   <?php
/**
 * This file is responsible for the blog section on front page.
 * @version:1.0
 */
?> 

<?php if ( true == get_theme_mod( 'blogonoff', true ) ) : ?>
 <!--#Our Latest Blog Area start -->
      <section id="blog" class="latest_blog_area">
         <div class="container">
            <div class="title wow fadeInUp pt_40">
               <h2><?php _e(get_theme_mod('homepage_blog_title', __('Our Latest Posts' , 'plumbing-lite'))); ?></h2>
            </div>
            <div class="row latest_blog">
    <?php
    
      $args = array( 
                'numberposts' => '3' 
               );

      $posts = wp_get_recent_posts( $args, OBJECT );
      if(isset($posts) && !empty($posts)){
      foreach( $posts as $post) : 
      
        // okay lets setup it as global post so we call wordpress default wrapper functions
        global $post;
        $post = get_post($post->ID);
        setup_postdata( $post);
 
        ?>

               <div class="col-md-4 col-sm-6 blog_content">

                  <?php if ( has_post_thumbnail() ) :
                         the_post_thumbnail();
                        endif; 
                     ?>
                  
                  <h4>
                    <a href="<?php the_permalink(); ?>" class="blog_heading"><?php the_title(); ?></a>
                  </h4>
                    <small><?php _e('By', 'plumbing-lite')?>  </small>
                      <a href="<?php the_permalink(); ?>" class="c-b"><?php  echo the_author(); ?></a>
                      <span>/</span>
                      <small><?php _e('ON', 'plumbing-lite')?> </small>
                    <?php echo get_the_date(); ?>

                  <div>
                    <?php the_excerpt() ;  ?>
                   </div>
                    
                  <a href="<?php the_permalink(); ?>" class="c-b"><?php _e('Read More', 'plumbing-lite')?></a> 
               </div>
            
            <?php endforeach; ?>
              <?php }?>

            </div>
         </div>
      </section>
      <!--#End Our Latest Blog Area -->

      <?php endif; 

      // Reset
      wp_reset_postdata();

      ?>


      <?php if ( true == get_theme_mod( 'partneronoff', true ) ) : ?>
      <!--#Our Partners Area -->
      <div class="our_partners_area pt-90">
         <div class="container">
            <div class="title wow fadeInUp pt_40">
               <h2><?php _e(get_theme_mod('homepage_partners_title', __('Our Partners' , 'plumbing-lite'))); ?></h2>
            </div>
            <!--#Our Partners images start -->
            <div class="partners">

              <?php if(is_active_sidebar('partners_widget_')) { ?>
              <?php dynamic_sidebar('partners_widget_'); ?>
            <?php } ?>



            </div>
               <!--#End Our Partners images -->
         </div>


         <div class="book_now_aera">
            <div class="container">
               <div class="row book_now">
                  <div class="col-md-9 booking_text">
                     <h4><?php _e(get_theme_mod('homepage_booknow_text1' , __('Book now.','plumbing-lite')));  ?></h4>
                     <p><?php _e(get_theme_mod('homepage_booknow_text2' , __('','plumbing-lite')));  ?></p>
                  </div>
                  <div class="col-md-3 p0 book_bottun">
                     <a href="#" class="button_all"><?php _e('Book now','plumbing-lite'); ?></a>
                  </div>
               </div>
            </div>
         </div>
      <!--#End Our Partners Area -->
      
      </div>

            <?php endif; ?>