<?php
 /*--------------------------------------------------------------------------------
  _   _                   _______   _                                     
 | \ | |                 |__   __| | |                                    
 |  \| |   __ _  __   __    | |    | |__     ___   _ __ ___     ___   ___ 
 |     |  / _  | \ \ / /    | |    | '_ \   / _ \ | '_ ` _ \   / _ \ / __|
 | |\  | | (_| |  \ V /     | |    | | | | |  __/ | | | | | | |  __/ \__ \
 |_| \_|  \__,_|   \_/      |_|    |_| |_|  \___| |_| |_| |_|  \___| |___/
                                                                          
                                                                          
----------------------------------------------------------------------------------*/ 

/**
 * The main theme functions file loads styles/scripts, allows some theme functionality and provides some helper functions.
 * @version:1.0
 */

 /*----------------------------------------------------------------
    The main theme functions file loads styles/scripts, allows some theme functionality and provides some helper functions.
    This theme only works in WordPress 4.2 or later.
 -----------------------------------------------------------------*/

if ( version_compare( $GLOBALS['wp_version'], '4.2', '<' ) ) {
    require get_template_directory() . '/inc/back-compat.php';
}

/*----------------------------------------------------------------
    Content Width
 -----------------------------------------------------------------*/
if ( ! isset( $content_width ) ) $content_width = 1140;


/*----------------------------------------------------------------
    Path Function.
 -----------------------------------------------------------------*/
function getAssetsPath($path) {
    return get_template_directory_uri().$path;
}

function image($name) {
    return getAssetsPath('assets/images/'.$name);
}


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 *
 * Create your own plumbing_setup function to override in a child theme.
 *
 * @version Plumbing 1.0
 */

function plumbing_lite_setup(){

    /*------------------------------
         * Register Navigation 
    --------------------------------*/

    register_nav_menus(array(
        'primary' => __('Primary Menu', 'plumbing-lite')
    ));

    /*---------------------------------------------------
         Theme Supports.
     ----------------------------------------------------*/

    //Add featured image support
    add_theme_support('post-thumbnails');

    //This feature enables plugins and themes to manage the document title tag.
    add_theme_support('title-tag');

    //This feature adds RSS feed links to HTML <head>.
    add_theme_support( 'automatic-feed-links' );
 

    add_theme_support('post-thumbnails');

    set_post_thumbnail_size( 400, 500, true );
        add_image_size( 'small-thumb', 200, 200);
    add_image_size( 'video-logo', 90, 90, true );
    add_image_size( 'medium-photo', 500, 500, true );
    add_image_size( 'single-photo', 140, 70, true );

        // Load Text Domain
    load_theme_textdomain('plumbing-lite'); 

}

add_action( 'after_setup_theme', 'plumbing_lite_setup' );


/*----------------------------------------------------------------
    TGMPA Activation.
 -----------------------------------------------------------------*/
require_once(get_template_directory() . '/inc/tgm_activation/tgm.php');



/*----------------------------------------------------------------
    Nav menu selection
 -----------------------------------------------------------------*/
    function plumbing_lite_nav_menus(){
         $nav_menus = array('none' => __('None', 'plumbing-lite'));
         $wp_nav_menu_list = get_terms('nav_menu', array('hide_empty' => true));

        foreach($wp_nav_menu_list as $menuItem) {
            $nav_menus[$menuItem->slug] = $menuItem->name;
        }
        return $nav_menus;
     }

	/*----------------------------
     Enquening Scripts and Styles
    -----------------------------*/
	function plumbing_lite_scripts() {
	
    global $wp_styles;
		

	/*---------------------------------------------------
    Comment Reply.
 ----------------------------------------------------*/ 

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );


        // Lets load CSS First
	
		// bootstrap
		wp_enqueue_style( 'plumbing-bootstrap-style', getAssetsPath('/assets/css/bootstrap.min.css') );

		// Loads our main stylesheet.
		wp_enqueue_style( 'plumbing-style', get_stylesheet_uri() );

        // Loads Google Font.
        wp_enqueue_style( 'google-oswald-font', 'https://fonts.googleapis.com/css?family=Oswald:400,700' );
        
        // OWL CAROUSEL
        wp_enqueue_style( 'plumbing-owl-style', getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.css'));

        //Load Font CSS
        wp_enqueue_style('plumbing-font-awesome.min', getAssetsPath('/assets/vendors/font-awesome/css/font-awesome.min.css"'));

        //Load animation css
         wp_enqueue_style('plumbing-animate-css', getAssetsPath('/assets/vendors/animate/animate.css'));

         /*----------------------------
           Load Javascript
            -----------------------------*/

        // Adds bootstrap JavaScript.
        wp_enqueue_script( 'plumbing-bootstrap-js',getAssetsPath('/assets/js/bootstrap.min.js'), array( 'jquery' ) , '','', true);

        // Adds carousel JavaScript.
        wp_enqueue_script( 'plumbing-owl-script',  getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.min.js'), '','', true);
            
		 // Adds animation JavaScript.
        wp_enqueue_script( 'plumbing-wow.min',  getAssetsPath('/assets/vendors/animate/wow.min.js'), '','', true);
           
          // Adds slider  JavaScript. 
        wp_enqueue_script( 'plumbing-cameraeasing',  getAssetsPath('/assets/vendors/camera-slider/jquery.easing.1.3.js'), '','', true);

        wp_enqueue_script( 'plumbing-cameraslider',  getAssetsPath('/assets/vendors/camera-slider/camera.min.js'), '','', true);
           
        // Adds isotope JavaScript.
        wp_enqueue_script( 'plumbing-imagesloaded',  getAssetsPath('/assets/vendors/isotope/imagesloaded.pkgd.min.js'), '','', true);
           
        wp_enqueue_script( 'plumbing-isotope',  getAssetsPath('/assets/vendors/isotope/isotope.pkgd.min.js'), '','', true);
        
        // Adds counter JavaScript.
        wp_enqueue_script( 'plumbing-counterup',  getAssetsPath('/assets/vendors/Counter-Up/jquery.counterup.min.js'), '','', true);
           
        wp_enqueue_script( 'plumbing-waypoint',  getAssetsPath('/assets/vendors/Counter-Up/waypoints.min.js'), '','', true);

        // Adds stellar JavaScript.
        wp_enqueue_script( 'plumbing-stellar',  getAssetsPath('/assets/vendors/stellar/jquery.stellar.js'), '','', true);

        // Custom JS
        wp_enqueue_script( 'plumbing-custom',  getAssetsPath('/assets/js/theme.min.js'), '','', true);
         // Custom JS
        wp_enqueue_script( 'plumbing-custom-slider',  getAssetsPath('/assets/js/slider.js'), '','', true);

	}
	
	add_action( 'wp_enqueue_scripts', 'plumbing_lite_scripts' );
 
 /*----------------------------
   Excerpt Word Length
    -----------------------------*/

 if(!function_exists( 'plumbing_lite_custom_excerpt_length' )) {

    //Customize excerpt word count
    function plumbing_lite_custom_excerpt_length() {
        return 25; //25 words
    }
    
    add_filter('excerpt_length', 'plumbing_lite_custom_excerpt_length');

}

if(!function_exists('plumbing_pro_WidgetsInit')) {

/*----------------------------
   Add our Widget Locations
    -----------------------------*/

function plumbing_lite_WidgetsInit() {
    register_sidebar( array(
        'name' => __( 'Sidebar', 'plumbing-lite' ),
        'id' => 'sidebar-1',
        'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
        ) );
    
        register_sidebar( array(
            'name' => __( 'Footer 1', 'plumbing-lite' ),
            'id' => 'sidebar-2',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 2', 'plumbing-lite' ),
            'id' => 'sidebar-3',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Footer 3', 'plumbing-lite' ),
            'id' => 'sidebar-4',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
          
        register_sidebar( array(
            'name' => __( 'Testimonials Section', 'plumbing-lite' ),
            'id' => 'testimonials_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Partners Section', 'plumbing-lite' ),
            'id' => 'partners_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        
  

        register_sidebar( array(
            'name' => __( 'Front Page Services Widget', 'plumbing-lite' ),
            'id' => 'services_widget_solutions',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        
        register_sidebar( array(
            'name' => __( ' Team Section', 'plumbing-lite' ),
            'id' => 'team_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
       
        register_sidebar( array(
            'name' => __( ' About Us Section', 'plumbing-lite' ),
            'id' => 'about_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'plumbing-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        

    }
add_action('widgets_init', 'plumbing_lite_WidgetsInit');

} 

/*----------------------------
    Including NavThemes Functions File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/navthemes-functions.php')) :
    include_once(dirname( __FILE__ ) . '/navthemes-functions.php');
 endif;   



/*----------------------------
    Including theme-options File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/theme-options.php')) :
    include_once(dirname( __FILE__ ) . '/theme-options.php');
 endif; 




    /*----------------------------
    Adds customizer css
    -----------------------------*/
if(!function_exists('navthemes_customizer_css')) {

    function navthemes_customizer_css() {
     // Loads our main stylesheet.
        wp_enqueue_style( 'customizer-css', get_template_directory_uri().'/customizer.css' );
    }
    
    add_action( 'customize_controls_print_styles', 'navthemes_customizer_css');

}


