<?php

/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Hiddentechies\Pixtron\Setup;

use Magento\Framework\Setup;

class Installer implements Setup\SampleData\InstallerInterface {

    /**
     * @var \Magento\CmsSampleData\Model\Page
     */
    private $page;

    /**
     * @var \Magento\CmsSampleData\Model\Block
     */
    private $block;

    /**
     * @param \Hiddentechies\Pixtron\Model\Page $page
     * @param \Hiddentechies\Pixtron\Model\Block $block
     */
    public function __construct(
    \Hiddentechies\Pixtron\Model\Page $page, 
            \Hiddentechies\Pixtron\Model\Block $block
    ) {
        $this->page = $page;
        $this->block = $block;
    }

    /**
     * {@inheritdoc}
     */
    public function install() {

        //$this->page->install(['Hiddentechies_Pixtron::fixtures/pages/pages.csv']);
        $this->page->install(
                [

                    'Hiddentechies_Pixtron::DemoPages/pages.csv',
                ]
        );
        $this->block->install(
                [

                    'Hiddentechies_Pixtron::DemoBlocks/blocks.csv',
                ]
        );
    }

}
