<script type="text/javascript">
    ybc_blog_report_url = '{$report_url}';
    ybc_blog_report_warning = '{l s='Do you want to report this comment?'}';
    ybc_blog_error = '{l s='There was a problem while submitting your report. Try again later'}';
</script>
<div class="ybc-blog-wrapper" itemscope itemType="http://schema.org/BlogPosting">
    {if $blog_post}
        <h1 class="page-heading product-listing"><span class="title_cat">{$blog_post.title}</span></h1>
        <div class="post-details">
            <div class="blog-extra"> 
                {if $show_date}
                    <div class="blog-extra-item be-date-block">
                        <span class="blog-posted-date">{date("F j Y, g:i a",strtotime($blog_post.datetime_added))}</span>
                    </div>
                {/if}
                {if $show_author && ($blog_post.firstname || $blog_post.lastname)}
                    <div class="blog-extra-item be-author-block">
                        <span class="blog-post-author">
                            <span class="post-author-label">{l s='Posted by: '}</span>
                            <span class="post-author-name">
                                {if !$blog_post.lastname}
                                    {ucfirst($blog_post.firstname)}
                                {else}
                                    {ucfirst($blog_post.firstname)} {ucfirst(substr($blog_post.lastname, 0, 1))}
                                {/if}
                            </span>
                        </span>
                    </div>
                {/if}
                {if $show_views}
                    <div class="blog-extra-item be-view-block">                        
                        <span class="be-view-span">{$blog_post.click_number} {if $blog_post.click_number != 1}{l s='Views'}{else}{l s='View'}{/if}</span>
                    </div>
                {/if} 
                {if $allow_like}
                    <div class="blog-extra-item be-like-block">
                        <span class="ybc-blog-like-span ybc-blog-like-span-{$blog_post.id_post} {if $likedPost}active{/if}"  data-id-post="{$blog_post.id_post}">                        
                            <span class="blog-post-total-like ben_{$blog_post.id_post}">{$blog_post.likes}</span>
                            <span class="blog-post-like-text blog-post-like-text-{$blog_post.id_post}">{l s='Liked'}</span>
                        </span>                        
                    </div>
                {/if}                 
                {if $allow_rating && $everage_rating}
                    <div class="blog-extra-item be-rating-block" itemprop="comment" itemscope itemtype="http://schema.org/UserComments">
                        <span>{l s='Rating: '}</span>
                        <div class="blog_rating_wrapper"   itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating"> 
                            <div class="ybc_blog_review">
                                {for $i = 1 to $everage_rating}
                                    <div class="star star_on"></div>
                                {/for}
                                {if $everage_rating<5}
                                    {for $i = $everage_rating + 1 to 5}
                                        <div class="star"></div>
                                    {/for}
                                {/if}
                            </div>
                            {if $total_review}
                                <span class="blog__rating_reviews">
                                     <span itemprop="reviewCount">{$total_review}</span>
                                    {if $total_review != 1}
                                        {l s='Reviews'}
                                    {else}
                                        {l s='Review'}
                                    {/if}
                                </span>
                            {/if}
                        </div>
                    </div>
                {/if}   
                {if $use_google_share || $use_facebook_share || $use_twitter_share}
                    <div class="blog-extra-item blog-extra-facebook-share">
                        {if $use_facebook_share}
                            <div class="ybc_blog_button_share">
                                <div id="fb-root"></div>
                                {literal}
                                    <script>(function(d, s, id) {
                                      var js, fjs = d.getElementsByTagName(s)[0];
                                      if (d.getElementById(id)) return;
                                      js = d.createElement(s); js.id = id;
                                      js.src = "//connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v2.3";
                                      fjs.parentNode.insertBefore(js, fjs);
                                    }(document, 'script', 'facebook-jssdk'));</script>
                                {/literal}
                                <div class="fb-like" data-href="{$post_url}" data-layout="button_count" data-action="like" data-show-faces="false" data-share="true"></div>
                            </div>
                        {/if}
                        {if $use_google_share}
                            <div class="ybc_blog_button_share">
                                <script src="https://apis.google.com/js/platform.js" async defer></script>                   
                                <div class="g-plusone" data-size="medium" data-href="{$post_url}"></div>
                            </div>
                        {/if}
                        {if $use_twitter_share}
                            <div class="ybc_blog_button_share">
                                <a href="https://twitter.com/share" class="twitter-share-button" data-url="{$post_url}">{l s='Tweet'}</a>
                                {literal}
                                    <script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
                                {/literal}
                            </div>
                        {/if}
                    </div>   
                {/if}                         
                {if $show_tags && $blog_post.tags}
                    <div class="blog-extra-item be-tag-block">
                        {assign var='ik' value=0}
                        {assign var='totalTag' value=count($blog_post.tags)}
                        <span class="be-label"> {if $totalTag > 1}{l s='Tags'}{else}{l s='Tag'}{/if}: </span>
                        <div class="be-tags">
                            {foreach from=$blog_post.tags item='tag'}
                                {assign var='ik' value=$ik+1}                                        
                                <a href="{$tag.link}">{ucfirst($tag.tag)}</a>{if $ik < $totalTag}, {/if}
                            {/foreach}
                        </div>
                    </div>
                {/if}
                {if $show_categories && $blog_post.categories}
                    <div class="blog-extra-item be-categories-block">
                        {assign var='ik' value=0}
                        {assign var='totalCat' value=count($blog_post.categories)}
                        <span class="be-label">{l s='Posted in'}: </span>
                        <div class="be-categories">
                            {foreach from=$blog_post.categories item='cat'}
                                {assign var='ik' value=$ik+1}                                        
                                <a href="{$cat.link}">{ucfirst($cat.title)}</a>{if $ik < $totalCat}, {/if}
                            {/foreach}
                        </div>
                    </div>
                {/if}
            </div>
            <div class="post-wrapper">
                {if $blog_post.image}
                    {if $enable_slideshow}<a href="{$blog_post.image}" class="prettyPhoto">{/if}<img title="{$blog_post.title}" src="{$blog_post.image}" alt="{$blog_post.title}" />{if $enable_slideshow}</a>{/if}
                    {if $enable_slideshow}
                        <script type="text/javascript">    
                            prettySkin = '{$prettySkin}';
                            prettyAutoPlay = false;
                            {literal}
                                $(document).ready(function(){            
                                    $("a[class^='prettyPhoto']").prettyPhoto({animation_speed:'normal',theme:prettySkin,slideshow:3000, autoplay_slideshow: prettyAutoPlay, social_tools: '',deeplinking: false});
                                });
                            {/literal}
                        </script>
                    {/if}
                {/if}
                <div class="blog-content">
                    {if $blog_post.description}
                        {$blog_post.description}
                    {else}
                        {$blog_post.short_description}
                    {/if}
                </div>
            </div>
            
            {if $display_related_products && $blog_post.products}
                <h4 class="title_block"><span class="title_cat">{if count($blog_post.products) > 1}{l s='Related products: '}{else}{l s='Related product: '}{/if}</span></h4>
                <ul class="blog-product-list product_list grid row">
                    {foreach from=$blog_post.products item='product'}
                        <li class="ajax_block_product col-xs-12 col-sm-4 col-md-3">
                            <div class="product-container">
                                <div class="left-block">
                                    <a href="{$product.link}"><img src="{$product.img_url}" alt="{$product.name}" /></a>
                                </div>
                                <div class="right-block">
                                    <h5><a href="{$product.link}">{$product.name}</a></h5>
                                    <div class="blog-product-extra content_price">
                                        {if $product.price!=$product.old_price}
                                            <span class="bp-price-old old-price"><span class="bp-price-old-label">{l s='Old price: '}</span><span class="bp-price-old-display">{$product.old_price}</span></span>
                                        {/if}
                                        <span class="bp-price price special-price"><span class="bp-price-label">{l s='Price: '}</span><span class="bp-price-display">{$product.price}</span></span>
                                        {if $product.price!=$product.old_price}
                                            <span class="bp-percent price-percent-reduction"><span class="bp-percent-label">{l s='Discount: '}</span><span class="bp-percent-display">-{$product.discount_percent}</span></span>
                                            <span class="bp-save"><span class="bp-save-label">{l s='Save up: '}</span><span class="bp-save-display">-{$product.discount_amount}</span></span>
                                        {/if}
                                    </div>
                                    {if $product.short_description}
                                        <div class="blog-product-desc">
                                            {$product.short_description|strip_tags:'UTF-8'|truncate:80:'...'}
                                        </div>
                                    {/if}
                                </div>
                            </div>
                        </li>
                    {/foreach}
                </ul>
            {/if}
            {if $allowComments}
                <h4 class="title_block"><span class="title_cat">{l s='Leave a comment'}</span></h4>
                {if $hasLoggedIn}
                    <form action="{$blogCommentAction}" method="post">
                        <div class="blog-comment-row">
                            <label for="bc-subject">{l s='Subject: '}</label>
                            <input class="form-control" name="subject" id="bc-subject" type="text" value="{if isset($subject)}{$subject}{/if}" />
                        </div>
                        {if $allow_rating}                            
                            <div class="blog-comment-row">
                                <label>{'Rate this post: '}</label>
                                    <div class="blog_rating_box">
                                        {if $default_rating > 0 && $default_rating <5}
                                            <input id="blog_rating" type="hidden" name="rating" value="{$default_rating}" />
                                            {for $i = 1 to $default_rating}
                                                <div rel="{$i}" class="star star_on blog_rating_star blog_rating_star_{$i}"></div>
                                            {/for}
                                            {for $i = $default_rating + 1 to 5}
                                                <div rel="{$i}" class="star blog_rating_star blog_rating_star_{$i}"></div>
                                            {/for}
                                        {else}
                                            <input id="blog_rating" type="hidden" name="rating" value="5" />
                                            {for $i = 1 to 5}
                                                <div rel="{$i}" class="star star_on blog_rating_star blog_rating_star_{$i}"></div>
                                            {/for}
                                        {/if}
                                    </div>
                            </div>
                        {/if}
                        <div class="blog-comment-row">
                            <label for="bc-comment">{l s='Comment: '}</label>
                            <textarea   class="form-control" name="comment" id="bc-comment">{if isset($comment)}{$comment}{/if}</textarea>
                        </div>
                        {if $use_capcha}
                            <div class="blog-comment-row">
                                <label for="bc-capcha">{l s='Security code: '}</label>
                                <span class="bc-capcha-wrapper">
                                    <img rel="{$blog_random_code}" id="ybc-blog-capcha-img" src="{$capcha_image}" /><span id="ybc-blog-capcha-refesh" title="{l s='Refresh code'}">{*l s='Refresh code'*}</span><br />
                                    <input class="form-control" name="capcha_code" type="text" id="bc-capcha" value="" />
                                </span>
                            </div>
                        {/if}
                        <div class="blog-comment-row">
                            <input class="button" type="submit" value="{l s='Submit'}" name="bcsubmit" />
                        </div>                       
                        {if $blog_errors && is_array($blog_errors)}
                            <ul class="alert alert-danger ybc_alert-danger">
                                {foreach from=$blog_errors item='error'}
                                    <li>{$error}</li>
                                {/foreach}
                            </ul>
                        {/if}
                        {if $blog_success}
                            <p class="alert alert-success ybc_alert-success">{$blog_success}</p>
                        {/if}
                    </form>
                {else}
                    <p class="alert alert-warning">{l s='Log in to post comments'}</p>
                {/if}
                {if count($comments)}
                    {if count($comments)>1}
                        <h4><span class="title_cat">{l s='Comments: '}</span></h4>
                    {else}
                        <h4><span class="title_cat">{l s='Comment: '}</span></h4>
                    {/if}
                    <ul class="blog-comments-list">
                        {foreach from=$comments item='comment'}
                            <li class="blog-comment-line">
                                <h5 class="comment-subject">{$comment.subject}</h5>
                                {if $comment.firstname || $comment.lastname}<span class="comment-by">{l s='By: '}{ucfirst($comment.firstname)} {ucfirst($comment.lastname)}</span>{/if}
                                <span class="comment-time">{date('F j Y, g:i a',strtotime($comment.datetime_added))}</span>
                                {if $allow_rating && $comment.rating > 0}
                                    <div class="comment-rating"  itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">
                                        <span>{l s='Rating: '}</span>
                                        <div class="ybc_blog_review">
                                            {for $i = 1 to $comment.rating}
                                                <div class="star star_on"></div>
                                            {/for}
                                            {if $comment.rating<5}
                                                {for $i = $comment.rating + 1 to 5}
                                                    <div class="star"></div>
                                                {/for}
                                            {/if}                                        
                                        </div>
                                    </div>
                                {/if} 
                                {if $comment.comment}<p class="comment-content">{$comment.comment}</p>{/if}
                                {if $allow_report_comment && $hasLoggedIn}
                                    {if !($reportedComments && is_array($reportedComments) && in_array($comment.id_comment, $reportedComments))}
                                        <span class="ybc-block-comment-report comment-report-{$comment.id_comment}" rel="{$comment.id_comment}">{l s='Report abuse'}</span>
                                    {/if}
                                {/if}
                                {if $comment.reply}<p class="comment-reply">
                                    {if $comment.elastname || $comment.efirstname}
                                        <span class="ybc-blog-replied-by">
                                            {l s='Replied by: '}
                                            <span class="ybc-blog-replied-by-name">
                                                {if !$comment.elastname}
                                                    {ucfirst($comment.efirstname)}
                                                {else}
                                                    {ucfirst($comment.efirstname)} {ucfirst(substr($comment.elastname, 0, 1))}
                                                {/if}
                                            </span>
                                        </span>
                                    {/if}
                                    <span class="ybc-blog-reply-content">
                                        {$comment.reply}
                                    </span></p>
                                {/if}
                            </li>
                        {/foreach}
                    </ul>
                {/if}
            {/if}
        </div>
    {else}
        <p class="warning">{l s='No posts found'}</p>
    {/if}
</div>