<div class="ybc-blog-wrapper ybc-blog-wrapper-blog-list">
    {if $is_main_page}
        {hook h='blogSlidersBlock'}
    {/if}
    {if $blog_category}
        <div class="blog-category">
            <h1 class="page-heading product-listing"><span class="title_cat">{$blog_category.title}</span></h1>
            {if $blog_category.image}
                <img src="{$blog_dir}images/category/{$blog_category.image}" alt="{$blog_category.title}" title="{$blog_category.title}" />
            {/if}
            {if $blog_category.description}
                <div class="blog-category-desc">
                    {$blog_category.description}
                </div>
            {/if}
        </div>
    {elseif $blog_latest}
       <h1 class="page-heading product-listing"><span class="title_cat">{l s='Latest posts'}</span></h1>
    {elseif $blog_tag}
        <h1 class="page-heading product-listing"><span class="title_cat">{l s='Tag: '}"{ucfirst($blog_tag)}"</span></h1>
    {elseif $blog_search}
        <h1 class="page-heading product-listing"><span class="title_cat">{l s='Search: '}"{ucfirst($blog_search)}"</span></h1>
    {elseif $show_featured_post}
        <h1 class="page-heading product-listing"><span class="title_cat">{l s='Featured posts'}</span></h1>
    {/if}
    {if $show_featured_post || $blog_category || $blog_tag || $blog_search}
        {if isset($blog_posts)}
            <ul class="ybc-blog-list row">
                {foreach from=$blog_posts item='post'}            
                    <li>
                        <h2><a href="{$post.link}">{$post.title}</a></h2>  
                        <div class="blog-extra">
                            {if $show_date}
                                <div class="blog-extra-item be-date-block">
                                    <span class="blog-posted-date">{date("F j Y, g:i a",strtotime($post.datetime_added))}</span>
                                </div>
                            {/if}  
                            {if $show_views}
                                <div class="blog-extra-item be-view-block">                        
                                    <span class="be-view-span">{$post.click_number} {if $post.click_number !=1}{l s='Views'}{else}{l s='View'}{/if}</span>
                                </div>
                            {/if} 
                            {if $allow_like}
                                <span class="ybc-blog-like-span ybc-blog-like-span-{$post.id_post} {if $post.liked}active{/if}"  data-id-post="{$post.id_post}">                        
                                    <span class="blog-post-total-like ben_{$post.id_post}">{$post.likes}</span>
                                    <span class="blog-post-like-text blog-post-like-text-{$post.id_post}">{l s='Liked'}</span>
                                </span> 
                            {/if}                     
                            {if $allow_rating && isset($post.everage_rating) && $post.everage_rating}
                                {assign var='everage_rating' value=$post.everage_rating}
                                <div class="blog-extra-item be-rating-block">
                                    <span>{l s='Rating: '}</span>
                                    <div class="blog_rating_wrapper">
                                        <div class="ybc_blog_review">
                                            {for $i = 1 to $everage_rating}
                                                <div class="star star_on"></div>
                                            {/for}
                                            {if $everage_rating<5}
                                                {for $i = $everage_rating + 1 to 5}
                                                    <div class="star"></div>
                                                {/for}
                                            {/if}
                                        </div>
                                        {if $post.total_review}
                                            <span class="blog__rating_reviews">
                                                 {$post.total_review}
                                                {if $post.total_review != 1}
                                                    {l s='Reviews'}
                                                {else}
                                                    {l s='Review'}
                                                {/if}
                                            </span>
                                        {/if}
                                    </div>
                                </div>
                            {/if}  
                        </div>
                        <div class="post-wrapper">
                            {if $post.thumb}
                                <a href="{$post.link}"><img title="{$post.title}" src="{$post.thumb}" alt="{$post.title}" /></a>
                            {/if}
                            <div class="blog-content">
                                {if $post.short_description}
                                    <p>{$post.short_description|strip_tags:'UTF-8'|truncate:500:'...'}</p>
                                {elseif $post.description}
                                    <p>{$post.description|strip_tags:'UTF-8'|truncate:500:'...'}</p>
                                {/if}
                                <a class="read_more" href="{$post.link}">{l s='Read more ...'}</a>
                            </div>
                        </div>
                    </li>
                {/foreach}
            </ul>
            {if $blog_paggination}
                <div class="blog-paggination">
                    {$blog_paggination}
                </div>
            {/if}
        {else}
            <p>{l s='No posts found'}</p>
        {/if}
    {/if}
    {*if $is_main_page}
        {hook h='blogGalleryBlock'}
    {/if*}
</div>