<?php
/**
* The template part for displaying a message that posts cannot be found
*
* @package ThemeHunk
* @subpackage Oneline Lite
* @since Oneline Lite 1.0
*/
?>
<div class="no-results not-found">
	<div class="page-nothing">
		<h1><?php _e( 'Nothing Found !', 'oneline-lite' ); ?></h1>
		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
		<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'oneline-lite' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
		<?php elseif ( is_search() ) : ?>
		<p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'oneline-lite' ); ?></p>
		<?php get_search_form(); ?>
		<?php else : ?>
		<p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'oneline-lite' ); ?></p>
		<?php get_search_form(); ?>
		<?php endif; ?>
	</div>
	<!-- .page-content -->
	</div><!-- .no-results -->