<div class="page-title">
	<div class="grid-main">
		<header class="entry-header">

		{* ********************************************************* *}
		{* for 404, SEARCH and WOOCOMMERCE                           *}
		{* ********************************************************* *}

		{if $wp->is404 or $wp->isSearch or $wp->isWoocommerce()}

			<div class="entry-title simple-title">
				<div class="entry-title-wrap">

					<h1>
						{if $wp->is404} 			{__ "This is somewhat embarrassing, isn't it?"} {/if}
						{if $wp->isSearch} 			{__ 'Search Results for: %s'|printf: $wp->searchQuery} {/if}
						{if $wp->isWoocommerce()}	{? woocommerce_page_title()} {/if}
					</h1>

				</div><!-- /.entry-title-wrap -->
			</div><!-- /.entry-title -->

		{* ********************************************************* *}
		{* for PAGES, POST DETAIL, IMAGE DETAIL and PORTFOLIO DETAIL *}
		{* for LOOP pages only                                       *}
		{* ********************************************************* *}

		{elseif $wp->isPage or $wp->isAttachment or $wp->isSingular(post) or $wp->isSingular(portfolio-item) or $wp->isSingular(event) or $wp->isSingular(job-offer)}

			{loop as $post}

				{* ********************* *}
				{* for PAGE ONLY         *}
				{* ********************* *}

				{if $wp->isPage}

					<div class="entry-title standard-title">
						<div class="entry-title-wrap">

							<h1>{!$post->title}</h1>
							{includePart parts/breadcrumbs}

							<div class="entry-meta">
								{capture $editLinkLabel}<span class="edit-link">{!__ 'Edit'}</span>{/capture}
								{!$post->editLink($editLinkLabel)}
							</div><!-- /.entry-meta -->

						</div><!-- /.entry-title-wrap -->
					</div><!-- /.entry-title -->

					<div class="entry-thumbnail">
						{if $post->hasImage}
							<a href="{$post->imageUrl}" class="thumb-link">
								<span class="entry-thumbnail-icon">
									<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}">
								</span>
							</a>
						{/if}
					</div>
				{/if}

				{* ***************************************** *}
				{* for POST DETAIL and PORTFOLIO DETAIL ONLY *}
				{* ***************************************** *}

				{if $wp->isSingular(post) or $wp->isSingular(portfolio-item) or $wp->isSingular(event) or $wp->isSingular(job-offer)}

					<div class="entry-title post-title">

						<div class="entry-title-wrap">

							{if $wp->isSingular(event)}
								{var $meta = $post->meta(event-data)}
								<h1>{!$post->title}</h1>
								{includePart parts/breadcrumbs}
							{elseif $wp->isSingular(job-offer)}
								{var $meta = $post->meta(offer-data)}
								<h1>{!$post->title}</h1>
								{includePart parts/breadcrumbs}
							{else}
								<h1>{!$post->title}</h1>
								{includePart parts/breadcrumbs}
							{/if}

							<div class="entry-meta">
								{capture $editLinkLabel}<span class="edit-link">{!__ 'Edit'}</span>{/capture}
								{!$post->editLink($editLinkLabel)}
							</div><!-- /.entry-meta -->

						</div><!-- /.entry-title-wrap -->
					</div><!-- /.entry-title -->

{* Custom latte: delete portfolio thumbnail from title
					{if $wp->isSingular(portfolio-item)}
						{var $meta = $post->meta('portfolio-item')}
						{if $meta->type == 'video'}
							<div class="entry-thumbnail">
								<div class="entry-thumbnail-wrap">
									<iframe src="{videoEmbedUrl $meta->videoLink}" width="1000" height="500"></iframe>
								</div>
							</div>
						{else}
							<div class="entry-thumbnail">
								{if $post->hasImage}
									<div class="entry-thumbnail-wrap">
								<a href="{$post->imageUrl}" class="thumb-link">
									<span class="entry-thumbnail-icon">
										<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}" alt="{!$post->title}">
									</span>
								</a>
									</div>
								{/if}
							</div>
						{/if}
					{else}
 					<div class="entry-thumbnail">
						{if $post->hasImage}
							<div class="entry-thumbnail-wrap">
								<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}" alt="{!$post->title}">
							</div>
						{/if}
					</div>
					{/if}
*}
				{/if}

				{* ********************* *}
				{* for IMAGE DETAIL ONLY *}
				{* ********************* *}

				{if $wp->isAttachment}

					<div class="entry-title attach-title">
						<div class="entry-title-wrap">

							<h1>{!$post->title}</h1>

							{if $post->attachment->isImage or $post->attachment->isVideo or $post->attachment->isAudio}
							{capture $dateI18n}{$post->date('c')|dateI18n}{/capture}
							<div class="entry-data">
								{!__ '
									<span class="meta-prep meta-prep-entry-date">Published</span>
									<time class="meta-date" datetime="%1$s">%2$s</time>
									at
									<a href="%3$s" title="Link to full-size image">%4$s &times; %5$s</a> in
									<a href="%6$s" title="Return to %7$s" rel="gallery">%7$s</a>.
								'|printf:
										$post->date(c),
										$dateI18n,
										$post->attachment->url,
										$post->attachment->width,
										$post->attachment->height,
										$post->parent->permalink,
										$post->parent->title
								}
							</div><!-- .entry-data -->
							{/if}

							<div class="entry-meta">
								{capture $editLinkLabel}<span class="edit-link">{!__ 'Edit'}</span>{/capture}
								{!$post->editLink($editLinkLabel)}
							</div><!-- /.entry-meta -->

							{if $post->attachment->isImage}
							<nav id="image-navigation" class="navigation" role="navigation">
								{capture $prev}{!__ '&larr; Previous'}{/capture}
								{capture $next}{!__ 'Next &rarr;'}{/capture}

								<span class="previous-image">{prevImageLink false, $prev}</span>
								<span class="next-image">{nextImageLink false, $next}</span>
							</nav><!-- #image-navigation -->
							{/if}

						</div><!-- /.entry-title-wrap -->
					</div><!-- /.entry-title -->

				{/if}

			{/loop}

		{* ********************************************************* *}
		{* for BLOG PAGE ONLY                                        *}
		{* ********************************************************* *}

		{elseif $wp->isBlog and $blog}

			<div class="entry-title blog-title">
				<div class="entry-title-wrap">

					<h1>{!$blog->title}</h1>
					{includePart parts/breadcrumbs}

					<div class="entry-meta">
						{capture $editLinkLabel}<span class="edit-link">{!__ 'Edit'}</span>{/capture}
						{!$blog->editLink($editLinkLabel)}
					</div><!-- /.entry-meta -->

				</div><!-- /.entry-title-wrap -->
			</div><!-- /.entry-title -->

			<div class="entry-thumbnail">
				{if $blog->hasImage}
					<a href="{$post->imageUrl}" class="thumb-link">
						<span class="entry-thumbnail-icon">
							<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}">
						</span>
					</a>
				{/if}
			</div>

		{* ********************************************************* *}
		{* for CATEGORY, ARCHIVE, TAG and AUTHOR                     *}
		{* ********************************************************* *}

		{elseif $wp->isCategory or $wp->isArchive or $wp->isTag or $wp->isAuthor or $wp->isTax(portfolios) or $wp->isTax(events)}

			<div class="entry-title archive-title">
				<div class="entry-title-wrap">
					<h1>					

						{if $wp->isCategory}		{__ 'Category Archives: %s'|printf: $category->title}

						{elseif $wp->isTax(portfolios)} {__ 'Category Archives: %s'|printf: $taxonomyTerm->title}
						{elseif $wp->isTax(events)} {__ 'Category Archives: %s'|printf: $taxonomyTerm->title}

						{elseif $wp->isTag}			{__ 'Tag Archives:'} <span>{$tag->title}</span>

						{elseif $wp->isPostTypeArchive}	{__ 'Archives: %s'|printf: $archive->title}

						{elseif $wp->isAuthor}			{capture $authorTitle}
														<span class="vcard">
															<a class="url fn n" href="{$author->postsUrl}" title="{$author}" rel="me">{$author}</a>
														</span>
													{/capture}
													{!__ 'All posts by %s'|printf: $authorTitle}

						{elseif $wp->isArchive}
													{capture $archiveDate}{$archive->date('c')}{/capture}
													{if $archive->isDay}		{__ 'Daily Archives: %s'|printf:''}{$archiveDate|dateI18n}
													{elseif $archive->isMonth}	{capture $monthFormat}{_x 'F Y', 'monthly archives date format'}{/capture}
																				{__ 'Monthly Archives: %s'|printf: ''}{$archiveDate|dateI18n: $monthFormat}
													{elseif $archive->isYear}	{capture $yearFormat}{_x 'Y',  'yearly archives date format'}{/capture}
																				{__ 'Yearly Archives: %s'|printf: ''}{$archiveDate|dateI18n: $yearFormat}
													{/if}

						{/if}
					</h1>

					{if $wp->isCategory and $category->description}
						<div class="entry-data">{!$category->description}</div>
					{/if}

					{if $wp->isTag and $tag->description}
						<div class="entry-data">{!$tag->description}</div>
					{/if}

				</div><!-- /.entry-title-wrap -->
			</div><!-- /.entry-title -->

		{/if}

		{if $el->option(description)}
			<div class="page-description">
				{!$el->option(description)}
			</div>
		{/if}

		</header><!-- /.entry-header -->
	</div>
</div>
