<?php

/*
 * AIT WordPress Theme Framework
 *
 * Copyright (c) 2013, Affinity Information Technology, s.r.o. (http://ait-themes.com)
 */

/**
 * Anchor Menu Element
 */
class AitAnchorMenuElement extends AitElement
{
	public function getMenu()
	{
		$elements = AitWpLatte::getCustomElementsOptions();
		$anchors = array();

		if($this->option('enableCustomMenu') == 1){
			if(is_array($this->option('customMenuBefore')) && count($this->option('customMenuBefore')) > 0){
				foreach($this->option('customMenuBefore') as $menuitem){
					$anchors[] = array('title' => $menuitem['title'], 'parent' => $menuitem['parent'], 'description' => $menuitem['description'], 'href' => $menuitem['href']); 
				}
			}
		}

		foreach($elements->sortable as $el){
			if($el->getId() == 'anchor'){
				$anchors[] = array('id' => $el->getOption()->id, 'title' => $el->getOption()->title, 'parent' => $el->getOption()->parent); 
			}
		}

		if($this->option('enableCustomMenu') == 1){
			if(is_array($this->option('customMenuAfter')) && count($this->option('customMenuAfter')) > 0){
				foreach($this->option('customMenuAfter') as $menuitem){
					$anchors[] = array('title' => $menuitem['title'], 'parent' => $menuitem['parent'], 'description' => $menuitem['description'], 'href' => $menuitem['href']); 
				}
			}
		}

		return $anchors;
	}
}
