<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Acme Themes
 * @subpackage Mercantile
 */
$mercantile_customizer_all_values = mercantile_get_theme_options();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="content-wrapper">
		<header class="entry-header">
			<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			if ( 'post' === get_post_type() ) : ?>
				<div class="entry-meta">
					<?php mercantile_posted_on(); ?>
				</div><!-- .entry-meta -->
			<?php endif; ?>
		</header><!-- .entry-header -->
		<?php
		if ( $mercantile_customizer_all_values['mercantile-blog-archive-layout'] == 'full-image' && has_post_thumbnail() ) {
			?>
			<!--post thumbnal options-->
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'full' );?>
			</a>
			<?php
		}
		?>
		<div class="entry-summary entry-content">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		<footer class="entry-footer">
			<?php mercantile_entry_footer(); ?>
		</footer><!-- .entry-footer -->
	</div>
</article><!-- #post-## -->