-- phpMyAdmin SQL Dump
-- version 3.5.1
-- http://www.phpmyadmin.net
--
-- Хост: 127.0.0.1
-- Время создания: Фев 23 2015 г., 14:24
-- Версия сервера: 5.5.25
-- Версия PHP: 5.3.13


--
-- База данных: `master2`
--

-- --------------------------------------------------------

--
-- Структура таблицы `actions`
--

DROP TABLE IF EXISTS `actions`;
CREATE TABLE IF NOT EXISTS `actions` (
  `aid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique actions ID.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The object that that action acts on (node, user, comment, system or custom types.)',
  `callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback function that executes when the action runs.',
  `parameters` longblob NOT NULL COMMENT 'Parameters to be passed to the callback function.',
  `label` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Label of the action.',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores action information.';

--
-- Дамп данных таблицы `actions`
--

INSERT INTO `actions` (`aid`, `type`, `callback`, `parameters`, `label`) VALUES
('2', 'system', 'system_goto_action', 0x613a313a7b733a333a2275726c223b733a373a223c66726f6e743e223b7d, 'Redirect to URL'),
('comment_publish_action', 'comment', 'comment_publish_action', '', 'Publish comment'),
('comment_save_action', 'comment', 'comment_save_action', '', 'Save comment'),
('comment_unpublish_action', 'comment', 'comment_unpublish_action', '', 'Unpublish comment'),
('node_make_sticky_action', 'node', 'node_make_sticky_action', '', 'Make content sticky'),
('node_make_unsticky_action', 'node', 'node_make_unsticky_action', '', 'Make content unsticky'),
('node_promote_action', 'node', 'node_promote_action', '', 'Promote content to front page'),
('node_publish_action', 'node', 'node_publish_action', '', 'Publish content'),
('node_save_action', 'node', 'node_save_action', '', 'Save content'),
('node_unpromote_action', 'node', 'node_unpromote_action', '', 'Remove content from front page'),
('node_unpublish_action', 'node', 'node_unpublish_action', '', 'Unpublish content'),
('system_block_ip_action', 'user', 'system_block_ip_action', '', 'Ban IP address of current user'),
('user_block_user_action', 'user', 'user_block_user_action', '', 'Block current user');

-- --------------------------------------------------------

--
-- Структура таблицы `advanced_help_index`
--

DROP TABLE IF EXISTS `advanced_help_index`;
CREATE TABLE IF NOT EXISTS `advanced_help_index` (
  `sid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary key to give to the search engine for this topic.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The module that owns this topic.',
  `topic` varchar(255) NOT NULL DEFAULT '' COMMENT 'The topic id.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The language this search index relates to.',
  PRIMARY KEY (`sid`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores search index correlations for advanced help topics.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `authmap`
--

DROP TABLE IF EXISTS `authmap`;
CREATE TABLE IF NOT EXISTS `authmap` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique authmap ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'User’s users.uid.',
  `authname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Unique authentication name.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'Module which is controlling the authentication.',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `authname` (`authname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores distributed authentication mapping.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `batch`
--

DROP TABLE IF EXISTS `batch`;
CREATE TABLE IF NOT EXISTS `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores details about batches (processes that run in...';

--
-- Дамп данных таблицы `batch`
--

INSERT INTO `batch` (`bid`, `token`, `timestamp`, `batch`) VALUES
(3, '8DZb50sHAdUehF-xaLnvdByZ9PlE4rYjrSYCu1bV438', 1411114613, 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);

-- --------------------------------------------------------

--
-- Структура таблицы `block`
--

DROP TABLE IF EXISTS `block`;
CREATE TABLE IF NOT EXISTS `block` (
  `bid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique block ID.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The module from which the block originates; for example, ’user’ for the Who’s Online block, and ’block’ for any custom blocks.',
  `delta` varchar(32) NOT NULL DEFAULT '0' COMMENT 'Unique ID for block within a module.',
  `theme` varchar(64) NOT NULL DEFAULT '' COMMENT 'The theme under which the block settings apply.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Block enabled status. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Block weight within region.',
  `region` varchar(64) NOT NULL DEFAULT '' COMMENT 'Theme region within which the block is set.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)',
  `visibility` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)',
  `pages` text NOT NULL COMMENT 'Contents of the "Pages" block; contains either a list of paths on which to include/exclude the block or PHP code, depending on "visibility" setting.',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT 'Custom title for the block. (Empty string will use block default title, <none> will remove the title, text will cause block to use specified title.)',
  `cache` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Binary flag to indicate block cache mode. (-2: Custom cache, -1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See DRUPAL_CACHE_* constants in ../includes/common.inc for more detailed information.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `tmd` (`theme`,`module`,`delta`),
  KEY `list` (`theme`,`status`,`region`,`weight`,`module`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores block settings, such as region and visibility...' AUTO_INCREMENT=800 ;

--
-- Дамп данных таблицы `block`
--

INSERT INTO `block` (`bid`, `module`, `delta`, `theme`, `status`, `weight`, `region`, `custom`, `visibility`, `pages`, `title`, `cache`) VALUES
(1, 'system', 'main', 'bartik', 1, 0, 'content', 0, 0, '<front>', '', -1),
(2, 'search', 'form', 'bartik', 1, -1, 'sidebar_first', 0, 0, '', '', -1),
(3, 'node', 'recent', 'seven', 1, 10, 'dashboard_main', 0, 0, '', '', -1),
(4, 'user', 'login', 'bartik', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(5, 'system', 'navigation', 'bartik', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(6, 'system', 'powered-by', 'bartik', 1, 10, 'footer', 0, 0, '', '', -1),
(7, 'system', 'help', 'bartik', 1, 0, 'help', 0, 0, '', '', -1),
(8, 'system', 'main', 'seven', 1, 0, 'content', 0, 0, '<front>', '', -1),
(9, 'system', 'help', 'seven', 1, 0, 'help', 0, 0, '', '', -1),
(10, 'user', 'login', 'seven', 1, 10, 'content', 0, 0, '', '', -1),
(11, 'user', 'new', 'seven', 1, 0, 'dashboard_sidebar', 0, 0, '', '', -1),
(12, 'search', 'form', 'seven', 1, -10, 'dashboard_sidebar', 0, 0, '', '', -1),
(13, 'comment', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(14, 'node', 'syndicate', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(15, 'node', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(16, 'shortcut', 'shortcuts', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(17, 'system', 'management', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(18, 'system', 'user-menu', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(19, 'system', 'main-menu', 'bartik', 0, 0, '-1', 0, 0, '', '<none>', -1),
(20, 'user', 'new', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(21, 'user', 'online', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(22, 'comment', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', 1),
(23, 'node', 'syndicate', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(24, 'shortcut', 'shortcuts', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(25, 'system', 'powered-by', 'seven', 0, 10, '-1', 0, 0, '', '', -1),
(26, 'system', 'navigation', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(27, 'system', 'management', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(28, 'system', 'user-menu', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(29, 'system', 'main-menu', 'seven', 0, 0, '-1', 0, 0, '', '<none>', -1),
(30, 'user', 'online', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', -1),
(31, 'comment', 'recent', 'fpixel', 0, 0, '-1', 0, 0, '', '', 1),
(32, 'node', 'recent', 'fpixel', 0, 0, '-1', 0, 0, '', '', 1),
(33, 'node', 'syndicate', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(34, 'search', 'form', 'fpixel', 0, -1, '-1', 0, 0, '', '', -1),
(35, 'shortcut', 'shortcuts', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(36, 'system', 'help', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(37, 'system', 'main', 'fpixel', 1, 0, 'content', 0, 0, '<front>', '', -1),
(38, 'system', 'main-menu', 'fpixel', 0, 0, '-1', 0, 0, '', '<none>', -1),
(39, 'system', 'management', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(40, 'system', 'navigation', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(41, 'system', 'powered-by', 'fpixel', 0, -8, '-1', 0, 0, '', '', -1),
(42, 'system', 'user-menu', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(43, 'user', 'login', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(44, 'user', 'new', 'fpixel', 0, 0, '-1', 0, 0, '', '', 1),
(45, 'user', 'online', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(62, 'comment', 'recent', 'corporateclean', 0, 0, '-1', 0, 0, '', '', 1),
(63, 'node', 'recent', 'corporateclean', 0, 0, '-1', 0, 0, '', '', 1),
(64, 'node', 'syndicate', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(65, 'search', 'form', 'corporateclean', 0, -1, '-1', 0, 0, '', '', -1),
(66, 'shortcut', 'shortcuts', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(67, 'system', 'help', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(68, 'system', 'main', 'corporateclean', 1, 0, 'content', 0, 0, '<front>', '', -1),
(69, 'system', 'main-menu', 'corporateclean', 0, 0, '-1', 0, 0, '', '<none>', -1),
(70, 'system', 'management', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(71, 'system', 'navigation', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(72, 'system', 'powered-by', 'corporateclean', 0, -8, '-1', 0, 0, '', '', -1),
(73, 'system', 'user-menu', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(74, 'user', 'login', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(75, 'user', 'new', 'corporateclean', 0, 0, '-1', 0, 0, '', '', 1),
(76, 'user', 'online', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(79, 'views', 'form_powerfull-block_1', 'fpixel', 0, 0, '-1', 0, 0, '<front>', '', -1),
(80, 'views', 'form_powerfull-block_1', 'seven', 0, 0, '', 0, 0, '<front>', '', 1),
(81, 'views', 'test-block_1', 'fpixel', 1, 0, 'galery_portfolio', 0, 1, '<front>', 'testblock', -1),
(82, 'views', 'test-block_1', 'seven', 0, 0, '', 0, 1, '<front>', 'testblock', -1),
(85, 'views', 'image_gallery-block_1', 'fpixel', 1, 0, 'galery_portfolio', 0, 1, '<front>', 'qweqwe', -1),
(86, 'views', 'image_gallery-block_1', 'seven', 0, 0, '', 0, 0, '<front>', '', 1),
(87, 'cck_blocks', 'field_img', 'fpixel', 1, 0, 'galery_portfolio', 0, 1, '<front>', '<none>', -1),
(88, 'cck_blocks', 'field_imge', 'fpixel', 1, 0, 'galery_portfolio', 0, 1, '<front>', '<none>', -1),
(89, 'cck_blocks', 'field_img', 'seven', 0, 0, '', 0, 0, '<front>', '', 1),
(90, 'cck_blocks', 'field_imge', 'seven', 0, 0, '', 0, 0, '<front>', '', 1),
(121, 'widgets', 's_socialmedia_profile-default', 'fpixel', 1, 0, 'social_icons', 0, 0, '', '', -1),
(122, 'widgets', 's_socialmedia_share-default', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(123, 'widgets', 's_socialmedia_profile-urls', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(124, 'widgets', 's_socialmedia_profile-buttons', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(125, 'widgets', 's_addthis-share', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(126, 'widgets', 's_facebook-like-box', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(127, 'widgets', 's_twitter-profile-widget', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(128, 'widgets', 's_socialmedia_profile-default', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(129, 'widgets', 's_socialmedia_share-default', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(130, 'widgets', 's_socialmedia_profile-urls', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(131, 'widgets', 's_socialmedia_profile-buttons', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(132, 'widgets', 's_addthis-share', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(133, 'widgets', 's_facebook-like-box', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(134, 'widgets', 's_twitter-profile-widget', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(150, 'widgets', 's_socialmedia_profile-default', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(151, 'widgets', 's_socialmedia_share-default', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(152, 'widgets', 's_socialmedia_profile-urls', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(153, 'widgets', 's_socialmedia_profile-buttons', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(154, 'widgets', 's_addthis-share', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(155, 'widgets', 's_facebook-like-box', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(156, 'widgets', 's_twitter-profile-widget', 'corporateclean', 0, 0, '-1', 0, 0, '', '', -1),
(160, 'views', 'slideshow_top_view-block', 'fpixel', 0, 0, '-1', 0, 0, '', '', -1),
(170, 'cck_blocks', 'field_img', 'garland', 1, 0, 'sidebar_first', 0, 1, '<front>', '<none>', -1),
(171, 'cck_blocks', 'field_imge', 'garland', 1, 0, 'sidebar_first', 0, 1, '<front>', '<none>', -1),
(172, 'comment', 'recent', 'garland', 0, 0, '-1', 0, 0, '', '', 1),
(186, 'node', 'recent', 'garland', 0, 0, '-1', 0, 0, '', '', 1),
(187, 'node', 'syndicate', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(188, 'search', 'form', 'garland', 0, -1, '-1', 0, 0, '', '', -1),
(189, 'shortcut', 'shortcuts', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(190, 'system', 'help', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(191, 'system', 'main', 'garland', 1, 0, 'content', 0, 0, '<front>', '', -1),
(192, 'system', 'main-menu', 'garland', 0, 0, '-1', 0, 0, '', '<none>', -1),
(193, 'system', 'management', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(194, 'system', 'navigation', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(195, 'system', 'powered-by', 'garland', 0, -8, '-1', 0, 0, '', '', -1),
(196, 'system', 'user-menu', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(197, 'user', 'login', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(198, 'user', 'new', 'garland', 0, 0, '-1', 0, 0, '', '', 1),
(199, 'user', 'online', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(200, 'views', 'form_powerfull-block_1', 'garland', 0, 0, '-1', 0, 0, '<front>', '', -1),
(201, 'views', 'image_gallery-block_1', 'garland', 1, 0, 'sidebar_first', 0, 1, '<front>', 'qweqwe', -1),
(202, 'views', 'slideshow_top_view-block', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(203, 'views', 'test-block_1', 'garland', 1, 0, 'sidebar_first', 0, 1, '<front>', 'testblock', -1),
(204, 'widgets', 's_addthis-share', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(205, 'widgets', 's_facebook-like-box', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(206, 'widgets', 's_socialmedia_profile-buttons', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(207, 'widgets', 's_socialmedia_profile-default', 'garland', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(208, 'widgets', 's_socialmedia_profile-urls', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(209, 'widgets', 's_socialmedia_share-default', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(210, 'widgets', 's_twitter-profile-widget', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(244, 'block', '11', 'fpixel', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(245, 'block', '11', 'garland', 0, 0, '-1', 0, 1, 'icons', 'Icons ', -1),
(246, 'block', '11', 'seven', 0, 0, '-1', 0, 1, 'icons', 'Icons ', -1),
(247, 'imageblock', '16', 'fpixel', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(248, 'imageblock', '16', 'garland', 0, 0, '-1', 0, 1, 'quickstart', 'QuickStart Package', -1),
(249, 'imageblock', '16', 'seven', 0, 0, '-1', 0, 1, 'quickstart', 'QuickStart Package', -1),
(250, 'imageblock', '17', 'fpixel', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(251, 'imageblock', '17', 'garland', 0, 0, '-1', 0, 1, 'responsive', 'Responsive Layout', -1),
(252, 'imageblock', '17', 'seven', 0, 0, '-1', 0, 1, 'responsive', 'Responsive Layout', -1),
(253, 'block', '12', 'fpixel', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(254, 'block', '12', 'garland', 0, 0, '-1', 0, 1, 'typography', 'Typography', -1),
(255, 'block', '12', 'seven', 0, 0, '-1', 0, 1, 'typography', 'Typography', -1),
(256, 'blog', 'recent', 'fpixel', 0, 0, '-1', 0, 0, '', '', 1),
(257, 'blog', 'recent', 'garland', 0, 0, '-1', 0, 0, '', '', 1),
(258, 'blog', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', 1),
(259, 'block', '13', 'fpixel', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(260, 'block', '13', 'garland', 0, 0, '-1', 0, 1, 'buttons', 'Button', -1),
(261, 'block', '14', 'fpixel', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(262, 'block', '14', 'garland', 0, 0, '-1', 0, 1, 'bages', ' Labels and badges', -1),
(263, 'block', '15', 'fpixel', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(264, 'block', '15', 'garland', 0, 0, '-1', 0, 1, 'accordion', 'Tabs and accordion', -1),
(265, 'block', '16', 'fpixel', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(266, 'block', '16', 'garland', 0, 0, '-1', 0, 1, 'notifications', 'Notifications', -1),
(267, 'block', '17', 'fpixel', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(268, 'block', '17', 'garland', 0, 0, '-1', 0, 1, 'tooltips', 'Tooltips', -1),
(269, 'block', '18', 'fpixel', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(270, 'block', '18', 'garland', 0, 0, '', 0, 1, 'bars', 'Progress bare', -1),
(271, 'views', 'location-block', 'fpixel', 1, 0, 'content', 0, 1, 'contact', '', -1),
(272, 'views', 'location-block', 'garland', 0, 0, '', 0, 1, 'contact', '', 1),
(275, 'block', '11', 'test', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(276, 'block', '12', 'test', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(277, 'block', '13', 'test', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(278, 'block', '14', 'test', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(279, 'block', '15', 'test', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(280, 'block', '16', 'test', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(281, 'block', '17', 'test', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(282, 'block', '18', 'test', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(289, 'blog', 'recent', 'test', 0, 0, '-1', 0, 0, '', '', 1),
(290, 'cck_blocks', 'field_img', 'test', 1, 0, 'sidebar_first', 0, 1, '<front>', '<none>', -1),
(291, 'cck_blocks', 'field_imge', 'test', 1, 0, 'sidebar_first', 0, 1, '<front>', '<none>', -1),
(292, 'comment', 'recent', 'test', 0, 0, '-1', 0, 0, '', '', 1),
(300, 'imageblock', '16', 'test', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(301, 'imageblock', '17', 'test', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(314, 'node', 'recent', 'test', 0, 0, '-1', 0, 0, '', '', 1),
(315, 'node', 'syndicate', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(316, 'search', 'form', 'test', 0, -1, '-1', 0, 0, '', '', -1),
(317, 'shortcut', 'shortcuts', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(318, 'system', 'help', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(319, 'system', 'main', 'test', 1, 0, 'content', 0, 0, '<front>', '', -1),
(320, 'system', 'main-menu', 'test', 1, 0, 'sidebar_first', 0, 0, '', '<none>', -1),
(321, 'system', 'management', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(322, 'system', 'navigation', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(323, 'system', 'powered-by', 'test', 0, -8, '-1', 0, 0, '', '', -1),
(324, 'system', 'user-menu', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(325, 'user', 'login', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(326, 'user', 'new', 'test', 0, 0, '-1', 0, 0, '', '', 1),
(327, 'user', 'online', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(328, 'views', 'form_powerfull-block_1', 'test', 0, 0, '-1', 0, 0, '<front>', '', -1),
(329, 'views', 'image_gallery-block_1', 'test', 1, 0, 'sidebar_first', 0, 1, '<front>', 'qweqwe', -1),
(330, 'views', 'location-block', 'test', 1, 0, 'content', 0, 1, 'contact', '', -1),
(331, 'views', 'slideshow_top_view-block', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(332, 'views', 'test-block_1', 'test', 1, 0, 'sidebar_first', 0, 1, '<front>', 'testblock', -1),
(333, 'widgets', 's_addthis-share', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(334, 'widgets', 's_facebook-like-box', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(335, 'widgets', 's_socialmedia_profile-buttons', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(336, 'widgets', 's_socialmedia_profile-default', 'test', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(337, 'widgets', 's_socialmedia_profile-urls', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(338, 'widgets', 's_socialmedia_share-default', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(339, 'widgets', 's_twitter-profile-widget', 'test', 0, 0, '-1', 0, 0, '', '', -1),
(342, 'block', '11', 'tb_test', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(343, 'block', '12', 'tb_test', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(344, 'block', '13', 'tb_test', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(345, 'block', '14', 'tb_test', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(346, 'block', '15', 'tb_test', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(347, 'block', '16', 'tb_test', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(348, 'block', '17', 'tb_test', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(349, 'block', '18', 'tb_test', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(356, 'blog', 'recent', 'tb_test', 0, 0, '-1', 0, 0, '', '', 1),
(357, 'cck_blocks', 'field_img', 'tb_test', 1, 0, 'sidebar_first', 0, 1, '<front>', '<none>', -1),
(358, 'cck_blocks', 'field_imge', 'tb_test', 1, 0, 'sidebar_first', 0, 1, '<front>', '<none>', -1),
(359, 'comment', 'recent', 'tb_test', 0, 0, '-1', 0, 0, '', '', 1),
(367, 'imageblock', '16', 'tb_test', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(368, 'imageblock', '17', 'tb_test', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(381, 'node', 'recent', 'tb_test', 0, 0, '-1', 0, 0, '', '', 1),
(382, 'node', 'syndicate', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(383, 'search', 'form', 'tb_test', 0, -1, '-1', 0, 0, '', '', -1),
(384, 'shortcut', 'shortcuts', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(385, 'system', 'help', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(386, 'system', 'main', 'tb_test', 1, 0, 'content', 0, 0, '<front>', '', -1),
(387, 'system', 'main-menu', 'tb_test', 1, 0, 'sidebar_first', 0, 0, '', '<none>', -1),
(388, 'system', 'management', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(389, 'system', 'navigation', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(390, 'system', 'powered-by', 'tb_test', 0, -8, '-1', 0, 0, '', '', -1),
(391, 'system', 'user-menu', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(392, 'user', 'login', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(393, 'user', 'new', 'tb_test', 0, 0, '-1', 0, 0, '', '', 1),
(394, 'user', 'online', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(395, 'views', 'form_powerfull-block_1', 'tb_test', 0, 0, '-1', 0, 0, '<front>', '', -1),
(396, 'views', 'image_gallery-block_1', 'tb_test', 1, 0, 'sidebar_first', 0, 1, '<front>', 'qweqwe', -1),
(397, 'views', 'location-block', 'tb_test', 1, 0, 'content', 0, 1, 'contact', '', -1),
(398, 'views', 'slideshow_top_view-block', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(399, 'views', 'test-block_1', 'tb_test', 1, 0, 'sidebar_first', 0, 1, '<front>', 'testblock', -1),
(400, 'widgets', 's_addthis-share', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(401, 'widgets', 's_facebook-like-box', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(402, 'widgets', 's_socialmedia_profile-buttons', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(403, 'widgets', 's_socialmedia_profile-default', 'tb_test', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(404, 'widgets', 's_socialmedia_profile-urls', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(405, 'widgets', 's_socialmedia_share-default', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(406, 'widgets', 's_twitter-profile-widget', 'tb_test', 0, 0, '-1', 0, 0, '', '', -1),
(411, 'on_the_web', '0', 'fpixel', 1, 0, 'social_icons', 0, 0, '', '', 1),
(412, 'on_the_web', '0', 'garland', 0, 0, '-1', 0, 0, '', '', 1),
(413, 'block', '14', 'seven', 0, 0, '-1', 0, 1, 'bages', ' Labels and badges', -1),
(414, 'block', '13', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(416, 'block', '16', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(417, 'block', '18', 'seven', 0, 0, '-1', 0, 1, 'bars', 'Progress bare', -1),
(418, 'block', '15', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(419, 'block', '17', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(423, 'block', '11', 'infographics', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(424, 'block', '12', 'infographics', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(425, 'block', '13', 'infographics', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(426, 'block', '14', 'infographics', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(427, 'block', '15', 'infographics', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(428, 'block', '16', 'infographics', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(429, 'block', '17', 'infographics', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(430, 'block', '18', 'infographics', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(435, 'blog', 'recent', 'infographics', 0, 0, '-1', 0, 0, '', '', 1),
(436, 'cck_blocks', 'field_img', 'infographics', 1, 0, 'slider_bottom', 0, 1, '<front>', '<none>', -1),
(437, 'cck_blocks', 'field_imge', 'infographics', 1, 0, 'slider_bottom', 0, 1, '<front>', '<none>', -1),
(438, 'comment', 'recent', 'infographics', 0, 0, '-1', 0, 0, '', '', 1),
(446, 'imageblock', '16', 'infographics', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(447, 'imageblock', '17', 'infographics', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(461, 'node', 'recent', 'infographics', 0, 0, '-1', 0, 0, '', '', 1),
(462, 'node', 'syndicate', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(463, 'on_the_web', '0', 'infographics', 0, 0, '-1', 0, 0, '', '', 1),
(464, 'search', 'form', 'infographics', 0, -1, '-1', 0, 0, '', '', -1),
(465, 'shortcut', 'shortcuts', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(466, 'system', 'help', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(467, 'system', 'main', 'infographics', 1, 0, 'content', 0, 0, '<front>', '', -1),
(468, 'system', 'main-menu', 'infographics', 0, 0, '-1', 0, 0, '', '<none>', -1),
(469, 'system', 'management', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(470, 'system', 'navigation', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(471, 'system', 'powered-by', 'infographics', 0, -8, '-1', 0, 0, '', '', -1),
(472, 'system', 'user-menu', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(473, 'user', 'login', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(474, 'user', 'new', 'infographics', 0, 0, '-1', 0, 0, '', '', 1),
(475, 'user', 'online', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(476, 'views', 'form_powerfull-block_1', 'infographics', 0, 0, '-1', 0, 0, '<front>', '', -1),
(477, 'views', 'image_gallery-block_1', 'infographics', 1, 0, 'slider_bottom', 0, 1, '<front>', 'qweqwe', -1),
(478, 'views', 'location-block', 'infographics', 0, 0, '', 0, 1, 'contact', '', 1),
(479, 'views', 'slideshow_top_view-block', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(480, 'views', 'test-block_1', 'infographics', 1, 0, 'slider_bottom', 0, 1, '<front>', 'testblock', -1),
(481, 'widgets', 's_addthis-share', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(482, 'widgets', 's_facebook-like-box', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(483, 'widgets', 's_socialmedia_profile-buttons', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(484, 'widgets', 's_socialmedia_profile-default', 'infographics', 1, 0, 'slider_bottom', 0, 0, '', '', -1),
(485, 'widgets', 's_socialmedia_profile-urls', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(486, 'widgets', 's_socialmedia_share-default', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(487, 'widgets', 's_twitter-profile-widget', 'infographics', 0, 0, '-1', 0, 0, '', '', -1),
(490, 'views', 'home_page_gallery-block', 'infographics', 1, 0, 'home_page_gallery', 0, 1, '<front>', '', -1),
(491, 'views', 'home_page_gallery-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(492, 'views', 'slideshow_top-block', 'infographics', 1, 0, 'slider_top', 0, 1, '<front>', '', -1),
(493, 'views', 'slideshow_bottom-block', 'infographics', 1, 0, 'slider_bottom', 0, 1, '<front>', '', -1),
(496, 'views', 'slideshow_top-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(497, 'views', 'slideshow_bottom-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(498, 'views', 'skills-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(499, 'views', 'skills-block', 'infographics', 1, 0, 'skills', 0, 1, '<front>', '', -1),
(500, 'views', 'price_table-block', 'infographics', 1, 0, 'price_table', 0, 1, '<front>', '', -1),
(501, 'views', 'price_table-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(502, 'block', '11', 'photographer', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(503, 'block', '12', 'photographer', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(504, 'block', '13', 'photographer', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(505, 'block', '14', 'photographer', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(506, 'block', '15', 'photographer', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(507, 'block', '16', 'photographer', 0, 0, '-1', 0, 1, 'notifications', 'Notifications', -1),
(508, 'block', '17', 'photographer', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(509, 'block', '18', 'photographer', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(513, 'blog', 'recent', 'photographer', 0, 0, '-1', 0, 0, '', '', 1),
(514, 'cck_blocks', 'field_img', 'photographer', 1, 0, 'slider_bottom', 0, 1, '<front>', '<none>', -1),
(515, 'cck_blocks', 'field_imge', 'photographer', 1, 0, 'slider_bottom', 0, 1, '<front>', '<none>', -1),
(516, 'comment', 'recent', 'photographer', 0, 0, '-1', 0, 0, '', '', 1),
(517, 'imageblock', '16', 'photographer', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(518, 'imageblock', '17', 'photographer', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(519, 'node', 'recent', 'photographer', 0, 0, '-1', 0, 0, '', '', 1),
(520, 'node', 'syndicate', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(521, 'on_the_web', '0', 'photographer', 0, 0, '-1', 0, 0, '', '', 1),
(522, 'search', 'form', 'photographer', 0, -1, '-1', 0, 0, '', '', -1),
(523, 'shortcut', 'shortcuts', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(524, 'system', 'help', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(525, 'system', 'main', 'photographer', 1, 0, 'content', 0, 0, '<front>', '', -1),
(526, 'system', 'main-menu', 'photographer', 0, 0, '-1', 0, 0, '', '<none>', -1),
(527, 'system', 'management', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(528, 'system', 'navigation', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(529, 'system', 'powered-by', 'photographer', 0, -8, '-1', 0, 0, '', '', -1),
(530, 'system', 'user-menu', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(531, 'user', 'login', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(532, 'user', 'new', 'photographer', 0, 0, '-1', 0, 0, '', '', 1),
(533, 'user', 'online', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(534, 'views', 'form_powerfull-block_1', 'photographer', 0, 0, '-1', 0, 0, '<front>', '', -1),
(535, 'views', 'home_page_gallery-block', 'photographer', 1, 0, 'home_page_gallery', 0, 1, '<front>', '', -1),
(536, 'views', 'image_gallery-block_1', 'photographer', 1, 0, 'slider_bottom', 0, 1, '<front>', 'qweqwe', -1),
(537, 'views', 'location-block', 'photographer', 0, 0, '', 0, 1, 'contact', '', 1),
(538, 'views', 'price_table-block', 'photographer', 0, 0, '-1', 0, 1, '<front>', '', -1),
(539, 'views', 'skills-block', 'photographer', 0, 0, '-1', 0, 1, '<front>', '', -1),
(540, 'views', 'slideshow_bottom-block', 'photographer', 1, 0, 'slider_bottom', 0, 1, '<front>', '', -1),
(541, 'views', 'slideshow_top-block', 'photographer', 0, 0, '-1', 0, 1, '<front>', '', -1),
(542, 'views', 'slideshow_top_view-block', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(543, 'views', 'test-block_1', 'photographer', 1, 0, 'slider_bottom', 0, 1, '<front>', 'testblock', -1),
(544, 'widgets', 's_addthis-share', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(545, 'widgets', 's_facebook-like-box', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(546, 'widgets', 's_socialmedia_profile-buttons', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(547, 'widgets', 's_socialmedia_profile-default', 'photographer', 1, 0, 'slider_bottom', 0, 0, '', '', -1),
(548, 'widgets', 's_socialmedia_profile-urls', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(549, 'widgets', 's_socialmedia_share-default', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(550, 'widgets', 's_twitter-profile-widget', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(551, 'views', 'services-block', 'photographer', 1, 0, 'services', 0, 1, '<front>', '', -1),
(552, 'views', 'services-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(553, 'views', 'who_we_are-block', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(554, 'views', 'who_we_are-block', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(555, 'menu', 'menu-menu-secondary-menu', 'photographer', 0, 0, '-1', 0, 0, '', '', -1),
(556, 'menu', 'menu-menu-secondary-menu', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(557, 'views', 'contact_form-block', 'photographer', 1, 0, 'contact_form', 0, 0, '', '', -1),
(558, 'contact_form_blocks', '0', 'garland', 0, 0, '-1', 0, 1, '<front>', '', 1),
(559, 'contact_form_blocks', '0', 'photographer', 0, 0, '-1', 0, 1, '<front>', '', 1),
(562, 'block', '11', 'serenity', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(563, 'block', '12', 'serenity', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(564, 'block', '13', 'serenity', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(565, 'block', '14', 'serenity', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(566, 'block', '15', 'serenity', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(567, 'block', '16', 'serenity', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(568, 'block', '17', 'serenity', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(569, 'block', '18', 'serenity', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(574, 'blog', 'recent', 'serenity', 0, 0, '-1', 0, 0, '', '', 1),
(575, 'cck_blocks', 'field_img', 'serenity', 1, 0, 'home_page_gallery', 0, 1, '<front>', '<none>', -1),
(576, 'cck_blocks', 'field_imge', 'serenity', 1, 0, 'home_page_gallery', 0, 1, '<front>', '<none>', -1),
(577, 'comment', 'recent', 'serenity', 0, 0, '-1', 0, 0, '', '', 1),
(578, 'contact_form_blocks', '0', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', 1),
(579, 'imageblock', '16', 'serenity', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(580, 'imageblock', '17', 'serenity', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(581, 'menu', 'menu-menu-secondary-menu', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(582, 'node', 'recent', 'serenity', 0, 0, '-1', 0, 0, '', '', 1),
(583, 'node', 'syndicate', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(584, 'on_the_web', '0', 'serenity', 0, 0, '-1', 0, 0, '', '', 1),
(585, 'search', 'form', 'serenity', 0, -1, '-1', 0, 0, '', '', -1),
(586, 'shortcut', 'shortcuts', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(587, 'system', 'help', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(588, 'system', 'main', 'serenity', 1, 0, 'content', 0, 0, '<front>', '', -1),
(589, 'system', 'main-menu', 'serenity', 0, 0, '-1', 0, 0, '', '<none>', -1),
(590, 'system', 'management', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(591, 'system', 'navigation', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(592, 'system', 'powered-by', 'serenity', 0, -8, '-1', 0, 0, '', '', -1),
(593, 'system', 'user-menu', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(594, 'user', 'login', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(595, 'user', 'new', 'serenity', 0, 0, '-1', 0, 0, '', '', 1),
(596, 'user', 'online', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(597, 'views', 'form_powerfull-block_1', 'serenity', 0, 0, '-1', 0, 0, '<front>', '', -1),
(598, 'views', 'home_page_gallery-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(599, 'views', 'image_gallery-block_1', 'serenity', 1, 0, 'home_page_gallery', 0, 1, '<front>', 'qweqwe', -1),
(600, 'views', 'location-block', 'serenity', 0, 0, '', 0, 1, 'contact', '', 1),
(601, 'views', 'price_table-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(602, 'views', 'services-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(603, 'views', 'skills-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(604, 'views', 'slideshow_bottom-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(605, 'views', 'slideshow_top-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(606, 'views', 'slideshow_top_view-block', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(607, 'views', 'test-block_1', 'serenity', 1, 0, 'home_page_gallery', 0, 1, '<front>', 'testblock', -1),
(608, 'views', 'who_we_are-block', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(609, 'widgets', 's_addthis-share', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(610, 'widgets', 's_facebook-like-box', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(611, 'widgets', 's_socialmedia_profile-buttons', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(612, 'widgets', 's_socialmedia_profile-default', 'serenity', 1, 0, 'home_page_gallery', 0, 0, '', '', -1),
(613, 'widgets', 's_socialmedia_profile-urls', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(614, 'widgets', 's_socialmedia_share-default', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(615, 'widgets', 's_twitter-profile-widget', 'serenity', 0, 0, '-1', 0, 0, '', '', -1),
(616, 'views', 'comments_recent-block', 'garland', 0, 0, '-1', 0, 1, 'blog', '', -1),
(617, 'views', 'comments_recent-block', 'serenity', 1, 0, 'recent_comments', 0, 1, 'blog', '', -1),
(618, 'views', 'features-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(619, 'views', 'statistics-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(620, 'views', 'statistics-block', 'garland', 0, 0, '-1', 0, 0, '<front>', '', -1),
(621, 'views', 'features-block', 'garland', 0, 0, '-1', 0, 0, '<front>', '', -1),
(622, 'views', 'featured_in-block', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(623, 'views', 'featured_in-block', 'garland', 0, 0, '-1', 0, 0, '<front>', '', -1),
(624, 'views', 'category_blog-block', 'serenity', 1, 0, 'categories_blog', 0, 1, 'blog', '', -1),
(625, 'views', 'recent_blog-block', 'serenity', 1, 0, 'recent_blog', 0, 1, 'blog', '', -1),
(626, 'views', 'category_blog-block', 'garland', 0, 0, '-1', 0, 0, 'blog', '', -1),
(627, 'views', 'recent_blog-block', 'garland', 0, 0, '-1', 0, 0, 'blog', '', -1),
(628, 'block', '21', 'garland', 0, 0, '-1', 0, 1, '<front>', 'CONTACT INFO', -1),
(629, 'block', '21', 'serenity', 1, 0, 'contact_info', 0, 1, '<front>', 'CONTACT INFO', -1),
(630, 'block', '22', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(631, 'block', '22', 'serenity', 0, 0, '-1', 0, 1, '<front>', '', -1),
(634, 'menu', 'menu-top-menu', 'serenity', 1, 0, 'top_menu', 0, 0, '', '<none>', -1),
(635, 'menu', 'menu-top-menu', 'garland', 0, 0, '-1', 0, 0, '', '', -1),
(638, 'block', '25', 'garland', 0, 0, '-1', 0, 1, '<front>', 'Find us on map', -1),
(639, 'block', '25', 'serenity', 0, 0, '-1', 0, 1, '<front>', 'Find us on map', -1),
(662, 'block', '37', 'garland', 0, 0, '-1', 0, 0, '', 'Sidebar Right', -1),
(663, 'block', '37', 'serenity', 0, 0, '-1', 0, 0, '', 'Sidebar Right', -1),
(664, 'views', 'location-block', 'ordasofttemplate', 0, 0, '', 0, 1, 'contact', '', 1),
(665, 'system', 'powered-by', 'ordasofttemplate', 0, -8, '-1', 0, 0, '', '', -1),
(666, 'search', 'form', 'ordasofttemplate', 0, -1, '-1', 0, 0, '', '', -1),
(667, 'block', '22', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(668, 'block', '25', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', 'Find us on map', -1),
(669, 'block', '37', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', 'Sidebar Right', -1),
(670, 'blog', 'recent', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', 1),
(671, 'comment', 'recent', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', 1),
(672, 'contact_form_blocks', '0', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', 1),
(673, 'menu', 'menu-menu-secondary-menu', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(674, 'node', 'recent', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', 1),
(675, 'node', 'syndicate', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(676, 'on_the_web', '0', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', 1),
(677, 'shortcut', 'shortcuts', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(678, 'system', 'help', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(679, 'system', 'main-menu', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '<none>', -1),
(680, 'system', 'management', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(681, 'system', 'navigation', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(682, 'system', 'user-menu', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(683, 'user', 'login', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(684, 'user', 'new', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', 1),
(685, 'user', 'online', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(686, 'views', 'form_powerfull-block_1', 'ordasofttemplate', 0, 0, '-1', 0, 0, '<front>', '', -1),
(687, 'views', 'home_page_gallery-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(688, 'views', 'price_table-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(689, 'views', 'services-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(690, 'views', 'skills-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(691, 'views', 'slideshow_bottom-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(692, 'views', 'slideshow_top-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(693, 'views', 'slideshow_top_view-block', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(694, 'views', 'who_we_are-block', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(695, 'views', 'features-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(696, 'views', 'statistics-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(697, 'views', 'featured_in-block', 'ordasofttemplate', 0, 0, '-1', 0, 1, '<front>', '', -1),
(698, 'widgets', 's_addthis-share', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(699, 'widgets', 's_facebook-like-box', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(700, 'widgets', 's_socialmedia_profile-buttons', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(701, 'widgets', 's_socialmedia_profile-urls', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(702, 'widgets', 's_socialmedia_share-default', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(703, 'widgets', 's_twitter-profile-widget', 'ordasofttemplate', 0, 0, '-1', 0, 0, '', '', -1),
(704, 'views', 'category_blog-block', 'ordasofttemplate', 1, 0, 'categories_blog', 0, 1, 'blog', '', -1),
(705, 'block', '21', 'ordasofttemplate', 1, 0, 'contact_info', 0, 1, '<front>', 'CONTACT INFO', -1),
(706, 'block', '11', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(707, 'block', '12', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(708, 'block', '13', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(709, 'block', '14', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(710, 'block', '15', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(711, 'block', '16', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(712, 'block', '17', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(713, 'block', '18', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(714, 'imageblock', '16', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(715, 'imageblock', '17', 'ordasofttemplate', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(716, 'system', 'main', 'ordasofttemplate', 1, 0, 'content', 0, 0, '<front>', '', -1),
(717, 'cck_blocks', 'field_img', 'ordasofttemplate', 1, 0, 'home_page_gallery', 0, 1, '<front>', '<none>', -1),
(718, 'cck_blocks', 'field_imge', 'ordasofttemplate', 1, 0, 'home_page_gallery', 0, 1, '<front>', '<none>', -1),
(719, 'views', 'image_gallery-block_1', 'ordasofttemplate', 1, 0, 'home_page_gallery', 0, 1, '<front>', 'qweqwe', -1),
(720, 'views', 'test-block_1', 'ordasofttemplate', 1, 0, 'home_page_gallery', 0, 1, '<front>', 'testblock', -1),
(721, 'widgets', 's_socialmedia_profile-default', 'ordasofttemplate', 1, 0, 'home_page_gallery', 0, 0, '', '', -1),
(722, 'views', 'recent_blog-block', 'ordasofttemplate', 1, 0, 'recent_blog', 0, 1, 'blog', '', -1),
(723, 'views', 'comments_recent-block', 'ordasofttemplate', 1, 0, 'recent_comments', 0, 1, 'blog', '', -1),
(726, 'menu', 'menu-top-menu', 'ordasofttemplate', 1, 0, 'top_menu', 0, 0, '', '<none>', -1),
(727, 'block', '11', 'master', 1, 0, 'content', 0, 1, 'icons', 'Icons ', -1),
(728, 'block', '12', 'master', 1, 0, 'content', 0, 1, 'typography', 'Typography', -1),
(729, 'block', '13', 'master', 1, 0, 'content', 0, 1, 'buttons', 'Button', -1),
(730, 'block', '14', 'master', 1, 0, 'content', 0, 1, 'bages', ' Labels and badges', -1),
(731, 'block', '15', 'master', 1, 0, 'content', 0, 1, 'accordion', 'Tabs and accordion', -1),
(732, 'block', '16', 'master', 1, 0, 'content', 0, 1, 'notifications', 'Notifications', -1),
(733, 'block', '17', 'master', 1, 0, 'content', 0, 1, 'tooltips', 'Tooltips', -1),
(734, 'block', '18', 'master', 1, 0, 'content', 0, 1, 'bars', 'Progress bare', -1),
(735, 'block', '21', 'master', 1, 0, 'bottom_line2', 0, 1, '<front>', 'CONTACT INFO', -1),
(736, 'block', '22', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(737, 'block', '25', 'master', 1, 0, 'contentbottom1', 0, 1, '<front>', 'Find us on map', -1),
(738, 'block', '37', 'master', 0, 0, '-1', 0, 0, '', 'Sidebar Right', -1),
(739, 'blog', 'recent', 'master', 0, 0, '-1', 0, 0, '', '', 1),
(740, 'cck_blocks', 'field_img', 'master', 1, 0, 'top_menu', 0, 1, '<front>', '<none>', -1),
(741, 'cck_blocks', 'field_imge', 'master', 1, 0, 'top_menu', 0, 1, '<front>', '<none>', -1),
(742, 'comment', 'recent', 'master', 0, 0, '-1', 0, 0, '', '', 1),
(743, 'contact_form_blocks', '0', 'master', 1, 0, 'bottom_line1', 0, 1, '<front>', '', 1),
(744, 'imageblock', '16', 'master', 1, 0, 'content', 0, 1, 'quickstart', 'QuickStart Package', -1),
(745, 'imageblock', '17', 'master', 1, 0, 'content', 0, 1, 'responsive', 'Responsive Layout', -1),
(746, 'menu', 'menu-menu-secondary-menu', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(747, 'menu', 'menu-top-menu', 'master', 1, 0, 'top_menu', 0, 0, '', '<none>', -1),
(748, 'node', 'recent', 'master', 0, 0, '-1', 0, 0, '', '', 1),
(749, 'node', 'syndicate', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(750, 'on_the_web', '0', 'master', 0, 0, '-1', 0, 0, '', '', 1),
(751, 'search', 'form', 'master', 0, -1, '-1', 0, 0, '', '', -1),
(752, 'shortcut', 'shortcuts', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(753, 'system', 'help', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(754, 'system', 'main', 'master', 1, 0, 'content', 0, 0, '<front>', '', -1),
(755, 'system', 'main-menu', 'master', 0, 0, '-1', 0, 0, '', '<none>', -1),
(756, 'system', 'management', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(757, 'system', 'navigation', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(758, 'system', 'powered-by', 'master', 0, -8, '-1', 0, 0, '', '', -1),
(759, 'system', 'user-menu', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(760, 'user', 'login', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(761, 'user', 'new', 'master', 0, 0, '-1', 0, 0, '', '', 1),
(762, 'user', 'online', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(763, 'views', 'category_blog-block', 'master', 1, 0, 'categories_blog', 0, 1, 'blog', '', -1),
(764, 'views', 'comments_recent-block', 'master', 1, 0, 'recent_comments', 0, 1, 'blog', '', -1),
(765, 'views', 'featured_in-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(766, 'views', 'features-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(767, 'views', 'form_powerfull-block_1', 'master', 0, 0, '-1', 0, 0, '<front>', '', -1),
(768, 'views', 'home_page_gallery-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(769, 'views', 'image_gallery-block_1', 'master', 1, 0, 'top_menu', 0, 1, '<front>', 'qweqwe', -1),
(770, 'views', 'location-block', 'master', 0, 0, '', 0, 1, 'contact', '', 1),
(771, 'views', 'price_table-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(772, 'views', 'recent_blog-block', 'master', 1, 0, 'recent_blog', 0, 1, 'blog', '', -1),
(773, 'views', 'services-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(774, 'views', 'skills-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(775, 'views', 'slideshow_bottom-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(776, 'views', 'slideshow_top-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(777, 'views', 'slideshow_top_view-block', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(778, 'views', 'statistics-block', 'master', 0, 0, '-1', 0, 1, '<front>', '', -1),
(779, 'views', 'test-block_1', 'master', 1, 0, 'top_menu', 0, 1, '<front>', 'testblock', -1),
(780, 'views', 'who_we_are-block', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(781, 'widgets', 's_addthis-share', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(782, 'widgets', 's_facebook-like-box', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(783, 'widgets', 's_socialmedia_profile-buttons', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(784, 'widgets', 's_socialmedia_profile-default', 'master', 1, 0, 'top_menu', 0, 0, '', '', -1),
(785, 'widgets', 's_socialmedia_profile-urls', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(786, 'widgets', 's_socialmedia_share-default', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(787, 'widgets', 's_twitter-profile-widget', 'master', 0, 0, '-1', 0, 0, '', '', -1),
(788, 'block', '38', 'garland', 0, 0, '-1', 0, 0, '', '<none>', -1),
(789, 'block', '38', 'master', 1, 0, 'first_news', 0, 0, '', '<none>', -1),
(790, 'block', '39', 'garland', 0, 0, '-1', 0, 0, '', '<none>', -1),
(791, 'block', '39', 'master', 1, 0, 'second_news', 0, 0, '', '<none>', -1),
(792, 'block', '40', 'garland', 0, 0, '-1', 0, 0, '', 'Drupal Theme', -1),
(793, 'block', '40', 'master', 1, 0, 'top1', 0, 0, '', 'Drupal Theme', -1),
(794, 'views', 'servece-block', 'master', 1, 0, 'top_content1', 0, 1, '<front>', 'Servece', -1),
(795, 'views', 'servece-block', 'garland', 0, 0, '-1', 0, 1, '<front>', 'Servece', -1),
(796, 'views', 'gallery-block', 'garland', 0, 0, '-1', 0, 1, '<front>', '', -1),
(797, 'views', 'gallery-block', 'master', 1, 0, 'line1', 0, 1, '<front>', '', -1),
(798, 'block', '41', 'garland', 0, 0, '-1', 0, 1, '<front>', 'my skills', -1),
(799, 'block', '41', 'master', 1, 0, 'contenttop1', 0, 1, '<front>', 'my skills', -1);

-- --------------------------------------------------------

--
-- Структура таблицы `blocked_ips`
--

DROP TABLE IF EXISTS `blocked_ips`;
CREATE TABLE IF NOT EXISTS `blocked_ips` (
  `iid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: unique ID for IP addresses.',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP address',
  PRIMARY KEY (`iid`),
  KEY `blocked_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores blocked IP addresses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `block_custom`
--

DROP TABLE IF EXISTS `block_custom`;
CREATE TABLE IF NOT EXISTS `block_custom` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made blocks.' AUTO_INCREMENT=42 ;

--
-- Дамп данных таблицы `block_custom`
--

INSERT INTO `block_custom` (`bid`, `body`, `info`, `format`) VALUES
(11, '\r\n<p>Lots of easy ways to use <a href="http://fontawesome.io/examples/" target="_blank">Font Awesome</a>.</p>\r\n\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>11 New Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-rub"></i> fa-rub</div>\r\n  <div class="fa-hover"><i class="fa fa-ruble"></i> fa-ruble</div>\r\n  <div class="fa-hover"><i class="fa fa-rouble"></i> fa-rouble</div>\r\n  <div class="fa-hover"><i class="fa fa-pagelines"></i> fa-pagelines</div>\r\n  <div class="fa-hover"><i class="fa fa-stack-exchange"></i> fa-stack-exchange</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-o-right"></i> fa-arrow-circle-o-right</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-o-left"></i> fa-arrow-circle-o-left</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-left"></i> fa-toggle-left</div>\r\n  <div class="fa-hover"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-wheelchair"></i> fa-wheelchair</div>\r\n  <div class="fa-hover"><i class="fa fa-vimeo-square"></i> fa-vimeo-square</div>\r\n  <div class="fa-hover"><i class="fa fa-try"></i> fa-try</div>\r\n  <div class="fa-hover"><i class="fa fa-turkish-lira"></i> fa-turkish-lira</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Web Application Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-adjust"></i> fa-adjust</div>\r\n  <div class="fa-hover"><i class="fa fa-anchor"></i> fa-anchor</div>\r\n  <div class="fa-hover"><i class="fa fa-archive"></i> fa-archive</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows"></i> fa-arrows</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows-h"></i> fa-arrows-h</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows-v"></i> fa-arrows-v</div>\r\n  <div class="fa-hover"><i class="fa fa-asterisk"></i> fa-asterisk</div>\r\n  <div class="fa-hover"><i class="fa fa-ban"></i> fa-ban</div>\r\n  <div class="fa-hover"><i class="fa fa-bar-chart-o"></i> fa-bar-chart-o</div>\r\n  <div class="fa-hover"><i class="fa fa-barcode"></i> fa-barcode</div>\r\n  <div class="fa-hover"><i class="fa fa-bars"></i> fa-bars</div>\r\n  <div class="fa-hover"><i class="fa fa-beer"></i> fa-beer</div>\r\n  <div class="fa-hover"><i class="fa fa-bell"></i> fa-bell</div>\r\n  <div class="fa-hover"><i class="fa fa-bell-o"></i> fa-bell-o</div>\r\n  <div class="fa-hover"><i class="fa fa-bolt"></i> fa-bolt</div>\r\n  <div class="fa-hover"><i class="fa fa-book"></i> fa-book</div>\r\n  <div class="fa-hover"><i class="fa fa-bookmark"></i> fa-bookmark</div>\r\n  <div class="fa-hover"><i class="fa fa-bookmark-o"></i> fa-bookmark-o</div>\r\n  <div class="fa-hover"><i class="fa fa-briefcase"></i> fa-briefcase</div>\r\n  <div class="fa-hover"><i class="fa fa-bug"></i> fa-bug</div>\r\n  <div class="fa-hover"><i class="fa fa-building-o"></i> fa-building-o</div>\r\n  <div class="fa-hover"><i class="fa fa-bullhorn"></i> fa-bullhorn</div>\r\n  <div class="fa-hover"><i class="fa fa-bullseye"></i> fa-bullseye</div>\r\n  <div class="fa-hover"><i class="fa fa-calendar"></i> fa-calendar</div>\r\n  <div class="fa-hover"><i class="fa fa-calendar-o"></i> fa-calendar-o</div>\r\n  <div class="fa-hover"><i class="fa fa-camera"></i> fa-camera</div>\r\n  <div class="fa-hover"><i class="fa fa-camera-retro"></i> fa-camera-retro</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-down"></i> fa-caret-square-o-down</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-right"></i> fa-caret-square-o-right</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-up"></i> fa-caret-square-o-up</div>\r\n  <div class="fa-hover"><i class="fa fa-certificate"></i> fa-certificate</div>\r\n  <div class="fa-hover"><i class="fa fa-check"></i> fa-check</div>\r\n  <div class="fa-hover"><i class="fa fa-check-circle"></i> fa-check-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-check-circle-o"></i> fa-check-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-check-square"></i> fa-check-square</div>\r\n  <div class="fa-hover"><i class="fa fa-check-square-o"></i> fa-check-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-circle"></i> fa-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-circle-o"></i> fa-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-clock-o"></i> fa-clock-o</div>\r\n  <div class="fa-hover"><i class="fa fa-cloud"></i> fa-cloud</div>\r\n  <div class="fa-hover"><i class="fa fa-cloud-download"></i> fa-cloud-download</div>\r\n  <div class="fa-hover"><i class="fa fa-cloud-upload"></i> fa-cloud-upload</div>\r\n  <div class="fa-hover"><i class="fa fa-code"></i> fa-code</div>\r\n  <div class="fa-hover"><i class="fa fa-code-fork"></i> fa-code-fork</div>\r\n  <div class="fa-hover"><i class="fa fa-coffee"></i> fa-coffee</div>\r\n  <div class="fa-hover"><i class="fa fa-cog"></i> fa-cog</div>\r\n  <div class="fa-hover"><i class="fa fa-cogs"></i> fa-cogs</div>\r\n  <div class="fa-hover"><i class="fa fa-comment"></i> fa-comment</div>\r\n  <div class="fa-hover"><i class="fa fa-comment-o"></i> fa-comment-o</div>\r\n  <div class="fa-hover"><i class="fa fa-comments"></i> fa-comments</div>\r\n  <div class="fa-hover"><i class="fa fa-comments-o"></i> fa-comments-o</div>\r\n  <div class="fa-hover"><i class="fa fa-compass"></i> fa-compass</div>\r\n  <div class="fa-hover"><i class="fa fa-credit-card"></i> fa-credit-card</div>\r\n  <div class="fa-hover"><i class="fa fa-crop"></i> fa-crop</div>\r\n  <div class="fa-hover"><i class="fa fa-crosshairs"></i> fa-crosshairs</div>\r\n  <div class="fa-hover"><i class="fa fa-cutlery"></i> fa-cutlery</div>\r\n  <div class="fa-hover"><i class="fa fa-dashboard"></i> fa-dashboard</div>\r\n  <div class="fa-hover"><i class="fa fa-desktop"></i> fa-desktop</div>\r\n  <div class="fa-hover"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-download"></i> fa-download</div>\r\n  <div class="fa-hover"><i class="fa fa-edit"></i> fa-edit</div>\r\n  <div class="fa-hover"><i class="fa fa-ellipsis-h"></i> fa-ellipsis-h</div>\r\n  <div class="fa-hover"><i class="fa fa-ellipsis-v"></i> fa-ellipsis-v</div>\r\n  <div class="fa-hover"><i class="fa fa-envelope"></i> fa-envelope</div>\r\n  <div class="fa-hover"><i class="fa fa-envelope-o"></i> fa-envelope-o</div>\r\n  <div class="fa-hover"><i class="fa fa-eraser"></i> fa-eraser</div>\r\n  <div class="fa-hover"><i class="fa fa-exchange"></i> fa-exchange</div>\r\n  <div class="fa-hover"><i class="fa fa-exclamation"></i> fa-exclamation</div>\r\n  <div class="fa-hover"><i class="fa fa-exclamation-circle"></i> fa-exclamation-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-exclamation-triangle"></i> fa-exclamation-triangle</div>\r\n  <div class="fa-hover"><i class="fa fa-external-link"></i> fa-external-link</div>\r\n  <div class="fa-hover"><i class="fa fa-external-link-square"></i> fa-external-link-square</div>\r\n  <div class="fa-hover"><i class="fa fa-eye"></i> fa-eye</div>\r\n  <div class="fa-hover"><i class="fa fa-eye-slash"></i> fa-eye-slash</div>\r\n  <div class="fa-hover"><i class="fa fa-female"></i> fa-female</div>\r\n  <div class="fa-hover"><i class="fa fa-fighter-jet"></i> fa-fighter-jet</div>\r\n  <div class="fa-hover"><i class="fa fa-film"></i> fa-film</div>\r\n  <div class="fa-hover"><i class="fa fa-filter"></i> fa-filter</div>\r\n  <div class="fa-hover"><i class="fa fa-fire"></i> fa-fire</div>\r\n  <div class="fa-hover"><i class="fa fa-fire-extinguisher"></i> fa-fire-extinguisher</div>\r\n  <div class="fa-hover"><i class="fa fa-flag"></i> fa-flag</div>\r\n  <div class="fa-hover"><i class="fa fa-flag-checkered"></i> fa-flag-checkered</div>\r\n  <div class="fa-hover"><i class="fa fa-flag-o"></i> fa-flag-o</div>\r\n  <div class="fa-hover"><i class="fa fa-flash"></i> fa-flash</div>\r\n  <div class="fa-hover"><i class="fa fa-flask"></i> fa-flask</div>\r\n  <div class="fa-hover"><i class="fa fa-folder"></i> fa-folder</div>\r\n  <div class="fa-hover"><i class="fa fa-folder-o"></i> fa-folder-o</div>\r\n  <div class="fa-hover"><i class="fa fa-folder-open"></i> fa-folder-open</div>\r\n  <div class="fa-hover"><i class="fa fa-folder-open-o"></i> fa-folder-open-o</div>\r\n  <div class="fa-hover"><i class="fa fa-frown-o"></i> fa-frown-o</div>\r\n  <div class="fa-hover"><i class="fa fa-gamepad"></i> fa-gamepad</div>\r\n  <div class="fa-hover"><i class="fa fa-gavel"></i> fa-gavel</div>\r\n  <div class="fa-hover"><i class="fa fa-gear"></i> fa-gear</div>\r\n  <div class="fa-hover"><i class="fa fa-gears"></i> fa-gears</div>\r\n  <div class="fa-hover"><i class="fa fa-gift"></i> fa-gift</div>\r\n  <div class="fa-hover"><i class="fa fa-glass"></i> fa-glass</div>\r\n  <div class="fa-hover"><i class="fa fa-globe"></i> fa-globe</div>\r\n  <div class="fa-hover"><i class="fa fa-group"></i> fa-group</div>\r\n  <div class="fa-hover"><i class="fa fa-hdd-o"></i> fa-hdd-o</div>\r\n  <div class="fa-hover"><i class="fa fa-headphones"></i> fa-headphones</div>\r\n  <div class="fa-hover"><i class="fa fa-heart"></i> fa-heart</div>\r\n  <div class="fa-hover"><i class="fa fa-heart-o"></i> fa-heart-o</div>\r\n  <div class="fa-hover"><i class="fa fa-home"></i> fa-home</div>\r\n  <div class="fa-hover"><i class="fa fa-inbox"></i> fa-inbox</div>\r\n  <div class="fa-hover"><i class="fa fa-info"></i> fa-info</div>\r\n  <div class="fa-hover"><i class="fa fa-info-circle"></i> fa-info-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-key"></i> fa-key</div>\r\n  <div class="fa-hover"><i class="fa fa-keyboard-o"></i> fa-keyboard-o</div>\r\n  <div class="fa-hover"><i class="fa fa-laptop"></i> fa-laptop</div>\r\n  <div class="fa-hover"><i class="fa fa-leaf"></i> fa-leaf</div>\r\n  <div class="fa-hover"><i class="fa fa-legal"></i> fa-legal</div>\r\n  <div class="fa-hover"><i class="fa fa-lemon-o"></i> fa-lemon-o</div>\r\n  <div class="fa-hover"><i class="fa fa-level-down"></i> fa-level-down</div>\r\n  <div class="fa-hover"><i class="fa fa-level-up"></i> fa-level-up</div>\r\n  <div class="fa-hover"><i class="fa fa-lightbulb-o"></i> fa-lightbulb-o</div>\r\n  <div class="fa-hover"><i class="fa fa-location-arrow"></i> fa-location-arrow</div>\r\n  <div class="fa-hover"><i class="fa fa-lock"></i> fa-lock</div>\r\n  <div class="fa-hover"><i class="fa fa-magic"></i> fa-magic</div>\r\n  <div class="fa-hover"><i class="fa fa-magnet"></i> fa-magnet</div>\r\n  <div class="fa-hover"><i class="fa fa-mail-forward"></i> fa-mail-forward</div>\r\n  <div class="fa-hover"><i class="fa fa-mail-reply"></i> fa-mail-reply</div>\r\n  <div class="fa-hover"><i class="fa fa-mail-reply-all"></i> fa-mail-reply-all</div>\r\n  <div class="fa-hover"><i class="fa fa-male"></i> fa-male</div>\r\n  <div class="fa-hover"><i class="fa fa-map-marker"></i> fa-map-marker</div>\r\n  <div class="fa-hover"><i class="fa fa-meh-o"></i> fa-meh-o</div>\r\n  <div class="fa-hover"><i class="fa fa-microphone"></i> fa-microphone</div>\r\n  <div class="fa-hover"><i class="fa fa-microphone-slash"></i> fa-microphone-slash</div>\r\n  <div class="fa-hover"><i class="fa fa-minus"></i> fa-minus</div>\r\n  <div class="fa-hover"><i class="fa fa-minus-circle"></i> fa-minus-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-minus-square"></i> fa-minus-square</div>\r\n  <div class="fa-hover"><i class="fa fa-minus-square-o"></i> fa-minus-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-mobile"></i> fa-mobile</div>\r\n  <div class="fa-hover"><i class="fa fa-mobile-phone"></i> fa-mobile-phone</div>\r\n  <div class="fa-hover"><i class="fa fa-money"></i> fa-money</div>\r\n  <div class="fa-hover"><i class="fa fa-moon-o"></i> fa-moon-o</div>\r\n  <div class="fa-hover"><i class="fa fa-music"></i> fa-music</div>\r\n  <div class="fa-hover"><i class="fa fa-pencil"></i> fa-pencil</div>\r\n  <div class="fa-hover"><i class="fa fa-pencil-square"></i> fa-pencil-square</div>\r\n  <div class="fa-hover"><i class="fa fa-pencil-square-o"></i> fa-pencil-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-phone"></i> fa-phone</div>\r\n  <div class="fa-hover"><i class="fa fa-phone-square"></i> fa-phone-square</div>\r\n  <div class="fa-hover"><i class="fa fa-picture-o"></i> fa-picture-o</div>\r\n  <div class="fa-hover"><i class="fa fa-plane"></i> fa-plane</div>\r\n  <div class="fa-hover"><i class="fa fa-plus"></i> fa-plus</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-circle"></i> fa-plus-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-square"></i> fa-plus-square</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-power-off"></i> fa-power-off</div>\r\n  <div class="fa-hover"><i class="fa fa-print"></i> fa-print</div>\r\n  <div class="fa-hover"><i class="fa fa-puzzle-piece"></i> fa-puzzle-piece</div>\r\n  <div class="fa-hover"><i class="fa fa-qrcode"></i> fa-qrcode</div>\r\n  <div class="fa-hover"><i class="fa fa-question"></i> fa-question</div>\r\n  <div class="fa-hover"><i class="fa fa-question-circle"></i> fa-question-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-quote-left"></i> fa-quote-left</div>\r\n  <div class="fa-hover"><i class="fa fa-quote-right"></i> fa-quote-right</div>\r\n  <div class="fa-hover"><i class="fa fa-random"></i> fa-random</div>\r\n  <div class="fa-hover"><i class="fa fa-refresh"></i> fa-refresh</div>\r\n  <div class="fa-hover"><i class="fa fa-reply"></i> fa-reply</div>\r\n  <div class="fa-hover"><i class="fa fa-reply-all"></i> fa-reply-all</div>\r\n  <div class="fa-hover"><i class="fa fa-retweet"></i> fa-retweet</div>\r\n  <div class="fa-hover"><i class="fa fa-road"></i> fa-road</div>\r\n  <div class="fa-hover"><i class="fa fa-rocket"></i> fa-rocket</div>\r\n  <div class="fa-hover"><i class="fa fa-rss"></i> fa-rss</div>\r\n  <div class="fa-hover"><i class="fa fa-rss-square"></i> fa-rss-square</div>\r\n  <div class="fa-hover"><i class="fa fa-search"></i> fa-search</div>\r\n  <div class="fa-hover"><i class="fa fa-search-minus"></i> fa-search-minus</div>\r\n  <div class="fa-hover"><i class="fa fa-search-plus"></i> fa-search-plus</div>\r\n  <div class="fa-hover"><i class="fa fa-share"></i> fa-share</div>\r\n  <div class="fa-hover"><i class="fa fa-share-square"></i> fa-share-square</div>\r\n  <div class="fa-hover"><i class="fa fa-share-square-o"></i> fa-share-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-shield"></i> fa-shield</div>\r\n  <div class="fa-hover"><i class="fa fa-shopping-cart"></i> fa-shopping-cart</div>\r\n  <div class="fa-hover"><i class="fa fa-sign-in"></i> fa-sign-in</div>\r\n  <div class="fa-hover"><i class="fa fa-sign-out"></i> fa-sign-out</div>\r\n  <div class="fa-hover"><i class="fa fa-signal"></i> fa-signal</div>\r\n  <div class="fa-hover"><i class="fa fa-sitemap"></i> fa-sitemap</div>\r\n  <div class="fa-hover"><i class="fa fa-smile-o"></i> fa-smile-o</div>\r\n  <div class="fa-hover"><i class="fa fa-sort"></i> fa-sort</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-alpha-asc"></i> fa-sort-alpha-asc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-alpha-desc"></i> fa-sort-alpha-desc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-amount-asc"></i> fa-sort-amount-asc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-amount-desc"></i> fa-sort-amount-desc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-asc"></i> fa-sort-asc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-desc"></i> fa-sort-desc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-down"></i> fa-sort-down</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-numeric-asc"></i> fa-sort-numeric-asc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-numeric-desc"></i> fa-sort-numeric-desc</div>\r\n  <div class="fa-hover"><i class="fa fa-sort-up"></i> fa-sort-up</div>\r\n  <div class="fa-hover"><i class="fa fa-spinner"></i> fa-spinner</div>\r\n  <div class="fa-hover"><i class="fa fa-square"></i> fa-square</div>\r\n  <div class="fa-hover"><i class="fa fa-square-o"></i> fa-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-star"></i> fa-star</div>\r\n  <div class="fa-hover"><i class="fa fa-star-half"></i> fa-star-half</div>\r\n  <div class="fa-hover"><i class="fa fa-star-half-empty"></i> fa-star-half-empty</div>\r\n  <div class="fa-hover"><i class="fa fa-star-half-full"></i> fa-star-half-full</div>\r\n  <div class="fa-hover"><i class="fa fa-star-half-o"></i> fa-star-half-o</div>\r\n  <div class="fa-hover"><i class="fa fa-star-o"></i> fa-star-o</div>\r\n  <div class="fa-hover"><i class="fa fa-subscript"></i> fa-subscript</div>\r\n  <div class="fa-hover"><i class="fa fa-suitcase"></i> fa-suitcase</div>\r\n  <div class="fa-hover"><i class="fa fa-sun-o"></i> fa-sun-o</div>\r\n  <div class="fa-hover"><i class="fa fa-superscript"></i> fa-superscript</div>\r\n  <div class="fa-hover"><i class="fa fa-tablet"></i> fa-tablet</div>\r\n  <div class="fa-hover"><i class="fa fa-tachometer"></i> fa-tachometer</div>\r\n  <div class="fa-hover"><i class="fa fa-tag"></i> fa-tag</div>\r\n  <div class="fa-hover"><i class="fa fa-tags"></i> fa-tags</div>\r\n  <div class="fa-hover"><i class="fa fa-tasks"></i> fa-tasks</div>\r\n  <div class="fa-hover"><i class="fa fa-terminal"></i> fa-terminal</div>\r\n  <div class="fa-hover"><i class="fa fa-thumb-tack"></i> fa-thumb-tack</div>\r\n  <div class="fa-hover"><i class="fa fa-thumbs-down"></i> fa-thumbs-down</div>\r\n  <div class="fa-hover"><i class="fa fa-thumbs-o-down"></i> fa-thumbs-o-down</div>\r\n  <div class="fa-hover"><i class="fa fa-thumbs-o-up"></i> fa-thumbs-o-up</div>\r\n  <div class="fa-hover"><i class="fa fa-thumbs-up"></i> fa-thumbs-up</div>\r\n  <div class="fa-hover"><i class="fa fa-ticket"></i> fa-ticket</div>\r\n  <div class="fa-hover"><i class="fa fa-times"></i> fa-times</div>\r\n  <div class="fa-hover"><i class="fa fa-times-circle"></i> fa-times-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-times-circle-o"></i> fa-times-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-tint"></i> fa-tint</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-down"></i> fa-toggle-down</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-left"></i> fa-toggle-left</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-right"></i> fa-toggle-right</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-up"></i> fa-toggle-up</div>\r\n  <div class="fa-hover"><i class="fa fa-trash-o"></i> fa-trash-o</div>\r\n  <div class="fa-hover"><i class="fa fa-trophy"></i> fa-trophy</div>\r\n  <div class="fa-hover"><i class="fa fa-truck"></i> fa-truck</div>\r\n  <div class="fa-hover"><i class="fa fa-umbrella"></i> fa-umbrella</div>\r\n  <div class="fa-hover"><i class="fa fa-unlock"></i> fa-unlock</div>\r\n  <div class="fa-hover"><i class="fa fa-unlock-alt"></i> fa-unlock-alt</div>\r\n  <div class="fa-hover"><i class="fa fa-unsorted"></i> fa-unsorted</div>\r\n  <div class="fa-hover"><i class="fa fa-upload"></i> fa-upload</div>\r\n  <div class="fa-hover"><i class="fa fa-user"></i> fa-user</div>\r\n  <div class="fa-hover"><i class="fa fa-users"></i> fa-users</div>\r\n  <div class="fa-hover"><i class="fa fa-video-camera"></i> fa-video-camera</div>\r\n  <div class="fa-hover"><i class="fa fa-volume-down"></i> fa-volume-down</div>\r\n  <div class="fa-hover"><i class="fa fa-volume-off"></i> fa-volume-off</div>\r\n  <div class="fa-hover"><i class="fa fa-volume-up"></i> fa-volume-up</div>\r\n  <div class="fa-hover"><i class="fa fa-warning"></i> fa-warning</div>\r\n  <div class="fa-hover"><i class="fa fa-wheelchair"></i> fa-wheelchair</div>\r\n  <div class="fa-hover"><i class="fa fa-wrench"></i> fa-wrench</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Form Control Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-check-square"></i> fa-check-square</div>\r\n  <div class="fa-hover"><i class="fa fa-check-square-o"></i> fa-check-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-circle"></i> fa-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-circle-o"></i> fa-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-minus-square"></i> fa-minus-square</div>\r\n  <div class="fa-hover"><i class="fa fa-minus-square-o"></i> fa-minus-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-square"></i> fa-plus-square</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</div>\r\n  <div class="fa-hover"><i class="fa fa-square"></i> fa-square</div>\r\n  <div class="fa-hover"><i class="fa fa-square-o"></i> fa-square-o</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Currency Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-bitcoin"></i> fa-bitcoin</div>\r\n  <div class="fa-hover"><i class="fa fa-btc"></i> fa-btc</div>\r\n  <div class="fa-hover"><i class="fa fa-cny"></i> fa-cny</div>\r\n  <div class="fa-hover"><i class="fa fa-dollar"></i> fa-dollar</div>\r\n  <div class="fa-hover"><i class="fa fa-eur"></i> fa-eur</div>\r\n  <div class="fa-hover"><i class="fa fa-euro"></i> fa-euro</div>\r\n  <div class="fa-hover"><i class="fa fa-gbp"></i> fa-gbp</div>\r\n  <div class="fa-hover"><i class="fa fa-inr"></i> fa-inr</div>\r\n  <div class="fa-hover"><i class="fa fa-jpy"></i> fa-jpy</div>\r\n  <div class="fa-hover"><i class="fa fa-krw"></i> fa-krw</div>\r\n  <div class="fa-hover"><i class="fa fa-money"></i> fa-money</div>\r\n  <div class="fa-hover"><i class="fa fa-rmb"></i> fa-rmb</div>\r\n  <div class="fa-hover"><i class="fa fa-rouble"></i> fa-rouble</div>\r\n  <div class="fa-hover"><i class="fa fa-rub"></i> fa-rub</div>\r\n  <div class="fa-hover"><i class="fa fa-ruble"></i> fa-ruble</div>\r\n  <div class="fa-hover"><i class="fa fa-rupee"></i> fa-rupee</div>\r\n  <div class="fa-hover"><i class="fa fa-try"></i> fa-try</div>\r\n  <div class="fa-hover"><i class="fa fa-turkish-lira"></i> fa-turkish-lira</div>\r\n  <div class="fa-hover"><i class="fa fa-usd"></i> fa-usd</div>\r\n  <div class="fa-hover"><i class="fa fa-won"></i> fa-won</div>\r\n  <div class="fa-hover"><i class="fa fa-yen"></i> fa-yen</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Text Editor Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-align-center"></i> fa-align-center</div>\r\n  <div class="fa-hover"><i class="fa fa-align-justify"></i> fa-align-justify</div>\r\n  <div class="fa-hover"><i class="fa fa-align-left"></i> fa-align-left</div>\r\n  <div class="fa-hover"><i class="fa fa-align-right"></i> fa-align-right</div>\r\n  <div class="fa-hover"><i class="fa fa-bold"></i> fa-bold</div>\r\n  <div class="fa-hover"><i class="fa fa-chain"></i> fa-chain</div>\r\n  <div class="fa-hover"><i class="fa fa-chain-broken"></i> fa-chain-broken</div>\r\n  <div class="fa-hover"><i class="fa fa-clipboard"></i> fa-clipboard</div>\r\n  <div class="fa-hover"><i class="fa fa-columns"></i> fa-columns</div>\r\n  <div class="fa-hover"><i class="fa fa-copy"></i> fa-copy</div>\r\n  <div class="fa-hover"><i class="fa fa-cut"></i> fa-cut</div>\r\n  <div class="fa-hover"><i class="fa fa-dedent"></i> fa-dedent</div>\r\n  <div class="fa-hover"><i class="fa fa-eraser"></i> fa-eraser</div>\r\n  <div class="fa-hover"><i class="fa fa-file"></i> fa-file</div>\r\n  <div class="fa-hover"><i class="fa fa-file-o"></i> fa-file-o</div>\r\n  <div class="fa-hover"><i class="fa fa-file-text"></i> fa-file-text</div>\r\n  <div class="fa-hover"><i class="fa fa-file-text-o"></i> fa-file-text-o</div>\r\n  <div class="fa-hover"><i class="fa fa-files-o"></i> fa-files-o</div>\r\n  <div class="fa-hover"><i class="fa fa-floppy-o"></i> fa-floppy-o</div>\r\n  <div class="fa-hover"><i class="fa fa-font"></i> fa-font</div>\r\n  <div class="fa-hover"><i class="fa fa-indent"></i> fa-indent</div>\r\n  <div class="fa-hover"><i class="fa fa-italic"></i> fa-italic</div>\r\n  <div class="fa-hover"><i class="fa fa-link"></i> fa-link</div>\r\n  <div class="fa-hover"><i class="fa fa-list"></i> fa-list</div>\r\n  <div class="fa-hover"><i class="fa fa-list-alt"></i> fa-list-alt</div>\r\n  <div class="fa-hover"><i class="fa fa-list-ol"></i> fa-list-ol</div>\r\n  <div class="fa-hover"><i class="fa fa-list-ul"></i> fa-list-ul</div>\r\n  <div class="fa-hover"><i class="fa fa-outdent"></i> fa-outdent</div>\r\n  <div class="fa-hover"><i class="fa fa-paperclip"></i> fa-paperclip</div>\r\n  <div class="fa-hover"><i class="fa fa-paste"></i> fa-paste</div>\r\n  <div class="fa-hover"><i class="fa fa-repeat"></i> fa-repeat</div>\r\n  <div class="fa-hover"><i class="fa fa-rotate-left"></i> fa-rotate-left</div>\r\n  <div class="fa-hover"><i class="fa fa-rotate-right"></i> fa-rotate-right</div>\r\n  <div class="fa-hover"><i class="fa fa-save"></i> fa-save</div>\r\n  <div class="fa-hover"><i class="fa fa-scissors"></i> fa-scissors</div>\r\n  <div class="fa-hover"><i class="fa fa-strikethrough"></i> fa-strikethrough</div>\r\n  <div class="fa-hover"><i class="fa fa-table"></i> fa-table</div>\r\n  <div class="fa-hover"><i class="fa fa-text-height"></i> fa-text-height</div>\r\n  <div class="fa-hover"><i class="fa fa-text-width"></i> fa-text-width</div>\r\n  <div class="fa-hover"><i class="fa fa-th"></i> fa-th</div>\r\n  <div class="fa-hover"><i class="fa fa-th-large"></i> fa-th-large</div>\r\n  <div class="fa-hover"><i class="fa fa-th-list"></i> fa-th-list</div>\r\n  <div class="fa-hover"><i class="fa fa-underline"></i> fa-underline</div>\r\n  <div class="fa-hover"><i class="fa fa-undo"></i> fa-undo</div>\r\n  <div class="fa-hover"><i class="fa fa-unlink"></i> fa-unlink</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Directional Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-angle-double-down"></i> fa-angle-double-down</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-double-left"></i> fa-angle-double-left</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-double-right"></i> fa-angle-double-right</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-double-up"></i> fa-angle-double-up</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-down"></i> fa-angle-down</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-left"></i> fa-angle-left</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-right"></i> fa-angle-right</div>\r\n  <div class="fa-hover"><i class="fa fa-angle-up"></i> fa-angle-up</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-down"></i> fa-arrow-circle-down</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-left"></i> fa-arrow-circle-left</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-o-down"></i> fa-arrow-circle-o-down</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-o-left"></i> fa-arrow-circle-o-left</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-o-right"></i> fa-arrow-circle-o-right</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-o-up"></i> fa-arrow-circle-o-up</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-right"></i> fa-arrow-circle-right</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-circle-up"></i> fa-arrow-circle-up</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-down"></i> fa-arrow-down</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-left"></i> fa-arrow-left</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-right"></i> fa-arrow-right</div>\r\n  <div class="fa-hover"><i class="fa fa-arrow-up"></i> fa-arrow-up</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows"></i> fa-arrows</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows-alt"></i> fa-arrows-alt</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows-h"></i> fa-arrows-h</div>\r\n  <div class="fa-hover"><i class="fa fa-arrows-v"></i> fa-arrows-v</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-down"></i> fa-caret-down</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-left"></i> fa-caret-left</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-right"></i> fa-caret-right</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-down"></i> fa-caret-square-o-down</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-right"></i> fa-caret-square-o-right</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-square-o-up"></i> fa-caret-square-o-up</div>\r\n  <div class="fa-hover"><i class="fa fa-caret-up"></i> fa-caret-up</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-circle-down"></i> fa-chevron-circle-down</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-circle-left"></i> fa-chevron-circle-left</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-circle-right"></i> fa-chevron-circle-right</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-circle-up"></i> fa-chevron-circle-up</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-down"></i> fa-chevron-down</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-left"></i> fa-chevron-left</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-right"></i> fa-chevron-right</div>\r\n  <div class="fa-hover"><i class="fa fa-chevron-up"></i> fa-chevron-up</div>\r\n  <div class="fa-hover"><i class="fa fa-hand-o-down"></i> fa-hand-o-down</div>\r\n  <div class="fa-hover"><i class="fa fa-hand-o-left"></i> fa-hand-o-left</div>\r\n  <div class="fa-hover"><i class="fa fa-hand-o-right"></i> fa-hand-o-right</div>\r\n  <div class="fa-hover"><i class="fa fa-hand-o-up"></i> fa-hand-o-up</div>\r\n  <div class="fa-hover"><i class="fa fa-long-arrow-down"></i> fa-long-arrow-down</div>\r\n  <div class="fa-hover"><i class="fa fa-long-arrow-left"></i> fa-long-arrow-left</div>\r\n  <div class="fa-hover"><i class="fa fa-long-arrow-right"></i> fa-long-arrow-right</div>\r\n  <div class="fa-hover"><i class="fa fa-long-arrow-up"></i> fa-long-arrow-up</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-down"></i> fa-toggle-down</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-left"></i> fa-toggle-left</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-right"></i> fa-toggle-right</div>\r\n  <div class="fa-hover"><i class="fa fa-toggle-up"></i> fa-toggle-up</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Video Player Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-arrows-alt"></i> fa-arrows-alt</div>\r\n  <div class="fa-hover"><i class="fa fa-backward"></i> fa-backward</div>\r\n  <div class="fa-hover"><i class="fa fa-compress"></i> fa-compress</div>\r\n  <div class="fa-hover"><i class="fa fa-eject"></i> fa-eject</div>\r\n  <div class="fa-hover"><i class="fa fa-expand"></i> fa-expand</div>\r\n  <div class="fa-hover"><i class="fa fa-fast-backward"></i> fa-fast-backward</div>\r\n  <div class="fa-hover"><i class="fa fa-fast-forward"></i> fa-fast-forward</div>\r\n  <div class="fa-hover"><i class="fa fa-forward"></i> fa-forward</div>\r\n  <div class="fa-hover"><i class="fa fa-pause"></i> fa-pause</div>\r\n  <div class="fa-hover"><i class="fa fa-play"></i> fa-play</div>\r\n  <div class="fa-hover"><i class="fa fa-play-circle"></i> fa-play-circle</div>\r\n  <div class="fa-hover"><i class="fa fa-play-circle-o"></i> fa-play-circle-o</div>\r\n  <div class="fa-hover"><i class="fa fa-step-backward"></i> fa-step-backward</div>\r\n  <div class="fa-hover"><i class="fa fa-step-forward"></i> fa-step-forward</div>\r\n  <div class="fa-hover"><i class="fa fa-stop"></i> fa-stop</div>\r\n  <div class="fa-hover"><i class="fa fa-youtube-play"></i> fa-youtube-play</div>\r\n\r\n\r\n<div class="row-fluid iconsrow">\r\n<h4>Brand Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-adn"></i> fa-adn</div>\r\n  <div class="fa-hover"><i class="fa fa-android"></i> fa-android</div>\r\n  <div class="fa-hover"><i class="fa fa-apple"></i> fa-apple</div>\r\n  <div class="fa-hover"><i class="fa fa-bitbucket"></i> fa-bitbucket</div>\r\n  <div class="fa-hover"><i class="fa fa-bitbucket-square"></i> fa-bitbucket-square</div>\r\n  <div class="fa-hover"><i class="fa fa-bitcoin"></i> fa-bitcoin</div>\r\n  <div class="fa-hover"><i class="fa fa-btc"></i> fa-btc</div>\r\n  <div class="fa-hover"><i class="fa fa-css3"></i> fa-css3</div>\r\n  <div class="fa-hover"><i class="fa fa-dribbble"></i> fa-dribbble</div>\r\n  <div class="fa-hover"><i class="fa fa-dropbox"></i> fa-dropbox</div>\r\n  <div class="fa-hover"><i class="fa fa-facebook"></i> fa-facebook</div>\r\n  <div class="fa-hover"><i class="fa fa-facebook-square"></i> fa-facebook-square</div>\r\n  <div class="fa-hover"><i class="fa fa-flickr"></i> fa-flickr</div>\r\n  <div class="fa-hover"><i class="fa fa-foursquare"></i> fa-foursquare</div>\r\n  <div class="fa-hover"><i class="fa fa-github"></i> fa-github</div>\r\n  <div class="fa-hover"><i class="fa fa-github-alt"></i> fa-github-alt</div>\r\n  <div class="fa-hover"><i class="fa fa-github-square"></i> fa-github-square</div>\r\n  <div class="fa-hover"><i class="fa fa-gittip"></i> fa-gittip</div>\r\n  <div class="fa-hover"><i class="fa fa-google-plus"></i> fa-google-plus</div>\r\n  <div class="fa-hover"><i class="fa fa-google-plus-square"></i> fa-google-plus-square</div>\r\n  <div class="fa-hover"><i class="fa fa-html5"></i> fa-html5</div>\r\n  <div class="fa-hover"><i class="fa fa-instagram"></i> fa-instagram</div>\r\n  <div class="fa-hover"><i class="fa fa-linkedin"></i> fa-linkedin</div>\r\n  <div class="fa-hover"><i class="fa fa-linkedin-square"></i> fa-linkedin-square</div>\r\n  <div class="fa-hover"><i class="fa fa-linux"></i> fa-linux</div>\r\n  <div class="fa-hover"><i class="fa fa-maxcdn"></i> fa-maxcdn</div>\r\n  <div class="fa-hover"><i class="fa fa-pagelines"></i> fa-pagelines</div>\r\n  <div class="fa-hover"><i class="fa fa-pinterest"></i> fa-pinterest</div>\r\n  <div class="fa-hover"><i class="fa fa-pinterest-square"></i> fa-pinterest-square</div>\r\n  <div class="fa-hover"><i class="fa fa-renren"></i> fa-renren</div>\r\n  <div class="fa-hover"><i class="fa fa-skype"></i> fa-skype</div>\r\n  <div class="fa-hover"><i class="fa fa-stack-exchange"></i> fa-stack-exchange</div>\r\n  <div class="fa-hover"><i class="fa fa-stack-overflow"></i> fa-stack-overflow</div>\r\n  <div class="fa-hover"><i class="fa fa-trello"></i> fa-trello</div>\r\n  <div class="fa-hover"><i class="fa fa-tumblr"></i> fa-tumblr</div>\r\n  <div class="fa-hover"><i class="fa fa-tumblr-square"></i> fa-tumblr-square</div>\r\n  <div class="fa-hover"><i class="fa fa-twitter"></i> fa-twitter</div>\r\n  <div class="fa-hover"><i class="fa fa-twitter-square"></i> fa-twitter-square</div>\r\n  <div class="fa-hover"><i class="fa fa-vimeo-square"></i> fa-vimeo-square</div>\r\n  <div class="fa-hover"><i class="fa fa-vk"></i> fa-vk</div>\r\n  <div class="fa-hover"><i class="fa fa-weibo"></i> fa-weibo</div>\r\n  <div class="fa-hover"><i class="fa fa-windows"></i> fa-windows</div>\r\n  <div class="fa-hover"><i class="fa fa-xing"></i> fa-xing</div>\r\n  <div class="fa-hover"><i class="fa fa-xing-square"></i> fa-xing-square</div>\r\n  <div class="fa-hover"><i class="fa fa-youtube"></i> fa-youtube</div>\r\n  <div class="fa-hover"><i class="fa fa-youtube-play"></i> fa-youtube-play</div>\r\n  <div class="fa-hover"><i class="fa fa-youtube-square"></i> fa-youtube-square</div>\r\n</div>\r\n\r\n<div class="row-fluid iconsrow">\r\n  <h4>Medical Icons</h4>\r\n  <div class="fa-hover"><i class="fa fa-ambulance"></i> fa-ambulance</div>\r\n  <div class="fa-hover"><i class="fa fa-h-square"></i> fa-h-square</div>\r\n  <div class="fa-hover"><i class="fa fa-hospital-o"></i> fa-hospital-o</div>\r\n  <div class="fa-hover"><i class="fa fa-medkit"></i> fa-medkit</div>\r\n  <div class="fa-hover"><i class="fa fa-plus-square"></i> fa-plus-square</div>\r\n  <div class="fa-hover"><i class="fa fa-stethoscope"></i> fa-stethoscope</div>\r\n  <div class="fa-hover"><i class="fa fa-user-md"></i> fa-user-md</div>\r\n  <div class="fa-hover"><i class="fa fa-wheelchair"></i> fa-wheelchair</div>\r\n</div>\r\n\r\n\r\n<div id="accordion1" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion1">How to use</a></div>\r\n<div id="collapseOne" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;i class="fa fa-tumblr-square"&gt;&lt;/i&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Icons ', 'full_html'),
(12, '	  <div class="row-fluid">\r\n	    <div class="span4">\r\n		<h1>H1 header</h1>\r\n		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vehicula tempus nulla at eleifend. Morbi placerat neque tincidunt velit accumsan pulvinar. Quisque vel consectetur ligula.</p><p><br></p>\r\n	    </div>\r\n\r\n	    <div class="span4">\r\n		<h2>H2 header</h2>\r\n		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vehicula tempus nulla at eleifend. Morbi placerat neque tincidunt velit accumsan pulvinar. Quisque vel consectetur ligula.</p><p><br></p>\r\n	    </div>\r\n\r\n	    <div class="span4">\r\n		<h3>H3 header</h3>\r\n		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vehicula tempus nulla at eleifend. Morbi placerat neque tincidunt velit accumsan pulvinar. Quisque vel consectetur ligula.</p><p><br></p>\r\n	    </div>\r\n	  </div>\r\n\r\n\r\n	  <div class="row-fluid">\r\n	    <div class="span4">\r\n		<h4>H4 header</h4>\r\n		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vehicula tempus nulla at eleifend. Morbi placerat neque tincidunt velit accumsan pulvinar. Quisque vel consectetur ligula.</p><p><br></p>\r\n	    </div>\r\n\r\n	    <div class="span4">\r\n		<h5>H5 header</h5>\r\n		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vehicula tempus nulla at eleifend. Morbi placerat neque tincidunt velit accumsan pulvinar. Quisque vel consectetur ligula.</p><p><br></p>\r\n	    </div>\r\n\r\n	    <div class="span4">\r\n		<h6>H6 header</h6>\r\n		<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean vehicula tempus nulla at eleifend. Morbi placerat neque tincidunt velit accumsan pulvinar. Quisque vel consectetur ligula.</p><p><br></p>\r\n	    </div>\r\n	  </div>\r\n\r\n	  <div class="row-fluid">\r\n	    <div class="span4">\r\n		<h2>List</h2>\r\n		<ul>\r\n		<li>Lorem ipsum dolor sit amet neque tincidunt</li>\r\n		<li>Consectetur adipiscing elit vel consectetur ligula</li>\r\n		<li>Aenean vehicula tempus nulla at dolore magna aliguam</li>\r\n		</ul>\r\n	    </div>\r\n\r\n	    <div class="span4">\r\n		<h2>Link</h2>\r\n		<a href="#">This is simple link</a><br>\r\n	    </div>\r\n\r\n	    <div class="span4">\r\n		<h2>Blockquote</h2>\r\n		<blockquote>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diem nonummy nibh euismod tincidunt ut lacreet dolore magna aliguam erat volutpat. Ut wisis enim ad minim veniam, quis nostrud exerci tution ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.<br></blockquote>\r\n	    </div>\r\n	  </div>', 'Typography', 'full_html'),
(13, '<h4>Large button</h4>\r\n<p><button class="btn btn-large" type="button">Large button</button> <button class="btn btn-large btn-primary" type="button">Large button</button> <button class="btn btn-large btn-info" type="button">Large button</button> <button class="btn btn-large btn-success" type="button">Large button</button> <button class="btn btn-large btn-warning" type="button">Large button</button> <button class="btn btn-large btn-danger" type="button">Large button</button> <button class="btn btn-large btn-inverse" type="button">Large button</button></p>\r\n<div id="accordion1" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion1">How to use</a></div>\r\n<div id="collapseOne" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;button class="btn btn-large" type="button"&gt;Large button&lt;/button&gt; \r\n&lt;button class="btn btn-large btn-primary" type="button"&gt;Large button&lt;/button&gt; \r\n&lt;button class="btn btn-large btn-info" type="button"&gt;Large button&lt;/button&gt; \r\n&lt;button class="btn btn-large btn-success" type="button"&gt;Large button&lt;/button&gt; \r\n&lt;button class="btn btn-large btn-warning" type="button"&gt;Large button&lt;/button&gt; \r\n&lt;button class="btn btn-large btn-danger" type="button"&gt;Large button&lt;/button&gt; \r\n&lt;button class="btn btn-large btn-inverse" type="button"&gt;Large button&lt;/button&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Button</h4>\r\n<p><button class="btn" type="button">Button</button> <button class="btn btn-primary" type="button">Button</button> <button class="btn btn-info" type="button">Button</button> <button class="btn btn-success" type="button">Button</button> <button class="btn btn-warning" type="button">Button</button> <button class="btn btn-danger" type="button">Button</button> <button class="btn btn-inverse" type="button">Button</button></p>\r\n<div id="accordion2" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseTwo" data-toggle="collapse" data-parent="#accordion2">How to use</a></div>\r\n<div id="collapseTwo" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;button class="btn" type="button"&gt;Button&lt;/button&gt; \r\n&lt;button class="btn btn-primary" type="button"&gt;Button&lt;/button&gt; \r\n&lt;button class="btn btn-info" type="button"&gt;Button&lt;/button&gt; \r\n&lt;button class="btn btn-success" type="button"&gt;Button&lt;/button&gt; \r\n&lt;button class="btn btn-warning" type="button"&gt;Button&lt;/button&gt; \r\n&lt;button class="btn btn-danger" type="button"&gt;Button&lt;/button&gt; \r\n&lt;button class="btn btn-inverse" type="button"&gt;Button&lt;/button&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Small button</h4>\r\n<p><button class="btn btn-small" type="button">Small button</button> <button class="btn btn-small btn-primary" type="button">Small button</button> <button class="btn btn-small btn-info" type="button">Small button</button> <button class="btn btn-small btn-success" type="button">Small button</button> <button class="btn btn-small btn-warning" type="button">Small button</button> <button class="btn btn-small btn-danger" type="button">Small button</button> <button class="btn btn-small btn-inverse" type="button">Small button</button></p>\r\n<div id="accordion3" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseThree" data-toggle="collapse" data-parent="#accordion3">How to use</a></div>\r\n<div id="collapseThree" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;button class="btn btn-small" type="button"&gt;Small button&lt;/button&gt; \r\n&lt;button class="btn btn-small btn-primary" type="button"&gt;Small button&lt;/button&gt; \r\n&lt;button class="btn btn-small btn-info" type="button"&gt;Small button&lt;/button&gt; \r\n&lt;button class="btn btn-small btn-success" type="button"&gt;Small button&lt;/button&gt; \r\n&lt;button class="btn btn-small btn-warning" type="button"&gt;Small button&lt;/button&gt; \r\n&lt;button class="btn btn-small btn-danger" type="button"&gt;Small button&lt;/button&gt; \r\n&lt;button class="btn btn-small btn-inverse" type="button"&gt;Small button&lt;/button&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Mini button</h4>\r\n<p><button class="btn btn-mini" type="button">Mini button</button> <button class="btn btn-mini btn-primary" type="button">Mini button</button> <button class="btn btn-mini btn-info" type="button">Mini button</button> <button class="btn btn-mini btn-success" type="button">Mini button</button> <button class="btn btn-mini btn-warning" type="button">Mini button</button> <button class="btn btn-mini btn-danger" type="button">Mini button</button> <button class="btn btn-mini btn-inverse" type="button">Mini button</button></p>\r\n<div id="accordion4" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseFour" data-toggle="collapse" data-parent="#accordion4">How to use</a></div>\r\n<div id="collapseFour" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;button class="btn btn-mini" type="button"&gt;Mini button&lt;/button&gt; \r\n&lt;button class=&amp;quot..</code></pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Button', 'full_html'),
(14, '<h4>Labels</h4>\r\n<div class="row-fluid" style="margin-bottom: 20px;"><span class="label">Default</span> <span class="label label-success">Success</span> <span class="label label-warning">Warning</span> <span class="label label-important">Important</span> <span class="label label-info">Info</span> <span class="label label-inverse">Inverse</span></div>\r\n<div id="accordion1" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion1">How to use</a></div>\r\n<div id="collapseOne" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;span class="label"&gt;Default&lt;/span&gt;\r\n&lt;span class="label label-success"&gt;Success&lt;/span&gt;\r\n&lt;span class="label label-warning"&gt;Warning&lt;/span&gt;\r\n&lt;span class="label label-important"&gt;Important&lt;/span&gt;\r\n&lt;span class="label label-info"&gt;Info&lt;/span&gt;\r\n&lt;span class="label label-inverse"&gt;Inverse&lt;/span&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Badges</h4>\r\n<div class="row-fluid" style="margin-bottom: 20px;"><span class="badge">1</span> <span class="badge badge-success">2</span> <span class="badge badge-warning">4</span> <span class="badge badge-important">6</span> <span class="badge badge-info">8</span> <span class="badge badge-inverse">10</span></div>\r\n<div id="accordion2" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseTwo" data-toggle="collapse" data-parent="#accordion2">How to use</a></div>\r\n<div id="collapseTwo" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;span class="badge"&gt;1&lt;/span&gt;\r\n&lt;span class="badge badge-success"&gt;2&lt;/span&gt;\r\n&lt;span class="badge badge-warning"&gt;4&lt;/span&gt;\r\n&lt;span class="badge badge-important"&gt;6&lt;/span&gt;\r\n&lt;span class="badge badge-info"&gt;8&lt;/span&gt;\r\n&lt;span class="badge badge-inverse"&gt;10&lt;/span&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', ' Labels and badges', 'full_html');
INSERT INTO `block_custom` (`bid`, `body`, `info`, `format`) VALUES
(15, '<h4>Tabs</h4>\r\n<ul id="tabs" class="nav nav-tabs" data-tabs="tabs">\r\n<li class="active"><a href="#home" data-toggle="tab">Home</a></li>\r\n<li><a href="#description" data-toggle="tab">Description</a></li>\r\n<li><a href="#reviews" data-toggle="tab">Rewievs</a></li>\r\n</ul>\r\n<div id="my-tab-content" class="tab-content">\r\n<div id="home" class="tab-pane active">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rhoncus, felis quis blandit commodo, tortor magna egestas massa, eget semper massa est et quam. Nullam ut felis et quam malesuada mollis. Aenean condimentum ullamcorper quam. Curabitur quis turpis libero, eget aliquet est. Curabitur non lorem et lacus luctus ultrices. Fusce odio nisi, posuere ut fringilla in, vehicula et libero. Vivamus nisi ante, dapibus sed egestas eu, ultricies ut odio.</p>\r\n</div>\r\n<div id="description" class="tab-pane">\r\n<p>Maecenas at porta felis. Duis feugiat sagittis sodales. Aenean pretium gravida orci, sed ullamcorper arcu ultrices vitae. Suspendisse in mi lacus, vitae rhoncus arcu. Nulla tincidunt, augue at consectetur ullamcorper, justo neque congue massa, in gravida elit magna quis lectus. Fusce eu mi ante. Suspendisse potenti. In in nibh ligula, interdum dignissim lorem. Phasellus feugiat risus eu dolor mattis a elementum sem egestas.</p>\r\n</div>\r\n<div id="reviews" class="tab-pane">\r\n<p>Quisque et elit enim, eget placerat est. Phasellus vitae nunc libero. Cras pulvinar blandit neque eget tristique. Donec rutrum sollicitudin neque, non tristique augue dignissim vitae. In ornare, ante in mollis bibendum, lectus neque lobortis dui, et fringilla diam risus sed neque. Donec malesuada mattis erat ac lacinia. Aenean pellentesque placerat mollis. Etiam nec purus ante, et placerat turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi et metus quis massa suscipit molestie. Mauris magna erat, ornare vitae condimentum vel, mattis vitae odio. Ut vestibulum volutpat nulla, id bibendum orci malesuada eleifend. Quisque ornare nunc vitae mauris luctus vitae porta urna consequat. Sed ante turpis, accumsan vel facilisis id, varius id magna. Praesent posuere, tortor sit amet congue laoreet, leo odio scelerisque magna, eu tincidunt dui ligula nec urna.</p>\r\n</div>\r\n</div>\r\n\r\n<div id="accordion11" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseEleven" data-toggle="collapse" data-parent="#accordion11">How to use</a></div>\r\n<div id="collapseEleven" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;script type="text/javascript"&gt;\r\njQuery(document).ready(function($){$(''#tabs'').tab();});\r\n&lt;/script&gt;   \r\n&lt;ul id="tabs" class="nav nav-tabs" data-tabs="tabs"&gt;\r\n &lt;li class="active"&gt;&lt;a href="#home" data-toggle="tab"&gt;Home&lt;/a&gt;&lt;/li&gt;\r\n &lt;li&gt;&lt;a href="#description" data-toggle="tab"&gt;Description&lt;/a&gt;&lt;/li&gt;\r\n &lt;li&gt;&lt;a href="#reviews" data-toggle="tab"&gt;Rewievs&lt;/a&gt;&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;div id="my-tab-content" class="tab-content"&gt;\r\n &lt;div class="tab-pane active" id="home"&gt;\r\n  &lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rhoncus, felis quis blandit commodo..&lt;/p&gt;\r\n &lt;/div&gt; \r\n &lt;div class="tab-pane" id="description"&gt;\r\n  &lt;p&gt;Maecenas at porta felis. Duis feugiat sagittis sodales...&lt;/p&gt;\r\n &lt;/div&gt;\r\n &lt;div class="tab-pane" id="reviews"&gt;\r\n  &lt;p&gt;Quisque et elit enim, eget placerat est...&lt;/p&gt;\r\n &lt;/div&gt;\r\n&lt;/div&gt;\r\n</code></pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Accordion</h4>\r\n<div id="accordion2" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion2"> Collapsible Group Item #1 </a></div>\r\n<div id="collapseOne" class="accordion-body collapse in">\r\n<div class="accordion-inner">Anim pariatur cliche...</div>\r\n</div>\r\n</div>\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseTwo" data-toggle="collapse" data-parent="#accordion2"> Collapsible Group Item #2 </a></div>\r\n<div id="collapseTwo" class="accordion-body collapse">\r\n<div class="accordion-inner">Anim pariatur cliche...</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id="accordion12" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseTwelve" data-toggle="collapse" data-parent="#accordion12">How to use</a></div>\r\n<div id="collapseTwelve" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="accordion" id="accordion2"&gt;\r\n  &lt;div class="accordion-group"&gt;\r\n    &lt;div class="accordion-heading"&gt;\r\n      &lt;a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#collapseOne"&gt;\r\n        Collapsible Group Item #1\r\n      &lt;/a&gt;\r\n    &lt;/div&gt;\r\n    &lt;div id="collapseOne" class="accordion-body collapse in"&gt;\r\n      &lt;div class="accordion-inner"&gt;\r\n        Anim pariatur cliche...\r\n      &lt;/div&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n  &lt;div class="accordion-group"&gt;\r\n    &lt;div class="accordion-heading"&gt;\r\n      &lt;a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#collapseTwo"&gt;\r\n        Collapsible Group Item #2\r\n      &lt;/a&gt;\r\n    &lt;/div&gt;\r\n    &lt;div id="collapseTwo" class="accordion-body collapse"&gt;\r\n      &lt;div class="accordion-inner"&gt;\r\n        Anim pariatur cliche...\r\n      &lt;/div&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Tabs and accordion', 'full_html'),
(16, '<h4>Alert</h4>\r\n<div class="alert alert-error"><button class="close" type="button" data-dismiss="alert">×</button> <strong>Alert!</strong> Change a few things up and try submitting again.</div>\r\n<div id="accordion1" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion1">How to use</a></div>\r\n<div id="collapseOne" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="alert alert-error"&gt;\r\n&lt;button type="button" class="close" data-dismiss="alert"&gt;×&lt;/button&gt;\r\n&lt;strong&gt;Alert&lt;strong&gt;Change a few things up and try submitting again.&lt;/div&gt; \r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Success</h4>\r\n<div class="alert alert-success"><button class="close" type="button" data-dismiss="alert">×</button> <strong>Success!</strong> You successfully read this important alert message.</div>\r\n<div id="accordion2" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseTwo" data-toggle="collapse" data-parent="#accordion2">How to use</a></div>\r\n<div id="collapseTwo" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="alert alert-succes"&gt;\r\n&lt;button type="button" class="close" data-dismiss="alert"&gt;×&lt;/button&gt;\r\n&lt;strong&gt;Success!&lt;strong&gt;You successfully read this important alert message.&lt;/div&gt; \r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<h4>Info</h4>\r\n<div class="alert alert-info"><button class="close" type="button" data-dismiss="alert">×</button> <strong>Info!</strong> This alert needs your attention, but it''s not super important.</div>\r\n<div id="accordion3" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseThree" data-toggle="collapse" data-parent="#accordion3">How to use</a></div>\r\n<div id="collapseThree" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="alert alert-info"&gt;\r\n&lt;button type="button" class="close" data-dismiss="alert"&gt;×&lt;/button&gt;\r\n&lt;strong&gt;Info!&lt;strong&gt;This alert needs your attention, but it''s not super important.&lt;/div&gt; \r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Notifications', 'full_html'),
(17, '<p><a class="tooltip_link" href="#" title="Top tooltip" rel="tooltip" data-placement="top" data-toggle="tooltip">Top tooltip</a> <a class="tooltip_link" href="#" title="Right tooltip" rel="tooltip" data-placement="right" data-toggle="tooltip">Right tooltip</a> <a class="tooltip_link" href="#" title="Bottom tooltip" rel="tooltip" data-placement="bottom" data-toggle="tooltip">Bottom tooltip</a> <a class="tooltip_link" href="#" title="Left tooltip" rel="tooltip" data-placement="left" data-toggle="tooltip">Left tooltip</a></p>\r\n<div style="clear: both;"> </div>\r\n<div id="accordion2" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion2">How to use</a></div>\r\n<div id="collapseOne" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;script type=''text/javascript''&gt;\r\n     jQuery(document).ready(function () {\r\n     if (jQuery("[rel=tooltip]").length) {\r\n     jQuery("[rel=tooltip]").tooltip();\r\n     }\r\n   });\r\n  &lt;/script&gt;\r\n&lt;a class="tooltip_link" rel="tooltip" href="#" data-placement="top" data-toggle="tooltip" title="Top tooltip"&gt;Top tooltip&lt;/a&gt;\r\n&lt;a class="tooltip_link" rel="tooltip" href="#" data-placement="right" data-toggle="tooltip" title="Right tooltip"&gt;Right tooltip&lt;/a&gt;\r\n&lt;a class="tooltip_link" rel="tooltip" href="#" data-placement="bottom" data-toggle="tooltip" title="Bottom tooltip"&gt;Bottom tooltip&lt;/a&gt;\r\n&lt;a class="tooltip_link" rel="tooltip" href="#" data-placement="left" data-toggle="tooltip" title="Left tooltip"&gt;Left tooltip&lt;/a&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Tooltips', 'full_html'),
(18, ' \r\n<h3>Basic</h3>\r\n\r\n<div class="progress">\r\n  <div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;">\r\n    <span class="sr-only">60% Complete</span>\r\n  </div>\r\n</div>\r\n<div id="accordion1" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseOne" data-toggle="collapse" data-parent="#accordion1">How to use</a></div>\r\n<div id="collapseOne" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="progress"&gt;\r\n  &lt;div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;"&gt;\r\n    &lt;span class="sr-only"&gt;60% Complete&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n\r\n<br>\r\n\r\n<h3>With label</h3>\r\n\r\n<div class="progress">\r\n  <div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;">\r\n    60%\r\n  </div>\r\n</div>\r\n<div id="accordion11" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapse11" data-toggle="collapse" data-parent="#accordion11">How to use</a></div>\r\n<div id="collapse11" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n  &lt;div class="progress"&gt;\r\n    &lt;div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;"&gt;\r\n      60%\r\n   &lt;/div&gt;\r\n &lt;/div&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n\r\n<br>\r\n\r\n\r\n\r\n<h3>Contextual alternatives</h3>\r\n<div class="progress">\r\n  <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%">\r\n    <span class="sr-only">40% Complete (success)</span>\r\n  </div>\r\n</div>\r\n<div class="progress">\r\n  <div class="progress-bar progress-bar-info" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width: 20%">\r\n    <span class="sr-only">20% Complete</span>\r\n  </div>\r\n</div>\r\n<div class="progress">\r\n  <div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%">\r\n    <span class="sr-only">60% Complete (warning)</span>\r\n  </div>\r\n</div>\r\n<div class="progress">\r\n  <div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: 80%">\r\n    <span class="sr-only">80% Complete</span>\r\n  </div>\r\n</div>\r\n\r\n<div id="accordion4" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseFour" data-toggle="collapse" data-parent="#accordion4">How to use</a></div>\r\n<div id="collapseFour" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n\r\n&lt;div class="progress"&gt;\r\n  &lt;div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%"&gt;\r\n    &lt;span class="sr-only"&gt;40% Complete (success)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="progress"&gt;\r\n  &lt;div class="progress-bar progress-bar-info" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width: 20%"&gt;\r\n    &lt;span class="sr-only"&gt;20% Complete&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="progress"&gt;\r\n  &lt;div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%"&gt;\r\n    &lt;span class="sr-only"&gt;60% Complete (warning)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="progress"&gt;\r\n  &lt;div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: 80%"&gt;\r\n    &lt;span class="sr-only"&gt;80% Complete&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n\r\n<br>\r\n\r\n<h3>Striped</h3>\r\n\r\n<div class="progress progress-striped">\r\n  <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%">\r\n    <span class="sr-only">40% Complete (success)</span>\r\n  </div>\r\n</div>\r\n<div class="progress progress-striped">\r\n  <div class="progress-bar progress-bar-info" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width: 20%">\r\n    <span class="sr-only">20% Complete</span>\r\n  </div>\r\n</div>\r\n<div class="progress progress-striped">\r\n  <div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%">\r\n    <span class="sr-only">60% Complete (warning)</span>\r\n  </div>\r\n</div>\r\n<div class="progress progress-striped">\r\n  <div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: 80%">\r\n    <span class="sr-only">80% Complete (danger)</span>\r\n  </div>\r\n</div>\r\n\r\n<div id="accordion2" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseTwo" data-toggle="collapse" data-parent="#accordion2">How to use</a></div>\r\n<div id="collapseTwo" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="progress progress-striped"&gt;\r\n  &lt;div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%"&gt;\r\n    &lt;span class="sr-only"&gt;40% Complete (success)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="progress progress-striped"&gt;\r\n  &lt;div class="progress-bar progress-bar-info" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width: 20%"&gt;\r\n    &lt;span class="sr-only"&gt;20% Complete&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="progress progress-striped"&gt;\r\n  &lt;div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%"&gt;\r\n    &lt;span class="sr-only"&gt;60% Complete (warning)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="progress progress-striped"&gt;\r\n  &lt;div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: 80%"&gt;\r\n    &lt;span class="sr-only"&gt;80% Complete (danger)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n\r\n<br>\r\n\r\n<h3>Animated</h3>\r\n<div class="progress progress-striped active">\r\n  <div class="progress-bar" role="progressbar" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 45%">\r\n    <span class="sr-only">45% Complete</span>\r\n  </div>\r\n</div>\r\n\r\n<div id="accordion3" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseThree" data-toggle="collapse" data-parent="#accordion3">How to use</a></div>\r\n<div id="collapseThree" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="progress progress-striped active"&gt;\r\n  &lt;div class="progress-bar"  role="progressbar" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 45%"&gt;\r\n    &lt;span class="sr-only"&gt;45% Complete&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n\r\n<br>\r\n\r\n<h3>Stacked</h3>\r\n\r\n<div class="progress">\r\n  <div class="progress-bar progress-bar-success" style="width: 35%">\r\n    <span class="sr-only">35% Complete (success)</span>\r\n  </div>\r\n  <div class="progress-bar progress-bar-warning" style="width: 20%">\r\n    <span class="sr-only">20% Complete (warning)</span>\r\n  </div>\r\n  <div class="progress-bar progress-bar-danger" style="width: 10%">\r\n    <span class="sr-only">10% Complete (danger)</span>\r\n  </div>\r\n</div>\r\n\r\n<div id="accordion5" class="accordion">\r\n<div class="accordion-group">\r\n<div class="accordion-heading"><a class="accordion-toggle" href="#collapseFive" data-toggle="collapse" data-parent="#accordion5">How to use</a></div>\r\n<div id="collapseFive" class="accordion-body collapse">\r\n<div class="accordion-inner">\r\n<pre><code>\r\n&lt;div class="progress"&gt;\r\n  &lt;div class="progress-bar progress-bar-success" style="width: 35%"&gt;\r\n    &lt;span class="sr-only"&gt;35% Complete (success)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n  &lt;div class="progress-bar progress-bar-warning" style="width: 20%"&gt;\r\n    &lt;span class="sr-only"&gt;20% Complete (warning)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n  &lt;div class="progress-bar progress-bar-danger" style="width: 10%"&gt;\r\n    &lt;span class="sr-only"&gt;10% Complete (danger)&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</code>\r\n</pre>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Progress bare', 'full_html'),
(21, '<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque la udantium, totam rem aperiam, eaque&nbsp;<sed ut="" perspi<="" p="">\r\n</sed></p><p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque la udantium, totam rem aperiam, eaque&nbsp;<sed ut="" perspi<="" p="">\r\n</sed></p><p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque la udantium, totam rem aperiam, eaque&nbsp;<sed ut="" perspi<="" p="">\r\n</sed></p><p><i class="fa fa-map-marker"></i>&nbsp; 125 Worth Street, New York</p>\r\n<p><i class="fa fa-phone"></i>&nbsp; Phone: 974 356 879</p>\r\n<p><i class="fa fa-print"></i>&nbsp; Fax: 413 546 789<br></p>', 'CONTACT INFO', 'full_html'),
(22, '<div class="buttonBox container">\r\n<br>\r\n<h1><font face="roboto">START YOUR BUSINESS</font></h1>\r\n<a href="#">Get Started</a>\r\n<br>\r\n</div>', 'Get started button', 'full_html'),
(25, '<iframe marginheight="0" marginwidth="0" src="https://maps.google.com.ua/maps?f=q&amp;source=s_q&amp;hl=uk&amp;geocode=&amp;q=New+York,+NY,+United+States&amp;aq=0&amp;oq=n&amp;sll=50.074098,35.877824&amp;sspn=0.442452,1.352692&amp;ie=UTF8&amp;hq=&amp;hnear=%D0%9D%D1%8C%D1%8E-%D0%99%D0%BE%D1%80%D0%BA,+%D0%A1%D0%BF%D0%BE%D0%BB%D1%83%D1%87%D0%B5%D0%BD%D1%96+%D0%A8%D1%82%D0%B0%D1%82%D0%B8+%D0%90%D0%BC%D0%B5%D1%80%D0%B8%D0%BA%D0%B8&amp;ll=40.714353,-74.005973&amp;spn=0.016329,0.042272&amp;t=m&amp;z=14&amp;output=embed" frameborder="0" height="400" scrolling="no" width="100%"></iframe>\r\n', 'map block', 'full_html'),
(37, 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.', 'SidebarRight', 'full_html'),
(38, '<pre class="tw-data-text vk_txt tw-ta tw-text-small" data-placeholder="Перевод" id="tw-target-text" data-fulltext="" dir="ltr" style="unicode-bidi: -webkit-isolate; border-style: none; padding-right: 0.14em; position: relative; margin-top: 0px; margin-bottom: 0px; resize: none; font-family: inherit; overflow: hidden; width: 237.5px; word-wrap: break-word; color: rgb(33, 33, 33); height: 48px; font-size: 16px !important; line-height: 24px !important;"><a href="http://ordasoft.com/" title="http://ordasoft.com/" target="">More information you can find here to see prices</a></pre>', 'First news', 'full_html'),
(39, '<div class="header_contacts">\r\n<p><i class="fa fa-phone"></i>Phone: 974 356 879</p>\r\n<p><i class="fa fa-print"></i>Fax: 413 546 789</p>\r\n<p><i class="fa fa-comment"></i>http://ordasoft.com/drupal-themes</p>\r\n</div>', 'Second news', 'full_html'),
(40, 'interesting and helpful website design for Drupal', 'Drupal', 'filtered_html'),
(41, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum\r\n<div class="row">\r\n    <div class="col-lg-6 first">\r\n        <a class="btn btn-primary" href="#">read more</a>\r\n    </div>\r\n    <div class="col-lg-6 last">\r\n        <a class="btn btn-primary" href="#">read more</a>\r\n    </div>\r\n</div>', 'my skills', 'full_html');

-- --------------------------------------------------------

--
-- Структура таблицы `block_node_type`
--

DROP TABLE IF EXISTS `block_node_type`;
CREATE TABLE IF NOT EXISTS `block_node_type` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type from node_type.type.',
  PRIMARY KEY (`module`,`delta`,`type`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up display criteria for blocks based on content types';

--
-- Дамп данных таблицы `block_node_type`
--

INSERT INTO `block_node_type` (`module`, `delta`, `type`) VALUES
('cck_blocks', 'field_img', 'test_block_portfolio'),
('cck_blocks', 'field_imge', 'test_block_portfolio'),
('views', 'image_gallery-block_1', 'test_block_portfolio'),
('views', 'test-block_1', 'test_block_portfolio');

-- --------------------------------------------------------

--
-- Структура таблицы `block_role`
--

DROP TABLE IF EXISTS `block_role`;
CREATE TABLE IF NOT EXISTS `block_role` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `rid` int(10) unsigned NOT NULL COMMENT 'The user’s role ID from users_roles.rid.',
  PRIMARY KEY (`module`,`delta`,`rid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up access permissions for blocks based on user roles';

-- --------------------------------------------------------

--
-- Структура таблицы `cache`
--

DROP TABLE IF EXISTS `cache`;
CREATE TABLE IF NOT EXISTS `cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

--
-- Дамп данных таблицы `cache`
--



--
-- Структура таблицы `cache_admin_menu`
--

DROP TABLE IF EXISTS `cache_admin_menu`;
CREATE TABLE IF NOT EXISTS `cache_admin_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for Administration menu to store client-side...';

--
-- Дамп данных таблицы `cache_admin_menu`
--


--
-- Структура таблицы `cache_block`
--

DROP TABLE IF EXISTS `cache_block`;
CREATE TABLE IF NOT EXISTS `cache_block` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Block module to store already built...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_bootstrap`
--

DROP TABLE IF EXISTS `cache_bootstrap`;
CREATE TABLE IF NOT EXISTS `cache_bootstrap` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for data required to bootstrap Drupal, may be...';

--
-- Дамп данных таблицы `cache_bootstrap`
--



--
-- Структура таблицы `cache_field`
--

DROP TABLE IF EXISTS `cache_field`;
CREATE TABLE IF NOT EXISTS `cache_field` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

--
-- Дамп данных таблицы `cache_field`
--



--
-- Структура таблицы `cache_file_styles`
--

DROP TABLE IF EXISTS `cache_file_styles`;
CREATE TABLE IF NOT EXISTS `cache_file_styles` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information file manipulations...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_filter`
--

DROP TABLE IF EXISTS `cache_filter`;
CREATE TABLE IF NOT EXISTS `cache_filter` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Filter module to store already...';

--
-- Дамп данных таблицы `cache_filter`
--



--
-- Структура таблицы `cache_form`
--

DROP TABLE IF EXISTS `cache_form`;
CREATE TABLE IF NOT EXISTS `cache_form` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the form system to store recently built...';

--
-- Дамп данных таблицы `cache_form`
--



--
-- Структура таблицы `cache_image`
--

DROP TABLE IF EXISTS `cache_image`;
CREATE TABLE IF NOT EXISTS `cache_image` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about image...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_libraries`
--

DROP TABLE IF EXISTS `cache_libraries`;
CREATE TABLE IF NOT EXISTS `cache_libraries` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table to store library information.';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_location`
--

DROP TABLE IF EXISTS `cache_location`;
CREATE TABLE IF NOT EXISTS `cache_location` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `headers` text COMMENT 'Any custom HTTP headers to be added to cached data.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_media_xml`
--

DROP TABLE IF EXISTS `cache_media_xml`;
CREATE TABLE IF NOT EXISTS `cache_media_xml` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the the results of retreived XML...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_menu`
--

DROP TABLE IF EXISTS `cache_menu`;
CREATE TABLE IF NOT EXISTS `cache_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the menu system to store router...';

--
-- Дамп данных таблицы `cache_menu`
--



--
-- Структура таблицы `cache_page`
--

DROP TABLE IF EXISTS `cache_page`;
CREATE TABLE IF NOT EXISTS `cache_page` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store compressed pages for anonymous...';

--
-- Дамп данных таблицы `cache_page`
--



--
-- Структура таблицы `cache_path`
--

DROP TABLE IF EXISTS `cache_path`;
CREATE TABLE IF NOT EXISTS `cache_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for path alias lookup.';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_styles`
--

DROP TABLE IF EXISTS `cache_styles`;
CREATE TABLE IF NOT EXISTS `cache_styles` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information display...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_update`
--

DROP TABLE IF EXISTS `cache_update`;
CREATE TABLE IF NOT EXISTS `cache_update` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Update module to store information...';

--
-- Дамп данных таблицы `cache_update`
--



--
-- Структура таблицы `cache_views`
--

DROP TABLE IF EXISTS `cache_views`;
CREATE TABLE IF NOT EXISTS `cache_views` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

--
-- Дамп данных таблицы `cache_views`
--



--
-- Структура таблицы `cache_views_data`
--

DROP TABLE IF EXISTS `cache_views_data`;
CREATE TABLE IF NOT EXISTS `cache_views_data` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for views to store pre-rendered queries,...';

-- --------------------------------------------------------

--
-- Структура таблицы `cache_widgets`
--

DROP TABLE IF EXISTS `cache_widgets`;
CREATE TABLE IF NOT EXISTS `cache_widgets` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about widgets...';

-- --------------------------------------------------------

--
-- Структура таблицы `comment`
--

DROP TABLE IF EXISTS `comment`;
CREATE TABLE IF NOT EXISTS `comment` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique comment ID.',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid to which this comment is a reply.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid who authored the comment. If set to 0, this comment was created by an anonymous user.',
  `subject` varchar(64) NOT NULL DEFAULT '' COMMENT 'The comment title.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The author’s host name.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was created, as a Unix timestamp.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was last edited, as a Unix timestamp.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The published status of a comment. (0 = Not Published, 1 = Published)',
  `thread` varchar(255) NOT NULL COMMENT 'The vancode representation of the comment’s place in a thread.',
  `name` varchar(60) DEFAULT NULL COMMENT 'The comment author’s name. Uses users.name if the user is logged in, otherwise uses the value typed into the comment form.',
  `mail` varchar(64) DEFAULT NULL COMMENT 'The comment author’s e-mail address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `homepage` varchar(255) DEFAULT NULL COMMENT 'The comment author’s home page address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this comment.',
  PRIMARY KEY (`cid`),
  KEY `comment_status_pid` (`pid`,`status`),
  KEY `comment_num_new` (`nid`,`status`,`created`,`cid`,`thread`),
  KEY `comment_uid` (`uid`),
  KEY `comment_nid_language` (`nid`,`language`),
  KEY `comment_created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores comments and associated data.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `contact`
--

DROP TABLE IF EXISTS `contact`;
CREATE TABLE IF NOT EXISTS `contact` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique category ID.',
  `category` varchar(255) NOT NULL DEFAULT '' COMMENT 'Category name.',
  `recipients` longtext NOT NULL COMMENT 'Comma-separated list of recipient e-mail addresses.',
  `reply` longtext NOT NULL COMMENT 'Text of the auto-reply message.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The category’s weight.',
  `selected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether or not category is selected by default. (1 = Yes, 0 = No)',
  `page_title` text,
  `page_info` longtext,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `category` (`category`),
  KEY `list` (`weight`,`category`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contact form category settings.' AUTO_INCREMENT=2 ;

--
-- Дамп данных таблицы `contact`
--

INSERT INTO `contact` (`cid`, `category`, `recipients`, `reply`, `weight`, `selected`, `page_title`, `page_info`) VALUES
(1, 'Website feedback', 'photographer@mail.com', '', 0, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `ctools_access_ruleset`
--

DROP TABLE IF EXISTS `ctools_access_ruleset`;
CREATE TABLE IF NOT EXISTS `ctools_access_ruleset` (
  `rsid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'A database primary key to ensure uniqueness',
  `name` varchar(255) DEFAULT NULL COMMENT 'Unique ID for this ruleset. Used to identify it programmatically.',
  `admin_title` varchar(255) DEFAULT NULL COMMENT 'Administrative title for this ruleset.',
  `admin_description` longtext COMMENT 'Administrative description for this ruleset.',
  `requiredcontexts` longtext COMMENT 'Any required contexts for this ruleset.',
  `contexts` longtext COMMENT 'Any embedded contexts for this ruleset.',
  `relationships` longtext COMMENT 'Any relationships for this ruleset.',
  `access` longtext COMMENT 'The actual group of access plugins for this ruleset.',
  PRIMARY KEY (`rsid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains exportable customized access rulesets.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `ctools_css_cache`
--

DROP TABLE IF EXISTS `ctools_css_cache`;
CREATE TABLE IF NOT EXISTS `ctools_css_cache` (
  `cid` varchar(128) NOT NULL COMMENT 'The CSS ID this cache object belongs to.',
  `filename` varchar(255) DEFAULT NULL COMMENT 'The filename this CSS is stored in.',
  `css` longtext COMMENT 'CSS being stored.',
  `filter` tinyint(4) DEFAULT NULL COMMENT 'Whether or not this CSS needs to be filtered.',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store CSS that must be non-volatile.';

--
-- Дамп данных таблицы `ctools_css_cache`
--

INSERT INTO `ctools_css_cache` (`cid`, `filename`, `css`, `filter`) VALUES
('flexiblev2:16', 'public://ctools/css/0e69963ffb2eec1001cba4542ff3ff5b.css', '.panels-flexible-region {\n  padding: 0;\n}\n\n.panels-flexible-region-inside {\n  padding-right: 0.5em;\n  padding-left: 0.5em;\n}\n\n.panels-flexible-region-inside-first {\n  padding-left: 0;\n}\n\n.panels-flexible-region-inside-last {\n  padding-right: 0;\n}\n\n.panels-flexible-column {\n  padding: 0;\n}\n\n.panels-flexible-column-inside {\n  padding-right: 0.5em;\n  padding-left: 0.5em;\n}\n\n.panels-flexible-column-inside-first {\n  padding-left: 0;\n}\n\n.panels-flexible-column-inside-last {\n  padding-right: 0;\n}\n\n.panels-flexible-row {\n  padding: 0 0 0.5em 0;\n  margin: 0;\n}\n\n.panels-flexible-row-last {\n  padding-bottom: 0;\n}\n\n.panels-flexible-column-16-main {\n  float: left;\n  width: 99.0000%;\n}\n\n.panels-flexible-16-inside {\n  padding-right: 0px;\n}\n\n.panels-flexible-16 {\n  width: auto;\n}\n\n.panels-flexible-region-16-center {\n  float: left;\n  width: 99.0000%;\n}\n\n.panels-flexible-row-16-main-row-inside {\n  padding-right: 0px;\n}\n\n', 0);

-- --------------------------------------------------------

--
-- Структура таблицы `ctools_custom_content`
--

DROP TABLE IF EXISTS `ctools_custom_content`;
CREATE TABLE IF NOT EXISTS `ctools_custom_content` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'A database primary key to ensure uniqueness',
  `name` varchar(255) DEFAULT NULL COMMENT 'Unique ID for this content. Used to identify it programmatically.',
  `admin_title` varchar(255) DEFAULT NULL COMMENT 'Administrative title for this content.',
  `admin_description` longtext COMMENT 'Administrative description for this content.',
  `category` varchar(255) DEFAULT NULL COMMENT 'Administrative category for this content.',
  `settings` longtext COMMENT 'Serialized settings for the actual content to be used',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains exportable customized content for this site.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `ctools_object_cache`
--

DROP TABLE IF EXISTS `ctools_object_cache`;
CREATE TABLE IF NOT EXISTS `ctools_object_cache` (
  `sid` varchar(64) NOT NULL COMMENT 'The session ID this cache object belongs to.',
  `name` varchar(128) NOT NULL COMMENT 'The name of the object this cache is attached to.',
  `obj` varchar(32) NOT NULL COMMENT 'The type of the object this cache is attached to; this essentially represents the owner so that several sub-systems can use this cache.',
  `updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The time this cache was created or updated.',
  `data` longblob COMMENT 'Serialized data being stored.',
  PRIMARY KEY (`sid`,`obj`,`name`),
  KEY `updated` (`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store objects that are being...';

--
-- Дамп данных таблицы `ctools_object_cache`
--

INSERT INTO `ctools_object_cache` (`sid`, `name`, `obj`, `updated`, `data`) VALUES
('1aizLE5nNEYaPlVDW1Bj28kWzwBe8HQjS9X0LnkJ9eg', 'page-about_us', 'page_manager_page', 1411485416, 0x4f3a383a22737464436c617373223a31343a7b733a333a226e6577223b623a313b733a393a227461736b5f6e616d65223b733a31333a22706167652d61626f75745f7573223b733a373a227461736b5f6964223b733a343a2270616765223b733a343a227461736b223b613a32353a7b733a353a227469746c65223b733a31323a22437573746f6d207061676573223b733a31313a226465736372697074696f6e223b733a3130333a2241646d696e6973747261746f7220637265617465642070616765732074686174206861766520612055524c20706174682c2061636365737320636f6e74726f6c20616e6420656e747269657320696e207468652044727570616c206d656e752073797374656d2e223b733a31343a226e6f6e2d6578706f727461626c65223b623a313b733a383a227375627461736b73223b623a313b733a31363a227375627461736b2063616c6c6261636b223b733a32353a22706167655f6d616e616765725f706167655f7375627461736b223b733a31373a227375627461736b732063616c6c6261636b223b733a32363a22706167655f6d616e616765725f706167655f7375627461736b73223b733a32313a2273617665207375627461736b2063616c6c6261636b223b733a33303a22706167655f6d616e616765725f706167655f736176655f7375627461736b223b733a31353a226163636573732063616c6c6261636b223b733a33303a22706167655f6d616e616765725f706167655f6163636573735f636865636b223b733a393a22686f6f6b206d656e75223b613a333a7b733a343a2266696c65223b733a31343a22706167652e61646d696e2e696e63223b733a343a2270617468223b733a35313a2273697465732f616c6c2f6d6f64756c65732f63746f6f6c732f706167655f6d616e616765722f706c7567696e732f7461736b73223b733a383a2266756e6374696f6e223b733a32323a22706167655f6d616e616765725f706167655f6d656e75223b7d733a31303a22686f6f6b207468656d65223b733a32333a22706167655f6d616e616765725f706167655f7468656d65223b733a393a227461736b2074797065223b733a343a2270616765223b733a31353a2270616765206f7065726174696f6e73223b613a313a7b693a303b613a333a7b733a353a227469746c65223b733a32363a222026726171756f3b204372656174652061206e65772070616765223b733a343a2268726566223b733a32353a2261646d696e2f7374727563747572652f70616765732f616464223b733a343a2268746d6c223b623a313b7d7d733a373a22636f6c756d6e73223b613a313a7b733a373a2273746f72616765223b613a323a7b733a353a226c6162656c223b733a373a2253746f72616765223b733a353a22636c617373223b733a32353a22706167652d6d616e616765722d706167652d73746f72616765223b7d7d733a393a22706167652074797065223b733a363a22637573746f6d223b733a31323a2268616e646c65722074797065223b733a373a22636f6e74657874223b733a31333a2267657420617267756d656e7473223b613a333a7b733a343a2266696c65223b733a31343a22706167652e61646d696e2e696e63223b733a343a2270617468223b733a35313a2273697465732f616c6c2f6d6f64756c65732f63746f6f6c732f706167655f6d616e616765722f706c7567696e732f7461736b73223b733a383a2266756e6374696f6e223b733a33313a22706167655f6d616e616765725f706167655f6765745f617267756d656e7473223b7d733a32343a2267657420636f6e7465787420706c616365686f6c64657273223b733a33303a22706167655f6d616e616765725f706167655f6765745f636f6e7465787473223b733a31393a22616363657373207265737472696374696f6e73223b733a33373a22706167655f6d616e616765725f706167655f6163636573735f7265737472696374696f6e73223b733a31333a22757365732068616e646c657273223b623a313b733a363a226d6f64756c65223b733a31323a22706167655f6d616e61676572223b733a343a226e616d65223b733a343a2270616765223b733a343a2270617468223b733a35313a2273697465732f616c6c2f6d6f64756c65732f63746f6f6c732f706167655f6d616e616765722f706c7567696e732f7461736b73223b733a343a2266696c65223b733a383a22706167652e696e63223b733a31333a22706c7567696e206d6f64756c65223b733a31323a22706167655f6d616e61676572223b733a31313a22706c7567696e2074797065223b733a353a227461736b73223b7d733a31303a227375627461736b5f6964223b733a383a2261626f75745f7573223b733a373a227375627461736b223b613a31343a7b733a343a226e616d65223b4e3b733a31313a2261646d696e207469746c65223b733a383a2241626f7574205573223b733a31373a2261646d696e206465736372697074696f6e223b733a303a22223b733a31333a2261646d696e2073756d6d617279223b733a33313a22706167655f6d616e616765725f706167655f61646d696e5f73756d6d617279223b733a31303a2261646d696e2070617468223b4e3b733a31303a2261646d696e2074797065223b733a363a22437573746f6d223b733a373a227375627461736b223b4f3a383a22737464436c617373223a31333a7b733a333a22706964223b4e3b733a343a226e616d65223b733a383a2261626f75745f7573223b733a343a227461736b223b733a343a2270616765223b733a31313a2261646d696e5f7469746c65223b733a383a2241626f7574205573223b733a31373a2261646d696e5f6465736372697074696f6e223b733a303a22223b733a343a2270617468223b733a383a2241626f7574205573223b733a363a22616363657373223b613a303a7b7d733a343a226d656e75223b613a303a7b7d733a393a22617267756d656e7473223b613a303a7b7d733a343a22636f6e66223b613a313a7b733a31313a2261646d696e5f7061746873223b623a303b7d733a31313a226578706f72745f74797065223b693a313b733a343a2274797065223b733a363a224e6f726d616c223b733a31343a226d616b655f66726f6e7470616765223b623a303b7d733a31303a226f7065726174696f6e73223b613a323a7b733a383a2273657474696e6773223b613a343a7b733a343a2274797065223b733a353a2267726f7570223b733a353a22636c617373223b613a313a7b693a303b733a31393a226f7065726174696f6e732d73657474696e6773223b7d733a353a227469746c65223b733a383a2253657474696e6773223b733a383a226368696c6472656e223b613a333a7b733a353a226261736963223b613a333a7b733a353a227469746c65223b733a353a224261736963223b733a31313a226465736372697074696f6e223b733a35343a2245646974206e616d652c207061746820616e64206f746865722062617369632073657474696e677320666f722074686520706167652e223b733a343a22666f726d223b733a32383a22706167655f6d616e616765725f706167655f666f726d5f6261736963223b7d733a363a22616363657373223b613a343a7b733a353a227469746c65223b733a363a22416363657373223b733a31313a226465736372697074696f6e223b733a34303a22436f6e74726f6c20776861742075736572732063616e20616363657373207468697320706167652e223b733a31373a2261646d696e206465736372697074696f6e223b733a3130363a224163636573732072756c657320617265207573656420746f20746573742069662074686520706167652069732061636365737369626c6520616e6420616e79206d656e75206974656d73206173736f6369617465642077697468206974206172652076697369626c652e223b733a343a22666f726d223b733a32393a22706167655f6d616e616765725f706167655f666f726d5f616363657373223b7d733a343a226d656e75223b613a333a7b733a353a227469746c65223b733a343a224d656e75223b733a31313a226465736372697074696f6e223b733a34373a2250726f766964652074686973207061676520612076697369626c65206d656e75206f722061206d656e75207461622e223b733a343a22666f726d223b733a32373a22706167655f6d616e616765725f706167655f666f726d5f6d656e75223b7d7d7d733a373a22616374696f6e73223b613a313a7b733a383a226368696c6472656e223b613a333a7b733a353a22636c6f6e65223b613a333a7b733a353a227469746c65223b733a353a22436c6f6e65223b733a31313a226465736372697074696f6e223b733a32343a224d616b65206120636f7079206f6620746869732070616765223b733a343a22666f726d223b733a32383a22706167655f6d616e616765725f706167655f666f726d5f636c6f6e65223b7d733a363a226578706f7274223b613a333a7b733a353a227469746c65223b733a363a224578706f7274223b733a31313a226465736372697074696f6e223b733a37323a224578706f72742074686973207061676520617320636f646520746861742063616e20626520696d706f72746564206f7220656d62656464656420696e746f2061206d6f64756c652e223b733a343a22666f726d223b733a32393a22706167655f6d616e616765725f706167655f666f726d5f6578706f7274223b7d733a363a2264656c657465223b613a333a7b733a353a227469746c65223b733a363a2244656c657465223b733a31313a226465736372697074696f6e223b733a34353a2252656d6f7665207468697320706167652066726f6d20796f75722073797374656d20636f6d706c6574656c792e223b733a343a22666f726d223b733a32393a22706167655f6d616e616765725f706167655f666f726d5f64656c657465223b7d7d7d7d733a31383a226f7065726174696f6e7320696e636c756465223b613a323a7b733a343a2266696c65223b733a31343a22706167652e61646d696e2e696e63223b733a343a2270617468223b733a35313a2273697465732f616c6c2f6d6f64756c65732f63746f6f6c732f706167655f6d616e616765722f706c7567696e732f7461736b73223b7d733a31313a2273696e676c65207461736b223b623a313b733a393a22726f7720636c617373223b733a32303a22706167652d6d616e616765722d656e61626c6564223b733a373a2273746f72616765223b733a363a224e6f726d616c223b733a383a2264697361626c6564223b623a303b733a31353a22656e61626c652063616c6c6261636b223b733a32343a22706167655f6d616e616765725f706167655f656e61626c65223b7d733a383a2268616e646c657273223b613a313a7b733a32373a22706167655f61626f75745f75735f70616e656c5f636f6e74657874223b4f3a383a22737464436c617373223a393a7b733a353a227469746c65223b733a353a2250616e656c223b733a343a227461736b223b733a343a2270616765223b733a373a227375627461736b223b733a383a2261626f75745f7573223b733a343a226e616d65223b733a32373a22706167655f61626f75745f75735f70616e656c5f636f6e74657874223b733a373a2268616e646c6572223b733a31333a2270616e656c5f636f6e74657874223b733a363a22776569676874223b693a303b733a343a22636f6e66223b613a31303a7b733a353a227469746c65223b733a353a2250616e656c223b733a393a226e6f5f626c6f636b73223b693a303b733a383a22706970656c696e65223b733a383a227374616e64617264223b733a32323a22626f64795f636c61737365735f746f5f72656d6f7665223b733a303a22223b733a31393a22626f64795f636c61737365735f746f5f616464223b733a303a22223b733a363a226373735f6964223b733a303a22223b733a333a22637373223b733a303a22223b733a383a22636f6e7465787473223b613a303a7b7d733a31333a2272656c6174696f6e7368697073223b613a303a7b7d733a373a22646973706c6179223b4f3a31343a2270616e656c735f646973706c6179223a31363a7b733a343a2261726773223b613a303a7b7d733a373a22636f6e74656e74223b613a303a7b7d733a363a2270616e656c73223b613a313a7b733a363a2263656e746572223b613a303a7b7d7d733a31363a22696e636f6d696e675f636f6e74656e74223b4e3b733a363a226373735f6964223b4e3b733a373a22636f6e74657874223b613a303a7b7d733a333a22646964223b733a333a226e6577223b733a383a2272656e6465726572223b733a383a227374616e64617264223b733a363a226c61796f7574223b733a383a22666c657869626c65223b733a31353a226c61796f75745f73657474696e6773223b613a303a7b7d733a31343a2270616e656c5f73657474696e6773223b613a313a7b733a31343a227374796c655f73657474696e6773223b613a323a7b733a373a2264656661756c74223b4e3b733a363a2263656e746572223b4e3b7d7d733a353a226361636865223b613a303a7b7d733a353a227469746c65223b733a303a22223b733a31303a22686964655f7469746c65223b733a313a2230223b733a31303a227469746c655f70616e65223b693a303b733a393a2263616368655f6b6579223b733a35353a2270616e656c5f636f6e746578743a706167652d61626f75745f75733a706167655f61626f75745f75735f70616e656c5f636f6e74657874223b7d7d733a31313a226578706f72745f74797065223b693a313b733a343a2274797065223b733a363a224e6f726d616c223b7d7d733a31323a2268616e646c65725f696e666f223b613a313a7b733a32373a22706167655f61626f75745f75735f70616e656c5f636f6e74657874223b613a333a7b733a363a22776569676874223b693a303b733a343a226e616d65223b733a32373a22706167655f61626f75745f75735f70616e656c5f636f6e74657874223b733a373a226368616e676564223b693a323b7d7d733a363a226c6f636b6564223b623a303b733a373a226368616e676564223b623a313b733a373a2268616e646c6572223b733a31333a2270616e656c5f636f6e74657874223b733a353a22666f726d73223b613a343a7b693a303b733a353a226261736963223b693a313b733a363a2263686f6f7365223b693a323b733a383a2273657474696e6773223b693a333b733a373a22636f6e74656e74223b7d733a31323a22706174685f6368616e676564223b623a313b733a31333a22646973706c61795f6361636865223b613a303a7b7d7d),
('1aizLE5nNEYaPlVDW1Bj28kWzwBe8HQjS9X0LnkJ9eg', 'page-faqs', 'page_manager_page', 1411485265, 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),
('vPIoGd955OSqUMDaL41schWsHuLqrTX5miwKKoeyTcc', 'page-test', 'page_manager_page', 1411473617, 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);

-- --------------------------------------------------------

--
-- Структура таблицы `date_formats`
--

DROP TABLE IF EXISTS `date_formats`;
CREATE TABLE IF NOT EXISTS `date_formats` (
  `dfid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The date format identifier.',
  `format` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this format can be modified.',
  PRIMARY KEY (`dfid`),
  UNIQUE KEY `formats` (`format`,`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats.' AUTO_INCREMENT=36 ;

--
-- Дамп данных таблицы `date_formats`
--

INSERT INTO `date_formats` (`dfid`, `format`, `type`, `locked`) VALUES
(1, 'Y-m-d H:i', 'short', 1),
(2, 'm/d/Y - H:i', 'short', 1),
(3, 'd/m/Y - H:i', 'short', 1),
(4, 'Y/m/d - H:i', 'short', 1),
(5, 'd.m.Y - H:i', 'short', 1),
(6, 'm/d/Y - g:ia', 'short', 1),
(7, 'd/m/Y - g:ia', 'short', 1),
(8, 'Y/m/d - g:ia', 'short', 1),
(9, 'M j Y - H:i', 'short', 1),
(10, 'j M Y - H:i', 'short', 1),
(11, 'Y M j - H:i', 'short', 1),
(12, 'M j Y - g:ia', 'short', 1),
(13, 'j M Y - g:ia', 'short', 1),
(14, 'Y M j - g:ia', 'short', 1),
(15, 'D, Y-m-d H:i', 'medium', 1),
(16, 'D, m/d/Y - H:i', 'medium', 1),
(17, 'D, d/m/Y - H:i', 'medium', 1),
(18, 'D, Y/m/d - H:i', 'medium', 1),
(19, 'F j, Y - H:i', 'medium', 1),
(20, 'j F, Y - H:i', 'medium', 1),
(21, 'Y, F j - H:i', 'medium', 1),
(22, 'D, m/d/Y - g:ia', 'medium', 1),
(23, 'D, d/m/Y - g:ia', 'medium', 1),
(24, 'D, Y/m/d - g:ia', 'medium', 1),
(25, 'F j, Y - g:ia', 'medium', 1),
(26, 'j F Y - g:ia', 'medium', 1),
(27, 'Y, F j - g:ia', 'medium', 1),
(28, 'j. F Y - G:i', 'medium', 1),
(29, 'l, F j, Y - H:i', 'long', 1),
(30, 'l, j F, Y - H:i', 'long', 1),
(31, 'l, Y,  F j - H:i', 'long', 1),
(32, 'l, F j, Y - g:ia', 'long', 1),
(33, 'l, j F Y - g:ia', 'long', 1),
(34, 'l, Y,  F j - g:ia', 'long', 1),
(35, 'l, j. F Y - G:i', 'long', 1);

-- --------------------------------------------------------

--
-- Структура таблицы `date_format_locale`
--

DROP TABLE IF EXISTS `date_format_locale`;
CREATE TABLE IF NOT EXISTS `date_format_locale` (
  `format` varchar(100) NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `language` varchar(12) NOT NULL COMMENT 'A languages.language for this format to be used with.',
  PRIMARY KEY (`type`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats for each locale.';

-- --------------------------------------------------------

--
-- Структура таблицы `date_format_type`
--

DROP TABLE IF EXISTS `date_format_type`;
CREATE TABLE IF NOT EXISTS `date_format_type` (
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `title` varchar(255) NOT NULL COMMENT 'The human readable name of the format type.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this is a system provided format.',
  PRIMARY KEY (`type`),
  KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date format types.';

--
-- Дамп данных таблицы `date_format_type`
--

INSERT INTO `date_format_type` (`type`, `title`, `locked`) VALUES
('long', 'Long', 1),
('medium', 'Medium', 1),
('short', 'Short', 1);

-- --------------------------------------------------------

--
-- Структура таблицы `field_config`
--

DROP TABLE IF EXISTS `field_config`;
CREATE TABLE IF NOT EXISTS `field_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field',
  `field_name` varchar(32) NOT NULL COMMENT 'The name of this field. Non-deleted field names are unique, but multiple deleted fields can have the same name.',
  `type` varchar(128) NOT NULL COMMENT 'The type of this field.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the field type.',
  `active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the field type is enabled.',
  `storage_type` varchar(128) NOT NULL COMMENT 'The storage backend for the field.',
  `storage_module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the storage backend.',
  `storage_active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the storage backend is enabled.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT '@TODO',
  `data` longblob NOT NULL COMMENT 'Serialized data containing the field properties that do not warrant a dedicated column.',
  `cardinality` tinyint(4) NOT NULL DEFAULT '0',
  `translatable` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name` (`field_name`),
  KEY `active` (`active`),
  KEY `storage_active` (`storage_active`),
  KEY `deleted` (`deleted`),
  KEY `module` (`module`),
  KEY `storage_module` (`storage_module`),
  KEY `type` (`type`),
  KEY `storage_type` (`storage_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=118 ;

--
-- Дамп данных таблицы `field_config`
--

INSERT INTO `field_config` (`id`, `field_name`, `type`, `module`, `active`, `storage_type`, `storage_module`, `storage_active`, `locked`, `data`, `cardinality`, `translatable`, `deleted`) VALUES
(1, 'comment_body', 'text_long', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a373a22636f6d6d656e74223b7d733a31323a227472616e736c617461626c65223b733a313a2230223b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32333a226669656c645f646174615f636f6d6d656e745f626f6479223b613a323a7b733a353a2276616c7565223b733a31383a22636f6d6d656e745f626f64795f76616c7565223b733a363a22666f726d6174223b733a31393a22636f6d6d656e745f626f64795f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a32373a226669656c645f7265766973696f6e5f636f6d6d656e745f626f6479223b613a323a7b733a353a2276616c7565223b733a31383a22636f6d6d656e745f626f64795f76616c7565223b733a363a22666f726d6174223b733a31393a22636f6d6d656e745f626f64795f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a313a2231223b7d, 1, 0, 0),
(2, 'body', 'text_with_summary', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a343a226e6f6465223b7d733a31323a227472616e736c617461626c65223b733a313a2230223b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a31353a226669656c645f646174615f626f6479223b613a333a7b733a353a2276616c7565223b733a31303a22626f64795f76616c7565223b733a373a2273756d6d617279223b733a31323a22626f64795f73756d6d617279223b733a363a22666f726d6174223b733a31313a22626f64795f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a31393a226669656c645f7265766973696f6e5f626f6479223b613a333a7b733a353a2276616c7565223b733a31303a22626f64795f76616c7565223b733a373a2273756d6d617279223b733a31323a22626f64795f73756d6d617279223b733a363a22666f726d6174223b733a31313a22626f64795f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a313a2232223b7d, 1, 0, 0),
(3, 'field_tags', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a343a2274616773223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(4, 'field_image', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a373a22696e6465786573223b613a313a7b733a333a22666964223b613a313a7b693a303b733a333a22666964223b7d7d733a383a2273657474696e6773223b613a323a7b733a31303a227572695f736368656d65223b733a363a227075626c6963223b733a31333a2264656661756c745f696d616765223b693a303b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32323a226669656c645f646174615f6669656c645f696d616765223b613a353a7b733a333a22666964223b733a31353a226669656c645f696d6167655f666964223b733a333a22616c74223b733a31353a226669656c645f696d6167655f616c74223b733a353a227469746c65223b733a31373a226669656c645f696d6167655f7469746c65223b733a353a227769647468223b733a31373a226669656c645f696d6167655f7769647468223b733a363a22686569676874223b733a31383a226669656c645f696d6167655f686569676874223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a32363a226669656c645f7265766973696f6e5f6669656c645f696d616765223b613a353a7b733a333a22666964223b733a31353a226669656c645f696d6167655f666964223b733a333a22616c74223b733a31353a226669656c645f696d6167655f616c74223b733a353a227469746c65223b733a31373a226669656c645f696d6167655f7469746c65223b733a353a227769647468223b733a31373a226669656c645f696d6167655f7769647468223b733a363a22686569676874223b733a31383a226669656c645f696d6167655f686569676874223b7d7d7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22666f726569676e206b657973223b613a313a7b733a333a22666964223b613a323a7b733a353a227461626c65223b733a31323a2266696c655f6d616e61676564223b733a373a22636f6c756d6e73223b613a313a7b733a333a22666964223b733a333a22666964223b7d7d7d733a323a226964223b733a313a2234223b7d, 1, 0, 0),
(5, 'field_img', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, 1, 0, 0),
(7, 'media_gallery_media', 'media', 'media', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a31323a2266696c655f6d616e61676564223b613a323a7b733a353a227461626c65223b733a31323a2266696c655f6d616e61676564223b733a373a22636f6c756d6e73223b613a313a7b733a333a22666964223b733a333a22666964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22666964223b613a313a7b693a303b733a333a22666964223b7d7d7d, -1, 0, 0),
(8, 'media_gallery_description', 'text_long', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(9, 'media_gallery_format', 'list_text', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a33323a225f6d656469615f67616c6c6572795f6765745f666f726d61745f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(10, 'media_gallery_lightbox_extras', 'list_boolean', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a34313a225f6d656469615f67616c6c6572795f6765745f6c69676874626f785f6578747261735f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(11, 'media_gallery_columns', 'list_float', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a33333a225f6d656469615f67616c6c6572795f6765745f636f6c756d6e735f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(12, 'media_gallery_rows', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(13, 'media_gallery_image_info_where', 'list_text', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a34363a225f6d656469615f67616c6c6572795f6765745f696d6167655f696e666f5f706c6163656d656e745f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(14, 'media_gallery_allow_download', 'list_boolean', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a34303a225f6d656469615f67616c6c6572795f6765745f616c6c6f775f646f776e6c6f61645f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(15, 'media_gallery_expose_block', 'list_boolean', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a33383a225f6d656469615f67616c6c6572795f6765745f6578706f73655f626c6f636b5f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(16, 'media_gallery_block_columns', 'list_float', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a33393a225f6d656469615f67616c6c6572795f6765745f626c6f636b5f636f6c756d6e735f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(17, 'media_gallery_block_rows', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(19, 'media_description', 'text_long', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(20, 'media_title', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b693a3235353b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(21, 'field_license', 'list_text', 'list', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a383a2273657474696e6773223b613a323a7b733a32333a22616c6c6f7765645f76616c7565735f66756e6374696f6e223b733a33393a225f6d656469615f67616c6c6572795f6765745f6669656c645f6c6963656e73655f76616c756573223b733a31343a22616c6c6f7765645f76616c756573223b613a303a7b7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a353a2276616c7565223b613a313a7b693a303b733a353a2276616c7565223b7d7d7d, 1, 0, 0),
(31, 'field_img_blog', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, -1, 0, 0),
(111, 'field_category', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a31333a2263617465676f72795f626c6f67223b733a363a22706172656e74223b733a313a2230223b7d7d7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32353a226669656c645f646174615f6669656c645f63617465676f7279223b613a313a7b733a333a22746964223b733a31383a226669656c645f63617465676f72795f746964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a32393a226669656c645f7265766973696f6e5f6669656c645f63617465676f7279223b613a313a7b733a333a22746964223b733a31383a226669656c645f63617465676f72795f746964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d733a323a226964223b733a333a22313131223b7d, 1, 0, 0),
(112, 'field_icon_name', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b733a333a22323535223b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32363a226669656c645f646174615f6669656c645f69636f6e5f6e616d65223b613a323a7b733a353a2276616c7565223b733a32313a226669656c645f69636f6e5f6e616d655f76616c7565223b733a363a22666f726d6174223b733a32323a226669656c645f69636f6e5f6e616d655f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33303a226669656c645f7265766973696f6e5f6669656c645f69636f6e5f6e616d65223b613a323a7b733a353a2276616c7565223b733a32313a226669656c645f69636f6e5f6e616d655f76616c7565223b733a363a22666f726d6174223b733a32323a226669656c645f69636f6e5f6e616d655f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a333a22313132223b7d, 1, 0, 0),
(113, 'field_button_name', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b733a333a22323535223b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32383a226669656c645f646174615f6669656c645f627574746f6e5f6e616d65223b613a323a7b733a353a2276616c7565223b733a32333a226669656c645f627574746f6e5f6e616d655f76616c7565223b733a363a22666f726d6174223b733a32343a226669656c645f627574746f6e5f6e616d655f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33323a226669656c645f7265766973696f6e5f6669656c645f627574746f6e5f6e616d65223b613a323a7b733a353a2276616c7565223b733a32333a226669656c645f627574746f6e5f6e616d655f76616c7565223b733a363a22666f726d6174223b733a32343a226669656c645f627574746f6e5f6e616d655f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a333a22313133223b7d, 1, 0, 0),
(114, 'field_body_services', 'text_long', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a33303a226669656c645f646174615f6669656c645f626f64795f7365727669636573223b613a323a7b733a353a2276616c7565223b733a32353a226669656c645f626f64795f73657276696365735f76616c7565223b733a363a22666f726d6174223b733a32363a226669656c645f626f64795f73657276696365735f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33343a226669656c645f7265766973696f6e5f6669656c645f626f64795f7365727669636573223b613a323a7b733a353a2276616c7565223b733a32353a226669656c645f626f64795f73657276696365735f76616c7565223b733a363a22666f726d6174223b733a32363a226669656c645f626f64795f73657276696365735f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a333a22313134223b7d, 1, 0, 0),
(115, 'field_button_link', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b733a333a22323535223b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32383a226669656c645f646174615f6669656c645f627574746f6e5f6c696e6b223b613a323a7b733a353a2276616c7565223b733a32333a226669656c645f627574746f6e5f6c696e6b5f76616c7565223b733a363a22666f726d6174223b733a32343a226669656c645f627574746f6e5f6c696e6b5f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33323a226669656c645f7265766973696f6e5f6669656c645f627574746f6e5f6c696e6b223b613a323a7b733a353a2276616c7565223b733a32333a226669656c645f627574746f6e5f6c696e6b5f76616c7565223b733a363a22666f726d6174223b733a32343a226669656c645f627574746f6e5f6c696e6b5f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a333a22313135223b7d, 1, 0, 0),
(116, 'field_images', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, -1, 0, 0),
(117, 'field_button_name_hp', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b733a333a22323535223b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a33313a226669656c645f646174615f6669656c645f627574746f6e5f6e616d655f6870223b613a323a7b733a353a2276616c7565223b733a32363a226669656c645f627574746f6e5f6e616d655f68705f76616c7565223b733a363a22666f726d6174223b733a32373a226669656c645f627574746f6e5f6e616d655f68705f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33353a226669656c645f7265766973696f6e5f6669656c645f627574746f6e5f6e616d655f6870223b613a323a7b733a353a2276616c7565223b733a32363a226669656c645f627574746f6e5f6e616d655f68705f76616c7565223b733a363a22666f726d6174223b733a32373a226669656c645f627574746f6e5f6e616d655f68705f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a333a22313137223b7d, 1, 0, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `field_config_instance`
--

DROP TABLE IF EXISTS `field_config_instance`;
CREATE TABLE IF NOT EXISTS `field_config_instance` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field instance',
  `field_id` int(11) NOT NULL COMMENT 'The identifier of the field attached by this instance',
  `field_name` varchar(32) NOT NULL DEFAULT '',
  `entity_type` varchar(32) NOT NULL DEFAULT '',
  `bundle` varchar(128) NOT NULL DEFAULT '',
  `data` longblob NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name_bundle` (`field_name`,`entity_type`,`bundle`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=186 ;

--
-- Дамп данных таблицы `field_config_instance`
--

INSERT INTO `field_config_instance` (`id`, `field_id`, `field_name`, `entity_type`, `bundle`, `data`, `deleted`) VALUES
(1, 1, 'comment_body', 'comment', 'comment_node_page', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(2, 2, 'body', 'node', 'page', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b693a2d343b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b733a343a2231303030223b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(3, 1, 'comment_body', 'comment', 'comment_node_article', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(4, 2, 'body', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a313a2233223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b733a343a2231303030223b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(5, 3, 'field_tags', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a31313a226465736372697074696f6e223b733a36333a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f757220636f6e74656e742e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b693a31303b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a323a223130223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(6, 4, 'field_image', 'node', 'article', 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, 0),
(7, 5, 'field_img', 'taxonomy_term', 'tags', 0x613a363a7b733a353a226c6162656c223b733a353a22696d616765223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a383a2273657474696e6773223b613a393a7b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31343a2266696c655f6469726563746f7279223b733a303a22223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a303a22223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a343a2266756c6c223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a303a22223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(15, 8, 'media_gallery_description', 'node', 'media_gallery', 0x613a363a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a343b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a343a2266756c6c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(16, 7, 'media_gallery_media', 'node', 'media_gallery', 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, 0),
(17, 9, 'media_gallery_format', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a31343a2247616c6c65727920666f726d6174223b733a383a227265717569726564223b623a313b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b733a383a226c69676874626f78223b7d7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a333b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a333b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a333b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a333b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31353a226f7074696f6e735f627574746f6e73223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a323b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(18, 10, 'media_gallery_lightbox_extras', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a33303a224c69676874626f78207469746c6520616e64206465736372697074696f6e223b733a31313a226465736372697074696f6e223b733a32363a2253686f77207469746c6520616e64206465736372697074696f6e223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a303b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a226f7074696f6e735f6f6e6f6666223b733a383a2273657474696e6773223b613a313a7b733a31333a22646973706c61795f6c6162656c223b693a303b7d733a363a22776569676874223b693a333b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(19, 11, 'media_gallery_columns', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a31373a224e756d626572206f6620636f6c756d6e73223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a343b7d7d733a383a227265717569726564223b623a313b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(20, 12, 'media_gallery_rows', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a31343a224e756d626572206f6620726f7773223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a333b7d7d733a383a2273657474696e6773223b613a353a7b733a333a226d696e223b733a313a2231223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b733a363a226d6f64756c65223b733a363a226e756d626572223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a363b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a363b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a363b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a363b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(21, 13, 'media_gallery_image_info_where', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a31373a224d6564696120696e666f726d6174696f6e223b733a383a227265717569726564223b623a313b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b733a353a22686f766572223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a363b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a373b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a373b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a373b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a373b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(22, 14, 'media_gallery_allow_download', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a33393a22416c6c6f7720646f776e6c6f6164696e67206f6620746865206f726967696e616c20696d616765223b733a31313a226465736372697074696f6e223b733a34303a22446973706c617920612022646f776e6c6f6164206f726967696e616c20696d61676522206c696e6b223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a313b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a226f7074696f6e735f6f6e6f6666223b733a383a2273657474696e6773223b613a313a7b733a31333a22646973706c61795f6c6162656c223b693a303b7d733a363a22776569676874223b693a373b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a383b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a383b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a383b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a383b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(23, 15, 'media_gallery_expose_block', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a34333a22437265617465206120626c6f636b206f66206d6f737420726563656e746c79206164646564206d65646961223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a303b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a226f7074696f6e735f6f6e6f6666223b733a383a2273657474696e6773223b613a313a7b733a31333a22646973706c61795f6c6162656c223b693a303b7d733a363a22776569676874223b693a383b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a393b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a393b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a393b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a393b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(24, 16, 'media_gallery_block_columns', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a31373a224e756d626572206f6620636f6c756d6e73223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a323b7d7d733a383a227265717569726564223b623a313b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a393b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31303b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31303b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31303b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31303b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(25, 17, 'media_gallery_block_rows', 'node', 'media_gallery', 0x613a373a7b733a353a226c6162656c223b733a31343a224e756d626572206f6620726f7773223b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b693a333b7d7d733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a353a7b733a333a226d696e223b693a313b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31303b733a363a226d6f64756c65223b733a363a226e756d626572223b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31313b7d733a343a2266756c6c223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31313b7d733a363a22746561736572223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31313b7d733a31393a226d656469615f67616c6c6572795f626c6f636b223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a31313b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(27, 20, 'media_title', 'file', 'audio', 0x613a363a7b733a353a226c6162656c223b733a353a225469746c65223b733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a303b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a313b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(28, 19, 'media_description', 'file', 'audio', 0x613a363a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a343b7d733a363a22776569676874223b693a323b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(29, 3, 'field_tags', 'file', 'audio', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a22776569676874223b693a333b733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a36313a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f757220617564696f2e223b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(30, 21, 'field_license', 'file', 'audio', 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, 0),
(31, 20, 'media_title', 'file', 'image', 0x613a363a7b733a353a226c6162656c223b733a353a225469746c65223b733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a303b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a313b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(32, 19, 'media_description', 'file', 'image', 0x613a363a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a343b7d733a363a22776569676874223b693a323b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(33, 3, 'field_tags', 'file', 'image', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a22776569676874223b693a333b733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a36313a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f757220696d6167652e223b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(34, 21, 'field_license', 'file', 'image', 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, 0),
(35, 20, 'media_title', 'file', 'video', 0x613a363a7b733a353a226c6162656c223b733a353a225469746c65223b733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a303b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a313b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(36, 19, 'media_description', 'file', 'video', 0x613a363a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a343b7d733a363a22776569676874223b693a323b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(37, 3, 'field_tags', 'file', 'video', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a22776569676874223b693a333b733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a36313a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f757220766964656f2e223b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0);
INSERT INTO `field_config_instance` (`id`, `field_id`, `field_name`, `entity_type`, `bundle`, `data`, `deleted`) VALUES
(38, 21, 'field_license', 'file', 'video', 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, 0),
(39, 20, 'media_title', 'file', 'default', 0x613a363a7b733a353a226c6162656c223b733a353a225469746c65223b733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a303b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a313b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(40, 19, 'media_description', 'file', 'default', 0x613a363a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a343b7d733a363a22776569676874223b693a323b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(41, 3, 'field_tags', 'file', 'default', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a22776569676874223b693a333b733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a36303a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f75722066696c652e223b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(42, 21, 'field_license', 'file', 'default', 0x613a373a7b733a353a226c6162656c223b733a33303a224c6963656e73652073657474696e677320666f7220746869732066696c65223b733a383a227265717569726564223b623a313b733a31333a2264656661756c745f76616c7565223b613a313a7b693a303b613a313a7b733a353a2276616c7565223b733a373a226e6f7468696e67223b7d7d733a31313a226465736372697074696f6e223b733a3131383a2253656c6563742061203c6120687265663d22687474703a2f2f6372656174697665636f6d6d6f6e732e6f726722207461726765743d225f6e6577223e437265617469766520436f6d6d6f6e733c2f613e206c6963656e736520666f72206f74686572732077686f2075736520746869732066696c652e223b733a373a22646973706c6179223b613a343a7b733a373a2264656661756c74223b613a343a7b733a343a2274797065223b733a363a2268696464656e223b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a333b7d733a32333a226d656469615f67616c6c6572795f7468756d626e61696c223b613a353a7b733a343a2274797065223b733a31323a226c6973745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a226c697374223b733a363a22776569676874223b693a323b7d733a32323a226d656469615f67616c6c6572795f6c69676874626f78223b613a353a7b733a343a2274797065223b733a31323a226c6973745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a226c697374223b733a363a22776569676874223b693a323b7d733a32303a226d656469615f67616c6c6572795f64657461696c223b613a353a7b733a343a2274797065223b733a31323a226c6973745f64656661756c74223b733a353a226c6162656c223b733a363a2268696464656e223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a226c697374223b733a363a22776569676874223b693a323b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d7d, 0),
(43, 1, 'comment_body', 'comment', 'comment_node_media_gallery', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(63, 1, 'comment_body', 'comment', 'comment_node_blog', 0x613a373a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b733a313a2230223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b693a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2230223b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b733a313a2235223b7d7d733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(64, 2, 'body', 'node', 'blog', 0x613a373a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b733a323a223230223b733a31323a2273756d6d6172795f726f7773223b693a353b7d7d733a383a2273657474696e6773223b613a333a7b733a31353a22746578745f70726f63657373696e67223b733a313a2231223b733a31353a22646973706c61795f73756d6d617279223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(65, 31, 'field_img_blog', 'node', 'blog', 0x613a363a7b733a353a226c6162656c223b733a363a22496d61676573223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2231223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a303a22223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a31303a22696d6167652d626c6f67223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a31303a22696d6167652d626c6f67223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(175, 111, 'field_category', 'node', 'blog', 0x613a373a7b733a353a226c6162656c223b733a383a2243617465676f7279223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2233223b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a303a7b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(176, 1, 'comment_body', 'comment', 'comment_node_services', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(178, 112, 'field_icon_name', 'node', 'services', 0x613a373a7b733a353a226c6162656c223b733a393a2249636f6e206e616d65223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2230223b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b733a323a223630223b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b733a313a2230223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(179, 113, 'field_button_name', 'node', 'services', 0x613a373a7b733a353a226c6162656c223b733a31313a22427574746f6e206e616d65223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2233223b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b733a323a223630223b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b733a313a2230223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a323b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(180, 114, 'field_body_services', 'node', 'services', 0x613a373a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b733a313a2235223b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b733a313a2230223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a333b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(181, 115, 'field_button_link', 'node', 'services', 0x613a373a7b733a353a226c6162656c223b733a31313a22427574746f6e206c696e6b223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2234223b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b733a323a223630223b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b733a313a2230223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a343b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(182, 1, 'comment_body', 'comment', 'comment_node_home_page_gallery', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(184, 116, 'field_images', 'node', 'home_page_gallery', 0x613a363a7b733a353a226c6162656c223b733a363a22696d61676573223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a222d34223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a22686f6d655f70616765223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a303a22223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a353a22696d616765223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a303a22223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(185, 117, 'field_button_name_hp', 'node', 'home_page_gallery', 0x613a373a7b733a353a226c6162656c223b733a363a22427574746f6e223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a222d33223b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b733a323a223630223b7d7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b733a313a2230223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_body`
--

DROP TABLE IF EXISTS `field_data_body`;
CREATE TABLE IF NOT EXISTS `field_data_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 2 (body)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_comment_body`
--

DROP TABLE IF EXISTS `field_data_comment_body`;
CREATE TABLE IF NOT EXISTS `field_data_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 1 (comment_body)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_body_services`
--

DROP TABLE IF EXISTS `field_data_field_body_services`;
CREATE TABLE IF NOT EXISTS `field_data_field_body_services` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_body_services_value` longtext,
  `field_body_services_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_body_services_format` (`field_body_services_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 114 (field_body_services)';

--
-- Дамп данных таблицы `field_data_field_body_services`
--

INSERT INTO `field_data_field_body_services` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_body_services_value`, `field_body_services_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_button_link`
--

DROP TABLE IF EXISTS `field_data_field_button_link`;
CREATE TABLE IF NOT EXISTS `field_data_field_button_link` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_button_link_value` varchar(255) DEFAULT NULL,
  `field_button_link_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_button_link_format` (`field_button_link_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 115 (field_button_link)';

--
-- Дамп данных таблицы `field_data_field_button_link`
--

INSERT INTO `field_data_field_button_link` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_button_link_value`, `field_button_link_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'http://ordasoft.com/drupal-themes', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'http://ordasoft.com/drupal-themes', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'http://ordasoft.com/drupal-themes', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_button_name`
--

DROP TABLE IF EXISTS `field_data_field_button_name`;
CREATE TABLE IF NOT EXISTS `field_data_field_button_name` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_button_name_value` varchar(255) DEFAULT NULL,
  `field_button_name_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_button_name_format` (`field_button_name_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 113 (field_button_name)';

--
-- Дамп данных таблицы `field_data_field_button_name`
--

INSERT INTO `field_data_field_button_name` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_button_name_value`, `field_button_name_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'read more ', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'click here', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'read more', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_button_name_hp`
--

DROP TABLE IF EXISTS `field_data_field_button_name_hp`;
CREATE TABLE IF NOT EXISTS `field_data_field_button_name_hp` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_button_name_hp_value` varchar(255) DEFAULT NULL,
  `field_button_name_hp_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_button_name_hp_format` (`field_button_name_hp_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 117 (field_button_name_hp)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_category`
--

DROP TABLE IF EXISTS `field_data_field_category`;
CREATE TABLE IF NOT EXISTS `field_data_field_category` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_category_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_category_tid` (`field_category_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 111 (field_category)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_icon_name`
--

DROP TABLE IF EXISTS `field_data_field_icon_name`;
CREATE TABLE IF NOT EXISTS `field_data_field_icon_name` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_icon_name_value` varchar(255) DEFAULT NULL,
  `field_icon_name_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_icon_name_format` (`field_icon_name_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 112 (field_icon_name)';

--
-- Дамп данных таблицы `field_data_field_icon_name`
--

INSERT INTO `field_data_field_icon_name` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_icon_name_value`, `field_icon_name_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'fa  fa-tags', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'fa  fa-cogs', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'fa  fa-arrows-alt', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_image`
--

DROP TABLE IF EXISTS `field_data_field_image`;
CREATE TABLE IF NOT EXISTS `field_data_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 4 (field_image)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_images`
--

DROP TABLE IF EXISTS `field_data_field_images`;
CREATE TABLE IF NOT EXISTS `field_data_field_images` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_images_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_images_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_images_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_images_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_images_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_images_fid` (`field_images_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 116 (field_images)';

--
-- Дамп данных таблицы `field_data_field_images`
--

INSERT INTO `field_data_field_images` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_images_fid`, `field_images_alt`, `field_images_title`, `field_images_width`, `field_images_height`) VALUES
('node', 'home_page_gallery', 0, 4, 4, 'und', 0, 274, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 1, 275, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 2, 276, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 3, 277, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 4, 278, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 5, 279, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 6, 280, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 7, 281, '', '', 1920, 1080);

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_img`
--

DROP TABLE IF EXISTS `field_data_field_img`;
CREATE TABLE IF NOT EXISTS `field_data_field_img` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_img_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_img_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_img_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_img_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_img_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_img_fid` (`field_img_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 5 (field_img)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_img_blog`
--

DROP TABLE IF EXISTS `field_data_field_img_blog`;
CREATE TABLE IF NOT EXISTS `field_data_field_img_blog` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_img_blog_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_img_blog_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_img_blog_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_img_blog_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_img_blog_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_img_blog_fid` (`field_img_blog_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 31 (field_img_blog)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_license`
--

DROP TABLE IF EXISTS `field_data_field_license`;
CREATE TABLE IF NOT EXISTS `field_data_field_license` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_license_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_license_value` (`field_license_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 21 (field_license)';

--
-- Дамп данных таблицы `field_data_field_license`
--

INSERT INTO `field_data_field_license` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_license_value`) VALUES
('file', 'image', 0, 83, 83, 'und', 0, 'nothing'),
('file', 'image', 0, 84, 84, 'und', 0, 'nothing'),
('file', 'image', 0, 96, 96, 'und', 0, 'nothing'),
('file', 'image', 0, 97, 97, 'und', 0, 'nothing'),
('file', 'image', 0, 99, 99, 'und', 0, 'nothing'),
('file', 'image', 0, 100, 100, 'und', 0, 'nothing'),
('file', 'image', 0, 164, 164, 'und', 0, 'nothing'),
('file', 'image', 0, 259, 259, 'und', 0, 'nothing'),
('file', 'image', 0, 260, 260, 'und', 0, 'nothing'),
('file', 'default', 0, 271, 271, 'und', 0, 'nothing'),
('file', 'default', 0, 272, 272, 'und', 0, 'nothing'),
('file', 'default', 0, 273, 273, 'und', 0, 'nothing'),
('file', 'image', 0, 274, 274, 'und', 0, 'nothing'),
('file', 'image', 0, 275, 275, 'und', 0, 'nothing'),
('file', 'image', 0, 276, 276, 'und', 0, 'nothing'),
('file', 'image', 0, 277, 277, 'und', 0, 'nothing'),
('file', 'image', 0, 278, 278, 'und', 0, 'nothing'),
('file', 'image', 0, 279, 279, 'und', 0, 'nothing'),
('file', 'image', 0, 280, 280, 'und', 0, 'nothing'),
('file', 'image', 0, 281, 281, 'und', 0, 'nothing');

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_field_tags`
--

DROP TABLE IF EXISTS `field_data_field_tags`;
CREATE TABLE IF NOT EXISTS `field_data_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 3 (field_tags)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_description`
--

DROP TABLE IF EXISTS `field_data_media_description`;
CREATE TABLE IF NOT EXISTS `field_data_media_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_description_value` longtext,
  `media_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_description_format` (`media_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 19 (media_description)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_allow_download`
--

DROP TABLE IF EXISTS `field_data_media_gallery_allow_download`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_allow_download` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_allow_download_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_allow_download_value` (`media_gallery_allow_download_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 14 (media_gallery_allow_download)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_block_columns`
--

DROP TABLE IF EXISTS `field_data_media_gallery_block_columns`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_block_columns` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_block_columns_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_block_columns_value` (`media_gallery_block_columns_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 16 (media_gallery_block_columns)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_block_rows`
--

DROP TABLE IF EXISTS `field_data_media_gallery_block_rows`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_block_rows` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_block_rows_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 17 (media_gallery_block_rows)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_columns`
--

DROP TABLE IF EXISTS `field_data_media_gallery_columns`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_columns` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_columns_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_columns_value` (`media_gallery_columns_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 11 (media_gallery_columns)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_description`
--

DROP TABLE IF EXISTS `field_data_media_gallery_description`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_description_value` longtext,
  `media_gallery_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_description_format` (`media_gallery_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 8 (media_gallery_description)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_expose_block`
--

DROP TABLE IF EXISTS `field_data_media_gallery_expose_block`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_expose_block` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_expose_block_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_expose_block_value` (`media_gallery_expose_block_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 15 (media_gallery_expose_block)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_format`
--

DROP TABLE IF EXISTS `field_data_media_gallery_format`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_format` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_format_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_format_value` (`media_gallery_format_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 9 (media_gallery_format)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_image_info_where`
--

DROP TABLE IF EXISTS `field_data_media_gallery_image_info_where`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_image_info_where` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_image_info_where_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_image_info_where_value` (`media_gallery_image_info_where_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 13 (media_gallery_image_info_where)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_lightbox_extras`
--

DROP TABLE IF EXISTS `field_data_media_gallery_lightbox_extras`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_lightbox_extras` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_lightbox_extras_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_lightbox_extras_value` (`media_gallery_lightbox_extras_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 10 (media_gallery_lightbox_extras)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_media`
--

DROP TABLE IF EXISTS `field_data_media_gallery_media`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_media` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_media_fid` int(10) unsigned DEFAULT NULL,
  `media_gallery_media_title` varchar(255) DEFAULT NULL,
  `media_gallery_media_data` longtext,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_media_fid` (`media_gallery_media_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 7 (media_gallery_media)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_gallery_rows`
--

DROP TABLE IF EXISTS `field_data_media_gallery_rows`;
CREATE TABLE IF NOT EXISTS `field_data_media_gallery_rows` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_rows_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 12 (media_gallery_rows)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_data_media_title`
--

DROP TABLE IF EXISTS `field_data_media_title`;
CREATE TABLE IF NOT EXISTS `field_data_media_title` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_title_value` varchar(255) DEFAULT NULL,
  `media_title_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_title_format` (`media_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 20 (media_title)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_body`
--

DROP TABLE IF EXISTS `field_revision_body`;
CREATE TABLE IF NOT EXISTS `field_revision_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 2 (body)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_comment_body`
--

DROP TABLE IF EXISTS `field_revision_comment_body`;
CREATE TABLE IF NOT EXISTS `field_revision_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 1 (comment_body)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_body_services`
--

DROP TABLE IF EXISTS `field_revision_field_body_services`;
CREATE TABLE IF NOT EXISTS `field_revision_field_body_services` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_body_services_value` longtext,
  `field_body_services_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_body_services_format` (`field_body_services_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 114 (field_body_services)';

--
-- Дамп данных таблицы `field_revision_field_body_services`
--

INSERT INTO `field_revision_field_body_services` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_body_services_value`, `field_body_services_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_button_link`
--

DROP TABLE IF EXISTS `field_revision_field_button_link`;
CREATE TABLE IF NOT EXISTS `field_revision_field_button_link` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_button_link_value` varchar(255) DEFAULT NULL,
  `field_button_link_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_button_link_format` (`field_button_link_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 115 (field_button_link)';

--
-- Дамп данных таблицы `field_revision_field_button_link`
--

INSERT INTO `field_revision_field_button_link` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_button_link_value`, `field_button_link_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'http://ordasoft.com/drupal-themes', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'http://ordasoft.com/drupal-themes', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'http://ordasoft.com/drupal-themes', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_button_name`
--

DROP TABLE IF EXISTS `field_revision_field_button_name`;
CREATE TABLE IF NOT EXISTS `field_revision_field_button_name` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_button_name_value` varchar(255) DEFAULT NULL,
  `field_button_name_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_button_name_format` (`field_button_name_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 113 (field_button_name)';

--
-- Дамп данных таблицы `field_revision_field_button_name`
--

INSERT INTO `field_revision_field_button_name` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_button_name_value`, `field_button_name_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'read more ', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'click here', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'read more', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_button_name_hp`
--

DROP TABLE IF EXISTS `field_revision_field_button_name_hp`;
CREATE TABLE IF NOT EXISTS `field_revision_field_button_name_hp` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_button_name_hp_value` varchar(255) DEFAULT NULL,
  `field_button_name_hp_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_button_name_hp_format` (`field_button_name_hp_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 117 (field_button_name...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_category`
--

DROP TABLE IF EXISTS `field_revision_field_category`;
CREATE TABLE IF NOT EXISTS `field_revision_field_category` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_category_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_category_tid` (`field_category_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 111 (field_category)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_icon_name`
--

DROP TABLE IF EXISTS `field_revision_field_icon_name`;
CREATE TABLE IF NOT EXISTS `field_revision_field_icon_name` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_icon_name_value` varchar(255) DEFAULT NULL,
  `field_icon_name_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_icon_name_format` (`field_icon_name_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 112 (field_icon_name)';

--
-- Дамп данных таблицы `field_revision_field_icon_name`
--

INSERT INTO `field_revision_field_icon_name` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_icon_name_value`, `field_icon_name_format`) VALUES
('node', 'services', 0, 1, 1, 'und', 0, 'fa  fa-tags', NULL),
('node', 'services', 0, 2, 2, 'und', 0, 'fa  fa-cogs', NULL),
('node', 'services', 0, 3, 3, 'und', 0, 'fa  fa-arrows-alt', NULL);

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_image`
--

DROP TABLE IF EXISTS `field_revision_field_image`;
CREATE TABLE IF NOT EXISTS `field_revision_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 4 (field_image)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_images`
--

DROP TABLE IF EXISTS `field_revision_field_images`;
CREATE TABLE IF NOT EXISTS `field_revision_field_images` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_images_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_images_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_images_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_images_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_images_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_images_fid` (`field_images_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 116 (field_images)';

--
-- Дамп данных таблицы `field_revision_field_images`
--

INSERT INTO `field_revision_field_images` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_images_fid`, `field_images_alt`, `field_images_title`, `field_images_width`, `field_images_height`) VALUES
('node', 'home_page_gallery', 0, 4, 4, 'und', 0, 274, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 1, 275, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 2, 276, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 3, 277, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 4, 278, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 5, 279, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 6, 280, '', '', 1920, 1080),
('node', 'home_page_gallery', 0, 4, 4, 'und', 7, 281, '', '', 1920, 1080);

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_img`
--

DROP TABLE IF EXISTS `field_revision_field_img`;
CREATE TABLE IF NOT EXISTS `field_revision_field_img` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_img_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_img_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_img_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_img_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_img_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_img_fid` (`field_img_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 5 (field_img)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_img_blog`
--

DROP TABLE IF EXISTS `field_revision_field_img_blog`;
CREATE TABLE IF NOT EXISTS `field_revision_field_img_blog` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_img_blog_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_img_blog_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_img_blog_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_img_blog_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_img_blog_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_img_blog_fid` (`field_img_blog_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 31 (field_img_blog)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_license`
--

DROP TABLE IF EXISTS `field_revision_field_license`;
CREATE TABLE IF NOT EXISTS `field_revision_field_license` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_license_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_license_value` (`field_license_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 21 (field_license)';

--
-- Дамп данных таблицы `field_revision_field_license`
--

INSERT INTO `field_revision_field_license` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_license_value`) VALUES
('file', 'image', 0, 83, 83, 'und', 0, 'nothing'),
('file', 'image', 0, 84, 84, 'und', 0, 'nothing'),
('file', 'image', 0, 96, 96, 'und', 0, 'nothing'),
('file', 'image', 0, 97, 97, 'und', 0, 'nothing'),
('file', 'image', 0, 99, 99, 'und', 0, 'nothing'),
('file', 'image', 0, 100, 100, 'und', 0, 'nothing'),
('file', 'image', 0, 164, 164, 'und', 0, 'nothing'),
('file', 'image', 0, 259, 259, 'und', 0, 'nothing'),
('file', 'image', 0, 260, 260, 'und', 0, 'nothing'),
('file', 'default', 0, 271, 271, 'und', 0, 'nothing'),
('file', 'default', 0, 272, 272, 'und', 0, 'nothing'),
('file', 'default', 0, 273, 273, 'und', 0, 'nothing'),
('file', 'image', 0, 274, 274, 'und', 0, 'nothing'),
('file', 'image', 0, 275, 275, 'und', 0, 'nothing'),
('file', 'image', 0, 276, 276, 'und', 0, 'nothing'),
('file', 'image', 0, 277, 277, 'und', 0, 'nothing'),
('file', 'image', 0, 278, 278, 'und', 0, 'nothing'),
('file', 'image', 0, 279, 279, 'und', 0, 'nothing'),
('file', 'image', 0, 280, 280, 'und', 0, 'nothing'),
('file', 'image', 0, 281, 281, 'und', 0, 'nothing');

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_field_tags`
--

DROP TABLE IF EXISTS `field_revision_field_tags`;
CREATE TABLE IF NOT EXISTS `field_revision_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 3 (field_tags)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_description`
--

DROP TABLE IF EXISTS `field_revision_media_description`;
CREATE TABLE IF NOT EXISTS `field_revision_media_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_description_value` longtext,
  `media_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_description_format` (`media_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 19 (media_description)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_allow_download`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_allow_download`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_allow_download` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_allow_download_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_allow_download_value` (`media_gallery_allow_download_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 14 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_block_columns`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_block_columns`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_block_columns` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_block_columns_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_block_columns_value` (`media_gallery_block_columns_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 16 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_block_rows`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_block_rows`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_block_rows` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_block_rows_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 17 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_columns`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_columns`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_columns` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_columns_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_columns_value` (`media_gallery_columns_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 11 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_description`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_description`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_description_value` longtext,
  `media_gallery_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_description_format` (`media_gallery_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 8 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_expose_block`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_expose_block`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_expose_block` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_expose_block_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_expose_block_value` (`media_gallery_expose_block_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 15 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_format`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_format`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_format` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_format_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_format_value` (`media_gallery_format_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 9 (media_gallery_format)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_image_info_where`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_image_info_where`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_image_info_where` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_image_info_where_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_image_info_where_value` (`media_gallery_image_info_where_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 13 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_lightbox_extras`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_lightbox_extras`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_lightbox_extras` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_lightbox_extras_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_lightbox_extras_value` (`media_gallery_lightbox_extras_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 10 (media_gallery...';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_media`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_media`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_media` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_media_fid` int(10) unsigned DEFAULT NULL,
  `media_gallery_media_title` varchar(255) DEFAULT NULL,
  `media_gallery_media_data` longtext,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_gallery_media_fid` (`media_gallery_media_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 7 (media_gallery_media)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_gallery_rows`
--

DROP TABLE IF EXISTS `field_revision_media_gallery_rows`;
CREATE TABLE IF NOT EXISTS `field_revision_media_gallery_rows` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_gallery_rows_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 12 (media_gallery_rows)';

-- --------------------------------------------------------

--
-- Структура таблицы `field_revision_media_title`
--

DROP TABLE IF EXISTS `field_revision_media_title`;
CREATE TABLE IF NOT EXISTS `field_revision_media_title` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `media_title_value` varchar(255) DEFAULT NULL,
  `media_title_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `media_title_format` (`media_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 20 (media_title)';

-- --------------------------------------------------------

--
-- Структура таблицы `file_display`
--

DROP TABLE IF EXISTS `file_display`;
CREATE TABLE IF NOT EXISTS `file_display` (
  `name` varchar(255) NOT NULL COMMENT 'A combined string (FILE_TYPE__VIEW_MODE__FILE_FORMATTER) identifying a file display configuration. For integration with CTools Exportables, stored as a single string rather than as a compound primary key.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of formatter within the display chain for the associated file type and view mode. A file is rendered using the lowest weighted enabled display configuration that matches the file type and view mode and that is capable of displaying the file.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'The status of the display. (1 = enabled, 0 = disabled)',
  `settings` longblob COMMENT 'A serialized array of name value pairs that store the formatter settings for the display.',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for file displays.';

-- --------------------------------------------------------

--
-- Структура таблицы `file_effects`
--

DROP TABLE IF EXISTS `file_effects`;
CREATE TABLE IF NOT EXISTS `file_effects` (
  `meid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an file effect.',
  `msid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The file_styles.isid for a file style.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of the effect in the style.',
  `name` varchar(255) NOT NULL COMMENT 'The unique name of the effect to be executed.',
  `data` longtext NOT NULL COMMENT 'The configuration data for the effect.',
  PRIMARY KEY (`meid`),
  KEY `msid` (`msid`),
  KEY `weight` (`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for file effects.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `file_managed`
--

DROP TABLE IF EXISTS `file_managed`;
CREATE TABLE IF NOT EXISTS `file_managed` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The users.uid of the user who is associated with the file.',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the file with no path components. This may differ from the basename of the URI if the file is renamed to avoid overwriting an existing file.',
  `uri` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'The URI to access the file (either local or remote).',
  `filemime` varchar(255) NOT NULL DEFAULT '' COMMENT 'The file’s MIME type.',
  `filesize` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'The size of the file in bytes.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A field indicating the status of the file. Two status are defined in core: temporary (0) and permanent (1). Temporary files older than DRUPAL_MAXIMUM_TEMP_FILE_AGE will be removed during a cron run.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UNIX timestamp for when the file was added.',
  `type` varchar(50) NOT NULL DEFAULT 'undefined' COMMENT 'The type of this file.',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `uri` (`uri`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`),
  KEY `file_type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores information for uploaded files.' AUTO_INCREMENT=282 ;

--
-- Дамп данных таблицы `file_managed`
--

INSERT INTO `file_managed` (`fid`, `uid`, `filename`, `uri`, `filemime`, `filesize`, `status`, `timestamp`, `type`) VALUES
(83, 1, 'QuickStartPackage.png', 'public://imageblock/QuickStartPackage.png', 'image/png', 50568, 1, 1377166291, 'image'),
(84, 1, 'responsive-theme.png', 'public://imageblock/responsive-theme.png', 'image/png', 52967, 1, 1377167367, 'image'),
(96, 1, 'favicon.ico', 'temporary://favicon.ico', 'image/vnd.microsoft.icon', 1115, 0, 1380886677, 'image'),
(97, 1, 'logo.png', 'temporary://logo.png', 'image/png', 5029, 0, 1381137401, 'image'),
(99, 1, 'logo.png', 'temporary://logo_0.png', 'image/png', 5029, 0, 1381137417, 'image'),
(100, 1, 'favicon.ico', 'temporary://favicon_5.ico', 'image/vnd.microsoft.icon', 1115, 0, 1381137417, 'image'),
(164, 1, 'logo.png', 'temporary://logo_1.png', 'image/png', 2026, 0, 1391423710, 'image'),
(259, 1, 'logo.png', 'temporary://logo_2.png', 'image/png', 835, 0, 1395828609, 'image'),
(260, 1, 'logo.png', 'temporary://logo_3.png', 'image/png', 835, 0, 1395830095, 'image'),
(271, 1, 'fancybox-7.x-2.x-dev.zip', 'temporary://fancybox-7.x-2.x-dev.zip', 'application/zip', 26597, 0, 1424254486, 'default'),
(272, 1, 'jquery_update-7.x-2.4.zip', 'temporary://jquery_update-7.x-2.4.zip', 'application/zip', 1395393, 0, 1424254502, 'default'),
(273, 1, 'libraries-7.x-2.2.zip', 'temporary://libraries-7.x-2.2.zip', 'application/zip', 46858, 0, 1424254523, 'default'),
(274, 1, 'part.jpg', 'public://part.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(275, 1, 'part.jpg', 'public://part_0.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(276, 1, 'part.jpg', 'public://part_1.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(277, 1, 'part.jpg', 'public://part_2.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(278, 1, 'part.jpg', 'public://part_3.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(279, 1, 'part.jpg', 'public://part_4.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(280, 1, 'part.jpg', 'public://part_5.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image'),
(281, 1, 'part.jpg', 'public://part_6.jpg', 'image/jpeg', 64394, 1, 1424439775, 'image');

-- --------------------------------------------------------

--
-- Структура таблицы `file_styles`
--

DROP TABLE IF EXISTS `file_styles`;
CREATE TABLE IF NOT EXISTS `file_styles` (
  `msid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a file style.',
  `name` varchar(255) NOT NULL COMMENT 'The style name.',
  PRIMARY KEY (`msid`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for file styles.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `file_usage`
--

DROP TABLE IF EXISTS `file_usage`;
CREATE TABLE IF NOT EXISTS `file_usage` (
  `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Track where a file is used.';

--
-- Дамп данных таблицы `file_usage`
--

INSERT INTO `file_usage` (`fid`, `module`, `type`, `id`, `count`) VALUES
(7, 'image', 'default_image', 5, 1),
(83, 'imageblock', 'imageblock', 16, 1),
(84, 'imageblock', 'imageblock', 17, 1),
(274, 'file', 'node', 4, 1),
(275, 'file', 'node', 4, 1),
(276, 'file', 'node', 4, 1),
(277, 'file', 'node', 4, 1),
(278, 'file', 'node', 4, 1),
(279, 'file', 'node', 4, 1),
(280, 'file', 'node', 4, 1),
(281, 'file', 'node', 4, 1);

-- --------------------------------------------------------

--
-- Структура таблицы `filter`
--

DROP TABLE IF EXISTS `filter`;
CREATE TABLE IF NOT EXISTS `filter` (
  `format` varchar(255) NOT NULL COMMENT 'Foreign key: The filter_format.format to which this filter is assigned.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The origin module of the filter.',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Name of the filter being referenced.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of filter within format.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Filter enabled status. (1 = enabled, 0 = disabled)',
  `settings` longblob COMMENT 'A serialized array of name value pairs that store the filter settings for the specific format.',
  PRIMARY KEY (`format`,`name`),
  KEY `list` (`weight`,`module`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table that maps filters (HTML corrector) to text formats ...';

--
-- Дамп данных таблицы `filter`
--

INSERT INTO `filter` (`format`, `module`, `name`, `weight`, `status`, `settings`) VALUES
('filtered_html', 'filter', 'filter_autop', 2, 1, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_html', 1, 1, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('filtered_html', 'filter', 'filter_htmlcorrector', 10, 1, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_html_escape', -10, 0, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_url', 0, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('full_html', 'filter', 'filter_autop', 1, 1, 0x613a303a7b7d),
('full_html', 'filter', 'filter_html', -10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('full_html', 'filter', 'filter_htmlcorrector', 10, 1, 0x613a303a7b7d),
('full_html', 'filter', 'filter_html_escape', -10, 0, 0x613a303a7b7d),
('full_html', 'filter', 'filter_url', 0, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('plain_text', 'filter', 'filter_autop', 2, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_html', -10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('plain_text', 'filter', 'filter_htmlcorrector', 10, 0, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_html_escape', 0, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_url', 1, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d);

-- --------------------------------------------------------

--
-- Структура таблицы `filter_format`
--

DROP TABLE IF EXISTS `filter_format`;
CREATE TABLE IF NOT EXISTS `filter_format` (
  `format` varchar(255) NOT NULL COMMENT 'Primary Key: Unique machine name of the format.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the text format (Filtered HTML).',
  `cache` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether format is cacheable. (1 = cacheable, 0 = not cacheable)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The status of the text format. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of text format to use when listing.',
  PRIMARY KEY (`format`),
  UNIQUE KEY `name` (`name`),
  KEY `status_weight` (`status`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores text formats: custom groupings of filters, such as...';

--
-- Дамп данных таблицы `filter_format`
--

INSERT INTO `filter_format` (`format`, `name`, `cache`, `status`, `weight`) VALUES
('filtered_html', 'Filtered HTML', 1, 1, 0),
('full_html', 'Full HTML', 1, 1, 1),
('plain_text', 'Plain text', 1, 1, 10);

-- --------------------------------------------------------

--
-- Структура таблицы `flood`
--

DROP TABLE IF EXISTS `flood`;
CREATE TABLE IF NOT EXISTS `flood` (
  `fid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unique flood event ID.',
  `event` varchar(64) NOT NULL DEFAULT '' COMMENT 'Name of event (e.g. contact).',
  `identifier` varchar(128) NOT NULL DEFAULT '' COMMENT 'Identifier of the visitor, such as an IP address or hostname.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp of the event.',
  `expiration` int(11) NOT NULL DEFAULT '0' COMMENT 'Expiration timestamp. Expired events are purged on cron run.',
  PRIMARY KEY (`fid`),
  KEY `allow` (`event`,`identifier`,`timestamp`),
  KEY `purge` (`expiration`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Flood controls the threshold of events, such as the...' AUTO_INCREMENT=5 ;

--
-- Дамп данных таблицы `flood`
--

INSERT INTO `flood` (`fid`, `event`, `identifier`, `timestamp`, `expiration`) VALUES
(1, 'failed_login_attempt_ip', '::1', 1391696788, 1391700388),
(2, 'failed_login_attempt_ip', '::1', 1391697578, 1391701178),
(3, 'failed_login_attempt_ip', '::1', 1391697686, 1391701286),
(4, 'failed_login_attempt_ip', '::1', 1391697702, 1391701302);

-- --------------------------------------------------------

--
-- Структура таблицы `history`
--

DROP TABLE IF EXISTS `history`;
CREATE TABLE IF NOT EXISTS `history` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that read the node nid.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid that was read.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of which users have read which nodes.';

--
-- Дамп данных таблицы `history`
--

INSERT INTO `history` (`uid`, `nid`, `timestamp`) VALUES
(1, 1, 1423834669),
(1, 2, 1423841282),
(1, 3, 1423841334),
(1, 4, 1424083521);

-- --------------------------------------------------------

--
-- Структура таблицы `imageblock`
--

DROP TABLE IF EXISTS `imageblock`;
CREATE TABLE IF NOT EXISTS `imageblock` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The File’s files.fid.',
  `data` longtext COMMENT 'A serialized array of name value pairs that are related to the block file.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`),
  KEY `fid` (`fid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made image blocks.' AUTO_INCREMENT=18 ;

--
-- Дамп данных таблицы `imageblock`
--

INSERT INTO `imageblock` (`bid`, `body`, `info`, `format`, `fid`, `data`) VALUES
(16, '<div align="center"><font face="roboto" size="4">Quickstart Package allow you install in few clicks </font><font face="roboto" size="4">Drupal</font><font face="roboto" size="4"> template, Drupal extensions and Demo data, in final you get full </font><font face="roboto" size="4">Drupal</font><font face="roboto" size="4"> website exactly the same like on demo.\r\n<a target="_blank" href="http://ordasoft.com/News/Joomla-Tutorials/how-to-install-joomla-quickstart-package.html"><br></a></font></div>', 'QuickStart Package', 'full_html', 83, 'a:1:{s:22:"imageblock_link_target";s:5:"_self";}'),
(17, '<div align="center"><font face="roboto" size="4">We care about users who like surfing the web on their mobile device and we develop adaptive templates. OS templates it''s 100% responsive, your site will be amazing not only on desktops but also on all modern mobile devices</font></div>', 'Responsive Layout', 'full_html', 84, 'a:1:{s:22:"imageblock_link_target";s:5:"_self";}');

-- --------------------------------------------------------

--
-- Структура таблицы `image_dimensions`
--

DROP TABLE IF EXISTS `image_dimensions`;
CREATE TABLE IF NOT EXISTS `image_dimensions` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID.',
  `height` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The height of the image in pixels.',
  `width` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The width of the image in pixels..',
  PRIMARY KEY (`fid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Cache images dimensions.' AUTO_INCREMENT=282 ;

--
-- Дамп данных таблицы `image_dimensions`
--

INSERT INTO `image_dimensions` (`fid`, `height`, `width`) VALUES
(83, 273, 478),
(84, 444, 598),
(274, 1080, 1920),
(275, 1080, 1920),
(276, 1080, 1920),
(277, 1080, 1920),
(278, 1080, 1920),
(279, 1080, 1920),
(280, 1080, 1920),
(281, 1080, 1920);

-- --------------------------------------------------------

--
-- Структура таблицы `image_effects`
--

DROP TABLE IF EXISTS `image_effects`;
CREATE TABLE IF NOT EXISTS `image_effects` (
  `ieid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image effect.',
  `isid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The image_styles.isid for an image style.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of the effect in the style.',
  `name` varchar(255) NOT NULL COMMENT 'The unique name of the effect to be executed.',
  `data` longblob NOT NULL COMMENT 'The configuration data for the effect.',
  PRIMARY KEY (`ieid`),
  KEY `isid` (`isid`),
  KEY `weight` (`weight`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image effects.' AUTO_INCREMENT=16 ;

--
-- Дамп данных таблицы `image_effects`
--

INSERT INTO `image_effects` (`ieid`, `isid`, `weight`, `name`, `data`) VALUES
(6, 5, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22333530223b733a363a22686569676874223b733a333a22323430223b7d),
(9, 8, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a323a223735223b733a363a22686569676874223b733a323a223735223b7d),
(10, 9, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313930223b733a363a22686569676874223b733a333a22313730223b7d),
(11, 10, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22353530223b733a363a22686569676874223b733a333a22333635223b7d),
(12, 11, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22323630223b733a363a22686569676874223b733a333a22323030223b7d),
(13, 12, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313530223b733a363a22686569676874223b733a323a223735223b7d),
(14, 13, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22383030223b733a363a22686569676874223b733a333a22323530223b7d),
(15, 14, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22333832223b733a363a22686569676874223b733a333a22333434223b7d);

-- --------------------------------------------------------

--
-- Структура таблицы `image_styles`
--

DROP TABLE IF EXISTS `image_styles`;
CREATE TABLE IF NOT EXISTS `image_styles` (
  `isid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image style.',
  `name` varchar(255) NOT NULL COMMENT 'The style name.',
  `label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The style administrative name.',
  PRIMARY KEY (`isid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image styles.' AUTO_INCREMENT=15 ;

--
-- Дамп данных таблицы `image_styles`
--

INSERT INTO `image_styles` (`isid`, `name`, `label`) VALUES
(5, 'gallery-3-column', 'gallery-3-column'),
(8, 'slider-bottom', 'slider-bottom'),
(9, 'services', 'services'),
(10, 'gallery-2-column', 'gallery-2-column'),
(11, 'gallery-4-column', 'gallery-4-column'),
(12, 'featured_in', 'featured_in'),
(13, 'image-blog', 'image-blog'),
(14, 'home_page', 'home_page');

-- --------------------------------------------------------

--
-- Структура таблицы `location`
--

DROP TABLE IF EXISTS `location`;
CREATE TABLE IF NOT EXISTS `location` (
  `lid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique location ID.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Place Name.',
  `street` varchar(255) NOT NULL DEFAULT '' COMMENT 'Street address, line 1.',
  `additional` varchar(255) NOT NULL DEFAULT '' COMMENT 'Street address, line 2.',
  `city` varchar(255) NOT NULL DEFAULT '' COMMENT 'City.',
  `province` varchar(16) NOT NULL DEFAULT '' COMMENT 'State / Province code.',
  `postal_code` varchar(16) NOT NULL DEFAULT '' COMMENT 'Postal / ZIP code.',
  `country` char(2) NOT NULL DEFAULT '' COMMENT 'Two letter ISO country code.',
  `latitude` decimal(10,6) NOT NULL DEFAULT '0.000000' COMMENT 'Location latitude (decimal degrees).',
  `longitude` decimal(10,6) NOT NULL DEFAULT '0.000000' COMMENT 'Location longitude (decimal degrees).',
  `source` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Source of the latitude and longitude data (Geocoder, user entered, invalid, etc.)',
  `is_primary` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Is this the primary location of an object? (unused, civicrm legacy field?).',
  PRIMARY KEY (`lid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Locational data managed by location.module.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `location_instance`
--

DROP TABLE IF EXISTS `location_instance`;
CREATE TABLE IF NOT EXISTS `location_instance` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Reference to node.nid.',
  `vid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Reference to node_revision.vid.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Reference to users.uid.',
  `genid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Generic reference key.',
  `lid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Reference to location.lid.',
  KEY `nid` (`nid`),
  KEY `vid` (`vid`),
  KEY `uid` (`uid`),
  KEY `genid` (`genid`),
  KEY `lid` (`lid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='N:M join table to join locations to other tables.';

-- --------------------------------------------------------

--
-- Структура таблицы `media_filter_usage`
--

DROP TABLE IF EXISTS `media_filter_usage`;
CREATE TABLE IF NOT EXISTS `media_filter_usage` (
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The media file_managed.fid.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The timestamp the fid was last recorded by media_filter()',
  PRIMARY KEY (`fid`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores fids that have been included in the media tag in...';

-- --------------------------------------------------------

--
-- Структура таблицы `media_gallery_weight`
--

DROP TABLE IF EXISTS `media_gallery_weight`;
CREATE TABLE IF NOT EXISTS `media_gallery_weight` (
  `tid` int(10) unsigned NOT NULL COMMENT 'The taxonomy term id corresponding to a media gallery collection.',
  `nid` int(10) unsigned NOT NULL COMMENT 'The node id of the media gallery.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of the media gallery within the collection.',
  PRIMARY KEY (`tid`,`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The weight of media galleries within a given collection.';

-- --------------------------------------------------------

--
-- Структура таблицы `media_list_type`
--

DROP TABLE IF EXISTS `media_list_type`;
CREATE TABLE IF NOT EXISTS `media_list_type` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The user.uid of the user.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The type of display (table or images).',
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the user preference for whether to list as table...';

--
-- Дамп данных таблицы `media_list_type`
--

INSERT INTO `media_list_type` (`uid`, `type`) VALUES
(1, 'thumbnails');

-- --------------------------------------------------------

--
-- Структура таблицы `media_type`
--

DROP TABLE IF EXISTS `media_type`;
CREATE TABLE IF NOT EXISTS `media_type` (
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The machine name of the media type.',
  `label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The label of the media type.',
  `base` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'If this is a base type (i.e. cannot be deleted)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of media type. Determines which one wins when claiming a piece of media (first wins)',
  `type_callback` varchar(255) DEFAULT '' COMMENT 'Callback to determine if provided media is of this type.',
  `type_callback_args` longtext COMMENT 'A serialized array of name value pairs that will be passed to the callback function',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the settings for media types.';

--
-- Дамп данных таблицы `media_type`
--

INSERT INTO `media_type` (`name`, `label`, `base`, `weight`, `type_callback`, `type_callback_args`) VALUES
('audio', 'Audio', 1, 0, 'media_is_type', 'a:4:{s:10:"match_type";s:3:"all";s:9:"mimetypes";a:1:{i:0;s:8:"/^audio/";}s:10:"extensions";a:3:{i:0;s:3:"mp3";i:1;s:3:"ogg";i:2;s:3:"wma";}s:7:"streams";a:2:{i:0;s:6:"public";i:1;s:7:"private";}}'),
('default', 'Other', 1, 1000, 'media_is_type', 'a:2:{s:10:"match_type";s:3:"any";s:9:"mimetypes";a:1:{i:0;s:4:"/.*/";}}'),
('image', 'Image', 1, 0, 'media_is_type', 'a:4:{s:10:"match_type";s:3:"all";s:9:"mimetypes";a:1:{i:0;s:8:"/^image/";}s:10:"extensions";a:5:{i:0;s:3:"jpg";i:1;s:4:"jpeg";i:2;s:3:"gif";i:3;s:3:"png";i:4;s:4:"tiff";}s:7:"streams";a:2:{i:0;s:6:"public";i:1;s:7:"private";}}'),
('video', 'Video', 1, 0, 'media_is_type', 'a:4:{s:10:"match_type";s:3:"all";s:9:"mimetypes";a:1:{i:0;s:8:"/^video/";}s:10:"extensions";a:3:{i:0;s:3:"mov";i:1;s:3:"mp4";i:2;s:3:"avi";}s:7:"streams";a:2:{i:0;s:6:"public";i:1;s:7:"private";}}');

-- --------------------------------------------------------

--
-- Структура таблицы `menu_custom`
--

DROP TABLE IF EXISTS `menu_custom`;
CREATE TABLE IF NOT EXISTS `menu_custom` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique key for menu. This is used as a block delta so length is 32.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Menu title; displayed at top of block.',
  `description` text COMMENT 'Menu description.',
  PRIMARY KEY (`menu_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds definitions for top-level custom menus (for example...';

--
-- Дамп данных таблицы `menu_custom`
--

INSERT INTO `menu_custom` (`menu_name`, `title`, `description`) VALUES
('main-menu', 'Main menu', 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.'),
('management', 'Management', 'The <em>Management</em> menu contains links for administrative tasks.'),
('menu-menu-secondary-menu', 'Secondary menu', ''),
('menu-top-menu', 'Top menu', ''),
('navigation', 'Navigation', 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.'),
('user-menu', 'User menu', 'The <em>User</em> menu contains links related to the user''s account, as well as the ''Log out'' link.');

-- --------------------------------------------------------

--
-- Структура таблицы `menu_links`
--

DROP TABLE IF EXISTS `menu_links`;
CREATE TABLE IF NOT EXISTS `menu_links` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ’navigation’) are part of the same menu.',
  `mlid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',
  `plid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The parent link ID (plid) is the mlid of the link above in the hierarchy, or zero if the link is at the top level in its menu.',
  `link_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The Drupal path or external path this link points to.',
  `router_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'For links corresponding to a Drupal path (external = 0), this connects the link to a menu_router.path for joins.',
  `link_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The text displayed for the link, which may be modified by a title callback stored in menu_router.',
  `options` blob COMMENT 'A serialized array of options to be passed to the url() or l() function, such as a query string or HTML attributes.',
  `module` varchar(255) NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',
  `hidden` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link should be rendered in menus. (1 = a disabled menu item that may be shown on admin screens, -1 = a menu callback, 0 = a normal, visible link)',
  `external` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).',
  `has_children` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any links have this link as a parent (1 = children exist, 0 = no children).',
  `expanded` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',
  `depth` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with plid == 0 will have depth == 1.',
  `customized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate that the user has manually created or edited the link (1 = customized, 0 = not customized).',
  `p1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the plid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',
  `p2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',
  `p3` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',
  `p4` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',
  `p5` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',
  `p6` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',
  `p7` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',
  `p8` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',
  `p9` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',
  `updated` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag that indicates that this link was generated during the update from Drupal 5.',
  PRIMARY KEY (`mlid`),
  KEY `path_menu` (`link_path`(128),`menu_name`),
  KEY `menu_plid_expand_child` (`menu_name`,`plid`,`expanded`,`has_children`),
  KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),
  KEY `router_path` (`router_path`(128))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the individual links within a menu.' AUTO_INCREMENT=1084 ;

--
-- Дамп данных таблицы `menu_links`
--

INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 1, 0, 'admin', 'admin', 'Administration', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 9, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 2, 0, 'user', 'user', 'User account', 0x613a313a7b733a353a22616c746572223b623a313b7d, 'system', 0, 0, 0, 0, -10, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 3, 0, 'comment/%', 'comment/%', 'Comment permalink', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 4, 0, 'filter/tips', 'filter/tips', 'Compose tips', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 5, 0, 'node/%', 'node/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 6, 0, 'node/add', 'node/add', 'Add content', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 7, 1, 'admin/appearance', 'admin/appearance', 'Appearance', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a2253656c65637420616e6420636f6e66696775726520796f7572207468656d65732e223b7d7d, 'system', 0, 0, 0, 0, -6, 2, 0, 1, 7, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 8, 1, 'admin/config', 'admin/config', 'Configuration', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32303a2241646d696e69737465722073657474696e67732e223b7d7d, 'system', 0, 0, 1, 0, 0, 2, 0, 1, 8, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 9, 1, 'admin/content', 'admin/content', 'Content', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33323a2241646d696e697374657220636f6e74656e7420616e6420636f6d6d656e74732e223b7d7d, 'system', 0, 0, 1, 0, -10, 2, 0, 1, 9, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 10, 2, 'user/register', 'user/register', 'Create new account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 10, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 11, 1, 'admin/dashboard', 'admin/dashboard', 'Dashboard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a225669657720616e6420637573746f6d697a6520796f75722064617368626f6172642e223b7d7d, 'system', 0, 0, 0, 0, -15, 2, 0, 1, 11, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 12, 1, 'admin/help', 'admin/help', 'Help', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34383a225265666572656e636520666f722075736167652c20636f6e66696775726174696f6e2c20616e64206d6f64756c65732e223b7d7d, 'system', 0, 0, 0, 0, 9, 2, 0, 1, 12, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 13, 1, 'admin/index', 'admin/index', 'Index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -18, 2, 0, 1, 13, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 14, 2, 'user/login', 'user/login', 'Log in', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 14, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 15, 0, 'user/logout', 'user/logout', 'Log out', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 10, 1, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 16, 1, 'admin/modules', 'admin/modules', 'Modules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a22457874656e6420736974652066756e6374696f6e616c6974792e223b7d7d, 'system', 0, 0, 0, 0, -2, 2, 0, 1, 16, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 17, 0, 'user/%', 'user/%', 'My account', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 18, 1, 'admin/people', 'admin/people', 'People', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a224d616e6167652075736572206163636f756e74732c20726f6c65732c20616e64207065726d697373696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -4, 2, 0, 1, 18, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 19, 1, 'admin/reports', 'admin/reports', 'Reports', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a2256696577207265706f7274732c20757064617465732c20616e64206572726f72732e223b7d7d, 'system', 0, 0, 1, 0, 5, 2, 0, 1, 19, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 20, 2, 'user/password', 'user/password', 'Request new password', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 20, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 21, 1, 'admin/structure', 'admin/structure', 'Structure', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a2241646d696e697374657220626c6f636b732c20636f6e74656e742074797065732c206d656e75732c206574632e223b7d7d, 'system', 0, 0, 1, 0, -8, 2, 0, 1, 21, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 22, 1, 'admin/tasks', 'admin/tasks', 'Tasks', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -20, 2, 0, 1, 22, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 23, 0, 'comment/reply/%', 'comment/reply/%', 'Add new comment', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 24, 3, 'comment/%/approve', 'comment/%/approve', 'Approve', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 1, 2, 0, 3, 24, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 25, 3, 'comment/%/delete', 'comment/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 3, 25, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 26, 3, 'comment/%/edit', 'comment/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 3, 26, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 27, 0, 'taxonomy/term/%', 'taxonomy/term/%', 'Taxonomy term', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 28, 3, 'comment/%/view', 'comment/%/view', 'View comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 3, 28, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 29, 18, 'admin/people/create', 'admin/people/create', 'Add user', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 18, 29, 0, 0, 0, 0, 0, 0, 0),
('management', 30, 21, 'admin/structure/block', 'admin/structure/block', 'Blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37393a22436f6e666967757265207768617420626c6f636b20636f6e74656e74206170706561727320696e20796f75722073697465277320736964656261727320616e64206f7468657220726567696f6e732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 30, 0, 0, 0, 0, 0, 0, 0),
('navigation', 31, 17, 'user/%/cancel', 'user/%/cancel', 'Cancel account', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 2, 0, 17, 31, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 32, 9, 'admin/content/comment', 'admin/content/comment', 'Comments', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35393a224c69737420616e642065646974207369746520636f6d6d656e747320616e642074686520636f6d6d656e7420617070726f76616c2071756575652e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 9, 32, 0, 0, 0, 0, 0, 0, 0),
('management', 33, 11, 'admin/dashboard/configure', 'admin/dashboard/configure', 'Configure available dashboard blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a22436f6e66696775726520776869636820626c6f636b732063616e2062652073686f776e206f6e207468652064617368626f6172642e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 11, 33, 0, 0, 0, 0, 0, 0, 0),
('management', 34, 9, 'admin/content/node', 'admin/content/node', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 9, 34, 0, 0, 0, 0, 0, 0, 0),
('management', 35, 8, 'admin/config/content', 'admin/config/content', 'Content authoring', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a2253657474696e67732072656c6174656420746f20666f726d617474696e6720616e6420617574686f72696e6720636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, -15, 3, 0, 1, 8, 35, 0, 0, 0, 0, 0, 0, 0),
('management', 36, 21, 'admin/structure/types', 'admin/structure/types', 'Content types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a39323a224d616e61676520636f6e74656e742074797065732c20696e636c7564696e672064656661756c74207374617475732c2066726f6e7420706167652070726f6d6f74696f6e2c20636f6d6d656e742073657474696e67732c206574632e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 36, 0, 0, 0, 0, 0, 0, 0),
('management', 37, 11, 'admin/dashboard/customize', 'admin/dashboard/customize', 'Customize dashboard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22437573746f6d697a6520796f75722064617368626f6172642e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 11, 37, 0, 0, 0, 0, 0, 0, 0),
('navigation', 38, 5, 'node/%/delete', 'node/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 2, 0, 5, 38, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 39, 8, 'admin/config/development', 'admin/config/development', 'Development', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31383a22446576656c6f706d656e7420746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 39, 0, 0, 0, 0, 0, 0, 0),
('navigation', 40, 17, 'user/%/edit', 'user/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 40, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 41, 5, 'node/%/edit', 'node/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 5, 41, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 43, 7, 'admin/appearance/list', 'admin/appearance/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a2253656c65637420616e6420636f6e66696775726520796f7572207468656d65223b7d7d, 'system', -1, 0, 0, 0, -1, 3, 0, 1, 7, 43, 0, 0, 0, 0, 0, 0, 0),
('management', 44, 16, 'admin/modules/list', 'admin/modules/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 16, 44, 0, 0, 0, 0, 0, 0, 0),
('management', 45, 18, 'admin/people/people', 'admin/people/people', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35303a2246696e6420616e64206d616e6167652070656f706c6520696e746572616374696e67207769746820796f757220736974652e223b7d7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 18, 45, 0, 0, 0, 0, 0, 0, 0),
('management', 46, 8, 'admin/config/media', 'admin/config/media', 'Media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31323a224d6564696120746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 46, 0, 0, 0, 0, 0, 0, 0),
('management', 47, 21, 'admin/structure/menu', 'admin/structure/menu', 'Menus', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38363a22416464206e6577206d656e757320746f20796f757220736974652c2065646974206578697374696e67206d656e75732c20616e642072656e616d6520616e642072656f7267616e697a65206d656e75206c696e6b732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 47, 0, 0, 0, 0, 0, 0, 0),
('management', 48, 8, 'admin/config/people', 'admin/config/people', 'People', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a22436f6e6669677572652075736572206163636f756e74732e223b7d7d, 'system', 0, 0, 1, 0, -20, 3, 0, 1, 8, 48, 0, 0, 0, 0, 0, 0, 0),
('management', 49, 18, 'admin/people/permissions', 'admin/people/permissions', 'Permissions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36343a2244657465726d696e652061636365737320746f2066656174757265732062792073656c656374696e67207065726d697373696f6e7320666f7220726f6c65732e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 18, 49, 0, 0, 0, 0, 0, 0, 0),
('management', 50, 19, 'admin/reports/dblog', 'admin/reports/dblog', 'Recent log messages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a2256696577206576656e74732074686174206861766520726563656e746c79206265656e206c6f676765642e223b7d7d, 'system', 0, 0, 0, 0, -1, 3, 0, 1, 19, 50, 0, 0, 0, 0, 0, 0, 0),
('management', 51, 8, 'admin/config/regional', 'admin/config/regional', 'Regional and language', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34383a22526567696f6e616c2073657474696e67732c206c6f63616c697a6174696f6e20616e64207472616e736c6174696f6e2e223b7d7d, 'system', 0, 0, 1, 0, -5, 3, 0, 1, 8, 51, 0, 0, 0, 0, 0, 0, 0),
('navigation', 52, 5, 'node/%/revisions', 'node/%/revisions', 'Revisions', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 2, 2, 0, 5, 52, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 53, 8, 'admin/config/search', 'admin/config/search', 'Search and metadata', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a224c6f63616c2073697465207365617263682c206d6574616461746120616e642053454f2e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 53, 0, 0, 0, 0, 0, 0, 0),
('management', 54, 7, 'admin/appearance/settings', 'admin/appearance/settings', 'Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a22436f6e6669677572652064656661756c7420616e64207468656d652073706563696669632073657474696e67732e223b7d7d, 'system', -1, 0, 0, 0, 20, 3, 0, 1, 7, 54, 0, 0, 0, 0, 0, 0, 0),
('management', 55, 19, 'admin/reports/status', 'admin/reports/status', 'Status report', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37343a22476574206120737461747573207265706f72742061626f757420796f757220736974652773206f7065726174696f6e20616e6420616e792064657465637465642070726f626c656d732e223b7d7d, 'system', 0, 0, 0, 0, -50, 3, 1, 1, 19, 55, 0, 0, 0, 0, 0, 0, 0),
('management', 56, 8, 'admin/config/system', 'admin/config/system', 'System', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2247656e6572616c2073797374656d2072656c6174656420636f6e66696775726174696f6e2e223b7d7d, 'system', 0, 0, 1, 0, -20, 3, 0, 1, 8, 56, 0, 0, 0, 0, 0, 0, 0),
('management', 57, 21, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Taxonomy', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36373a224d616e6167652074616767696e672c2063617465676f72697a6174696f6e2c20616e6420636c617373696669636174696f6e206f6620796f757220636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 57, 0, 0, 0, 0, 0, 0, 0),
('management', 58, 19, 'admin/reports/access-denied', 'admin/reports/access-denied', 'Top ''access denied'' errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33353a225669657720276163636573732064656e69656427206572726f7273202834303373292e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 58, 0, 0, 0, 0, 0, 0, 0),
('management', 59, 19, 'admin/reports/page-not-found', 'admin/reports/page-not-found', 'Top ''page not found'' errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a2256696577202770616765206e6f7420666f756e6427206572726f7273202834303473292e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 59, 0, 0, 0, 0, 0, 0, 0),
('management', 60, 16, 'admin/modules/uninstall', 'admin/modules/uninstall', 'Uninstall', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 3, 0, 1, 16, 60, 0, 0, 0, 0, 0, 0, 0),
('management', 61, 8, 'admin/config/user-interface', 'admin/config/user-interface', 'User interface', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a22546f6f6c73207468617420656e68616e636520746865207573657220696e746572666163652e223b7d7d, 'system', 0, 0, 1, 0, -15, 3, 0, 1, 8, 61, 0, 0, 0, 0, 0, 0, 0),
('navigation', 62, 5, 'node/%/view', 'node/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 5, 62, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 63, 17, 'user/%/view', 'user/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 17, 63, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 64, 8, 'admin/config/services', 'admin/config/services', 'Web services', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a22546f6f6c732072656c6174656420746f207765622073657276696365732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 8, 64, 0, 0, 0, 0, 0, 0, 0),
('management', 65, 8, 'admin/config/workflow', 'admin/config/workflow', 'Workflow', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22436f6e74656e7420776f726b666c6f772c20656469746f7269616c20776f726b666c6f7720746f6f6c732e223b7d7d, 'system', 0, 0, 0, 0, 5, 3, 0, 1, 8, 65, 0, 0, 0, 0, 0, 0, 0),
('management', 66, 12, 'admin/help/block', 'admin/help/block', 'block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 66, 0, 0, 0, 0, 0, 0, 0),
('management', 67, 12, 'admin/help/color', 'admin/help/color', 'color', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 67, 0, 0, 0, 0, 0, 0, 0),
('management', 68, 12, 'admin/help/comment', 'admin/help/comment', 'comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 68, 0, 0, 0, 0, 0, 0, 0),
('management', 69, 12, 'admin/help/contextual', 'admin/help/contextual', 'contextual', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 69, 0, 0, 0, 0, 0, 0, 0),
('management', 70, 12, 'admin/help/dashboard', 'admin/help/dashboard', 'dashboard', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 70, 0, 0, 0, 0, 0, 0, 0),
('management', 71, 12, 'admin/help/dblog', 'admin/help/dblog', 'dblog', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 71, 0, 0, 0, 0, 0, 0, 0),
('management', 72, 12, 'admin/help/field', 'admin/help/field', 'field', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 72, 0, 0, 0, 0, 0, 0, 0),
('management', 73, 12, 'admin/help/field_sql_storage', 'admin/help/field_sql_storage', 'field_sql_storage', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 73, 0, 0, 0, 0, 0, 0, 0),
('management', 75, 12, 'admin/help/file', 'admin/help/file', 'file', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 75, 0, 0, 0, 0, 0, 0, 0),
('management', 76, 12, 'admin/help/filter', 'admin/help/filter', 'filter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 76, 0, 0, 0, 0, 0, 0, 0),
('management', 77, 12, 'admin/help/help', 'admin/help/help', 'help', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 77, 0, 0, 0, 0, 0, 0, 0),
('management', 78, 12, 'admin/help/image', 'admin/help/image', 'image', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 78, 0, 0, 0, 0, 0, 0, 0),
('management', 79, 12, 'admin/help/list', 'admin/help/list', 'list', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 79, 0, 0, 0, 0, 0, 0, 0),
('management', 80, 12, 'admin/help/menu', 'admin/help/menu', 'menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 80, 0, 0, 0, 0, 0, 0, 0),
('management', 81, 12, 'admin/help/node', 'admin/help/node', 'node', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 81, 0, 0, 0, 0, 0, 0, 0),
('management', 82, 12, 'admin/help/options', 'admin/help/options', 'options', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 82, 0, 0, 0, 0, 0, 0, 0),
('management', 83, 12, 'admin/help/system', 'admin/help/system', 'system', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 83, 0, 0, 0, 0, 0, 0, 0),
('management', 84, 12, 'admin/help/taxonomy', 'admin/help/taxonomy', 'taxonomy', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 84, 0, 0, 0, 0, 0, 0, 0),
('management', 85, 12, 'admin/help/text', 'admin/help/text', 'text', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 85, 0, 0, 0, 0, 0, 0, 0),
('management', 86, 12, 'admin/help/user', 'admin/help/user', 'user', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 86, 0, 0, 0, 0, 0, 0, 0),
('navigation', 87, 27, 'taxonomy/term/%/edit', 'taxonomy/term/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 2, 0, 27, 87, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 88, 27, 'taxonomy/term/%/view', 'taxonomy/term/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 27, 88, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 89, 57, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 57, 89, 0, 0, 0, 0, 0, 0),
('management', 90, 48, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Account settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130393a22436f6e6669677572652064656661756c74206265686176696f72206f662075736572732c20696e636c7564696e6720726567697374726174696f6e20726571756972656d656e74732c20652d6d61696c732c206669656c64732c20616e6420757365722070696374757265732e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 48, 90, 0, 0, 0, 0, 0, 0),
('management', 91, 56, 'admin/config/system/actions', 'admin/config/system/actions', 'Actions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224d616e6167652074686520616374696f6e7320646566696e656420666f7220796f757220736974652e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 56, 91, 0, 0, 0, 0, 0, 0),
('management', 92, 30, 'admin/structure/block/add', 'admin/structure/block/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 92, 0, 0, 0, 0, 0, 0),
('management', 93, 36, 'admin/structure/types/add', 'admin/structure/types/add', 'Add content type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 36, 93, 0, 0, 0, 0, 0, 0),
('management', 94, 47, 'admin/structure/menu/add', 'admin/structure/menu/add', 'Add menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 47, 94, 0, 0, 0, 0, 0, 0),
('management', 95, 57, 'admin/structure/taxonomy/add', 'admin/structure/taxonomy/add', 'Add vocabulary', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 57, 95, 0, 0, 0, 0, 0, 0),
('management', 96, 54, 'admin/appearance/settings/bartik', 'admin/appearance/settings/bartik', 'Bartik', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 96, 0, 0, 0, 0, 0, 0),
('management', 97, 53, 'admin/config/search/clean-urls', 'admin/config/search/clean-urls', 'Clean URLs', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22456e61626c65206f722064697361626c6520636c65616e2055524c7320666f7220796f757220736974652e223b7d7d, 'system', 0, 0, 0, 0, 5, 4, 0, 1, 8, 53, 97, 0, 0, 0, 0, 0, 0),
('management', 98, 56, 'admin/config/system/cron', 'admin/config/system/cron', 'Cron', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34303a224d616e616765206175746f6d617469632073697465206d61696e74656e616e6365207461736b732e223b7d7d, 'system', 0, 0, 0, 0, 20, 4, 0, 1, 8, 56, 98, 0, 0, 0, 0, 0, 0),
('management', 99, 51, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Date and time', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34343a22436f6e66696775726520646973706c617920666f726d61747320666f72206461746520616e642074696d652e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 51, 99, 0, 0, 0, 0, 0, 0),
('management', 100, 19, 'admin/reports/event/%', 'admin/reports/event/%', 'Details', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 100, 0, 0, 0, 0, 0, 0, 0),
('management', 101, 46, 'admin/config/media/file-system', 'admin/config/media/file-system', 'File system', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36383a2254656c6c2044727570616c20776865726520746f2073746f72652075706c6f616465642066696c657320616e6420686f772074686579206172652061636365737365642e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 46, 101, 0, 0, 0, 0, 0, 0),
('management', 102, 54, 'admin/appearance/settings/garland', 'admin/appearance/settings/garland', 'Garland', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 102, 0, 0, 0, 0, 0, 0),
('management', 103, 54, 'admin/appearance/settings/global', 'admin/appearance/settings/global', 'Global settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -1, 4, 0, 1, 7, 54, 103, 0, 0, 0, 0, 0, 0),
('management', 104, 48, 'admin/config/people/ip-blocking', 'admin/config/people/ip-blocking', 'IP address blocking', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224d616e61676520626c6f636b6564204950206164647265737365732e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 8, 48, 104, 0, 0, 0, 0, 0, 0),
('management', 105, 46, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Image styles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37383a22436f6e666967757265207374796c657320746861742063616e206265207573656420666f7220726573697a696e67206f722061646a757374696e6720696d61676573206f6e20646973706c61792e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 46, 105, 0, 0, 0, 0, 0, 0),
('management', 106, 46, 'admin/config/media/image-toolkit', 'admin/config/media/image-toolkit', 'Image toolkit', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37343a2243686f6f736520776869636820696d61676520746f6f6c6b697420746f2075736520696620796f75206861766520696e7374616c6c6564206f7074696f6e616c20746f6f6c6b6974732e223b7d7d, 'system', 0, 0, 0, 0, 20, 4, 0, 1, 8, 46, 106, 0, 0, 0, 0, 0, 0),
('management', 107, 44, 'admin/modules/list/confirm', 'admin/modules/list/confirm', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 16, 44, 107, 0, 0, 0, 0, 0, 0),
('management', 108, 36, 'admin/structure/types/list', 'admin/structure/types/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 36, 108, 0, 0, 0, 0, 0, 0),
('management', 109, 57, 'admin/structure/taxonomy/list', 'admin/structure/taxonomy/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 57, 109, 0, 0, 0, 0, 0, 0),
('management', 110, 47, 'admin/structure/menu/list', 'admin/structure/menu/list', 'List menus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 47, 110, 0, 0, 0, 0, 0, 0),
('management', 111, 39, 'admin/config/development/logging', 'admin/config/development/logging', 'Logging and errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3135343a2253657474696e677320666f72206c6f6767696e6720616e6420616c65727473206d6f64756c65732e20566172696f7573206d6f64756c65732063616e20726f7574652044727570616c27732073797374656d206576656e747320746f20646966666572656e742064657374696e6174696f6e732c2073756368206173207379736c6f672c2064617461626173652c20656d61696c2c206574632e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 39, 111, 0, 0, 0, 0, 0, 0),
('management', 112, 39, 'admin/config/development/maintenance', 'admin/config/development/maintenance', 'Maintenance mode', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36323a2254616b65207468652073697465206f66666c696e6520666f72206d61696e74656e616e6365206f72206272696e67206974206261636b206f6e6c696e652e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 39, 112, 0, 0, 0, 0, 0, 0),
('management', 113, 39, 'admin/config/development/performance', 'admin/config/development/performance', 'Performance', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130313a22456e61626c65206f722064697361626c6520706167652063616368696e6720666f7220616e6f6e796d6f757320757365727320616e64207365742043535320616e64204a532062616e647769647468206f7074696d697a6174696f6e206f7074696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 39, 113, 0, 0, 0, 0, 0, 0),
('management', 114, 49, 'admin/people/permissions/list', 'admin/people/permissions/list', 'Permissions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36343a2244657465726d696e652061636365737320746f2066656174757265732062792073656c656374696e67207065726d697373696f6e7320666f7220726f6c65732e223b7d7d, 'system', -1, 0, 0, 0, -8, 4, 0, 1, 18, 49, 114, 0, 0, 0, 0, 0, 0),
('management', 115, 32, 'admin/content/comment/new', 'admin/content/comment/new', 'Published comments', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 9, 32, 115, 0, 0, 0, 0, 0, 0),
('management', 116, 64, 'admin/config/services/rss-publishing', 'admin/config/services/rss-publishing', 'RSS publishing', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3131343a22436f6e666967757265207468652073697465206465736372697074696f6e2c20746865206e756d626572206f66206974656d7320706572206665656420616e6420776865746865722066656564732073686f756c64206265207469746c65732f746561736572732f66756c6c2d746578742e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 64, 116, 0, 0, 0, 0, 0, 0),
('management', 117, 51, 'admin/config/regional/settings', 'admin/config/regional/settings', 'Regional settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35343a2253657474696e677320666f7220746865207369746527732064656661756c742074696d65207a6f6e6520616e6420636f756e7472792e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 51, 117, 0, 0, 0, 0, 0, 0),
('management', 118, 49, 'admin/people/permissions/roles', 'admin/people/permissions/roles', 'Roles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a224c6973742c20656469742c206f7220616464207573657220726f6c65732e223b7d7d, 'system', -1, 0, 1, 0, -5, 4, 0, 1, 18, 49, 118, 0, 0, 0, 0, 0, 0),
('management', 119, 47, 'admin/structure/menu/settings', 'admin/structure/menu/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 4, 0, 1, 21, 47, 119, 0, 0, 0, 0, 0, 0),
('management', 120, 54, 'admin/appearance/settings/seven', 'admin/appearance/settings/seven', 'Seven', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 120, 0, 0, 0, 0, 0, 0),
('management', 121, 56, 'admin/config/system/site-information', 'admin/config/system/site-information', 'Site information', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130343a224368616e67652073697465206e616d652c20652d6d61696c20616464726573732c20736c6f67616e2c2064656661756c742066726f6e7420706167652c20616e64206e756d626572206f6620706f7374732070657220706167652c206572726f722070616765732e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 56, 121, 0, 0, 0, 0, 0, 0),
('management', 122, 54, 'admin/appearance/settings/stark', 'admin/appearance/settings/stark', 'Stark', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 122, 0, 0, 0, 0, 0, 0),
('management', 123, 35, 'admin/config/content/formats', 'admin/config/content/formats', 'Text formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3132373a22436f6e66696775726520686f7720636f6e74656e7420696e7075742062792075736572732069732066696c74657265642c20696e636c7564696e6720616c6c6f7765642048544d4c20746167732e20416c736f20616c6c6f777320656e61626c696e67206f66206d6f64756c652d70726f76696465642066696c746572732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 35, 123, 0, 0, 0, 0, 0, 0),
('management', 124, 32, 'admin/content/comment/approval', 'admin/content/comment/approval', 'Unapproved comments', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 9, 32, 124, 0, 0, 0, 0, 0, 0),
('management', 125, 60, 'admin/modules/uninstall/confirm', 'admin/modules/uninstall/confirm', 'Uninstall', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 16, 60, 125, 0, 0, 0, 0, 0, 0),
('navigation', 126, 40, 'user/%/edit/account', 'user/%/edit/account', 'Account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 17, 40, 126, 0, 0, 0, 0, 0, 0, 0),
('management', 127, 123, 'admin/config/content/formats/%', 'admin/config/content/formats/%', '', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 35, 123, 127, 0, 0, 0, 0, 0),
('management', 128, 105, 'admin/config/media/image-styles/add', 'admin/config/media/image-styles/add', 'Add style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a224164642061206e657720696d616765207374796c652e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 46, 105, 128, 0, 0, 0, 0, 0),
('management', 129, 89, 'admin/structure/taxonomy/%/add', 'admin/structure/taxonomy/%/add', 'Add term', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 57, 89, 129, 0, 0, 0, 0, 0),
('management', 130, 123, 'admin/config/content/formats/add', 'admin/config/content/formats/add', 'Add text format', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 35, 123, 130, 0, 0, 0, 0, 0),
('management', 131, 30, 'admin/structure/block/list/bartik', 'admin/structure/block/list/bartik', 'Bartik', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 131, 0, 0, 0, 0, 0, 0),
('management', 132, 91, 'admin/config/system/actions/configure', 'admin/config/system/actions/configure', 'Configure an advanced action', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 56, 91, 132, 0, 0, 0, 0, 0),
('management', 133, 47, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Customize menu', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 21, 47, 133, 0, 0, 0, 0, 0, 0),
('management', 134, 89, 'admin/structure/taxonomy/%/edit', 'admin/structure/taxonomy/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 57, 89, 134, 0, 0, 0, 0, 0),
('management', 135, 36, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Edit content type', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 21, 36, 135, 0, 0, 0, 0, 0, 0),
('management', 136, 99, 'admin/config/regional/date-time/formats', 'admin/config/regional/date-time/formats', 'Formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35313a22436f6e66696775726520646973706c617920666f726d617420737472696e677320666f72206461746520616e642074696d652e223b7d7d, 'system', -1, 0, 1, 0, -9, 5, 0, 1, 8, 51, 99, 136, 0, 0, 0, 0, 0),
('management', 137, 30, 'admin/structure/block/list/garland', 'admin/structure/block/list/garland', 'Garland', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 137, 0, 0, 0, 0, 0, 0),
('management', 138, 123, 'admin/config/content/formats/list', 'admin/config/content/formats/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 35, 123, 138, 0, 0, 0, 0, 0),
('management', 139, 89, 'admin/structure/taxonomy/%/list', 'admin/structure/taxonomy/%/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -20, 5, 0, 1, 21, 57, 89, 139, 0, 0, 0, 0, 0),
('management', 140, 105, 'admin/config/media/image-styles/list', 'admin/config/media/image-styles/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a224c697374207468652063757272656e7420696d616765207374796c6573206f6e2074686520736974652e223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 46, 105, 140, 0, 0, 0, 0, 0),
('management', 141, 91, 'admin/config/system/actions/manage', 'admin/config/system/actions/manage', 'Manage actions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224d616e6167652074686520616374696f6e7320646566696e656420666f7220796f757220736974652e223b7d7d, 'system', -1, 0, 0, 0, -2, 5, 0, 1, 8, 56, 91, 141, 0, 0, 0, 0, 0),
('management', 142, 90, 'admin/config/people/accounts/settings', 'admin/config/people/accounts/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 48, 90, 142, 0, 0, 0, 0, 0),
('management', 143, 30, 'admin/structure/block/list/seven', 'admin/structure/block/list/seven', 'Seven', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 143, 0, 0, 0, 0, 0, 0),
('management', 144, 30, 'admin/structure/block/list/stark', 'admin/structure/block/list/stark', 'Stark', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 144, 0, 0, 0, 0, 0, 0),
('management', 145, 99, 'admin/config/regional/date-time/types', 'admin/config/regional/date-time/types', 'Types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34343a22436f6e66696775726520646973706c617920666f726d61747320666f72206461746520616e642074696d652e223b7d7d, 'system', -1, 0, 1, 0, -10, 5, 0, 1, 8, 51, 99, 145, 0, 0, 0, 0, 0),
('navigation', 146, 52, 'node/%/revisions/%/delete', 'node/%/revisions/%/delete', 'Delete earlier revision', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 52, 146, 0, 0, 0, 0, 0, 0, 0),
('navigation', 147, 52, 'node/%/revisions/%/revert', 'node/%/revisions/%/revert', 'Revert to earlier revision', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 52, 147, 0, 0, 0, 0, 0, 0, 0),
('navigation', 148, 52, 'node/%/revisions/%/view', 'node/%/revisions/%/view', 'Revisions', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 52, 148, 0, 0, 0, 0, 0, 0, 0),
('management', 151, 144, 'admin/structure/block/list/stark/add', 'admin/structure/block/list/stark/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 144, 151, 0, 0, 0, 0, 0),
('management', 152, 145, 'admin/config/regional/date-time/types/add', 'admin/config/regional/date-time/types/add', 'Add date type', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31383a22416464206e6577206461746520747970652e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 51, 99, 145, 152, 0, 0, 0, 0),
('management', 153, 136, 'admin/config/regional/date-time/formats/add', 'admin/config/regional/date-time/formats/add', 'Add format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22416c6c6f7720757365727320746f20616464206164646974696f6e616c206461746520666f726d6174732e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 51, 99, 136, 153, 0, 0, 0, 0),
('management', 154, 133, 'admin/structure/menu/manage/%/add', 'admin/structure/menu/manage/%/add', 'Add link', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 47, 133, 154, 0, 0, 0, 0, 0),
('management', 155, 30, 'admin/structure/block/manage/%/%', 'admin/structure/block/manage/%/%', 'Configure block', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 30, 155, 0, 0, 0, 0, 0, 0),
('navigation', 156, 31, 'user/%/cancel/confirm/%/%', 'user/%/cancel/confirm/%/%', 'Confirm account cancellation', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 17, 31, 156, 0, 0, 0, 0, 0, 0, 0),
('management', 157, 135, 'admin/structure/types/manage/%/delete', 'admin/structure/types/manage/%/delete', 'Delete', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 36, 135, 157, 0, 0, 0, 0, 0),
('management', 158, 104, 'admin/config/people/ip-blocking/delete/%', 'admin/config/people/ip-blocking/delete/%', 'Delete IP address', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 48, 104, 158, 0, 0, 0, 0, 0),
('management', 159, 91, 'admin/config/system/actions/delete/%', 'admin/config/system/actions/delete/%', 'Delete action', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31373a2244656c65746520616e20616374696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 56, 91, 159, 0, 0, 0, 0, 0),
('management', 160, 133, 'admin/structure/menu/manage/%/delete', 'admin/structure/menu/manage/%/delete', 'Delete menu', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 47, 133, 160, 0, 0, 0, 0, 0),
('management', 161, 47, 'admin/structure/menu/item/%/delete', 'admin/structure/menu/item/%/delete', 'Delete menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 161, 0, 0, 0, 0, 0, 0),
('management', 162, 118, 'admin/people/permissions/roles/delete/%', 'admin/people/permissions/roles/delete/%', 'Delete role', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 18, 49, 118, 162, 0, 0, 0, 0, 0),
('management', 163, 127, 'admin/config/content/formats/%/disable', 'admin/config/content/formats/%/disable', 'Disable text format', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 35, 123, 127, 163, 0, 0, 0, 0),
('management', 164, 135, 'admin/structure/types/manage/%/edit', 'admin/structure/types/manage/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 36, 135, 164, 0, 0, 0, 0, 0),
('management', 165, 133, 'admin/structure/menu/manage/%/edit', 'admin/structure/menu/manage/%/edit', 'Edit menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 47, 133, 165, 0, 0, 0, 0, 0),
('management', 166, 47, 'admin/structure/menu/item/%/edit', 'admin/structure/menu/item/%/edit', 'Edit menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 166, 0, 0, 0, 0, 0, 0),
('management', 167, 118, 'admin/people/permissions/roles/edit/%', 'admin/people/permissions/roles/edit/%', 'Edit role', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 18, 49, 118, 167, 0, 0, 0, 0, 0),
('management', 168, 105, 'admin/config/media/image-styles/edit/%', 'admin/config/media/image-styles/edit/%', 'Edit style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22436f6e66696775726520616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 46, 105, 168, 0, 0, 0, 0, 0),
('management', 169, 133, 'admin/structure/menu/manage/%/list', 'admin/structure/menu/manage/%/list', 'List links', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 47, 133, 169, 0, 0, 0, 0, 0),
('management', 170, 47, 'admin/structure/menu/item/%/reset', 'admin/structure/menu/item/%/reset', 'Reset menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 170, 0, 0, 0, 0, 0, 0),
('management', 171, 105, 'admin/config/media/image-styles/delete/%', 'admin/config/media/image-styles/delete/%', 'Delete style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2244656c65746520616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 46, 105, 171, 0, 0, 0, 0, 0),
('management', 172, 105, 'admin/config/media/image-styles/revert/%', 'admin/config/media/image-styles/revert/%', 'Revert style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2252657665727420616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 46, 105, 172, 0, 0, 0, 0, 0),
('management', 173, 135, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%/comment/display', 'Comment display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 5, 0, 1, 21, 36, 135, 173, 0, 0, 0, 0, 0),
('management', 174, 135, 'admin/structure/types/manage/%/comment/fields', 'admin/structure/types/manage/%/comment/fields', 'Comment fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 3, 5, 0, 1, 21, 36, 135, 174, 0, 0, 0, 0, 0),
('management', 175, 155, 'admin/structure/block/manage/%/%/configure', 'admin/structure/block/manage/%/%/configure', 'Configure block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 155, 175, 0, 0, 0, 0, 0),
('management', 176, 155, 'admin/structure/block/manage/%/%/delete', 'admin/structure/block/manage/%/%/delete', 'Delete block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 155, 176, 0, 0, 0, 0, 0),
('management', 177, 136, 'admin/config/regional/date-time/formats/%/delete', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22416c6c6f7720757365727320746f2064656c657465206120636f6e66696775726564206461746520666f726d61742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 51, 99, 136, 177, 0, 0, 0, 0),
('management', 178, 145, 'admin/config/regional/date-time/types/%/delete', 'admin/config/regional/date-time/types/%/delete', 'Delete date type', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22416c6c6f7720757365727320746f2064656c657465206120636f6e66696775726564206461746520747970652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 51, 99, 145, 178, 0, 0, 0, 0),
('management', 179, 136, 'admin/config/regional/date-time/formats/%/edit', 'admin/config/regional/date-time/formats/%/edit', 'Edit date format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22416c6c6f7720757365727320746f2065646974206120636f6e66696775726564206461746520666f726d61742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 51, 99, 136, 179, 0, 0, 0, 0),
('management', 180, 168, 'admin/config/media/image-styles/edit/%/add/%', 'admin/config/media/image-styles/edit/%/add/%', 'Add image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224164642061206e65772065666665637420746f2061207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 46, 105, 168, 180, 0, 0, 0, 0),
('management', 181, 168, 'admin/config/media/image-styles/edit/%/effects/%', 'admin/config/media/image-styles/edit/%/effects/%', 'Edit image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a224564697420616e206578697374696e67206566666563742077697468696e2061207374796c652e223b7d7d, 'system', 0, 0, 1, 0, 0, 6, 0, 1, 8, 46, 105, 168, 181, 0, 0, 0, 0),
('management', 182, 181, 'admin/config/media/image-styles/edit/%/effects/%/delete', 'admin/config/media/image-styles/edit/%/effects/%/delete', 'Delete image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a2244656c65746520616e206578697374696e67206566666563742066726f6d2061207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 46, 105, 168, 181, 182, 0, 0, 0),
('management', 183, 47, 'admin/structure/menu/manage/main-menu', 'admin/structure/menu/manage/%', 'Main menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 183, 0, 0, 0, 0, 0, 0),
('management', 184, 47, 'admin/structure/menu/manage/management', 'admin/structure/menu/manage/%', 'Management', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 184, 0, 0, 0, 0, 0, 0),
('management', 185, 47, 'admin/structure/menu/manage/navigation', 'admin/structure/menu/manage/%', 'Navigation', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 185, 0, 0, 0, 0, 0, 0),
('management', 186, 47, 'admin/structure/menu/manage/user-menu', 'admin/structure/menu/manage/%', 'User menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 186, 0, 0, 0, 0, 0, 0),
('navigation', 187, 0, 'search', 'search', 'Search', 0x613a303a7b7d, 'system', 1, 0, 1, 0, 0, 1, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 188, 187, 'search/node', 'search/node', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 187, 188, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 189, 187, 'search/user', 'search/user', 'Users', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 187, 189, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 190, 188, 'search/node/%', 'search/node/%', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 187, 188, 190, 0, 0, 0, 0, 0, 0, 0),
('navigation', 191, 17, 'user/%/shortcuts', 'user/%/shortcuts', 'Shortcuts', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 191, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 192, 19, 'admin/reports/search', 'admin/reports/search', 'Top search phrases', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a2256696577206d6f737420706f70756c61722073656172636820706872617365732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 192, 0, 0, 0, 0, 0, 0, 0),
('navigation', 193, 189, 'search/user/%', 'search/user/%', 'Users', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 187, 189, 193, 0, 0, 0, 0, 0, 0, 0),
('management', 194, 12, 'admin/help/number', 'admin/help/number', 'number', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 194, 0, 0, 0, 0, 0, 0, 0),
('management', 196, 12, 'admin/help/path', 'admin/help/path', 'path', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 196, 0, 0, 0, 0, 0, 0, 0),
('management', 197, 12, 'admin/help/rdf', 'admin/help/rdf', 'rdf', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 197, 0, 0, 0, 0, 0, 0, 0),
('management', 198, 12, 'admin/help/search', 'admin/help/search', 'search', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 198, 0, 0, 0, 0, 0, 0, 0),
('management', 199, 12, 'admin/help/shortcut', 'admin/help/shortcut', 'shortcut', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 199, 0, 0, 0, 0, 0, 0, 0),
('management', 200, 53, 'admin/config/search/settings', 'admin/config/search/settings', 'Search settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36373a22436f6e6669677572652072656c6576616e63652073657474696e677320666f722073656172636820616e64206f7468657220696e646578696e67206f7074696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 53, 200, 0, 0, 0, 0, 0, 0),
('management', 201, 61, 'admin/config/user-interface/shortcut', 'admin/config/user-interface/shortcut', 'Shortcuts', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32393a2241646420616e64206d6f646966792073686f727463757420736574732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 61, 201, 0, 0, 0, 0, 0, 0),
('management', 202, 53, 'admin/config/search/path', 'admin/config/search/path', 'URL aliases', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a224368616e676520796f7572207369746527732055524c20706174687320627920616c696173696e67207468656d2e223b7d7d, 'system', 0, 0, 1, 0, -5, 4, 0, 1, 8, 53, 202, 0, 0, 0, 0, 0, 0),
('management', 203, 202, 'admin/config/search/path/add', 'admin/config/search/path/add', 'Add alias', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 53, 202, 203, 0, 0, 0, 0, 0),
('management', 204, 201, 'admin/config/user-interface/shortcut/add-set', 'admin/config/user-interface/shortcut/add-set', 'Add shortcut set', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 61, 201, 204, 0, 0, 0, 0, 0),
('management', 205, 200, 'admin/config/search/settings/reindex', 'admin/config/search/settings/reindex', 'Clear index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 53, 200, 205, 0, 0, 0, 0, 0),
('management', 206, 201, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Edit shortcuts', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 61, 201, 206, 0, 0, 0, 0, 0),
('management', 207, 202, 'admin/config/search/path/list', 'admin/config/search/path/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 53, 202, 207, 0, 0, 0, 0, 0),
('management', 208, 206, 'admin/config/user-interface/shortcut/%/add-link', 'admin/config/user-interface/shortcut/%/add-link', 'Add shortcut', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 61, 201, 206, 208, 0, 0, 0, 0),
('management', 209, 202, 'admin/config/search/path/delete/%', 'admin/config/search/path/delete/%', 'Delete alias', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 53, 202, 209, 0, 0, 0, 0, 0);
INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 210, 206, 'admin/config/user-interface/shortcut/%/delete', 'admin/config/user-interface/shortcut/%/delete', 'Delete shortcut set', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 61, 201, 206, 210, 0, 0, 0, 0),
('management', 211, 202, 'admin/config/search/path/edit/%', 'admin/config/search/path/edit/%', 'Edit alias', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 53, 202, 211, 0, 0, 0, 0, 0),
('management', 212, 206, 'admin/config/user-interface/shortcut/%/edit', 'admin/config/user-interface/shortcut/%/edit', 'Edit set name', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 6, 0, 1, 8, 61, 201, 206, 212, 0, 0, 0, 0),
('management', 213, 201, 'admin/config/user-interface/shortcut/link/%', 'admin/config/user-interface/shortcut/link/%', 'Edit shortcut', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 61, 201, 213, 0, 0, 0, 0, 0),
('management', 214, 206, 'admin/config/user-interface/shortcut/%/links', 'admin/config/user-interface/shortcut/%/links', 'List links', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 61, 201, 206, 214, 0, 0, 0, 0),
('management', 215, 213, 'admin/config/user-interface/shortcut/link/%/delete', 'admin/config/user-interface/shortcut/link/%/delete', 'Delete shortcut', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 61, 201, 213, 215, 0, 0, 0, 0),
('shortcut-set-1', 216, 0, 'node/add', 'node/add', 'Add content', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -50, 1, 0, 216, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 217, 0, 'admin/content', 'admin/content', 'Find content', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -49, 1, 0, 217, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 218, 0, '<front>', '', 'Home', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, -50, 1, 1, 218, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 219, 6, 'node/add/article', 'node/add/article', 'Article', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38393a22557365203c656d3e61727469636c65733c2f656d3e20666f722074696d652d73656e73697469766520636f6e74656e74206c696b65206e6577732c2070726573732072656c6561736573206f7220626c6f6720706f7374732e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 219, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 220, 6, 'node/add/page', 'node/add/page', 'Basic page', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37373a22557365203c656d3e62617369632070616765733c2f656d3e20666f7220796f75722073746174696320636f6e74656e742c207375636820617320616e202741626f75742075732720706167652e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 220, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 352, 131, 'admin/structure/block/list/bartik/add', 'admin/structure/block/list/bartik/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 131, 352, 0, 0, 0, 0, 0),
('management', 353, 12, 'admin/help/wysiwyg', 'admin/help/wysiwyg', 'wysiwyg', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 353, 0, 0, 0, 0, 0, 0, 0),
('management', 354, 35, 'admin/config/content/wysiwyg', 'admin/config/content/wysiwyg', 'Wysiwyg profiles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a22436f6e66696775726520636c69656e742d7369646520656469746f72732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 35, 354, 0, 0, 0, 0, 0, 0),
('management', 355, 354, 'admin/config/content/wysiwyg/profile', 'admin/config/content/wysiwyg/profile', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 35, 354, 355, 0, 0, 0, 0, 0),
('management', 356, 355, 'admin/config/content/wysiwyg/profile/%/edit', 'admin/config/content/wysiwyg/profile/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 354, 355, 356, 0, 0, 0, 0),
('management', 357, 355, 'admin/config/content/wysiwyg/profile/%/delete', 'admin/config/content/wysiwyg/profile/%/delete', 'Remove', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 6, 0, 1, 8, 35, 354, 355, 357, 0, 0, 0, 0),
('management', 360, 21, 'admin/structure/views', 'admin/structure/views', 'Views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33353a224d616e61676520637573746f6d697a6564206c69737473206f6620636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 360, 0, 0, 0, 0, 0, 0, 0),
('management', 361, 19, 'admin/reports/views-plugins', 'admin/reports/views-plugins', 'Views plugins', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a224f76657276696577206f6620706c7567696e73207573656420696e20616c6c2076696577732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 361, 0, 0, 0, 0, 0, 0, 0),
('management', 362, 360, 'admin/structure/views/add', 'admin/structure/views/add', 'Add new view', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 360, 362, 0, 0, 0, 0, 0, 0),
('management', 363, 360, 'admin/structure/views/add-template', 'admin/structure/views/add-template', 'Add view from template', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 360, 363, 0, 0, 0, 0, 0, 0),
('management', 364, 360, 'admin/structure/views/import', 'admin/structure/views/import', 'Import', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 360, 364, 0, 0, 0, 0, 0, 0),
('management', 365, 360, 'admin/structure/views/list', 'admin/structure/views/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 360, 365, 0, 0, 0, 0, 0, 0),
('management', 366, 19, 'admin/reports/fields/list', 'admin/reports/fields/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 19, 366, 0, 0, 0, 0, 0, 0, 0),
('management', 367, 360, 'admin/structure/views/settings', 'admin/structure/views/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 360, 367, 0, 0, 0, 0, 0, 0),
('management', 368, 19, 'admin/reports/fields/views-fields', 'admin/reports/fields/views-fields', 'Used in views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a224f76657276696577206f66206669656c6473207573656420696e20616c6c2076696577732e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 19, 368, 0, 0, 0, 0, 0, 0, 0),
('management', 369, 367, 'admin/structure/views/settings/advanced', 'admin/structure/views/settings/advanced', 'Advanced', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 21, 360, 367, 369, 0, 0, 0, 0, 0),
('management', 370, 367, 'admin/structure/views/settings/basic', 'admin/structure/views/settings/basic', 'Basic', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 367, 370, 0, 0, 0, 0, 0),
('management', 371, 360, 'admin/structure/views/view/%', 'admin/structure/views/view/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 360, 371, 0, 0, 0, 0, 0, 0),
('management', 372, 371, 'admin/structure/views/view/%/break-lock', 'admin/structure/views/view/%/break-lock', 'Break lock', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 371, 372, 0, 0, 0, 0, 0),
('management', 373, 371, 'admin/structure/views/view/%/edit', 'admin/structure/views/view/%/edit', 'Edit view', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 360, 371, 373, 0, 0, 0, 0, 0),
('management', 374, 371, 'admin/structure/views/view/%/clone', 'admin/structure/views/view/%/clone', 'Clone', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 371, 374, 0, 0, 0, 0, 0),
('management', 375, 371, 'admin/structure/views/view/%/delete', 'admin/structure/views/view/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 371, 375, 0, 0, 0, 0, 0),
('management', 376, 371, 'admin/structure/views/view/%/export', 'admin/structure/views/view/%/export', 'Export', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 371, 376, 0, 0, 0, 0, 0),
('management', 377, 371, 'admin/structure/views/view/%/revert', 'admin/structure/views/view/%/revert', 'Revert', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 371, 377, 0, 0, 0, 0, 0),
('management', 378, 360, 'admin/structure/views/ajax/preview/%/%', 'admin/structure/views/ajax/preview/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 360, 378, 0, 0, 0, 0, 0, 0),
('management', 379, 360, 'admin/structure/views/nojs/preview/%/%', 'admin/structure/views/nojs/preview/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 360, 379, 0, 0, 0, 0, 0, 0),
('management', 380, 371, 'admin/structure/views/view/%/preview/%', 'admin/structure/views/view/%/preview/%', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 360, 371, 380, 0, 0, 0, 0, 0),
('management', 383, 30, 'admin/structure/block/imageblock_add', 'admin/structure/block/imageblock_add', 'Add image block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 383, 0, 0, 0, 0, 0, 0),
('management', 384, 30, 'admin/structure/block/imageblock_configure', 'admin/structure/block/imageblock_configure', 'Image block settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a22436f6e66696775726520496d61676520626c6f636b2073657474696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 30, 384, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 458, 0, 'admin/structure', 'admin/structure', 'Structure', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -48, 1, 0, 458, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 459, 0, 'admin/structure', 'admin/structure', 'Structure', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -47, 1, 0, 459, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 464, 0, 'contact', 'contact', 'Contact Us', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -44, 1, 1, 464, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 465, 0, 'http://ordasoft.com', '', 'Template features', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 1, 1, -47, 1, 1, 465, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 466, 0, 'http://ordasoft.com', '', 'Elements', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 1, 1, -48, 1, 1, 466, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 467, 465, 'quickstart', 'quickstart', 'Quickstart package', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -50, 2, 1, 465, 467, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 468, 465, 'typography', 'typography', 'Typography', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -48, 2, 1, 465, 468, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 469, 465, 'responsive', 'responsive', 'Responsive layout', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -49, 2, 1, 465, 469, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 470, 465, 'ghplu', 'ghplu', '404 Page', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -50, 2, 1, 465, 470, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 472, 466, 'buttons', 'buttons', 'Buttons', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -50, 2, 1, 466, 472, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 473, 466, 'notifications', 'notifications', 'Notifications', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -47, 2, 1, 466, 473, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 474, 466, 'tooltips', 'tooltips', 'Tooltips', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -46, 2, 1, 466, 474, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 475, 466, 'icons', 'icons', 'Icons', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -44, 2, 1, 466, 475, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 476, 466, 'bars', 'bars', 'Progress bars', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -45, 2, 1, 466, 476, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 477, 466, 'accordion', 'accordion', 'Tabs and accordion', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -48, 2, 1, 466, 477, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 478, 466, 'bages', 'bages', 'Labels and bages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -49, 2, 1, 466, 478, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 479, 21, 'admin/structure/trigger', 'admin/structure/trigger', 'Triggers', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22436f6e666967757265207768656e20746f206578656375746520616374696f6e732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 21, 479, 0, 0, 0, 0, 0, 0, 0),
('management', 480, 12, 'admin/help/trigger', 'admin/help/trigger', 'trigger', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 480, 0, 0, 0, 0, 0, 0, 0),
('management', 481, 479, 'admin/structure/trigger/comment', 'admin/structure/trigger/comment', 'Comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 479, 481, 0, 0, 0, 0, 0, 0),
('management', 482, 479, 'admin/structure/trigger/node', 'admin/structure/trigger/node', 'Node', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 479, 482, 0, 0, 0, 0, 0, 0),
('management', 483, 479, 'admin/structure/trigger/system', 'admin/structure/trigger/system', 'System', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 479, 483, 0, 0, 0, 0, 0, 0),
('management', 484, 479, 'admin/structure/trigger/taxonomy', 'admin/structure/trigger/taxonomy', 'Taxonomy', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 479, 484, 0, 0, 0, 0, 0, 0),
('management', 485, 479, 'admin/structure/trigger/unassign', 'admin/structure/trigger/unassign', 'Unassign', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22556e61737369676e20616e20616374696f6e2066726f6d206120747269676765722e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 479, 485, 0, 0, 0, 0, 0, 0),
('management', 486, 479, 'admin/structure/trigger/user', 'admin/structure/trigger/user', 'User', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 479, 486, 0, 0, 0, 0, 0, 0),
('main-menu', 599, 0, 'gallery', 'gallery', 'Gallery', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 2, 1, 1, 599, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 605, 19, 'admin/reports/fields', 'admin/reports/fields', 'Field list', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a224f76657276696577206f66206669656c6473206f6e20616c6c20656e746974792074797065732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 605, 0, 0, 0, 0, 0, 0, 0),
('management', 606, 12, 'admin/help/field_ui', 'admin/help/field_ui', 'field_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 606, 0, 0, 0, 0, 0, 0, 0),
('management', 646, 21, 'admin/structure/pages', 'admin/structure/pages', 'Pages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38343a224164642c206564697420616e642072656d6f7665206f76657272696464656e2073797374656d20706167657320616e64207573657220646566696e65642070616765732066726f6d207468652073797374656d2e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 646, 0, 0, 0, 0, 0, 0, 0),
('management', 647, 646, 'admin/structure/pages/add', 'admin/structure/pages/add', 'Add custom page', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 646, 647, 0, 0, 0, 0, 0, 0),
('management', 648, 646, 'admin/structure/pages/import', 'admin/structure/pages/import', 'Import page', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 646, 648, 0, 0, 0, 0, 0, 0),
('management', 649, 646, 'admin/structure/pages/list', 'admin/structure/pages/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 646, 649, 0, 0, 0, 0, 0, 0),
('management', 650, 646, 'admin/structure/pages/wizard', 'admin/structure/pages/wizard', 'Wizards', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -5, 4, 0, 1, 21, 646, 650, 0, 0, 0, 0, 0, 0),
('management', 651, 646, 'admin/structure/pages/edit/%', 'admin/structure/pages/edit/%', 'Edit', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 646, 651, 0, 0, 0, 0, 0, 0),
('management', 652, 646, 'admin/structure/pages/%/operation/%', 'admin/structure/pages/%/operation/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 646, 652, 0, 0, 0, 0, 0, 0),
('navigation', 654, 0, 'ctools_ajax_sample', 'ctools_ajax_sample', 'Chaos Tools AJAX Demo', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 654, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 655, 654, 'ctools_ajax_sample/jumped', 'ctools_ajax_sample/jumped', 'Successful Jumping', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 654, 655, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 656, 0, 'media/%', 'media/%', '', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 656, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 657, 656, 'media/%/delete', 'media/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 2, 0, 656, 657, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 658, 656, 'media/%/edit', 'media/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 656, 658, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 659, 656, 'media/%/multiedit', 'media/%/multiedit', 'Multi Edit', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 656, 659, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 660, 656, 'media/%/format-form', 'media/%/format-form', 'Style selector', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a2243686f6f7365206120666f726d617420666f722061207069656365206f66206d65646961223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 656, 660, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 661, 656, 'media/%/view', 'media/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 656, 661, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 664, 9, 'admin/content/media', 'admin/content/media', 'Media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a224d616e6167652066696c65732075736564206f6e20796f757220736974652e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 9, 664, 0, 0, 0, 0, 0, 0, 0),
('management', 666, 12, 'admin/help/file_entity', 'admin/help/file_entity', 'file_entity', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 666, 0, 0, 0, 0, 0, 0, 0),
('management', 667, 12, 'admin/help/media', 'admin/help/media', 'media', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 667, 0, 0, 0, 0, 0, 0, 0),
('management', 673, 46, 'admin/config/media/file-types', 'admin/config/media/file-types', 'File types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a224d616e6167652066696c65732075736564206f6e20796f757220736974652e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 46, 673, 0, 0, 0, 0, 0, 0),
('management', 676, 664, 'admin/content/media/import', 'admin/content/media/import', 'Import media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a22496d706f72742066696c657320696e746f20796f7572206d65646961206c6962726172792e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 9, 664, 676, 0, 0, 0, 0, 0, 0),
('management', 678, 46, 'admin/config/media/browser', 'admin/config/media/browser', 'Media browser settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35363a22436f6e66696775726520746865206265686176696f7220616e6420646973706c6179206f6620746865206d656469612062726f777365722e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 46, 678, 0, 0, 0, 0, 0, 0),
('management', 679, 46, 'admin/config/media/rebuild_types', 'admin/config/media/rebuild_types', 'Rebuild type information for media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37393a22496e2063617365207468657265206172652066696c657320696e2066696c655f6d616e6167656420772f6f206120747970652c20746869732066756e6374696f6e2072656275696c6473207468656d223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 46, 679, 0, 0, 0, 0, 0, 0),
('management', 689, 673, 'admin/config/media/file-types/manage/%', 'admin/config/media/file-types/manage/%', 'Manage file types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a224d616e6167652066696c65732075736564206f6e20796f757220736974652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 46, 673, 689, 0, 0, 0, 0, 0),
('management', 694, 689, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%/file-display', 'Manage file display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 6, 0, 1, 8, 46, 673, 689, 694, 0, 0, 0, 0),
('management', 696, 694, 'admin/config/media/file-types/manage/%/file-display/default', 'admin/config/media/file-types/manage/%/file-display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 8, 46, 673, 689, 694, 696, 0, 0, 0),
('management', 708, 694, 'admin/config/media/file-types/manage/%/file-display/media_large', 'admin/config/media/file-types/manage/%/file-display/media_large', 'Large', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 7, 0, 1, 8, 46, 673, 689, 694, 708, 0, 0, 0),
('management', 710, 694, 'admin/config/media/file-types/manage/%/file-display/media_link', 'admin/config/media/file-types/manage/%/file-display/media_link', 'Link', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 46, 673, 689, 694, 710, 0, 0, 0),
('management', 712, 694, 'admin/config/media/file-types/manage/%/file-display/media_original', 'admin/config/media/file-types/manage/%/file-display/media_original', 'Original', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 7, 0, 1, 8, 46, 673, 689, 694, 712, 0, 0, 0),
('management', 714, 694, 'admin/config/media/file-types/manage/%/file-display/media_preview', 'admin/config/media/file-types/manage/%/file-display/media_preview', 'Preview', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 8, 46, 673, 689, 694, 714, 0, 0, 0),
('management', 716, 694, 'admin/config/media/file-types/manage/%/file-display/media_small', 'admin/config/media/file-types/manage/%/file-display/media_small', 'Small', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 7, 0, 1, 8, 46, 673, 689, 694, 716, 0, 0, 0),
('main-menu', 724, 944, 'gallery-3-column', 'gallery-3-column', 'Gallery 3 column', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -49, 2, 1, 944, 724, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 727, 944, 'gallery-2-column', 'gallery-2-column', 'Gallery 2 column', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -50, 2, 1, 944, 727, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 728, 944, 'gallery-4-column', 'gallery-4-column', 'Gallery 4 column', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -48, 2, 1, 944, 728, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 729, 0, 'contact', 'contact', 'Contact', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 0, 1, 0, 729, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 730, 17, 'user/%/contact', 'user/%/contact', 'Contact', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 17, 730, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 731, 21, 'admin/structure/contact', 'admin/structure/contact', 'Contact form', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37313a2243726561746520612073797374656d20636f6e7461637420666f726d20616e64207365742075702063617465676f7269657320666f722074686520666f726d20746f207573652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 731, 0, 0, 0, 0, 0, 0, 0),
('management', 732, 12, 'admin/help/contact', 'admin/help/contact', 'contact', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 732, 0, 0, 0, 0, 0, 0, 0),
('management', 733, 731, 'admin/structure/contact/add', 'admin/structure/contact/add', 'Add category', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 4, 0, 1, 21, 731, 733, 0, 0, 0, 0, 0, 0),
('management', 734, 731, 'admin/structure/contact/delete/%', 'admin/structure/contact/delete/%', 'Delete contact', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 731, 734, 0, 0, 0, 0, 0, 0),
('management', 735, 731, 'admin/structure/contact/edit/%', 'admin/structure/contact/edit/%', 'Edit contact category', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 731, 735, 0, 0, 0, 0, 0, 0),
('management', 736, 1, 'admin/advanced_help', 'admin/advanced_help', 'Advanced help', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 9, 2, 0, 1, 736, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 737, 1, 'admin/help_example', 'admin', 'Example help', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 9, 2, 1, 1, 737, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 738, 0, 'advanced_help/search/%', 'advanced_help/search/%', 'Search help', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 738, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 739, 187, 'search/advanced_help/%', 'search/advanced_help/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 187, 739, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 740, 21, 'admin/structure/panels', 'admin/structure/panels', 'Panels', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34393a22476574206120626972642773206579652076696577206f66206974656d732072656c6174656420746f2050616e656c732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 21, 740, 0, 0, 0, 0, 0, 0, 0),
('management', 741, 740, 'admin/structure/panels/dashboard', 'admin/structure/panels/dashboard', 'Dashboard', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 740, 741, 0, 0, 0, 0, 0, 0),
('management', 743, 740, 'admin/structure/panels/settings', 'admin/structure/panels/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 740, 743, 0, 0, 0, 0, 0, 0),
('management', 745, 743, 'admin/structure/panels/settings/general', 'admin/structure/panels/settings/general', 'General', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 740, 743, 745, 0, 0, 0, 0, 0),
('management', 748, 743, 'admin/structure/panels/settings/panel-page', 'admin/structure/panels/settings/panel-page', 'Panel pages', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 740, 743, 748, 0, 0, 0, 0, 0),
('management', 752, 1, 'admin/settings/ctools_plugin_example', 'admin/settings/ctools_plugin_example', 'CTools plugin example', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38383a2244656d6f6e7374726174696f6e20636f64652c20616476616e6365642068656c702c20616e6420612064656d6f2070616e656c20746f2073686f7720686f7720746f206275696c642063746f6f6c7320706c7567696e732e223b7d7d, 'system', 1, 0, 0, 0, 0, 2, 1, 1, 752, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 755, 0, 'blog', 'blog', 'Blogs', 0x613a303a7b7d, 'system', 1, 0, 1, 0, 0, 1, 0, 755, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 756, 755, 'blog/%', 'blog/%', 'My blog', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 755, 756, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 757, 6, 'node/add/blog', 'node/add/blog', 'Blog entry', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35383a2255736520666f72206d756c74692d7573657220626c6f67732e20457665727920757365722067657473206120706572736f6e616c20626c6f672e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 757, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 758, 12, 'admin/help/blog', 'admin/help/blog', 'blog', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 758, 0, 0, 0, 0, 0, 0, 0),
('management', 836, 143, 'admin/structure/block/list/seven/add', 'admin/structure/block/list/seven/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 143, 836, 0, 0, 0, 0, 0),
('management', 920, 47, 'admin/structure/menu/manage/menu-menu-secondary-menu', 'admin/structure/menu/manage/%', 'Secondary menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 920, 0, 0, 0, 0, 0, 0),
('menu-menu-secondary-menu', 921, 0, '<front>', '', 'Home', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, 0, 1, 1, 921, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 924, 56, 'admin/config/system/contact_form_blocks', 'admin/config/system/contact_form_blocks', 'Contact blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32333a22436f6e7461637420626c6f636b732073657474696e6773223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 56, 924, 0, 0, 0, 0, 0, 0),
('main-menu', 944, 0, 'http://ordasoft.com', '', 'Gallery', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 1, 1, 1, 1, -49, 1, 1, 944, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 945, 8, 'admin/config/administration', 'admin/config/administration', 'Administration', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32313a2241646d696e697374726174696f6e20746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 8, 945, 0, 0, 0, 0, 0, 0, 0),
('management', 946, 12, 'admin/help/admin_menu', 'admin/help/admin_menu', 'admin_menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 946, 0, 0, 0, 0, 0, 0, 0),
('management', 947, 945, 'admin/config/administration/admin_menu', 'admin/config/administration/admin_menu', 'Administration menu', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a2241646a7573742061646d696e697374726174696f6e206d656e752073657474696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 945, 947, 0, 0, 0, 0, 0, 0),
('management', 967, 19, 'admin/reports/updates', 'admin/reports/updates', 'Available updates', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38323a22476574206120737461747573207265706f72742061626f757420617661696c61626c65207570646174657320666f7220796f757220696e7374616c6c6564206d6f64756c657320616e64207468656d65732e223b7d7d, 'system', 0, 0, 0, 0, -50, 3, 0, 1, 19, 967, 0, 0, 0, 0, 0, 0, 0),
('management', 968, 16, 'admin/modules/install', 'admin/modules/install', 'Install new module', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 3, 0, 1, 16, 968, 0, 0, 0, 0, 0, 0, 0),
('management', 969, 7, 'admin/appearance/install', 'admin/appearance/install', 'Install new theme', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 3, 0, 1, 7, 969, 0, 0, 0, 0, 0, 0, 0),
('management', 970, 7, 'admin/appearance/update', 'admin/appearance/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 3, 0, 1, 7, 970, 0, 0, 0, 0, 0, 0, 0),
('management', 971, 16, 'admin/modules/update', 'admin/modules/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 3, 0, 1, 16, 971, 0, 0, 0, 0, 0, 0, 0),
('management', 972, 12, 'admin/help/update', 'admin/help/update', 'update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 972, 0, 0, 0, 0, 0, 0, 0),
('management', 973, 967, 'admin/reports/updates/list', 'admin/reports/updates/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 967, 973, 0, 0, 0, 0, 0, 0),
('management', 974, 967, 'admin/reports/updates/settings', 'admin/reports/updates/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 50, 4, 0, 1, 19, 967, 974, 0, 0, 0, 0, 0, 0),
('management', 975, 967, 'admin/reports/updates/install', 'admin/reports/updates/install', 'Install new module or theme', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 4, 0, 1, 19, 967, 975, 0, 0, 0, 0, 0, 0),
('management', 976, 967, 'admin/reports/updates/update', 'admin/reports/updates/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 4, 0, 1, 19, 967, 976, 0, 0, 0, 0, 0, 0),
('management', 977, 89, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 21, 57, 89, 977, 0, 0, 0, 0, 0),
('management', 978, 90, 'admin/config/people/accounts/display', 'admin/config/people/accounts/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 48, 90, 978, 0, 0, 0, 0, 0),
('management', 979, 89, 'admin/structure/taxonomy/%/fields', 'admin/structure/taxonomy/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 21, 57, 89, 979, 0, 0, 0, 0, 0),
('management', 980, 90, 'admin/config/people/accounts/fields', 'admin/config/people/accounts/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 8, 48, 90, 980, 0, 0, 0, 0, 0),
('management', 981, 977, 'admin/structure/taxonomy/%/display/default', 'admin/structure/taxonomy/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 57, 89, 977, 981, 0, 0, 0, 0),
('management', 982, 978, 'admin/config/people/accounts/display/default', 'admin/config/people/accounts/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 48, 90, 978, 982, 0, 0, 0, 0),
('management', 983, 135, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 21, 36, 135, 983, 0, 0, 0, 0, 0),
('management', 984, 135, 'admin/structure/types/manage/%/fields', 'admin/structure/types/manage/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 21, 36, 135, 984, 0, 0, 0, 0, 0),
('management', 985, 977, 'admin/structure/taxonomy/%/display/full', 'admin/structure/taxonomy/%/display/full', 'Taxonomy term page', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 57, 89, 977, 985, 0, 0, 0, 0),
('management', 986, 978, 'admin/config/people/accounts/display/full', 'admin/config/people/accounts/display/full', 'User account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 48, 90, 978, 986, 0, 0, 0, 0),
('management', 987, 979, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 57, 89, 979, 987, 0, 0, 0, 0),
('management', 988, 980, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 48, 90, 980, 988, 0, 0, 0, 0),
('management', 989, 983, 'admin/structure/types/manage/%/display/default', 'admin/structure/types/manage/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 36, 135, 983, 989, 0, 0, 0, 0),
('management', 990, 689, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 8, 46, 673, 689, 990, 0, 0, 0, 0),
('management', 991, 689, 'admin/config/media/file-types/manage/%/fields', 'admin/config/media/file-types/manage/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 8, 46, 673, 689, 991, 0, 0, 0, 0),
('management', 992, 983, 'admin/structure/types/manage/%/display/rss', 'admin/structure/types/manage/%/display/rss', 'RSS', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 21, 36, 135, 983, 992, 0, 0, 0, 0),
('management', 993, 983, 'admin/structure/types/manage/%/display/search_index', 'admin/structure/types/manage/%/display/search_index', 'Search index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 6, 0, 1, 21, 36, 135, 983, 993, 0, 0, 0, 0),
('management', 994, 983, 'admin/structure/types/manage/%/display/search_result', 'admin/structure/types/manage/%/display/search_result', 'Search result', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 6, 0, 1, 21, 36, 135, 983, 994, 0, 0, 0, 0),
('management', 995, 983, 'admin/structure/types/manage/%/display/full', 'admin/structure/types/manage/%/display/full', 'Full content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 36, 135, 983, 995, 0, 0, 0, 0),
('management', 996, 983, 'admin/structure/types/manage/%/display/teaser', 'admin/structure/types/manage/%/display/teaser', 'Teaser', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 21, 36, 135, 983, 996, 0, 0, 0, 0),
('management', 997, 984, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 36, 135, 984, 997, 0, 0, 0, 0),
('management', 998, 987, 'admin/structure/taxonomy/%/fields/%/delete', 'admin/structure/taxonomy/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 21, 57, 89, 979, 987, 998, 0, 0, 0),
('management', 999, 987, 'admin/structure/taxonomy/%/fields/%/edit', 'admin/structure/taxonomy/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 57, 89, 979, 987, 999, 0, 0, 0),
('management', 1000, 987, 'admin/structure/taxonomy/%/fields/%/field-settings', 'admin/structure/taxonomy/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 57, 89, 979, 987, 1000, 0, 0, 0),
('management', 1001, 987, 'admin/structure/taxonomy/%/fields/%/widget-type', 'admin/structure/taxonomy/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 57, 89, 979, 987, 1001, 0, 0, 0),
('management', 1002, 988, 'admin/config/people/accounts/fields/%/delete', 'admin/config/people/accounts/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 8, 48, 90, 980, 988, 1002, 0, 0, 0),
('management', 1003, 988, 'admin/config/people/accounts/fields/%/edit', 'admin/config/people/accounts/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 48, 90, 980, 988, 1003, 0, 0, 0),
('management', 1004, 988, 'admin/config/people/accounts/fields/%/field-settings', 'admin/config/people/accounts/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 48, 90, 980, 988, 1004, 0, 0, 0),
('management', 1005, 988, 'admin/config/people/accounts/fields/%/widget-type', 'admin/config/people/accounts/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 48, 90, 980, 988, 1005, 0, 0, 0),
('management', 1006, 173, 'admin/structure/types/manage/%/comment/display/default', 'admin/structure/types/manage/%/comment/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 36, 135, 173, 1006, 0, 0, 0, 0),
('management', 1007, 990, 'admin/config/media/file-types/manage/%/display/default', 'admin/config/media/file-types/manage/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 8, 46, 673, 689, 990, 1007, 0, 0, 0),
('management', 1008, 173, 'admin/structure/types/manage/%/comment/display/full', 'admin/structure/types/manage/%/comment/display/full', 'Full comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 36, 135, 173, 1008, 0, 0, 0, 0),
('management', 1009, 990, 'admin/config/media/file-types/manage/%/display/media_large', 'admin/config/media/file-types/manage/%/display/media_large', 'Large', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 7, 0, 1, 8, 46, 673, 689, 990, 1009, 0, 0, 0),
('management', 1010, 990, 'admin/config/media/file-types/manage/%/display/media_link', 'admin/config/media/file-types/manage/%/display/media_link', 'Link', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 46, 673, 689, 990, 1010, 0, 0, 0),
('management', 1011, 990, 'admin/config/media/file-types/manage/%/display/media_original', 'admin/config/media/file-types/manage/%/display/media_original', 'Original', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 7, 0, 1, 8, 46, 673, 689, 990, 1011, 0, 0, 0),
('management', 1012, 990, 'admin/config/media/file-types/manage/%/display/media_preview', 'admin/config/media/file-types/manage/%/display/media_preview', 'Preview', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 8, 46, 673, 689, 990, 1012, 0, 0, 0),
('management', 1013, 990, 'admin/config/media/file-types/manage/%/display/media_small', 'admin/config/media/file-types/manage/%/display/media_small', 'Small', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 7, 0, 1, 8, 46, 673, 689, 990, 1013, 0, 0, 0),
('management', 1014, 174, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 36, 135, 174, 1014, 0, 0, 0, 0),
('management', 1015, 997, 'admin/structure/types/manage/%/fields/%/delete', 'admin/structure/types/manage/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 21, 36, 135, 984, 997, 1015, 0, 0, 0),
('management', 1016, 991, 'admin/config/media/file-types/manage/%/fields/%', 'admin/config/media/file-types/manage/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 46, 673, 689, 991, 1016, 0, 0, 0),
('management', 1017, 997, 'admin/structure/types/manage/%/fields/%/edit', 'admin/structure/types/manage/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 135, 984, 997, 1017, 0, 0, 0),
('management', 1018, 997, 'admin/structure/types/manage/%/fields/%/field-settings', 'admin/structure/types/manage/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 135, 984, 997, 1018, 0, 0, 0),
('management', 1019, 997, 'admin/structure/types/manage/%/fields/%/widget-type', 'admin/structure/types/manage/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 135, 984, 997, 1019, 0, 0, 0),
('management', 1020, 1014, 'admin/structure/types/manage/%/comment/fields/%/delete', 'admin/structure/types/manage/%/comment/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 21, 36, 135, 174, 1014, 1020, 0, 0, 0),
('management', 1021, 1014, 'admin/structure/types/manage/%/comment/fields/%/edit', 'admin/structure/types/manage/%/comment/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 135, 174, 1014, 1021, 0, 0, 0),
('management', 1022, 1014, 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 135, 174, 1014, 1022, 0, 0, 0),
('management', 1023, 1014, 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 135, 174, 1014, 1023, 0, 0, 0),
('management', 1024, 1016, 'admin/config/media/file-types/manage/%/fields/%/delete', 'admin/config/media/file-types/manage/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 8, 46, 673, 689, 991, 1016, 1024, 0, 0),
('management', 1025, 1016, 'admin/config/media/file-types/manage/%/fields/%/edit', 'admin/config/media/file-types/manage/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 673, 689, 991, 1016, 1025, 0, 0),
('management', 1026, 1016, 'admin/config/media/file-types/manage/%/fields/%/field-settings', 'admin/config/media/file-types/manage/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 673, 689, 991, 1016, 1026, 0, 0),
('management', 1027, 1016, 'admin/config/media/file-types/manage/%/fields/%/widget-type', 'admin/config/media/file-types/manage/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 673, 689, 991, 1016, 1027, 0, 0),
('management', 1040, 47, 'admin/structure/menu/manage/menu-top-menu', 'admin/structure/menu/manage/%', 'Top menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 1040, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 1041, 0, '<front>', '', 'test', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, 0, 1, 1, 1041, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 1046, 0, '<front>', '', 'FAQs', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, 0, 1, 1, 1046, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 1047, 0, '<front>', '', 'About Us', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, 0, 1, 1, 1047, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 1066, 54, 'admin/appearance/settings/master', 'admin/appearance/settings/master', 'OS Master 2015', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 1066, 0, 0, 0, 0, 0, 0),
('management', 1067, 30, 'admin/structure/block/list/master', 'admin/structure/block/list/master', 'OS Master 2015', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 30, 1067, 0, 0, 0, 0, 0, 0),
('management', 1068, 740, 'admin/structure/panels/layouts', 'admin/structure/panels/layouts', 'Layouts', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a224164642c2065646974206f722064656c65746520637573746f6d20636f6e74656e74206c61796f7574732e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 740, 1068, 0, 0, 0, 0, 0, 0),
('management', 1069, 1068, 'admin/structure/panels/layouts/add-flexible', 'admin/structure/panels/layouts/add-flexible', 'Add flexible layout', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 740, 1068, 1069, 0, 0, 0, 0, 0),
('management', 1070, 1068, 'admin/structure/panels/layouts/import', 'admin/structure/panels/layouts/import', 'Import', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 740, 1068, 1070, 0, 0, 0, 0, 0),
('management', 1071, 1068, 'admin/structure/panels/layouts/list', 'admin/structure/panels/layouts/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 740, 1068, 1071, 0, 0, 0, 0, 0),
('management', 1072, 1071, 'admin/structure/panels/layouts/list/%/edit', 'admin/structure/panels/layouts/list/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 740, 1068, 1071, 1072, 0, 0, 0, 0),
('management', 1073, 1071, 'admin/structure/panels/layouts/list/%/export', 'admin/structure/panels/layouts/list/%/export', 'Export', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 740, 1068, 1071, 1073, 0, 0, 0, 0),
('management', 1077, 137, 'admin/structure/block/list/garland/add', 'admin/structure/block/list/garland/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 137, 1077, 0, 0, 0, 0, 0),
('navigation', 1078, 6, 'node/add/services', 'node/add/services', 'Services', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 1078, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 1079, 6, 'node/add/home-page-gallery', 'node/add/home-page-gallery', 'Home page Gallery', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 1079, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-menu-secondary-menu', 1080, 0, 'lorem', 'lorem', 'lorem', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 1, 1, 1080, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-menu-secondary-menu', 1081, 0, 'about', 'about', 'About', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 1, 1, 1081, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-menu-secondary-menu', 1082, 0, 'forum', 'forum', 'forum', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 1, 1, 1082, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 1083, 0, '<front>', '', 'About us', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, -46, 1, 1, 1083, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `menu_router`
--

DROP TABLE IF EXISTS `menu_router`;
CREATE TABLE IF NOT EXISTS `menu_router` (
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: the Drupal path this entry describes',
  `load_functions` blob NOT NULL COMMENT 'A serialized array of function names (like node_load) to be called to load an object corresponding to a part of the current path.',
  `to_arg_functions` blob NOT NULL COMMENT 'A serialized array of function names (like user_uid_optional_to_arg) to be called to replace a part of the router path with another string.',
  `access_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback which determines the access to this router path. Defaults to user_access.',
  `access_arguments` blob COMMENT 'A serialized array of arguments for the access callback.',
  `page_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that renders the page.',
  `page_arguments` blob COMMENT 'A serialized array of arguments for the page callback.',
  `delivery_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that sends the result of the page_callback function to the browser.',
  `fit` int(11) NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',
  `number_parts` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',
  `context` int(11) NOT NULL DEFAULT '0' COMMENT 'Only for local tasks (tabs) - the context of a local task to control its placement.',
  `tab_parent` varchar(255) NOT NULL DEFAULT '' COMMENT 'Only for local tasks (tabs) - the router path of the parent page (which may also be a local task).',
  `tab_root` varchar(255) NOT NULL DEFAULT '' COMMENT 'Router path of the closest non-tab parent page. For pages that are not local tasks, this will be the same as the path.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title for the current page, or the title for the tab if this is a local task.',
  `title_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which will alter the title. Defaults to t()',
  `title_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the title callback. If empty, the title will be used as the sole argument for the title callback.',
  `theme_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which returns the name of the theme that will be used to render this page. If left empty, the default theme will be used.',
  `theme_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the theme callback.',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT 'Numeric representation of the type of the menu item, like MENU_LOCAL_TASK.',
  `description` text NOT NULL COMMENT 'A description of this item.',
  `position` varchar(255) NOT NULL DEFAULT '' COMMENT 'The position of the block (left or right) on the system administration page for this item.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of the element. Lighter weights are higher up, heavier weights go down.',
  `include_file` mediumtext COMMENT 'The file to include for this element, usually the page callback function lives in this file.',
  PRIMARY KEY (`path`),
  KEY `fit` (`fit`),
  KEY `tab_parent` (`tab_parent`(64),`weight`,`title`),
  KEY `tab_root_weight_title` (`tab_root`(64),`weight`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps paths to various callbacks (access, page and title)';

--
-- Дамп данных таблицы `menu_router`
--

INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('about', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a353a2261626f7574223b7d, '', 1, 1, 0, '', 'about', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('about us', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a383a2261626f75745f7573223b7d, '', 1, 1, 0, '', 'about us', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('accordion', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31383a22746162735f616e645f6163636f7264696f6e223b7d, '', 1, 1, 0, '', 'accordion', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('admin', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'admin', 'Administration', 't', '', '', 'a:0:{}', 6, '', '', 9, 'modules/system/system.admin.inc'),
('admin/advanced_help', '', '', 'user_access', 0x613a313a7b693a303b733a32343a227669657720616476616e6365642068656c7020696e646578223b7d, 'advanced_help_index_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/advanced_help', 'Advanced help', 't', '', '', 'a:0:{}', 6, '', '', 9, ''),
('admin/appearance', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_themes_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/appearance', 'Appearance', 't', '', '', 'a:0:{}', 6, 'Select and configure your themes.', 'left', -6, 'modules/system/system.admin.inc'),
('admin/appearance/default', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_default', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/default', 'Set default theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/disable', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_disable', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/disable', 'Disable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/enable', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_enable', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/enable', 'Enable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a353a227468656d65223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Install new theme', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/appearance/list', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_themes_page', 0x613a303a7b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'List', 't', '', '', 'a:0:{}', 140, 'Select and configure your theme', '', -1, 'modules/system/system.admin.inc'),
('admin/appearance/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Settings', 't', '', '', 'a:0:{}', 132, 'Configure default and theme specific settings.', '', 20, 'modules/system/system.admin.inc'),
('admin/appearance/settings/bartik', '', '', '_system_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a383a2266696c656e616d65223b733a32353a227468656d65732f62617274696b2f62617274696b2e696e666f223b733a343a226e616d65223b733a363a2262617274696b223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2230223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a31383a7b733a343a226e616d65223b733a363a2242617274696b223b733a31313a226465736372697074696f6e223b733a34383a224120666c657869626c652c207265636f6c6f7261626c65207468656d652077697468206d616e7920726567696f6e732e223b733a373a227061636b616765223b733a343a22436f7265223b733a373a2276657273696f6e223b733a343a22372e3331223b733a343a22636f7265223b733a333a22372e78223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a333a7b733a31343a226373732f6c61796f75742e637373223b733a32383a227468656d65732f62617274696b2f6373732f6c61796f75742e637373223b733a31333a226373732f7374796c652e637373223b733a32373a227468656d65732f62617274696b2f6373732f7374796c652e637373223b733a31343a226373732f636f6c6f72732e637373223b733a32383a227468656d65732f62617274696b2f6373732f636f6c6f72732e637373223b7d733a353a227072696e74223b613a313a7b733a31333a226373732f7072696e742e637373223b733a32373a227468656d65732f62617274696b2f6373732f7072696e742e637373223b7d7d733a373a22726567696f6e73223b613a32303a7b733a363a22686561646572223b733a363a22486561646572223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31313a22686967686c696768746564223b733a31313a22486967686c696768746564223b733a383a226665617475726564223b733a383a224665617475726564223b733a373a22636f6e74656e74223b733a373a22436f6e74656e74223b733a31333a22736964656261725f6669727374223b733a31333a2253696465626172206669727374223b733a31343a22736964656261725f7365636f6e64223b733a31343a2253696465626172207365636f6e64223b733a31343a2274726970747963685f6669727374223b733a31343a225472697074796368206669727374223b733a31353a2274726970747963685f6d6964646c65223b733a31353a225472697074796368206d6964646c65223b733a31333a2274726970747963685f6c617374223b733a31333a225472697074796368206c617374223b733a31383a22666f6f7465725f6669727374636f6c756d6e223b733a31393a22466f6f74657220666972737420636f6c756d6e223b733a31393a22666f6f7465725f7365636f6e64636f6c756d6e223b733a32303a22466f6f746572207365636f6e6420636f6c756d6e223b733a31383a22666f6f7465725f7468697264636f6c756d6e223b733a31393a22466f6f74657220746869726420636f6c756d6e223b733a31393a22666f6f7465725f666f75727468636f6c756d6e223b733a32303a22466f6f74657220666f7572746820636f6c756d6e223b733a363a22666f6f746572223b733a363a22466f6f746572223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a383a2273657474696e6773223b613a313a7b733a32303a2273686f72746375745f6d6f64756c655f6c696e6b223b733a313a2230223b7d733a373a2270726f6a656374223b733a363a2264727570616c223b733a393a22646174657374616d70223b733a31303a2231343037333436343333223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a373a2266617669636f6e223b693a323b733a343a226e616d65223b693a333b733a363a22736c6f67616e223b693a343b733a31373a226e6f64655f757365725f70696374757265223b693a353b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a363b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a373b733a393a226d61696e5f6d656e75223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a31303a2273637265656e73686f74223b733a32383a227468656d65732f62617274696b2f73637265656e73686f742e706e67223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a31353a226f7665726c61795f726567696f6e73223b613a333a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b7d733a31343a22726567696f6e735f68696464656e223b613a323a7b693a303b733a383a22706167655f746f70223b693a313b733a31313a22706167655f626f74746f6d223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a31313a22706167655f626f74746f6d223b7d7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a333a7b733a31343a226373732f6c61796f75742e637373223b733a32383a227468656d65732f62617274696b2f6373732f6c61796f75742e637373223b733a31333a226373732f7374796c652e637373223b733a32373a227468656d65732f62617274696b2f6373732f7374796c652e637373223b733a31343a226373732f636f6c6f72732e637373223b733a32383a227468656d65732f62617274696b2f6373732f636f6c6f72732e637373223b7d733a353a227072696e74223b613a313a7b733a31333a226373732f7072696e742e637373223b733a32373a227468656d65732f62617274696b2f6373732f7072696e742e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b7d7d, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a363a2262617274696b223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Bartik', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/garland', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a373a226761726c616e64223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Garland', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/global', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Global settings', 't', '', '', 'a:0:{}', 140, '', '', -1, 'modules/system/system.admin.inc'),
('admin/appearance/settings/master', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a363a226d6173746572223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'OS Master 2015', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/seven', '', '', '_system_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a383a2266696c656e616d65223b733a32333a227468656d65732f736576656e2f736576656e2e696e666f223b733a343a226e616d65223b733a353a22736576656e223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2230223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a31383a7b733a343a226e616d65223b733a353a22536576656e223b733a31313a226465736372697074696f6e223b733a36353a22412073696d706c65206f6e652d636f6c756d6e2c207461626c656c6573732c20666c7569642077696474682061646d696e697374726174696f6e207468656d652e223b733a373a227061636b616765223b733a343a22436f7265223b733a373a2276657273696f6e223b733a343a22372e3331223b733a343a22636f7265223b733a333a22372e78223b733a31313a227374796c65736865657473223b613a313a7b733a363a2273637265656e223b613a323a7b733a393a2272657365742e637373223b733a32323a227468656d65732f736576656e2f72657365742e637373223b733a393a227374796c652e637373223b733a32323a227468656d65732f736576656e2f7374796c652e637373223b7d7d733a383a2273657474696e6773223b613a313a7b733a32303a2273686f72746375745f6d6f64756c655f6c696e6b223b733a313a2231223b7d733a373a22726567696f6e73223b613a383a7b733a373a22636f6e74656e74223b733a373a22436f6e74656e74223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31333a22736964656261725f6669727374223b733a31333a2246697273742073696465626172223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a31343a22726567696f6e735f68696464656e223b613a333a7b693a303b733a31333a22736964656261725f6669727374223b693a313b733a383a22706167655f746f70223b693a323b733a31313a22706167655f626f74746f6d223b7d733a373a2270726f6a656374223b733a363a2264727570616c223b733a393a22646174657374616d70223b733a31303a2231343037333436343333223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a373a2266617669636f6e223b693a323b733a343a226e616d65223b693a333b733a363a22736c6f67616e223b693a343b733a31373a226e6f64655f757365725f70696374757265223b693a353b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a363b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a373b733a393a226d61696e5f6d656e75223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a31303a2273637265656e73686f74223b733a32373a227468656d65732f736576656e2f73637265656e73686f742e706e67223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a31353a226f7665726c61795f726567696f6e73223b613a333a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a31313a22706167655f626f74746f6d223b7d7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a313a7b733a363a2273637265656e223b613a323a7b733a393a2272657365742e637373223b733a32323a227468656d65732f736576656e2f72657365742e637373223b733a393a227374796c652e637373223b733a32323a227468656d65732f736576656e2f7374796c652e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b7d7d, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22736576656e223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Seven', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/stark', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22737461726b223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Stark', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a353a227468656d65223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/compact', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_compact_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/compact', 'Compact mode', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_config_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/config', 'Configuration', 't', '', '', 'a:0:{}', 6, 'Administer settings.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/administration', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/administration', 'Administration', 't', '', '', 'a:0:{}', 6, 'Administration tools.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/administration/admin_menu', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2261646d696e5f6d656e755f7468656d655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/administration/admin_menu', 'Administration menu', 't', '', '', 'a:0:{}', 6, 'Adjust administration menu settings.', '', 0, 'sites/all/modules/admin_menu/admin_menu.inc'),
('admin/config/content', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/content', 'Content authoring', 't', '', '', 'a:0:{}', 6, 'Settings related to formatting and authoring content.', 'left', -15, 'modules/system/system.admin.inc'),
('admin/config/content/formats', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2266696c7465725f61646d696e5f6f76657276696577223b7d, '', 15, 4, 0, '', 'admin/config/content/formats', 'Text formats', 't', '', '', 'a:0:{}', 6, 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/%', 0x613a313a7b693a343b733a31383a2266696c7465725f666f726d61745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'filter_admin_format_page', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'admin/config/content/formats/%', '', 'filter_admin_format_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/%/disable', 0x613a313a7b693a343b733a31383a2266696c7465725f666f726d61745f6c6f6164223b7d, '', '_filter_disable_format_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2266696c7465725f61646d696e5f64697361626c65223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/config/content/formats/%/disable', 'Disable text format', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/add', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'filter_admin_format_page', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'Add text format', 't', '', '', 'a:0:{}', 388, '', '', 1, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/list', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2266696c7465725f61646d696e5f6f76657276696577223b7d, '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/wysiwyg', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22777973697779675f70726f66696c655f6f76657276696577223b7d, '', 15, 4, 0, '', 'admin/config/content/wysiwyg', 'Wysiwyg profiles', 't', '', '', 'a:0:{}', 6, 'Configure client-side editors.', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/content/wysiwyg/profile', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22777973697779675f70726f66696c655f6f76657276696577223b7d, '', 31, 5, 1, 'admin/config/content/wysiwyg', 'admin/config/content/wysiwyg', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/content/wysiwyg/profile/%/delete', 0x613a313a7b693a353b733a32303a22777973697779675f70726f66696c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a22777973697779675f70726f66696c655f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/content/wysiwyg/profile/%wysiwyg_profile', 'admin/config/content/wysiwyg/profile', 'Remove', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/content/wysiwyg/profile/%/edit', 0x613a313a7b693a353b733a32303a22777973697779675f70726f66696c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a22777973697779675f70726f66696c655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/content/wysiwyg/profile/%wysiwyg_profile', 'admin/config/content/wysiwyg/profile', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/development', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/development', 'Development', 't', '', '', 'a:0:{}', 6, 'Development tools.', 'right', -10, 'modules/system/system.admin.inc'),
('admin/config/development/logging', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32333a2273797374656d5f6c6f6767696e675f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/development/logging', 'Logging and errors', 't', '', '', 'a:0:{}', 6, 'Settings for logging and alerts modules. Various modules can route Drupal''s system events to different destinations, such as syslog, database, email, etc.', '', -15, 'modules/system/system.admin.inc'),
('admin/config/development/maintenance', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a2273797374656d5f736974655f6d61696e74656e616e63655f6d6f6465223b7d, '', 15, 4, 0, '', 'admin/config/development/maintenance', 'Maintenance mode', 't', '', '', 'a:0:{}', 6, 'Take the site offline for maintenance or bring it back online.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/development/performance', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a2273797374656d5f706572666f726d616e63655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/development/performance', 'Performance', 't', '', '', 'a:0:{}', 6, 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/media', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/media', 'Media', 't', '', '', 'a:0:{}', 6, 'Media tools.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/media/browser', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a226d656469615f61646d696e5f636f6e6669675f62726f77736572223b7d, '', 15, 4, 0, '', 'admin/config/media/browser', 'Media browser settings', 't', '', '', 'a:0:{}', 6, 'Configure the behavior and display of the media browser.', '', 0, 'sites/all/modules/media/includes/media.admin.inc'),
('admin/config/media/file-system', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a2273797374656d5f66696c655f73797374656d5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/file-system', 'File system', 't', '', '', 'a:0:{}', 6, 'Tell Drupal where to store uploaded files and how they are accessed.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/media/file-types', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'file_entity_list_types_page', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/media/file-types', 'File types', 't', '', '', 'a:0:{}', 6, 'Manage files used on your site.', '', 0, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%', 0x613a313a7b693a353b4e3b7d, '', '0', 0x613a303a7b7d, 'file_entity_list_types_page', 0x613a303a7b7d, '', 62, 6, 0, '', 'admin/config/media/file-types/manage/%', 'Manage file types', 't', '', '', 'a:0:{}', 6, 'Manage files used on your site.', '', 0, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/display', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a373a2264656661756c74223b7d, '', 125, 7, 1, 'admin/config/media/file-types/manage/%', 'admin/config/media/file-types/manage/%', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/display/default', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a373a2264656661756c74223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/display/media_large', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a31313a226d656469615f6c61726765223b693a333b733a31313a22757365725f616363657373223b693a343b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a31313a226d656469615f6c61726765223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%', 'Large', 't', '', '', 'a:0:{}', 132, '', '', 3, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/display/media_link', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a31303a226d656469615f6c696e6b223b693a333b733a31313a22757365725f616363657373223b693a343b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a31303a226d656469615f6c696e6b223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%', 'Link', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/display/media_original', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a31343a226d656469615f6f726967696e616c223b693a333b733a31313a22757365725f616363657373223b693a343b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a31343a226d656469615f6f726967696e616c223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%', 'Original', 't', '', '', 'a:0:{}', 132, '', '', 4, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/display/media_preview', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a31333a226d656469615f70726576696577223b693a333b733a31313a22757365725f616363657373223b693a343b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a31333a226d656469615f70726576696577223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%', 'Preview', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/display/media_small', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a31313a226d656469615f736d616c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b693a333b733a31313a226d656469615f736d616c6c223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/display', 'admin/config/media/file-types/manage/%', 'Small', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/fields', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a343a2266696c65223b693a323b693a353b7d, '', 125, 7, 1, 'admin/config/media/file-types/manage/%', 'admin/config/media/file-types/manage/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/fields/%', 0x613a323a7b693a353b613a313a7b733a31343a2266696c655f747970655f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/file-types/manage/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:7;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/fields/%/delete', 0x613a323a7b693a353b613a313a7b733a31343a2266696c655f747970655f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/config/media/file-types/manage/%/fields/%', 'admin/config/media/file-types/manage/%/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/config/media/file-types/manage/%/fields/%/edit', 0x613a323a7b693a353b613a313a7b733a31343a2266696c655f747970655f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/config/media/file-types/manage/%/fields/%', 'admin/config/media/file-types/manage/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/fields/%/field-settings', 0x613a323a7b693a353b613a313a7b733a31343a2266696c655f747970655f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/config/media/file-types/manage/%/fields/%', 'admin/config/media/file-types/manage/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/fields/%/widget-type', 0x613a323a7b693a353b613a313a7b733a31343a2266696c655f747970655f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2266696c65223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/config/media/file-types/manage/%/fields/%', 'admin/config/media/file-types/manage/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/file-types/manage/%/file-display', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a373a2264656661756c74223b7d, '', 125, 7, 1, 'admin/config/media/file-types/manage/%', 'admin/config/media/file-types/manage/%', 'Manage file display', 't', '', '', 'a:0:{}', 132, '', '', 3, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/file-display/default', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_file_entity_view_mode_menu_access', 0x613a343a7b693a303b693a353b693a313b733a373a2264656661756c74223b693a323b733a31313a22757365725f616363657373223b693a333b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a373a2264656661756c74223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/file-display/media_large', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_file_entity_view_mode_menu_access', 0x613a343a7b693a303b693a353b693a313b733a31313a226d656469615f6c61726765223b693a323b733a31313a22757365725f616363657373223b693a333b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a31313a226d656469615f6c61726765223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%', 'Large', 't', '', '', 'a:0:{}', 132, '', '', 3, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/file-display/media_link', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_file_entity_view_mode_menu_access', 0x613a343a7b693a303b693a353b693a313b733a31303a226d656469615f6c696e6b223b693a323b733a31313a22757365725f616363657373223b693a333b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a31303a226d656469615f6c696e6b223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%', 'Link', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/file-display/media_original', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_file_entity_view_mode_menu_access', 0x613a343a7b693a303b693a353b693a313b733a31343a226d656469615f6f726967696e616c223b693a323b733a31313a22757365725f616363657373223b693a333b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a31343a226d656469615f6f726967696e616c223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%', 'Original', 't', '', '', 'a:0:{}', 132, '', '', 4, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/file-display/media_preview', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_file_entity_view_mode_menu_access', 0x613a343a7b693a303b693a353b693a313b733a31333a226d656469615f70726576696577223b693a323b733a31313a22757365725f616363657373223b693a333b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a31333a226d656469615f70726576696577223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%', 'Preview', 't', '', '', 'a:0:{}', 132, '', '', 1, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/file-types/manage/%/file-display/media_small', 0x613a313a7b693a353b733a31343a2266696c655f747970655f6c6f6164223b7d, '', '_file_entity_view_mode_menu_access', 0x613a343a7b693a303b693a353b693a313b733a31313a226d656469615f736d616c6c223b693a323b733a31313a22757365725f616363657373223b693a333b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32393a2266696c655f656e746974795f66696c655f646973706c61795f666f726d223b693a313b693a353b693a323b733a31313a226d656469615f736d616c6c223b7d, '', 251, 8, 1, 'admin/config/media/file-types/manage/%/file-display', 'admin/config/media/file-types/manage/%', 'Small', 't', '', '', 'a:0:{}', 132, '', '', 2, 'sites/all/modules/media/file_entity/file_entity.admin.inc'),
('admin/config/media/image-styles', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'image_style_list', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/media/image-styles', 'Image styles', 't', '', '', 'a:0:{}', 6, 'Configure styles that can be used for resizing or adjusting images on display.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/add', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22696d6167655f7374796c655f6164645f666f726d223b7d, '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Add style', 't', '', '', 'a:0:{}', 388, 'Add a new image style.', '', 2, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/delete/%', 0x613a313a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b4e3b693a313b733a313a2231223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a22696d6167655f7374796c655f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/delete/%', 'Delete style', 't', '', '', 'a:0:{}', 6, 'Delete an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%', 0x613a313a7b693a353b733a31363a22696d6167655f7374796c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31363a22696d6167655f7374796c655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/edit/%', 'Edit style', 't', '', '', 'a:0:{}', 6, 'Configure an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/add/%', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a313a7b693a303b693a353b7d7d693a373b613a313a7b733a32383a22696d6167655f6566666563745f646566696e6974696f6e5f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31373a22696d6167655f6566666563745f666f726d223b693a313b693a353b693a323b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/add/%', 'Add image effect', 't', '', '', 'a:0:{}', 6, 'Add a new effect to a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/effects/%', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d693a373b613a313a7b733a31373a22696d6167655f6566666563745f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31373a22696d6167655f6566666563745f666f726d223b693a313b693a353b693a323b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/effects/%', 'Edit image effect', 't', '', '', 'a:0:{}', 6, 'Edit an existing effect within a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/effects/%/delete', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d693a373b613a313a7b733a31373a22696d6167655f6566666563745f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32343a22696d6167655f6566666563745f64656c6574655f666f726d223b693a313b693a353b693a323b693a373b7d, '', 501, 9, 0, '', 'admin/config/media/image-styles/edit/%/effects/%/delete', 'Delete image effect', 't', '', '', 'a:0:{}', 6, 'Delete an existing effect from a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/list', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'image_style_list', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'List', 't', '', '', 'a:0:{}', 140, 'List the current image styles on the site.', '', 1, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/revert/%', 0x613a313a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b4e3b693a313b733a313a2232223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a22696d6167655f7374796c655f7265766572745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/revert/%', 'Revert style', 't', '', '', 'a:0:{}', 6, 'Revert an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-toolkit', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a2273797374656d5f696d6167655f746f6f6c6b69745f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/image-toolkit', 'Image toolkit', 't', '', '', 'a:0:{}', 6, 'Choose which image toolkit to use if you have installed optional toolkits.', '', 20, 'modules/system/system.admin.inc'),
('admin/config/media/rebuild_types', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226d656469615f61646d696e5f72656275696c645f74797065735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/media/rebuild_types', 'Rebuild type information for media', 't', '', '', 'a:0:{}', 6, 'In case there are files in file_managed w/o a type, this function rebuilds them', '', 0, 'sites/all/modules/media/includes/media.admin.inc'),
('admin/config/people', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/people', 'People', 't', '', '', 'a:0:{}', 6, 'Configure user accounts.', 'left', -20, 'modules/system/system.admin.inc'),
('admin/config/people/accounts', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22757365725f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/people/accounts', 'Account settings', 't', '', '', 'a:0:{}', 6, 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.', '', -10, 'modules/user/user.admin.inc'),
('admin/config/people/accounts/display', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a373a2264656661756c74223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/full', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a343a2266756c6c223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'User account', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/people/accounts/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/delete', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/edit', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/field-settings', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/widget-type', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22757365725f61646d696e5f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Settings', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/user/user.admin.inc'),
('admin/config/people/ip-blocking', '', '', 'user_access', 0x613a313a7b693a303b733a31383a22626c6f636b20495020616464726573736573223b7d, 'system_ip_blocking', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/people/ip-blocking', 'IP address blocking', 't', '', '', 'a:0:{}', 6, 'Manage blocked IP addresses.', '', 10, 'modules/system/system.admin.inc'),
('admin/config/people/ip-blocking/delete/%', 0x613a313a7b693a353b733a31353a22626c6f636b65645f69705f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a22626c6f636b20495020616464726573736573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a2273797374656d5f69705f626c6f636b696e675f64656c657465223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/people/ip-blocking/delete/%', 'Delete IP address', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/regional', 'Regional and language', 't', '', '', 'a:0:{}', 6, 'Regional settings, localization and translation.', 'left', -5, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f646174655f74696d655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/regional/date-time', 'Date and time', 't', '', '', 'a:0:{}', 6, 'Configure display formats for date and time.', '', -15, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_date_time_formats', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Formats', 't', '', '', 'a:0:{}', 132, 'Configure display format strings for date and time.', '', -9, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a2273797374656d5f646174655f64656c6574655f666f726d61745f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date format.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/edit', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33343a2273797374656d5f636f6e6669677572655f646174655f666f726d6174735f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/edit', 'Edit date format', 't', '', '', 'a:0:{}', 6, 'Allow users to edit a configured date format.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/add', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33343a2273797374656d5f636f6e6669677572655f646174655f666f726d6174735f666f726d223b7d, '', 63, 6, 1, 'admin/config/regional/date-time/formats', 'admin/config/regional/date-time', 'Add format', 't', '', '', 'a:0:{}', 388, 'Allow users to add additional date formats.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/lookup', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_date_time_lookup', 0x613a303a7b7d, '', 63, 6, 0, '', 'admin/config/regional/date-time/formats/lookup', 'Date and time lookup', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f646174655f74696d655f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Types', 't', '', '', 'a:0:{}', 140, 'Configure display formats for date and time.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33353a2273797374656d5f64656c6574655f646174655f666f726d61745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/types/%/delete', 'Delete date type', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date type.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types/add', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2273797374656d5f6164645f646174655f666f726d61745f747970655f666f726d223b7d, '', 63, 6, 1, 'admin/config/regional/date-time/types', 'admin/config/regional/date-time', 'Add date type', 't', '', '', 'a:0:{}', 388, 'Add new date type.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f726567696f6e616c5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/regional/settings', 'Regional settings', 't', '', '', 'a:0:{}', 6, 'Settings for the site''s default time zone and country.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/search', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/search', 'Search and metadata', 't', '', '', 'a:0:{}', 6, 'Local site search, metadata and SEO.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/search/clean-urls', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f636c65616e5f75726c5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/search/clean-urls', 'Clean URLs', 't', '', '', 'a:0:{}', 6, 'Enable or disable clean URLs for your site.', '', 5, 'modules/system/system.admin.inc'),
('admin/config/search/clean-urls/check', '', '', '1', 0x613a303a7b7d, 'drupal_json_output', 0x613a313a7b693a303b613a313a7b733a363a22737461747573223b623a313b7d7d, '', 31, 5, 0, '', 'admin/config/search/clean-urls/check', 'Clean URL check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/search/path', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_overview', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/search/path', 'URL aliases', 't', '', '', 'a:0:{}', 6, 'Change your site''s URL paths by aliasing them.', '', -5, 'modules/path/path.admin.inc'),
('admin/config/search/path/add', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_edit', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Add alias', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/delete/%', 0x613a313a7b693a353b733a393a22706174685f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a22706174685f61646d696e5f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/search/path/delete/%', 'Delete alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/edit/%', 0x613a313a7b693a353b733a393a22706174685f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_edit', 0x613a313a7b693a303b693a353b7d, '', 62, 6, 0, '', 'admin/config/search/path/edit/%', 'Edit alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/list', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_overview', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/path/path.admin.inc'),
('admin/config/search/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220736561726368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a227365617263685f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/search/settings', 'Search settings', 't', '', '', 'a:0:{}', 6, 'Configure relevance settings for search and other indexing options.', '', -10, 'modules/search/search.admin.inc'),
('admin/config/search/settings/reindex', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220736561726368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a227365617263685f7265696e6465785f636f6e6669726d223b7d, '', 31, 5, 0, '', 'admin/config/search/settings/reindex', 'Clear index', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/search/search.admin.inc'),
('admin/config/services', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/services', 'Web services', 't', '', '', 'a:0:{}', 6, 'Tools related to web services.', 'right', 0, 'modules/system/system.admin.inc'),
('admin/config/services/rss-publishing', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f7273735f66656564735f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/services/rss-publishing', 'RSS publishing', 't', '', '', 'a:0:{}', 6, 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/system', 'System', 't', '', '', 'a:0:{}', 6, 'General system related configuration.', 'right', -20, 'modules/system/system.admin.inc'),
('admin/config/system/actions', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_manage', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/system/actions', 'Actions', 't', '', '', 'a:0:{}', 6, 'Manage the actions defined for your site.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f616374696f6e735f636f6e666967757265223b7d, '', 31, 5, 0, '', 'admin/config/system/actions/configure', 'Configure an advanced action', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/delete/%', 0x613a313a7b693a353b733a31323a22616374696f6e735f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a2273797374656d5f616374696f6e735f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/system/actions/delete/%', 'Delete action', 't', '', '', 'a:0:{}', 6, 'Delete an action.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/manage', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_manage', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/system/actions', 'admin/config/system/actions', 'Manage actions', 't', '', '', 'a:0:{}', 140, 'Manage the actions defined for your site.', '', -2, 'modules/system/system.admin.inc'),
('admin/config/system/actions/orphan', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_remove_orphans', 0x613a303a7b7d, '', 31, 5, 0, '', 'admin/config/system/actions/orphan', 'Remove orphans', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/contact_form_blocks', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e7461637420666f726d73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a22636f6e746163745f666f726d5f626c6f636b735f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/contact_form_blocks', 'Contact blocks', 't', '', '', 'a:0:{}', 6, 'Contact blocks settings', '', 0, ''),
('admin/config/system/cron', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2273797374656d5f63726f6e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/cron', 'Cron', 't', '', '', 'a:0:{}', 6, 'Manage automatic site maintenance tasks.', '', 20, 'modules/system/system.admin.inc'),
('admin/config/system/site-information', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2273797374656d5f736974655f696e666f726d6174696f6e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/site-information', 'Site information', 't', '', '', 'a:0:{}', 6, 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/user-interface', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/user-interface', 'User interface', 't', '', '', 'a:0:{}', 6, 'Tools that enhance the user interface.', 'right', -15, 'modules/system/system.admin.inc'),
('admin/config/user-interface/shortcut', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e69737465722073686f727463757473223b7d, 'shortcut_set_admin', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/user-interface/shortcut', 'Shortcuts', 't', '', '', 'a:0:{}', 6, 'Add and modify shortcut sets.', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f637573746f6d697a65223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/config/user-interface/shortcut/%', 'Edit shortcuts', 'shortcut_set_title_callback', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/add-link', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31373a2273686f72746375745f6c696e6b5f616464223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Add shortcut', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/add-link-inline', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'shortcut_link_add_inline', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 0, '', 'admin/config/user-interface/shortcut/%/add-link-inline', 'Add shortcut', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/delete', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_delete_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a2273686f72746375745f7365745f64656c6574655f666f726d223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/config/user-interface/shortcut/%/delete', 'Delete shortcut set', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/edit', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f656469745f666f726d223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Edit set name', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/links', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f637573746f6d697a65223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'List links', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/add-set', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e69737465722073686f727463757473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273686f72746375745f7365745f6164645f666f726d223b7d, '', 31, 5, 1, 'admin/config/user-interface/shortcut', 'admin/config/user-interface/shortcut', 'Add shortcut set', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/link/%', 0x613a313a7b693a353b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'shortcut_link_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31383a2273686f72746375745f6c696e6b5f65646974223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/user-interface/shortcut/link/%', 'Edit shortcut', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/link/%/delete', 0x613a313a7b693a353b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'shortcut_link_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2273686f72746375745f6c696e6b5f64656c657465223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/user-interface/shortcut/link/%/delete', 'Delete shortcut', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/workflow', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/workflow', 'Workflow', 't', '', '', 'a:0:{}', 6, 'Content workflow, editorial workflow tools.', 'right', 5, 'modules/system/system.admin.inc'),
('admin/content', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261636365737320636f6e74656e74206f76657276696577223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a226e6f64655f61646d696e5f636f6e74656e74223b7d, '', 3, 2, 0, '', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 6, 'Administer content and comments.', '', -10, 'modules/node/node.admin.inc'),
('admin/content/comment', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a303a7b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Comments', 't', '', '', 'a:0:{}', 134, 'List and edit site comments and the comment approval queue.', '', 0, 'modules/comment/comment.admin.inc'),
('admin/content/comment/approval', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a313a7b693a303b733a383a22617070726f76616c223b7d, '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Unapproved comments', 'comment_count_unpublished', '', '', 'a:0:{}', 132, '', '', 0, 'modules/comment/comment.admin.inc'),
('admin/content/comment/new', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a303a7b7d, '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Published comments', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/comment/comment.admin.inc'),
('admin/content/media', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31313a226d656469615f61646d696e223b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Media', 't', '', '', 'a:0:{}', 134, 'Manage files used on your site.', '', 0, 'sites/all/modules/media/includes/media.admin.inc'),
('admin/content/media/import', '', '', 'user_access', 0x613a313a7b693a303b733a31323a22696d706f7274206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31323a226d656469615f696d706f7274223b7d, '', 15, 4, 1, 'admin/content/media', 'admin/content', 'Import media', 't', '', '', 'a:0:{}', 388, 'Import files into your media library.', '', 0, 'sites/all/modules/media/includes/media.admin.inc'),
('admin/content/node', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261636365737320636f6e74656e74206f76657276696577223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a226e6f64655f61646d696e5f636f6e74656e74223b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/node/node.admin.inc'),
('admin/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a31363a226163636573732064617368626f617264223b7d, 'dashboard_admin', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/dashboard', 'Dashboard', 't', '', '', 'a:0:{}', 6, 'View and customize your dashboard.', '', -15, ''),
('admin/dashboard/block-content/%/%', 0x613a323a7b693a333b4e3b693a343b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_show_block_content', 0x613a323a7b693a303b693a333b693a313b693a343b7d, '', 28, 5, 0, '', 'admin/dashboard/block-content/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/dashboard/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_admin_blocks', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/configure', 'Configure available dashboard blocks', 't', '', '', 'a:0:{}', 4, 'Configure which blocks can be shown on the dashboard.', '', 0, ''),
('admin/dashboard/customize', '', '', 'user_access', 0x613a313a7b693a303b733a31363a226163636573732064617368626f617264223b7d, 'dashboard_admin', 0x613a313a7b693a303b623a313b7d, '', 7, 3, 0, '', 'admin/dashboard/customize', 'Customize dashboard', 't', '', '', 'a:0:{}', 4, 'Customize your dashboard.', '', 0, ''),
('admin/dashboard/drawer', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_show_disabled', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/drawer', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/dashboard/update', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_update', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/update', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/help', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_main', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/help', 'Help', 't', '', '', 'a:0:{}', 6, 'Reference for usage, configuration, and modules.', '', 9, 'modules/help/help.admin.inc'),
('admin/help/admin_menu', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/admin_menu', 'admin_menu', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/block', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/block', 'block', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/blog', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/blog', 'blog', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/color', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/color', 'color', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/comment', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/comment', 'comment', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/contact', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/contact', 'contact', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/contextual', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/contextual', 'contextual', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/dashboard', 'dashboard', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/dblog', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/dblog', 'dblog', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field', 'field', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field_sql_storage', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field_sql_storage', 'field_sql_storage', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field_ui', 'field_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/file', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/file', 'file', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/help/file_entity', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/file_entity', 'file_entity', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/filter', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/filter', 'filter', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/help', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/help', 'help', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/image', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/image', 'image', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/list', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/list', 'list', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/media', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/media', 'media', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/menu', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/menu', 'menu', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/node', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/node', 'node', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/number', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/number', 'number', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/options', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/options', 'options', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/path', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/path', 'path', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/rdf', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/rdf', 'rdf', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/search', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/search', 'search', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/shortcut', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/shortcut', 'shortcut', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/system', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/system', 'system', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/taxonomy', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/taxonomy', 'taxonomy', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/text', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/text', 'text', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/trigger', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/trigger', 'trigger', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/update', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/update', 'update', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/user', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/user', 'user', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/wysiwyg', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/wysiwyg', 'wysiwyg', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help_example', '', '', 'user_access', 0x613a313a7b693a303b733a32343a227669657720616476616e6365642068656c7020696e646578223b7d, 'help_example_index_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/help_example', 'Example help', 't', '', '', 'a:0:{}', 6, '', '', 9, ''),
('admin/index', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_index', 0x613a303a7b7d, '', 3, 2, 1, 'admin', 'admin', 'Index', 't', '', '', 'a:0:{}', 132, '', '', -18, 'modules/system/system.admin.inc'),
('admin/modules', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 3, 2, 0, '', 'admin/modules', 'Modules', 't', '', '', 'a:0:{}', 6, 'Extend site functionality.', '', -2, 'modules/system/system.admin.inc'),
('admin/modules/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a363a226d6f64756c65223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Install new module', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/modules/list', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/list/confirm', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 15, 4, 0, '', 'admin/modules/list/confirm', 'List', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/uninstall', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f6d6f64756c65735f756e696e7374616c6c223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Uninstall', 't', '', '', 'a:0:{}', 132, '', '', 20, 'modules/system/system.admin.inc'),
('admin/modules/uninstall/confirm', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f6d6f64756c65735f756e696e7374616c6c223b7d, '', 15, 4, 0, '', 'admin/modules/uninstall/confirm', 'Uninstall', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a363a226d6f64756c65223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/people', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a343a226c697374223b7d, '', 3, 2, 0, '', 'admin/people', 'People', 't', '', '', 'a:0:{}', 6, 'Manage user accounts, roles, and permissions.', 'left', -4, 'modules/user/user.admin.inc'),
('admin/people/create', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a363a22637265617465223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'Add user', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/user/user.admin.inc'),
('admin/people/people', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a343a226c697374223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'List', 't', '', '', 'a:0:{}', 140, 'Find and manage people interacting with your site.', '', -10, 'modules/user/user.admin.inc'),
('admin/people/permissions', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22757365725f61646d696e5f7065726d697373696f6e73223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'Permissions', 't', '', '', 'a:0:{}', 132, 'Determine access to features by selecting permissions for roles.', '', 0, 'modules/user/user.admin.inc'),
('admin/people/permissions/list', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22757365725f61646d696e5f7065726d697373696f6e73223b7d, '', 15, 4, 1, 'admin/people/permissions', 'admin/people', 'Permissions', 't', '', '', 'a:0:{}', 140, 'Determine access to features by selecting permissions for roles.', '', -8, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a22757365725f61646d696e5f726f6c6573223b7d, '', 15, 4, 1, 'admin/people/permissions', 'admin/people', 'Roles', 't', '', '', 'a:0:{}', 132, 'List, edit, or add user roles.', '', -5, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles/delete/%', 0x613a313a7b693a353b733a31343a22757365725f726f6c655f6c6f6164223b7d, '', 'user_role_edit_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a22757365725f61646d696e5f726f6c655f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/people/permissions/roles/delete/%', 'Delete role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles/edit/%', 0x613a313a7b693a353b733a31343a22757365725f726f6c655f6c6f6164223b7d, '', 'user_role_edit_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31353a22757365725f61646d696e5f726f6c65223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/people/permissions/roles/edit/%', 'Edit role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.admin.inc'),
('admin/reports', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/reports', 'Reports', 't', '', '', 'a:0:{}', 6, 'View reports, updates, and errors.', 'left', 5, 'modules/system/system.admin.inc'),
('admin/reports/access-denied', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_top', 0x613a313a7b693a303b733a31333a226163636573732064656e696564223b7d, '', 7, 3, 0, '', 'admin/reports/access-denied', 'Top ''access denied'' errors', 't', '', '', 'a:0:{}', 6, 'View ''access denied'' errors (403s).', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/dblog', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_overview', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/dblog', 'Recent log messages', 't', '', '', 'a:0:{}', 6, 'View events that have recently been logged.', '', -1, 'modules/dblog/dblog.admin.inc'),
('admin/reports/event/%', 0x613a313a7b693a333b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_event', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 0, '', 'admin/reports/event/%', 'Details', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'field_ui_fields_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/fields', 'Field list', 't', '', '', 'a:0:{}', 6, 'Overview of fields on all entity types.', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/list', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'field_ui_fields_list', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/views-fields', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_field_list', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'Used in views', 't', '', '', 'a:0:{}', 132, 'Overview of fields used in all views.', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/reports/page-not-found', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_top', 0x613a313a7b693a303b733a31343a2270616765206e6f7420666f756e64223b7d, '', 7, 3, 0, '', 'admin/reports/page-not-found', 'Top ''page not found'' errors', 't', '', '', 'a:0:{}', 6, 'View ''page not found'' errors (404s).', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/search', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_top', 0x613a313a7b693a303b733a363a22736561726368223b7d, '', 7, 3, 0, '', 'admin/reports/search', 'Top search phrases', 't', '', '', 'a:0:{}', 6, 'View most popular search phrases.', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/status', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_status', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/status', 'Status report', 't', '', '', 'a:0:{}', 6, 'Get a status report about your site''s operation and any detected problems.', '', -60, 'modules/system/system.admin.inc'),
('admin/reports/status/php', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_php', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/status/php', 'PHP', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/reports/status/rebuild', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226e6f64655f636f6e6669677572655f72656275696c645f636f6e6669726d223b7d, '', 15, 4, 0, '', 'admin/reports/status/rebuild', 'Rebuild permissions', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/node/node.admin.inc'),
('admin/reports/status/run-cron', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_run_cron', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/status/run-cron', 'Run cron', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/reports/updates', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_status', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/updates', 'Available updates', 't', '', '', 'a:0:{}', 6, 'Get a status report about available updates for your installed modules and themes.', '', -50, 'modules/update/update.report.inc'),
('admin/reports/updates/check', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_manual_status', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/updates/check', 'Manual update check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/update/update.fetch.inc'),
('admin/reports/updates/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a363a227265706f7274223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Install new module or theme', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/reports/updates/list', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_status', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/update/update.report.inc'),
('admin/reports/updates/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31353a227570646174655f73657474696e6773223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 50, 'modules/update/update.settings.inc'),
('admin/reports/updates/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a363a227265706f7274223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/reports/views-plugins', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_plugin_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/views-plugins', 'Views plugins', 't', '', '', 'a:0:{}', 6, 'Overview of plugins used in all views.', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/settings/ctools_plugin_example', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'ctools_plugin_example_explanation_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/settings/ctools_plugin_example', 'CTools plugin example', 't', '', '', 'a:0:{}', 6, 'Demonstration code, advanced help, and a demo panel to show how to build ctools plugins.', '', 0, ''),
('admin/structure', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/structure', 'Structure', 't', '', '', 'a:0:{}', 6, 'Administer blocks, content types, menus, etc.', 'right', -8, 'modules/system/system.admin.inc'),
('admin/structure/block', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'block_admin_display', 0x613a313a7b693a303b733a363a226d6173746572223b7d, '', 7, 3, 0, '', 'admin/structure/block', 'Blocks', 't', '', '', 'a:0:{}', 6, 'Configure what block content appears in your site''s sidebars and other regions.', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 15, 4, 1, 'admin/structure/block', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/bartik', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a363a2262617274696b223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/bartik', 'Bartik', 't', '', '_block_custom_theme', 'a:1:{i:0;s:6:"bartik";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/garland', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a373a226761726c616e64223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/garland', 'Garland', 't', '', '_block_custom_theme', 'a:1:{i:0;s:7:"garland";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/master', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a363a226d6173746572223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/master', 'OS Master 2015', 't', '', '_block_custom_theme', 'a:1:{i:0;s:6:"master";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/seven', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a353a22736576656e223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/seven', 'Seven', 't', '', '_block_custom_theme', 'a:1:{i:0;s:5:"seven";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/stark', '', '', '_block_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a383a2266696c656e616d65223b733a32333a227468656d65732f737461726b2f737461726b2e696e666f223b733a343a226e616d65223b733a353a22737461726b223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2230223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a31373a7b733a343a226e616d65223b733a353a22537461726b223b733a31313a226465736372697074696f6e223b733a3230383a2254686973207468656d652064656d6f6e737472617465732044727570616c27732064656661756c742048544d4c206d61726b757020616e6420435353207374796c65732e20546f206c6561726e20686f7720746f206275696c6420796f7572206f776e207468656d6520616e64206f766572726964652044727570616c27732064656661756c7420636f64652c2073656520746865203c6120687265663d22687474703a2f2f64727570616c2e6f72672f7468656d652d6775696465223e5468656d696e672047756964653c2f613e2e223b733a373a227061636b616765223b733a343a22436f7265223b733a373a2276657273696f6e223b733a343a22372e3331223b733a343a22636f7265223b733a333a22372e78223b733a31313a227374796c65736865657473223b613a313a7b733a333a22616c6c223b613a313a7b733a31303a226c61796f75742e637373223b733a32333a227468656d65732f737461726b2f6c61796f75742e637373223b7d7d733a373a2270726f6a656374223b733a363a2264727570616c223b733a393a22646174657374616d70223b733a31303a2231343037333436343333223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a373a22726567696f6e73223b613a31323a7b733a31333a22736964656261725f6669727374223b733a31323a224c6566742073696465626172223b733a31343a22736964656261725f7365636f6e64223b733a31333a2252696768742073696465626172223b733a373a22636f6e74656e74223b733a373a22436f6e74656e74223b733a363a22686561646572223b733a363a22486561646572223b733a363a22666f6f746572223b733a363a22466f6f746572223b733a31313a22686967686c696768746564223b733a31313a22486967686c696768746564223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a373a2266617669636f6e223b693a323b733a343a226e616d65223b693a333b733a363a22736c6f67616e223b693a343b733a31373a226e6f64655f757365725f70696374757265223b693a353b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a363b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a373b733a393a226d61696e5f6d656e75223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a31303a2273637265656e73686f74223b733a32373a227468656d65732f737461726b2f73637265656e73686f742e706e67223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a31353a226f7665726c61795f726567696f6e73223b613a333a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b7d733a31343a22726567696f6e735f68696464656e223b613a323a7b693a303b733a383a22706167655f746f70223b693a313b733a31313a22706167655f626f74746f6d223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a31313a22706167655f626f74746f6d223b7d7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a313a7b733a333a22616c6c223b613a313a7b733a31303a226c61796f75742e637373223b733a32333a227468656d65732f737461726b2f6c61796f75742e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b7d7d, 'block_admin_demo', 0x613a313a7b693a303b733a353a22737461726b223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/stark', 'Stark', 't', '', '_block_custom_theme', 'a:1:{i:0;s:5:"stark";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/imageblock_add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a22696d616765626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 15, 4, 1, 'admin/structure/block', 'admin/structure/block', 'Add image block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/imageblock/imageblock.admin.inc'),
('admin/structure/block/imageblock_configure', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a22696d616765626c6f636b5f61646d696e5f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/structure/block/imageblock_configure', 'Image block settings', 't', '', '', 'a:0:{}', 6, 'Configure Image block settings.', '', 0, 'sites/all/modules/imageblock/imageblock.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/structure/block/list/bartik', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a363a2262617274696b223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Bartik', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/bartik/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/bartik', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/garland', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a373a226761726c616e64223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Garland', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/garland/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/garland', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/master', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a363a226d6173746572223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'OS Master 2015', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/block/block.admin.inc'),
('admin/structure/block/list/seven', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a353a22736576656e223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Seven', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/seven/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/seven', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/stark', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a353a22737461726b223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Stark', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/stark/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/stark', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/manage/%/%', 0x613a323a7b693a343b4e3b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32313a22626c6f636b5f61646d696e5f636f6e666967757265223b693a313b693a343b693a323b693a353b7d, '', 60, 6, 0, '', 'admin/structure/block/manage/%/%', 'Configure block', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/manage/%/%/configure', 0x613a323a7b693a343b4e3b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32313a22626c6f636b5f61646d696e5f636f6e666967757265223b693a313b693a343b693a323b693a353b7d, '', 121, 7, 2, 'admin/structure/block/manage/%/%', 'admin/structure/block/manage/%/%', 'Configure block', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/manage/%/%/delete', 0x613a323a7b693a343b4e3b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32353a22626c6f636b5f637573746f6d5f626c6f636b5f64656c657465223b693a313b693a343b693a323b693a353b7d, '', 121, 7, 0, 'admin/structure/block/manage/%/%', 'admin/structure/block/manage/%/%', 'Delete block', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/manage/imageblock/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a22696d616765626c6f636b5f637573746f6d5f626c6f636b5f64656c657465223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/structure/block/manage/imageblock/%/delete', 'Delete block', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/imageblock/imageblock.admin.inc'),
('admin/structure/contact', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e7461637420666f726d73223b7d, 'contact_category_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/structure/contact', 'Contact form', 't', '', '', 'a:0:{}', 6, 'Create a system contact form and set up categories for the form to use.', '', 0, 'modules/contact/contact.admin.inc'),
('admin/structure/contact/add', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e7461637420666f726d73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a22636f6e746163745f63617465676f72795f656469745f666f726d223b7d, '', 15, 4, 1, 'admin/structure/contact', 'admin/structure/contact', 'Add category', 't', '', '', 'a:0:{}', 388, '', '', 1, 'modules/contact/contact.admin.inc'),
('admin/structure/contact/delete/%', 0x613a313a7b693a343b733a31323a22636f6e746163745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e7461637420666f726d73223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a22636f6e746163745f63617465676f72795f64656c6574655f666f726d223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/structure/contact/delete/%', 'Delete contact', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/contact/contact.admin.inc'),
('admin/structure/contact/edit/%', 0x613a313a7b693a343b733a31323a22636f6e746163745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e7461637420666f726d73223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a22636f6e746163745f63617465676f72795f656469745f666f726d223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/structure/contact/edit/%', 'Edit contact category', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/contact/contact.admin.inc'),
('admin/structure/menu', '', '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'menu_overview_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/structure/menu', 'Menus', 't', '', '', 'a:0:{}', 6, 'Add new menus to your site, edit existing menus, and rename and reorganize menu links.', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/add', '', '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31343a226d656e755f656469745f6d656e75223b693a313b733a333a22616464223b7d, '', 15, 4, 1, 'admin/structure/menu', 'admin/structure/menu', 'Add menu', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/item/%/delete', 0x613a313a7b693a343b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'menu_item_delete_page', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 0, '', 'admin/structure/menu/item/%/delete', 'Delete menu link', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/item/%/edit', 0x613a313a7b693a343b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a31343a226d656e755f656469745f6974656d223b693a313b733a343a2265646974223b693a323b693a343b693a333b4e3b7d, '', 61, 6, 0, '', 'admin/structure/menu/item/%/edit', 'Edit menu link', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/item/%/reset', 0x613a313a7b693a343b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a226d656e755f72657365745f6974656d5f636f6e6669726d223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/structure/menu/item/%/reset', 'Reset menu link', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/list', '', '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'menu_overview_page', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/menu', 'admin/structure/menu', 'List menus', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%', 0x613a313a7b693a343b733a393a226d656e755f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31383a226d656e755f6f766572766965775f666f726d223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/structure/menu/manage/%', 'Customize menu', 'menu_overview_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/add', 0x613a313a7b693a343b733a393a226d656e755f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a31343a226d656e755f656469745f6974656d223b693a313b733a333a22616464223b693a323b4e3b693a333b693a343b7d, '', 61, 6, 1, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Add link', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/delete', 0x613a313a7b693a343b733a393a226d656e755f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'menu_delete_menu_page', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 0, '', 'admin/structure/menu/manage/%/delete', 'Delete menu', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/edit', 0x613a313a7b693a343b733a393a226d656e755f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31343a226d656e755f656469745f6d656e75223b693a313b733a343a2265646974223b693a323b693a343b7d, '', 61, 6, 3, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Edit menu', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/list', 0x613a313a7b693a343b733a393a226d656e755f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31383a226d656e755f6f766572766965775f666f726d223b693a313b693a343b7d, '', 61, 6, 3, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'List links', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/menu/menu.admin.inc'),
('admin/structure/menu/parents', '', '', 'user_access', 0x613a313a7b693a303b623a313b7d, 'menu_parent_options_js', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/structure/menu/parents', 'Parent menu items', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/structure/menu/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31353a2261646d696e6973746572206d656e75223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a226d656e755f636f6e666967757265223b7d, '', 15, 4, 1, 'admin/structure/menu', 'admin/structure/menu', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 5, 'modules/menu/menu.admin.inc'),
('admin/structure/pages', '', '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_list_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/structure/pages', 'Pages', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, 'Add, edit and remove overridden system pages and user defined pages from the system.', '', 0, 'sites/all/modules/ctools/page_manager/page_manager.admin.inc'),
('admin/structure/pages/%/disable/%', 0x613a323a7b693a333b733a31343a2263746f6f6c735f6a735f6c6f6164223b693a353b733a32333a22706167655f6d616e616765725f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_enable_page', 0x613a333a7b693a303b623a313b693a313b693a333b693a323b693a353b7d, '', 58, 6, 0, '', 'admin/structure/pages/%/disable/%', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/page_manager.admin.inc'),
('admin/structure/pages/%/enable/%', 0x613a323a7b693a333b733a31343a2263746f6f6c735f6a735f6c6f6164223b693a353b733a32333a22706167655f6d616e616765725f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_enable_page', 0x613a333a7b693a303b623a303b693a313b693a333b693a323b693a353b7d, '', 58, 6, 0, '', 'admin/structure/pages/%/enable/%', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/page_manager.admin.inc'),
('admin/structure/pages/%/operation/%', 0x613a323a7b693a333b733a31343a2263746f6f6c735f6a735f6c6f6164223b693a353b733a32333a22706167655f6d616e616765725f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_edit_page_operation', 0x613a323a7b693a303b693a333b693a313b693a353b7d, '', 58, 6, 0, '', 'admin/structure/pages/%/operation/%', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/ctools/page_manager/page_manager.admin.inc'),
('admin/structure/pages/add', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e69737465722070616765206d616e61676572223b7d, 'page_manager_page_add_subtask', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/pages', 'admin/structure/pages', 'Add custom page', 't', '', 'ajax_base_page_theme', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.admin.inc'),
('admin/structure/pages/argument', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e69737465722070616765206d616e61676572223b7d, 'page_manager_page_subtask_argument_ajax', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/structure/pages/argument', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.admin.inc'),
('admin/structure/pages/edit/%', 0x613a313a7b693a343b733a32333a22706167655f6d616e616765725f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_edit_page', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'admin/structure/pages/edit/%', 'Edit', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/ctools/page_manager/page_manager.admin.inc'),
('admin/structure/pages/import', '', '', 'ctools_access_multiperm', 0x613a323a7b693a303b733a32333a2261646d696e69737465722070616765206d616e61676572223b693a313b733a32303a227573652050485020666f722073657474696e6773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33323a22706167655f6d616e616765725f706167655f696d706f72745f7375627461736b223b693a313b733a343a2270616765223b7d, '', 15, 4, 1, 'admin/structure/pages', 'admin/structure/pages', 'Import page', 't', '', 'ajax_base_page_theme', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.admin.inc'),
('admin/structure/pages/list', '', '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_list_page', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/pages', 'admin/structure/pages', 'List', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/ctools/page_manager/page_manager.admin.inc'),
('admin/structure/pages/wizard', '', '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_page_wizard_list', 0x613a313a7b693a303b693a343b7d, '', 15, 4, 1, 'admin/structure/pages', 'admin/structure/pages', 'Wizards', 't', '', 'ajax_base_page_theme', 'a:0:{}', 132, '', '', -5, 'sites/all/modules/ctools/includes/page-wizard.inc'),
('admin/structure/pages/wizard/%', 0x613a313a7b693a343b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a227573652070616765206d616e61676572223b7d, 'page_manager_page_wizard', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'admin/structure/pages/wizard/%', 'Wizard', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/page-wizard.inc'),
('admin/structure/panels', '', '', 'user_access', 0x613a313a7b693a303b733a32303a227573652070616e656c732064617368626f617264223b7d, 'panels_admin_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/structure/panels', 'Panels', 't', '', '', 'a:0:{}', 6, 'Get a bird''s eye view of items related to Panels.', '', 0, 'sites/all/modules/panels/includes/callbacks.inc'),
('admin/structure/panels/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a32303a227573652070616e656c732064617368626f617264223b7d, 'panels_admin_page', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/panels', 'admin/structure/panels', 'Dashboard', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/panels/includes/callbacks.inc'),
('admin/structure/panels/layouts', '', '', 'ctools_export_ui_task_access', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a226c697374223b7d, 'ctools_export_ui_switcher_page', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a226c697374223b7d, '', 15, 4, 1, 'admin/structure/panels', 'admin/structure/panels', 'Layouts', 't', '', '', 'a:0:{}', 132, 'Add, edit or delete custom content layouts.', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/add-flexible', '', '', 'ctools_export_ui_task_access', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a333a22616464223b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a333a22616464223b693a323b733a383a22666c657869626c65223b7d, '', 31, 5, 1, 'admin/structure/panels/layouts', 'admin/structure/panels', 'Add flexible layout', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/import', '', '', 'ctools_export_ui_task_access', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a22696d706f7274223b7d, 'ctools_export_ui_switcher_page', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a22696d706f7274223b7d, '', 31, 5, 1, 'admin/structure/panels/layouts', 'admin/structure/panels', 'Import', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list', '', '', 'ctools_export_ui_task_access', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a226c697374223b7d, 'ctools_export_ui_switcher_page', 0x613a323a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a226c697374223b7d, '', 31, 5, 1, 'admin/structure/panels/layouts', 'admin/structure/panels', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a2265646974223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a2265646974223b693a323b693a353b7d, '', 62, 6, 0, '', 'admin/structure/panels/layouts/list/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%/clone', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a353a22636c6f6e65223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a353a22636c6f6e65223b693a323b693a353b7d, '', 125, 7, 0, '', 'admin/structure/panels/layouts/list/%/clone', 'Clone', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%/delete', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a2264656c657465223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a2264656c657465223b693a323b693a353b7d, '', 125, 7, 0, '', 'admin/structure/panels/layouts/list/%/delete', 'Delete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%/disable', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a373a2264697361626c65223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a373a2264697361626c65223b693a323b693a353b7d, '', 125, 7, 0, '', 'admin/structure/panels/layouts/list/%/disable', 'Disable', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%/edit', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a2265646974223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a343a2265646974223b693a323b693a353b7d, '', 125, 7, 1, 'admin/structure/panels/layouts/list/%', 'admin/structure/panels/layouts/list/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%/enable', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a22656e61626c65223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a22656e61626c65223b693a323b693a353b7d, '', 125, 7, 0, '', 'admin/structure/panels/layouts/list/%/enable', 'Enable', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/layouts/list/%/export', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a226578706f7274223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a226578706f7274223b693a323b693a353b7d, '', 125, 7, 1, 'admin/structure/panels/layouts/list/%', 'admin/structure/panels/layouts/list/%', 'Export', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/structure/panels/layouts/list/%/revert', 0x613a313a7b693a353b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a31343a2270616e656c735f6c61796f757473223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a22726576657274223b693a323b693a353b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a31343a2270616e656c735f6c61796f757473223b693a313b733a363a2264656c657465223b693a323b693a353b7d, '', 125, 7, 0, '', 'admin/structure/panels/layouts/list/%/revert', 'Revert', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/panels/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32303a227573652070616e656c732064617368626f617264223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a2270616e656c735f61646d696e5f73657474696e67735f70616765223b7d, '', 15, 4, 1, 'admin/structure/panels', 'admin/structure/panels', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/panels/includes/callbacks.inc'),
('admin/structure/panels/settings/general', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e69737465722070616765206d616e61676572223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a2270616e656c735f61646d696e5f73657474696e67735f70616765223b7d, '', 31, 5, 1, 'admin/structure/panels/settings', 'admin/structure/panels', 'General', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/panels/includes/callbacks.inc'),
('admin/structure/panels/settings/panel-page', '', '', 'user_access', 0x613a313a7b693a303b733a32303a227573652070616e656c732064617368626f617264223b7d, 'panels_admin_panel_context_page', 0x613a303a7b7d, '', 31, 5, 1, 'admin/structure/panels/settings', 'admin/structure/panels', 'Panel pages', 't', '', '', 'a:0:{}', 132, '', '', -10, 'sites/all/modules/panels/includes/callbacks.inc'),
('admin/structure/taxonomy', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a227461786f6e6f6d795f6f766572766965775f766f636162756c6172696573223b7d, '', 7, 3, 0, '', 'admin/structure/taxonomy', 'Taxonomy', 't', '', '', 'a:0:{}', 6, 'Manage tagging, categorization, and classification of your content.', '', 0, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a227461786f6e6f6d795f6f766572766965775f7465726d73223b693a313b693a333b7d, '', 14, 4, 0, '', 'admin/structure/taxonomy/%', '', 'entity_label', 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}', '', 'a:0:{}', 6, '', '', 0, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/add', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31383a227461786f6e6f6d795f666f726d5f7465726d223b693a313b613a303a7b7d693a323b693a333b7d, '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Add term', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/display', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31333a227461786f6e6f6d795f7465726d223b693a323b693a333b693a333b733a373a2264656661756c74223b7d, '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/default', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31333a227461786f6e6f6d795f7465726d223b693a323b693a333b693a333b733a373a2264656661756c74223b7d, '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/full', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31333a227461786f6e6f6d795f7465726d223b693a323b693a333b693a333b733a343a2266756c6c223b7d, '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Taxonomy term page', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/edit', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a227461786f6e6f6d795f666f726d5f766f636162756c617279223b693a313b693a333b7d, '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', -10, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/fields', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31333a227461786f6e6f6d795f7465726d223b693a323b693a333b7d, '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%', 0x613a323a7b693a333b613a313a7b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 58, 6, 0, '', 'admin/structure/taxonomy/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/delete', 0x613a323a7b693a333b613a313a7b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a353b7d, '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/edit', 0x613a323a7b693a333b613a313a7b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/field-settings', 0x613a323a7b693a333b613a313a7b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a353b7d, '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/widget-type', 0x613a323a7b693a333b613a313a7b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a227461786f6e6f6d795f7465726d223b693a313b693a333b693a323b733a313a2233223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a353b7d, '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/list', 0x613a313a7b693a333b733a33373a227461786f6e6f6d795f766f636162756c6172795f6d616368696e655f6e616d655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a227461786f6e6f6d795f6f766572766965775f7465726d73223b693a313b693a333b7d, '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'List', 't', '', '', 'a:0:{}', 140, '', '', -20, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/add', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a227461786f6e6f6d795f666f726d5f766f636162756c617279223b7d, '', 15, 4, 1, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Add vocabulary', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/list', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e6973746572207461786f6e6f6d79223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a227461786f6e6f6d795f6f766572766965775f766f636162756c6172696573223b7d, '', 15, 4, 1, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/trigger', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'trigger_assign', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/structure/trigger', 'Triggers', 't', '', '', 'a:0:{}', 6, 'Configure when to execute actions.', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/trigger/comment', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'trigger_assign', 0x613a313a7b693a303b733a373a22636f6d6d656e74223b7d, '', 15, 4, 1, 'admin/structure/trigger', 'admin/structure/trigger', 'Comment', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/trigger/node', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'trigger_assign', 0x613a313a7b693a303b733a343a226e6f6465223b7d, '', 15, 4, 1, 'admin/structure/trigger', 'admin/structure/trigger', 'Node', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/trigger/system', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'trigger_assign', 0x613a313a7b693a303b733a363a2273797374656d223b7d, '', 15, 4, 1, 'admin/structure/trigger', 'admin/structure/trigger', 'System', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/trigger/taxonomy', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'trigger_assign', 0x613a313a7b693a303b733a383a227461786f6e6f6d79223b7d, '', 15, 4, 1, 'admin/structure/trigger', 'admin/structure/trigger', 'Taxonomy', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/trigger/unassign', '', '', 'trigger_menu_unassign_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a22747269676765725f756e61737369676e223b7d, '', 15, 4, 0, '', 'admin/structure/trigger/unassign', 'Unassign', 't', '', '', 'a:0:{}', 4, 'Unassign an action from a trigger.', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/trigger/user', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'trigger_assign', 0x613a313a7b693a303b733a343a2275736572223b7d, '', 15, 4, 1, 'admin/structure/trigger', 'admin/structure/trigger', 'User', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/trigger/trigger.admin.inc'),
('admin/structure/types', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'node_overview_types', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/structure/types', 'Content types', 't', '', '', 'a:0:{}', 6, 'Manage content types, including default status, front page promotion, comment settings, etc.', '', 0, 'modules/node/content_types.inc'),
('admin/structure/types/add', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a226e6f64655f747970655f666f726d223b7d, '', 15, 4, 1, 'admin/structure/types', 'admin/structure/types', 'Add content type', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/node/content_types.inc'),
('admin/structure/types/list', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'node_overview_types', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/types', 'admin/structure/types', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/node/content_types.inc'),
('admin/structure/types/manage/%', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31343a226e6f64655f747970655f666f726d223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/structure/types/manage/%', 'Edit content type', 'node_type_page_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/node/content_types.inc'),
('admin/structure/types/manage/%/comment/display', 0x613a313a7b693a343b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a373a22636f6d6d656e74223b693a323b693a343b693a333b733a373a2264656661756c74223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Comment display', 't', '', '', 'a:0:{}', 132, '', '', 4, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/default', 0x613a313a7b693a343b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a373a22636f6d6d656e74223b693a323b693a343b693a333b733a373a2264656661756c74223b7d, '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/full', 0x613a313a7b693a343b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a373a22636f6d6d656e74223b693a323b693a343b693a333b733a343a2266756c6c223b7d, '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Full comment', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields', 0x613a313a7b693a343b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a373a22636f6d6d656e74223b693a323b693a343b7d, '', 123, 7, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Comment fields', 't', '', '', 'a:0:{}', 132, '', '', 3, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%', 0x613a323a7b693a343b613a313a7b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a373b7d, '', 246, 8, 0, '', 'admin/structure/types/manage/%/comment/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:7;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/delete', 0x613a323a7b693a343b613a313a7b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a373b7d, '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/edit', 0x613a323a7b693a343b613a313a7b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a373b7d, '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/field-settings', 0x613a323a7b693a343b613a313a7b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a373b7d, '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/widget-type', 0x613a323a7b693a343b613a313a7b733a32323a22636f6d6d656e745f6e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a373a22636f6d6d656e74223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a373b7d, '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/delete', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226e6f64655f747970655f64656c6574655f636f6e6669726d223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/structure/types/manage/%/delete', 'Delete', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/node/content_types.inc'),
('admin/structure/types/manage/%/display', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a373a2264656661756c74223b7d, '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/default', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a373a2264656661756c74223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/full', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a343a2266756c6c223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Full content', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/rss', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a333a22727373223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a333a22727373223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'RSS', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/search_index', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a31323a227365617263685f696e646578223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a31323a227365617263685f696e646578223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Search index', 't', '', '', 'a:0:{}', 132, '', '', 3, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/search_result', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a31333a227365617263685f726573756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a31333a227365617263685f726573756c74223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Search result', 't', '', '', 'a:0:{}', 132, '', '', 4, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/teaser', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a363a22746561736572223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b693a333b733a363a22746561736572223b7d, '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Teaser', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/edit', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31343a226e6f64655f747970655f666f726d223b693a313b693a343b7d, '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/node/content_types.inc'),
('admin/structure/types/manage/%/fields', 0x613a313a7b693a343b733a31343a226e6f64655f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a343a226e6f6465223b693a323b693a343b7d, '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%', 0x613a323a7b693a343b613a313a7b733a31343a226e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 122, 7, 0, '', 'admin/structure/types/manage/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/delete', 0x613a323a7b693a343b613a313a7b733a31343a226e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/edit', 0x613a323a7b693a343b613a313a7b733a31343a226e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/field-settings', 0x613a323a7b693a343b613a313a7b733a31343a226e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/widget-type', 0x613a323a7b693a343b613a313a7b733a31343a226e6f64655f747970655f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a226e6f6465223b693a313b693a343b693a323b733a313a2234223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/structure/views', '', '', 'ctools_export_ui_task_access', 0x613a323a7b693a303b733a383a2276696577735f7569223b693a313b733a343a226c697374223b7d, 'ctools_export_ui_switcher_page', 0x613a323a7b693a303b733a383a2276696577735f7569223b693a313b733a343a226c697374223b7d, '', 7, 3, 0, '', 'admin/structure/views', 'Views', 't', '', '', 'a:0:{}', 6, 'Manage customized lists of content.', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/add', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_add_page', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'Add new view', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/add-template', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_add_template_page', 0x613a303a7b7d, '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'Add view from template', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/ajax/%/%', 0x613a323a7b693a343b4e3b693a353b733a31393a2276696577735f75695f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_ajax_form', 0x613a333a7b693a303b623a313b693a313b693a343b693a323b693a353b7d, 'ajax_deliver', 60, 6, 0, '', 'admin/structure/views/ajax/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/ajax/preview/%/%', 0x613a323a7b693a353b733a31393a2276696577735f75695f63616368655f6c6f6164223b693a363b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_preview', 0x613a323a7b693a303b693a353b693a313b693a363b7d, 'ajax_deliver', 124, 7, 0, '', 'admin/structure/views/ajax/preview/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/import', '', '', 'views_import_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2276696577735f75695f696d706f72745f70616765223b7d, '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'Import', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/list', '', '', 'ctools_export_ui_task_access', 0x613a323a7b693a303b733a383a2276696577735f7569223b693a313b733a343a226c697374223b7d, 'ctools_export_ui_switcher_page', 0x613a323a7b693a303b733a383a2276696577735f7569223b693a313b733a343a226c697374223b7d, '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/nojs/%/%', 0x613a323a7b693a343b4e3b693a353b733a31393a2276696577735f75695f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_ajax_form', 0x613a333a7b693a303b623a303b693a313b693a343b693a323b693a353b7d, '', 60, 6, 0, '', 'admin/structure/views/nojs/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/nojs/preview/%/%', 0x613a323a7b693a353b733a31393a2276696577735f75695f63616368655f6c6f6164223b693a363b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_preview', 0x613a323a7b693a303b693a353b693a313b693a363b7d, '', 124, 7, 0, '', 'admin/structure/views/nojs/preview/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a2276696577735f75695f61646d696e5f73657474696e67735f6261736963223b7d, '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/settings/advanced', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2276696577735f75695f61646d696e5f73657474696e67735f616476616e636564223b7d, '', 31, 5, 1, 'admin/structure/views/settings', 'admin/structure/views', 'Advanced', 't', '', '', 'a:0:{}', 132, '', '', 1, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/settings/basic', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a2276696577735f75695f61646d696e5f73657474696e67735f6261736963223b7d, '', 31, 5, 1, 'admin/structure/views/settings', 'admin/structure/views', 'Basic', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/template/%/add', 0x613a313a7b693a343b4e3b7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a31323a226164645f74656d706c617465223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a31323a226164645f74656d706c617465223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/template/%/add', 'Add from template', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/view/%', 0x613a313a7b693a343b733a31393a2276696577735f75695f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_edit_page', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'admin/structure/views/view/%', '', 'views_ui_edit_page_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/view/%/break-lock', 0x613a313a7b693a343b733a31393a2276696577735f75695f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a2276696577735f75695f627265616b5f6c6f636b5f636f6e6669726d223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/break-lock', 'Break lock', 't', '', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/view/%/clone', 0x613a313a7b693a343b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a383a2276696577735f7569223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a353a22636c6f6e65223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a353a22636c6f6e65223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/clone', 'Clone', 't', '', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/view/%/delete', 0x613a313a7b693a343b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a383a2276696577735f7569223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a2264656c657465223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a2264656c657465223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/view/%/disable', 0x613a313a7b693a343b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a383a2276696577735f7569223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a373a2264697361626c65223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a373a2264697361626c65223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/disable', 'Disable', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/view/%/edit', 0x613a313a7b693a343b733a31393a2276696577735f75695f63616368655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_edit_page', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 3, 'admin/structure/views/view/%', 'admin/structure/views/view/%', 'Edit view', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/view/%/edit/%/ajax', 0x613a323a7b693a343b733a31393a2276696577735f75695f63616368655f6c6f6164223b693a363b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_ajax_get_form', 0x613a333a7b693a303b733a31383a2276696577735f75695f656469745f666f726d223b693a313b693a343b693a323b693a363b7d, 'ajax_deliver', 245, 8, 0, '', 'admin/structure/views/view/%/edit/%/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/view/%/enable', 0x613a313a7b693a343b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a383a2276696577735f7569223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a22656e61626c65223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a22656e61626c65223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/enable', 'Enable', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/view/%/export', 0x613a313a7b693a343b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a383a2276696577735f7569223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a226578706f7274223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a226578706f7274223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/export', 'Export', 't', '', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/structure/views/view/%/preview/%', 0x613a323a7b693a343b733a31393a2276696577735f75695f63616368655f6c6f6164223b693a363b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_build_preview', 0x613a323a7b693a303b693a343b693a313b693a363b7d, '', 122, 7, 3, '', 'admin/structure/views/view/%/preview/%', '', 't', '', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/view/%/preview/%/ajax', 0x613a323a7b693a343b733a31393a2276696577735f75695f63616368655f6c6f6164223b693a363b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_build_preview', 0x613a323a7b693a303b693a343b693a313b693a363b7d, 'ajax_deliver', 245, 8, 0, '', 'admin/structure/views/view/%/preview/%/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/structure/views/view/%/revert', 0x613a313a7b693a343b613a313a7b733a32313a2263746f6f6c735f6578706f72745f75695f6c6f6164223b613a313a7b693a303b733a383a2276696577735f7569223b7d7d7d, '', 'ctools_export_ui_task_access', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a22726576657274223b693a323b693a343b7d, 'ctools_export_ui_switcher_page', 0x613a333a7b693a303b733a383a2276696577735f7569223b693a313b733a363a2264656c657465223b693a323b693a343b7d, '', 61, 6, 0, '', 'admin/structure/views/view/%/revert', 'Revert', 't', '', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/ctools/includes/export-ui.inc'),
('admin/tasks', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 1, 'admin', 'admin', 'Tasks', 't', '', '', 'a:0:{}', 140, '', '', -20, 'modules/system/system.admin.inc'),
('admin/update/ready', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a227570646174655f6d616e616765725f7570646174655f72656164795f666f726d223b7d, '', 7, 3, 0, '', 'admin/update/ready', 'Ready to update', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/update/update.manager.inc'),
('admin/views/ajax/autocomplete/tag', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_autocomplete_tag', 0x613a303a7b7d, '', 31, 5, 0, '', 'admin/views/ajax/autocomplete/tag', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/views/ajax/autocomplete/taxonomy', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'views_ajax_autocomplete_taxonomy', 0x613a303a7b7d, '', 31, 5, 0, '', 'admin/views/ajax/autocomplete/taxonomy', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/ajax.inc'),
('admin/views/ajax/autocomplete/user', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261636365737320757365722070726f66696c6573223b7d, 'views_ajax_autocomplete_user', 0x613a303a7b7d, '', 31, 5, 0, '', 'admin/views/ajax/autocomplete/user', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/views/includes/ajax.inc'),
('admin_menu/flush-cache', '', '', 'user_access', 0x613a313a7b693a303b733a31323a22666c75736820636163686573223b7d, 'admin_menu_flush_cache', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin_menu/flush-cache', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/admin_menu/admin_menu.inc'),
('admin_menu/toggle-modules', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'admin_menu_toggle_modules', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin_menu/toggle-modules', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/admin_menu/admin_menu.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('advanced_help/search/%', 0x613a313a7b693a323b733a31343a226d656e755f7461696c5f6c6f6164223b7d, 0x613a313a7b693a323b733a31363a226d656e755f7461696c5f746f5f617267223b7d, 'user_access', 0x613a313a7b693a303b733a32343a227669657720616476616e6365642068656c7020696e646578223b7d, 'advanced_help_search_view', 0x613a313a7b693a303b733a31333a22616476616e6365645f68656c70223b7d, '', 6, 3, 0, '', 'advanced_help/search/%', 'Search help', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('bages', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31363a226c6162656c735f616e645f6261676573223b7d, '', 1, 1, 0, '', 'bages', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('bars', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31333a2270726f67726573735f62617273223b7d, '', 1, 1, 0, '', 'bars', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('batch', '', '', '1', 0x613a303a7b7d, 'system_batch_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'batch', '', 't', '', '_system_batch_theme', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('blog', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a343a22626c6f67223b693a313b733a343a2270616765223b7d, '', 1, 1, 0, '', 'blog', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('blog/%', 0x613a313a7b693a313b733a32323a22757365725f7569645f6f7074696f6e616c5f6c6f6164223b7d, 0x613a313a7b693a313b733a32343a22757365725f7569645f6f7074696f6e616c5f746f5f617267223b7d, 'blog_page_user_access', 0x613a313a7b693a303b693a313b7d, 'blog_page_user', 0x613a313a7b693a303b693a313b7d, '', 2, 2, 0, '', 'blog/%', 'My blog', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/blog/blog.pages.inc'),
('blog/%/feed', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', 'blog_page_user_access', 0x613a313a7b693a303b693a313b7d, 'blog_feed_user', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 0, '', 'blog/%/feed', 'Blogs', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/blog/blog.pages.inc'),
('blog/feed', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'blog_feed_last', 0x613a303a7b7d, '', 3, 2, 0, '', 'blog/feed', 'Blogs', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/blog/blog.pages.inc'),
('buttons', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a373a22627574746f6e73223b7d, '', 1, 1, 0, '', 'buttons', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('category-blog', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31333a2263617465676f72795f626c6f67223b693a313b733a343a2270616765223b7d, '', 1, 1, 0, '', 'category-blog', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('comment/%', 0x613a313a7b693a313b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261636365737320636f6d6d656e7473223b7d, 'comment_permalink', 0x613a313a7b693a303b693a313b7d, '', 2, 2, 0, '', 'comment/%', 'Comment permalink', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('comment/%/approve', 0x613a313a7b693a313b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_approve', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 0, '', 'comment/%/approve', 'Approve', 't', '', '', 'a:0:{}', 6, '', '', 1, 'modules/comment/comment.pages.inc'),
('comment/%/delete', 0x613a313a7b693a313b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_confirm_delete_page', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'comment/%', 'comment/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/comment/comment.admin.inc'),
('comment/%/edit', 0x613a313a7b693a313b733a31323a22636f6d6d656e745f6c6f6164223b7d, '', 'comment_access', 0x613a323a7b693a303b733a343a2265646974223b693a313b693a313b7d, 'comment_edit_page', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'comment/%', 'comment/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, ''),
('comment/%/view', 0x613a313a7b693a313b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31353a2261636365737320636f6d6d656e7473223b7d, 'comment_permalink', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'comment/%', 'comment/%', 'View comment', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('comment/reply/%', 0x613a313a7b693a323b733a393a226e6f64655f6c6f6164223b7d, '', 'node_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a323b7d, 'comment_reply', 0x613a313a7b693a303b693a323b7d, '', 6, 3, 0, '', 'comment/reply/%', 'Add new comment', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/comment/comment.pages.inc'),
('comments/recent', '', '', 'views_access', 0x613a313a7b693a303b623a313b7d, 'views_page', 0x613a323a7b693a303b733a31353a22636f6d6d656e74735f726563656e74223b693a313b733a343a2270616765223b7d, '', 3, 2, 0, '', 'comments/recent', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('contact', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261636365737320736974652d7769646520636f6e7461637420666f726d223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31373a22636f6e746163745f736974655f666f726d223b7d, '', 1, 1, 0, '', 'contact', 'Contact', 't', '', '', 'a:0:{}', 20, '', '', 0, 'modules/contact/contact.pages.inc'),
('ctools/autocomplete/%', 0x613a313a7b693a323b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_content_autocomplete_entity', 0x613a313a7b693a303b693a323b7d, '', 6, 3, 0, '', 'ctools/autocomplete/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/content.menu.inc'),
('ctools/context/ajax/access/add', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_access_ajax_add', 0x613a303a7b7d, '', 31, 5, 0, '', 'ctools/context/ajax/access/add', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/context-access-admin.inc'),
('ctools/context/ajax/access/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_access_ajax_edit', 0x613a303a7b7d, '', 31, 5, 0, '', 'ctools/context/ajax/access/configure', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/context-access-admin.inc'),
('ctools/context/ajax/access/delete', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_access_ajax_delete', 0x613a303a7b7d, '', 31, 5, 0, '', 'ctools/context/ajax/access/delete', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/context-access-admin.inc'),
('ctools/context/ajax/add', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_context_ajax_item_add', 0x613a303a7b7d, '', 15, 4, 0, '', 'ctools/context/ajax/add', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/context-admin.inc'),
('ctools/context/ajax/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_context_ajax_item_edit', 0x613a303a7b7d, '', 15, 4, 0, '', 'ctools/context/ajax/configure', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/context-admin.inc'),
('ctools/context/ajax/delete', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'ctools_context_ajax_item_delete', 0x613a303a7b7d, '', 15, 4, 0, '', 'ctools/context/ajax/delete', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/includes/context-admin.inc'),
('ctools_ajax_sample', '', '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'ctools_ajax_sample', 'Chaos Tools AJAX Demo', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('ctools_ajax_sample/%/animal', 0x613a313a7b693a313b733a31343a2263746f6f6c735f6a735f6c6f6164223b7d, '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_animal', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 0, '', 'ctools_ajax_sample/%/animal', 'Animal', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('ctools_ajax_sample/%/hello', 0x613a313a7b693a313b733a31343a2263746f6f6c735f6a735f6c6f6164223b7d, '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_hello', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 0, '', 'ctools_ajax_sample/%/hello', 'Hello World', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('ctools_ajax_sample/%/login', 0x613a313a7b693a313b733a31343a2263746f6f6c735f6a735f6c6f6164223b7d, '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_login', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 0, '', 'ctools_ajax_sample/%/login', 'Login', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('ctools_ajax_sample/%/login/%', 0x613a323a7b693a313b733a31343a2263746f6f6c735f6a735f6c6f6164223b693a333b4e3b7d, '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_login_success', 0x613a323a7b693a303b693a313b693a313b693a333b7d, '', 10, 4, 0, '', 'ctools_ajax_sample/%/login/%', 'Post-Login Action', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('ctools_ajax_sample/%/tablenix/%', 0x613a323a7b693a313b733a31343a2263746f6f6c735f6a735f6c6f6164223b693a333b4e3b7d, '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_tablenix', 0x613a323a7b693a303b693a313b693a313b693a333b7d, '', 10, 4, 0, '', 'ctools_ajax_sample/%/tablenix/%', 'Hello World', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('ctools_ajax_sample/jumped', '', '', '1', 0x613a303a7b7d, 'ctools_ajax_sample_jump_menu_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'ctools_ajax_sample/jumped', 'Successful Jumping', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('ctools_ajax_sample/simple_form', '', '', '1', 0x613a303a7b7d, 'ctools_ajax_simple_form', 0x613a303a7b7d, '', 3, 2, 0, '', 'ctools_ajax_sample/simple_form', 'Simple Form', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('file/ajax', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'file_ajax_upload', 0x613a303a7b7d, 'ajax_deliver', 3, 2, 0, '', 'file/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('file/progress', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'file_ajax_progress', 0x613a303a7b7d, '', 3, 2, 0, '', 'file/progress', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('filter/tips', '', '', '1', 0x613a303a7b7d, 'filter_tips_long', 0x613a303a7b7d, '', 3, 2, 0, '', 'filter/tips', 'Compose tips', 't', '', '', 'a:0:{}', 20, '', '', 0, 'modules/filter/filter.pages.inc'),
('forum', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a353a22666f72756d223b7d, '', 1, 1, 0, '', 'forum', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('help/%/%', 0x613a323a7b693a313b4e3b693a323b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32343a227669657720616476616e6365642068656c7020746f706963223b7d, 'advanced_help_topic_page', 0x613a323a7b693a303b693a313b693a313b693a323b7d, '', 4, 3, 0, '', 'help/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('icons', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a353a2269636f6e73223b7d, '', 1, 1, 0, '', 'icons', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('js/admin_menu/cache', '', '', 'user_access', 0x613a313a7b693a303b733a32363a226163636573732061646d696e697374726174696f6e206d656e75223b7d, 'admin_menu_js_cache', 0x613a303a7b7d, 'admin_menu_deliver', 7, 3, 0, '', 'js/admin_menu/cache', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('lorem', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a353a226c6f72656d223b7d, '', 1, 1, 0, '', 'lorem', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('media/%', 0x613a313a7b693a313b733a393a2266696c655f6c6f6164223b7d, '', 'media_access', 0x613a313a7b693a303b733a343a2276696577223b7d, 'media_view_page', 0x613a313a7b693a303b693a313b7d, '', 2, 2, 0, '', 'media/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/media/includes/media.pages.inc'),
('media/%/delete', 0x613a313a7b693a313b733a393a2266696c655f6c6f6164223b7d, '', 'media_access', 0x613a313a7b693a303b733a343a2265646974223b7d, 'media_page_delete', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 3, 'media/%', 'media/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 1, 'sites/all/modules/media/includes/media.pages.inc'),
('media/%/edit', 0x613a313a7b693a313b733a393a2266696c655f6c6f6164223b7d, '', 'media_access', 0x613a313a7b693a303b733a343a2265646974223b7d, 'media_page_edit', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 3, 'media/%', 'media/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/media/includes/media.pages.inc'),
('media/%/format-form', 0x613a313a7b693a313b733a393a2266696c655f6c6f6164223b7d, '', 'media_access', 0x613a313a7b693a303b733a343a2276696577223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31373a226d656469615f666f726d61745f666f726d223b693a313b693a313b7d, '', 5, 3, 0, '', 'media/%/format-form', 'Style selector', 't', '', 'media_dialog_get_theme_name', 'a:0:{}', 6, 'Choose a format for a piece of media', '', 0, 'sites/all/modules/media/includes/media.filter.inc'),
('media/%/multiedit', 0x613a313a7b693a313b733a31363a226d656469615f6d756c74695f6c6f6164223b7d, '', 'media_access', 0x613a313a7b693a303b733a343a2265646974223b7d, 'media_page_multiedit', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 0, '', 'media/%/multiedit', 'Multi Edit', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/media/includes/media.pages.inc'),
('media/%/view', 0x613a313a7b693a313b733a393a2266696c655f6c6f6164223b7d, '', 'media_access', 0x613a313a7b693a303b733a343a2276696577223b7d, 'media_view_page', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'media/%', 'media/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/media/includes/media.pages.inc'),
('media/browser', '', '', 'media_access', 0x613a313a7b693a303b733a343a2276696577223b7d, 'media_browser', 0x613a303a7b7d, '', 3, 2, 0, '', 'media/browser', 'Media browser', 't', '', 'media_dialog_get_theme_name', 'a:0:{}', 0, 'Media Browser for picking media and uploading new media', '', 0, 'sites/all/modules/media/includes/media.browser.inc'),
('media/browser/library', '', '', 'media_access', 0x613a313a7b693a303b733a343a2276696577223b7d, 'media_browser_library', 0x613a303a7b7d, '', 7, 3, 0, '', 'media/browser/library', 'Media browser library', 't', '', 'media_dialog_get_theme_name', 'a:0:{}', 0, 'Media Browser for picking media and uploading new media', '', 0, 'sites/all/modules/media/includes/media.browser.inc'),
('media/browser/list', '', '', 'media_access', 0x613a313a7b693a303b733a343a2276696577223b7d, 'media_browser_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'media/browser/list', 'Media browser list', 't', '', 'media_dialog_get_theme_name', 'a:0:{}', 0, 'Ajax Callback for getting media', '', 0, 'sites/all/modules/media/includes/media.browser.inc'),
('media/browser/testbed', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a226d656469615f62726f777365725f74657374626564223b7d, '', 7, 3, 0, '', 'media/browser/testbed', 'Media Browser test', 't', '', 'media_dialog_get_theme_name', 'a:0:{}', 0, 'Make it easier to test media browser', '', 0, 'sites/all/modules/media/includes/media.browser.inc'),
('navigation404', '', '', '1', 0x613a303a7b7d, 'navigation404_404_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'navigation404', 'Page not found', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('node', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'node_page_default', 0x613a303a7b7d, '', 1, 1, 0, '', 'node', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('node/%', 0x613a313a7b693a313b733a393a226e6f64655f6c6f6164223b7d, '', 'node_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a313b7d, 'node_page_view', 0x613a313a7b693a303b693a313b7d, '', 2, 2, 0, '', 'node/%', '', 'node_page_title', 'a:1:{i:0;i:1;}', '', 'a:0:{}', 6, '', '', 0, ''),
('node/%/delete', 0x613a313a7b693a313b733a393a226e6f64655f6c6f6164223b7d, '', 'node_access', 0x613a323a7b693a303b733a363a2264656c657465223b693a313b693a313b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31393a226e6f64655f64656c6574655f636f6e6669726d223b693a313b693a313b7d, '', 5, 3, 2, 'node/%', 'node/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/node/node.pages.inc'),
('node/%/edit', 0x613a313a7b693a313b733a393a226e6f64655f6c6f6164223b7d, '', 'node_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a313b7d, 'node_page_edit', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 3, 'node/%', 'node/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/node/node.pages.inc'),
('node/%/revisions', 0x613a313a7b693a313b733a393a226e6f64655f6c6f6164223b7d, '', '_node_revision_access', 0x613a313a7b693a303b693a313b7d, 'node_revision_overview', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'node/%', 'node/%', 'Revisions', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/node/node.pages.inc'),
('node/%/revisions/%/delete', 0x613a323a7b693a313b613a313a7b733a393a226e6f64655f6c6f6164223b613a313a7b693a303b693a333b7d7d693a333b4e3b7d, '', '_node_revision_access', 0x613a323a7b693a303b693a313b693a313b733a363a2264656c657465223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226e6f64655f7265766973696f6e5f64656c6574655f636f6e6669726d223b693a313b693a313b7d, '', 21, 5, 0, '', 'node/%/revisions/%/delete', 'Delete earlier revision', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/node/node.pages.inc'),
('node/%/revisions/%/revert', 0x613a323a7b693a313b613a313a7b733a393a226e6f64655f6c6f6164223b613a313a7b693a303b693a333b7d7d693a333b4e3b7d, '', '_node_revision_access', 0x613a323a7b693a303b693a313b693a313b733a363a22757064617465223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226e6f64655f7265766973696f6e5f7265766572745f636f6e6669726d223b693a313b693a313b7d, '', 21, 5, 0, '', 'node/%/revisions/%/revert', 'Revert to earlier revision', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/node/node.pages.inc'),
('node/%/revisions/%/view', 0x613a323a7b693a313b613a313a7b733a393a226e6f64655f6c6f6164223b613a313a7b693a303b693a333b7d7d693a333b4e3b7d, '', '_node_revision_access', 0x613a313a7b693a303b693a313b7d, 'node_show', 0x613a323a7b693a303b693a313b693a313b623a313b7d, '', 21, 5, 0, '', 'node/%/revisions/%/view', 'Revisions', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('node/%/view', 0x613a313a7b693a313b733a393a226e6f64655f6c6f6164223b7d, '', 'node_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a313b7d, 'node_page_view', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'node/%', 'node/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('node/add', '', '', '_node_add_access', 0x613a303a7b7d, 'node_add_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'node/add', 'Add content', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/node/node.pages.inc'),
('node/add/article', '', '', 'node_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b733a373a2261727469636c65223b7d, 'node_add', 0x613a313a7b693a303b733a373a2261727469636c65223b7d, '', 7, 3, 0, '', 'node/add/article', 'Article', 'check_plain', '', '', 'a:0:{}', 6, 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.', '', 0, 'modules/node/node.pages.inc'),
('node/add/blog', '', '', 'node_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b733a343a22626c6f67223b7d, 'node_add', 0x613a313a7b693a303b733a343a22626c6f67223b7d, '', 7, 3, 0, '', 'node/add/blog', 'Blog entry', 'check_plain', '', '', 'a:0:{}', 6, 'Use for multi-user blogs. Every user gets a personal blog.', '', 0, 'modules/node/node.pages.inc'),
('node/add/home-page-gallery', '', '', 'node_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b733a31373a22686f6d655f706167655f67616c6c657279223b7d, 'node_add', 0x613a313a7b693a303b733a31373a22686f6d655f706167655f67616c6c657279223b7d, '', 7, 3, 0, '', 'node/add/home-page-gallery', 'Home page Gallery', 'check_plain', '', '', 'a:0:{}', 6, '', '', 0, 'modules/node/node.pages.inc'),
('node/add/page', '', '', 'node_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b733a343a2270616765223b7d, 'node_add', 0x613a313a7b693a303b733a343a2270616765223b7d, '', 7, 3, 0, '', 'node/add/page', 'Basic page', 'check_plain', '', '', 'a:0:{}', 6, 'Use <em>basic pages</em> for your static content, such as an ''About us'' page.', '', 0, 'modules/node/node.pages.inc'),
('node/add/services', '', '', 'node_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b733a383a227365727669636573223b7d, 'node_add', 0x613a313a7b693a303b733a383a227365727669636573223b7d, '', 7, 3, 0, '', 'node/add/services', 'Services', 'check_plain', '', '', 'a:0:{}', 6, '', '', 0, 'modules/node/node.pages.inc'),
('notifications', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31333a226e6f74696669636174696f6e73223b7d, '', 1, 1, 0, '', 'notifications', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('panels/ajax', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'panels_ajax_router', 0x613a303a7b7d, 'ajax_deliver', 3, 2, 0, '', 'panels/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('quickstart', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31383a22717569636b73746172745f7061636b616765223b7d, '', 1, 1, 0, '', 'quickstart', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('responsive', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31373a22726573706f6e736976655f6c61796f7574223b7d, '', 1, 1, 0, '', 'responsive', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('rss.xml', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'node_feed', 0x613a323a7b693a303b623a303b693a313b613a303a7b7d7d, '', 1, 1, 0, '', 'rss.xml', 'RSS feed', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('search', '', '', 'search_is_active', 0x613a303a7b7d, 'search_view', 0x613a303a7b7d, '', 1, 1, 0, '', 'search', 'Search', 't', '', '', 'a:0:{}', 20, '', '', 0, 'modules/search/search.pages.inc'),
('search/advanced_help/%', 0x613a313a7b693a323b733a31343a226d656e755f7461696c5f6c6f6164223b7d, 0x613a313a7b693a323b733a31363a226d656e755f7461696c5f746f5f617267223b7d, 'user_access', 0x613a313a7b693a303b733a32343a227669657720616476616e6365642068656c7020696e646578223b7d, 'search_view', 0x613a303a7b7d, '', 6, 3, 0, '', 'search/advanced_help/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/search/search.pages.inc'),
('search/node', '', '', '_search_menu_access', 0x613a313a7b693a303b733a343a226e6f6465223b7d, 'search_view', 0x613a323a7b693a303b733a343a226e6f6465223b693a313b733a303a22223b7d, '', 3, 2, 1, 'search', 'search', 'Content', 't', '', '', 'a:0:{}', 132, '', '', -10, 'modules/search/search.pages.inc'),
('search/node/%', 0x613a313a7b693a323b613a313a7b733a31343a226d656e755f7461696c5f6c6f6164223b613a323a7b693a303b733a343a22256d6170223b693a313b733a363a2225696e646578223b7d7d7d, 0x613a313a7b693a323b733a31363a226d656e755f7461696c5f746f5f617267223b7d, '_search_menu_access', 0x613a313a7b693a303b733a343a226e6f6465223b7d, 'search_view', 0x613a323a7b693a303b733a343a226e6f6465223b693a313b693a323b7d, '', 6, 3, 1, 'search/node', 'search/node/%', 'Content', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/search/search.pages.inc'),
('search/user', '', '', '_search_menu_access', 0x613a313a7b693a303b733a343a2275736572223b7d, 'search_view', 0x613a323a7b693a303b733a343a2275736572223b693a313b733a303a22223b7d, '', 3, 2, 1, 'search', 'search', 'Users', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/search/search.pages.inc'),
('search/user/%', 0x613a313a7b693a323b613a313a7b733a31343a226d656e755f7461696c5f6c6f6164223b613a323a7b693a303b733a343a22256d6170223b693a313b733a363a2225696e646578223b7d7d7d, 0x613a313a7b693a323b733a31363a226d656e755f7461696c5f746f5f617267223b7d, '_search_menu_access', 0x613a313a7b693a303b733a343a2275736572223b7d, 'search_view', 0x613a323a7b693a303b733a343a2275736572223b693a313b693a323b7d, '', 6, 3, 1, 'search/node', 'search/node/%', 'Users', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/search/search.pages.inc'),
('sites/default/files/styles/%', 0x613a313a7b693a343b733a31363a22696d6167655f7374796c655f6c6f6164223b7d, '', '1', 0x613a303a7b7d, 'image_style_deliver', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'sites/default/files/styles/%', 'Generate image style', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/ajax', '', '', '1', 0x613a303a7b7d, 'ajax_form_callback', 0x613a303a7b7d, 'ajax_deliver', 3, 2, 0, '', 'system/ajax', 'AHAH callback', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'includes/form.inc'),
('system/files', '', '', '1', 0x613a303a7b7d, 'file_download', 0x613a313a7b693a303b733a373a2270726976617465223b7d, '', 3, 2, 0, '', 'system/files', 'File download', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/files/styles/%', 0x613a313a7b693a333b733a31363a22696d6167655f7374796c655f6c6f6164223b7d, '', '1', 0x613a303a7b7d, 'image_style_deliver', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 0, '', 'system/files/styles/%', 'Generate image style', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/temporary', '', '', '1', 0x613a303a7b7d, 'file_download', 0x613a313a7b693a303b733a393a2274656d706f72617279223b7d, '', 3, 2, 0, '', 'system/temporary', 'Temporary files', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/timezone', '', '', '1', 0x613a303a7b7d, 'system_timezone', 0x613a303a7b7d, '', 3, 2, 0, '', 'system/timezone', 'Time zone', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('taxonomy/autocomplete', '', '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'taxonomy_autocomplete', 0x613a303a7b7d, '', 3, 2, 0, '', 'taxonomy/autocomplete', 'Autocomplete taxonomy', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/taxonomy/taxonomy.pages.inc'),
('taxonomy/term/%', 0x613a313a7b693a323b733a31383a227461786f6e6f6d795f7465726d5f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'taxonomy_term_page', 0x613a313a7b693a303b693a323b7d, '', 6, 3, 0, '', 'taxonomy/term/%', 'Taxonomy term', 'taxonomy_term_title', 'a:1:{i:0;i:2;}', '', 'a:0:{}', 6, '', '', 0, 'modules/taxonomy/taxonomy.pages.inc'),
('taxonomy/term/%/edit', 0x613a313a7b693a323b733a31383a227461786f6e6f6d795f7465726d5f6c6f6164223b7d, '', 'taxonomy_term_edit_access', 0x613a313a7b693a303b693a323b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31383a227461786f6e6f6d795f666f726d5f7465726d223b693a313b693a323b693a323b4e3b7d, '', 13, 4, 1, 'taxonomy/term/%', 'taxonomy/term/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/taxonomy/taxonomy.admin.inc'),
('taxonomy/term/%/feed', 0x613a313a7b693a323b733a31383a227461786f6e6f6d795f7465726d5f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'taxonomy_term_feed', 0x613a313a7b693a303b693a323b7d, '', 13, 4, 0, '', 'taxonomy/term/%/feed', 'Taxonomy term', 'taxonomy_term_title', 'a:1:{i:0;i:2;}', '', 'a:0:{}', 0, '', '', 0, 'modules/taxonomy/taxonomy.pages.inc'),
('taxonomy/term/%/view', 0x613a313a7b693a323b733a31383a227461786f6e6f6d795f7465726d5f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'taxonomy_term_page', 0x613a313a7b693a303b693a323b7d, '', 13, 4, 1, 'taxonomy/term/%', 'taxonomy/term/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/taxonomy/taxonomy.pages.inc'),
('test_test', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a393a22746573745f74657374223b7d, '', 1, 1, 0, '', 'test_test', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('tooltips', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a383a22746f6f6c74697073223b7d, '', 1, 1, 0, '', 'tooltips', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('typography', '', '', 'ctools_access_menu', 0x613a313a7b693a303b613a323a7b733a343a2274797065223b733a343a226e6f6e65223b733a383a2273657474696e6773223b4e3b7d7d, 'page_manager_page_execute', 0x613a313a7b693a303b733a31303a227479706f677261706879223b7d, '', 1, 1, 0, '', 'typography', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/ctools/page_manager/plugins/tasks/page.inc'),
('user', '', '', '1', 0x613a303a7b7d, 'user_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'user', 'User account', 'user_menu_title', '', '', 'a:0:{}', 6, '', '', -10, 'modules/user/user.pages.inc'),
('user/%', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', 'user_view_access', 0x613a313a7b693a303b693a313b7d, 'user_view_page', 0x613a313a7b693a303b693a313b7d, '', 2, 2, 0, '', 'user/%', 'My account', 'user_page_title', 'a:1:{i:0;i:1;}', '', 'a:0:{}', 6, '', '', 0, ''),
('user/%/cancel', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', 'user_cancel_access', 0x613a313a7b693a303b693a313b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a22757365725f63616e63656c5f636f6e6669726d5f666f726d223b693a313b693a313b7d, '', 5, 3, 0, '', 'user/%/cancel', 'Cancel account', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.pages.inc'),
('user/%/cancel/confirm/%/%', 0x613a333a7b693a313b733a393a22757365725f6c6f6164223b693a343b4e3b693a353b4e3b7d, '', 'user_cancel_access', 0x613a313a7b693a303b693a313b7d, 'user_cancel_confirm', 0x613a333a7b693a303b693a313b693a313b693a343b693a323b693a353b7d, '', 44, 6, 0, '', 'user/%/cancel/confirm/%/%', 'Confirm account cancellation', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.pages.inc'),
('user/%/contact', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', '_contact_personal_tab_access', 0x613a313a7b693a303b693a313b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32313a22636f6e746163745f706572736f6e616c5f666f726d223b693a313b693a313b7d, '', 5, 3, 1, 'user/%', 'user/%', 'Contact', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/contact/contact.pages.inc'),
('user/%/edit', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', 'user_edit_access', 0x613a313a7b693a303b693a313b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31373a22757365725f70726f66696c655f666f726d223b693a313b693a313b7d, '', 5, 3, 1, 'user/%', 'user/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/user/user.pages.inc'),
('user/%/edit/account', 0x613a313a7b693a313b613a313a7b733a31383a22757365725f63617465676f72795f6c6f6164223b613a323a7b693a303b733a343a22256d6170223b693a313b733a363a2225696e646578223b7d7d7d, '', 'user_edit_access', 0x613a313a7b693a303b693a313b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31373a22757365725f70726f66696c655f666f726d223b693a313b693a313b7d, '', 11, 4, 1, 'user/%/edit', 'user/%', 'Account', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/user/user.pages.inc'),
('user/%/shortcuts', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', 'shortcut_set_switch_access', 0x613a313a7b693a303b693a313b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31393a2273686f72746375745f7365745f737769746368223b693a313b693a313b7d, '', 5, 3, 1, 'user/%', 'user/%', 'Shortcuts', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('user/%/view', 0x613a313a7b693a313b733a393a22757365725f6c6f6164223b7d, '', 'user_view_access', 0x613a313a7b693a303b693a313b7d, 'user_view_page', 0x613a313a7b693a303b693a313b7d, '', 5, 3, 1, 'user/%', 'user/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('user/autocomplete', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261636365737320757365722070726f66696c6573223b7d, 'user_autocomplete', 0x613a303a7b7d, '', 3, 2, 0, '', 'user/autocomplete', 'User autocomplete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/user/user.pages.inc'),
('user/login', '', '', 'user_is_anonymous', 0x613a303a7b7d, 'user_page', 0x613a303a7b7d, '', 3, 2, 1, 'user', 'user', 'Log in', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/user/user.pages.inc'),
('user/logout', '', '', 'user_is_logged_in', 0x613a303a7b7d, 'user_logout', 0x613a303a7b7d, '', 3, 2, 0, '', 'user/logout', 'Log out', 't', '', '', 'a:0:{}', 6, '', '', 10, 'modules/user/user.pages.inc'),
('user/password', '', '', '1', 0x613a303a7b7d, 'drupal_get_form', 0x613a313a7b693a303b733a393a22757365725f70617373223b7d, '', 3, 2, 1, 'user', 'user', 'Request new password', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/user/user.pages.inc'),
('user/register', '', '', 'user_register_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a22757365725f72656769737465725f666f726d223b7d, '', 3, 2, 1, 'user', 'user', 'Create new account', 't', '', '', 'a:0:{}', 132, '', '', 0, ''),
('user/reset/%/%/%', 0x613a333a7b693a323b4e3b693a333b4e3b693a343b4e3b7d, '', '1', 0x613a303a7b7d, 'drupal_get_form', 0x613a343a7b693a303b733a31353a22757365725f706173735f7265736574223b693a313b693a323b693a323b693a333b693a333b693a343b7d, '', 24, 5, 0, '', 'user/reset/%/%/%', 'Reset password', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/user/user.pages.inc'),
('views/ajax', '', '', '1', 0x613a303a7b7d, 'views_ajax', 0x613a303a7b7d, 'ajax_deliver', 3, 2, 0, '', 'views/ajax', 'Views', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, 'Ajax callback for view loading.', '', 0, 'sites/all/modules/views/includes/ajax.inc'),
('wysiwyg/%', 0x613a313a7b693a313b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d, 'wysiwyg_dialog', 0x613a313a7b693a303b693a313b7d, 'wysiwyg_deliver_dialog_page', 2, 2, 0, '', 'wysiwyg/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.dialog.inc');

-- --------------------------------------------------------

--
-- Структура таблицы `node`
--

DROP TABLE IF EXISTS `node`;
CREATE TABLE IF NOT EXISTS `node` (
  `nid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a node.',
  `vid` int(10) unsigned DEFAULT NULL COMMENT 'The current node_revision.vid version identifier.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The node_type.type of this node.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this node.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this node, always treated as non-markup plain text.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns this node; initially, this is the user that created it.',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the node is published (visible to non-administrators).',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was most recently saved.',
  `comment` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this node: 0 = no, 1 = closed (read only), 2 = open (read/write).',
  `promote` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node should be displayed on the front page.',
  `sticky` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node should be displayed at the top of lists in which it appears.',
  `tnid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The translation set id for this node, which equals the node id of the source post in each set.',
  `translate` int(11) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this translation page needs to be updated.',
  PRIMARY KEY (`nid`),
  UNIQUE KEY `vid` (`vid`),
  KEY `node_changed` (`changed`),
  KEY `node_created` (`created`),
  KEY `node_frontpage` (`promote`,`status`,`sticky`,`created`),
  KEY `node_status_type` (`status`,`type`,`nid`),
  KEY `node_title_type` (`title`,`type`(4)),
  KEY `node_type` (`type`(4)),
  KEY `uid` (`uid`),
  KEY `tnid` (`tnid`),
  KEY `translate` (`translate`),
  KEY `language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='The base table for nodes.' AUTO_INCREMENT=5 ;

--
-- Дамп данных таблицы `node`
--

INSERT INTO `node` (`nid`, `vid`, `type`, `language`, `title`, `uid`, `status`, `created`, `changed`, `comment`, `promote`, `sticky`, `tnid`, `translate`) VALUES
(1, 1, 'services', 'und', 'Lorem ipsum1', 1, 1, 1423834668, 1423841213, 1, 0, 0, 0, 0),
(2, 2, 'services', 'und', 'Lorem ipsum2', 1, 1, 1423841281, 1423841281, 1, 0, 0, 0, 0),
(3, 3, 'services', 'und', 'Lorem ipsum3', 1, 1, 1423841334, 1423841334, 1, 0, 0, 0, 0),
(4, 4, 'home_page_gallery', 'und', 'test1', 1, 1, 1424083353, 1424439775, 2, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `node_access`
--

DROP TABLE IF EXISTS `node_access`;
CREATE TABLE IF NOT EXISTS `node_access` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid this record affects.',
  `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The grant ID a user must possess in the specified realm to gain this row’s privileges on the node.',
  `realm` varchar(255) NOT NULL DEFAULT '' COMMENT 'The realm in which the user must possess the grant ID. Each node access node can define one or more realms.',
  `grant_view` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can view this node.',
  `grant_update` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can edit this node.',
  `grant_delete` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can delete this node.',
  PRIMARY KEY (`nid`,`gid`,`realm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Identifies which realm/grant pairs a user must possess in...';

--
-- Дамп данных таблицы `node_access`
--

INSERT INTO `node_access` (`nid`, `gid`, `realm`, `grant_view`, `grant_update`, `grant_delete`) VALUES
(0, 0, 'all', 1, 0, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `node_comment_statistics`
--

DROP TABLE IF EXISTS `node_comment_statistics`;
CREATE TABLE IF NOT EXISTS `node_comment_statistics` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid for which the statistics are compiled.',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid of the last comment.',
  `last_comment_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from comment.changed.',
  `last_comment_name` varchar(60) DEFAULT NULL COMMENT 'The name of the latest author to post a comment on this node, from comment.name.',
  `last_comment_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The user ID of the latest author to post a comment on this node, from comment.uid.',
  `comment_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this node.',
  PRIMARY KEY (`nid`),
  KEY `node_comment_timestamp` (`last_comment_timestamp`),
  KEY `comment_count` (`comment_count`),
  KEY `last_comment_uid` (`last_comment_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maintains statistics of node and comments posts to show ...';

--
-- Дамп данных таблицы `node_comment_statistics`
--

INSERT INTO `node_comment_statistics` (`nid`, `cid`, `last_comment_timestamp`, `last_comment_name`, `last_comment_uid`, `comment_count`) VALUES
(1, 0, 1423834668, NULL, 1, 0),
(2, 0, 1423841281, NULL, 1, 0),
(3, 0, 1423841334, NULL, 1, 0),
(4, 0, 1424083353, NULL, 1, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `node_revision`
--

DROP TABLE IF EXISTS `node_revision`;
CREATE TABLE IF NOT EXISTS `node_revision` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node this version belongs to.',
  `vid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this version.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this version.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this version.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when this version was created.',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the node (at the time of this revision) is published (visible to non-administrators).',
  `comment` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this node (at the time of this revision): 0 = no, 1 = closed (read only), 2 = open (read/write).',
  `promote` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node (at the time of this revision) should be displayed on the front page.',
  `sticky` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node (at the time of this revision) should be displayed at the top of lists in which it appears.',
  PRIMARY KEY (`vid`),
  KEY `nid` (`nid`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores information about each saved version of a node.' AUTO_INCREMENT=5 ;

--
-- Дамп данных таблицы `node_revision`
--

INSERT INTO `node_revision` (`nid`, `vid`, `uid`, `title`, `log`, `timestamp`, `status`, `comment`, `promote`, `sticky`) VALUES
(1, 1, 1, 'Lorem ipsum1', '', 1423841213, 1, 1, 0, 0),
(2, 2, 1, 'Lorem ipsum2', '', 1423841281, 1, 1, 0, 0),
(3, 3, 1, 'Lorem ipsum3', '', 1423841334, 1, 1, 0, 0),
(4, 4, 1, 'test1', '', 1424439775, 1, 2, 0, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `node_type`
--

DROP TABLE IF EXISTS `node_type`;
CREATE TABLE IF NOT EXISTS `node_type` (
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The human-readable name of this type.',
  `base` varchar(255) NOT NULL COMMENT 'The base string used to construct callbacks corresponding to this node type.',
  `module` varchar(255) NOT NULL COMMENT 'The module defining this node type.',
  `description` mediumtext NOT NULL COMMENT 'A brief description of this type.',
  `help` mediumtext NOT NULL COMMENT 'Help information shown to the user when creating a node of this type.',
  `has_title` tinyint(3) unsigned NOT NULL COMMENT 'Boolean indicating whether this type uses the node.title field.',
  `title_label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The label displayed for the title field on the edit form.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this type is defined by a module (FALSE) or by a user via Add content type (TRUE).',
  `modified` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this type has been modified by an administrator; currently not used in any way.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether the administrator can change the machine name of this type.',
  `disabled` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether the node type is disabled.',
  `orig_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The original machine-readable name of this node type. This may be different from the current type name if the locked field is 0.',
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores information about all defined node types.';

--
-- Дамп данных таблицы `node_type`
--

INSERT INTO `node_type` (`type`, `name`, `base`, `module`, `description`, `help`, `has_title`, `title_label`, `custom`, `modified`, `locked`, `disabled`, `orig_type`) VALUES
('article', 'Article', 'node_content', 'node', 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.', '', 1, 'Title', 1, 1, 0, 0, 'article'),
('blog', 'Blog entry', 'blog', 'blog', 'Use for multi-user blogs. Every user gets a personal blog.', '', 1, 'Title', 0, 1, 1, 0, 'blog'),
('home_page_gallery', 'Home page Gallery', 'node_content', 'node', '', '', 1, 'Title', 1, 1, 0, 0, 'home_page_gallery'),
('media_gallery', 'Gallery', 'media_gallery', 'media_gallery', 'A flexible gallery of media.', 'Create a gallery of thumbnails including custom display settings.  Once your gallery is saved, your media can be added.', 1, 'Title', 0, 0, 1, 1, 'media_gallery'),
('page', 'Basic page', 'node_content', 'node', 'Use <em>basic pages</em> for your static content, such as an ''About us'' page.', '', 1, 'Title', 1, 1, 0, 0, 'page'),
('services', 'Services', 'node_content', 'node', '', '', 1, 'Title', 1, 1, 0, 0, 'services');

-- --------------------------------------------------------

--
-- Структура таблицы `page_manager_handlers`
--

DROP TABLE IF EXISTS `page_manager_handlers`;
CREATE TABLE IF NOT EXISTS `page_manager_handlers` (
  `did` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary ID field for the table. Not used for anything except internal lookups.',
  `name` varchar(255) DEFAULT NULL COMMENT 'Unique ID for this task handler. Used to identify it programmatically.',
  `task` varchar(64) DEFAULT NULL COMMENT 'ID of the task this handler is for.',
  `subtask` varchar(64) NOT NULL DEFAULT '' COMMENT 'ID of the subtask this handler is for.',
  `handler` varchar(64) DEFAULT NULL COMMENT 'ID of the task handler being used.',
  `weight` int(11) DEFAULT NULL COMMENT 'The order in which this handler appears. Lower numbers go first.',
  `conf` longtext NOT NULL COMMENT 'Serialized configuration of the handler, if needed.',
  PRIMARY KEY (`did`),
  UNIQUE KEY `name` (`name`),
  KEY `fulltask` (`task`,`subtask`,`weight`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Дамп данных таблицы `page_manager_handlers`
--

INSERT INTO `page_manager_handlers` (`did`, `name`, `task`, `subtask`, `handler`, `weight`, `conf`) VALUES
(1, 'page_quickstart_package_panel_context', 'page', 'quickstart_package', 'panel_context', 0, 'a:10:{s:5:"title";s:10:"QuickStart";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:3:"did";s:1:"1";s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:10:"quickStart";s:8:"pipeline";s:8:"standard";}'),
(2, 'page_responsive_layout_panel_context', 'page', 'responsive_layout', 'panel_context', 0, 'a:10:{s:5:"title";s:17:"Responsive Layout";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:16:"responsiveLayout";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"2";}'),
(4, 'page_typography_panel_context', 'page', 'typography', 'panel_context', 0, 'a:10:{s:5:"title";s:10:"Typography";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:10:"typography";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"4";}'),
(5, 'page_buttons_panel_context', 'page', 'buttons', 'panel_context', 0, 'a:10:{s:5:"title";s:7:"Buttons";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:7:"buttons";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"5";}'),
(6, 'page_labels_and_bages_panel_context', 'page', 'labels_and_bages', 'panel_context', 0, 'a:10:{s:5:"title";s:16:"Labels and bages";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:11:"labelsBages";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"6";}'),
(7, 'page_tabs_and_accordion_panel_context', 'page', 'tabs_and_accordion', 'panel_context', 0, 'a:10:{s:5:"title";s:18:"Tabs and accordion";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:13:"tabsAccordion";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"7";}'),
(8, 'page_notifications_panel_context', 'page', 'notifications', 'panel_context', 0, 'a:10:{s:5:"title";s:13:"Notifications";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:13:"notifications";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"8";}'),
(9, 'page_tooltips_panel_context', 'page', 'tooltips', 'panel_context', 0, 'a:10:{s:5:"title";s:8:"Tooltips";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:8:"tooltips";s:8:"pipeline";s:8:"standard";s:3:"did";s:1:"9";}'),
(10, 'page_progress_bars_panel_context', 'page', 'progress_bars', 'panel_context', 0, 'a:10:{s:5:"title";s:14:" Progress bars";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:12:"progressBars";s:8:"pipeline";s:8:"standard";s:3:"did";s:2:"10";}'),
(11, 'page_icons_panel_context', 'page', 'icons', 'panel_context', 0, 'a:10:{s:5:"title";s:5:"Icons";s:9:"no_blocks";i:1;s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:5:"icons";s:8:"pipeline";s:8:"standard";s:3:"did";s:2:"11";}'),
(12, 'page_test_test_panel_context', 'page', 'test_test', 'panel_context', 0, 'a:10:{s:5:"title";s:5:"Panel";s:9:"no_blocks";i:0;s:8:"pipeline";s:8:"standard";s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:0:"";s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:3:"did";s:2:"12";}'),
(13, 'page_lorem_panel_context', 'page', 'lorem', 'panel_context', 0, 'a:10:{s:5:"title";s:5:"Panel";s:9:"no_blocks";i:0;s:8:"pipeline";s:8:"standard";s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:0:"";s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:3:"did";s:2:"13";}'),
(14, 'page_about_panel_context', 'page', 'about', 'panel_context', 0, 'a:10:{s:5:"title";s:5:"Panel";s:9:"no_blocks";i:0;s:8:"pipeline";s:8:"standard";s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:0:"";s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:3:"did";s:2:"14";}'),
(15, 'page_forum_panel_context', 'page', 'forum', 'panel_context', 0, 'a:10:{s:5:"title";s:5:"Panel";s:9:"no_blocks";i:0;s:8:"pipeline";s:8:"standard";s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:0:"";s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:3:"did";s:2:"15";}'),
(16, 'page_about_us_panel_context', 'page', 'about_us', 'panel_context', 0, 'a:10:{s:5:"title";s:5:"Panel";s:9:"no_blocks";i:0;s:8:"pipeline";s:8:"standard";s:22:"body_classes_to_remove";s:0:"";s:19:"body_classes_to_add";s:0:"";s:6:"css_id";s:0:"";s:3:"css";s:0:"";s:8:"contexts";a:0:{}s:13:"relationships";a:0:{}s:3:"did";s:2:"16";}');

-- --------------------------------------------------------

--
-- Структура таблицы `page_manager_pages`
--

DROP TABLE IF EXISTS `page_manager_pages`;
CREATE TABLE IF NOT EXISTS `page_manager_pages` (
  `pid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary ID field for the table. Not used for anything except internal lookups.',
  `name` varchar(255) DEFAULT NULL COMMENT 'Unique ID for this subtask. Used to identify it programmatically.',
  `task` varchar(64) DEFAULT 'page' COMMENT 'What type of page this is, so that we can use the same mechanism for creating tighter UIs for targeted pages.',
  `admin_title` varchar(255) DEFAULT NULL COMMENT 'Human readable title for this page subtask.',
  `admin_description` longtext COMMENT 'Administrative description of this item.',
  `path` varchar(255) DEFAULT NULL COMMENT 'The menu path that will invoke this task.',
  `access` longtext NOT NULL COMMENT 'Access configuration for this path.',
  `menu` longtext NOT NULL COMMENT 'Serialized configuration of Drupal menu visibility settings for this item.',
  `arguments` longtext NOT NULL COMMENT 'Configuration of arguments for this menu item.',
  `conf` longtext NOT NULL COMMENT 'Serialized configuration of the page, if needed.',
  PRIMARY KEY (`pid`),
  UNIQUE KEY `name` (`name`),
  KEY `task` (`task`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains page subtasks for implementing pages with...' AUTO_INCREMENT=17 ;

--
-- Дамп данных таблицы `page_manager_pages`
--

INSERT INTO `page_manager_pages` (`pid`, `name`, `task`, `admin_title`, `admin_description`, `path`, `access`, `menu`, `arguments`, `conf`) VALUES
(1, 'quickstart_package', 'page', 'QuickStart Package', 'This pages for QuickStart Package', 'quickstart', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(2, 'responsive_layout', 'page', 'Responsive Layout', 'This pages for QuickStart Package', 'responsive', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(4, 'typography', 'page', 'Typography', 'This pages for QuickStart Package', 'typography', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(5, 'buttons', 'page', 'Buttons', 'This pages for QuickStart Package', 'buttons', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(6, 'labels_and_bages', 'page', 'Labels and bages', 'This pages for QuickStart Package', 'bages', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(7, 'tabs_and_accordion', 'page', 'Tabs and accordion', 'This pages for QuickStart Package', 'accordion', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(8, 'notifications', 'page', 'Notifications', 'This pages for QuickStart Package', 'notifications', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(9, 'tooltips', 'page', 'Tooltips', 'This pages for QuickStart Package', 'tooltips', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(10, 'progress_bars', 'page', 'Progress bars', 'This pages for QuickStart Package', 'bars', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(11, 'icons', 'page', 'Icons', 'This pages for QuickStart Package', 'icons', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(12, 'test_test', 'page', 'Test_test', 'test', 'test_test', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(13, 'lorem', 'page', 'Lorem', '', 'lorem', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(14, 'about', 'page', 'about', '', 'about', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(15, 'forum', 'page', 'Forum', '', 'forum', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}'),
(16, 'about_us', 'page', 'About us', '', 'about us', 'a:0:{}', 'a:0:{}', 'a:0:{}', 'a:1:{s:11:"admin_paths";b:0;}');

-- --------------------------------------------------------

--
-- Структура таблицы `page_manager_weights`
--

DROP TABLE IF EXISTS `page_manager_weights`;
CREATE TABLE IF NOT EXISTS `page_manager_weights` (
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Unique ID for this task handler. Used to identify it programmatically.',
  `weight` int(11) DEFAULT NULL COMMENT 'The order in which this handler appears. Lower numbers go first.',
  PRIMARY KEY (`name`),
  KEY `weights` (`name`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains override weights for page_manager handlers that...';

-- --------------------------------------------------------

--
-- Структура таблицы `panels_display`
--

DROP TABLE IF EXISTS `panels_display`;
CREATE TABLE IF NOT EXISTS `panels_display` (
  `did` int(11) NOT NULL AUTO_INCREMENT,
  `layout` varchar(255) DEFAULT '',
  `layout_settings` longtext,
  `panel_settings` longtext,
  `cache` text,
  `title` varchar(255) DEFAULT '',
  `hide_title` tinyint(4) DEFAULT '0',
  `title_pane` int(11) DEFAULT '0',
  PRIMARY KEY (`did`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Дамп данных таблицы `panels_display`
--

INSERT INTO `panels_display` (`did`, `layout`, `layout_settings`, `panel_settings`, `cache`, `title`, `hide_title`, `title_pane`) VALUES
(1, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'QuickStart Package', 0, 0),
(2, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Responsive Layout', 0, 0),
(4, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Typography', 0, 0),
(5, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Buttons', 0, 0),
(6, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Labels and bages', 0, 0),
(7, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Tabs and accordion', 0, 0),
(8, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Notifications', 0, 0),
(9, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Tooltips', 0, 0),
(10, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Progress bars', 0, 0),
(11, 'onecol', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"middle";N;}}', 'a:0:{}', 'Icons', 0, 0),
(12, 'flexible', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"center";N;}}', 'a:0:{}', '', 0, 0),
(13, 'flexible', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"center";N;}}', 'a:0:{}', '', 0, 0),
(14, 'flexible', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"center";N;}}', 'a:0:{}', '', 0, 0),
(15, 'flexible', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"center";N;}}', 'a:0:{}', '', 0, 0),
(16, 'flexible', 'a:0:{}', 'a:1:{s:14:"style_settings";a:2:{s:7:"default";N;s:6:"center";N;}}', 'a:0:{}', '', 0, 0);

-- --------------------------------------------------------

--
-- Структура таблицы `panels_layout`
--

DROP TABLE IF EXISTS `panels_layout`;
CREATE TABLE IF NOT EXISTS `panels_layout` (
  `lid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'A database primary key to ensure uniqueness.',
  `name` varchar(255) DEFAULT NULL COMMENT 'Unique ID for this content. Used to identify it programmatically.',
  `admin_title` varchar(255) DEFAULT NULL COMMENT 'Administrative title for this layout.',
  `admin_description` longtext COMMENT 'Administrative description for this layout.',
  `category` varchar(255) DEFAULT NULL COMMENT 'Administrative category for this layout.',
  `plugin` varchar(255) DEFAULT NULL COMMENT 'The layout plugin that owns this layout.',
  `settings` longtext COMMENT 'Serialized settings for the actual layout. The contents of this field are up to the plugin that uses it.',
  PRIMARY KEY (`lid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains exportable customized layouts for this site.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `panels_pane`
--

DROP TABLE IF EXISTS `panels_pane`;
CREATE TABLE IF NOT EXISTS `panels_pane` (
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `did` int(11) NOT NULL DEFAULT '0',
  `panel` varchar(32) DEFAULT '',
  `type` varchar(32) DEFAULT '',
  `subtype` varchar(64) DEFAULT '',
  `shown` tinyint(4) DEFAULT '1',
  `access` longtext,
  `configuration` longtext,
  `cache` longtext,
  `style` longtext,
  `css` longtext,
  `extras` longtext,
  `position` smallint(6) DEFAULT '0',
  `locks` longtext,
  PRIMARY KEY (`pid`),
  KEY `did_idx` (`did`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Дамп данных таблицы `panels_pane`
--

INSERT INTO `panels_pane` (`pid`, `did`, `panel`, `type`, `subtype`, `shown`, `access`, `configuration`, `cache`, `style`, `css`, `extras`, `position`, `locks`) VALUES
(1, 1, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(2, 2, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(4, 4, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(5, 5, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(6, 6, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(7, 7, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(8, 8, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(9, 9, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(10, 10, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";'),
(11, 11, 'middle', 'custom', 'custom', 1, 'a:0:{}', 'a:4:{s:5:"title";s:30:"Use this page with an argument";s:4:"body";s:120:"This demo page works if you use an argument, like <a href="ctools_plugin_example/xxxxx">ctools_plugin_example/xxxxx</a>.";s:6:"format";s:1:"1";s:10:"substitute";N;}', 'a:0:{}', 'a:1:{s:8:"settings";N;}', 'a:0:{}', 'a:0:{}', 0, 's:0:"";');

-- --------------------------------------------------------

--
-- Структура таблицы `panels_renderer_pipeline`
--

DROP TABLE IF EXISTS `panels_renderer_pipeline`;
CREATE TABLE IF NOT EXISTS `panels_renderer_pipeline` (
  `rpid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'A database primary key to ensure uniqueness.',
  `name` varchar(255) DEFAULT NULL COMMENT 'Unique ID for this content. Used to identify it programmatically.',
  `admin_title` varchar(255) DEFAULT NULL COMMENT 'Administrative title for this pipeline.',
  `admin_description` longtext COMMENT 'Administrative description for this pipeline.',
  `weight` smallint(6) DEFAULT '0',
  `settings` longtext COMMENT 'Serialized settings for the actual pipeline. The contents of this field are up to the plugin that uses it.',
  PRIMARY KEY (`rpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains renderer pipelines for Panels. Each pipeline...' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Структура таблицы `queue`
--

DROP TABLE IF EXISTS `queue`;
CREATE TABLE IF NOT EXISTS `queue` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique item ID.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The queue name.',
  `data` longblob COMMENT 'The arbitrary data for the item.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the claim lease expires on the item.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the item was created.',
  PRIMARY KEY (`item_id`),
  KEY `name_created` (`name`,`created`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores items in queues.' AUTO_INCREMENT=158 ;

--
-- Дамп данных таблицы `queue`
--

INSERT INTO `queue` (`item_id`, `name`, `data`, `expire`, `created`) VALUES
(104, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a2261646d696e5f6d656e75223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a2241646d696e697374726174696f6e206d656e75223b733a373a227061636b616765223b733a31343a2241646d696e697374726174696f6e223b733a373a2276657273696f6e223b733a31313a22372e782d332e302d726334223b733a373a2270726f6a656374223b733a31303a2261646d696e5f6d656e75223b733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232313b7d733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a383a22696e636c75646573223b613a313a7b733a31303a2261646d696e5f6d656e75223b733a31393a2241646d696e697374726174696f6e206d656e75223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(105, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a22616476616e6365645f68656c70223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31333a22416476616e6365642068656c70223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a22616476616e6365645f68656c70223b733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232313b7d733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a383a22696e636c75646573223b613a323a7b733a31333a22616476616e6365645f68656c70223b733a31333a22416476616e6365642068656c70223b733a31323a2268656c705f6578616d706c65223b733a32313a22416476616e6365642068656c70206578616d706c65223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(106, 'update_fetch_tasks', 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, 0, 1411114740),
(107, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b733a373a2276657273696f6e223b733a31313a22372e782d312e782d646576223b733a373a2270726f6a656374223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232313b7d733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a383a22696e636c75646573223b613a313a7b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(108, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2263746f6f6c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a224368616f7320746f6f6c73223b733a373a227061636b616765223b733a31363a224368616f7320746f6f6c207375697465223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a363a2263746f6f6c73223b733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431313131343639333b7d733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a383a22696e636c75646573223b613a353a7b733a363a2263746f6f6c73223b733a31313a224368616f7320746f6f6c73223b733a31383a2263746f6f6c735f616a61785f73616d706c65223b733a33333a224368616f7320546f6f6c73202843546f6f6c732920414a4158204578616d706c65223b733a32313a2263746f6f6c735f706c7567696e5f6578616d706c65223b733a33353a224368616f7320546f6f6c73202843546f6f6c732920506c7567696e204578616d706c65223b733a31323a22706167655f6d616e61676572223b733a31323a2250616765206d616e61676572223b733a31333a2276696577735f636f6e74656e74223b733a31393a22566965777320636f6e74656e742070616e6573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(109, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a226d65646961223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a2246696c6520656e74697479223b733a373a227061636b616765223b733a353a224d65646961223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a353a226d65646961223b733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431313131343639323b7d733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a383a22696e636c75646573223b613a333a7b733a31313a2266696c655f656e74697479223b733a31313a2246696c6520656e74697479223b733a353a226d65646961223b733a353a224d65646961223b733a31343a226d656469615f696e7465726e6574223b733a32323a224d6564696120496e7465726e657420536f7572636573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(110, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a22696d616765626c6f636b223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a22496d61676520426c6f636b223b733a373a2276657273696f6e223b733a373a22372e782d312e33223b733a373a2270726f6a656374223b733a31303a22696d616765626c6f636b223b733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232333b7d733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a383a22696e636c75646573223b613a313a7b733a31303a22696d616765626c6f636b223b733a31313a22496d61676520426c6f636b223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(111, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a393a226d756c7469666f726d223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a224d756c7469706c6520666f726d73223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a393a226d756c7469666f726d223b733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232333b7d733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a383a22696e636c75646573223b613a313a7b733a393a226d756c7469666f726d223b733a31343a224d756c7469706c6520666f726d73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(112, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a226e617669676174696f6e343034223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a22343034204e617669676174696f6e223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a226e617669676174696f6e343034223b733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232333b7d733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a383a22696e636c75646573223b613a313a7b733a31333a226e617669676174696f6e343034223b733a31343a22343034204e617669676174696f6e223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(113, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2270616e656c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a363a2250616e656c73223b733a373a227061636b616765223b733a363a2250616e656c73223b733a373a2276657273696f6e223b733a373a22372e782d332e33223b733a373a2270726f6a656374223b733a363a2270616e656c73223b733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373232333b7d733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a383a22696e636c75646573223b613a313a7b733a363a2270616e656c73223b733a363a2250616e656c73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(114, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a227669657773223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a353a225669657773223b733a373a227061636b616765223b733a353a225669657773223b733a373a2276657273696f6e223b733a373a22372e782d332e38223b733a373a2270726f6a656374223b733a353a227669657773223b733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431313131343639313b7d733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a383a22696e636c75646573223b613a323a7b733a353a227669657773223b733a353a225669657773223b733a383a2276696577735f7569223b733a383a225669657773205549223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(115, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a373a2277797369777967223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a373a2257797369777967223b733a373a227061636b616765223b733a31343a225573657220696e74657266616365223b733a373a2276657273696f6e223b733a373a22372e782d322e32223b733a373a2270726f6a656374223b733a373a2277797369777967223b733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313430383632373233303b7d733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a383a22696e636c75646573223b613a313a7b733a373a2277797369777967223b733a373a2257797369777967223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1411114740),
(116, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a2261646d696e5f6d656e75223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a2241646d696e697374726174696f6e206d656e75223b733a373a227061636b616765223b733a31343a2241646d696e697374726174696f6e223b733a373a2276657273696f6e223b733a31313a22372e782d332e302d726334223b733a373a2270726f6a656374223b733a31303a2261646d696e5f6d656e75223b733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831333b7d733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a383a22696e636c75646573223b613a313a7b733a31303a2261646d696e5f6d656e75223b733a31393a2241646d696e697374726174696f6e206d656e75223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(117, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a22616476616e6365645f68656c70223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31333a22416476616e6365642068656c70223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a22616476616e6365645f68656c70223b733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831343b7d733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a383a22696e636c75646573223b613a323a7b733a31333a22616476616e6365645f68656c70223b733a31333a22416476616e6365642068656c70223b733a31323a2268656c705f6578616d706c65223b733a32313a22416476616e6365642068656c70206578616d706c65223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(118, 'update_fetch_tasks', 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, 0, 1412259052),
(119, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b733a373a2276657273696f6e223b733a31313a22372e782d312e782d646576223b733a373a2270726f6a656374223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831343b7d733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a383a22696e636c75646573223b613a313a7b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(120, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2263746f6f6c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a224368616f7320746f6f6c73223b733a373a227061636b616765223b733a31363a224368616f7320746f6f6c207375697465223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a363a2263746f6f6c73223b733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831353b7d733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a383a22696e636c75646573223b613a353a7b733a363a2263746f6f6c73223b733a31313a224368616f7320746f6f6c73223b733a31383a2263746f6f6c735f616a61785f73616d706c65223b733a33333a224368616f7320546f6f6c73202843546f6f6c732920414a4158204578616d706c65223b733a32313a2263746f6f6c735f706c7567696e5f6578616d706c65223b733a33353a224368616f7320546f6f6c73202843546f6f6c732920506c7567696e204578616d706c65223b733a31323a22706167655f6d616e61676572223b733a31323a2250616765206d616e61676572223b733a31333a2276696577735f636f6e74656e74223b733a31393a22566965777320636f6e74656e742070616e6573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(121, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a226d65646961223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a2246696c6520656e74697479223b733a373a227061636b616765223b733a353a224d65646961223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a353a226d65646961223b733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831353b7d733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a383a22696e636c75646573223b613a333a7b733a31313a2266696c655f656e74697479223b733a31313a2246696c6520656e74697479223b733a353a226d65646961223b733a353a224d65646961223b733a31343a226d656469615f696e7465726e6574223b733a32323a224d6564696120496e7465726e657420536f7572636573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(122, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a22696d616765626c6f636b223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a22496d61676520426c6f636b223b733a373a2276657273696f6e223b733a373a22372e782d312e33223b733a373a2270726f6a656374223b733a31303a22696d616765626c6f636b223b733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831353b7d733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a383a22696e636c75646573223b613a313a7b733a31303a22696d616765626c6f636b223b733a31313a22496d61676520426c6f636b223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(123, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a393a226d756c7469666f726d223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a224d756c7469706c6520666f726d73223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a393a226d756c7469666f726d223b733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831353b7d733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a383a22696e636c75646573223b613a313a7b733a393a226d756c7469666f726d223b733a31343a224d756c7469706c6520666f726d73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(124, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a226e617669676174696f6e343034223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a22343034204e617669676174696f6e223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a226e617669676174696f6e343034223b733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831353b7d733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a383a22696e636c75646573223b613a313a7b733a31333a226e617669676174696f6e343034223b733a31343a22343034204e617669676174696f6e223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(125, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2270616e656c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a363a2250616e656c73223b733a373a227061636b616765223b733a363a2250616e656c73223b733a373a2276657273696f6e223b733a373a22372e782d332e33223b733a373a2270726f6a656374223b733a363a2270616e656c73223b733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831353b7d733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a383a22696e636c75646573223b613a313a7b733a363a2270616e656c73223b733a363a2250616e656c73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(126, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a227669657773223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a353a225669657773223b733a373a227061636b616765223b733a353a225669657773223b733a373a2276657273696f6e223b733a373a22372e782d332e38223b733a373a2270726f6a656374223b733a353a227669657773223b733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831363b7d733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a383a22696e636c75646573223b613a323a7b733a353a227669657773223b733a353a225669657773223b733a383a2276696577735f7569223b733a383a225669657773205549223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(127, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a373a2277797369777967223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a373a2257797369777967223b733a373a227061636b616765223b733a31343a225573657220696e74657266616365223b733a373a2276657273696f6e223b733a373a22372e782d322e32223b733a373a2270726f6a656374223b733a373a2277797369777967223b733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313431323235373831373b7d733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a383a22696e636c75646573223b613a313a7b733a373a2277797369777967223b733a373a2257797369777967223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1412259052),
(128, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a2261646d696e5f6d656e75223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a2241646d696e697374726174696f6e206d656e75223b733a373a227061636b616765223b733a31343a2241646d696e697374726174696f6e223b733a373a2276657273696f6e223b733a31313a22372e782d332e302d726334223b733a373a2270726f6a656374223b733a31303a2261646d696e5f6d656e75223b733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383036373b7d733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a383a22696e636c75646573223b613a313a7b733a31303a2261646d696e5f6d656e75223b733a31393a2241646d696e697374726174696f6e206d656e75223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578226),
(129, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a22616476616e6365645f68656c70223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31333a22416476616e6365642068656c70223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a22616476616e6365645f68656c70223b733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383036373b7d733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a383a22696e636c75646573223b613a323a7b733a31333a22616476616e6365645f68656c70223b733a31333a22416476616e6365642068656c70223b733a31323a2268656c705f6578616d706c65223b733a32313a22416476616e6365642068656c70206578616d706c65223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578226),
(130, 'update_fetch_tasks', 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, 0, 1423578226),
(131, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b733a373a2276657273696f6e223b733a31313a22372e782d312e782d646576223b733a373a2270726f6a656374223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383036373b7d733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a383a22696e636c75646573223b613a313a7b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578226),
(132, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2263746f6f6c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a224368616f7320746f6f6c73223b733a373a227061636b616765223b733a31363a224368616f7320746f6f6c207375697465223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a363a2263746f6f6c73223b733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383036393b7d733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a383a22696e636c75646573223b613a353a7b733a363a2263746f6f6c73223b733a31313a224368616f7320746f6f6c73223b733a31383a2263746f6f6c735f616a61785f73616d706c65223b733a33333a224368616f7320546f6f6c73202843546f6f6c732920414a4158204578616d706c65223b733a32313a2263746f6f6c735f706c7567696e5f6578616d706c65223b733a33353a224368616f7320546f6f6c73202843546f6f6c732920506c7567696e204578616d706c65223b733a31323a22706167655f6d616e61676572223b733a31323a2250616765206d616e61676572223b733a31333a2276696577735f636f6e74656e74223b733a31393a22566965777320636f6e74656e742070616e6573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(133, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a226d65646961223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a2246696c6520656e74697479223b733a373a227061636b616765223b733a353a224d65646961223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a353a226d65646961223b733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383037303b7d733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a383a22696e636c75646573223b613a333a7b733a31313a2266696c655f656e74697479223b733a31313a2246696c6520656e74697479223b733a353a226d65646961223b733a353a224d65646961223b733a31343a226d656469615f696e7465726e6574223b733a32323a224d6564696120496e7465726e657420536f7572636573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(134, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a22696d616765626c6f636b223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a22496d61676520426c6f636b223b733a373a2276657273696f6e223b733a373a22372e782d312e33223b733a373a2270726f6a656374223b733a31303a22696d616765626c6f636b223b733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383036393b7d733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a383a22696e636c75646573223b613a313a7b733a31303a22696d616765626c6f636b223b733a31313a22496d61676520426c6f636b223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(135, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a393a226d756c7469666f726d223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a224d756c7469706c6520666f726d73223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a393a226d756c7469666f726d223b733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383037303b7d733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a383a22696e636c75646573223b613a313a7b733a393a226d756c7469666f726d223b733a31343a224d756c7469706c6520666f726d73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(136, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a226e617669676174696f6e343034223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a22343034204e617669676174696f6e223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a226e617669676174696f6e343034223b733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383037303b7d733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a383a22696e636c75646573223b613a313a7b733a31333a226e617669676174696f6e343034223b733a31343a22343034204e617669676174696f6e223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(137, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2270616e656c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a363a2250616e656c73223b733a373a227061636b616765223b733a363a2250616e656c73223b733a373a2276657273696f6e223b733a373a22372e782d332e33223b733a373a2270726f6a656374223b733a363a2270616e656c73223b733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383037303b7d733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a383a22696e636c75646573223b613a313a7b733a363a2270616e656c73223b733a363a2250616e656c73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(138, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a227669657773223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a353a225669657773223b733a373a227061636b616765223b733a353a225669657773223b733a373a2276657273696f6e223b733a373a22372e782d332e38223b733a373a2270726f6a656374223b733a353a227669657773223b733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383037313b7d733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a383a22696e636c75646573223b613a323a7b733a353a227669657773223b733a353a225669657773223b733a383a2276696577735f7569223b733a383a225669657773205549223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(139, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a373a2277797369777967223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a373a2257797369777967223b733a373a227061636b616765223b733a31343a225573657220696e74657266616365223b733a373a2276657273696f6e223b733a373a22372e782d322e32223b733a373a2270726f6a656374223b733a373a2277797369777967223b733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432333537383037353b7d733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a383a22696e636c75646573223b613a313a7b733a373a2277797369777967223b733a373a2257797369777967223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1423578227),
(143, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a383a2266616e6379626f78223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a383a2266616e6379426f78223b733a373a227061636b616765223b733a31343a225573657220696e74657266616365223b733a373a2276657273696f6e223b733a31393a22372e782d322e302d62657461332b322d646576223b733a373a2270726f6a656374223b733a383a2266616e6379626f78223b733a393a22646174657374616d70223b733a31303a2231343139343437313833223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343235343438383b7d733a393a22646174657374616d70223b733a31303a2231343139343437313833223b733a383a22696e636c75646573223b613a313a7b733a383a2266616e6379626f78223b733a383a2266616e6379426f78223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424254604),
(144, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a226a71756572795f757064617465223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31333a226a517565727920557064617465223b733a373a227061636b616765223b733a31343a225573657220696e74657266616365223b733a373a2276657273696f6e223b733a373a22372e782d322e34223b733a373a2270726f6a656374223b733a31333a226a71756572795f757064617465223b733a393a22646174657374616d70223b733a31303a2231333936343832323436223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343235343530353b7d733a393a22646174657374616d70223b733a31303a2231333936343832323436223b733a383a22696e636c75646573223b613a313a7b733a31333a226a71756572795f757064617465223b733a31333a226a517565727920557064617465223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424254604),
(145, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a393a226c6962726172696573223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a393a224c6962726172696573223b733a373a2276657273696f6e223b733a373a22372e782d322e32223b733a373a2270726f6a656374223b733a393a226c6962726172696573223b733a393a22646174657374616d70223b733a31303a2231333931393635373136223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343235343532353b7d733a393a22646174657374616d70223b733a31303a2231333931393635373136223b733a383a22696e636c75646573223b613a313a7b733a393a226c6962726172696573223b733a393a224c6962726172696573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424254605),
(146, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a2261646d696e5f6d656e75223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a2241646d696e697374726174696f6e206d656e75223b733a373a227061636b616765223b733a31343a2241646d696e697374726174696f6e223b733a373a2276657273696f6e223b733a31313a22372e782d332e302d726334223b733a373a2270726f6a656374223b733a31303a2261646d696e5f6d656e75223b733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393039393b7d733a393a22646174657374616d70223b733a31303a2231333539363531363837223b733a383a22696e636c75646573223b613a313a7b733a31303a2261646d696e5f6d656e75223b733a31393a2241646d696e697374726174696f6e206d656e75223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439655),
(147, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a22616476616e6365645f68656c70223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31333a22416476616e6365642068656c70223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a22616476616e6365645f68656c70223b733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393039393b7d733a393a22646174657374616d70223b733a31303a2231333231303232373330223b733a383a22696e636c75646573223b613a323a7b733a31333a22616476616e6365645f68656c70223b733a31333a22416476616e6365642068656c70223b733a31323a2268656c705f6578616d706c65223b733a32313a22416476616e6365642068656c70206578616d706c65223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439655),
(148, 'update_fetch_tasks', 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, 0, 1424439656),
(149, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b733a373a2276657273696f6e223b733a31313a22372e782d312e782d646576223b733a373a2270726f6a656374223b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393039393b7d733a393a22646174657374616d70223b733a31303a2231333830353636383036223b733a383a22696e636c75646573223b613a313a7b733a31393a22636f6e746163745f666f726d5f626c6f636b73223b733a31393a22436f6e7461637420466f726d20426c6f636b73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656);
INSERT INTO `queue` (`item_id`, `name`, `data`, `expire`, `created`) VALUES
(150, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2263746f6f6c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a224368616f7320746f6f6c73223b733a373a227061636b616765223b733a31363a224368616f7320746f6f6c207375697465223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a363a2263746f6f6c73223b733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130313b7d733a393a22646174657374616d70223b733a31303a2231333932323230373330223b733a383a22696e636c75646573223b613a353a7b733a363a2263746f6f6c73223b733a31313a224368616f7320746f6f6c73223b733a31383a2263746f6f6c735f616a61785f73616d706c65223b733a33333a224368616f7320546f6f6c73202843546f6f6c732920414a4158204578616d706c65223b733a32313a2263746f6f6c735f706c7567696e5f6578616d706c65223b733a33353a224368616f7320546f6f6c73202843546f6f6c732920506c7567696e204578616d706c65223b733a31323a22706167655f6d616e61676572223b733a31323a2250616765206d616e61676572223b733a31333a2276696577735f636f6e74656e74223b733a31393a22566965777320636f6e74656e742070616e6573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(151, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a226d65646961223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a2246696c6520656e74697479223b733a373a227061636b616765223b733a353a224d65646961223b733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a353a226d65646961223b733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130323b7d733a393a22646174657374616d70223b733a31303a2231333839323139353137223b733a383a22696e636c75646573223b613a333a7b733a31313a2266696c655f656e74697479223b733a31313a2246696c6520656e74697479223b733a353a226d65646961223b733a353a224d65646961223b733a31343a226d656469615f696e7465726e6574223b733a32323a224d6564696120496e7465726e657420536f7572636573223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(152, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31303a22696d616765626c6f636b223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31313a22496d61676520426c6f636b223b733a373a2276657273696f6e223b733a373a22372e782d312e33223b733a373a2270726f6a656374223b733a31303a22696d616765626c6f636b223b733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130313b7d733a393a22646174657374616d70223b733a31303a2231333432373938363031223b733a383a22696e636c75646573223b613a313a7b733a31303a22696d616765626c6f636b223b733a31313a22496d61676520426c6f636b223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(153, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a393a226d756c7469666f726d223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a224d756c7469706c6520666f726d73223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a393a226d756c7469666f726d223b733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130323b7d733a393a22646174657374616d70223b733a31303a2231333237383233373439223b733a383a22696e636c75646573223b613a313a7b733a393a226d756c7469666f726d223b733a31343a224d756c7469706c6520666f726d73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(154, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a31333a226e617669676174696f6e343034223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a31343a22343034204e617669676174696f6e223b733a373a2276657273696f6e223b733a373a22372e782d312e30223b733a373a2270726f6a656374223b733a31333a226e617669676174696f6e343034223b733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a373a227061636b616765223b733a353a224f74686572223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130323b7d733a393a22646174657374616d70223b733a31303a2231323934343139303931223b733a383a22696e636c75646573223b613a313a7b733a31333a226e617669676174696f6e343034223b733a31343a22343034204e617669676174696f6e223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(155, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a363a2270616e656c73223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a363a2250616e656c73223b733a373a227061636b616765223b733a363a2250616e656c73223b733a373a2276657273696f6e223b733a373a22372e782d332e33223b733a373a2270726f6a656374223b733a363a2270616e656c73223b733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130323b7d733a393a22646174657374616d70223b733a31303a2231333435333139353732223b733a383a22696e636c75646573223b613a313a7b733a363a2270616e656c73223b733a363a2250616e656c73223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(156, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a353a227669657773223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a353a225669657773223b733a373a227061636b616765223b733a353a225669657773223b733a373a2276657273696f6e223b733a373a22372e782d332e38223b733a373a2270726f6a656374223b733a353a227669657773223b733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130323b7d733a393a22646174657374616d70223b733a31303a2231343030363138393238223b733a383a22696e636c75646573223b613a323a7b733a353a227669657773223b733a353a225669657773223b733a383a2276696577735f7569223b733a383a225669657773205549223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656),
(157, 'update_fetch_tasks', 0x613a383a7b733a343a226e616d65223b733a373a2277797369777967223b733a343a22696e666f223b613a363a7b733a343a226e616d65223b733a373a2257797369777967223b733a373a227061636b616765223b733a31343a225573657220696e74657266616365223b733a373a2276657273696f6e223b733a373a22372e782d322e32223b733a373a2270726f6a656374223b733a373a2277797369777967223b733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a31363a225f696e666f5f66696c655f6374696d65223b693a313432343433393130363b7d733a393a22646174657374616d70223b733a31303a2231333439323133373736223b733a383a22696e636c75646573223b613a313a7b733a373a2277797369777967223b733a373a2257797369777967223b7d733a31323a2270726f6a6563745f74797065223b733a363a226d6f64756c65223b733a31343a2270726f6a6563745f737461747573223b623a313b733a31303a227375625f7468656d6573223b613a303a7b7d733a31313a22626173655f7468656d6573223b613a303a7b7d7d, 0, 1424439656);

-- --------------------------------------------------------

--
-- Структура таблицы `rdf_mapping`
--

DROP TABLE IF EXISTS `rdf_mapping`;
CREATE TABLE IF NOT EXISTS `rdf_mapping` (
  `type` varchar(128) NOT NULL COMMENT 'The name of the entity type a mapping applies to (node, user, comment, etc.).',
  `bundle` varchar(128) NOT NULL COMMENT 'The name of the bundle a mapping applies to.',
  `mapping` longblob COMMENT 'The serialized mapping of the bundle type and fields to RDF terms.',
  PRIMARY KEY (`type`,`bundle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores custom RDF mappings for user defined content types...';

--
-- Дамп данных таблицы `rdf_mapping`
--

INSERT INTO `rdf_mapping` (`type`, `bundle`, `mapping`) VALUES
('node', 'article', 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),
('node', 'blog', 0x613a393a7b733a373a2272646674797065223b613a323a7b693a303b733a393a2273696f633a506f7374223b693a313b733a31343a2273696f63743a426c6f67506f7374223b7d733a353a227469746c65223b613a313a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a383a2264633a7469746c65223b7d7d733a373a2263726561746564223b613a333a7b733a31303a2270726564696361746573223b613a323a7b693a303b733a373a2264633a64617465223b693a313b733a31303a2264633a63726561746564223b7d733a383a226461746174797065223b733a31323a227873643a6461746554696d65223b733a383a2263616c6c6261636b223b733a31323a22646174655f69736f38363031223b7d733a373a226368616e676564223b613a333a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31313a2264633a6d6f646966696564223b7d733a383a226461746174797065223b733a31323a227873643a6461746554696d65223b733a383a2263616c6c6261636b223b733a31323a22646174655f69736f38363031223b7d733a343a22626f6479223b613a313a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31353a22636f6e74656e743a656e636f646564223b7d7d733a333a22756964223b613a323a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31363a2273696f633a6861735f63726561746f72223b7d733a343a2274797065223b733a333a2272656c223b7d733a343a226e616d65223b613a313a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a393a22666f61663a6e616d65223b7d7d733a31333a22636f6d6d656e745f636f756e74223b613a323a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31363a2273696f633a6e756d5f7265706c696573223b7d733a383a226461746174797065223b733a31313a227873643a696e7465676572223b7d733a31333a226c6173745f6163746976697479223b613a333a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a32333a2273696f633a6c6173745f61637469766974795f64617465223b7d733a383a226461746174797065223b733a31323a227873643a6461746554696d65223b733a383a2263616c6c6261636b223b733a31323a22646174655f69736f38363031223b7d7d),
('node', 'page', 0x613a393a7b733a373a2272646674797065223b613a313a7b693a303b733a31333a22666f61663a446f63756d656e74223b7d733a353a227469746c65223b613a313a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a383a2264633a7469746c65223b7d7d733a373a2263726561746564223b613a333a7b733a31303a2270726564696361746573223b613a323a7b693a303b733a373a2264633a64617465223b693a313b733a31303a2264633a63726561746564223b7d733a383a226461746174797065223b733a31323a227873643a6461746554696d65223b733a383a2263616c6c6261636b223b733a31323a22646174655f69736f38363031223b7d733a373a226368616e676564223b613a333a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31313a2264633a6d6f646966696564223b7d733a383a226461746174797065223b733a31323a227873643a6461746554696d65223b733a383a2263616c6c6261636b223b733a31323a22646174655f69736f38363031223b7d733a343a22626f6479223b613a313a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31353a22636f6e74656e743a656e636f646564223b7d7d733a333a22756964223b613a323a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31363a2273696f633a6861735f63726561746f72223b7d733a343a2274797065223b733a333a2272656c223b7d733a343a226e616d65223b613a313a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a393a22666f61663a6e616d65223b7d7d733a31333a22636f6d6d656e745f636f756e74223b613a323a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a31363a2273696f633a6e756d5f7265706c696573223b7d733a383a226461746174797065223b733a31313a227873643a696e7465676572223b7d733a31333a226c6173745f6163746976697479223b613a333a7b733a31303a2270726564696361746573223b613a313a7b693a303b733a32333a2273696f633a6c6173745f61637469766974795f64617465223b7d733a383a226461746174797065223b733a31323a227873643a6461746554696d65223b733a383a2263616c6c6261636b223b733a31323a22646174655f69736f38363031223b7d7d);

-- --------------------------------------------------------

--
-- Структура таблицы `registry`
--

DROP TABLE IF EXISTS `registry`;
CREATE TABLE IF NOT EXISTS `registry` (
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function, class, or interface.',
  `type` varchar(9) NOT NULL DEFAULT '' COMMENT 'Either function or class or interface.',
  `filename` varchar(255) NOT NULL COMMENT 'Name of the file.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the module the file belongs to.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The order in which this module’s hooks should be invoked relative to other modules. Equal-weighted modules are ordered by name.',
  PRIMARY KEY (`name`,`type`),
  KEY `hook` (`type`,`weight`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each record is a function, class, or interface name and...';

--
-- Дамп данных таблицы `registry`
--

INSERT INTO `registry` (`name`, `type`, `filename`, `module`, `weight`) VALUES
('AccessDeniedTestCase', 'class', 'modules/system/system.test', 'system', 0),
('AdminMenuCustomizedTestCase', 'class', 'sites/all/modules/admin_menu/tests/admin_menu.test', 'admin_menu', 0),
('AdminMenuDynamicLinksTestCase', 'class', 'sites/all/modules/admin_menu/tests/admin_menu.test', 'admin_menu', 0),
('AdminMenuLinkTypesTestCase', 'class', 'sites/all/modules/admin_menu/tests/admin_menu.test', 'admin_menu', 0),
('AdminMenuPermissionsTestCase', 'class', 'sites/all/modules/admin_menu/tests/admin_menu.test', 'admin_menu', 0),
('AdminMenuWebTestCase', 'class', 'sites/all/modules/admin_menu/tests/admin_menu.test', 'admin_menu', 0),
('AdminMetaTagTestCase', 'class', 'modules/system/system.test', 'system', 0),
('ArchiverInterface', 'interface', 'includes/archiver.inc', '', 0),
('ArchiverTar', 'class', 'modules/system/system.archiver.inc', 'system', 0),
('ArchiverZip', 'class', 'modules/system/system.archiver.inc', 'system', 0),
('Archive_Tar', 'class', 'modules/system/system.tar.inc', 'system', 0),
('BatchMemoryQueue', 'class', 'includes/batch.queue.inc', '', 0),
('BatchQueue', 'class', 'includes/batch.queue.inc', '', 0),
('BlockAdminThemeTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockCacheTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockHashTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockHiddenRegionTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockHTMLIdTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockInvalidRegionTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockTemplateSuggestionsUnitTest', 'class', 'modules/block/block.test', 'block', -5),
('BlockTestCase', 'class', 'modules/block/block.test', 'block', -5),
('BlockViewModuleDeltaAlterWebTest', 'class', 'modules/block/block.test', 'block', -5),
('BlogTestCase', 'class', 'modules/blog/blog.test', 'blog', 0),
('ColorTestCase', 'class', 'modules/color/color.test', 'color', 0),
('CommentActionsTestCase', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentAnonymous', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentApprovalTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentBlockFunctionalTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentContentRebuild', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentController', 'class', 'modules/comment/comment.module', 'comment', 0),
('CommentFieldsTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentHelperCase', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentInterfaceTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentNodeAccessTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentNodeChangesTestCase', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentPagerTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentPreviewTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentRSSUnitTest', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentThreadingTestCase', 'class', 'modules/comment/comment.test', 'comment', 0),
('CommentTokenReplaceTestCase', 'class', 'modules/comment/comment.test', 'comment', 0),
('ContactPersonalTestCase', 'class', 'modules/contact/contact.test', 'contact', 0),
('ContactSitewideTestCase', 'class', 'modules/contact/contact.test', 'contact', 0),
('ContextualDynamicContextTestCase', 'class', 'modules/contextual/contextual.test', 'contextual', 0),
('CronQueueTestCase', 'class', 'modules/system/system.test', 'system', 0),
('CronRunTestCase', 'class', 'modules/system/system.test', 'system', 0),
('ctools_context', 'class', 'sites/all/modules/ctools/includes/context.inc', 'ctools', 0),
('ctools_context_optional', 'class', 'sites/all/modules/ctools/includes/context.inc', 'ctools', 0),
('ctools_context_required', 'class', 'sites/all/modules/ctools/includes/context.inc', 'ctools', 0),
('ctools_export_ui', 'class', 'sites/all/modules/ctools/plugins/export_ui/ctools_export_ui.class.php', 'ctools', 0),
('ctools_math_expr', 'class', 'sites/all/modules/ctools/includes/math-expr.inc', 'ctools', 0),
('ctools_math_expr_stack', 'class', 'sites/all/modules/ctools/includes/math-expr.inc', 'ctools', 0),
('ctools_stylizer_image_processor', 'class', 'sites/all/modules/ctools/includes/stylizer.inc', 'ctools', 0),
('DashboardBlocksTestCase', 'class', 'modules/dashboard/dashboard.test', 'dashboard', 0),
('Database', 'class', 'includes/database/database.inc', '', 0),
('DatabaseCondition', 'class', 'includes/database/query.inc', '', 0),
('DatabaseConnection', 'class', 'includes/database/database.inc', '', 0),
('DatabaseConnectionNotDefinedException', 'class', 'includes/database/database.inc', '', 0),
('DatabaseConnection_mysql', 'class', 'includes/database/mysql/database.inc', '', 0),
('DatabaseConnection_pgsql', 'class', 'includes/database/pgsql/database.inc', '', 0),
('DatabaseConnection_sqlite', 'class', 'includes/database/sqlite/database.inc', '', 0),
('DatabaseDriverNotSpecifiedException', 'class', 'includes/database/database.inc', '', 0),
('DatabaseLog', 'class', 'includes/database/log.inc', '', 0),
('DatabaseSchema', 'class', 'includes/database/schema.inc', '', 0),
('DatabaseSchemaObjectDoesNotExistException', 'class', 'includes/database/schema.inc', '', 0),
('DatabaseSchemaObjectExistsException', 'class', 'includes/database/schema.inc', '', 0),
('DatabaseSchema_mysql', 'class', 'includes/database/mysql/schema.inc', '', 0),
('DatabaseSchema_pgsql', 'class', 'includes/database/pgsql/schema.inc', '', 0),
('DatabaseSchema_sqlite', 'class', 'includes/database/sqlite/schema.inc', '', 0),
('DatabaseStatementBase', 'class', 'includes/database/database.inc', '', 0),
('DatabaseStatementEmpty', 'class', 'includes/database/database.inc', '', 0),
('DatabaseStatementInterface', 'interface', 'includes/database/database.inc', '', 0),
('DatabaseStatementPrefetch', 'class', 'includes/database/prefetch.inc', '', 0),
('DatabaseStatement_sqlite', 'class', 'includes/database/sqlite/database.inc', '', 0),
('DatabaseTaskException', 'class', 'includes/install.inc', '', 0),
('DatabaseTasks', 'class', 'includes/install.inc', '', 0),
('DatabaseTasks_mysql', 'class', 'includes/database/mysql/install.inc', '', 0),
('DatabaseTasks_pgsql', 'class', 'includes/database/pgsql/install.inc', '', 0),
('DatabaseTasks_sqlite', 'class', 'includes/database/sqlite/install.inc', '', 0),
('DatabaseTransaction', 'class', 'includes/database/database.inc', '', 0),
('DatabaseTransactionCommitFailedException', 'class', 'includes/database/database.inc', '', 0),
('DatabaseTransactionExplicitCommitNotAllowedException', 'class', 'includes/database/database.inc', '', 0),
('DatabaseTransactionNameNonUniqueException', 'class', 'includes/database/database.inc', '', 0),
('DatabaseTransactionNoActiveException', 'class', 'includes/database/database.inc', '', 0),
('DatabaseTransactionOutOfOrderException', 'class', 'includes/database/database.inc', '', 0),
('DateTimeFunctionalTest', 'class', 'modules/system/system.test', 'system', 0),
('DBLogTestCase', 'class', 'modules/dblog/dblog.test', 'dblog', 0),
('DefaultMailSystem', 'class', 'modules/system/system.mail.inc', 'system', 0),
('DeleteQuery', 'class', 'includes/database/query.inc', '', 0),
('DeleteQuery_sqlite', 'class', 'includes/database/sqlite/query.inc', '', 0),
('DrupalCacheArray', 'class', 'includes/bootstrap.inc', '', 0),
('DrupalCacheInterface', 'interface', 'includes/cache.inc', '', 0),
('DrupalDatabaseCache', 'class', 'includes/cache.inc', '', 0),
('DrupalDefaultEntityController', 'class', 'includes/entity.inc', '', 0),
('DrupalEntityControllerInterface', 'interface', 'includes/entity.inc', '', 0),
('DrupalFakeCache', 'class', 'includes/cache-install.inc', '', 0),
('DrupalLocalStreamWrapper', 'class', 'includes/stream_wrappers.inc', '', 0),
('DrupalPrivateStreamWrapper', 'class', 'includes/stream_wrappers.inc', '', 0),
('DrupalPublicStreamWrapper', 'class', 'includes/stream_wrappers.inc', '', 0),
('DrupalQueue', 'class', 'modules/system/system.queue.inc', 'system', 0),
('DrupalQueueInterface', 'interface', 'modules/system/system.queue.inc', 'system', 0),
('DrupalReliableQueueInterface', 'interface', 'modules/system/system.queue.inc', 'system', 0),
('DrupalStreamWrapperInterface', 'interface', 'includes/stream_wrappers.inc', '', 0),
('DrupalTemporaryStreamWrapper', 'class', 'includes/stream_wrappers.inc', '', 0),
('DrupalUpdateException', 'class', 'includes/update.inc', '', 0),
('DrupalUpdaterInterface', 'interface', 'includes/updater.inc', '', 0),
('EnableDisableTestCase', 'class', 'modules/system/system.test', 'system', 0),
('EntityFieldQuery', 'class', 'includes/entity.inc', '', 0),
('EntityFieldQueryException', 'class', 'includes/entity.inc', '', 0),
('EntityMalformedException', 'class', 'includes/entity.inc', '', 0),
('EntityPropertiesTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldAttachOtherTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldAttachStorageTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldAttachTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldBulkDeleteTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldCrudTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldDisplayAPITestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldException', 'class', 'modules/field/field.module', 'field', 0),
('FieldFormTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldInfo', 'class', 'modules/field/field.info.class.inc', 'field', 0),
('FieldInfoTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldInstanceCrudTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldsOverlapException', 'class', 'includes/database/database.inc', '', 0),
('FieldSqlStorageTestCase', 'class', 'modules/field/modules/field_sql_storage/field_sql_storage.test', 'field_sql_storage', 0),
('FieldTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldTranslationsTestCase', 'class', 'modules/field/tests/field.test', 'field', 0),
('FieldUIAlterTestCase', 'class', 'modules/field_ui/field_ui.test', 'field_ui', 0),
('FieldUIManageDisplayTestCase', 'class', 'modules/field_ui/field_ui.test', 'field_ui', 0),
('FieldUIManageFieldsTestCase', 'class', 'modules/field_ui/field_ui.test', 'field_ui', 0),
('FieldUITestCase', 'class', 'modules/field_ui/field_ui.test', 'field_ui', 0),
('FieldUpdateForbiddenException', 'class', 'modules/field/field.module', 'field', 0),
('FieldValidationException', 'class', 'modules/field/field.attach.inc', 'field', 0),
('FileFieldDisplayTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileFieldPathTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileFieldRevisionTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileFieldTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileFieldValidateTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileFieldWidgetTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileManagedFileElementTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FilePrivateTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileTaxonomyTermTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileTokenReplaceTestCase', 'class', 'modules/file/tests/file.test', 'file', 0),
('FileTransfer', 'class', 'includes/filetransfer/filetransfer.inc', '', 0),
('FileTransferChmodInterface', 'interface', 'includes/filetransfer/filetransfer.inc', '', 0),
('FileTransferException', 'class', 'includes/filetransfer/filetransfer.inc', '', 0),
('FileTransferFTP', 'class', 'includes/filetransfer/ftp.inc', '', 0),
('FileTransferFTPExtension', 'class', 'includes/filetransfer/ftp.inc', '', 0),
('FileTransferLocal', 'class', 'includes/filetransfer/local.inc', '', 0),
('FileTransferSSH', 'class', 'includes/filetransfer/ssh.inc', '', 0),
('FilterAdminTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterCRUDTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterDefaultFormatTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterFormatAccessTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterHooksTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterNoFormatTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterSecurityTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterSettingsTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FilterUnitTestCase', 'class', 'modules/filter/filter.test', 'filter', 0),
('FloodFunctionalTest', 'class', 'modules/system/system.test', 'system', 0),
('FrontPageTestCase', 'class', 'modules/system/system.test', 'system', 0),
('HelpTestCase', 'class', 'modules/help/help.test', 'help', 0),
('HookRequirementsTestCase', 'class', 'modules/system/system.test', 'system', 0),
('ImageAdminStylesUnitTest', 'class', 'modules/image/image.test', 'image', 0),
('ImageDimensionsScaleTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageDimensionsTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageEffectsUnitTest', 'class', 'modules/image/image.test', 'image', 0),
('ImageFieldDefaultImagesTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageFieldDisplayTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageFieldTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageFieldValidateTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageStyleFlushTest', 'class', 'modules/image/image.test', 'image', 0),
('ImageStylesPathAndUrlTestCase', 'class', 'modules/image/image.test', 'image', 0),
('ImageThemeFunctionWebTestCase', 'class', 'modules/image/image.test', 'image', 0),
('InfoFileParserTestCase', 'class', 'modules/system/system.test', 'system', 0),
('InsertQuery', 'class', 'includes/database/query.inc', '', 0),
('InsertQuery_mysql', 'class', 'includes/database/mysql/query.inc', '', 0),
('InsertQuery_pgsql', 'class', 'includes/database/pgsql/query.inc', '', 0),
('InsertQuery_sqlite', 'class', 'includes/database/sqlite/query.inc', '', 0),
('InvalidMergeQueryException', 'class', 'includes/database/database.inc', '', 0),
('IPAddressBlockingTestCase', 'class', 'modules/system/system.test', 'system', 0),
('LibrariesTestCase', 'class', 'sites/all/modules/libraries/tests/libraries.test', 'libraries', 0),
('LibrariesUnitTestCase', 'class', 'sites/all/modules/libraries/tests/libraries.test', 'libraries', 0),
('ListDynamicValuesTestCase', 'class', 'modules/field/modules/list/tests/list.test', 'list', 0),
('ListDynamicValuesValidationTestCase', 'class', 'modules/field/modules/list/tests/list.test', 'list', 0),
('ListFieldTestCase', 'class', 'modules/field/modules/list/tests/list.test', 'list', 0),
('ListFieldUITestCase', 'class', 'modules/field/modules/list/tests/list.test', 'list', 0),
('MailSystemInterface', 'interface', 'includes/mail.inc', '', 0),
('MediaEntityTest', 'class', 'sites/all/modules/media/test/media.entity.test', 'media', 0),
('MediaFileUsageTest', 'class', 'sites/all/modules/media/test/media.file.usage.test', 'media', 0),
('MediaInternetBaseHandler', 'class', 'sites/all/modules/media/modules/media_internet/media_internet.module', 'media_internet', 0),
('MediaInternetFileHandler', 'class', 'sites/all/modules/media/modules/media_internet/media_internet.module', 'media_internet', 0),
('MediaInternetNoHandlerException', 'class', 'sites/all/modules/media/modules/media_internet/media_internet.module', 'media_internet', 0),
('MediaInternetValidationException', 'class', 'sites/all/modules/media/modules/media_internet/media_internet.module', 'media_internet', 0),
('MediaReadOnlyStreamWrapper', 'class', 'sites/all/modules/media/includes/MediaReadOnlyStreamWrapper.inc', 'media', 0),
('MediaTypeTest', 'class', 'sites/all/modules/media/test/media.types.test', 'media', 0),
('MemoryQueue', 'class', 'modules/system/system.queue.inc', 'system', 0),
('MenuNodeTestCase', 'class', 'modules/menu/menu.test', 'menu', 0),
('MenuTestCase', 'class', 'modules/menu/menu.test', 'menu', 0),
('MergeQuery', 'class', 'includes/database/query.inc', '', 0),
('ModuleDependencyTestCase', 'class', 'modules/system/system.test', 'system', 0),
('ModuleRequiredTestCase', 'class', 'modules/system/system.test', 'system', 0),
('ModuleTestCase', 'class', 'modules/system/system.test', 'system', 0),
('ModuleUpdater', 'class', 'modules/system/system.updater.inc', 'system', 0),
('ModuleVersionTestCase', 'class', 'modules/system/system.test', 'system', 0),
('MultiformTestCase', 'class', 'sites/all/modules/multiform/tests/multiform.test', 'multiform', 0),
('MultiStepNodeFormBasicOptionsTest', 'class', 'modules/node/node.test', 'node', 0),
('NewDefaultThemeBlocks', 'class', 'modules/block/block.test', 'block', -5),
('NodeAccessBaseTableTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeAccessFieldTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeAccessPagerTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeAccessRebuildTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeAccessRecordsTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeAccessTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeAdminTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeBlockFunctionalTest', 'class', 'modules/node/node.test', 'node', 0),
('NodeBlockTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeBuildContent', 'class', 'modules/node/node.test', 'node', 0),
('NodeController', 'class', 'modules/node/node.module', 'node', 0),
('NodeCreationTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeEntityFieldQueryAlter', 'class', 'modules/node/node.test', 'node', 0),
('NodeEntityViewModeAlterTest', 'class', 'modules/node/node.test', 'node', 0),
('NodeFeedTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeLoadHooksTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeLoadMultipleTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodePageCacheTest', 'class', 'modules/node/node.test', 'node', 0),
('NodePostSettingsTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeQueryAlter', 'class', 'modules/node/node.test', 'node', 0),
('NodeRevisionPermissionsTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeRevisionsTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeRSSContentTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeSaveTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeTitleTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeTitleXSSTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeTokenReplaceTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeTypePersistenceTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeTypeTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NodeWebTestCase', 'class', 'modules/node/node.test', 'node', 0),
('NoFieldsException', 'class', 'includes/database/database.inc', '', 0),
('NoHelpTestCase', 'class', 'modules/help/help.test', 'help', 0),
('NonDefaultBlockAdmin', 'class', 'modules/block/block.test', 'block', -5),
('NumberFieldTestCase', 'class', 'modules/field/modules/number/number.test', 'number', 0),
('OptionsSelectDynamicValuesTestCase', 'class', 'modules/field/modules/options/options.test', 'options', 0),
('OptionsWidgetsTestCase', 'class', 'modules/field/modules/options/options.test', 'options', 0),
('PageEditTestCase', 'class', 'modules/node/node.test', 'node', 0),
('PageNotFoundTestCase', 'class', 'modules/system/system.test', 'system', 0),
('PagePreviewTestCase', 'class', 'modules/node/node.test', 'node', 0),
('PagerDefault', 'class', 'includes/pager.inc', '', 0),
('PageTitleFiltering', 'class', 'modules/system/system.test', 'system', 0),
('PageViewTestCase', 'class', 'modules/node/node.test', 'node', 0),
('PanelsLegacyState', 'class', 'sites/all/modules/panels/includes/legacy.inc', 'panels', 0),
('panels_allowed_layouts', 'class', 'sites/all/modules/panels/includes/common.inc', 'panels', 0),
('panels_cache_object', 'class', 'sites/all/modules/panels/includes/plugins.inc', 'panels', 0),
('panels_display', 'class', 'sites/all/modules/panels/panels.module', 'panels', 0),
('panels_layouts_ui', 'class', 'sites/all/modules/panels/plugins/export_ui/panels_layouts_ui.class.php', 'panels', 0),
('panels_renderer_editor', 'class', 'sites/all/modules/panels/plugins/display_renderers/panels_renderer_editor.class.php', 'panels', 0),
('panels_renderer_simple', 'class', 'sites/all/modules/panels/plugins/display_renderers/panels_renderer_simple.class.php', 'panels', 0),
('panels_renderer_standard', 'class', 'sites/all/modules/panels/plugins/display_renderers/panels_renderer_standard.class.php', 'panels', 0),
('panels_views_plugin_row_fields', 'class', 'sites/all/modules/panels/plugins/views/panels_views_plugin_row_fields.inc', 'panels', 0),
('PathLanguageTestCase', 'class', 'modules/path/path.test', 'path', 0),
('PathLanguageUITestCase', 'class', 'modules/path/path.test', 'path', 0),
('PathMonolingualTestCase', 'class', 'modules/path/path.test', 'path', 0),
('PathTaxonomyTermTestCase', 'class', 'modules/path/path.test', 'path', 0),
('PathTestCase', 'class', 'modules/path/path.test', 'path', 0),
('Query', 'class', 'includes/database/query.inc', '', 0),
('QueryAlterableInterface', 'interface', 'includes/database/query.inc', '', 0),
('QueryConditionInterface', 'interface', 'includes/database/query.inc', '', 0),
('QueryExtendableInterface', 'interface', 'includes/database/select.inc', '', 0),
('QueryPlaceholderInterface', 'interface', 'includes/database/query.inc', '', 0),
('QueueTestCase', 'class', 'modules/system/system.test', 'system', 0),
('RdfCommentAttributesTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RdfCrudTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RdfGetRdfNamespacesTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RdfMappingDefinitionTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RdfMappingHookTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RdfRdfaMarkupTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RdfTrackerAttributesTestCase', 'class', 'modules/rdf/rdf.test', 'rdf', 0),
('RetrieveFileTestCase', 'class', 'modules/system/system.test', 'system', 0),
('SchemaCache', 'class', 'includes/bootstrap.inc', '', 0),
('SearchAdvancedSearchForm', 'class', 'modules/search/search.test', 'search', 0),
('SearchBlockTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchCommentCountToggleTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchCommentTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchConfigSettingsForm', 'class', 'modules/search/search.test', 'search', 0),
('SearchEmbedForm', 'class', 'modules/search/search.test', 'search', 0),
('SearchExactTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchExcerptTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchExpressionInsertExtractTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchKeywordsConditions', 'class', 'modules/search/search.test', 'search', 0),
('SearchLanguageTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchMatchTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchNodeAccessTest', 'class', 'modules/search/search.test', 'search', 0),
('SearchNumberMatchingTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchNumbersTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchPageOverride', 'class', 'modules/search/search.test', 'search', 0),
('SearchPageText', 'class', 'modules/search/search.test', 'search', 0),
('SearchQuery', 'class', 'modules/search/search.extender.inc', 'search', 0),
('SearchRankingTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchSetLocaleTest', 'class', 'modules/search/search.test', 'search', 0),
('SearchSimplifyTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SearchTokenizerTestCase', 'class', 'modules/search/search.test', 'search', 0),
('SelectQuery', 'class', 'includes/database/select.inc', '', 0),
('SelectQueryExtender', 'class', 'includes/database/select.inc', '', 0),
('SelectQueryInterface', 'interface', 'includes/database/select.inc', '', 0),
('SelectQuery_pgsql', 'class', 'includes/database/pgsql/select.inc', '', 0),
('SelectQuery_sqlite', 'class', 'includes/database/sqlite/select.inc', '', 0),
('ShortcutLinksTestCase', 'class', 'modules/shortcut/shortcut.test', 'shortcut', 0),
('ShortcutSetsTestCase', 'class', 'modules/shortcut/shortcut.test', 'shortcut', 0),
('ShortcutTestCase', 'class', 'modules/shortcut/shortcut.test', 'shortcut', 0),
('ShutdownFunctionsTest', 'class', 'modules/system/system.test', 'system', 0),
('SiteMaintenanceTestCase', 'class', 'modules/system/system.test', 'system', 0),
('SkipDotsRecursiveDirectoryIterator', 'class', 'includes/filetransfer/filetransfer.inc', '', 0),
('StreamWrapperInterface', 'interface', 'includes/stream_wrappers.inc', '', 0),
('SummaryLengthTestCase', 'class', 'modules/node/node.test', 'node', 0),
('SystemAdminTestCase', 'class', 'modules/system/system.test', 'system', 0),
('SystemAuthorizeCase', 'class', 'modules/system/system.test', 'system', 0),
('SystemBlockTestCase', 'class', 'modules/system/system.test', 'system', 0),
('SystemIndexPhpTest', 'class', 'modules/system/system.test', 'system', 0),
('SystemInfoAlterTestCase', 'class', 'modules/system/system.test', 'system', 0),
('SystemMainContentFallback', 'class', 'modules/system/system.test', 'system', 0),
('SystemQueue', 'class', 'modules/system/system.queue.inc', 'system', 0),
('SystemThemeFunctionalTest', 'class', 'modules/system/system.test', 'system', 0),
('SystemValidTokenTest', 'class', 'modules/system/system.test', 'system', 0),
('TableSort', 'class', 'includes/tablesort.inc', '', 0),
('TaxonomyEFQTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyHooksTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyLegacyTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyLoadMultipleTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyRSSTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyTermController', 'class', 'modules/taxonomy/taxonomy.module', 'taxonomy', 0),
('TaxonomyTermFieldMultipleVocabularyTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyTermFieldTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyTermFunctionTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyTermIndexTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyTermTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyThemeTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyTokenReplaceTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyVocabularyController', 'class', 'modules/taxonomy/taxonomy.module', 'taxonomy', 0),
('TaxonomyVocabularyFunctionalTest', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyVocabularyTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TaxonomyWebTestCase', 'class', 'modules/taxonomy/taxonomy.test', 'taxonomy', 0),
('TestingMailSystem', 'class', 'modules/system/system.mail.inc', 'system', 0),
('TextFieldTestCase', 'class', 'modules/field/modules/text/text.test', 'text', 0),
('TextSummaryTestCase', 'class', 'modules/field/modules/text/text.test', 'text', 0),
('TextTranslationTestCase', 'class', 'modules/field/modules/text/text.test', 'text', 0),
('ThemeRegistry', 'class', 'includes/theme.inc', '', 0),
('ThemeUpdater', 'class', 'modules/system/system.updater.inc', 'system', 0),
('TokenReplaceTestCase', 'class', 'modules/system/system.test', 'system', 0),
('TokenScanTest', 'class', 'modules/system/system.test', 'system', 0),
('TriggerActionTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerContentTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerCronTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerOrphanedActionsTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerOtherTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerUnassignTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerUserActionTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerUserTokenTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TriggerWebTestCase', 'class', 'modules/trigger/trigger.test', 'trigger', 0),
('TruncateQuery', 'class', 'includes/database/query.inc', '', 0),
('TruncateQuery_mysql', 'class', 'includes/database/mysql/query.inc', '', 0),
('TruncateQuery_sqlite', 'class', 'includes/database/sqlite/query.inc', '', 0),
('UpdateCoreTestCase', 'class', 'modules/update/update.test', 'update', 0),
('UpdateCoreUnitTestCase', 'class', 'modules/update/update.test', 'update', 0),
('UpdateQuery', 'class', 'includes/database/query.inc', '', 0),
('UpdateQuery_pgsql', 'class', 'includes/database/pgsql/query.inc', '', 0),
('UpdateQuery_sqlite', 'class', 'includes/database/sqlite/query.inc', '', 0),
('Updater', 'class', 'includes/updater.inc', '', 0),
('UpdaterException', 'class', 'includes/updater.inc', '', 0),
('UpdaterFileTransferException', 'class', 'includes/updater.inc', '', 0),
('UpdateScriptFunctionalTest', 'class', 'modules/system/system.test', 'system', 0),
('UpdateTestContribCase', 'class', 'modules/update/update.test', 'update', 0),
('UpdateTestHelper', 'class', 'modules/update/update.test', 'update', 0),
('UpdateTestUploadCase', 'class', 'modules/update/update.test', 'update', 0),
('UserAccountLinksUnitTests', 'class', 'modules/user/user.test', 'user', 0),
('UserAdminTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserAuthmapAssignmentTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserAutocompleteTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserBlocksUnitTests', 'class', 'modules/user/user.test', 'user', 0),
('UserCancelTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserController', 'class', 'modules/user/user.module', 'user', 0),
('UserCreateTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserEditedOwnAccountTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserEditTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserLoginTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserPasswordResetTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserPermissionsTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserPictureTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserRegistrationTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserRoleAdminTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserRolesAssignmentTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserSaveTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserSignatureTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserTimeZoneFunctionalTest', 'class', 'modules/user/user.test', 'user', 0),
('UserTokenReplaceTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserUserSearchTestCase', 'class', 'modules/user/user.test', 'user', 0),
('UserValidateCurrentPassCustomForm', 'class', 'modules/user/user.test', 'user', 0),
('UserValidationTestCase', 'class', 'modules/user/user.test', 'user', 0),
('view', 'class', 'sites/all/modules/views/includes/view.inc', 'views', 10),
('ViewsAccessTest', 'class', 'sites/all/modules/views/tests/views_access.test', 'views', 0),
('ViewsAnalyzeTest', 'class', 'sites/all/modules/views/tests/views_analyze.test', 'views', 0),
('ViewsArgumentDefaultTest', 'class', 'sites/all/modules/views/tests/views_argument_default.test', 'views', 0),
('ViewsArgumentValidatorTest', 'class', 'sites/all/modules/views/tests/views_argument_validator.test', 'views', 0),
('ViewsBasicTest', 'class', 'sites/all/modules/views/tests/views_basic.test', 'views', 0),
('ViewsCacheTest', 'class', 'sites/all/modules/views/tests/views_cache.test', 'views', 10),
('ViewsExposedFormTest', 'class', 'sites/all/modules/views/tests/views_exposed_form.test', 'views', 0),
('viewsFieldApiDataTest', 'class', 'sites/all/modules/views/tests/field/views_fieldapi.test', 'views', 0),
('ViewsFieldApiTestHelper', 'class', 'sites/all/modules/views/tests/field/views_fieldapi.test', 'views', 0),
('ViewsGlossaryTestCase', 'class', 'sites/all/modules/views/tests/views_glossary.test', 'views', 0),
('ViewsHandlerAreaTextTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_area_text.test', 'views', 0),
('viewsHandlerArgumentCommentUserUidTest', 'class', 'sites/all/modules/views/tests/comment/views_handler_argument_comment_user_uid.test', 'views', 0),
('ViewsHandlerArgumentNullTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_argument_null.test', 'views', 0),
('ViewsHandlerArgumentStringTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_argument_string.test', 'views', 0),
('ViewsHandlerFieldBooleanTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_boolean.test', 'views', 0),
('ViewsHandlerFieldCustomTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_custom.test', 'views', 0),
('ViewsHandlerFieldDateTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_date.test', 'views', 10),
('viewsHandlerFieldFieldTest', 'class', 'sites/all/modules/views/tests/field/views_fieldapi.test', 'views', 0),
('ViewsHandlerFieldMath', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_math.test', 'views', 0),
('ViewsHandlerFieldTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field.test', 'views', 0),
('ViewsHandlerFieldUrlTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_url.test', 'views', 0),
('viewsHandlerFieldUserNameTest', 'class', 'sites/all/modules/views/tests/user/views_handler_field_user_name.test', 'views', 0),
('ViewsHandlerFileExtensionTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_file_extension.test', 'views', 10),
('ViewsHandlerFilterCombineTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_filter_combine.test', 'views', 0),
('viewsHandlerFilterCommentUserUidTest', 'class', 'sites/all/modules/views/tests/comment/views_handler_filter_comment_user_uid.test', 'views', 0),
('ViewsHandlerFilterCounterTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_counter.test', 'views', 0),
('ViewsHandlerFilterDateTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_filter_date.test', 'views', 0),
('ViewsHandlerFilterEqualityTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_filter_equality.test', 'views', 0),
('ViewsHandlerFilterInOperator', 'class', 'sites/all/modules/views/tests/handlers/views_handler_filter_in_operator.test', 'views', 0),
('ViewsHandlerFilterNumericTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_filter_numeric.test', 'views', 0),
('ViewsHandlerFilterStringTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_filter_string.test', 'views', 0),
('ViewsHandlerRelationshipNodeTermDataTest', 'class', 'sites/all/modules/views/tests/taxonomy/views_handler_relationship_node_term_data.test', 'views', 0),
('ViewsHandlerSortDateTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_sort_date.test', 'views', 0),
('ViewsHandlerSortRandomTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_sort_random.test', 'views', 0),
('ViewsHandlerSortTest', 'class', 'sites/all/modules/views/tests/handlers/views_handler_sort.test', 'views', 0),
('ViewsHandlersTest', 'class', 'sites/all/modules/views/tests/views_handlers.test', 'views', 0),
('ViewsHandlerTest', 'class', 'sites/all/modules/views/tests/handlers/views_handlers.test', 'views', 10),
('ViewsHandlerTestFileSize', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_file_size.test', 'views', 0),
('ViewsHandlerTestXss', 'class', 'sites/all/modules/views/tests/handlers/views_handler_field_xss.test', 'views', 0),
('ViewsModuleTest', 'class', 'sites/all/modules/views/tests/views_module.test', 'views', 10),
('ViewsNodeRevisionRelationsTestCase', 'class', 'sites/all/modules/views/tests/node/views_node_revision_relations.test', 'views', 0),
('ViewsPagerTest', 'class', 'sites/all/modules/views/tests/views_pager.test', 'views', 0),
('ViewsPluginDisplayTestCase', 'class', 'sites/all/modules/views/tests/plugins/views_plugin_display.test', 'views', 0),
('viewsPluginStyleJumpMenuTest', 'class', 'sites/all/modules/views/tests/styles/views_plugin_style_jump_menu.test', 'views', 0),
('ViewsPluginStyleMappingTest', 'class', 'sites/all/modules/views/tests/styles/views_plugin_style_mapping.test', 'views', 0),
('ViewsPluginStyleTestBase', 'class', 'sites/all/modules/views/tests/styles/views_plugin_style_base.test', 'views', 0),
('ViewsPluginStyleTestCase', 'class', 'sites/all/modules/views/tests/styles/views_plugin_style.test', 'views', 0),
('ViewsPluginStyleUnformattedTestCase', 'class', 'sites/all/modules/views/tests/styles/views_plugin_style_unformatted.test', 'views', 0),
('ViewsQueryGroupByTest', 'class', 'sites/all/modules/views/tests/views_groupby.test', 'views', 0),
('viewsSearchQuery', 'class', 'sites/all/modules/views/modules/search/views_handler_filter_search.inc', 'views', 0),
('ViewsSqlTest', 'class', 'sites/all/modules/views/tests/views_query.test', 'views', 0),
('ViewsTestCase', 'class', 'sites/all/modules/views/tests/views_query.test', 'views', 0),
('ViewsTranslatableTest', 'class', 'sites/all/modules/views/tests/views_translatable.test', 'views', 0),
('ViewsUiBaseViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_base_views_wizard.class.php', 'views_ui', 0),
('ViewsUiCommentViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_comment_views_wizard.class.php', 'views_ui', 0),
('ViewsUiFileManagedViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_file_managed_views_wizard.class.php', 'views_ui', 0),
('viewsUiGroupbyTestCase', 'class', 'sites/all/modules/views/tests/views_groupby.test', 'views', 0),
('ViewsUiNodeRevisionViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_node_revision_views_wizard.class.php', 'views_ui', 0),
('ViewsUiNodeViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_node_views_wizard.class.php', 'views_ui', 0),
('ViewsUiTaxonomyTermViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_taxonomy_term_views_wizard.class.php', 'views_ui', 0),
('ViewsUiUsersViewsWizard', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_users_views_wizard.class.php', 'views_ui', 0),
('ViewsUIWizardBasicTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardDefaultViewsTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardHelper', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardItemsPerPageTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardJumpMenuTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardMenuTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardOverrideDisplaysTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardSortingTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUIWizardTaggedWithTestCase', 'class', 'sites/all/modules/views/tests/views_ui.test', 'views', 0),
('ViewsUpgradeTestCase', 'class', 'sites/all/modules/views/tests/views_upgrade.test', 'views', 0),
('ViewsUserArgumentDefault', 'class', 'sites/all/modules/views/tests/user/views_user_argument_default.test', 'views', 0),
('ViewsUserArgumentValidate', 'class', 'sites/all/modules/views/tests/user/views_user_argument_validate.test', 'views', 0),
('ViewsUserTestCase', 'class', 'sites/all/modules/views/tests/user/views_user.test', 'views', 0),
('ViewsViewTest', 'class', 'sites/all/modules/views/tests/views_view.test', 'views', 0),
('ViewsWizardException', 'class', 'sites/all/modules/views/plugins/views_wizard/views_ui_base_views_wizard.class.php', 'views_ui', 0),
('ViewsWizardInterface', 'interface', 'sites/all/modules/views/plugins/views_wizard/views_ui_base_views_wizard.class.php', 'views_ui', 0),
('views_content_plugin_display_ctools_context', 'class', 'sites/all/modules/ctools/views_content/plugins/views/views_content_plugin_display_ctools_context.inc', 'views_content', 0),
('views_content_plugin_display_panel_pane', 'class', 'sites/all/modules/ctools/views_content/plugins/views/views_content_plugin_display_panel_pane.inc', 'views_content', 0),
('views_content_plugin_style_ctools_context', 'class', 'sites/all/modules/ctools/views_content/plugins/views/views_content_plugin_style_ctools_context.inc', 'views_content', 0),
('views_db_object', 'class', 'sites/all/modules/views/includes/view.inc', 'views', 10),
('views_display', 'class', 'sites/all/modules/views/includes/view.inc', 'views', 10),
('views_handler', 'class', 'sites/all/modules/views/includes/handlers.inc', 'views', 10),
('views_handler_area', 'class', 'sites/all/modules/views/handlers/views_handler_area.inc', 'views', 0),
('views_handler_area_broken', 'class', 'sites/all/modules/views/handlers/views_handler_area.inc', 'views', 0),
('views_handler_area_messages', 'class', 'sites/all/modules/views/handlers/views_handler_area_messages.inc', 'views', 10),
('views_handler_area_result', 'class', 'sites/all/modules/views/handlers/views_handler_area_result.inc', 'views', 0),
('views_handler_area_text', 'class', 'sites/all/modules/views/handlers/views_handler_area_text.inc', 'views', 0),
('views_handler_area_text_custom', 'class', 'sites/all/modules/views/handlers/views_handler_area_text_custom.inc', 'views', 0),
('views_handler_area_view', 'class', 'sites/all/modules/views/handlers/views_handler_area_view.inc', 'views', 0),
('views_handler_argument', 'class', 'sites/all/modules/views/handlers/views_handler_argument.inc', 'views', 0),
('views_handler_argument_aggregator_category_cid', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_category_cid.inc', 'views', 0),
('views_handler_argument_aggregator_fid', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_fid.inc', 'views', 0),
('views_handler_argument_aggregator_iid', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_iid.inc', 'views', 0),
('views_handler_argument_broken', 'class', 'sites/all/modules/views/handlers/views_handler_argument.inc', 'views', 0),
('views_handler_argument_comment_user_uid', 'class', 'sites/all/modules/views/modules/comment/views_handler_argument_comment_user_uid.inc', 'views', 0),
('views_handler_argument_date', 'class', 'sites/all/modules/views/handlers/views_handler_argument_date.inc', 'views', 0),
('views_handler_argument_field_list', 'class', 'sites/all/modules/views/modules/field/views_handler_argument_field_list.inc', 'views', 0),
('views_handler_argument_field_list_string', 'class', 'sites/all/modules/views/modules/field/views_handler_argument_field_list_string.inc', 'views', 0),
('views_handler_argument_file_fid', 'class', 'sites/all/modules/views/modules/system/views_handler_argument_file_fid.inc', 'views', 0),
('views_handler_argument_formula', 'class', 'sites/all/modules/views/handlers/views_handler_argument_formula.inc', 'views', 0),
('views_handler_argument_group_by_numeric', 'class', 'sites/all/modules/views/handlers/views_handler_argument_group_by_numeric.inc', 'views', 0),
('views_handler_argument_locale_group', 'class', 'sites/all/modules/views/modules/locale/views_handler_argument_locale_group.inc', 'views', 0),
('views_handler_argument_locale_language', 'class', 'sites/all/modules/views/modules/locale/views_handler_argument_locale_language.inc', 'views', 0),
('views_handler_argument_many_to_one', 'class', 'sites/all/modules/views/handlers/views_handler_argument_many_to_one.inc', 'views', 0),
('views_handler_argument_node_created_day', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc', 'views', 0),
('views_handler_argument_node_created_fulldate', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc', 'views', 0),
('views_handler_argument_node_created_month', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc', 'views', 0),
('views_handler_argument_node_created_week', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc', 'views', 0),
('views_handler_argument_node_created_year', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc', 'views', 0),
('views_handler_argument_node_created_year_month', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc', 'views', 0),
('views_handler_argument_node_language', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_node_language.inc', 'views', 0),
('views_handler_argument_node_nid', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_node_nid.inc', 'views', 0),
('views_handler_argument_node_tnid', 'class', 'sites/all/modules/views/modules/translation/views_handler_argument_node_tnid.inc', 'views', 0),
('views_handler_argument_node_type', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_node_type.inc', 'views', 0),
('views_handler_argument_node_uid_revision', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_node_uid_revision.inc', 'views', 0),
('views_handler_argument_node_vid', 'class', 'sites/all/modules/views/modules/node/views_handler_argument_node_vid.inc', 'views', 0),
('views_handler_argument_null', 'class', 'sites/all/modules/views/handlers/views_handler_argument_null.inc', 'views', 0),
('views_handler_argument_numeric', 'class', 'sites/all/modules/views/handlers/views_handler_argument_numeric.inc', 'views', 0),
('views_handler_argument_search', 'class', 'sites/all/modules/views/modules/search/views_handler_argument_search.inc', 'views', 0),
('views_handler_argument_string', 'class', 'sites/all/modules/views/handlers/views_handler_argument_string.inc', 'views', 0),
('views_handler_argument_taxonomy', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_argument_taxonomy.inc', 'views', 0),
('views_handler_argument_term_node_tid', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid.inc', 'views', 0),
('views_handler_argument_term_node_tid_depth', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth.inc', 'views', 0),
('views_handler_argument_term_node_tid_depth_modifier', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth_modifier.inc', 'views', 0),
('views_handler_argument_tracker_comment_user_uid', 'class', 'sites/all/modules/views/modules/tracker/views_handler_argument_tracker_comment_user_uid.inc', 'views', 0),
('views_handler_argument_users_roles_rid', 'class', 'sites/all/modules/views/modules/user/views_handler_argument_users_roles_rid.inc', 'views', 0),
('views_handler_argument_user_uid', 'class', 'sites/all/modules/views/modules/user/views_handler_argument_user_uid.inc', 'views', 0),
('views_handler_argument_vocabulary_machine_name', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_argument_vocabulary_machine_name.inc', 'views', 0),
('views_handler_argument_vocabulary_vid', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_argument_vocabulary_vid.inc', 'views', 0),
('views_handler_field', 'class', 'sites/all/modules/views/handlers/views_handler_field.inc', 'views', 0),
('views_handler_field_accesslog_path', 'class', 'sites/all/modules/views/modules/statistics/views_handler_field_accesslog_path.inc', 'views', 0),
('views_handler_field_aggregator_category', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_category.inc', 'views', 0),
('views_handler_field_aggregator_title_link', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_title_link.inc', 'views', 0),
('views_handler_field_aggregator_xss', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_xss.inc', 'views', 0),
('views_handler_field_boolean', 'class', 'sites/all/modules/views/handlers/views_handler_field_boolean.inc', 'views', 0),
('views_handler_field_broken', 'class', 'sites/all/modules/views/handlers/views_handler_field.inc', 'views', 0),
('views_handler_field_comment', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment.inc', 'views', 0),
('views_handler_field_comment_depth', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_depth.inc', 'views', 0),
('views_handler_field_comment_link', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_link.inc', 'views', 0),
('views_handler_field_comment_link_approve', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_approve.inc', 'views', 0),
('views_handler_field_comment_link_delete', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_delete.inc', 'views', 0),
('views_handler_field_comment_link_edit', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_edit.inc', 'views', 0),
('views_handler_field_comment_link_reply', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_reply.inc', 'views', 0),
('views_handler_field_comment_node_link', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_node_link.inc', 'views', 0),
('views_handler_field_comment_username', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_comment_username.inc', 'views', 0),
('views_handler_field_contact_link', 'class', 'sites/all/modules/views/modules/contact/views_handler_field_contact_link.inc', 'views', 0);
INSERT INTO `registry` (`name`, `type`, `filename`, `module`, `weight`) VALUES
('views_handler_field_contextual_links', 'class', 'sites/all/modules/views/handlers/views_handler_field_contextual_links.inc', 'views', 0),
('views_handler_field_counter', 'class', 'sites/all/modules/views/handlers/views_handler_field_counter.inc', 'views', 0),
('views_handler_field_custom', 'class', 'sites/all/modules/views/handlers/views_handler_field_custom.inc', 'views', 0),
('views_handler_field_date', 'class', 'sites/all/modules/views/handlers/views_handler_field_date.inc', 'views', 10),
('views_handler_field_entity', 'class', 'sites/all/modules/views/handlers/views_handler_field_entity.inc', 'views', 0),
('views_handler_field_field', 'class', 'sites/all/modules/views/modules/field/views_handler_field_field.inc', 'views', 10),
('views_handler_field_file', 'class', 'sites/all/modules/views/modules/system/views_handler_field_file.inc', 'views', 0),
('views_handler_field_file_extension', 'class', 'sites/all/modules/views/modules/system/views_handler_field_file_extension.inc', 'views', 10),
('views_handler_field_file_filemime', 'class', 'sites/all/modules/views/modules/system/views_handler_field_file_filemime.inc', 'views', 0),
('views_handler_field_file_size', 'class', 'sites/all/modules/views/handlers/views_handler_field.inc', 'views', 0),
('views_handler_field_file_status', 'class', 'sites/all/modules/views/modules/system/views_handler_field_file_status.inc', 'views', 0),
('views_handler_field_file_uri', 'class', 'sites/all/modules/views/modules/system/views_handler_field_file_uri.inc', 'views', 0),
('views_handler_field_filter_format_name', 'class', 'sites/all/modules/views/modules/filter/views_handler_field_filter_format_name.inc', 'views', 0),
('views_handler_field_history_user_timestamp', 'class', 'sites/all/modules/views/modules/node/views_handler_field_history_user_timestamp.inc', 'views', 0),
('views_handler_field_last_comment_timestamp', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_last_comment_timestamp.inc', 'views', 0),
('views_handler_field_locale_group', 'class', 'sites/all/modules/views/modules/locale/views_handler_field_locale_group.inc', 'views', 0),
('views_handler_field_locale_language', 'class', 'sites/all/modules/views/modules/locale/views_handler_field_locale_language.inc', 'views', 0),
('views_handler_field_locale_link_edit', 'class', 'sites/all/modules/views/modules/locale/views_handler_field_locale_link_edit.inc', 'views', 0),
('views_handler_field_machine_name', 'class', 'sites/all/modules/views/handlers/views_handler_field_machine_name.inc', 'views', 0),
('views_handler_field_markup', 'class', 'sites/all/modules/views/handlers/views_handler_field_markup.inc', 'views', 0),
('views_handler_field_math', 'class', 'sites/all/modules/views/handlers/views_handler_field_math.inc', 'views', 0),
('views_handler_field_ncs_last_comment_name', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_ncs_last_comment_name.inc', 'views', 0),
('views_handler_field_ncs_last_updated', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_ncs_last_updated.inc', 'views', 0),
('views_handler_field_node', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node.inc', 'views', 0),
('views_handler_field_node_comment', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_node_comment.inc', 'views', 0),
('views_handler_field_node_language', 'class', 'sites/all/modules/views/modules/locale/views_handler_field_node_language.inc', 'views', 0),
('views_handler_field_node_link', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_link.inc', 'views', 0),
('views_handler_field_node_link_delete', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_link_delete.inc', 'views', 0),
('views_handler_field_node_link_edit', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_link_edit.inc', 'views', 0),
('views_handler_field_node_link_translate', 'class', 'sites/all/modules/views/modules/translation/views_handler_field_node_link_translate.inc', 'views', 0),
('views_handler_field_node_new_comments', 'class', 'sites/all/modules/views/modules/comment/views_handler_field_node_new_comments.inc', 'views', 0),
('views_handler_field_node_path', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_path.inc', 'views', 0),
('views_handler_field_node_revision', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_revision.inc', 'views', 0),
('views_handler_field_node_revision_link', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link.inc', 'views', 0),
('views_handler_field_node_revision_link_delete', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link_delete.inc', 'views', 0),
('views_handler_field_node_revision_link_revert', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link_revert.inc', 'views', 0),
('views_handler_field_node_translation_link', 'class', 'sites/all/modules/views/modules/translation/views_handler_field_node_translation_link.inc', 'views', 0),
('views_handler_field_node_type', 'class', 'sites/all/modules/views/modules/node/views_handler_field_node_type.inc', 'views', 0),
('views_handler_field_numeric', 'class', 'sites/all/modules/views/handlers/views_handler_field_numeric.inc', 'views', 0),
('views_handler_field_prerender_list', 'class', 'sites/all/modules/views/handlers/views_handler_field_prerender_list.inc', 'views', 0),
('views_handler_field_profile_date', 'class', 'sites/all/modules/views/modules/profile/views_handler_field_profile_date.inc', 'views', 10),
('views_handler_field_profile_list', 'class', 'sites/all/modules/views/modules/profile/views_handler_field_profile_list.inc', 'views', 0),
('views_handler_field_search_score', 'class', 'sites/all/modules/views/modules/search/views_handler_field_search_score.inc', 'views', 0),
('views_handler_field_serialized', 'class', 'sites/all/modules/views/handlers/views_handler_field_serialized.inc', 'views', 0),
('views_handler_field_taxonomy', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_field_taxonomy.inc', 'views', 0),
('views_handler_field_term_link_edit', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_field_term_link_edit.inc', 'views', 0),
('views_handler_field_term_node_tid', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_field_term_node_tid.inc', 'views', 0),
('views_handler_field_time_interval', 'class', 'sites/all/modules/views/handlers/views_handler_field_time_interval.inc', 'views', 0),
('views_handler_field_url', 'class', 'sites/all/modules/views/handlers/views_handler_field_url.inc', 'views', 0),
('views_handler_field_user', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user.inc', 'views', 0),
('views_handler_field_user_language', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_language.inc', 'views', 0),
('views_handler_field_user_link', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_link.inc', 'views', 0),
('views_handler_field_user_link_cancel', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_link_cancel.inc', 'views', 10),
('views_handler_field_user_link_edit', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_link_edit.inc', 'views', 0),
('views_handler_field_user_mail', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_mail.inc', 'views', 0),
('views_handler_field_user_name', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_name.inc', 'views', 0),
('views_handler_field_user_permissions', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_permissions.inc', 'views', 0),
('views_handler_field_user_picture', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_picture.inc', 'views', 0),
('views_handler_field_user_roles', 'class', 'sites/all/modules/views/modules/user/views_handler_field_user_roles.inc', 'views', 0),
('views_handler_field_xss', 'class', 'sites/all/modules/views/handlers/views_handler_field.inc', 'views', 0),
('views_handler_filter', 'class', 'sites/all/modules/views/handlers/views_handler_filter.inc', 'views', 10),
('views_handler_filter_aggregator_category_cid', 'class', 'sites/all/modules/views/modules/aggregator/views_handler_filter_aggregator_category_cid.inc', 'views', 0),
('views_handler_filter_boolean_operator', 'class', 'sites/all/modules/views/handlers/views_handler_filter_boolean_operator.inc', 'views', 0),
('views_handler_filter_boolean_operator_string', 'class', 'sites/all/modules/views/handlers/views_handler_filter_boolean_operator_string.inc', 'views', 10),
('views_handler_filter_broken', 'class', 'sites/all/modules/views/handlers/views_handler_filter.inc', 'views', 10),
('views_handler_filter_combine', 'class', 'sites/all/modules/views/handlers/views_handler_filter_combine.inc', 'views', 0),
('views_handler_filter_comment_user_uid', 'class', 'sites/all/modules/views/modules/comment/views_handler_filter_comment_user_uid.inc', 'views', 0),
('views_handler_filter_date', 'class', 'sites/all/modules/views/handlers/views_handler_filter_date.inc', 'views', 0),
('views_handler_filter_entity_bundle', 'class', 'sites/all/modules/views/handlers/views_handler_filter_entity_bundle.inc', 'views', 0),
('views_handler_filter_equality', 'class', 'sites/all/modules/views/handlers/views_handler_filter_equality.inc', 'views', 0),
('views_handler_filter_fields_compare', 'class', 'sites/all/modules/views/handlers/views_handler_filter_fields_compare.inc', 'views', 10),
('views_handler_filter_field_list', 'class', 'sites/all/modules/views/modules/field/views_handler_filter_field_list.inc', 'views', 0),
('views_handler_filter_file_status', 'class', 'sites/all/modules/views/modules/system/views_handler_filter_file_status.inc', 'views', 0),
('views_handler_filter_group_by_numeric', 'class', 'sites/all/modules/views/handlers/views_handler_filter_group_by_numeric.inc', 'views', 0),
('views_handler_filter_history_user_timestamp', 'class', 'sites/all/modules/views/modules/node/views_handler_filter_history_user_timestamp.inc', 'views', 0),
('views_handler_filter_in_operator', 'class', 'sites/all/modules/views/handlers/views_handler_filter_in_operator.inc', 'views', 0),
('views_handler_filter_locale_group', 'class', 'sites/all/modules/views/modules/locale/views_handler_filter_locale_group.inc', 'views', 0),
('views_handler_filter_locale_language', 'class', 'sites/all/modules/views/modules/locale/views_handler_filter_locale_language.inc', 'views', 0),
('views_handler_filter_locale_version', 'class', 'sites/all/modules/views/modules/locale/views_handler_filter_locale_version.inc', 'views', 0),
('views_handler_filter_many_to_one', 'class', 'sites/all/modules/views/handlers/views_handler_filter_many_to_one.inc', 'views', 0),
('views_handler_filter_ncs_last_updated', 'class', 'sites/all/modules/views/modules/comment/views_handler_filter_ncs_last_updated.inc', 'views', 0),
('views_handler_filter_node_access', 'class', 'sites/all/modules/views/modules/node/views_handler_filter_node_access.inc', 'views', 0),
('views_handler_filter_node_comment', 'class', 'sites/all/modules/views/modules/comment/views_handler_filter_node_comment.inc', 'views', 0),
('views_handler_filter_node_language', 'class', 'sites/all/modules/views/modules/locale/views_handler_filter_node_language.inc', 'views', 0),
('views_handler_filter_node_status', 'class', 'sites/all/modules/views/modules/node/views_handler_filter_node_status.inc', 'views', 0),
('views_handler_filter_node_tnid', 'class', 'sites/all/modules/views/modules/translation/views_handler_filter_node_tnid.inc', 'views', 0),
('views_handler_filter_node_tnid_child', 'class', 'sites/all/modules/views/modules/translation/views_handler_filter_node_tnid_child.inc', 'views', 0),
('views_handler_filter_node_type', 'class', 'sites/all/modules/views/modules/node/views_handler_filter_node_type.inc', 'views', 0),
('views_handler_filter_node_uid_revision', 'class', 'sites/all/modules/views/modules/node/views_handler_filter_node_uid_revision.inc', 'views', 0),
('views_handler_filter_numeric', 'class', 'sites/all/modules/views/handlers/views_handler_filter_numeric.inc', 'views', 0),
('views_handler_filter_profile_selection', 'class', 'sites/all/modules/views/modules/profile/views_handler_filter_profile_selection.inc', 'views', 0),
('views_handler_filter_search', 'class', 'sites/all/modules/views/modules/search/views_handler_filter_search.inc', 'views', 0),
('views_handler_filter_string', 'class', 'sites/all/modules/views/handlers/views_handler_filter_string.inc', 'views', 0),
('views_handler_filter_system_type', 'class', 'sites/all/modules/views/modules/system/views_handler_filter_system_type.inc', 'views', 0),
('views_handler_filter_term_node_tid', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid.inc', 'views', 10),
('views_handler_filter_term_node_tid_depth', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid_depth.inc', 'views', 0),
('views_handler_filter_tracker_boolean_operator', 'class', 'sites/all/modules/views/modules/tracker/views_handler_filter_tracker_boolean_operator.inc', 'views', 0),
('views_handler_filter_tracker_comment_user_uid', 'class', 'sites/all/modules/views/modules/tracker/views_handler_filter_tracker_comment_user_uid.inc', 'views', 0),
('views_handler_filter_user_current', 'class', 'sites/all/modules/views/modules/user/views_handler_filter_user_current.inc', 'views', 0),
('views_handler_filter_user_name', 'class', 'sites/all/modules/views/modules/user/views_handler_filter_user_name.inc', 'views', 0),
('views_handler_filter_user_permissions', 'class', 'sites/all/modules/views/modules/user/views_handler_filter_user_permissions.inc', 'views', 0),
('views_handler_filter_user_roles', 'class', 'sites/all/modules/views/modules/user/views_handler_filter_user_roles.inc', 'views', 0),
('views_handler_filter_vocabulary_machine_name', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_filter_vocabulary_machine_name.inc', 'views', 0),
('views_handler_filter_vocabulary_vid', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_filter_vocabulary_vid.inc', 'views', 0),
('views_handler_relationship', 'class', 'sites/all/modules/views/handlers/views_handler_relationship.inc', 'views', 0),
('views_handler_relationship_broken', 'class', 'sites/all/modules/views/handlers/views_handler_relationship.inc', 'views', 0),
('views_handler_relationship_entity_reverse', 'class', 'sites/all/modules/views/modules/field/views_handler_relationship_entity_reverse.inc', 'views', 0),
('views_handler_relationship_groupwise_max', 'class', 'sites/all/modules/views/handlers/views_handler_relationship_groupwise_max.inc', 'views', 0),
('views_handler_relationship_node_term_data', 'class', 'sites/all/modules/views/modules/taxonomy/views_handler_relationship_node_term_data.inc', 'views', 10),
('views_handler_relationship_translation', 'class', 'sites/all/modules/views/modules/translation/views_handler_relationship_translation.inc', 'views', 0),
('views_handler_sort', 'class', 'sites/all/modules/views/handlers/views_handler_sort.inc', 'views', 0),
('views_handler_sort_broken', 'class', 'sites/all/modules/views/handlers/views_handler_sort.inc', 'views', 0),
('views_handler_sort_comment_thread', 'class', 'sites/all/modules/views/modules/comment/views_handler_sort_comment_thread.inc', 'views', 0),
('views_handler_sort_date', 'class', 'sites/all/modules/views/handlers/views_handler_sort_date.inc', 'views', 0),
('views_handler_sort_group_by_numeric', 'class', 'sites/all/modules/views/handlers/views_handler_sort_group_by_numeric.inc', 'views', 0),
('views_handler_sort_menu_hierarchy', 'class', 'sites/all/modules/views/handlers/views_handler_sort_menu_hierarchy.inc', 'views', 0),
('views_handler_sort_ncs_last_comment_name', 'class', 'sites/all/modules/views/modules/comment/views_handler_sort_ncs_last_comment_name.inc', 'views', 0),
('views_handler_sort_ncs_last_updated', 'class', 'sites/all/modules/views/modules/comment/views_handler_sort_ncs_last_updated.inc', 'views', 0),
('views_handler_sort_random', 'class', 'sites/all/modules/views/handlers/views_handler_sort_random.inc', 'views', 0),
('views_handler_sort_search_score', 'class', 'sites/all/modules/views/modules/search/views_handler_sort_search_score.inc', 'views', 0),
('views_join', 'class', 'sites/all/modules/views/includes/handlers.inc', 'views', 10),
('views_join_subquery', 'class', 'sites/all/modules/views/includes/handlers.inc', 'views', 10),
('views_many_to_one_helper', 'class', 'sites/all/modules/views/includes/handlers.inc', 'views', 10),
('views_object', 'class', 'sites/all/modules/views/includes/base.inc', 'views', 0),
('views_plugin', 'class', 'sites/all/modules/views/includes/plugins.inc', 'views', 0),
('views_plugin_access', 'class', 'sites/all/modules/views/plugins/views_plugin_access.inc', 'views', 0),
('views_plugin_access_none', 'class', 'sites/all/modules/views/plugins/views_plugin_access_none.inc', 'views', 0),
('views_plugin_access_perm', 'class', 'sites/all/modules/views/plugins/views_plugin_access_perm.inc', 'views', 0),
('views_plugin_access_role', 'class', 'sites/all/modules/views/plugins/views_plugin_access_role.inc', 'views', 0),
('views_plugin_argument_default', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_default.inc', 'views', 0),
('views_plugin_argument_default_book_root', 'class', 'sites/all/modules/views/modules/book/views_plugin_argument_default_book_root.inc', 'views', 0),
('views_plugin_argument_default_current_user', 'class', 'sites/all/modules/views/modules/user/views_plugin_argument_default_current_user.inc', 'views', 0),
('views_plugin_argument_default_fixed', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_default_fixed.inc', 'views', 0),
('views_plugin_argument_default_node', 'class', 'sites/all/modules/views/modules/node/views_plugin_argument_default_node.inc', 'views', 0),
('views_plugin_argument_default_php', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_default_php.inc', 'views', 0),
('views_plugin_argument_default_raw', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_default_raw.inc', 'views', 0),
('views_plugin_argument_default_taxonomy_tid', 'class', 'sites/all/modules/views/modules/taxonomy/views_plugin_argument_default_taxonomy_tid.inc', 'views', 0),
('views_plugin_argument_default_user', 'class', 'sites/all/modules/views/modules/user/views_plugin_argument_default_user.inc', 'views', 0),
('views_plugin_argument_validate', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_validate.inc', 'views', 0),
('views_plugin_argument_validate_node', 'class', 'sites/all/modules/views/modules/node/views_plugin_argument_validate_node.inc', 'views', 0),
('views_plugin_argument_validate_numeric', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_validate_numeric.inc', 'views', 0),
('views_plugin_argument_validate_php', 'class', 'sites/all/modules/views/plugins/views_plugin_argument_validate_php.inc', 'views', 0),
('views_plugin_argument_validate_taxonomy_term', 'class', 'sites/all/modules/views/modules/taxonomy/views_plugin_argument_validate_taxonomy_term.inc', 'views', 0),
('views_plugin_argument_validate_user', 'class', 'sites/all/modules/views/modules/user/views_plugin_argument_validate_user.inc', 'views', 0),
('views_plugin_cache', 'class', 'sites/all/modules/views/plugins/views_plugin_cache.inc', 'views', 10),
('views_plugin_cache_none', 'class', 'sites/all/modules/views/plugins/views_plugin_cache_none.inc', 'views', 0),
('views_plugin_cache_time', 'class', 'sites/all/modules/views/plugins/views_plugin_cache_time.inc', 'views', 0),
('views_plugin_display', 'class', 'sites/all/modules/views/plugins/views_plugin_display.inc', 'views', 10),
('views_plugin_display_attachment', 'class', 'sites/all/modules/views/plugins/views_plugin_display_attachment.inc', 'views', 0),
('views_plugin_display_block', 'class', 'sites/all/modules/views/plugins/views_plugin_display_block.inc', 'views', 0),
('views_plugin_display_default', 'class', 'sites/all/modules/views/plugins/views_plugin_display_default.inc', 'views', 0),
('views_plugin_display_embed', 'class', 'sites/all/modules/views/plugins/views_plugin_display_embed.inc', 'views', 0),
('views_plugin_display_extender', 'class', 'sites/all/modules/views/plugins/views_plugin_display_extender.inc', 'views', 0),
('views_plugin_display_feed', 'class', 'sites/all/modules/views/plugins/views_plugin_display_feed.inc', 'views', 10),
('views_plugin_display_page', 'class', 'sites/all/modules/views/plugins/views_plugin_display_page.inc', 'views', 10),
('views_plugin_exposed_form', 'class', 'sites/all/modules/views/plugins/views_plugin_exposed_form.inc', 'views', 10),
('views_plugin_exposed_form_basic', 'class', 'sites/all/modules/views/plugins/views_plugin_exposed_form_basic.inc', 'views', 0),
('views_plugin_exposed_form_input_required', 'class', 'sites/all/modules/views/plugins/views_plugin_exposed_form_input_required.inc', 'views', 10),
('views_plugin_localization', 'class', 'sites/all/modules/views/plugins/views_plugin_localization.inc', 'views', 0),
('views_plugin_localization_core', 'class', 'sites/all/modules/views/plugins/views_plugin_localization_core.inc', 'views', 0),
('views_plugin_localization_none', 'class', 'sites/all/modules/views/plugins/views_plugin_localization_none.inc', 'views', 0),
('views_plugin_localization_test', 'class', 'sites/all/modules/views/tests/views_plugin_localization_test.inc', 'views', 0),
('views_plugin_pager', 'class', 'sites/all/modules/views/plugins/views_plugin_pager.inc', 'views', 10),
('views_plugin_pager_full', 'class', 'sites/all/modules/views/plugins/views_plugin_pager_full.inc', 'views', 10),
('views_plugin_pager_mini', 'class', 'sites/all/modules/views/plugins/views_plugin_pager_mini.inc', 'views', 10),
('views_plugin_pager_none', 'class', 'sites/all/modules/views/plugins/views_plugin_pager_none.inc', 'views', 0),
('views_plugin_pager_some', 'class', 'sites/all/modules/views/plugins/views_plugin_pager_some.inc', 'views', 0),
('views_plugin_query', 'class', 'sites/all/modules/views/plugins/views_plugin_query.inc', 'views', 0),
('views_plugin_query_default', 'class', 'sites/all/modules/views/plugins/views_plugin_query_default.inc', 'views', 10),
('views_plugin_row', 'class', 'sites/all/modules/views/plugins/views_plugin_row.inc', 'views', 0),
('views_plugin_row_aggregator_rss', 'class', 'sites/all/modules/views/modules/aggregator/views_plugin_row_aggregator_rss.inc', 'views', 0),
('views_plugin_row_comment_rss', 'class', 'sites/all/modules/views/modules/comment/views_plugin_row_comment_rss.inc', 'views', 0),
('views_plugin_row_comment_view', 'class', 'sites/all/modules/views/modules/comment/views_plugin_row_comment_view.inc', 'views', 0),
('views_plugin_row_fields', 'class', 'sites/all/modules/views/plugins/views_plugin_row_fields.inc', 'views', 0),
('views_plugin_row_node_rss', 'class', 'sites/all/modules/views/modules/node/views_plugin_row_node_rss.inc', 'views', 0),
('views_plugin_row_node_view', 'class', 'sites/all/modules/views/modules/node/views_plugin_row_node_view.inc', 'views', 0),
('views_plugin_row_rss_fields', 'class', 'sites/all/modules/views/plugins/views_plugin_row_rss_fields.inc', 'views', 0),
('views_plugin_row_search_view', 'class', 'sites/all/modules/views/modules/search/views_plugin_row_search_view.inc', 'views', 0),
('views_plugin_row_user_view', 'class', 'sites/all/modules/views/modules/user/views_plugin_row_user_view.inc', 'views', 0),
('views_plugin_style', 'class', 'sites/all/modules/views/plugins/views_plugin_style.inc', 'views', 0),
('views_plugin_style_default', 'class', 'sites/all/modules/views/plugins/views_plugin_style_default.inc', 'views', 0),
('views_plugin_style_grid', 'class', 'sites/all/modules/views/plugins/views_plugin_style_grid.inc', 'views', 0),
('views_plugin_style_jump_menu', 'class', 'sites/all/modules/views/plugins/views_plugin_style_jump_menu.inc', 'views', 10),
('views_plugin_style_list', 'class', 'sites/all/modules/views/plugins/views_plugin_style_list.inc', 'views', 0),
('views_plugin_style_mapping', 'class', 'sites/all/modules/views/plugins/views_plugin_style_mapping.inc', 'views', 0),
('views_plugin_style_rss', 'class', 'sites/all/modules/views/plugins/views_plugin_style_rss.inc', 'views', 0),
('views_plugin_style_summary', 'class', 'sites/all/modules/views/plugins/views_plugin_style_summary.inc', 'views', 0),
('views_plugin_style_summary_jump_menu', 'class', 'sites/all/modules/views/plugins/views_plugin_style_summary_jump_menu.inc', 'views', 0),
('views_plugin_style_summary_unformatted', 'class', 'sites/all/modules/views/plugins/views_plugin_style_summary_unformatted.inc', 'views', 0),
('views_plugin_style_table', 'class', 'sites/all/modules/views/plugins/views_plugin_style_table.inc', 'views', 0),
('views_test_area_access', 'class', 'sites/all/modules/views/tests/test_handlers/views_test_area_access.inc', 'views', 10),
('views_test_plugin_access_test_dynamic', 'class', 'sites/all/modules/views/tests/test_plugins/views_test_plugin_access_test_dynamic.inc', 'views', 0),
('views_test_plugin_access_test_static', 'class', 'sites/all/modules/views/tests/test_plugins/views_test_plugin_access_test_static.inc', 'views', 0),
('views_test_plugin_style_test_mapping', 'class', 'sites/all/modules/views/tests/test_plugins/views_test_plugin_style_test_mapping.inc', 'views', 0),
('views_ui', 'class', 'sites/all/modules/views/plugins/export_ui/views_ui.class.php', 'views_ui', 0),
('WysiwygProfileController', 'class', 'sites/all/modules/wysiwyg/wysiwyg.module', 'wysiwyg', 0);

-- --------------------------------------------------------

--
-- Структура таблицы `registry_file`
--

DROP TABLE IF EXISTS `registry_file`;
CREATE TABLE IF NOT EXISTS `registry_file` (
  `filename` varchar(255) NOT NULL COMMENT 'Path to the file.',
  `hash` varchar(64) NOT NULL COMMENT 'sha-256 hash of the file’s contents when last parsed.',
  PRIMARY KEY (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Files parsed to build the registry.';

--
-- Дамп данных таблицы `registry_file`
--

INSERT INTO `registry_file` (`filename`, `hash`) VALUES
('includes/actions.inc', 'f36b066681463c7dfe189e0430cb1a89bf66f7e228cbb53cdfcd93987193f759'),
('includes/ajax.inc', 'df8500bc0305993c011eaf51d3185e2c9c4b7f61213f13971761ed47d12eb31d'),
('includes/archiver.inc', 'bdbb21b712a62f6b913590b609fd17cd9f3c3b77c0d21f68e71a78427ed2e3e9'),
('includes/authorize.inc', '6d64d8c21aa01eb12fc29918732e4df6b871ed06e5d41373cb95c197ed661d13'),
('includes/batch.inc', '059da9e36e1f3717f27840aae73f10dea7d6c8daf16f6520401cc1ca3b4c0388'),
('includes/batch.queue.inc', '554b2e92e1dad0f7fd5a19cb8dff7e109f10fbe2441a5692d076338ec908de0f'),
('includes/bootstrap.inc', 'c823b636a36fe4cefb6d908ad43d5678fb106d34957f1003a5215b2521561ded'),
('includes/cache-install.inc', 'e7ed123c5805703c84ad2cce9c1ca46b3ce8caeeea0d8ef39a3024a4ab95fa0e'),
('includes/cache.inc', 'c1916375fcb92250a5c86aa53269d54854b983f34906d582fc912784f16ccaf4'),
('includes/common.inc', 'abf0d71d0ecc95fd727849d435cf57095b94568db66ab5d6ae0996e991dad0f1'),
('includes/database/database.inc', '9e42ae0ac0ae8fa94da417fb7b0dc4df038bf924adf6f7d77ca02976c5f8daaa'),
('includes/database/log.inc', '9feb5a17ae2fabcf26a96d2a634ba73da501f7bcfc3599a693d916a6971d00d1'),
('includes/database/mysql/database.inc', 'd62a2d8ca103cb3b085e7f8b894a7db14c02f20d0b1ed0bd32f6534a45b4527f'),
('includes/database/mysql/install.inc', '6ae316941f771732fbbabed7e1d6b4cbb41b1f429dd097d04b3345aa15e461a0'),
('includes/database/mysql/query.inc', '0212a871646c223bf77aa26b945c77a8974855373967b5fb9fdc09f8a1de88a6'),
('includes/database/mysql/schema.inc', 'd8d3904ea9c23a526c2f2a7acc8ba870b31c378aac2eb53e2e41a73c6209c5bd'),
('includes/database/pgsql/database.inc', 'd737f95947d78eb801e8ec8ca8b01e72d2e305924efce8abca0a98c1b5264cff'),
('includes/database/pgsql/install.inc', '585b80c5bbd6f134bff60d06397f15154657a577d4da8d1b181858905f09dea5'),
('includes/database/pgsql/query.inc', '0df57377686c921e722a10b49d5e433b131176c8059a4ace4680964206fc14b4'),
('includes/database/pgsql/schema.inc', '8fd647e4557522283caef63e528c6e403fc0751a46e94aac867a281af85eac27'),
('includes/database/pgsql/select.inc', 'fd4bba7887c1dc6abc8f080fc3a76c01d92ea085434e355dc1ecb50d8743c22d'),
('includes/database/prefetch.inc', 'b5b207a66a69ecb52ee4f4459af16a7b5eabedc87254245f37cc33bebb61c0fb'),
('includes/database/query.inc', '9171653e9710c6c0d20cff865fdead5a580367137ad4cdf81059ecc2eea61c74'),
('includes/database/schema.inc', '6e46893241e56cb48ffa80d431c9f2fe097162f178150d3dd8777c66c0f98712'),
('includes/database/select.inc', 'c3a278420ed6c2de751b546d0b6382841542d3f6b665e8596d459dc11c50940e'),
('includes/database/sqlite/database.inc', '4281c6e80932560ecbeb07d1757efd133e8699a6fccf58c27a55df0f71794622'),
('includes/database/sqlite/install.inc', '381f3db8c59837d961978ba3097bb6443534ed1659fd713aa563963fa0c42cc5'),
('includes/database/sqlite/query.inc', 'f33ab1b6350736a231a4f3f93012d3aac4431ac4e5510fb3a015a5aa6cab8303'),
('includes/database/sqlite/schema.inc', '238414785aa96dd27f10f48c961783f4d1091392beee8d0e7ca8ae774e917da2'),
('includes/database/sqlite/select.inc', '8d1c426dbd337733c206cce9f59a172546c6ed856d8ef3f1c7bef05a16f7bf68'),
('includes/date.inc', '18c047be64f201e16d189f1cc47ed9dcf0a145151b1ee187e90511b24e5d2b36'),
('includes/entity.inc', '3080fe3c30991a48f1f314a60d02e841d263a8f222337e5bde3be61afe41ee7a'),
('includes/errors.inc', '72cc29840b24830df98a5628286b4d82738f2abbb78e69b4980310ff12062668'),
('includes/file.inc', 'c48dad3783bbf77c1b4b83123dcca44d3ed51a254b04e4dbe67c2699bef77c88'),
('includes/file.mimetypes.inc', 'f88c967550576694b7a1ce2afd0f2f1bbc1a91d21cc2c20f86c44d39ff353867'),
('includes/filetransfer/filetransfer.inc', 'fdea8ae48345ec91885ac48a9bc53daf87616271472bb7c29b7e3ce219b22034'),
('includes/filetransfer/ftp.inc', '51eb119b8e1221d598ffa6cc46c8a322aa77b49a3d8879f7fb38b7221cf7e06d'),
('includes/filetransfer/local.inc', '7cbfdb46abbdf539640db27e66fb30e5265128f31002bd0dfc3af16ae01a9492'),
('includes/filetransfer/ssh.inc', '002e24a24cac133d12728bd3843868ce378681237d7fad420761af84e6efe5ad'),
('includes/form.inc', 'a0c5979e2dc5fd4ac5ac72cc1974365108a4c6fb21f6fde63b8a998b8a568d06'),
('includes/graph.inc', '8e0e313a8bb33488f371df11fc1b58d7cf80099b886cd1003871e2c896d1b536'),
('includes/image.inc', 'bcdc7e1599c02227502b9d0fe36eeb2b529b130a392bc709eb737647bd361826'),
('includes/install.core.inc', 'a0585c85002e6f3d702dc505584f48b55bc13e24bee749bfe5b718fbce4847e1'),
('includes/install.inc', 'affa74aa61a41f080cada3564abd1f83089bb60503cb6a56c3482af4a5c3d735'),
('includes/iso.inc', '0ce4c225edcfa9f037703bc7dd09d4e268a69bcc90e55da0a3f04c502bd2f349'),
('includes/json-encode.inc', '02a822a652d00151f79db9aa9e171c310b69b93a12f549bc2ce00533a8efa14e'),
('includes/language.inc', '4dd521af07e0ca7bf97ff145f4bd3a218acf0d8b94964e72f11212bb8af8d66e'),
('includes/locale.inc', '8cc571c114587f2b30e4e24db17e97e51e81f9cc395fa01f348aba12cee8523e'),
('includes/lock.inc', 'daa62e95528f6b986b85680b600a896452bf2ce6f38921242857dcc5a3460a1b'),
('includes/mail.inc', '419741aa09ba39e94771dc054f9bda66c932c937bb60bc71a15bf1d6c5bd39db'),
('includes/menu.inc', '33800a4450f76db2573751e2b8a21d790f4d4504666d945ac1a32eef308c3d12'),
('includes/module.inc', 'ca3f2e6129181bbbc67e5e6058a882047f2152174ec8e95c0ea99ce610ace4d7'),
('includes/pager.inc', '6f9494b85c07a2cc3be4e54aff2d2757485238c476a7da084d25bde1d88be6d8'),
('includes/password.inc', '7550ac434a929562a3380e82c546afbf9163598b22f2351f0e7d3f19567fb6c9'),
('includes/path.inc', '74bf05f3c68b0218730abf3e539fcf08b271959c8f4611940d05124f34a6a66f'),
('includes/registry.inc', 'c225de772f86eebd21b0b52fa8fcc6671e05fa2374cedb3164f7397f27d3c88d'),
('includes/session.inc', '6880cfa853e8b919bba6df34f76c9439710cd94730c6f952709af901c51489ed'),
('includes/stream_wrappers.inc', '4f1feb774a8dbc04ca382fa052f59e58039c7261625f3df29987d6b31f08d92d'),
('includes/tablesort.inc', '4cb2a5a2d41b2a204a13f59085096e3f64237d32639ea5d30752905099bc7540'),
('includes/theme.inc', '7fc0ffea33bf25419adb89b91f0fc892c183cd0db41e4f00958694b6f03e7335'),
('includes/theme.maintenance.inc', '39f068b3eee4d10a90d6aa3c86db587b6d25844c2919d418d34d133cfe330f5a'),
('includes/token.inc', '5e7898cd78689e2c291ed3cd8f41c032075656896f1db57e49217aac19ae0428'),
('includes/unicode.entities.inc', '2b858138596d961fbaa4c6e3986e409921df7f76b6ee1b109c4af5970f1e0f54'),
('includes/unicode.inc', '518ad21bd4f43814277d67f76ff8eb2b99bd1be4caa5e02b6e5f06cf65d84eb0'),
('includes/update.inc', '177ce24362efc7f28b384c90a09c3e485396bbd18c3721d4b21e57dd1733bd92'),
('includes/updater.inc', 'd2da0e74ed86e93c209f16069f3d32e1a134ceb6c06a0044f78e841a1b54e380'),
('includes/utility.inc', '3458fd2b55ab004dd0cc529b8e58af12916e8bd36653b072bdd820b26b907ed5'),
('includes/xmlrpc.inc', 'ea24176ec445c440ba0c825fc7b04a31b440288df8ef02081560dc418e34e659'),
('includes/xmlrpcs.inc', '741aa8d6fcc6c45a9409064f52351f7999b7c702d73def8da44de2567946598a'),
('modules/block/block.test', 'df1b364688b46345523dfcb95c0c48352d6a4edbc66597890d29b9b0d7866e86'),
('modules/blog/blog.test', 'f7534b972951c05d34bd832d3e06176b372fff6f4999c428f789fdd7703ed2e2'),
('modules/color/color.test', '013806279bd47ceb2f82ca854b57f880ba21058f7a2592c422afae881a7f5d15'),
('modules/comment/comment.module', '72744dfc221241f9919c934777c35fce36595a661ac81dc9c63483b423dde24c'),
('modules/comment/comment.test', '083d47035d3e64d1f6f9f1e12bc13d056511019a9de84183088e58a359ea58b9'),
('modules/contact/contact.test', 'd49eedd71859fbb6ffa26b87226f640db56694c8f43c863c83d920cf3632f9ad'),
('modules/contextual/contextual.test', '023dafa199bd325ecc55a17b2a3db46ac0a31e23059f701f789f3bc42427ba0b'),
('modules/dashboard/dashboard.test', '125df00fc6deb985dc554aa7807a48e60a68dbbddbad9ec2c4718da724f0e683'),
('modules/dblog/dblog.test', '11fbb8522b1c9dc7c85edba3aed7308a8891f26fc7292008822bea1b54722912'),
('modules/field/field.attach.inc', '60fbbe46f3e5319fc862f078aa9e56664e3ddb78f680ce170227db0b2e1d16b7'),
('modules/field/field.info.class.inc', 'c2e4bc67ef51e4956c913be772914b1b2625aa5066ab67c74baf6404ed538174'),
('modules/field/field.module', 'd855513f834dfd7401f0725027d6bb701c0373f451087320d74877f1ab76877c'),
('modules/field/modules/field_sql_storage/field_sql_storage.test', '35c9c300bc922d3a7c40516ad0ddeb7dc0ef02dd6b7f3f12b4820c41ce912593'),
('modules/field/modules/list/tests/list.test', '97e55bd49f6f4b0562d04aa3773b5ab9b35063aee05c8c7231780cdcf9c97714'),
('modules/field/modules/number/number.test', '9ccf835bbf80ff31b121286f6fbcf59cc42b622a51ab56b22362b2f55c656e18'),
('modules/field/modules/options/options.test', 'c71441020206b1587dece7296cca306a9f0fbd6e8f04dae272efc15ed3a38383'),
('modules/field/modules/text/text.test', 'a1e5cb0fa8c0651c68d560d9bb7781463a84200f701b00b6e797a9ca792a7e42'),
('modules/field/tests/field.test', '73bc91bbb405f25021340c887f218ea3d1b38473599c234e4c90454e08db63e9'),
('modules/field_ui/field_ui.test', 'da42e28d6f32d447b4a6e5b463a2f7d87d6ce32f149de04a98fa8e3f286c9f68'),
('modules/file/tests/file.test', '5cb7a7a6cc14a6d4269bf4d406a304f77052be7691e0ec9b8e7c5262316d7539'),
('modules/filter/filter.test', '184fa79a4802b3903844d35a63fd065ba3d8d025ba39a70cf3ff0ac1ef108bb4'),
('modules/help/help.test', 'bc934de8c71bd9874a05ccb5e8f927f4c227b3b2397d739e8504c8fd6ae5a83c'),
('modules/image/image.test', '37a999e3988ee08baddd05bb544926db68c00686913285105ca8bb3c34750526'),
('modules/me