{block content}

	{* template for page title is in parts/page-title.php *}

	{loop as $post}

		<div class="single-event">
				
			<div class="entry-thumbnail">
				{if $post->hasImage}
					<div class="entry-thumbnail-wrap">
						<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}" class="border" alt="{!$post->title}">
					</div>
				{/if}
			</div>

			<div class="meta-info">
				{var $meta = $post->meta(event-data)}
				{if $meta->dateTo != ''}
					<div class="event-duration">
						<span class="event-dur-title"><strong>{__ 'Duration:'}</strong></span>
						<time class="event-from" datetime="{$meta->dateFrom|date:c}">{$meta->dateFrom|dateI18n}</time>
						<span class="date-sep">-</span>
						<time class="event-to" datetime="{$meta->dateTo|date:c}">{$meta->dateTo|dateI18n}</time>
					</div>
				{/if}


				{if $wp->isSingular(event)}
					{var $meta = $post->meta('event-data')}
					{if $meta->location != ''}
						<div class="event-loc">
							<span class="event-loc-title"><strong>{__ 'Location:'}</strong></span>
							<span class="event-loc-text">{$meta->location}</span>
						</div>
					{/if}
				{/if}
			</div><!-- .entry-footer -->

			<div class="entry-content">
				{if $post->hasContent}
					{!$post->content}
				{else}
					{!$post->excerpt}
				{/if}

				{!$post->linkPages}
			</div><!-- .entry-content -->

			<div class="rule"></div>

			{includePart parts/pagination location => nav-below}
			
		</div>

	{/loop}
