<!doctype html>
<!--[if IE 8]>
<html {languageAttributes}  class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass} ie ie8">
<![endif]-->
<!--[if !(IE 7) | !(IE 8)]><!-->
<html {languageAttributes} class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass}">
<!--<![endif]-->
<head>
	<meta charset="{$wp->charset}">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="{$wp->pingbackUrl}">
	{if $options->theme->general->favicon != ""}
		<link href="{$options->theme->general->favicon}" rel="icon" type="image/x-icon" />
	{/if}

	{includePart parts/seo}

	{googleAnalytics $options->theme->google->analyticsTrackingId, $options->theme->google->anonymizeIp}

	{!$options->theme->header->customJsCode}

	{wpHead}
</head>
<body {!$wp->bodyHtmlClass}>
	{* usefull for inline scripts like facebook social plugins scripts, etc... *}
	{doAction ait-html-body-begin}

	<div id="page" class="hfeed page-container">

		{if $options->theme->header->headerType == 'header-two'}
			<header id="masthead" class="site-header" role="banner" data-header="header-two">

				<div class="header-top">
					<div class="grid-main">
						{includePart parts/languages-switcher}

						{menu header, depth => 1}
						<div class="ait-woocommerce-cart-widget">
								{includePart "parts/woocommerce-cart"}
						</div>
					</div>
				</div>

				<div class="header-container grid-main">
					<div class="site-header-table-wrap">
						<div class="site-header-row-wrap">
							<div class="site-logo">
								{if $options->theme->header->logo}
								<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
								{else}
								<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
								{/if}
							</div>

							<div class="menu-container">
								<nav class="main-nav" role="navigation">
									<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
									<div class="main-nav-wrap">
										<h3 class="menu-toggle">{__ 'Menu'} <i class="toggle-icon"></i></h3>
										{menu main}
									</div>
								</nav>
							</div>

						</div>
					</div>
				</div>

			</header><!-- #masthead -->
		{elseif $options->theme->header->headerType == 'header-three'}
			<header id="masthead" class="site-header" role="banner" data-header="header-three">

				<div class="header-top">
					<div class="grid-main">
						{includePart parts/languages-switcher}

						{menu header, depth => 1}
					</div>
				</div>

				<div class="site-info">
					<div class="grid-main">
						<div class="site-header-table-wrap">
							<div class="site-header-row-wrap">
								<p class="site-description">{$wp->description}</p>

								<div class="site-tools">
									{includePart parts/social-icons}
								</div>

								<div class="ait-woocommerce-cart-widget">
									{includePart "parts/woocommerce-cart"}
								</div>
							</div>
						</div>

					</div>
				</div>

				<div class="header-two">
					<div class="header-container">
						<div class="grid-main">
							<div class="site-header-table-wrap">
								<div class="site-header-row-wrap">
									<div class="site-logo">
										{if $options->theme->header->logo}
										<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
										{else}
										<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
										{/if}
									</div>

									<div class="menu-container">
										<nav class="main-nav" role="navigation">
											<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
											<div class="main-nav-wrap">
												<h3 class="menu-toggle">{__ 'Menu'} <i class="toggle-icon"></i></h3>
												{menu main}
											</div>
										</nav>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>

			</header><!-- #masthead -->
		{elseif $options->theme->header->headerType == 'header-four'}
			<header id="masthead" class="site-header" role="banner" data-header="header-four">

				<div class="header-top">
					<div class="grid-main">
						{includePart parts/languages-switcher}

						{menu header, depth => 1}
					</div>
				</div>

				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
						{/if}
					</div>

					<div class="site-tools">
						{includePart parts/social-icons}

						<div class="woo-cart-holder">
							<div class="ait-woocommerce-cart-widget">
								{includePart "parts/woocommerce-cart"}
							</div>
						</div>
					</div>
				</div>

				<div class="menu-container">
					<div class="grid-main">
						<nav class="main-nav" role="navigation">
							<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'} <i class="toggle-icon"></i></h3>
								{menu main}
							</div>
						</nav>
					</div>
				</div>

			</header><!-- #masthead -->
		{elseif $options->theme->header->headerType == 'header-five'}
			<header id="masthead" class="site-header" role="banner" data-header="header-five">

				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
						{/if}
					</div>

					<div class="site-tools">

						{includePart parts/social-icons}

						<div class="site-search">
							{searchForm}
						</div>

						{includePart parts/languages-switcher}

						<div class="ait-woocommerce-cart-widget">
							{includePart "parts/woocommerce-cart"}
						</div>

					</div>
				</div>

				<div class="menu-container">
					<div class="grid-main">
						<nav class="main-nav" role="navigation">
							<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'} <i class="toggle-icon"></i></h3>
								{menu main}
							</div>
						</nav>
					</div>
				</div>

			</header><!-- #masthead -->
		{elseif $options->theme->header->headerType == 'headerSix'}
			<header id="masthead" class="site-header" role="banner" data-header="header-six">

				<div class="header-container grid-main">
					{!$options->theme->header->customHtml}
				</div>

				<div class="menu-container">
					<div class="grid-main">

						<nav class="main-nav" role="navigation">
							<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'} <i class="toggle-icon"></i></h3>
								{menu main}
							</div>
						</nav>

						<div class="site-tools">
							<div class="ait-woocommerce-cart-widget">
								{includePart "parts/woocommerce-cart"}
							</div>

							{includePart parts/languages-switcher}
						</div>

					</div>
				</div>

			</header><!-- #masthead -->
		{else}
			<header id="masthead" class="site-header" role="banner" data-header="header-one">

				<div class="header-top">
					<div class="grid-main">
						{includePart parts/languages-switcher}

						{menu header, depth => 1}
					</div>
				</div>

				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
						{/if}
						<p class="site-description">{$wp->description}</p>
					</div>

					<div class="site-tools">
						{includePart parts/social-icons}

						<div class="site-search">
							{searchForm}
						</div>

						<div class="ait-woocommerce-cart-widget">
							{includePart "parts/woocommerce-cart"}
						</div>
					</div>
				</div>

				<div class="menu-container">
					<div class="grid-main">
						<nav class="main-nav" role="navigation">
							<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'} <i class="toggle-icon"></i></h3>
								{menu main}
							</div>
						</nav>
					</div>
				</div>

			</header><!-- #masthead -->
		{/if}

		<div class="menu-overlay"></div>

		<div class="sticky-menu menu-container" >
			<div class="grid-main">
				<div class="site-logo">
					{if $options->theme->header->logo}
					<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
					{else}
					<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
					{/if}
				</div>
				<nav class="main-nav">
					<!-- wp menu here -->
				</nav>
			</div>
		</div>
