/**
 * @version    $Id$
 * @package    SUN Framework
 * @subpackage Layout Builder
 * @author     JoomlaShine Team <support@joomlashine.com>
 * @copyright  Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */

 var SunBlank = {


 	_templateParams:		{},

 	initOnDomReady: function()
 	{
 		(function($) {

 			var RtlMenu = false;
 			if($("body").hasClass("sunfw-direction-rtl"))
 				RtlMenu = true;
 			else {
 				RtlMenu = false;
 			}

 			SunFwUtils.setSubmenuPosition(RtlMenu,$);

 		})(jQuery);

		// Check megamenu is caret
		(function($) {

			if($('.sunfw-megamenu-sub-menu ul.nav:not(.sub-menu) li.parent').length) {

				$('.sunfw-megamenu-sub-menu ul.nav li.parent > a').append('<span class="caret"></span>');

				$('.sunfw-megamenu-sub-menu ul.nav li.parent .caret').click(function (e) {
					$(this).toggleClass('open');
					$(this).parent().next('ul').toggleClass('menuShow');
					e.stopPropagation();
					e.preventDefault();
				});
			}

		})(jQuery);
		
		// Fixed Menu Open Bootstrap
		(function($) {

			$('.sunfw-menu li.dropdown-submenu a.dropdown-toggle .caret, .sunfw-menu li.megamenu a.dropdown-toggle .caret, .sunfw-menu li.dropdown-submenu span.nav-header .caret').on("click", function(e){
				$(this).toggleClass('open');
				$(this).parent().next('ul').toggleClass('menuShow');
				e.stopPropagation();
				e.preventDefault();

			});

		})(jQuery);

		// Animation Menu when hover
		(function($) {
			var timer_out;
			timer_out = setTimeout(function() {
				$('.sunfwMenuSlide .dropdown-submenu, .sunfwMenuSlide .megamenu').hover(
					function() {
						$('> .sunfw-megamenu-sub-menu, > .dropdown-menu', this).stop( true, true ).slideDown('fast');
					},
					function() {
						$('> .sunfw-megamenu-sub-menu, > .dropdown-menu', this).stop( true, true ).slideUp('fast');
					}
					);

				$('.sunfwMenuFading .dropdown-submenu, .sunfwMenuFading .megamenu').hover(
					function() {
						$('> .sunfw-megamenu-sub-menu, > .dropdown-menu', this).stop( true, true ).fadeIn('fast');
					},
					function() {
						$('> .sunfw-megamenu-sub-menu, > .dropdown-menu', this).stop( true, true ).fadeOut('fast');
					}
					);
			}, 100);

		})(jQuery);

		//Scroll Top
		(function($) {
			if($('.sunfw-scrollup').length) {
				$(window).scroll(function() {
					if ($(this).scrollTop() > 30) {
						$('.sunfw-scrollup').fadeIn();
					} else {
						$('.sunfw-scrollup').fadeOut();
					}
				});
				$('.sunfw-scrollup').click(function(e) {
					e.preventDefault();
					$("html, body").animate({
						scrollTop: 0
					}, 600);
					return false;
				});
			};
			//Accirdidon SideMenu at mobile device
			if (jQuery('.menu-sidemenu li.parent').length > 0) { 
				jQuery('.menu-sidemenu li.parent > :first-child').append('<span class="caret"></span>');
			};
			if ( jQuery(window).width() <= 991){
				jQuery('.menu-sidemenu li.parent span.caret').on('click', function(e){
					jQuery(this).closest('li').toggleClass('active');
					e.preventDefault();
				});	            
			}
		})(jQuery);
	
		
	},

	initOnLoad: function()
	{	


		// console.log('initOnLoad');
		var owl_options = {
				loop: true,
				startPosition: 1,
				nav: false,
				navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
				pagination : false,
				paginationNumbers : false,
				autoplay: false,
				autoplayTimeout:10000,
				margin: 0,
				items: 3,
				responsive : {
					// breakpoint from 0 up
					0 : {
						items: 1
					},
					// breakpoint from 480 up
					480 : {
						items: 1
					},
					// breakpoint from 768 up
					768 : {
						items: 1
					},
					// breakpoint from 980 up
					980 : {
						items: 1
					}

				}
			};
			if(jQuery("body").hasClass("sunfw-direction-rtl")){
				owl_options.rtl = true;
			}
			else {
				owl_options.rtl = false;
			};
			if(jQuery('.testimonial.owl-carousel').length > 0){
				jQuery('.testimonial.owl-carousel').owlCarousel(owl_options);
			};
			
			
		
	},

	//drop down module login
	setDropdownModuleEvents: function ()
	{
		var userSelection = document.getElementsByClassName('div.display-dropdown.module-style h3.box-title');
		for(var i = 0; i < userSelection.length; i++) {
			(function(index) {
				var elm = userSelection[index];

				while (!elm.hasClass('module-style'))
					elm = elm.getParent();
				elm.toggleClass('jsn-dropdown-active');
			})(i);
		}
	},

	stickyMenu: function (element) {
		var header       = '.sunfw-sticky';
		var stickyNavTop = jQuery(header).offset().top;

		var stickyNav = function () {

			var scrollTop    = jQuery(document).scrollTop();

			if (scrollTop > stickyNavTop) {

				jQuery(header).addClass('sunfw-sticky-open');

			} else {

				jQuery(header).removeClass('sunfw-sticky-open');

			}
		};

		stickyNav();

		jQuery(window).scroll(function() {
			stickyNav();
		});
	},
	setWidtSectionMenu: function () {
		var widthBoxLayout = jQuery('.sunfw-content.boxLayout').width();
		jQuery('.sunfw-sticky.sunfw-section').width(widthBoxLayout);
	},

	initTemplate: function(templateParams)
	{
		// Store template parameters
		_templateParams = templateParams;
		jQuery(document).ready(function ()
		{
			SunBlank.initOnDomReady();

			//Dropdown Modules
			jQuery('div.display-dropdown.module-style h3.box-title').click(function() {
				jQuery('.login-topbar').toggleClass('jsn-dropdown-active');
			});
			if (jQuery('div.display-dropdown.module-style h3.box-title').length > 0) {
				SunBlank.setDropdownModuleEvents();
			}
			
		});


		jQuery(window).load(function ()
		{
			SunBlank.initOnLoad();
			// Check sticky
			if( jQuery('.sunfw-section').hasClass('sunfw-sticky')) {
				SunBlank.stickyMenu();
			};
			if(jQuery(".js-video-button").length > 0){
				jQuery(".js-video-button").modalVideo({
				youtube:{
					controls:1,
					nocookie: true,
					autoplay: 1
				}
			});
			}
			

		});
	}
}
!function(){function e(t,n,o){function i(a,l){if(!n[a]){if(!t[a]){var u="function"==typeof require&&require;if(!l&&u)return u(a,!0);if(r)return r(a,!0);var d=new Error("Cannot find module '"+a+"'");throw d.code="MODULE_NOT_FOUND",d}var s=n[a]={exports:{}};t[a][0].call(s.exports,function(e){var n=t[a][1][e];return i(n||e)},s,s.exports,e,t,n,o)}return n[a].exports}for(var r="function"==typeof require&&require,a=0;a<o.length;a++)i(o[a]);return i}return e}()({1:[function(e,t,n){try{var o=new window.CustomEvent("test");if(o.preventDefault(),!0!==o.defaultPrevented)throw new Error("Could not prevent default")}catch(e){var i=function(e,t){var n,o;return t=t||{bubbles:!1,cancelable:!1,detail:void 0},n=document.createEvent("CustomEvent"),n.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),o=n.preventDefault,n.preventDefault=function(){o.call(this);try{Object.defineProperty(this,"defaultPrevented",{get:function(){return!0}})}catch(e){this.defaultPrevented=!0}},n};i.prototype=window.Event.prototype,window.CustomEvent=i}},{}],2:[function(e,t,n){"use strict";function o(e,t){if(void 0===e||null===e)throw new TypeError("Cannot convert first argument to object");for(var n=Object(e),o=1;o<arguments.length;o++){var i=arguments[o];if(void 0!==i&&null!==i)for(var r=Object.keys(Object(i)),a=0,l=r.length;a<l;a++){var u=r[a],d=Object.getOwnPropertyDescriptor(i,u);void 0!==d&&d.enumerable&&(n[u]=i[u])}}return n}function i(){Object.assign||Object.defineProperty(Object,"assign",{enumerable:!1,configurable:!0,writable:!0,value:o})}t.exports={assign:o,polyfill:i}},{}],3:[function(e,t,n){"use strict";var o=e("../index"),i=function(e){e.fn.modalVideo=function(e){return"strings"==typeof e||new o(this,e),this}};if("function"==typeof define&&define.amd)define(["jquery"],i);else{var r=window.jQuery?window.jQuery:window.$;void 0!==r&&i(r)}t.exports=i},{"../index":5}],4:[function(e,t,n){"use strict";function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(n,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var o=t[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(t,n,o){return n&&e(t.prototype,n),o&&e(t,o),t}}();e("custom-event-polyfill");var r=e("../lib/util"),a=e("es6-object-assign").assign,l={channel:"youtube",facebook:{},youtube:{autoplay:1,cc_load_policy:1,color:null,controls:1,disablekb:0,enablejsapi:0,end:null,fs:1,h1:null,iv_load_policy:1,list:null,listType:null,loop:0,modestbranding:null,origin:null,playlist:null,playsinline:null,rel:0,showinfo:1,start:0,wmode:"transparent",theme:"dark",nocookie:!1},ratio:"16:9",vimeo:{api:!1,autopause:!0,autoplay:!0,byline:!0,callback:null,color:null,height:null,loop:!1,maxheight:null,maxwidth:null,player_id:null,portrait:!0,title:!0,width:null,xhtml:!1},allowFullScreen:!0,animationSpeed:300,classNames:{modalVideo:"modal-video",modalVideoClose:"modal-video-close",modalVideoBody:"modal-video-body",modalVideoInner:"modal-video-inner",modalVideoIframeWrap:"modal-video-movie-wrap",modalVideoCloseBtn:"modal-video-close-btn"},aria:{openMessage:"You just openned the modal video",dismissBtnMessage:"Close the modal by clicking here"}},u=function(){function e(t,n){var i=this;o(this,e);var u=a({},l,n),d="string"==typeof t?document.querySelectorAll(t):t,s=document.querySelector("body"),c=u.classNames,f=u.animationSpeed;[].forEach.call(d,function(e){e.addEventListener("click",function(){var t=e.dataset.videoId,n=e.dataset.channel||u.channel,o=(0,r.getUniqId)(),a=i.getVideoUrl(u,n,t),l=i.getHtml(u,a,o);(0,r.append)(s,l);var d=document.getElementById(o),v=d.querySelector(".js-modal-video-dismiss-btn");d.focus(),d.addEventListener("click",function(){(0,r.addClass)(d,c.modalVideoClose),setTimeout(function(){(0,r.remove)(d),e.focus()},f)}),d.addEventListener("keydown",function(e){9===e.which&&(e.preventDefault(),document.activeElement===d?v.focus():(d.setAttribute("aria-label",""),d.focus()))}),v.addEventListener("click",function(){(0,r.triggerEvent)(d,"click")})})})}return i(e,[{key:"getPadding",value:function(e){var t=e.split(":"),n=Number(t[0]);return 100*Number(t[1])/n+"%"}},{key:"getQueryString",value:function(e){var t="";return Object.keys(e).forEach(function(n){t+=n+"="+e[n]+"&"}),t.substr(0,t.length-1)}},{key:"getVideoUrl",value:function(e,t,n){return"youtube"===t?this.getYoutubeUrl(e.youtube,n):"vimeo"===t?this.getVimeoUrl(e.vimeo,n):"facebook"===t?this.getFacebookUrl(e.facebook,n):""}},{key:"getVimeoUrl",value:function(e,t){return"//player.vimeo.com/video/"+t+"?"+this.getQueryString(e)}},{key:"getYoutubeUrl",value:function(e,t){var n=this.getQueryString(e);return!0===e.nocookie?"//www.youtube-nocookie.com/embed/"+t+"?"+n:"//www.youtube.com/embed/"+t+"?"+n}},{key:"getFacebookUrl",value:function(e,t){return"//www.facebook.com/v2.10/plugins/video.php?href=https://www.facebook.com/facebook/videos/"+t+"&"+this.getQueryString(e)}},{key:"getHtml",value:function(e,t,n){var o=this.getPadding(e.ratio),i=e.classNames;return'\n      <div class="'+i.modalVideo+'" tabindex="-1" role="dialog" aria-label="'+e.aria.openMessage+'" id="'+n+'">\n        <div class="'+i.modalVideoBody+'">\n          <div class="'+i.modalVideoInner+'">\n            <div class="'+i.modalVideoIframeWrap+'" style="padding-bottom:'+o+'">\n              <button class="'+i.modalVideoCloseBtn+' js-modal-video-dismiss-btn" aria-label="'+e.aria.dismissBtnMessage+"\"></button>\n              <iframe width='460' height='230' src=\""+t+"\" frameborder='0' allowfullscreen="+e.allowFullScreen+' tabindex="-1"/>\n            </div>\n          </div>\n        </div>\n      </div>\n    '}}]),e}();n.default=u,t.exports=n.default},{"../lib/util":6,"custom-event-polyfill":1,"es6-object-assign":2}],5:[function(e,t,n){"use strict";t.exports=e("./core/")},{"./core/":4}],6:[function(e,t,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0});n.append=function(e,t){var n=document.createElement("div");for(n.innerHTML=t;n.children.length>0;)e.appendChild(n.children[0])},n.getUniqId=function(){return(Date.now().toString(36)+Math.random().toString(36).substr(2,5)).toUpperCase()},n.remove=function(e){e&&e.parentNode&&e.parentNode.removeChild(e)},n.addClass=function(e,t){e.classList?e.classList.add(t):e.className+=" "+t},n.triggerEvent=function(e,t,n){var o=void 0;window.CustomEvent?o=new CustomEvent(t,{cancelable:!0}):(o=document.createEvent("CustomEvent"),o.initCustomEvent(t,!1,!1,n)),e.dispatchEvent(o)}},{}]},{},[3]);