<?php
/**
 * @package   T3 Blank
 * @copyright Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license   GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>

<!-- META FOR IOS & HANDHELD -->
<?php if ($this->getParam('responsive', 1)): ?>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
	<style type="text/stylesheet">
		@-webkit-viewport   { width: device-width; }
		@-moz-viewport      { width: device-width; }
		@-ms-viewport       { width: device-width; }
		@-o-viewport        { width: device-width; }
		@viewport           { width: device-width; }
	</style>
	<script type="text/javascript">
		//<![CDATA[
		if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
			var msViewportStyle = document.createElement("style");
			msViewportStyle.appendChild(
				document.createTextNode("@-ms-viewport{width:auto!important}")
			);
			document.getElementsByTagName("head")[0].appendChild(msViewportStyle);
		}
		//]]>
	</script>
	

<?php endif ?>
<meta name="HandheldFriendly" content="true"/>
<meta name="apple-mobile-web-app-capable" content="YES"/>
<!-- //META FOR IOS & HANDHELD -->

<?php
// SYSTEM CSS
$this->addStyleSheet(JUri::base(true) . '/templates/system/css/system.css');
$this->addScript(T3_TEMPLATE_URL . '/js/script.js');
?>

<?php
// T3 BASE HEAD
$this->addHead();
?>

<?php
// CUSTOM CSS
if (is_file(T3_TEMPLATE_PATH . '/css/custom.css')) {
	$this->addStyleSheet(T3_TEMPLATE_URL . '/css/custom.css');
}
?>

<!-- Le HTML5 shim and media query for IE8 support -->
<!--[if lt IE 9]>
<script src="//html5shim.googlecode.com/svn/trunk/html5.js"></script>
<script type="text/javascript" src="<?php echo T3_URL ?>/js/respond.min.js"></script>
<![endif]-->

<!-- You can add Google Analytics here or use T3 Injection feature -->
<?php 
$script = '<script>
	jQuery(document).ready(function(){
	jQuery(window).scroll(function() {    
		var scroll = jQuery(window).scrollTop();
		if (scroll >= 100) {
			jQuery(".t3-header").addClass("solid");
		}
		if (scroll <= 100) {
			jQuery(".t3-header").removeClass("solid");
		}
	});
	})
</script>';
$wowjs = '<script>
new WOW().init();
</script>';
$app = JFactory::getApplication();
$templateName = $app->getTemplate();
$document = JFactory::getDocument();
JHtml::_('jquery.framework');
$document->addCustomTag($script);
$document->addStyleSheet(JUri::base(true) . '/templates/'. $templateName.'/less/kunena.less');
$document->addStyleSheet(JUri::base(true) . '/templates/'. $templateName.'/less/animate.less');
$document->addStyleSheet('https://fonts.googleapis.com/css?family=Roboto');
$document->addScript(JUri::base(true) . '/templates/'. $templateName.'/js/less.js');
$document->addScript(JUri::base(true) . '/templates/'. $templateName.'/js/wow.min.js');
$document->addCustomTag($wowjs);
?>