<?php
/**
 * Template for displaying search forms 
 *
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'intechnic-lite' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'intechnic-lite' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	</label>
	<button type="submit" class="search-submit btn btn-primary"><span class="screen-reader-text"><?php echo _x( 'Search', 'submit button', 'intechnic-lite' ); ?></span><?php _e('Search', 'intechnic-lite'); ?></button>
</form>
