<?php
/**
 * The template part for displaying a message that posts cannot be found
 * @version:1.0
 * 
 */
?>

<section class="no-results not-found">

	<header class="page-header">
		<h1 class="page-title font_40"><?php _e( 'Nothing Found', 'intechnic-lite' ); ?></h1>
	</header><!-- .page-header -->

	<div class="page-content">

		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'intechnic-lite' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'intechnic-lite' ); ?></p>
			
			
		<div class="m_20">
			<?php get_search_form(); ?>
		</div>
		<?php else : ?>

			<p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'intechnic-lite' ); ?></p>

		<div class="m_20">
			<?php get_search_form(); ?>
		</div>
		<?php endif; ?>

	</div><!-- .page-content -->
</section><!-- .no-results -->

