<?php
/**
	This File handles Customizer Options
	* @version:1.0
*/


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page About Section 3
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
	

		Kirki::add_section( 'homepage_aboutthree', array(
			'title'          => __( 'About Section Three', 'intechnic-lite' ),
			'description'    => __( 'From here you can manage about section 3', 'intechnic-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 91,
			'capability'     => 'edit_theme_options',
		) );

			Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepage_aboutthree_bgimage',
                'label'    => __( 'Image', 'intechnic-lite' ),
                'section'  => 'homepage_aboutthree',
                'type'     => 'image',
                'priority' => 92,
                'default'  => get_template_directory_uri() . '/assets/images/s-left.jpg',
		) );

		Kirki::add_field( 'intechnic-lite', array(
					'settings' => 'homepage_aboutthree_title',
					'label'    => __( 'Heading', 'intechnic-lite' ),
					'section'  => 'homepage_aboutthree',
					'type'     => 'text',
					'priority' => 93,
					'default'  => 'Hey title',
				) );

	
		Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'homepage_aboutthree_content',
			'label'    => __( 'Content', 'intechnic-lite' ),
			'section'  => 'homepage_aboutthree',
			'type'     => 'textarea',
			'priority' => 94,
			'default'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book',
			
		) );

			Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepageaboutthreeonoff',
                'label'    => __( 'Button ON/OFF', 'intechnic-lite' ),
                'section'  => 'homepage_aboutthree',
                'type'     => 'toggle',
                'priority' => 95,
                'default'  => 1,           
            ) );

	 	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_aboutthree_button',
				'label'    => __( 'Button Text', 'intechnic-lite' ),
				'section'  => 'homepage_aboutthree',
				'type'     => 'text',
				'priority' => 96,
				'default'  => 'LEARN MORE ABOUT OUR CUSTOMERS',
				
			) );
	 	
	 	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepage_aboutthree_button_link',
                'label'    => __( 'Button Link', 'intechnic-lite' ),
                'section'  => 'homepage_aboutthree',
                'type'     => 'text',
                'priority' => 97,
                'default'  => '#', 
            ) );
	 	


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page  Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_panel( 'services_page', array(
    'priority'    => 5,
    'title'       => __( 'Services Page', 'intechnic-lite' ),
    'description' => __( 'Manage services page from here', 'intechnic-lite' ),
	) );


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page Header Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'services_banner', array(
		'title'          => __( 'Header Content Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage background image, Title and Text of Header', 'intechnic-lite' ),
		'panel'          => 'services_page', 
		'priority'       => 150,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
	'settings' => 'service_banner_image',
	'label'    => __( 'Header Image', 'intechnic-lite' ),
	'section'  => 'services_banner',
	'type'        => 'image',
	'priority' => 151,
	'default'  => get_template_directory_uri() . '/assets/images/banner_service.jpg',
	) );

	Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'services_banner_heading',
			'label'    => __( 'Heading', 'intechnic-lite' ),
			'section'  => 'services_banner',
			'type'     => 'text',
			'priority' => 152,
			'default'  => 'WELCOME TO intechnic',
		) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'services_banner_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'services_banner',
				'type'     => 'text',
				'priority' => 153,
				'default'  => 'Services',
			) );
			
				
	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'services_banner_text',
		'label'    => __( 'Sub Heading', 'intechnic-lite' ),
		'section'  => 'services_banner',
		'type'     => 'textarea',
		'priority' => 154,
		'default'  => 'To help customers find businesses that genuinely provide exceptional service, we personally check each business.',
		
	) );

		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page about Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'services_about_block', array(
		'title'          => __( 'About Section Setting', 'intechnic-lite' ),
		'description'    => __( 'Manage service page about section from here', 'intechnic-lite' ),
		'panel'          => 'services_page', 
		'priority'       => 155,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'services_about_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'services_about_block',
				'type'     => 'textarea',
				'priority' => 156,
				'default'  => ' Services introduction Company business and innovation marketing',
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'services_about_content',
				'label'    => __( 'Content', 'intechnic-lite' ),
				'section'  => 'services_about_block',
				'type'     => 'textarea',
				'priority' => 157,
				'default'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
			) );

	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page services blocks Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'services_service_block', array(
		'title'          => __( 'Services Section Setting', 'intechnic-lite' ),
		'description'    => __( 'Manage service page service section from here', 'intechnic-lite' ),
		'panel'          => 'services_page', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'services_service_block',
	'settings' => 'service_services_',
	'priority'    => 161,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Services', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 3,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
	'service_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Image', 'intechnic-lite' ),
				'section'     => 'services_service_block',
				'priority'    => 162,
				'default'  => '',
				
			),	
	'service__name'  => array(
				'label'    =>esc_attr__( 'Heading', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be the label of name field', 'intechnic-lite' ),
				'section'  => 'services_service_block',
				'type'     => 'text',
				'priority' => 163,
				'default'  => '', 
			),
	'service_content'  => array(
			'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
			'description' => esc_attr__( 'This will be content field', 'intechnic-lite' ),
			'section'  => 'services_service_block',
			'type'     => 'textarea',
			'priority' => 164,
			'default'  => '', 
		),
	'service_button'  => array(
            'label'    => esc_attr__( 'Buttoon Text', 'intechnic-lite' ),
            'section'  => 'services_service_block',
            'type'     => 'text',
            'priority' => 165,
            'default'  => '',  
		),
	'service_link'  => array(
            'label'    => esc_attr__( 'Link', 'intechnic-lite' ),
            'section'  => 'services_service_block',
            'type'     => 'text',
            'priority' => 166,
            'default'  => '#',  
		),
	
	)
) );

/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page services blocks 2 Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'services_service_blocks', array(
		'title'          => __( 'Services Section 2 Setting', 'intechnic-lite' ),
		'description'    => __( 'Manage service page services section from here', 'intechnic-lite' ),
		'panel'          => 'services_page', 
		'priority'       => 170,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'services_about_block_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'services_service_blocks',
				'type'     => 'textarea',
				'priority' => 171,
				'default'  => ' We bring the best things For you',
			) );


	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'services_service_blocks',
	'settings' => 'service_services_blocks',
	'priority'    => 172,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Services', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 3,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
	'service_bloc_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Image', 'intechnic-lite' ),
				'section'     => 'services_service_blocks',
				'priority'    => 173,
				'default'  => '',
				
			),	
	'service_block_name'  => array(
				'label'    =>esc_attr__( 'Heading', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be the label of name field', 'intechnic-lite' ),
				'section'  => 'services_service_blocks',
				'type'     => 'text',
				'priority' => 174,
				'default'  => '', 
			),
	'service_block_content'  => array(
			'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
			'description' => esc_attr__( 'This will be content field', 'intechnic-lite' ),
			'section'  => 'services_service_blocks',
			'type'     => 'textarea',
			'priority' => 175,
			'default'  => '', 
		),
	
	)
) );


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page planning Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'services_planning_section', array(
		'title'          => __( 'Planning Section Setting', 'intechnic-lite' ),
		'description'    => __( 'Manage service page planning section from here', 'intechnic-lite' ),
		'panel'          => 'services_page', 
		'priority'       => 180,
		'capability'     => 'edit_theme_options',
	) );


	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Planning Sections', 'intechnic-lite' ),
	'section'     => 'services_planning_section',
	'settings' => 'service_planning',
	'priority'    => 181,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Planning Section', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 4,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
	'service_planning_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Left Image', 'intechnic-lite' ),
				'section'     => 'services_planning_section',
				'priority'    => 182,
				'default'  => '',
				
			),
	'service_planning_right_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Right Image', 'intechnic-lite' ),
				'section'     => 'services_planning_section',
				'priority'    => 183,
				'default'  => '',
				
			),
	'service_planning_right_heading'  => array(
		'label'    =>esc_attr__( 'Heading', 'intechnic-lite' ),
		'description' => esc_attr__( 'This will be the label of heading field', 'intechnic-lite' ),
		'section'  => 'services_planning_section',
		'type'     => 'text',
		'priority' => 184,
		'default'  => '', 
	),
	'service_planning_right_content'  => array(
		'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
		'description' => esc_attr__( 'This will be the label of content field', 'intechnic-lite' ),
		'section'  => 'services_planning_section',
		'type'     => 'textarea',
		'priority' => 185,
		'default'  => '', 
	),
	'service_planning_right_link'  => array(
		'label'    =>esc_attr__( 'Link', 'intechnic-lite' ),
		'description' => esc_attr__( 'This will be the label of link field', 'intechnic-lite' ),
		'section'  => 'services_planning_section',
		'type'     => 'text',
		'priority' => 186,
		'default'  => '#', 
	),			
	)
) );




/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Service Page unique Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'services_unique', array(
		'title'          => __( 'Unique Setting', 'intechnic-lite' ),
		'description'    => __( 'Manage service page unique section from here', 'intechnic-lite' ),
		'panel'          => 'services_page', 
		'priority'       => 190,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'services_unique_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'services_unique',
				'type'     => 'textarea',
				'priority' => 191,
				'default'  => ' GROW YOUR BUSINESS',
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'services_unique_subheading',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'services_unique',
				'type'     => 'textarea',
				'priority' => 192,
				'default'  => ' What makes us different from the other companies',
			) );


	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'services_unique',
	'settings' => 'service_uniques_blocks',
	'priority'    => 193,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Sections', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 2,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(	
	'unique_heading'  => array(
				'label'    =>esc_attr__( 'Heading', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be the label of heading field', 'intechnic-lite' ),
				'section'  => 'services_unique',
				'type'     => 'text',
				'priority' => 194,
				'default'  => '', 
			),
	'unique_content'  => array(
			'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
			'description' => esc_attr__( 'This will be content field', 'intechnic-lite' ),
			'section'  => 'services_unique',
			'type'     => 'textarea',
			'priority' => 195,
			'default'  => '', 
		),
	'unique_button'  => array(
			'label'    =>esc_attr__( 'Button Text', 'intechnic-lite' ),
			'description' => esc_attr__( 'This will be button text', 'intechnic-lite' ),
			'section'  => 'services_unique',
			'type'     => 'textarea',
			'priority' => 196,
			'default'  => '', 
		),
	'unique_link'  => array(
			'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
			'description' => esc_attr__( 'This will be button link', 'intechnic-lite' ),
			'section'  => 'services_unique',
			'type'     => 'textarea',
			'priority' => 197,
			'default'  => '#', 
		),
	
	)
) );


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Contact Page  Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_panel( 'contact_page', array(
    'priority'    => 6,
    'title'       => __( 'Contact Page', 'intechnic-lite' ),
    'description' => __( 'Manage Contact page from here', 'intechnic-lite' ),
	) );


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Contact Page Banner Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'contact_banner', array(
		'title'          => __( 'Header Content Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage background image, Title and Text of header', 'intechnic-lite' ),
		'panel'          => 'contact_page', 
		'priority'       => 200,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
	'settings' => 'contact_banner_image',
	'label'    => __( 'Header Image', 'intechnic-lite' ),
	'section'  => 'contact_banner',
	'type'        => 'image',
	'priority' => 201,
	'default'  => get_template_directory_uri() . '/assets/images/about_banner.jpg',
		) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_banner_heading',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'contact_banner',
				'type'     => 'text',
				'priority' => 202,
				'default'  => 'WELCOME TO intechnic',
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_banner_title',
				'label'    => __( 'Sub Heading', 'intechnic-lite' ),
				'section'  => 'contact_banner',
				'type'     => 'text',
				'priority' => 203,
				'default'  => 'CONTACT US',
			) );
			
				
	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'contact_banner_text',
		'label'    => __( 'Content', 'intechnic-lite' ),
		'section'  => 'contact_banner',
		'type'     => 'textarea',
		'priority' => 204,
		'default'  => 'To help customers find businesses that genuinely provide <br>exceptional service, we personally check each business.',
		
	) );

		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Contact Page Form Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'contact_form', array(
		'title'          => __( 'Contact Form Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage contact page form section', 'intechnic-lite' ),
		'panel'          => 'contact_page', 
		'priority'       => 205,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_form_title',
				'label'    => __( 'Form Heading', 'intechnic-lite' ),
				'section'  => 'contact_form',
				'type'     => 'text',
				'priority' => 206,
				'default'  => 'Let\'s Talk about Your Business',
			) );
			
				
	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'contact7_code',
		'label'    => __( 'Contact 7 Code', 'intechnic-lite' ),
		'section'  => 'contact_form',
		'type'     => 'text',
		'priority' => 207,
		'default'  => '',
		
	) );

	Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'contact_form_submit',
			'label'    => __( 'Submit Button', 'intechnic-lite' ),
			'section'  => 'contact_form',
			'type'     => 'text',
			'priority' => 208,
			'default'  => 'Send Message',
		) );



		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Contact Page Contact details Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'contact_details_', array(
		'title'          => __( 'Contact Details Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage contact page details section', 'intechnic-lite' ),
		'panel'          => 'contact_page', 
		'priority'       => 210,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_details_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 211,
				'default'  => 'Get in Touch',
			) );
	
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_details_text',
				'label'    => __( 'Headline', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'textarea',
				'priority' => 212,
				'default'  => 'Tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse consequat.',
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_details_subheading',
				'label'    => __( 'Sub Heading', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 213,
				'default'  => 'The Office',
			) );
	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'contact_address_icon',
                'label'    => __( 'Address Icon', 'intechnic-lite' ),
                'section'  => 'contact_details_',
                'type'     => 'fontawesome',
                'priority' => 214,
                'default'  => 'fa fa-phone',
             
            ) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_address',
				'label'    => __( 'Address Heading', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 215,
				'default'  => 'Address:',
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_details_address',
				'label'    => __( 'Address Detail', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 216,
				'default'  => 'Regina ST, London, SK 8GH.',
			) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'contact_phone_icon',
                'label'    => __( 'Phone Icon', 'intechnic-lite' ),
                'section'  => 'contact_details_',
                'type'     => 'fontawesome',
                'priority' => 217,
                'default'  => 'fa fa-globe',
             
            ) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_phone',
				'label'    => __( 'Phone Heading', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 218,
				'default'  => 'Phone:',
			) );
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_details_phone',
				'label'    => __( 'Phone Details', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 219,
				'default'  => '(+44) 123 456 789',
			) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'contact_email_icon',
                'label'    => __( 'Email Icon', 'intechnic-lite' ),
                'section'  => 'contact_details_',
                'type'     => 'fontawesome',
                'priority' => 220,
                'default'  => 'fa fa-envelope',
             
            ) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_email',
				'label'    => __( 'Email Heading', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 221,
				'default'  => 'Email:',
			) );
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_details_email',
				'label'    => __( 'Email Heading', 'intechnic-lite' ),
				'section'  => 'contact_details_',
				'type'     => 'text',
				'priority' => 222,
				'default'  => 'email@youradress.com',
			) );

/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Contact Page Business Hours Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'contact_business', array(
		'title'          => __( 'Business Hours Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage contact page business hours section', 'intechnic-lite' ),
		'panel'          => 'contact_page', 
		'priority'       => 230,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'contact_business_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'contact_business',
				'type'     => 'text',
				'priority' => 231,
				'default'  => 'Business Hours',
			) );
			
	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'contact_business',
	'settings' => 'contact_business_hours',
	'priority'    => 232,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Business Hours', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 4,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new field"', 'intechnic-lite' ),
	
	'fields' => array(	
		'hours_fields'  => array(
				'label'    =>esc_attr__( 'Field', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be the label of business hours fields', 'intechnic-lite' ),
				'section'  => 'contact_business',
				'type'     => 'text',
				'priority' => 233,
				'default'  => '', 
			),
	)
) );


  		/*------------------------------------------
		Google Map Section	
  	------------------------------------------*/
	

	Kirki::add_section( 'homepage_googlemap', array(
		'title'          => __( 'Google Map Settings', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage Google Map', 'intechnic-lite' ),
		'panel'          => 'contact_page', 
		'priority'       => 240,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '', // Rarely needed.
	) );
 	
	/*------------------------------------------
		Add Fields to Google Map Section
	------------------------------------------*/
	 	
		// Switch
		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'google_map_active',
                'label'    => __( 'Google Map Active', 'intechnic-lite' ),
                'section'  => 'homepage_googlemap',
                'type'     => 'toggle',
                'priority' => 241,
                'default'  => 1,           
            ) );

		// Help
		Kirki::add_field( 'intechnic-lite', array(
			'type'        => 'custom',
			'settings'    => 'latlong_help',
			'default'     => '<strong>You Can find your Latitude and Long from here <a target="_blank" href="http://www.latlong.net/">http://www.latlong.net/</a> <br/> <br/> You need to get an Google map Api key in order to use map. You can get one from <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" > here </a> <strong>',
			'section'     => 'homepage_googlemap',
			'priority'    => 242,
		) );
		
		// Lat
		Kirki::add_field( 'intechnic-lite', array(
			'type'        => 'text',
			'settings'    => 'map_key',
			'description'    => __( 'You need to get an Google map Api key in order to use map.', 'intechnic-lite' ),
			'label'       => __( 'Your Google Map Key', 'intechnic-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 243,
			'default' 	  => ''
		) );
					
		// Lat
		Kirki::add_field( 'intechnic-lite', array(
			'type'        => 'text',
			'settings'    => 'map_lat',
			'label'       => __( 'Your Latitude', 'intechnic-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 244,
			'default' 	  => 27.175015
		) );
		
		// Long
		Kirki::add_field( 'intechnic-lite', array(
			'type'        => 'text',
			'settings'    => 'map_long',
			'label'       => __( 'Your Longitude', 'intechnic-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 245,
			'default' 	  => 78.042155
		) );
						

		// Long
		Kirki::add_field( 'intechnic-lite', array(
			'type'        => 'number',
			'settings'    => 'map_zoom',
			'label'       => __( 'Map Zoom', 'intechnic-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 246,
			'default' 	  => 12,
			'choices'     => array(
				'min'  => 0,
				'max'  => 30,
				'step' => 1,
			),
		) );



/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page  Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_panel( 'about_page', array(
    'priority'    => 7,
    'title'       => __( 'About Page', 'intechnic-lite' ),
    'description' => __( 'Manage about page from here', 'intechnic-lite' ),
	) );


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page Header Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'about_banner', array(
		'title'          => __( 'Header Content Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage background image, Title and Text of banner', 'intechnic-lite' ),
		'panel'          => 'about_page', 
		'priority'       => 250,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
	'settings' => 'about_banner_image',
	'label'    => __( 'Header Image', 'intechnic-lite' ),
	'section'  => 'about_banner',
	'type'        => 'image',
	'priority' => 251,
	'default'  => get_template_directory_uri() . '/assets/images/about_banner.jpg',
		) );

	Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'about_banner_heading',
			'label'    => __( 'Heading', 'intechnic-lite' ),
			'section'  => 'about_banner',
			'type'     => 'text',
			'priority' => 253,
			'default'  => 'Welcome To Intechnic',
		) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'about_banner_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'about_banner',
				'type'     => 'text',
				'priority' => 253,
				'default'  => 'ABOUT US?',
			) );
			
				
	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'about_banner_text',
		'label'    => __( 'Sub Heading', 'intechnic-lite' ),
		'section'  => 'about_banner',
		'type'     => 'textarea',
		'priority' => 254,
		'default'  => 'No hours sank into aggregating and cleaning data. No complex SQL queries required. Just the answers <br> teams need to make smarter decisions, fast. Now, that\'s data-driven.',
		
	) );

	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page About Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'aboutpage_about_section', array(
		'title'          => __( 'About Section Setting ', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage about section of about page', 'intechnic-lite' ),
		'panel'          => 'about_page', 
		'priority'       => 260,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'aboutsectiononeonoff',
                'label'    => __( 'Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'aboutpage_about_section',
                'type'     => 'toggle',
                'priority' => 261,
                'default'  => 1,           
            ) ); 

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_about_section_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'aboutpage_about_section',
				'type'     => 'textarea',
				'priority' => 262,
				'default'  => 'WE CREATE THE BEST VALUE FOR YOUR OWN',
			) );
			
				
	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'aboutpage_about_content',
		'label'    => __( 'Content', 'intechnic-lite' ),
		'section'  => 'aboutpage_about_section',
		'type'     => 'textarea',
		'priority' => 263,
		'default'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.',
		
	) );

	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'aboutpage_about_image',
		'label'    => __( 'Image', 'intechnic-lite' ),
		'section'  => 'aboutpage_about_section',
		'type'     => 'image',
		'priority' => 264,
		'default'  => get_template_directory_uri() . '/assets/images/about_images.jpg.jpg',
	) );


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page Capablities Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'aboutpage_capablities_section', array(
		'title'          => __( 'Capablities Section Setting ', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage about section of about page', 'intechnic-lite' ),
		'panel'          => 'about_page', 
		'priority'       => 270,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'aboutsectioncapablitiesonoff',
                'label'    => __( 'Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'aboutpage_capablities_section',
                'type'     => 'toggle',
                'priority' => 271,
                'default'  => 1,           
            ) ); 

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_capablities_section_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'aboutpage_capablities_section',
				'type'     => 'textarea',
				'priority' => 272,
				'default'  => 'WE CREATE THE BEST VALUE FOR YOUR OWN',
			) );
	
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutcapablitiespage_video_url',
				'label'    => __( 'Video URL', 'intechnic-lite' ),
				'section'  => 'aboutpage_capablities_section',
				'type'     => 'textarea',
				'priority' => 273,
				'default'  => 'https://www.youtube.com/embed/WVPRkcczXCY',
			) );

	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'aboutpage_capablities_section',
	'settings' => 'aboutpage_capablities_',
	'priority'    => 274,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Capablities', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 6,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
		'capablities_points'  => array(
				'label'    =>esc_attr__( 'Points', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Capablities field', 'intechnic-lite' ),
				'section'  => 'aboutpage_capablities_section',
				'type'     => 'textarea',
				'priority' => 275,
				'default'  => '', 
			),
	)
) );


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page What We Do Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'aboutpage_whatwedo_section', array(
		'title'          => __( 'What We Do Section Setting ', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage what we do section of about page', 'intechnic-lite' ),
		'panel'          => 'about_page', 
		'priority'       => 280,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'aboutsectionwhatwedosonoff',
                'label'    => __( 'Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'aboutpage_whatwedo_section',
                'type'     => 'toggle',
                'priority' => 281,
                'default'  => 1,           
            ) ); 

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_whatwedo_section_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'aboutpage_whatwedo_section',
				'type'     => 'textarea',
				'priority' => 282,
				'default'  => 'WHAT WE DO FOR YOU ',
			) );
	
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_whatwedo_section_content',
				'label'    => __( 'Content', 'intechnic-lite' ),
				'section'  => 'aboutpage_whatwedo_section',
				'type'     => 'textarea',
				'priority' => 283,
				'default'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry  it over 2000 years old.',
			) );

	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'aboutpage_whatwedo_section',
	'settings' => 'aboutpage_whatwedo_',
	'priority'    => 284,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('What We Do', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 6,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
		'whatwedo_image'  => array(
				'label'    =>esc_attr__( 'Image', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Image field', 'intechnic-lite' ),
				'section'  => 'aboutpage_whatwedo_section',
				'type'     => 'image',
				'priority' => 285,
				'default'  => '', 
			),
		'whatwedo_title'  => array(
				'label'    =>esc_attr__( 'Title', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be title field', 'intechnic-lite' ),
				'section'  => 'aboutpage_whatwedo_section',
				'type'     => 'textarea',
				'priority' => 286,
				'default'  => '', 
			),
		'whatwedo_content'  => array(
				'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be content field', 'intechnic-lite' ),
				'section'  => 'aboutpage_whatwedo_section',
				'type'     => 'textarea',
				'priority' => 287,
				'default'  => '', 
			),
	)
) );



/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page Testimonials Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'aboutpage_testimonials_section', array(
		'title'          => __( 'Testimonials Section Setting ', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage testimonials section of about page', 'intechnic-lite' ),
		'panel'          => 'about_page', 
		'priority'       => 290,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'aboutsectiontestimonialssonoff',
                'label'    => __( 'Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'aboutpage_testimonials_section',
                'type'     => 'toggle',
                'priority' => 291,
                'default'  => 1,           
            ) ); 


	
		Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'aboutpage_testimonial_image',
		'label'    => __( 'Left Image', 'intechnic-lite' ),
		'section'  => 'aboutpage_testimonials_section',
		'type'     => 'image',
		'priority' => 292,
		'default'  => get_template_directory_uri() . '/assets/images/testimonial-left.png',
	) );



	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_testimonial_section_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'aboutpage_testimonials_section',
				'type'     => 'textarea',
				'priority' => 293,
				'default'  => 'WHAT CLIENTS SAY ',
			) );
	
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_testimonial_section_content',
				'label'    => __( 'Content', 'intechnic-lite' ),
				'section'  => 'aboutpage_testimonials_section',
				'type'     => 'textarea',
				'priority' => 294,
				'default'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard',
			) );

	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'aboutpage_testimonials_section',
	'settings' => 'aboutpage_testimonials_',
	'priority'    => 295,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Testimonials', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 6,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
		'testimonials_image'  => array(
				'label'    =>esc_attr__( 'Image', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Image field', 'intechnic-lite' ),
				'section'  => 'aboutpage_testimonials_section',
				'type'     => 'image',
				'priority' => 296,
				'default'  => '', 
			),
		'testimonials_name'  => array(
				'label'    =>esc_attr__( 'Name', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be name field', 'intechnic-lite' ),
				'section'  => 'aboutpage_testimonials_section',
				'type'     => 'text',
				'priority' => 297,
				'default'  => '', 
			),
		'testimonials_content'  => array(
				'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be content field', 'intechnic-lite' ),
				'section'  => 'aboutpage_testimonials_section',
				'type'     => 'textarea',
				'priority' => 298,
				'default'  => '', 
			),
		'testimonials_designation'  => array(
				'label'    =>esc_attr__( 'Designation', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be designation field', 'intechnic-lite' ),
				'section'  => 'aboutpage_testimonials_section',
				'type'     => 'textarea',
				'priority' => 299,
				'default'  => '', 
			),
	)
) );


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page Our Team Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'aboutpage_ourteam_section', array(
		'title'          => __( 'Our Team Section Setting ', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage our team section of about page', 'intechnic-lite' ),
		'panel'          => 'about_page', 
		'priority'       => 300,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'aboutsectionourteamonoff',
                'label'    => __( 'Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'aboutpage_ourteam_section',
                'type'     => 'toggle',
                'priority' => 301,
                'default'  => 1,           
            ) ); 

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_ourteam_section_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 302,
				'default'  => 'Our Team ',
			) );
	
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'aboutpage_ourteam_section_subheading',
				'label'    => __( 'Sub Heading', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 303,
				'default'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard',
			) );

	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'aboutpage_ourteam_section',
	'settings' => 'aboutpage_ourteam_',
	'priority'    => 304,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Our Team', 'intechnic-lite' ),
	),
	'choices'     => array(
				'limit' => 6,
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
		'ourteam_image'  => array(
				'label'    =>esc_attr__( 'Image', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Image field', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'image',
				'priority' => 305,
				'default'  => '', 
			),
		'ourteam_name'  => array(
				'label'    =>esc_attr__( 'Name', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be name field', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'text',
				'priority' => 306,
				'default'  => '', 
			),
		'ourteam_designation'  => array(
				'label'    =>esc_attr__( 'Designation', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be designation field', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 307,
				'default'  => '', 
			),
		'ourteam_content'  => array(
				'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be content field', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 308,
				'default'  => '', 
			),
		'ourteam_fblink'  => array(
				'label'    =>esc_attr__( 'Facebook Link', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Facebook link field', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 309,
				'default'  => '#', 
			),
		'ourteam_twitterlink'  => array(
				'label'    =>esc_attr__( 'Twitter Link', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Twitter link field', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 310,
				'default'  => '#', 
			),
		'ourteam_instalink'  => array(
				'label'    =>esc_attr__( 'Instagram Link', 'intechnic-lite' ),
				'description' => esc_attr__( 'This will be Instagram link', 'intechnic-lite' ),
				'section'  => 'aboutpage_ourteam_section',
				'type'     => 'textarea',
				'priority' => 311,
				'default'  => '#', 
			),
	)
) );


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				About Page Partners Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'aboutpage_partners', array(
			'title'          => __( 'Partner Section Setting' , 'intechnic-lite' ),
			'description'    => __( '<h3>From here you can manage partners section of about page. If global partners section is set, it will get displayed before new partners section. You can either have global partners section or new partners section or both.</h3>', 'intechnic-lite' ),
			'panel'          => 'about_page', 
			'priority'       => 312,
			'capability'     => 'edit_theme_options',
		) );

		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'about_partner_section_onoff',
                'label'    => __( 'Partner Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'aboutpage_partners',
                'type'     => 'toggle',
                'priority' => 313,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'about_global_partner_onoff',
                'label'    => __( 'Global Partners Images Show/Hide', 'intechnic-lite' ),
                'section'  => 'aboutpage_partners',
                'type'     => 'toggle',
                'priority' => 314,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'about_partner_sectiononoff',
                'label'    => __( 'New Partners Images Show/Hide', 'intechnic-lite' ),
                'section'  => 'aboutpage_partners',
                'type'     => 'toggle',
                'priority' => 315,
                'default'  => 1,           
            ) );


	Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'intechnic-lite' ),
	'section'     => 'aboutpage_partners',
	'settings' => 'aboutpage_partners_',
	'priority'    => 316,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Partner', 'intechnic-lite' ),
	),
	'choices'     => array(
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

	
	'fields' => array(
		'about_partner_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Partner Image', 'intechnic-lite' ),
				'section'     => 'aboutpage_partners',
				'priority'    => 317,
				'default'  => '',
				
			),	
			)
		) );	



/*--------------------
-------------------
About Page Modules Reorder
-----------------------------------------*/
	
Kirki::add_section( 'aboutpage_reordering_modules', array(
	'title'          => __( 'Modules order', 'intechnic-lite' ),
	'description'    => __( 'From here you can manage re-ordering of the about page content', 'intechnic-lite' ),
	'panel'          => 'about_page', 
	'priority'       => 318,
	'capability'     => 'edit_theme_options',
) ); 


Kirki::add_field( 'intechnic-lite', array(
	'type'        => 'sortable',
	'settings'    => 'aboutpage_modules',
	'label'       => esc_attr__( 'Modules', 'intechnic-lite' ),
	'section'     => 'aboutpage_reordering_modules',
	'default'     => array('aboutpageaboutus' , 'aboutpagecapablities' , 'aboutpagewhatwedo' , 'aboutpagetestimonials', 'aboutpageourteam', 'aboutpagepartner'),
	'priority'    => 319,
	'choices'     => array(
		'aboutpageaboutus' => esc_attr__('About Section', 'intechnic-lite'),
		'aboutpagecapablities' => esc_attr__('Capablities Section', 'intechnic-lite'),
		'aboutpagewhatwedo' => esc_attr__('What We Do Section', 'intechnic-lite'),
		'aboutpagetestimonials' => esc_attr__('Testimonials Section', 'intechnic-lite'), 
		'aboutpageourteam' => esc_attr__('Our Team Section', 'intechnic-lite'), 
		'aboutpagepartner' => esc_attr__('Partners Section', 'intechnic-lite'),  
	),
) );



