<?php
/**
 * This file is responsible for the rendering of the header of the theme.
 * @version:1.0
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>
    <?php
    if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
    wp_head();
    ?>
</head>
<body <?php body_class(); ?>" id="top">

   <!-- Collect the nav links, forms, and other content for toggling -->
  <?php
            $layout = maybe_unserialize(get_theme_mod( 'homepage_modules', 
                                    array( 
                                        'aboutsectionone',
                                        'partner', 
                                        'aboutsectiontwo' , 
                                        'services',
                                        'aboutsectionthree', 
                                        'process', 
                                        'pricing',
                                        'testimonials'
                                      ) ) ); 
  
          
            $modules = array( 
    
                  'aboutsectionone' =>array(
                    'show' => get_theme_mod('showin_menu_welcome', 1), 
                    'text' => get_theme_mod('welcome_menu_title', 'Aboutsectionone'),
                    'link' => '#aboutsectionone'
                  ), 
                  
                  'partner' =>array(
                    'show' => get_theme_mod('showin_menu_welcome', 1), 
                    'text' => get_theme_mod('welcome_menu_title', 'Partner'),
                    'link' => '#partner'
                  ), 

                  'aboutsectiontwo' =>array(
                    'show' => get_theme_mod('showin_menu_pages', 1), 
                    'text' => get_theme_mod('pages_menu_title', 'Aboutsectiontwo'),
                    'link' => '#aboutsectiontwo'
                  ), 
   
                  'services' =>array(
                    'show' => get_theme_mod('showin_menu_portfolio', 1), 
                    'text' => get_theme_mod('portfolio_menu_title', 'Services'),
                    'link' => '#services'
                  ), 
                  
                  'aboutsectionthree' =>array(
                    'show' => get_theme_mod('showin_menu_team', 1), 
                    'text' => get_theme_mod('team_menu_title', 'Aboutsectionthree'),
                    'link' => '#aboutsectionthree'
                  ),
    
                  'process' =>array(
                    'show' => get_theme_mod('showin_menu_statistics', 1), 
                    'text' => get_theme_mod('statistics_menu_title', 'Process'), 
                    'link' => '#process'
                  ),

                  'pricing' =>array(
                    'show' => get_theme_mod('showin_menu_statistics', 1), 
                    'text' => get_theme_mod('statistics_menu_title', 'Pricing'), 
                    'link' => '#pricing'
                  ),

                  'testimonials' =>array(
                    'show' => get_theme_mod('showin_menu_statistics', 1), 
                    'text' => get_theme_mod('statistics_menu_title', 'Testimonials'), 
                    'link' => '#testimonials'
                  ),
            );
          ?>

  <?php if(is_page_template('templates/page-services.php')) : ?>
    <div class="service-bg-banner-img" style="background-image: url(<?php echo get_theme_mod('service_banner_image', get_template_directory_uri() . '/assets/images/banner_service.jpg');?>);">
  <?php elseif(is_page_template('templates/page-contact.php')) : ?>
   <div class="contact-bg-banner-img" style="background-image: url(<?php echo get_theme_mod('contact_banner_image', get_template_directory_uri() . '/assets/images/about_banner.jpg'); ?>);">
   <?php elseif(is_page_template('templates/page-about.php')) : ?>
   <div class="about-bg-banner-img" style="background-image: url(<?php echo get_theme_mod('about_banner_image', get_template_directory_uri() . '/assets/images/about_banner.jpg'); ?>);">
    <?php else: ?>
      <div class="bg-grediunt">
         <div class="bg-banner-img" style="background-image: url(<?php echo get_theme_mod('banner_image', get_template_directory_uri() . '/assets/images/banner-img.jpg'); ?>);">
          <?php endif; ?>
            <div class="overlay-all">
               <!-- Header_Area -->
               <!-- header
                  ================================================== -->
               <header class="s-header">
                  <div class="header-logo">
                     <a class="navbar-brand logo-biss" href="<?php echo site_url(); ?>"> 
                        <?php if(get_theme_mod('sitelogo')){ 
                            $logo= (get_theme_mod('sitelogo'));  
                            ?> 
                            <img height="50"  alt="<?php bloginfo('name'); ?>" src="<?php echo $logo; ?>">
                        <?php } else { bloginfo('name'); } ?>
                     </a>
                  </div>
                  <!-- end header-logo -->
                  <nav class="header-nav">
                     <a href="#0" class="header-nav__close" title="close"><span>Close</span></a>
                     <div class="header-nav__content">
                        <h3><?php bloginfo('name'); ?></h3>
                        
                          <?php  if ( has_nav_menu( 'primary' ) ) { 
                              $menu = wp_nav_menu( 
                                array( 
                                'theme_location' => 'primary',
                                'echo' => FALSE, 
                                'items_wrap'=> '<ul id="%1$s" class="header-nav__list">%3$s</ul>', 
                                'container' => 'none', 
                                'fallback_cb'    => '__return_false'
                                ) ); 
                              } 
                              if ( ! empty ( $menu ) )
                                {
                                     echo $menu;
                                }
                                 else{
                                  if (current_user_can('update_core')) :   _e( __( '<h5 class="menuwarning">Menu Doesn\'t exists, please set a menu. (Only You (admin) can see this.)</h5>', 'intechnic-lite' )); endif;
                                }
                              ?>

                        
                        <ul class="header-nav__social">

                          <?php if ( true == get_theme_mod( 'navfacebookonoff', true ) ) : ?>
                           <li>
                              <a href="<?php _e(get_theme_mod('nav_social_facebook', __('#' , 'intechnic-lite'))); ?>" target="_blank"><i  class="fa fa-facebook-square fa-3x social"></i></a>
                           </li>
                          <?php endif; ?>

                          <?php if ( true == get_theme_mod( 'navtwitteronoff', true ) ) : ?>
                           <li>
                              <a href="<?php _e(get_theme_mod('nav_social_twitter', __('#' , 'intechnic-lite'))); ?>" target="_blank"><i  class="fa fa-twitter-square fa-3x social"></i></a>
                           </li>
                           <?php endif; ?>

                           <?php if ( true == get_theme_mod( 'navinstagramonoff', true ) ) : ?>
                           <li>
                              <a href="<?php _e(get_theme_mod('nav_social_instagram', __('#' , 'intechnic-lite'))); ?>" target="_blank"><i  class="fa fa-instagram fa-3x social"></i></a>
                           </li>
                           <?php endif; ?>

                            <?php if ( true == get_theme_mod( 'navlinkedinonoff', true ) ) : ?>
                           <li>
                              <a href="<?php _e(get_theme_mod('nav_social_linkedin', __('#' , 'intechnic-lite'))); ?>"><i class="fa fa-linkedin-square fa-3x social"></i></a>
                           </li>
                           <?php endif; ?>

                        </ul>
                     </div>
                     <!-- end header-nav__content -->
                  </nav>
                  <!-- end header-nav -->
                  <a class="header-menu-toggle" href="#0">
                  <span class="header-menu-icon"></span>
                  </a>
               </header>
               <!-- end s-header -->
               <!-- End Header_Area -->
              