<?php
/**
	This File handles Customizer Options
	* @version:1.0
*/

//include_once( 'admin/kirki/kirki.php' );


// Early exit if Kirki is not installed
if ( ! class_exists( 'Kirki' ) ) {
	return;
}
 
/**
 * Configuration sample for the Kirki Customizer.
 */
function navthemes_configuration() {

	$args = array(
		'logo_image'   => 'http://navthemes.com/branding/inthemes/logo.png',
		'url_path' => get_stylesheet_directory_uri() . '/admin/kirki/'
   );

	return $args;

}

add_filter( 'kirki/config', 'navthemes_configuration' );


/*=================================
	Priorities-

* NavThemes Branding  - 10 
* Sample Content      - 11
* General settings    - 20-37
* Front page          - 40-142
* Addons              - 150-319
* Global Partners     - 320-322
* Global Testimonials - 330-338
* Call To Action      - 340-345

================================= */


/*=================================
	Panels Priorities-

* NavThemes Branding  - 1 
* Sample Content      - 2
* General Settings    - 3
* Front Page          - 4
* Addons              - 5-7
* Global Partners     - 8
* Global Testimonials - 9
* Call To Action      - 10
================================= */


/*=================================
	Config	
  ================================= */

Kirki::add_config( 'intechnic-lite', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
 	
) );

	/*------------------------------------------
     NavThemes Branding
     ------------------------------------------*/

     $theme = wp_get_theme();
	 $theme_version = $theme->get( 'Version' );
	 $theme_name = $theme->get( 'Name' );
 
  Kirki::add_section( 'NavThemes_Support', array(
			'title'          => __( 'NavThemes Support', 'navthemes' ),
			'description'    => sprintf( 'You are using Free version of %s Theme, Check out Paid version, which comes with many exciting features in the package.', __($theme->Name, 'navthemes','intechnic-lite') ),
			'priority'       => 1,
	) );
			
 
		Kirki::add_field( 'navthemes', array(
		'type'        => 'custom',
		'settings'     => 'navthemes_support',
		'section'     => 'NavThemes_Support',
		'default'     => sprintf( '<div id="navthemes_branding"><h1>Get Premium Version of %s for Just $59</h1>
			<div class="navthemes-links">
			<ul>
				<li><a target="_blank" href="%s">Check out All Features of Paid version</a></li>
				<li><a target="_blank" href="%s">View Demo</a></li>
			</ul> 
		</div>
		</div>', __($theme->Name, 'navthemes','intechnic-lite'), 'https://www.navthemes.com/wp-themes/intechnic-pro-wordpress-themes/' , 'http://demo.navthemes.com/?demo=intechnic-pro' ),
		'priority'    => 10,
	) );    



/*------------------------------------------
    Maintenance Service
    ------------------------------------------*/

Kirki::add_section( 'NavThemes_Maintenance_Service', array(
            'title'          => __( 'Maintenance Service', 'navthemes' ),
            'description'    => sprintf( '<h1> Managing WordPress Site is a hassle ? Let us handle that.

</h1>', __($theme->Name, 'navthemes','intechnic-lite') ),
            'priority'       => 1,
    ) );
            

        Kirki::add_field( 'navthemes', array(
        'type'        => 'custom',
        'settings'     => 'navThemes_maintenance_service',
        'section'     => 'NavThemes_Maintenance_Service',
        'default'     => sprintf( '<div id="navthemes_maintenance">
        <div class="themeisle-upsell"> 
        <h1>**Key Features**</h1>
            <h3>FREE Lightning Fast Hosting <span class="color_span" ><br>This is a Google Ranking factor. </span></h3>
            <h3>FREE SSL Certificate   <span class="color_span"> <br>This is a Google Ranking factor. </span></h3> 
            <h3>24/7 Uptime monitoring</h3>
            <h3>Access All NavThemes Premium WordPress Themes and Plugins</h3>
            <h3>Free Migration Service to our hosting</h3>
            <h3>Free CDN Service</h3>
            <h3>Unlimited Website Edits</h3>
            <h3>Hack/Malware Removal</h3>
            <h3>Weekly Website Report</h3>
            <div class="navthemes-links">
            <ul>
            <li>

            <a target="_blank" href="http://navthemes.com/wordpress-management-service/?utm_source=intechnic-lite&utm_medium=lite-wordpress-theme&utm_campaign=customizer&utm_term=maintenance-service" class="button button-primary button_70">Starting at just $39/Month</a>
          </li>

                
            </ul>
            </div>
        </div>
        </div>', __($theme->Name, 'navthemes','intechnic-lite'), 'https://www.navthemes.com/free-wordpress-theme/intechnic-pro-wordpress-theme/'),
        'priority'    => 11,
    ) );








/*=================================
		Sample Content	
	  ================================= */
	
	Kirki::add_section( 'required_settings', array(
		'title'          => __( 'Sample Content', 'intechnic-lite' ), 
		'priority'       => 2,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'section'  => 'required_settings',
				'type'     => 'custom',
				'priority' => 10,
				'default'  =>sprintf('<div><h3>Once you have installed and activated all recommended plugins, to setup your theme look like demo, Please download  <a target="_blank" href="%s">this</a> file and import it in cusomizer export import.<br/><br/> if you not sure how to do that, Please check this <a target="_blank" href="%s">tutorial</a></h3>
		</div>
		<div id="navthemes_maintenance">
		 <a target="_blank" href="https://docs.navthemes.com/docs/intechnic-lite" class="button button-primary button_70">Documentation</a>
		 </div>', 'https://docs.navthemes.com/download/1308/', 'https://docs.navthemes.com/docs/intechnic-lite/sample-content/' ),
		'priority'    => 12,
	) );    









/*--------------------------------------------------------------------------
  --------------------------------------------------------------------------
			General Settings
--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
			
		
	Kirki::add_panel( 'general_settings', array(
		'priority'    => 3,
		'title'       => __( 'General Settings', 'intechnic-lite' ),
		'description' => __( 'Manage General Setting from here', 'intechnic-lite' ),
	) );
	
	/*=================================
		General Section	
  	================================= */
  	
  	/*=================================
	Banner Image setting	
  ================================= */

	Kirki::add_section( 'banner_image', array(
		'title'          => __( 'Header Image', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage background image of header', 'intechnic-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 20,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'banner_image',
		'label'    => __( 'Header Image', 'intechnic-lite' ),
		'section'  => 'banner_image',
		'type'        => 'image',
		'priority' => 21,
		'default'  => get_template_directory_uri() . '/assets/images/banner-img.jpg',
	) );




	/*=================================
		Site Logo 	
  	================================= */


		Kirki::add_section( 'logo_settings', array(
			'title'          => __( 'Logo Settings', 'intechnic-lite' ),
			'description'    => __( 'From Here You Can Manage Manage Settings' , 'intechnic-lite' ),
			'panel'          => 'general_settings', 
			'priority'       => 22,
			'capability'     => 'edit_theme_options', 
		) );
	
		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'sitelogo',
				'label'    => __( 'Logo', 'intechnic-lite' ),
				'section'  => 'logo_settings',
				'type'     => 'image',
				'priority' => 23,
				'default'  => '',
			 
			) );

		/*=================================
		Navigation social Section	
  	================================= */

	Kirki::add_section( 'nav_social_settings', array(
		'title'          => __( 'Navigation Social Settings', 'intechnic-lite' ),
		'description'    => __( 'From Here You Can Manage Navigation Social Settings' , 'intechnic-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 24,
		'capability'     => 'edit_theme_options', 
	) );
		
		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'navfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'intechnic-lite' ),
                'section'  => 'general_settings',
                'type'     => 'toggle',
                'priority' => 25,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'nav_social_facebook',
				'label'    => __( 'Facebook', 'intechnic-lite' ),
				'section'  => 'general_settings',
				'type'     => 'url',
				'priority' => 26,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'navtwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'intechnic-lite' ),
                'section'  => 'general_settings',
                'type'     => 'toggle',
                'priority' => 27,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'nav_social_twitter',
				'label'    => __( 'Twiiter', 'intechnic-lite' ),
				'section'  => 'general_settings',
				'type'     => 'url',
				'priority' => 28,
				'default'  => '#',
			) );


		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'navinstagramonoff',
                'label'    => __( 'Instagram Active/Inactive', 'intechnic-lite' ),
                'section'  => 'general_settings',
                'type'     => 'toggle',
                'priority' => 29,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'nav_social_instagram',
				'label'    => __( 'Instagram', 'intechnic-lite' ),
				'section'  => 'general_settings',
				'type'     => 'url',
				'priority' => 30,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'navlinkedinonoff',
                'label'    => __( 'Linkedin Active/Inactive', 'intechnic-lite' ),
                'section'  => 'general_settings',
                'type'     => 'toggle',
                'priority' => 30,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'nav_social_linkedin',
				'label'    => __( 'Linkedin', 'intechnic-lite' ),
				'section'  => 'general_settings',
				'type'     => 'url',
				'priority' => 30,
				'default'  => '#',
			) );


		/*=================================
		Footer social Section	
  	================================= */

	Kirki::add_section( 'social_settings', array(
		'title'          => __( 'Footer Social Settings', 'intechnic-lite' ),
		'description'    => __( 'From Here You Can Manage Some Social Settings' , 'intechnic-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 31,
		'capability'     => 'edit_theme_options', 
	) );
		
		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'footerfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'intechnic-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 32,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'social_facebook',
				'label'    => __( 'Facebook', 'intechnic-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 33,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'footertwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'intechnic-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 34,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'social_twitter',
				'label'    => __( 'Twiiter', 'intechnic-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 35,
				'default'  => '#',
			) );


		Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'footerinstagramonoff',
                'label'    => __( 'Instagram Active/Inactive', 'intechnic-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 36,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'social_instagram',
				'label'    => __( 'Instagram', 'intechnic-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 37,
				'default'  => '#',
			) );
	
		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Footer Text Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'footer_text', array(
		'title'          => __( 'Footer Copyright Text Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage text of footer', 'intechnic-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 41,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'footer_theme_text',
				'label'    => __( 'Field', 'intechnic-lite' ),
				'section'  => 'footer_text',
				'type'     => 'textarea',
				'priority' => 42,
				'default'  => '',
			) );	

/*=================================
	Home Page Panel	
  ================================= */

	Kirki::add_panel( 'homepage', array(
		'priority'    => 4,
		'title'       => __( 'Front Page Settings', 'intechnic-lite' ),
		'description' => __( 'Manage Front Page Setting from here', 'intechnic-lite' ),
	) );
	

		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Header Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'homepage_banner', array(
		'title'          => __( 'Header Content Setting', 'intechnic-lite' ),
		'description'    => __( 'From here you can manage Title and Text of Header', 'intechnic-lite' ),
		'panel'          => 'homepage', 
		'priority'       => 1,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'banner_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 41,
				'default'  => '',
			) );
			
				
			Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'banner_text1',
				'label'    => __( 'Sub Heading', 'intechnic-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'textarea',
				'priority' => 42,
				'default'  => '',
				
			) );

			Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_video_url',
				'label'    => __( 'Video URL', 'intechnic-lite' ),
				'description'    => __( 'Copy YouTube video URL here. Only YouTube video is supported.' , 'intechnic-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'textarea',
				'priority' => 43,
				'default'  => '#', 
				
			) );

			Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepagebuttonbanneronoff',
                'label'    => __( 'Button ON/OFF', 'intechnic-lite' ),
                'section'  => 'homepage_banner',
                'type'     => 'toggle',
                'priority' => 44,
                'default'  => 1,           
            ) );

	 	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'button_text',
				'label'    => __( 'Button Text', 'intechnic-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 45,
				'default'  => '',
				
			) );
	 	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'button_link',
                'label'    => __( 'Button Link', 'intechnic-lite' ),
                'section'  => 'homepage_banner',
                'type'     => 'text',
                'priority' => 46,
                'default'  => '#services', 
            ) );

	 		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Partners Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_partners', array(
			'title'          => __( 'Partner Section Setting' , 'intechnic-lite' ),
			'description'    => __( 'Partner Section Heading', 'intechnic-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 3,
			'capability'     => 'edit_theme_options',
		) );


		Kirki::add_field( 'intechnic-lite', array(
					'settings' => 'homepage_partner_title',
					'label'    => __( 'Heading', 'intechnic-lite' ),
					'section'  => 'homepage_partners',
					'type'     => 'text',
					'priority' => 63,
					'default'  => '',
				) );
				
					
		Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'homepage_partner_content',
			'label'    => __( 'Content', 'intechnic-lite' ),
			'section'  => 'homepage_partners',
			'type'     => 'textarea',
			'priority' => 64,
			'default'  => '',
			
		) );



		Kirki::add_field( 'intechnic-lite', array(
	        'settings' => 'homepagepartnerbuttononoff',
	        'label'    => __( 'Button ON/OFF', 'intechnic-lite' ),
	        'section'  => 'homepage_partners',
	        'type'     => 'toggle',
	        'priority' => 67,
	        'default'  => 1,           
	    ) );

	 	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_partner_button',
				'label'    => __( 'Button Text', 'intechnic-lite' ),
				'section'  => 'homepage_partners',
				'type'     => 'text',
				'priority' => 68,
				'default'  => '',
				
			) );
	 	
	 	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepage_partners_button_link',
                'label'    => __( 'Button Link', 'intechnic-lite' ),
                'section'  => 'homepage_partners',
                'type'     => 'text',
                'priority' => 69,
                'default'  => '#', 
            ) );


		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page About Section 1
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
	

		Kirki::add_section( 'homepage_aboutone', array(
			'title'          => __( 'About Section One', 'intechnic-lite' ),
			'description'    => __( 'From here you can manage about section 1', 'intechnic-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 2,
			'capability'     => '',
		) );

			Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepage_aboutone_bgimage',
                'label'    => __( 'Background Image', 'intechnic-lite' ),
                'section'  => 'homepage_aboutone',
                'type'     => 'image',
                'priority' => 51,
                'default'  => get_template_directory_uri() . '/assets/images/about-bg-right.jpg',
		) );

		Kirki::add_field( 'intechnic-lite', array(
					'settings' => 'homepage_aboutone_title',
					'label'    => __( 'Heading', 'intechnic-lite' ),
					'section'  => 'homepage_aboutone',
					'type'     => 'text',
					'priority' => 52,
					'default'  => '',
				) );

		Kirki::add_field( 'intechnic-lite', array(
					'settings' => 'homepage_aboutone_subheading',
					'label'    => __( 'Sub Heading', 'intechnic-lite' ),
					'section'  => 'homepage_aboutone',
					'type'     => 'text',
					'priority' => 53,
					'default'  => '',
				) );
				
					
		Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'homepage_aboutone_content',
			'label'    => __( 'Content', 'intechnic-lite' ),
			'section'  => 'homepage_aboutone',
			'type'     => 'textarea',
			'priority' => 54,
			'default'  => '',
			
		) );

			Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepageaboutoneonoff',
                'label'    => __( 'Button ON/OFF', 'intechnic-lite' ),
                'section'  => 'homepage_aboutone',
                'type'     => 'toggle',
                'priority' => 55,
                'default'  => 1,           
            ) );

	 	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_aboutone_button',
				'label'    => __( 'Button Text', 'intechnic-lite' ),
				'section'  => 'homepage_aboutone',
				'type'     => 'text',
				'priority' => 56,
				'default'  => '',
				
			) );
	 	
	 	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'homepage_aboutone_button_link',
                'label'    => __( 'Button Link', 'intechnic-lite' ),
                'section'  => 'homepage_aboutone',
                'type'     => 'text',
                'priority' => 57,
                'default'  => '#services', 
            ) );



/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Process Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
	

		Kirki::add_section( 'homepage_process', array(
			'title'          => __( 'Process Section', 'intechnic-lite' ),
			'description'    => __( 'From here you can manage home page process section', 'intechnic-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 6,
			'capability'     => 'edit_theme_options',
		) );


		Kirki::add_field( 'intechnic-lite', array(
				'type'        => 'repeater',
				'label'       => esc_attr__( 'Process Section', 'intechnic-lite' ),
				'section'     => 'homepage_process',
				'settings' => 'home_process_',
				'priority'    => 101,
				
				'row_label' => array(
					'type' => 'text',
					'value' => esc_attr__('Process Section', 'intechnic-lite' ),
				),
				'choices'     => array(
							'limit' => 4,
							'save_as' => 'array',
							),

				'button_label' => esc_attr__('"Add new"', 'intechnic-lite' ),

				
				'fields' => array(
				'process_image'  => array(
					'type' => 'image',
					'label'       => esc_attr__( 'Left Image', 'intechnic-lite' ),
					'section'     => 'homepage_process',
					'priority'    => 102,
					'default'  => '',
							
				),
				'process_heading'  => array(
					'label'    =>esc_attr__( 'Heading', 'intechnic-lite' ),
					'description' => esc_attr__( 'This will be the label of heading field', 'intechnic-lite' ),
					'section'  => 'homepage_process',
					'type'     => 'text',
					'priority' => 103,
					'default'  => '', 
				),
				'process_content'  => array(
					'label'    =>esc_attr__( 'Content', 'intechnic-lite' ),
					'description' => esc_attr__( 'This will be the label of content field', 'intechnic-lite' ),
					'section'  => 'homepage_process',
					'type'     => 'textarea',
					'priority' => 104,
					'default'  => '', 
				),
				'process_button'  => array(
					'label'    =>esc_attr__( 'Button Text', 'intechnic-lite' ),
					'description' => esc_attr__( 'This will be the label of button text field', 'intechnic-lite' ),
					'section'  => 'homepage_process',
					'type'     => 'text',
					'priority' => 105,
					'default'  => '', 
				),
				'process_button_link'  => array(
					'label'    =>esc_attr__( 'Link', 'intechnic-lite' ),
					'description' => esc_attr__( 'This will be button link', 'intechnic-lite' ),
					'section'  => 'homepage_process',
					'type'     => 'text',
					'priority' => 106,
					'default'  => '#', 
				),
				'process_right_image'  => array(
							'type' => 'image',
							'label'       => esc_attr__( 'Right Image', 'intechnic-lite' ),
							'section'     => 'homepage_process',
							'priority' => 107,
							'default'  => '',
							
				),
				'process_title'  => array(
					'label'    =>esc_attr__( 'Right Button Text', 'intechnic-lite' ),
					'description' => esc_attr__( 'This will be title', 'intechnic-lite' ),
					'section'  => 'homepage_process',
					'type'     => 'text',
					'priority' => 108,
					'default'  => '', 
				),						
				)
			) );


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Plan Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
	Kirki::add_section( 'homepage_plan', array(
			'title'          => __( 'Plans Section Setting' , 'intechnic-lite' ),
			'description'    => __( 'From here you can manage Home Page plans section' , 'intechnic-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 6,
			'capability'     => 'edit_theme_options',
		) );
	Kirki::add_field( 'intechnic-lite', array(
                'settings' => 'plansonoff',
                'label'    => __( 'Section ON/OFF', 'intechnic-lite' ),
                'section'  => 'homepage_plan',
                'type'     => 'toggle',
                'priority' => 111,
                'default'  => 1,           
            ) );
	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_plan_title',
				'label'    => __( 'Heading', 'intechnic-lite' ),
				'section'  => 'homepage_plan',
				'type'     => 'textarea',
				'priority' => 112,
				'default'  => __('', 'intechnic-lite'), 
			  
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_plan_subheading',
				'label'    => __( 'Sub Heading', 'intechnic-lite' ),
				'section'  => 'homepage_plan',
				'type'     => 'textarea',
				'priority' => 113,
				'default'  => __('', 'intechnic-lite'), 
			  
			) );

	Kirki::add_field( 'intechnic-lite', array(
				'settings' => 'homepage_plan_content',
				'label'    => __( 'Content', 'intechnic-lite' ),
				'section'  => 'homepage_plan',
				'type'     => 'textarea',
				'priority' => 114,
				'default'  => __('', 'intechnic-lite'), 
			  
			) );

		Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'homepage_plan_content',
			'label'    => __( 'Content', 'intechnic-lite' ),
			'section'  => 'homepage_plan',
			'type'     => 'textarea',
			'priority' => 115,
			'default'  => __('', 'intechnic-lite'), 
		  
		) );

		Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'homepage_plan_monthly',
			'label'    => __( 'Monthly ', 'intechnic-lite' ),
			'section'  => 'homepage_plan',
			'type'     => 'textarea',
			'priority' => 116,
			'default'  => __('', 'intechnic-lite'), 
		  
		) );

		Kirki::add_field( 'intechnic-lite', array(
		'settings' => 'homepage_plan_yearly',
		'label'    => __( 'Yearly', 'intechnic-lite' ),
		'section'  => 'homepage_plan',
		'type'     => 'textarea',
		'priority' => 117,
		'default'  => __('', 'intechnic-lite'), 
		  
		) );

		Kirki::add_field( 'intechnic-lite', array(
			'settings' => 'homepage_plan_yearly_content',
			'label'    => __( 'Note', 'intechnic-lite' ),
			'section'  => 'homepage_plan',
			'type'     => 'textarea',
			'priority' => 118,
			'default'  => __('', 'intechnic-lite'), 
		  
		) );



add_action( 'customize_register', 'navthemes_move_widget_area' );
function navthemes_move_widget_area () {
  global $wp_customize;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section9 = (object) $wp_customize->get_section( 'sidebar-widgets-about_widgets_' );
  // homepage - Panel ID 
  $footer_widgets_section9->panel = 'homepage';
  $footer_widgets_section9->priority = 4;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section10 = (object) $wp_customize->get_section( 'sidebar-widgets-about_widgets__' );
  // homepage - Panel ID 
  $footer_widgets_section10->panel = 'homepage';
  $footer_widgets_section10->priority = 4;
  
  // sidebar-2 is your sidebar ID
  $footer_widgets_section2 = (object) $wp_customize->get_section( 'sidebar-widgets-testimonials_widgets' );
  // homepage - Panel ID 
  $footer_widgets_section2->panel = 'homepage';
  $footer_widgets_section2->priority = 9;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section3 = (object) $wp_customize->get_section( 'sidebar-widgets-partner_widget_' );
  // homepage - Panel ID 
  $footer_widgets_section3->panel = 'homepage';
  $footer_widgets_section3->priority = 4;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section5 = (object) $wp_customize->get_section( 'sidebar-widgets-call_action_widget' );
  // general_settings - Panel ID 
  $footer_widgets_section5->panel = '';
  $footer_widgets_section5->priority = 17;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-services_widget_' );
  // homepage - Panel ID 
  $footer_widgets_section6->panel = 'homepage';
  $footer_widgets_section6->priority = 5;

 
  // sidebar-2 is your sidebar ID
  $footer_widgets_section11 = (object) $wp_customize->get_section( 'sidebar-widgets-plan_widget_' );
  // homepage - Panel ID 
  $footer_widgets_section11->panel = 'homepage';
  $footer_widgets_section11->priority = 8;

}