<?php
 /*--------------------------------------------------------------------------------
  _   _                   _______   _                                     
 | \ | |                 |__   __| | |                                    
 |  \| |   __ _  __   __    | |    | |__     ___   _ __ ___     ___   ___ 
 |     |  / _  | \ \ / /    | |    | '_ \   / _ \ | '_ ` _ \   / _ \ / __|
 | |\  | | (_| |  \ V /     | |    | | | | |  __/ | | | | | | |  __/ \__ \
 |_| \_|  \__,_|   \_/      |_|    |_| |_|  \___| |_| |_| |_|  \___| |___/
                                                                          
                                                                          
----------------------------------------------------------------------------------*/ 
?>


<?php
/**
 * The main theme functions file loads styles/scripts, allows some theme functionality and provides some helper functions.
 * @version:2.0
 */
/**
 * This theme only works in WordPress 4.2 or later.
 */


if ( version_compare( $GLOBALS['wp_version'], '4.2', '<' ) ) {
    require get_template_directory() . '/inc/back-compat.php';
}

/*----------------------------------------------------------------
    Content Width
 -----------------------------------------------------------------*/

if ( ! isset( $content_width ) ) $content_width = 1140;


/*----------------------------------------------------------------
    TGMPA Activation.
 -----------------------------------------------------------------*/
require_once(get_template_directory() . '/inc/tgm_activation/tgm.php');


/*----------------------------------------------------------------
    Path Function.
 -----------------------------------------------------------------*/

function getAssetsPath($path) {
    return get_template_directory_uri().$path;
}

function image($name) {
    return getAssetsPath('/assets/images/'.$name);
}


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 *
 * Create your own intechnic_setup function to override in a child theme.
 *
 * @version Intechnic-lite 2.0
 */

function intechnic_lite_setup(){

    /*------------------------------
         * Register Navigation 
    --------------------------------*/
    //Navigation Menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'intechnic-lite')
    ));

    /*---------------------------------------------------
         Theme Supports.
     ----------------------------------------------------*/

    //Add featured image support
    add_theme_support('post-thumbnails');

    //This feature enables plugins and themes to manage the document title tag.
    add_theme_support('title-tag');
    //This feature adds RSS feed links to HTML <head>.
    add_theme_support( 'automatic-feed-links' );
 
    add_theme_support('post-thumbnails');
    set_post_thumbnail_size( 300, 250, true );
    add_image_size( 'small-thumb', 200, 200);
    add_image_size( 'video-logo', 90, 90, true );
    add_image_size( 'medium-photo', 500, 500, true );
    add_image_size( 'single-photo', 140, 70, true );
 }

 set_post_thumbnail_size( 300, 250, true ); 

add_action( 'after_setup_theme', 'intechnic_lite_setup' );



	/*----------------------------
     Enquening Scripts and Styles
    -----------------------------*/

	function intechnic_lite_scripts() {
		global $wp_styles;

    /*---------------------------------------------------
         Comment Reply.
     ----------------------------------------------------*/
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	// Loads bootstrap.
	wp_enqueue_style( 'intechnic-bootstrap-style', getAssetsPath('/assets/css/bootstrap.min.css') );

	// Loads our main stylesheet.
	wp_enqueue_style( 'intechnic-style', get_stylesheet_uri() );

    //Load Fontawesome css
    wp_enqueue_style('intechnic-font-awesome.min', getAssetsPath('/assets/vendors/font-awesome/css/font-awesome.min.css"'));

    // Loads font.
    wp_enqueue_style( 'google-vietnamese-font', 'https://fonts.googleapis.com/css?family=Open+Sans:400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese' );

    /* OWL */
    // Loads stylesheets.
    wp_enqueue_style( 'intechnic-owl-style', getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.css'));

       //Load animation css
    wp_enqueue_style('intechnic-animate-css', getAssetsPath('/assets/vendors/animate/animate.css'));

     /*----------------------------
       Load Javascript
        -----------------------------*/

    // Adds bootstrap JavaScript.
    wp_enqueue_script( 'intechnic-bootstrap-js', getAssetsPath('/assets/js/bootstrap.min.js'), array( 'jquery' ) , '','', true);

    wp_enqueue_script( 'intechnic-owl-script',  getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.min.js'), '','', true);
	 
    //Loads animation js
    wp_enqueue_script( 'intechnic-wow.min',  getAssetsPath('/assets/vendors/animate/wow.min.js'), '','', true);
  
    //Loads lightbox js
      wp_enqueue_script( 'intechnic-lightbox', getAssetsPath('/assets/vendors/popup/lightbox.min.js'), '','', true);

    //Loads sidebar js
    wp_enqueue_script( 'intechnic-custom-sidebar',  getAssetsPath('/assets/vendors/sidebar/main.js'), '','', true);
    
        // Slider JS
    wp_enqueue_script( 'intechnic-slider',  getAssetsPath('/assets/js/slider.js'), '','', true);
 
    // Custom JS
    wp_enqueue_script( 'intechnic-custom',  getAssetsPath('/assets/js/theme.js'), '','', true);
    
	}
	
 add_action( 'wp_enqueue_scripts', 'intechnic_lite_scripts' );


 /*----------------------------
   Excerpt Word Length
    -----------------------------*/

 if(!function_exists( 'intechnic_lite_custom_excerpt_length' )) {

    //Customize excerpt word count
    function intechnic_lite_custom_excerpt_length() {
        return 25; //25 words
    }
    
    add_filter('excerpt_length', 'intechnic_lite_custom_excerpt_length');
}



add_image_size( 'small-thumb', 60, 60, true );
add_image_size( 'listng-photo', 200, 100, true );
add_image_size( 'single-photo', 200, 200, true );
add_image_size( 'about-photo', 680, 370, true );
add_image_size( 'midume-photo', 300, 300, true );
add_image_size( 'full-photo-bio', 8000, 10000 );


/*----------------------------
   Add our Widget Locations
    -----------------------------*/

    function intechnic_lite_widgets() {
        register_sidebar( array(
            'name' => __( 'Sidebar', 'intechnic-lite' ),
            'id' => 'sidebar-1',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 1', 'intechnic-lite' ),
            'id' => 'sidebar-2',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 2', 'intechnic-lite' ),
            'id' => 'sidebar-3',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 3', 'intechnic-lite' ),
            'id' => 'sidebar-4',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Home Page Testimonials', 'intechnic-lite' ),
            'id' => 'testimonials_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );          
        register_sidebar( array(
            'name' => __( 'Home Partners', 'intechnic-lite' ),
            'id' => 'partner_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'NavThemes Call Action', 'intechnic-lite' ),
            'id' => 'call_action_widget',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );   
        register_sidebar( array(
            'name' => __( 'Front Page Services Widget', 'intechnic-lite' ),
            'id' => 'services_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Services Page Services Widget', 'intechnic-lite' ),
            'id' => 'services_widget___',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Services Page Services 2 Widget', 'intechnic-lite' ),
            'id' => 'services_widget__',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'About Us First Widget', 'intechnic-lite' ),
            'id' => 'about_widgets_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'About Us Second Widget', 'intechnic-lite' ),
            'id' => 'about_widgets__',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Plans Widget', 'intechnic-lite' ),
            'id' => 'plan_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'intechnic-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );         
        }
add_action('widgets_init', 'intechnic_lite_widgets');

    
/*----------------------------
    Including NavThemes Functions File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/navthemes-functions.php')) :
    include_once(dirname( __FILE__ ) . '/navthemes-functions.php');
 endif;   



/*----------------------------
    Including theme-options File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/theme-options.php')) :
    include_once(dirname( __FILE__ ) . '/theme-options.php');
 endif; 
    
 
    /*----------------------------
    Adds customizer css
    -----------------------------*/
if(!function_exists('navthemes_customizer_css')) {

    function navthemes_customizer_css() {
     // Loads our main stylesheet.
        wp_enqueue_style( 'customizer-css', get_template_directory_uri().'/customizer.css' );
    }
    
    add_action( 'customize_controls_print_styles', 'navthemes_customizer_css');

}