<?php
/**
 * This file is responsible for the rendering of the header of the theme.
 * @version:1.0
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>
    <?php
    if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
    wp_head();
    ?>
</head>
<body <?php body_class(); ?>">
  <!-- Collect the nav links, forms, and other content for toggling -->
  <?php
            $layout = maybe_unserialize( get_theme_mod( 'homepage_modules', 
                                          array('partners' , 
                                            'servicessectionone' ,
                                            'servicessectiontwo' ,
                                            'servicessectionthree',
                                            'plans',
                                            'testimonials') ) );  
          
            $modules = array( 
    
                  'partners' =>array(
                    'show' => get_theme_mod('showin_menu_welcome', 1), 
                    'text' => get_theme_mod('welcome_menu_title', 'Partners'),
                    'link' => '#partners'
                  ), 
                  
                  'servicessectionone' =>array(
                    'show' => get_theme_mod('showin_menu_welcome', 1), 
                    'text' => get_theme_mod('welcome_menu_title', 'Servicessectionone'),
                    'link' => '#servicessectionone'
                  ), 

                  'servicessectiontwo' =>array(
                    'show' => get_theme_mod('showin_menu_pages', 1), 
                    'text' => get_theme_mod('pages_menu_title', 'Servicessectiontwo'),
                    'link' => '#servicessectiontwo'
                  ), 
   
                  'servicessectionthree' =>array(
                    'show' => get_theme_mod('showin_menu_portfolio', 1), 
                    'text' => get_theme_mod('portfolio_menu_title', 'Servicessectionthree'),
                    'link' => '#servicessectionthree'
                  ), 
                  
                  'plans' =>array(
                    'show' => get_theme_mod('showin_menu_team', 1), 
                    'text' => get_theme_mod('team_menu_title', 'Plans'),
                    'link' => '#plans'
                  ),
    
                  'testimonials' =>array(
                    'show' => get_theme_mod('showin_menu_statistics', 1), 
                    'text' => get_theme_mod('statistics_menu_title', 'Testimonials'), 
                    'link' => '#testimonials'
                  ),
            );
          ?>
  <?php if ( is_front_page() && !is_home() ) { ?>
    <div class="bg-gradient">
    <?php }else{ ?>
      <div>
   <?php  } ?>
         <div class="bg-banner-img clip-ellipse" style="background-image: url(<?php echo get_theme_mod('banner_image', get_template_directory_uri() . '/assets/images/banner-img.jpg'); ?>);">
               <!-- Header_Area -->
               <nav class="navbar navbar-default header_aera affix-top" id="navbarfixed">
                  <div class="container m-s">
                     <!-- Brand and toggle get grouped for better mobile display -->
                     <div class="col-md-4 p0">
                        <div class="navbar-header">
                           <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#min_navbar">
                           <span class="sr-only"><?php _e('Toggle navigation', 'iconic'); ?></span>
                           <span class="icon-bar"></span>
                           <span class="icon-bar"></span>
                           <span class="icon-bar"></span>
                           </button>
                           <a class="navbar-brand logo-biss" href="<?php echo site_url(); ?>"> 
                            <?php if(get_theme_mod('sitelogo')){ 
                                $logo= (get_theme_mod('sitelogo'));  
                                ?> 
                                <img height="50"  alt="<?php bloginfo('name'); ?>" src="<?php echo $logo; ?>">
                              <?php } else { bloginfo('name'); } ?>
                          </a>
                        </div>
                     </div>
                     <!-- Collect the nav links, forms, and other content for toggling -->
                     <div class="col-md-8 p0">
                        <div class="collapse navbar-collapse" id="min_navbar">
                           <ul class="nav navbar-nav navbar-right" style="    margin: -8.5px -15px;">
                            <?php  if ( has_nav_menu( 'primary' ) ) { 
                              $menu = wp_nav_menu( 
                                array( 
                                'theme_location' => 'primary',
                                'echo' => FALSE, 
                                'items_wrap'=> '<ul id="%1$s" class="nav navbar-nav">%3$s</ul>', 
                                'container' => 'none', 
                                'fallback_cb'    => '__return_false'
                                ) ); 
                              } 
                              if ( ! empty ( $menu ) )
                                {
                                     echo $menu;
                                }
                                 else{
                                  if (current_user_can('update_core')) : _e( __( '<h5 class="menuwarning">Menu Doesn\'t exists, please set a menu. (Only You (admin) can see this.)</h5>', 'iconic' ));     endif;
                                }
                              ?>
             
                           </ul>
                        </div>
                        <!-- /.navbar-collapse -->
                     </div>
                  </div>
                  <!-- /.container -->
               </nav>
               <!-- End Header_Area -->

                   <div class="navbar navbar-default navbar-inverse" role="navigation" id="mobilenav">
          <div class="navbar-header">
              
              <button type="button" class="navbar-toggle">
                  <span class="sr-only"><?php _e('Toggle navigation', 'iconic'); ?></span>
                  <span class="icon-bar"></span>
                  <span class="icon-bar"></span>
                  <span class="icon-bar"></span>
              </button>
              
              <a class="navbar-brand" href="<?php echo home_url(); ?>">
                  <div class="logo">
                     <?php if(get_theme_mod('sitelogo')){ 
                          $logo= (get_theme_mod('sitelogo'));  
                          ?> 
                          <img height="50"  alt="<?php bloginfo('name'); ?>" src="<?php echo $logo; ?>">
                        <?php } else { bloginfo('name'); } ?>
                  </div>
              </a>
              
          </div>
              
              <div class="navbar-collapse">
                  <ul class="nav navbar-nav navbar-right">
                            <?php  if ( has_nav_menu( 'primary' ) ) { 
                              $menu = wp_nav_menu( 
                                array( 
                                'theme_location' => 'primary',
                                'echo' => FALSE, 
                                'items_wrap'=> '<ul id="%1$s" class="nav navbar-nav">%3$s</ul>', 
                                'container' => 'none', 
                                'fallback_cb'    => '__return_false'
                                ) ); 
                              } 
                              if ( ! empty ( $menu ) )
                                {
                                     echo $menu;
                                }
                                 else{
                                  if (current_user_can('update_core')) : _e( __( '<h5 class="menuwarning">Menu Doesn\'t exists, please set a menu. (Only You (admin) can see this.)</h5>', 'iconic' ));     endif;
                                }
                              ?>
                  </ul>
              </div>
          
      </div>
      <!-- End Navigation-->