<?php
/**
	This File handles Customizer Options
	* @version:1.0
*/

//include_once( 'admin/kirki/kirki.php' );


// Early exit if Kirki is not installed
if ( ! class_exists( 'Kirki' ) ) {
	return;
}
 
/**
 * Configuration sample for the Kirki Customizer.
 */
function navthemes_configuration() {

	$args = array(
		'logo_image'   => 'http://navthemes.com/branding/inthemes/logo.png',
		'url_path' => get_stylesheet_directory_uri() . '/admin/kirki/'
   );

	return $args;

}

add_filter( 'kirki/config', 'navthemes_configuration' );


/*=================================
	Priorities-

* NavThemes Branding  - 1-10 
* Sample Content      - 11
* General settings    - 21-31
* Front page          - 41-130

================================= */


/*=================================
	Panels Priorities-

* NavThemes Branding  - 1 
* Sample Content      - 2
* General Settings    - 3
* Front Page          - 4
* Call To Action      - 11
================================= */


/*=================================
	Config	
  ================================= */

Kirki::add_config( 'iconic', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
 	
) );


	/*------------------------------------------
     NavThemes Branding
     ------------------------------------------*/

     $theme = wp_get_theme();
	 $theme_version = $theme->get( 'Version' );
	 $theme_name = $theme->get( 'Name' );
 
  Kirki::add_section( 'NavThemes_Support', array(
			'title'          => __( 'NavThemes Support', 'navthemes' ),
			'description'    => sprintf( 'You are using Free version of %s Theme, Check out Paid version, which comes with many exciting features in the package.', __($theme->Name, 'navthemes','iconic') ),
			'priority'       => 1,
	) );
			
		Kirki::add_field( 'navthemes', array(
		'type'        => 'custom',
		'settings'     => 'navthemes_support',
		'section'     => 'NavThemes_Support',
		'default'     => sprintf( '<div id="navthemes_branding"><h1>Get Premium Version of %s for Just $59</h1>
			<div class="navthemes-links">
			<ul>
				<li><a target="_blank" href="%s">Check out All Features of Paid version</a></li>
				<li><a target="_blank" href="%s">View Demo</a></li>
			</ul> 
		</div>
		</div>', __($theme->Name, 'navthemes','iconic'), 'https://www.navthemes.com/wp-themes/iconic-pro-wordpress-themes/' , 'http://demo.navthemes.com/?demo=iconic-pro' ),
		'priority'    => 10,
	) );    

/*------------------------------------------
    Maintenance Service
    ------------------------------------------*/


 Kirki::add_section( 'NavThemes_Maintenance_Service', array(
            'title'          => __( 'Maintenance Service', 'navthemes' ),
            'description'    => sprintf( '<h1> Managing WordPress Site is a hassle ? Let us handle that.

</h1>', __($theme->Name, 'navthemes','iconic') ),
            'priority'       => 1,
    ) );
            

        Kirki::add_field( 'navthemes', array(
        'type'        => 'custom',
        'settings'     => 'navThemes_maintenance_service',
        'section'     => 'NavThemes_Maintenance_Service',
        'default'     => sprintf( '<div id="navthemes_maintenance">
        <div class="themeisle-upsell"> 
        <h1>**Key Features**</h1>
            <h3>FREE Lightning Fast Hosting <span class="color_span" ><br>This is a Google Ranking factor. </span></h3>
            <h3>FREE SSL Certificate   <span class="color_span"> <br>This is a Google Ranking factor. </span></h3> 
            <h3>24/7 Uptime monitoring</h3>
            <h3>Access All NavThemes Premium WordPress Themes and Plugins</h3>
            <h3>Free Migration Service to our hosting</h3>
            <h3>Free CDN Service</h3>
            <h3>Unlimited Website Edits</h3>
            <h3>Hack/Malware Removal</h3>
            <h3>Weekly Website Report</h3>
            <div class="navthemes-links">
            <ul>
            <li>

            <a target="_blank" href="http://navthemes.com/wordpress-management-service/?utm_source=iconic-lite&utm_medium=lite-wordpress-theme&utm_campaign=customizer&utm_term=maintenance-service" class="button button-primary button_70">Starting at just $39/Month</a>
          </li>

                
            </ul>
            </div>
        </div>
        </div>', __($theme->Name, 'navthemes','iconic'), 'https://www.navthemes.com/free-wordpress-theme/Iconic-wordpress-theme/'),
        'priority'    => 11,
    ) );


/*=================================
		Sample Content	
	  ================================= */
	
	Kirki::add_section( 'required_settings', array(
		'title'          => __( 'Sample Content', 'iconic' ), 
		'priority'       => 2,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'iconic', array(
				'section'  => 'required_settings',
				'type'     => 'custom',
				'priority' => 11,
				'default'  => sprintf('<div><h3>Once you have installed and activated all recommended plugins, to setup your theme look like demo Follow these steps.
					<ol>
						<li>Download <a target="_blank" href="%s">this</a> file</li>
						<li>Import this file in customizer, Check <a target="_blank" href="%s">instructions</a> here.</li>
						<li>Once imported, publish it.</li>
					</ol>
					</h3>
		</div>
		<div id="navthemes_maintenance">
		 <a target="_blank" href="http://docs.navthemes.com/docs/iconic" class="button button-primary button_70">Documentation</a>
		 </div>
		', 'http://docs.navthemes.com/download/320/', 'http://docs.navthemes.com/docs/iconic/sample-content/' ),
		'priority'    => 10,
		)    
	);    

	

/*--------------------------------------------------------------------------
  --------------------------------------------------------------------------
			General Settings
--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
			
		
	Kirki::add_panel( 'general_settings', array(
		'priority'    => 3,
		'title'       => __( 'General Settings', 'iconic' ),
		'description' => __( 'Manage General Setting from here', 'iconic' ),
	) );
	
	/*=================================
		General Section	
  	================================= */
  	


  	/*=================================
	Banner Image setting	
  ================================= */

	Kirki::add_section( 'banner_image', array(
		'title'          => __( 'Header Image', 'iconic' ),
		'description'    => __( 'From here you can manage background image of header', 'iconic' ),
		'panel'          => 'general_settings', 
		'priority'       => 21,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'iconic', array(
		'settings' => 'banner_image',
		'label'    => __( 'Header Image', 'iconic' ),
		'section'  => 'banner_image',
		'type'        => 'image',
		'priority' => 22,
		'default'  => get_template_directory_uri() . '/assets/images/banner-img.jpg',
	) );



	/*=================================
	Site Logo Settings settings	
  ================================= */


	Kirki::add_section( 'logo_settings', array(
		'title'          => __( 'Logo Settings', 'iconic' ),
		'description'    => __( 'From Here You Can Manage Manage Settings' , 'iconic' ),
		'panel'          => 'general_settings', 
		'priority'       => 23,
		'capability'     => 'edit_theme_options', 
	) );

	Kirki::add_field( 'iconic', array(
			'settings' => 'sitelogo',
			'label'    => __( 'Logo', 'iconic' ),
			'section'  => 'logo_settings',
			'type'     => 'image',
			'priority' => 24,
			'default'  => '',
		 
		) );



	/*=================================
	Footer Social settings	
  ================================= */

  	Kirki::add_section( 'social_settings', array(
		'title'          => __( 'Footer Social Settings', 'iconic' ),
		'description'    => __( 'From Here You Can Manage Some Social Settings' , 'iconic' ),
		'panel'          => 'general_settings', 
		'priority'       => 25,
		'capability'     => 'edit_theme_options', 
	) );

		Kirki::add_field( 'iconic', array(
                'settings' => 'footerfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'iconic' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 26,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'iconic', array(
				'settings' => 'social_facebook',
				'label'    => __( 'Facebook', 'iconic' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 27,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'iconic', array(
                'settings' => 'footertwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'iconic' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 28,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'iconic', array(
				'settings' => 'social_twitter',
				'label'    => __( 'Twiiter', 'iconic' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 29,
				'default'  => '#',
			) );


		Kirki::add_field( 'iconic', array(
                'settings' => 'footerinstagramonoff',
                'label'    => __( 'Instagram Active/Inactive', 'iconic' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 30,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'iconic', array(
				'settings' => 'social_instagram',
				'label'    => __( 'Instagram', 'iconic' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 31,
				'default'  => '#',
			) );
	
			/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Footer Text Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'footer_text', array(
		'title'          => __( 'Footer Copyright Text Setting', 'iconic' ),
		'description'    => __( 'From here you can manage text of footer', 'iconic' ),
		'panel'          => 'general_settings', 
		'priority'       => 41,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'iconic', array(
				'settings' => 'footer_theme_text',
				'label'    => __( 'Field', 'iconic' ),
				'section'  => 'footer_text',
				'type'     => 'textarea',
				'priority' => 42,
				'default'  => '',
			) );	



/*=================================
	Home Page Panel	
  ================================= */

	Kirki::add_panel( 'homepage', array(
		'priority'    => 4,
		'title'       => __( 'Front Page Settings', 'iconic' ),
		'description' => __( 'Manage Front Page Setting from here', 'iconic' ),
	) );
	

		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Header Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'homepage_banner', array(
		'title'          => __( 'Header Content Setting', 'iconic' ),
		'description'    => __( 'From here you can manage Title and Text of Header', 'iconic' ),
		'panel'          => 'homepage', 
		'priority'       => 41,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'iconic', array(
				'settings' => 'banner_title',
				'label'    => __( 'Heading', 'iconic' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 42,
				'default'  => '',
			) );
			
				
			Kirki::add_field( 'iconic', array(
				'settings' => 'banner_text1',
				'label'    => __( 'Sub Heading', 'iconic' ),
				'section'  => 'homepage_banner',
				'type'     => 'textarea',
				'priority' => 43,
				'default'  => '',
				
			) );

			Kirki::add_field( 'iconic', array(
                'settings' => 'homepagebuttonbanneronoff',
                'label'    => __( 'Button ON/OFF', 'iconic' ),
                'section'  => 'homepage_banner',
                'type'     => 'toggle',
                'priority' => 44,
                'default'  => 1,           
            ) );

	 	Kirki::add_field( 'iconic', array(
				'settings' => 'button_text',
				'label'    => __( 'Button Text', 'iconic' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 45,
				'default'  => '',
				
			) );
	 	Kirki::add_field( 'iconic', array(
                'settings' => 'button_link',
                'label'    => __( 'Button Link', 'iconic' ),
                'section'  => 'homepage_banner',
                'type'     => 'text',
                'priority' => 46,
                'default'  => '#', 
            ) );



add_action( 'customize_register', 'navthemes_move_widget_area' );
function navthemes_move_widget_area () {
  global $wp_customize;


    // sidebar-2 is your sidebar ID
  $footer_widgets_section3 = (object) $wp_customize->get_section( 'sidebar-widgets-partner_widget_' );
  // general_settings - Panel ID
  $footer_widgets_section3->priority = 50; 
  $footer_widgets_section3->panel = 'homepage';

   // sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-services_widget_' );
  // general_settings - Panel ID 
  $footer_widgets_section6->priority = 60;
  $footer_widgets_section6->panel = 'homepage';

  // sidebar-2 is your sidebar ID
  $footer_widgets_section9 = (object) $wp_customize->get_section( 'sidebar-widgets-about_widgets_' );
  // general_settings - Panel ID
  $footer_widgets_section9->priority = 70; 
  $footer_widgets_section9->panel = 'homepage';

    // sidebar-2 is your sidebar ID
  $footer_widgets_section11 = (object) $wp_customize->get_section( 'sidebar-widgets-plan_widget_' );
  // general_settings - Panel ID 
  $footer_widgets_section11->priority = 80;
  $footer_widgets_section11->panel = 'homepage';

  // sidebar-2 is your sidebar ID
  $footer_widgets_section2 = (object) $wp_customize->get_section( 'sidebar-widgets-testimonials_widgets' );
  // general_settings - Panel ID 
  $footer_widgets_section2->priority = 90;
  $footer_widgets_section2->panel = 'homepage';

     // sidebar-2 is your sidebar ID
  $footer_widgets_section5 = (object) $wp_customize->get_section( 'sidebar-widgets-call_action_widget' );
  // general_settings - Panel ID 
  $footer_widgets_section5->priority = 10;
  $footer_widgets_section5->panel = '';
}



// add if other functions available
if(file_exists('add-on.php')) include('add-on.php');
		