<?php
 /*--------------------------------------------------------------------------------
  _   _                   _______   _                                     
 | \ | |                 |__   __| | |                                    
 |  \| |   __ _  __   __    | |    | |__     ___   _ __ ___     ___   ___ 
 |     |  / _  | \ \ / /    | |    | '_ \   / _ \ | '_ ` _ \   / _ \ / __|
 | |\  | | (_| |  \ V /     | |    | | | | |  __/ | | | | | | |  __/ \__ \
 |_| \_|  \__,_|   \_/      |_|    |_| |_|  \___| |_| |_| |_|  \___| |___/
                                                                          
                                                                          
----------------------------------------------------------------------------------*/ 
?>


<?php
/**
 * The main theme functions file loads styles/scripts, allows some theme functionality and provides some helper functions.
 * @version:2.2
 */
/**
 * This theme only works in WordPress 4.2 or later.
 */


if ( version_compare( $GLOBALS['wp_version'], '4.2', '<' ) ) {
    require get_template_directory() . '/inc/back-compat.php';
}

/*----------------------------------------------------------------
    Content Width
 -----------------------------------------------------------------*/

if ( ! isset( $content_width ) ) $content_width = 1140;


/*----------------------------------------------------------------
    TGMPA Activation.
 -----------------------------------------------------------------*/
require_once(get_template_directory() . '/inc/tgm_activation/tgm.php');


/*----------------------------------------------------------------
    Path Function.
 -----------------------------------------------------------------*/

function getAssetsPath($path) {
    return get_template_directory_uri().$path;
}

function image($name) {
    return getAssetsPath('assets/images/'.$name);
}


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 *
 * Create your own iconic_setup function to override in a child theme.
 *
 * @version iconic 2.2
 */

function iconic_setup(){

    /*------------------------------
         * Register Navigation 
    --------------------------------*/
    //Navigation Menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'iconic')
    ));

    /*---------------------------------------------------
         Theme Supports.
     ----------------------------------------------------*/

    //Add featured image support
    add_theme_support('post-thumbnails');

    //This feature enables plugins and themes to manage the document title tag.
    add_theme_support('title-tag');
    //This feature adds RSS feed links to HTML <head>.
    add_theme_support( 'automatic-feed-links' );
 
    add_theme_support('post-thumbnails');
    set_post_thumbnail_size( 700, 500, true );
    add_image_size( 'small-thumb', 200, 200, true );
    add_image_size( 'video-logo', 90, 90, true );
    add_image_size( 'single-photo', 140, 70, true );
    add_image_size( 'medium-photo', 500, 500, true );

    // Load Text Domain
    load_theme_textdomain('iconic');

 }

add_action( 'after_setup_theme', 'iconic_setup' );



	/*----------------------------
     Enquening Scripts and Styles
    -----------------------------*/

	function iconic_scripts() {
		global $wp_styles;

    /*---------------------------------------------------
         Comment Reply.
     ----------------------------------------------------*/
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	// Loads bootstrap.
	wp_enqueue_style( 'iconic-bootstrap-style', getAssetsPath('/assets/css/bootstrap.min.css') );

	// Loads our main stylesheet.
	wp_enqueue_style( 'iconic-style', get_stylesheet_uri() );

    //Load Fontawesome css
    wp_enqueue_style('iconic-font-awesome.min', getAssetsPath('/assets/vendors/font-awesome/css/font-awesome.min.css"'));

    // Loads font.
    wp_enqueue_style( 'google-oswald-font', 'https://fonts.googleapis.com/css?family=Open+Sans:400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese' );

    /* OWL */
    // Loads stylesheets.
    wp_enqueue_style( 'iconic-owl-style', getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.css'));

    //Load animation css
    wp_enqueue_style('iconic-animate-css', getAssetsPath('/assets/vendors/animate/animate.css'));

     /*----------------------------
       Load Javascript
        -----------------------------*/

    // Adds bootstrap JavaScript.
    wp_enqueue_script( 'iconic-bootstrap-js', getAssetsPath('/assets/js/bootstrap.min.js'), array( 'jquery' ) , '','', true);


    wp_enqueue_script( 'iconic-owl-script',  getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.min.js'), '','', true);
	 
    wp_enqueue_script( 'iconic-lightbox', getAssetsPath('/assets/vendors/popup/lightbox.min.js'), '','', true);

    //Loads animation js
    wp_enqueue_script( 'iconic-wow.min',  getAssetsPath('/assets/vendors/animate/wow.min.js'), '','', true);

    // Custom JS
    wp_enqueue_script( 'iconic-custom',  getAssetsPath('/assets/js/theme.js'), '','', true);

	}
	
 add_action( 'wp_enqueue_scripts', 'iconic_scripts' );


 /*----------------------------
   Excerpt Word Length
    -----------------------------*/

 if(!function_exists( 'iconic_custom_excerpt_length' )) {

    //Customize excerpt word count
    function iconic_custom_excerpt_length() {
        return 25; //25 words
    }
    
    add_filter('excerpt_length', 'iconic_custom_excerpt_length');
}


/*----------------------------
   Add our Widget Locations
    -----------------------------*/

    function iconic_widgets() {
        register_sidebar( array(
            'name' => __( 'Sidebar', 'iconic' ),
            'id' => 'sidebar-1',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 1', 'iconic' ),
            'id' => 'sidebar-2',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 2', 'iconic' ),
            'id' => 'sidebar-3',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 3', 'iconic' ),
            'id' => 'sidebar-4',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
  
        register_sidebar( array(
            'name' => __( 'Testimonials Section', 'iconic' ),
            'id' => 'testimonials_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );          
        register_sidebar( array(
            'name' => __( 'Partners Section', 'iconic' ),
            'id' => 'partner_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Call Action Section', 'iconic' ),
            'id' => 'call_action_widget',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );   
        register_sidebar( array(
            'name' => __( 'Services Section', 'iconic' ),
            'id' => 'services_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'About Us Section', 'iconic' ),
            'id' => 'about_widgets_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
        register_sidebar( array(
            'name' => __( 'Plans Section', 'iconic' ),
            'id' => 'plan_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'iconic' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );        
        }
add_action('widgets_init', 'iconic_widgets');

    
/*----------------------------
    Including NavThemes Functions File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/navthemes-functions.php')) :
    include_once(dirname( __FILE__ ) . '/navthemes-functions.php');
 endif;   

/*----------------------------
    Including theme-options File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/theme-options.php')) :
    include_once(dirname( __FILE__ ) . '/theme-options.php');
 endif; 
    
 
    /*----------------------------
    Adds customizer css
    -----------------------------*/
if(!function_exists('navthemes_customizer_css')) {

    function navthemes_customizer_css() {
     // Loads our main stylesheet.
        wp_enqueue_style( 'customizer-css', get_template_directory_uri().'/customizer.css' );
    }
    
    add_action( 'customize_controls_print_styles', 'navthemes_customizer_css');

}

