-- MySQL dump 10.13  Distrib 5.6.36, for Linux (x86_64)
--
-- Host: localhost    Database: d7_hotel
-- ------------------------------------------------------
-- Server version	5.6.30

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accesslog`
--

DROP TABLE IF EXISTS `accesslog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accesslog` (
  `aid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique accesslog ID.',
  `sid` varchar(128) NOT NULL DEFAULT '' COMMENT 'Browser session ID of user that visited page.',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title of page visited.',
  `path` varchar(255) DEFAULT NULL COMMENT 'Internal path to page visited (relative to Drupal root.)',
  `url` text COMMENT 'Referrer URI.',
  `hostname` varchar(128) DEFAULT NULL COMMENT 'Hostname of user that visited the page.',
  `uid` int(10) unsigned DEFAULT '0' COMMENT 'User users.uid that visited the page.',
  `timer` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Time in milliseconds that the page took to load.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Timestamp of when the page was visited.',
  PRIMARY KEY (`aid`),
  KEY `accesslog_timestamp` (`timestamp`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores site access information for statistics.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accesslog`
--

LOCK TABLES `accesslog` WRITE;
/*!40000 ALTER TABLE `accesslog` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `accesslog` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `actions`
--

DROP TABLE IF EXISTS `actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actions` (
  `aid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique actions ID.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The object that that action acts on (node, user, comment, system or custom types.)',
  `callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback function that executes when the action runs.',
  `parameters` longblob NOT NULL COMMENT 'Parameters to be passed to the callback function.',
  `label` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Label of the action.',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores action information.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actions`
--

LOCK TABLES `actions` WRITE;
/*!40000 ALTER TABLE `actions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `actions` VALUES ('comment_publish_action','comment','comment_publish_action','','Publish comment'),('comment_save_action','comment','comment_save_action','','Save comment'),('comment_unpublish_action','comment','comment_unpublish_action','','Unpublish comment'),('node_make_sticky_action','node','node_make_sticky_action','','Make content sticky'),('node_make_unsticky_action','node','node_make_unsticky_action','','Make content unsticky'),('node_promote_action','node','node_promote_action','','Promote content to front page'),('node_publish_action','node','node_publish_action','','Publish content'),('node_save_action','node','node_save_action','','Save content'),('node_unpromote_action','node','node_unpromote_action','','Remove content from front page'),('node_unpublish_action','node','node_unpublish_action','','Unpublish content'),('pathauto_node_update_action','node','pathauto_node_update_action','','Update node alias'),('pathauto_taxonomy_term_update_action','taxonomy_term','pathauto_taxonomy_term_update_action','','Update taxonomy term alias'),('pathauto_user_update_action','user','pathauto_user_update_action','','Update user alias'),('system_block_ip_action','user','system_block_ip_action','','Ban IP address of current user'),('user_block_user_action','user','user_block_user_action','','Block current user');
/*!40000 ALTER TABLE `actions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `authmap`
--

DROP TABLE IF EXISTS `authmap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authmap` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique authmap ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'User’s users.uid.',
  `authname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Unique authentication name.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'Module which is controlling the authentication.',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `authname` (`authname`),
  KEY `uid_module` (`uid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores distributed authentication mapping.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authmap`
--

LOCK TABLES `authmap` WRITE;
/*!40000 ALTER TABLE `authmap` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `authmap` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `batch`
--

DROP TABLE IF EXISTS `batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores details about batches (processes that run in...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batch`
--

LOCK TABLES `batch` WRITE;
/*!40000 ALTER TABLE `batch` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `batch` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block`
--

DROP TABLE IF EXISTS `block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block` (
  `bid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique block ID.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The module from which the block originates; for example, ’user’ for the Who’s Online block, and ’block’ for any custom blocks.',
  `delta` varchar(32) NOT NULL DEFAULT '0' COMMENT 'Unique ID for block within a module.',
  `theme` varchar(64) NOT NULL DEFAULT '' COMMENT 'The theme under which the block settings apply.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Block enabled status. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Block weight within region.',
  `region` varchar(64) NOT NULL DEFAULT '' COMMENT 'Theme region within which the block is set.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)',
  `visibility` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)',
  `pages` text NOT NULL COMMENT 'Contents of the "Pages" block; contains either a list of paths on which to include/exclude the block or PHP code, depending on "visibility" setting.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Custom title for the block. (Empty string will use block default title, <none> will remove the title, text will cause block to use specified title.)',
  `cache` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Binary flag to indicate block cache mode. (-2: Custom cache, -1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See DRUPAL_CACHE_* constants in ../includes/common.inc for more detailed information.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `tmd` (`theme`,`module`,`delta`),
  KEY `list` (`theme`,`status`,`region`,`weight`,`module`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8 COMMENT='Stores block settings, such as region and visibility...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block`
--

LOCK TABLES `block` WRITE;
/*!40000 ALTER TABLE `block` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block` VALUES (1,'system','main','bartik',1,0,'content',0,0,'','',-1),(2,'search','form','bartik',1,-1,'sidebar_first',0,0,'','',-1),(3,'node','recent','seven',1,10,'dashboard_main',0,0,'','',-1),(4,'user','login','bartik',1,0,'sidebar_first',0,0,'','',-1),(5,'system','navigation','bartik',1,0,'sidebar_first',0,0,'','',-1),(6,'system','powered-by','bartik',1,10,'footer',0,0,'','',-1),(7,'system','help','bartik',1,0,'help',0,0,'','',-1),(8,'system','main','seven',1,0,'content',0,0,'','',-1),(9,'system','help','seven',1,0,'help',0,0,'','',-1),(10,'user','login','seven',1,10,'content',0,0,'','',-1),(11,'user','new','seven',1,0,'dashboard_sidebar',0,0,'','',-1),(12,'search','form','seven',1,-10,'dashboard_sidebar',0,0,'','',-1),(13,'comment','recent','bartik',0,0,'-1',0,0,'','',1),(14,'node','syndicate','bartik',0,0,'-1',0,0,'','',-1),(15,'node','recent','bartik',0,0,'-1',0,0,'','',1),(16,'shortcut','shortcuts','bartik',0,0,'-1',0,0,'','',-1),(17,'system','management','bartik',0,0,'-1',0,0,'','',-1),(18,'system','user-menu','bartik',0,0,'-1',0,0,'','',-1),(19,'system','main-menu','bartik',0,0,'-1',0,0,'','',-1),(20,'user','new','bartik',0,0,'-1',0,0,'','',1),(21,'user','online','bartik',0,0,'-1',0,0,'','',-1),(22,'comment','recent','seven',1,0,'dashboard_inactive',0,0,'','',1),(23,'node','syndicate','seven',0,0,'-1',0,0,'','',-1),(24,'shortcut','shortcuts','seven',0,0,'-1',0,0,'','',-1),(25,'system','powered-by','seven',0,10,'-1',0,0,'','',-1),(26,'system','navigation','seven',0,0,'-1',0,0,'','',-1),(27,'system','management','seven',0,0,'-1',0,0,'','',-1),(28,'system','user-menu','seven',0,0,'-1',0,0,'','',-1),(29,'system','main-menu','seven',0,0,'-1',0,0,'','',-1),(30,'user','online','seven',1,0,'dashboard_inactive',0,0,'','',-1),(31,'commerce_cart','cart','bartik',0,0,'-1',0,0,'checkout*','',-1),(32,'locale','language','bartik',0,0,'-1',0,0,'','',-1),(33,'locationmap','image','bartik',0,0,'-1',0,1,'<front>','',1),(34,'poll','recent','bartik',0,0,'-1',0,0,'','',1),(35,'rooms_booking_manager','rooms_availability_search','bartik',1,0,'sidebar_first',0,0,'','',-1),(36,'site_map','syndicate','bartik',0,0,'-1',0,0,'','',1),(37,'superfish','1','bartik',0,0,'-1',0,0,'','',-1),(38,'superfish','2','bartik',0,0,'-1',0,0,'','',-1),(39,'superfish','3','bartik',0,0,'-1',0,0,'','',-1),(40,'superfish','4','bartik',0,0,'-1',0,0,'','',-1),(41,'commerce_cart','cart','seven',0,0,'-1',0,0,'checkout*','',-1),(42,'locale','language','seven',0,0,'-1',0,0,'','',-1),(43,'locationmap','image','seven',0,0,'-1',0,1,'<front>','',1),(44,'poll','recent','seven',1,0,'dashboard_inactive',0,0,'','',1),(45,'rooms_booking_manager','rooms_availability_search','seven',0,0,'-1',0,0,'','',-1),(46,'site_map','syndicate','seven',0,0,'-1',0,0,'','',1),(47,'superfish','1','seven',0,0,'-1',0,0,'','',-1),(48,'superfish','2','seven',0,0,'-1',0,0,'','',-1),(49,'superfish','3','seven',0,0,'-1',0,0,'','',-1),(50,'superfish','4','seven',0,0,'-1',0,0,'','',-1),(51,'comment','recent','hotel',0,0,'-1',0,0,'','',1),(52,'commerce_cart','cart','hotel',0,0,'-1',0,0,'checkout*','',-1),(53,'locale','language','hotel',0,0,'-1',0,0,'','',-1),(54,'locationmap','image','hotel',1,0,'panel_second_1',0,1,'<front>','',1),(55,'node','recent','hotel',0,0,'-1',0,0,'','',1),(56,'node','syndicate','hotel',0,0,'-1',0,0,'','',-1),(57,'poll','recent','hotel',0,0,'-1',0,0,'','',1),(58,'rooms_booking_manager','rooms_availability_search','hotel',1,-17,'sidebar_first',0,0,'','',-1),(59,'search','form','hotel',1,-12,'header',0,0,'','',-1),(60,'shortcut','shortcuts','hotel',0,0,'-1',0,0,'','',-1),(61,'site_map','syndicate','hotel',0,0,'-1',0,0,'','',1),(62,'superfish','1','hotel',1,0,'menu_bar',0,0,'','',-1),(63,'superfish','2','hotel',0,0,'-1',0,0,'','',-1),(64,'superfish','3','hotel',0,0,'-1',0,0,'','',-1),(65,'superfish','4','hotel',0,0,'-1',0,0,'','',-1),(66,'system','help','hotel',1,0,'help',0,0,'','',-1),(67,'system','main','hotel',1,0,'content',0,0,'','',-1),(68,'system','main-menu','hotel',0,0,'-1',0,0,'','',-1),(69,'system','management','hotel',0,0,'-1',0,0,'','',-1),(70,'system','navigation','hotel',0,0,'-1',0,0,'','',-1),(71,'system','powered-by','hotel',0,10,'-1',0,0,'','',-1),(72,'system','user-menu','hotel',0,0,'-1',0,0,'','',-1),(73,'user','login','hotel',0,0,'-1',0,0,'','',-1),(74,'user','new','hotel',0,0,'-1',0,0,'','',1),(75,'user','online','hotel',0,0,'-1',0,0,'','',-1),(76,'menu','menu-top-menu','hotel',1,-14,'header',0,0,'','<none>',-1),(77,'block','1','bartik',0,0,'-1',0,0,'','',-1),(78,'block','1','hotel',1,-13,'header',0,0,'','',-1),(79,'block','1','seven',0,0,'-1',0,0,'','',-1),(80,'views','promotions-block','hotel',1,0,'sidebar_second',0,1,'<front>','<none>',-1),(81,'block','2','bartik',0,0,'-1',0,0,'','',-1),(82,'block','2','hotel',1,-15,'footer',0,0,'','',-1),(83,'block','2','seven',0,0,'-1',0,0,'','',-1),(84,'block','3','bartik',0,0,'-1',0,0,'','',-1),(85,'block','3','hotel',1,-16,'footer',0,0,'','',-1),(86,'block','3','seven',0,0,'-1',0,0,'','',-1),(87,'views','accommodation-block','hotel',1,0,'panel_second_2',0,1,'<front>','',-1),(88,'views','promotions-block','bartik',0,0,'-1',0,1,'<front>','<none>',-1),(89,'views','promotions-block','seven',0,0,'-1',0,1,'<front>','<none>',-1),(90,'menu','menu-top-menu','bartik',0,0,'-1',0,0,'','<none>',-1),(91,'views','accommodation-block','bartik',0,0,'-1',0,1,'<front>','',-1),(92,'menu','menu-top-menu','seven',0,0,'-1',0,0,'','<none>',-1),(93,'views','accommodation-block','seven',0,0,'-1',0,1,'<front>','',-1),(97,'views','Slideshow-block','hotel',0,0,'-1',0,0,'','',-1),(98,'views','Slideshow-block','bartik',0,0,'-1',0,0,'','',-1),(99,'views','Slideshow-block','seven',0,0,'-1',0,0,'','',-1),(100,'views','slideshow-block_1','hotel',1,0,'slideshow',0,0,'','',-1),(101,'views','slideshow-block_1','bartik',0,0,'-1',0,0,'','',-1),(102,'views','slideshow-block_1','seven',0,0,'-1',0,0,'','',-1),(103,'views','promotions_in_left_column-block','hotel',1,-15,'sidebar_first',0,0,'<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions','<none>',-1),(104,'views','promotions_in_left_column-block','bartik',0,0,'-1',0,0,'<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions','<none>',-1),(105,'views','promotions_in_left_column-block','seven',0,0,'-1',0,0,'<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions','<none>',-1),(106,'block','5','bartik',0,0,'-1',0,0,'<front>','',-1),(107,'block','5','hotel',1,-16,'sidebar_first',0,0,'<front>','',-1),(108,'block','5','seven',0,0,'-1',0,0,'<front>','',-1),(109,'commerce_cart_expiration','cart_expiration','bartik',0,0,'-1',0,1,'checkout*\r\ncart','',-1),(110,'commerce_cart_expiration','cart_expiration','hotel',0,0,'-1',0,1,'checkout*\r\ncart','',-1),(111,'commerce_cart_expiration','cart_expiration','seven',0,0,'-1',0,1,'checkout*\r\ncart','',-1),(112,'block','1','we_backend',1,-13,'header',0,0,'','',-1),(113,'block','2','we_backend',0,-15,'-1',0,0,'','',-1),(114,'block','3','we_backend',1,-16,'footer',0,0,'','',-1),(115,'block','5','we_backend',0,-16,'-1',0,0,'<front>','',-1),(116,'comment','recent','we_backend',1,0,'dashboard_inactive',0,0,'','',1),(117,'commerce_cart','cart','we_backend',0,0,'-1',0,0,'checkout*','',-1),(118,'commerce_cart_expiration','cart_expiration','we_backend',0,0,'-1',0,1,'checkout*\r\ncart','',-1),(119,'locale','language','we_backend',0,0,'-1',0,0,'','',-1),(120,'locationmap','image','we_backend',1,0,'header',0,1,'<front>','',1),(121,'menu','menu-top-menu','we_backend',1,-14,'header',0,0,'','<none>',-1),(122,'node','recent','we_backend',1,0,'dashboard_inactive',0,0,'','',1),(123,'node','syndicate','we_backend',0,0,'-1',0,0,'','',-1),(124,'poll','recent','we_backend',1,0,'dashboard_inactive',0,0,'','',1),(125,'rooms_booking_manager','rooms_availability_search','we_backend',0,-17,'-1',0,0,'','',-1),(126,'search','form','we_backend',1,-12,'header',0,0,'','',-1),(127,'shortcut','shortcuts','we_backend',0,0,'-1',0,0,'','',-1),(128,'site_map','syndicate','we_backend',0,0,'-1',0,0,'','',1),(129,'superfish','1','we_backend',1,0,'header',0,0,'','',-1),(130,'superfish','2','we_backend',0,0,'-1',0,0,'','',-1),(131,'superfish','3','we_backend',0,0,'-1',0,0,'','',-1),(132,'superfish','4','we_backend',0,0,'-1',0,0,'','',-1),(133,'system','help','we_backend',1,0,'help',0,0,'','',-1),(134,'system','main','we_backend',1,0,'content',0,0,'','',-1),(135,'system','main-menu','we_backend',0,0,'-1',0,0,'','',-1),(136,'system','management','we_backend',0,0,'-1',0,0,'','',-1),(137,'system','navigation','we_backend',0,0,'-1',0,0,'','',-1),(138,'system','powered-by','we_backend',0,10,'-1',0,0,'','',-1),(139,'system','user-menu','we_backend',0,0,'-1',0,0,'','',-1),(140,'user','login','we_backend',0,0,'-1',0,0,'','',-1),(141,'user','new','we_backend',1,0,'dashboard_inactive',0,0,'','',1),(142,'user','online','we_backend',1,0,'dashboard_inactive',0,0,'','',-1),(143,'views','accommodation-block','we_backend',1,0,'header',0,1,'<front>','',-1),(144,'views','promotions-block','we_backend',1,0,'sidebar_second',0,1,'<front>','<none>',-1),(145,'views','promotions_in_left_column-block','we_backend',0,-15,'-1',0,0,'<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions','<none>',-1),(146,'views','Slideshow-block','we_backend',0,0,'-1',0,0,'','',-1),(147,'views','slideshow-block_1','we_backend',1,0,'header',0,0,'','',-1);
/*!40000 ALTER TABLE `block` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_custom`
--

DROP TABLE IF EXISTS `block_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_custom` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made blocks.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_custom`
--

LOCK TABLES `block_custom` WRITE;
/*!40000 ALTER TABLE `block_custom` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_custom` VALUES (1,'<p>Follow us on:</p>\r\n<ul class=\"socials\">\r\n<li>\r\n <a href=\"#\" class=\"facebook-follow\" title=\"Facebook\">Facebook</a>\r\n</li>\r\n<li>\r\n<a href=\"#\" class=\"twitter-follow\" title=\"Twitter\">Twitter</a>\r\n</li>\r\n<li>\r\n<a href=\"#\" class=\"google-plus-follow\" title=\"Google Plus\">Google Plus</a>\r\n</li>\r\n</ul>','Follow social','full_html'),(2,'<ul class=\"contact-info\">\r\n<li class=\"tel\">Tel.\\Fax: 222-1111 \\ 111-1111</li>\r\n<li class=\"email-address\">Email: <a href=\"mailto:services@jasper-hotel.com\">services@jasper-hotel.com</a></li>\r\n</ul>','Contact Information','filtered_html'),(3,'Designed by <a href=\"http://www.weebpal.com\">WeebPal Drupal Themes</a>. Powered by <a href=\"http://drupal.org\" target=\"_blank\">Drupal</a>.','Jasper hotel Copyright Notice Block. Ussuallly locate in footer.','filtered_html'),(5,'<dl class=\"contact-list\">\r\n<dt>General Information</dt>\r\n<dd>\r\n<p>4 New York Plaza, New York, NY 10004</p>\r\n<p>Tel: (212) 210-2100</p>\r\n<p>Fax: (212) 210-2100</p>\r\n<p>Email: <a href=\"mailto:hotel@jasper.com\">hotel@jasper.com</a></p>\r\n</dd>\r\n<dt>Sales and Marketing</dt>\r\n<dd>\r\n<p>Email: <a href=\"mailto:hotel@jasper.com\">hotel@jasper.com</a></p>\r\n<p>Direct fax: (212) 210-2100</p>\r\n</dd>\r\n<dt>Reservations</dt>\r\n<dd class=\"last\">\r\n<p>Email: <a href=\"mailto:hotel@jasper.com\">hotel@jasper.com</a></p>\r\n<p>Direct fax: (212) 210-2100</p>\r\n</dd>\r\n</dl>','General Information','filtered_html');
/*!40000 ALTER TABLE `block_custom` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_node_type`
--

DROP TABLE IF EXISTS `block_node_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_node_type` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type from node_type.type.',
  PRIMARY KEY (`module`,`delta`,`type`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up display criteria for blocks based on content types';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_node_type`
--

LOCK TABLES `block_node_type` WRITE;
/*!40000 ALTER TABLE `block_node_type` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `block_node_type` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_role`
--

DROP TABLE IF EXISTS `block_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_role` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `rid` int(10) unsigned NOT NULL COMMENT 'The user’s role ID from users_roles.rid.',
  PRIMARY KEY (`module`,`delta`,`rid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up access permissions for blocks based on user roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_role`
--

LOCK TABLES `block_role` WRITE;
/*!40000 ALTER TABLE `block_role` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `block_role` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `blocked_ips`
--

DROP TABLE IF EXISTS `blocked_ips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blocked_ips` (
  `iid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: unique ID for IP addresses.',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP address',
  PRIMARY KEY (`iid`),
  KEY `blocked_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores blocked IP addresses.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blocked_ips`
--

LOCK TABLES `blocked_ips` WRITE;
/*!40000 ALTER TABLE `blocked_ips` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `blocked_ips` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `cache` VALUES ('schema:runtime:1','a:2:{s:16:\"date_format_type\";a:5:{s:6:\"fields\";a:3:{s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:5:\"title\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:7:\"default\";i:0;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"type\";}s:7:\"indexes\";a:1:{s:5:\"title\";a:1:{i:0;s:5:\"title\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:16:\"date_format_type\";}s:12:\"date_formats\";a:5:{s:6:\"fields\";a:4:{s:4:\"dfid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;s:8:\"unsigned\";b:1;}s:6:\"format\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;s:6:\"binary\";b:1;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:7:\"default\";i:0;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"dfid\";}s:11:\"unique keys\";a:1:{s:7:\"formats\";a:2:{i:0;s:6:\"format\";i:1;s:4:\"type\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:12:\"date_formats\";}}',0,1512630527,1);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_admin_menu`
--

DROP TABLE IF EXISTS `cache_admin_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_admin_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for Administration menu to store client-side...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_admin_menu`
--

LOCK TABLES `cache_admin_menu` WRITE;
/*!40000 ALTER TABLE `cache_admin_menu` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_admin_menu` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_block`
--

DROP TABLE IF EXISTS `cache_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_block` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Block module to store already built...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_block`
--

LOCK TABLES `cache_block` WRITE;
/*!40000 ALTER TABLE `cache_block` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_block` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_bootstrap`
--

DROP TABLE IF EXISTS `cache_bootstrap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_bootstrap` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for data required to bootstrap Drupal, may be...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_bootstrap`
--

LOCK TABLES `cache_bootstrap` WRITE;
/*!40000 ALTER TABLE `cache_bootstrap` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_bootstrap` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_field`
--

DROP TABLE IF EXISTS `cache_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_field` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_field`
--

LOCK TABLES `cache_field` WRITE;
/*!40000 ALTER TABLE `cache_field` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_field` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_filter`
--

DROP TABLE IF EXISTS `cache_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_filter` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Filter module to store already...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_filter`
--

LOCK TABLES `cache_filter` WRITE;
/*!40000 ALTER TABLE `cache_filter` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_filter` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_form`
--

DROP TABLE IF EXISTS `cache_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_form` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the form system to store recently built...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_form`
--

LOCK TABLES `cache_form` WRITE;
/*!40000 ALTER TABLE `cache_form` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `cache_form` VALUES ('form_form-d-qKQdG4901GjNo1ST6LypMjAORGMHtDQ2AO0Woh_O0','a:30:{s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:47:\"rooms-management-form rooms-unit-type-edit-form\";}}s:9:\"#attached\";a:1:{s:3:\"css\";a:1:{i:0;s:66:\"sites/all/modules/rooms/modules/rooms_unit/css/rooms_unit_type.css\";}}s:5:\"label\";a:7:{s:6:\"#title\";s:14:\"Unit type name\";s:5:\"#type\";s:9:\"textfield\";s:14:\"#default_value\";s:11:\"Basic Suite\";s:12:\"#description\";s:42:\"The human-readable name of this unit type.\";s:9:\"#required\";b:1;s:5:\"#size\";i:30;s:7:\"#weight\";i:-100;}s:4:\"type\";a:6:{s:5:\"#type\";s:12:\"machine_name\";s:14:\"#default_value\";s:11:\"basic_suite\";s:10:\"#maxlength\";i:32;s:13:\"#machine_name\";a:2:{s:6:\"exists\";s:20:\"rooms_unit_get_types\";s:6:\"source\";a:1:{i:0;s:5:\"label\";}}s:12:\"#description\";s:116:\"A unique machine-readable name for this unit type. It must only contain lowercase letters, numbers, and underscores.\";s:7:\"#weight\";i:-99;}s:13:\"unit_defaults\";a:8:{s:5:\"#type\";s:8:\"fieldset\";s:12:\"#description\";s:127:\"<strong>Unit defaults</strong> - Values specified below will be pre-populated as the defaults when creating units of this type.\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-98;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:24:\"rooms-unit-type-defaults\";}}s:4:\"data\";a:2:{s:5:\"#tree\";b:1;s:10:\"base_price\";a:7:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:18:\"Default base price\";s:14:\"#default_value\";s:2:\"50\";s:5:\"#size\";i:5;s:13:\"#field_suffix\";s:18:\"Per unit per night\";s:12:\"#description\";s:120:\"The default base price is used for all units of this type and may be changed on the edit form of each unit individually.\";s:10:\"#maxlength\";i:10;}}s:14:\"guest_capacity\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:25:\"Default sleeping capacity\";s:5:\"#tree\";b:0;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:30:\"rooms-unit-type-guest-capacity\";}}s:4:\"data\";a:3:{s:5:\"#tree\";b:1;s:10:\"min_sleeps\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person minimum\";}s:10:\"max_sleeps\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:12:\"#description\";s:88:\"The default number of guests (including adults and children) for each unit of this type.\";s:13:\"#field_suffix\";s:14:\"Person maximum\";}}}s:14:\"child_capacity\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:22:\"Default child capacity\";s:5:\"#tree\";b:0;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:30:\"rooms-unit-type-child-capacity\";}}s:4:\"data\";a:3:{s:5:\"#tree\";b:1;s:12:\"min_children\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:13:\"Child minimum\";}s:12:\"max_children\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:12:\"#description\";s:53:\"The default number of children per unit of this type.\";s:13:\"#field_suffix\";s:13:\"Child maximum\";}}}}s:9:\"reference\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-97;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-type-reference\";}}s:4:\"data\";a:2:{s:5:\"#tree\";b:1;s:24:\"rooms_description_source\";a:7:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:28:\"Unit type description source\";s:12:\"#description\";s:65:\"The node you choose here will be rendered in the booking results.\";s:5:\"#size\";i:30;s:10:\"#maxlength\";i:60;s:18:\"#autocomplete_path\";s:40:\"admin/rooms/unit-type/description-source\";s:14:\"#default_value\";s:0:\"\";}}}s:8:\"#parents\";a:0:{}s:7:\"#entity\";O:13:\"RoomsUnitType\":12:{s:4:\"type\";s:11:\"basic_suite\";s:5:\"label\";s:11:\"Basic Suite\";s:13:\"\0*\0entityType\";s:15:\"rooms_unit_type\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:2:\"id\";s:1:\"3\";s:6:\"weight\";s:1:\"0\";s:4:\"data\";a:6:{s:10:\"base_price\";s:2:\"50\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";N;s:12:\"max_children\";N;s:24:\"rooms_description_source\";N;}s:6:\"status\";s:1:\"1\";s:6:\"module\";N;s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}}s:26:\"rooms_booking_unit_options\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:24:\"field-type-rooms-options\";i:1;s:37:\"field-name-rooms-booking-unit-options\";i:2;s:35:\"field-widget-rooms-options-combined\";}}s:7:\"#weight\";i:0;s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:14:{i:0;a:19:{s:12:\"#entity_type\";s:15:\"rooms_unit_type\";s:7:\"#entity\";r:102;s:7:\"#bundle\";s:15:\"rooms_unit_type\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:4:{i:0;s:4:\"name\";i:1;s:8:\"quantity\";i:2;s:9:\"operation\";i:3;s:5:\"value\";}s:6:\"#title\";s:0:\"\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:0;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:4:\"name\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:4:\"Name\";s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:18:\"rooms-option--name\";}}}s:8:\"quantity\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:8:\"Quantity\";s:8:\"#options\";a:10:{i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;i:8;i:9;i:9;i:10;i:10;}s:14:\"#default_value\";N;s:12:\"#description\";s:43:\"How many of this option should be available\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:22:\"rooms-option--quantity\";}}}s:9:\"operation\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:9:\"Operation\";s:8:\"#options\";a:7:{s:3:\"add\";s:12:\"Add to price\";s:9:\"add-daily\";s:22:\"Add to price per night\";s:3:\"sub\";s:19:\"Subtract from price\";s:9:\"sub-daily\";s:29:\"Subtract from price per night\";s:7:\"replace\";s:13:\"Replace price\";s:8:\"increase\";s:26:\"Increase price by % amount\";s:8:\"decrease\";s:26:\"Decrease price by % amount\";}s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"rooms-option--operation\";}}}s:5:\"value\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:5:\"Value\";s:5:\"#size\";i:10;s:14:\"#default_value\";N;s:17:\"#element_validate\";a:1:{i:0;s:33:\"element_validate_integer_positive\";}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"rooms-option--value\";}}}s:6:\"remove\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:6:\"Remove\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:27:\"rooms-option--remove-button\";}}}s:9:\"#attached\";a:2:{s:2:\"js\";a:1:{i:0;s:50:\"sites/all/modules/rooms/js/rooms_options_widget.js\";}s:3:\"css\";a:1:{i:0;s:52:\"sites/all/modules/rooms/css/rooms_options_widget.css\";}}s:7:\"_weight\";a:6:{s:5:\"#type\";s:6:\"weight\";s:6:\"#title\";s:16:\"Weight for row 1\";s:14:\"#title_display\";s:9:\"invisible\";s:6:\"#delta\";i:0;s:14:\"#default_value\";i:0;s:7:\"#weight\";i:100;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:12:\"#cardinality\";s:2:\"-1\";s:6:\"#title\";s:7:\"Options\";s:9:\"#required\";b:0;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:54:\"<div id=\"rooms-booking-unit-options-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:8:\"add_more\";a:7:{s:5:\"#type\";s:6:\"submit\";s:5:\"#name\";s:35:\"rooms_booking_unit_options_add_more\";s:6:\"#value\";s:16:\"Add another item\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:21:\"field-add-more-submit\";}}s:24:\"#limit_validation_errors\";a:1:{i:0;a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}}s:7:\"#submit\";a:1:{i:0;s:21:\"field_add_more_submit\";}s:5:\"#ajax\";a:3:{s:8:\"callback\";s:17:\"field_add_more_js\";s:7:\"wrapper\";s:43:\"rooms-booking-unit-options-add-more-wrapper\";s:6:\"effect\";s:4:\"fade\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:11:\"#pre_render\";a:1:{i:0;s:30:\"_field_extra_fields_pre_render\";}s:12:\"#entity_type\";s:15:\"rooms_unit_type\";s:7:\"#bundle\";s:15:\"rooms_unit_type\";s:19:\"additional_settings\";a:2:{s:5:\"#type\";s:13:\"vertical_tabs\";s:7:\"#weight\";i:99;}s:7:\"actions\";a:3:{s:5:\"#type\";s:7:\"actions\";s:5:\"#tree\";b:0;s:6:\"submit\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:14:\"Save unit type\";s:7:\"#weight\";i:100;}}s:8:\"#form_id\";s:20:\"rooms_unit_type_form\";s:5:\"#type\";s:4:\"form\";s:9:\"#build_id\";s:48:\"form-d-qKQdG4901GjNo1ST6LypMjAORGMHtDQ2AO0Woh_O0\";s:13:\"form_build_id\";a:5:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-d-qKQdG4901GjNo1ST6LypMjAORGMHtDQ2AO0Woh_O0\";s:3:\"#id\";s:48:\"form-d-qKQdG4901GjNo1ST6LypMjAORGMHtDQ2AO0Woh_O0\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}}s:6:\"#token\";s:20:\"rooms_unit_type_form\";s:10:\"form_token\";a:4:{s:3:\"#id\";s:36:\"edit-rooms-unit-type-form-form-token\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:43:\"o1voUzop6IXScYsc1932mcPUdrsZ2P0wFhGizHdprYE\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:20:\"rooms_unit_type_form\";s:3:\"#id\";s:25:\"edit-rooms-unit-type-form\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:20:\"rooms-unit-type-form\";s:7:\"#method\";s:4:\"post\";s:7:\"#action\";s:77:\"/drupal7/hotel/admin/rooms/units/unit-types/manage/basic_suite?render=overlay\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:5:\"#tree\";b:0;s:9:\"#validate\";a:1:{i:0;s:29:\"rooms_unit_type_form_validate\";}s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_type_form_submit\";}s:6:\"#theme\";a:1:{i:0;s:20:\"rooms_unit_type_form\";}s:12:\"#cache_token\";s:43:\"_0Nqq7kbxACp9xFRIcu1io57GJhTq2Xwy9d-QUy3irw\";}',1500477334,1500455734,1),('form_form-DVJktaRaUTofYtvvpstMERE0Ydvon9Y1jTgJZmpq0-U','a:36:{s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:42:\"rooms-management-form rooms-unit-edit-form\";}}s:9:\"#attached\";a:1:{s:3:\"css\";a:1:{i:0;s:61:\"sites/all/modules/rooms/modules/rooms_unit/css/rooms_unit.css\";}}s:4:\"name\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:9:\"Unit name\";s:14:\"#default_value\";s:14:\"Royal Room - 2\";s:10:\"#maxlength\";i:255;s:9:\"#required\";b:1;s:7:\"#weight\";i:-99;}s:10:\"base_price\";a:8:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:10:\"Base price\";s:14:\"#default_value\";s:7:\"2000.00\";s:5:\"#size\";s:1:\"5\";s:13:\"#field_suffix\";s:18:\"Per unit per night\";s:10:\"#maxlength\";i:10;s:9:\"#required\";b:1;s:7:\"#weight\";i:-98;}s:14:\"guest_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:17:\"Sleeping capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-97;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-guest-capacity\";}}s:10:\"min_sleeps\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"4\";s:13:\"#field_suffix\";s:14:\"Person minimum\";}s:10:\"max_sleeps\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"4\";s:13:\"#field_suffix\";s:14:\"Person maximum\";s:12:\"#description\";s:70:\"The total number of guests (adults and children) allowed in this unit.\";}}s:14:\"child_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:14:\"Child capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-96;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-child-capacity\";}}s:12:\"min_children\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child minimum\";}s:12:\"max_children\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child maximum\";s:12:\"#description\";s:44:\"The number of children allowed in this unit.\";}}s:4:\"data\";a:3:{s:5:\"#tree\";b:1;s:7:\"#weight\";i:-95;s:15:\"bed_arrangement\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:15:\"Bed arrangement\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:26:\"rooms-unit-bed-arrangement\";}}s:7:\"singles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Single beds\";}s:7:\"doubles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Double beds\";}}}s:8:\"#parents\";a:0:{}s:7:\"#entity\";O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"24\";s:4:\"type\";s:11:\"royal_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:14:\"Royal Room - 2\";s:7:\"created\";s:10:\"1339860445\";s:7:\"changed\";s:10:\"1339860445\";s:10:\"base_price\";s:7:\"2000.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"4\";s:10:\"max_sleeps\";s:1:\"4\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"5\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:17:\"superior room.JPG\";s:3:\"uri\";s:38:\"public://image/rooms/superior room.JPG\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:6:\"774810\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860445\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:4:\"2400\";s:6:\"height\";s:4:\"1895\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1210:\"Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1224:\"<p>Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.</p>\n<p>Mauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?</p>\n<p>Curabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:27:25 +0800\";s:11:\"author_name\";s:5:\"admin\";}s:11:\"field_image\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:16:\"field-type-image\";i:1;s:22:\"field-name-field-image\";i:2;s:24:\"field-widget-image-image\";}}s:7:\"#weight\";s:1:\"2\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:5:{i:0;a:19:{s:7:\"#entity\";r:82;s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:11:\"royal_suite\";s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:5:{i:0;s:3:\"fid\";i:1;s:3:\"alt\";i:2;s:5:\"title\";i:3;s:5:\"width\";i:4;s:6:\"height\";}s:6:\"#title\";s:5:\"Image\";s:12:\"#description\";s:110:\"Files must be less than <strong>48.83 GB</strong>.<br />Allowed file types: <strong>png gif jpg jpeg</strong>.\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:5:\"#type\";s:12:\"managed_file\";s:16:\"#upload_location\";s:20:\"public://image/rooms\";s:18:\"#upload_validators\";a:2:{s:18:\"file_validate_size\";a:1:{i:0;d:52428800000;}s:24:\"file_validate_extensions\";a:1:{i:0;s:16:\"png gif jpg jpeg\";}}s:15:\"#value_callback\";s:23:\"file_field_widget_value\";s:8:\"#process\";a:3:{i:0;s:25:\"file_managed_file_process\";i:1;s:25:\"file_field_widget_process\";i:2;s:26:\"image_field_widget_process\";}s:19:\"#progress_indicator\";s:8:\"throbber\";s:9:\"#extended\";b:1;s:14:\"#default_value\";a:3:{s:3:\"fid\";i:0;s:7:\"display\";b:0;s:11:\"description\";s:0:\"\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:17:\"field_description\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:28:\"field-type-text-with-summary\";i:1;s:28:\"field-name-field-description\";i:2;s:39:\"field-widget-text-textarea-with-summary\";}}s:7:\"#weight\";s:1:\"4\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:13:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:11:\"royal_suite\";s:11:\"#field_name\";s:17:\"field_description\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:3:{i:0;s:5:\"value\";i:1;s:7:\"summary\";i:2;s:6:\"format\";}s:6:\"#title\";s:11:\"Description\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:5:\"#type\";s:11:\"text_format\";s:14:\"#default_value\";s:1210:\"Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n\";s:5:\"#rows\";s:2:\"20\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:9:\"text-full\";}}s:7:\"#format\";s:13:\"filtered_html\";s:10:\"#base_type\";s:8:\"textarea\";s:7:\"summary\";a:10:{s:5:\"#type\";s:5:\"value\";s:14:\"#default_value\";s:0:\"\";s:6:\"#title\";s:7:\"Summary\";s:5:\"#rows\";i:5;s:12:\"#description\";s:61:\"Leave blank to use trimmed value of full text as the summary.\";s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:34:\"modules/field/modules/text/text.js\";}}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:12:\"text-summary\";}}s:7:\"#prefix\";s:34:\"<div class=\"text-summary-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:7:\"#weight\";i:-10;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:17:\"field_description\";s:12:\"#cardinality\";s:1:\"1\";s:6:\"#title\";s:11:\"Description\";s:9:\"#required\";i:1;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:48:\"<div id=\"field-description-add-more-wrapper--2\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:26:\"rooms_booking_unit_options\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:24:\"field-type-rooms-options\";i:1;s:37:\"field-name-rooms-booking-unit-options\";i:2;s:35:\"field-widget-rooms-options-combined\";}}s:7:\"#weight\";i:5;s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:14:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:11:\"royal_suite\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:4:{i:0;s:4:\"name\";i:1;s:8:\"quantity\";i:2;s:9:\"operation\";i:3;s:5:\"value\";}s:6:\"#title\";s:0:\"\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:0;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:4:\"name\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:4:\"Name\";s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:18:\"rooms-option--name\";}}}s:8:\"quantity\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:8:\"Quantity\";s:8:\"#options\";a:10:{i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;i:8;i:9;i:9;i:10;i:10;}s:14:\"#default_value\";N;s:12:\"#description\";s:43:\"How many of this option should be available\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:22:\"rooms-option--quantity\";}}}s:9:\"operation\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:9:\"Operation\";s:8:\"#options\";a:7:{s:3:\"add\";s:12:\"Add to price\";s:9:\"add-daily\";s:22:\"Add to price per night\";s:3:\"sub\";s:19:\"Subtract from price\";s:9:\"sub-daily\";s:29:\"Subtract from price per night\";s:7:\"replace\";s:13:\"Replace price\";s:8:\"increase\";s:26:\"Increase price by % amount\";s:8:\"decrease\";s:26:\"Decrease price by % amount\";}s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"rooms-option--operation\";}}}s:5:\"value\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:5:\"Value\";s:5:\"#size\";i:10;s:14:\"#default_value\";N;s:17:\"#element_validate\";a:1:{i:0;s:33:\"element_validate_integer_positive\";}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"rooms-option--value\";}}}s:6:\"remove\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:6:\"Remove\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:27:\"rooms-option--remove-button\";}}}s:9:\"#attached\";a:2:{s:2:\"js\";a:1:{i:0;s:50:\"sites/all/modules/rooms/js/rooms_options_widget.js\";}s:3:\"css\";a:1:{i:0;s:52:\"sites/all/modules/rooms/css/rooms_options_widget.css\";}}s:7:\"_weight\";a:6:{s:5:\"#type\";s:6:\"weight\";s:6:\"#title\";s:16:\"Weight for row 1\";s:14:\"#title_display\";s:9:\"invisible\";s:6:\"#delta\";i:0;s:14:\"#default_value\";i:0;s:7:\"#weight\";i:100;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:12:\"#cardinality\";s:2:\"-1\";s:6:\"#title\";s:7:\"Options\";s:9:\"#required\";b:0;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:57:\"<div id=\"rooms-booking-unit-options-add-more-wrapper--2\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:8:\"add_more\";a:7:{s:5:\"#type\";s:6:\"submit\";s:5:\"#name\";s:35:\"rooms_booking_unit_options_add_more\";s:6:\"#value\";s:16:\"Add another item\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:21:\"field-add-more-submit\";}}s:24:\"#limit_validation_errors\";a:1:{i:0;a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}}s:7:\"#submit\";a:1:{i:0;s:21:\"field_add_more_submit\";}s:5:\"#ajax\";a:3:{s:8:\"callback\";s:17:\"field_add_more_js\";s:7:\"wrapper\";s:46:\"rooms-booking-unit-options-add-more-wrapper--2\";s:6:\"effect\";s:4:\"fade\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:11:\"#pre_render\";a:1:{i:0;s:30:\"_field_extra_fields_pre_render\";}s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:11:\"royal_suite\";s:19:\"additional_settings\";a:2:{s:5:\"#type\";s:13:\"vertical_tabs\";s:7:\"#weight\";i:99;}s:12:\"availability\";a:9:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#group\";s:19:\"additional_settings\";s:6:\"#title\";s:6:\"Status\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:80;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"unit-form-availability \";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:8:\"bookable\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:8:\"Bookable\";s:12:\"#description\";s:153:\"Uncheck this to temporarily prevent the unit from being booked or appearing in any searches without affecting the scheduled availability on the calendar.\";s:14:\"#default_value\";s:1:\"1\";}s:13:\"default_state\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:20:\"Default availability\";s:8:\"#options\";a:4:{i:0;s:11:\"Unavailable\";i:1;s:9:\"Available\";i:2;s:10:\"On Request\";i:3;s:17:\"Anonymous Booking\";}s:14:\"#default_value\";s:1:\"1\";s:12:\"#description\";s:50:\"Choose what state to leave the unit in by default.\";}}s:6:\"author\";a:11:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:21:\"Authoring information\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:16:\"unit-form-author\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:2:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";i:1;a:2:{s:4:\"type\";s:7:\"setting\";s:4:\"data\";a:1:{s:9:\"anonymous\";s:9:\"Anonymous\";}}}}s:7:\"#weight\";i:90;s:11:\"author_name\";a:7:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored by\";s:10:\"#maxlength\";i:60;s:18:\"#autocomplete_path\";s:17:\"user/autocomplete\";s:14:\"#default_value\";s:5:\"admin\";s:7:\"#weight\";i:-1;s:12:\"#description\";s:55:\"Leave blank for <em class=\"placeholder\">Anonymous</em>.\";}s:4:\"date\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored on\";s:10:\"#maxlength\";i:25;s:12:\"#description\";s:214:\"Format: <em class=\"placeholder\">2012-06-16 23:27:25 +0800</em>. The date format is YYYY-MM-DD and <em class=\"placeholder\">+0800</em> is the time zone offset from UTC. Leave blank to use the time of form submission.\";s:14:\"#default_value\";s:25:\"2012-06-16 23:27:25 +0800\";}}s:7:\"options\";a:10:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:18:\"Publishing options\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"unit-form-published\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:7:\"#weight\";i:95;s:6:\"status\";a:3:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:9:\"Published\";s:14:\"#default_value\";s:1:\"1\";}}s:7:\"actions\";a:4:{s:5:\"#type\";s:7:\"actions\";s:5:\"#tree\";b:0;s:6:\"submit\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:9:\"Save Unit\";s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}}s:6:\"delete\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:11:\"Delete Unit\";s:7:\"#suffix\";s:53:\"<a href=\"/drupal7/hotel/admin/rooms/units\">Cancel</a>\";s:7:\"#submit\";a:1:{i:0;s:29:\"rooms_unit_form_submit_delete\";}s:7:\"#weight\";i:45;}}s:9:\"#validate\";a:1:{i:0;s:29:\"rooms_unit_edit_form_validate\";}s:8:\"#form_id\";s:20:\"rooms_unit_edit_form\";s:9:\"#build_id\";s:48:\"form-DVJktaRaUTofYtvvpstMERE0Ydvon9Y1jTgJZmpq0-U\";s:7:\"#action\";s:45:\"/drupal7/hotel/admin/rooms/units/unit/24/edit\";s:5:\"#type\";s:4:\"form\";s:13:\"form_build_id\";a:5:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-DVJktaRaUTofYtvvpstMERE0Ydvon9Y1jTgJZmpq0-U\";s:3:\"#id\";s:48:\"form-DVJktaRaUTofYtvvpstMERE0Ydvon9Y1jTgJZmpq0-U\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}}s:6:\"#token\";s:20:\"rooms_unit_edit_form\";s:10:\"form_token\";a:4:{s:3:\"#id\";s:36:\"edit-rooms-unit-edit-form-form-token\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:43:\"Qtu5MJd7pX3R9fynIvfKJ4F19I0RTAuKS0jN24SGYT8\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:20:\"rooms_unit_edit_form\";s:3:\"#id\";s:25:\"edit-rooms-unit-edit-form\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:23:\"rooms-unit-edit-form--2\";s:7:\"#method\";s:4:\"post\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:5:\"#tree\";b:0;s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}s:6:\"#theme\";a:1:{i:0;s:20:\"rooms_unit_edit_form\";}s:12:\"#cache_token\";s:43:\"_0Nqq7kbxACp9xFRIcu1io57GJhTq2Xwy9d-QUy3irw\";}',1500477299,1500455699,1),('form_form-G9EdxsEdtKrxdcyIiy-rfHt26MkUzTE42FMRUfKKeNg','a:36:{s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:42:\"rooms-management-form rooms-unit-edit-form\";}}s:9:\"#attached\";a:1:{s:3:\"css\";a:1:{i:0;s:61:\"sites/all/modules/rooms/modules/rooms_unit/css/rooms_unit.css\";}}s:4:\"name\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:9:\"Unit name\";s:14:\"#default_value\";s:15:\"Deluxe Room - 1\";s:10:\"#maxlength\";i:255;s:9:\"#required\";b:1;s:7:\"#weight\";i:-99;}s:10:\"base_price\";a:8:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:10:\"Base price\";s:14:\"#default_value\";s:6:\"100.00\";s:5:\"#size\";s:1:\"5\";s:13:\"#field_suffix\";s:18:\"Per unit per night\";s:10:\"#maxlength\";i:10;s:9:\"#required\";b:1;s:7:\"#weight\";i:-98;}s:14:\"guest_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:17:\"Sleeping capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-97;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-guest-capacity\";}}s:10:\"min_sleeps\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person minimum\";}s:10:\"max_sleeps\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person maximum\";s:12:\"#description\";s:70:\"The total number of guests (adults and children) allowed in this unit.\";}}s:14:\"child_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:14:\"Child capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-96;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-child-capacity\";}}s:12:\"min_children\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child minimum\";}s:12:\"max_children\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child maximum\";s:12:\"#description\";s:44:\"The number of children allowed in this unit.\";}}s:4:\"data\";a:3:{s:5:\"#tree\";b:1;s:7:\"#weight\";i:-95;s:15:\"bed_arrangement\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:15:\"Bed arrangement\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:26:\"rooms-unit-bed-arrangement\";}}s:7:\"singles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Single beds\";}s:7:\"doubles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Double beds\";}}}s:8:\"#parents\";a:0:{}s:7:\"#entity\";O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"17\";s:4:\"type\";s:12:\"deluxe_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:15:\"Deluxe Room - 1\";s:7:\"created\";s:10:\"1339860342\";s:7:\"changed\";s:10:\"1339861017\";s:10:\"base_price\";s:6:\"100.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"3\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-2.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10886\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860342\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1206:\"Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1216:\"<p>Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.</p>\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:25:42 +0800\";s:11:\"author_name\";s:5:\"admin\";}s:11:\"field_image\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:16:\"field-type-image\";i:1;s:22:\"field-name-field-image\";i:2;s:24:\"field-widget-image-image\";}}s:7:\"#weight\";s:1:\"2\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:5:{i:0;a:19:{s:7:\"#entity\";r:82;s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:12:\"deluxe_suite\";s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:5:{i:0;s:3:\"fid\";i:1;s:3:\"alt\";i:2;s:5:\"title\";i:3;s:5:\"width\";i:4;s:6:\"height\";}s:6:\"#title\";s:5:\"Image\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:5:\"#type\";s:12:\"managed_file\";s:16:\"#upload_location\";s:20:\"public://image/rooms\";s:18:\"#upload_validators\";a:2:{s:18:\"file_validate_size\";a:1:{i:0;d:52428800000;}s:24:\"file_validate_extensions\";a:1:{i:0;s:16:\"png gif jpg jpeg\";}}s:15:\"#value_callback\";s:23:\"file_field_widget_value\";s:8:\"#process\";a:3:{i:0;s:25:\"file_managed_file_process\";i:1;s:25:\"file_field_widget_process\";i:2;s:26:\"image_field_widget_process\";}s:19:\"#progress_indicator\";s:8:\"throbber\";s:9:\"#extended\";b:1;s:14:\"#default_value\";a:13:{s:3:\"fid\";s:1:\"3\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-2.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10886\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860342\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:17:\"field_description\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:28:\"field-type-text-with-summary\";i:1;s:28:\"field-name-field-description\";i:2;s:39:\"field-widget-text-textarea-with-summary\";}}s:7:\"#weight\";s:1:\"4\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:13:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:12:\"deluxe_suite\";s:11:\"#field_name\";s:17:\"field_description\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:3:{i:0;s:5:\"value\";i:1;s:7:\"summary\";i:2;s:6:\"format\";}s:6:\"#title\";s:11:\"Description\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:5:\"#type\";s:11:\"text_format\";s:14:\"#default_value\";s:1206:\"Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n\";s:5:\"#rows\";s:2:\"20\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:9:\"text-full\";}}s:7:\"#format\";s:13:\"filtered_html\";s:10:\"#base_type\";s:8:\"textarea\";s:7:\"summary\";a:10:{s:5:\"#type\";s:5:\"value\";s:14:\"#default_value\";s:0:\"\";s:6:\"#title\";s:7:\"Summary\";s:5:\"#rows\";i:5;s:12:\"#description\";s:61:\"Leave blank to use trimmed value of full text as the summary.\";s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:34:\"modules/field/modules/text/text.js\";}}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:12:\"text-summary\";}}s:7:\"#prefix\";s:34:\"<div class=\"text-summary-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:7:\"#weight\";i:-10;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:17:\"field_description\";s:12:\"#cardinality\";s:1:\"1\";s:6:\"#title\";s:11:\"Description\";s:9:\"#required\";i:1;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:45:\"<div id=\"field-description-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:26:\"rooms_booking_unit_options\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:24:\"field-type-rooms-options\";i:1;s:37:\"field-name-rooms-booking-unit-options\";i:2;s:35:\"field-widget-rooms-options-combined\";}}s:7:\"#weight\";i:5;s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:14:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:12:\"deluxe_suite\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:4:{i:0;s:4:\"name\";i:1;s:8:\"quantity\";i:2;s:9:\"operation\";i:3;s:5:\"value\";}s:6:\"#title\";s:0:\"\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:0;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:4:\"name\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:4:\"Name\";s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:18:\"rooms-option--name\";}}}s:8:\"quantity\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:8:\"Quantity\";s:8:\"#options\";a:10:{i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;i:8;i:9;i:9;i:10;i:10;}s:14:\"#default_value\";N;s:12:\"#description\";s:43:\"How many of this option should be available\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:22:\"rooms-option--quantity\";}}}s:9:\"operation\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:9:\"Operation\";s:8:\"#options\";a:7:{s:3:\"add\";s:12:\"Add to price\";s:9:\"add-daily\";s:22:\"Add to price per night\";s:3:\"sub\";s:19:\"Subtract from price\";s:9:\"sub-daily\";s:29:\"Subtract from price per night\";s:7:\"replace\";s:13:\"Replace price\";s:8:\"increase\";s:26:\"Increase price by % amount\";s:8:\"decrease\";s:26:\"Decrease price by % amount\";}s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"rooms-option--operation\";}}}s:5:\"value\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:5:\"Value\";s:5:\"#size\";i:10;s:14:\"#default_value\";N;s:17:\"#element_validate\";a:1:{i:0;s:33:\"element_validate_integer_positive\";}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"rooms-option--value\";}}}s:6:\"remove\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:6:\"Remove\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:27:\"rooms-option--remove-button\";}}}s:9:\"#attached\";a:2:{s:2:\"js\";a:1:{i:0;s:50:\"sites/all/modules/rooms/js/rooms_options_widget.js\";}s:3:\"css\";a:1:{i:0;s:52:\"sites/all/modules/rooms/css/rooms_options_widget.css\";}}s:7:\"_weight\";a:6:{s:5:\"#type\";s:6:\"weight\";s:6:\"#title\";s:16:\"Weight for row 1\";s:14:\"#title_display\";s:9:\"invisible\";s:6:\"#delta\";i:0;s:14:\"#default_value\";i:0;s:7:\"#weight\";i:100;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:12:\"#cardinality\";s:2:\"-1\";s:6:\"#title\";s:7:\"Options\";s:9:\"#required\";b:0;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:54:\"<div id=\"rooms-booking-unit-options-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:8:\"add_more\";a:7:{s:5:\"#type\";s:6:\"submit\";s:5:\"#name\";s:35:\"rooms_booking_unit_options_add_more\";s:6:\"#value\";s:16:\"Add another item\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:21:\"field-add-more-submit\";}}s:24:\"#limit_validation_errors\";a:1:{i:0;a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}}s:7:\"#submit\";a:1:{i:0;s:21:\"field_add_more_submit\";}s:5:\"#ajax\";a:3:{s:8:\"callback\";s:17:\"field_add_more_js\";s:7:\"wrapper\";s:43:\"rooms-booking-unit-options-add-more-wrapper\";s:6:\"effect\";s:4:\"fade\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:11:\"#pre_render\";a:1:{i:0;s:30:\"_field_extra_fields_pre_render\";}s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:12:\"deluxe_suite\";s:19:\"additional_settings\";a:2:{s:5:\"#type\";s:13:\"vertical_tabs\";s:7:\"#weight\";i:99;}s:12:\"availability\";a:9:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#group\";s:19:\"additional_settings\";s:6:\"#title\";s:6:\"Status\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:80;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"unit-form-availability \";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:8:\"bookable\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:8:\"Bookable\";s:12:\"#description\";s:153:\"Uncheck this to temporarily prevent the unit from being booked or appearing in any searches without affecting the scheduled availability on the calendar.\";s:14:\"#default_value\";s:1:\"1\";}s:13:\"default_state\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:20:\"Default availability\";s:8:\"#options\";a:4:{i:0;s:11:\"Unavailable\";i:1;s:9:\"Available\";i:2;s:10:\"On Request\";i:3;s:17:\"Anonymous Booking\";}s:14:\"#default_value\";s:1:\"1\";s:12:\"#description\";s:50:\"Choose what state to leave the unit in by default.\";}}s:6:\"author\";a:11:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:21:\"Authoring information\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:16:\"unit-form-author\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:2:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";i:1;a:2:{s:4:\"type\";s:7:\"setting\";s:4:\"data\";a:1:{s:9:\"anonymous\";s:9:\"Anonymous\";}}}}s:7:\"#weight\";i:90;s:11:\"author_name\";a:7:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored by\";s:10:\"#maxlength\";i:60;s:18:\"#autocomplete_path\";s:17:\"user/autocomplete\";s:14:\"#default_value\";s:5:\"admin\";s:7:\"#weight\";i:-1;s:12:\"#description\";s:55:\"Leave blank for <em class=\"placeholder\">Anonymous</em>.\";}s:4:\"date\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored on\";s:10:\"#maxlength\";i:25;s:12:\"#description\";s:214:\"Format: <em class=\"placeholder\">2012-06-16 23:25:42 +0800</em>. The date format is YYYY-MM-DD and <em class=\"placeholder\">+0800</em> is the time zone offset from UTC. Leave blank to use the time of form submission.\";s:14:\"#default_value\";s:25:\"2012-06-16 23:25:42 +0800\";}}s:7:\"options\";a:10:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:18:\"Publishing options\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"unit-form-published\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:7:\"#weight\";i:95;s:6:\"status\";a:3:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:9:\"Published\";s:14:\"#default_value\";s:1:\"1\";}}s:7:\"actions\";a:4:{s:5:\"#type\";s:7:\"actions\";s:5:\"#tree\";b:0;s:6:\"submit\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:9:\"Save Unit\";s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}}s:6:\"delete\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:11:\"Delete Unit\";s:7:\"#suffix\";s:53:\"<a href=\"/drupal7/hotel/admin/rooms/units\">Cancel</a>\";s:7:\"#submit\";a:1:{i:0;s:29:\"rooms_unit_form_submit_delete\";}s:7:\"#weight\";i:45;}}s:9:\"#validate\";a:1:{i:0;s:29:\"rooms_unit_edit_form_validate\";}s:8:\"#form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"#type\";s:4:\"form\";s:9:\"#build_id\";s:48:\"form-G9EdxsEdtKrxdcyIiy-rfHt26MkUzTE42FMRUfKKeNg\";s:13:\"form_build_id\";a:5:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-G9EdxsEdtKrxdcyIiy-rfHt26MkUzTE42FMRUfKKeNg\";s:3:\"#id\";s:48:\"form-G9EdxsEdtKrxdcyIiy-rfHt26MkUzTE42FMRUfKKeNg\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}}s:6:\"#token\";s:20:\"rooms_unit_edit_form\";s:10:\"form_token\";a:4:{s:3:\"#id\";s:36:\"edit-rooms-unit-edit-form-form-token\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:43:\"Qtu5MJd7pX3R9fynIvfKJ4F19I0RTAuKS0jN24SGYT8\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:20:\"rooms_unit_edit_form\";s:3:\"#id\";s:25:\"edit-rooms-unit-edit-form\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:20:\"rooms-unit-edit-form\";s:7:\"#method\";s:4:\"post\";s:7:\"#action\";s:45:\"/drupal7/hotel/admin/rooms/units/unit/17/edit\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:5:\"#tree\";b:0;s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}s:6:\"#theme\";a:1:{i:0;s:20:\"rooms_unit_edit_form\";}s:12:\"#cache_token\";s:43:\"_0Nqq7kbxACp9xFRIcu1io57GJhTq2Xwy9d-QUy3irw\";}',1500477115,1500455515,1),('form_form-lLBFBc9zsPFg3tRMSAzEPGjyqnRiLERTvwIQodgBH1o','a:36:{s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:42:\"rooms-management-form rooms-unit-edit-form\";}}s:9:\"#attached\";a:1:{s:3:\"css\";a:1:{i:0;s:61:\"sites/all/modules/rooms/modules/rooms_unit/css/rooms_unit.css\";}}s:4:\"name\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:9:\"Unit name\";s:14:\"#default_value\";s:15:\"Deluxe Room - 1\";s:10:\"#maxlength\";i:255;s:9:\"#required\";b:1;s:7:\"#weight\";i:-99;}s:10:\"base_price\";a:8:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:10:\"Base price\";s:14:\"#default_value\";s:6:\"100.00\";s:5:\"#size\";s:1:\"5\";s:13:\"#field_suffix\";s:18:\"Per unit per night\";s:10:\"#maxlength\";i:10;s:9:\"#required\";b:1;s:7:\"#weight\";i:-98;}s:14:\"guest_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:17:\"Sleeping capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-97;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-guest-capacity\";}}s:10:\"min_sleeps\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person minimum\";}s:10:\"max_sleeps\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person maximum\";s:12:\"#description\";s:70:\"The total number of guests (adults and children) allowed in this unit.\";}}s:14:\"child_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:14:\"Child capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-96;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-child-capacity\";}}s:12:\"min_children\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child minimum\";}s:12:\"max_children\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child maximum\";s:12:\"#description\";s:44:\"The number of children allowed in this unit.\";}}s:4:\"data\";a:3:{s:5:\"#tree\";b:1;s:7:\"#weight\";i:-95;s:15:\"bed_arrangement\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:15:\"Bed arrangement\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:26:\"rooms-unit-bed-arrangement\";}}s:7:\"singles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Single beds\";}s:7:\"doubles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Double beds\";}}}s:8:\"#parents\";a:0:{}s:7:\"#entity\";O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"17\";s:4:\"type\";s:12:\"deluxe_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:15:\"Deluxe Room - 1\";s:7:\"created\";s:10:\"1339860342\";s:7:\"changed\";s:10:\"1339861017\";s:10:\"base_price\";s:6:\"100.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"3\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-2.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10886\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860342\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1206:\"Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1216:\"<p>Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.</p>\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:25:42 +0800\";s:11:\"author_name\";s:5:\"admin\";}s:11:\"field_image\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:16:\"field-type-image\";i:1;s:22:\"field-name-field-image\";i:2;s:24:\"field-widget-image-image\";}}s:7:\"#weight\";s:1:\"2\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:5:{i:0;a:19:{s:7:\"#entity\";r:82;s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:12:\"deluxe_suite\";s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:5:{i:0;s:3:\"fid\";i:1;s:3:\"alt\";i:2;s:5:\"title\";i:3;s:5:\"width\";i:4;s:6:\"height\";}s:6:\"#title\";s:5:\"Image\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:5:\"#type\";s:12:\"managed_file\";s:16:\"#upload_location\";s:20:\"public://image/rooms\";s:18:\"#upload_validators\";a:2:{s:18:\"file_validate_size\";a:1:{i:0;d:52428800000;}s:24:\"file_validate_extensions\";a:1:{i:0;s:16:\"png gif jpg jpeg\";}}s:15:\"#value_callback\";s:23:\"file_field_widget_value\";s:8:\"#process\";a:3:{i:0;s:25:\"file_managed_file_process\";i:1;s:25:\"file_field_widget_process\";i:2;s:26:\"image_field_widget_process\";}s:19:\"#progress_indicator\";s:8:\"throbber\";s:9:\"#extended\";b:1;s:14:\"#default_value\";a:13:{s:3:\"fid\";s:1:\"3\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-2.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10886\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860342\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:17:\"field_description\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:28:\"field-type-text-with-summary\";i:1;s:28:\"field-name-field-description\";i:2;s:39:\"field-widget-text-textarea-with-summary\";}}s:7:\"#weight\";s:1:\"4\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:13:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:12:\"deluxe_suite\";s:11:\"#field_name\";s:17:\"field_description\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:3:{i:0;s:5:\"value\";i:1;s:7:\"summary\";i:2;s:6:\"format\";}s:6:\"#title\";s:11:\"Description\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:5:\"#type\";s:11:\"text_format\";s:14:\"#default_value\";s:1206:\"Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n\";s:5:\"#rows\";s:2:\"20\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:9:\"text-full\";}}s:7:\"#format\";s:13:\"filtered_html\";s:10:\"#base_type\";s:8:\"textarea\";s:7:\"summary\";a:10:{s:5:\"#type\";s:5:\"value\";s:14:\"#default_value\";s:0:\"\";s:6:\"#title\";s:7:\"Summary\";s:5:\"#rows\";i:5;s:12:\"#description\";s:61:\"Leave blank to use trimmed value of full text as the summary.\";s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:34:\"modules/field/modules/text/text.js\";}}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:12:\"text-summary\";}}s:7:\"#prefix\";s:34:\"<div class=\"text-summary-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:7:\"#weight\";i:-10;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:17:\"field_description\";s:12:\"#cardinality\";s:1:\"1\";s:6:\"#title\";s:11:\"Description\";s:9:\"#required\";i:1;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:45:\"<div id=\"field-description-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:26:\"rooms_booking_unit_options\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:24:\"field-type-rooms-options\";i:1;s:37:\"field-name-rooms-booking-unit-options\";i:2;s:35:\"field-widget-rooms-options-combined\";}}s:7:\"#weight\";i:5;s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:14:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:12:\"deluxe_suite\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:4:{i:0;s:4:\"name\";i:1;s:8:\"quantity\";i:2;s:9:\"operation\";i:3;s:5:\"value\";}s:6:\"#title\";s:0:\"\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:0;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:4:\"name\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:4:\"Name\";s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:18:\"rooms-option--name\";}}}s:8:\"quantity\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:8:\"Quantity\";s:8:\"#options\";a:10:{i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;i:8;i:9;i:9;i:10;i:10;}s:14:\"#default_value\";N;s:12:\"#description\";s:43:\"How many of this option should be available\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:22:\"rooms-option--quantity\";}}}s:9:\"operation\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:9:\"Operation\";s:8:\"#options\";a:7:{s:3:\"add\";s:12:\"Add to price\";s:9:\"add-daily\";s:22:\"Add to price per night\";s:3:\"sub\";s:19:\"Subtract from price\";s:9:\"sub-daily\";s:29:\"Subtract from price per night\";s:7:\"replace\";s:13:\"Replace price\";s:8:\"increase\";s:26:\"Increase price by % amount\";s:8:\"decrease\";s:26:\"Decrease price by % amount\";}s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"rooms-option--operation\";}}}s:5:\"value\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:5:\"Value\";s:5:\"#size\";i:10;s:14:\"#default_value\";N;s:17:\"#element_validate\";a:1:{i:0;s:33:\"element_validate_integer_positive\";}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"rooms-option--value\";}}}s:6:\"remove\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:6:\"Remove\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:27:\"rooms-option--remove-button\";}}}s:9:\"#attached\";a:2:{s:2:\"js\";a:1:{i:0;s:50:\"sites/all/modules/rooms/js/rooms_options_widget.js\";}s:3:\"css\";a:1:{i:0;s:52:\"sites/all/modules/rooms/css/rooms_options_widget.css\";}}s:7:\"_weight\";a:6:{s:5:\"#type\";s:6:\"weight\";s:6:\"#title\";s:16:\"Weight for row 1\";s:14:\"#title_display\";s:9:\"invisible\";s:6:\"#delta\";i:0;s:14:\"#default_value\";i:0;s:7:\"#weight\";i:100;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:12:\"#cardinality\";s:2:\"-1\";s:6:\"#title\";s:7:\"Options\";s:9:\"#required\";b:0;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:54:\"<div id=\"rooms-booking-unit-options-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:8:\"add_more\";a:7:{s:5:\"#type\";s:6:\"submit\";s:5:\"#name\";s:35:\"rooms_booking_unit_options_add_more\";s:6:\"#value\";s:16:\"Add another item\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:21:\"field-add-more-submit\";}}s:24:\"#limit_validation_errors\";a:1:{i:0;a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}}s:7:\"#submit\";a:1:{i:0;s:21:\"field_add_more_submit\";}s:5:\"#ajax\";a:3:{s:8:\"callback\";s:17:\"field_add_more_js\";s:7:\"wrapper\";s:43:\"rooms-booking-unit-options-add-more-wrapper\";s:6:\"effect\";s:4:\"fade\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:11:\"#pre_render\";a:1:{i:0;s:30:\"_field_extra_fields_pre_render\";}s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:12:\"deluxe_suite\";s:19:\"additional_settings\";a:2:{s:5:\"#type\";s:13:\"vertical_tabs\";s:7:\"#weight\";i:99;}s:12:\"availability\";a:9:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#group\";s:19:\"additional_settings\";s:6:\"#title\";s:6:\"Status\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:80;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"unit-form-availability \";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:8:\"bookable\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:8:\"Bookable\";s:12:\"#description\";s:153:\"Uncheck this to temporarily prevent the unit from being booked or appearing in any searches without affecting the scheduled availability on the calendar.\";s:14:\"#default_value\";s:1:\"1\";}s:13:\"default_state\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:20:\"Default availability\";s:8:\"#options\";a:4:{i:0;s:11:\"Unavailable\";i:1;s:9:\"Available\";i:2;s:10:\"On Request\";i:3;s:17:\"Anonymous Booking\";}s:14:\"#default_value\";s:1:\"1\";s:12:\"#description\";s:50:\"Choose what state to leave the unit in by default.\";}}s:6:\"author\";a:11:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:21:\"Authoring information\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:16:\"unit-form-author\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:2:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";i:1;a:2:{s:4:\"type\";s:7:\"setting\";s:4:\"data\";a:1:{s:9:\"anonymous\";s:9:\"Anonymous\";}}}}s:7:\"#weight\";i:90;s:11:\"author_name\";a:7:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored by\";s:10:\"#maxlength\";i:60;s:18:\"#autocomplete_path\";s:17:\"user/autocomplete\";s:14:\"#default_value\";s:5:\"admin\";s:7:\"#weight\";i:-1;s:12:\"#description\";s:55:\"Leave blank for <em class=\"placeholder\">Anonymous</em>.\";}s:4:\"date\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored on\";s:10:\"#maxlength\";i:25;s:12:\"#description\";s:214:\"Format: <em class=\"placeholder\">2012-06-16 23:25:42 +0800</em>. The date format is YYYY-MM-DD and <em class=\"placeholder\">+0800</em> is the time zone offset from UTC. Leave blank to use the time of form submission.\";s:14:\"#default_value\";s:25:\"2012-06-16 23:25:42 +0800\";}}s:7:\"options\";a:10:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:18:\"Publishing options\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"unit-form-published\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:7:\"#weight\";i:95;s:6:\"status\";a:3:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:9:\"Published\";s:14:\"#default_value\";s:1:\"1\";}}s:7:\"actions\";a:4:{s:5:\"#type\";s:7:\"actions\";s:5:\"#tree\";b:0;s:6:\"submit\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:9:\"Save Unit\";s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}}s:6:\"delete\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:11:\"Delete Unit\";s:7:\"#suffix\";s:53:\"<a href=\"/drupal7/hotel/admin/rooms/units\">Cancel</a>\";s:7:\"#submit\";a:1:{i:0;s:29:\"rooms_unit_form_submit_delete\";}s:7:\"#weight\";i:45;}}s:9:\"#validate\";a:1:{i:0;s:29:\"rooms_unit_edit_form_validate\";}s:8:\"#form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"#type\";s:4:\"form\";s:9:\"#build_id\";s:48:\"form-lLBFBc9zsPFg3tRMSAzEPGjyqnRiLERTvwIQodgBH1o\";s:13:\"form_build_id\";a:5:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-lLBFBc9zsPFg3tRMSAzEPGjyqnRiLERTvwIQodgBH1o\";s:3:\"#id\";s:48:\"form-lLBFBc9zsPFg3tRMSAzEPGjyqnRiLERTvwIQodgBH1o\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}}s:6:\"#token\";s:20:\"rooms_unit_edit_form\";s:10:\"form_token\";a:4:{s:3:\"#id\";s:36:\"edit-rooms-unit-edit-form-form-token\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:43:\"Qtu5MJd7pX3R9fynIvfKJ4F19I0RTAuKS0jN24SGYT8\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:20:\"rooms_unit_edit_form\";s:3:\"#id\";s:25:\"edit-rooms-unit-edit-form\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:20:\"rooms-unit-edit-form\";s:7:\"#method\";s:4:\"post\";s:7:\"#action\";s:45:\"/drupal7/hotel/admin/rooms/units/unit/17/edit\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:5:\"#tree\";b:0;s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}s:6:\"#theme\";a:1:{i:0;s:20:\"rooms_unit_edit_form\";}s:12:\"#cache_token\";s:43:\"_0Nqq7kbxACp9xFRIcu1io57GJhTq2Xwy9d-QUy3irw\";}',1500477104,1500455504,1),('form_form-N_fv1q-95TtRYaEeJt7gt57POY1q4dPP1JXyglhd7fU','a:25:{s:7:\"#action\";s:23:\"/drupal7/hotel/bookings\";s:18:\"show_view_elements\";a:2:{s:5:\"#type\";s:5:\"value\";s:6:\"#value\";b:1;}s:7:\"#prefix\";s:43:\"<div class=\"commerce-line-item-views-form\">\";s:7:\"#suffix\";s:6:\"</div>\";s:6:\"#theme\";s:21:\"views_form_views_form\";s:9:\"#validate\";a:1:{i:0;s:30:\"views_form_views_form_validate\";}s:7:\"#submit\";a:2:{i:0;s:28:\"views_form_views_form_submit\";i:1;s:46:\"commerce_line_item_line_item_views_form_submit\";}s:6:\"output\";a:3:{s:5:\"#type\";s:6:\"markup\";s:7:\"#markup\";s:1221:\"<table class=\"views-table cols-4\" >\n         <thead>\n      <tr>\n                  <th class=\"views-field views-field-line-item-label\"  scope=\"col\">\n            Booking          </th>\n                  <th class=\"views-field views-field-commerce-unit-price\"  scope=\"col\">\n            Price          </th>\n                  <th class=\"views-field views-field-edit-delete\"  scope=\"col\">\n            Remove          </th>\n                  <th class=\"views-field views-field-commerce-total\"  scope=\"col\">\n            Total          </th>\n              </tr>\n    </thead>\n    <tbody>\n          <tr class=\"odd views-row-first views-row-last\">\n                  <td class=\"views-field views-field-line-item-label\" >\n            Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)          </td>\n                  <td class=\"views-field views-field-commerce-unit-price price\" >\n            $84,000.00          </td>\n                  <td class=\"views-field views-field-edit-delete\" >\n            <!--form-item-edit_delete--0-->          </td>\n                  <td class=\"views-field views-field-commerce-total price\" >\n            $84,000.00          </td>\n              </tr>\n      </tbody>\n</table>\n\";s:7:\"#weight\";i:50;}s:11:\"edit_delete\";a:2:{s:5:\"#tree\";b:1;i:0;a:6:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:6:\"Remove\";s:5:\"#name\";s:18:\"delete-line-item-0\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:16:\"delete-line-item\";}}s:13:\"#line_item_id\";s:2:\"16\";s:7:\"#submit\";a:3:{i:0;s:28:\"views_form_views_form_submit\";i:1;s:46:\"commerce_line_item_line_item_views_form_submit\";i:2;s:42:\"commerce_cart_line_item_delete_form_submit\";}}}s:14:\"#substitutions\";a:2:{s:5:\"#type\";s:5:\"value\";s:6:\"#value\";a:1:{i:0;a:3:{s:11:\"placeholder\";s:31:\"<!--form-item-edit_delete--0-->\";s:10:\"field_name\";s:11:\"edit_delete\";s:6:\"row_id\";i:0;}}}s:7:\"actions\";a:4:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:2:{i:0;s:12:\"form-actions\";i:1;s:26:\"commerce-line-item-actions\";}}s:7:\"#weight\";i:100;s:8:\"checkout\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:8:\"Checkout\";s:7:\"#weight\";i:5;s:7:\"#access\";b:1;s:7:\"#submit\";a:3:{i:0;s:28:\"views_form_views_form_submit\";i:1;s:46:\"commerce_line_item_line_item_views_form_submit\";i:2;s:45:\"commerce_checkout_line_item_views_form_submit\";}}}s:8:\"#form_id\";s:36:\"views_form_booking_cart_form_default\";s:5:\"#type\";s:4:\"form\";s:9:\"#build_id\";s:48:\"form-N_fv1q-95TtRYaEeJt7gt57POY1q4dPP1JXyglhd7fU\";s:13:\"form_build_id\";a:5:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-N_fv1q-95TtRYaEeJt7gt57POY1q4dPP1JXyglhd7fU\";s:3:\"#id\";s:48:\"form-N_fv1q-95TtRYaEeJt7gt57POY1q4dPP1JXyglhd7fU\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}}s:6:\"#token\";s:36:\"views_form_booking_cart_form_default\";s:10:\"form_token\";a:4:{s:3:\"#id\";s:52:\"edit-views-form-booking-cart-form-default-form-token\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:43:\"-Wwkg25dWo3xojwYtqDoUy-QZWzCWweZKRP3XmWHSQ8\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:36:\"views_form_booking_cart_form_default\";s:3:\"#id\";s:41:\"edit-views-form-booking-cart-form-default\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:36:\"views-form-booking-cart-form-default\";s:7:\"#method\";s:4:\"post\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:5:\"#tree\";b:0;s:8:\"#parents\";a:0:{}s:9:\"#attached\";a:2:{s:3:\"css\";a:1:{i:0;s:79:\"sites/all/modules/commerce/modules/line_item/theme/commerce_line_item.theme.css\";}s:2:\"js\";a:1:{i:0;s:66:\"sites/all/modules/commerce/modules/line_item/commerce_line_item.js\";}}s:12:\"#cache_token\";s:43:\"_0Nqq7kbxACp9xFRIcu1io57GJhTq2Xwy9d-QUy3irw\";}',1500476866,1500455266,1),('form_form-RV5tK0n4kGVsoVp9BF-8vKe8LLKlT7evDhcjC1NMKrc','a:36:{s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:42:\"rooms-management-form rooms-unit-edit-form\";}}s:9:\"#attached\";a:1:{s:3:\"css\";a:1:{i:0;s:61:\"sites/all/modules/rooms/modules/rooms_unit/css/rooms_unit.css\";}}s:4:\"name\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:9:\"Unit name\";s:14:\"#default_value\";s:14:\"Basic Room - 3\";s:10:\"#maxlength\";i:255;s:9:\"#required\";b:1;s:7:\"#weight\";i:-99;}s:10:\"base_price\";a:8:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:10:\"Base price\";s:14:\"#default_value\";s:5:\"50.00\";s:5:\"#size\";s:1:\"5\";s:13:\"#field_suffix\";s:18:\"Per unit per night\";s:10:\"#maxlength\";i:10;s:9:\"#required\";b:1;s:7:\"#weight\";i:-98;}s:14:\"guest_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:17:\"Sleeping capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-97;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-guest-capacity\";}}s:10:\"min_sleeps\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person minimum\";}s:10:\"max_sleeps\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"2\";s:13:\"#field_suffix\";s:14:\"Person maximum\";s:12:\"#description\";s:70:\"The total number of guests (adults and children) allowed in this unit.\";}}s:14:\"child_capacity\";a:7:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:14:\"Child capacity\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:-96;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:25:\"rooms-unit-child-capacity\";}}s:12:\"min_children\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child minimum\";}s:12:\"max_children\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:1:\"0\";s:13:\"#field_suffix\";s:13:\"Child maximum\";s:12:\"#description\";s:44:\"The number of children allowed in this unit.\";}}s:4:\"data\";a:3:{s:5:\"#tree\";b:1;s:7:\"#weight\";i:-95;s:15:\"bed_arrangement\";a:5:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#title\";s:15:\"Bed arrangement\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:26:\"rooms-unit-bed-arrangement\";}}s:7:\"singles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Single beds\";}s:7:\"doubles\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:5:\"#size\";i:5;s:14:\"#default_value\";s:0:\"\";s:13:\"#field_suffix\";s:11:\"Double beds\";}}}s:8:\"#parents\";a:0:{}s:7:\"#entity\";O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"16\";s:4:\"type\";s:11:\"basic_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:14:\"Basic Room - 3\";s:7:\"created\";s:10:\"1339860325\";s:7:\"changed\";s:10:\"1339860325\";s:10:\"base_price\";s:5:\"50.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-1.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-1.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10673\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860324\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1210:\"In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1224:\"<p>In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.</p>\n<p>Quisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.</p>\n<p>Donec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:25:25 +0800\";s:11:\"author_name\";s:5:\"admin\";}s:11:\"field_image\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:16:\"field-type-image\";i:1;s:22:\"field-name-field-image\";i:2;s:24:\"field-widget-image-image\";}}s:7:\"#weight\";s:1:\"2\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:5:{i:0;a:19:{s:7:\"#entity\";r:82;s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:11:\"basic_suite\";s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:5:{i:0;s:3:\"fid\";i:1;s:3:\"alt\";i:2;s:5:\"title\";i:3;s:5:\"width\";i:4;s:6:\"height\";}s:6:\"#title\";s:5:\"Image\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:5:\"#type\";s:12:\"managed_file\";s:16:\"#upload_location\";s:20:\"public://image/rooms\";s:18:\"#upload_validators\";a:2:{s:18:\"file_validate_size\";a:1:{i:0;d:52428800000;}s:24:\"file_validate_extensions\";a:1:{i:0;s:16:\"png gif jpg jpeg\";}}s:15:\"#value_callback\";s:23:\"file_field_widget_value\";s:8:\"#process\";a:3:{i:0;s:25:\"file_managed_file_process\";i:1;s:25:\"file_field_widget_process\";i:2;s:26:\"image_field_widget_process\";}s:19:\"#progress_indicator\";s:8:\"throbber\";s:9:\"#extended\";b:1;s:14:\"#default_value\";a:13:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-1.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-1.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10673\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860324\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:11:\"#field_name\";s:11:\"field_image\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:17:\"field_description\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:28:\"field-type-text-with-summary\";i:1;s:28:\"field-name-field-description\";i:2;s:39:\"field-widget-text-textarea-with-summary\";}}s:7:\"#weight\";s:1:\"3\";s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:13:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:11:\"basic_suite\";s:11:\"#field_name\";s:17:\"field_description\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:3:{i:0;s:5:\"value\";i:1;s:7:\"summary\";i:2;s:6:\"format\";}s:6:\"#title\";s:11:\"Description\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:1;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:5:\"#type\";s:11:\"text_format\";s:14:\"#default_value\";s:1210:\"In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n\";s:5:\"#rows\";s:2:\"20\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:9:\"text-full\";}}s:7:\"#format\";s:13:\"filtered_html\";s:10:\"#base_type\";s:8:\"textarea\";s:7:\"summary\";a:10:{s:5:\"#type\";s:5:\"value\";s:14:\"#default_value\";s:0:\"\";s:6:\"#title\";s:7:\"Summary\";s:5:\"#rows\";i:5;s:12:\"#description\";s:61:\"Leave blank to use trimmed value of full text as the summary.\";s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:34:\"modules/field/modules/text/text.js\";}}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:12:\"text-summary\";}}s:7:\"#prefix\";s:34:\"<div class=\"text-summary-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:7:\"#weight\";i:-10;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:17:\"field_description\";s:12:\"#cardinality\";s:1:\"1\";s:6:\"#title\";s:11:\"Description\";s:9:\"#required\";i:1;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:45:\"<div id=\"field-description-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:26:\"rooms_booking_unit_options\";a:7:{s:5:\"#type\";s:9:\"container\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:3:{i:0;s:24:\"field-type-rooms-options\";i:1;s:37:\"field-name-rooms-booking-unit-options\";i:2;s:35:\"field-widget-rooms-options-combined\";}}s:7:\"#weight\";i:4;s:5:\"#tree\";b:1;s:9:\"#language\";s:3:\"und\";s:3:\"und\";a:14:{i:0;a:19:{s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#entity\";r:82;s:7:\"#bundle\";s:11:\"basic_suite\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}s:8:\"#columns\";a:4:{i:0;s:4:\"name\";i:1;s:8:\"quantity\";i:2;s:9:\"operation\";i:3;s:5:\"value\";}s:6:\"#title\";s:0:\"\";s:12:\"#description\";s:0:\"\";s:9:\"#required\";b:0;s:6:\"#delta\";i:0;s:7:\"#weight\";i:0;s:4:\"name\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:4:\"Name\";s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:18:\"rooms-option--name\";}}}s:8:\"quantity\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:8:\"Quantity\";s:8:\"#options\";a:10:{i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;i:8;i:9;i:9;i:10;i:10;}s:14:\"#default_value\";N;s:12:\"#description\";s:43:\"How many of this option should be available\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:22:\"rooms-option--quantity\";}}}s:9:\"operation\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:9:\"Operation\";s:8:\"#options\";a:7:{s:3:\"add\";s:12:\"Add to price\";s:9:\"add-daily\";s:22:\"Add to price per night\";s:3:\"sub\";s:19:\"Subtract from price\";s:9:\"sub-daily\";s:29:\"Subtract from price per night\";s:7:\"replace\";s:13:\"Replace price\";s:8:\"increase\";s:26:\"Increase price by % amount\";s:8:\"decrease\";s:26:\"Decrease price by % amount\";}s:14:\"#default_value\";N;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"rooms-option--operation\";}}}s:5:\"value\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:5:\"Value\";s:5:\"#size\";i:10;s:14:\"#default_value\";N;s:17:\"#element_validate\";a:1:{i:0;s:33:\"element_validate_integer_positive\";}s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"rooms-option--value\";}}}s:6:\"remove\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:6:\"Remove\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:27:\"rooms-option--remove-button\";}}}s:9:\"#attached\";a:2:{s:2:\"js\";a:1:{i:0;s:50:\"sites/all/modules/rooms/js/rooms_options_widget.js\";}s:3:\"css\";a:1:{i:0;s:52:\"sites/all/modules/rooms/css/rooms_options_widget.css\";}}s:7:\"_weight\";a:6:{s:5:\"#type\";s:6:\"weight\";s:6:\"#title\";s:16:\"Weight for row 1\";s:14:\"#title_display\";s:9:\"invisible\";s:6:\"#delta\";i:0;s:14:\"#default_value\";i:0;s:7:\"#weight\";i:100;}}s:6:\"#theme\";s:25:\"field_multiple_value_form\";s:11:\"#field_name\";s:26:\"rooms_booking_unit_options\";s:12:\"#cardinality\";s:2:\"-1\";s:6:\"#title\";s:7:\"Options\";s:9:\"#required\";b:0;s:12:\"#description\";s:0:\"\";s:7:\"#prefix\";s:54:\"<div id=\"rooms-booking-unit-options-add-more-wrapper\">\";s:7:\"#suffix\";s:6:\"</div>\";s:10:\"#max_delta\";i:0;s:8:\"add_more\";a:7:{s:5:\"#type\";s:6:\"submit\";s:5:\"#name\";s:35:\"rooms_booking_unit_options_add_more\";s:6:\"#value\";s:16:\"Add another item\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:21:\"field-add-more-submit\";}}s:24:\"#limit_validation_errors\";a:1:{i:0;a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}}s:7:\"#submit\";a:1:{i:0;s:21:\"field_add_more_submit\";}s:5:\"#ajax\";a:3:{s:8:\"callback\";s:17:\"field_add_more_js\";s:7:\"wrapper\";s:43:\"rooms-booking-unit-options-add-more-wrapper\";s:6:\"effect\";s:4:\"fade\";}}s:12:\"#after_build\";a:1:{i:0;s:30:\"field_form_element_after_build\";}s:9:\"#language\";s:3:\"und\";s:14:\"#field_parents\";a:0:{}}s:7:\"#access\";b:1;}s:11:\"#pre_render\";a:1:{i:0;s:30:\"_field_extra_fields_pre_render\";}s:12:\"#entity_type\";s:10:\"rooms_unit\";s:7:\"#bundle\";s:11:\"basic_suite\";s:19:\"additional_settings\";a:2:{s:5:\"#type\";s:13:\"vertical_tabs\";s:7:\"#weight\";i:99;}s:12:\"availability\";a:9:{s:5:\"#type\";s:8:\"fieldset\";s:6:\"#group\";s:19:\"additional_settings\";s:6:\"#title\";s:6:\"Status\";s:5:\"#tree\";b:0;s:7:\"#weight\";i:80;s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:23:\"unit-form-availability \";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:8:\"bookable\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:8:\"Bookable\";s:12:\"#description\";s:153:\"Uncheck this to temporarily prevent the unit from being booked or appearing in any searches without affecting the scheduled availability on the calendar.\";s:14:\"#default_value\";s:1:\"1\";}s:13:\"default_state\";a:5:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";s:20:\"Default availability\";s:8:\"#options\";a:4:{i:0;s:11:\"Unavailable\";i:1;s:9:\"Available\";i:2;s:10:\"On Request\";i:3;s:17:\"Anonymous Booking\";}s:14:\"#default_value\";s:1:\"1\";s:12:\"#description\";s:50:\"Choose what state to leave the unit in by default.\";}}s:6:\"author\";a:11:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:21:\"Authoring information\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:16:\"unit-form-author\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:2:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";i:1;a:2:{s:4:\"type\";s:7:\"setting\";s:4:\"data\";a:1:{s:9:\"anonymous\";s:9:\"Anonymous\";}}}}s:7:\"#weight\";i:90;s:11:\"author_name\";a:7:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored by\";s:10:\"#maxlength\";i:60;s:18:\"#autocomplete_path\";s:17:\"user/autocomplete\";s:14:\"#default_value\";s:5:\"admin\";s:7:\"#weight\";i:-1;s:12:\"#description\";s:55:\"Leave blank for <em class=\"placeholder\">Anonymous</em>.\";}s:4:\"date\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";s:11:\"Authored on\";s:10:\"#maxlength\";i:25;s:12:\"#description\";s:214:\"Format: <em class=\"placeholder\">2012-06-16 23:25:25 +0800</em>. The date format is YYYY-MM-DD and <em class=\"placeholder\">+0800</em> is the time zone offset from UTC. Leave blank to use the time of form submission.\";s:14:\"#default_value\";s:25:\"2012-06-16 23:25:25 +0800\";}}s:7:\"options\";a:10:{s:5:\"#type\";s:8:\"fieldset\";s:7:\"#access\";b:1;s:6:\"#title\";s:18:\"Publishing options\";s:12:\"#collapsible\";b:1;s:10:\"#collapsed\";b:1;s:6:\"#group\";s:19:\"additional_settings\";s:11:\"#attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:19:\"unit-form-published\";}}s:9:\"#attached\";a:1:{s:2:\"js\";a:1:{i:0;s:59:\"sites/all/modules/rooms/modules/rooms_unit/js/rooms_unit.js\";}}s:7:\"#weight\";i:95;s:6:\"status\";a:3:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";s:9:\"Published\";s:14:\"#default_value\";s:1:\"1\";}}s:7:\"actions\";a:4:{s:5:\"#type\";s:7:\"actions\";s:5:\"#tree\";b:0;s:6:\"submit\";a:3:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:9:\"Save Unit\";s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}}s:6:\"delete\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";s:11:\"Delete Unit\";s:7:\"#suffix\";s:53:\"<a href=\"/drupal7/hotel/admin/rooms/units\">Cancel</a>\";s:7:\"#submit\";a:1:{i:0;s:29:\"rooms_unit_form_submit_delete\";}s:7:\"#weight\";i:45;}}s:9:\"#validate\";a:1:{i:0;s:29:\"rooms_unit_edit_form_validate\";}s:8:\"#form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"#type\";s:4:\"form\";s:9:\"#build_id\";s:48:\"form-RV5tK0n4kGVsoVp9BF-8vKe8LLKlT7evDhcjC1NMKrc\";s:13:\"form_build_id\";a:5:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-RV5tK0n4kGVsoVp9BF-8vKe8LLKlT7evDhcjC1NMKrc\";s:3:\"#id\";s:48:\"form-RV5tK0n4kGVsoVp9BF-8vKe8LLKlT7evDhcjC1NMKrc\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}}s:6:\"#token\";s:20:\"rooms_unit_edit_form\";s:10:\"form_token\";a:4:{s:3:\"#id\";s:36:\"edit-rooms-unit-edit-form-form-token\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:43:\"Qtu5MJd7pX3R9fynIvfKJ4F19I0RTAuKS0jN24SGYT8\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:20:\"rooms_unit_edit_form\";s:3:\"#id\";s:25:\"edit-rooms-unit-edit-form\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:20:\"rooms-unit-edit-form\";s:7:\"#method\";s:4:\"post\";s:7:\"#action\";s:45:\"/drupal7/hotel/admin/rooms/units/unit/16/edit\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:5:\"#tree\";b:0;s:7:\"#submit\";a:1:{i:0;s:27:\"rooms_unit_edit_form_submit\";}s:6:\"#theme\";a:1:{i:0;s:20:\"rooms_unit_edit_form\";}s:12:\"#cache_token\";s:43:\"_0Nqq7kbxACp9xFRIcu1io57GJhTq2Xwy9d-QUy3irw\";}',1500477064,1500455464,1),('form_state_form-d-qKQdG4901GjNo1ST6LypMjAORGMHtDQ2AO0Woh_O0','a:10:{s:16:\"wrapper_callback\";s:28:\"entity_ui_main_form_defaults\";s:11:\"entity_type\";s:15:\"rooms_unit_type\";s:10:\"build_info\";a:3:{s:5:\"files\";a:2:{s:29:\"entity:includes/entity.ui.inc\";a:3:{s:4:\"type\";s:3:\"inc\";s:6:\"module\";s:6:\"entity\";s:4:\"name\";s:18:\"includes/entity.ui\";}s:4:\"menu\";s:68:\"sites/all/modules/rooms/modules/rooms_unit/rooms_unit_type.admin.inc\";}s:4:\"args\";a:3:{i:0;O:13:\"RoomsUnitType\":12:{s:4:\"type\";s:11:\"basic_suite\";s:5:\"label\";s:11:\"Basic Suite\";s:13:\"\0*\0entityType\";s:15:\"rooms_unit_type\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:2:\"id\";s:1:\"3\";s:6:\"weight\";s:1:\"0\";s:4:\"data\";a:6:{s:10:\"base_price\";s:2:\"50\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";N;s:12:\"max_children\";N;s:24:\"rooms_description_source\";N;}s:6:\"status\";s:1:\"1\";s:6:\"module\";N;s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}}i:1;s:4:\"edit\";i:2;s:15:\"rooms_unit_type\";}s:7:\"form_id\";s:20:\"rooms_unit_type_form\";}s:10:\"programmed\";b:0;s:30:\"programmed_bypass_access_check\";b:1;s:5:\"cache\";b:1;s:15:\"rooms_unit_type\";r:12;s:2:\"op\";s:4:\"edit\";s:5:\"field\";a:1:{s:26:\"rooms_booking_unit_options\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:37:\"field_data_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:41:\"field_revision_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}s:2:\"id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:4:\"type\";s:13:\"rooms_options\";s:6:\"module\";s:5:\"rooms\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:2:\"-1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:8:\"quantity\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;}s:9:\"operation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:5:\"value\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:15:\"rooms_unit_type\";a:1:{i:0;s:15:\"rooms_unit_type\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:22:\"rooms_options_combined\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"module\";s:5:\"rooms\";}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"82\";s:8:\"field_id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:11:\"entity_type\";s:15:\"rooms_unit_type\";s:6:\"bundle\";s:15:\"rooms_unit_type\";s:7:\"deleted\";s:1:\"0\";s:13:\"default_value\";N;}s:11:\"items_count\";i:0;s:13:\"array_parents\";a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}}s:13:\"process_input\";b:0;}',1500477334,1500455734,1),('form_state_form-DVJktaRaUTofYtvvpstMERE0Ydvon9Y1jTgJZmpq0-U','a:9:{s:10:\"build_info\";a:3:{s:4:\"args\";a:1:{i:0;O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"24\";s:4:\"type\";s:11:\"royal_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:14:\"Royal Room - 2\";s:7:\"created\";s:10:\"1339860445\";s:7:\"changed\";s:10:\"1339860445\";s:10:\"base_price\";s:7:\"2000.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"4\";s:10:\"max_sleeps\";s:1:\"4\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"5\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:17:\"superior room.JPG\";s:3:\"uri\";s:38:\"public://image/rooms/superior room.JPG\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:6:\"774810\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860445\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:4:\"2400\";s:6:\"height\";s:4:\"1895\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1210:\"Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1224:\"<p>Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.</p>\n<p>Mauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?</p>\n<p>Curabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:27:25 +0800\";s:11:\"author_name\";s:5:\"admin\";}}s:7:\"form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"files\";a:1:{s:4:\"menu\";s:63:\"sites/all/modules/rooms/modules/rooms_unit/rooms_unit.admin.inc\";}}s:10:\"programmed\";b:0;s:30:\"programmed_bypass_access_check\";b:1;s:5:\"cache\";b:1;s:10:\"rooms_unit\";r:4;s:5:\"field\";a:3:{s:11:\"field_image\";a:1:{s:3:\"und\";a:6:{s:5:\"field\";a:16:{s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:22:\"field_data_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:26:\"field_revision_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:2:\"id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:4:\"type\";s:5:\"image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:5:{s:3:\"fid\";a:4:{s:11:\"description\";s:54:\"The {file_managed}.fid being referenced in this field.\";s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:8:\"unsigned\";b:1;}s:3:\"alt\";a:4:{s:11:\"description\";s:56:\"Alternative image text, for the image\'s \'alt\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:5:\"title\";a:4:{s:11:\"description\";s:52:\"Image title text, for the image\'s \'title\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:5:\"width\";a:3:{s:11:\"description\";s:33:\"The width of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}s:6:\"height\";a:3:{s:11:\"description\";s:34:\"The height of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"bundles\";a:2:{s:4:\"node\";a:1:{i:0;s:7:\"article\";}s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}}}s:8:\"instance\";a:12:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"70\";s:8:\"field_id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:11:\"royal_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:11:\"field_image\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}s:5:\"items\";a:0:{}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:28:\"field_data_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:32:\"field_revision_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:4:\"type\";s:17:\"text_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:5:\"value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:7:\"summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:4:\"node\";a:1:{i:0;s:16:\"unit_description\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"4\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;s:2:\"id\";s:2:\"71\";s:8:\"field_id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:11:\"royal_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:17:\"field_description\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:26:\"rooms_booking_unit_options\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:37:\"field_data_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:41:\"field_revision_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}s:2:\"id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:4:\"type\";s:13:\"rooms_options\";s:6:\"module\";s:5:\"rooms\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:2:\"-1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:8:\"quantity\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;}s:9:\"operation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:5:\"value\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:15:\"rooms_unit_type\";a:1:{i:0;s:15:\"rooms_unit_type\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:22:\"rooms_options_combined\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"module\";s:5:\"rooms\";}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"80\";s:8:\"field_id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:11:\"royal_suite\";s:7:\"deleted\";s:1:\"0\";s:13:\"default_value\";N;}s:11:\"items_count\";i:0;s:13:\"array_parents\";a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}}s:13:\"process_input\";b:1;s:16:\"has_file_element\";b:1;s:13:\"invalid_token\";b:0;}',1500477299,1500455699,1),('form_state_form-G9EdxsEdtKrxdcyIiy-rfHt26MkUzTE42FMRUfKKeNg','a:8:{s:10:\"build_info\";a:3:{s:4:\"args\";a:1:{i:0;O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"17\";s:4:\"type\";s:12:\"deluxe_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:15:\"Deluxe Room - 1\";s:7:\"created\";s:10:\"1339860342\";s:7:\"changed\";s:10:\"1339861017\";s:10:\"base_price\";s:6:\"100.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"3\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-2.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10886\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860342\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1206:\"Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1216:\"<p>Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.</p>\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:25:42 +0800\";s:11:\"author_name\";s:5:\"admin\";}}s:7:\"form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"files\";a:1:{s:4:\"menu\";s:63:\"sites/all/modules/rooms/modules/rooms_unit/rooms_unit.admin.inc\";}}s:10:\"programmed\";b:0;s:30:\"programmed_bypass_access_check\";b:1;s:5:\"cache\";b:1;s:10:\"rooms_unit\";r:4;s:5:\"field\";a:3:{s:11:\"field_image\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:22:\"field_data_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:26:\"field_revision_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:2:\"id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:4:\"type\";s:5:\"image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:5:{s:3:\"fid\";a:4:{s:11:\"description\";s:54:\"The {file_managed}.fid being referenced in this field.\";s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:8:\"unsigned\";b:1;}s:3:\"alt\";a:4:{s:11:\"description\";s:56:\"Alternative image text, for the image\'s \'alt\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:5:\"title\";a:4:{s:11:\"description\";s:52:\"Image title text, for the image\'s \'title\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:5:\"width\";a:3:{s:11:\"description\";s:33:\"The width of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}s:6:\"height\";a:3:{s:11:\"description\";s:34:\"The height of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"bundles\";a:2:{s:4:\"node\";a:1:{i:0;s:7:\"article\";}s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}}}s:8:\"instance\";a:12:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"66\";s:8:\"field_id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:12:\"deluxe_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:11:\"field_image\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:28:\"field_data_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:32:\"field_revision_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:4:\"type\";s:17:\"text_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:5:\"value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:7:\"summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:4:\"node\";a:1:{i:0;s:16:\"unit_description\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"4\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;s:2:\"id\";s:2:\"67\";s:8:\"field_id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:12:\"deluxe_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:17:\"field_description\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:26:\"rooms_booking_unit_options\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:37:\"field_data_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:41:\"field_revision_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}s:2:\"id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:4:\"type\";s:13:\"rooms_options\";s:6:\"module\";s:5:\"rooms\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:2:\"-1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:8:\"quantity\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;}s:9:\"operation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:5:\"value\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:15:\"rooms_unit_type\";a:1:{i:0;s:15:\"rooms_unit_type\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:22:\"rooms_options_combined\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"module\";s:5:\"rooms\";}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"78\";s:8:\"field_id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:12:\"deluxe_suite\";s:7:\"deleted\";s:1:\"0\";s:13:\"default_value\";N;}s:11:\"items_count\";i:0;s:13:\"array_parents\";a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}}s:13:\"process_input\";b:0;s:16:\"has_file_element\";b:1;}',1500477115,1500455515,1),('form_state_form-lLBFBc9zsPFg3tRMSAzEPGjyqnRiLERTvwIQodgBH1o','a:8:{s:10:\"build_info\";a:3:{s:4:\"args\";a:1:{i:0;O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"17\";s:4:\"type\";s:12:\"deluxe_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:15:\"Deluxe Room - 1\";s:7:\"created\";s:10:\"1339860342\";s:7:\"changed\";s:10:\"1339861017\";s:10:\"base_price\";s:6:\"100.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"3\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-2.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-2.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10886\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860342\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1206:\"Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1216:\"<p>Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.</p>\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:25:42 +0800\";s:11:\"author_name\";s:5:\"admin\";}}s:7:\"form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"files\";a:1:{s:4:\"menu\";s:63:\"sites/all/modules/rooms/modules/rooms_unit/rooms_unit.admin.inc\";}}s:10:\"programmed\";b:0;s:30:\"programmed_bypass_access_check\";b:1;s:5:\"cache\";b:1;s:10:\"rooms_unit\";r:4;s:5:\"field\";a:3:{s:11:\"field_image\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:22:\"field_data_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:26:\"field_revision_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:2:\"id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:4:\"type\";s:5:\"image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:5:{s:3:\"fid\";a:4:{s:11:\"description\";s:54:\"The {file_managed}.fid being referenced in this field.\";s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:8:\"unsigned\";b:1;}s:3:\"alt\";a:4:{s:11:\"description\";s:56:\"Alternative image text, for the image\'s \'alt\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:5:\"title\";a:4:{s:11:\"description\";s:52:\"Image title text, for the image\'s \'title\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:5:\"width\";a:3:{s:11:\"description\";s:33:\"The width of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}s:6:\"height\";a:3:{s:11:\"description\";s:34:\"The height of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"bundles\";a:2:{s:4:\"node\";a:1:{i:0;s:7:\"article\";}s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}}}s:8:\"instance\";a:12:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"66\";s:8:\"field_id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:12:\"deluxe_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:11:\"field_image\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:28:\"field_data_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:32:\"field_revision_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:4:\"type\";s:17:\"text_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:5:\"value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:7:\"summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:4:\"node\";a:1:{i:0;s:16:\"unit_description\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"4\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;s:2:\"id\";s:2:\"67\";s:8:\"field_id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:12:\"deluxe_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:17:\"field_description\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:26:\"rooms_booking_unit_options\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:37:\"field_data_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:41:\"field_revision_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}s:2:\"id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:4:\"type\";s:13:\"rooms_options\";s:6:\"module\";s:5:\"rooms\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:2:\"-1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:8:\"quantity\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;}s:9:\"operation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:5:\"value\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:15:\"rooms_unit_type\";a:1:{i:0;s:15:\"rooms_unit_type\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:22:\"rooms_options_combined\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"module\";s:5:\"rooms\";}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"78\";s:8:\"field_id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:12:\"deluxe_suite\";s:7:\"deleted\";s:1:\"0\";s:13:\"default_value\";N;}s:11:\"items_count\";i:0;s:13:\"array_parents\";a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}}s:13:\"process_input\";b:0;s:16:\"has_file_element\";b:1;}',1500477104,1500455504,1),('form_state_form-N_fv1q-95TtRYaEeJt7gt57POY1q4dPP1JXyglhd7fU','a:8:{s:10:\"build_info\";a:3:{s:4:\"args\";a:2:{i:0;O:4:\"view\":59:{s:8:\"db_table\";s:10:\"views_view\";s:10:\"base_table\";s:14:\"commerce_order\";s:10:\"base_field\";s:8:\"order_id\";s:4:\"name\";s:17:\"booking_cart_form\";s:3:\"vid\";s:0:\"\";s:11:\"description\";s:36:\"Display a shopping cart update form.\";s:3:\"tag\";s:8:\"commerce\";s:10:\"human_name\";s:23:\"Review your reservation\";s:4:\"core\";i:0;s:11:\"api_version\";s:3:\"3.0\";s:8:\"disabled\";b:0;s:7:\"editing\";b:0;s:4:\"args\";a:1:{i:0;s:1:\"7\";}s:8:\"use_ajax\";b:0;s:6:\"result\";a:1:{i:0;O:8:\"stdClass\":9:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:2:\"16\";s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";s:18:\"commerce_line_item\";s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";s:18:\"commerce_line_item\";s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";s:18:\"commerce_line_item\";s:11:\"_field_data\";a:1:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";a:2:{s:11:\"entity_type\";s:18:\"commerce_line_item\";s:6:\"entity\";O:8:\"stdClass\":22:{s:12:\"line_item_id\";s:2:\"16\";s:8:\"order_id\";s:1:\"7\";s:4:\"type\";s:13:\"rooms_booking\";s:15:\"line_item_label\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:8:\"quantity\";s:4:\"1.00\";s:7:\"created\";s:10:\"1500455265\";s:7:\"changed\";s:10:\"1500455265\";s:4:\"data\";a:0:{}s:19:\"commerce_unit_price\";a:1:{s:3:\"und\";a:1:{i:0;a:3:{s:6:\"amount\";s:7:\"8400000\";s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}}}}s:14:\"commerce_total\";a:1:{s:3:\"und\";a:1:{i:0;a:3:{s:6:\"amount\";s:7:\"8400000\";s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}}}}s:16:\"commerce_product\";a:1:{s:3:\"und\";a:1:{i:0;a:1:{s:10:\"product_id\";s:1:\"1\";}}}s:19:\"rooms_booking_dates\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:10:\"2017-07-20\";s:6:\"value2\";s:10:\"2017-08-31\";s:8:\"timezone\";s:16:\"Asia/Krasnoyarsk\";s:11:\"timezone_db\";s:16:\"Asia/Krasnoyarsk\";s:9:\"date_type\";s:4:\"date\";}}}s:20:\"rooms_booked_unit_id\";a:1:{s:3:\"und\";a:1:{i:0;a:1:{s:5:\"value\";s:2:\"24\";}}}s:19:\"rooms_booked_status\";a:1:{s:3:\"und\";a:1:{i:0;a:1:{s:5:\"value\";s:1:\"1\";}}}s:18:\"rooms_booked_price\";a:1:{s:3:\"und\";a:1:{i:0;a:1:{s:5:\"value\";s:7:\"8400000\";}}}s:25:\"rooms_booked_bookingprice\";a:1:{s:3:\"und\";a:1:{i:0;a:1:{s:5:\"value\";s:5:\"84000\";}}}s:21:\"commerce_display_path\";a:1:{s:3:\"und\";a:1:{i:0;a:3:{s:5:\"value\";s:0:\"\";s:6:\"format\";N;s:10:\"safe_value\";s:0:\"\";}}}s:27:\"rooms_booking_number_people\";a:1:{s:3:\"und\";a:2:{i:0;a:1:{s:5:\"value\";s:1:\"2\";}i:1;a:1:{s:5:\"value\";s:1:\"0\";}}}s:21:\"rooms_booking_options\";a:0:{}s:23:\"rooms_booking_reference\";a:0:{}s:27:\"rooms_booking_children_ages\";a:0:{}s:11:\"rdf_mapping\";a:0:{}}}}s:27:\"field_commerce_display_path\";a:1:{i:0;a:2:{s:8:\"rendered\";a:2:{s:7:\"#markup\";s:0:\"\";s:7:\"#access\";b:1;}s:3:\"raw\";a:3:{s:5:\"value\";s:0:\"\";s:6:\"format\";N;s:10:\"safe_value\";s:0:\"\";}}}s:25:\"field_commerce_unit_price\";a:1:{i:0;a:2:{s:8:\"rendered\";a:2:{s:7:\"#markup\";s:10:\"$84,000.00\";s:7:\"#access\";b:1;}s:3:\"raw\";a:3:{s:6:\"amount\";s:7:\"8400000\";s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}}}}s:20:\"field_commerce_total\";a:1:{i:0;a:2:{s:8:\"rendered\";a:2:{s:7:\"#markup\";s:10:\"$84,000.00\";s:7:\"#access\";b:1;}s:3:\"raw\";a:3:{s:6:\"amount\";s:7:\"8400000\";s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}}}}}}s:12:\"current_page\";N;s:14:\"items_per_page\";N;s:6:\"offset\";N;s:10:\"total_rows\";N;s:17:\"exposed_raw_input\";a:0:{}s:8:\"old_view\";a:1:{i:0;N;}s:12:\"parent_views\";a:0:{}s:13:\"is_attachment\";b:0;s:15:\"current_display\";s:7:\"default\";s:5:\"query\";O:26:\"views_plugin_query_default\":28:{s:11:\"table_queue\";a:3:{s:14:\"commerce_order\";a:4:{s:5:\"alias\";s:14:\"commerce_order\";s:5:\"table\";s:14:\"commerce_order\";s:12:\"relationship\";s:14:\"commerce_order\";s:4:\"join\";N;}s:30:\"field_data_commerce_line_items\";a:5:{s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:3:\"num\";i:1;s:5:\"alias\";s:30:\"field_data_commerce_line_items\";s:4:\"join\";O:10:\"views_join\":9:{s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:10:\"left_table\";s:14:\"commerce_order\";s:10:\"left_field\";s:8:\"order_id\";s:5:\"field\";s:9:\"entity_id\";s:5:\"extra\";a:2:{i:0;a:2:{s:5:\"field\";s:11:\"entity_type\";s:5:\"value\";s:14:\"commerce_order\";}i:1;a:3:{s:5:\"field\";s:7:\"deleted\";s:5:\"value\";i:0;s:7:\"numeric\";b:1;}}s:4:\"type\";s:4:\"LEFT\";s:10:\"definition\";a:5:{s:10:\"left_field\";s:8:\"order_id\";s:5:\"field\";s:9:\"entity_id\";s:5:\"extra\";a:2:{i:0;a:2:{s:5:\"field\";s:11:\"entity_type\";s:5:\"value\";s:14:\"commerce_order\";}i:1;a:3:{s:5:\"field\";s:7:\"deleted\";s:5:\"value\";i:0;s:7:\"numeric\";b:1;}}s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:10:\"left_table\";s:14:\"commerce_order\";}s:10:\"extra_type\";s:3:\"AND\";s:8:\"adjusted\";b:1;}s:12:\"relationship\";s:14:\"commerce_order\";}s:49:\"commerce_line_item_field_data_commerce_line_items\";a:5:{s:5:\"table\";s:18:\"commerce_line_item\";s:3:\"num\";i:1;s:5:\"alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:4:\"join\";O:10:\"views_join\":10:{s:5:\"table\";s:18:\"commerce_line_item\";s:10:\"left_table\";s:30:\"field_data_commerce_line_items\";s:10:\"left_field\";s:32:\"commerce_line_items_line_item_id\";s:5:\"field\";s:12:\"line_item_id\";s:5:\"extra\";N;s:4:\"type\";s:5:\"INNER\";s:10:\"definition\";a:13:{s:5:\"title\";s:21:\"Referenced line items\";s:5:\"label\";s:44:\"Line items referenced by commerce_line_items\";s:4:\"help\";s:127:\"Relate this entity to line items referenced by its commerce_line_items value.<br />Appears in: commerce_order (commerce_order).\";s:4:\"base\";s:18:\"commerce_line_item\";s:10:\"base field\";s:12:\"line_item_id\";s:7:\"handler\";s:26:\"views_handler_relationship\";s:5:\"group\";s:14:\"Commerce Order\";s:11:\"title short\";s:10:\"Line items\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:12:\"line_item_id\";s:10:\"left_table\";s:30:\"field_data_commerce_line_items\";s:10:\"left_field\";s:32:\"commerce_line_items_line_item_id\";s:4:\"type\";s:5:\"INNER\";}s:7:\"options\";a:8:{s:2:\"id\";s:32:\"commerce_line_items_line_item_id\";s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"field\";s:32:\"commerce_line_items_line_item_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:44:\"Line items referenced by commerce_line_items\";s:8:\"required\";i:1;}s:10:\"extra_type\";s:3:\"AND\";s:8:\"adjusted\";b:1;}s:12:\"relationship\";s:14:\"commerce_order\";}}s:6:\"tables\";a:1:{s:14:\"commerce_order\";a:3:{s:14:\"commerce_order\";a:2:{s:5:\"count\";i:1;s:5:\"alias\";s:14:\"commerce_order\";}s:30:\"field_data_commerce_line_items\";a:2:{s:5:\"count\";i:1;s:5:\"alias\";s:30:\"field_data_commerce_line_items\";}s:49:\"commerce_line_item_field_data_commerce_line_items\";a:2:{s:5:\"count\";i:1;s:5:\"alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";}}}s:13:\"relationships\";a:2:{s:14:\"commerce_order\";a:4:{s:4:\"link\";N;s:5:\"table\";s:14:\"commerce_order\";s:5:\"alias\";s:14:\"commerce_order\";s:4:\"base\";s:14:\"commerce_order\";}s:49:\"commerce_line_item_field_data_commerce_line_items\";a:3:{s:4:\"link\";s:14:\"commerce_order\";s:5:\"table\";s:18:\"commerce_line_item\";s:4:\"base\";s:18:\"commerce_line_item\";}}s:5:\"where\";a:2:{i:1;a:3:{s:10:\"conditions\";a:0:{}s:4:\"args\";a:0:{}s:4:\"type\";s:3:\"AND\";}i:0;a:3:{s:10:\"conditions\";a:2:{i:0;a:3:{s:5:\"field\";s:54:\"commerce_line_item_field_data_commerce_line_items.type\";s:5:\"value\";a:2:{i:0;s:7:\"product\";i:1;s:13:\"rooms_booking\";}s:8:\"operator\";s:2:\"in\";}i:1;a:3:{s:5:\"field\";s:51:\"commerce_order.order_id = :commerce_order_order_id \";s:5:\"value\";a:1:{s:24:\":commerce_order_order_id\";s:1:\"7\";}s:8:\"operator\";s:7:\"formula\";}}s:4:\"args\";a:0:{}s:4:\"type\";s:3:\"AND\";}}s:6:\"having\";a:0:{}s:14:\"group_operator\";s:3:\"AND\";s:7:\"orderby\";a:1:{i:0;a:2:{s:5:\"field\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:9:\"direction\";s:3:\"ASC\";}}s:7:\"groupby\";a:0:{}s:6:\"fields\";a:5:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";a:3:{s:5:\"field\";s:12:\"line_item_id\";s:5:\"table\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:5:\"alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";}s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";a:3:{s:5:\"field\";s:20:\"\'commerce_line_item\'\";s:5:\"table\";N;s:5:\"alias\";s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";}s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";a:3:{s:5:\"field\";s:15:\"line_item_label\";s:5:\"table\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:5:\"alias\";s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";}s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";a:3:{s:5:\"field\";s:20:\"\'commerce_line_item\'\";s:5:\"table\";N;s:5:\"alias\";s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";}s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";a:3:{s:5:\"field\";s:20:\"\'commerce_line_item\'\";s:5:\"table\";N;s:5:\"alias\";s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";}}s:6:\"header\";a:0:{}s:8:\"distinct\";b:0;s:13:\"has_aggregate\";b:0;s:19:\"get_count_optimized\";b:0;s:5:\"pager\";O:23:\"views_plugin_pager_none\":9:{s:12:\"current_page\";N;s:11:\"total_items\";i:1;s:4:\"view\";R:4;s:7:\"display\";O:13:\"views_display\":8:{s:15:\"display_options\";a:14:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:1:{s:13:\"query_comment\";b:0;}}s:5:\"title\";s:13:\"Shopping cart\";s:6:\"access\";a:1:{s:4:\"type\";s:4:\"none\";}s:5:\"cache\";a:1:{s:4:\"type\";s:4:\"none\";}s:12:\"exposed_form\";a:1:{s:4:\"type\";s:5:\"basic\";}s:5:\"pager\";a:1:{s:4:\"type\";s:4:\"none\";}s:12:\"style_plugin\";s:5:\"table\";s:13:\"style_options\";a:5:{s:7:\"columns\";a:6:{s:21:\"commerce_display_path\";s:21:\"commerce_display_path\";s:15:\"line_item_title\";s:15:\"line_item_title\";s:19:\"commerce_unit_price\";s:19:\"commerce_unit_price\";s:13:\"edit_quantity\";s:13:\"edit_quantity\";s:11:\"edit_delete\";s:11:\"edit_delete\";s:14:\"commerce_total\";s:14:\"commerce_total\";}s:7:\"default\";s:2:\"-1\";s:4:\"info\";a:6:{s:21:\"commerce_display_path\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:15:\"line_item_title\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:19:\"commerce_unit_price\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:13:\"edit_quantity\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:11:\"edit_delete\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:14:\"commerce_total\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}}s:8:\"override\";i:1;s:6:\"sticky\";i:0;}s:6:\"footer\";a:1:{s:11:\"order_total\";a:4:{s:2:\"id\";s:11:\"order_total\";s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:11:\"order_total\";s:5:\"empty\";b:0;}}s:13:\"relationships\";a:1:{s:32:\"commerce_line_items_line_item_id\";a:4:{s:2:\"id\";s:32:\"commerce_line_items_line_item_id\";s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"field\";s:32:\"commerce_line_items_line_item_id\";s:8:\"required\";i:1;}}s:6:\"fields\";a:5:{s:21:\"commerce_display_path\";a:12:{s:2:\"id\";s:21:\"commerce_display_path\";s:5:\"table\";s:32:\"field_data_commerce_display_path\";s:5:\"field\";s:21:\"commerce_display_path\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:17:\"field_api_classes\";i:0;}s:15:\"line_item_label\";a:11:{s:2:\"id\";s:15:\"line_item_label\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:15:\"line_item_label\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:7:\"Booking\";s:5:\"alter\";a:13:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";i:0;s:15:\"trim_whitespace\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";i:0;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";i:1;}s:19:\"commerce_unit_price\";a:14:{s:2:\"id\";s:19:\"commerce_unit_price\";s:5:\"table\";s:30:\"field_data_commerce_unit_price\";s:5:\"field\";s:19:\"commerce_unit_price\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:5:\"Price\";s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:13:\"element_class\";s:5:\"price\";s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:17:\"click_sort_column\";s:6:\"amount\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:17:\"field_api_classes\";i:0;}s:11:\"edit_delete\";a:10:{s:2:\"id\";s:11:\"edit_delete\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:11:\"edit_delete\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:6:\"Remove\";s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;}s:14:\"commerce_total\";a:13:{s:2:\"id\";s:14:\"commerce_total\";s:5:\"table\";s:25:\"field_data_commerce_total\";s:5:\"field\";s:14:\"commerce_total\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:13:\"element_class\";s:5:\"price\";s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:17:\"click_sort_column\";s:6:\"amount\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:17:\"field_api_classes\";i:0;}}s:5:\"sorts\";a:1:{s:12:\"line_item_id\";a:4:{s:2:\"id\";s:12:\"line_item_id\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:12:\"line_item_id\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";}}s:9:\"arguments\";a:1:{s:8:\"order_id\";a:9:{s:2:\"id\";s:8:\"order_id\";s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:8:\"order_id\";s:14:\"default_action\";s:5:\"empty\";s:21:\"default_argument_type\";s:5:\"fixed\";s:7:\"summary\";a:2:{s:17:\"number_of_records\";s:1:\"0\";s:6:\"format\";s:15:\"default_summary\";}s:15:\"summary_options\";a:1:{s:14:\"items_per_page\";s:2:\"25\";}s:12:\"break_phrase\";i:0;s:3:\"not\";i:0;}}s:7:\"filters\";a:1:{s:22:\"product_line_item_type\";a:6:{s:2:\"id\";s:22:\"product_line_item_type\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:22:\"product_line_item_type\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:0;}}}s:8:\"db_table\";s:13:\"views_display\";s:3:\"vid\";i:0;s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:8:\"Defaults\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:7:\"handler\";O:28:\"views_plugin_display_default\":11:{s:4:\"view\";R:4;s:8:\"handlers\";a:8:{s:5:\"field\";a:5:{s:21:\"commerce_display_path\";O:25:\"views_handler_field_field\":25:{s:5:\"items\";a:0:{}s:10:\"field_info\";a:16:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:1:{s:10:\"max_length\";i:255;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:32:\"field_data_commerce_display_path\";a:2:{s:5:\"value\";s:27:\"commerce_display_path_value\";s:6:\"format\";s:28:\"commerce_display_path_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:36:\"field_revision_commerce_display_path\";a:2:{s:5:\"value\";s:27:\"commerce_display_path_value\";s:6:\"format\";s:28:\"commerce_display_path_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:2:\"14\";s:10:\"field_name\";s:21:\"commerce_display_path\";s:4:\"type\";s:4:\"text\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"1\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:2:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:7:\"bundles\";a:1:{s:18:\"commerce_line_item\";a:2:{i:0;s:7:\"product\";i:1;s:13:\"rooms_booking\";}}}s:8:\"multiple\";b:0;s:12:\"limit_values\";b:0;s:10:\"base_table\";s:18:\"commerce_line_item\";s:8:\"instance\";N;s:11:\"field_alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:7:\"aliases\";a:1:{s:11:\"entity_type\";s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";}s:14:\"original_value\";s:0:\"\";s:17:\"additional_fields\";a:5:{i:0;s:5:\"delta\";i:1;s:8:\"language\";i:2;s:6:\"bundle\";i:3;s:27:\"commerce_display_path_value\";i:4;s:28:\"commerce_display_path_format\";}s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:5:\"field\";s:11:\"table_alias\";N;s:10:\"real_field\";s:27:\"commerce_display_path_value\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:35:{s:2:\"id\";s:21:\"commerce_display_path\";s:5:\"table\";s:32:\"field_data_commerce_display_path\";s:5:\"field\";s:21:\"commerce_display_path\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";i:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";i:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";i:0;s:10:\"max_length\";s:0:\"\";s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";i:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";i:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";i:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";s:3:\"all\";s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:12:\"delta_random\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";i:0;}s:10:\"definition\";a:13:{s:5:\"table\";s:32:\"field_data_commerce_display_path\";s:7:\"handler\";s:25:\"views_handler_field_field\";s:14:\"click sortable\";b:1;s:10:\"field_name\";s:21:\"commerce_display_path\";s:10:\"real field\";s:27:\"commerce_display_path_value\";s:17:\"additional fields\";a:5:{i:0;s:5:\"delta\";i:1;s:8:\"language\";i:2;s:6:\"bundle\";i:3;s:27:\"commerce_display_path_value\";i:4;s:28:\"commerce_display_path_format\";}s:13:\"entity_tables\";a:1:{s:18:\"commerce_line_item\";s:18:\"commerce_line_item\";}s:12:\"element type\";s:3:\"div\";s:11:\"is revision\";b:0;s:5:\"group\";s:18:\"Commerce Line item\";s:5:\"title\";s:12:\"Display path\";s:11:\"title short\";s:12:\"Display path\";s:4:\"help\";s:73:\"Appears in: commerce_line_item:product, commerce_line_item:rooms_booking.\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:5:\"field\";i:2;s:32:\"field_data_commerce_display_path\";i:3;s:21:\"commerce_display_path\";}s:5:\"table\";s:32:\"field_data_commerce_display_path\";s:5:\"field\";s:21:\"commerce_display_path\";s:8:\"position\";i:0;s:16:\"base_table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:11:\"last_render\";s:0:\"\";}s:15:\"line_item_label\";O:19:\"views_handler_field\":19:{s:11:\"field_alias\";s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";s:7:\"aliases\";a:0:{}s:14:\"original_value\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:17:\"additional_fields\";a:0:{}s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:5:\"field\";s:11:\"table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:10:\"real_field\";s:15:\"line_item_label\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:21:{s:2:\"id\";s:15:\"line_item_label\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:15:\"line_item_label\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:7:\"Booking\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";i:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";i:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";i:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";i:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";i:0;s:10:\"max_length\";s:0:\"\";s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";i:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";i:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";i:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";i:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";i:1;}s:10:\"definition\";a:5:{s:7:\"handler\";s:19:\"views_handler_field\";s:14:\"click sortable\";b:1;s:5:\"group\";s:18:\"Commerce Line Item\";s:5:\"title\";s:5:\"Label\";s:4:\"help\";s:27:\"The label of the line item.\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:5:\"field\";i:2;s:18:\"commerce_line_item\";i:3;s:15:\"line_item_label\";}s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:15:\"line_item_label\";s:8:\"position\";i:1;s:11:\"last_render\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:16:\"last_render_text\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";}s:19:\"commerce_unit_price\";O:43:\"commerce_price_handler_field_commerce_price\":26:{s:5:\"items\";a:0:{}s:10:\"field_info\";a:16:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:30:\"field_data_commerce_unit_price\";a:3:{s:6:\"amount\";s:26:\"commerce_unit_price_amount\";s:13:\"currency_code\";s:33:\"commerce_unit_price_currency_code\";s:4:\"data\";s:24:\"commerce_unit_price_data\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:34:\"field_revision_commerce_unit_price\";a:3:{s:6:\"amount\";s:26:\"commerce_unit_price_amount\";s:13:\"currency_code\";s:33:\"commerce_unit_price_currency_code\";s:4:\"data\";s:24:\"commerce_unit_price_data\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:14:\"currency_price\";a:2:{i:0;s:6:\"amount\";i:1;s:13:\"currency_code\";}}s:2:\"id\";s:2:\"11\";s:10:\"field_name\";s:19:\"commerce_unit_price\";s:4:\"type\";s:14:\"commerce_price\";s:6:\"module\";s:14:\"commerce_price\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"1\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:6:\"amount\";a:4:{s:11:\"description\";s:17:\"The price amount.\";s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"currency_code\";a:4:{s:11:\"description\";s:32:\"The currency code for the price.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:4:\"data\";a:5:{s:11:\"description\";s:44:\"A serialized array of additional price data.\";s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;s:9:\"serialize\";b:1;}}s:7:\"bundles\";a:1:{s:18:\"commerce_line_item\";a:2:{i:0;s:7:\"product\";i:1;s:13:\"rooms_booking\";}}}s:8:\"multiple\";b:0;s:12:\"limit_values\";b:0;s:10:\"base_table\";s:18:\"commerce_line_item\";s:8:\"instance\";N;s:11:\"field_alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:7:\"aliases\";a:1:{s:11:\"entity_type\";s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";}s:14:\"original_value\";s:10:\"$84,000.00\";s:17:\"additional_fields\";a:6:{i:0;s:5:\"delta\";i:1;s:8:\"language\";i:2;s:6:\"bundle\";i:3;s:26:\"commerce_unit_price_amount\";i:4;s:33:\"commerce_unit_price_currency_code\";i:5;s:24:\"commerce_unit_price_data\";}s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:5:\"field\";s:11:\"table_alias\";N;s:10:\"real_field\";s:26:\"commerce_unit_price_amount\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:35:{s:2:\"id\";s:19:\"commerce_unit_price\";s:5:\"table\";s:30:\"field_data_commerce_unit_price\";s:5:\"field\";s:19:\"commerce_unit_price\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:5:\"Price\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";i:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";i:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";i:0;s:10:\"max_length\";s:0:\"\";s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";i:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:5:\"price\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";i:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";i:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:6:\"amount\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";s:3:\"all\";s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:12:\"delta_random\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";i:0;}s:10:\"definition\";a:13:{s:5:\"table\";s:30:\"field_data_commerce_unit_price\";s:7:\"handler\";s:43:\"commerce_price_handler_field_commerce_price\";s:14:\"click sortable\";b:1;s:10:\"field_name\";s:19:\"commerce_unit_price\";s:10:\"real field\";s:26:\"commerce_unit_price_amount\";s:17:\"additional fields\";a:6:{i:0;s:5:\"delta\";i:1;s:8:\"language\";i:2;s:6:\"bundle\";i:3;s:26:\"commerce_unit_price_amount\";i:4;s:33:\"commerce_unit_price_currency_code\";i:5;s:24:\"commerce_unit_price_data\";}s:13:\"entity_tables\";a:1:{s:18:\"commerce_line_item\";s:18:\"commerce_line_item\";}s:12:\"element type\";s:3:\"div\";s:11:\"is revision\";b:0;s:5:\"group\";s:18:\"Commerce Line item\";s:5:\"title\";s:10:\"Unit price\";s:11:\"title short\";s:10:\"Unit price\";s:4:\"help\";s:73:\"Appears in: commerce_line_item:product, commerce_line_item:rooms_booking.\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:5:\"field\";i:2;s:30:\"field_data_commerce_unit_price\";i:3;s:19:\"commerce_unit_price\";}s:5:\"table\";s:30:\"field_data_commerce_unit_price\";s:5:\"field\";s:19:\"commerce_unit_price\";s:8:\"position\";i:2;s:16:\"base_table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:11:\"last_render\";s:10:\"$84,000.00\";s:16:\"last_render_text\";s:10:\"$84,000.00\";}s:11:\"edit_delete\";O:44:\"commerce_line_item_handler_field_edit_delete\":19:{s:11:\"field_alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:7:\"aliases\";a:1:{s:12:\"line_item_id\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";}s:14:\"original_value\";s:31:\"<!--form-item-edit_delete--0-->\";s:17:\"additional_fields\";a:1:{s:12:\"line_item_id\";s:12:\"line_item_id\";}s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:5:\"field\";s:11:\"table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:10:\"real_field\";s:12:\"line_item_id\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:21:{s:2:\"id\";s:11:\"edit_delete\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:11:\"edit_delete\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:6:\"Remove\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";i:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";i:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";i:0;s:10:\"max_length\";s:0:\"\";s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";i:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";i:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";i:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";b:1;}s:10:\"definition\";a:4:{s:5:\"title\";s:13:\"Delete button\";s:4:\"help\";s:36:\"Adds a button to delete a line item.\";s:7:\"handler\";s:44:\"commerce_line_item_handler_field_edit_delete\";s:5:\"group\";s:18:\"Commerce Line Item\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:5:\"field\";i:2;s:18:\"commerce_line_item\";i:3;s:11:\"edit_delete\";}s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:11:\"edit_delete\";s:8:\"position\";i:3;s:11:\"last_render\";s:31:\"<!--form-item-edit_delete--0-->\";s:16:\"last_render_text\";s:31:\"<!--form-item-edit_delete--0-->\";}s:14:\"commerce_total\";O:43:\"commerce_price_handler_field_commerce_price\":27:{s:5:\"items\";a:0:{}s:10:\"field_info\";a:16:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:25:\"field_data_commerce_total\";a:3:{s:6:\"amount\";s:21:\"commerce_total_amount\";s:13:\"currency_code\";s:28:\"commerce_total_currency_code\";s:4:\"data\";s:19:\"commerce_total_data\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:29:\"field_revision_commerce_total\";a:3:{s:6:\"amount\";s:21:\"commerce_total_amount\";s:13:\"currency_code\";s:28:\"commerce_total_currency_code\";s:4:\"data\";s:19:\"commerce_total_data\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:14:\"currency_price\";a:2:{i:0;s:6:\"amount\";i:1;s:13:\"currency_code\";}}s:2:\"id\";s:2:\"12\";s:10:\"field_name\";s:14:\"commerce_total\";s:4:\"type\";s:14:\"commerce_price\";s:6:\"module\";s:14:\"commerce_price\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"1\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:6:\"amount\";a:4:{s:11:\"description\";s:17:\"The price amount.\";s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"currency_code\";a:4:{s:11:\"description\";s:32:\"The currency code for the price.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:4:\"data\";a:5:{s:11:\"description\";s:44:\"A serialized array of additional price data.\";s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;s:9:\"serialize\";b:1;}}s:7:\"bundles\";a:1:{s:18:\"commerce_line_item\";a:2:{i:0;s:7:\"product\";i:1;s:13:\"rooms_booking\";}}}s:8:\"multiple\";b:0;s:12:\"limit_values\";b:0;s:10:\"base_table\";s:18:\"commerce_line_item\";s:8:\"instance\";N;s:11:\"field_alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:7:\"aliases\";a:1:{s:11:\"entity_type\";s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";}s:14:\"original_value\";s:10:\"$84,000.00\";s:17:\"additional_fields\";a:6:{i:0;s:5:\"delta\";i:1;s:8:\"language\";i:2;s:6:\"bundle\";i:3;s:21:\"commerce_total_amount\";i:4;s:28:\"commerce_total_currency_code\";i:5;s:19:\"commerce_total_data\";}s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:5:\"field\";s:11:\"table_alias\";N;s:10:\"real_field\";s:21:\"commerce_total_amount\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:35:{s:2:\"id\";s:14:\"commerce_total\";s:5:\"table\";s:25:\"field_data_commerce_total\";s:5:\"field\";s:14:\"commerce_total\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:5:\"Total\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";i:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";i:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";i:0;s:10:\"max_length\";s:0:\"\";s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";i:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:5:\"price\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";i:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";i:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:6:\"amount\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";s:3:\"all\";s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:12:\"delta_random\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";i:0;}s:10:\"definition\";a:13:{s:5:\"table\";s:25:\"field_data_commerce_total\";s:7:\"handler\";s:43:\"commerce_price_handler_field_commerce_price\";s:14:\"click sortable\";b:1;s:10:\"field_name\";s:14:\"commerce_total\";s:10:\"real field\";s:21:\"commerce_total_amount\";s:17:\"additional fields\";a:6:{i:0;s:5:\"delta\";i:1;s:8:\"language\";i:2;s:6:\"bundle\";i:3;s:21:\"commerce_total_amount\";i:4;s:28:\"commerce_total_currency_code\";i:5;s:19:\"commerce_total_data\";}s:13:\"entity_tables\";a:1:{s:18:\"commerce_line_item\";s:18:\"commerce_line_item\";}s:12:\"element type\";s:3:\"div\";s:11:\"is revision\";b:0;s:5:\"group\";s:18:\"Commerce Line item\";s:5:\"title\";s:5:\"Total\";s:11:\"title short\";s:5:\"Total\";s:4:\"help\";s:73:\"Appears in: commerce_line_item:product, commerce_line_item:rooms_booking.\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:5:\"field\";i:2;s:25:\"field_data_commerce_total\";i:3;s:14:\"commerce_total\";}s:5:\"table\";s:25:\"field_data_commerce_total\";s:5:\"field\";s:14:\"commerce_total\";s:8:\"position\";i:4;s:16:\"base_table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:11:\"last_render\";s:10:\"$84,000.00\";s:16:\"last_render_text\";s:10:\"$84,000.00\";s:11:\"last_tokens\";a:8:{s:2:\"%1\";s:1:\"7\";s:2:\"!1\";s:1:\"7\";s:2:\"%q\";s:8:\"bookings\";s:23:\"[commerce_display_path]\";s:0:\"\";s:17:\"[line_item_label]\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:21:\"[commerce_unit_price]\";s:10:\"$84,000.00\";s:13:\"[edit_delete]\";s:31:\"<!--form-item-edit_delete--0-->\";s:16:\"[commerce_total]\";s:10:\"$84,000.00\";}}}s:8:\"argument\";a:1:{s:8:\"order_id\";O:46:\"commerce_order_handler_argument_order_order_id\":20:{s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:1:{i:0;s:1:\"7\";}s:9:\"validator\";N;s:8:\"argument\";s:1:\"7\";s:10:\"name_table\";N;s:10:\"name_field\";s:12:\"order_number\";s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:8:\"argument\";s:11:\"table_alias\";s:14:\"commerce_order\";s:10:\"real_field\";s:8:\"order_id\";s:12:\"relationship\";N;s:7:\"options\";a:22:{s:2:\"id\";s:8:\"order_id\";s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:8:\"order_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:14:\"default_action\";s:5:\"empty\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:17:\"breadcrumb_enable\";b:0;s:10:\"breadcrumb\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:0:{}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:1:{s:14:\"items_per_page\";s:2:\"25\";}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";s:1:\"0\";s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";i:0;s:3:\"not\";i:0;}s:10:\"definition\";a:7:{s:7:\"handler\";s:46:\"commerce_order_handler_argument_order_order_id\";s:10:\"name field\";s:12:\"order_number\";s:7:\"numeric\";b:1;s:13:\"validate type\";s:8:\"order_id\";s:5:\"group\";s:14:\"Commerce Order\";s:5:\"title\";s:8:\"Order ID\";s:4:\"help\";s:44:\"The unique internal identifier of the order.\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:8:\"argument\";i:2;s:14:\"commerce_order\";i:3;s:8:\"order_id\";}s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:8:\"order_id\";s:8:\"position\";i:0;s:18:\"argument_validated\";b:1;}}s:4:\"sort\";a:1:{s:12:\"line_item_id\";O:18:\"views_handler_sort\":13:{s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:4:\"sort\";s:11:\"table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:10:\"real_field\";s:12:\"line_item_id\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:9:{s:2:\"id\";s:12:\"line_item_id\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:12:\"line_item_id\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"order\";s:3:\"ASC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}}s:10:\"definition\";a:4:{s:7:\"handler\";s:18:\"views_handler_sort\";s:5:\"group\";s:18:\"Commerce Line Item\";s:5:\"title\";s:12:\"Line item ID\";s:4:\"help\";s:48:\"The unique internal identifier of the line item.\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:4:\"sort\";i:2;s:18:\"commerce_line_item\";i:3;s:12:\"line_item_id\";}s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:12:\"line_item_id\";s:8:\"position\";i:0;}}s:6:\"filter\";a:1:{s:22:\"product_line_item_type\";O:64:\"commerce_product_reference_handler_filter_product_line_item_type\":22:{s:15:\"always_multiple\";b:1;s:11:\"no_operator\";b:1;s:11:\"accept_null\";b:0;s:5:\"value\";s:1:\"1\";s:8:\"operator\";s:1:\"=\";s:10:\"group_info\";s:3:\"All\";s:15:\"always_required\";b:0;s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:6:\"filter\";s:11:\"table_alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:10:\"real_field\";s:22:\"product_line_item_type\";s:12:\"relationship\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:7:\"options\";a:13:{s:2:\"id\";s:22:\"product_line_item_type\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:22:\"product_line_item_type\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:0;s:7:\"exposed\";b:0;s:6:\"expose\";a:11:{s:11:\"operator_id\";b:0;s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:14:\"operator_label\";s:0:\"\";s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{i:2;i:2;}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";i:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:10:\"definition\";a:5:{s:7:\"handler\";s:64:\"commerce_product_reference_handler_filter_product_line_item_type\";s:5:\"group\";s:18:\"Commerce Line Item\";s:5:\"title\";s:40:\"Line item is of a product line item type\";s:4:\"help\";s:121:\"Filter line items to those of a product line item type (including but not limited to the default Product line item type).\";s:11:\"allow empty\";b:1;}s:10:\"is_handler\";b:1;s:11:\"value_value\";s:4:\"True\";s:13:\"value_options\";N;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:6:\"filter\";i:2;s:18:\"commerce_line_item\";i:3;s:22:\"product_line_item_type\";}s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:22:\"product_line_item_type\";s:8:\"position\";i:0;}}s:12:\"relationship\";a:1:{s:32:\"commerce_line_items_line_item_id\";O:26:\"views_handler_relationship\":14:{s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:12:\"relationship\";s:11:\"table_alias\";s:30:\"field_data_commerce_line_items\";s:10:\"real_field\";s:32:\"commerce_line_items_line_item_id\";s:12:\"relationship\";N;s:7:\"options\";a:8:{s:2:\"id\";s:32:\"commerce_line_items_line_item_id\";s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"field\";s:32:\"commerce_line_items_line_item_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:44:\"Line items referenced by commerce_line_items\";s:8:\"required\";i:1;}s:10:\"definition\";a:8:{s:5:\"title\";s:21:\"Referenced line items\";s:5:\"label\";s:44:\"Line items referenced by commerce_line_items\";s:4:\"help\";s:127:\"Relate this entity to line items referenced by its commerce_line_items value.<br />Appears in: commerce_order (commerce_order).\";s:4:\"base\";s:18:\"commerce_line_item\";s:10:\"base field\";s:12:\"line_item_id\";s:7:\"handler\";s:26:\"views_handler_relationship\";s:5:\"group\";s:14:\"Commerce Order\";s:11:\"title short\";s:10:\"Line items\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:12:\"relationship\";i:2;s:30:\"field_data_commerce_line_items\";i:3;s:32:\"commerce_line_items_line_item_id\";}s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"field\";s:32:\"commerce_line_items_line_item_id\";s:8:\"position\";i:0;s:5:\"alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";}}s:6:\"header\";a:0:{}s:6:\"footer\";a:1:{s:11:\"order_total\";O:39:\"commerce_order_handler_area_order_total\":13:{s:4:\"view\";R:4;s:5:\"query\";R:168;s:12:\"handler_type\";s:6:\"footer\";s:11:\"table_alias\";N;s:10:\"real_field\";s:0:\"\";s:12:\"relationship\";N;s:7:\"options\";a:8:{s:2:\"id\";s:11:\"order_total\";s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:11:\"order_total\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:7:\"ui_name\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:0;}s:10:\"definition\";a:5:{s:7:\"handler\";s:39:\"commerce_order_handler_area_order_total\";s:5:\"group\";s:14:\"Commerce Order\";s:5:\"title\";s:11:\"Order total\";s:4:\"help\";s:97:\"Displays the order total field formatted with its components list; requires an Order ID argument.\";s:5:\"field\";s:0:\"\";}s:10:\"is_handler\";b:1;s:17:\"localization_keys\";a:4:{i:0;s:7:\"default\";i:1;s:6:\"footer\";i:2;s:14:\"commerce_order\";i:3;s:11:\"order_total\";}s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:11:\"order_total\";s:8:\"position\";i:0;}}s:5:\"empty\";a:0:{}}s:8:\"extender\";a:0:{}s:7:\"display\";R:322;s:11:\"plugin_type\";s:7:\"display\";s:11:\"plugin_name\";s:7:\"default\";s:7:\"options\";a:38:{s:5:\"title\";s:13:\"Shopping cart\";s:7:\"enabled\";b:1;s:15:\"display_comment\";s:0:\"\";s:9:\"css_class\";s:0:\"\";s:19:\"display_description\";s:0:\"\";s:8:\"use_ajax\";b:0;s:23:\"hide_attachment_summary\";b:0;s:16:\"hide_admin_links\";b:0;s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;s:9:\"use_pager\";b:0;s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"more\";s:12:\"link_display\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:8:\"group_by\";b:0;s:14:\"field_language\";s:22:\"***CURRENT_LANGUAGE***\";s:27:\"field_language_add_to_query\";i:1;s:6:\"access\";a:1:{s:4:\"type\";s:4:\"none\";}s:5:\"cache\";a:1:{s:4:\"type\";s:4:\"none\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:1:{s:13:\"query_comment\";b:0;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:0:{}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:12:\"style_plugin\";s:5:\"table\";s:13:\"style_options\";a:5:{s:7:\"columns\";a:6:{s:21:\"commerce_display_path\";s:21:\"commerce_display_path\";s:15:\"line_item_title\";s:15:\"line_item_title\";s:19:\"commerce_unit_price\";s:19:\"commerce_unit_price\";s:13:\"edit_quantity\";s:13:\"edit_quantity\";s:11:\"edit_delete\";s:11:\"edit_delete\";s:14:\"commerce_total\";s:14:\"commerce_total\";}s:7:\"default\";s:2:\"-1\";s:4:\"info\";a:6:{s:21:\"commerce_display_path\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:15:\"line_item_title\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:19:\"commerce_unit_price\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:13:\"edit_quantity\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:11:\"edit_delete\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:14:\"commerce_total\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}}s:8:\"override\";i:1;s:6:\"sticky\";i:0;}s:10:\"row_plugin\";s:6:\"fields\";s:11:\"row_options\";a:0:{}s:13:\"exposed_block\";b:0;s:6:\"header\";a:0:{}s:6:\"footer\";a:1:{s:11:\"order_total\";a:4:{s:2:\"id\";s:11:\"order_total\";s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:11:\"order_total\";s:5:\"empty\";b:0;}}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:1:{s:32:\"commerce_line_items_line_item_id\";a:4:{s:2:\"id\";s:32:\"commerce_line_items_line_item_id\";s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"field\";s:32:\"commerce_line_items_line_item_id\";s:8:\"required\";i:1;}}s:6:\"fields\";a:5:{s:21:\"commerce_display_path\";a:12:{s:2:\"id\";s:21:\"commerce_display_path\";s:5:\"table\";s:32:\"field_data_commerce_display_path\";s:5:\"field\";s:21:\"commerce_display_path\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:17:\"field_api_classes\";i:0;}s:15:\"line_item_label\";a:11:{s:2:\"id\";s:15:\"line_item_label\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:15:\"line_item_label\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:7:\"Booking\";s:5:\"alter\";a:13:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:14:\"replace_spaces\";i:0;s:15:\"trim_whitespace\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:9:\"more_link\";i:0;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:16:\"hide_alter_empty\";i:1;}s:19:\"commerce_unit_price\";a:14:{s:2:\"id\";s:19:\"commerce_unit_price\";s:5:\"table\";s:30:\"field_data_commerce_unit_price\";s:5:\"field\";s:19:\"commerce_unit_price\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:5:\"Price\";s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:13:\"element_class\";s:5:\"price\";s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:17:\"click_sort_column\";s:6:\"amount\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:17:\"field_api_classes\";i:0;}s:11:\"edit_delete\";a:10:{s:2:\"id\";s:11:\"edit_delete\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:11:\"edit_delete\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"label\";s:6:\"Remove\";s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;}s:14:\"commerce_total\";a:13:{s:2:\"id\";s:14:\"commerce_total\";s:5:\"table\";s:25:\"field_data_commerce_total\";s:5:\"field\";s:14:\"commerce_total\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"alter\";a:10:{s:10:\"alter_text\";i:0;s:9:\"make_link\";i:0;s:8:\"absolute\";i:0;s:8:\"external\";i:0;s:5:\"nl2br\";i:0;s:13:\"word_boundary\";i:1;s:8:\"ellipsis\";i:1;s:10:\"strip_tags\";i:0;s:4:\"trim\";i:0;s:4:\"html\";i:0;}s:13:\"element_class\";s:5:\"price\";s:19:\"element_label_colon\";i:1;s:23:\"element_default_classes\";i:1;s:10:\"hide_empty\";i:0;s:10:\"empty_zero\";i:0;s:17:\"click_sort_column\";s:6:\"amount\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:17:\"field_api_classes\";i:0;}}s:5:\"sorts\";a:1:{s:12:\"line_item_id\";a:4:{s:2:\"id\";s:12:\"line_item_id\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:12:\"line_item_id\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";}}s:9:\"arguments\";a:1:{s:8:\"order_id\";a:9:{s:2:\"id\";s:8:\"order_id\";s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:8:\"order_id\";s:14:\"default_action\";s:5:\"empty\";s:21:\"default_argument_type\";s:5:\"fixed\";s:7:\"summary\";a:2:{s:17:\"number_of_records\";s:1:\"0\";s:6:\"format\";s:15:\"default_summary\";}s:15:\"summary_options\";a:1:{s:14:\"items_per_page\";s:2:\"25\";}s:12:\"break_phrase\";i:0;s:3:\"not\";i:0;}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:7:\"filters\";a:1:{s:22:\"product_line_item_type\";a:6:{s:2:\"id\";s:22:\"product_line_item_type\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"field\";s:22:\"product_line_item_type\";s:12:\"relationship\";s:32:\"commerce_line_items_line_item_id\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:0;}}}s:10:\"definition\";a:20:{s:5:\"title\";s:6:\"Master\";s:4:\"help\";s:31:\"Default settings for this view.\";s:7:\"handler\";s:28:\"views_plugin_display_default\";s:5:\"theme\";s:10:\"views_view\";s:5:\"no ui\";b:1;s:9:\"no remove\";b:1;s:2:\"js\";a:6:{i:0;s:12:\"misc/form.js\";i:1;s:16:\"misc/collapse.js\";i:2;s:16:\"misc/textarea.js\";i:3;s:17:\"misc/tabledrag.js\";i:4;s:20:\"misc/autocomplete.js\";i:5;s:40:\"sites/all/modules/ctools/js/dependent.js\";}s:8:\"use ajax\";b:1;s:9:\"use pager\";b:1;s:8:\"use more\";b:1;s:18:\"accept attachments\";b:1;s:10:\"help topic\";s:15:\"display-default\";s:6:\"module\";s:5:\"views\";s:10:\"theme path\";s:29:\"sites/all/modules/views/theme\";s:10:\"theme file\";s:9:\"theme.inc\";s:4:\"path\";s:31:\"sites/all/modules/views/plugins\";s:4:\"file\";s:32:\"views_plugin_display_default.inc\";s:6:\"parent\";s:6:\"parent\";s:4:\"name\";s:7:\"default\";s:16:\"contextual links\";a:1:{s:8:\"views_ui\";a:2:{s:11:\"parent path\";s:26:\"admin/structure/views/view\";s:19:\"argument properties\";a:1:{i:0;s:4:\"name\";}}}}s:9:\"is_plugin\";b:1;s:17:\"localization_keys\";a:1:{i:0;s:7:\"default\";}s:11:\"has_exposed\";b:0;}}s:11:\"plugin_type\";s:5:\"pager\";s:11:\"plugin_name\";s:4:\"none\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:0;}s:10:\"definition\";a:13:{s:5:\"title\";s:17:\"Display all items\";s:4:\"help\";s:43:\"Display all items that this view might find\";s:7:\"handler\";s:23:\"views_plugin_pager_none\";s:10:\"help topic\";s:10:\"pager-none\";s:12:\"uses options\";b:1;s:4:\"type\";s:5:\"basic\";s:6:\"module\";s:5:\"views\";s:10:\"theme path\";s:29:\"sites/all/modules/views/theme\";s:10:\"theme file\";s:9:\"theme.inc\";s:4:\"path\";s:31:\"sites/all/modules/views/plugins\";s:4:\"file\";s:27:\"views_plugin_pager_none.inc\";s:6:\"parent\";s:6:\"parent\";s:4:\"name\";s:4:\"none\";}s:9:\"is_plugin\";b:1;}s:13:\"field_aliases\";a:2:{s:49:\"commerce_line_item_field_data_commerce_line_items\";a:2:{s:12:\"line_item_id\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:15:\"line_item_label\";s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";}s:0:\"\";a:1:{s:20:\"\'commerce_line_item\'\";s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";}}s:4:\"tags\";a:1:{i:0;s:25:\"commerce_line_item_access\";}s:11:\"no_distinct\";N;s:13:\"pure_distinct\";b:0;s:4:\"view\";r:4;s:7:\"display\";N;s:11:\"plugin_type\";s:5:\"query\";s:11:\"plugin_name\";s:11:\"views_query\";s:7:\"options\";a:6:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:13:\"pure_distinct\";b:0;s:5:\"slave\";b:0;s:13:\"query_comment\";b:0;s:10:\"query_tags\";a:0:{}}s:10:\"definition\";a:10:{s:5:\"title\";s:9:\"SQL Query\";s:4:\"help\";s:62:\"Query will be generated and run using the Drupal database API.\";s:7:\"handler\";s:26:\"views_plugin_query_default\";s:6:\"module\";s:5:\"views\";s:10:\"theme path\";s:29:\"sites/all/modules/views/theme\";s:10:\"theme file\";s:9:\"theme.inc\";s:4:\"path\";s:31:\"sites/all/modules/views/plugins\";s:4:\"file\";s:30:\"views_plugin_query_default.inc\";s:6:\"parent\";s:6:\"parent\";s:4:\"name\";s:11:\"views_query\";}s:9:\"is_plugin\";b:1;s:10:\"base_table\";s:14:\"commerce_order\";s:10:\"base_field\";s:8:\"order_id\";s:11:\"count_field\";a:4:{s:5:\"table\";s:14:\"commerce_order\";s:5:\"field\";s:8:\"order_id\";s:5:\"alias\";s:8:\"order_id\";s:5:\"count\";b:1;}}s:15:\"display_handler\";R:539;s:7:\"display\";a:1:{s:7:\"default\";R:322;}s:12:\"style_plugin\";O:24:\"views_plugin_style_table\":13:{s:6:\"active\";N;s:5:\"order\";s:3:\"asc\";s:10:\"row_tokens\";a:1:{i:0;a:8:{s:2:\"%1\";s:1:\"7\";s:2:\"!1\";s:1:\"7\";s:2:\"%q\";s:8:\"bookings\";s:23:\"[commerce_display_path]\";s:0:\"\";s:17:\"[line_item_label]\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:21:\"[commerce_unit_price]\";s:10:\"$84,000.00\";s:13:\"[edit_delete]\";s:31:\"<!--form-item-edit_delete--0-->\";s:16:\"[commerce_total]\";s:10:\"$84,000.00\";}}s:10:\"row_plugin\";N;s:4:\"view\";r:4;s:7:\"display\";R:322;s:11:\"plugin_type\";s:5:\"style\";s:11:\"plugin_name\";s:5:\"table\";s:7:\"options\";a:14:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:17:\"row_class_special\";b:1;s:11:\"uses_fields\";b:0;s:7:\"columns\";a:6:{s:21:\"commerce_display_path\";s:21:\"commerce_display_path\";s:15:\"line_item_title\";s:15:\"line_item_title\";s:19:\"commerce_unit_price\";s:19:\"commerce_unit_price\";s:13:\"edit_quantity\";s:13:\"edit_quantity\";s:11:\"edit_delete\";s:11:\"edit_delete\";s:14:\"commerce_total\";s:14:\"commerce_total\";}s:7:\"default\";s:2:\"-1\";s:4:\"info\";a:6:{s:21:\"commerce_display_path\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:15:\"line_item_title\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:19:\"commerce_unit_price\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:13:\"edit_quantity\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:11:\"edit_delete\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:14:\"commerce_total\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}}s:8:\"override\";i:1;s:6:\"sticky\";i:0;s:5:\"order\";s:3:\"asc\";s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;}s:10:\"definition\";a:18:{s:5:\"title\";s:5:\"Table\";s:4:\"help\";s:25:\"Displays rows in a table.\";s:7:\"handler\";s:24:\"views_plugin_style_table\";s:5:\"theme\";s:16:\"views_view_table\";s:15:\"uses row plugin\";b:0;s:14:\"uses row class\";b:1;s:11:\"uses fields\";b:1;s:12:\"uses options\";b:1;s:4:\"type\";s:6:\"normal\";s:10:\"help topic\";s:11:\"style-table\";s:6:\"module\";s:5:\"views\";s:10:\"theme path\";s:29:\"sites/all/modules/views/theme\";s:10:\"theme file\";s:9:\"theme.inc\";s:4:\"path\";s:31:\"sites/all/modules/views/plugins\";s:4:\"file\";s:28:\"views_plugin_style_table.inc\";s:6:\"parent\";s:6:\"parent\";s:4:\"name\";s:5:\"table\";s:13:\"uses grouping\";b:1;}s:9:\"is_plugin\";b:1;s:15:\"rendered_fields\";a:1:{i:0;a:5:{s:21:\"commerce_display_path\";s:0:\"\";s:15:\"line_item_label\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:19:\"commerce_unit_price\";s:10:\"$84,000.00\";s:11:\"edit_delete\";s:31:\"<!--form-item-edit_delete--0-->\";s:14:\"commerce_total\";s:10:\"$84,000.00\";}}s:13:\"render_tokens\";a:1:{i:0;a:8:{s:2:\"%1\";s:1:\"7\";s:2:\"!1\";s:1:\"7\";s:2:\"%q\";s:8:\"bookings\";s:23:\"[commerce_display_path]\";s:0:\"\";s:17:\"[line_item_label]\";s:78:\"Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)\";s:21:\"[commerce_unit_price]\";s:10:\"$84,000.00\";s:13:\"[edit_delete]\";s:31:\"<!--form-item-edit_delete--0-->\";s:16:\"[commerce_total]\";s:10:\"$84,000.00\";}}}s:13:\"style_options\";a:5:{s:7:\"columns\";a:6:{s:21:\"commerce_display_path\";s:21:\"commerce_display_path\";s:15:\"line_item_title\";s:15:\"line_item_title\";s:19:\"commerce_unit_price\";s:19:\"commerce_unit_price\";s:13:\"edit_quantity\";s:13:\"edit_quantity\";s:11:\"edit_delete\";s:11:\"edit_delete\";s:14:\"commerce_total\";s:14:\"commerce_total\";}s:7:\"default\";s:2:\"-1\";s:4:\"info\";a:6:{s:21:\"commerce_display_path\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:15:\"line_item_title\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:19:\"commerce_unit_price\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:13:\"edit_quantity\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:11:\"edit_delete\";a:2:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}s:14:\"commerce_total\";a:4:{s:8:\"sortable\";i:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";}}s:8:\"override\";i:1;s:6:\"sticky\";i:0;}s:12:\"override_url\";s:4:\"cart\";s:13:\"override_path\";N;s:13:\"base_database\";N;s:5:\"field\";R:541;s:8:\"argument\";R:1207;s:4:\"sort\";R:1270;s:6:\"filter\";R:1301;s:12:\"relationship\";R:1367;s:6:\"header\";R:1401;s:6:\"footer\";R:1402;s:5:\"empty\";R:1432;s:13:\"export_module\";s:21:\"rooms_booking_manager\";s:4:\"type\";s:7:\"Default\";s:11:\"export_type\";i:2;s:12:\"in_code_only\";b:1;s:5:\"table\";s:10:\"views_view\";s:8:\"executed\";b:1;s:5:\"built\";b:1;s:10:\"build_info\";a:6:{s:5:\"query\";O:11:\"SelectQuery\":20:{s:9:\"\0*\0fields\";a:2:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";a:3:{s:5:\"field\";s:12:\"line_item_id\";s:5:\"table\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:5:\"alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";}s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";a:3:{s:5:\"field\";s:15:\"line_item_label\";s:5:\"table\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:5:\"alias\";s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";}}s:14:\"\0*\0expressions\";a:3:{s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";a:3:{s:10:\"expression\";s:20:\"\'commerce_line_item\'\";s:5:\"alias\";s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";s:9:\"arguments\";a:0:{}}s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";a:3:{s:10:\"expression\";s:20:\"\'commerce_line_item\'\";s:5:\"alias\";s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";s:9:\"arguments\";a:0:{}}s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";a:3:{s:10:\"expression\";s:20:\"\'commerce_line_item\'\";s:5:\"alias\";s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";s:9:\"arguments\";a:0:{}}}s:9:\"\0*\0tables\";a:3:{s:14:\"commerce_order\";a:5:{s:9:\"join type\";N;s:5:\"table\";s:14:\"commerce_order\";s:5:\"alias\";s:14:\"commerce_order\";s:9:\"condition\";N;s:9:\"arguments\";a:0:{}}s:30:\"field_data_commerce_line_items\";a:5:{s:9:\"join type\";s:4:\"LEFT\";s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"alias\";s:30:\"field_data_commerce_line_items\";s:9:\"condition\";s:209:\"commerce_order.order_id = field_data_commerce_line_items.entity_id AND (field_data_commerce_line_items.entity_type = :views_join_condition_ AND field_data_commerce_line_items.deleted = :views_join_condition_1)\";s:9:\"arguments\";a:2:{s:22:\":views_join_condition_\";s:14:\"commerce_order\";s:23:\":views_join_condition_1\";i:0;}}s:49:\"commerce_line_item_field_data_commerce_line_items\";a:5:{s:9:\"join type\";s:5:\"INNER\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:9:\"condition\";s:128:\"field_data_commerce_line_items.commerce_line_items_line_item_id = commerce_line_item_field_data_commerce_line_items.line_item_id\";s:9:\"arguments\";a:0:{}}}s:8:\"\0*\0order\";a:1:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:3:\"ASC\";}s:8:\"\0*\0group\";a:0:{}s:8:\"\0*\0where\";O:17:\"DatabaseCondition\":5:{s:13:\"\0*\0conditions\";a:2:{s:12:\"#conjunction\";s:3:\"AND\";i:0;a:3:{s:5:\"field\";O:17:\"DatabaseCondition\":5:{s:13:\"\0*\0conditions\";a:2:{s:12:\"#conjunction\";s:3:\"AND\";i:0;a:3:{s:5:\"field\";O:17:\"DatabaseCondition\":5:{s:13:\"\0*\0conditions\";a:3:{s:12:\"#conjunction\";s:3:\"AND\";i:0;a:3:{s:5:\"field\";s:54:\"commerce_line_item_field_data_commerce_line_items.type\";s:5:\"value\";a:2:{i:0;s:7:\"product\";i:1;s:13:\"rooms_booking\";}s:8:\"operator\";s:2:\"in\";}i:1;a:3:{s:5:\"field\";s:51:\"commerce_order.order_id = :commerce_order_order_id \";s:5:\"value\";a:1:{s:24:\":commerce_order_order_id\";s:1:\"7\";}s:8:\"operator\";N;}}s:12:\"\0*\0arguments\";a:3:{s:27:\":db_condition_placeholder_0\";s:7:\"product\";s:27:\":db_condition_placeholder_1\";s:13:\"rooms_booking\";s:24:\":commerce_order_order_id\";s:1:\"7\";}s:10:\"\0*\0changed\";b:0;s:29:\"\0*\0queryPlaceholderIdentifier\";s:23:\"596f21622d9215.05606916\";s:13:\"stringVersion\";s:179:\" (commerce_line_item_field_data_commerce_line_items.type IN  (:db_condition_placeholder_0, :db_condition_placeholder_1)) AND (commerce_order.order_id = :commerce_order_order_id ) \";}s:5:\"value\";N;s:8:\"operator\";s:7:\"IS NULL\";}}s:12:\"\0*\0arguments\";a:3:{s:27:\":db_condition_placeholder_0\";s:7:\"product\";s:27:\":db_condition_placeholder_1\";s:13:\"rooms_booking\";s:24:\":commerce_order_order_id\";s:1:\"7\";}s:10:\"\0*\0changed\";b:0;s:29:\"\0*\0queryPlaceholderIdentifier\";s:23:\"596f21622d9215.05606916\";s:13:\"stringVersion\";s:181:\"( (commerce_line_item_field_data_commerce_line_items.type IN  (:db_condition_placeholder_0, :db_condition_placeholder_1)) AND (commerce_order.order_id = :commerce_order_order_id ) )\";}s:5:\"value\";N;s:8:\"operator\";s:7:\"IS NULL\";}}s:12:\"\0*\0arguments\";a:3:{s:27:\":db_condition_placeholder_0\";s:7:\"product\";s:27:\":db_condition_placeholder_1\";s:13:\"rooms_booking\";s:24:\":commerce_order_order_id\";s:1:\"7\";}s:10:\"\0*\0changed\";b:0;s:29:\"\0*\0queryPlaceholderIdentifier\";s:23:\"596f21622d9215.05606916\";s:13:\"stringVersion\";s:183:\"(( (commerce_line_item_field_data_commerce_line_items.type IN  (:db_condition_placeholder_0, :db_condition_placeholder_1)) AND (commerce_order.order_id = :commerce_order_order_id ) ))\";}s:9:\"\0*\0having\";O:17:\"DatabaseCondition\":5:{s:13:\"\0*\0conditions\";a:1:{s:12:\"#conjunction\";s:3:\"AND\";}s:12:\"\0*\0arguments\";a:0:{}s:10:\"\0*\0changed\";b:0;s:29:\"\0*\0queryPlaceholderIdentifier\";s:23:\"596f21622d9215.05606916\";s:13:\"stringVersion\";s:0:\"\";}s:11:\"\0*\0distinct\";b:0;s:8:\"\0*\0range\";N;s:8:\"\0*\0union\";a:0:{}s:11:\"\0*\0prepared\";b:1;s:12:\"\0*\0forUpdate\";b:0;s:19:\"\0*\0connectionTarget\";s:7:\"default\";s:16:\"\0*\0connectionKey\";s:7:\"default\";s:15:\"\0*\0queryOptions\";a:1:{s:6:\"return\";i:1;}s:19:\"\0*\0uniqueIdentifier\";s:23:\"596f21622d9215.05606916\";s:18:\"\0*\0nextPlaceholder\";i:2;s:11:\"\0*\0comments\";a:0:{}s:9:\"alterTags\";a:4:{s:5:\"views\";i:1;s:23:\"views_booking_cart_form\";i:1;s:25:\"commerce_line_item_access\";i:1;s:21:\"commerce_order_access\";i:1;}s:13:\"alterMetaData\";a:2:{s:19:\"views_substitutions\";a:8:{s:22:\"***ADMINISTER_NODES***\";i:1;s:32:\"***VIEW_OWN_UNPUBLISHED_NODES***\";i:1;s:24:\"***BYPASS_NODE_ACCESS***\";i:1;s:18:\"***CURRENT_USER***\";i:1;s:21:\"***CURRENT_VERSION***\";s:4:\"7.56\";s:18:\"***CURRENT_TIME***\";i:1500455266;s:22:\"***CURRENT_LANGUAGE***\";s:2:\"en\";s:22:\"***DEFAULT_LANGUAGE***\";s:2:\"en\";}s:4:\"view\";r:4;}}s:11:\"count_query\";O:11:\"SelectQuery\":20:{s:9:\"\0*\0fields\";a:2:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";a:3:{s:5:\"field\";s:12:\"line_item_id\";s:5:\"table\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:5:\"alias\";s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";}s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";a:3:{s:5:\"field\";s:15:\"line_item_label\";s:5:\"table\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:5:\"alias\";s:62:\"commerce_line_item_field_data_commerce_line_items_line_item__1\";}}s:14:\"\0*\0expressions\";a:3:{s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";a:3:{s:10:\"expression\";s:20:\"\'commerce_line_item\'\";s:5:\"alias\";s:60:\"field_data_commerce_display_path_commerce_line_item_entity_t\";s:9:\"arguments\";a:0:{}}s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";a:3:{s:10:\"expression\";s:20:\"\'commerce_line_item\'\";s:5:\"alias\";s:60:\"field_data_commerce_unit_price_commerce_line_item_entity_typ\";s:9:\"arguments\";a:0:{}}s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";a:3:{s:10:\"expression\";s:20:\"\'commerce_line_item\'\";s:5:\"alias\";s:56:\"field_data_commerce_total_commerce_line_item_entity_type\";s:9:\"arguments\";a:0:{}}}s:9:\"\0*\0tables\";a:3:{s:14:\"commerce_order\";a:5:{s:9:\"join type\";N;s:5:\"table\";s:14:\"commerce_order\";s:5:\"alias\";s:14:\"commerce_order\";s:9:\"condition\";N;s:9:\"arguments\";a:0:{}}s:30:\"field_data_commerce_line_items\";a:5:{s:9:\"join type\";s:4:\"LEFT\";s:5:\"table\";s:30:\"field_data_commerce_line_items\";s:5:\"alias\";s:30:\"field_data_commerce_line_items\";s:9:\"condition\";s:210:\"commerce_order.order_id = field_data_commerce_line_items.entity_id AND (field_data_commerce_line_items.entity_type = :views_join_condition_2 AND field_data_commerce_line_items.deleted = :views_join_condition_3)\";s:9:\"arguments\";a:2:{s:23:\":views_join_condition_2\";s:14:\"commerce_order\";s:23:\":views_join_condition_3\";i:0;}}s:49:\"commerce_line_item_field_data_commerce_line_items\";a:5:{s:9:\"join type\";s:5:\"INNER\";s:5:\"table\";s:18:\"commerce_line_item\";s:5:\"alias\";s:49:\"commerce_line_item_field_data_commerce_line_items\";s:9:\"condition\";s:128:\"field_data_commerce_line_items.commerce_line_items_line_item_id = commerce_line_item_field_data_commerce_line_items.line_item_id\";s:9:\"arguments\";a:0:{}}}s:8:\"\0*\0order\";a:1:{s:60:\"commerce_line_item_field_data_commerce_line_items_line_item_\";s:3:\"ASC\";}s:8:\"\0*\0group\";a:0:{}s:8:\"\0*\0where\";O:17:\"DatabaseCondition\":4:{s:13:\"\0*\0conditions\";a:2:{s:12:\"#conjunction\";s:3:\"AND\";i:0;a:3:{s:5:\"field\";O:17:\"DatabaseCondition\":4:{s:13:\"\0*\0conditions\";a:2:{s:12:\"#conjunction\";s:3:\"AND\";i:0;a:3:{s:5:\"field\";O:17:\"DatabaseCondition\":4:{s:13:\"\0*\0conditions\";a:3:{s:12:\"#conjunction\";s:3:\"AND\";i:0;a:3:{s:5:\"field\";s:54:\"commerce_line_item_field_data_commerce_line_items.type\";s:5:\"value\";a:2:{i:0;s:7:\"product\";i:1;s:13:\"rooms_booking\";}s:8:\"operator\";s:2:\"in\";}i:1;a:3:{s:5:\"field\";s:51:\"commerce_order.order_id = :commerce_order_order_id \";s:5:\"value\";a:1:{s:24:\":commerce_order_order_id\";s:1:\"7\";}s:8:\"operator\";N;}}s:12:\"\0*\0arguments\";a:0:{}s:10:\"\0*\0changed\";b:1;s:29:\"\0*\0queryPlaceholderIdentifier\";N;}s:5:\"value\";N;s:8:\"operator\";s:7:\"IS NULL\";}}s:12:\"\0*\0arguments\";a:0:{}s:10:\"\0*\0changed\";b:1;s:29:\"\0*\0queryPlaceholderIdentifier\";N;}s:5:\"value\";N;s:8:\"operator\";s:7:\"IS NULL\";}}s:12:\"\0*\0arguments\";a:0:{}s:10:\"\0*\0changed\";b:1;s:29:\"\0*\0queryPlaceholderIdentifier\";N;}s:9:\"\0*\0having\";O:17:\"DatabaseCondition\":4:{s:13:\"\0*\0conditions\";a:1:{s:12:\"#conjunction\";s:3:\"AND\";}s:12:\"\0*\0arguments\";a:0:{}s:10:\"\0*\0changed\";b:1;s:29:\"\0*\0queryPlaceholderIdentifier\";N;}s:11:\"\0*\0distinct\";b:0;s:8:\"\0*\0range\";N;s:8:\"\0*\0union\";a:0:{}s:11:\"\0*\0prepared\";b:1;s:12:\"\0*\0forUpdate\";b:0;s:19:\"\0*\0connectionTarget\";s:7:\"default\";s:16:\"\0*\0connectionKey\";s:7:\"default\";s:15:\"\0*\0queryOptions\";a:1:{s:6:\"return\";i:1;}s:19:\"\0*\0uniqueIdentifier\";s:23:\"596f21622d9935.97051423\";s:18:\"\0*\0nextPlaceholder\";i:0;s:11:\"\0*\0comments\";a:0:{}s:9:\"alterTags\";a:4:{s:5:\"views\";i:1;s:23:\"views_booking_cart_form\";i:1;s:25:\"commerce_line_item_access\";i:1;s:21:\"commerce_order_access\";i:1;}s:13:\"alterMetaData\";a:2:{s:19:\"views_substitutions\";a:8:{s:22:\"***ADMINISTER_NODES***\";i:1;s:32:\"***VIEW_OWN_UNPUBLISHED_NODES***\";i:1;s:24:\"***BYPASS_NODE_ACCESS***\";i:1;s:18:\"***CURRENT_USER***\";i:1;s:21:\"***CURRENT_VERSION***\";s:4:\"7.56\";s:18:\"***CURRENT_TIME***\";i:1500455266;s:22:\"***CURRENT_LANGUAGE***\";s:2:\"en\";s:22:\"***DEFAULT_LANGUAGE***\";s:2:\"en\";}s:4:\"view\";r:4;}}s:10:\"query_args\";a:0:{}s:10:\"breadcrumb\";a:0:{}s:5:\"title\";s:13:\"Shopping cart\";s:13:\"substitutions\";a:2:{s:2:\"%1\";s:1:\"7\";s:2:\"!1\";s:1:\"7\";}}s:17:\"attachment_before\";s:0:\"\";s:16:\"attachment_after\";s:0:\"\";s:19:\"localization_plugin\";O:30:\"views_plugin_localization_core\":9:{s:14:\"export_strings\";a:0:{}s:9:\"translate\";b:1;s:4:\"view\";r:4;s:7:\"display\";N;s:11:\"plugin_type\";s:12:\"localization\";s:11:\"plugin_name\";s:4:\"core\";s:7:\"options\";a:0:{}s:10:\"definition\";a:11:{s:5:\"title\";s:4:\"Core\";s:4:\"help\";s:283:\"Use Drupal core t() function. Not recommended, as it doesn\'t support updates to existing strings. If you need to translate Views labels into other languages, consider installing the <a href=\"http://drupal.org/project/i18n\">Internationalization</a> package\'s Views translation module.\";s:7:\"handler\";s:30:\"views_plugin_localization_core\";s:10:\"help topic\";s:17:\"localization-core\";s:6:\"module\";s:5:\"views\";s:10:\"theme path\";s:29:\"sites/all/modules/views/theme\";s:10:\"theme file\";s:9:\"theme.inc\";s:4:\"path\";s:31:\"sites/all/modules/views/plugins\";s:4:\"file\";s:34:\"views_plugin_localization_core.inc\";s:6:\"parent\";s:6:\"parent\";s:4:\"name\";s:4:\"core\";}s:9:\"is_plugin\";b:1;}s:6:\"dom_id\";s:32:\"244d46d55f4fdf166db5a599bd3f4350\";s:19:\"relationships_fixed\";b:1;s:6:\"inited\";b:1;s:10:\"build_sort\";b:1;s:11:\"plugin_name\";s:5:\"table\";s:10:\"build_time\";d:0.0030660629272460938;s:12:\"execute_time\";d:0.00046801567077636719;s:13:\"exposed_input\";a:0:{}}i:1;s:1221:\"<table class=\"views-table cols-4\" >\n         <thead>\n      <tr>\n                  <th class=\"views-field views-field-line-item-label\"  scope=\"col\">\n            Booking          </th>\n                  <th class=\"views-field views-field-commerce-unit-price\"  scope=\"col\">\n            Price          </th>\n                  <th class=\"views-field views-field-edit-delete\"  scope=\"col\">\n            Remove          </th>\n                  <th class=\"views-field views-field-commerce-total\"  scope=\"col\">\n            Total          </th>\n              </tr>\n    </thead>\n    <tbody>\n          <tr class=\"odd views-row-first views-row-last\">\n                  <td class=\"views-field views-field-line-item-label\" >\n            Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)          </td>\n                  <td class=\"views-field views-field-commerce-unit-price price\" >\n            $84,000.00          </td>\n                  <td class=\"views-field views-field-edit-delete\" >\n            <!--form-item-edit_delete--0-->          </td>\n                  <td class=\"views-field views-field-commerce-total price\" >\n            $84,000.00          </td>\n              </tr>\n      </tbody>\n</table>\n\";}s:7:\"form_id\";s:36:\"views_form_booking_cart_form_default\";s:12:\"base_form_id\";s:10:\"views_form\";}s:10:\"programmed\";b:0;s:30:\"programmed_bypass_access_check\";b:1;s:5:\"cache\";b:1;s:4:\"step\";s:21:\"views_form_views_form\";s:5:\"order\";O:8:\"stdClass\":19:{s:12:\"order_number\";s:1:\"7\";s:11:\"revision_id\";s:2:\"47\";s:12:\"revision_uid\";s:1:\"1\";s:4:\"mail\";s:18:\"you@yourdomain.com\";s:6:\"status\";s:4:\"cart\";s:3:\"log\";s:33:\"Created as a shopping cart order.\";s:18:\"revision_timestamp\";s:10:\"1500455265\";s:17:\"revision_hostname\";s:12:\"192.168.1.49\";s:4:\"data\";a:1:{s:17:\"last_cart_refresh\";i:1500455266;}s:8:\"order_id\";s:1:\"7\";s:4:\"type\";s:14:\"commerce_order\";s:3:\"uid\";s:1:\"1\";s:7:\"created\";s:10:\"1500455265\";s:7:\"changed\";s:10:\"1500455265\";s:8:\"hostname\";s:12:\"192.168.1.49\";s:19:\"commerce_line_items\";a:1:{s:3:\"und\";a:1:{i:0;a:1:{s:12:\"line_item_id\";s:2:\"16\";}}}s:20:\"commerce_order_total\";a:1:{s:3:\"und\";a:1:{i:0;a:3:{s:6:\"amount\";s:7:\"8400000\";s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:0:{}}s:8:\"included\";b:1;}}}}}}s:25:\"commerce_customer_billing\";a:0:{}s:11:\"rdf_mapping\";a:0:{}}s:10:\"line_items\";a:1:{i:16;r:30;}s:13:\"process_input\";b:0;}',1500476866,1500455266,1),('form_state_form-RV5tK0n4kGVsoVp9BF-8vKe8LLKlT7evDhcjC1NMKrc','a:8:{s:10:\"build_info\";a:3:{s:4:\"args\";a:1:{i:0;O:9:\"RoomsUnit\":25:{s:13:\"\0*\0entityType\";s:10:\"rooms_unit\";s:15:\"\0*\0defaultLabel\";b:0;s:10:\"\0*\0wrapper\";N;s:7:\"unit_id\";s:2:\"16\";s:4:\"type\";s:11:\"basic_suite\";s:8:\"language\";s:0:\"\";s:4:\"name\";s:14:\"Basic Room - 3\";s:7:\"created\";s:10:\"1339860325\";s:7:\"changed\";s:10:\"1339860325\";s:10:\"base_price\";s:5:\"50.00\";s:13:\"default_state\";s:1:\"1\";s:8:\"bookable\";s:1:\"1\";s:10:\"min_sleeps\";s:1:\"2\";s:10:\"max_sleeps\";s:1:\"2\";s:12:\"min_children\";s:1:\"0\";s:12:\"max_children\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:4:\"data\";a:2:{s:14:\"singlediscount\";s:0:\"\";s:15:\"bed_arrangement\";a:3:{s:7:\"singles\";s:0:\"\";s:7:\"doubles\";s:0:\"\";s:13:\"cot_available\";i:0;}}s:11:\"field_image\";a:1:{s:3:\"und\";a:1:{i:0;a:13:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";s:1:\"1\";s:8:\"filename\";s:10:\"demo-1.jpg\";s:3:\"uri\";s:31:\"public://image/rooms/demo-1.jpg\";s:8:\"filemime\";s:10:\"image/jpeg\";s:8:\"filesize\";s:5:\"10673\";s:6:\"status\";s:1:\"1\";s:9:\"timestamp\";s:10:\"1339860324\";s:11:\"rdf_mapping\";a:0:{}s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"165\";}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:1:{i:0;a:5:{s:5:\"value\";s:1210:\"In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n\";s:7:\"summary\";s:0:\"\";s:6:\"format\";s:13:\"filtered_html\";s:10:\"safe_value\";s:1224:\"<p>In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.</p>\n<p>Quisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.</p>\n<p>Donec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.</p>\n\";s:12:\"safe_summary\";s:0:\"\";}}}s:26:\"rooms_booking_unit_options\";a:0:{}s:11:\"rdf_mapping\";a:0:{}s:4:\"date\";s:25:\"2012-06-16 23:25:25 +0800\";s:11:\"author_name\";s:5:\"admin\";}}s:7:\"form_id\";s:20:\"rooms_unit_edit_form\";s:5:\"files\";a:1:{s:4:\"menu\";s:63:\"sites/all/modules/rooms/modules/rooms_unit/rooms_unit.admin.inc\";}}s:10:\"programmed\";b:0;s:30:\"programmed_bypass_access_check\";b:1;s:5:\"cache\";b:1;s:10:\"rooms_unit\";r:4;s:5:\"field\";a:3:{s:11:\"field_image\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:22:\"field_data_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:26:\"field_revision_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:2:\"id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:4:\"type\";s:5:\"image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:5:{s:3:\"fid\";a:4:{s:11:\"description\";s:54:\"The {file_managed}.fid being referenced in this field.\";s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:8:\"unsigned\";b:1;}s:3:\"alt\";a:4:{s:11:\"description\";s:56:\"Alternative image text, for the image\'s \'alt\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:5:\"title\";a:4:{s:11:\"description\";s:52:\"Image title text, for the image\'s \'title\' attribute.\";s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:5:\"width\";a:3:{s:11:\"description\";s:33:\"The width of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}s:6:\"height\";a:3:{s:11:\"description\";s:34:\"The height of the image in pixels.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"bundles\";a:2:{s:4:\"node\";a:1:{i:0;s:7:\"article\";}s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}}}s:8:\"instance\";a:12:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"64\";s:8:\"field_id\";s:1:\"4\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:11:\"basic_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:11:\"field_image\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:17:\"field_description\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:28:\"field_data_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:32:\"field_revision_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:4:\"type\";s:17:\"text_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:5:\"value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:7:\"summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:4:\"node\";a:1:{i:0;s:16:\"unit_description\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"3\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;s:2:\"id\";s:2:\"65\";s:8:\"field_id\";s:2:\"28\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:11:\"basic_suite\";s:7:\"deleted\";s:1:\"0\";}s:11:\"items_count\";i:1;s:13:\"array_parents\";a:2:{i:0;s:17:\"field_description\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}s:26:\"rooms_booking_unit_options\";a:1:{s:3:\"und\";a:5:{s:5:\"field\";a:16:{s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:37:\"field_data_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:41:\"field_revision_rooms_booking_unit_options\";a:4:{s:4:\"name\";s:31:\"rooms_booking_unit_options_name\";s:8:\"quantity\";s:35:\"rooms_booking_unit_options_quantity\";s:9:\"operation\";s:36:\"rooms_booking_unit_options_operation\";s:5:\"value\";s:32:\"rooms_booking_unit_options_value\";}}}}}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}s:2:\"id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:4:\"type\";s:13:\"rooms_options\";s:6:\"module\";s:5:\"rooms\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:2:\"-1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:8:\"quantity\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;}s:9:\"operation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:5:\"value\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:7:\"bundles\";a:2:{s:10:\"rooms_unit\";a:4:{i:0;s:11:\"basic_suite\";i:1;s:12:\"deluxe_suite\";i:2;s:12:\"luxury_suite\";i:3;s:11:\"royal_suite\";}s:15:\"rooms_unit_type\";a:1:{i:0;s:15:\"rooms_unit_type\";}}}s:8:\"instance\";a:13:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:22:\"rooms_options_combined\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"module\";s:5:\"rooms\";}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";s:2:\"id\";s:2:\"77\";s:8:\"field_id\";s:2:\"32\";s:10:\"field_name\";s:26:\"rooms_booking_unit_options\";s:11:\"entity_type\";s:10:\"rooms_unit\";s:6:\"bundle\";s:11:\"basic_suite\";s:7:\"deleted\";s:1:\"0\";s:13:\"default_value\";N;}s:11:\"items_count\";i:0;s:13:\"array_parents\";a:2:{i:0;s:26:\"rooms_booking_unit_options\";i:1;s:3:\"und\";}s:6:\"errors\";a:0:{}}}}s:13:\"process_input\";b:0;s:16:\"has_file_element\";b:1;}',1500477064,1500455464,1);
/*!40000 ALTER TABLE `cache_form` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_image`
--

DROP TABLE IF EXISTS `cache_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_image` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about image...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_image`
--

LOCK TABLES `cache_image` WRITE;
/*!40000 ALTER TABLE `cache_image` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_image` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_libraries`
--

DROP TABLE IF EXISTS `cache_libraries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_libraries` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table to store library information.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_libraries`
--

LOCK TABLES `cache_libraries` WRITE;
/*!40000 ALTER TABLE `cache_libraries` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_libraries` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_menu`
--

DROP TABLE IF EXISTS `cache_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the menu system to store router...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_menu`
--

LOCK TABLES `cache_menu` WRITE;
/*!40000 ALTER TABLE `cache_menu` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `cache_menu` VALUES ('menu_custom','a:5:{s:9:\"main-menu\";a:3:{s:9:\"menu_name\";s:9:\"main-menu\";s:5:\"title\";s:9:\"Main menu\";s:11:\"description\";s:115:\"The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.\";}s:10:\"management\";a:3:{s:9:\"menu_name\";s:10:\"management\";s:5:\"title\";s:10:\"Management\";s:11:\"description\";s:69:\"The <em>Management</em> menu contains links for administrative tasks.\";}s:13:\"menu-top-menu\";a:3:{s:9:\"menu_name\";s:13:\"menu-top-menu\";s:5:\"title\";s:8:\"Top Menu\";s:11:\"description\";s:302:\"Donec dignissim tincidunt tellus, eu laoreet enim tincidunt in. Sed eget augue id arcu malesuada volutpat sit amet at tortor. Cras ac gravida leo? Donec quis dolor diam, quis tempus purus. Ut eu adipiscing nulla. Cras euismod, urna vel convallis commodo, augue enim eleifend augue, nec lobortis amet.\r\n\";}s:10:\"navigation\";a:3:{s:9:\"menu_name\";s:10:\"navigation\";s:5:\"title\";s:10:\"Navigation\";s:11:\"description\";s:150:\"The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.\";}s:9:\"user-menu\";a:3:{s:9:\"menu_name\";s:9:\"user-menu\";s:5:\"title\";s:9:\"User menu\";s:11:\"description\";s:99:\"The <em>User</em> menu contains links related to the user\'s account, as well as the \'Log out\' link.\";}}',0,1512630527,1);
/*!40000 ALTER TABLE `cache_menu` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_page`
--

DROP TABLE IF EXISTS `cache_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_page` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store compressed pages for anonymous...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_page`
--

LOCK TABLES `cache_page` WRITE;
/*!40000 ALTER TABLE `cache_page` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_page` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_path`
--

DROP TABLE IF EXISTS `cache_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for path alias lookup.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_path`
--

LOCK TABLES `cache_path` WRITE;
/*!40000 ALTER TABLE `cache_path` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_path` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_rules`
--

DROP TABLE IF EXISTS `cache_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_rules` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the rules engine to store configured items.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_rules`
--

LOCK TABLES `cache_rules` WRITE;
/*!40000 ALTER TABLE `cache_rules` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_rules` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_token`
--

DROP TABLE IF EXISTS `cache_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_token` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for token information.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_token`
--

LOCK TABLES `cache_token` WRITE;
/*!40000 ALTER TABLE `cache_token` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_token` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_update`
--

DROP TABLE IF EXISTS `cache_update`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_update` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Update module to store information...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_update`
--

LOCK TABLES `cache_update` WRITE;
/*!40000 ALTER TABLE `cache_update` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `cache_update` VALUES ('available_releases::addressfield','a:11:{s:5:\"title\";s:13:\"Address Field\";s:10:\"short_name\";s:12:\"addressfield\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:43:\"https://www.drupal.org/project/addressfield\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:14:{s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:20:\"addressfield 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/addressfield/releases/7.x-1.2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1444253039\";s:6:\"mdhash\";s:32:\"2c9452731b1b8fffeba8f420c590cc57\";s:8:\"filesize\";s:5:\"77194\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:20:\"addressfield 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/addressfield/releases/7.x-1.1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1429819381\";s:6:\"mdhash\";s:32:\"c81a7e14dd68dba02c377d8678175b02\";s:8:\"filesize\";s:5:\"76589\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:20:\"addressfield 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1421426880\";s:6:\"mdhash\";s:32:\"d0dafd2af22b482a5d14d4aa530bbba4\";s:8:\"filesize\";s:5:\"76261\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:24:\"addressfield 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1418653681\";s:6:\"mdhash\";s:32:\"b67a4f2f88c958e5bc5dccff84cf7856\";s:8:\"filesize\";s:5:\"74572\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta5\";a:15:{s:4:\"name\";s:26:\"addressfield 7.x-1.0-beta5\";s:7:\"version\";s:13:\"7.x-1.0-beta5\";s:3:\"tag\";s:13:\"7.x-1.0-beta5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-beta5\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1386309504\";s:6:\"mdhash\";s:32:\"63d28860718d212d0b68d7c1a199590e\";s:8:\"filesize\";s:5:\"67249\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:26:\"addressfield 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1367945111\";s:6:\"mdhash\";s:32:\"884414b0ad4afd037b5ba1cec1d107e3\";s:8:\"filesize\";s:5:\"61233\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:26:\"addressfield 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1338304248\";s:6:\"mdhash\";s:32:\"a3df218c4f779a03f4efe4c87d9eaf53\";s:8:\"filesize\";s:5:\"52898\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:26:\"addressfield 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1314906115\";s:6:\"mdhash\";s:32:\"8ea36908a8aeca560c273acc75f79d2f\";s:8:\"filesize\";s:5:\"51350\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:26:\"addressfield 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1310587614\";s:6:\"mdhash\";s:32:\"b945c657d8a1d05fc3008a0b93d71595\";s:8:\"filesize\";s:5:\"18370\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha4\";a:15:{s:4:\"name\";s:27:\"addressfield 7.x-1.0-alpha4\";s:7:\"version\";s:14:\"7.x-1.0-alpha4\";s:3:\"tag\";s:14:\"7.x-1.0-alpha4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-alpha4\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1307853714\";s:6:\"mdhash\";s:32:\"ae1698ed003872b6f51e53319d41dbc0\";s:8:\"filesize\";s:5:\"15085\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:27:\"addressfield 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1307808115\";s:6:\"mdhash\";s:32:\"3d17e265474c269056a8e32123fa7db1\";s:8:\"filesize\";s:5:\"15097\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:27:\"addressfield 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1303140714\";s:6:\"mdhash\";s:32:\"8ceff09ca7655dea59d15add3aae1608\";s:8:\"filesize\";s:5:\"13906\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:27:\"addressfield 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/addressfield/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1286607059\";s:6:\"mdhash\";s:32:\"bd3d8946deeb2d99d559827208112f98\";s:8:\"filesize\";s:5:\"10632\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:24:\"addressfield 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/addressfield/releases/7.x-1.x-dev\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/addressfield-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1451474639\";s:6:\"mdhash\";s:32:\"49f9b3674808adec5528bb421bd3094e\";s:8:\"filesize\";s:5:\"77544\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541603,1500455183,1),('available_releases::admin_menu','a:11:{s:5:\"title\";s:19:\"Administration menu\";s:10:\"short_name\";s:10:\"admin_menu\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"https://www.drupal.org/project/admin_menu\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:6:{s:11:\"7.x-3.0-rc5\";a:15:{s:4:\"name\";s:22:\"admin_menu 7.x-3.0-rc5\";s:7:\"version\";s:11:\"7.x-3.0-rc5\";s:3:\"tag\";s:11:\"7.x-3.0-rc5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/admin_menu/releases/7.x-3.0-rc5\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/admin_menu-7.x-3.0-rc5.tar.gz\";s:4:\"date\";s:10:\"1419029280\";s:6:\"mdhash\";s:32:\"4f1a0c14001c880bd7eb170318b91303\";s:8:\"filesize\";s:5:\"53401\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";}s:11:\"7.x-3.0-rc4\";a:15:{s:4:\"name\";s:22:\"admin_menu 7.x-3.0-rc4\";s:7:\"version\";s:11:\"7.x-3.0-rc4\";s:3:\"tag\";s:11:\"7.x-3.0-rc4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/admin_menu/releases/7.x-3.0-rc4\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/admin_menu-7.x-3.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1359651687\";s:6:\"mdhash\";s:32:\"3d8359538878723720fca6ddb2f82c7a\";s:8:\"filesize\";s:5:\"55064\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";}s:11:\"7.x-3.0-rc3\";a:15:{s:4:\"name\";s:22:\"admin_menu 7.x-3.0-rc3\";s:7:\"version\";s:11:\"7.x-3.0-rc3\";s:3:\"tag\";s:11:\"7.x-3.0-rc3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/admin_menu/releases/7.x-3.0-rc3\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/admin_menu-7.x-3.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1337292349\";s:6:\"mdhash\";s:32:\"86b659c35823d541354179eccbfdc2d4\";s:8:\"filesize\";s:5:\"50950\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";}s:11:\"7.x-3.0-rc2\";a:15:{s:4:\"name\";s:22:\"admin_menu 7.x-3.0-rc2\";s:7:\"version\";s:11:\"7.x-3.0-rc2\";s:3:\"tag\";s:11:\"7.x-3.0-rc2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/admin_menu/releases/7.x-3.0-rc2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/admin_menu-7.x-3.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1335198071\";s:6:\"mdhash\";s:32:\"47761c79c351697f295d933b85441328\";s:8:\"filesize\";s:5:\"49988\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";}s:11:\"7.x-3.0-rc1\";a:15:{s:4:\"name\";s:22:\"admin_menu 7.x-3.0-rc1\";s:7:\"version\";s:11:\"7.x-3.0-rc1\";s:3:\"tag\";s:11:\"7.x-3.0-rc1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/admin_menu/releases/7.x-3.0-rc1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/admin_menu-7.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1294378871\";s:6:\"mdhash\";s:32:\"9d0cfb26adda4da7bd309bdf5be305a0\";s:8:\"filesize\";s:5:\"70961\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";s:5:\"terms\";a:0:{}}s:11:\"7.x-3.x-dev\";a:14:{s:4:\"name\";s:22:\"admin_menu 7.x-3.x-dev\";s:7:\"version\";s:11:\"7.x-3.x-dev\";s:3:\"tag\";s:7:\"7.x-3.x\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/admin_menu/releases/7.x-3.x-dev\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/admin_menu-7.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1426875181\";s:6:\"mdhash\";s:32:\"6d2cdd2a5be2531a7e735847ce329102\";s:8:\"filesize\";s:5:\"53496\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";s:5:\"terms\";a:0:{}}}}',1500541603,1500455183,1),('available_releases::colorbox','a:11:{s:5:\"title\";s:8:\"Colorbox\";s:10:\"short_name\";s:8:\"colorbox\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"https://www.drupal.org/project/colorbox\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:31:{s:8:\"7.x-2.13\";a:14:{s:4:\"name\";s:17:\"colorbox 7.x-2.13\";s:7:\"version\";s:8:\"7.x-2.13\";s:3:\"tag\";s:8:\"7.x-2.13\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/colorbox/releases/7.x-2.13\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.13.tar.gz\";s:4:\"date\";s:10:\"1491291483\";s:6:\"mdhash\";s:32:\"81942f2858a20cd9b986b4c7c82708e0\";s:8:\"filesize\";s:6:\"163128\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-2.12\";a:14:{s:4:\"name\";s:17:\"colorbox 7.x-2.12\";s:7:\"version\";s:8:\"7.x-2.12\";s:3:\"tag\";s:8:\"7.x-2.12\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/colorbox/releases/7.x-2.12\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.12.tar.gz\";s:4:\"date\";s:10:\"1465255739\";s:6:\"mdhash\";s:32:\"a5667b3345a9430837dbeee8066b7de9\";s:8:\"filesize\";s:6:\"169332\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-2.11\";a:14:{s:4:\"name\";s:17:\"colorbox 7.x-2.11\";s:7:\"version\";s:8:\"7.x-2.11\";s:3:\"tag\";s:8:\"7.x-2.11\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/colorbox/releases/7.x-2.11\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.11.tar.gz\";s:4:\"date\";s:10:\"1464956939\";s:6:\"mdhash\";s:32:\"0b560eeee3003170f80cc81d56f45c65\";s:8:\"filesize\";s:6:\"169285\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-2.10\";a:14:{s:4:\"name\";s:17:\"colorbox 7.x-2.10\";s:7:\"version\";s:8:\"7.x-2.10\";s:3:\"tag\";s:8:\"7.x-2.10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/colorbox/releases/7.x-2.10\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1443691439\";s:6:\"mdhash\";s:32:\"6027f03ecc6e0e6c92e137339cb58517\";s:8:\"filesize\";s:6:\"168996\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.9\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.9\";s:7:\"version\";s:7:\"7.x-2.9\";s:3:\"tag\";s:7:\"7.x-2.9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.9\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1434934980\";s:6:\"mdhash\";s:32:\"48c71a713678548d5ee368ee36a0ba58\";s:8:\"filesize\";s:6:\"168826\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.8\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.8\";s:7:\"version\";s:7:\"7.x-2.8\";s:3:\"tag\";s:7:\"7.x-2.8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.8\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1410514128\";s:6:\"mdhash\";s:32:\"c0ffce63e21f30f4a741b4389f01bfc5\";s:8:\"filesize\";s:6:\"168639\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.7\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.7\";s:7:\"version\";s:7:\"7.x-2.7\";s:3:\"tag\";s:7:\"7.x-2.7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.7\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1403692728\";s:6:\"mdhash\";s:32:\"a5aaf8c323c87ca1c0facf8c93c2c486\";s:8:\"filesize\";s:6:\"164144\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.6\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.6\";s:7:\"version\";s:7:\"7.x-2.6\";s:3:\"tag\";s:7:\"7.x-2.6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.6\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1401278627\";s:6:\"mdhash\";s:32:\"739bc27a2385e7c8db4f6714cb46fd31\";s:8:\"filesize\";s:6:\"164172\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.5\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1385815705\";s:6:\"mdhash\";s:32:\"6de84bea6ea5827598bc1192a0cedfb0\";s:8:\"filesize\";s:6:\"164026\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.4\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1365452412\";s:6:\"mdhash\";s:32:\"aba012077a2ee086548eb93157b2caa2\";s:8:\"filesize\";s:6:\"167430\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1360072087\";s:6:\"mdhash\";s:32:\"5c0d240681d26bf38ca7c7a4057a7acf\";s:8:\"filesize\";s:6:\"167131\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1358727059\";s:6:\"mdhash\";s:32:\"dc8b6a29054a74bc05e26908789d11a6\";s:8:\"filesize\";s:6:\"167236\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1358483767\";s:6:\"mdhash\";s:32:\"29961ac05e2d8157db32b3bd7ad8482c\";s:8:\"filesize\";s:6:\"167181\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-2.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1353323160\";s:6:\"mdhash\";s:32:\"5918dee2282afec27a7a8db69270684b\";s:8:\"filesize\";s:6:\"167181\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-2.0-beta4\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-2.0-beta4\";s:7:\"version\";s:13:\"7.x-2.0-beta4\";s:3:\"tag\";s:13:\"7.x-2.0-beta4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-2.0-beta4\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1352120168\";s:6:\"mdhash\";s:32:\"feafdb0f3bbf3c05ff0ac6e7819ee293\";s:8:\"filesize\";s:6:\"167425\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.0-beta3\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-2.0-beta3\";s:7:\"version\";s:13:\"7.x-2.0-beta3\";s:3:\"tag\";s:13:\"7.x-2.0-beta3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-2.0-beta3\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1350631571\";s:6:\"mdhash\";s:32:\"b9af4d78d3b5cac517eb366180876d41\";s:8:\"filesize\";s:6:\"167755\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-2.0-beta2\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-2.0-beta2\";s:7:\"version\";s:13:\"7.x-2.0-beta2\";s:3:\"tag\";s:13:\"7.x-2.0-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-2.0-beta2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1349463066\";s:6:\"mdhash\";s:32:\"9475265a6db49de132e502449d5dd5a5\";s:8:\"filesize\";s:6:\"167529\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.0-beta1\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-2.0-beta1\";s:7:\"version\";s:13:\"7.x-2.0-beta1\";s:3:\"tag\";s:13:\"7.x-2.0-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-2.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1349353286\";s:6:\"mdhash\";s:32:\"e3cdda134788e2099f905fc144f94616\";s:8:\"filesize\";s:6:\"163330\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.6\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1366377322\";s:6:\"mdhash\";s:32:\"38b97fb51f9c142ba72a1170e8787b4d\";s:8:\"filesize\";s:6:\"165078\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.5\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1360354358\";s:6:\"mdhash\";s:32:\"afa09428bc15375c286dce88f39046dc\";s:8:\"filesize\";s:6:\"165009\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.4\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1350629767\";s:6:\"mdhash\";s:32:\"227d9cd3ec8571aa319a4bdceba5ee07\";s:8:\"filesize\";s:6:\"165054\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1334080546\";s:6:\"mdhash\";s:32:\"a425d8a02a1d330db02c0811c5e24302\";s:8:\"filesize\";s:6:\"164324\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1316137003\";s:6:\"mdhash\";s:32:\"b63fd0da78504bfedead6d5085f59040\";s:8:\"filesize\";s:6:\"471679\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1311834128\";s:6:\"mdhash\";s:32:\"2c60f60ad556b136989d460b71258b92\";s:8:\"filesize\";s:6:\"470602\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:16:\"colorbox 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/colorbox/releases/7.x-1.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1310430426\";s:6:\"mdhash\";s:32:\"1dc9da66c5a1d3665e80ef710e6d5491\";s:8:\"filesize\";s:6:\"470489\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1302456716\";s:6:\"mdhash\";s:32:\"553d25193b88e7b85304b36e21854297\";s:8:\"filesize\";s:6:\"470080\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1300860667\";s:6:\"mdhash\";s:32:\"ca49a6e24473b509402311c78e53c18b\";s:8:\"filesize\";s:6:\"469395\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1295780643\";s:6:\"mdhash\";s:32:\"08ce0c2ecf630044a56aa4fcffef70ae\";s:8:\"filesize\";s:6:\"464575\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:22:\"colorbox 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/colorbox/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1294250152\";s:6:\"mdhash\";s:32:\"d904b8c0d67188c87649e29be48d75d5\";s:8:\"filesize\";s:6:\"464551\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:20:\"colorbox 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/colorbox/releases/7.x-2.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/colorbox-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1499798042\";s:6:\"mdhash\";s:32:\"5d3fbfd4899a080da04e5ce0e998ffa3\";s:8:\"filesize\";s:7:\"1171670\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:20:\"colorbox 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/colorbox/releases/7.x-1.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/colorbox-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380559602\";s:6:\"mdhash\";s:32:\"51d68fe0bf25a4c6b5a4d43adca337d2\";s:8:\"filesize\";s:6:\"165085\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541605,1500455183,1),('available_releases::commerce','a:11:{s:5:\"title\";s:15:\"Drupal Commerce\";s:10:\"short_name\";s:8:\"commerce\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"https://www.drupal.org/project/commerce\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:27:{s:8:\"7.x-1.13\";a:14:{s:4:\"name\";s:17:\"commerce 7.x-1.13\";s:7:\"version\";s:8:\"7.x-1.13\";s:3:\"tag\";s:8:\"7.x-1.13\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/commerce/releases/7.x-1.13\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.13.tar.gz\";s:4:\"date\";s:10:\"1459956568\";s:6:\"mdhash\";s:32:\"32f60a3f4e7e08d8979be3c8beda49e2\";s:8:\"filesize\";s:6:\"381834\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-1.12\";a:14:{s:4:\"name\";s:17:\"commerce 7.x-1.12\";s:7:\"version\";s:8:\"7.x-1.12\";s:3:\"tag\";s:8:\"7.x-1.12\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/commerce/releases/7.x-1.12\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1459831734\";s:6:\"mdhash\";s:32:\"398790375ddc2e1bde90fe38e2cd625a\";s:8:\"filesize\";s:6:\"381908\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-1.11\";a:14:{s:4:\"name\";s:17:\"commerce 7.x-1.11\";s:7:\"version\";s:8:\"7.x-1.11\";s:3:\"tag\";s:8:\"7.x-1.11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/commerce/releases/7.x-1.11\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1421426580\";s:6:\"mdhash\";s:32:\"948ab5d78a0ee7e23c28d3df8f585ab6\";s:8:\"filesize\";s:6:\"382099\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-1.10\";a:14:{s:4:\"name\";s:17:\"commerce 7.x-1.10\";s:7:\"version\";s:8:\"7.x-1.10\";s:3:\"tag\";s:8:\"7.x-1.10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/commerce/releases/7.x-1.10\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1410366832\";s:6:\"mdhash\";s:32:\"aad5b6bbdf089c6f3550b3f04fd8ca1e\";s:8:\"filesize\";s:6:\"381635\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.9\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.9\";s:7:\"version\";s:7:\"7.x-1.9\";s:3:\"tag\";s:7:\"7.x-1.9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.9\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1394061805\";s:6:\"mdhash\";s:32:\"1fa0211d155f7e75e3a57c1a6cbd63e9\";s:8:\"filesize\";s:6:\"378943\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.8\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.8\";s:7:\"version\";s:7:\"7.x-1.8\";s:3:\"tag\";s:7:\"7.x-1.8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.8\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1374609068\";s:6:\"mdhash\";s:32:\"f1f8036c5dc006d641f504d2126ae4e7\";s:8:\"filesize\";s:6:\"369712\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.7\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.7\";s:7:\"version\";s:7:\"7.x-1.7\";s:3:\"tag\";s:7:\"7.x-1.7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.7\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1367298614\";s:6:\"mdhash\";s:32:\"bedfde3ae336892df9a433990b8fc77a\";s:8:\"filesize\";s:6:\"368250\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.6\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1365633618\";s:6:\"mdhash\";s:32:\"951cd47b652aabd411e562c29ce7dbe4\";s:8:\"filesize\";s:6:\"368067\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.5\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1360749320\";s:6:\"mdhash\";s:32:\"61f53b99d48441ef3f64a4a7e73981ac\";s:8:\"filesize\";s:6:\"366627\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.4\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1350864676\";s:6:\"mdhash\";s:32:\"18bf64b33ecb54e91d38a840f563a879\";s:8:\"filesize\";s:6:\"363286\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1336585865\";s:6:\"mdhash\";s:32:\"827c1fde0fa75a5bcea3bc10f2b2aadf\";s:8:\"filesize\";s:6:\"353698\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1327528840\";s:6:\"mdhash\";s:32:\"a7ac902711ce7c3e1722a015f41f2013\";s:8:\"filesize\";s:6:\"349147\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:12:\"New features\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1322552155\";s:6:\"mdhash\";s:32:\"62942795e7c21e385631659ac241ea1b\";s:8:\"filesize\";s:6:\"328801\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:16:\"commerce 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/commerce/releases/7.x-1.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1314124616\";s:6:\"mdhash\";s:32:\"d4eb672998468ec255d8be694a4d3779\";s:8:\"filesize\";s:6:\"315114\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc3\";a:15:{s:4:\"name\";s:20:\"commerce 7.x-1.0-rc3\";s:7:\"version\";s:11:\"7.x-1.0-rc3\";s:3:\"tag\";s:11:\"7.x-1.0-rc3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-rc3\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1313076716\";s:6:\"mdhash\";s:32:\"925dfa96685e2cbed1b549b77a56ebb0\";s:8:\"filesize\";s:6:\"312390\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:20:\"commerce 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1313037416\";s:6:\"mdhash\";s:32:\"6ba485c1fce1535f3b3e2957e616f394\";s:8:\"filesize\";s:6:\"312335\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:20:\"commerce 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1310664115\";s:6:\"mdhash\";s:32:\"c732e70e3e8f4a5e284c26bd4905ec4e\";s:8:\"filesize\";s:6:\"306038\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:22:\"commerce 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1307772351\";s:6:\"mdhash\";s:32:\"afeee457f68ac8165e2d5ad22c5f75e0\";s:8:\"filesize\";s:6:\"289313\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:22:\"commerce 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1303540316\";s:6:\"mdhash\";s:32:\"e4da46e99b11fb772e386a0db242b5e2\";s:8:\"filesize\";s:6:\"279732\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:22:\"commerce 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1298816467\";s:6:\"mdhash\";s:32:\"f6d3fc0daeb3245edc1d9eddf1e0d457\";s:8:\"filesize\";s:6:\"257520\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:22:\"commerce 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1298529203\";s:6:\"mdhash\";s:32:\"3e435407de0b4f8d8c1d8fd33329e5cb\";s:8:\"filesize\";s:6:\"259881\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha5\";a:15:{s:4:\"name\";s:23:\"commerce 7.x-1.0-alpha5\";s:7:\"version\";s:14:\"7.x-1.0-alpha5\";s:3:\"tag\";s:14:\"7.x-1.0-alpha5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-alpha5\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1296455786\";s:6:\"mdhash\";s:32:\"5dc5d375eedec0ffd7a6fd4d8fcdb102\";s:8:\"filesize\";s:6:\"216068\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha4\";a:15:{s:4:\"name\";s:23:\"commerce 7.x-1.0-alpha4\";s:7:\"version\";s:14:\"7.x-1.0-alpha4\";s:3:\"tag\";s:14:\"7.x-1.0-alpha4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-alpha4\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1293329163\";s:6:\"mdhash\";s:32:\"d62fa017115ecc34b81f3e4fe5e0b3db\";s:8:\"filesize\";s:6:\"191023\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:23:\"commerce 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1289666774\";s:6:\"mdhash\";s:32:\"449fee374e9f9c2f2f350f9a77551222\";s:8:\"filesize\";s:6:\"180135\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:23:\"commerce 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1286608567\";s:6:\"mdhash\";s:32:\"092559792765f635bdd4f30fcc47329d\";s:8:\"filesize\";s:6:\"151878\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:23:\"commerce 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1282612007\";s:6:\"mdhash\";s:32:\"dd5151ef1f8053306be442dd2cf479cd\";s:8:\"filesize\";s:6:\"122724\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:20:\"commerce 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/commerce/releases/7.x-1.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/commerce-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1498564442\";s:6:\"mdhash\";s:32:\"11caec0284d1c5089da3c6da02496244\";s:8:\"filesize\";s:6:\"384670\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541606,1500455183,1),('available_releases::commerce_cart_expiration','a:11:{s:5:\"title\";s:24:\"Commerce Cart Expiration\";s:10:\"short_name\";s:24:\"commerce_cart_expiration\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:55:\"https://www.drupal.org/project/commerce_cart_expiration\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:5:{s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:32:\"commerce_cart_expiration 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:72:\"https://www.drupal.org/project/commerce_cart_expiration/releases/7.x-1.4\";s:13:\"download_link\";s:77:\"https://ftp.drupal.org/files/projects/commerce_cart_expiration-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1473511439\";s:6:\"mdhash\";s:32:\"dc36a61aa03ffd13cc28be530d664ff6\";s:8:\"filesize\";s:5:\"14823\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:32:\"commerce_cart_expiration 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:72:\"https://www.drupal.org/project/commerce_cart_expiration/releases/7.x-1.3\";s:13:\"download_link\";s:77:\"https://ftp.drupal.org/files/projects/commerce_cart_expiration-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1453316639\";s:6:\"mdhash\";s:32:\"8eaee931bb3fa55421d767f90c6a30aa\";s:8:\"filesize\";s:5:\"14705\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:32:\"commerce_cart_expiration 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:72:\"https://www.drupal.org/project/commerce_cart_expiration/releases/7.x-1.2\";s:13:\"download_link\";s:77:\"https://ftp.drupal.org/files/projects/commerce_cart_expiration-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1417462080\";s:6:\"mdhash\";s:32:\"33404a4aaa8bd136cbf7ce9c4a27a2e1\";s:8:\"filesize\";s:5:\"14282\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:32:\"commerce_cart_expiration 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:72:\"https://www.drupal.org/project/commerce_cart_expiration/releases/7.x-1.1\";s:13:\"download_link\";s:77:\"https://ftp.drupal.org/files/projects/commerce_cart_expiration-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1382085696\";s:6:\"mdhash\";s:32:\"85393c9d504d3b38156778a493f6be59\";s:8:\"filesize\";s:5:\"14316\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:32:\"commerce_cart_expiration 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:72:\"https://www.drupal.org/project/commerce_cart_expiration/releases/7.x-1.0\";s:13:\"download_link\";s:77:\"https://ftp.drupal.org/files/projects/commerce_cart_expiration-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1333976150\";s:6:\"mdhash\";s:32:\"aec2aaa818e0ace09d66225ada4b9566\";s:8:\"filesize\";s:4:\"9870\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}}}',1500541606,1500455183,1),('available_releases::commerce_paypal','a:11:{s:5:\"title\";s:15:\"Commerce PayPal\";s:10:\"short_name\";s:15:\"commerce_paypal\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:46:\"https://www.drupal.org/project/commerce_paypal\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:10:{s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:23:\"commerce_paypal 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.4\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1497908942\";s:6:\"mdhash\";s:32:\"4d7129199d1d7efc162ae1eef7003c72\";s:8:\"filesize\";s:5:\"71951\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:23:\"commerce_paypal 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.3\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1389740905\";s:6:\"mdhash\";s:32:\"2679887b33842c2ab7b7a830cc963ad9\";s:8:\"filesize\";s:5:\"69460\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:23:\"commerce_paypal 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1379410934\";s:6:\"mdhash\";s:32:\"b91dabf9f87041753d85d0f1c2dc91e0\";s:8:\"filesize\";s:5:\"70177\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:23:\"commerce_paypal 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1379295700\";s:6:\"mdhash\";s:32:\"d84284794ac0fe0256bc2f129bdb612f\";s:8:\"filesize\";s:5:\"70303\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:23:\"commerce_paypal 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.0\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1372479352\";s:6:\"mdhash\";s:32:\"46935ff9c2099391421948aeaa18475c\";s:8:\"filesize\";s:5:\"64858\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-2.0-beta1\";a:15:{s:4:\"name\";s:29:\"commerce_paypal 7.x-2.0-beta1\";s:7:\"version\";s:13:\"7.x-2.0-beta1\";s:3:\"tag\";s:13:\"7.x-2.0-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:69:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.0-beta1\";s:13:\"download_link\";s:74:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1360753518\";s:6:\"mdhash\";s:32:\"64bd53b26d4fcb2ed43e6a365eafd49f\";s:8:\"filesize\";s:5:\"63814\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:23:\"commerce_paypal 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-1.0\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1355696805\";s:6:\"mdhash\";s:32:\"58eb5b1ad772a79eb5bfe0fe7dd671e3\";s:8:\"filesize\";s:5:\"29546\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:27:\"commerce_paypal 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1347157356\";s:6:\"mdhash\";s:32:\"5efd04e9dace7d2fe112d9061673b91d\";s:8:\"filesize\";s:5:\"29556\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:27:\"commerce_paypal 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-2.x-dev\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1497908643\";s:6:\"mdhash\";s:32:\"1b6a8bcb14ded436f59294f4a35a1ca6\";s:8:\"filesize\";s:5:\"72053\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:27:\"commerce_paypal 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/commerce_paypal/releases/7.x-1.x-dev\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/commerce_paypal-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380560597\";s:6:\"mdhash\";s:32:\"0daf56e6792f156f4726376570718a3d\";s:8:\"filesize\";s:5:\"29564\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541607,1500455183,1),('available_releases::ctools','a:11:{s:5:\"title\";s:25:\"Chaos tool suite (ctools)\";s:10:\"short_name\";s:6:\"ctools\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:37:\"https://www.drupal.org/project/ctools\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:22:{s:8:\"7.x-1.12\";a:14:{s:4:\"name\";s:15:\"ctools 7.x-1.12\";s:7:\"version\";s:8:\"7.x-1.12\";s:3:\"tag\";s:8:\"7.x-1.12\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/ctools/releases/7.x-1.12\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1479787142\";s:6:\"mdhash\";s:32:\"daae0be22830e34c4d952f91557ae5a5\";s:8:\"filesize\";s:6:\"433707\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-1.11\";a:14:{s:4:\"name\";s:15:\"ctools 7.x-1.11\";s:7:\"version\";s:8:\"7.x-1.11\";s:3:\"tag\";s:8:\"7.x-1.11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/ctools/releases/7.x-1.11\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1476581639\";s:6:\"mdhash\";s:32:\"271d08d18f3c05f51aba1ad77d42f96c\";s:8:\"filesize\";s:6:\"432144\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-1.10\";a:14:{s:4:\"name\";s:15:\"ctools 7.x-1.10\";s:7:\"version\";s:8:\"7.x-1.10\";s:3:\"tag\";s:8:\"7.x-1.10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/ctools/releases/7.x-1.10\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1471454080\";s:6:\"mdhash\";s:32:\"38bb47304f6dcd0bcd6b02ed6ee235fc\";s:8:\"filesize\";s:6:\"430198\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.9\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.9\";s:7:\"version\";s:7:\"7.x-1.9\";s:3:\"tag\";s:7:\"7.x-1.9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.9\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1440019139\";s:6:\"mdhash\";s:32:\"bd7b5dac915e8fa3da909379807ef824\";s:8:\"filesize\";s:6:\"429330\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.8\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.8\";s:7:\"version\";s:7:\"7.x-1.8\";s:3:\"tag\";s:7:\"7.x-1.8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.8\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1440015839\";s:6:\"mdhash\";s:32:\"629f8bc414026864fe4a235b62586e0c\";s:8:\"filesize\";s:6:\"428252\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.7\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.7\";s:7:\"version\";s:7:\"7.x-1.7\";s:3:\"tag\";s:7:\"7.x-1.7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.7\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1426695781\";s:6:\"mdhash\";s:32:\"81ab507b12875b02b88a0492d1173b99\";s:8:\"filesize\";s:6:\"426463\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.6\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1422471481\";s:6:\"mdhash\";s:32:\"e8999d5bd1748ee3dcd4fdc33a24c615\";s:8:\"filesize\";s:6:\"424622\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.6-rc1\";a:15:{s:4:\"name\";s:18:\"ctools 7.x-1.6-rc1\";s:7:\"version\";s:11:\"7.x-1.6-rc1\";s:3:\"tag\";s:11:\"7.x-1.6-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/ctools/releases/7.x-1.6-rc1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.6-rc1.tar.gz\";s:4:\"date\";s:10:\"1418961480\";s:6:\"mdhash\";s:32:\"f3dc80ff7f3e29c73870f26a6ad02ff7\";s:8:\"filesize\";s:6:\"422180\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.5\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1416423482\";s:6:\"mdhash\";s:32:\"0e90d8baaae78d3c37fe73dbe0d98dac\";s:8:\"filesize\";s:6:\"417508\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.4\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1392220719\";s:6:\"mdhash\";s:32:\"df1ce5aeb6a9a5c383d944a2a7494f18\";s:8:\"filesize\";s:6:\"415678\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.3\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1365013512\";s:6:\"mdhash\";s:32:\"b27a7230f63a7a81db8cc480ab2dba63\";s:8:\"filesize\";s:6:\"413477\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.2\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1345319204\";s:6:\"mdhash\";s:32:\"62fa855ee8aced1e355b09ac6cd54e99\";s:8:\"filesize\";s:6:\"407345\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.1\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1344463011\";s:6:\"mdhash\";s:32:\"c36cbb2fd7a6eb8b3245c13972380bd7\";s:8:\"filesize\";s:6:\"405567\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:14:\"ctools 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/ctools/releases/7.x-1.0\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1332962446\";s:6:\"mdhash\";s:32:\"642eca364e64b0074e5ad49f86627ac5\";s:8:\"filesize\";s:6:\"402254\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:18:\"ctools 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1332017742\";s:6:\"mdhash\";s:32:\"791167a47cea014fad9018c93376aa88\";s:8:\"filesize\";s:6:\"396440\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:18:\"ctools 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1311894415\";s:6:\"mdhash\";s:32:\"39bcea671210505409e3148c8eaefc0e\";s:8:\"filesize\";s:6:\"381078\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:20:\"ctools 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1306885315\";s:6:\"mdhash\";s:32:\"96d8154bfab611eb59cbd3774aa94793\";s:8:\"filesize\";s:6:\"378287\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha4\";a:15:{s:4:\"name\";s:21:\"ctools 7.x-1.0-alpha4\";s:7:\"version\";s:14:\"7.x-1.0-alpha4\";s:3:\"tag\";s:14:\"7.x-1.0-alpha4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-alpha4\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1301099792\";s:6:\"mdhash\";s:32:\"774f6654c149f192b11b136a06be5544\";s:8:\"filesize\";s:6:\"370763\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:21:\"ctools 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1300395967\";s:6:\"mdhash\";s:32:\"1909846a7bd5775c99331c6564ffefa8\";s:8:\"filesize\";s:6:\"370238\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:21:\"ctools 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1294276865\";s:6:\"mdhash\";s:32:\"30e0f5cb27949d2cd67b80bb36701d3e\";s:8:\"filesize\";s:6:\"521068\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:21:\"ctools 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/ctools/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1286838960\";s:6:\"mdhash\";s:32:\"500a55a33f90b2bab865753a0d8c5439\";s:8:\"filesize\";s:6:\"510384\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:18:\"ctools 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/ctools/releases/7.x-1.x-dev\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/ctools-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1487053684\";s:6:\"mdhash\";s:32:\"149a825138993bde410a2cb823a716c2\";s:8:\"filesize\";s:6:\"440513\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541607,1500455183,1),('available_releases::date','a:11:{s:5:\"title\";s:4:\"Date\";s:10:\"short_name\";s:4:\"date\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:35:\"https://www.drupal.org/project/date\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:31:{s:8:\"7.x-2.10\";a:14:{s:4:\"name\";s:13:\"date 7.x-2.10\";s:7:\"version\";s:8:\"7.x-2.10\";s:3:\"tag\";s:8:\"7.x-2.10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/date/releases/7.x-2.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/date-7.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1491562083\";s:6:\"mdhash\";s:32:\"2574ab984de79b65f93dbeb48a4e2036\";s:8:\"filesize\";s:6:\"226466\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:12:\"7.x-2.10-rc2\";a:15:{s:4:\"name\";s:17:\"date 7.x-2.10-rc2\";s:7:\"version\";s:12:\"7.x-2.10-rc2\";s:3:\"tag\";s:12:\"7.x-2.10-rc2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/date/releases/7.x-2.10-rc2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/date-7.x-2.10-rc2.tar.gz\";s:4:\"date\";s:10:\"1490783284\";s:6:\"mdhash\";s:32:\"2e59072e74cf1e180b5f159cea91639c\";s:8:\"filesize\";s:6:\"226485\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"7.x-2.10-rc1\";a:15:{s:4:\"name\";s:17:\"date 7.x-2.10-rc1\";s:7:\"version\";s:12:\"7.x-2.10-rc1\";s:3:\"tag\";s:12:\"7.x-2.10-rc1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/date/releases/7.x-2.10-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/date-7.x-2.10-rc1.tar.gz\";s:4:\"date\";s:10:\"1461749740\";s:6:\"mdhash\";s:32:\"59079319cdaa7f96843c66a674bd6f96\";s:8:\"filesize\";s:6:\"226185\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.10-beta1\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.10-beta1\";s:7:\"version\";s:14:\"7.x-2.10-beta1\";s:3:\"tag\";s:14:\"7.x-2.10-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.10-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.10-beta1.tar.gz\";s:4:\"date\";s:10:\"1452253139\";s:6:\"mdhash\";s:32:\"b6c7abde2995afb8a014cb590ac131ac\";s:8:\"filesize\";s:6:\"224719\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"7.x-2.9\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.9\";s:7:\"version\";s:7:\"7.x-2.9\";s:3:\"tag\";s:7:\"7.x-2.9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1441727339\";s:6:\"mdhash\";s:32:\"5d76a5e020d3926aa3c516e426678700\";s:8:\"filesize\";s:6:\"224512\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-2.9-rc1\";a:15:{s:4:\"name\";s:16:\"date 7.x-2.9-rc1\";s:7:\"version\";s:11:\"7.x-2.9-rc1\";s:3:\"tag\";s:11:\"7.x-2.9-rc1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/date/releases/7.x-2.9-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/date-7.x-2.9-rc1.tar.gz\";s:4:\"date\";s:10:\"1427454181\";s:6:\"mdhash\";s:32:\"5cc051772c39d76bb0a2bfd8a5f7c775\";s:8:\"filesize\";s:6:\"224454\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.9-beta2\";a:15:{s:4:\"name\";s:18:\"date 7.x-2.9-beta2\";s:7:\"version\";s:13:\"7.x-2.9-beta2\";s:3:\"tag\";s:13:\"7.x-2.9-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/date/releases/7.x-2.9-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/date-7.x-2.9-beta2.tar.gz\";s:4:\"date\";s:10:\"1417718873\";s:6:\"mdhash\";s:32:\"e81616832e6ef58be039640a4fe35390\";s:8:\"filesize\";s:6:\"223732\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.9-beta1\";a:15:{s:4:\"name\";s:18:\"date 7.x-2.9-beta1\";s:7:\"version\";s:13:\"7.x-2.9-beta1\";s:3:\"tag\";s:13:\"7.x-2.9-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/date/releases/7.x-2.9-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/date-7.x-2.9-beta1.tar.gz\";s:4:\"date\";s:10:\"1415483880\";s:6:\"mdhash\";s:32:\"e03390f28efe81e7e56180651f4bb76a\";s:8:\"filesize\";s:6:\"222344\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.9-alpha2\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.9-alpha2\";s:7:\"version\";s:14:\"7.x-2.9-alpha2\";s:3:\"tag\";s:14:\"7.x-2.9-alpha2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.9-alpha2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.9-alpha2.tar.gz\";s:4:\"date\";s:10:\"1411597754\";s:6:\"mdhash\";s:32:\"2f71a9bc1dc8a13c1607ca2dc74a87b7\";s:8:\"filesize\";s:6:\"218373\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.9-alpha1\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.9-alpha1\";s:7:\"version\";s:14:\"7.x-2.9-alpha1\";s:3:\"tag\";s:14:\"7.x-2.9-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.9-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.9-alpha1.tar.gz\";s:4:\"date\";s:10:\"1406829527\";s:6:\"mdhash\";s:32:\"3e6a694c86989c61d9cd5cf4cf582bc5\";s:8:\"filesize\";s:6:\"218628\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"7.x-2.8\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.8\";s:7:\"version\";s:7:\"7.x-2.8\";s:3:\"tag\";s:7:\"7.x-2.8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1406653427\";s:6:\"mdhash\";s:32:\"e0d07255a60e3a7716db5902767e08d1\";s:8:\"filesize\";s:6:\"218587\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-2.8-beta2\";a:15:{s:4:\"name\";s:18:\"date 7.x-2.8-beta2\";s:7:\"version\";s:13:\"7.x-2.8-beta2\";s:3:\"tag\";s:13:\"7.x-2.8-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/date/releases/7.x-2.8-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/date-7.x-2.8-beta2.tar.gz\";s:4:\"date\";s:10:\"1406317428\";s:6:\"mdhash\";s:32:\"3ba190c30aa3833500af8505c9951121\";s:8:\"filesize\";s:6:\"217910\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.8-beta1\";a:15:{s:4:\"name\";s:18:\"date 7.x-2.8-beta1\";s:7:\"version\";s:13:\"7.x-2.8-beta1\";s:3:\"tag\";s:13:\"7.x-2.8-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/date/releases/7.x-2.8-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/date-7.x-2.8-beta1.tar.gz\";s:4:\"date\";s:10:\"1403366927\";s:6:\"mdhash\";s:32:\"cf89ddee77f567db0157124e1651246d\";s:8:\"filesize\";s:6:\"217411\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"7.x-2.7\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.7\";s:7:\"version\";s:7:\"7.x-2.7\";s:3:\"tag\";s:7:\"7.x-2.7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1387659204\";s:6:\"mdhash\";s:32:\"24e11f82623a442305c30cb6887d77f9\";s:8:\"filesize\";s:6:\"216320\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.6\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.6\";s:7:\"version\";s:7:\"7.x-2.6\";s:3:\"tag\";s:7:\"7.x-2.6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1344850024\";s:6:\"mdhash\";s:32:\"cc22fe50289aea79b3b9b240baba0111\";s:8:\"filesize\";s:6:\"213301\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1334835098\";s:6:\"mdhash\";s:32:\"56fa435f5c8831655ddf3f4fffe2b97a\";s:8:\"filesize\";s:6:\"211078\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1334828498\";s:6:\"mdhash\";s:32:\"2c152c82d8cc55e090cba40a46742465\";s:8:\"filesize\";s:6:\"210999\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1333273246\";s:6:\"mdhash\";s:32:\"3290ee3891157384b606633dda02fe19\";s:8:\"filesize\";s:6:\"210464\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1330089942\";s:6:\"mdhash\";s:32:\"652323d741226212057e8f58906c7d6a\";s:8:\"filesize\";s:6:\"207223\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:12:\"date 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/date/releases/7.x-2.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/date-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1329214840\";s:6:\"mdhash\";s:32:\"08eab951b7096b1edcc1cdff52b3c9cc\";s:8:\"filesize\";s:6:\"208349\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-2.0-rc2\";a:15:{s:4:\"name\";s:16:\"date 7.x-2.0-rc2\";s:7:\"version\";s:11:\"7.x-2.0-rc2\";s:3:\"tag\";s:11:\"7.x-2.0-rc2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/date/releases/7.x-2.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1328104249\";s:6:\"mdhash\";s:32:\"60e5d591d567e823141650db8290394b\";s:8:\"filesize\";s:6:\"208479\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.0-rc1\";a:15:{s:4:\"name\";s:16:\"date 7.x-2.0-rc1\";s:7:\"version\";s:11:\"7.x-2.0-rc1\";s:3:\"tag\";s:11:\"7.x-2.0-rc1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/date/releases/7.x-2.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1324415138\";s:6:\"mdhash\";s:32:\"553e622be1be5c28b59c088f8b890872\";s:8:\"filesize\";s:6:\"203112\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha5\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.0-alpha5\";s:7:\"version\";s:14:\"7.x-2.0-alpha5\";s:3:\"tag\";s:14:\"7.x-2.0-alpha5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.0-alpha5\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1322563238\";s:6:\"mdhash\";s:32:\"02cf9eff83b7203b70c311daca9c0e8c\";s:8:\"filesize\";s:6:\"204364\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha4\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.0-alpha4\";s:7:\"version\";s:14:\"7.x-2.0-alpha4\";s:3:\"tag\";s:14:\"7.x-2.0-alpha4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.0-alpha4\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1314097619\";s:6:\"mdhash\";s:32:\"832ce7f175146004c9976b9191d37f45\";s:8:\"filesize\";s:6:\"195013\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha3\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.0-alpha3\";s:7:\"version\";s:14:\"7.x-2.0-alpha3\";s:3:\"tag\";s:14:\"7.x-2.0-alpha3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.0-alpha3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1303821715\";s:6:\"mdhash\";s:32:\"d7de2d8ece4098fe8ac9ce6e5eb30270\";s:8:\"filesize\";s:6:\"169553\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha2\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.0-alpha2\";s:7:\"version\";s:14:\"7.x-2.0-alpha2\";s:3:\"tag\";s:14:\"7.x-2.0-alpha2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.0-alpha2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1303818715\";s:6:\"mdhash\";s:32:\"2a2c10cb87eed66b0174283f9fc607c4\";s:8:\"filesize\";s:6:\"169563\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha1\";a:15:{s:4:\"name\";s:19:\"date 7.x-2.0-alpha1\";s:7:\"version\";s:14:\"7.x-2.0-alpha1\";s:3:\"tag\";s:14:\"7.x-2.0-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-2.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1299682267\";s:6:\"mdhash\";s:32:\"c5ab4e67bb59da279c0da9b10ed9725e\";s:8:\"filesize\";s:6:\"166837\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:19:\"date 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1295529407\";s:6:\"mdhash\";s:32:\"0ed3d8939eeb72e7a3bcb537ed4d21ff\";s:8:\"filesize\";s:6:\"268480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:19:\"date 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/date/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/date-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1295353339\";s:6:\"mdhash\";s:32:\"6534800ffd881bab8721172100039111\";s:8:\"filesize\";s:6:\"268378\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:16:\"date 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/date/releases/7.x-2.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/date-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1490712482\";s:6:\"mdhash\";s:32:\"d1b92438376c95b25e429036c4dd3ef9\";s:8:\"filesize\";s:6:\"226507\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:16:\"date-7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/date/releases/7.x-1.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/date-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1490710682\";s:6:\"mdhash\";s:32:\"fac06f792a558a00f0bc1b49b43469fd\";s:8:\"filesize\";s:6:\"166214\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541608,1500455183,1),('available_releases::drupal','a:11:{s:5:\"title\";s:11:\"Drupal core\";s:10:\"short_name\";s:6:\"drupal\";s:4:\"type\";s:12:\"project_core\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"7\";s:16:\"supported_majors\";s:1:\"7\";s:13:\"default_major\";s:1:\"7\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:37:\"https://www.drupal.org/project/drupal\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:67:{s:4:\"7.56\";a:14:{s:4:\"name\";s:11:\"drupal 7.56\";s:7:\"version\";s:4:\"7.56\";s:3:\"tag\";s:4:\"7.56\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"56\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.56\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.56.tar.gz\";s:4:\"date\";s:10:\"1498069782\";s:6:\"mdhash\";s:32:\"5d198f40f0f1cbf9cdf1bf3de842e534\";s:8:\"filesize\";s:7:\"3277833\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.55\";a:14:{s:4:\"name\";s:11:\"drupal 7.55\";s:7:\"version\";s:4:\"7.55\";s:3:\"tag\";s:4:\"7.55\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"55\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.55\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.55.tar.gz\";s:4:\"date\";s:10:\"1496873942\";s:6:\"mdhash\";s:32:\"ad97f8c86cee7be9d6ab13724b55fa1c\";s:8:\"filesize\";s:7:\"3277355\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.54\";a:14:{s:4:\"name\";s:11:\"drupal 7.54\";s:7:\"version\";s:4:\"7.54\";s:3:\"tag\";s:4:\"7.54\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"54\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.54\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.54.tar.gz\";s:4:\"date\";s:10:\"1485986883\";s:6:\"mdhash\";s:32:\"3068cbe488075ae166e23ea6cd29cf0f\";s:8:\"filesize\";s:7:\"3275864\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.53\";a:14:{s:4:\"name\";s:11:\"drupal 7.53\";s:7:\"version\";s:4:\"7.53\";s:3:\"tag\";s:4:\"7.53\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"53\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.53\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.53.tar.gz\";s:4:\"date\";s:10:\"1481152384\";s:6:\"mdhash\";s:32:\"4230279ecca4f0cde652a219e10327e7\";s:8:\"filesize\";s:7:\"3273245\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.52\";a:14:{s:4:\"name\";s:11:\"drupal 7.52\";s:7:\"version\";s:4:\"7.52\";s:3:\"tag\";s:4:\"7.52\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"52\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.52\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.52.tar.gz\";s:4:\"date\";s:10:\"1479322810\";s:6:\"mdhash\";s:32:\"4963e68ca12918d3a3eae56054214191\";s:8:\"filesize\";s:7:\"3289714\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.51\";a:14:{s:4:\"name\";s:11:\"drupal 7.51\";s:7:\"version\";s:4:\"7.51\";s:3:\"tag\";s:4:\"7.51\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"51\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.51\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.51.tar.gz\";s:4:\"date\";s:10:\"1475693339\";s:6:\"mdhash\";s:32:\"49f82c1cac8e4bd4941ca160fcbee93d\";s:8:\"filesize\";s:7:\"3288987\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.50\";a:14:{s:4:\"name\";s:11:\"drupal 7.50\";s:7:\"version\";s:4:\"7.50\";s:3:\"tag\";s:4:\"7.50\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"50\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.50\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.50.tar.gz\";s:4:\"date\";s:10:\"1467918239\";s:6:\"mdhash\";s:32:\"f23905b0248d76f0fc8316692cd64753\";s:8:\"filesize\";s:7:\"3286826\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.44\";a:14:{s:4:\"name\";s:11:\"drupal 7.44\";s:7:\"version\";s:4:\"7.44\";s:3:\"tag\";s:4:\"7.44\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"44\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.44\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.44.tar.gz\";s:4:\"date\";s:10:\"1466021480\";s:6:\"mdhash\";s:32:\"965ab5fe5457625ec8c18e5c1c455008\";s:8:\"filesize\";s:7:\"3265819\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.43\";a:14:{s:4:\"name\";s:11:\"drupal 7.43\";s:7:\"version\";s:4:\"7.43\";s:3:\"tag\";s:4:\"7.43\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"43\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.43\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.43.tar.gz\";s:4:\"date\";s:10:\"1456341749\";s:6:\"mdhash\";s:32:\"c6fb49bc88a6408a985afddac76b9f8b\";s:8:\"filesize\";s:7:\"3265824\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.42\";a:14:{s:4:\"name\";s:11:\"drupal 7.42\";s:7:\"version\";s:4:\"7.42\";s:3:\"tag\";s:4:\"7.42\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"42\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.42-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.42.tar.gz\";s:4:\"date\";s:10:\"1454516939\";s:6:\"mdhash\";s:32:\"9a96f67474e209dd48750ba6fccc77db\";s:8:\"filesize\";s:7:\"3264065\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.41\";a:14:{s:4:\"name\";s:11:\"drupal 7.41\";s:7:\"version\";s:4:\"7.41\";s:3:\"tag\";s:4:\"7.41\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"41\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.41-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.41.tar.gz\";s:4:\"date\";s:10:\"1445457239\";s:6:\"mdhash\";s:32:\"7636e75e8be213455b4ac7911ce5801f\";s:8:\"filesize\";s:7:\"3257325\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.40\";a:14:{s:4:\"name\";s:11:\"drupal 7.40\";s:7:\"version\";s:4:\"7.40\";s:3:\"tag\";s:4:\"7.40\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"40\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.40-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.40.tar.gz\";s:4:\"date\";s:10:\"1444865639\";s:6:\"mdhash\";s:32:\"d4509f13c23999a76e61ec4d5ccfaf26\";s:8:\"filesize\";s:7:\"3257401\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.39\";a:14:{s:4:\"name\";s:11:\"drupal 7.39\";s:7:\"version\";s:4:\"7.39\";s:3:\"tag\";s:4:\"7.39\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"39\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.39-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.39.tar.gz\";s:4:\"date\";s:10:\"1440019139\";s:6:\"mdhash\";s:32:\"6f42a7e9c7a1c2c4c9c2f20c81b8e79a\";s:8:\"filesize\";s:7:\"3249343\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.38\";a:14:{s:4:\"name\";s:11:\"drupal 7.38\";s:7:\"version\";s:4:\"7.38\";s:3:\"tag\";s:4:\"7.38\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"38\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.38-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.38.tar.gz\";s:4:\"date\";s:10:\"1434566280\";s:6:\"mdhash\";s:32:\"c18298c1a5aed32ddbdac605fdef7fce\";s:8:\"filesize\";s:7:\"3247864\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.37\";a:14:{s:4:\"name\";s:11:\"drupal 7.37\";s:7:\"version\";s:4:\"7.37\";s:3:\"tag\";s:4:\"7.37\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"37\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.37-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.37.tar.gz\";s:4:\"date\";s:10:\"1430972281\";s:6:\"mdhash\";s:32:\"3a70696c87b786365f2c6c3aeb895d8a\";s:8:\"filesize\";s:7:\"3244291\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.36\";a:14:{s:4:\"name\";s:11:\"drupal 7.36\";s:7:\"version\";s:4:\"7.36\";s:3:\"tag\";s:4:\"7.36\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"36\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.36-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.36.tar.gz\";s:4:\"date\";s:10:\"1427943181\";s:6:\"mdhash\";s:32:\"98e1f62c11a5dc5f9481935eefc814c5\";s:8:\"filesize\";s:7:\"3244905\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.35\";a:14:{s:4:\"name\";s:11:\"drupal 7.35\";s:7:\"version\";s:4:\"7.35\";s:3:\"tag\";s:4:\"7.35\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"35\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.35-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.35.tar.gz\";s:4:\"date\";s:10:\"1426706281\";s:6:\"mdhash\";s:32:\"fecc55bd0bd476bc35d9ebf68452942d\";s:8:\"filesize\";s:7:\"3234349\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.34\";a:14:{s:4:\"name\";s:11:\"drupal 7.34\";s:7:\"version\";s:4:\"7.34\";s:3:\"tag\";s:4:\"7.34\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"34\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.34-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.34.tar.gz\";s:4:\"date\";s:10:\"1416429264\";s:6:\"mdhash\";s:32:\"bb4d212e1eb1d7375e41613fbefa04f2\";s:8:\"filesize\";s:7:\"3229858\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.33\";a:14:{s:4:\"name\";s:11:\"drupal 7.33\";s:7:\"version\";s:4:\"7.33\";s:3:\"tag\";s:4:\"7.33\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"33\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.33-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.33.tar.gz\";s:4:\"date\";s:10:\"1415374080\";s:6:\"mdhash\";s:32:\"187b076a5753960d5d5cb12d30d93e73\";s:8:\"filesize\";s:7:\"3229397\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.32\";a:14:{s:4:\"name\";s:11:\"drupal 7.32\";s:7:\"version\";s:4:\"7.32\";s:3:\"tag\";s:4:\"7.32\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"32\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.32-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.32.tar.gz\";s:4:\"date\";s:10:\"1413387329\";s:6:\"mdhash\";s:32:\"d5d121a6ce974f2d20604a7e10e1987a\";s:8:\"filesize\";s:7:\"3215563\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.31\";a:14:{s:4:\"name\";s:11:\"drupal 7.31\";s:7:\"version\";s:4:\"7.31\";s:3:\"tag\";s:4:\"7.31\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"31\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.31-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.31.tar.gz\";s:4:\"date\";s:10:\"1407346427\";s:6:\"mdhash\";s:32:\"de256f202930d3ef5ccc6aebc550adaf\";s:8:\"filesize\";s:7:\"3216766\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.30\";a:14:{s:4:\"name\";s:11:\"drupal 7.30\";s:7:\"version\";s:4:\"7.30\";s:3:\"tag\";s:4:\"7.30\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"30\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.30-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.30.tar.gz\";s:4:\"date\";s:10:\"1406239728\";s:6:\"mdhash\";s:32:\"ef7bce65ca6395f1e6bc44c15fdbc3cb\";s:8:\"filesize\";s:7:\"3215744\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.29\";a:14:{s:4:\"name\";s:11:\"drupal 7.29\";s:7:\"version\";s:4:\"7.29\";s:3:\"tag\";s:4:\"7.29\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"29\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.29-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.29.tar.gz\";s:4:\"date\";s:10:\"1405543128\";s:6:\"mdhash\";s:32:\"6ffdfb0ee08fadfb531c7fed1d2c5633\";s:8:\"filesize\";s:7:\"3213499\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.28\";a:14:{s:4:\"name\";s:11:\"drupal 7.28\";s:7:\"version\";s:4:\"7.28\";s:3:\"tag\";s:4:\"7.28\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"28\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.28-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.28.tar.gz\";s:4:\"date\";s:10:\"1399522729\";s:6:\"mdhash\";s:32:\"6255884d7e15c654fc8856805b271551\";s:8:\"filesize\";s:7:\"3212823\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.27\";a:14:{s:4:\"name\";s:11:\"drupal 7.27\";s:7:\"version\";s:4:\"7.27\";s:3:\"tag\";s:4:\"7.27\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"27\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.27-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.27.tar.gz\";s:4:\"date\";s:10:\"1397686464\";s:6:\"mdhash\";s:32:\"e9b05562f1a7f8bbcb5922cd3a0d55cb\";s:8:\"filesize\";s:7:\"3207398\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.26\";a:14:{s:4:\"name\";s:11:\"drupal 7.26\";s:7:\"version\";s:4:\"7.26\";s:3:\"tag\";s:4:\"7.26\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"26\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.26-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.26.tar.gz\";s:4:\"date\";s:10:\"1389815904\";s:6:\"mdhash\";s:32:\"740bd57f524b8ac18a203b663ca1329d\";s:8:\"filesize\";s:7:\"3204587\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.25\";a:14:{s:4:\"name\";s:11:\"drupal 7.25\";s:7:\"version\";s:4:\"7.25\";s:3:\"tag\";s:4:\"7.25\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"25\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.25-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.25.tar.gz\";s:4:\"date\";s:10:\"1388709505\";s:6:\"mdhash\";s:32:\"25906158083d89aa86534df1c683b4ea\";s:8:\"filesize\";s:7:\"3203256\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.24\";a:14:{s:4:\"name\";s:11:\"drupal 7.24\";s:7:\"version\";s:4:\"7.24\";s:3:\"tag\";s:4:\"7.24\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"24\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.24-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.24.tar.gz\";s:4:\"date\";s:10:\"1384982905\";s:6:\"mdhash\";s:32:\"c1ddb37155e4b6160f6508636c06f2a7\";s:8:\"filesize\";s:7:\"3195735\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.23\";a:14:{s:4:\"name\";s:11:\"drupal 7.23\";s:7:\"version\";s:4:\"7.23\";s:3:\"tag\";s:4:\"7.23\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"23\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.23-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.23.tar.gz\";s:4:\"date\";s:10:\"1375928239\";s:6:\"mdhash\";s:32:\"0beca6fec15b8cf8c35a6fdda6675342\";s:8:\"filesize\";s:7:\"3191695\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.22\";a:14:{s:4:\"name\";s:11:\"drupal 7.22\";s:7:\"version\";s:4:\"7.22\";s:3:\"tag\";s:4:\"7.22\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"22\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.22-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.22.tar.gz\";s:4:\"date\";s:10:\"1365027013\";s:6:\"mdhash\";s:32:\"068d7a77958fce6bb002659aa7ccaeb7\";s:8:\"filesize\";s:7:\"3183014\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.21\";a:14:{s:4:\"name\";s:11:\"drupal 7.21\";s:7:\"version\";s:4:\"7.21\";s:3:\"tag\";s:4:\"7.21\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.21-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.21.tar.gz\";s:4:\"date\";s:10:\"1362616997\";s:6:\"mdhash\";s:32:\"eff054cd53be39ff719f77c81dce1aac\";s:8:\"filesize\";s:7:\"3163798\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.20\";a:14:{s:4:\"name\";s:11:\"drupal 7.20\";s:7:\"version\";s:4:\"7.20\";s:3:\"tag\";s:4:\"7.20\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.20-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.20.tar.gz\";s:4:\"date\";s:10:\"1361393684\";s:6:\"mdhash\";s:32:\"ee576d63f1fd8a1f1c072a56978da0c5\";s:8:\"filesize\";s:7:\"3163257\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.19\";a:14:{s:4:\"name\";s:11:\"drupal 7.19\";s:7:\"version\";s:4:\"7.19\";s:3:\"tag\";s:4:\"7.19\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.19-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.19.tar.gz\";s:4:\"date\";s:10:\"1358374871\";s:6:\"mdhash\";s:32:\"c1dd3960f1555df208c80ef612e0c53a\";s:8:\"filesize\";s:7:\"3163130\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.18\";a:14:{s:4:\"name\";s:11:\"drupal 7.18\";s:7:\"version\";s:4:\"7.18\";s:3:\"tag\";s:4:\"7.18\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.18-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.18.tar.gz\";s:4:\"date\";s:10:\"1355944004\";s:6:\"mdhash\";s:32:\"5c048f60a53acd7cb3c2b6d5fe42f082\";s:8:\"filesize\";s:7:\"3162333\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.17\";a:14:{s:4:\"name\";s:11:\"drupal 7.17\";s:7:\"version\";s:4:\"7.17\";s:3:\"tag\";s:4:\"7.17\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:48:\"https://www.drupal.org/drupal-7.17-release-notes\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.17.tar.gz\";s:4:\"date\";s:10:\"1352325358\";s:6:\"mdhash\";s:32:\"439e8ca7e6a33bb879a4624d8f01bed0\";s:8:\"filesize\";s:7:\"3162429\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.16\";a:14:{s:4:\"name\";s:11:\"drupal 7.16\";s:7:\"version\";s:4:\"7.16\";s:3:\"tag\";s:4:\"7.16\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.16\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.16.tar.gz\";s:4:\"date\";s:10:\"1350508568\";s:6:\"mdhash\";s:32:\"352497b2df94b5308e31cb8da020b631\";s:8:\"filesize\";s:7:\"3142889\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.15\";a:14:{s:4:\"name\";s:11:\"drupal 7.15\";s:7:\"version\";s:4:\"7.15\";s:3:\"tag\";s:4:\"7.15\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.15\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.15.tar.gz\";s:4:\"date\";s:10:\"1343839327\";s:6:\"mdhash\";s:32:\"f42c9baccd74e1d035d61ff537ae21b4\";s:8:\"filesize\";s:7:\"3142219\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.14\";a:14:{s:4:\"name\";s:11:\"drupal 7.14\";s:7:\"version\";s:4:\"7.14\";s:3:\"tag\";s:4:\"7.14\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.14\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.14.tar.gz\";s:4:\"date\";s:10:\"1335997556\";s:6:\"mdhash\";s:32:\"af7abd95c03ecad4e1567ed94a438334\";s:8:\"filesize\";s:7:\"3128473\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.13\";a:14:{s:4:\"name\";s:11:\"drupal 7.13\";s:7:\"version\";s:4:\"7.13\";s:3:\"tag\";s:4:\"7.13\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.13\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.13.tar.gz\";s:4:\"date\";s:10:\"1335997261\";s:6:\"mdhash\";s:32:\"80587b66375c7fc539414a20a2c6f2de\";s:8:\"filesize\";s:7:\"3088448\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.12\";a:14:{s:4:\"name\";s:11:\"drupal 7.12\";s:7:\"version\";s:4:\"7.12\";s:3:\"tag\";s:4:\"7.12\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.12\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.12.tar.gz\";s:4:\"date\";s:10:\"1328134561\";s:6:\"mdhash\";s:32:\"db2284beb97241c9bdca9c638cd8a4f1\";s:8:\"filesize\";s:7:\"3088472\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.11\";a:14:{s:4:\"name\";s:11:\"drupal 7.11\";s:7:\"version\";s:4:\"7.11\";s:3:\"tag\";s:4:\"7.11\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.11\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.11.tar.gz\";s:4:\"date\";s:10:\"1328134275\";s:6:\"mdhash\";s:32:\"e9857e1749762367d7631d74cc6564a7\";s:8:\"filesize\";s:7:\"2789336\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:4:\"7.10\";a:14:{s:4:\"name\";s:11:\"drupal 7.10\";s:7:\"version\";s:4:\"7.10\";s:3:\"tag\";s:4:\"7.10\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:51:\"https://www.drupal.org/project/drupal/releases/7.10\";s:13:\"download_link\";s:56:\"https://ftp.drupal.org/files/projects/drupal-7.10.tar.gz\";s:4:\"date\";s:10:\"1323125439\";s:6:\"mdhash\";s:32:\"1caafb849bc756e62dd874b90b95ab31\";s:8:\"filesize\";s:7:\"3067653\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.9\";a:14:{s:4:\"name\";s:10:\"drupal 7.9\";s:7:\"version\";s:3:\"7.9\";s:3:\"tag\";s:3:\"7.9\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.9\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.9.tar.gz\";s:4:\"date\";s:10:\"1319660731\";s:6:\"mdhash\";s:32:\"7f45f109c413ca69ebb6e3140ed47225\";s:8:\"filesize\";s:7:\"2788086\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.8\";a:14:{s:4:\"name\";s:10:\"drupal 7.8\";s:7:\"version\";s:3:\"7.8\";s:3:\"tag\";s:3:\"7.8\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.8\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.8.tar.gz\";s:4:\"date\";s:10:\"1314817617\";s:6:\"mdhash\";s:32:\"e0226b56e8d5c57c6b126e8ed5866b1f\";s:8:\"filesize\";s:7:\"2766967\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.7\";a:14:{s:4:\"name\";s:10:\"drupal 7.7\";s:7:\"version\";s:3:\"7.7\";s:3:\"tag\";s:3:\"7.7\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.7\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.7.tar.gz\";s:4:\"date\";s:10:\"1311813880\";s:6:\"mdhash\";s:32:\"2eeb63fd1ef6b23b0a9f5f6b8aef8850\";s:8:\"filesize\";s:7:\"2754113\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.6\";a:14:{s:4:\"name\";s:10:\"drupal 7.6\";s:7:\"version\";s:3:\"7.6\";s:3:\"tag\";s:3:\"7.6\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.6\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.6.tar.gz\";s:4:\"date\";s:10:\"1311798716\";s:6:\"mdhash\";s:32:\"e88e63c4da9e5e170f089d050c88c827\";s:8:\"filesize\";s:7:\"2753784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.5\";a:14:{s:4:\"name\";s:10:\"drupal 7.5\";s:7:\"version\";s:3:\"7.5\";s:3:\"tag\";s:3:\"7.5\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.5\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.5.tar.gz\";s:4:\"date\";s:10:\"1311798416\";s:6:\"mdhash\";s:32:\"36d65b7a97c58226c64a6abdf481de45\";s:8:\"filesize\";s:7:\"2744690\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.4\";a:14:{s:4:\"name\";s:10:\"drupal 7.4\";s:7:\"version\";s:3:\"7.4\";s:3:\"tag\";s:3:\"7.4\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.4\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.4.tar.gz\";s:4:\"date\";s:10:\"1309397516\";s:6:\"mdhash\";s:32:\"84704de078e9f5432c9bb5c6ecd841d4\";s:8:\"filesize\";s:7:\"2744808\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.3\";a:14:{s:4:\"name\";s:10:\"drupal 7.3\";s:7:\"version\";s:3:\"7.3\";s:3:\"tag\";s:3:\"7.3\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.3\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.3.tar.gz\";s:4:\"date\";s:10:\"1309397216\";s:6:\"mdhash\";s:32:\"c290775724bc309647d84d03ddb88e2e\";s:8:\"filesize\";s:7:\"2735461\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.2\";a:14:{s:4:\"name\";s:10:\"drupal 7.2\";s:7:\"version\";s:3:\"7.2\";s:3:\"tag\";s:3:\"7.2\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.2\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.2.tar.gz\";s:4:\"date\";s:10:\"1306357017\";s:6:\"mdhash\";s:32:\"cf88c87e3694ebd15b62ba6f6a69124f\";s:8:\"filesize\";s:7:\"2731345\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.1\";a:14:{s:4:\"name\";s:10:\"drupal 7.1\";s:7:\"version\";s:3:\"7.1\";s:3:\"tag\";s:3:\"7.1\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.1\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.1.tar.gz\";s:4:\"date\";s:10:\"1306354916\";s:6:\"mdhash\";s:32:\"27eb45cb894a76f3a9ae6715584a10cc\";s:8:\"filesize\";s:7:\"2713977\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:3:\"7.0\";a:14:{s:4:\"name\";s:10:\"drupal 7.0\";s:7:\"version\";s:3:\"7.0\";s:3:\"tag\";s:3:\"7.0\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:50:\"https://www.drupal.org/project/drupal/releases/7.0\";s:13:\"download_link\";s:55:\"https://ftp.drupal.org/files/projects/drupal-7.0.tar.gz\";s:4:\"date\";s:10:\"1294208759\";s:6:\"mdhash\";s:32:\"e96c0a5e47c5d7706897384069dfb920\";s:8:\"filesize\";s:7:\"2728271\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.0-rc4\";a:15:{s:4:\"name\";s:14:\"drupal 7.0-rc4\";s:7:\"version\";s:7:\"7.0-rc4\";s:3:\"tag\";s:8:\"7.0-rc-4\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/7.0-rc4\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-7.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1293684084\";s:6:\"mdhash\";s:32:\"104c08e609c64bb1e45b55a7ad1ad857\";s:8:\"filesize\";s:7:\"2717666\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:7:\"7.0-rc3\";a:15:{s:4:\"name\";s:14:\"drupal 7.0-rc3\";s:7:\"version\";s:7:\"7.0-rc3\";s:3:\"tag\";s:8:\"7.0-rc-3\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/7.0-rc3\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-7.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1293099424\";s:6:\"mdhash\";s:32:\"be9a3f190e2648fa03dcb2bf3d8be199\";s:8:\"filesize\";s:7:\"2719115\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:7:\"7.0-rc2\";a:15:{s:4:\"name\";s:14:\"drupal 7.0-rc2\";s:7:\"version\";s:7:\"7.0-rc2\";s:3:\"tag\";s:8:\"7.0-rc-2\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/7.0-rc2\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-7.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1292101847\";s:6:\"mdhash\";s:32:\"f31982c73f1707ddccb2927325bc9cb9\";s:8:\"filesize\";s:7:\"2705734\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:7:\"7.0-rc1\";a:15:{s:4:\"name\";s:14:\"drupal 7.0-rc1\";s:7:\"version\";s:7:\"7.0-rc1\";s:3:\"tag\";s:8:\"7.0-rc-1\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/7.0-rc1\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-7.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1291190142\";s:6:\"mdhash\";s:32:\"b554e79cf60c02d4dec592151c4b58ee\";s:8:\"filesize\";s:7:\"2694689\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:12:\"New features\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"7.0-beta3\";a:15:{s:4:\"name\";s:16:\"drupal 7.0-beta3\";s:7:\"version\";s:9:\"7.0-beta3\";s:3:\"tag\";s:9:\"7.0-beta3\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/7.0-beta3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-7.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1289694735\";s:6:\"mdhash\";s:32:\"c942f010a2535586c4578cd7b107c652\";s:8:\"filesize\";s:7:\"2660883\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:12:\"New features\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:9:\"7.0-beta2\";a:15:{s:4:\"name\";s:16:\"drupal 7.0-beta2\";s:7:\"version\";s:9:\"7.0-beta2\";s:3:\"tag\";s:9:\"7.0-beta2\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/7.0-beta2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-7.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1287812133\";s:6:\"mdhash\";s:32:\"c2de0bdb657b77af8c8369a355cab8ce\";s:8:\"filesize\";s:7:\"2638949\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:9:\"7.0-beta1\";a:15:{s:4:\"name\";s:16:\"drupal 7.0-beta1\";s:7:\"version\";s:9:\"7.0-beta1\";s:3:\"tag\";s:9:\"7.0-beta1\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/7.0-beta1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-7.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1286422866\";s:6:\"mdhash\";s:32:\"490ce0d95eacc15f2918becd60f6821c\";s:8:\"filesize\";s:7:\"2622225\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha7\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha7\";s:7:\"version\";s:10:\"7.0-alpha7\";s:3:\"tag\";s:10:\"7.0-alpha7\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha7\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1284599764\";s:6:\"mdhash\";s:32:\"15183fcf862be97f7e96991e6e56fe2e\";s:8:\"filesize\";s:7:\"2586833\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha6\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha6\";s:7:\"version\";s:10:\"7.0-alpha6\";s:3:\"tag\";s:10:\"7.0-alpha6\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha6\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1278634809\";s:6:\"mdhash\";s:32:\"eb64647263affc36f76d1e7ffb751d32\";s:8:\"filesize\";s:7:\"2458211\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:12:\"New features\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha5\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha5\";s:7:\"version\";s:10:\"7.0-alpha5\";s:3:\"tag\";s:10:\"7.0-alpha5\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha5\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1274628613\";s:6:\"mdhash\";s:32:\"de9c1d51f0ce730f7356bd0a160e8ce1\";s:8:\"filesize\";s:7:\"2424226\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha4\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha4\";s:7:\"version\";s:10:\"7.0-alpha4\";s:3:\"tag\";s:10:\"7.0-alpha4\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha4\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1272318014\";s:6:\"mdhash\";s:32:\"c8f371a388bc65b2211d7d29856fb993\";s:8:\"filesize\";s:7:\"2403384\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha3\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha3\";s:7:\"version\";s:10:\"7.0-alpha3\";s:3:\"tag\";s:10:\"7.0-alpha3\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha3\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1269192317\";s:6:\"mdhash\";s:32:\"9efc083f09d6b523d655bc90a6869945\";s:8:\"filesize\";s:7:\"2357934\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:12:\"New features\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha2\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha2\";s:7:\"version\";s:10:\"7.0-alpha2\";s:3:\"tag\";s:10:\"7.0-alpha2\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1266777910\";s:6:\"mdhash\";s:32:\"cfbfdd2249638a266054f2532348065d\";s:8:\"filesize\";s:7:\"2314834\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"7.0-alpha1\";a:15:{s:4:\"name\";s:17:\"drupal 7.0-alpha1\";s:7:\"version\";s:10:\"7.0-alpha1\";s:3:\"tag\";s:10:\"7.0-alpha1\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/7.0-alpha1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-7.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1263566711\";s:6:\"mdhash\";s:32:\"508109c6cf0ead868e02d8c3db2a4d1f\";s:8:\"filesize\";s:7:\"2283220\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"7.x-dev\";a:14:{s:4:\"name\";s:14:\"drupal 7.x-dev\";s:7:\"version\";s:7:\"7.x-dev\";s:3:\"tag\";s:3:\"7.x\";s:13:\"version_major\";s:1:\"7\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/7.x-dev\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-7.x-dev.tar.gz\";s:4:\"date\";s:10:\"1499966043\";s:6:\"mdhash\";s:32:\"f769ca3a41b3e188f3d1b148388939bf\";s:8:\"filesize\";s:7:\"3278048\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541604,1500455183,1),('available_releases::entity','a:11:{s:5:\"title\";s:10:\"Entity API\";s:10:\"short_name\";s:6:\"entity\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:37:\"https://www.drupal.org/project/entity\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:30:{s:7:\"7.x-1.8\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.8\";s:7:\"version\";s:7:\"7.x-1.8\";s:3:\"tag\";s:7:\"7.x-1.8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.8\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1474545839\";s:6:\"mdhash\";s:32:\"3926d48c86387c3d1d5777538903a752\";s:8:\"filesize\";s:6:\"123957\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.7\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.7\";s:7:\"version\";s:7:\"7.x-1.7\";s:3:\"tag\";s:7:\"7.x-1.7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.7\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1458222242\";s:6:\"mdhash\";s:32:\"f4787da0230869cc7420b6cea78212e5\";s:8:\"filesize\";s:6:\"121426\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.6\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1424876581\";s:6:\"mdhash\";s:32:\"a778a5c82eaddac50e40a3dd0a3ebac6\";s:8:\"filesize\";s:6:\"120850\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.5\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1396975451\";s:6:\"mdhash\";s:32:\"04b90c27b2f1627d0a218006291afa9f\";s:8:\"filesize\";s:6:\"121011\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.4\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1395335056\";s:6:\"mdhash\";s:32:\"d026208f7b433b9b2dd5fdc705396d0e\";s:8:\"filesize\";s:6:\"120371\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.3\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1389210804\";s:6:\"mdhash\";s:32:\"92bb78da6928049c0d9bdea76629416b\";s:8:\"filesize\";s:6:\"119279\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.2\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1376493705\";s:6:\"mdhash\";s:32:\"c87e0ce3708a26a3045c36b8ad15f61c\";s:8:\"filesize\";s:6:\"115225\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.1\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1367338217\";s:6:\"mdhash\";s:32:\"1f23d1bee48287f1c53f8d3f1391187a\";s:8:\"filesize\";s:6:\"110514\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:14:\"entity 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/entity/releases/7.x-1.0\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1356471145\";s:6:\"mdhash\";s:32:\"f072eda34e284561bb55cfae0dbe30db\";s:8:\"filesize\";s:6:\"110082\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc3\";a:15:{s:4:\"name\";s:18:\"entity 7.x-1.0-rc3\";s:7:\"version\";s:11:\"7.x-1.0-rc3\";s:3:\"tag\";s:11:\"7.x-1.0-rc3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/entity/releases/7.x-1.0-rc3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1337981155\";s:6:\"mdhash\";s:32:\"267c552757d1fa8bbe17c624a7ec4c3f\";s:8:\"filesize\";s:6:\"106628\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:18:\"entity 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/entity/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1335099086\";s:6:\"mdhash\";s:32:\"587d7b6a088a195722fe7d11b1c9c8fa\";s:8:\"filesize\";s:6:\"105993\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:18:\"entity 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/entity/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1320914735\";s:6:\"mdhash\";s:32:\"daa6dff009d00756f86b80b31af32c77\";s:8:\"filesize\";s:5:\"95227\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-beta11\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-beta11\";s:7:\"version\";s:14:\"7.x-1.0-beta11\";s:3:\"tag\";s:14:\"7.x-1.0-beta11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"beta11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta11\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta11.tar.gz\";s:4:\"date\";s:10:\"1319558131\";s:6:\"mdhash\";s:32:\"0d98c2c361e5936593b8365614fa04e3\";s:8:\"filesize\";s:5:\"83206\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-beta10\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-beta10\";s:7:\"version\";s:14:\"7.x-1.0-beta10\";s:3:\"tag\";s:14:\"7.x-1.0-beta10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"beta10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta10\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta10.tar.gz\";s:4:\"date\";s:10:\"1310486817\";s:6:\"mdhash\";s:32:\"016f48d7ecee0da62ae1a8f6cf26a656\";s:8:\"filesize\";s:5:\"77197\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta9\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta9\";s:7:\"version\";s:13:\"7.x-1.0-beta9\";s:3:\"tag\";s:13:\"7.x-1.0-beta9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta9\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta9.tar.gz\";s:4:\"date\";s:10:\"1308239815\";s:6:\"mdhash\";s:32:\"a965dc47b0b8afc2f75b69be31e767d0\";s:8:\"filesize\";s:5:\"75840\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta8\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta8\";s:7:\"version\";s:13:\"7.x-1.0-beta8\";s:3:\"tag\";s:13:\"7.x-1.0-beta8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta8\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta8.tar.gz\";s:4:\"date\";s:10:\"1300731067\";s:6:\"mdhash\";s:32:\"317ec15a5f9d90e7613b52f20a7e9a82\";s:8:\"filesize\";s:5:\"71258\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta7\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta7\";s:7:\"version\";s:13:\"7.x-1.0-beta7\";s:3:\"tag\";s:13:\"7.x-1.0-beta7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta7\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta7.tar.gz\";s:4:\"date\";s:10:\"1298285230\";s:6:\"mdhash\";s:32:\"9598452892a90a3b098d3152334aeb85\";s:8:\"filesize\";s:5:\"72722\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta6\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta6\";s:7:\"version\";s:13:\"7.x-1.0-beta6\";s:3:\"tag\";s:13:\"7.x-1.0-beta6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta6\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1294170388\";s:6:\"mdhash\";s:32:\"64588b70e6773d146e0bf4267a90a270\";s:8:\"filesize\";s:5:\"68465\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta5\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta5\";s:7:\"version\";s:13:\"7.x-1.0-beta5\";s:3:\"tag\";s:13:\"7.x-1.0-beta5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta5\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1293135097\";s:6:\"mdhash\";s:32:\"53325d82ab40c0dc325ccb59d0bca3e6\";s:8:\"filesize\";s:5:\"65300\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1292941950\";s:6:\"mdhash\";s:32:\"93210f6c3b3b19258f217a64e6bd56a8\";s:8:\"filesize\";s:5:\"65305\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1291297866\";s:6:\"mdhash\";s:32:\"cb05413449da98da415d40e3520f0f6d\";s:8:\"filesize\";s:5:\"61957\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1290197444\";s:6:\"mdhash\";s:32:\"a1646f5c1933772feb76e2dd31d6324b\";s:8:\"filesize\";s:5:\"60670\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:20:\"entity 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/entity/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1286786762\";s:6:\"mdhash\";s:32:\"2e53243fdf0fae60217dd7916d982e47\";s:8:\"filesize\";s:5:\"54660\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha6\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-alpha6\";s:7:\"version\";s:14:\"7.x-1.0-alpha6\";s:3:\"tag\";s:14:\"7.x-1.0-alpha6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-alpha6\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1280228111\";s:6:\"mdhash\";s:32:\"5d88abea4508ea3561332f466746ab3d\";s:8:\"filesize\";s:5:\"47315\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha5\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-alpha5\";s:7:\"version\";s:14:\"7.x-1.0-alpha5\";s:3:\"tag\";s:14:\"7.x-1.0-alpha5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-alpha5\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1273607706\";s:6:\"mdhash\";s:32:\"13348a08070605b3742d4fad7856d76a\";s:8:\"filesize\";s:5:\"45331\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha4\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-alpha4\";s:7:\"version\";s:14:\"7.x-1.0-alpha4\";s:3:\"tag\";s:14:\"7.x-1.0-alpha4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-alpha4\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1268336409\";s:6:\"mdhash\";s:32:\"0e093c0ded92b23a4e628a7953a198dc\";s:8:\"filesize\";s:5:\"41614\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1266851413\";s:6:\"mdhash\";s:32:\"d347ca5528b9ed9d132b492cb4b7b2af\";s:8:\"filesize\";s:5:\"40746\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1263231309\";s:6:\"mdhash\";s:32:\"be9a91bd68b59480bdca9e8a6d6ad932\";s:8:\"filesize\";s:5:\"31954\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:21:\"entity 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/entity/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/entity-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1260807922\";s:6:\"mdhash\";s:32:\"858c5a1b255f5316737dbbd3b562d825\";s:8:\"filesize\";s:5:\"29154\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:18:\"entity 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/entity/releases/7.x-1.x-dev\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/entity-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1489006983\";s:6:\"mdhash\";s:32:\"896905b4ea1cfc180d6f03bc5ab44378\";s:8:\"filesize\";s:6:\"124235\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541609,1500455183,1),('available_releases::entityreference','a:11:{s:5:\"title\";s:16:\"Entity reference\";s:10:\"short_name\";s:15:\"entityreference\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:46:\"https://www.drupal.org/project/entityreference\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:18:{s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:23:\"entityreference 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/entityreference/releases/7.x-1.4\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1495557183\";s:6:\"mdhash\";s:32:\"ce8bde18b2b0269f218a1e2dc17579ee\";s:8:\"filesize\";s:5:\"43230\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:23:\"entityreference 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/entityreference/releases/7.x-1.3\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1494450485\";s:6:\"mdhash\";s:32:\"e800309d10d254bd8e80770beb17f4f3\";s:8:\"filesize\";s:5:\"43171\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:23:\"entityreference 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/entityreference/releases/7.x-1.2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1474306739\";s:6:\"mdhash\";s:32:\"ef8f161721709dedcd1babc18b033006\";s:8:\"filesize\";s:5:\"40840\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:23:\"entityreference 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/entityreference/releases/7.x-1.1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1384973004\";s:6:\"mdhash\";s:32:\"604843bda17acbd927f71f8cf8a74a48\";s:8:\"filesize\";s:5:\"40371\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:23:\"entityreference 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1353230808\";s:6:\"mdhash\";s:32:\"81f458c4b41b61f405af905d2fd8a5ec\";s:8:\"filesize\";s:5:\"36787\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc5\";a:15:{s:4:\"name\";s:27:\"entityreference 7.x-1.0-rc5\";s:7:\"version\";s:11:\"7.x-1.0-rc5\";s:3:\"tag\";s:11:\"7.x-1.0-rc5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-rc5\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-rc5.tar.gz\";s:4:\"date\";s:10:\"1348565045\";s:6:\"mdhash\";s:32:\"648a462e0bc442533debbd0b1b98e665\";s:8:\"filesize\";s:5:\"32328\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.0-rc4\";a:15:{s:4:\"name\";s:27:\"entityreference 7.x-1.0-rc4\";s:7:\"version\";s:11:\"7.x-1.0-rc4\";s:3:\"tag\";s:11:\"7.x-1.0-rc4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-rc4\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1348486666\";s:6:\"mdhash\";s:32:\"b1bdad67159df7cfa1edbc71ca1f15be\";s:8:\"filesize\";s:5:\"31223\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.0-rc3\";a:15:{s:4:\"name\";s:27:\"entityreference 7.x-1.0-rc3\";s:7:\"version\";s:11:\"7.x-1.0-rc3\";s:3:\"tag\";s:11:\"7.x-1.0-rc3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-rc3\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1338411956\";s:6:\"mdhash\";s:32:\"6f07ffafd42ec5fa9b76d398831c9956\";s:8:\"filesize\";s:5:\"30501\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:27:\"entityreference 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1338371757\";s:6:\"mdhash\";s:32:\"35336e7b27b1755db8464d786167081b\";s:8:\"filesize\";s:5:\"30494\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:27:\"entityreference 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1332279946\";s:6:\"mdhash\";s:32:\"83f006ab5235890efc2b3986f8dcdfe3\";s:8:\"filesize\";s:5:\"24495\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta5\";a:15:{s:4:\"name\";s:29:\"entityreference 7.x-1.0-beta5\";s:7:\"version\";s:13:\"7.x-1.0-beta5\";s:3:\"tag\";s:13:\"7.x-1.0-beta5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:69:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-beta5\";s:13:\"download_link\";s:74:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1330297849\";s:6:\"mdhash\";s:32:\"1508867497f54a68acb9f92ca4cddcfe\";s:8:\"filesize\";s:5:\"24228\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:29:\"entityreference 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:69:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:74:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1329149138\";s:6:\"mdhash\";s:32:\"7d5566cd6425d2dca4d0597984726eb8\";s:8:\"filesize\";s:5:\"24005\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:29:\"entityreference 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:69:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:74:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1324748139\";s:6:\"mdhash\";s:32:\"397fa7a810501fbb22390c8fb8ac10ef\";s:8:\"filesize\";s:5:\"19799\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:29:\"entityreference 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:69:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:74:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1322214940\";s:6:\"mdhash\";s:32:\"41b5dd4ed7115763e5b30c41a9a07c3d\";s:8:\"filesize\";s:5:\"19792\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:29:\"entityreference 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:69:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:74:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1316702804\";s:6:\"mdhash\";s:32:\"a056dc3e075e9b0783cb1addaad5086e\";s:8:\"filesize\";s:5:\"18948\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:30:\"entityreference 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:70:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:75:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1316171203\";s:6:\"mdhash\";s:32:\"0f5a3e9f3f998ed12d7c6bf1fd864274\";s:8:\"filesize\";s:5:\"17761\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:30:\"entityreference 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:70:\"https://www.drupal.org/project/entityreference/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:75:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1313085717\";s:6:\"mdhash\";s:32:\"d17373159f2c745be04bf3ea2df7632d\";s:8:\"filesize\";s:5:\"10847\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:27:\"entityreference 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/entityreference/releases/7.x-1.x-dev\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/entityreference-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1494943085\";s:6:\"mdhash\";s:32:\"3b31310e19437100905b2625d32a5c97\";s:8:\"filesize\";s:5:\"43242\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541609,1500455183,1),('available_releases::galleryformatter','a:11:{s:5:\"title\";s:17:\"Gallery formatter\";s:10:\"short_name\";s:16:\"galleryformatter\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:47:\"https://www.drupal.org/project/galleryformatter\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:6:{s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:24:\"galleryformatter 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/galleryformatter/releases/7.x-1.4\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/galleryformatter-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1442600639\";s:6:\"mdhash\";s:32:\"3754143cc4f2623b85fe4432514db18b\";s:8:\"filesize\";s:5:\"41653\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:24:\"galleryformatter 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/galleryformatter/releases/7.x-1.3\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/galleryformatter-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1355821655\";s:6:\"mdhash\";s:32:\"5cc4e33e7a3c1939303cf947d8e3a657\";s:8:\"filesize\";s:5:\"41800\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:24:\"galleryformatter 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/galleryformatter/releases/7.x-1.2\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/galleryformatter-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1343209964\";s:6:\"mdhash\";s:32:\"fb0f1682bd3498015d1b11029a07791f\";s:8:\"filesize\";s:5:\"41729\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:24:\"galleryformatter 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/galleryformatter/releases/7.x-1.1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/galleryformatter-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1342169810\";s:6:\"mdhash\";s:32:\"84a8c812ae5c86d97d6d7d7d08b4a4fb\";s:8:\"filesize\";s:5:\"41282\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:24:\"galleryformatter 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/galleryformatter/releases/7.x-1.0\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/galleryformatter-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1296418641\";s:6:\"mdhash\";s:32:\"67b0a3976281a4b5c1d9b3bd1baee6e9\";s:8:\"filesize\";s:5:\"39177\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:28:\"galleryformatter 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/galleryformatter/releases/7.x-1.x-dev\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/galleryformatter-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1477160340\";s:6:\"mdhash\";s:32:\"507d0b1f4de7f940b12a301925b7473d\";s:8:\"filesize\";s:5:\"41700\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541610,1500455183,1),('available_releases::hotel','a:11:{s:5:\"title\";s:5:\"Hotel\";s:10:\"short_name\";s:5:\"hotel\";s:4:\"type\";s:13:\"project_theme\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"https://www.drupal.org/project/hotel\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:2:{s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:13:\"hotel 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/hotel/releases/7.x-1.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/hotel-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1402666428\";s:6:\"mdhash\";s:32:\"4dc72f5871dc8673628c5fab562a9d49\";s:8:\"filesize\";s:6:\"277608\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:17:\"hotel 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/hotel/releases/7.x-1.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/hotel-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1402665828\";s:6:\"mdhash\";s:32:\"3c33e74617a980205514d6e068883f1f\";s:8:\"filesize\";s:6:\"277609\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500446435,1500360009,1),('available_releases::jcarousel','a:11:{s:5:\"title\";s:9:\"jCarousel\";s:10:\"short_name\";s:9:\"jcarousel\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:40:\"https://www.drupal.org/project/jcarousel\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:11:{s:7:\"7.x-2.7\";a:14:{s:4:\"name\";s:17:\"jcarousel 7.x-2.7\";s:7:\"version\";s:7:\"7.x-2.7\";s:3:\"tag\";s:7:\"7.x-2.7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.7\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1420460280\";s:6:\"mdhash\";s:32:\"da7722a86d12f286ce6b05e064b6a6e3\";s:8:\"filesize\";s:5:\"58289\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-2.7-rc1\";a:15:{s:4:\"name\";s:21:\"jcarousel 7.x-2.7-rc1\";s:7:\"version\";s:11:\"7.x-2.7-rc1\";s:3:\"tag\";s:11:\"7.x-2.7-rc1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.7-rc1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.7-rc1.tar.gz\";s:4:\"date\";s:10:\"1420458180\";s:6:\"mdhash\";s:32:\"cd41f12d87404de09a65778c96f60dc4\";s:8:\"filesize\";s:5:\"58292\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:7:\"7.x-2.6\";a:14:{s:4:\"name\";s:17:\"jcarousel 7.x-2.6\";s:7:\"version\";s:7:\"7.x-2.6\";s:3:\"tag\";s:7:\"7.x-2.6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.6\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1322116852\";s:6:\"mdhash\";s:32:\"0cd60b44c05b4d0e1001357f59ecc20c\";s:8:\"filesize\";s:5:\"59462\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:17:\"jcarousel 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.5\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1319935769\";s:6:\"mdhash\";s:32:\"390b331e84ee07078c15c947b5a49906\";s:8:\"filesize\";s:5:\"58051\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:14:\"7.x-2.4-alpha3\";a:15:{s:4:\"name\";s:24:\"jcarousel 7.x-2.4-alpha3\";s:7:\"version\";s:14:\"7.x-2.4-alpha3\";s:3:\"tag\";s:14:\"7.x-2.4-alpha3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.4-alpha3\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.4-alpha3.tar.gz\";s:4:\"date\";s:10:\"1302133615\";s:6:\"mdhash\";s:32:\"8a26f61e7c879bf969450cdadfb3bed4\";s:8:\"filesize\";s:5:\"55189\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.3-alpha2\";a:15:{s:4:\"name\";s:24:\"jcarousel 7.x-2.3-alpha2\";s:7:\"version\";s:14:\"7.x-2.3-alpha2\";s:3:\"tag\";s:14:\"7.x-2.3-alpha2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.3-alpha2\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.3-alpha2.tar.gz\";s:4:\"date\";s:10:\"1297036300\";s:6:\"mdhash\";s:32:\"0a46305bd164dcb3488b539381fcfd80\";s:8:\"filesize\";s:5:\"55269\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.2-alpha1\";a:15:{s:4:\"name\";s:24:\"jcarousel 7.x-2.2-alpha1\";s:7:\"version\";s:14:\"7.x-2.2-alpha1\";s:3:\"tag\";s:14:\"7.x-2.2-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.2-alpha1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.2-alpha1.tar.gz\";s:4:\"date\";s:10:\"1292868983\";s:6:\"mdhash\";s:32:\"e67324d105cce787f5a0cb620494bf2a\";s:8:\"filesize\";s:5:\"55026\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.1-alpha1\";a:15:{s:4:\"name\";s:24:\"jcarousel 7.x-2.1-alpha1\";s:7:\"version\";s:14:\"7.x-2.1-alpha1\";s:3:\"tag\";s:14:\"7.x-2.1-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.1-alpha1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.1-alpha1.tar.gz\";s:4:\"date\";s:10:\"1292184217\";s:6:\"mdhash\";s:32:\"154017caadc52cd00407c499c8dfcfc3\";s:8:\"filesize\";s:5:\"54766\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha1\";a:15:{s:4:\"name\";s:24:\"jcarousel 7.x-2.0-alpha1\";s:7:\"version\";s:14:\"7.x-2.0-alpha1\";s:3:\"tag\";s:14:\"7.x-2.0-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.0-alpha1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1290991275\";s:6:\"mdhash\";s:32:\"e70693d58a9d241bc98a4f602ea305da\";s:8:\"filesize\";s:5:\"54560\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"7.x-3.x-dev\";a:14:{s:4:\"name\";s:21:\"jcarousel 7.x-3.x-dev\";s:7:\"version\";s:11:\"7.x-3.x-dev\";s:3:\"tag\";s:7:\"7.x-3.x\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jcarousel/releases/7.x-3.x-dev\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1420043280\";s:6:\"mdhash\";s:32:\"f08221738d43aedaa6e5eda20b56821c\";s:8:\"filesize\";s:5:\"43746\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:21:\"jcarousel 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jcarousel/releases/7.x-2.x-dev\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jcarousel-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1420464180\";s:6:\"mdhash\";s:32:\"90787216acc1a3738c47ef8d0b568380\";s:8:\"filesize\";s:5:\"58318\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541610,1500455183,1),('available_releases::jquery_plugin','a:11:{s:5:\"title\";s:14:\"jQuery plugins\";s:10:\"short_name\";s:13:\"jquery_plugin\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"https://www.drupal.org/project/jquery_plugin\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:2:{s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:21:\"jquery_plugin 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_plugin/releases/7.x-1.0\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_plugin-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1294280183\";s:6:\"mdhash\";s:32:\"4d1440d76a0373b4664638fd71594bb9\";s:8:\"filesize\";s:5:\"39980\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:25:\"jquery_plugin 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/jquery_plugin/releases/7.x-1.x-dev\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/jquery_plugin-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380584029\";s:6:\"mdhash\";s:32:\"5168e231cfcba2fe4afda89f17a3e136\";s:8:\"filesize\";s:5:\"41740\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541611,1500455183,1),('available_releases::jquery_update','a:11:{s:5:\"title\";s:13:\"jQuery Update\";s:10:\"short_name\";s:13:\"jquery_update\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"2,3\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"https://www.drupal.org/project/jquery_update\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:18:{s:14:\"7.x-3.0-alpha5\";a:15:{s:4:\"name\";s:28:\"jquery_update 7.x-3.0-alpha5\";s:7:\"version\";s:14:\"7.x-3.0-alpha5\";s:3:\"tag\";s:14:\"7.x-3.0-alpha5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/jquery_update/releases/7.x-3.0-alpha5\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-3.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1490805183\";s:6:\"mdhash\";s:32:\"48baebd87003519ade8c65dc5598bbe5\";s:8:\"filesize\";s:7:\"1980268\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-3.0-alpha4\";a:15:{s:4:\"name\";s:28:\"jquery_update 7.x-3.0-alpha4\";s:7:\"version\";s:14:\"7.x-3.0-alpha4\";s:3:\"tag\";s:14:\"7.x-3.0-alpha4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/jquery_update/releases/7.x-3.0-alpha4\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-3.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1489024086\";s:6:\"mdhash\";s:32:\"b9cadf50cf17638df514aad3c188c776\";s:8:\"filesize\";s:7:\"1978968\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-3.0-alpha3\";a:15:{s:4:\"name\";s:28:\"jquery_update 7.x-3.0-alpha3\";s:7:\"version\";s:14:\"7.x-3.0-alpha3\";s:3:\"tag\";s:14:\"7.x-3.0-alpha3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/jquery_update/releases/7.x-3.0-alpha3\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-3.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1445382239\";s:6:\"mdhash\";s:32:\"599739c36c8095b1a268d82a8d5820ac\";s:8:\"filesize\";s:7:\"1463630\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-3.0-alpha2\";a:15:{s:4:\"name\";s:28:\"jquery_update 7.x-3.0-alpha2\";s:7:\"version\";s:14:\"7.x-3.0-alpha2\";s:3:\"tag\";s:14:\"7.x-3.0-alpha2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/jquery_update/releases/7.x-3.0-alpha2\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-3.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1432926481\";s:6:\"mdhash\";s:32:\"99d161a138a599ee9ebd30434479e1ca\";s:8:\"filesize\";s:7:\"1542292\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-3.0-alpha1\";a:15:{s:4:\"name\";s:28:\"jquery_update 7.x-3.0-alpha1\";s:7:\"version\";s:14:\"7.x-3.0-alpha1\";s:3:\"tag\";s:14:\"7.x-3.0-alpha1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/jquery_update/releases/7.x-3.0-alpha1\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1431975181\";s:6:\"mdhash\";s:32:\"500a98ed3bec0c943994c43913422332\";s:8:\"filesize\";s:7:\"1541898\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"7.x-2.7\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.7\";s:7:\"version\";s:7:\"7.x-2.7\";s:3:\"tag\";s:7:\"7.x-2.7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.7\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1445379839\";s:6:\"mdhash\";s:32:\"85eaf02362c384979bc475df30ae7a3e\";s:8:\"filesize\";s:7:\"1135987\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.6\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.6\";s:7:\"version\";s:7:\"7.x-2.6\";s:3:\"tag\";s:7:\"7.x-2.6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.6\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1434549780\";s:6:\"mdhash\";s:32:\"88b81a8defbfdf9a4674f876685543f1\";s:8:\"filesize\";s:7:\"1203578\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.5\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1422221880\";s:6:\"mdhash\";s:32:\"47f430531b0a2a821c791325b2d89388\";s:8:\"filesize\";s:7:\"1201320\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.4\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1396482245\";s:6:\"mdhash\";s:32:\"9cc4f8b964202f1d6f005a43a08060c6\";s:8:\"filesize\";s:7:\"1199709\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.3\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1360375905\";s:6:\"mdhash\";s:32:\"2d5a1e594a027fa849ed250f5dfef7c5\";s:8:\"filesize\";s:6:\"709788\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:14:\"7.x-2.3-alpha1\";a:15:{s:4:\"name\";s:28:\"jquery_update 7.x-2.3-alpha1\";s:7:\"version\";s:14:\"7.x-2.3-alpha1\";s:3:\"tag\";s:14:\"7.x-2.3-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.3-alpha1\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.3-alpha1.tar.gz\";s:4:\"date\";s:10:\"1348790474\";s:6:\"mdhash\";s:32:\"2fe04a30f74e47c0b1a4ce24023a39fa\";s:8:\"filesize\";s:6:\"709779\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.2\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1301920269\";s:6:\"mdhash\";s:32:\"944e097382c08d9a3ba5028ac700162b\";s:8:\"filesize\";s:6:\"482023\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1300647067\";s:6:\"mdhash\";s:32:\"6b6f9064e23aaede7ce9f04ded255a57\";s:8:\"filesize\";s:6:\"479984\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.0\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1297454705\";s:6:\"mdhash\";s:32:\"de6d8095e0bdd4e231922974df3f8fc7\";s:8:\"filesize\";s:6:\"476204\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:21:\"jquery_update 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/jquery_update/releases/7.x-1.0\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1297453316\";s:6:\"mdhash\";s:32:\"4fa3749b8e477b76341d72a5516344d8\";s:8:\"filesize\";s:6:\"476208\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:11:\"7.x-3.x-dev\";a:14:{s:4:\"name\";s:25:\"jquery_update 7.x-3.x-dev\";s:7:\"version\";s:11:\"7.x-3.x-dev\";s:3:\"tag\";s:7:\"7.x-3.x\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/jquery_update/releases/7.x-3.x-dev\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1490804883\";s:6:\"mdhash\";s:32:\"5786d8734547bdd37d012b365aaa44d9\";s:8:\"filesize\";s:7:\"1980264\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:25:\"jquery_update 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/jquery_update/releases/7.x-2.x-dev\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1445379839\";s:6:\"mdhash\";s:32:\"b4c28c594a6ecf50ccb9cd9689e778c9\";s:8:\"filesize\";s:7:\"1135988\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:25:\"jquery_update 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/jquery_update/releases/7.x-1.x-dev\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/jquery_update-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380584081\";s:6:\"mdhash\";s:32:\"9d1b43a6e55ea389f03cd338ab9c5f35\";s:8:\"filesize\";s:6:\"472169\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541611,1500455183,1),('available_releases::libraries','a:11:{s:5:\"title\";s:13:\"Libraries API\";s:10:\"short_name\";s:9:\"libraries\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:5:\"1,2,3\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:40:\"https://www.drupal.org/project/libraries\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:10:{s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:17:\"libraries 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/libraries/releases/7.x-2.3\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1463077439\";s:6:\"mdhash\";s:32:\"294d3e4096c513321159b908cfd7c2be\";s:8:\"filesize\";s:5:\"41863\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:17:\"libraries 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/libraries/releases/7.x-2.2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1391965705\";s:6:\"mdhash\";s:32:\"629663be1ddbbc79531ab98d7d3761dc\";s:8:\"filesize\";s:5:\"33326\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:17:\"libraries 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/libraries/releases/7.x-2.1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1362848412\";s:6:\"mdhash\";s:32:\"e240bf43e3a4dd2d595bf24ac34d46bd\";s:8:\"filesize\";s:5:\"30501\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:17:\"libraries 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/libraries/releases/7.x-2.0\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1343561873\";s:6:\"mdhash\";s:32:\"bb4707fe9c9c67401c9baa514fbab948\";s:8:\"filesize\";s:5:\"30229\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:14:\"7.x-2.0-alpha2\";a:15:{s:4:\"name\";s:24:\"libraries 7.x-2.0-alpha2\";s:7:\"version\";s:14:\"7.x-2.0-alpha2\";s:3:\"tag\";s:14:\"7.x-2.0-alpha2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/libraries/releases/7.x-2.0-alpha2\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1323950504\";s:6:\"mdhash\";s:32:\"150a5e24e7f1e849e054ba06921a0311\";s:8:\"filesize\";s:5:\"29501\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha1\";a:15:{s:4:\"name\";s:24:\"libraries 7.x-2.0-alpha1\";s:7:\"version\";s:14:\"7.x-2.0-alpha1\";s:3:\"tag\";s:14:\"7.x-2.0-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/libraries/releases/7.x-2.0-alpha1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1317479207\";s:6:\"mdhash\";s:32:\"8e3529be946d9ad0a4b387756cb91a5d\";s:8:\"filesize\";s:5:\"28459\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:17:\"libraries 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/libraries/releases/7.x-1.0\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/libraries-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1296096156\";s:6:\"mdhash\";s:32:\"e395a4229adb94f48de0764654e83967\";s:8:\"filesize\";s:4:\"7921\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:11:\"7.x-3.x-dev\";a:14:{s:4:\"name\";s:21:\"libraries 7.x-3.x-dev\";s:7:\"version\";s:11:\"7.x-3.x-dev\";s:3:\"tag\";s:7:\"7.x-3.x\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/libraries/releases/7.x-3.x-dev\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/libraries-7.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1413167628\";s:6:\"mdhash\";s:32:\"7263f590a91de04704820f2b218956f9\";s:8:\"filesize\";s:5:\"33184\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:21:\"libraries 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/libraries/releases/7.x-2.x-dev\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/libraries-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1479046140\";s:6:\"mdhash\";s:32:\"3664fa9b54800164c107a0fbc2e52865\";s:8:\"filesize\";s:5:\"44459\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:21:\"libraries 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/libraries/releases/7.x-1.x-dev\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/libraries-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1406512127\";s:6:\"mdhash\";s:32:\"84247d751f028c55371865aef18fbd11\";s:8:\"filesize\";s:4:\"9041\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541612,1500455183,1),('available_releases::locationmap','a:11:{s:5:\"title\";s:12:\"Location Map\";s:10:\"short_name\";s:11:\"locationmap\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:42:\"https://www.drupal.org/project/locationmap\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:14:{s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-2.5\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1488545283\";s:6:\"mdhash\";s:32:\"03e56d42e77dba380595690d40896101\";s:8:\"filesize\";s:5:\"16224\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-2.4\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1488278284\";s:6:\"mdhash\";s:32:\"da11f22e3e8504d184e42972497733af\";s:8:\"filesize\";s:5:\"16223\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-2.3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1400942327\";s:6:\"mdhash\";s:32:\"55cc57901f6ea132cd9a0adfcf0e8a72\";s:8:\"filesize\";s:5:\"15612\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-2.2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1358172127\";s:6:\"mdhash\";s:32:\"1badcbe424ebd54edc6fce5c09aaf64e\";s:8:\"filesize\";s:5:\"15256\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-2.1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1332365750\";s:6:\"mdhash\";s:32:\"7ec39a6f154bc6520f406a81b587a32c\";s:8:\"filesize\";s:5:\"14363\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-2.0\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1332019243\";s:6:\"mdhash\";s:32:\"375e6b89ac7419c319009f2ec4b28200\";s:8:\"filesize\";s:5:\"14353\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-1.3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1332365748\";s:6:\"mdhash\";s:32:\"49c172b7ad9755bc9f57edad31f3ce6d\";s:8:\"filesize\";s:5:\"14368\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-1.2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1332020443\";s:6:\"mdhash\";s:32:\"4d3b4e81125d6094c14f100d68c72652\";s:8:\"filesize\";s:5:\"14357\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-1.1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1318621600\";s:6:\"mdhash\";s:32:\"6fc3d7cbd52d3991c82dc2158122eb3c\";s:8:\"filesize\";s:5:\"14352\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:19:\"locationmap 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/locationmap/releases/7.x-1.0\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1294226468\";s:6:\"mdhash\";s:32:\"ed13337c0933852673f9d8c1226d4b04\";s:8:\"filesize\";s:5:\"12990\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:25:\"locationmap 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/locationmap/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1292098553\";s:6:\"mdhash\";s:32:\"a83a3ce4c655b415ccfddb1bb0d70503\";s:8:\"filesize\";s:5:\"12987\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:25:\"locationmap 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/locationmap/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1292095934\";s:6:\"mdhash\";s:32:\"26e9efdae76ca7a34430d6ce40c76d3e\";s:8:\"filesize\";s:5:\"12968\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:23:\"locationmap 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/locationmap/releases/7.x-2.x-dev\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/locationmap-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1488534483\";s:6:\"mdhash\";s:32:\"16b73865d1b9a51434676f3d9356b838\";s:8:\"filesize\";s:5:\"16222\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:23:\"locationmap 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/locationmap/releases/7.x-1.x-dev\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/locationmap-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380585262\";s:6:\"mdhash\";s:32:\"1a604dbfe03105426c75f558974e1c9f\";s:8:\"filesize\";s:5:\"14385\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541612,1500455183,1),('available_releases::module_filter','a:11:{s:5:\"title\";s:13:\"Module Filter\";s:10:\"short_name\";s:13:\"module_filter\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:44:\"https://www.drupal.org/project/module_filter\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:15:{s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-2.1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1497029343\";s:6:\"mdhash\";s:32:\"66a4998f63f2cefe77c18713054a42cc\";s:8:\"filesize\";s:5:\"29757\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-2.0\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1424631181\";s:6:\"mdhash\";s:32:\"3e2ebdd2f2ec028252e1cf2a547d7d7e\";s:8:\"filesize\";s:5:\"29130\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:14:\"7.x-2.0-alpha2\";a:15:{s:4:\"name\";s:28:\"module_filter 7.x-2.0-alpha2\";s:7:\"version\";s:14:\"7.x-2.0-alpha2\";s:3:\"tag\";s:14:\"7.x-2.0-alpha2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/module_filter/releases/7.x-2.0-alpha2\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/module_filter-7.x-2.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1386356904\";s:6:\"mdhash\";s:32:\"342e0e3963e64c39f86061a10bbdaf2e\";s:8:\"filesize\";s:5:\"27898\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha1\";a:15:{s:4:\"name\";s:28:\"module_filter 7.x-2.0-alpha1\";s:7:\"version\";s:14:\"7.x-2.0-alpha1\";s:3:\"tag\";s:14:\"7.x-2.0-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:68:\"https://www.drupal.org/project/module_filter/releases/7.x-2.0-alpha1\";s:13:\"download_link\";s:73:\"https://ftp.drupal.org/files/projects/module_filter-7.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1384832005\";s:6:\"mdhash\";s:32:\"3bfb306828c12830c0ee3678f675f124\";s:8:\"filesize\";s:5:\"27962\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.8\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.8\";s:7:\"version\";s:7:\"7.x-1.8\";s:3:\"tag\";s:7:\"7.x-1.8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.8\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1375995221\";s:6:\"mdhash\";s:32:\"53a1b995dee29e1ab202fa1547dc1266\";s:8:\"filesize\";s:5:\"14605\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.7\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.7\";s:7:\"version\";s:7:\"7.x-1.7\";s:3:\"tag\";s:7:\"7.x-1.7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.7\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1341518501\";s:6:\"mdhash\";s:32:\"f10e62aa5346d5cd82854d66c359f199\";s:8:\"filesize\";s:5:\"14646\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.6\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1316105205\";s:6:\"mdhash\";s:32:\"77ca515021372066e2b19906adddb94e\";s:8:\"filesize\";s:5:\"13177\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.5\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1313598120\";s:6:\"mdhash\";s:32:\"f3a6a44ec3e35e91870f8391a9f04ff5\";s:8:\"filesize\";s:5:\"13039\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.4\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1299525068\";s:6:\"mdhash\";s:32:\"90d9ec10df0b9ee07707f87b96711bca\";s:8:\"filesize\";s:5:\"11570\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.3\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1299519370\";s:6:\"mdhash\";s:32:\"8a075e4932db8cd4e35371ac276bcb4b\";s:8:\"filesize\";s:5:\"11555\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.2\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1299516669\";s:6:\"mdhash\";s:32:\"afbb784aeb4029294e5877654385cc8c\";s:8:\"filesize\";s:5:\"11446\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1299515169\";s:6:\"mdhash\";s:32:\"45546c1f5bc473389ffc36f0e38a2bc1\";s:8:\"filesize\";s:5:\"13033\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:21:\"module_filter 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/module_filter/releases/7.x-1.0\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1294104365\";s:6:\"mdhash\";s:32:\"a482aef54751a8fd947bafc2d5ef1ecd\";s:8:\"filesize\";s:5:\"11523\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:25:\"module_filter 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/module_filter/releases/7.x-2.x-dev\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/module_filter-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1497029343\";s:6:\"mdhash\";s:32:\"bf63bf30b9a6eecb11e527cc12a87312\";s:8:\"filesize\";s:5:\"29762\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:25:\"module_filter 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/module_filter/releases/7.x-1.x-dev\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/module_filter-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1406917428\";s:6:\"mdhash\";s:32:\"62b7a0ab716b2798d9e60462314d95c5\";s:8:\"filesize\";s:5:\"14743\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541613,1500455183,1),('available_releases::nucleus','a:11:{s:5:\"title\";s:10:\"TB Nucleus\";s:10:\"short_name\";s:7:\"nucleus\";s:4:\"type\";s:13:\"project_theme\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:38:\"https://www.drupal.org/project/nucleus\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:13:{s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:15:\"nucleus 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/nucleus/releases/7.x-1.5\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1403079828\";s:6:\"mdhash\";s:32:\"9bc335fc1e88712aeccc0b4842e1216f\";s:8:\"filesize\";s:5:\"88338\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:15:\"nucleus 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/nucleus/releases/7.x-1.4\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1375072569\";s:6:\"mdhash\";s:32:\"d9c079396acbd013817a6b4d58ded907\";s:8:\"filesize\";s:5:\"84585\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:15:\"nucleus 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/nucleus/releases/7.x-1.3\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1364376317\";s:6:\"mdhash\";s:32:\"14b3a7b9e07418f2a171596e756efab0\";s:8:\"filesize\";s:5:\"84524\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:15:\"nucleus 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/nucleus/releases/7.x-1.2\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1353011329\";s:6:\"mdhash\";s:32:\"7798e12a3a514094915abaa3b32a950f\";s:8:\"filesize\";s:5:\"86474\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:15:\"nucleus 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/nucleus/releases/7.x-1.1\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1347590572\";s:6:\"mdhash\";s:32:\"8b8535895052b20b6d9a9dfa96d20f91\";s:8:\"filesize\";s:5:\"88755\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.1-beta4\";a:15:{s:4:\"name\";s:21:\"nucleus 7.x-1.1-beta4\";s:7:\"version\";s:13:\"7.x-1.1-beta4\";s:3:\"tag\";s:13:\"7.x-1.1-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/nucleus/releases/7.x-1.1-beta4\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.1-beta4.tar.gz\";s:4:\"date\";s:10:\"1344915737\";s:6:\"mdhash\";s:32:\"94fd1bf476ead438c1b8e421ed371074\";s:8:\"filesize\";s:5:\"89119\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.1-beta3\";a:15:{s:4:\"name\";s:21:\"nucleus 7.x-1.1-beta3\";s:7:\"version\";s:13:\"7.x-1.1-beta3\";s:3:\"tag\";s:13:\"7.x-1.1-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/nucleus/releases/7.x-1.1-beta3\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.1-beta3.tar.gz\";s:4:\"date\";s:10:\"1340361999\";s:6:\"mdhash\";s:32:\"0bc29b03f5b4b96710db98d9b9ecc885\";s:8:\"filesize\";s:5:\"87224\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.1-beta2\";a:15:{s:4:\"name\";s:21:\"nucleus 7.x-1.1-beta2\";s:7:\"version\";s:13:\"7.x-1.1-beta2\";s:3:\"tag\";s:13:\"7.x-1.1-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/nucleus/releases/7.x-1.1-beta2\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.1-beta2.tar.gz\";s:4:\"date\";s:10:\"1336100164\";s:6:\"mdhash\";s:32:\"92f6a811226200c2f727bdbf5a94bd09\";s:8:\"filesize\";s:5:\"86958\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.1-beta1\";a:15:{s:4:\"name\";s:21:\"nucleus 7.x-1.1-beta1\";s:7:\"version\";s:13:\"7.x-1.1-beta1\";s:3:\"tag\";s:13:\"7.x-1.1-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/nucleus/releases/7.x-1.1-beta1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.1-beta1.tar.gz\";s:4:\"date\";s:10:\"1336015262\";s:6:\"mdhash\";s:32:\"abd634dc59818bf0761f0c210a39c825\";s:8:\"filesize\";s:5:\"86956\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:21:\"nucleus 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/nucleus/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1344914886\";s:6:\"mdhash\";s:32:\"74d5753dc44158d8917cc00044e1f0c9\";s:8:\"filesize\";s:5:\"89123\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:22:\"nucleus 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/nucleus/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1331527242\";s:6:\"mdhash\";s:32:\"bf847adc68832f382f007e58f1ff06aa\";s:8:\"filesize\";s:5:\"83290\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:22:\"nucleus 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/nucleus/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1330413656\";s:6:\"mdhash\";s:32:\"3b0314cb095fbd9c37a28f51a2a58c9e\";s:8:\"filesize\";s:5:\"83300\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:19:\"nucleus 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/nucleus/releases/7.x-1.x-dev\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/nucleus-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380594941\";s:6:\"mdhash\";s:32:\"72b6f05f149bf083f99045165616c0a7\";s:8:\"filesize\";s:5:\"84616\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541602,1500455183,1),('available_releases::pathauto','a:11:{s:5:\"title\";s:8:\"Pathauto\";s:10:\"short_name\";s:8:\"pathauto\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"https://www.drupal.org/project/pathauto\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:10:{s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:16:\"pathauto 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/pathauto/releases/7.x-1.3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1444232639\";s:6:\"mdhash\";s:32:\"ff984b2837230a221d53fad5462c0b61\";s:8:\"filesize\";s:5:\"42319\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:16:\"pathauto 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/pathauto/releases/7.x-1.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1344525185\";s:6:\"mdhash\";s:32:\"abdb73c49803aefe3c87774a92c42b87\";s:8:\"filesize\";s:5:\"38900\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:16:\"pathauto 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/pathauto/releases/7.x-1.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1336950382\";s:6:\"mdhash\";s:32:\"ee42c248db62f384871cb526d72005f2\";s:8:\"filesize\";s:5:\"38652\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:16:\"pathauto 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/pathauto/releases/7.x-1.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1320072936\";s:6:\"mdhash\";s:32:\"6edd617da0cfa31ddde247933d670ef4\";s:8:\"filesize\";s:5:\"37196\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:20:\"pathauto 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/pathauto/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1308241021\";s:6:\"mdhash\";s:32:\"376c28fa39f3b383ad5134c5a1360be7\";s:8:\"filesize\";s:5:\"35681\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:20:\"pathauto 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/pathauto/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1308121619\";s:6:\"mdhash\";s:32:\"a53a56cffaaa67c8775c085d542f162c\";s:8:\"filesize\";s:5:\"35350\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:22:\"pathauto 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/pathauto/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1294891602\";s:6:\"mdhash\";s:32:\"37c8eaa37d69d60303e702c271f99f9e\";s:8:\"filesize\";s:5:\"56885\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:23:\"pathauto 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/pathauto/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1281556294\";s:6:\"mdhash\";s:32:\"5f4aecc1b5d6a6e4365fafcc7f0efe15\";s:8:\"filesize\";s:6:\"122301\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:12:\"New features\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:23:\"pathauto 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/pathauto/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1267300506\";s:6:\"mdhash\";s:32:\"ec86f7a12f9b4daa02967a3d7ccedef6\";s:8:\"filesize\";s:6:\"121249\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:20:\"pathauto 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/pathauto/releases/7.x-1.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/pathauto-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1472576639\";s:6:\"mdhash\";s:32:\"a597c609ed9d356b6ad4faa978b12aa7\";s:8:\"filesize\";s:5:\"42278\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541596,1500455183,1),('available_releases::rooms','a:11:{s:5:\"title\";s:64:\"Rooms - Drupal Booking for Hotels, B&amp;Bs and Vacation Rentals\";s:10:\"short_name\";s:5:\"rooms\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"https://www.drupal.org/project/rooms\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:24:{s:8:\"7.x-1.11\";a:14:{s:4:\"name\";s:14:\"rooms 7.x-1.11\";s:7:\"version\";s:8:\"7.x-1.11\";s:3:\"tag\";s:8:\"7.x-1.11\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/rooms/releases/7.x-1.11\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1456415528\";s:6:\"mdhash\";s:32:\"f20e68590f877f5539dee9f69c4ca445\";s:8:\"filesize\";s:6:\"269950\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-1.10\";a:14:{s:4:\"name\";s:14:\"rooms 7.x-1.10\";s:7:\"version\";s:8:\"7.x-1.10\";s:3:\"tag\";s:8:\"7.x-1.10\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/rooms/releases/7.x-1.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1454999339\";s:6:\"mdhash\";s:32:\"1e8e9c6d1243bbdc49cbb6c8fbf1d26b\";s:8:\"filesize\";s:6:\"267631\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.9\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.9\";s:7:\"version\";s:7:\"7.x-1.9\";s:3:\"tag\";s:7:\"7.x-1.9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1454954939\";s:6:\"mdhash\";s:32:\"28fe9bb576a26197515c9195fafa6d7b\";s:8:\"filesize\";s:6:\"267613\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.8\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.8\";s:7:\"version\";s:7:\"7.x-1.8\";s:3:\"tag\";s:7:\"7.x-1.8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1452937139\";s:6:\"mdhash\";s:32:\"a39d856b46ed4ce39f988d303a8f8dbb\";s:8:\"filesize\";s:6:\"268776\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.7\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.7\";s:7:\"version\";s:7:\"7.x-1.7\";s:3:\"tag\";s:7:\"7.x-1.7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1427482981\";s:6:\"mdhash\";s:32:\"7dccfe76f61de03d83dc43853904aa26\";s:8:\"filesize\";s:6:\"247946\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1427476381\";s:6:\"mdhash\";s:32:\"7b51d10d4de7f1e141964de0c5433728\";s:8:\"filesize\";s:6:\"247893\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1427392081\";s:6:\"mdhash\";s:32:\"a376b3ad0822bebfe22039d041c8a3f5\";s:8:\"filesize\";s:6:\"247855\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1422616808\";s:6:\"mdhash\";s:32:\"e04e59f85fd66833588bb21734b1d7c0\";s:8:\"filesize\";s:6:\"240873\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-1.4-beta1\";a:15:{s:4:\"name\";s:19:\"rooms 7.x-1.4-beta1\";s:7:\"version\";s:13:\"7.x-1.4-beta1\";s:3:\"tag\";s:13:\"7.x-1.4-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rooms/releases/7.x-1.4-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.4-beta1.tar.gz\";s:4:\"date\";s:10:\"1421169180\";s:6:\"mdhash\";s:32:\"8569d93cf06ddde2553c9e589d0b4eb3\";s:8:\"filesize\";s:6:\"240407\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1403200428\";s:6:\"mdhash\";s:32:\"f39126504b931c54d3478003d9b7586b\";s:8:\"filesize\";s:6:\"156054\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1399027127\";s:6:\"mdhash\";s:32:\"d19e51917f81f655fcad5d73fb377adf\";s:8:\"filesize\";s:6:\"132173\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1397748863\";s:6:\"mdhash\";s:32:\"84d23344fd0144ebeda1bcdd5cfac186\";s:8:\"filesize\";s:6:\"132147\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:13:\"rooms 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rooms/releases/7.x-1.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1368114620\";s:6:\"mdhash\";s:32:\"ec9d9fb52d1b5ef2150e6924cfb620c5\";s:8:\"filesize\";s:6:\"124674\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.0-rc3\";a:15:{s:4:\"name\";s:17:\"rooms 7.x-1.0-rc3\";s:7:\"version\";s:11:\"7.x-1.0-rc3\";s:3:\"tag\";s:11:\"7.x-1.0-rc3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-rc3\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1366136512\";s:6:\"mdhash\";s:32:\"2282cda765038f1e4dfdfef75cee904f\";s:8:\"filesize\";s:6:\"123980\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:17:\"rooms 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1361812601\";s:6:\"mdhash\";s:32:\"d80320d0a0d0dbc325193cbef2d4e5db\";s:8:\"filesize\";s:6:\"110373\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:17:\"rooms 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1357929525\";s:6:\"mdhash\";s:32:\"22fae3e8867edfe2f86401c3132b45b4\";s:8:\"filesize\";s:6:\"102451\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:19:\"rooms 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1338892950\";s:6:\"mdhash\";s:32:\"9bcbb379a3d6b5ee39921fb090881e21\";s:8:\"filesize\";s:5:\"94617\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:19:\"rooms 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1338767234\";s:6:\"mdhash\";s:32:\"defe6ab4a151c7dfbf798c9ab3570c96\";s:8:\"filesize\";s:5:\"94463\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:19:\"rooms 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1338745330\";s:6:\"mdhash\";s:32:\"8a51c0507e40ec062986bf9ef316647e\";s:8:\"filesize\";s:5:\"94327\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha4\";a:15:{s:4:\"name\";s:20:\"rooms 7.x-1.0-alpha4\";s:7:\"version\";s:14:\"7.x-1.0-alpha4\";s:3:\"tag\";s:14:\"7.x-1.0-alpha4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-alpha4\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1328428852\";s:6:\"mdhash\";s:32:\"d1560365e7c646d3a86713aeebcc92e0\";s:8:\"filesize\";s:5:\"73717\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:20:\"rooms 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1328345745\";s:6:\"mdhash\";s:32:\"2c61d9693f4e22bf6468166aea872d0b\";s:8:\"filesize\";s:5:\"73698\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:20:\"rooms 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1324451455\";s:6:\"mdhash\";s:32:\"c9a011ecd5044c1927eae7f5bbdde5d0\";s:8:\"filesize\";s:5:\"73034\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:20:\"rooms 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rooms/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1322390143\";s:6:\"mdhash\";s:32:\"268c0ca407d7dde56a80ff7eebcbcb18\";s:8:\"filesize\";s:5:\"72985\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:17:\"rooms 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rooms/releases/7.x-1.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rooms-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1466008147\";s:6:\"mdhash\";s:32:\"5d82566050ddc6499e1c0c65b8bedcd5\";s:8:\"filesize\";s:6:\"270219\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541597,1500455183,1),('available_releases::rules','a:11:{s:5:\"title\";s:5:\"Rules\";s:10:\"short_name\";s:5:\"rules\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"https://www.drupal.org/project/rules\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:24:{s:8:\"7.x-2.10\";a:14:{s:4:\"name\";s:14:\"rules 7.x-2.10\";s:7:\"version\";s:8:\"7.x-2.10\";s:3:\"tag\";s:8:\"7.x-2.10\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/rules/releases/7.x-2.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/rules-7.x-2.10.tar.gz\";s:4:\"date\";s:10:\"1492697942\";s:6:\"mdhash\";s:32:\"b66045ee97acdec07b4808f649e9dcc8\";s:8:\"filesize\";s:6:\"187783\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.9\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.9\";s:7:\"version\";s:7:\"7.x-2.9\";s:3:\"tag\";s:7:\"7.x-2.9\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.9.tar.gz\";s:4:\"date\";s:10:\"1426527181\";s:6:\"mdhash\";s:32:\"ce4e3363c37cb00f4caf0abd3f38f38a\";s:8:\"filesize\";s:6:\"188880\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.8\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.8\";s:7:\"version\";s:7:\"7.x-2.8\";s:3:\"tag\";s:7:\"7.x-2.8\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.8.tar.gz\";s:4:\"date\";s:10:\"1420733280\";s:6:\"mdhash\";s:32:\"c84d88caa5ba178efa689a1a71d3a144\";s:8:\"filesize\";s:6:\"187857\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.7\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.7\";s:7:\"version\";s:7:\"7.x-2.7\";s:3:\"tag\";s:7:\"7.x-2.7\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.7.tar.gz\";s:4:\"date\";s:10:\"1399041227\";s:6:\"mdhash\";s:32:\"f28b8811918dd16952acca967d09dcc0\";s:8:\"filesize\";s:6:\"186255\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.6\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.6\";s:7:\"version\";s:7:\"7.x-2.6\";s:3:\"tag\";s:7:\"7.x-2.6\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.6.tar.gz\";s:4:\"date\";s:10:\"1383063053\";s:6:\"mdhash\";s:32:\"152c1f330f91f83d358b478253a8c042\";s:8:\"filesize\";s:6:\"186022\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1379579047\";s:6:\"mdhash\";s:32:\"5387542c8c5cd2de9682d61fafb57314\";s:8:\"filesize\";s:6:\"185061\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1379354606\";s:6:\"mdhash\";s:32:\"e19b2c10f96c8a680afe9e4f65db4e5c\";s:8:\"filesize\";s:6:\"184071\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1364401819\";s:6:\"mdhash\";s:32:\"9af9fbdc593158638603832c633432b1\";s:8:\"filesize\";s:6:\"170892\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1343980733\";s:6:\"mdhash\";s:32:\"91799bff2cf6690937e056734265458c\";s:8:\"filesize\";s:6:\"168867\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1331918148\";s:6:\"mdhash\";s:32:\"a7f15c72df435554790d5611a8b1732e\";s:8:\"filesize\";s:6:\"167042\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:13:\"rules 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/rules/releases/7.x-2.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1318336335\";s:6:\"mdhash\";s:32:\"efe3f31a4d21b9fa8757cd692dc8f641\";s:8:\"filesize\";s:6:\"155077\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:0:\"\";s:5:\"terms\";a:0:{}}s:11:\"7.x-2.0-rc2\";a:15:{s:4:\"name\";s:17:\"rules 7.x-2.0-rc2\";s:7:\"version\";s:11:\"7.x-2.0-rc2\";s:3:\"tag\";s:11:\"7.x-2.0-rc2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rules/releases/7.x-2.0-rc2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1316339806\";s:6:\"mdhash\";s:32:\"9a9d7de26f666d5af62fc90612551f64\";s:8:\"filesize\";s:6:\"152243\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.0-rc1\";a:15:{s:4:\"name\";s:17:\"rules 7.x-2.0-rc1\";s:7:\"version\";s:11:\"7.x-2.0-rc1\";s:3:\"tag\";s:11:\"7.x-2.0-rc1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rules/releases/7.x-2.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1313600220\";s:6:\"mdhash\";s:32:\"0c01319958aed5439bd7e22d5f060ab0\";s:8:\"filesize\";s:6:\"150814\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.0-beta3\";a:15:{s:4:\"name\";s:19:\"rules 7.x-2.0-beta3\";s:7:\"version\";s:13:\"7.x-2.0-beta3\";s:3:\"tag\";s:13:\"7.x-2.0-beta3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rules/releases/7.x-2.0-beta3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1312908119\";s:6:\"mdhash\";s:32:\"c0d8f94ec44834355ab2acd02eb01781\";s:8:\"filesize\";s:6:\"146211\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.0-beta2\";a:15:{s:4:\"name\";s:19:\"rules 7.x-2.0-beta2\";s:7:\"version\";s:13:\"7.x-2.0-beta2\";s:3:\"tag\";s:13:\"7.x-2.0-beta2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rules/releases/7.x-2.0-beta2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1308241620\";s:6:\"mdhash\";s:32:\"fd1bdc36bc612913dfba91e7bdeda00d\";s:8:\"filesize\";s:6:\"139063\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-2.0-beta1\";a:15:{s:4:\"name\";s:19:\"rules 7.x-2.0-beta1\";s:7:\"version\";s:13:\"7.x-2.0-beta1\";s:3:\"tag\";s:13:\"7.x-2.0-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/rules/releases/7.x-2.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1300896369\";s:6:\"mdhash\";s:32:\"7b9718415365872eca4a2f7b9f50787a\";s:8:\"filesize\";s:6:\"134506\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha5\";a:15:{s:4:\"name\";s:20:\"rules 7.x-2.0-alpha5\";s:7:\"version\";s:14:\"7.x-2.0-alpha5\";s:3:\"tag\";s:14:\"7.x-2.0-alpha5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rules/releases/7.x-2.0-alpha5\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1297877847\";s:6:\"mdhash\";s:32:\"cf14a81dca5d26d4ab392bc14c0c23a6\";s:8:\"filesize\";s:6:\"124733\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-2.0-alpha4\";a:15:{s:4:\"name\";s:20:\"rules 7.x-2.0-alpha4\";s:7:\"version\";s:14:\"7.x-2.0-alpha4\";s:3:\"tag\";s:14:\"7.x-2.0-alpha4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rules/releases/7.x-2.0-alpha4\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1294228281\";s:6:\"mdhash\";s:32:\"3e6905f82d9c9e1ab462ab0c90afe3e9\";s:8:\"filesize\";s:6:\"113547\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha3\";a:15:{s:4:\"name\";s:20:\"rules 7.x-2.0-alpha3\";s:7:\"version\";s:14:\"7.x-2.0-alpha3\";s:3:\"tag\";s:14:\"7.x-2.0-alpha3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rules/releases/7.x-2.0-alpha3\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1291637070\";s:6:\"mdhash\";s:32:\"92f674a49f40ddd9ffb8de5b0e91425f\";s:8:\"filesize\";s:6:\"108782\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha2\";a:15:{s:4:\"name\";s:20:\"rules 7.x-2.0-alpha2\";s:7:\"version\";s:14:\"7.x-2.0-alpha2\";s:3:\"tag\";s:14:\"7.x-2.0-alpha2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rules/releases/7.x-2.0-alpha2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1286798162\";s:6:\"mdhash\";s:32:\"57e3e8298fff1c6f7cf6af8a0a3c3309\";s:8:\"filesize\";s:6:\"106373\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha1\";a:15:{s:4:\"name\";s:20:\"rules 7.x-2.0-alpha1\";s:7:\"version\";s:14:\"7.x-2.0-alpha1\";s:3:\"tag\";s:14:\"7.x-2.0-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rules/releases/7.x-2.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rules-7.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1283932308\";s:6:\"mdhash\";s:32:\"103e926a3b79276e6a7ea62b12a7f2a1\";s:8:\"filesize\";s:6:\"104650\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:20:\"rules 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/rules/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/rules-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1286792763\";s:6:\"mdhash\";s:32:\"c49d85d2bb2fb860580a79e3f930b5c1\";s:8:\"filesize\";s:6:\"106374\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:17:\"rules 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rules/releases/7.x-2.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rules-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1492696442\";s:6:\"mdhash\";s:32:\"68fea23d84ad3632092f9a9ba8d7c636\";s:8:\"filesize\";s:6:\"187827\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:17:\"rules 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/rules/releases/7.x-1.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/rules-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1380626241\";s:6:\"mdhash\";s:32:\"a1a7d855e52429da95024a30a55a635a\";s:8:\"filesize\";s:4:\"7108\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541598,1500455183,1),('available_releases::site_map','a:11:{s:5:\"title\";s:8:\"Site map\";s:10:\"short_name\";s:8:\"site_map\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"https://www.drupal.org/project/site_map\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:6:{s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:16:\"site_map 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/site_map/releases/7.x-1.3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/site_map-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1441076639\";s:6:\"mdhash\";s:32:\"638c9d973197d3dc51b67b20c75b8b52\";s:8:\"filesize\";s:5:\"20300\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:16:\"site_map 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/site_map/releases/7.x-1.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/site_map-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1393897705\";s:6:\"mdhash\";s:32:\"c8810b35609987d2f4c0c7ab85a1d5ef\";s:8:\"filesize\";s:5:\"19452\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:16:\"site_map 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/site_map/releases/7.x-1.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/site_map-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1393879105\";s:6:\"mdhash\";s:32:\"7279c07aaefdab7b985b1ae943c03afd\";s:8:\"filesize\";s:5:\"19351\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:16:\"site_map 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/site_map/releases/7.x-1.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/site_map-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1315890108\";s:6:\"mdhash\";s:32:\"84aabb928fa80f416d94467155e11fd3\";s:8:\"filesize\";s:5:\"16773\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:22:\"site_map 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/site_map/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/site_map-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1294253198\";s:6:\"mdhash\";s:32:\"dd07000ac2d3bcdb4c4a18e885521fb3\";s:8:\"filesize\";s:5:\"25769\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:20:\"site_map 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/site_map/releases/7.x-1.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/site_map-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1500401942\";s:6:\"mdhash\";s:32:\"2a18f13f2fe5daf6fa991ab7f9779b60\";s:8:\"filesize\";s:5:\"22662\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541598,1500455183,1),('available_releases::superfish','a:11:{s:5:\"title\";s:9:\"Superfish\";s:10:\"short_name\";s:9:\"superfish\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:3:\"1,2\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:40:\"https://www.drupal.org/project/superfish\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:13:{s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:17:\"superfish 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/superfish/releases/7.x-2.0\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/superfish-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1448444941\";s:6:\"mdhash\";s:32:\"bcfbb3277b2c4b15d4adef04f843eb0d\";s:8:\"filesize\";s:5:\"31730\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.9\";a:14:{s:4:\"name\";s:17:\"superfish 7.x-1.9\";s:7:\"version\";s:7:\"7.x-1.9\";s:3:\"tag\";s:7:\"7.x-1.9\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/superfish/releases/7.x-1.9\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1367054111\";s:6:\"mdhash\";s:32:\"94db2b82bf5f2dbd9f798afed1aa8e54\";s:8:\"filesize\";s:5:\"29432\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.9-rc1\";a:15:{s:4:\"name\";s:21:\"superfish 7.x-1.9-rc1\";s:7:\"version\";s:11:\"7.x-1.9-rc1\";s:3:\"tag\";s:11:\"7.x-1.9-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/superfish/releases/7.x-1.9-rc1\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9-rc1.tar.gz\";s:4:\"date\";s:10:\"1365576032\";s:6:\"mdhash\";s:32:\"88e031378d00b1d2ae37afaf212faeb1\";s:8:\"filesize\";s:5:\"29338\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.9-beta5\";a:15:{s:4:\"name\";s:23:\"superfish 7.x-1.9-beta5\";s:7:\"version\";s:13:\"7.x-1.9-beta5\";s:3:\"tag\";s:13:\"7.x-1.9-beta5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/superfish/releases/7.x-1.9-beta5\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9-beta5.tar.gz\";s:4:\"date\";s:10:\"1355076542\";s:6:\"mdhash\";s:32:\"0c64a860667cc1dcfca98316791d27a7\";s:8:\"filesize\";s:5:\"23334\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.9-beta4\";a:15:{s:4:\"name\";s:23:\"superfish 7.x-1.9-beta4\";s:7:\"version\";s:13:\"7.x-1.9-beta4\";s:3:\"tag\";s:13:\"7.x-1.9-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/superfish/releases/7.x-1.9-beta4\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9-beta4.tar.gz\";s:4:\"date\";s:10:\"1322150145\";s:6:\"mdhash\";s:32:\"a7b0cf9559dc9b1c10eb548c3d8d64c8\";s:8:\"filesize\";s:5:\"21378\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.9-beta3\";a:15:{s:4:\"name\";s:23:\"superfish 7.x-1.9-beta3\";s:7:\"version\";s:13:\"7.x-1.9-beta3\";s:3:\"tag\";s:13:\"7.x-1.9-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/superfish/releases/7.x-1.9-beta3\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9-beta3.tar.gz\";s:4:\"date\";s:10:\"1321783244\";s:6:\"mdhash\";s:32:\"a04540f5e161439603ae9dfcf7b18984\";s:8:\"filesize\";s:5:\"20897\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.9-beta2\";a:15:{s:4:\"name\";s:23:\"superfish 7.x-1.9-beta2\";s:7:\"version\";s:13:\"7.x-1.9-beta2\";s:3:\"tag\";s:13:\"7.x-1.9-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/superfish/releases/7.x-1.9-beta2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9-beta2.tar.gz\";s:4:\"date\";s:10:\"1301053268\";s:6:\"mdhash\";s:32:\"33851d31e5d186ff7bae1b9b95263b4f\";s:8:\"filesize\";s:5:\"17500\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.9-beta1\";a:15:{s:4:\"name\";s:23:\"superfish 7.x-1.9-beta1\";s:7:\"version\";s:13:\"7.x-1.9-beta1\";s:3:\"tag\";s:13:\"7.x-1.9-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"9\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/superfish/releases/7.x-1.9-beta1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.9-beta1.tar.gz\";s:4:\"date\";s:10:\"1300977968\";s:6:\"mdhash\";s:32:\"f3b1956b4b47d8b217144e27ace9be08\";s:8:\"filesize\";s:5:\"17502\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.8\";a:14:{s:4:\"name\";s:17:\"superfish 7.x-1.8\";s:7:\"version\";s:7:\"7.x-1.8\";s:3:\"tag\";s:7:\"7.x-1.8\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/superfish/releases/7.x-1.8\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1301247369\";s:6:\"mdhash\";s:32:\"08612c4b53845e93c441e854a588ecb9\";s:8:\"filesize\";s:5:\"17561\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:14:\"7.x-1.8-alpha5\";a:15:{s:4:\"name\";s:24:\"superfish 7.x-1.8-alpha5\";s:7:\"version\";s:14:\"7.x-1.8-alpha5\";s:3:\"tag\";s:14:\"7.x-1.8-alpha5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"8\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/superfish/releases/7.x-1.8-alpha5\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.8-alpha5.tar.gz\";s:4:\"date\";s:10:\"1274714410\";s:6:\"mdhash\";s:32:\"b145551a88dbe691ab5251be62845d7a\";s:8:\"filesize\";s:5:\"23303\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.7-alpha5\";a:15:{s:4:\"name\";s:24:\"superfish 7.x-1.7-alpha5\";s:7:\"version\";s:14:\"7.x-1.7-alpha5\";s:3:\"tag\";s:14:\"7.x-1.7-alpha5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/superfish/releases/7.x-1.7-alpha5\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.7-alpha5.tar.gz\";s:4:\"date\";s:10:\"1274712907\";s:6:\"mdhash\";s:32:\"c1f510bcc68149b6cf908f924a9d01b7\";s:8:\"filesize\";s:5:\"22938\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha5\";a:15:{s:4:\"name\";s:24:\"superfish 7.x-1.0-alpha5\";s:7:\"version\";s:14:\"7.x-1.0-alpha5\";s:3:\"tag\";s:14:\"7.x-1.0-alpha5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/superfish/releases/7.x-1.0-alpha5\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1274713810\";s:6:\"mdhash\";s:32:\"789b1fbb69f5bfff5ee09af91d3ab8bf\";s:8:\"filesize\";s:5:\"23302\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:21:\"superfish 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:61:\"https://www.drupal.org/project/superfish/releases/7.x-1.x-dev\";s:13:\"download_link\";s:66:\"https://ftp.drupal.org/files/projects/superfish-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1477738740\";s:6:\"mdhash\";s:32:\"7dd7786793d8f52d77b5d7142c743c0d\";s:8:\"filesize\";s:5:\"31729\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}}',1500541599,1500455183,1),('available_releases::token','a:11:{s:5:\"title\";s:5:\"Token\";s:10:\"short_name\";s:5:\"token\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"https://www.drupal.org/project/token\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:20:{s:7:\"7.x-1.7\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.7\";s:7:\"version\";s:7:\"7.x-1.7\";s:3:\"tag\";s:7:\"7.x-1.7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1485316084\";s:6:\"mdhash\";s:32:\"cf117195d2815e4292e522c04f4055d0\";s:8:\"filesize\";s:5:\"44016\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.6\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.6\";s:7:\"version\";s:7:\"7.x-1.6\";s:3:\"tag\";s:7:\"7.x-1.6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1425149059\";s:6:\"mdhash\";s:32:\"9b59f3ce5f25aab883a1ae7631bf5581\";s:8:\"filesize\";s:5:\"44396\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.5\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.5\";s:7:\"version\";s:7:\"7.x-1.5\";s:3:\"tag\";s:7:\"7.x-1.5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1361665026\";s:6:\"mdhash\";s:32:\"93e5a19e8b244022cc38e58663db8001\";s:8:\"filesize\";s:5:\"44012\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.4\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.4\";s:7:\"version\";s:7:\"7.x-1.4\";s:3:\"tag\";s:7:\"7.x-1.4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1348497279\";s:6:\"mdhash\";s:32:\"e65a894f14518751ca1da445a767965c\";s:8:\"filesize\";s:5:\"43675\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.3\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.3\";s:7:\"version\";s:7:\"7.x-1.3\";s:3:\"tag\";s:7:\"7.x-1.3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1347466790\";s:6:\"mdhash\";s:32:\"efe130120435cf38d33e6ae005ad0956\";s:8:\"filesize\";s:5:\"43666\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1344634643\";s:6:\"mdhash\";s:32:\"0cb93d8a597acd5f99acdc7cb42b6332\";s:8:\"filesize\";s:5:\"43170\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1337115392\";s:6:\"mdhash\";s:32:\"8d4c96128ab3ef9f4e76fbdb73900e35\";s:8:\"filesize\";s:5:\"42496\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:13:\"token 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/token/releases/7.x-1.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/token-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1333672577\";s:6:\"mdhash\";s:32:\"21709598974906287ea5bd68f2b94815\";s:8:\"filesize\";s:5:\"42264\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:17:\"token 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/token/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1328022364\";s:6:\"mdhash\";s:32:\"b63435f4a943cb013aa34339f5ce8bb0\";s:8:\"filesize\";s:5:\"41089\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta7\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta7\";s:7:\"version\";s:13:\"7.x-1.0-beta7\";s:3:\"tag\";s:13:\"7.x-1.0-beta7\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta7\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta7.tar.gz\";s:4:\"date\";s:10:\"1319825735\";s:6:\"mdhash\";s:32:\"9d5644d212720e8c9db7fcbcf4559468\";s:8:\"filesize\";s:5:\"40531\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta6\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta6\";s:7:\"version\";s:13:\"7.x-1.0-beta6\";s:3:\"tag\";s:13:\"7.x-1.0-beta6\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta6\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1317397307\";s:6:\"mdhash\";s:32:\"797c619140cdcc00004ce5e64b25eb02\";s:8:\"filesize\";s:5:\"40155\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta5\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta5\";s:7:\"version\";s:13:\"7.x-1.0-beta5\";s:3:\"tag\";s:13:\"7.x-1.0-beta5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta5\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1314804722\";s:6:\"mdhash\";s:32:\"42b75e49ecfe3945cf3971b20d64e21f\";s:8:\"filesize\";s:5:\"38428\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta4\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta4\";s:7:\"version\";s:13:\"7.x-1.0-beta4\";s:3:\"tag\";s:13:\"7.x-1.0-beta4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta4\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1313614619\";s:6:\"mdhash\";s:32:\"00aea5ce506db5a5308e4881cc16a650\";s:8:\"filesize\";s:5:\"36328\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1311709319\";s:6:\"mdhash\";s:32:\"236041ef8c6249adae04f0af98e8aa8b\";s:8:\"filesize\";s:5:\"34573\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1305833216\";s:6:\"mdhash\";s:32:\"33678788042e89887c17f072f22b360e\";s:8:\"filesize\";s:5:\"32677\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:19:\"token 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/token/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1294805791\";s:6:\"mdhash\";s:32:\"0c597a7a17a7a27a725cf076bbae25e4\";s:8:\"filesize\";s:5:\"31159\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:20:\"token 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/token/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1286469965\";s:6:\"mdhash\";s:32:\"16096ce5c4a1f7e0b70c31026d88238a\";s:8:\"filesize\";s:5:\"23473\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:20:\"token 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/token/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1281549992\";s:6:\"mdhash\";s:32:\"788bb2827e595fa41387afbe116f462d\";s:8:\"filesize\";s:5:\"21523\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:20:\"token 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/token/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/token-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1271567107\";s:6:\"mdhash\";s:32:\"622a57e2ef607da3010c9e94d76af3fc\";s:8:\"filesize\";s:5:\"17032\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:17:\"token 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/token/releases/7.x-1.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/token-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1493330042\";s:6:\"mdhash\";s:32:\"89e063c41031d1001ae19ca34d00ccdb\";s:8:\"filesize\";s:5:\"44024\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541599,1500455183,1),('available_releases::variable','a:11:{s:5:\"title\";s:8:\"Variable\";s:10:\"short_name\";s:8:\"variable\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"2\";s:16:\"supported_majors\";s:1:\"2\";s:13:\"default_major\";s:1:\"2\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:39:\"https://www.drupal.org/project/variable\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:21:{s:7:\"7.x-2.5\";a:14:{s:4:\"name\";s:16:\"variable 7.x-2.5\";s:7:\"version\";s:7:\"7.x-2.5\";s:3:\"tag\";s:7:\"7.x-2.5\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-2.5\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-2.5.tar.gz\";s:4:\"date\";s:10:\"1398250127\";s:6:\"mdhash\";s:32:\"19ef79edd10ef87e471775cf34a27386\";s:8:\"filesize\";s:5:\"53993\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.4\";a:14:{s:4:\"name\";s:16:\"variable 7.x-2.4\";s:7:\"version\";s:7:\"7.x-2.4\";s:3:\"tag\";s:7:\"7.x-2.4\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-2.4\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-2.4.tar.gz\";s:4:\"date\";s:10:\"1390310305\";s:6:\"mdhash\";s:32:\"593343d361833c14f6bf8da3cc93332c\";s:8:\"filesize\";s:5:\"53722\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.3\";a:14:{s:4:\"name\";s:16:\"variable 7.x-2.3\";s:7:\"version\";s:7:\"7.x-2.3\";s:3:\"tag\";s:7:\"7.x-2.3\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-2.3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-2.3.tar.gz\";s:4:\"date\";s:10:\"1376034994\";s:6:\"mdhash\";s:32:\"4a053c4479a0a540225dc040e822b6ac\";s:8:\"filesize\";s:5:\"53717\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.2\";a:14:{s:4:\"name\";s:16:\"variable 7.x-2.2\";s:7:\"version\";s:7:\"7.x-2.2\";s:3:\"tag\";s:7:\"7.x-2.2\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-2.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-2.2.tar.gz\";s:4:\"date\";s:10:\"1358075138\";s:6:\"mdhash\";s:32:\"07d1633a9df95a66374c70eb9b539ef1\";s:8:\"filesize\";s:5:\"53545\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.1\";a:14:{s:4:\"name\";s:16:\"variable 7.x-2.1\";s:7:\"version\";s:7:\"7.x-2.1\";s:3:\"tag\";s:7:\"7.x-2.1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-2.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-2.1.tar.gz\";s:4:\"date\";s:10:\"1341236242\";s:6:\"mdhash\";s:32:\"ec6e03acf71fdb65471dcf3f71439a2b\";s:8:\"filesize\";s:5:\"52510\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-2.0\";a:14:{s:4:\"name\";s:16:\"variable 7.x-2.0\";s:7:\"version\";s:7:\"7.x-2.0\";s:3:\"tag\";s:7:\"7.x-2.0\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-2.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-2.0.tar.gz\";s:4:\"date\";s:10:\"1340224919\";s:6:\"mdhash\";s:32:\"8360a99fe685553a71ebb8f2b2de9537\";s:8:\"filesize\";s:5:\"52286\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-2.0-beta1\";a:15:{s:4:\"name\";s:22:\"variable 7.x-2.0-beta1\";s:7:\"version\";s:13:\"7.x-2.0-beta1\";s:3:\"tag\";s:13:\"7.x-2.0-beta1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/variable/releases/7.x-2.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/variable-7.x-2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1338039697\";s:6:\"mdhash\";s:32:\"f06bde35794978e2114b064b8fe6a26a\";s:8:\"filesize\";s:5:\"50599\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-2.0-alpha1\";a:15:{s:4:\"name\";s:23:\"variable 7.x-2.0-alpha1\";s:7:\"version\";s:14:\"7.x-2.0-alpha1\";s:3:\"tag\";s:14:\"7.x-2.0-alpha1\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/variable/releases/7.x-2.0-alpha1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/variable-7.x-2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1337602905\";s:6:\"mdhash\";s:32:\"a969eb4605ed8d1b46d5a7f615894d97\";s:8:\"filesize\";s:5:\"49073\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"7.x-1.2\";a:14:{s:4:\"name\";s:16:\"variable 7.x-1.2\";s:7:\"version\";s:7:\"7.x-1.2\";s:3:\"tag\";s:7:\"7.x-1.2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-1.2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1334999498\";s:6:\"mdhash\";s:32:\"d22b461760eb97e010a29ab443d26582\";s:8:\"filesize\";s:5:\"39619\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:16:\"variable 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-1.1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1313088721\";s:6:\"mdhash\";s:32:\"e25c594c052b1973402c90ed896b40aa\";s:8:\"filesize\";s:5:\"30548\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:16:\"variable 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/variable/releases/7.x-1.0\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1304158917\";s:6:\"mdhash\";s:32:\"715a7eb15fb721ce32f243a0cbe014a2\";s:8:\"filesize\";s:5:\"29109\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:13:\"7.x-1.0-beta3\";a:15:{s:4:\"name\";s:22:\"variable 7.x-1.0-beta3\";s:7:\"version\";s:13:\"7.x-1.0-beta3\";s:3:\"tag\";s:13:\"7.x-1.0-beta3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/variable/releases/7.x-1.0-beta3\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1303033317\";s:6:\"mdhash\";s:32:\"b7b99e2a5fee44e3ba2bc9162826576c\";s:8:\"filesize\";s:5:\"29116\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta2\";a:15:{s:4:\"name\";s:22:\"variable 7.x-1.0-beta2\";s:7:\"version\";s:13:\"7.x-1.0-beta2\";s:3:\"tag\";s:13:\"7.x-1.0-beta2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/variable/releases/7.x-1.0-beta2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1298891771\";s:6:\"mdhash\";s:32:\"91d7116b5ef8b9a0b32d47c913e93a9c\";s:8:\"filesize\";s:5:\"28339\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-1.0-beta1\";a:15:{s:4:\"name\";s:22:\"variable 7.x-1.0-beta1\";s:7:\"version\";s:13:\"7.x-1.0-beta1\";s:3:\"tag\";s:13:\"7.x-1.0-beta1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/variable/releases/7.x-1.0-beta1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1298575040\";s:6:\"mdhash\";s:32:\"316aa9de8723f9e42d235340d5e81cd8\";s:8:\"filesize\";s:5:\"27140\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha5\";a:15:{s:4:\"name\";s:23:\"variable 7.x-1.0-alpha5\";s:7:\"version\";s:14:\"7.x-1.0-alpha5\";s:3:\"tag\";s:14:\"7.x-1.0-alpha5\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/variable/releases/7.x-1.0-alpha5\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1298138218\";s:6:\"mdhash\";s:32:\"562eb1e1bc3ed33f3bf7d3cf3af5713c\";s:8:\"filesize\";s:5:\"25613\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha4\";a:15:{s:4:\"name\";s:23:\"variable 7.x-1.0-alpha4\";s:7:\"version\";s:14:\"7.x-1.0-alpha4\";s:3:\"tag\";s:14:\"7.x-1.0-alpha4\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/variable/releases/7.x-1.0-alpha4\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1297961280\";s:6:\"mdhash\";s:32:\"d9057a4880e128bf379a261985cee7b9\";s:8:\"filesize\";s:5:\"25316\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha3\";a:15:{s:4:\"name\";s:23:\"variable 7.x-1.0-alpha3\";s:7:\"version\";s:14:\"7.x-1.0-alpha3\";s:3:\"tag\";s:14:\"7.x-1.0-alpha3\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/variable/releases/7.x-1.0-alpha3\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1297683744\";s:6:\"mdhash\";s:32:\"d5e5cc33ed8d0c29409fa945d3107c4e\";s:8:\"filesize\";s:5:\"23820\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:14:\"7.x-1.0-alpha2\";a:15:{s:4:\"name\";s:23:\"variable 7.x-1.0-alpha2\";s:7:\"version\";s:14:\"7.x-1.0-alpha2\";s:3:\"tag\";s:14:\"7.x-1.0-alpha2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/variable/releases/7.x-1.0-alpha2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1295708628\";s:6:\"mdhash\";s:32:\"5d8f8134368f319788c6b2f86d812171\";s:8:\"filesize\";s:5:\"23271\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:14:\"7.x-1.0-alpha1\";a:15:{s:4:\"name\";s:23:\"variable 7.x-1.0-alpha1\";s:7:\"version\";s:14:\"7.x-1.0-alpha1\";s:3:\"tag\";s:14:\"7.x-1.0-alpha1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/variable/releases/7.x-1.0-alpha1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/variable-7.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1295460731\";s:6:\"mdhash\";s:32:\"e42b293024da523516f8e92e26ede356\";s:8:\"filesize\";s:5:\"19401\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"7.x-2.x-dev\";a:14:{s:4:\"name\";s:20:\"variable 7.x-2.x-dev\";s:7:\"version\";s:11:\"7.x-2.x-dev\";s:3:\"tag\";s:7:\"7.x-2.x\";s:13:\"version_major\";s:1:\"2\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/variable/releases/7.x-2.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/variable-7.x-2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1397240053\";s:6:\"mdhash\";s:32:\"9e8a3fec31297fdc79a71dbba82e5472\";s:8:\"filesize\";s:5:\"53993\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:20:\"variable 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/variable/releases/7.x-1.x-dev\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/variable-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1382151333\";s:6:\"mdhash\";s:32:\"5251f764b10e313bcb36b83eaaafd77b\";s:8:\"filesize\";s:5:\"48137\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500446519,1500360090,1),('available_releases::views','a:11:{s:5:\"title\";s:5:\"Views\";s:10:\"short_name\";s:5:\"views\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:36:\"https://www.drupal.org/project/views\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:24:{s:8:\"7.x-3.16\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.16\";s:7:\"version\";s:8:\"7.x-3.16\";s:3:\"tag\";s:8:\"7.x-3.16\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.16\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.16.tar.gz\";s:4:\"date\";s:10:\"1491158584\";s:6:\"mdhash\";s:32:\"d840cb148809da844b93d73b16b453f9\";s:8:\"filesize\";s:7:\"1643030\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:12:\"7.x-3.16-rc1\";a:15:{s:4:\"name\";s:18:\"views 7.x-3.16-rc1\";s:7:\"version\";s:12:\"7.x-3.16-rc1\";s:3:\"tag\";s:12:\"7.x-3.16-rc1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"16\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/views/releases/7.x-3.16-rc1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/views-7.x-3.16-rc1.tar.gz\";s:4:\"date\";s:10:\"1489763584\";s:6:\"mdhash\";s:32:\"cba59381dbf64ac9d9d76fa549b4c7c1\";s:8:\"filesize\";s:7:\"1642814\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:8:\"7.x-3.15\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.15\";s:7:\"version\";s:8:\"7.x-3.15\";s:3:\"tag\";s:8:\"7.x-3.15\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.15\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.15.tar.gz\";s:4:\"date\";s:10:\"1487784184\";s:6:\"mdhash\";s:32:\"473cb5384456d55af988feabc1af12ed\";s:8:\"filesize\";s:7:\"1642425\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-3.14\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.14\";s:7:\"version\";s:8:\"7.x-3.14\";s:3:\"tag\";s:8:\"7.x-3.14\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.14\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.14.tar.gz\";s:4:\"date\";s:10:\"1466019539\";s:6:\"mdhash\";s:32:\"168bb684c8f34297be94b03c797841e5\";s:8:\"filesize\";s:7:\"1656594\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-3.13\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.13\";s:7:\"version\";s:8:\"7.x-3.13\";s:3:\"tag\";s:8:\"7.x-3.13\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.13\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.13.tar.gz\";s:4:\"date\";s:10:\"1446804839\";s:6:\"mdhash\";s:32:\"50d3b231f689f8c4ff15d79ea3c261d9\";s:8:\"filesize\";s:7:\"1650157\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-3.12\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.12\";s:7:\"version\";s:8:\"7.x-3.12\";s:3:\"tag\";s:8:\"7.x-3.12\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.12\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.12.tar.gz\";s:4:\"date\";s:10:\"1446653339\";s:6:\"mdhash\";s:32:\"a50033bb090730176d9263ddae7f32b2\";s:8:\"filesize\";s:7:\"1650130\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-3.11\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.11\";s:7:\"version\";s:8:\"7.x-3.11\";s:3:\"tag\";s:8:\"7.x-3.11\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.11\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.11.tar.gz\";s:4:\"date\";s:10:\"1430320981\";s:6:\"mdhash\";s:32:\"00d722e1d8ed57e912c8bd586cf2edbe\";s:8:\"filesize\";s:7:\"1649389\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:8:\"7.x-3.10\";a:14:{s:4:\"name\";s:14:\"views 7.x-3.10\";s:7:\"version\";s:8:\"7.x-3.10\";s:3:\"tag\";s:8:\"7.x-3.10\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:2:\"10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/views/releases/7.x-3.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/views-7.x-3.10.tar.gz\";s:4:\"date\";s:10:\"1423648081\";s:6:\"mdhash\";s:32:\"c9806ffd69448bc505a67e790f97da58\";s:8:\"filesize\";s:7:\"1648314\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.8\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.8\";s:7:\"version\";s:7:\"7.x-3.8\";s:3:\"tag\";s:7:\"7.x-3.8\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.8.tar.gz\";s:4:\"date\";s:10:\"1400618927\";s:6:\"mdhash\";s:32:\"0fbe71c455f5d34c7193797563b63b3f\";s:8:\"filesize\";s:7:\"1646817\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.7\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.7\";s:7:\"version\";s:7:\"7.x-3.7\";s:3:\"tag\";s:7:\"7.x-3.7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1365499237\";s:6:\"mdhash\";s:32:\"3f36f0d13f3b724d719f6729cbc110ba\";s:8:\"filesize\";s:7:\"1639539\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.6\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.6\";s:7:\"version\";s:7:\"7.x-3.6\";s:3:\"tag\";s:7:\"7.x-3.6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.6.tar.gz\";s:4:\"date\";s:10:\"1363810217\";s:6:\"mdhash\";s:32:\"1531a1ece3970332db1559b854f5dcc9\";s:8:\"filesize\";s:7:\"1639219\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.5\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.5\";s:7:\"version\";s:7:\"7.x-3.5\";s:3:\"tag\";s:7:\"7.x-3.5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.5.tar.gz\";s:4:\"date\";s:10:\"1345829395\";s:6:\"mdhash\";s:32:\"fba70998d4ebcca5116ef5ee90117738\";s:8:\"filesize\";s:7:\"1632919\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.4\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.4\";s:7:\"version\";s:7:\"7.x-3.4\";s:3:\"tag\";s:7:\"7.x-3.4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1345559303\";s:6:\"mdhash\";s:32:\"72bd0f35ac467aed74e533c10a76c93f\";s:8:\"filesize\";s:7:\"1632803\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.3\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.3\";s:7:\"version\";s:7:\"7.x-3.3\";s:3:\"tag\";s:7:\"7.x-3.3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1329946249\";s:6:\"mdhash\";s:32:\"70f24086dc7acfa7fc23c6148c7f8e00\";s:8:\"filesize\";s:7:\"1583249\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.2\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.2\";s:7:\"version\";s:7:\"7.x-3.2\";s:3:\"tag\";s:7:\"7.x-3.2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1329778551\";s:6:\"mdhash\";s:32:\"c350603991445ca69b30eddf3befe887\";s:8:\"filesize\";s:7:\"1582617\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.1\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.1\";s:7:\"version\";s:7:\"7.x-3.1\";s:3:\"tag\";s:7:\"7.x-3.1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1326750948\";s:6:\"mdhash\";s:32:\"e158435dc66d1d89a0df587c39ef1a23\";s:8:\"filesize\";s:7:\"1575585\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.0\";a:14:{s:4:\"name\";s:13:\"views 7.x-3.0\";s:7:\"version\";s:7:\"7.x-3.0\";s:3:\"tag\";s:7:\"7.x-3.0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/views/releases/7.x-3.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/views-7.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1324170451\";s:6:\"mdhash\";s:32:\"1be8cbd6fd3f37bfd1493693dfa95d8d\";s:8:\"filesize\";s:7:\"1461460\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-3.0-rc3\";a:15:{s:4:\"name\";s:17:\"views 7.x-3.0-rc3\";s:7:\"version\";s:11:\"7.x-3.0-rc3\";s:3:\"tag\";s:11:\"7.x-3.0-rc3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/views/releases/7.x-3.0-rc3\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/views-7.x-3.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1321467945\";s:6:\"mdhash\";s:32:\"b3e58f4195308e37621155d3c843e53f\";s:8:\"filesize\";s:7:\"1456218\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-3.0-rc1\";a:15:{s:4:\"name\";s:17:\"views 7.x-3.0-rc1\";s:7:\"version\";s:11:\"7.x-3.0-rc1\";s:3:\"tag\";s:11:\"7.x-3.0-rc1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/views/releases/7.x-3.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/views-7.x-3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1308341221\";s:6:\"mdhash\";s:32:\"e158db78ae2f8cc615edb910a09384b0\";s:8:\"filesize\";s:7:\"1481151\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:13:\"7.x-3.0-beta3\";a:15:{s:4:\"name\";s:19:\"views 7.x-3.0-beta3\";s:7:\"version\";s:13:\"7.x-3.0-beta3\";s:3:\"tag\";s:13:\"7.x-3.0-beta3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/views/releases/7.x-3.0-beta3\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/views-7.x-3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1301301971\";s:6:\"mdhash\";s:32:\"114c76f201523ef3e50b9a1d431b0364\";s:8:\"filesize\";s:7:\"1469580\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-3.0-beta2\";a:15:{s:4:\"name\";s:19:\"views 7.x-3.0-beta2\";s:7:\"version\";s:13:\"7.x-3.0-beta2\";s:3:\"tag\";s:13:\"7.x-3.0-beta2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/views/releases/7.x-3.0-beta2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/views-7.x-3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1301158871\";s:6:\"mdhash\";s:32:\"c39fab1e76e55b15291fecf2c10386c2\";s:8:\"filesize\";s:7:\"1469243\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"7.x-3.0-beta1\";a:15:{s:4:\"name\";s:19:\"views 7.x-3.0-beta1\";s:7:\"version\";s:13:\"7.x-3.0-beta1\";s:3:\"tag\";s:13:\"7.x-3.0-beta1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:5:\"beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/views/releases/7.x-3.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/views-7.x-3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1301099796\";s:6:\"mdhash\";s:32:\"6ee4495cbdf0a8d19bd214f57bef0bf4\";s:8:\"filesize\";s:7:\"1468892\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:14:\"7.x-3.0-alpha1\";a:15:{s:4:\"name\";s:20:\"views 7.x-3.0-alpha1\";s:7:\"version\";s:14:\"7.x-3.0-alpha1\";s:3:\"tag\";s:14:\"7.x-3.0-alpha1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/views/releases/7.x-3.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/views-7.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1294276882\";s:6:\"mdhash\";s:32:\"8635e5b0c03fed4516abae25489a5a5c\";s:8:\"filesize\";s:7:\"1561161\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"7.x-3.x-dev\";a:14:{s:4:\"name\";s:17:\"views 7.x-3.x-dev\";s:7:\"version\";s:11:\"7.x-3.x-dev\";s:3:\"tag\";s:7:\"7.x-3.x\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/views/releases/7.x-3.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/views-7.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1498765443\";s:6:\"mdhash\";s:32:\"685c91d42eee7c9a657dd7cbba6c14c4\";s:8:\"filesize\";s:7:\"1645722\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541600,1500455183,1),('available_releases::views_accordion','a:11:{s:5:\"title\";s:15:\"Views Accordion\";s:10:\"short_name\";s:15:\"views_accordion\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"1\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:46:\"https://www.drupal.org/project/views_accordion\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:5:{s:7:\"7.x-1.1\";a:14:{s:4:\"name\";s:23:\"views_accordion 7.x-1.1\";s:7:\"version\";s:7:\"7.x-1.1\";s:3:\"tag\";s:7:\"7.x-1.1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_accordion/releases/7.x-1.1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_accordion-7.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1422545581\";s:6:\"mdhash\";s:32:\"9ca6496bb8398def4a4b61bd2b15c4c8\";s:8:\"filesize\";s:5:\"14731\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-1.0\";a:14:{s:4:\"name\";s:23:\"views_accordion 7.x-1.0\";s:7:\"version\";s:7:\"7.x-1.0\";s:3:\"tag\";s:7:\"7.x-1.0\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_accordion/releases/7.x-1.0\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_accordion-7.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1394102606\";s:6:\"mdhash\";s:32:\"c7723cb357819a18b1e0d746819dbdc8\";s:8:\"filesize\";s:5:\"14362\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:11:\"7.x-1.0-rc2\";a:15:{s:4:\"name\";s:27:\"views_accordion 7.x-1.0-rc2\";s:7:\"version\";s:11:\"7.x-1.0-rc2\";s:3:\"tag\";s:11:\"7.x-1.0-rc2\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/views_accordion/releases/7.x-1.0-rc2\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/views_accordion-7.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1342687617\";s:6:\"mdhash\";s:32:\"1d15d3a14a1f213efdfc7e09721645eb\";s:8:\"filesize\";s:5:\"14548\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.0-rc1\";a:15:{s:4:\"name\";s:27:\"views_accordion 7.x-1.0-rc1\";s:7:\"version\";s:11:\"7.x-1.0-rc1\";s:3:\"tag\";s:11:\"7.x-1.0-rc1\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:3:\"rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/views_accordion/releases/7.x-1.0-rc1\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/views_accordion-7.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1316625409\";s:6:\"mdhash\";s:32:\"84ca65a3f3b5bf3c696442beec1b24e3\";s:8:\"filesize\";s:5:\"14545\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:27:\"views_accordion 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/views_accordion/releases/7.x-1.x-dev\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/views_accordion-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1490116684\";s:6:\"mdhash\";s:32:\"05d670052f75640a6735dc4f9c3d652c\";s:8:\"filesize\";s:5:\"14751\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541601,1500455183,1),('available_releases::views_slideshow','a:11:{s:5:\"title\";s:15:\"Views Slideshow\";s:10:\"short_name\";s:15:\"views_slideshow\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:17:\"recommended_major\";s:1:\"3\";s:16:\"supported_majors\";s:1:\"3\";s:13:\"default_major\";s:1:\"3\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:46:\"https://www.drupal.org/project/views_slideshow\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:12:{s:7:\"7.x-3.9\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.9\";s:7:\"version\";s:7:\"7.x-3.9\";s:3:\"tag\";s:7:\"7.x-3.9\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.9\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.9.tar.gz\";s:4:\"date\";s:10:\"1496893142\";s:6:\"mdhash\";s:32:\"fc1edcb8ee04923d93cdaa36ca848563\";s:8:\"filesize\";s:5:\"42352\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.8\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.8\";s:7:\"version\";s:7:\"7.x-3.8\";s:3:\"tag\";s:7:\"7.x-3.8\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.8\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.8.tar.gz\";s:4:\"date\";s:10:\"1488825783\";s:6:\"mdhash\";s:32:\"ad0e1665ad39b234df35954f96be4d78\";s:8:\"filesize\";s:5:\"42099\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.7\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.7\";s:7:\"version\";s:7:\"7.x-3.7\";s:3:\"tag\";s:7:\"7.x-3.7\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.7\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.7.tar.gz\";s:4:\"date\";s:10:\"1488323883\";s:6:\"mdhash\";s:32:\"3c9f89add1c975c6820f155a855d109d\";s:8:\"filesize\";s:5:\"41306\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.6\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.6\";s:7:\"version\";s:7:\"7.x-3.6\";s:3:\"tag\";s:7:\"7.x-3.6\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.6\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.6.tar.gz\";s:4:\"date\";s:10:\"1487211484\";s:6:\"mdhash\";s:32:\"cb17433b7585c42c64c4ce4cbaaa186d\";s:8:\"filesize\";s:5:\"40102\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.5\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.5\";s:7:\"version\";s:7:\"7.x-3.5\";s:3:\"tag\";s:7:\"7.x-3.5\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.5\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.5.tar.gz\";s:4:\"date\";s:10:\"1484857383\";s:6:\"mdhash\";s:32:\"3123e0b522aadb07b7e791eea34c27de\";s:8:\"filesize\";s:5:\"38808\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.4\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.4\";s:7:\"version\";s:7:\"7.x-3.4\";s:3:\"tag\";s:7:\"7.x-3.4\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.4\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.4.tar.gz\";s:4:\"date\";s:10:\"1483641842\";s:6:\"mdhash\";s:32:\"c793ed088af5d093df616fee77b86b41\";s:8:\"filesize\";s:5:\"38045\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.3\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.3\";s:7:\"version\";s:7:\"7.x-3.3\";s:3:\"tag\";s:7:\"7.x-3.3\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.3\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.3.tar.gz\";s:4:\"date\";s:10:\"1483562342\";s:6:\"mdhash\";s:32:\"8642510e04bb94fa5e61033b6ed6645c\";s:8:\"filesize\";s:5:\"37849\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.2\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.2\";s:7:\"version\";s:7:\"7.x-3.2\";s:3:\"tag\";s:7:\"7.x-3.2\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.2\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.2.tar.gz\";s:4:\"date\";s:10:\"1482784083\";s:6:\"mdhash\";s:32:\"81adf86198a6a0dc61aa43c961726dbe\";s:8:\"filesize\";s:5:\"37459\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.1\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.1\";s:7:\"version\";s:7:\"7.x-3.1\";s:3:\"tag\";s:7:\"7.x-3.1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.1\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.1.tar.gz\";s:4:\"date\";s:10:\"1382584827\";s:6:\"mdhash\";s:32:\"a807ec5d346350d1f21b84be38480faf\";s:8:\"filesize\";s:5:\"35949\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:7:\"7.x-3.0\";a:14:{s:4:\"name\";s:23:\"views_slideshow 7.x-3.0\";s:7:\"version\";s:7:\"7.x-3.0\";s:3:\"tag\";s:7:\"7.x-3.0\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:63:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.0\";s:13:\"download_link\";s:68:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.0.tar.gz\";s:4:\"date\";s:10:\"1319589616\";s:6:\"mdhash\";s:32:\"6bf9363dacee1b55b97c0294b70b5507\";s:8:\"filesize\";s:5:\"33692\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:0:\"\";}s:14:\"7.x-3.0-alpha1\";a:15:{s:4:\"name\";s:30:\"views_slideshow 7.x-3.0-alpha1\";s:7:\"version\";s:14:\"7.x-3.0-alpha1\";s:3:\"tag\";s:14:\"7.x-3.0-alpha1\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_patch\";s:1:\"0\";s:13:\"version_extra\";s:6:\"alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:70:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.0-alpha1\";s:13:\"download_link\";s:75:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1299893769\";s:6:\"mdhash\";s:32:\"a6b97871bde1ee41b63b60d0953b2e8b\";s:8:\"filesize\";s:5:\"29502\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"7.x-3.x-dev\";a:14:{s:4:\"name\";s:27:\"views_slideshow 7.x-3.x-dev\";s:7:\"version\";s:11:\"7.x-3.x-dev\";s:3:\"tag\";s:7:\"7.x-3.x\";s:13:\"version_major\";s:1:\"3\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:67:\"https://www.drupal.org/project/views_slideshow/releases/7.x-3.x-dev\";s:13:\"download_link\";s:72:\"https://ftp.drupal.org/files/projects/views_slideshow-7.x-3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1496892542\";s:6:\"mdhash\";s:32:\"d61cf9a551b02666350c6b3cc6cf483c\";s:8:\"filesize\";s:5:\"42351\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}}}',1500541602,1500455183,1),('available_releases::we_content_migration','a:10:{s:5:\"title\";s:24:\"Drupal Content Migration\";s:10:\"short_name\";s:20:\"we_content_migration\";s:4:\"type\";s:14:\"project_module\";s:11:\"api_version\";s:3:\"7.x\";s:16:\"supported_majors\";s:1:\"1\";s:13:\"default_major\";s:1:\"1\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:51:\"https://www.drupal.org/project/we_content_migration\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:1:{s:11:\"7.x-1.x-dev\";a:14:{s:4:\"name\";s:32:\"we_content_migration 7.x-1.x-dev\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:3:\"tag\";s:7:\"7.x-1.x\";s:13:\"version_major\";s:1:\"1\";s:13:\"version_extra\";s:3:\"dev\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:72:\"https://www.drupal.org/project/we_content_migration/releases/7.x-1.x-dev\";s:13:\"download_link\";s:77:\"https://ftp.drupal.org/files/projects/we_content_migration-7.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1499677742\";s:6:\"mdhash\";s:32:\"5e6c20f89dc504dbc3bdfe48009e62a1\";s:8:\"filesize\";s:5:\"49548\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:12:\"New features\";}}s:8:\"security\";s:54:\"Project has not opted into security advisory coverage!\";}}}',1500541586,1500455183,1),('fetch_failures','a:0:{}',1500455513,1500455183,1),('fetch_task::addressfield',NULL,0,1500633272,0),('fetch_task::admin_menu',NULL,0,1500633272,0),('fetch_task::colorbox',NULL,0,1500633272,0),('fetch_task::commerce',NULL,0,1500633272,0),('fetch_task::commerce_cart_expiration',NULL,0,1500633272,0),('fetch_task::commerce_paypal',NULL,0,1500633272,0),('fetch_task::ctools',NULL,0,1500633272,0),('fetch_task::date',NULL,0,1500633272,0),('fetch_task::drupal',NULL,0,1500633272,0),('fetch_task::entity',NULL,0,1500633272,0),('fetch_task::entityreference',NULL,0,1500633272,0),('fetch_task::galleryformatter',NULL,0,1500633272,0),('fetch_task::jcarousel',NULL,0,1500633272,0),('fetch_task::jquery_plugin',NULL,0,1500633272,0),('fetch_task::jquery_update',NULL,0,1500633272,0),('fetch_task::libraries',NULL,0,1500633272,0),('fetch_task::locationmap',NULL,0,1500633272,0),('fetch_task::module_filter',NULL,0,1500633272,0),('fetch_task::nucleus',NULL,0,1500633272,0),('fetch_task::pathauto',NULL,0,1500633272,0),('fetch_task::rooms',NULL,0,1500633272,0),('fetch_task::rules',NULL,0,1500633272,0),('fetch_task::site_map',NULL,0,1500633272,0),('fetch_task::superfish',NULL,0,1500633272,0),('fetch_task::token',NULL,0,1500633272,0),('fetch_task::variable',NULL,0,1500455183,0),('fetch_task::views',NULL,0,1500633272,0),('fetch_task::views_accordion',NULL,0,1500633272,0),('fetch_task::views_slideshow',NULL,0,1500633272,0),('fetch_task::we_content_migration',NULL,0,1500633272,0),('update_project_data','a:30:{s:12:\"addressfield\";a:16:{s:4:\"name\";s:12:\"addressfield\";s:4:\"info\";a:6:{s:4:\"name\";s:13:\"Address Field\";s:7:\"package\";s:6:\"Fields\";s:7:\"version\";s:7:\"7.x-1.0\";s:7:\"project\";s:12:\"addressfield\";s:9:\"datestamp\";s:10:\"1421426885\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1421426885\";s:8:\"includes\";a:1:{s:12:\"addressfield\";s:13:\"Address Field\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.0\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:13:\"Address Field\";s:4:\"link\";s:43:\"https://www.drupal.org/project/addressfield\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:10:\"admin_menu\";a:16:{s:4:\"name\";s:10:\"admin_menu\";s:4:\"info\";a:6:{s:4:\"name\";s:19:\"Administration menu\";s:7:\"package\";s:14:\"Administration\";s:7:\"version\";s:11:\"7.x-3.0-rc5\";s:7:\"project\";s:10:\"admin_menu\";s:9:\"datestamp\";s:10:\"1419029284\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1419029284\";s:8:\"includes\";a:2:{s:10:\"admin_menu\";s:19:\"Administration menu\";s:18:\"admin_menu_toolbar\";s:33:\"Administration menu Toolbar style\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:11:\"7.x-3.0-rc5\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:19:\"Administration menu\";s:4:\"link\";s:41:\"https://www.drupal.org/project/admin_menu\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:6:\"drupal\";a:16:{s:4:\"name\";s:6:\"drupal\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Block\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.56\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1498069849\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1498069849\";s:8:\"includes\";a:39:{s:5:\"block\";s:5:\"Block\";s:5:\"color\";s:5:\"Color\";s:7:\"comment\";s:7:\"Comment\";s:7:\"contact\";s:7:\"Contact\";s:10:\"contextual\";s:16:\"Contextual links\";s:9:\"dashboard\";s:9:\"Dashboard\";s:5:\"dblog\";s:16:\"Database logging\";s:5:\"field\";s:5:\"Field\";s:17:\"field_sql_storage\";s:17:\"Field SQL storage\";s:8:\"field_ui\";s:8:\"Field UI\";s:4:\"file\";s:4:\"File\";s:6:\"filter\";s:6:\"Filter\";s:4:\"help\";s:4:\"Help\";s:5:\"image\";s:5:\"Image\";s:4:\"list\";s:4:\"List\";s:6:\"locale\";s:6:\"Locale\";s:4:\"menu\";s:4:\"Menu\";s:4:\"node\";s:4:\"Node\";s:6:\"number\";s:6:\"Number\";s:7:\"options\";s:7:\"Options\";s:7:\"overlay\";s:7:\"Overlay\";s:4:\"path\";s:4:\"Path\";s:3:\"php\";s:10:\"PHP filter\";s:4:\"poll\";s:4:\"Poll\";s:3:\"rdf\";s:3:\"RDF\";s:6:\"search\";s:6:\"Search\";s:8:\"shortcut\";s:8:\"Shortcut\";s:10:\"statistics\";s:10:\"Statistics\";s:6:\"syslog\";s:6:\"Syslog\";s:6:\"system\";s:6:\"System\";s:8:\"taxonomy\";s:8:\"Taxonomy\";s:4:\"text\";s:4:\"Text\";s:7:\"tracker\";s:7:\"Tracker\";s:11:\"translation\";s:19:\"Content translation\";s:7:\"trigger\";s:7:\"Trigger\";s:6:\"update\";s:14:\"Update manager\";s:4:\"user\";s:4:\"User\";s:6:\"bartik\";s:6:\"Bartik\";s:5:\"seven\";s:5:\"Seven\";}s:12:\"project_type\";s:4:\"core\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:4:\"7.56\";s:14:\"existing_major\";s:1:\"7\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:11:\"Drupal core\";s:4:\"link\";s:37:\"https://www.drupal.org/project/drupal\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:8:\"colorbox\";a:16:{s:4:\"name\";s:8:\"colorbox\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Colorbox\";s:7:\"version\";s:8:\"7.x-2.13\";s:7:\"project\";s:8:\"colorbox\";s:9:\"datestamp\";s:10:\"1491291489\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1491291489\";s:8:\"includes\";a:1:{s:8:\"colorbox\";s:8:\"Colorbox\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"7.x-2.13\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:8:\"Colorbox\";s:4:\"link\";s:39:\"https://www.drupal.org/project/colorbox\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:8:\"commerce\";a:16:{s:4:\"name\";s:8:\"commerce\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Commerce\";s:7:\"package\";s:8:\"Commerce\";s:7:\"version\";s:14:\"7.x-1.11+8-dev\";s:7:\"project\";s:8:\"commerce\";s:9:\"datestamp\";s:10:\"1429820283\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1429820283\";s:8:\"includes\";a:18:{s:8:\"commerce\";s:8:\"Commerce\";s:13:\"commerce_cart\";s:4:\"Cart\";s:17:\"commerce_checkout\";s:8:\"Checkout\";s:17:\"commerce_customer\";s:8:\"Customer\";s:20:\"commerce_customer_ui\";s:11:\"Customer UI\";s:18:\"commerce_line_item\";s:9:\"Line Item\";s:21:\"commerce_line_item_ui\";s:12:\"Line Item UI\";s:14:\"commerce_order\";s:5:\"Order\";s:17:\"commerce_order_ui\";s:8:\"Order UI\";s:16:\"commerce_payment\";s:7:\"Payment\";s:19:\"commerce_payment_ui\";s:10:\"Payment UI\";s:14:\"commerce_price\";s:5:\"Price\";s:16:\"commerce_product\";s:7:\"Product\";s:24:\"commerce_product_pricing\";s:15:\"Product Pricing\";s:27:\"commerce_product_pricing_ui\";s:18:\"Product Pricing UI\";s:26:\"commerce_product_reference\";s:17:\"Product Reference\";s:19:\"commerce_product_ui\";s:10:\"Product UI\";s:11:\"commerce_ui\";s:11:\"Commerce UI\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:14:\"7.x-1.11+8-dev\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:3:\"dev\";s:5:\"title\";s:15:\"Drupal Commerce\";s:4:\"link\";s:39:\"https://www.drupal.org/project/commerce\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:24:\"commerce_cart_expiration\";a:16:{s:4:\"name\";s:24:\"commerce_cart_expiration\";s:4:\"info\";a:6:{s:4:\"name\";s:24:\"Commerce Cart Expiration\";s:7:\"package\";s:18:\"Commerce (contrib)\";s:7:\"version\";s:7:\"7.x-1.2\";s:7:\"project\";s:24:\"commerce_cart_expiration\";s:9:\"datestamp\";s:10:\"1417462081\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1417462081\";s:8:\"includes\";a:1:{s:24:\"commerce_cart_expiration\";s:24:\"Commerce Cart Expiration\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.2\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:24:\"Commerce Cart Expiration\";s:4:\"link\";s:55:\"https://www.drupal.org/project/commerce_cart_expiration\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:15:\"commerce_paypal\";a:16:{s:4:\"name\";s:15:\"commerce_paypal\";s:4:\"info\";a:6:{s:4:\"name\";s:6:\"PayPal\";s:7:\"package\";s:17:\"Commerce (PayPal)\";s:7:\"version\";s:7:\"7.x-2.3\";s:7:\"project\";s:15:\"commerce_paypal\";s:9:\"datestamp\";s:10:\"1389740908\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1389740908\";s:8:\"includes\";a:3:{s:15:\"commerce_paypal\";s:6:\"PayPal\";s:19:\"commerce_paypal_wpp\";s:10:\"PayPal WPP\";s:19:\"commerce_paypal_wps\";s:10:\"PayPal WPS\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.3\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:15:\"Commerce PayPal\";s:4:\"link\";s:46:\"https://www.drupal.org/project/commerce_paypal\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:6:\"ctools\";a:16:{s:4:\"name\";s:6:\"ctools\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Chaos tools\";s:7:\"package\";s:16:\"Chaos tool suite\";s:7:\"version\";s:8:\"7.x-1.12\";s:7:\"project\";s:6:\"ctools\";s:9:\"datestamp\";s:10:\"1479787162\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1479787162\";s:8:\"includes\";a:1:{s:6:\"ctools\";s:11:\"Chaos tools\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"7.x-1.12\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:25:\"Chaos tool suite (ctools)\";s:4:\"link\";s:37:\"https://www.drupal.org/project/ctools\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:4:\"date\";a:16:{s:4:\"name\";s:4:\"date\";s:4:\"info\";a:6:{s:4:\"name\";s:4:\"Date\";s:7:\"package\";s:9:\"Date/Time\";s:7:\"version\";s:7:\"7.x-2.8\";s:7:\"project\";s:4:\"date\";s:9:\"datestamp\";s:10:\"1406653438\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1406653438\";s:8:\"includes\";a:5:{s:4:\"date\";s:4:\"Date\";s:12:\"date_all_day\";s:12:\"Date All Day\";s:8:\"date_api\";s:8:\"Date API\";s:10:\"date_popup\";s:10:\"Date Popup\";s:10:\"date_views\";s:10:\"Date Views\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.8\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:4:\"Date\";s:4:\"link\";s:35:\"https://www.drupal.org/project/date\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:6:\"entity\";a:16:{s:4:\"name\";s:6:\"entity\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"Entity API\";s:7:\"version\";s:7:\"7.x-1.6\";s:7:\"project\";s:6:\"entity\";s:9:\"datestamp\";s:10:\"1424876582\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1424876582\";s:8:\"includes\";a:2:{s:6:\"entity\";s:10:\"Entity API\";s:12:\"entity_token\";s:13:\"Entity tokens\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.6\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:10:\"Entity API\";s:4:\"link\";s:37:\"https://www.drupal.org/project/entity\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:15:\"entityreference\";a:16:{s:4:\"name\";s:15:\"entityreference\";s:4:\"info\";a:6:{s:4:\"name\";s:16:\"Entity Reference\";s:7:\"package\";s:6:\"Fields\";s:7:\"version\";s:7:\"7.x-1.1\";s:7:\"project\";s:15:\"entityreference\";s:9:\"datestamp\";s:10:\"1384973110\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1384973110\";s:8:\"includes\";a:1:{s:15:\"entityreference\";s:16:\"Entity Reference\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:16:\"Entity reference\";s:4:\"link\";s:46:\"https://www.drupal.org/project/entityreference\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:16:\"galleryformatter\";a:16:{s:4:\"name\";s:16:\"galleryformatter\";s:4:\"info\";a:6:{s:4:\"name\";s:17:\"Gallery Formatter\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-1.3\";s:7:\"project\";s:16:\"galleryformatter\";s:9:\"datestamp\";s:10:\"1355821655\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1355821655\";s:8:\"includes\";a:1:{s:16:\"galleryformatter\";s:17:\"Gallery Formatter\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.3\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:17:\"Gallery formatter\";s:4:\"link\";s:47:\"https://www.drupal.org/project/galleryformatter\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:9:\"jcarousel\";a:16:{s:4:\"name\";s:9:\"jcarousel\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"jCarousel\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-2.7\";s:7:\"project\";s:9:\"jcarousel\";s:9:\"datestamp\";s:10:\"1420460282\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1420460282\";s:8:\"includes\";a:1:{s:9:\"jcarousel\";s:9:\"jCarousel\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.7\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:9:\"jCarousel\";s:4:\"link\";s:40:\"https://www.drupal.org/project/jcarousel\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:13:\"jquery_plugin\";a:16:{s:4:\"name\";s:13:\"jquery_plugin\";s:4:\"info\";a:6:{s:4:\"name\";s:14:\"jQuery plugins\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-1.0\";s:7:\"project\";s:13:\"jquery_plugin\";s:9:\"datestamp\";s:10:\"1294280182\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1294280182\";s:8:\"includes\";a:1:{s:13:\"jquery_plugin\";s:14:\"jQuery plugins\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.0\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:14:\"jQuery plugins\";s:4:\"link\";s:44:\"https://www.drupal.org/project/jquery_plugin\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:13:\"jquery_update\";a:16:{s:4:\"name\";s:13:\"jquery_update\";s:4:\"info\";a:6:{s:4:\"name\";s:13:\"jQuery Update\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-2.7\";s:7:\"project\";s:13:\"jquery_update\";s:9:\"datestamp\";s:10:\"1445379855\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1445379855\";s:8:\"includes\";a:1:{s:13:\"jquery_update\";s:13:\"jQuery Update\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.7\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:13:\"jQuery Update\";s:4:\"link\";s:44:\"https://www.drupal.org/project/jquery_update\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:9:\"libraries\";a:16:{s:4:\"name\";s:9:\"libraries\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"Libraries\";s:7:\"version\";s:7:\"7.x-2.2\";s:7:\"project\";s:9:\"libraries\";s:9:\"datestamp\";s:10:\"1391965716\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1391965716\";s:8:\"includes\";a:1:{s:9:\"libraries\";s:9:\"Libraries\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.2\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:13:\"Libraries API\";s:4:\"link\";s:40:\"https://www.drupal.org/project/libraries\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:11:\"locationmap\";a:16:{s:4:\"name\";s:11:\"locationmap\";s:4:\"info\";a:6:{s:4:\"name\";s:12:\"Location Map\";s:7:\"version\";s:7:\"7.x-2.5\";s:7:\"project\";s:11:\"locationmap\";s:9:\"datestamp\";s:10:\"1488545391\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1488545391\";s:8:\"includes\";a:1:{s:11:\"locationmap\";s:12:\"Location Map\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.5\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:12:\"Location Map\";s:4:\"link\";s:42:\"https://www.drupal.org/project/locationmap\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:13:\"module_filter\";a:16:{s:4:\"name\";s:13:\"module_filter\";s:4:\"info\";a:6:{s:4:\"name\";s:13:\"Module filter\";s:7:\"package\";s:14:\"Administration\";s:7:\"version\";s:7:\"7.x-2.1\";s:7:\"project\";s:13:\"module_filter\";s:9:\"datestamp\";s:10:\"1497029349\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1497029349\";s:8:\"includes\";a:1:{s:13:\"module_filter\";s:13:\"Module filter\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.1\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:13:\"Module Filter\";s:4:\"link\";s:44:\"https://www.drupal.org/project/module_filter\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:8:\"pathauto\";a:16:{s:4:\"name\";s:8:\"pathauto\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Pathauto\";s:7:\"version\";s:7:\"7.x-1.2\";s:7:\"project\";s:8:\"pathauto\";s:9:\"datestamp\";s:10:\"1344525185\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1344525185\";s:8:\"includes\";a:1:{s:8:\"pathauto\";s:8:\"Pathauto\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.2\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:8:\"Pathauto\";s:4:\"link\";s:39:\"https://www.drupal.org/project/pathauto\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:5:\"rooms\";a:16:{s:4:\"name\";s:5:\"rooms\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Rooms\";s:7:\"package\";s:5:\"Rooms\";s:7:\"version\";s:7:\"7.x-1.4\";s:7:\"project\";s:5:\"rooms\";s:9:\"datestamp\";s:10:\"1422616810\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1422616810\";s:8:\"includes\";a:8:{s:5:\"rooms\";s:5:\"Rooms\";s:18:\"rooms_availability\";s:18:\"Rooms Availability\";s:28:\"rooms_availability_reference\";s:28:\"Rooms Availability Reference\";s:13:\"rooms_booking\";s:13:\"Rooms Booking\";s:21:\"rooms_booking_manager\";s:21:\"Rooms Booking Manager\";s:13:\"rooms_pricing\";s:13:\"Rooms Pricing\";s:8:\"rooms_ui\";s:8:\"Rooms UI\";s:10:\"rooms_unit\";s:10:\"Rooms Unit\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.4\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:64:\"Rooms - Drupal Booking for Hotels, B&amp;Bs and Vacation Rentals\";s:4:\"link\";s:36:\"https://www.drupal.org/project/rooms\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:5:\"rules\";a:16:{s:4:\"name\";s:5:\"rules\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Rules\";s:7:\"package\";s:5:\"Rules\";s:7:\"version\";s:7:\"7.x-2.9\";s:7:\"project\";s:5:\"rules\";s:9:\"datestamp\";s:10:\"1426527210\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1426527210\";s:8:\"includes\";a:2:{s:5:\"rules\";s:5:\"Rules\";s:11:\"rules_admin\";s:8:\"Rules UI\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.9\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:5:\"Rules\";s:4:\"link\";s:36:\"https://www.drupal.org/project/rules\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:8:\"site_map\";a:16:{s:4:\"name\";s:8:\"site_map\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Site map\";s:7:\"version\";s:7:\"7.x-1.2\";s:7:\"project\";s:8:\"site_map\";s:9:\"datestamp\";s:10:\"1393897705\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1393897705\";s:8:\"includes\";a:1:{s:8:\"site_map\";s:8:\"Site map\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.2\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:8:\"Site map\";s:4:\"link\";s:39:\"https://www.drupal.org/project/site_map\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:9:\"superfish\";a:16:{s:4:\"name\";s:9:\"superfish\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"Superfish\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-1.9\";s:7:\"project\";s:9:\"superfish\";s:9:\"datestamp\";s:10:\"1367054112\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1367054112\";s:8:\"includes\";a:1:{s:9:\"superfish\";s:9:\"Superfish\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.9\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:9:\"Superfish\";s:4:\"link\";s:40:\"https://www.drupal.org/project/superfish\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:5:\"token\";a:16:{s:4:\"name\";s:5:\"token\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Token\";s:7:\"version\";s:7:\"7.x-1.6\";s:7:\"project\";s:5:\"token\";s:9:\"datestamp\";s:10:\"1425149060\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1425149060\";s:8:\"includes\";a:1:{s:5:\"token\";s:5:\"Token\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.6\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:5:\"Token\";s:4:\"link\";s:36:\"https://www.drupal.org/project/token\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:8:\"variable\";a:16:{s:4:\"name\";s:8:\"variable\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Variable\";s:7:\"package\";s:8:\"Variable\";s:7:\"version\";s:7:\"7.x-2.5\";s:7:\"project\";s:8:\"variable\";s:9:\"datestamp\";s:10:\"1398250128\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1398250128\";s:8:\"includes\";a:1:{s:8:\"variable\";s:8:\"Variable\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-2.5\";s:14:\"existing_major\";s:1:\"2\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:8:\"Variable\";s:4:\"link\";s:39:\"https://www.drupal.org/project/variable\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:5:\"views\";a:16:{s:4:\"name\";s:5:\"views\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Views\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:8:\"7.x-3.16\";s:7:\"project\";s:5:\"views\";s:9:\"datestamp\";s:10:\"1491158591\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1491158591\";s:8:\"includes\";a:2:{s:5:\"views\";s:5:\"Views\";s:8:\"views_ui\";s:8:\"Views UI\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:8:\"7.x-3.16\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:5:\"Views\";s:4:\"link\";s:36:\"https://www.drupal.org/project/views\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:15:\"views_accordion\";a:16:{s:4:\"name\";s:15:\"views_accordion\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views Accordion\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"7.x-1.1\";s:7:\"project\";s:15:\"views_accordion\";s:9:\"datestamp\";s:10:\"1422545700\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1422545700\";s:8:\"includes\";a:1:{s:15:\"views_accordion\";s:15:\"Views Accordion\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.1\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:15:\"Views Accordion\";s:4:\"link\";s:46:\"https://www.drupal.org/project/views_accordion\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:15:\"views_slideshow\";a:16:{s:4:\"name\";s:15:\"views_slideshow\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views Slideshow\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"7.x-3.1\";s:7:\"project\";s:15:\"views_slideshow\";s:9:\"datestamp\";s:10:\"1382584826\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1382584826\";s:8:\"includes\";a:2:{s:15:\"views_slideshow\";s:15:\"Views Slideshow\";s:21:\"views_slideshow_cycle\";s:22:\"Views Slideshow: Cycle\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-3.1\";s:14:\"existing_major\";s:1:\"3\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:15:\"Views Slideshow\";s:4:\"link\";s:46:\"https://www.drupal.org/project/views_slideshow\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:20:\"we_content_migration\";a:16:{s:4:\"name\";s:20:\"we_content_migration\";s:4:\"info\";a:6:{s:4:\"name\";s:17:\"Content Migration\";s:7:\"package\";s:17:\"Content Migration\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:7:\"project\";s:20:\"we_content_migration\";s:9:\"datestamp\";s:10:\"1499677744\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1499677744\";s:8:\"includes\";a:1:{s:20:\"we_content_migration\";s:17:\"Content Migration\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:11:\"7.x-1.x-dev\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:3:\"dev\";s:5:\"title\";s:24:\"Drupal Content Migration\";s:4:\"link\";s:51:\"https://www.drupal.org/project/we_content_migration\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}s:7:\"nucleus\";a:16:{s:4:\"name\";s:7:\"nucleus\";s:4:\"info\";a:5:{s:4:\"name\";s:7:\"nucleus\";s:7:\"version\";s:7:\"7.x-1.4\";s:7:\"project\";s:7:\"nucleus\";s:9:\"datestamp\";s:10:\"1375072568\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1375072568\";s:8:\"includes\";a:1:{s:7:\"nucleus\";s:7:\"nucleus\";}s:12:\"project_type\";s:5:\"theme\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:1:{s:5:\"hotel\";s:5:\"Hotel\";}s:11:\"base_themes\";a:0:{}s:16:\"existing_version\";s:7:\"7.x-1.4\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:10:\"TB Nucleus\";s:4:\"link\";s:38:\"https://www.drupal.org/project/nucleus\";s:6:\"status\";i:-4;s:6:\"reason\";s:24:\"No available update data\";s:12:\"fetch_status\";i:-4;}}',1509944164,1509940564,1),('update_project_projects','a:30:{s:12:\"addressfield\";a:8:{s:4:\"name\";s:12:\"addressfield\";s:4:\"info\";a:6:{s:4:\"name\";s:13:\"Address Field\";s:7:\"package\";s:6:\"Fields\";s:7:\"version\";s:7:\"7.x-1.0\";s:7:\"project\";s:12:\"addressfield\";s:9:\"datestamp\";s:10:\"1421426885\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1421426885\";s:8:\"includes\";a:1:{s:12:\"addressfield\";s:13:\"Address Field\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:10:\"admin_menu\";a:8:{s:4:\"name\";s:10:\"admin_menu\";s:4:\"info\";a:6:{s:4:\"name\";s:19:\"Administration menu\";s:7:\"package\";s:14:\"Administration\";s:7:\"version\";s:11:\"7.x-3.0-rc5\";s:7:\"project\";s:10:\"admin_menu\";s:9:\"datestamp\";s:10:\"1419029284\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1419029284\";s:8:\"includes\";a:2:{s:10:\"admin_menu\";s:19:\"Administration menu\";s:18:\"admin_menu_toolbar\";s:33:\"Administration menu Toolbar style\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:6:\"drupal\";a:8:{s:4:\"name\";s:6:\"drupal\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Block\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.56\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1498069849\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1498069849\";s:8:\"includes\";a:39:{s:5:\"block\";s:5:\"Block\";s:5:\"color\";s:5:\"Color\";s:7:\"comment\";s:7:\"Comment\";s:7:\"contact\";s:7:\"Contact\";s:10:\"contextual\";s:16:\"Contextual links\";s:9:\"dashboard\";s:9:\"Dashboard\";s:5:\"dblog\";s:16:\"Database logging\";s:5:\"field\";s:5:\"Field\";s:17:\"field_sql_storage\";s:17:\"Field SQL storage\";s:8:\"field_ui\";s:8:\"Field UI\";s:4:\"file\";s:4:\"File\";s:6:\"filter\";s:6:\"Filter\";s:4:\"help\";s:4:\"Help\";s:5:\"image\";s:5:\"Image\";s:4:\"list\";s:4:\"List\";s:6:\"locale\";s:6:\"Locale\";s:4:\"menu\";s:4:\"Menu\";s:4:\"node\";s:4:\"Node\";s:6:\"number\";s:6:\"Number\";s:7:\"options\";s:7:\"Options\";s:7:\"overlay\";s:7:\"Overlay\";s:4:\"path\";s:4:\"Path\";s:3:\"php\";s:10:\"PHP filter\";s:4:\"poll\";s:4:\"Poll\";s:3:\"rdf\";s:3:\"RDF\";s:6:\"search\";s:6:\"Search\";s:8:\"shortcut\";s:8:\"Shortcut\";s:10:\"statistics\";s:10:\"Statistics\";s:6:\"syslog\";s:6:\"Syslog\";s:6:\"system\";s:6:\"System\";s:8:\"taxonomy\";s:8:\"Taxonomy\";s:4:\"text\";s:4:\"Text\";s:7:\"tracker\";s:7:\"Tracker\";s:11:\"translation\";s:19:\"Content translation\";s:7:\"trigger\";s:7:\"Trigger\";s:6:\"update\";s:14:\"Update manager\";s:4:\"user\";s:4:\"User\";s:6:\"bartik\";s:6:\"Bartik\";s:5:\"seven\";s:5:\"Seven\";}s:12:\"project_type\";s:4:\"core\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"colorbox\";a:8:{s:4:\"name\";s:8:\"colorbox\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Colorbox\";s:7:\"version\";s:8:\"7.x-2.13\";s:7:\"project\";s:8:\"colorbox\";s:9:\"datestamp\";s:10:\"1491291489\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1491291489\";s:8:\"includes\";a:1:{s:8:\"colorbox\";s:8:\"Colorbox\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"commerce\";a:8:{s:4:\"name\";s:8:\"commerce\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Commerce\";s:7:\"package\";s:8:\"Commerce\";s:7:\"version\";s:14:\"7.x-1.11+8-dev\";s:7:\"project\";s:8:\"commerce\";s:9:\"datestamp\";s:10:\"1429820283\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1429820283\";s:8:\"includes\";a:18:{s:8:\"commerce\";s:8:\"Commerce\";s:13:\"commerce_cart\";s:4:\"Cart\";s:17:\"commerce_checkout\";s:8:\"Checkout\";s:17:\"commerce_customer\";s:8:\"Customer\";s:20:\"commerce_customer_ui\";s:11:\"Customer UI\";s:18:\"commerce_line_item\";s:9:\"Line Item\";s:21:\"commerce_line_item_ui\";s:12:\"Line Item UI\";s:14:\"commerce_order\";s:5:\"Order\";s:17:\"commerce_order_ui\";s:8:\"Order UI\";s:16:\"commerce_payment\";s:7:\"Payment\";s:19:\"commerce_payment_ui\";s:10:\"Payment UI\";s:14:\"commerce_price\";s:5:\"Price\";s:16:\"commerce_product\";s:7:\"Product\";s:24:\"commerce_product_pricing\";s:15:\"Product Pricing\";s:27:\"commerce_product_pricing_ui\";s:18:\"Product Pricing UI\";s:26:\"commerce_product_reference\";s:17:\"Product Reference\";s:19:\"commerce_product_ui\";s:10:\"Product UI\";s:11:\"commerce_ui\";s:11:\"Commerce UI\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:24:\"commerce_cart_expiration\";a:8:{s:4:\"name\";s:24:\"commerce_cart_expiration\";s:4:\"info\";a:6:{s:4:\"name\";s:24:\"Commerce Cart Expiration\";s:7:\"package\";s:18:\"Commerce (contrib)\";s:7:\"version\";s:7:\"7.x-1.2\";s:7:\"project\";s:24:\"commerce_cart_expiration\";s:9:\"datestamp\";s:10:\"1417462081\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1417462081\";s:8:\"includes\";a:1:{s:24:\"commerce_cart_expiration\";s:24:\"Commerce Cart Expiration\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"commerce_paypal\";a:8:{s:4:\"name\";s:15:\"commerce_paypal\";s:4:\"info\";a:6:{s:4:\"name\";s:6:\"PayPal\";s:7:\"package\";s:17:\"Commerce (PayPal)\";s:7:\"version\";s:7:\"7.x-2.3\";s:7:\"project\";s:15:\"commerce_paypal\";s:9:\"datestamp\";s:10:\"1389740908\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1389740908\";s:8:\"includes\";a:3:{s:15:\"commerce_paypal\";s:6:\"PayPal\";s:19:\"commerce_paypal_wpp\";s:10:\"PayPal WPP\";s:19:\"commerce_paypal_wps\";s:10:\"PayPal WPS\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:6:\"ctools\";a:8:{s:4:\"name\";s:6:\"ctools\";s:4:\"info\";a:6:{s:4:\"name\";s:11:\"Chaos tools\";s:7:\"package\";s:16:\"Chaos tool suite\";s:7:\"version\";s:8:\"7.x-1.12\";s:7:\"project\";s:6:\"ctools\";s:9:\"datestamp\";s:10:\"1479787162\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1479787162\";s:8:\"includes\";a:1:{s:6:\"ctools\";s:11:\"Chaos tools\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:4:\"date\";a:8:{s:4:\"name\";s:4:\"date\";s:4:\"info\";a:6:{s:4:\"name\";s:4:\"Date\";s:7:\"package\";s:9:\"Date/Time\";s:7:\"version\";s:7:\"7.x-2.8\";s:7:\"project\";s:4:\"date\";s:9:\"datestamp\";s:10:\"1406653438\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1406653438\";s:8:\"includes\";a:5:{s:4:\"date\";s:4:\"Date\";s:12:\"date_all_day\";s:12:\"Date All Day\";s:8:\"date_api\";s:8:\"Date API\";s:10:\"date_popup\";s:10:\"Date Popup\";s:10:\"date_views\";s:10:\"Date Views\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:6:\"entity\";a:8:{s:4:\"name\";s:6:\"entity\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"Entity API\";s:7:\"version\";s:7:\"7.x-1.6\";s:7:\"project\";s:6:\"entity\";s:9:\"datestamp\";s:10:\"1424876582\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1424876582\";s:8:\"includes\";a:2:{s:6:\"entity\";s:10:\"Entity API\";s:12:\"entity_token\";s:13:\"Entity tokens\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"entityreference\";a:8:{s:4:\"name\";s:15:\"entityreference\";s:4:\"info\";a:6:{s:4:\"name\";s:16:\"Entity Reference\";s:7:\"package\";s:6:\"Fields\";s:7:\"version\";s:7:\"7.x-1.1\";s:7:\"project\";s:15:\"entityreference\";s:9:\"datestamp\";s:10:\"1384973110\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1384973110\";s:8:\"includes\";a:1:{s:15:\"entityreference\";s:16:\"Entity Reference\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:16:\"galleryformatter\";a:8:{s:4:\"name\";s:16:\"galleryformatter\";s:4:\"info\";a:6:{s:4:\"name\";s:17:\"Gallery Formatter\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-1.3\";s:7:\"project\";s:16:\"galleryformatter\";s:9:\"datestamp\";s:10:\"1355821655\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1355821655\";s:8:\"includes\";a:1:{s:16:\"galleryformatter\";s:17:\"Gallery Formatter\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:9:\"jcarousel\";a:8:{s:4:\"name\";s:9:\"jcarousel\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"jCarousel\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-2.7\";s:7:\"project\";s:9:\"jcarousel\";s:9:\"datestamp\";s:10:\"1420460282\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1420460282\";s:8:\"includes\";a:1:{s:9:\"jcarousel\";s:9:\"jCarousel\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:13:\"jquery_plugin\";a:8:{s:4:\"name\";s:13:\"jquery_plugin\";s:4:\"info\";a:6:{s:4:\"name\";s:14:\"jQuery plugins\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-1.0\";s:7:\"project\";s:13:\"jquery_plugin\";s:9:\"datestamp\";s:10:\"1294280182\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1294280182\";s:8:\"includes\";a:1:{s:13:\"jquery_plugin\";s:14:\"jQuery plugins\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:13:\"jquery_update\";a:8:{s:4:\"name\";s:13:\"jquery_update\";s:4:\"info\";a:6:{s:4:\"name\";s:13:\"jQuery Update\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-2.7\";s:7:\"project\";s:13:\"jquery_update\";s:9:\"datestamp\";s:10:\"1445379855\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1445379855\";s:8:\"includes\";a:1:{s:13:\"jquery_update\";s:13:\"jQuery Update\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:9:\"libraries\";a:8:{s:4:\"name\";s:9:\"libraries\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"Libraries\";s:7:\"version\";s:7:\"7.x-2.2\";s:7:\"project\";s:9:\"libraries\";s:9:\"datestamp\";s:10:\"1391965716\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1391965716\";s:8:\"includes\";a:1:{s:9:\"libraries\";s:9:\"Libraries\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:11:\"locationmap\";a:8:{s:4:\"name\";s:11:\"locationmap\";s:4:\"info\";a:6:{s:4:\"name\";s:12:\"Location Map\";s:7:\"version\";s:7:\"7.x-2.5\";s:7:\"project\";s:11:\"locationmap\";s:9:\"datestamp\";s:10:\"1488545391\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1488545391\";s:8:\"includes\";a:1:{s:11:\"locationmap\";s:12:\"Location Map\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:13:\"module_filter\";a:8:{s:4:\"name\";s:13:\"module_filter\";s:4:\"info\";a:6:{s:4:\"name\";s:13:\"Module filter\";s:7:\"package\";s:14:\"Administration\";s:7:\"version\";s:7:\"7.x-2.1\";s:7:\"project\";s:13:\"module_filter\";s:9:\"datestamp\";s:10:\"1497029349\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1497029349\";s:8:\"includes\";a:1:{s:13:\"module_filter\";s:13:\"Module filter\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"pathauto\";a:8:{s:4:\"name\";s:8:\"pathauto\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Pathauto\";s:7:\"version\";s:7:\"7.x-1.2\";s:7:\"project\";s:8:\"pathauto\";s:9:\"datestamp\";s:10:\"1344525185\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1344525185\";s:8:\"includes\";a:1:{s:8:\"pathauto\";s:8:\"Pathauto\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"rooms\";a:8:{s:4:\"name\";s:5:\"rooms\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Rooms\";s:7:\"package\";s:5:\"Rooms\";s:7:\"version\";s:7:\"7.x-1.4\";s:7:\"project\";s:5:\"rooms\";s:9:\"datestamp\";s:10:\"1422616810\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1422616810\";s:8:\"includes\";a:8:{s:5:\"rooms\";s:5:\"Rooms\";s:18:\"rooms_availability\";s:18:\"Rooms Availability\";s:28:\"rooms_availability_reference\";s:28:\"Rooms Availability Reference\";s:13:\"rooms_booking\";s:13:\"Rooms Booking\";s:21:\"rooms_booking_manager\";s:21:\"Rooms Booking Manager\";s:13:\"rooms_pricing\";s:13:\"Rooms Pricing\";s:8:\"rooms_ui\";s:8:\"Rooms UI\";s:10:\"rooms_unit\";s:10:\"Rooms Unit\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"rules\";a:8:{s:4:\"name\";s:5:\"rules\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Rules\";s:7:\"package\";s:5:\"Rules\";s:7:\"version\";s:7:\"7.x-2.9\";s:7:\"project\";s:5:\"rules\";s:9:\"datestamp\";s:10:\"1426527210\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1426527210\";s:8:\"includes\";a:2:{s:5:\"rules\";s:5:\"Rules\";s:11:\"rules_admin\";s:8:\"Rules UI\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"site_map\";a:8:{s:4:\"name\";s:8:\"site_map\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Site map\";s:7:\"version\";s:7:\"7.x-1.2\";s:7:\"project\";s:8:\"site_map\";s:9:\"datestamp\";s:10:\"1393897705\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1393897705\";s:8:\"includes\";a:1:{s:8:\"site_map\";s:8:\"Site map\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:9:\"superfish\";a:8:{s:4:\"name\";s:9:\"superfish\";s:4:\"info\";a:6:{s:4:\"name\";s:9:\"Superfish\";s:7:\"package\";s:14:\"User interface\";s:7:\"version\";s:7:\"7.x-1.9\";s:7:\"project\";s:9:\"superfish\";s:9:\"datestamp\";s:10:\"1367054112\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1367054112\";s:8:\"includes\";a:1:{s:9:\"superfish\";s:9:\"Superfish\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"token\";a:8:{s:4:\"name\";s:5:\"token\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Token\";s:7:\"version\";s:7:\"7.x-1.6\";s:7:\"project\";s:5:\"token\";s:9:\"datestamp\";s:10:\"1425149060\";s:7:\"package\";s:5:\"Other\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1425149060\";s:8:\"includes\";a:1:{s:5:\"token\";s:5:\"Token\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:8:\"variable\";a:8:{s:4:\"name\";s:8:\"variable\";s:4:\"info\";a:6:{s:4:\"name\";s:8:\"Variable\";s:7:\"package\";s:8:\"Variable\";s:7:\"version\";s:7:\"7.x-2.5\";s:7:\"project\";s:8:\"variable\";s:9:\"datestamp\";s:10:\"1398250128\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1398250128\";s:8:\"includes\";a:1:{s:8:\"variable\";s:8:\"Variable\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:5:\"views\";a:8:{s:4:\"name\";s:5:\"views\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Views\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:8:\"7.x-3.16\";s:7:\"project\";s:5:\"views\";s:9:\"datestamp\";s:10:\"1491158591\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1491158591\";s:8:\"includes\";a:2:{s:5:\"views\";s:5:\"Views\";s:8:\"views_ui\";s:8:\"Views UI\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"views_accordion\";a:8:{s:4:\"name\";s:15:\"views_accordion\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views Accordion\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"7.x-1.1\";s:7:\"project\";s:15:\"views_accordion\";s:9:\"datestamp\";s:10:\"1422545700\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1422545700\";s:8:\"includes\";a:1:{s:15:\"views_accordion\";s:15:\"Views Accordion\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:15:\"views_slideshow\";a:8:{s:4:\"name\";s:15:\"views_slideshow\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"Views Slideshow\";s:7:\"package\";s:5:\"Views\";s:7:\"version\";s:7:\"7.x-3.1\";s:7:\"project\";s:15:\"views_slideshow\";s:9:\"datestamp\";s:10:\"1382584826\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1382584826\";s:8:\"includes\";a:2:{s:15:\"views_slideshow\";s:15:\"Views Slideshow\";s:21:\"views_slideshow_cycle\";s:22:\"Views Slideshow: Cycle\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:20:\"we_content_migration\";a:8:{s:4:\"name\";s:20:\"we_content_migration\";s:4:\"info\";a:6:{s:4:\"name\";s:17:\"Content Migration\";s:7:\"package\";s:17:\"Content Migration\";s:7:\"version\";s:11:\"7.x-1.x-dev\";s:7:\"project\";s:20:\"we_content_migration\";s:9:\"datestamp\";s:10:\"1499677744\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1499677744\";s:8:\"includes\";a:1:{s:20:\"we_content_migration\";s:17:\"Content Migration\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:0:{}s:11:\"base_themes\";a:0:{}}s:7:\"nucleus\";a:8:{s:4:\"name\";s:7:\"nucleus\";s:4:\"info\";a:5:{s:4:\"name\";s:7:\"nucleus\";s:7:\"version\";s:7:\"7.x-1.4\";s:7:\"project\";s:7:\"nucleus\";s:9:\"datestamp\";s:10:\"1375072568\";s:16:\"_info_file_ctime\";i:1500455029;}s:9:\"datestamp\";s:10:\"1375072568\";s:8:\"includes\";a:1:{s:7:\"nucleus\";s:7:\"nucleus\";}s:12:\"project_type\";s:5:\"theme\";s:14:\"project_status\";b:1;s:10:\"sub_themes\";a:1:{s:5:\"hotel\";s:5:\"Hotel\";}s:11:\"base_themes\";a:0:{}}}',1509944164,1509940564,1);
/*!40000 ALTER TABLE `cache_update` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_variable`
--

DROP TABLE IF EXISTS `cache_variable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_variable` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for variables.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_variable`
--

LOCK TABLES `cache_variable` WRITE;
/*!40000 ALTER TABLE `cache_variable` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_variable` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_views`
--

DROP TABLE IF EXISTS `cache_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_views` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_views`
--

LOCK TABLES `cache_views` WRITE;
/*!40000 ALTER TABLE `cache_views` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_views` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_views_data`
--

DROP TABLE IF EXISTS `cache_views_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_views_data` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for views to store pre-rendered queries,...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_views_data`
--

LOCK TABLES `cache_views_data` WRITE;
/*!40000 ALTER TABLE `cache_views_data` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `cache_views_data` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `comment`
--

DROP TABLE IF EXISTS `comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comment` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique comment ID.',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid to which this comment is a reply.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid who authored the comment. If set to 0, this comment was created by an anonymous user.',
  `subject` varchar(64) NOT NULL DEFAULT '' COMMENT 'The comment title.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The author’s host name.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was created, as a Unix timestamp.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was last edited, as a Unix timestamp.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The published status of a comment. (0 = Not Published, 1 = Published)',
  `thread` varchar(255) NOT NULL COMMENT 'The vancode representation of the comment’s place in a thread.',
  `name` varchar(60) DEFAULT NULL COMMENT 'The comment author’s name. Uses users.name if the user is logged in, otherwise uses the value typed into the comment form.',
  `mail` varchar(64) DEFAULT NULL COMMENT 'The comment author’s e-mail address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `homepage` varchar(255) DEFAULT NULL COMMENT 'The comment author’s home page address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this comment.',
  PRIMARY KEY (`cid`),
  KEY `comment_status_pid` (`pid`,`status`),
  KEY `comment_num_new` (`nid`,`status`,`created`,`cid`,`thread`),
  KEY `comment_uid` (`uid`),
  KEY `comment_nid_language` (`nid`,`language`),
  KEY `comment_created` (`created`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Stores comments and associated data.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comment`
--

LOCK TABLES `comment` WRITE;
/*!40000 ALTER TABLE `comment` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `comment` VALUES (1,0,2,1,'Sed lectus eros','127.0.0.1',1341022600,1341022599,1,'01/','admin','','','und');
/*!40000 ALTER TABLE `comment` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_calculated_price`
--

DROP TABLE IF EXISTS `commerce_calculated_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_calculated_price` (
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module performing the calculation.',
  `module_key` mediumtext NOT NULL COMMENT 'A module specific key useful for indicating the context of a particular calculation, e.g. the IDs of Rules evaluated to produce the calculated price.',
  `entity_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The type of entity this price belongs to.',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The entity ID of the object this price belongs to.',
  `field_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The name of the field the calculated price relates to.',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The languages.language of the entity.',
  `delta` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sequence number for this data item, used for multi-value fields',
  `amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `data` longtext COMMENT 'A serialized array of additional price data.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the price was calculated.',
  KEY `module` (`module`),
  KEY `entity_type` (`entity_type`),
  KEY `entity_id` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores pre-calculated dynamic prices.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_calculated_price`
--

LOCK TABLES `commerce_calculated_price` WRITE;
/*!40000 ALTER TABLE `commerce_calculated_price` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `commerce_calculated_price` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_checkout_pane`
--

DROP TABLE IF EXISTS `commerce_checkout_pane`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_checkout_pane` (
  `pane_id` varchar(255) NOT NULL COMMENT 'The machine readable name of the order state.',
  `page` varchar(255) NOT NULL DEFAULT '1' COMMENT 'The ID of the checkout page on which this pane appears.',
  `fieldset` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean value indicating whether or not the pane should appear in a fieldset.',
  `collapsible` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean value indicating whether or not the pane should appear collapsed.',
  `collapsed` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean value indicating whether or not the pane should appear collapsed.',
  `weight` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The sorting weight of the status for lists of statuses.',
  `enabled` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean value indicating whether or not the pane is enabled.',
  `review` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean value indicating whether or not the pane should appear on the checkout review.',
  PRIMARY KEY (`pane_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Checkout pane configuration data.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_checkout_pane`
--

LOCK TABLES `commerce_checkout_pane` WRITE;
/*!40000 ALTER TABLE `commerce_checkout_pane` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `commerce_checkout_pane` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_customer_profile`
--

DROP TABLE IF EXISTS `commerce_customer_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_customer_profile` (
  `profile_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a customer profile.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_customer_profile_revision.revision_id version identifier.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The commerce_customer_profile_type.type of this profile.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that this profile belongs to.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the profile is active or not.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the profile was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the profile was most recently saved.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`profile_id`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `uid` (`uid`),
  KEY `customer_profile_type` (`type`),
  KEY `uid_by_type` (`uid`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='The base table for customer profiles.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_customer_profile`
--

LOCK TABLES `commerce_customer_profile` WRITE;
/*!40000 ALTER TABLE `commerce_customer_profile` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_customer_profile` VALUES (1,1,'billing',1,1,1339919524,1339919524,NULL),(2,2,'billing',1,1,1339922341,1340030143,'b:0;'),(3,3,'billing',1,1,1340030642,1340030642,NULL),(4,4,'billing',1,1,1340031977,1340031977,NULL);
/*!40000 ALTER TABLE `commerce_customer_profile` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_customer_profile_revision`
--

DROP TABLE IF EXISTS `commerce_customer_profile_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_customer_profile_revision` (
  `profile_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_customer_profile.customer_id of the profile this revision belongs to.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this revision.',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this profile at this revision.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the profile is active or not.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`revision_id`),
  KEY `profile_id` (`profile_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_customer_profile_revision`
--

LOCK TABLES `commerce_customer_profile_revision` WRITE;
/*!40000 ALTER TABLE `commerce_customer_profile_revision` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_customer_profile_revision` VALUES (1,1,1,1,'',1339919524,NULL),(2,2,1,1,'',1340030143,'b:0;'),(3,3,1,1,'',1340030642,NULL),(4,4,1,1,'',1340031977,NULL);
/*!40000 ALTER TABLE `commerce_customer_profile_revision` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_line_item`
--

DROP TABLE IF EXISTS `commerce_line_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_line_item` (
  `line_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a line item.',
  `order_id` int(11) NOT NULL DEFAULT '0' COMMENT 'The unique ID of the order the line item belongs to.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The module defined type of this line item.',
  `line_item_label` varchar(255) NOT NULL COMMENT 'The merchant defined label for a line item.',
  `quantity` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the line item was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the line item was most recently saved.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`line_item_id`),
  KEY `order_id` (`order_id`),
  KEY `line_item_type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='The base table for line items.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_line_item`
--

LOCK TABLES `commerce_line_item` WRITE;
/*!40000 ALTER TABLE `commerce_line_item` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_line_item` VALUES (4,1,'rooms_booking','Booking for Basic Suite (7 Nights; Arrival: 2012-06-21 Departure: 2012-06-28)',1.00,1339919449,1339919449,'a:0:{}'),(5,2,'rooms_booking','Booking for Royal Suite (11 Nights; Arrival: 2012-06-18 Departure: 2012-06-29)',1.00,1339921103,1339921103,'a:0:{}'),(6,2,'rooms_booking','Booking for Basic Suite (11 Nights; Arrival: 2012-06-18 Departure: 2012-06-29)',1.00,1339921137,1339921137,'a:0:{}'),(7,2,'rooms_booking','Booking for Royal Suite (11 Nights; Arrival: 2012-06-19 Departure: 2012-06-30)',1.00,1340028175,1340028175,'a:0:{}'),(8,3,'rooms_booking','Booking for Luxury Suite (10 Nights; Arrival: 2012-06-19 Departure: 2012-06-29)',1.00,1340030517,1340030517,'a:0:{}'),(9,3,'rooms_booking','Booking for Luxury Suite (10 Nights; Arrival: 2012-06-20 Departure: 2012-06-30)',1.00,1340030585,1340030585,'a:0:{}'),(11,4,'rooms_booking','Booking for Royal Suite (12 Nights; Arrival: 2012-06-19 Departure: 2012-07-31)',1.00,1340031948,1340031948,'a:0:{}'),(16,7,'rooms_booking','Booking for Royal Suite (42 Nights; Arrival: 2017-07-20 Departure: 2017-08-31)',1.00,1500455265,1500455265,'a:0:{}');
/*!40000 ALTER TABLE `commerce_line_item` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_order`
--

DROP TABLE IF EXISTS `commerce_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an order.',
  `order_number` varchar(255) DEFAULT NULL COMMENT 'The order number displayed to the customer.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_order_revision.revision_id version identifier.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The type of this order.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns this order.',
  `mail` varchar(255) NOT NULL DEFAULT '' COMMENT 'The e-mail address associated with the order.',
  `status` varchar(255) NOT NULL COMMENT 'The status name of this order.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the order was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the order was most recently saved.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The IP address that created this order.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_number` (`order_number`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='The base table for orders.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_order`
--

LOCK TABLES `commerce_order` WRITE;
/*!40000 ALTER TABLE `commerce_order` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_order` VALUES (1,'1',10,'commerce_order',1,'you@yourdomain.com','pending',1339774881,1339919538,'127.0.0.1','a:0:{}'),(2,'2',28,'commerce_order',1,'you@yourdomain.com','pending',1339921103,1340030262,'127.0.0.1','a:0:{}'),(3,'3',34,'commerce_order',1,'you@yourdomain.com','pending',1340030517,1340030705,'127.0.0.1','a:0:{}'),(4,'4',40,'commerce_order',1,'you@yourdomain.com','pending',1340031924,1340031995,'127.0.0.1','a:0:{}'),(7,'7',47,'commerce_order',1,'you@yourdomain.com','cart',1500455265,1500455265,'192.168.1.49','a:1:{s:17:\"last_cart_refresh\";i:1501129510;}');
/*!40000 ALTER TABLE `commerce_order` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_order_revision`
--

DROP TABLE IF EXISTS `commerce_order_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_order_revision` (
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_order.order_id of the order this revision belongs to.',
  `order_number` varchar(255) DEFAULT NULL COMMENT 'The order number displayed to the customer for this revision.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this revision.',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns the order at this revision.',
  `mail` varchar(255) NOT NULL COMMENT 'The e-mail address associated with the order at this revision.',
  `status` varchar(255) NOT NULL COMMENT 'The status name of this revision.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `revision_hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The IP address that created this order.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`revision_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_order_revision`
--

LOCK TABLES `commerce_order_revision` WRITE;
/*!40000 ALTER TABLE `commerce_order_revision` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_order_revision` VALUES (1,'1',1,1,'you@yourdomain.com','cart','Created as a shopping cart order.',1339774881,'127.0.0.1','a:0:{}'),(1,'1',2,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1339860483,'127.0.0.1','a:0:{}'),(1,'1',3,1,'you@yourdomain.com','cart','Order status updated via Rules.',1339860483,'127.0.0.1','a:0:{}'),(1,'1',4,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1339891551,'127.0.0.1','a:0:{}'),(1,'1',5,1,'you@yourdomain.com','cart','Order status updated via Rules.',1339919480,'127.0.0.1','a:0:{}'),(1,'1',6,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1339919524,'127.0.0.1','a:0:{}'),(1,'1',7,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1339919536,'127.0.0.1','a:0:{}'),(1,'1',8,1,'you@yourdomain.com','checkout_payment','Customer continued to the next checkout page via a submit button.',1339919536,'127.0.0.1','a:0:{}'),(1,'1',9,1,'you@yourdomain.com','checkout_complete','',1339919538,'127.0.0.1','a:0:{}'),(1,'1',10,1,'you@yourdomain.com','pending','Order state updated via Rules.',1339919538,'127.0.0.1','a:0:{}'),(2,'2',11,1,'you@yourdomain.com','cart','Created as a shopping cart order.',1339921137,'127.0.0.1','a:0:{}'),(2,'2',12,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1339922341,'127.0.0.1','a:0:{}'),(2,'2',13,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1339922341,'127.0.0.1','a:0:{}'),(2,'2',14,1,'you@yourdomain.com','cart','Customer manually canceled the checkout process.',1339922407,'127.0.0.1','a:0:{}'),(2,'2',15,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1339922423,'127.0.0.1','a:0:{}'),(2,'2',16,1,'you@yourdomain.com','cart','Customer updated the order via the shopping cart form.',1339922449,'127.0.0.1','a:0:{}'),(2,'2',17,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1339922467,'127.0.0.1','a:0:{}'),(2,'2',18,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1340028175,'127.0.0.1','a:0:{}'),(2,'2',19,1,'you@yourdomain.com','cart','Order status updated via Rules.',1340028175,'127.0.0.1','a:0:{}'),(2,'2',20,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1340028289,'127.0.0.1','a:0:{}'),(2,'2',21,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1340028289,'127.0.0.1','a:0:{}'),(2,'2',22,1,'you@yourdomain.com','checkout_checkout','Customer returned to the previous checkout page via a submit button.',1340029856,'127.0.0.1','a:0:{}'),(2,'2',23,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1340029856,'127.0.0.1','a:0:{}'),(2,'2',24,1,'you@yourdomain.com','checkout_checkout','Customer returned to the previous checkout page via a submit button.',1340030143,'127.0.0.1','a:0:{}'),(2,'2',25,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1340030260,'127.0.0.1','a:0:{}'),(2,'2',26,1,'you@yourdomain.com','checkout_payment','Customer continued to the next checkout page via a submit button.',1340030260,'127.0.0.1','a:0:{}'),(2,'2',27,1,'you@yourdomain.com','checkout_complete','',1340030262,'127.0.0.1','a:0:{}'),(2,'2',28,1,'you@yourdomain.com','pending','Order state updated via Rules.',1340030262,'127.0.0.1','a:0:{}'),(3,'3',29,1,'you@yourdomain.com','cart','Created as a shopping cart order.',1340030585,'127.0.0.1','a:0:{}'),(3,'3',30,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1340030642,'127.0.0.1','a:0:{}'),(3,'3',31,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1340030702,'127.0.0.1','a:0:{}'),(3,'3',32,1,'you@yourdomain.com','checkout_payment','Customer continued to the next checkout page via a submit button.',1340030702,'127.0.0.1','a:0:{}'),(3,'3',33,1,'you@yourdomain.com','checkout_complete','',1340030705,'127.0.0.1','a:0:{}'),(3,'3',34,1,'you@yourdomain.com','pending','Order state updated via Rules.',1340030705,'127.0.0.1','a:0:{}'),(4,'4',35,1,'you@yourdomain.com','cart','Created as a shopping cart order.',1340031948,'127.0.0.1','a:0:{}'),(4,'4',36,1,'you@yourdomain.com','checkout_checkout','Customer proceeded to checkout using a submit button.',1340031977,'127.0.0.1','a:0:{}'),(4,'4',37,1,'you@yourdomain.com','checkout_review','Customer continued to the next checkout page via a submit button.',1340031993,'127.0.0.1','a:0:{}'),(4,'4',38,1,'you@yourdomain.com','checkout_payment','Customer continued to the next checkout page via a submit button.',1340031993,'127.0.0.1','a:0:{}'),(4,'4',39,1,'you@yourdomain.com','checkout_complete','',1340031995,'127.0.0.1','a:0:{}'),(4,'4',40,1,'you@yourdomain.com','pending','Order state updated via Rules.',1340031995,'127.0.0.1','a:0:{}'),(7,'7',47,1,'you@yourdomain.com','cart','Created as a shopping cart order.',1500455265,'192.168.1.49','a:1:{s:17:\"last_cart_refresh\";i:1501129510;}');
/*!40000 ALTER TABLE `commerce_order_revision` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_payment_transaction`
--

DROP TABLE IF EXISTS `commerce_payment_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_payment_transaction` (
  `transaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a transaction.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_payment_transaction_revision.revision_id version identifier.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this transaction.',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_order.order_id of the order this payment is for.',
  `payment_method` varchar(128) NOT NULL COMMENT 'The payment method method_id for this transaction.',
  `instance_id` varchar(255) NOT NULL COMMENT 'The payment method instance ID for this transaction.',
  `remote_id` varchar(255) NOT NULL COMMENT 'The remote identifier for this transaction.',
  `message` longtext NOT NULL COMMENT 'The human-readable message associated to this transaction.',
  `message_variables` longblob NOT NULL COMMENT 'The variables associated with the human-readable message.',
  `amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The amount of this transaction.',
  `currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `status` varchar(128) NOT NULL COMMENT 'The status of this transaction (pending, success, or failure).',
  `remote_status` varchar(128) NOT NULL COMMENT 'The status of the transaction at the payment provider.',
  `payload` longblob NOT NULL COMMENT 'The payment-gateway specific payload associated with this transaction.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this transaction was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this transaction was last changed.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`transaction_id`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `payment_method` (`payment_method`),
  KEY `uid` (`uid`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Transaction information for every attempted payment.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_payment_transaction`
--

LOCK TABLES `commerce_payment_transaction` WRITE;
/*!40000 ALTER TABLE `commerce_payment_transaction` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `commerce_payment_transaction` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_payment_transaction_revision`
--

DROP TABLE IF EXISTS `commerce_payment_transaction_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_payment_transaction_revision` (
  `transaction_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a transaction.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The current commerce_payment_transaction_revision.revision_id version identifier.',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this revision.',
  `remote_id` varchar(255) NOT NULL COMMENT 'The remote identifier for this transaction.',
  `message` longtext NOT NULL COMMENT 'The human-readable message associated to this transaction.',
  `message_variables` longblob NOT NULL COMMENT 'The variables associated with the human-readable message.',
  `amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The amount of this transaction.',
  `currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `status` varchar(128) NOT NULL COMMENT 'The status of this transaction (pending, success, or failure).',
  `remote_status` varchar(128) NOT NULL COMMENT 'The status of the transaction at the payment provider.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`revision_id`),
  KEY `transaction_id` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_payment_transaction_revision`
--

LOCK TABLES `commerce_payment_transaction_revision` WRITE;
/*!40000 ALTER TABLE `commerce_payment_transaction_revision` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `commerce_payment_transaction_revision` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_paypal_ipn`
--

DROP TABLE IF EXISTS `commerce_paypal_ipn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_paypal_ipn` (
  `ipn_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Serial numeric ID of the IPN in the local database.',
  `txn_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'The PayPal transaction ID.',
  `txn_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The PayPal transaction type.',
  `receiver_email` varchar(255) NOT NULL DEFAULT '' COMMENT 'The e-mail of the payment receiever.',
  `payer_email` varchar(255) NOT NULL DEFAULT '' COMMENT 'The e-mail of the payer.',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The order ID the payment belongs to.',
  `transaction_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The payment transaction ID the payment belongs to.',
  `mc_gross` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The gross payment amount.',
  `mc_currency` varchar(255) NOT NULL DEFAULT '' COMMENT 'The currency code of the payment.',
  `mc_fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The amount of fees collected by PayPal for this payment.',
  `payment_status` varchar(255) NOT NULL DEFAULT '' COMMENT 'The status of the payment at PayPal.',
  `payment_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The type of the payment.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the IPN was received.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the IPN was last updated.',
  `test_ipn` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether or not this was a test IPN sent by the Sandbox.',
  PRIMARY KEY (`ipn_id`),
  KEY `txn_id` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores processed IPNs.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_paypal_ipn`
--

LOCK TABLES `commerce_paypal_ipn` WRITE;
/*!40000 ALTER TABLE `commerce_paypal_ipn` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `commerce_paypal_ipn` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_product`
--

DROP TABLE IF EXISTS `commerce_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_product` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a product, used internally only.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_product_revision.revision_id version identifier.',
  `sku` varchar(255) NOT NULL COMMENT 'The unique, human-readable identifier for a product.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this product, always treated as non-markup plain text.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The commerce_product_type.type of this product.',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The languages.language of this product.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this product.',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether or not the product appears in lists and may be added to orders.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the product was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the product was most recently saved.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`product_id`),
  UNIQUE KEY `sku` (`sku`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `product_type` (`type`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='The base table for products.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_product`
--

LOCK TABLES `commerce_product` WRITE;
/*!40000 ALTER TABLE `commerce_product` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_product` VALUES (1,1,'ROOMS-BASIC-BOOKING','Rooms Basic Booking','rooms_product','',0,1,1339773379,1400512348,'b:0;');
/*!40000 ALTER TABLE `commerce_product` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_product_revision`
--

DROP TABLE IF EXISTS `commerce_product_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_product_revision` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_product.product_id of the product this revision belongs to.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this revision.',
  `sku` varchar(255) NOT NULL COMMENT 'The unique, human-readable identifier of a product for this revision.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this product for this revision',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns the product at this revision.',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'The status of this revision.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `data` longblob COMMENT 'A serialized array of additional data for this revision.',
  PRIMARY KEY (`revision_id`),
  KEY `product_id` (`product_id`),
  KEY `revision_uid` (`revision_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_product_revision`
--

LOCK TABLES `commerce_product_revision` WRITE;
/*!40000 ALTER TABLE `commerce_product_revision` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_product_revision` VALUES (1,1,'ROOMS-BASIC-BOOKING','Rooms Basic Booking',1,1,'',1400512348,'b:0;');
/*!40000 ALTER TABLE `commerce_product_revision` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `commerce_product_type`
--

DROP TABLE IF EXISTS `commerce_product_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commerce_product_type` (
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The machine-readable name of this type.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The human-readable name of this type.',
  `description` mediumtext NOT NULL COMMENT 'A brief description of this type.',
  `help` mediumtext NOT NULL COMMENT 'Help information shown to the user when creating a commerce_product of this type.',
  `revision` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Determine whether to create a new revision when a product of this type is updated.',
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores information about commerce_product types created...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commerce_product_type`
--

LOCK TABLES `commerce_product_type` WRITE;
/*!40000 ALTER TABLE `commerce_product_type` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `commerce_product_type` VALUES ('product','Product','A basic product type.','',1);
/*!40000 ALTER TABLE `commerce_product_type` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `contact`
--

DROP TABLE IF EXISTS `contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique category ID.',
  `category` varchar(255) NOT NULL DEFAULT '' COMMENT 'Category name.',
  `recipients` longtext NOT NULL COMMENT 'Comma-separated list of recipient e-mail addresses.',
  `reply` longtext NOT NULL COMMENT 'Text of the auto-reply message.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The category’s weight.',
  `selected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether or not category is selected by default. (1 = Yes, 0 = No)',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `category` (`category`),
  KEY `list` (`weight`,`category`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Contact form category settings.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact`
--

LOCK TABLES `contact` WRITE;
/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `contact` VALUES (1,'Website feedback','you@yourdomain.com','',0,1);
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `ctools_css_cache`
--

DROP TABLE IF EXISTS `ctools_css_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctools_css_cache` (
  `cid` varchar(128) NOT NULL COMMENT 'The CSS ID this cache object belongs to.',
  `filename` varchar(255) DEFAULT NULL COMMENT 'The filename this CSS is stored in.',
  `css` longtext COMMENT 'CSS being stored.',
  `filter` tinyint(4) DEFAULT NULL COMMENT 'Whether or not this CSS needs to be filtered.',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store CSS that must be non-volatile.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctools_css_cache`
--

LOCK TABLES `ctools_css_cache` WRITE;
/*!40000 ALTER TABLE `ctools_css_cache` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `ctools_css_cache` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `ctools_object_cache`
--

DROP TABLE IF EXISTS `ctools_object_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctools_object_cache` (
  `sid` varchar(64) NOT NULL COMMENT 'The session ID this cache object belongs to.',
  `name` varchar(128) NOT NULL COMMENT 'The name of the object this cache is attached to.',
  `obj` varchar(128) NOT NULL COMMENT 'The type of the object this cache is attached to; this essentially represents the owner so that several sub-systems can use this cache.',
  `updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The time this cache was created or updated.',
  `data` longblob COMMENT 'Serialized data being stored.',
  PRIMARY KEY (`sid`,`obj`,`name`),
  KEY `updated` (`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store objects that are being...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctools_object_cache`
--

LOCK TABLES `ctools_object_cache` WRITE;
/*!40000 ALTER TABLE `ctools_object_cache` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `ctools_object_cache` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `date_format_locale`
--

DROP TABLE IF EXISTS `date_format_locale`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_format_locale` (
  `format` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `language` varchar(12) NOT NULL COMMENT 'A languages.language for this format to be used with.',
  PRIMARY KEY (`type`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats for each locale.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_format_locale`
--

LOCK TABLES `date_format_locale` WRITE;
/*!40000 ALTER TABLE `date_format_locale` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `date_format_locale` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `date_format_type`
--

DROP TABLE IF EXISTS `date_format_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_format_type` (
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `title` varchar(255) NOT NULL COMMENT 'The human readable name of the format type.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this is a system provided format.',
  PRIMARY KEY (`type`),
  KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date format types.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_format_type`
--

LOCK TABLES `date_format_type` WRITE;
/*!40000 ALTER TABLE `date_format_type` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `date_format_type` VALUES ('long','Long',1),('medium','Medium',1),('short','Short',1);
/*!40000 ALTER TABLE `date_format_type` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `date_formats`
--

DROP TABLE IF EXISTS `date_formats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_formats` (
  `dfid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The date format identifier.',
  `format` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this format can be modified.',
  PRIMARY KEY (`dfid`),
  UNIQUE KEY `formats` (`format`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_formats`
--

LOCK TABLES `date_formats` WRITE;
/*!40000 ALTER TABLE `date_formats` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `date_formats` VALUES (1,'Y-m-d H:i','short',1),(2,'m/d/Y - H:i','short',1),(3,'d/m/Y - H:i','short',1),(4,'Y/m/d - H:i','short',1),(5,'d.m.Y - H:i','short',1),(6,'m/d/Y - g:ia','short',1),(7,'d/m/Y - g:ia','short',1),(8,'Y/m/d - g:ia','short',1),(9,'M j Y - H:i','short',1),(10,'j M Y - H:i','short',1),(11,'Y M j - H:i','short',1),(12,'M j Y - g:ia','short',1),(13,'j M Y - g:ia','short',1),(14,'Y M j - g:ia','short',1),(15,'D, Y-m-d H:i','medium',1),(16,'D, m/d/Y - H:i','medium',1),(17,'D, d/m/Y - H:i','medium',1),(18,'D, Y/m/d - H:i','medium',1),(19,'F j, Y - H:i','medium',1),(20,'j F, Y - H:i','medium',1),(21,'Y, F j - H:i','medium',1),(22,'D, m/d/Y - g:ia','medium',1),(23,'D, d/m/Y - g:ia','medium',1),(24,'D, Y/m/d - g:ia','medium',1),(25,'F j, Y - g:ia','medium',1),(26,'j F Y - g:ia','medium',1),(27,'Y, F j - g:ia','medium',1),(28,'j. F Y - G:i','medium',1),(29,'l, F j, Y - H:i','long',1),(30,'l, j F, Y - H:i','long',1),(31,'l, Y,  F j - H:i','long',1),(32,'l, F j, Y - g:ia','long',1),(33,'l, j F Y - g:ia','long',1),(34,'l, Y,  F j - g:ia','long',1),(35,'l, j. F Y - G:i','long',1);
/*!40000 ALTER TABLE `date_formats` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_config`
--

DROP TABLE IF EXISTS `field_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field',
  `field_name` varchar(32) NOT NULL COMMENT 'The name of this field. Non-deleted field names are unique, but multiple deleted fields can have the same name.',
  `type` varchar(128) NOT NULL COMMENT 'The type of this field.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the field type.',
  `active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the field type is enabled.',
  `storage_type` varchar(128) NOT NULL COMMENT 'The storage backend for the field.',
  `storage_module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the storage backend.',
  `storage_active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the storage backend is enabled.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT '@TODO',
  `data` longblob NOT NULL COMMENT 'Serialized data containing the field properties that do not warrant a dedicated column.',
  `cardinality` tinyint(4) NOT NULL DEFAULT '0',
  `translatable` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name` (`field_name`),
  KEY `active` (`active`),
  KEY `storage_active` (`storage_active`),
  KEY `deleted` (`deleted`),
  KEY `module` (`module`),
  KEY `storage_module` (`storage_module`),
  KEY `type` (`type`),
  KEY `storage_type` (`storage_type`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_config`
--

LOCK TABLES `field_config` WRITE;
/*!40000 ALTER TABLE `field_config` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_config` VALUES (1,'comment_body','text_long','text',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:7:\"comment\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}}',1,0,0),(2,'body','text_with_summary','text',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:4:\"node\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}}',1,0,0),(3,'field_tags','taxonomy_term_reference','taxonomy',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:8:\"settings\";a:1:{s:14:\"allowed_values\";a:1:{i:0;a:2:{s:10:\"vocabulary\";s:4:\"tags\";s:6:\"parent\";i:0;}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:3:\"tid\";a:2:{s:5:\"table\";s:18:\"taxonomy_term_data\";s:7:\"columns\";a:1:{s:3:\"tid\";s:3:\"tid\";}}}s:7:\"indexes\";a:1:{s:3:\"tid\";a:1:{i:0;s:3:\"tid\";}}}',-1,0,0),(4,'field_image','image','image',1,'field_sql_storage','field_sql_storage',1,0,'a:7:{s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:22:\"field_data_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:26:\"field_revision_field_image\";a:5:{s:3:\"fid\";s:15:\"field_image_fid\";s:3:\"alt\";s:15:\"field_image_alt\";s:5:\"title\";s:17:\"field_image_title\";s:5:\"width\";s:17:\"field_image_width\";s:6:\"height\";s:18:\"field_image_height\";}}}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";s:1:\"0\";s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:2:\"id\";s:1:\"4\";}',1,0,0),(5,'commerce_customer_address','addressfield','addressfield',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:25:\"commerce_customer_profile\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',1,0,0),(6,'commerce_line_items','commerce_line_item_reference','commerce_line_item',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:14:\"commerce_order\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:12:\"line_item_id\";a:2:{s:5:\"table\";s:18:\"commerce_line_item\";s:7:\"columns\";a:1:{s:12:\"line_item_id\";s:12:\"line_item_id\";}}}s:7:\"indexes\";a:1:{s:12:\"line_item_id\";a:1:{i:0;s:12:\"line_item_id\";}}}',-1,0,0),(7,'commerce_order_total','commerce_price','commerce_price',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:14:\"commerce_order\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:14:\"currency_price\";a:2:{i:0;s:6:\"amount\";i:1;s:13:\"currency_code\";}}}',1,0,0),(8,'commerce_customer_billing','commerce_customer_profile_reference','commerce_customer',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:14:\"commerce_order\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:1:{s:12:\"profile_type\";s:7:\"billing\";}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:10:\"profile_id\";a:2:{s:5:\"table\";s:17:\"commerce_customer\";s:7:\"columns\";a:1:{s:10:\"profile_id\";s:10:\"profile_id\";}}}s:7:\"indexes\";a:1:{s:10:\"profile_id\";a:1:{i:0;s:10:\"profile_id\";}}}',1,0,0),(11,'commerce_unit_price','commerce_price','commerce_price',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:14:\"currency_price\";a:2:{i:0;s:6:\"amount\";i:1;s:13:\"currency_code\";}}}',1,0,0),(12,'commerce_total','commerce_price','commerce_price',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:14:\"currency_price\";a:2:{i:0;s:6:\"amount\";i:1;s:13:\"currency_code\";}}}',1,0,0),(13,'commerce_product','commerce_product_reference','commerce_product_reference',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:10:\"product_id\";a:2:{s:5:\"table\";s:16:\"commerce_product\";s:7:\"columns\";a:1:{s:10:\"product_id\";s:10:\"product_id\";}}}s:7:\"indexes\";a:1:{s:10:\"product_id\";a:1:{i:0;s:10:\"product_id\";}}}',1,0,0),(14,'commerce_display_path','text','text',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:18:\"commerce_line_item\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:1:{s:10:\"max_length\";i:255;}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}}',1,0,0),(15,'rooms_booking_dates','date','date',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:13:\"Booking Dates\";s:8:\"settings\";a:5:{s:6:\"repeat\";i:0;s:6:\"todate\";s:8:\"required\";s:11:\"granularity\";a:3:{s:4:\"year\";s:4:\"year\";s:5:\"month\";s:5:\"month\";s:3:\"day\";s:3:\"day\";}s:11:\"tz_handling\";s:4:\"none\";s:11:\"timezone_db\";s:0:\"\";}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',1,0,0),(16,'rooms_booked_unit_id','number_integer','number',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:14:\"Booked Unit ID\";s:8:\"settings\";a:3:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',1,0,0),(17,'rooms_booked_status','number_integer','number',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:18:\"Booked Unit Status\";s:8:\"settings\";a:3:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',1,0,0),(18,'rooms_booked_price','number_integer','number',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:17:\"Booked Unit Price\";s:8:\"settings\";a:3:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',1,0,0),(19,'rooms_booked_bookingprice','number_integer','number',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:13:\"Booking Price\";s:8:\"settings\";a:3:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',1,0,0),(20,'commerce_price','commerce_price','commerce_price',1,'field_sql_storage','field_sql_storage',1,1,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:16:\"commerce_product\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:14:\"currency_price\";a:2:{i:0;s:6:\"amount\";i:1;s:13:\"currency_code\";}}}',1,0,0),(23,'field_images','image','image',1,'field_sql_storage','field_sql_storage',1,0,'a:7:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:23:\"field_data_field_images\";a:5:{s:3:\"fid\";s:16:\"field_images_fid\";s:3:\"alt\";s:16:\"field_images_alt\";s:5:\"title\";s:18:\"field_images_title\";s:5:\"width\";s:18:\"field_images_width\";s:6:\"height\";s:19:\"field_images_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:27:\"field_revision_field_images\";a:5:{s:3:\"fid\";s:16:\"field_images_fid\";s:3:\"alt\";s:16:\"field_images_alt\";s:5:\"title\";s:18:\"field_images_title\";s:5:\"width\";s:18:\"field_images_width\";s:6:\"height\";s:19:\"field_images_height\";}}}}}s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:2:\"id\";s:2:\"23\";}',-1,0,0),(25,'field_slideshow_image','image','image',1,'field_sql_storage','field_sql_storage',1,0,'a:7:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:32:\"field_data_field_slideshow_image\";a:5:{s:3:\"fid\";s:25:\"field_slideshow_image_fid\";s:3:\"alt\";s:25:\"field_slideshow_image_alt\";s:5:\"title\";s:27:\"field_slideshow_image_title\";s:5:\"width\";s:27:\"field_slideshow_image_width\";s:6:\"height\";s:28:\"field_slideshow_image_height\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:36:\"field_revision_field_slideshow_image\";a:5:{s:3:\"fid\";s:25:\"field_slideshow_image_fid\";s:3:\"alt\";s:25:\"field_slideshow_image_alt\";s:5:\"title\";s:27:\"field_slideshow_image_title\";s:5:\"width\";s:27:\"field_slideshow_image_width\";s:6:\"height\";s:28:\"field_slideshow_image_height\";}}}}}s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:2:\"id\";s:2:\"25\";}',1,0,0),(27,'field_availability','rooms_availability_reference','rooms_availability_reference',1,'field_sql_storage','field_sql_storage',1,0,'a:7:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:2:{s:24:\"referenceable_unit_types\";a:4:{s:11:\"basic_suite\";s:11:\"basic_suite\";s:12:\"deluxe_suite\";s:12:\"deluxe_suite\";s:12:\"luxury_suite\";s:12:\"luxury_suite\";s:11:\"royal_suite\";s:11:\"royal_suite\";}s:32:\"referenceable_booking_unit_types\";a:0:{}}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:29:\"field_data_field_availability\";a:1:{s:7:\"unit_id\";s:26:\"field_availability_unit_id\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:33:\"field_revision_field_availability\";a:1:{s:7:\"unit_id\";s:26:\"field_availability_unit_id\";}}}}}s:12:\"foreign keys\";a:1:{s:7:\"unit_id\";a:2:{s:5:\"table\";s:11:\"rooms_units\";s:7:\"columns\";a:1:{s:7:\"unit_id\";s:7:\"unit_id\";}}}s:7:\"indexes\";a:1:{s:7:\"unit_id\";a:1:{i:0;s:7:\"unit_id\";}}s:2:\"id\";s:2:\"27\";}',1,0,0),(28,'field_description','text_with_summary','text',1,'field_sql_storage','field_sql_storage',1,0,'a:7:{s:12:\"translatable\";s:1:\"0\";s:12:\"entity_types\";a:0:{}s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:28:\"field_data_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:32:\"field_revision_field_description\";a:3:{s:5:\"value\";s:23:\"field_description_value\";s:7:\"summary\";s:25:\"field_description_summary\";s:6:\"format\";s:24:\"field_description_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:2:\"28\";}',1,0,0),(29,'rooms_booking_number_people','number_integer','number',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:21:\"Booking Number People\";s:8:\"settings\";a:3:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',2,0,0),(30,'rooms_booking_options','rooms_options','rooms',1,'field_sql_storage','field_sql_storage',1,0,'a:9:{s:5:\"label\";s:15:\"Booking Options\";s:8:\"required\";i:0;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:5:{s:6:\"active\";i:0;s:6:\"module\";s:5:\"rooms\";s:8:\"settings\";a:0:{}s:4:\"type\";s:22:\"rooms_options_combined\";s:6:\"weight\";s:1:\"0\";}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',-1,0,0),(31,'rooms_booking_reference','entityreference','entityreference',1,'field_sql_storage','field_sql_storage',1,0,'a:9:{s:5:\"label\";s:17:\"Booking Reference\";s:8:\"required\";i:0;s:8:\"settings\";a:3:{s:7:\"handler\";s:4:\"base\";s:16:\"handler_settings\";a:3:{s:9:\"behaviors\";a:1:{s:17:\"views-select-list\";a:1:{s:6:\"status\";i:0;}}s:4:\"sort\";a:1:{s:4:\"type\";s:4:\"none\";}s:14:\"target_bundles\";a:0:{}}s:11:\"target_type\";s:13:\"rooms_booking\";}s:6:\"widget\";a:5:{s:6:\"active\";i:1;s:6:\"module\";s:15:\"entityreference\";s:8:\"settings\";a:3:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:4:\"path\";s:0:\"\";s:4:\"size\";s:2:\"60\";}s:4:\"type\";s:28:\"entityreference_autocomplete\";s:6:\"weight\";s:1:\"9\";}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}}',1,0,0),(32,'rooms_booking_unit_options','rooms_options','rooms',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',-1,0,0),(33,'rooms_booking_children_ages','number_integer','number',1,'field_sql_storage','field_sql_storage',1,1,'a:7:{s:5:\"label\";s:21:\"Booking Children Ages\";s:8:\"settings\";a:3:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:0:{}s:7:\"indexes\";a:0:{}}',-1,0,0);
/*!40000 ALTER TABLE `field_config` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_config_instance`
--

DROP TABLE IF EXISTS `field_config_instance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_config_instance` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field instance',
  `field_id` int(11) NOT NULL COMMENT 'The identifier of the field attached by this instance',
  `field_name` varchar(32) NOT NULL DEFAULT '',
  `entity_type` varchar(32) NOT NULL DEFAULT '',
  `bundle` varchar(128) NOT NULL DEFAULT '',
  `data` longblob NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name_bundle` (`field_name`,`entity_type`,`bundle`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_config_instance`
--

LOCK TABLES `field_config_instance` WRITE;
/*!40000 ALTER TABLE `field_config_instance` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_config_instance` VALUES (1,1,'comment_body','comment','comment_node_page','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(2,2,'body','node','page','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";i:-4;s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(3,1,'comment_body','comment','comment_node_article','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(4,2,'body','node','article','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";s:2:\"-4\";s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:1:{s:11:\"trim_length\";s:3:\"520\";}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(5,3,'field_tags','node','article','a:6:{s:5:\"label\";s:4:\"Tags\";s:11:\"description\";s:63:\"Enter a comma-separated list of words to describe your content.\";s:6:\"widget\";a:4:{s:4:\"type\";s:21:\"taxonomy_autocomplete\";s:6:\"weight\";s:2:\"-4\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:17:\"autocomplete_path\";s:21:\"taxonomy/autocomplete\";}s:6:\"module\";s:8:\"taxonomy\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:28:\"taxonomy_term_reference_link\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"taxonomy\";}s:6:\"teaser\";a:4:{s:5:\"label\";s:6:\"inline\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"3\";s:8:\"settings\";a:0:{}}}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:8:\"required\";b:0;}',0),(6,4,'field_image','node','article','a:6:{s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:40:\"Upload an image to go with this article.\";s:8:\"required\";b:0;s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"field/image\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:11:\"title_field\";s:0:\"\";s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:11:\"image_image\";s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:6:\"weight\";s:2:\"-1\";s:6:\"module\";s:5:\"image\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:7:\"content\";}s:6:\"module\";s:5:\"image\";}}}',0),(7,5,'commerce_customer_address','commerce_customer_profile','billing','a:6:{s:5:\"label\";s:7:\"Address\";s:8:\"required\";b:1;s:6:\"widget\";a:4:{s:4:\"type\";s:21:\"addressfield_standard\";s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:15:\"format_handlers\";a:2:{i:0;s:7:\"address\";i:1;s:12:\"name-oneline\";}s:19:\"available_countries\";a:0:{}s:15:\"default_country\";s:0:\"\";}s:6:\"module\";s:12:\"addressfield\";}s:7:\"display\";a:3:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:20:\"addressfield_default\";s:6:\"weight\";i:-10;s:8:\"settings\";a:2:{s:19:\"use_widget_handlers\";i:1;s:15:\"format_handlers\";a:1:{i:0;s:7:\"address\";}}s:6:\"module\";s:12:\"addressfield\";}s:8:\"customer\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:20:\"addressfield_default\";s:6:\"weight\";i:-10;s:8:\"settings\";a:2:{s:19:\"use_widget_handlers\";i:1;s:15:\"format_handlers\";a:1:{i:0;s:7:\"address\";}}s:6:\"module\";s:12:\"addressfield\";}s:13:\"administrator\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:20:\"addressfield_default\";s:6:\"weight\";i:-10;s:8:\"settings\";a:2:{s:19:\"use_widget_handlers\";i:1;s:15:\"format_handlers\";a:1:{i:0;s:7:\"address\";}}s:6:\"module\";s:12:\"addressfield\";}}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:11:\"description\";s:0:\"\";}',0),(8,6,'commerce_line_items','commerce_order','commerce_order','a:6:{s:5:\"label\";s:10:\"Line items\";s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"commerce_line_item_manager\";s:6:\"weight\";i:-10;s:8:\"settings\";a:0:{}s:6:\"module\";s:18:\"commerce_line_item\";}s:7:\"display\";a:3:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:33:\"commerce_line_item_reference_view\";s:6:\"weight\";i:-10;s:8:\"settings\";a:1:{s:4:\"view\";s:32:\"commerce_line_item_table|default\";}s:6:\"module\";s:18:\"commerce_line_item\";}s:8:\"customer\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:33:\"commerce_line_item_reference_view\";s:6:\"weight\";i:-10;s:8:\"settings\";a:1:{s:4:\"view\";s:32:\"commerce_line_item_table|default\";}s:6:\"module\";s:18:\"commerce_line_item\";}s:13:\"administrator\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:33:\"commerce_line_item_reference_view\";s:6:\"weight\";i:-10;s:8:\"settings\";a:1:{s:4:\"view\";s:32:\"commerce_line_item_table|default\";}s:6:\"module\";s:18:\"commerce_line_item\";}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(9,7,'commerce_order_total','commerce_order','commerce_order','a:6:{s:5:\"label\";s:11:\"Order total\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:-8;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:4:{s:13:\"administrator\";a:5:{s:4:\"type\";s:35:\"commerce_price_formatted_components\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:-8;s:6:\"module\";s:14:\"commerce_price\";}s:8:\"customer\";a:5:{s:4:\"type\";s:35:\"commerce_price_formatted_components\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:-8;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:4:\"type\";s:35:\"commerce_price_formatted_components\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:-8;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:4:\"type\";s:35:\"commerce_price_formatted_components\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:-8;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(10,8,'commerce_customer_billing','commerce_order','commerce_order','a:6:{s:5:\"label\";s:19:\"Billing information\";s:6:\"widget\";a:4:{s:4:\"type\";s:33:\"commerce_customer_profile_manager\";s:6:\"weight\";i:-5;s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"commerce_customer\";}s:7:\"display\";a:3:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:43:\"commerce_customer_profile_reference_display\";s:6:\"weight\";i:-5;s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"commerce_customer\";}s:8:\"customer\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:43:\"commerce_customer_profile_reference_display\";s:6:\"weight\";i:-5;s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"commerce_customer\";}s:13:\"administrator\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:43:\"commerce_customer_profile_reference_display\";s:6:\"weight\";i:-5;s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"commerce_customer\";}}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(13,1,'comment_body','comment','comment_node_unit_description','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(14,11,'commerce_unit_price','commerce_line_item','product','a:6:{s:5:\"label\";s:10:\"Unit price\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:4:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:5:\"token\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(15,12,'commerce_total','commerce_line_item','product','a:6:{s:5:\"label\";s:5:\"Total\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:1;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:4:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}s:5:\"token\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(16,13,'commerce_product','commerce_line_item','product','a:6:{s:5:\"label\";s:7:\"Product\";s:8:\"required\";b:1;s:8:\"settings\";a:3:{s:19:\"referenceable_types\";a:0:{}s:15:\"field_injection\";b:1;s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:39:\"commerce_product_reference_autocomplete\";s:6:\"weight\";i:0;s:8:\"settings\";a:3:{s:18:\"autocomplete_match\";s:8:\"contains\";s:4:\"size\";i:60;s:17:\"autocomplete_path\";s:29:\"commerce_product/autocomplete\";}s:6:\"module\";s:26:\"commerce_product_reference\";}s:7:\"display\";a:2:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:6:\"weight\";i:0;s:4:\"type\";s:30:\"commerce_cart_add_to_cart_form\";s:8:\"settings\";a:4:{s:13:\"show_quantity\";b:0;s:16:\"default_quantity\";i:1;s:7:\"combine\";b:1;s:14:\"line_item_type\";s:7:\"product\";}s:6:\"module\";s:13:\"commerce_cart\";}s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:30:\"commerce_cart_add_to_cart_form\";s:8:\"settings\";a:4:{s:13:\"show_quantity\";b:0;s:16:\"default_quantity\";i:1;s:7:\"combine\";b:1;s:14:\"line_item_type\";s:7:\"product\";}s:6:\"module\";s:13:\"commerce_cart\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";}',0),(17,14,'commerce_display_path','commerce_line_item','product','a:6:{s:5:\"label\";s:12:\"Display path\";s:8:\"required\";b:1;s:8:\"settings\";a:2:{s:15:\"text_processing\";i:0;s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:6:\"weight\";i:0;s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:3;}}s:11:\"description\";s:0:\"\";}',0),(18,11,'commerce_unit_price','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:10:\"Unit price\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:4:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:5:\"token\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(19,12,'commerce_total','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:5:\"Total\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:1;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:4:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}s:5:\"token\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";b:0;}s:6:\"weight\";i:1;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(20,13,'commerce_product','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:7:\"Product\";s:8:\"required\";b:1;s:8:\"settings\";a:3:{s:19:\"referenceable_types\";a:0:{}s:15:\"field_injection\";b:1;s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:39:\"commerce_product_reference_autocomplete\";s:6:\"weight\";i:0;s:8:\"settings\";a:3:{s:18:\"autocomplete_match\";s:8:\"contains\";s:4:\"size\";i:60;s:17:\"autocomplete_path\";s:29:\"commerce_product/autocomplete\";}s:6:\"module\";s:26:\"commerce_product_reference\";}s:7:\"display\";a:2:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:6:\"weight\";i:0;s:4:\"type\";s:30:\"commerce_cart_add_to_cart_form\";s:8:\"settings\";a:4:{s:13:\"show_quantity\";b:0;s:16:\"default_quantity\";i:1;s:7:\"combine\";b:1;s:14:\"line_item_type\";s:7:\"product\";}s:6:\"module\";s:13:\"commerce_cart\";}s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:30:\"commerce_cart_add_to_cart_form\";s:8:\"settings\";a:4:{s:13:\"show_quantity\";b:0;s:16:\"default_quantity\";i:1;s:7:\"combine\";b:1;s:14:\"line_item_type\";s:7:\"product\";}s:6:\"module\";s:13:\"commerce_cart\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";}',0),(21,15,'rooms_booking_dates','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:13:\"Booking Dates\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:10:\"date_popup\";s:6:\"module\";s:4:\"date\";s:8:\"settings\";a:9:{s:13:\"default_value\";s:3:\"now\";s:14:\"default_format\";s:6:\"medium\";s:12:\"input_format\";s:13:\"m/d/Y - H:i:s\";s:19:\"input_format_custom\";s:0:\"\";s:9:\"increment\";i:15;s:10:\"text_parts\";a:0:{}s:10:\"year_range\";s:5:\"-3:+3\";s:14:\"label_position\";s:5:\"above\";s:15:\"display_all_day\";i:0;}s:6:\"weight\";i:2;}s:8:\"settings\";a:5:{s:13:\"default_value\";s:3:\"now\";s:18:\"default_value_code\";s:0:\"\";s:14:\"default_value2\";s:4:\"same\";s:19:\"default_value_code2\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:12:\"date_default\";s:8:\"settings\";a:5:{s:11:\"format_type\";s:4:\"long\";s:15:\"multiple_number\";s:0:\"\";s:13:\"multiple_from\";s:0:\"\";s:11:\"multiple_to\";s:0:\"\";s:6:\"fromto\";s:4:\"both\";}s:6:\"module\";s:4:\"date\";s:6:\"weight\";i:3;}}s:11:\"description\";s:0:\"\";}',0),(22,16,'rooms_booked_unit_id','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:14:\"Booked Unit ID\";s:8:\"required\";b:1;s:8:\"settings\";a:8:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"weight\";i:3;s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:6:\"number\";s:8:\"settings\";a:4:{s:17:\"decimal_separator\";s:1:\".\";s:13:\"prefix_suffix\";b:1;s:5:\"scale\";i:0;s:18:\"thousand_separator\";s:1:\" \";}s:4:\"type\";s:14:\"number_integer\";s:6:\"weight\";i:11;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0),(23,17,'rooms_booked_status','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:18:\"Booked Unit Status\";s:8:\"required\";b:1;s:8:\"settings\";a:8:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"weight\";i:4;s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:6:\"number\";s:8:\"settings\";a:4:{s:17:\"decimal_separator\";s:1:\".\";s:13:\"prefix_suffix\";b:1;s:5:\"scale\";i:0;s:18:\"thousand_separator\";s:1:\" \";}s:4:\"type\";s:14:\"number_integer\";s:6:\"weight\";i:11;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0),(24,18,'rooms_booked_price','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:17:\"Booked Unit Price\";s:8:\"required\";b:1;s:8:\"settings\";a:8:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"weight\";i:5;s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:6:\"number\";s:8:\"settings\";a:4:{s:17:\"decimal_separator\";s:1:\".\";s:13:\"prefix_suffix\";b:1;s:5:\"scale\";i:0;s:18:\"thousand_separator\";s:1:\" \";}s:4:\"type\";s:14:\"number_integer\";s:6:\"weight\";i:11;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0),(25,19,'rooms_booked_bookingprice','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:13:\"Booking Price\";s:8:\"required\";b:1;s:8:\"settings\";a:8:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"weight\";i:6;s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:6:\"number\";s:8:\"settings\";a:4:{s:17:\"decimal_separator\";s:1:\".\";s:13:\"prefix_suffix\";b:1;s:5:\"scale\";i:0;s:18:\"thousand_separator\";s:1:\" \";}s:4:\"type\";s:14:\"number_integer\";s:6:\"weight\";i:11;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0),(26,14,'commerce_display_path','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:12:\"Display path\";s:8:\"required\";b:1;s:8:\"settings\";a:2:{s:15:\"text_processing\";i:0;s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:6:\"weight\";i:0;s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:12;}}s:11:\"description\";s:0:\"\";}',0),(27,20,'commerce_price','commerce_product','product','a:6:{s:5:\"label\";s:5:\"Price\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:6:{s:4:\"full\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:9:\"line_item\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:26:\"commerce_line_item_display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:5:\"token\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(28,20,'commerce_price','commerce_product','rooms_product','a:6:{s:5:\"label\";s:5:\"Price\";s:8:\"required\";b:1;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:19:\"commerce_price_full\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:13:\"currency_code\";s:7:\"default\";}s:6:\"module\";s:14:\"commerce_price\";}s:7:\"display\";a:6:{s:4:\"full\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:9:\"line_item\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:26:\"commerce_line_item_display\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:5:\"token\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}s:11:\"node_teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:31:\"commerce_price_formatted_amount\";s:8:\"settings\";a:1:{s:11:\"calculation\";s:21:\"calculated_sell_price\";}s:6:\"weight\";i:0;s:6:\"module\";s:14:\"commerce_price\";}}s:11:\"description\";s:0:\"\";}',0),(29,1,'comment_body','comment','comment_node_poll','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(43,1,'comment_body','comment','comment_node_promotions','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(44,2,'body','node','promotions','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";s:2:\"31\";s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(45,23,'field_images','node','promotions','a:6:{s:5:\"label\";s:6:\"Images\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"32\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:12:\"field/images\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:7:\"content\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(47,25,'field_slideshow_image','node','promotions','a:6:{s:5:\"label\";s:15:\"Slideshow Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"33\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:15:\"field/slideshow\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:4:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(48,1,'comment_body','comment','comment_node_news_events','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(49,2,'body','node','news_events','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";s:2:\"31\";s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(50,23,'field_images','node','news_events','a:6:{s:5:\"label\";s:6:\"Images\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"33\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:12:\"field/images\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:7:\"content\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(51,25,'field_slideshow_image','node','news_events','a:6:{s:5:\"label\";s:15:\"Slideshow Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"35\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:15:\"field/slideshow\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:4:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(52,1,'comment_body','comment','comment_node_services_facilities','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(53,2,'body','node','services_facilities','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";s:2:\"31\";s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(54,23,'field_images','node','services_facilities','a:6:{s:5:\"label\";s:6:\"Images\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"33\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:12:\"field/images\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:11:\"img_646_246\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(55,25,'field_slideshow_image','node','services_facilities','a:6:{s:5:\"label\";s:15:\"Slideshow Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"35\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:15:\"field/slideshow\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:4:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(56,1,'comment_body','comment','comment_node_photo_galleries','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(57,2,'body','node','photo_galleries','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";s:1:\"3\";s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(58,23,'field_images','node','photo_galleries','a:6:{s:5:\"label\";s:6:\"Images\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:12:\"field/images\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:24:\"galleryformatter_default\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:6:{s:11:\"slide_style\";s:22:\"galleryformatter_slide\";s:11:\"thumb_style\";s:22:\"galleryformatter_thumb\";s:5:\"style\";s:11:\"Greenarrows\";s:12:\"link_to_full\";i:1;s:18:\"link_to_full_style\";i:0;s:5:\"modal\";s:4:\"none\";}s:6:\"module\";s:16:\"galleryformatter\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:8:\"colorbox\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:6:{s:19:\"colorbox_node_style\";s:22:\"galleryformatter_thumb\";s:20:\"colorbox_image_style\";s:22:\"galleryformatter_slide\";s:16:\"colorbox_gallery\";s:4:\"post\";s:23:\"colorbox_gallery_custom\";s:0:\"\";s:16:\"colorbox_caption\";s:4:\"auto\";s:23:\"colorbox_caption_custom\";s:0:\"\";}s:6:\"module\";s:8:\"colorbox\";}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(61,27,'field_availability','node','unit_description','a:7:{s:5:\"label\";s:12:\"Availability\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"1\";s:4:\"type\";s:41:\"rooms_availability_reference_autocomplete\";s:6:\"module\";s:28:\"rooms_availability_reference\";s:6:\"active\";i:0;s:8:\"settings\";a:3:{s:18:\"autocomplete_match\";s:8:\"contains\";s:4:\"size\";i:60;s:17:\"autocomplete_path\";s:41:\"rooms_availability_reference/autocomplete\";}}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:36:\"rooms_availability_reference_default\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}s:6:\"module\";s:28:\"rooms_availability_reference\";}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;}',0),(62,23,'field_images','node','unit_description','a:6:{s:5:\"label\";s:6:\"Images\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"field/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:8:\"colorbox\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:6:{s:19:\"colorbox_node_style\";s:6:\"medium\";s:20:\"colorbox_image_style\";s:22:\"galleryformatter_slide\";s:16:\"colorbox_gallery\";s:4:\"post\";s:23:\"colorbox_gallery_custom\";s:0:\"\";s:16:\"colorbox_caption\";s:4:\"auto\";s:23:\"colorbox_caption_custom\";s:0:\"\";}s:6:\"module\";s:8:\"colorbox\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:7:\"content\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";}',0),(64,4,'field_image','rooms_unit','basic_suite','a:6:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";}',0),(65,28,'field_description','rooms_unit','basic_suite','a:7:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"3\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;}',0),(66,4,'field_image','rooms_unit','deluxe_suite','a:6:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";}',0),(67,28,'field_description','rooms_unit','deluxe_suite','a:7:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"4\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;}',0),(68,4,'field_image','rooms_unit','luxury_suite','a:6:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";}',0),(69,28,'field_description','rooms_unit','luxury_suite','a:7:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"4\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;}',0),(70,4,'field_image','rooms_unit','royal_suite','a:6:{s:5:\"label\";s:5:\"Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"2\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"image/rooms\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:6:\"weight\";s:1:\"0\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";}',0),(71,28,'field_description','rooms_unit','royal_suite','a:7:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"4\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;}',0),(72,28,'field_description','node','unit_description','a:7:{s:5:\"label\";s:11:\"Description\";s:6:\"widget\";a:5:{s:6:\"weight\";s:1:\"3\";s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";s:2:\"20\";s:12:\"summary_rows\";i:5;}}s:8:\"settings\";a:3:{s:15:\"text_processing\";s:1:\"1\";s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";s:1:\"1\";s:8:\"settings\";a:1:{s:11:\"trim_length\";s:3:\"500\";}s:6:\"module\";s:4:\"text\";}}s:8:\"required\";i:1;s:11:\"description\";s:0:\"\";s:13:\"default_value\";N;}',0),(73,25,'field_slideshow_image','node','article','a:6:{s:5:\"label\";s:15:\"Slideshow Image\";s:6:\"widget\";a:5:{s:6:\"weight\";s:2:\"32\";s:4:\"type\";s:11:\"image_image\";s:6:\"module\";s:5:\"image\";s:6:\"active\";i:1;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:0:\"\";}}s:8:\"settings\";a:9:{s:14:\"file_directory\";s:15:\"field/slideshow\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:4:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"3\";s:8:\"settings\";a:0:{}}s:6:\"teaser\";a:4:{s:5:\"label\";s:6:\"inline\";s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";s:1:\"2\";s:8:\"settings\";a:0:{}}}s:8:\"required\";i:0;s:11:\"description\";s:0:\"\";}',0),(74,29,'rooms_booking_number_people','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:21:\"Booking Number People\";s:8:\"required\";b:1;s:8:\"settings\";a:8:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"weight\";i:7;s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:6:\"number\";s:8:\"settings\";a:4:{s:17:\"decimal_separator\";s:1:\".\";s:13:\"prefix_suffix\";b:1;s:5:\"scale\";i:0;s:18:\"thousand_separator\";s:1:\" \";}s:4:\"type\";s:14:\"number_integer\";s:6:\"weight\";i:11;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0),(75,30,'rooms_booking_options','commerce_line_item','rooms_booking','a:7:{s:5:\"label\";s:15:\"Booking Options\";s:13:\"default_value\";N;s:11:\"description\";s:0:\"\";s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:5:\"rooms\";s:8:\"settings\";a:0:{}s:4:\"type\";s:21:\"rooms_options_default\";s:6:\"weight\";i:12;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:8:\"required\";i:0;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:6:\"module\";s:5:\"rooms\";s:4:\"type\";s:22:\"rooms_options_combined\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:8;}}',0),(76,31,'rooms_booking_reference','commerce_line_item','rooms_booking','a:7:{s:5:\"label\";s:17:\"Booking Reference\";s:13:\"default_value\";N;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:15:\"entityreference\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:4:\"type\";s:21:\"entityreference_label\";s:6:\"weight\";i:13;}}s:8:\"required\";i:0;s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:5:{s:6:\"active\";i:1;s:6:\"module\";s:15:\"entityreference\";s:8:\"settings\";a:3:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:4:\"path\";s:0:\"\";s:4:\"size\";s:2:\"60\";}s:4:\"type\";s:28:\"entityreference_autocomplete\";s:6:\"weight\";s:1:\"9\";}s:11:\"description\";s:0:\"\";}',0),(77,32,'rooms_booking_unit_options','rooms_unit','basic_suite','a:6:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"rooms_options\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"module\";N;}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";}',0),(78,32,'rooms_booking_unit_options','rooms_unit','deluxe_suite','a:6:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"rooms_options\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"module\";N;}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";}',0),(79,32,'rooms_booking_unit_options','rooms_unit','luxury_suite','a:6:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"rooms_options\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"module\";N;}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";}',0),(80,32,'rooms_booking_unit_options','rooms_unit','royal_suite','a:6:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"rooms_options\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"module\";N;}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:2;}}s:11:\"description\";s:0:\"\";}',0),(81,33,'rooms_booking_children_ages','commerce_line_item','rooms_booking','a:6:{s:5:\"label\";s:21:\"Booking Children Ages\";s:8:\"required\";b:0;s:8:\"settings\";a:8:{s:4:\"size\";i:8;s:10:\"max_length\";i:10;s:15:\"text_processing\";i:0;s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:14:\"text_textfield\";s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"weight\";i:10;s:6:\"module\";s:4:\"text\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:6:\"module\";s:6:\"number\";s:8:\"settings\";a:4:{s:17:\"decimal_separator\";s:1:\".\";s:13:\"prefix_suffix\";b:1;s:5:\"scale\";i:0;s:18:\"thousand_separator\";s:1:\" \";}s:4:\"type\";s:14:\"number_integer\";s:6:\"weight\";i:13;}s:6:\"teaser\";a:4:{s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:4:\"type\";s:6:\"hidden\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0),(82,32,'rooms_booking_unit_options','rooms_unit_type','rooms_unit_type','a:6:{s:5:\"label\";s:7:\"Options\";s:8:\"required\";b:0;s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"rooms_options\";s:8:\"settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"module\";N;}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:5:\"above\";s:4:\"type\";s:21:\"rooms_options_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:5:\"rooms\";s:6:\"weight\";i:0;}}s:11:\"description\";s:0:\"\";}',0);
/*!40000 ALTER TABLE `field_config_instance` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_body`
--

DROP TABLE IF EXISTS `field_data_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 2 (body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_body`
--

LOCK TABLES `field_data_body` WRITE;
/*!40000 ALTER TABLE `field_data_body` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_body` VALUES ('node','page',0,1,1,'und',0,'<dl class=\"support-content\">\r\n<dt>Contact us</dt>\r\n<dd><p>Suspendisse vel sollicitudin metus. Fusce ac turpis quis elit eleifend vestibulum id sed tellus. Fusce vulputate faucibus auctor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed cursus sapien aliquet mauris auctor egestas. Cras at nisl sed metus tempor posuere vel at tellus. Cras faucibus dui sed lectus elementum vitae imperdiet lectus pulvinar. Quisque non sapien neque. Vestibulum a mi lectus. </p></dd>\r\n<dt>Recent Stay Comments</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n<dt>Reservations FAQ</dt>\r\n<dd><p>Morbi pellentesque adipiscing dui, in vehicula lorem dictum sollicitudin. Praesent pretium placerat dictum. Sed suscipit, leo ac gravida egestas, nibh nisl viverra odio, a pulvinar mauris turpis non augue. Quisque non metus metus, ac congue tortor. Nam ac lorem quam. Morbi et sem sit amet odio egestas semper. Mauris venenatis porta ligula euismod venenatis. Vivamus nibh lacus, tincidunt eget lobortis eget, pharetra sit amet sapien.</p><p>Proin commodo massa sed lorem ullamcorper eget pulvinar magna pharetra. Quisque sollicitudin interdum felis, in tristique est rutrum quis. Suspendisse eu fringilla dolor. Integer vitae mauris est. Suspendisse potenti. Nulla lacinia molestie porta. </p></dd>\r\n<dt>Call Us</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n</dl>','','full_html'),('node','promotions',0,2,2,'und',0,'Nullam a dapibus arcu. Duis nec velit nec dolor cursus condimentum in id massa. Ut elementum, arcu in dignissim bibendum, ante justo commodo leo, non condimentum mauris diam in nulla. Etiam tincidunt est sit amet magna luctus condimentum. Aliquam mattis rutrum eros et tincidunt. Sed eu cursus neque. Cras egestas felis sit amet mauris accumsan eget sodales lacus vulputate. Etiam pulvinar neque et nisl fringilla ut mattis est eleifend. Vestibulum metus urna, vulputate nec aliquet aliquet, volutpat vitae erat. Nullam nibh lectus, ultricies adipiscing aliquam ac, varius et magna. Phasellus ut nisi volutpat mi tempor faucibus eu eget nulla? Curabitur molestie laoreet tellus, ut egestas erat vehicula non.\r\n\r\nVivamus porta faucibus mi, id congue elit convallis non. Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem. Curabitur condimentum enim sit amet eros tempus fringilla? Donec arcu magna, varius eu elementum et, faucibus nec arcu. Aenean varius, purus a dignissim fermentum; purus leo venenatis dui, nec rhoncus neque augue ut dolor. Duis aliquet risus sit amet purus suscipit ut faucibus urna gravida? Duis vitae risus eu sem aliquet sodales. Donec sit amet ligula metus.\r\n','','filtered_html'),('node','services_facilities',0,6,6,'und',0,'Revitalize with a healthy workout in the fully appointed fitness center. Maximize your workout routine with treadmills, cycles, and workout station. Enjoy the panorama from the 24th floor, or watch a variety of international channels on the 32” televisions. And experience total relaxation after your work out in the separate saunas for men and women.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 to 22:00','','filtered_html'),('node','services_facilities',0,7,7,'und',0,'Lounge by the swimming pool and take in the spectacular views of Saigon from the 24th floor. The swimming pool has a maximum depth of 1.8 meters. Poolside furniture offers a pristine spot to read a book, enjoy a drink, or just bask in some tropical rays.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 - 22:00','','filtered_html'),('node','services_facilities',0,8,8,'und',0,'With meeting rooms, copy and fax services, and internet connectivity, accomplishing important tasks is quick and efficient at the Business Center. Using the on-site computers, you can check email, browse the net, or look up your next travel destination. Our experienced receptionist is at hand to help you solve any problems that may arise.\r\n\r\nLocation: 4th floor','','filtered_html'),('node','photo_galleries',0,9,9,'und',0,'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.\r\n','','filtered_html'),('node','photo_galleries',0,10,10,'und',0,'Pellentesque molestie, quam sit amet aliquet porttitor, enim neque bibendum turpis, ac convallis orci lectus id est. Aenean nec diam nec nibh fermentum malesuada sit amet in nisl. Integer varius, metus nec dictum blandit, ante felis suscipit quam, sed tincidunt ante dui sed enim. Fusce gravida, magna at posuere pretium, leo purus dictum ipsum, eleifend ornare tellus justo ac augue. Aenean et pharetra leo. Sed ut lectus felis. Praesent vitae velit quis mi ultrices vehicula vel ac leo.\r\n\r\nQuisque erat ligula, tempus et interdum eu, egestas a libero. Sed a condimentum felis! In semper enim eu ligula luctus luctus. Ut mattis, nisi in congue condimentum, velit diam semper orci, quis tincidunt urna ligula at ligula? Nullam ante purus, elementum at ultrices in, mollis non massa. Nulla commodo, felis in pretium ornare, nunc mi dignissim ligula, non pellentesque orci leo sit amet orci. Nulla tincidunt fringilla nulla, sit amet vestibulum leo porttitor eu. Curabitur sit amet sapien a ipsum pulvinar tristique eget in velit. Donec sagittis vulputate sem ac consequat. Aliquam sem urna, tristique sit amet commodo a; placerat at enim! Nulla eu bibendum tortor. Pellentesque vitae nulla et elit nullam.\r\n','','filtered_html'),('node','news_events',0,11,11,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','news_events',0,12,12,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','news_events',0,13,13,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','promotions',0,14,14,'und',0,'Mauris lacinia tellus sit amet justo laoreet facilisis. Fusce non urna ut libero tempus auctor sit amet in leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Curabitur vel nunc a enim commodo porta non eget augue. Duis placerat, risus a faucibus tempor, ligula diam imperdiet justo, nec venenatis orci magna at augue! Ut ut mauris id sem feugiat molestie. Morbi ac magna sapien, nec sollicitudin nibh. Aenean auctor molestie leo, sit amet malesuada nisi pulvinar sit amet. Nullam mollis iaculis cursus. Morbi id tristique felis. Aenean sagittis sollicitudin mollis. Nulla facilisi. Maecenas molestie tincidunt aliquam. In luctus, nunc at consequat iaculis, dolor turpis consequat nisi, ac interdum mi mauris euismod mi? Aliquam eu elementum arcu!\r\n\r\nQuisque sit amet felis ligula, a porttitor nunc. Nullam ac ante et purus viverra imperdiet? Nam id tellus arcu, eu convallis sapien. Sed sit amet mattis risus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam mattis tellus non arcu pharetra at porta libero lobortis. Morbi eleifend mauris sed mauris molestie quis blandit massa lobortis! Aliquam molestie, elit sed.\r\n','','filtered_html'),('node','article',0,15,15,'und',0,'Curabitur dapibus felis sit amet odio sodales ultrices. Sed non dolor tortor. Donec blandit diam sed ligula tempor egestas. Cras rhoncus enim tortor, vel venenatis libero. Sed eu sem urna, vitae luctus ligula? Pellentesque pulvinar, nisl sit amet sagittis rhoncus, neque sem luctus ante, vel sodales quam metus at turpis. Sed massa augue, sollicitudin ut tristique ut, malesuada elementum tellus. Nunc nec leo lacus? Etiam dictum, orci nec tincidunt iaculis, dui diam accumsan leo, et blandit tortor tortor non lacus. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nProin elit eros; sagittis vel facilisis vitae, facilisis vel tellus. Praesent elementum viverra orci rutrum posuere? Nunc pretium diam a purus ornare hendrerit eget a mauris. Nullam sodales orci nec neque scelerisque quis iaculis orci accumsan. Maecenas gravida quam quis odio feugiat condimentum. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nNunc odio risus, auctor ut gravida et, venenatis quis quam. Quisque dapibus dictum vestibulum. In at nunc quam, quis pellentesque risus. Aliquam venenatis enim sit amet risus congue quis adipiscing eros posuere.','','filtered_html'),('node','services_facilities',0,16,16,'und',0,'Give your children some time to relax and move about in our spacious supervised kids’ corner. Children can stimulate their bodies and minds with a variety of educational toys and games. Young adults will enjoy the games room equipped with the latest generation of video game consoles and large LCD TVs.\r\n\r\nLocation: 4th floor','','filtered_html'),('node','services_facilities',0,17,17,'und',0,'Sed scelerisque justo id massa laoreet sollicitudin. Sed id lorem ornare nunc elementum convallis. Nam lectus ligula, rutrum ac convallis vel, tempus sodales dui. Pellentesque euismod est eget sem vehicula facilisis. Pellentesque lacinia mollis eleifend. Sed cursus lobortis scelerisque. Maecenas nulla tellus, viverra a lobortis quis, bibendum vel nunc.\r\n\r\nUt accumsan orci vel dolor eleifend venenatis varius erat vestibulum. Vivamus commodo porta ligula, ut dictum ligula ornare ac. Nulla erat dui, condimentum a malesuada quis, pharetra ut nulla. Vivamus posuere semper massa, quis volutpat nulla porta sit amet. Vivamus rhoncus, risus quis sodales egestas, orci risus volutpat felis, sed euismod massa quam non velit.\r\n\r\nLocation: 4th floor','','filtered_html'),('node','photo_galleries',0,18,18,'und',0,'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.','','filtered_html'),('node','photo_galleries',0,19,19,'und',0,'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.','','filtered_html'),('node','article',0,20,20,'und',0,'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.','','filtered_html'),('node','article',0,21,21,'und',0,'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n','','filtered_html'),('node','article',0,22,22,'und',0,'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n','','filtered_html'),('node','news_events',0,23,23,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','news_events',0,24,24,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html');
/*!40000 ALTER TABLE `field_data_body` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_comment_body`
--

DROP TABLE IF EXISTS `field_data_comment_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 1 (comment_body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_comment_body`
--

LOCK TABLES `field_data_comment_body` WRITE;
/*!40000 ALTER TABLE `field_data_comment_body` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_comment_body` VALUES ('comment','comment_node_promotions',0,1,1,'und',0,'Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem.','filtered_html');
/*!40000 ALTER TABLE `field_data_comment_body` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_customer_address`
--

DROP TABLE IF EXISTS `field_data_commerce_customer_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_customer_address` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_address_country` varchar(2) DEFAULT '' COMMENT 'Two letter ISO country code of this address.',
  `commerce_customer_address_administrative_area` varchar(255) DEFAULT '' COMMENT 'The administrative area of this address. (i.e. State/Province)',
  `commerce_customer_address_sub_administrative_area` varchar(255) DEFAULT '' COMMENT 'The sub administrative area of this address.',
  `commerce_customer_address_locality` varchar(255) DEFAULT '' COMMENT 'The locality of this address. (i.e. City)',
  `commerce_customer_address_dependent_locality` varchar(255) DEFAULT '' COMMENT 'The dependent locality of this address.',
  `commerce_customer_address_postal_code` varchar(255) DEFAULT '' COMMENT 'The postal code of this address.',
  `commerce_customer_address_thoroughfare` varchar(255) DEFAULT '' COMMENT 'The thoroughfare of this address. (i.e. Street address)',
  `commerce_customer_address_premise` varchar(255) DEFAULT '' COMMENT 'The premise of this address. (i.e. Apartment / Suite number)',
  `commerce_customer_address_sub_premise` varchar(255) DEFAULT '' COMMENT 'The sub_premise of this address.',
  `commerce_customer_address_organisation_name` varchar(255) DEFAULT '' COMMENT 'Contents of a primary OrganisationName element in the xNL XML.',
  `commerce_customer_address_name_line` varchar(255) DEFAULT '' COMMENT 'Contents of a primary NameLine element in the xNL XML.',
  `commerce_customer_address_first_name` varchar(255) DEFAULT '' COMMENT 'Contents of the FirstName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_last_name` varchar(255) DEFAULT '' COMMENT 'Contents of the LastName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_data` longtext COMMENT 'Additional data for this address.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 5 (commerce_customer_address)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_customer_address`
--

LOCK TABLES `field_data_commerce_customer_address` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_customer_address` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_customer_address` VALUES ('commerce_customer_profile','billing',0,1,1,'und',0,'VN','048',NULL,'hcm',NULL,'014','11','1111',NULL,NULL,'Trung',NULL,NULL,NULL),('commerce_customer_profile','billing',0,2,2,'und',0,'VN','014',NULL,'hcm',NULL,'12','94 B5 Hung Vuong F9 Q5','',NULL,NULL,'Huynh Huu Trung',NULL,NULL,NULL),('commerce_customer_profile','billing',0,3,3,'und',0,'VN','084',NULL,'HCM',NULL,'084','364 Cong Hoa Tan Binh ','',NULL,NULL,'Nguyen Ngoc Hai',NULL,NULL,NULL),('commerce_customer_profile','billing',0,4,4,'und',0,'VN','084',NULL,'HCM',NULL,'084','94 B5 Hung Vuong F9 Q5','',NULL,NULL,'Huynh Huu Trung',NULL,NULL,NULL);
/*!40000 ALTER TABLE `field_data_commerce_customer_address` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_customer_billing`
--

DROP TABLE IF EXISTS `field_data_commerce_customer_billing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_customer_billing` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_billing_profile_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_customer_billing_profile_id` (`commerce_customer_billing_profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 8 (commerce_customer_billing)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_customer_billing`
--

LOCK TABLES `field_data_commerce_customer_billing` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_customer_billing` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_customer_billing` VALUES ('commerce_order','commerce_order',0,1,10,'und',0,1),('commerce_order','commerce_order',0,2,28,'und',0,2),('commerce_order','commerce_order',0,3,34,'und',0,3),('commerce_order','commerce_order',0,4,40,'und',0,4);
/*!40000 ALTER TABLE `field_data_commerce_customer_billing` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_display_path`
--

DROP TABLE IF EXISTS `field_data_commerce_display_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_display_path` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_display_path_value` varchar(255) DEFAULT NULL,
  `commerce_display_path_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_display_path_format` (`commerce_display_path_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 14 (commerce_display_path)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_display_path`
--

LOCK TABLES `field_data_commerce_display_path` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_display_path` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_display_path` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,5,5,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,6,6,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,7,7,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,8,8,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,9,9,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,11,11,'und',0,'',NULL),('commerce_line_item','rooms_booking',0,16,16,'und',0,'',NULL);
/*!40000 ALTER TABLE `field_data_commerce_display_path` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_line_items`
--

DROP TABLE IF EXISTS `field_data_commerce_line_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_line_items` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_line_items_line_item_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_line_items_line_item_id` (`commerce_line_items_line_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 6 (commerce_line_items)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_line_items`
--

LOCK TABLES `field_data_commerce_line_items` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_line_items` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_line_items` VALUES ('commerce_order','commerce_order',0,1,10,'und',0,4),('commerce_order','commerce_order',0,2,28,'und',0,5),('commerce_order','commerce_order',0,2,28,'und',1,6),('commerce_order','commerce_order',0,2,28,'und',2,7),('commerce_order','commerce_order',0,3,34,'und',0,8),('commerce_order','commerce_order',0,3,34,'und',1,9),('commerce_order','commerce_order',0,4,40,'und',0,11),('commerce_order','commerce_order',0,7,47,'und',0,16);
/*!40000 ALTER TABLE `field_data_commerce_line_items` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_order_total`
--

DROP TABLE IF EXISTS `field_data_commerce_order_total`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_order_total` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_order_total_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_order_total_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_order_total_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_order_total_currency_price` (`commerce_order_total_amount`,`commerce_order_total_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 7 (commerce_order_total)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_order_total`
--

LOCK TABLES `field_data_commerce_order_total` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_order_total` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_order_total` VALUES ('commerce_order','commerce_order',0,1,10,'und',0,35000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:35000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:0:{}}s:8:\"included\";b:1;}}}'),('commerce_order','commerce_order',0,2,28,'und',0,4455000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:4455000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:0:{}}s:8:\"included\";b:1;}}}'),('commerce_order','commerce_order',0,3,34,'und',0,400000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:0:{}}s:8:\"included\";b:1;}}}'),('commerce_order','commerce_order',0,4,40,'und',0,8400000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:0:{}}s:8:\"included\";b:1;}}}'),('commerce_order','commerce_order',0,7,47,'und',0,8400000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:0:{}}s:8:\"included\";b:1;}}}');
/*!40000 ALTER TABLE `field_data_commerce_order_total` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_price`
--

DROP TABLE IF EXISTS `field_data_commerce_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_price_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_price_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_price_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_price_currency_price` (`commerce_price_amount`,`commerce_price_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 20 (commerce_price)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_price`
--

LOCK TABLES `field_data_commerce_price` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_price` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_price` VALUES ('commerce_product','rooms_product',0,1,1,'und',0,100,'USD',NULL);
/*!40000 ALTER TABLE `field_data_commerce_price` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_product`
--

DROP TABLE IF EXISTS `field_data_commerce_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_product` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_product_product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_product_product_id` (`commerce_product_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 13 (commerce_product)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_product`
--

LOCK TABLES `field_data_commerce_product` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_product` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_product` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,1),('commerce_line_item','rooms_booking',0,5,5,'und',0,1),('commerce_line_item','rooms_booking',0,6,6,'und',0,1),('commerce_line_item','rooms_booking',0,7,7,'und',0,1),('commerce_line_item','rooms_booking',0,8,8,'und',0,1),('commerce_line_item','rooms_booking',0,9,9,'und',0,1),('commerce_line_item','rooms_booking',0,11,11,'und',0,1),('commerce_line_item','rooms_booking',0,16,16,'und',0,1);
/*!40000 ALTER TABLE `field_data_commerce_product` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_total`
--

DROP TABLE IF EXISTS `field_data_commerce_total`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_total` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_total_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_total_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_total_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_total_currency_price` (`commerce_total_amount`,`commerce_total_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 12 (commerce_total)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_total`
--

LOCK TABLES `field_data_commerce_total` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_total` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_total` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,35000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:35000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,5,5,'und',0,2200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:2200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,6,6,'und',0,55000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:55000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,7,7,'und',0,2200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:2200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,8,8,'und',0,200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,9,9,'und',0,200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,11,11,'und',0,8400000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,16,16,'und',0,8400000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}');
/*!40000 ALTER TABLE `field_data_commerce_total` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_commerce_unit_price`
--

DROP TABLE IF EXISTS `field_data_commerce_unit_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_commerce_unit_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_unit_price_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_unit_price_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_unit_price_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_unit_price_currency_price` (`commerce_unit_price_amount`,`commerce_unit_price_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 11 (commerce_unit_price)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_commerce_unit_price`
--

LOCK TABLES `field_data_commerce_unit_price` WRITE;
/*!40000 ALTER TABLE `field_data_commerce_unit_price` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_commerce_unit_price` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,35000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:35000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,5,5,'und',0,2200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:2200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,6,6,'und',0,55000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:55000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,7,7,'und',0,2200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:2200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,8,8,'und',0,200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,9,9,'und',0,200000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:200000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,11,11,'und',0,8400000,'USD','a:2:{i:0;s:0:\"\";s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:2:{i:0;s:0:\"\";s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}'),('commerce_line_item','rooms_booking',0,16,16,'und',0,8400000,'USD','a:1:{s:10:\"components\";a:1:{i:0;a:3:{s:4:\"name\";s:10:\"base_price\";s:5:\"price\";a:3:{s:6:\"amount\";i:8400000;s:13:\"currency_code\";s:3:\"USD\";s:4:\"data\";a:1:{s:10:\"components\";a:0:{}}}s:8:\"included\";b:1;}}}');
/*!40000 ALTER TABLE `field_data_commerce_unit_price` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_field_availability`
--

DROP TABLE IF EXISTS `field_data_field_availability`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_availability` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_availability_unit_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_availability_unit_id` (`field_availability_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 27 (field_availability)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_availability`
--

LOCK TABLES `field_data_field_availability` WRITE;
/*!40000 ALTER TABLE `field_data_field_availability` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_field_availability` VALUES ('node','unit_description',0,3,3,'und',0,14),('node','unit_description',0,4,4,'und',0,17),('node','unit_description',0,5,5,'und',0,20);
/*!40000 ALTER TABLE `field_data_field_availability` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_field_description`
--

DROP TABLE IF EXISTS `field_data_field_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_description_value` longtext,
  `field_description_summary` longtext,
  `field_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_description_format` (`field_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 28 (field_description)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_description`
--

LOCK TABLES `field_data_field_description` WRITE;
/*!40000 ALTER TABLE `field_data_field_description` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_field_description` VALUES ('node','unit_description',0,3,3,'und',0,'Morbi nec malesuada ligula. Praesent quis turpis leo, quis fermentum neque. Donec vitae gravida nisi. Quisque vitae velit erat! Nam sed nisi orci. Nulla lobortis porta lacus, sit amet commodo dolor hendrerit congue. Phasellus sed erat in mauris euismod tristique! Etiam sit amet augue id metus lacinia condimentum ut at dui. Integer eget est at augue scelerisque tempor.\r\n\r\nAliquam consectetur pulvinar ipsum vitae bibendum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Pellentesque vel dui elit, vel dignissim sapien. Vivamus nisi neque, lobortis id euismod ac; sollicitudin id eros. Morbi nibh enim, euismod ac tempus eleifend; dignissim ut ligula. Quisque dapibus venenatis euismod.\r\n\r\nSed suscipit venenatis velit at adipiscing? Sed quis lacus eros, nec pulvinar justo? Praesent aliquet orci ac tortor adipiscing bibendum. Nulla faucibus justo purus. Aenean scelerisque, lorem id sodales pulvinar, ligula magna cursus est, vitae facilisis mauris dui ac risus. Aliquam lacinia, felis egestas convallis congue, justo ante auctor leo, ut ornare magna augue et lacus. Donec amet.\r\n','','filtered_html'),('node','unit_description',0,4,4,'und',0,'Duis semper massa a nibh feugiat tempus. Proin tempor rutrum sapien, nec ornare ligula rutrum et. Morbi elit quam, interdum nec consectetur at, egestas quis velit. Aliquam erat volutpat. Curabitur imperdiet urna sed metus pharetra ac malesuada urna pulvinar. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc ullamcorper viverra tristique? Morbi sit amet iaculis arcu.\r\n\r\nEtiam porttitor orci a dolor lacinia aliquet. Nullam lacus est; facilisis posuere pharetra ut; varius in libero. Quisque venenatis varius augue, vel pellentesque magna convallis rhoncus. Sed nec dolor ac sem congue commodo. Curabitur dignissim nulla a libero posuere vel mollis sem malesuada. Vestibulum sapien purus, iaculis ac vulputate id, tristique vitae lacus. Sed dolor purus, pretium id congue et, placerat sit amet felis. Aenean quis tortor felis, id rhoncus nibh.\r\n\r\nInteger dui dolor, aliquam et ultrices sed, accumsan sit amet turpis. Mauris viverra rhoncus adipiscing. Fusce ut leo at lectus eleifend eleifend. Donec dapibus dui non tortor consectetur accumsan. Nullam at elit ligula, in semper nisi! Phasellus eget est justo, eu consequat nunc? Maecenas hendrerit sodales felis, at euismod libero dapibus metus.\r\n','','filtered_html'),('node','unit_description',0,5,5,'und',0,'Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam a iaculis leo. Curabitur vitae urna erat, sit amet ornare tellus. In vitae ipsum leo. Pellentesque aliquet nisi non ipsum cursus semper. Nullam ultrices ornare aliquet! Pellentesque nec dignissim enim. Sed congue, neque ut eleifend adipiscing, leo sem hendrerit risus, fermentum feugiat velit nulla quis ligula. Morbi condimentum viverra elit, vel faucibus justo pretium non. Praesent congue massa vitae massa accumsan consectetur lacinia sapien dapibus. Phasellus placerat hendrerit libero sit amet faucibus.\r\n\r\nMorbi tincidunt commodo risus non dapibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque viverra lacus id nibh tempus ut auctor quam auctor. Nulla mattis neque sed metus rutrum sit amet pharetra justo scelerisque. Nullam a euismod mi. Curabitur facilisis ligula eu arcu hendrerit non adipiscing orci aliquam. Nunc condimentum condimentum erat, eu eleifend neque tristique quis. Quisque eros sem, ultricies in fringilla tristique, mollis a enim? Sed vitae sapien urna. Cras ipsum sem, accumsan quis hendrerit eget, aliquet at sem? cras amet.\r\n','','filtered_html'),('rooms_unit','basic_suite',0,14,14,'und',0,'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n','','filtered_html'),('rooms_unit','basic_suite',0,15,15,'und',0,'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n','','filtered_html'),('rooms_unit','basic_suite',0,16,16,'und',0,'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n','','filtered_html'),('rooms_unit','deluxe_suite',0,17,17,'und',0,'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n','','filtered_html'),('rooms_unit','deluxe_suite',0,18,18,'und',0,'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n','','filtered_html'),('rooms_unit','deluxe_suite',0,19,19,'und',0,'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n','','filtered_html'),('rooms_unit','luxury_suite',0,20,20,'und',0,'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n','','filtered_html'),('rooms_unit','luxury_suite',0,21,21,'und',0,'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n','','filtered_html'),('rooms_unit','luxury_suite',0,22,22,'und',0,'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n','','filtered_html'),('rooms_unit','royal_suite',0,23,23,'und',0,'Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n','','filtered_html'),('rooms_unit','royal_suite',0,24,24,'und',0,'Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n','','filtered_html');
/*!40000 ALTER TABLE `field_data_field_description` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_field_image`
--

DROP TABLE IF EXISTS `field_data_field_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 4 (field_image)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_image`
--

LOCK TABLES `field_data_field_image` WRITE;
/*!40000 ALTER TABLE `field_data_field_image` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_field_image` VALUES ('node','article',0,21,21,'und',0,114,'','',676,396),('node','article',0,22,22,'und',0,112,'','',676,396),('rooms_unit','basic_suite',0,14,14,'und',0,2,'','',200,165),('rooms_unit','basic_suite',0,15,15,'und',0,2,'','',200,165),('rooms_unit','basic_suite',0,16,16,'und',0,2,'','',200,165),('rooms_unit','deluxe_suite',0,17,17,'und',0,3,'','',200,165),('rooms_unit','deluxe_suite',0,18,18,'und',0,3,'','',200,165),('rooms_unit','deluxe_suite',0,19,19,'und',0,3,'','',200,165),('rooms_unit','luxury_suite',0,20,20,'und',0,4,'','',200,165),('rooms_unit','luxury_suite',0,21,21,'und',0,4,'','',200,165),('rooms_unit','luxury_suite',0,22,22,'und',0,4,'','',200,165),('rooms_unit','royal_suite',0,23,23,'und',0,5,'','',2400,1895),('rooms_unit','royal_suite',0,24,24,'und',0,5,'','',2400,1895);
/*!40000 ALTER TABLE `field_data_field_image` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_field_images`
--

DROP TABLE IF EXISTS `field_data_field_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_images` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_images_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_images_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_images_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_images_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_images_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_images_fid` (`field_images_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 23 (field_images)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_images`
--

LOCK TABLES `field_data_field_images` WRITE;
/*!40000 ALTER TABLE `field_data_field_images` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_field_images` VALUES ('node','promotions',0,2,2,'und',0,1,'','',260,286),('node','unit_description',0,3,3,'und',0,117,'','',220,150),('node','unit_description',0,3,3,'und',1,118,'','',220,150),('node','unit_description',0,3,3,'und',2,119,'','',220,150),('node','unit_description',0,3,3,'und',3,120,'','',676,396),('node','unit_description',0,4,4,'und',0,121,'','',220,150),('node','unit_description',0,4,4,'und',1,122,'','',220,150),('node','unit_description',0,4,4,'und',2,123,'','',220,150),('node','unit_description',0,4,4,'und',3,124,'','',220,150),('node','unit_description',0,5,5,'und',0,125,'','',220,150),('node','unit_description',0,5,5,'und',1,126,'','',220,150),('node','unit_description',0,5,5,'und',2,127,'','',220,150),('node','unit_description',0,5,5,'und',3,128,'','',220,150),('node','services_facilities',0,6,6,'und',0,91,'','',676,396),('node','services_facilities',0,7,7,'und',0,92,'','',676,396),('node','services_facilities',0,8,8,'und',0,93,'','',676,396),('node','photo_galleries',0,9,9,'und',0,45,'','',676,396),('node','photo_galleries',0,9,9,'und',1,46,'','',676,396),('node','photo_galleries',0,9,9,'und',2,47,'','',676,396),('node','photo_galleries',0,9,9,'und',3,48,'','',676,396),('node','photo_galleries',0,10,10,'und',0,49,'','',676,396),('node','photo_galleries',0,10,10,'und',1,50,'','',676,396),('node','photo_galleries',0,10,10,'und',2,72,'','',676,396),('node','news_events',0,11,11,'und',0,103,'','',676,396),('node','news_events',0,12,12,'und',0,104,'','',676,396),('node','news_events',0,13,13,'und',0,105,'','',676,396),('node','promotions',0,14,14,'und',0,41,'','',260,286),('node','services_facilities',0,16,16,'und',0,94,'','',676,396),('node','services_facilities',0,17,17,'und',0,95,'','',676,396),('node','photo_galleries',0,18,18,'und',0,68,'','',676,396),('node','photo_galleries',0,18,18,'und',1,69,'','',676,396),('node','photo_galleries',0,18,18,'und',2,70,'','',676,396),('node','photo_galleries',0,18,18,'und',3,71,'','',676,396),('node','photo_galleries',0,19,19,'und',0,75,'','',676,396),('node','photo_galleries',0,19,19,'und',1,76,'','',676,396),('node','photo_galleries',0,19,19,'und',2,77,'','',676,396),('node','photo_galleries',0,19,19,'und',3,78,'','',676,396),('node','news_events',0,23,23,'und',0,102,'','',676,396),('node','news_events',0,24,24,'und',0,101,'','',676,396);
/*!40000 ALTER TABLE `field_data_field_images` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_field_slideshow_image`
--

DROP TABLE IF EXISTS `field_data_field_slideshow_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_slideshow_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_slideshow_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_slideshow_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_slideshow_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_slideshow_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_slideshow_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_slideshow_image_fid` (`field_slideshow_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 25 (field_slideshow_image)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_slideshow_image`
--

LOCK TABLES `field_data_field_slideshow_image` WRITE;
/*!40000 ALTER TABLE `field_data_field_slideshow_image` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_field_slideshow_image` VALUES ('node','article',0,20,20,'und',0,116,'','',980,300),('node','article',0,21,21,'und',0,115,'','',980,300),('node','article',0,22,22,'und',0,113,'','',980,300);
/*!40000 ALTER TABLE `field_data_field_slideshow_image` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_field_tags`
--

DROP TABLE IF EXISTS `field_data_field_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 3 (field_tags)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_tags`
--

LOCK TABLES `field_data_field_tags` WRITE;
/*!40000 ALTER TABLE `field_data_field_tags` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `field_data_field_tags` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booked_bookingprice`
--

DROP TABLE IF EXISTS `field_data_rooms_booked_bookingprice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booked_bookingprice` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_bookingprice_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 19 (rooms_booked_bookingprice)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booked_bookingprice`
--

LOCK TABLES `field_data_rooms_booked_bookingprice` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booked_bookingprice` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_rooms_booked_bookingprice` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,350),('commerce_line_item','rooms_booking',0,5,5,'und',0,22000),('commerce_line_item','rooms_booking',0,6,6,'und',0,550),('commerce_line_item','rooms_booking',0,7,7,'und',0,22000),('commerce_line_item','rooms_booking',0,8,8,'und',0,2000),('commerce_line_item','rooms_booking',0,9,9,'und',0,2000),('commerce_line_item','rooms_booking',0,11,11,'und',0,84000),('commerce_line_item','rooms_booking',0,16,16,'und',0,84000);
/*!40000 ALTER TABLE `field_data_rooms_booked_bookingprice` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booked_price`
--

DROP TABLE IF EXISTS `field_data_rooms_booked_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booked_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_price_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 18 (rooms_booked_price)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booked_price`
--

LOCK TABLES `field_data_rooms_booked_price` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booked_price` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_rooms_booked_price` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,35000),('commerce_line_item','rooms_booking',0,5,5,'und',0,2200000),('commerce_line_item','rooms_booking',0,6,6,'und',0,55000),('commerce_line_item','rooms_booking',0,7,7,'und',0,2200000),('commerce_line_item','rooms_booking',0,8,8,'und',0,200000),('commerce_line_item','rooms_booking',0,9,9,'und',0,200000),('commerce_line_item','rooms_booking',0,11,11,'und',0,8400000),('commerce_line_item','rooms_booking',0,16,16,'und',0,8400000);
/*!40000 ALTER TABLE `field_data_rooms_booked_price` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booked_status`
--

DROP TABLE IF EXISTS `field_data_rooms_booked_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booked_status` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_status_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 17 (rooms_booked_status)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booked_status`
--

LOCK TABLES `field_data_rooms_booked_status` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booked_status` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_rooms_booked_status` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,1),('commerce_line_item','rooms_booking',0,5,5,'und',0,1),('commerce_line_item','rooms_booking',0,6,6,'und',0,1),('commerce_line_item','rooms_booking',0,7,7,'und',0,1),('commerce_line_item','rooms_booking',0,8,8,'und',0,1),('commerce_line_item','rooms_booking',0,9,9,'und',0,1),('commerce_line_item','rooms_booking',0,11,11,'und',0,1),('commerce_line_item','rooms_booking',0,16,16,'und',0,1);
/*!40000 ALTER TABLE `field_data_rooms_booked_status` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booked_unit_id`
--

DROP TABLE IF EXISTS `field_data_rooms_booked_unit_id`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booked_unit_id` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_unit_id_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 16 (rooms_booked_unit_id)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booked_unit_id`
--

LOCK TABLES `field_data_rooms_booked_unit_id` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booked_unit_id` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_rooms_booked_unit_id` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,14),('commerce_line_item','rooms_booking',0,5,5,'und',0,24),('commerce_line_item','rooms_booking',0,6,6,'und',0,15),('commerce_line_item','rooms_booking',0,7,7,'und',0,24),('commerce_line_item','rooms_booking',0,8,8,'und',0,22),('commerce_line_item','rooms_booking',0,9,9,'und',0,21),('commerce_line_item','rooms_booking',0,11,11,'und',0,23),('commerce_line_item','rooms_booking',0,16,16,'und',0,24);
/*!40000 ALTER TABLE `field_data_rooms_booked_unit_id` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booking_children_ages`
--

DROP TABLE IF EXISTS `field_data_rooms_booking_children_ages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booking_children_ages` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_children_ages_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 33 (rooms_booking_children_ages)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booking_children_ages`
--

LOCK TABLES `field_data_rooms_booking_children_ages` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booking_children_ages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `field_data_rooms_booking_children_ages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booking_dates`
--

DROP TABLE IF EXISTS `field_data_rooms_booking_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booking_dates` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_dates_value` varchar(20) DEFAULT NULL,
  `rooms_booking_dates_value2` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 15 (rooms_booking_dates)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booking_dates`
--

LOCK TABLES `field_data_rooms_booking_dates` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booking_dates` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_rooms_booking_dates` VALUES ('commerce_line_item','rooms_booking',0,4,4,'und',0,'2012-06-21','2012-06-27'),('commerce_line_item','rooms_booking',0,5,5,'und',0,'2012-06-18','2012-06-28'),('commerce_line_item','rooms_booking',0,6,6,'und',0,'2012-06-18','2012-06-28'),('commerce_line_item','rooms_booking',0,7,7,'und',0,'2012-06-19','2012-06-29'),('commerce_line_item','rooms_booking',0,8,8,'und',0,'2012-06-19','2012-06-28'),('commerce_line_item','rooms_booking',0,9,9,'und',0,'2012-06-20','2012-06-29'),('commerce_line_item','rooms_booking',0,11,11,'und',0,'2012-06-19','2012-07-30'),('commerce_line_item','rooms_booking',0,16,16,'und',0,'2017-07-20','2017-08-31');
/*!40000 ALTER TABLE `field_data_rooms_booking_dates` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booking_number_people`
--

DROP TABLE IF EXISTS `field_data_rooms_booking_number_people`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booking_number_people` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_number_people_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 29 (rooms_booking_number_people)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booking_number_people`
--

LOCK TABLES `field_data_rooms_booking_number_people` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booking_number_people` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_data_rooms_booking_number_people` VALUES ('commerce_line_item','rooms_booking',0,16,16,'und',0,2),('commerce_line_item','rooms_booking',0,16,16,'und',1,0);
/*!40000 ALTER TABLE `field_data_rooms_booking_number_people` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booking_options`
--

DROP TABLE IF EXISTS `field_data_rooms_booking_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booking_options` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_options_name` varchar(255) NOT NULL,
  `rooms_booking_options_quantity` int(11) DEFAULT NULL,
  `rooms_booking_options_operation` varchar(255) DEFAULT NULL,
  `rooms_booking_options_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 30 (rooms_booking_options)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booking_options`
--

LOCK TABLES `field_data_rooms_booking_options` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booking_options` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `field_data_rooms_booking_options` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booking_reference`
--

DROP TABLE IF EXISTS `field_data_rooms_booking_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booking_reference` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_reference_target_id` int(10) unsigned NOT NULL COMMENT 'The id of the target entity.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `rooms_booking_reference_target_id` (`rooms_booking_reference_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 31 (rooms_booking_reference)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booking_reference`
--

LOCK TABLES `field_data_rooms_booking_reference` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booking_reference` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `field_data_rooms_booking_reference` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_data_rooms_booking_unit_options`
--

DROP TABLE IF EXISTS `field_data_rooms_booking_unit_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_rooms_booking_unit_options` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_unit_options_name` varchar(255) NOT NULL,
  `rooms_booking_unit_options_quantity` int(11) DEFAULT NULL,
  `rooms_booking_unit_options_operation` varchar(255) DEFAULT NULL,
  `rooms_booking_unit_options_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 32 (rooms_booking_unit_options)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_rooms_booking_unit_options`
--

LOCK TABLES `field_data_rooms_booking_unit_options` WRITE;
/*!40000 ALTER TABLE `field_data_rooms_booking_unit_options` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `field_data_rooms_booking_unit_options` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_revision_body`
--

DROP TABLE IF EXISTS `field_revision_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 2 (body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_body`
--

LOCK TABLES `field_revision_body` WRITE;
/*!40000 ALTER TABLE `field_revision_body` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_revision_body` VALUES ('node','page',0,1,1,'und',0,'<dl class=\"support-content\">\r\n<dt>Contact us</dt>\r\n<dd><p>Suspendisse vel sollicitudin metus. Fusce ac turpis quis elit eleifend vestibulum id sed tellus. Fusce vulputate faucibus auctor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed cursus sapien aliquet mauris auctor egestas. Cras at nisl sed metus tempor posuere vel at tellus. Cras faucibus dui sed lectus elementum vitae imperdiet lectus pulvinar. Quisque non sapien neque. Vestibulum a mi lectus. </p></dd>\r\n<dt>Recent Stay Comments</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n<dt>Reservations FAQ</dt>\r\n<dd><p>Morbi pellentesque adipiscing dui, in vehicula lorem dictum sollicitudin. Praesent pretium placerat dictum. Sed suscipit, leo ac gravida egestas, nibh nisl viverra odio, a pulvinar mauris turpis non augue. Quisque non metus metus, ac congue tortor. Nam ac lorem quam. Morbi et sem sit amet odio egestas semper. Mauris venenatis porta ligula euismod venenatis. Vivamus nibh lacus, tincidunt eget lobortis eget, pharetra sit amet sapien.</p><p>Proin commodo massa sed lorem ullamcorper eget pulvinar magna pharetra. Quisque sollicitudin interdum felis, in tristique est rutrum quis. Suspendisse eu fringilla dolor. Integer vitae mauris est. Suspendisse potenti. Nulla lacinia molestie porta. </p></dd>\r\n<dt>Call Us</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n</dl>','','full_html'),('node','promotions',0,2,2,'und',0,'Nullam a dapibus arcu. Duis nec velit nec dolor cursus condimentum in id massa. Ut elementum, arcu in dignissim bibendum, ante justo commodo leo, non condimentum mauris diam in nulla. Etiam tincidunt est sit amet magna luctus condimentum. Aliquam mattis rutrum eros et tincidunt. Sed eu cursus neque. Cras egestas felis sit amet mauris accumsan eget sodales lacus vulputate. Etiam pulvinar neque et nisl fringilla ut mattis est eleifend. Vestibulum metus urna, vulputate nec aliquet aliquet, volutpat vitae erat. Nullam nibh lectus, ultricies adipiscing aliquam ac, varius et magna. Phasellus ut nisi volutpat mi tempor faucibus eu eget nulla? Curabitur molestie laoreet tellus, ut egestas erat vehicula non.\r\n\r\nVivamus porta faucibus mi, id congue elit convallis non. Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem. Curabitur condimentum enim sit amet eros tempus fringilla? Donec arcu magna, varius eu elementum et, faucibus nec arcu. Aenean varius, purus a dignissim fermentum; purus leo venenatis dui, nec rhoncus neque augue ut dolor. Duis aliquet risus sit amet purus suscipit ut faucibus urna gravida? Duis vitae risus eu sem aliquet sodales. Donec sit amet ligula metus.\r\n','','filtered_html'),('node','services_facilities',0,6,6,'und',0,'Revitalize with a healthy workout in the fully appointed fitness center. Maximize your workout routine with treadmills, cycles, and workout station. Enjoy the panorama from the 24th floor, or watch a variety of international channels on the 32” televisions. And experience total relaxation after your work out in the separate saunas for men and women.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 to 22:00','','filtered_html'),('node','services_facilities',0,7,7,'und',0,'Lounge by the swimming pool and take in the spectacular views of Saigon from the 24th floor. The swimming pool has a maximum depth of 1.8 meters. Poolside furniture offers a pristine spot to read a book, enjoy a drink, or just bask in some tropical rays.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 - 22:00','','filtered_html'),('node','services_facilities',0,8,8,'und',0,'With meeting rooms, copy and fax services, and internet connectivity, accomplishing important tasks is quick and efficient at the Business Center. Using the on-site computers, you can check email, browse the net, or look up your next travel destination. Our experienced receptionist is at hand to help you solve any problems that may arise.\r\n\r\nLocation: 4th floor','','filtered_html'),('node','photo_galleries',0,9,9,'und',0,'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.\r\n','','filtered_html'),('node','photo_galleries',0,10,10,'und',0,'Pellentesque molestie, quam sit amet aliquet porttitor, enim neque bibendum turpis, ac convallis orci lectus id est. Aenean nec diam nec nibh fermentum malesuada sit amet in nisl. Integer varius, metus nec dictum blandit, ante felis suscipit quam, sed tincidunt ante dui sed enim. Fusce gravida, magna at posuere pretium, leo purus dictum ipsum, eleifend ornare tellus justo ac augue. Aenean et pharetra leo. Sed ut lectus felis. Praesent vitae velit quis mi ultrices vehicula vel ac leo.\r\n\r\nQuisque erat ligula, tempus et interdum eu, egestas a libero. Sed a condimentum felis! In semper enim eu ligula luctus luctus. Ut mattis, nisi in congue condimentum, velit diam semper orci, quis tincidunt urna ligula at ligula? Nullam ante purus, elementum at ultrices in, mollis non massa. Nulla commodo, felis in pretium ornare, nunc mi dignissim ligula, non pellentesque orci leo sit amet orci. Nulla tincidunt fringilla nulla, sit amet vestibulum leo porttitor eu. Curabitur sit amet sapien a ipsum pulvinar tristique eget in velit. Donec sagittis vulputate sem ac consequat. Aliquam sem urna, tristique sit amet commodo a; placerat at enim! Nulla eu bibendum tortor. Pellentesque vitae nulla et elit nullam.\r\n','','filtered_html'),('node','news_events',0,11,11,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','news_events',0,12,12,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','news_events',0,13,13,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','promotions',0,14,14,'und',0,'Mauris lacinia tellus sit amet justo laoreet facilisis. Fusce non urna ut libero tempus auctor sit amet in leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Curabitur vel nunc a enim commodo porta non eget augue. Duis placerat, risus a faucibus tempor, ligula diam imperdiet justo, nec venenatis orci magna at augue! Ut ut mauris id sem feugiat molestie. Morbi ac magna sapien, nec sollicitudin nibh. Aenean auctor molestie leo, sit amet malesuada nisi pulvinar sit amet. Nullam mollis iaculis cursus. Morbi id tristique felis. Aenean sagittis sollicitudin mollis. Nulla facilisi. Maecenas molestie tincidunt aliquam. In luctus, nunc at consequat iaculis, dolor turpis consequat nisi, ac interdum mi mauris euismod mi? Aliquam eu elementum arcu!\r\n\r\nQuisque sit amet felis ligula, a porttitor nunc. Nullam ac ante et purus viverra imperdiet? Nam id tellus arcu, eu convallis sapien. Sed sit amet mattis risus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam mattis tellus non arcu pharetra at porta libero lobortis. Morbi eleifend mauris sed mauris molestie quis blandit massa lobortis! Aliquam molestie, elit sed.\r\n','','filtered_html'),('node','article',0,15,15,'und',0,'Curabitur dapibus felis sit amet odio sodales ultrices. Sed non dolor tortor. Donec blandit diam sed ligula tempor egestas. Cras rhoncus enim tortor, vel venenatis libero. Sed eu sem urna, vitae luctus ligula? Pellentesque pulvinar, nisl sit amet sagittis rhoncus, neque sem luctus ante, vel sodales quam metus at turpis. Sed massa augue, sollicitudin ut tristique ut, malesuada elementum tellus. Nunc nec leo lacus? Etiam dictum, orci nec tincidunt iaculis, dui diam accumsan leo, et blandit tortor tortor non lacus. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nProin elit eros; sagittis vel facilisis vitae, facilisis vel tellus. Praesent elementum viverra orci rutrum posuere? Nunc pretium diam a purus ornare hendrerit eget a mauris. Nullam sodales orci nec neque scelerisque quis iaculis orci accumsan. Maecenas gravida quam quis odio feugiat condimentum. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nNunc odio risus, auctor ut gravida et, venenatis quis quam. Quisque dapibus dictum vestibulum. In at nunc quam, quis pellentesque risus. Aliquam venenatis enim sit amet risus congue quis adipiscing eros posuere.','','filtered_html'),('node','services_facilities',0,16,16,'und',0,'Give your children some time to relax and move about in our spacious supervised kids’ corner. Children can stimulate their bodies and minds with a variety of educational toys and games. Young adults will enjoy the games room equipped with the latest generation of video game consoles and large LCD TVs.\r\n\r\nLocation: 4th floor','','filtered_html'),('node','services_facilities',0,17,17,'und',0,'Sed scelerisque justo id massa laoreet sollicitudin. Sed id lorem ornare nunc elementum convallis. Nam lectus ligula, rutrum ac convallis vel, tempus sodales dui. Pellentesque euismod est eget sem vehicula facilisis. Pellentesque lacinia mollis eleifend. Sed cursus lobortis scelerisque. Maecenas nulla tellus, viverra a lobortis quis, bibendum vel nunc.\r\n\r\nUt accumsan orci vel dolor eleifend venenatis varius erat vestibulum. Vivamus commodo porta ligula, ut dictum ligula ornare ac. Nulla erat dui, condimentum a malesuada quis, pharetra ut nulla. Vivamus posuere semper massa, quis volutpat nulla porta sit amet. Vivamus rhoncus, risus quis sodales egestas, orci risus volutpat felis, sed euismod massa quam non velit.\r\n\r\nLocation: 4th floor','','filtered_html'),('node','photo_galleries',0,18,18,'und',0,'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.','','filtered_html'),('node','photo_galleries',0,19,19,'und',0,'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.','','filtered_html'),('node','article',0,20,20,'und',0,'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.','','filtered_html'),('node','article',0,21,21,'und',0,'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n','','filtered_html'),('node','article',0,22,22,'und',0,'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n','','filtered_html'),('node','news_events',0,23,23,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html'),('node','news_events',0,24,24,'und',0,'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.','','filtered_html');
/*!40000 ALTER TABLE `field_revision_body` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_revision_comment_body`
--

DROP TABLE IF EXISTS `field_revision_comment_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 1 (comment_body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_comment_body`
--

LOCK TABLES `field_revision_comment_body` WRITE;
/*!40000 ALTER TABLE `field_revision_comment_body` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_revision_comment_body` VALUES ('comment','comment_node_promotions',0,1,1,'und',0,'Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem.','filtered_html');
/*!40000 ALTER TABLE `field_revision_comment_body` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_revision_commerce_customer_address`
--

DROP TABLE IF EXISTS `field_revision_commerce_customer_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_commerce_customer_address` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_address_country` varchar(2) DEFAULT '' COMMENT 'Two letter ISO country code of this address.',
  `commerce_customer_address_administrative_area` varchar(255) DEFAULT '' COMMENT 'The administrative area of this address. (i.e. State/Province)',
  `commerce_customer_address_sub_administrative_area` varchar(255) DEFAULT '' COMMENT 'The sub administrative area of this address.',
  `commerce_customer_address_locality` varchar(255) DEFAULT '' COMMENT 'The locality of this address. (i.e. City)',
  `commerce_customer_address_dependent_locality` varchar(255) DEFAULT '' COMMENT 'The dependent locality of this address.',
  `commerce_customer_address_postal_code` varchar(255) DEFAULT '' COMMENT 'The postal code of this address.',
  `commerce_customer_address_thoroughfare` varchar(255) DEFAULT '' COMMENT 'The thoroughfare of this address. (i.e. Street address)',
  `commerce_customer_address_premise` varchar(255) DEFAULT '' COMMENT 'The premise of this address. (i.e. Apartment / Suite number)',
  `commerce_customer_address_sub_premise` varchar(255) DEFAULT '' COMMENT 'The sub_premise of this address.',
  `commerce_customer_address_organisation_name` varchar(255) DEFAULT '' COMMENT 'Contents of a primary OrganisationName element in the xNL XML.',
  `commerce_customer_address_name_line` varchar(255) DEFAULT '' COMMENT 'Contents of a primary NameLine element in the xNL XML.',
  `commerce_customer_address_first_name` varchar(255) DEFAULT '' COMMENT 'Contents of the FirstName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_last_name` varchar(255) DEFAULT '' COMMENT 'Contents of the LastName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_data` longtext COMMENT 'Additional data for this address.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 5 (commerce_customer...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_commerce_customer_address`
--

LOCK TABLES `field_revision_commerce_customer_address` WRITE;
/*!40000 ALTER TABLE `field_revision_commerce_customer_address` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_revision_commerce_customer_address` VALUES ('commerce_customer_profile','billing',0,1,1,'und',0,'VN','048',NULL,'hcm',NULL,'014','11','1111',NULL,NULL,'Trung',NULL,NULL,NULL),('commerce_customer_profile','billing',0,2,2,'und',0,'VN','014',NULL,'hcm',NULL,'12','94 B5 Hung Vuong F9 Q5','',NULL,NULL,'Huynh Huu Trung',NULL,NULL,NULL),('commerce_customer_profile','billing',0,3,3,'und',0,'VN','084',NULL,'HCM',NULL,'084','364 Cong Hoa Tan Binh ','',NULL,NULL,'Nguyen Ngoc Hai',NULL,NULL,NULL),('commerce_customer_profile','billing',0,4,4,'und',0,'VN','084',NULL,'HCM',NULL,'084','94 B5 Hung Vuong F9 Q5','',NULL,NULL,'Huynh Huu Trung',NULL,NULL,NULL);
/*!40000 ALTER TABLE `field_revision_commerce_customer_address` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `field_revision_commerce_customer_billing`
--

DROP TABLE IF EXISTS `field_revision_commerce_customer_billing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_commerce_customer_billing` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_billing_profile_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_customer_billing_profile_id` (`commerce_customer_billing_profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 8 (commerce_customer...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_commerce_customer_billing`
--

LOCK TABLES `field_revision_commerce_customer_billing` WRITE;
/*!40000 ALTER TABLE `field_revision_commerce_customer_billing` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `field_revision_commerce_customer_billing` VALUES ('commerce_order','commerce_order',0,1,6,'und',0,1),('commerce_order','commerce_order',0,1,7,'und',0,1),('commerce_order','commerce_order',0,1,8,'und',0,1),('commerce_order','commerce_order',0,1,9,'und',0,1),('commerce_order','commerce_order',0,1,10,'und',0,1),('commerce_order','commerce_order',0,2,12,'und',0,2),('commerce_order','commerce_order',0,2,13,'und',0,2),('commerce_order','commerce_order',0,2,14,'und',0,2),('commerce_order','commerce_order',0,2,15,'und',0,2),('commerce_order','commerce_order',0,2,16,'und',0,2),('commerce_order','commerce_order',0,2,17,'und',0,2),('commerce_order','commerce_order',0,2,18,'und',0,2),('commerce_order','commerce_order',0,2,19,'und',0,2),('commerce_order','commerce_order',0,2,20,'und',0,2),('commerce_order','commerce_order',0,2,21,'und',0,2),('commerce_order','commerce_order',0,2,22,'und',0,2),('commerce_order','commerce_order',0,2,23,'und',0,2),('commerce_order','commerce_order',0,2,24,'und',0,2),('commerce_order','commerce_order',0,2,25,'und',0,2),('commerce_order','commerce_order',0,2,26,'und',0,2),('commerce_order','commerce_order',0,2,27,'und',0,2),('commerce_order','commerce_order',0,2,28,'und',0,2),('commerce_order','commerce_order',0,3,30,'und',0,3),('commerce_order','commerce_order',0,3,31,'und',0,3),('commerce_order','commerce_order',0,3,32,'und',0,3),('commerce_order','commerce_order',0,3,33,'und',0,3),('commerce_order','commerce_order',0,3,34,'und',0,3),('commerce_order','commerce_order',0,4,36,'und',0,4),('commerce_order','commerce_order',0,4,37,'und',0,4),('commerce_order','commerce_order',0,4,38,'und',0,4),('commerce_order','commerce_order',0,4,39,'und',0,4),('commerce_order','comm