-- phpMyAdmin SQL Dump
-- version 4.0.6
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Mar 11, 2015 at 07:05 AM
-- Server version: 5.5.20-log
-- PHP Version: 5.4.36

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `wee_hotel`
--

-- --------------------------------------------------------

--
-- Table structure for table `accesslog`
--

CREATE TABLE IF NOT EXISTS `accesslog` (
  `aid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique accesslog ID.',
  `sid` varchar(128) NOT NULL DEFAULT '' COMMENT 'Browser session ID of user that visited page.',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title of page visited.',
  `path` varchar(255) DEFAULT NULL COMMENT 'Internal path to page visited (relative to Drupal root.)',
  `url` text COMMENT 'Referrer URI.',
  `hostname` varchar(128) DEFAULT NULL COMMENT 'Hostname of user that visited the page.',
  `uid` int(10) unsigned DEFAULT '0' COMMENT 'User users.uid that visited the page.',
  `timer` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Time in milliseconds that the page took to load.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Timestamp of when the page was visited.',
  PRIMARY KEY (`aid`),
  KEY `accesslog_timestamp` (`timestamp`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores site access information for statistics.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `actions`
--

CREATE TABLE IF NOT EXISTS `actions` (
  `aid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique actions ID.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The object that that action acts on (node, user, comment, system or custom types.)',
  `callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback function that executes when the action runs.',
  `parameters` longblob NOT NULL COMMENT 'Parameters to be passed to the callback function.',
  `label` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Label of the action.',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores action information.';

--
-- Dumping data for table `actions`
--

INSERT INTO `actions` (`aid`, `type`, `callback`, `parameters`, `label`) VALUES
('comment_publish_action', 'comment', 'comment_publish_action', '', 'Publish comment'),
('comment_save_action', 'comment', 'comment_save_action', '', 'Save comment'),
('comment_unpublish_action', 'comment', 'comment_unpublish_action', '', 'Unpublish comment'),
('node_make_sticky_action', 'node', 'node_make_sticky_action', '', 'Make content sticky'),
('node_make_unsticky_action', 'node', 'node_make_unsticky_action', '', 'Make content unsticky'),
('node_promote_action', 'node', 'node_promote_action', '', 'Promote content to front page'),
('node_publish_action', 'node', 'node_publish_action', '', 'Publish content'),
('node_save_action', 'node', 'node_save_action', '', 'Save content'),
('node_unpromote_action', 'node', 'node_unpromote_action', '', 'Remove content from front page'),
('node_unpublish_action', 'node', 'node_unpublish_action', '', 'Unpublish content'),
('pathauto_node_update_action', 'node', 'pathauto_node_update_action', '', 'Update node alias'),
('pathauto_taxonomy_term_update_action', 'taxonomy_term', 'pathauto_taxonomy_term_update_action', '', 'Update taxonomy term alias'),
('pathauto_user_update_action', 'user', 'pathauto_user_update_action', '', 'Update user alias'),
('system_block_ip_action', 'user', 'system_block_ip_action', '', 'Ban IP address of current user'),
('user_block_user_action', 'user', 'user_block_user_action', '', 'Block current user');

-- --------------------------------------------------------

--
-- Table structure for table `authmap`
--

CREATE TABLE IF NOT EXISTS `authmap` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique authmap ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'User’s users.uid.',
  `authname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Unique authentication name.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'Module which is controlling the authentication.',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `authname` (`authname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores distributed authentication mapping.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `batch`
--

CREATE TABLE IF NOT EXISTS `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores details about batches (processes that run in...';

--
-- Dumping data for table `batch`
--

INSERT INTO `batch` (`bid`, `token`, `timestamp`, `batch`) VALUES
(14, 'OPc64jxLbHu9cGNpOAz-hwmiUPb30Nu-ZaKmqQOyaZM', 1425615753, 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),
(15, 'xh7BkAlFm1zfS9pFmtTkRrU45frnAUGhL8buPo5Kdlg', 1425615863, 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);

-- --------------------------------------------------------

--
-- Table structure for table `block`
--

CREATE TABLE IF NOT EXISTS `block` (
  `bid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique block ID.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The module from which the block originates; for example, ’user’ for the Who’s Online block, and ’block’ for any custom blocks.',
  `delta` varchar(32) NOT NULL DEFAULT '0' COMMENT 'Unique ID for block within a module.',
  `theme` varchar(64) NOT NULL DEFAULT '' COMMENT 'The theme under which the block settings apply.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Block enabled status. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Block weight within region.',
  `region` varchar(64) NOT NULL DEFAULT '' COMMENT 'Theme region within which the block is set.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)',
  `visibility` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)',
  `pages` text NOT NULL COMMENT 'Contents of the "Pages" block; contains either a list of paths on which to include/exclude the block or PHP code, depending on "visibility" setting.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Custom title for the block. (Empty string will use block default title, <none> will remove the title, text will cause block to use specified title.)',
  `cache` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Binary flag to indicate block cache mode. (-2: Custom cache, -1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See DRUPAL_CACHE_* constants in ../includes/common.inc for more detailed information.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `tmd` (`theme`,`module`,`delta`),
  KEY `list` (`theme`,`status`,`region`,`weight`,`module`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores block settings, such as region and visibility...' AUTO_INCREMENT=109 ;

--
-- Dumping data for table `block`
--

INSERT INTO `block` (`bid`, `module`, `delta`, `theme`, `status`, `weight`, `region`, `custom`, `visibility`, `pages`, `title`, `cache`) VALUES
(1, 'system', 'main', 'bartik', 1, 0, 'content', 0, 0, '', '', -1),
(2, 'search', 'form', 'bartik', 1, -1, 'sidebar_first', 0, 0, '', '', -1),
(3, 'node', 'recent', 'seven', 1, 10, 'dashboard_main', 0, 0, '', '', -1),
(4, 'user', 'login', 'bartik', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(5, 'system', 'navigation', 'bartik', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(6, 'system', 'powered-by', 'bartik', 1, 10, 'footer', 0, 0, '', '', -1),
(7, 'system', 'help', 'bartik', 1, 0, 'help', 0, 0, '', '', -1),
(8, 'system', 'main', 'seven', 1, 0, 'content', 0, 0, '', '', -1),
(9, 'system', 'help', 'seven', 1, 0, 'help', 0, 0, '', '', -1),
(10, 'user', 'login', 'seven', 1, 10, 'content', 0, 0, '', '', -1),
(11, 'user', 'new', 'seven', 1, 0, 'dashboard_sidebar', 0, 0, '', '', -1),
(12, 'search', 'form', 'seven', 1, -10, 'dashboard_sidebar', 0, 0, '', '', -1),
(13, 'comment', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(14, 'node', 'syndicate', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(15, 'node', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(16, 'shortcut', 'shortcuts', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(17, 'system', 'management', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(18, 'system', 'user-menu', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(19, 'system', 'main-menu', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(20, 'user', 'new', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(21, 'user', 'online', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(22, 'comment', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', 1),
(23, 'node', 'syndicate', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(24, 'shortcut', 'shortcuts', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(25, 'system', 'powered-by', 'seven', 0, 10, '-1', 0, 0, '', '', -1),
(26, 'system', 'navigation', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(27, 'system', 'management', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(28, 'system', 'user-menu', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(29, 'system', 'main-menu', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(30, 'user', 'online', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', -1),
(31, 'commerce_cart', 'cart', 'bartik', 0, 0, '-1', 0, 0, 'checkout*', '', -1),
(32, 'locale', 'language', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(33, 'locationmap', 'image', 'bartik', 0, 0, '-1', 0, 1, '<front>', '', 1),
(34, 'poll', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(35, 'rooms_booking_manager', 'rooms_availability_search', 'bartik', 1, 0, 'sidebar_first', 0, 0, '', '', -1),
(36, 'site_map', 'syndicate', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(37, 'superfish', '1', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(38, 'superfish', '2', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(39, 'superfish', '3', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(40, 'superfish', '4', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(41, 'commerce_cart', 'cart', 'seven', 0, 0, '-1', 0, 0, 'checkout*', '', -1),
(42, 'locale', 'language', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(43, 'locationmap', 'image', 'seven', 0, 0, '-1', 0, 1, '<front>', '', 1),
(44, 'poll', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', 1),
(45, 'rooms_booking_manager', 'rooms_availability_search', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(46, 'site_map', 'syndicate', 'seven', 0, 0, '-1', 0, 0, '', '', 1),
(47, 'superfish', '1', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(48, 'superfish', '2', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(49, 'superfish', '3', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(50, 'superfish', '4', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(51, 'comment', 'recent', 'hotel', 0, 0, '-1', 0, 0, '', '', 1),
(52, 'commerce_cart', 'cart', 'hotel', 0, 0, '-1', 0, 0, 'checkout*', '', -1),
(53, 'locale', 'language', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(54, 'locationmap', 'image', 'hotel', 1, 0, 'panel_second_1', 0, 1, '<front>', '', 1),
(55, 'node', 'recent', 'hotel', 0, 0, '-1', 0, 0, '', '', 1),
(56, 'node', 'syndicate', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(57, 'poll', 'recent', 'hotel', 0, 0, '-1', 0, 0, '', '', 1),
(58, 'rooms_booking_manager', 'rooms_availability_search', 'hotel', 1, -17, 'sidebar_first', 0, 0, '', '', -1),
(59, 'search', 'form', 'hotel', 1, -12, 'header', 0, 0, '', '', -1),
(60, 'shortcut', 'shortcuts', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(61, 'site_map', 'syndicate', 'hotel', 0, 0, '-1', 0, 0, '', '', 1),
(62, 'superfish', '1', 'hotel', 1, 0, 'menu_bar', 0, 0, '', '', -1),
(63, 'superfish', '2', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(64, 'superfish', '3', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(65, 'superfish', '4', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(66, 'system', 'help', 'hotel', 1, 0, 'help', 0, 0, '', '', -1),
(67, 'system', 'main', 'hotel', 1, 0, 'content', 0, 0, '', '', -1),
(68, 'system', 'main-menu', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(69, 'system', 'management', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(70, 'system', 'navigation', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(71, 'system', 'powered-by', 'hotel', 0, 10, '-1', 0, 0, '', '', -1),
(72, 'system', 'user-menu', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(73, 'user', 'login', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(74, 'user', 'new', 'hotel', 0, 0, '-1', 0, 0, '', '', 1),
(75, 'user', 'online', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(76, 'menu', 'menu-top-menu', 'hotel', 1, -14, 'header', 0, 0, '', '<none>', -1),
(77, 'block', '1', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(78, 'block', '1', 'hotel', 1, -13, 'header', 0, 0, '', '', -1),
(79, 'block', '1', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(80, 'views', 'promotions-block', 'hotel', 1, 0, 'sidebar_second', 0, 1, '<front>', '<none>', -1),
(81, 'block', '2', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(82, 'block', '2', 'hotel', 1, -15, 'footer', 0, 0, '', '', -1),
(83, 'block', '2', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(84, 'block', '3', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(85, 'block', '3', 'hotel', 1, -16, 'footer', 0, 0, '', '', -1),
(86, 'block', '3', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(87, 'views', 'accommodation-block', 'hotel', 1, 0, 'panel_second_2', 0, 1, '<front>', '', -1),
(88, 'views', 'promotions-block', 'bartik', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(89, 'views', 'promotions-block', 'seven', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(90, 'menu', 'menu-top-menu', 'bartik', 0, 0, '-1', 0, 0, '', '<none>', -1),
(91, 'views', 'accommodation-block', 'bartik', 0, 0, '-1', 0, 1, '<front>', '', -1),
(92, 'menu', 'menu-top-menu', 'seven', 0, 0, '-1', 0, 0, '', '<none>', -1),
(93, 'views', 'accommodation-block', 'seven', 0, 0, '-1', 0, 1, '<front>', '', -1),
(97, 'views', 'Slideshow-block', 'hotel', 0, 0, '-1', 0, 0, '', '', -1),
(98, 'views', 'Slideshow-block', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(99, 'views', 'Slideshow-block', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(100, 'views', 'slideshow-block_1', 'hotel', 1, 0, 'slideshow', 0, 0, '', '', -1),
(101, 'views', 'slideshow-block_1', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(102, 'views', 'slideshow-block_1', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(103, 'views', 'promotions_in_left_column-block', 'hotel', 1, -15, 'sidebar_first', 0, 0, '<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions', '<none>', -1),
(104, 'views', 'promotions_in_left_column-block', 'bartik', 0, 0, '-1', 0, 0, '<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions', '<none>', -1),
(105, 'views', 'promotions_in_left_column-block', 'seven', 0, 0, '-1', 0, 0, '<front>\r\nphoto-galleries\r\ncontact\r\nuser\r\nuser/*\r\nsupport\r\npromotions', '<none>', -1),
(106, 'block', '5', 'bartik', 0, 0, '-1', 0, 0, '<front>', '', -1),
(107, 'block', '5', 'hotel', 1, -16, 'sidebar_first', 0, 0, '<front>', '', -1),
(108, 'block', '5', 'seven', 0, 0, '-1', 0, 0, '<front>', '', -1);

-- --------------------------------------------------------

--
-- Table structure for table `blocked_ips`
--

CREATE TABLE IF NOT EXISTS `blocked_ips` (
  `iid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: unique ID for IP addresses.',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP address',
  PRIMARY KEY (`iid`),
  KEY `blocked_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores blocked IP addresses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `block_custom`
--

CREATE TABLE IF NOT EXISTS `block_custom` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made blocks.' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `block_custom`
--

INSERT INTO `block_custom` (`bid`, `body`, `info`, `format`) VALUES
(1, '<p>Follow us on:</p>\r\n<ul class="socials">\r\n<li>\r\n <a href="#" class="facebook-follow" title="Facebook">Facebook</a>\r\n</li>\r\n<li>\r\n<a href="#" class="twitter-follow" title="Twitter">Twitter</a>\r\n</li>\r\n<li>\r\n<a href="#" class="google-plus-follow" title="Google Plus">Google Plus</a>\r\n</li>\r\n</ul>', 'Follow social', 'full_html'),
(2, '<ul class="contact-info">\r\n<li class="tel">Tel.\\Fax: 222-1111 \\ 111-1111</li>\r\n<li class="email-address">Email: <a href="mailto:services@jasper-hotel.com">services@jasper-hotel.com</a></li>\r\n</ul>', 'Contact Information', 'filtered_html'),
(3, 'Designed by <a href="http://www.weebpal.com">WeebPal Drupal Themes</a>. Powered by <a href="http://drupal.org" target="_blank">Drupal</a>.', 'Jasper hotel Copyright Notice Block. Ussuallly locate in footer.', 'filtered_html'),
(5, '<dl class="contact-list">\r\n<dt>General Information</dt>\r\n<dd>\r\n<p>4 New York Plaza, New York, NY 10004</p>\r\n<p>Tel: (212) 210-2100</p>\r\n<p>Fax: (212) 210-2100</p>\r\n<p>Email: <a href="mailto:hotel@jasper.com">hotel@jasper.com</a></p>\r\n</dd>\r\n<dt>Sales and Marketing</dt>\r\n<dd>\r\n<p>Email: <a href="mailto:hotel@jasper.com">hotel@jasper.com</a></p>\r\n<p>Direct fax: (212) 210-2100</p>\r\n</dd>\r\n<dt>Reservations</dt>\r\n<dd class="last">\r\n<p>Email: <a href="mailto:hotel@jasper.com">hotel@jasper.com</a></p>\r\n<p>Direct fax: (212) 210-2100</p>\r\n</dd>\r\n</dl>', 'General Information', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `block_node_type`
--

CREATE TABLE IF NOT EXISTS `block_node_type` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type from node_type.type.',
  PRIMARY KEY (`module`,`delta`,`type`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up display criteria for blocks based on content types';

-- --------------------------------------------------------

--
-- Table structure for table `block_role`
--

CREATE TABLE IF NOT EXISTS `block_role` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `rid` int(10) unsigned NOT NULL COMMENT 'The user’s role ID from users_roles.rid.',
  PRIMARY KEY (`module`,`delta`,`rid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up access permissions for blocks based on user roles';

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE IF NOT EXISTS `cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_block`
--

CREATE TABLE IF NOT EXISTS `cache_block` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Block module to store already built...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_bootstrap`
--

CREATE TABLE IF NOT EXISTS `cache_bootstrap` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for data required to bootstrap Drupal, may be...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_field`
--

CREATE TABLE IF NOT EXISTS `cache_field` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_filter`
--

CREATE TABLE IF NOT EXISTS `cache_filter` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Filter module to store already...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_form`
--

CREATE TABLE IF NOT EXISTS `cache_form` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the form system to store recently built...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_image`
--

CREATE TABLE IF NOT EXISTS `cache_image` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about image...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_libraries`
--

CREATE TABLE IF NOT EXISTS `cache_libraries` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table to store library information.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_menu`
--

CREATE TABLE IF NOT EXISTS `cache_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the menu system to store router...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_page`
--

CREATE TABLE IF NOT EXISTS `cache_page` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store compressed pages for anonymous...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_path`
--

CREATE TABLE IF NOT EXISTS `cache_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for path alias lookup.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_rules`
--

CREATE TABLE IF NOT EXISTS `cache_rules` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the rules engine to store configured items.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_token`
--

CREATE TABLE IF NOT EXISTS `cache_token` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for token information.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_update`
--

CREATE TABLE IF NOT EXISTS `cache_update` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Update module to store information...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_variable`
--

CREATE TABLE IF NOT EXISTS `cache_variable` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for variables.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_views`
--

CREATE TABLE IF NOT EXISTS `cache_views` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_views_data`
--

CREATE TABLE IF NOT EXISTS `cache_views_data` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for views to store pre-rendered queries,...';

-- --------------------------------------------------------

--
-- Table structure for table `comment`
--

CREATE TABLE IF NOT EXISTS `comment` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique comment ID.',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid to which this comment is a reply.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid who authored the comment. If set to 0, this comment was created by an anonymous user.',
  `subject` varchar(64) NOT NULL DEFAULT '' COMMENT 'The comment title.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The author’s host name.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was created, as a Unix timestamp.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was last edited, as a Unix timestamp.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The published status of a comment. (0 = Not Published, 1 = Published)',
  `thread` varchar(255) NOT NULL COMMENT 'The vancode representation of the comment’s place in a thread.',
  `name` varchar(60) DEFAULT NULL COMMENT 'The comment author’s name. Uses users.name if the user is logged in, otherwise uses the value typed into the comment form.',
  `mail` varchar(64) DEFAULT NULL COMMENT 'The comment author’s e-mail address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `homepage` varchar(255) DEFAULT NULL COMMENT 'The comment author’s home page address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this comment.',
  PRIMARY KEY (`cid`),
  KEY `comment_status_pid` (`pid`,`status`),
  KEY `comment_num_new` (`nid`,`status`,`created`,`cid`,`thread`),
  KEY `comment_uid` (`uid`),
  KEY `comment_nid_language` (`nid`,`language`),
  KEY `comment_created` (`created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores comments and associated data.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `comment`
--

INSERT INTO `comment` (`cid`, `pid`, `nid`, `uid`, `subject`, `hostname`, `created`, `changed`, `status`, `thread`, `name`, `mail`, `homepage`, `language`) VALUES
(1, 0, 2, 1, 'Sed lectus eros', '127.0.0.1', 1341022600, 1341022599, 1, '01/', 'admin', '', '', 'und');

-- --------------------------------------------------------

--
-- Table structure for table `commerce_calculated_price`
--

CREATE TABLE IF NOT EXISTS `commerce_calculated_price` (
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module performing the calculation.',
  `module_key` mediumtext NOT NULL COMMENT 'A module specific key useful for indicating the context of a particular calculation, e.g. the IDs of Rules evaluated to produce the calculated price.',
  `entity_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The type of entity this price belongs to.',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The entity ID of the object this price belongs to.',
  `field_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The name of the field the calculated price relates to.',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The languages.language of the entity.',
  `delta` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sequence number for this data item, used for multi-value fields',
  `amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `data` longtext COMMENT 'A serialized array of additional price data.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the price was calculated.',
  KEY `module` (`module`),
  KEY `entity_type` (`entity_type`),
  KEY `entity_id` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores pre-calculated dynamic prices.';

-- --------------------------------------------------------

--
-- Table structure for table `commerce_checkout_pane`
--

CREATE TABLE IF NOT EXISTS `commerce_checkout_pane` (
  `pane_id` varchar(255) NOT NULL COMMENT 'The machine readable name of the order state.',
  `page` varchar(255) NOT NULL DEFAULT '1' COMMENT 'The ID of the checkout page on which this pane appears.',
  `fieldset` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean value indicating whether or not the pane should appear in a fieldset.',
  `collapsible` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean value indicating whether or not the pane should appear collapsed.',
  `collapsed` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean value indicating whether or not the pane should appear collapsed.',
  `weight` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The sorting weight of the status for lists of statuses.',
  `enabled` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean value indicating whether or not the pane is enabled.',
  `review` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean value indicating whether or not the pane should appear on the checkout review.',
  PRIMARY KEY (`pane_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Checkout pane configuration data.';

-- --------------------------------------------------------

--
-- Table structure for table `commerce_customer_profile`
--

CREATE TABLE IF NOT EXISTS `commerce_customer_profile` (
  `profile_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a customer profile.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_customer_profile_revision.revision_id version identifier.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The commerce_customer_profile_type.type of this profile.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that this profile belongs to.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the profile is active or not.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the profile was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the profile was most recently saved.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`profile_id`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `uid` (`uid`),
  KEY `customer_profile_type` (`type`),
  KEY `uid_by_type` (`uid`,`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='The base table for customer profiles.' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `commerce_customer_profile`
--

INSERT INTO `commerce_customer_profile` (`profile_id`, `revision_id`, `type`, `uid`, `status`, `created`, `changed`, `data`) VALUES
(1, 1, 'billing', 1, 1, 1339919524, 1339919524, NULL),
(2, 2, 'billing', 1, 1, 1339922341, 1340030143, 0x623a303b),
(3, 3, 'billing', 1, 1, 1340030642, 1340030642, NULL),
(4, 4, 'billing', 1, 1, 1340031977, 1340031977, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_customer_profile_revision`
--

CREATE TABLE IF NOT EXISTS `commerce_customer_profile_revision` (
  `profile_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_customer_profile.customer_id of the profile this revision belongs to.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this revision.',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this profile at this revision.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the profile is active or not.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`revision_id`),
  KEY `profile_id` (`profile_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `commerce_customer_profile_revision`
--

INSERT INTO `commerce_customer_profile_revision` (`profile_id`, `revision_id`, `revision_uid`, `status`, `log`, `revision_timestamp`, `data`) VALUES
(1, 1, 1, 1, '', 1339919524, NULL),
(2, 2, 1, 1, '', 1340030143, 0x623a303b),
(3, 3, 1, 1, '', 1340030642, NULL),
(4, 4, 1, 1, '', 1340031977, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_line_item`
--

CREATE TABLE IF NOT EXISTS `commerce_line_item` (
  `line_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a line item.',
  `order_id` int(11) NOT NULL DEFAULT '0' COMMENT 'The unique ID of the order the line item belongs to.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The module defined type of this line item.',
  `line_item_label` varchar(255) NOT NULL COMMENT 'The merchant defined label for a line item.',
  `quantity` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the line item was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the line item was most recently saved.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`line_item_id`),
  KEY `order_id` (`order_id`),
  KEY `line_item_type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='The base table for line items.' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `commerce_line_item`
--

INSERT INTO `commerce_line_item` (`line_item_id`, `order_id`, `type`, `line_item_label`, `quantity`, `created`, `changed`, `data`) VALUES
(4, 1, 'rooms_booking', 'Booking for Basic Suite (7 Nights; Arrival: 2012-06-21 Departure: 2012-06-28)', '1.00', 1339919449, 1339919449, 0x613a303a7b7d),
(5, 2, 'rooms_booking', 'Booking for Royal Suite (11 Nights; Arrival: 2012-06-18 Departure: 2012-06-29)', '1.00', 1339921103, 1339921103, 0x613a303a7b7d),
(6, 2, 'rooms_booking', 'Booking for Basic Suite (11 Nights; Arrival: 2012-06-18 Departure: 2012-06-29)', '1.00', 1339921137, 1339921137, 0x613a303a7b7d),
(7, 2, 'rooms_booking', 'Booking for Royal Suite (11 Nights; Arrival: 2012-06-19 Departure: 2012-06-30)', '1.00', 1340028175, 1340028175, 0x613a303a7b7d),
(8, 3, 'rooms_booking', 'Booking for Luxury Suite (10 Nights; Arrival: 2012-06-19 Departure: 2012-06-29)', '1.00', 1340030517, 1340030517, 0x613a303a7b7d),
(9, 3, 'rooms_booking', 'Booking for Luxury Suite (10 Nights; Arrival: 2012-06-20 Departure: 2012-06-30)', '1.00', 1340030585, 1340030585, 0x613a303a7b7d),
(11, 4, 'rooms_booking', 'Booking for Royal Suite (12 Nights; Arrival: 2012-06-19 Departure: 2012-07-31)', '1.00', 1340031948, 1340031948, 0x613a303a7b7d),
(12, 5, 'rooms_booking', 'Booking for Basic Suite (8 Nights; Arrival: 2012-06-22 Departure: 2012-06-30)', '1.00', 1340115483, 1340115483, 0x613a303a7b7d),
(13, 5, 'rooms_booking', 'Booking for Luxury Suite (7 Nights; Arrival: 2012-06-23 Departure: 2012-06-30)', '1.00', 1340202768, 1340202768, 0x613a303a7b7d),
(14, 5, 'rooms_booking', 'Booking for Royal Suite (28 Nights; Arrival: 2012-07-03 Departure: 2012-07-31)', '1.00', 1341022997, 1341022997, 0x613a303a7b7d),
(15, 6, 'rooms_booking', 'Booking for Basic Suite (5 Nights; Arrival: 2012-08-25 Departure: 2012-08-30)', '1.00', 1345723459, 1345723459, 0x613a303a7b7d);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_order`
--

CREATE TABLE IF NOT EXISTS `commerce_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an order.',
  `order_number` varchar(255) DEFAULT NULL COMMENT 'The order number displayed to the customer.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_order_revision.revision_id version identifier.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The type of this order.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns this order.',
  `mail` varchar(255) NOT NULL DEFAULT '' COMMENT 'The e-mail address associated with the order.',
  `status` varchar(255) NOT NULL COMMENT 'The status name of this order.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the order was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the order was most recently saved.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The IP address that created this order.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_number` (`order_number`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='The base table for orders.' AUTO_INCREMENT=7 ;

--
-- Dumping data for table `commerce_order`
--

INSERT INTO `commerce_order` (`order_id`, `order_number`, `revision_id`, `type`, `uid`, `mail`, `status`, `created`, `changed`, `hostname`, `data`) VALUES
(1, '1', 10, 'commerce_order', 1, 'you@yourdomain.com', 'pending', 1339774881, 1339919538, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 28, 'commerce_order', 1, 'you@yourdomain.com', 'pending', 1339921103, 1340030262, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 34, 'commerce_order', 1, 'you@yourdomain.com', 'pending', 1340030517, 1340030705, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 40, 'commerce_order', 1, 'you@yourdomain.com', 'pending', 1340031924, 1340031995, '127.0.0.1', 0x613a303a7b7d),
(5, '5', 44, 'commerce_order', 1, 'you@yourdomain.com', 'checkout_checkout', 1340115483, 1341023010, '127.0.0.1', 0x613a303a7b7d),
(6, '6', 46, 'commerce_order', 0, '', 'checkout_checkout', 1345723459, 1345723469, '127.0.0.1', 0x613a303a7b7d);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_order_revision`
--

CREATE TABLE IF NOT EXISTS `commerce_order_revision` (
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_order.order_id of the order this revision belongs to.',
  `order_number` varchar(255) DEFAULT NULL COMMENT 'The order number displayed to the customer for this revision.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this revision.',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns the order at this revision.',
  `mail` varchar(255) NOT NULL COMMENT 'The e-mail address associated with the order at this revision.',
  `status` varchar(255) NOT NULL COMMENT 'The status name of this revision.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `revision_hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The IP address that created this order.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`revision_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...' AUTO_INCREMENT=47 ;

--
-- Dumping data for table `commerce_order_revision`
--

INSERT INTO `commerce_order_revision` (`order_id`, `order_number`, `revision_id`, `revision_uid`, `mail`, `status`, `log`, `revision_timestamp`, `revision_hostname`, `data`) VALUES
(1, '1', 1, 1, 'you@yourdomain.com', 'cart', 'Created as a shopping cart order.', 1339774881, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 2, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1339860483, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 3, 1, 'you@yourdomain.com', 'cart', 'Order status updated via Rules.', 1339860483, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 4, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1339891551, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 5, 1, 'you@yourdomain.com', 'cart', 'Order status updated via Rules.', 1339919480, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 6, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1339919524, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 7, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1339919536, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 8, 1, 'you@yourdomain.com', 'checkout_payment', 'Customer continued to the next checkout page via a submit button.', 1339919536, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 9, 1, 'you@yourdomain.com', 'checkout_complete', '', 1339919538, '127.0.0.1', 0x613a303a7b7d),
(1, '1', 10, 1, 'you@yourdomain.com', 'pending', 'Order state updated via Rules.', 1339919538, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 11, 1, 'you@yourdomain.com', 'cart', 'Created as a shopping cart order.', 1339921137, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 12, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1339922341, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 13, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1339922341, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 14, 1, 'you@yourdomain.com', 'cart', 'Customer manually canceled the checkout process.', 1339922407, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 15, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1339922423, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 16, 1, 'you@yourdomain.com', 'cart', 'Customer updated the order via the shopping cart form.', 1339922449, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 17, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1339922467, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 18, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1340028175, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 19, 1, 'you@yourdomain.com', 'cart', 'Order status updated via Rules.', 1340028175, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 20, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1340028289, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 21, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1340028289, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 22, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer returned to the previous checkout page via a submit button.', 1340029856, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 23, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1340029856, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 24, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer returned to the previous checkout page via a submit button.', 1340030143, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 25, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1340030260, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 26, 1, 'you@yourdomain.com', 'checkout_payment', 'Customer continued to the next checkout page via a submit button.', 1340030260, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 27, 1, 'you@yourdomain.com', 'checkout_complete', '', 1340030262, '127.0.0.1', 0x613a303a7b7d),
(2, '2', 28, 1, 'you@yourdomain.com', 'pending', 'Order state updated via Rules.', 1340030262, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 29, 1, 'you@yourdomain.com', 'cart', 'Created as a shopping cart order.', 1340030585, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 30, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1340030642, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 31, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1340030702, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 32, 1, 'you@yourdomain.com', 'checkout_payment', 'Customer continued to the next checkout page via a submit button.', 1340030702, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 33, 1, 'you@yourdomain.com', 'checkout_complete', '', 1340030705, '127.0.0.1', 0x613a303a7b7d),
(3, '3', 34, 1, 'you@yourdomain.com', 'pending', 'Order state updated via Rules.', 1340030705, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 35, 1, 'you@yourdomain.com', 'cart', 'Created as a shopping cart order.', 1340031948, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 36, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1340031977, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 37, 1, 'you@yourdomain.com', 'checkout_review', 'Customer continued to the next checkout page via a submit button.', 1340031993, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 38, 1, 'you@yourdomain.com', 'checkout_payment', 'Customer continued to the next checkout page via a submit button.', 1340031993, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 39, 1, 'you@yourdomain.com', 'checkout_complete', '', 1340031995, '127.0.0.1', 0x613a303a7b7d),
(4, '4', 40, 1, 'you@yourdomain.com', 'pending', 'Order state updated via Rules.', 1340031995, '127.0.0.1', 0x613a303a7b7d),
(5, '5', 41, 1, 'you@yourdomain.com', 'cart', 'Created as a shopping cart order.', 1340115483, '127.0.0.1', 0x613a303a7b7d),
(5, '5', 42, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1340202768, '127.0.0.1', 0x613a303a7b7d),
(5, '5', 43, 1, 'you@yourdomain.com', 'cart', 'Order status updated via Rules.', 1341022997, '127.0.0.1', 0x613a303a7b7d),
(5, '5', 44, 1, 'you@yourdomain.com', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1341023010, '127.0.0.1', 0x613a303a7b7d),
(6, '6', 45, 0, '', 'cart', 'Created as a shopping cart order.', 1345723459, '127.0.0.1', 0x613a303a7b7d),
(6, '6', 46, 0, '', 'checkout_checkout', 'Customer proceeded to checkout using a submit button.', 1345723469, '127.0.0.1', 0x613a303a7b7d);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_payment_transaction`
--

CREATE TABLE IF NOT EXISTS `commerce_payment_transaction` (
  `transaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a transaction.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_payment_transaction_revision.revision_id version identifier.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this transaction.',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_order.order_id of the order this payment is for.',
  `payment_method` varchar(128) NOT NULL COMMENT 'The payment method method_id for this transaction.',
  `instance_id` varchar(255) NOT NULL COMMENT 'The payment method instance ID for this transaction.',
  `remote_id` varchar(255) NOT NULL COMMENT 'The remote identifier for this transaction.',
  `message` longtext NOT NULL COMMENT 'The human-readable message associated to this transaction.',
  `message_variables` longblob NOT NULL COMMENT 'The variables associated with the human-readable message.',
  `amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The amount of this transaction.',
  `currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `status` varchar(128) NOT NULL COMMENT 'The status of this transaction (pending, success, or failure).',
  `remote_status` varchar(128) NOT NULL COMMENT 'The status of the transaction at the payment provider.',
  `payload` longblob NOT NULL COMMENT 'The payment-gateway specific payload associated with this transaction.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this transaction was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this transaction was last changed.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`transaction_id`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `payment_method` (`payment_method`),
  KEY `uid` (`uid`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Transaction information for every attempted payment.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `commerce_payment_transaction_revision`
--

CREATE TABLE IF NOT EXISTS `commerce_payment_transaction_revision` (
  `transaction_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary identifier for a transaction.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The current commerce_payment_transaction_revision.revision_id version identifier.',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this revision.',
  `remote_id` varchar(255) NOT NULL COMMENT 'The remote identifier for this transaction.',
  `message` longtext NOT NULL COMMENT 'The human-readable message associated to this transaction.',
  `message_variables` longblob NOT NULL COMMENT 'The variables associated with the human-readable message.',
  `amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The amount of this transaction.',
  `currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `status` varchar(128) NOT NULL COMMENT 'The status of this transaction (pending, success, or failure).',
  `remote_status` varchar(128) NOT NULL COMMENT 'The status of the transaction at the payment provider.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`revision_id`),
  KEY `transaction_id` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `commerce_paypal_ipn`
--

CREATE TABLE IF NOT EXISTS `commerce_paypal_ipn` (
  `ipn_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Serial numeric ID of the IPN in the local database.',
  `txn_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'The PayPal transaction ID.',
  `txn_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The PayPal transaction type.',
  `receiver_email` varchar(255) NOT NULL DEFAULT '' COMMENT 'The e-mail of the payment receiever.',
  `payer_email` varchar(255) NOT NULL DEFAULT '' COMMENT 'The e-mail of the payer.',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The order ID the payment belongs to.',
  `transaction_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The payment transaction ID the payment belongs to.',
  `mc_gross` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The gross payment amount.',
  `mc_currency` varchar(255) NOT NULL DEFAULT '' COMMENT 'The currency code of the payment.',
  `mc_fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'The amount of fees collected by PayPal for this payment.',
  `payment_status` varchar(255) NOT NULL DEFAULT '' COMMENT 'The status of the payment at PayPal.',
  `payment_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The type of the payment.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the IPN was received.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the IPN was last updated.',
  `test_ipn` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether or not this was a test IPN sent by the Sandbox.',
  PRIMARY KEY (`ipn_id`),
  KEY `txn_id` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores processed IPNs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `commerce_product`
--

CREATE TABLE IF NOT EXISTS `commerce_product` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a product, used internally only.',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The current commerce_product_revision.revision_id version identifier.',
  `sku` varchar(255) NOT NULL COMMENT 'The unique, human-readable identifier for a product.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this product, always treated as non-markup plain text.',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The commerce_product_type.type of this product.',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The languages.language of this product.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this product.',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether or not the product appears in lists and may be added to orders.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the product was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the product was most recently saved.',
  `data` longblob COMMENT 'A serialized array of additional data.',
  PRIMARY KEY (`product_id`),
  UNIQUE KEY `sku` (`sku`),
  UNIQUE KEY `revision_id` (`revision_id`),
  KEY `product_type` (`type`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='The base table for products.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `commerce_product`
--

INSERT INTO `commerce_product` (`product_id`, `revision_id`, `sku`, `title`, `type`, `language`, `uid`, `status`, `created`, `changed`, `data`) VALUES
(1, 1, 'ROOMS-BASIC-BOOKING', 'Rooms Basic Booking', 'rooms_product', '', 0, 1, 1339773379, 1400512348, 0x623a303b);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_product_revision`
--

CREATE TABLE IF NOT EXISTS `commerce_product_revision` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The commerce_product.product_id of the product this revision belongs to.',
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this revision.',
  `sku` varchar(255) NOT NULL COMMENT 'The unique, human-readable identifier of a product for this revision.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this product for this revision',
  `revision_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns the product at this revision.',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'The status of this revision.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `revision_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this revision was created.',
  `data` longblob COMMENT 'A serialized array of additional data for this revision.',
  PRIMARY KEY (`revision_id`),
  KEY `product_id` (`product_id`),
  KEY `revision_uid` (`revision_uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Saves information about each saved revision of a commerce...' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `commerce_product_revision`
--

INSERT INTO `commerce_product_revision` (`product_id`, `revision_id`, `sku`, `title`, `revision_uid`, `status`, `log`, `revision_timestamp`, `data`) VALUES
(1, 1, 'ROOMS-BASIC-BOOKING', 'Rooms Basic Booking', 1, 1, '', 1400512348, 0x623a303b);

-- --------------------------------------------------------

--
-- Table structure for table `commerce_product_type`
--

CREATE TABLE IF NOT EXISTS `commerce_product_type` (
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The machine-readable name of this type.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The human-readable name of this type.',
  `description` mediumtext NOT NULL COMMENT 'A brief description of this type.',
  `help` mediumtext NOT NULL COMMENT 'Help information shown to the user when creating a commerce_product of this type.',
  `revision` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Determine whether to create a new revision when a product of this type is updated.',
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores information about commerce_product types created...';

--
-- Dumping data for table `commerce_product_type`
--

INSERT INTO `commerce_product_type` (`type`, `name`, `description`, `help`, `revision`) VALUES
('product', 'Product', 'A basic product type.', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `contact`
--

CREATE TABLE IF NOT EXISTS `contact` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique category ID.',
  `category` varchar(255) NOT NULL DEFAULT '' COMMENT 'Category name.',
  `recipients` longtext NOT NULL COMMENT 'Comma-separated list of recipient e-mail addresses.',
  `reply` longtext NOT NULL COMMENT 'Text of the auto-reply message.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The category’s weight.',
  `selected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether or not category is selected by default. (1 = Yes, 0 = No)',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `category` (`category`),
  KEY `list` (`weight`,`category`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contact form category settings.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `contact`
--

INSERT INTO `contact` (`cid`, `category`, `recipients`, `reply`, `weight`, `selected`) VALUES
(1, 'Website feedback', 'you@yourdomain.com', '', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `ctools_css_cache`
--

CREATE TABLE IF NOT EXISTS `ctools_css_cache` (
  `cid` varchar(128) NOT NULL COMMENT 'The CSS ID this cache object belongs to.',
  `filename` varchar(255) DEFAULT NULL COMMENT 'The filename this CSS is stored in.',
  `css` longtext COMMENT 'CSS being stored.',
  `filter` tinyint(4) DEFAULT NULL COMMENT 'Whether or not this CSS needs to be filtered.',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store CSS that must be non-volatile.';

-- --------------------------------------------------------

--
-- Table structure for table `ctools_object_cache`
--

CREATE TABLE IF NOT EXISTS `ctools_object_cache` (
  `sid` varchar(64) NOT NULL COMMENT 'The session ID this cache object belongs to.',
  `name` varchar(128) NOT NULL COMMENT 'The name of the object this cache is attached to.',
  `obj` varchar(128) NOT NULL COMMENT 'The type of the object this cache is attached to; this essentially represents the owner so that several sub-systems can use this cache.',
  `updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The time this cache was created or updated.',
  `data` longblob COMMENT 'Serialized data being stored.',
  PRIMARY KEY (`sid`,`obj`,`name`),
  KEY `updated` (`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store objects that are being...';

-- --------------------------------------------------------

--
-- Table structure for table `date_formats`
--

CREATE TABLE IF NOT EXISTS `date_formats` (
  `dfid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The date format identifier.',
  `format` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this format can be modified.',
  PRIMARY KEY (`dfid`),
  UNIQUE KEY `formats` (`format`,`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats.' AUTO_INCREMENT=36 ;

--
-- Dumping data for table `date_formats`
--

INSERT INTO `date_formats` (`dfid`, `format`, `type`, `locked`) VALUES
(1, 'Y-m-d H:i', 'short', 1),
(2, 'm/d/Y - H:i', 'short', 1),
(3, 'd/m/Y - H:i', 'short', 1),
(4, 'Y/m/d - H:i', 'short', 1),
(5, 'd.m.Y - H:i', 'short', 1),
(6, 'm/d/Y - g:ia', 'short', 1),
(7, 'd/m/Y - g:ia', 'short', 1),
(8, 'Y/m/d - g:ia', 'short', 1),
(9, 'M j Y - H:i', 'short', 1),
(10, 'j M Y - H:i', 'short', 1),
(11, 'Y M j - H:i', 'short', 1),
(12, 'M j Y - g:ia', 'short', 1),
(13, 'j M Y - g:ia', 'short', 1),
(14, 'Y M j - g:ia', 'short', 1),
(15, 'D, Y-m-d H:i', 'medium', 1),
(16, 'D, m/d/Y - H:i', 'medium', 1),
(17, 'D, d/m/Y - H:i', 'medium', 1),
(18, 'D, Y/m/d - H:i', 'medium', 1),
(19, 'F j, Y - H:i', 'medium', 1),
(20, 'j F, Y - H:i', 'medium', 1),
(21, 'Y, F j - H:i', 'medium', 1),
(22, 'D, m/d/Y - g:ia', 'medium', 1),
(23, 'D, d/m/Y - g:ia', 'medium', 1),
(24, 'D, Y/m/d - g:ia', 'medium', 1),
(25, 'F j, Y - g:ia', 'medium', 1),
(26, 'j F Y - g:ia', 'medium', 1),
(27, 'Y, F j - g:ia', 'medium', 1),
(28, 'j. F Y - G:i', 'medium', 1),
(29, 'l, F j, Y - H:i', 'long', 1),
(30, 'l, j F, Y - H:i', 'long', 1),
(31, 'l, Y,  F j - H:i', 'long', 1),
(32, 'l, F j, Y - g:ia', 'long', 1),
(33, 'l, j F Y - g:ia', 'long', 1),
(34, 'l, Y,  F j - g:ia', 'long', 1),
(35, 'l, j. F Y - G:i', 'long', 1);

-- --------------------------------------------------------

--
-- Table structure for table `date_format_locale`
--

CREATE TABLE IF NOT EXISTS `date_format_locale` (
  `format` varchar(100) NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `language` varchar(12) NOT NULL COMMENT 'A languages.language for this format to be used with.',
  PRIMARY KEY (`type`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats for each locale.';

-- --------------------------------------------------------

--
-- Table structure for table `date_format_type`
--

CREATE TABLE IF NOT EXISTS `date_format_type` (
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `title` varchar(255) NOT NULL COMMENT 'The human readable name of the format type.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this is a system provided format.',
  PRIMARY KEY (`type`),
  KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date format types.';

--
-- Dumping data for table `date_format_type`
--

INSERT INTO `date_format_type` (`type`, `title`, `locked`) VALUES
('long', 'Long', 1),
('medium', 'Medium', 1),
('short', 'Short', 1);

-- --------------------------------------------------------

--
-- Table structure for table `field_config`
--

CREATE TABLE IF NOT EXISTS `field_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field',
  `field_name` varchar(32) NOT NULL COMMENT 'The name of this field. Non-deleted field names are unique, but multiple deleted fields can have the same name.',
  `type` varchar(128) NOT NULL COMMENT 'The type of this field.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the field type.',
  `active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the field type is enabled.',
  `storage_type` varchar(128) NOT NULL COMMENT 'The storage backend for the field.',
  `storage_module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the storage backend.',
  `storage_active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the storage backend is enabled.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT '@TODO',
  `data` longblob NOT NULL COMMENT 'Serialized data containing the field properties that do not warrant a dedicated column.',
  `cardinality` tinyint(4) NOT NULL DEFAULT '0',
  `translatable` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name` (`field_name`),
  KEY `active` (`active`),
  KEY `storage_active` (`storage_active`),
  KEY `deleted` (`deleted`),
  KEY `module` (`module`),
  KEY `storage_module` (`storage_module`),
  KEY `type` (`type`),
  KEY `storage_type` (`storage_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;

--
-- Dumping data for table `field_config`
--

INSERT INTO `field_config` (`id`, `field_name`, `type`, `module`, `active`, `storage_type`, `storage_module`, `storage_active`, `locked`, `data`, `cardinality`, `translatable`, `deleted`) VALUES
(1, 'comment_body', 'text_long', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a373a22636f6d6d656e74223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(2, 'body', 'text_with_summary', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a343a226e6f6465223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(3, 'field_tags', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a343a2274616773223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(4, 'field_image', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a373a22696e6465786573223b613a313a7b733a333a22666964223b613a313a7b693a303b733a333a22666964223b7d7d733a383a2273657474696e6773223b613a323a7b733a31303a227572695f736368656d65223b733a363a227075626c6963223b733a31333a2264656661756c745f696d616765223b693a303b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32323a226669656c645f646174615f6669656c645f696d616765223b613a353a7b733a333a22666964223b733a31353a226669656c645f696d6167655f666964223b733a333a22616c74223b733a31353a226669656c645f696d6167655f616c74223b733a353a227469746c65223b733a31373a226669656c645f696d6167655f7469746c65223b733a353a227769647468223b733a31373a226669656c645f696d6167655f7769647468223b733a363a22686569676874223b733a31383a226669656c645f696d6167655f686569676874223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a32363a226669656c645f7265766973696f6e5f6669656c645f696d616765223b613a353a7b733a333a22666964223b733a31353a226669656c645f696d6167655f666964223b733a333a22616c74223b733a31353a226669656c645f696d6167655f616c74223b733a353a227469746c65223b733a31373a226669656c645f696d6167655f7469746c65223b733a353a227769647468223b733a31373a226669656c645f696d6167655f7769647468223b733a363a22686569676874223b733a31383a226669656c645f696d6167655f686569676874223b7d7d7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22666f726569676e206b657973223b613a313a7b733a333a22666964223b613a323a7b733a353a227461626c65223b733a31323a2266696c655f6d616e61676564223b733a373a22636f6c756d6e73223b613a313a7b733a333a22666964223b733a333a22666964223b7d7d7d733a323a226964223b733a313a2234223b7d, 1, 0, 0),
(5, 'commerce_customer_address', 'addressfield', 'addressfield', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(6, 'commerce_line_items', 'commerce_line_item_reference', 'commerce_line_item', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a31323a226c696e655f6974656d5f6964223b613a323a7b733a353a227461626c65223b733a31383a22636f6d6d657263655f6c696e655f6974656d223b733a373a22636f6c756d6e73223b613a313a7b733a31323a226c696e655f6974656d5f6964223b733a31323a226c696e655f6974656d5f6964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a31323a226c696e655f6974656d5f6964223b613a313a7b693a303b733a31323a226c696e655f6974656d5f6964223b7d7d7d, -1, 0, 0),
(7, 'commerce_order_total', 'commerce_price', 'commerce_price', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a31343a2263757272656e63795f7072696365223b613a323a7b693a303b733a363a22616d6f756e74223b693a313b733a31333a2263757272656e63795f636f6465223b7d7d7d, 1, 0, 0),
(8, 'commerce_customer_billing', 'commerce_customer_profile_reference', 'commerce_customer', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a313a7b733a31323a2270726f66696c655f74797065223b733a373a2262696c6c696e67223b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a31303a2270726f66696c655f6964223b613a323a7b733a353a227461626c65223b733a31373a22636f6d6d657263655f637573746f6d6572223b733a373a22636f6c756d6e73223b613a313a7b733a31303a2270726f66696c655f6964223b733a31303a2270726f66696c655f6964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a31303a2270726f66696c655f6964223b613a313a7b693a303b733a31303a2270726f66696c655f6964223b7d7d7d, 1, 0, 0),
(11, 'commerce_unit_price', 'commerce_price', 'commerce_price', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a31343a2263757272656e63795f7072696365223b613a323a7b693a303b733a363a22616d6f756e74223b693a313b733a31333a2263757272656e63795f636f6465223b7d7d7d, 1, 0, 0),
(12, 'commerce_total', 'commerce_price', 'commerce_price', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a31343a2263757272656e63795f7072696365223b613a323a7b693a303b733a363a22616d6f756e74223b693a313b733a31333a2263757272656e63795f636f6465223b7d7d7d, 1, 0, 0),
(13, 'commerce_product', 'commerce_product_reference', 'commerce_product_reference', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a31303a2270726f647563745f6964223b613a323a7b733a353a227461626c65223b733a31363a22636f6d6d657263655f70726f64756374223b733a373a22636f6c756d6e73223b613a313a7b733a31303a2270726f647563745f6964223b733a31303a2270726f647563745f6964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a31303a2270726f647563745f6964223b613a313a7b693a303b733a31303a2270726f647563745f6964223b7d7d7d, 1, 0, 0),
(14, 'commerce_display_path', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b693a3235353b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(15, 'rooms_booking_dates', 'date', 'date', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a31333a22426f6f6b696e67204461746573223b733a383a2273657474696e6773223b613a353a7b733a363a22726570656174223b693a303b733a363a22746f64617465223b733a383a227265717569726564223b733a31313a226772616e756c6172697479223b613a333a7b733a343a2279656172223b733a343a2279656172223b733a353a226d6f6e7468223b733a353a226d6f6e7468223b733a333a22646179223b733a333a22646179223b7d733a31313a22747a5f68616e646c696e67223b733a343a226e6f6e65223b733a31313a2274696d657a6f6e655f6462223b733a303a22223b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(16, 'rooms_booked_unit_id', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a31343a22426f6f6b656420556e6974204944223b733a383a2273657474696e6773223b613a333a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(17, 'rooms_booked_status', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a31383a22426f6f6b656420556e697420537461747573223b733a383a2273657474696e6773223b613a333a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(18, 'rooms_booked_price', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a31373a22426f6f6b656420556e6974205072696365223b733a383a2273657474696e6773223b613a333a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(19, 'rooms_booked_bookingprice', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a31333a22426f6f6b696e67205072696365223b733a383a2273657474696e6773223b613a333a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 1, 0, 0),
(20, 'commerce_price', 'commerce_price', 'commerce_price', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a31343a2263757272656e63795f7072696365223b613a323a7b693a303b733a363a22616d6f756e74223b693a313b733a31333a2263757272656e63795f636f6465223b7d7d7d, 1, 0, 0),
(23, 'field_images', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, -1, 0, 0),
(25, 'field_slideshow_image', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, 1, 0, 0),
(27, 'field_availability', 'rooms_availability_reference', 'rooms_availability_reference', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a323a7b733a32343a227265666572656e636561626c655f756e69745f7479706573223b613a343a7b733a31313a2262617369635f7375697465223b733a31313a2262617369635f7375697465223b733a31323a2264656c7578655f7375697465223b733a31323a2264656c7578655f7375697465223b733a31323a226c75787572795f7375697465223b733a31323a226c75787572795f7375697465223b733a31313a22726f79616c5f7375697465223b733a31313a22726f79616c5f7375697465223b7d733a33323a227265666572656e636561626c655f626f6f6b696e675f756e69745f7479706573223b613a303a7b7d7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32393a226669656c645f646174615f6669656c645f617661696c6162696c697479223b613a313a7b733a373a22756e69745f6964223b733a32363a226669656c645f617661696c6162696c6974795f756e69745f6964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33333a226669656c645f7265766973696f6e5f6669656c645f617661696c6162696c697479223b613a313a7b733a373a22756e69745f6964223b733a32363a226669656c645f617661696c6162696c6974795f756e69745f6964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a373a22756e69745f6964223b613a323a7b733a353a227461626c65223b733a31313a22726f6f6d735f756e697473223b733a373a22636f6c756d6e73223b613a313a7b733a373a22756e69745f6964223b733a373a22756e69745f6964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a373a22756e69745f6964223b613a313a7b693a303b733a373a22756e69745f6964223b7d7d733a323a226964223b733a323a223237223b7d, 1, 0, 0),
(28, 'field_description', 'text_with_summary', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32383a226669656c645f646174615f6669656c645f6465736372697074696f6e223b613a333a7b733a353a2276616c7565223b733a32333a226669656c645f6465736372697074696f6e5f76616c7565223b733a373a2273756d6d617279223b733a32353a226669656c645f6465736372697074696f6e5f73756d6d617279223b733a363a22666f726d6174223b733a32343a226669656c645f6465736372697074696f6e5f666f726d6174223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33323a226669656c645f7265766973696f6e5f6669656c645f6465736372697074696f6e223b613a333a7b733a353a2276616c7565223b733a32333a226669656c645f6465736372697074696f6e5f76616c7565223b733a373a2273756d6d617279223b733a32353a226669656c645f6465736372697074696f6e5f73756d6d617279223b733a363a22666f726d6174223b733a32343a226669656c645f6465736372697074696f6e5f666f726d6174223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d733a323a226964223b733a323a223238223b7d, 1, 0, 0),
(29, 'rooms_booking_number_people', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a32313a22426f6f6b696e67204e756d6265722050656f706c65223b733a383a2273657474696e6773223b613a333a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, 2, 0, 0),
(30, 'rooms_booking_options', 'rooms_options', 'rooms', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a393a7b733a353a226c6162656c223b733a31353a22426f6f6b696e67204f7074696f6e73223b733a383a227265717569726564223b693a303b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a353a7b733a363a22616374697665223b693a303b733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a32323a22726f6f6d735f6f7074696f6e735f636f6d62696e6564223b733a363a22776569676874223b733a313a2230223b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, -1, 0, 0),
(31, 'rooms_booking_reference', 'entityreference', 'entityreference', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a393a7b733a353a226c6162656c223b733a31373a22426f6f6b696e67205265666572656e6365223b733a383a227265717569726564223b693a303b733a383a2273657474696e6773223b613a333a7b733a373a2268616e646c6572223b733a343a2262617365223b733a31363a2268616e646c65725f73657474696e6773223b613a333a7b733a393a226265686176696f7273223b613a313a7b733a31373a2276696577732d73656c6563742d6c697374223b613a313a7b733a363a22737461747573223b693a303b7d7d733a343a22736f7274223b613a313a7b733a343a2274797065223b733a343a226e6f6e65223b7d733a31343a227461726765745f62756e646c6573223b613a303a7b7d7d733a31313a227461726765745f74797065223b733a31333a22726f6f6d735f626f6f6b696e67223b7d733a363a22776964676574223b613a353a7b733a363a22616374697665223b693a313b733a363a226d6f64756c65223b733a31353a22656e746974797265666572656e6365223b733a383a2273657474696e6773223b613a333a7b733a31343a226d617463685f6f70657261746f72223b733a383a22434f4e5441494e53223b733a343a2270617468223b733a303a22223b733a343a2273697a65223b733a323a223630223b7d733a343a2274797065223b733a32383a22656e746974797265666572656e63655f6175746f636f6d706c657465223b733a363a22776569676874223b733a313a2239223b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a393a227461726765745f6964223b613a313a7b693a303b733a393a227461726765745f6964223b7d7d7d, 1, 0, 0),
(32, 'rooms_booking_unit_options', 'rooms_options', 'rooms', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, -1, 0, 0),
(33, 'rooms_booking_children_ages', 'number_integer', 'number', 1, 'field_sql_storage', 'field_sql_storage', 1, 1, 0x613a373a7b733a353a226c6162656c223b733a32313a22426f6f6b696e67204368696c6472656e2041676573223b733a383a2273657474696e6773223b613a333a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a303a7b7d7d, -1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `field_config_instance`
--

CREATE TABLE IF NOT EXISTS `field_config_instance` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field instance',
  `field_id` int(11) NOT NULL COMMENT 'The identifier of the field attached by this instance',
  `field_name` varchar(32) NOT NULL DEFAULT '',
  `entity_type` varchar(32) NOT NULL DEFAULT '',
  `bundle` varchar(128) NOT NULL DEFAULT '',
  `data` longblob NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name_bundle` (`field_name`,`entity_type`,`bundle`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=83 ;

--
-- Dumping data for table `field_config_instance`
--

INSERT INTO `field_config_instance` (`id`, `field_id`, `field_name`, `entity_type`, `bundle`, `data`, `deleted`) VALUES
(1, 1, 'comment_body', 'comment', 'comment_node_page', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(2, 2, 'body', 'node', 'page', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b693a2d343b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(3, 1, 'comment_body', 'comment', 'comment_node_article', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(4, 2, 'body', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a323a222d34223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b733a333a22353230223b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(5, 3, 'field_tags', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a31313a226465736372697074696f6e223b733a36333a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f757220636f6e74656e742e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a363a22776569676874223b733a323a222d34223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2233223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(6, 4, 'field_image', 'node', 'article', 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, 0),
(7, 5, 'commerce_customer_address', 'commerce_customer_profile', 'billing', 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, 0),
(8, 6, 'commerce_line_items', 'commerce_order', 'commerce_order', 0x613a363a7b733a353a226c6162656c223b733a31303a224c696e65206974656d73223b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22636f6d6d657263655f6c696e655f6974656d5f6d616e61676572223b733a363a22776569676874223b693a2d31303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a373a22646973706c6179223b613a333a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a33333a22636f6d6d657263655f6c696e655f6974656d5f7265666572656e63655f76696577223b733a363a22776569676874223b693a2d31303b733a383a2273657474696e6773223b613a313a7b733a343a2276696577223b733a33323a22636f6d6d657263655f6c696e655f6974656d5f7461626c657c64656661756c74223b7d733a363a226d6f64756c65223b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a383a22637573746f6d6572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a33333a22636f6d6d657263655f6c696e655f6974656d5f7265666572656e63655f76696577223b733a363a22776569676874223b693a2d31303b733a383a2273657474696e6773223b613a313a7b733a343a2276696577223b733a33323a22636f6d6d657263655f6c696e655f6974656d5f7461626c657c64656661756c74223b7d733a363a226d6f64756c65223b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d733a31333a2261646d696e6973747261746f72223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a33333a22636f6d6d657263655f6c696e655f6974656d5f7265666572656e63655f76696577223b733a363a22776569676874223b693a2d31303b733a383a2273657474696e6773223b613a313a7b733a343a2276696577223b733a33323a22636f6d6d657263655f6c696e655f6974656d5f7461626c657c64656661756c74223b7d733a363a226d6f64756c65223b733a31383a22636f6d6d657263655f6c696e655f6974656d223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(9, 7, 'commerce_order_total', 'commerce_order', 'commerce_order', 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, 0),
(10, 8, 'commerce_customer_billing', 'commerce_order', 'commerce_order', 0x613a363a7b733a353a226c6162656c223b733a31393a2242696c6c696e6720696e666f726d6174696f6e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a33333a22636f6d6d657263655f637573746f6d65725f70726f66696c655f6d616e61676572223b733a363a22776569676874223b693a2d353b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a22636f6d6d657263655f637573746f6d6572223b7d733a373a22646973706c6179223b613a333a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a34333a22636f6d6d657263655f637573746f6d65725f70726f66696c655f7265666572656e63655f646973706c6179223b733a363a22776569676874223b693a2d353b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a22636f6d6d657263655f637573746f6d6572223b7d733a383a22637573746f6d6572223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a34333a22636f6d6d657263655f637573746f6d65725f70726f66696c655f7265666572656e63655f646973706c6179223b733a363a22776569676874223b693a2d353b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a22636f6d6d657263655f637573746f6d6572223b7d733a31333a2261646d696e6973747261746f72223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a34333a22636f6d6d657263655f637573746f6d65725f70726f66696c655f7265666572656e63655f646973706c6179223b733a363a22776569676874223b693a2d353b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a22636f6d6d657263655f637573746f6d6572223b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(13, 1, 'comment_body', 'comment', 'comment_node_unit_description', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(14, 11, 'commerce_unit_price', 'commerce_line_item', 'product', 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, 0),
(15, 12, 'commerce_total', 'commerce_line_item', 'product', 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, 0),
(16, 13, 'commerce_product', 'commerce_line_item', 'product', 0x613a363a7b733a353a226c6162656c223b733a373a2250726f64756374223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a333a7b733a31393a227265666572656e636561626c655f7479706573223b613a303a7b7d733a31353a226669656c645f696e6a656374696f6e223b623a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a33393a22636f6d6d657263655f70726f647563745f7265666572656e63655f6175746f636f6d706c657465223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a333a7b733a31383a226175746f636f6d706c6574655f6d61746368223b733a383a22636f6e7461696e73223b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32393a22636f6d6d657263655f70726f647563742f6175746f636f6d706c657465223b7d733a363a226d6f64756c65223b733a32363a22636f6d6d657263655f70726f647563745f7265666572656e6365223b7d733a373a22646973706c6179223b613a323a7b733a373a22646973706c6179223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a343a2274797065223b733a33303a22636f6d6d657263655f636172745f6164645f746f5f636172745f666f726d223b733a383a2273657474696e6773223b613a343a7b733a31333a2273686f775f7175616e74697479223b623a303b733a31363a2264656661756c745f7175616e74697479223b693a313b733a373a22636f6d62696e65223b623a313b733a31343a226c696e655f6974656d5f74797065223b733a373a2270726f64756374223b7d733a363a226d6f64756c65223b733a31333a22636f6d6d657263655f63617274223b7d733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a33303a22636f6d6d657263655f636172745f6164645f746f5f636172745f666f726d223b733a383a2273657474696e6773223b613a343a7b733a31333a2273686f775f7175616e74697479223b623a303b733a31363a2264656661756c745f7175616e74697479223b693a313b733a373a22636f6d62696e65223b623a313b733a31343a226c696e655f6974656d5f74797065223b733a373a2270726f64756374223b7d733a363a226d6f64756c65223b733a31333a22636f6d6d657263655f63617274223b733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(17, 14, 'commerce_display_path', 'commerce_line_item', 'product', 0x613a363a7b733a353a226c6162656c223b733a31323a22446973706c61792070617468223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a22646973706c6179223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a333b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(18, 11, 'commerce_unit_price', 'commerce_line_item', 'rooms_booking', 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, 0),
(19, 12, 'commerce_total', 'commerce_line_item', 'rooms_booking', 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, 0),
(20, 13, 'commerce_product', 'commerce_line_item', 'rooms_booking', 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, 0),
(21, 15, 'rooms_booking_dates', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a31333a22426f6f6b696e67204461746573223b733a383a227265717569726564223b623a303b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31303a22646174655f706f707570223b733a363a226d6f64756c65223b733a343a2264617465223b733a383a2273657474696e6773223b613a393a7b733a31333a2264656661756c745f76616c7565223b733a333a226e6f77223b733a31343a2264656661756c745f666f726d6174223b733a363a226d656469756d223b733a31323a22696e7075745f666f726d6174223b733a31333a226d2f642f59202d20483a693a73223b733a31393a22696e7075745f666f726d61745f637573746f6d223b733a303a22223b733a393a22696e6372656d656e74223b693a31353b733a31303a22746578745f7061727473223b613a303a7b7d733a31303a22796561725f72616e6765223b733a353a222d333a2b33223b733a31343a226c6162656c5f706f736974696f6e223b733a353a2261626f7665223b733a31353a22646973706c61795f616c6c5f646179223b693a303b7d733a363a22776569676874223b693a323b7d733a383a2273657474696e6773223b613a353a7b733a31333a2264656661756c745f76616c7565223b733a333a226e6f77223b733a31383a2264656661756c745f76616c75655f636f6465223b733a303a22223b733a31343a2264656661756c745f76616c756532223b733a343a2273616d65223b733a31393a2264656661756c745f76616c75655f636f646532223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22646174655f64656661756c74223b733a383a2273657474696e6773223b613a353a7b733a31313a22666f726d61745f74797065223b733a343a226c6f6e67223b733a31353a226d756c7469706c655f6e756d626572223b733a303a22223b733a31333a226d756c7469706c655f66726f6d223b733a303a22223b733a31313a226d756c7469706c655f746f223b733a303a22223b733a363a2266726f6d746f223b733a343a22626f7468223b7d733a363a226d6f64756c65223b733a343a2264617465223b733a363a22776569676874223b693a333b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(22, 16, 'rooms_booked_unit_id', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a31343a22426f6f6b656420556e6974204944223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a383a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b733a333a226d696e223b733a303a22223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a333b733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a343a7b733a31373a22646563696d616c5f736570617261746f72223b733a313a222e223b733a31333a227072656669785f737566666978223b623a313b733a353a227363616c65223b693a303b733a31383a2274686f7573616e645f736570617261746f72223b733a313a2220223b7d733a343a2274797065223b733a31343a226e756d6265725f696e7465676572223b733a363a22776569676874223b693a31313b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(23, 17, 'rooms_booked_status', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a31383a22426f6f6b656420556e697420537461747573223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a383a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b733a333a226d696e223b733a303a22223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a343b733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a343a7b733a31373a22646563696d616c5f736570617261746f72223b733a313a222e223b733a31333a227072656669785f737566666978223b623a313b733a353a227363616c65223b693a303b733a31383a2274686f7573616e645f736570617261746f72223b733a313a2220223b7d733a343a2274797065223b733a31343a226e756d6265725f696e7465676572223b733a363a22776569676874223b693a31313b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(24, 18, 'rooms_booked_price', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a31373a22426f6f6b656420556e6974205072696365223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a383a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b733a333a226d696e223b733a303a22223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a353b733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a343a7b733a31373a22646563696d616c5f736570617261746f72223b733a313a222e223b733a31333a227072656669785f737566666978223b623a313b733a353a227363616c65223b693a303b733a31383a2274686f7573616e645f736570617261746f72223b733a313a2220223b7d733a343a2274797065223b733a31343a226e756d6265725f696e7465676572223b733a363a22776569676874223b693a31313b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(25, 19, 'rooms_booked_bookingprice', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a31333a22426f6f6b696e67205072696365223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a383a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b733a333a226d696e223b733a303a22223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a363b733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a343a7b733a31373a22646563696d616c5f736570617261746f72223b733a313a222e223b733a31333a227072656669785f737566666978223b623a313b733a353a227363616c65223b693a303b733a31383a2274686f7573616e645f736570617261746f72223b733a313a2220223b7d733a343a2274797065223b733a31343a226e756d6265725f696e7465676572223b733a363a22776569676874223b693a31313b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(26, 14, 'commerce_display_path', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a31323a22446973706c61792070617468223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a22646973706c6179223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a363a22776569676874223b693a303b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a31323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(27, 20, 'commerce_price', 'commerce_product', 'product', 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, 0),
(28, 20, 'commerce_price', 'commerce_product', 'rooms_product', 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, 0),
(29, 1, 'comment_body', 'comment', 'comment_node_poll', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0);
INSERT INTO `field_config_instance` (`id`, `field_id`, `field_name`, `entity_type`, `bundle`, `data`, `deleted`) VALUES
(43, 1, 'comment_body', 'comment', 'comment_node_promotions', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(44, 2, 'body', 'node', 'promotions', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a323a223331223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(45, 23, 'field_images', 'node', 'promotions', 0x613a363a7b733a353a226c6162656c223b733a363a22496d61676573223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223332223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31323a226669656c642f696d61676573223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(47, 25, 'field_slideshow_image', 'node', 'promotions', 0x613a363a7b733a353a226c6162656c223b733a31353a22536c69646573686f7720496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223333223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31353a226669656c642f736c69646573686f77223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(48, 1, 'comment_body', 'comment', 'comment_node_news_events', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(49, 2, 'body', 'node', 'news_events', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a323a223331223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(50, 23, 'field_images', 'node', 'news_events', 0x613a363a7b733a353a226c6162656c223b733a363a22496d61676573223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223333223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31323a226669656c642f696d61676573223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(51, 25, 'field_slideshow_image', 'node', 'news_events', 0x613a363a7b733a353a226c6162656c223b733a31353a22536c69646573686f7720496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223335223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31353a226669656c642f736c69646573686f77223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(52, 1, 'comment_body', 'comment', 'comment_node_services_facilities', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(53, 2, 'body', 'node', 'services_facilities', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a323a223331223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(54, 23, 'field_images', 'node', 'services_facilities', 0x613a363a7b733a353a226c6162656c223b733a363a22496d61676573223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223333223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31323a226669656c642f696d61676573223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a31313a22696d675f3634365f323436223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(55, 25, 'field_slideshow_image', 'node', 'services_facilities', 0x613a363a7b733a353a226c6162656c223b733a31353a22536c69646573686f7720496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223335223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31353a226669656c642f736c69646573686f77223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(56, 1, 'comment_body', 'comment', 'comment_node_photo_galleries', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(57, 2, 'body', 'node', 'photo_galleries', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a313a2233223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(58, 23, 'field_images', 'node', 'photo_galleries', 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, 0),
(61, 27, 'field_availability', 'node', 'unit_description', 0x613a373a7b733a353a226c6162656c223b733a31323a22417661696c6162696c697479223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2231223b733a343a2274797065223b733a34313a22726f6f6d735f617661696c6162696c6974795f7265666572656e63655f6175746f636f6d706c657465223b733a363a226d6f64756c65223b733a32383a22726f6f6d735f617661696c6162696c6974795f7265666572656e6365223b733a363a22616374697665223b693a303b733a383a2273657474696e6773223b613a333a7b733a31383a226175746f636f6d706c6574655f6d61746368223b733a383a22636f6e7461696e73223b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a34313a22726f6f6d735f617661696c6162696c6974795f7265666572656e63652f6175746f636f6d706c657465223b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a33363a22726f6f6d735f617661696c6162696c6974795f7265666572656e63655f64656661756c74223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a32383a22726f6f6d735f617661696c6162696c6974795f7265666572656e6365223b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(62, 23, 'field_images', 'node', 'unit_description', 0x613a363a7b733a353a226c6162656c223b733a363a22496d61676573223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31313a226669656c642f726f6f6d73223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a383a22636f6c6f72626f78223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a363a7b733a31393a22636f6c6f72626f785f6e6f64655f7374796c65223b733a363a226d656469756d223b733a32303a22636f6c6f72626f785f696d6167655f7374796c65223b733a32323a2267616c6c657279666f726d61747465725f736c696465223b733a31363a22636f6c6f72626f785f67616c6c657279223b733a343a22706f7374223b733a32333a22636f6c6f72626f785f67616c6c6572795f637573746f6d223b733a303a22223b733a31363a22636f6c6f72626f785f63617074696f6e223b733a343a226175746f223b733a32333a22636f6c6f72626f785f63617074696f6e5f637573746f6d223b733a303a22223b7d733a363a226d6f64756c65223b733a383a22636f6c6f72626f78223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(64, 4, 'field_image', 'rooms_unit', 'basic_suite', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31313a22696d6167652f726f6f6d73223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(65, 28, 'field_description', 'rooms_unit', 'basic_suite', 0x613a373a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2233223b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b733a323a223230223b733a31323a2273756d6d6172795f726f7773223b693a353b7d7d733a383a2273657474696e6773223b613a333a7b733a31353a22746578745f70726f63657373696e67223b733a313a2231223b733a31353a22646973706c61795f73756d6d617279223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(66, 4, 'field_image', 'rooms_unit', 'deluxe_suite', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31313a22696d6167652f726f6f6d73223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(67, 28, 'field_description', 'rooms_unit', 'deluxe_suite', 0x613a373a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2234223b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b733a323a223230223b733a31323a2273756d6d6172795f726f7773223b693a353b7d7d733a383a2273657474696e6773223b613a333a7b733a31353a22746578745f70726f63657373696e67223b733a313a2231223b733a31353a22646973706c61795f73756d6d617279223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(68, 4, 'field_image', 'rooms_unit', 'luxury_suite', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31313a22696d6167652f726f6f6d73223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(69, 28, 'field_description', 'rooms_unit', 'luxury_suite', 0x613a373a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2234223b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b733a323a223230223b733a31323a2273756d6d6172795f726f7773223b693a353b7d7d733a383a2273657474696e6773223b613a333a7b733a31353a22746578745f70726f63657373696e67223b733a313a2231223b733a31353a22646973706c61795f73756d6d617279223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(70, 4, 'field_image', 'rooms_unit', 'royal_suite', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31313a22696d6167652f726f6f6d73223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(71, 28, 'field_description', 'rooms_unit', 'royal_suite', 0x613a373a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2234223b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b733a323a223230223b733a31323a2273756d6d6172795f726f7773223b693a353b7d7d733a383a2273657474696e6773223b613a333a7b733a31353a22746578745f70726f63657373696e67223b733a313a2231223b733a31353a22646973706c61795f73756d6d617279223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(72, 28, 'field_description', 'node', 'unit_description', 0x613a373a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2233223b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a363a226d6f64756c65223b733a343a2274657874223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b733a323a223230223b733a31323a2273756d6d6172795f726f7773223b693a353b7d7d733a383a2273657474696e6773223b613a333a7b733a31353a22746578745f70726f63657373696e67223b733a313a2231223b733a31353a22646973706c61795f73756d6d617279223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b733a333a22353030223b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(73, 25, 'field_slideshow_image', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a31353a22536c69646573686f7720496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223332223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a303a22223b7d7d733a383a2273657474696e6773223b613a393a7b733a31343a2266696c655f6469726563746f7279223b733a31353a226669656c642f736c69646573686f77223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31333a2264656661756c745f696d616765223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2233223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(74, 29, 'rooms_booking_number_people', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a32313a22426f6f6b696e67204e756d6265722050656f706c65223b733a383a227265717569726564223b623a313b733a383a2273657474696e6773223b613a383a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b733a333a226d696e223b733a303a22223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a373b733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a343a7b733a31373a22646563696d616c5f736570617261746f72223b733a313a222e223b733a31333a227072656669785f737566666978223b623a313b733a353a227363616c65223b693a303b733a31383a2274686f7573616e645f736570617261746f72223b733a313a2220223b7d733a343a2274797065223b733a31343a226e756d6265725f696e7465676572223b733a363a22776569676874223b693a31313b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(75, 30, 'rooms_booking_options', 'commerce_line_item', 'rooms_booking', 0x613a373a7b733a353a226c6162656c223b733a31353a22426f6f6b696e67204f7074696f6e73223b733a31333a2264656661756c745f76616c7565223b4e3b733a31313a226465736372697074696f6e223b733a303a22223b733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a32313a22726f6f6d735f6f7074696f6e735f64656661756c74223b733a363a22776569676874223b693a31323b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b693a303b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a343a2274797065223b733a32323a22726f6f6d735f6f7074696f6e735f636f6d62696e6564223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a383b7d7d, 0),
(76, 31, 'rooms_booking_reference', 'commerce_line_item', 'rooms_booking', 0x613a373a7b733a353a226c6162656c223b733a31373a22426f6f6b696e67205265666572656e6365223b733a31333a2264656661756c745f76616c7565223b4e3b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a31353a22656e746974797265666572656e6365223b733a383a2273657474696e6773223b613a313a7b733a343a226c696e6b223b623a303b7d733a343a2274797065223b733a32313a22656e746974797265666572656e63655f6c6162656c223b733a363a22776569676874223b693a31333b7d7d733a383a227265717569726564223b693a303b733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a353a7b733a363a22616374697665223b693a313b733a363a226d6f64756c65223b733a31353a22656e746974797265666572656e6365223b733a383a2273657474696e6773223b613a333a7b733a31343a226d617463685f6f70657261746f72223b733a383a22434f4e5441494e53223b733a343a2270617468223b733a303a22223b733a343a2273697a65223b733a323a223630223b7d733a343a2274797065223b733a32383a22656e746974797265666572656e63655f6175746f636f6d706c657465223b733a363a22776569676874223b733a313a2239223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(77, 32, 'rooms_booking_unit_options', 'rooms_unit', 'basic_suite', 0x613a363a7b733a353a226c6162656c223b733a373a224f7074696f6e73223b733a383a227265717569726564223b623a303b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22726f6f6d735f6f7074696f6e73223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a343b733a363a226d6f64756c65223b4e3b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22726f6f6d735f6f7074696f6e735f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(78, 32, 'rooms_booking_unit_options', 'rooms_unit', 'deluxe_suite', 0x613a363a7b733a353a226c6162656c223b733a373a224f7074696f6e73223b733a383a227265717569726564223b623a303b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22726f6f6d735f6f7074696f6e73223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b733a363a226d6f64756c65223b4e3b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22726f6f6d735f6f7074696f6e735f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(79, 32, 'rooms_booking_unit_options', 'rooms_unit', 'luxury_suite', 0x613a363a7b733a353a226c6162656c223b733a373a224f7074696f6e73223b733a383a227265717569726564223b623a303b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22726f6f6d735f6f7074696f6e73223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b733a363a226d6f64756c65223b4e3b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22726f6f6d735f6f7074696f6e735f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(80, 32, 'rooms_booking_unit_options', 'rooms_unit', 'royal_suite', 0x613a363a7b733a353a226c6162656c223b733a373a224f7074696f6e73223b733a383a227265717569726564223b623a303b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22726f6f6d735f6f7074696f6e73223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a353b733a363a226d6f64756c65223b4e3b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22726f6f6d735f6f7074696f6e735f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0);
INSERT INTO `field_config_instance` (`id`, `field_id`, `field_name`, `entity_type`, `bundle`, `data`, `deleted`) VALUES
(81, 33, 'rooms_booking_children_ages', 'commerce_line_item', 'rooms_booking', 0x613a363a7b733a353a226c6162656c223b733a32313a22426f6f6b696e67204368696c6472656e2041676573223b733a383a227265717569726564223b623a303b733a383a2273657474696e6773223b613a383a7b733a343a2273697a65223b693a383b733a31303a226d61785f6c656e677468223b693a31303b733a31353a22746578745f70726f63657373696e67223b693a303b733a333a226d696e223b733a303a22223b733a333a226d6178223b733a303a22223b733a363a22707265666978223b733a303a22223b733a363a22737566666978223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a22776569676874223b693a31303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a363a226d6f64756c65223b733a363a226e756d626572223b733a383a2273657474696e6773223b613a343a7b733a31373a22646563696d616c5f736570617261746f72223b733a313a222e223b733a31333a227072656669785f737566666978223b623a313b733a353a227363616c65223b693a303b733a31383a2274686f7573616e645f736570617261746f72223b733a313a2220223b7d733a343a2274797065223b733a31343a226e756d6265725f696e7465676572223b733a363a22776569676874223b693a31333b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a383a2273657474696e6773223b613a303a7b7d733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(82, 32, 'rooms_booking_unit_options', 'rooms_unit_type', 'rooms_unit_type', 0x613a363a7b733a353a226c6162656c223b733a373a224f7074696f6e73223b733a383a227265717569726564223b623a303b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22726f6f6d735f6f7074696f6e73223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b4e3b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22726f6f6d735f6f7074696f6e735f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a353a22726f6f6d73223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_body`
--

CREATE TABLE IF NOT EXISTS `field_data_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 2 (body)';

--
-- Dumping data for table `field_data_body`
--

INSERT INTO `field_data_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'page', 0, 1, 1, 'und', 0, '<dl class="support-content">\r\n<dt>Contact us</dt>\r\n<dd><p>Suspendisse vel sollicitudin metus. Fusce ac turpis quis elit eleifend vestibulum id sed tellus. Fusce vulputate faucibus auctor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed cursus sapien aliquet mauris auctor egestas. Cras at nisl sed metus tempor posuere vel at tellus. Cras faucibus dui sed lectus elementum vitae imperdiet lectus pulvinar. Quisque non sapien neque. Vestibulum a mi lectus. </p></dd>\r\n<dt>Recent Stay Comments</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n<dt>Reservations FAQ</dt>\r\n<dd><p>Morbi pellentesque adipiscing dui, in vehicula lorem dictum sollicitudin. Praesent pretium placerat dictum. Sed suscipit, leo ac gravida egestas, nibh nisl viverra odio, a pulvinar mauris turpis non augue. Quisque non metus metus, ac congue tortor. Nam ac lorem quam. Morbi et sem sit amet odio egestas semper. Mauris venenatis porta ligula euismod venenatis. Vivamus nibh lacus, tincidunt eget lobortis eget, pharetra sit amet sapien.</p><p>Proin commodo massa sed lorem ullamcorper eget pulvinar magna pharetra. Quisque sollicitudin interdum felis, in tristique est rutrum quis. Suspendisse eu fringilla dolor. Integer vitae mauris est. Suspendisse potenti. Nulla lacinia molestie porta. </p></dd>\r\n<dt>Call Us</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n</dl>', '', 'full_html'),
('node', 'promotions', 0, 2, 2, 'und', 0, 'Nullam a dapibus arcu. Duis nec velit nec dolor cursus condimentum in id massa. Ut elementum, arcu in dignissim bibendum, ante justo commodo leo, non condimentum mauris diam in nulla. Etiam tincidunt est sit amet magna luctus condimentum. Aliquam mattis rutrum eros et tincidunt. Sed eu cursus neque. Cras egestas felis sit amet mauris accumsan eget sodales lacus vulputate. Etiam pulvinar neque et nisl fringilla ut mattis est eleifend. Vestibulum metus urna, vulputate nec aliquet aliquet, volutpat vitae erat. Nullam nibh lectus, ultricies adipiscing aliquam ac, varius et magna. Phasellus ut nisi volutpat mi tempor faucibus eu eget nulla? Curabitur molestie laoreet tellus, ut egestas erat vehicula non.\r\n\r\nVivamus porta faucibus mi, id congue elit convallis non. Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem. Curabitur condimentum enim sit amet eros tempus fringilla? Donec arcu magna, varius eu elementum et, faucibus nec arcu. Aenean varius, purus a dignissim fermentum; purus leo venenatis dui, nec rhoncus neque augue ut dolor. Duis aliquet risus sit amet purus suscipit ut faucibus urna gravida? Duis vitae risus eu sem aliquet sodales. Donec sit amet ligula metus.\r\n', '', 'filtered_html'),
('node', 'services_facilities', 0, 6, 6, 'und', 0, 'Revitalize with a healthy workout in the fully appointed fitness center. Maximize your workout routine with treadmills, cycles, and workout station. Enjoy the panorama from the 24th floor, or watch a variety of international channels on the 32” televisions. And experience total relaxation after your work out in the separate saunas for men and women.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 to 22:00', '', 'filtered_html'),
('node', 'services_facilities', 0, 7, 7, 'und', 0, 'Lounge by the swimming pool and take in the spectacular views of Saigon from the 24th floor. The swimming pool has a maximum depth of 1.8 meters. Poolside furniture offers a pristine spot to read a book, enjoy a drink, or just bask in some tropical rays.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 - 22:00', '', 'filtered_html'),
('node', 'services_facilities', 0, 8, 8, 'und', 0, 'With meeting rooms, copy and fax services, and internet connectivity, accomplishing important tasks is quick and efficient at the Business Center. Using the on-site computers, you can check email, browse the net, or look up your next travel destination. Our experienced receptionist is at hand to help you solve any problems that may arise.\r\n\r\nLocation: 4th floor', '', 'filtered_html'),
('node', 'photo_galleries', 0, 9, 9, 'und', 0, 'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.\r\n', '', 'filtered_html'),
('node', 'photo_galleries', 0, 10, 10, 'und', 0, 'Pellentesque molestie, quam sit amet aliquet porttitor, enim neque bibendum turpis, ac convallis orci lectus id est. Aenean nec diam nec nibh fermentum malesuada sit amet in nisl. Integer varius, metus nec dictum blandit, ante felis suscipit quam, sed tincidunt ante dui sed enim. Fusce gravida, magna at posuere pretium, leo purus dictum ipsum, eleifend ornare tellus justo ac augue. Aenean et pharetra leo. Sed ut lectus felis. Praesent vitae velit quis mi ultrices vehicula vel ac leo.\r\n\r\nQuisque erat ligula, tempus et interdum eu, egestas a libero. Sed a condimentum felis! In semper enim eu ligula luctus luctus. Ut mattis, nisi in congue condimentum, velit diam semper orci, quis tincidunt urna ligula at ligula? Nullam ante purus, elementum at ultrices in, mollis non massa. Nulla commodo, felis in pretium ornare, nunc mi dignissim ligula, non pellentesque orci leo sit amet orci. Nulla tincidunt fringilla nulla, sit amet vestibulum leo porttitor eu. Curabitur sit amet sapien a ipsum pulvinar tristique eget in velit. Donec sagittis vulputate sem ac consequat. Aliquam sem urna, tristique sit amet commodo a; placerat at enim! Nulla eu bibendum tortor. Pellentesque vitae nulla et elit nullam.\r\n', '', 'filtered_html'),
('node', 'news_events', 0, 11, 11, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'news_events', 0, 12, 12, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'news_events', 0, 13, 13, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'promotions', 0, 14, 14, 'und', 0, 'Mauris lacinia tellus sit amet justo laoreet facilisis. Fusce non urna ut libero tempus auctor sit amet in leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Curabitur vel nunc a enim commodo porta non eget augue. Duis placerat, risus a faucibus tempor, ligula diam imperdiet justo, nec venenatis orci magna at augue! Ut ut mauris id sem feugiat molestie. Morbi ac magna sapien, nec sollicitudin nibh. Aenean auctor molestie leo, sit amet malesuada nisi pulvinar sit amet. Nullam mollis iaculis cursus. Morbi id tristique felis. Aenean sagittis sollicitudin mollis. Nulla facilisi. Maecenas molestie tincidunt aliquam. In luctus, nunc at consequat iaculis, dolor turpis consequat nisi, ac interdum mi mauris euismod mi? Aliquam eu elementum arcu!\r\n\r\nQuisque sit amet felis ligula, a porttitor nunc. Nullam ac ante et purus viverra imperdiet? Nam id tellus arcu, eu convallis sapien. Sed sit amet mattis risus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam mattis tellus non arcu pharetra at porta libero lobortis. Morbi eleifend mauris sed mauris molestie quis blandit massa lobortis! Aliquam molestie, elit sed.\r\n', '', 'filtered_html'),
('node', 'article', 0, 15, 15, 'und', 0, 'Curabitur dapibus felis sit amet odio sodales ultrices. Sed non dolor tortor. Donec blandit diam sed ligula tempor egestas. Cras rhoncus enim tortor, vel venenatis libero. Sed eu sem urna, vitae luctus ligula? Pellentesque pulvinar, nisl sit amet sagittis rhoncus, neque sem luctus ante, vel sodales quam metus at turpis. Sed massa augue, sollicitudin ut tristique ut, malesuada elementum tellus. Nunc nec leo lacus? Etiam dictum, orci nec tincidunt iaculis, dui diam accumsan leo, et blandit tortor tortor non lacus. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nProin elit eros; sagittis vel facilisis vitae, facilisis vel tellus. Praesent elementum viverra orci rutrum posuere? Nunc pretium diam a purus ornare hendrerit eget a mauris. Nullam sodales orci nec neque scelerisque quis iaculis orci accumsan. Maecenas gravida quam quis odio feugiat condimentum. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nNunc odio risus, auctor ut gravida et, venenatis quis quam. Quisque dapibus dictum vestibulum. In at nunc quam, quis pellentesque risus. Aliquam venenatis enim sit amet risus congue quis adipiscing eros posuere.', '', 'filtered_html'),
('node', 'services_facilities', 0, 16, 16, 'und', 0, 'Give your children some time to relax and move about in our spacious supervised kids’ corner. Children can stimulate their bodies and minds with a variety of educational toys and games. Young adults will enjoy the games room equipped with the latest generation of video game consoles and large LCD TVs.\r\n\r\nLocation: 4th floor', '', 'filtered_html'),
('node', 'services_facilities', 0, 17, 17, 'und', 0, 'Sed scelerisque justo id massa laoreet sollicitudin. Sed id lorem ornare nunc elementum convallis. Nam lectus ligula, rutrum ac convallis vel, tempus sodales dui. Pellentesque euismod est eget sem vehicula facilisis. Pellentesque lacinia mollis eleifend. Sed cursus lobortis scelerisque. Maecenas nulla tellus, viverra a lobortis quis, bibendum vel nunc.\r\n\r\nUt accumsan orci vel dolor eleifend venenatis varius erat vestibulum. Vivamus commodo porta ligula, ut dictum ligula ornare ac. Nulla erat dui, condimentum a malesuada quis, pharetra ut nulla. Vivamus posuere semper massa, quis volutpat nulla porta sit amet. Vivamus rhoncus, risus quis sodales egestas, orci risus volutpat felis, sed euismod massa quam non velit.\r\n\r\nLocation: 4th floor', '', 'filtered_html'),
('node', 'photo_galleries', 0, 18, 18, 'und', 0, 'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.', '', 'filtered_html'),
('node', 'photo_galleries', 0, 19, 19, 'und', 0, 'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.', '', 'filtered_html'),
('node', 'article', 0, 20, 20, 'und', 0, 'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.', '', 'filtered_html'),
('node', 'article', 0, 21, 21, 'und', 0, 'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n', '', 'filtered_html'),
('node', 'article', 0, 22, 22, 'und', 0, 'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n', '', 'filtered_html'),
('node', 'news_events', 0, 23, 23, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'news_events', 0, 24, 24, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_comment_body`
--

CREATE TABLE IF NOT EXISTS `field_data_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 1 (comment_body)';

--
-- Dumping data for table `field_data_comment_body`
--

INSERT INTO `field_data_comment_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `comment_body_value`, `comment_body_format`) VALUES
('comment', 'comment_node_promotions', 0, 1, 1, 'und', 0, 'Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem.', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_customer_address`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_customer_address` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_address_country` varchar(2) DEFAULT '' COMMENT 'Two letter ISO country code of this address.',
  `commerce_customer_address_administrative_area` varchar(255) DEFAULT '' COMMENT 'The administrative area of this address. (i.e. State/Province)',
  `commerce_customer_address_sub_administrative_area` varchar(255) DEFAULT '' COMMENT 'The sub administrative area of this address.',
  `commerce_customer_address_locality` varchar(255) DEFAULT '' COMMENT 'The locality of this address. (i.e. City)',
  `commerce_customer_address_dependent_locality` varchar(255) DEFAULT '' COMMENT 'The dependent locality of this address.',
  `commerce_customer_address_postal_code` varchar(255) DEFAULT '' COMMENT 'The postal code of this address.',
  `commerce_customer_address_thoroughfare` varchar(255) DEFAULT '' COMMENT 'The thoroughfare of this address. (i.e. Street address)',
  `commerce_customer_address_premise` varchar(255) DEFAULT '' COMMENT 'The premise of this address. (i.e. Apartment / Suite number)',
  `commerce_customer_address_sub_premise` varchar(255) DEFAULT '' COMMENT 'The sub_premise of this address.',
  `commerce_customer_address_organisation_name` varchar(255) DEFAULT '' COMMENT 'Contents of a primary OrganisationName element in the xNL XML.',
  `commerce_customer_address_name_line` varchar(255) DEFAULT '' COMMENT 'Contents of a primary NameLine element in the xNL XML.',
  `commerce_customer_address_first_name` varchar(255) DEFAULT '' COMMENT 'Contents of the FirstName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_last_name` varchar(255) DEFAULT '' COMMENT 'Contents of the LastName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_data` longtext COMMENT 'Additional data for this address.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 5 (commerce_customer_address)';

--
-- Dumping data for table `field_data_commerce_customer_address`
--

INSERT INTO `field_data_commerce_customer_address` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_customer_address_country`, `commerce_customer_address_administrative_area`, `commerce_customer_address_sub_administrative_area`, `commerce_customer_address_locality`, `commerce_customer_address_dependent_locality`, `commerce_customer_address_postal_code`, `commerce_customer_address_thoroughfare`, `commerce_customer_address_premise`, `commerce_customer_address_sub_premise`, `commerce_customer_address_organisation_name`, `commerce_customer_address_name_line`, `commerce_customer_address_first_name`, `commerce_customer_address_last_name`, `commerce_customer_address_data`) VALUES
('commerce_customer_profile', 'billing', 0, 1, 1, 'und', 0, 'VN', '048', NULL, 'hcm', NULL, '014', '11', '1111', NULL, NULL, 'Trung', NULL, NULL, NULL),
('commerce_customer_profile', 'billing', 0, 2, 2, 'und', 0, 'VN', '014', NULL, 'hcm', NULL, '12', '94 B5 Hung Vuong F9 Q5', '', NULL, NULL, 'Huynh Huu Trung', NULL, NULL, NULL),
('commerce_customer_profile', 'billing', 0, 3, 3, 'und', 0, 'VN', '084', NULL, 'HCM', NULL, '084', '364 Cong Hoa Tan Binh ', '', NULL, NULL, 'Nguyen Ngoc Hai', NULL, NULL, NULL),
('commerce_customer_profile', 'billing', 0, 4, 4, 'und', 0, 'VN', '084', NULL, 'HCM', NULL, '084', '94 B5 Hung Vuong F9 Q5', '', NULL, NULL, 'Huynh Huu Trung', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_customer_billing`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_customer_billing` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_billing_profile_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_customer_billing_profile_id` (`commerce_customer_billing_profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 8 (commerce_customer_billing)';

--
-- Dumping data for table `field_data_commerce_customer_billing`
--

INSERT INTO `field_data_commerce_customer_billing` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_customer_billing_profile_id`) VALUES
('commerce_order', 'commerce_order', 0, 1, 10, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 0, 3),
('commerce_order', 'commerce_order', 0, 4, 40, 'und', 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_display_path`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_display_path` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_display_path_value` varchar(255) DEFAULT NULL,
  `commerce_display_path_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_display_path_format` (`commerce_display_path_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 14 (commerce_display_path)';

--
-- Dumping data for table `field_data_commerce_display_path`
--

INSERT INTO `field_data_commerce_display_path` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_display_path_value`, `commerce_display_path_format`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_line_items`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_line_items` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_line_items_line_item_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_line_items_line_item_id` (`commerce_line_items_line_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 6 (commerce_line_items)';

--
-- Dumping data for table `field_data_commerce_line_items`
--

INSERT INTO `field_data_commerce_line_items` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_line_items_line_item_id`) VALUES
('commerce_order', 'commerce_order', 0, 1, 10, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 4, 40, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 0, 12),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 1, 13),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 2, 14),
('commerce_order', 'commerce_order', 0, 6, 46, 'und', 0, 15);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_order_total`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_order_total` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_order_total_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_order_total_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_order_total_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_order_total_currency_price` (`commerce_order_total_amount`,`commerce_order_total_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 7 (commerce_order_total)';

--
-- Dumping data for table `field_data_commerce_order_total`
--

INSERT INTO `field_data_commerce_order_total` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_order_total_amount`, `commerce_order_total_currency_code`, `commerce_order_total_data`) VALUES
('commerce_order', 'commerce_order', 0, 1, 10, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 40, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 0, 5780000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5780000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 6, 46, 'und', 0, 25000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_price`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_price_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_price_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_price_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_price_currency_price` (`commerce_price_amount`,`commerce_price_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 20 (commerce_price)';

--
-- Dumping data for table `field_data_commerce_price`
--

INSERT INTO `field_data_commerce_price` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_price_amount`, `commerce_price_currency_code`, `commerce_price_data`) VALUES
('commerce_product', 'rooms_product', 0, 1, 1, 'und', 0, 100, 'USD', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_product`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_product` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_product_product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_product_product_id` (`commerce_product_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 13 (commerce_product)';

--
-- Dumping data for table `field_data_commerce_product`
--

INSERT INTO `field_data_commerce_product` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_product_product_id`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_total`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_total` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_total_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_total_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_total_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_total_currency_price` (`commerce_total_amount`,`commerce_total_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 12 (commerce_total)';

--
-- Dumping data for table `field_data_commerce_total`
--

INSERT INTO `field_data_commerce_total` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_total_amount`, `commerce_total_currency_code`, `commerce_total_data`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 35000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 55000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:55000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 8400000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 40000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:40000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 140000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:140000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 5600000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5600000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 25000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_commerce_unit_price`
--

CREATE TABLE IF NOT EXISTS `field_data_commerce_unit_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_unit_price_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_unit_price_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_unit_price_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_unit_price_currency_price` (`commerce_unit_price_amount`,`commerce_unit_price_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 11 (commerce_unit_price)';

--
-- Dumping data for table `field_data_commerce_unit_price`
--

INSERT INTO `field_data_commerce_unit_price` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_unit_price_amount`, `commerce_unit_price_currency_code`, `commerce_unit_price_data`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 35000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 55000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:55000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 8400000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 40000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:40000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 140000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:140000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 5600000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5600000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 25000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_availability`
--

CREATE TABLE IF NOT EXISTS `field_data_field_availability` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_availability_unit_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_availability_unit_id` (`field_availability_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 27 (field_availability)';

--
-- Dumping data for table `field_data_field_availability`
--

INSERT INTO `field_data_field_availability` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_availability_unit_id`) VALUES
('node', 'unit_description', 0, 3, 3, 'und', 0, 14),
('node', 'unit_description', 0, 4, 4, 'und', 0, 17),
('node', 'unit_description', 0, 5, 5, 'und', 0, 20);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_description`
--

CREATE TABLE IF NOT EXISTS `field_data_field_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_description_value` longtext,
  `field_description_summary` longtext,
  `field_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_description_format` (`field_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 28 (field_description)';

--
-- Dumping data for table `field_data_field_description`
--

INSERT INTO `field_data_field_description` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_description_value`, `field_description_summary`, `field_description_format`) VALUES
('node', 'unit_description', 0, 3, 3, 'und', 0, 'Morbi nec malesuada ligula. Praesent quis turpis leo, quis fermentum neque. Donec vitae gravida nisi. Quisque vitae velit erat! Nam sed nisi orci. Nulla lobortis porta lacus, sit amet commodo dolor hendrerit congue. Phasellus sed erat in mauris euismod tristique! Etiam sit amet augue id metus lacinia condimentum ut at dui. Integer eget est at augue scelerisque tempor.\r\n\r\nAliquam consectetur pulvinar ipsum vitae bibendum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Pellentesque vel dui elit, vel dignissim sapien. Vivamus nisi neque, lobortis id euismod ac; sollicitudin id eros. Morbi nibh enim, euismod ac tempus eleifend; dignissim ut ligula. Quisque dapibus venenatis euismod.\r\n\r\nSed suscipit venenatis velit at adipiscing? Sed quis lacus eros, nec pulvinar justo? Praesent aliquet orci ac tortor adipiscing bibendum. Nulla faucibus justo purus. Aenean scelerisque, lorem id sodales pulvinar, ligula magna cursus est, vitae facilisis mauris dui ac risus. Aliquam lacinia, felis egestas convallis congue, justo ante auctor leo, ut ornare magna augue et lacus. Donec amet.\r\n', '', 'filtered_html'),
('node', 'unit_description', 0, 4, 4, 'und', 0, 'Duis semper massa a nibh feugiat tempus. Proin tempor rutrum sapien, nec ornare ligula rutrum et. Morbi elit quam, interdum nec consectetur at, egestas quis velit. Aliquam erat volutpat. Curabitur imperdiet urna sed metus pharetra ac malesuada urna pulvinar. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc ullamcorper viverra tristique? Morbi sit amet iaculis arcu.\r\n\r\nEtiam porttitor orci a dolor lacinia aliquet. Nullam lacus est; facilisis posuere pharetra ut; varius in libero. Quisque venenatis varius augue, vel pellentesque magna convallis rhoncus. Sed nec dolor ac sem congue commodo. Curabitur dignissim nulla a libero posuere vel mollis sem malesuada. Vestibulum sapien purus, iaculis ac vulputate id, tristique vitae lacus. Sed dolor purus, pretium id congue et, placerat sit amet felis. Aenean quis tortor felis, id rhoncus nibh.\r\n\r\nInteger dui dolor, aliquam et ultrices sed, accumsan sit amet turpis. Mauris viverra rhoncus adipiscing. Fusce ut leo at lectus eleifend eleifend. Donec dapibus dui non tortor consectetur accumsan. Nullam at elit ligula, in semper nisi! Phasellus eget est justo, eu consequat nunc? Maecenas hendrerit sodales felis, at euismod libero dapibus metus.\r\n', '', 'filtered_html'),
('node', 'unit_description', 0, 5, 5, 'und', 0, 'Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam a iaculis leo. Curabitur vitae urna erat, sit amet ornare tellus. In vitae ipsum leo. Pellentesque aliquet nisi non ipsum cursus semper. Nullam ultrices ornare aliquet! Pellentesque nec dignissim enim. Sed congue, neque ut eleifend adipiscing, leo sem hendrerit risus, fermentum feugiat velit nulla quis ligula. Morbi condimentum viverra elit, vel faucibus justo pretium non. Praesent congue massa vitae massa accumsan consectetur lacinia sapien dapibus. Phasellus placerat hendrerit libero sit amet faucibus.\r\n\r\nMorbi tincidunt commodo risus non dapibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque viverra lacus id nibh tempus ut auctor quam auctor. Nulla mattis neque sed metus rutrum sit amet pharetra justo scelerisque. Nullam a euismod mi. Curabitur facilisis ligula eu arcu hendrerit non adipiscing orci aliquam. Nunc condimentum condimentum erat, eu eleifend neque tristique quis. Quisque eros sem, ultricies in fringilla tristique, mollis a enim? Sed vitae sapien urna. Cras ipsum sem, accumsan quis hendrerit eget, aliquet at sem? cras amet.\r\n', '', 'filtered_html'),
('rooms_unit', 'basic_suite', 0, 14, 14, 'und', 0, 'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n', '', 'filtered_html'),
('rooms_unit', 'basic_suite', 0, 15, 15, 'und', 0, 'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n', '', 'filtered_html'),
('rooms_unit', 'basic_suite', 0, 16, 16, 'und', 0, 'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n', '', 'filtered_html'),
('rooms_unit', 'deluxe_suite', 0, 17, 17, 'und', 0, 'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n', '', 'filtered_html'),
('rooms_unit', 'deluxe_suite', 0, 18, 18, 'und', 0, 'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n', '', 'filtered_html'),
('rooms_unit', 'deluxe_suite', 0, 19, 19, 'und', 0, 'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n', '', 'filtered_html'),
('rooms_unit', 'luxury_suite', 0, 20, 20, 'und', 0, 'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n', '', 'filtered_html'),
('rooms_unit', 'luxury_suite', 0, 21, 21, 'und', 0, 'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n', '', 'filtered_html'),
('rooms_unit', 'luxury_suite', 0, 22, 22, 'und', 0, 'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n', '', 'filtered_html'),
('rooms_unit', 'royal_suite', 0, 23, 23, 'und', 0, 'Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n', '', 'filtered_html'),
('rooms_unit', 'royal_suite', 0, 24, 24, 'und', 0, 'Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n', '', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_image`
--

CREATE TABLE IF NOT EXISTS `field_data_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 4 (field_image)';

--
-- Dumping data for table `field_data_field_image`
--

INSERT INTO `field_data_field_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_image_fid`, `field_image_alt`, `field_image_title`, `field_image_width`, `field_image_height`) VALUES
('node', 'article', 0, 21, 21, 'und', 0, 114, '', '', 676, 396),
('node', 'article', 0, 22, 22, 'und', 0, 112, '', '', 676, 396),
('rooms_unit', 'basic_suite', 0, 14, 14, 'und', 0, 2, '', '', 200, 165),
('rooms_unit', 'basic_suite', 0, 15, 15, 'und', 0, 2, '', '', 200, 165),
('rooms_unit', 'basic_suite', 0, 16, 16, 'und', 0, 2, '', '', 200, 165),
('rooms_unit', 'deluxe_suite', 0, 17, 17, 'und', 0, 3, '', '', 200, 165),
('rooms_unit', 'deluxe_suite', 0, 18, 18, 'und', 0, 3, '', '', 200, 165),
('rooms_unit', 'deluxe_suite', 0, 19, 19, 'und', 0, 3, '', '', 200, 165),
('rooms_unit', 'luxury_suite', 0, 20, 20, 'und', 0, 4, '', '', 200, 165),
('rooms_unit', 'luxury_suite', 0, 21, 21, 'und', 0, 4, '', '', 200, 165),
('rooms_unit', 'luxury_suite', 0, 22, 22, 'und', 0, 4, '', '', 200, 165),
('rooms_unit', 'royal_suite', 0, 23, 23, 'und', 0, 5, '', '', 2400, 1895),
('rooms_unit', 'royal_suite', 0, 24, 24, 'und', 0, 5, '', '', 2400, 1895);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_images`
--

CREATE TABLE IF NOT EXISTS `field_data_field_images` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_images_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_images_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_images_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_images_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_images_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_images_fid` (`field_images_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 23 (field_images)';

--
-- Dumping data for table `field_data_field_images`
--

INSERT INTO `field_data_field_images` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_images_fid`, `field_images_alt`, `field_images_title`, `field_images_width`, `field_images_height`) VALUES
('node', 'promotions', 0, 2, 2, 'und', 0, 1, '', '', 260, 286),
('node', 'unit_description', 0, 3, 3, 'und', 0, 117, '', '', 220, 150),
('node', 'unit_description', 0, 3, 3, 'und', 1, 118, '', '', 220, 150),
('node', 'unit_description', 0, 3, 3, 'und', 2, 119, '', '', 220, 150),
('node', 'unit_description', 0, 3, 3, 'und', 3, 120, '', '', 676, 396),
('node', 'unit_description', 0, 4, 4, 'und', 0, 121, '', '', 220, 150),
('node', 'unit_description', 0, 4, 4, 'und', 1, 122, '', '', 220, 150),
('node', 'unit_description', 0, 4, 4, 'und', 2, 123, '', '', 220, 150),
('node', 'unit_description', 0, 4, 4, 'und', 3, 124, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 0, 125, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 1, 126, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 2, 127, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 3, 128, '', '', 220, 150),
('node', 'services_facilities', 0, 6, 6, 'und', 0, 91, '', '', 676, 396),
('node', 'services_facilities', 0, 7, 7, 'und', 0, 92, '', '', 676, 396),
('node', 'services_facilities', 0, 8, 8, 'und', 0, 93, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 0, 45, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 1, 46, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 2, 47, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 3, 48, '', '', 676, 396),
('node', 'photo_galleries', 0, 10, 10, 'und', 0, 49, '', '', 676, 396),
('node', 'photo_galleries', 0, 10, 10, 'und', 1, 50, '', '', 676, 396),
('node', 'photo_galleries', 0, 10, 10, 'und', 2, 72, '', '', 676, 396),
('node', 'news_events', 0, 11, 11, 'und', 0, 103, '', '', 676, 396),
('node', 'news_events', 0, 12, 12, 'und', 0, 104, '', '', 676, 396),
('node', 'news_events', 0, 13, 13, 'und', 0, 105, '', '', 676, 396),
('node', 'promotions', 0, 14, 14, 'und', 0, 41, '', '', 260, 286),
('node', 'services_facilities', 0, 16, 16, 'und', 0, 94, '', '', 676, 396),
('node', 'services_facilities', 0, 17, 17, 'und', 0, 95, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 0, 68, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 1, 69, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 2, 70, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 3, 71, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 0, 75, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 1, 76, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 2, 77, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 3, 78, '', '', 676, 396),
('node', 'news_events', 0, 23, 23, 'und', 0, 102, '', '', 676, 396),
('node', 'news_events', 0, 24, 24, 'und', 0, 101, '', '', 676, 396);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_slideshow_image`
--

CREATE TABLE IF NOT EXISTS `field_data_field_slideshow_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_slideshow_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_slideshow_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_slideshow_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_slideshow_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_slideshow_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_slideshow_image_fid` (`field_slideshow_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 25 (field_slideshow_image)';

--
-- Dumping data for table `field_data_field_slideshow_image`
--

INSERT INTO `field_data_field_slideshow_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_slideshow_image_fid`, `field_slideshow_image_alt`, `field_slideshow_image_title`, `field_slideshow_image_width`, `field_slideshow_image_height`) VALUES
('node', 'article', 0, 20, 20, 'und', 0, 116, '', '', 980, 300),
('node', 'article', 0, 21, 21, 'und', 0, 115, '', '', 980, 300),
('node', 'article', 0, 22, 22, 'und', 0, 113, '', '', 980, 300);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_tags`
--

CREATE TABLE IF NOT EXISTS `field_data_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 3 (field_tags)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booked_bookingprice`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booked_bookingprice` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_bookingprice_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 19 (rooms_booked_bookingprice)';

--
-- Dumping data for table `field_data_rooms_booked_bookingprice`
--

INSERT INTO `field_data_rooms_booked_bookingprice` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_bookingprice_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 350),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 22000),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 550),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 22000),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 2000),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 2000),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 84000),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 400),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 1400),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 56000),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 250);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booked_price`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booked_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_price_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 18 (rooms_booked_price)';

--
-- Dumping data for table `field_data_rooms_booked_price`
--

INSERT INTO `field_data_rooms_booked_price` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_price_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 35000),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 2200000),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 55000),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 2200000),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 200000),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 200000),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 8400000),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 40000),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 140000),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 5600000),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 25000);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booked_status`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booked_status` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_status_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 17 (rooms_booked_status)';

--
-- Dumping data for table `field_data_rooms_booked_status`
--

INSERT INTO `field_data_rooms_booked_status` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_status_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booked_unit_id`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booked_unit_id` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_unit_id_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 16 (rooms_booked_unit_id)';

--
-- Dumping data for table `field_data_rooms_booked_unit_id`
--

INSERT INTO `field_data_rooms_booked_unit_id` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_unit_id_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 14),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 24),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 15),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 24),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 22),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 21),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 23),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 16),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 20),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 24),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 14);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booking_children_ages`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booking_children_ages` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_children_ages_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 33 (rooms_booking_children_ages)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booking_dates`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booking_dates` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_dates_value` varchar(20) DEFAULT NULL,
  `rooms_booking_dates_value2` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 15 (rooms_booking_dates)';

--
-- Dumping data for table `field_data_rooms_booking_dates`
--

INSERT INTO `field_data_rooms_booking_dates` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booking_dates_value`, `rooms_booking_dates_value2`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, '2012-06-21', '2012-06-27'),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, '2012-06-18', '2012-06-28'),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, '2012-06-18', '2012-06-28'),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, '2012-06-19', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, '2012-06-19', '2012-06-28'),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, '2012-06-20', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, '2012-06-19', '2012-07-30'),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, '2012-06-22', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, '2012-06-23', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, '2012-07-03', '2012-07-30'),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, '2012-08-25', '2012-08-29');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booking_number_people`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booking_number_people` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_number_people_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 29 (rooms_booking_number_people)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booking_options`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booking_options` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_options_name` varchar(255) NOT NULL,
  `rooms_booking_options_quantity` int(11) DEFAULT NULL,
  `rooms_booking_options_operation` varchar(255) DEFAULT NULL,
  `rooms_booking_options_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 30 (rooms_booking_options)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booking_reference`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booking_reference` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_reference_target_id` int(10) unsigned NOT NULL COMMENT 'The id of the target entity.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `rooms_booking_reference_target_id` (`rooms_booking_reference_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 31 (rooms_booking_reference)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_rooms_booking_unit_options`
--

CREATE TABLE IF NOT EXISTS `field_data_rooms_booking_unit_options` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_unit_options_name` varchar(255) NOT NULL,
  `rooms_booking_unit_options_quantity` int(11) DEFAULT NULL,
  `rooms_booking_unit_options_operation` varchar(255) DEFAULT NULL,
  `rooms_booking_unit_options_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 32 (rooms_booking_unit_options)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_body`
--

CREATE TABLE IF NOT EXISTS `field_revision_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 2 (body)';

--
-- Dumping data for table `field_revision_body`
--

INSERT INTO `field_revision_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'page', 0, 1, 1, 'und', 0, '<dl class="support-content">\r\n<dt>Contact us</dt>\r\n<dd><p>Suspendisse vel sollicitudin metus. Fusce ac turpis quis elit eleifend vestibulum id sed tellus. Fusce vulputate faucibus auctor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed cursus sapien aliquet mauris auctor egestas. Cras at nisl sed metus tempor posuere vel at tellus. Cras faucibus dui sed lectus elementum vitae imperdiet lectus pulvinar. Quisque non sapien neque. Vestibulum a mi lectus. </p></dd>\r\n<dt>Recent Stay Comments</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n<dt>Reservations FAQ</dt>\r\n<dd><p>Morbi pellentesque adipiscing dui, in vehicula lorem dictum sollicitudin. Praesent pretium placerat dictum. Sed suscipit, leo ac gravida egestas, nibh nisl viverra odio, a pulvinar mauris turpis non augue. Quisque non metus metus, ac congue tortor. Nam ac lorem quam. Morbi et sem sit amet odio egestas semper. Mauris venenatis porta ligula euismod venenatis. Vivamus nibh lacus, tincidunt eget lobortis eget, pharetra sit amet sapien.</p><p>Proin commodo massa sed lorem ullamcorper eget pulvinar magna pharetra. Quisque sollicitudin interdum felis, in tristique est rutrum quis. Suspendisse eu fringilla dolor. Integer vitae mauris est. Suspendisse potenti. Nulla lacinia molestie porta. </p></dd>\r\n<dt>Call Us</dt>\r\n<dd><p>Donec eros justo, tincidunt sed porttitor nec, interdum sit amet justo. Nulla porttitor ligula sit amet lacus gravida dictum. Pellentesque pharetra ante vel ligula pharetra aliquet. Suspendisse accumsan, quam ut facilisis accumsan, tellus metus convallis justo, vitae ornare leo turpis nec massa.</p></dd>\r\n</dl>', '', 'full_html'),
('node', 'promotions', 0, 2, 2, 'und', 0, 'Nullam a dapibus arcu. Duis nec velit nec dolor cursus condimentum in id massa. Ut elementum, arcu in dignissim bibendum, ante justo commodo leo, non condimentum mauris diam in nulla. Etiam tincidunt est sit amet magna luctus condimentum. Aliquam mattis rutrum eros et tincidunt. Sed eu cursus neque. Cras egestas felis sit amet mauris accumsan eget sodales lacus vulputate. Etiam pulvinar neque et nisl fringilla ut mattis est eleifend. Vestibulum metus urna, vulputate nec aliquet aliquet, volutpat vitae erat. Nullam nibh lectus, ultricies adipiscing aliquam ac, varius et magna. Phasellus ut nisi volutpat mi tempor faucibus eu eget nulla? Curabitur molestie laoreet tellus, ut egestas erat vehicula non.\r\n\r\nVivamus porta faucibus mi, id congue elit convallis non. Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem. Curabitur condimentum enim sit amet eros tempus fringilla? Donec arcu magna, varius eu elementum et, faucibus nec arcu. Aenean varius, purus a dignissim fermentum; purus leo venenatis dui, nec rhoncus neque augue ut dolor. Duis aliquet risus sit amet purus suscipit ut faucibus urna gravida? Duis vitae risus eu sem aliquet sodales. Donec sit amet ligula metus.\r\n', '', 'filtered_html'),
('node', 'services_facilities', 0, 6, 6, 'und', 0, 'Revitalize with a healthy workout in the fully appointed fitness center. Maximize your workout routine with treadmills, cycles, and workout station. Enjoy the panorama from the 24th floor, or watch a variety of international channels on the 32” televisions. And experience total relaxation after your work out in the separate saunas for men and women.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 to 22:00', '', 'filtered_html'),
('node', 'services_facilities', 0, 7, 7, 'und', 0, 'Lounge by the swimming pool and take in the spectacular views of Saigon from the 24th floor. The swimming pool has a maximum depth of 1.8 meters. Poolside furniture offers a pristine spot to read a book, enjoy a drink, or just bask in some tropical rays.\r\n\r\nLocation: 24th floor\r\nHours: 6:00 - 22:00', '', 'filtered_html'),
('node', 'services_facilities', 0, 8, 8, 'und', 0, 'With meeting rooms, copy and fax services, and internet connectivity, accomplishing important tasks is quick and efficient at the Business Center. Using the on-site computers, you can check email, browse the net, or look up your next travel destination. Our experienced receptionist is at hand to help you solve any problems that may arise.\r\n\r\nLocation: 4th floor', '', 'filtered_html'),
('node', 'photo_galleries', 0, 9, 9, 'und', 0, 'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.\r\n', '', 'filtered_html'),
('node', 'photo_galleries', 0, 10, 10, 'und', 0, 'Pellentesque molestie, quam sit amet aliquet porttitor, enim neque bibendum turpis, ac convallis orci lectus id est. Aenean nec diam nec nibh fermentum malesuada sit amet in nisl. Integer varius, metus nec dictum blandit, ante felis suscipit quam, sed tincidunt ante dui sed enim. Fusce gravida, magna at posuere pretium, leo purus dictum ipsum, eleifend ornare tellus justo ac augue. Aenean et pharetra leo. Sed ut lectus felis. Praesent vitae velit quis mi ultrices vehicula vel ac leo.\r\n\r\nQuisque erat ligula, tempus et interdum eu, egestas a libero. Sed a condimentum felis! In semper enim eu ligula luctus luctus. Ut mattis, nisi in congue condimentum, velit diam semper orci, quis tincidunt urna ligula at ligula? Nullam ante purus, elementum at ultrices in, mollis non massa. Nulla commodo, felis in pretium ornare, nunc mi dignissim ligula, non pellentesque orci leo sit amet orci. Nulla tincidunt fringilla nulla, sit amet vestibulum leo porttitor eu. Curabitur sit amet sapien a ipsum pulvinar tristique eget in velit. Donec sagittis vulputate sem ac consequat. Aliquam sem urna, tristique sit amet commodo a; placerat at enim! Nulla eu bibendum tortor. Pellentesque vitae nulla et elit nullam.\r\n', '', 'filtered_html'),
('node', 'news_events', 0, 11, 11, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'news_events', 0, 12, 12, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'news_events', 0, 13, 13, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'promotions', 0, 14, 14, 'und', 0, 'Mauris lacinia tellus sit amet justo laoreet facilisis. Fusce non urna ut libero tempus auctor sit amet in leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Curabitur vel nunc a enim commodo porta non eget augue. Duis placerat, risus a faucibus tempor, ligula diam imperdiet justo, nec venenatis orci magna at augue! Ut ut mauris id sem feugiat molestie. Morbi ac magna sapien, nec sollicitudin nibh. Aenean auctor molestie leo, sit amet malesuada nisi pulvinar sit amet. Nullam mollis iaculis cursus. Morbi id tristique felis. Aenean sagittis sollicitudin mollis. Nulla facilisi. Maecenas molestie tincidunt aliquam. In luctus, nunc at consequat iaculis, dolor turpis consequat nisi, ac interdum mi mauris euismod mi? Aliquam eu elementum arcu!\r\n\r\nQuisque sit amet felis ligula, a porttitor nunc. Nullam ac ante et purus viverra imperdiet? Nam id tellus arcu, eu convallis sapien. Sed sit amet mattis risus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam mattis tellus non arcu pharetra at porta libero lobortis. Morbi eleifend mauris sed mauris molestie quis blandit massa lobortis! Aliquam molestie, elit sed.\r\n', '', 'filtered_html'),
('node', 'article', 0, 15, 15, 'und', 0, 'Curabitur dapibus felis sit amet odio sodales ultrices. Sed non dolor tortor. Donec blandit diam sed ligula tempor egestas. Cras rhoncus enim tortor, vel venenatis libero. Sed eu sem urna, vitae luctus ligula? Pellentesque pulvinar, nisl sit amet sagittis rhoncus, neque sem luctus ante, vel sodales quam metus at turpis. Sed massa augue, sollicitudin ut tristique ut, malesuada elementum tellus. Nunc nec leo lacus? Etiam dictum, orci nec tincidunt iaculis, dui diam accumsan leo, et blandit tortor tortor non lacus. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nProin elit eros; sagittis vel facilisis vitae, facilisis vel tellus. Praesent elementum viverra orci rutrum posuere? Nunc pretium diam a purus ornare hendrerit eget a mauris. Nullam sodales orci nec neque scelerisque quis iaculis orci accumsan. Maecenas gravida quam quis odio feugiat condimentum. Morbi a odio eu turpis faucibus scelerisque quis non tortor. Aenean tortor lorem, scelerisque eget scelerisque a, volutpat rhoncus ante. Nulla facilisi. Quisque ac nisi nisi.\r\n\r\nNunc odio risus, auctor ut gravida et, venenatis quis quam. Quisque dapibus dictum vestibulum. In at nunc quam, quis pellentesque risus. Aliquam venenatis enim sit amet risus congue quis adipiscing eros posuere.', '', 'filtered_html'),
('node', 'services_facilities', 0, 16, 16, 'und', 0, 'Give your children some time to relax and move about in our spacious supervised kids’ corner. Children can stimulate their bodies and minds with a variety of educational toys and games. Young adults will enjoy the games room equipped with the latest generation of video game consoles and large LCD TVs.\r\n\r\nLocation: 4th floor', '', 'filtered_html'),
('node', 'services_facilities', 0, 17, 17, 'und', 0, 'Sed scelerisque justo id massa laoreet sollicitudin. Sed id lorem ornare nunc elementum convallis. Nam lectus ligula, rutrum ac convallis vel, tempus sodales dui. Pellentesque euismod est eget sem vehicula facilisis. Pellentesque lacinia mollis eleifend. Sed cursus lobortis scelerisque. Maecenas nulla tellus, viverra a lobortis quis, bibendum vel nunc.\r\n\r\nUt accumsan orci vel dolor eleifend venenatis varius erat vestibulum. Vivamus commodo porta ligula, ut dictum ligula ornare ac. Nulla erat dui, condimentum a malesuada quis, pharetra ut nulla. Vivamus posuere semper massa, quis volutpat nulla porta sit amet. Vivamus rhoncus, risus quis sodales egestas, orci risus volutpat felis, sed euismod massa quam non velit.\r\n\r\nLocation: 4th floor', '', 'filtered_html'),
('node', 'photo_galleries', 0, 18, 18, 'und', 0, 'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.', '', 'filtered_html'),
('node', 'photo_galleries', 0, 19, 19, 'und', 0, 'Vestibulum et risus a nibh iaculis dapibus et et mauris. Suspendisse potenti. Nulla a diam urna, ut facilisis urna. Aenean faucibus est ac neque commodo blandit. Nam tempor tristique diam, a posuere est faucibus et. Nullam pulvinar augue vehicula elit tempus feugiat at sit amet lectus? Duis tristique turpis quis tortor sodales bibendum!\r\n\r\nProin ut lorem vel felis egestas tincidunt quis eget velit. Vestibulum rutrum ligula a turpis scelerisque nec viverra magna lacinia. Cras at neque odio. Ut diam diam, elementum in hendrerit nec, hendrerit at sem! Ut risus augue, imperdiet non malesuada eget; semper et orci. Fusce tellus massa, sollicitudin a ultricies a, dictum non lacus. Aliquam lobortis magna a enim rhoncus sit amet ullamcorper nunc scelerisque. Curabitur vulputate tristique orci eget egestas. Donec eu tellus sapien. Cras ante lacus, dapibus vel sollicitudin at, facilisis nec nibh. Duis et ultrices odio.\r\n\r\nSed varius, lacus quis scelerisque egestas; massa turpis tristique nisi, id dictum nisl lacus at dolor. Pellentesque pulvinar nunc sit amet nulla tincidunt bibendum. Nunc bibendum posuere libero, vel convallis lorem congue vel? Nunc suscipit accumsan tristique? Pellentesque posuere.', '', 'filtered_html'),
('node', 'article', 0, 20, 20, 'und', 0, 'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.', '', 'filtered_html'),
('node', 'article', 0, 21, 21, 'und', 0, 'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n', '', 'filtered_html'),
('node', 'article', 0, 22, 22, 'und', 0, 'Duis ut diam lacus. Cras ut purus dolor, sit amet suscipit nisl. Nullam consectetur fringilla erat, sed auctor ligula posuere sit amet. Vivamus eu tellus nisi, tincidunt adipiscing leo! Sed tortor purus, aliquet ac auctor ac, vulputate at justo. Mauris quis turpis quis nisi mollis ornare nec non mi. Etiam est ligula, laoreet in sodales et, vehicula sit amet est.\r\n\r\nMorbi lorem turpis; pellentesque ut vehicula a, tincidunt vel orci. Vestibulum convallis est in dui faucibus id porttitor tellus fermentum. Nulla purus sem, pellentesque ut dapibus sed, pharetra vel dui? Phasellus non leo id augue rhoncus euismod nec sit amet sapien. Proin consectetur, urna sit amet convallis venenatis, felis metus ornare est, ut iaculis augue diam sed nisi. Pellentesque sit amet arcu vitae massa tincidunt porttitor sit amet non mauris. Duis et arcu non dolor porttitor hendrerit. Nullam posuere elit eu sapien malesuada egestas. Pellentesque scelerisque tincidunt luctus. Nulla facilisi. Fusce rutrum mollis ligula, non pulvinar sem fringilla vitae.\r\n\r\nVestibulum at enim vitae mi luctus aliquam. Donec tempus consequat nulla ac commodo. Suspendisse convallis tincidunt enim, quis cursus dolor ultrices pretium? metus.\r\n', '', 'filtered_html'),
('node', 'news_events', 0, 23, 23, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html'),
('node', 'news_events', 0, 24, 24, 'und', 0, 'Nam non turpis at mi euismod auctor in non eros. Aliquam bibendum tellus non tellus bibendum tempor. Cras et metus augue, laoreet ullamcorper nulla. Praesent et elementum erat. Suspendisse potenti. Aliquam erat volutpat. Donec aliquam ullamcorper magna, mollis ornare sapien dapibus convallis. Nulla facilisi. Vestibulum non dictum orci. Aenean tellus quam, semper non mattis in, varius eu lacus. Integer odio tortor, bibendum ac pulvinar sit amet, ornare quis felis. Vivamus facilisis varius sapien sed venenatis.\r\n\r\nNulla mattis gravida ligula, ac fermentum orci pretium ac. Fusce sollicitudin urna eu tortor egestas tempor. Quisque nec est a mauris vestibulum consectetur. Nunc erat massa, auctor eu pharetra eget; ultrices non nunc. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum iaculis justo vel purus congue quis ornare neque cursus. Proin adipiscing, lacus sed consectetur rhoncus, turpis massa sodales enim, a pharetra augue risus id felis. Cras at elit at lacus ullamcorper eleifend! Pellentesque semper tortor a diam sagittis convallis. Aliquam in turpis tellus. Sed velit enim, venenatis quis hendrerit mattis, placerat sit amet nullam.\r\n\r\nNullam ac dui elit, ac consectetur magna. Phasellus vitae mauris felis. Vestibulum laoreet massa nec nibh porta porta pellentesque ipsum pretium! Aliquam adipiscing adipiscing nisl, id iaculis justo posuere vel. Nam tempor enim quis ipsum pellentesque condimentum. Nam justo massa, egestas quis mattis ac, facilisis id odio. Nunc elementum aliquam lacus, eu ultricies neque tempor ac. Duis pharetra scelerisque diam, ac varius eros facilisis in. Maecenas tortor nisl, iaculis nec consequat ut, dignissim sed felis. Nulla facilisi. Nulla varius bibendum erat at egestas. Mauris lorem est; varius sed laoreet sed, porttitor a lorem.\r\n\r\nNullam eu dolor nibh. Suspendisse potenti. Sed pulvinar ornare rhoncus! Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Phasellus nec quam nisl. Proin tincidunt nunc nec leo ultricies semper imperdiet eros imperdiet. Duis id quam et leo posuere fermentum eu vel magna! Quisque feugiat auctor nisi, a aliquam nisl tristique a.\r\n\r\nPhasellus lacinia posuere dui, at aliquet massa tincidunt sit amet. Phasellus convallis volutpat purus, porttitor ultricies est laoreet vitae. Nam nunc sapien, euismod sit amet egestas eget massa nunc.\r\n\r\n Maecenas at metus nec lectus dictum blandit. Cras lacinia, dui at consectetur commodo, turpis eros venenatis tortor, a tincidunt metus lacus non justo. Aenean at eros sed purus malesuada pretium sed eget tellus. Quisque in ligula vel enim ullamcorper sollicitudin at nec nisl. Mauris massa quam, porttitor et vestibulum eu, dapibus sit amet tortor. Morbi hendrerit lobortis leo, et pellentesque enim cursus in. Praesent eleifend justo et quam molestie sed volutpat metus commodo.\r\n\r\nFusce a odio nulla, sit amet suscipit ante. Vivamus id eros non massa eleifend pellentesque quis ac velit. Aliquam eget lectus eu arcu facilisis adipiscing. Integer volutpat metus eu dui vehicula at semper lacus blandit. Nullam posuere dignissim enim, in accumsan justo dictum malesuada. Nulla ante magna, tristique eu congue vitae, convallis ut ipsum. Aliquam sit amet magna vitae leo aliquam fringilla in nec tortor. Nunc at arcu magna, at placerat est. Quisque gravida neque vitae ligula porta sit amet eleifend nunc ultricies.', '', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_comment_body`
--

CREATE TABLE IF NOT EXISTS `field_revision_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 1 (comment_body)';

--
-- Dumping data for table `field_revision_comment_body`
--

INSERT INTO `field_revision_comment_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `comment_body_value`, `comment_body_format`) VALUES
('comment', 'comment_node_promotions', 0, 1, 1, 'und', 0, 'Sed lectus eros, iaculis sit amet vehicula imperdiet, malesuada ac lorem.', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_customer_address`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_customer_address` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_address_country` varchar(2) DEFAULT '' COMMENT 'Two letter ISO country code of this address.',
  `commerce_customer_address_administrative_area` varchar(255) DEFAULT '' COMMENT 'The administrative area of this address. (i.e. State/Province)',
  `commerce_customer_address_sub_administrative_area` varchar(255) DEFAULT '' COMMENT 'The sub administrative area of this address.',
  `commerce_customer_address_locality` varchar(255) DEFAULT '' COMMENT 'The locality of this address. (i.e. City)',
  `commerce_customer_address_dependent_locality` varchar(255) DEFAULT '' COMMENT 'The dependent locality of this address.',
  `commerce_customer_address_postal_code` varchar(255) DEFAULT '' COMMENT 'The postal code of this address.',
  `commerce_customer_address_thoroughfare` varchar(255) DEFAULT '' COMMENT 'The thoroughfare of this address. (i.e. Street address)',
  `commerce_customer_address_premise` varchar(255) DEFAULT '' COMMENT 'The premise of this address. (i.e. Apartment / Suite number)',
  `commerce_customer_address_sub_premise` varchar(255) DEFAULT '' COMMENT 'The sub_premise of this address.',
  `commerce_customer_address_organisation_name` varchar(255) DEFAULT '' COMMENT 'Contents of a primary OrganisationName element in the xNL XML.',
  `commerce_customer_address_name_line` varchar(255) DEFAULT '' COMMENT 'Contents of a primary NameLine element in the xNL XML.',
  `commerce_customer_address_first_name` varchar(255) DEFAULT '' COMMENT 'Contents of the FirstName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_last_name` varchar(255) DEFAULT '' COMMENT 'Contents of the LastName element of a primary PersonName element in the xNL XML.',
  `commerce_customer_address_data` longtext COMMENT 'Additional data for this address.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 5 (commerce_customer...';

--
-- Dumping data for table `field_revision_commerce_customer_address`
--

INSERT INTO `field_revision_commerce_customer_address` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_customer_address_country`, `commerce_customer_address_administrative_area`, `commerce_customer_address_sub_administrative_area`, `commerce_customer_address_locality`, `commerce_customer_address_dependent_locality`, `commerce_customer_address_postal_code`, `commerce_customer_address_thoroughfare`, `commerce_customer_address_premise`, `commerce_customer_address_sub_premise`, `commerce_customer_address_organisation_name`, `commerce_customer_address_name_line`, `commerce_customer_address_first_name`, `commerce_customer_address_last_name`, `commerce_customer_address_data`) VALUES
('commerce_customer_profile', 'billing', 0, 1, 1, 'und', 0, 'VN', '048', NULL, 'hcm', NULL, '014', '11', '1111', NULL, NULL, 'Trung', NULL, NULL, NULL),
('commerce_customer_profile', 'billing', 0, 2, 2, 'und', 0, 'VN', '014', NULL, 'hcm', NULL, '12', '94 B5 Hung Vuong F9 Q5', '', NULL, NULL, 'Huynh Huu Trung', NULL, NULL, NULL),
('commerce_customer_profile', 'billing', 0, 3, 3, 'und', 0, 'VN', '084', NULL, 'HCM', NULL, '084', '364 Cong Hoa Tan Binh ', '', NULL, NULL, 'Nguyen Ngoc Hai', NULL, NULL, NULL),
('commerce_customer_profile', 'billing', 0, 4, 4, 'und', 0, 'VN', '084', NULL, 'HCM', NULL, '084', '94 B5 Hung Vuong F9 Q5', '', NULL, NULL, 'Huynh Huu Trung', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_customer_billing`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_customer_billing` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_customer_billing_profile_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_customer_billing_profile_id` (`commerce_customer_billing_profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 8 (commerce_customer...';

--
-- Dumping data for table `field_revision_commerce_customer_billing`
--

INSERT INTO `field_revision_commerce_customer_billing` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_customer_billing_profile_id`) VALUES
('commerce_order', 'commerce_order', 0, 1, 6, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 7, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 8, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 9, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 10, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 2, 12, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 13, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 14, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 15, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 16, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 17, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 18, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 19, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 20, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 21, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 22, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 23, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 24, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 25, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 26, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 27, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 0, 2),
('commerce_order', 'commerce_order', 0, 3, 30, 'und', 0, 3),
('commerce_order', 'commerce_order', 0, 3, 31, 'und', 0, 3),
('commerce_order', 'commerce_order', 0, 3, 32, 'und', 0, 3),
('commerce_order', 'commerce_order', 0, 3, 33, 'und', 0, 3),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 0, 3),
('commerce_order', 'commerce_order', 0, 4, 36, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 4, 37, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 4, 38, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 4, 39, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 4, 40, 'und', 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_display_path`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_display_path` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_display_path_value` varchar(255) DEFAULT NULL,
  `commerce_display_path_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_display_path_format` (`commerce_display_path_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 14 (commerce_display...';

--
-- Dumping data for table `field_revision_commerce_display_path`
--

INSERT INTO `field_revision_commerce_display_path` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_display_path_value`, `commerce_display_path_format`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, '', NULL),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_line_items`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_line_items` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_line_items_line_item_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_line_items_line_item_id` (`commerce_line_items_line_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 6 (commerce_line_items)';

--
-- Dumping data for table `field_revision_commerce_line_items`
--

INSERT INTO `field_revision_commerce_line_items` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_line_items_line_item_id`) VALUES
('commerce_order', 'commerce_order', 0, 1, 1, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 2, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 2, 'und', 1, 2),
('commerce_order', 'commerce_order', 0, 1, 3, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 3, 'und', 1, 2),
('commerce_order', 'commerce_order', 0, 1, 4, 'und', 0, 1),
('commerce_order', 'commerce_order', 0, 1, 4, 'und', 1, 2),
('commerce_order', 'commerce_order', 0, 1, 4, 'und', 2, 3),
('commerce_order', 'commerce_order', 0, 1, 5, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 1, 6, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 1, 7, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 1, 8, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 1, 9, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 1, 10, 'und', 0, 4),
('commerce_order', 'commerce_order', 0, 2, 11, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 11, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 12, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 12, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 13, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 13, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 14, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 14, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 15, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 15, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 16, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 16, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 17, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 17, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 18, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 18, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 18, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 19, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 19, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 19, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 20, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 20, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 20, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 21, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 21, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 21, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 22, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 22, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 22, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 23, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 23, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 23, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 24, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 24, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 24, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 25, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 25, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 25, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 26, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 26, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 26, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 27, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 27, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 27, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 0, 5),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 1, 6),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 2, 7),
('commerce_order', 'commerce_order', 0, 3, 29, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 29, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 3, 30, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 30, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 3, 31, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 31, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 3, 32, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 32, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 3, 33, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 33, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 0, 8),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 1, 9),
('commerce_order', 'commerce_order', 0, 4, 35, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 4, 36, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 4, 37, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 4, 38, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 4, 39, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 4, 40, 'und', 0, 11),
('commerce_order', 'commerce_order', 0, 5, 41, 'und', 0, 12),
('commerce_order', 'commerce_order', 0, 5, 42, 'und', 0, 12),
('commerce_order', 'commerce_order', 0, 5, 42, 'und', 1, 13),
('commerce_order', 'commerce_order', 0, 5, 43, 'und', 0, 12),
('commerce_order', 'commerce_order', 0, 5, 43, 'und', 1, 13),
('commerce_order', 'commerce_order', 0, 5, 43, 'und', 2, 14),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 0, 12),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 1, 13),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 2, 14),
('commerce_order', 'commerce_order', 0, 6, 45, 'und', 0, 15),
('commerce_order', 'commerce_order', 0, 6, 46, 'und', 0, 15);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_order_total`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_order_total` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_order_total_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_order_total_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_order_total_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_order_total_currency_price` (`commerce_order_total_amount`,`commerce_order_total_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 7 (commerce_order_total)';

--
-- Dumping data for table `field_revision_commerce_order_total`
--

INSERT INTO `field_revision_commerce_order_total` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_order_total_amount`, `commerce_order_total_currency_code`, `commerce_order_total_data`) VALUES
('commerce_order', 'commerce_order', 0, 1, 1, 'und', 0, 20000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:20000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 2, 'und', 0, 50000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:50000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 3, 'und', 0, 50000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:50000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 4, 'und', 0, 90000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:90000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 5, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 6, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 7, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 8, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 9, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 1, 10, 'und', 0, 35000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 11, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 12, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 13, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 14, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 15, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 16, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 17, 'und', 0, 2255000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2255000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 18, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 19, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 20, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 21, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 22, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 23, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 24, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 25, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 26, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 27, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 2, 28, 'und', 0, 4455000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:4455000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 29, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 30, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 31, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 32, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 33, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 3, 34, 'und', 0, 400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 35, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 36, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 37, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 38, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 39, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 4, 40, 'und', 0, 8400000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 5, 41, 'und', 0, 40000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:40000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 5, 42, 'und', 0, 180000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:180000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 5, 43, 'und', 0, 5780000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5780000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 5, 44, 'und', 0, 5780000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5780000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 6, 45, 'und', 0, 25000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}'),
('commerce_order', 'commerce_order', 0, 6, 46, 'und', 0, 25000, 'USD', 'a:1:{s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:0:{}}s:8:"included";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_price`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_price_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_price_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_price_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_price_currency_price` (`commerce_price_amount`,`commerce_price_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 20 (commerce_price)';

--
-- Dumping data for table `field_revision_commerce_price`
--

INSERT INTO `field_revision_commerce_price` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_price_amount`, `commerce_price_currency_code`, `commerce_price_data`) VALUES
('commerce_product', 'rooms_product', 0, 1, 1, 'und', 0, 100, 'USD', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_product`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_product` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_product_product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_product_product_id` (`commerce_product_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 13 (commerce_product)';

--
-- Dumping data for table `field_revision_commerce_product`
--

INSERT INTO `field_revision_commerce_product` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_product_product_id`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_total`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_total` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_total_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_total_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_total_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_total_currency_price` (`commerce_total_amount`,`commerce_total_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 12 (commerce_total)';

--
-- Dumping data for table `field_revision_commerce_total`
--

INSERT INTO `field_revision_commerce_total` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_total_amount`, `commerce_total_currency_code`, `commerce_total_data`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 35000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 55000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:55000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 8400000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 40000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:40000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 140000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:140000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 5600000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5600000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 25000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_commerce_unit_price`
--

CREATE TABLE IF NOT EXISTS `field_revision_commerce_unit_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `commerce_unit_price_amount` int(11) NOT NULL DEFAULT '0' COMMENT 'The price amount.',
  `commerce_unit_price_currency_code` varchar(32) NOT NULL COMMENT 'The currency code for the price.',
  `commerce_unit_price_data` longtext COMMENT 'A serialized array of additional price data.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `commerce_unit_price_currency_price` (`commerce_unit_price_amount`,`commerce_unit_price_currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 11 (commerce_unit_price)';

--
-- Dumping data for table `field_revision_commerce_unit_price`
--

INSERT INTO `field_revision_commerce_unit_price` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `commerce_unit_price_amount`, `commerce_unit_price_currency_code`, `commerce_unit_price_data`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 35000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:35000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 55000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:55000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 2200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:2200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 200000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:200000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 8400000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:8400000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 40000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:40000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 140000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:140000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 5600000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:5600000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}'),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 25000, 'USD', 'a:2:{i:0;s:0:"";s:10:"components";a:1:{i:0;a:3:{s:4:"name";s:10:"base_price";s:5:"price";a:3:{s:6:"amount";i:25000;s:13:"currency_code";s:3:"USD";s:4:"data";a:2:{i:0;s:0:"";s:10:"components";a:0:{}}}s:8:"included";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_availability`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_availability` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_availability_unit_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_availability_unit_id` (`field_availability_unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 27 (field_availability)';

--
-- Dumping data for table `field_revision_field_availability`
--

INSERT INTO `field_revision_field_availability` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_availability_unit_id`) VALUES
('node', 'unit_description', 0, 3, 3, 'und', 0, 14),
('node', 'unit_description', 0, 4, 4, 'und', 0, 17),
('node', 'unit_description', 0, 5, 5, 'und', 0, 20);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_description`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_description_value` longtext,
  `field_description_summary` longtext,
  `field_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_description_format` (`field_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 28 (field_description)';

--
-- Dumping data for table `field_revision_field_description`
--

INSERT INTO `field_revision_field_description` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_description_value`, `field_description_summary`, `field_description_format`) VALUES
('node', 'unit_description', 0, 3, 3, 'und', 0, 'Morbi nec malesuada ligula. Praesent quis turpis leo, quis fermentum neque. Donec vitae gravida nisi. Quisque vitae velit erat! Nam sed nisi orci. Nulla lobortis porta lacus, sit amet commodo dolor hendrerit congue. Phasellus sed erat in mauris euismod tristique! Etiam sit amet augue id metus lacinia condimentum ut at dui. Integer eget est at augue scelerisque tempor.\r\n\r\nAliquam consectetur pulvinar ipsum vitae bibendum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Pellentesque vel dui elit, vel dignissim sapien. Vivamus nisi neque, lobortis id euismod ac; sollicitudin id eros. Morbi nibh enim, euismod ac tempus eleifend; dignissim ut ligula. Quisque dapibus venenatis euismod.\r\n\r\nSed suscipit venenatis velit at adipiscing? Sed quis lacus eros, nec pulvinar justo? Praesent aliquet orci ac tortor adipiscing bibendum. Nulla faucibus justo purus. Aenean scelerisque, lorem id sodales pulvinar, ligula magna cursus est, vitae facilisis mauris dui ac risus. Aliquam lacinia, felis egestas convallis congue, justo ante auctor leo, ut ornare magna augue et lacus. Donec amet.\r\n', '', 'filtered_html'),
('node', 'unit_description', 0, 4, 4, 'und', 0, 'Duis semper massa a nibh feugiat tempus. Proin tempor rutrum sapien, nec ornare ligula rutrum et. Morbi elit quam, interdum nec consectetur at, egestas quis velit. Aliquam erat volutpat. Curabitur imperdiet urna sed metus pharetra ac malesuada urna pulvinar. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc ullamcorper viverra tristique? Morbi sit amet iaculis arcu.\r\n\r\nEtiam porttitor orci a dolor lacinia aliquet. Nullam lacus est; facilisis posuere pharetra ut; varius in libero. Quisque venenatis varius augue, vel pellentesque magna convallis rhoncus. Sed nec dolor ac sem congue commodo. Curabitur dignissim nulla a libero posuere vel mollis sem malesuada. Vestibulum sapien purus, iaculis ac vulputate id, tristique vitae lacus. Sed dolor purus, pretium id congue et, placerat sit amet felis. Aenean quis tortor felis, id rhoncus nibh.\r\n\r\nInteger dui dolor, aliquam et ultrices sed, accumsan sit amet turpis. Mauris viverra rhoncus adipiscing. Fusce ut leo at lectus eleifend eleifend. Donec dapibus dui non tortor consectetur accumsan. Nullam at elit ligula, in semper nisi! Phasellus eget est justo, eu consequat nunc? Maecenas hendrerit sodales felis, at euismod libero dapibus metus.\r\n', '', 'filtered_html'),
('node', 'unit_description', 0, 5, 5, 'und', 0, 'Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam a iaculis leo. Curabitur vitae urna erat, sit amet ornare tellus. In vitae ipsum leo. Pellentesque aliquet nisi non ipsum cursus semper. Nullam ultrices ornare aliquet! Pellentesque nec dignissim enim. Sed congue, neque ut eleifend adipiscing, leo sem hendrerit risus, fermentum feugiat velit nulla quis ligula. Morbi condimentum viverra elit, vel faucibus justo pretium non. Praesent congue massa vitae massa accumsan consectetur lacinia sapien dapibus. Phasellus placerat hendrerit libero sit amet faucibus.\r\n\r\nMorbi tincidunt commodo risus non dapibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque viverra lacus id nibh tempus ut auctor quam auctor. Nulla mattis neque sed metus rutrum sit amet pharetra justo scelerisque. Nullam a euismod mi. Curabitur facilisis ligula eu arcu hendrerit non adipiscing orci aliquam. Nunc condimentum condimentum erat, eu eleifend neque tristique quis. Quisque eros sem, ultricies in fringilla tristique, mollis a enim? Sed vitae sapien urna. Cras ipsum sem, accumsan quis hendrerit eget, aliquet at sem? cras amet.\r\n', '', 'filtered_html'),
('rooms_unit', 'basic_suite', 0, 14, 14, 'und', 0, 'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n', '', 'filtered_html'),
('rooms_unit', 'basic_suite', 0, 15, 15, 'und', 0, 'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n', '', 'filtered_html'),
('rooms_unit', 'basic_suite', 0, 16, 16, 'und', 0, 'In massa massa, interdum vitae blandit vitae, eleifend vitae dui? Sed ullamcorper pellentesque tortor non vulputate. Ut hendrerit justo et massa varius vehicula. Aliquam auctor; magna quis condimentum dapibus, eros dolor gravida urna, eu placerat elit dolor non massa. Vestibulum dapibus, purus et laoreet molestie, ante enim blandit turpis; et malesuada diam magna vel arcu. Suspendisse scelerisque suscipit leo; nec congue tellus venenatis eget. Donec ut arcu ligula, a mollis erat. Sed congue nunc a ipsum tristique lacinia. In hac habitasse platea dictumst. Nunc sodales suscipit feugiat.\r\n\r\nQuisque neque felis, blandit in ultricies in, vulputate sit amet nisl. Proin laoreet ornare pulvinar. Pellentesque euismod lorem et mauris aliquet imperdiet. Nullam bibendum sem ac est convallis lacinia. Maecenas dolor leo, elementum vitae elementum vitae, lobortis vel lectus. Phasellus at nisi felis. Quisque sit amet ligula nec arcu sodales mollis. Suspendisse convallis imperdiet sodales. Quisque vestibulum pulvinar leo vel sagittis.\r\n\r\nDonec hendrerit posuere lectus non tincidunt. Etiam aliquet, tortor ut vestibulum bibendum, mauris ante facilisis sapien, fermentum facilisis elit dolor vitae mi? nullam.\r\n', '', 'filtered_html'),
('rooms_unit', 'deluxe_suite', 0, 17, 17, 'und', 0, 'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n', '', 'filtered_html'),
('rooms_unit', 'deluxe_suite', 0, 18, 18, 'und', 0, 'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n', '', 'filtered_html'),
('rooms_unit', 'deluxe_suite', 0, 19, 19, 'und', 0, 'Cras non risus id lectus rutrum condimentum ac in odio. Etiam at sapien vitae nisl commodo auctor at sollicitudin mi. Vivamus dolor mi, auctor eget imperdiet dignissim, aliquam vel lectus! Mauris ut nulla in dui vehicula rutrum. Fusce fermentum, elit eget luctus varius, sapien ligula elementum libero, vel auctor enim nisi commodo eros. Nulla non laoreet purus. Cras mi metus, imperdiet at placerat tincidunt, facilisis ut ante. Nam sit amet ultricies ipsum. Sed elementum dolor ac libero accumsan aliquam quis et lectus.\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In hac habitasse platea dictumst. Sed fermentum semper vehicula. Mauris egestas euismod lectus sit amet sollicitudin. Etiam facilisis nulla at velit adipiscing venenatis. Nullam pharetra ornare velit eu cursus. Morbi consequat suscipit urna, ac viverra erat malesuada et. Sed malesuada erat nec tortor luctus aliquam. Sed rutrum pulvinar iaculis. Vestibulum at metus magna? Aliquam lectus sem, ornare ut laoreet ac, semper at nulla. Mauris condimentum viverra porta. Quisque lacinia posuere turpis sed dignissim! Nullam mauris dui, venenatis ut sollicitudin ut, lobortis non odio metus.\r\n', '', 'filtered_html'),
('rooms_unit', 'luxury_suite', 0, 20, 20, 'und', 0, 'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n', '', 'filtered_html'),
('rooms_unit', 'luxury_suite', 0, 21, 21, 'und', 0, 'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n', '', 'filtered_html'),
('rooms_unit', 'luxury_suite', 0, 22, 22, 'und', 0, 'Nulla at leo elit, at gravida orci. Nam accumsan molestie ligula, eget semper felis aliquam vel. Phasellus aliquam dictum nisl ac ullamcorper. Mauris vitae eros metus. Fusce ut aliquam sapien. Quisque adipiscing gravida lectus sit amet tincidunt. Vivamus pretium; mi eget ornare luctus, mauris velit malesuada ligula, non tempor risus arcu at tellus. Maecenas molestie velit a sapien convallis sollicitudin quis eleifend urna. Ut vel felis et lacus volutpat tristique.\r\n\r\nIn elit sem, molestie non vestibulum in, tristique ac enim. Proin id quam sem, vitae lacinia elit. Proin eget sem felis. Etiam dui tellus, porttitor eget consectetur eget, aliquet condimentum turpis. Nam eu orci non diam vehicula rutrum. Nunc erat ante, bibendum pretium molestie luctus, commodo eget ipsum. Integer sodales ipsum ac ipsum luctus et commodo risus tincidunt. Nullam faucibus varius ligula, et rutrum elit ornare in. Sed pulvinar, lacus vel viverra tristique, libero orci tempus odio, nec ornare ante nisl non orci. Vestibulum sagittis lorem in sem imperdiet et fringilla tellus malesuada. Phasellus fringilla urna in dui tristique congue. Aliquam erat volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing sed.\r\n', '', 'filtered_html'),
('rooms_unit', 'royal_suite', 0, 23, 23, 'und', 0, 'Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n', '', 'filtered_html'),
('rooms_unit', 'royal_suite', 0, 24, 24, 'und', 0, 'Duis ultricies vulputate metus, eu viverra ipsum malesuada in. Proin commodo enim lorem; a sollicitudin turpis. Nulla facilisi. Donec quis lectus magna, pulvinar venenatis mi. Etiam pellentesque ultrices libero ac rhoncus. Nunc et tellus augue. Nunc interdum arcu id ante rhoncus pulvinar. Praesent non ipsum nec augue tempus cursus a a massa.\r\n\r\nMauris scelerisque leo vitae magna lacinia iaculis. Sed tempus rhoncus sapien, consequat euismod lorem dictum non. Ut ipsum augue, iaculis quis eleifend et, auctor sit amet felis. Cras erat ipsum, accumsan vitae luctus nec, suscipit egestas sem? Nunc turpis turpis, tincidunt sed fermentum at, mollis id turpis. Sed commodo porta enim eu tristique? Integer a odio id quam sollicitudin fringilla! Donec convallis scelerisque enim, non sodales leo tempus id. Ut erat leo, congue sit amet venenatis vitae, ornare sed magna. Nam euismod sagittis ante a blandit. Vivamus non diam in sapien pretium fringilla. Nam varius lobortis porttitor?\r\n\r\nCurabitur porta neque turpis. Mauris tempor massa vel neque hendrerit nec eleifend diam gravida. Sed interdum porttitor lectus nec ultrices. Donec velit dui, vehicula ac commodo nec, faucibus quis dolor. Donec nisi posuere.\r\n', '', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_image`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 4 (field_image)';

--
-- Dumping data for table `field_revision_field_image`
--

INSERT INTO `field_revision_field_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_image_fid`, `field_image_alt`, `field_image_title`, `field_image_width`, `field_image_height`) VALUES
('node', 'article', 0, 21, 21, 'und', 0, 114, '', '', 676, 396),
('node', 'article', 0, 22, 22, 'und', 0, 112, '', '', 676, 396),
('rooms_unit', 'basic_suite', 0, 14, 14, 'und', 0, 2, '', '', 200, 165),
('rooms_unit', 'basic_suite', 0, 15, 15, 'und', 0, 2, '', '', 200, 165),
('rooms_unit', 'basic_suite', 0, 16, 16, 'und', 0, 2, '', '', 200, 165),
('rooms_unit', 'deluxe_suite', 0, 17, 17, 'und', 0, 3, '', '', 200, 165),
('rooms_unit', 'deluxe_suite', 0, 18, 18, 'und', 0, 3, '', '', 200, 165),
('rooms_unit', 'deluxe_suite', 0, 19, 19, 'und', 0, 3, '', '', 200, 165),
('rooms_unit', 'luxury_suite', 0, 20, 20, 'und', 0, 4, '', '', 200, 165),
('rooms_unit', 'luxury_suite', 0, 21, 21, 'und', 0, 4, '', '', 200, 165),
('rooms_unit', 'luxury_suite', 0, 22, 22, 'und', 0, 4, '', '', 200, 165),
('rooms_unit', 'royal_suite', 0, 23, 23, 'und', 0, 5, '', '', 2400, 1895),
('rooms_unit', 'royal_suite', 0, 24, 24, 'und', 0, 5, '', '', 2400, 1895);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_images`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_images` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_images_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_images_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_images_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_images_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_images_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_images_fid` (`field_images_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 23 (field_images)';

--
-- Dumping data for table `field_revision_field_images`
--

INSERT INTO `field_revision_field_images` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_images_fid`, `field_images_alt`, `field_images_title`, `field_images_width`, `field_images_height`) VALUES
('node', 'promotions', 0, 2, 2, 'und', 0, 1, '', '', 260, 286),
('node', 'unit_description', 0, 3, 3, 'und', 0, 117, '', '', 220, 150),
('node', 'unit_description', 0, 3, 3, 'und', 1, 118, '', '', 220, 150),
('node', 'unit_description', 0, 3, 3, 'und', 2, 119, '', '', 220, 150),
('node', 'unit_description', 0, 3, 3, 'und', 3, 120, '', '', 676, 396),
('node', 'unit_description', 0, 4, 4, 'und', 0, 121, '', '', 220, 150),
('node', 'unit_description', 0, 4, 4, 'und', 1, 122, '', '', 220, 150),
('node', 'unit_description', 0, 4, 4, 'und', 2, 123, '', '', 220, 150),
('node', 'unit_description', 0, 4, 4, 'und', 3, 124, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 0, 125, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 1, 126, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 2, 127, '', '', 220, 150),
('node', 'unit_description', 0, 5, 5, 'und', 3, 128, '', '', 220, 150),
('node', 'services_facilities', 0, 6, 6, 'und', 0, 91, '', '', 676, 396),
('node', 'services_facilities', 0, 7, 7, 'und', 0, 92, '', '', 676, 396),
('node', 'services_facilities', 0, 8, 8, 'und', 0, 93, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 0, 45, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 1, 46, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 2, 47, '', '', 676, 396),
('node', 'photo_galleries', 0, 9, 9, 'und', 3, 48, '', '', 676, 396),
('node', 'photo_galleries', 0, 10, 10, 'und', 0, 49, '', '', 676, 396),
('node', 'photo_galleries', 0, 10, 10, 'und', 1, 50, '', '', 676, 396),
('node', 'photo_galleries', 0, 10, 10, 'und', 2, 72, '', '', 676, 396),
('node', 'news_events', 0, 11, 11, 'und', 0, 103, '', '', 676, 396),
('node', 'news_events', 0, 12, 12, 'und', 0, 104, '', '', 676, 396),
('node', 'news_events', 0, 13, 13, 'und', 0, 105, '', '', 676, 396),
('node', 'promotions', 0, 14, 14, 'und', 0, 41, '', '', 260, 286),
('node', 'services_facilities', 0, 16, 16, 'und', 0, 94, '', '', 676, 396),
('node', 'services_facilities', 0, 17, 17, 'und', 0, 95, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 0, 68, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 1, 69, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 2, 70, '', '', 676, 396),
('node', 'photo_galleries', 0, 18, 18, 'und', 3, 71, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 0, 75, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 1, 76, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 2, 77, '', '', 676, 396),
('node', 'photo_galleries', 0, 19, 19, 'und', 3, 78, '', '', 676, 396),
('node', 'news_events', 0, 23, 23, 'und', 0, 102, '', '', 676, 396),
('node', 'news_events', 0, 24, 24, 'und', 0, 101, '', '', 676, 396);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_slideshow_image`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_slideshow_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_slideshow_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_slideshow_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_slideshow_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_slideshow_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_slideshow_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_slideshow_image_fid` (`field_slideshow_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 25 (field_slideshow...';

--
-- Dumping data for table `field_revision_field_slideshow_image`
--

INSERT INTO `field_revision_field_slideshow_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_slideshow_image_fid`, `field_slideshow_image_alt`, `field_slideshow_image_title`, `field_slideshow_image_width`, `field_slideshow_image_height`) VALUES
('node', 'article', 0, 20, 20, 'und', 0, 116, '', '', 980, 300),
('node', 'article', 0, 21, 21, 'und', 0, 115, '', '', 980, 300),
('node', 'article', 0, 22, 22, 'und', 0, 113, '', '', 980, 300);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_tags`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 3 (field_tags)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booked_bookingprice`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booked_bookingprice` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_bookingprice_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 19 (rooms_booked...';

--
-- Dumping data for table `field_revision_rooms_booked_bookingprice`
--

INSERT INTO `field_revision_rooms_booked_bookingprice` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_bookingprice_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 350),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 22000),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 550),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 22000),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 2000),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 2000),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 84000),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 400),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 1400),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 56000),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 250);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booked_price`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booked_price` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_price_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 18 (rooms_booked_price)';

--
-- Dumping data for table `field_revision_rooms_booked_price`
--

INSERT INTO `field_revision_rooms_booked_price` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_price_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 35000),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 2200000),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 55000),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 2200000),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 200000),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 200000),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 8400000),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 40000),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 140000),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 5600000),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 25000);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booked_status`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booked_status` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_status_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 17 (rooms_booked_status)';

--
-- Dumping data for table `field_revision_rooms_booked_status`
--

INSERT INTO `field_revision_rooms_booked_status` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_status_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 1),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booked_unit_id`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booked_unit_id` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booked_unit_id_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 16 (rooms_booked_unit_id)';

--
-- Dumping data for table `field_revision_rooms_booked_unit_id`
--

INSERT INTO `field_revision_rooms_booked_unit_id` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booked_unit_id_value`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, 14),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, 24),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, 15),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, 24),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, 22),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, 21),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, 23),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, 16),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, 20),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, 24),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, 14);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booking_children_ages`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booking_children_ages` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_children_ages_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 33 (rooms_booking...';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booking_dates`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booking_dates` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_dates_value` varchar(20) DEFAULT NULL,
  `rooms_booking_dates_value2` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 15 (rooms_booking_dates)';

--
-- Dumping data for table `field_revision_rooms_booking_dates`
--

INSERT INTO `field_revision_rooms_booking_dates` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `rooms_booking_dates_value`, `rooms_booking_dates_value2`) VALUES
('commerce_line_item', 'rooms_booking', 0, 4, 4, 'und', 0, '2012-06-21', '2012-06-27'),
('commerce_line_item', 'rooms_booking', 0, 5, 5, 'und', 0, '2012-06-18', '2012-06-28'),
('commerce_line_item', 'rooms_booking', 0, 6, 6, 'und', 0, '2012-06-18', '2012-06-28'),
('commerce_line_item', 'rooms_booking', 0, 7, 7, 'und', 0, '2012-06-19', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 8, 8, 'und', 0, '2012-06-19', '2012-06-28'),
('commerce_line_item', 'rooms_booking', 0, 9, 9, 'und', 0, '2012-06-20', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 11, 11, 'und', 0, '2012-06-19', '2012-07-30'),
('commerce_line_item', 'rooms_booking', 0, 12, 12, 'und', 0, '2012-06-22', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 13, 13, 'und', 0, '2012-06-23', '2012-06-29'),
('commerce_line_item', 'rooms_booking', 0, 14, 14, 'und', 0, '2012-07-03', '2012-07-30'),
('commerce_line_item', 'rooms_booking', 0, 15, 15, 'und', 0, '2012-08-25', '2012-08-29');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booking_number_people`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booking_number_people` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_number_people_value` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 29 (rooms_booking...';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booking_options`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booking_options` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_options_name` varchar(255) NOT NULL,
  `rooms_booking_options_quantity` int(11) DEFAULT NULL,
  `rooms_booking_options_operation` varchar(255) DEFAULT NULL,
  `rooms_booking_options_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 30 (rooms_booking...';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booking_reference`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booking_reference` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_reference_target_id` int(10) unsigned NOT NULL COMMENT 'The id of the target entity.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `rooms_booking_reference_target_id` (`rooms_booking_reference_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 31 (rooms_booking...';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_rooms_booking_unit_options`
--

CREATE TABLE IF NOT EXISTS `field_revision_rooms_booking_unit_options` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `rooms_booking_unit_options_name` varchar(255) NOT NULL,
  `rooms_booking_unit_options_quantity` int(11) DEFAULT NULL,
  `rooms_booking_unit_options_operation` varchar(255) DEFAULT NULL,
  `rooms_booking_unit_options_value` float DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 32 (rooms_booking_unit...';

-- --------------------------------------------------------

--
-- Table structure for table `file_managed`
--

CREATE TABLE IF NOT EXISTS `file_managed` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The users.uid of the user who is associated with the file.',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the file with no path components. This may differ from the basename of the URI if the file is renamed to avoid overwriting an existing file.',
  `uri` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'The URI to access the file (either local or remote).',
  `filemime` varchar(255) NOT NULL DEFAULT '' COMMENT 'The file’s MIME type.',
  `filesize` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'The size of the file in bytes.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A field indicating the status of the file. Two status are defined in core: temporary (0) and permanent (1). Temporary files older than DRUPAL_MAXIMUM_TEMP_FILE_AGE will be removed during a cron run.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UNIX timestamp for when the file was added.',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `uri` (`uri`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores information for uploaded files.' AUTO_INCREMENT=129 ;

--
-- Dumping data for table `file_managed`
--

INSERT INTO `file_managed` (`fid`, `uid`, `filename`, `uri`, `filemime`, `filesize`, `status`, `timestamp`) VALUES
(1, 1, 'banner.jpg', 'public://field/images/banner.jpg', 'image/jpeg', 48716, 1, 1339858675),
(2, 1, 'demo-1.jpg', 'public://image/rooms/demo-1.jpg', 'image/jpeg', 10673, 1, 1339860324),
(3, 1, 'demo-2.jpg', 'public://image/rooms/demo-2.jpg', 'image/jpeg', 10886, 1, 1339860342),
(4, 1, 'demo-4.jpg', 'public://image/rooms/demo-4.jpg', 'image/jpeg', 10909, 1, 1339860364),
(5, 1, 'superior room.JPG', 'public://image/rooms/superior room.JPG', 'image/jpeg', 774810, 1, 1339860445),
(41, 1, 'banner-2.jpg', 'public://field/images/banner-2.jpg', 'image/jpeg', 64829, 1, 1339890901),
(45, 1, 'demo-17.jpg', 'public://field/images/demo-17.jpg', 'image/jpeg', 55867, 1, 1339911811),
(46, 1, 'demo-18.jpg', 'public://field/images/demo-18.jpg', 'image/jpeg', 69042, 1, 1339911811),
(47, 1, 'demo-19.jpg', 'public://field/images/demo-19.jpg', 'image/jpeg', 59587, 1, 1339911811),
(48, 1, 'demo-20.jpg', 'public://field/images/demo-20_0.jpg', 'image/jpeg', 71690, 1, 1339911811),
(49, 1, 'demo-21.jpg', 'public://field/images/demo-21.jpg', 'image/jpeg', 70500, 1, 1339911933),
(50, 1, 'demo-22.jpg', 'public://field/images/demo-22.jpg', 'image/jpeg', 74735, 1, 1339911933),
(68, 1, 'demo-22.jpg', 'public://field/images/demo-22_0.jpg', 'image/jpeg', 99608, 1, 1356185175),
(69, 1, 'demo-19.jpg', 'public://field/images/demo-19_0.jpg', 'image/jpeg', 101653, 1, 1356185175),
(70, 1, 'demo-17.jpg', 'public://field/images/demo-17_0.jpg', 'image/jpeg', 106449, 1, 1356185175),
(71, 1, 'demo-23.jpg', 'public://field/images/demo-23_0.jpg', 'image/jpeg', 100103, 1, 1356185175),
(72, 1, 'demo-18.jpg', 'public://field/images/demo-18_0.jpg', 'image/jpeg', 92776, 1, 1356185284),
(75, 1, 'demo-1.jpg', 'public://field/images/demo-1.jpg', 'image/jpeg', 49856, 1, 1356185370),
(76, 1, 'demo-2.jpg', 'public://field/images/demo-2.jpg', 'image/jpeg', 41546, 1, 1356185370),
(77, 1, 'demo-3.jpg', 'public://field/images/demo-3.jpg', 'image/jpeg', 63036, 1, 1356185370),
(78, 1, 'demo-4.jpg', 'public://field/images/demo-4.jpg', 'image/jpeg', 69395, 1, 1356185370),
(91, 1, 'demo-12.jpg', 'public://field/images/demo-12.jpg', 'image/jpeg', 43750, 1, 1356185586),
(92, 1, 'demo-21.jpg', 'public://field/images/demo-21_0.jpg', 'image/jpeg', 93266, 1, 1356185612),
(93, 1, 'demo-20.jpg', 'public://field/images/demo-20.jpg', 'image/jpeg', 123502, 1, 1356185640),
(94, 1, 'demo-23.jpg', 'public://field/images/demo-23.jpg', 'image/jpeg', 100103, 1, 1356185681),
(95, 1, 'demo-24.jpg', 'public://field/images/demo-24.jpg', 'image/jpeg', 85699, 1, 1356185772),
(101, 1, 'demo-14.jpg', 'public://field/images/demo-14.jpg', 'image/jpeg', 76563, 1, 1356186091),
(102, 1, 'demo-19.jpg', 'public://field/images/demo-19_1.jpg', 'image/jpeg', 101653, 1, 1356186117),
(103, 1, 'demo-16.jpg', 'public://field/images/demo-16.jpg', 'image/jpeg', 72370, 1, 1356186196),
(104, 1, 'demo-15.jpg', 'public://field/images/demo-15.jpg', 'image/jpeg', 59161, 1, 1356186224),
(105, 1, 'demo-14.jpg', 'public://field/images/demo-14_0.jpg', 'image/jpeg', 76563, 1, 1356186255),
(112, 1, 'demo-1.jpg', 'public://field/image/demo-1.jpg', 'image/jpeg', 49856, 1, 1356187587),
(113, 1, 'sl-1.jpg', 'public://field/slideshow/sl-1.jpg', 'image/jpeg', 61757, 1, 1356187587),
(114, 1, 'demo-2.jpg', 'public://field/image/demo-2.jpg', 'image/jpeg', 41546, 1, 1356187627),
(115, 1, 'sl-2.jpg', 'public://field/slideshow/sl-2.jpg', 'image/jpeg', 46406, 1, 1356187627),
(116, 1, 'sl-3.jpg', 'public://field/slideshow/sl-3.jpg', 'image/jpeg', 55620, 1, 1356187648),
(117, 1, 'demo-1.jpg', 'public://field/rooms/demo-1.jpg', 'image/jpeg', 10141, 1, 1356424112),
(118, 1, 'demo-2.jpg', 'public://field/rooms/demo-2.jpg', 'image/jpeg', 10026, 1, 1356424112),
(119, 1, 'demo-3.jpg', 'public://field/rooms/demo-3.jpg', 'image/jpeg', 13042, 1, 1356424112),
(120, 1, 'demo-4.jpg', 'public://field/rooms/demo-4.jpg', 'image/jpeg', 69395, 1, 1356424112),
(121, 1, 'demo-5.jpg', 'public://field/rooms/demo-5.jpg', 'image/jpeg', 11886, 1, 1356424299),
(122, 1, 'demo-6.jpg', 'public://field/rooms/demo-6.jpg', 'image/jpeg', 11358, 1, 1356424299),
(123, 1, 'demo-7.jpg', 'public://field/rooms/demo-7.jpg', 'image/jpeg', 13297, 1, 1356424299),
(124, 1, 'demo-8.jpg', 'public://field/rooms/demo-8.jpg', 'image/jpeg', 13837, 1, 1356424299),
(125, 1, 'demo-9.jpg', 'public://field/rooms/demo-9.jpg', 'image/jpeg', 13181, 1, 1356424357),
(126, 1, 'demo-10.jpg', 'public://field/rooms/demo-10.jpg', 'image/jpeg', 12601, 1, 1356424357),
(127, 1, 'demo-11.jpg', 'public://field/rooms/demo-11.jpg', 'image/jpeg', 12443, 1, 1356424357),
(128, 1, 'demo-12.jpg', 'public://field/rooms/demo-12.jpg', 'image/jpeg', 12977, 1, 1356424357);

-- --------------------------------------------------------

--
-- Table structure for table `file_usage`
--

CREATE TABLE IF NOT EXISTS `file_usage` (
  `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Track where a file is used.';

--
-- Dumping data for table `file_usage`
--

INSERT INTO `file_usage` (`fid`, `module`, `type`, `id`, `count`) VALUES
(1, 'file', 'node', 2, 1),
(2, 'file', 'rooms_unit', 14, 1),
(2, 'file', 'rooms_unit', 15, 1),
(2, 'file', 'rooms_unit', 16, 1),
(3, 'file', 'rooms_unit', 17, 1),
(3, 'file', 'rooms_unit', 18, 1),
(3, 'file', 'rooms_unit', 19, 1),
(4, 'file', 'rooms_unit', 20, 1),
(4, 'file', 'rooms_unit', 21, 1),
(4, 'file', 'rooms_unit', 22, 1),
(5, 'file', 'rooms_unit', 23, 1),
(5, 'file', 'rooms_unit', 24, 1),
(41, 'file', 'node', 14, 1),
(45, 'file', 'node', 9, 1),
(46, 'file', 'node', 9, 1),
(47, 'file', 'node', 9, 1),
(48, 'file', 'node', 9, 1),
(49, 'file', 'node', 10, 1),
(50, 'file', 'node', 10, 1),
(68, 'file', 'node', 18, 1),
(69, 'file', 'node', 18, 1),
(70, 'file', 'node', 18, 1),
(71, 'file', 'node', 18, 1),
(72, 'file', 'node', 10, 1),
(75, 'file', 'node', 19, 1),
(76, 'file', 'node', 19, 1),
(77, 'file', 'node', 19, 1),
(78, 'file', 'node', 19, 1),
(91, 'file', 'node', 6, 1),
(92, 'file', 'node', 7, 1),
(93, 'file', 'node', 8, 1),
(94, 'file', 'node', 16, 1),
(95, 'file', 'node', 17, 1),
(101, 'file', 'node', 24, 1),
(102, 'file', 'node', 23, 1),
(103, 'file', 'node', 11, 1),
(104, 'file', 'node', 12, 1),
(105, 'file', 'node', 13, 1),
(112, 'file', 'node', 22, 1),
(113, 'file', 'node', 22, 1),
(114, 'file', 'node', 21, 1),
(115, 'file', 'node', 21, 1),
(116, 'file', 'node', 20, 1),
(117, 'file', 'node', 3, 1),
(118, 'file', 'node', 3, 1),
(119, 'file', 'node', 3, 1),
(120, 'file', 'node', 3, 1),
(121, 'file', 'node', 4, 1),
(122, 'file', 'node', 4, 1),
(123, 'file', 'node', 4, 1),
(124, 'file', 'node', 4, 1),
(125, 'file', 'node', 5, 1),
(126, 'file', 'node', 5, 1),
(127, 'file', 'node', 5, 1),
(128, 'file', 'node', 5, 1);

-- --------------------------------------------------------

--
-- Table structure for table `filter`
--

CREATE TABLE IF NOT EXISTS `filter` (
  `format` varchar(255) NOT NULL COMMENT 'Foreign key: The filter_format.format to which this filter is assigned.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The origin module of the filter.',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Name of the filter being referenced.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of filter within format.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Filter enabled status. (1 = enabled, 0 = disabled)',
  `settings` longblob COMMENT 'A serialized array of name value pairs that store the filter settings for the specific format.',
  PRIMARY KEY (`format`,`name`),
  KEY `list` (`weight`,`module`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table that maps filters (HTML corrector) to text formats ...';

--
-- Dumping data for table `filter`
--

INSERT INTO `filter` (`format`, `module`, `name`, `weight`, `status`, `settings`) VALUES
('filtered_html', 'filter', 'filter_autop', 2, 1, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_html', 1, 1, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('filtered_html', 'filter', 'filter_htmlcorrector', 10, 1, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_html_escape', -10, 0, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_url', 0, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('full_html', 'filter', 'filter_autop', 1, 1, 0x613a303a7b7d),
('full_html', 'filter', 'filter_html', -10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('full_html', 'filter', 'filter_htmlcorrector', 10, 1, 0x613a303a7b7d),
('full_html', 'filter', 'filter_html_escape', -10, 0, 0x613a303a7b7d),
('full_html', 'filter', 'filter_url', 0, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('php_code', 'filter', 'filter_autop', 0, 0, 0x613a303a7b7d),
('php_code', 'filter', 'filter_html', -10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('php_code', 'filter', 'filter_htmlcorrector', 10, 0, 0x613a303a7b7d),
('php_code', 'filter', 'filter_html_escape', -10, 0, 0x613a303a7b7d),
('php_code', 'filter', 'filter_url', 0, 0, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('php_code', 'php', 'php_code', 0, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_autop', 2, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_html', -10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('plain_text', 'filter', 'filter_htmlcorrector', 10, 0, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_html_escape', 0, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_url', 1, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d);

-- --------------------------------------------------------

--
-- Table structure for table `filter_format`
--

CREATE TABLE IF NOT EXISTS `filter_format` (
  `format` varchar(255) NOT NULL COMMENT 'Primary Key: Unique machine name of the format.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the text format (Filtered HTML).',
  `cache` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether format is cacheable. (1 = cacheable, 0 = not cacheable)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The status of the text format. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of text format to use when listing.',
  PRIMARY KEY (`format`),
  UNIQUE KEY `name` (`name`),
  KEY `status_weight` (`status`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores text formats: custom groupings of filters, such as...';

--
-- Dumping data for table `filter_format`
--

INSERT INTO `filter_format` (`format`, `name`, `cache`, `status`, `weight`) VALUES
('filtered_html', 'Filtered HTML', 1, 1, 0),
('full_html', 'Full HTML', 1, 1, 1),
('php_code', 'PHP code', 0, 1, 11),
('plain_text', 'Plain text', 1, 1, 10);

-- --------------------------------------------------------

--
-- Table structure for table `flood`
--

CREATE TABLE IF NOT EXISTS `flood` (
  `fid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unique flood event ID.',
  `event` varchar(64) NOT NULL DEFAULT '' COMMENT 'Name of event (e.g. contact).',
  `identifier` varchar(128) NOT NULL DEFAULT '' COMMENT 'Identifier of the visitor, such as an IP address or hostname.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp of the event.',
  `expiration` int(11) NOT NULL DEFAULT '0' COMMENT 'Expiration timestamp. Expired events are purged on cron run.',
  PRIMARY KEY (`fid`),
  KEY `allow` (`event`,`identifier`,`timestamp`),
  KEY `purge` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Flood controls the threshold of events, such as the...' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `history`
--

CREATE TABLE IF NOT EXISTS `history` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that read the node nid.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid that was read.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of which users have read which nodes.';

-- --------------------------------------------------------

--
-- Table structure for table `image_effects`
--

CREATE TABLE IF NOT EXISTS `image_effects` (
  `ieid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image effect.',
  `isid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The image_styles.isid for an image style.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of the effect in the style.',
  `name` varchar(255) NOT NULL COMMENT 'The unique name of the effect to be executed.',
  `data` longblob NOT NULL COMMENT 'The configuration data for the effect.',
  PRIMARY KEY (`ieid`),
  KEY `isid` (`isid`),
  KEY `weight` (`weight`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image effects.' AUTO_INCREMENT=11 ;

--
-- Dumping data for table `image_effects`
--

INSERT INTO `image_effects` (`ieid`, `isid`, `weight`, `name`, `data`) VALUES
(1, 1, 0, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22363736223b733a363a22686569676874223b733a333a22333936223b7d),
(2, 2, 0, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313936223b733a363a22686569676874223b733a333a22313135223b7d),
(4, 3, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22323230223b733a363a22686569676874223b733a333a22313530223b7d),
(5, 4, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22393830223b733a363a22686569676874223b733a333a22333030223b7d),
(6, 5, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22323630223b733a363a22686569676874223b733a333a22333030223b7d),
(7, 6, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22323139223b733a363a22686569676874223b733a333a22313330223b7d),
(8, 7, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22363436223b733a363a22686569676874223b733a333a22323436223b7d),
(9, 8, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22333036223b733a363a22686569676874223b733a333a22323136223b7d),
(10, 9, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22393830223b733a363a22686569676874223b733a333a22333030223b7d);

-- --------------------------------------------------------

--
-- Table structure for table `image_styles`
--

CREATE TABLE IF NOT EXISTS `image_styles` (
  `isid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image style.',
  `name` varchar(255) NOT NULL COMMENT 'The style name.',
  `label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The style administrative name.',
  PRIMARY KEY (`isid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image styles.' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `image_styles`
--

INSERT INTO `image_styles` (`isid`, `name`, `label`) VALUES
(1, 'galleryformatter_slide', 'galleryformatter_slide'),
(2, 'galleryformatter_thumb', 'galleryformatter_thumb'),
(3, 'medium', 'medium'),
(4, 'img_980_300', 'img_980_300'),
(5, 'img_260_300', 'img_260_300'),
(6, 'img_219_130', 'img_219_130'),
(7, 'img_646_246', 'img_646_246'),
(8, 'img_306_216', 'img_306_216'),
(9, 'slideshow', 'slideshow');

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE IF NOT EXISTS `languages` (
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'Language code, e.g. ’de’ or ’en-US’.',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT 'Language name in English.',
  `native` varchar(64) NOT NULL DEFAULT '' COMMENT 'Native language name.',
  `direction` int(11) NOT NULL DEFAULT '0' COMMENT 'Direction of language (Left-to-Right = 0, Right-to-Left = 1).',
  `enabled` int(11) NOT NULL DEFAULT '0' COMMENT 'Enabled flag (1 = Enabled, 0 = Disabled).',
  `plurals` int(11) NOT NULL DEFAULT '0' COMMENT 'Number of plural indexes in this language.',
  `formula` varchar(255) NOT NULL DEFAULT '' COMMENT 'Plural formula in PHP code to evaluate to get plural indexes.',
  `domain` varchar(128) NOT NULL DEFAULT '' COMMENT 'Domain to use for this language.',
  `prefix` varchar(128) NOT NULL DEFAULT '' COMMENT 'Path prefix to use for this language.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight, used in lists of languages.',
  `javascript` varchar(64) NOT NULL DEFAULT '' COMMENT 'Location of JavaScript translation file.',
  PRIMARY KEY (`language`),
  KEY `list` (`weight`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='List of all available languages in the system.';

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` (`language`, `name`, `native`, `direction`, `enabled`, `plurals`, `formula`, `domain`, `prefix`, `weight`, `javascript`) VALUES
('en', 'English', 'English', 0, 1, 0, '', '', '', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `locales_source`
--

CREATE TABLE IF NOT EXISTS `locales_source` (
  `lid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unique identifier of this string.',
  `location` longtext COMMENT 'Drupal path in case of online discovered translations or file path in case of imported strings.',
  `textgroup` varchar(255) NOT NULL DEFAULT 'default' COMMENT 'A module defined group of translations, see hook_locale().',
  `source` blob NOT NULL COMMENT 'The original string in English.',
  `context` varchar(255) NOT NULL DEFAULT '' COMMENT 'The context this string applies to.',
  `version` varchar(20) NOT NULL DEFAULT 'none' COMMENT 'Version of Drupal, where the string was last used (for locales optimization).',
  PRIMARY KEY (`lid`),
  KEY `source_context` (`source`(30),`context`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='List of English source strings.' AUTO_INCREMENT=126 ;

--
-- Dumping data for table `locales_source`
--

INSERT INTO `locales_source` (`lid`, `location`, `textgroup`, `source`, `context`, `version`) VALUES
(1, 'misc/drupal.js', 'default', 0x416e20414a41582048545450206572726f72206f636375727265642e, '', 'none'),
(2, 'misc/drupal.js', 'default', 0x4854545020526573756c7420436f64653a2021737461747573, '', 'none'),
(3, 'misc/drupal.js', 'default', 0x416e20414a415820485454502072657175657374207465726d696e617465642061626e6f726d616c6c792e, '', 'none'),
(4, 'misc/drupal.js', 'default', 0x446562756767696e6720696e666f726d6174696f6e20666f6c6c6f77732e, '', 'none'),
(5, 'misc/drupal.js', 'default', 0x506174683a2021757269, '', 'none'),
(6, 'misc/drupal.js', 'default', 0x537461747573546578743a202173746174757354657874, '', 'none'),
(7, 'misc/drupal.js', 'default', 0x526573706f6e7365546578743a2021726573706f6e736554657874, '', 'none'),
(8, 'misc/drupal.js', 'default', 0x526561647953746174653a202172656164795374617465, '', 'none'),
(9, 'modules/overlay/overlay-child.js', 'default', 0x4c6f6164696e67, '', 'none'),
(10, 'modules/overlay/overlay-child.js; misc/vertical-tabs.js', 'default', 0x286163746976652074616229, '', 'none'),
(11, 'sites/all/modules/views_slideshow/js/views_slideshow.js', 'default', 0x526573756d65, '', 'none'),
(12, 'sites/all/modules/views_slideshow/js/views_slideshow.js', 'default', 0x5061757365, '', 'none'),
(13, 'sites/all/modules/views_slideshow/js/views_slideshow.js', 'default', 0x546865726520776173206e6f20616374696f6e207370656369666965642e, '', 'none'),
(14, 'sites/all/modules/views_slideshow/js/views_slideshow.js', 'default', 0x5468697320736c69646573686f7720697320666f72636564207061757365642e, '', 'none'),
(15, 'sites/all/modules/views_slideshow/js/views_slideshow.js', 'default', 0x416e20696e76616c696420696e7465676572207761732073706563696669656420666f7220736c6964654e756d2e, '', 'none'),
(16, 'sites/all/modules/views_slideshow/js/views_slideshow.js', 'default', 0x416e20696e76616c696420616374696f6e202221616374696f6e2220776173207370656369666965642e, '', 'none'),
(17, 'misc/collapse.js', 'default', 0x48696465, '', 'none'),
(18, 'misc/collapse.js', 'default', 0x53686f77, '', 'none'),
(19, 'sites/all/modules/jcarousel/js/jcarousel.js', 'default', 0x496e7465726e616c20736572766572206572726f722e20506c656173652073656520736572766572206f7220504850206c6f677320666f72206572726f7220696e666f726d6174696f6e2e, '', 'none'),
(20, 'sites/all/modules/jcarousel/js/jcarousel.js', 'default', 0x416e206572726f72206f636375727265642061742040706174682e5c6e5c6e4572726f72204465736372697074696f6e3a20406572726f72, '', 'none'),
(21, 'modules/overlay/overlay-parent.js; sites/all/modules/jquery_update/replace/misc/1.9/overlay-parent.js', 'default', 0x407469746c65206469616c6f67, '', 'none'),
(22, 'modules/contextual/contextual.js', 'default', 0x436f6e666967757265, '', 'none'),
(23, 'modules/toolbar/toolbar.js', 'default', 0x53686f772073686f727463757473, '', 'none'),
(24, 'modules/toolbar/toolbar.js', 'default', 0x486964652073686f727463757473, '', 'none'),
(25, 'misc/tableselect.js', 'default', 0x53656c65637420616c6c20726f777320696e2074686973207461626c65, '', 'none'),
(26, 'misc/tableselect.js', 'default', 0x446573656c65637420616c6c20726f777320696e2074686973207461626c65, '', 'none'),
(27, 'modules/block/block.js', 'default', 0x4e6f742072657374726963746564, '', 'none'),
(28, 'modules/block/block.js', 'default', 0x5265737472696374656420746f206365727461696e207061676573, '', 'none'),
(29, 'modules/block/block.js', 'default', 0x4e6f7420637573746f6d697a61626c65, '', 'none'),
(30, 'modules/block/block.js', 'default', 0x546865206368616e67657320746f20746865736520626c6f636b732077696c6c206e6f7420626520736176656420756e74696c20746865203c656d3e5361766520626c6f636b733c2f656d3e20627574746f6e20697320636c69636b65642e, '', 'none'),
(31, 'modules/block/block.js', 'default', 0x54686520626c6f636b2063616e6e6f7420626520706c6163656420696e207468697320726567696f6e2e, '', 'none'),
(32, 'misc/tabledrag.js', 'default', 0x52652d6f7264657220726f7773206279206e756d65726963616c2077656967687420696e7374656164206f66206472616767696e672e, '', 'none'),
(33, 'misc/tabledrag.js', 'default', 0x53686f7720726f772077656967687473, '', 'none'),
(34, 'misc/tabledrag.js', 'default', 0x4869646520726f772077656967687473, '', 'none'),
(35, 'misc/tabledrag.js', 'default', 0x4472616720746f2072652d6f72646572, '', 'none'),
(36, 'misc/tabledrag.js', 'default', 0x4368616e676573206d61646520696e2074686973207461626c652077696c6c206e6f7420626520736176656420756e74696c2074686520666f726d206973207375626d69747465642e, '', 'none'),
(37, 'misc/ajax.js', 'default', 0x506c6561736520776169742e2e2e, '', 'none'),
(38, 'misc/machine-name.js', 'default', 0x45646974, '', 'none'),
(39, 'misc/autocomplete.js', 'default', 0x4175746f636f6d706c65746520706f707570, '', 'none'),
(40, 'misc/autocomplete.js', 'default', 0x536561726368696e6720666f72206d6174636865732e2e2e, '', 'none'),
(41, 'modules/file/file.js', 'default', 0x5468652073656c65637465642066696c65202566696c656e616d652063616e6e6f742062652075706c6f616465642e204f6e6c792066696c657320776974682074686520666f6c6c6f77696e6720657874656e73696f6e732061726520616c6c6f7765643a2025657874656e73696f6e732e, '', 'none'),
(42, 'sites/all/modules/token/token.js', 'default', 0x496e73657274207468697320746f6b656e20696e746f20796f757220666f726d, '', 'none'),
(43, 'sites/all/modules/token/token.js', 'default', 0x466972737420636c69636b20612074657874206669656c6420746f20696e7365727420796f757220746f6b656e7320696e746f2e, '', 'none'),
(44, 'modules/field/modules/text/text.js', 'default', 0x486964652073756d6d617279, '', 'none'),
(45, 'modules/field/modules/text/text.js', 'default', 0x456469742073756d6d617279, '', 'none'),
(46, 'modules/comment/comment-node-form.js', 'default', 0x406e756d62657220636f6d6d656e7473207065722070616765, '', 'none'),
(47, 'modules/node/content_types.js', 'default', 0x52657175697265732061207469746c65, '', 'none'),
(48, 'modules/node/content_types.js; modules/node/node.js', 'default', 0x4e6f74207075626c6973686564, '', 'none'),
(49, 'modules/node/content_types.js', 'default', 0x446f6e277420646973706c617920706f737420696e666f726d6174696f6e, '', 'none'),
(50, 'modules/menu/menu.js', 'default', 0x4e6f7420696e206d656e75, '', 'none'),
(51, 'modules/node/node.js', 'default', 0x4e6577207265766973696f6e, '', 'none'),
(52, 'modules/node/node.js', 'default', 0x4e6f207265766973696f6e, '', 'none'),
(53, 'modules/node/node.js', 'default', 0x427920406e616d65206f6e204064617465, '', 'none'),
(54, 'modules/node/node.js', 'default', 0x427920406e616d65, '', 'none'),
(55, 'sites/all/modules/pathauto/pathauto.js', 'default', 0x4175746f6d6174696320616c696173, '', 'none'),
(56, 'sites/all/modules/pathauto/pathauto.js', 'default', 0x416c6961733a2040616c696173, '', 'none'),
(57, 'sites/all/modules/pathauto/pathauto.js', 'default', 0x4e6f20616c696173, '', 'none'),
(58, 'sites/all/themes/nucleus/nucleus/js/nucleus.js', 'default', 0x636f6c756d6e73, '', 'none'),
(59, 'sites/all/themes/nucleus/nucleus/js/nucleus.js', 'default', 0x636f6c756d6e, '', 'none'),
(60, 'sites/all/themes/nucleus/nucleus/js/nucleus.js', 'default', 0x506978656c73, '', 'none'),
(61, 'sites/all/themes/nucleus/nucleus/js/nucleus.js', 'default', 0x437573746f6d, '', 'none'),
(62, 'sites/all/themes/nucleus/nucleus/js/nucleus.js', 'default', 0x41726520796f75207375726520796f752077616e7420746f20726573657420796f7572207468656d652073657474696e677320746f2064656661756c74207468656d652073657474696e67733f, '', 'none'),
(63, 'sites/all/modules/views/js/views-admin.js', 'default', 0x52656d6f76652067726f7570, '', 'none'),
(64, 'sites/all/modules/views/js/views-admin.js', 'default', 0x4170706c792028616c6c20646973706c61797329, '', 'none'),
(65, 'sites/all/modules/views/js/views-admin.js', 'default', 0x52657665727420746f2064656661756c74, '', 'none'),
(66, 'sites/all/modules/views/js/views-admin.js', 'default', 0x4170706c7920287468697320646973706c617929, '', 'none'),
(67, 'sites/all/modules/galleryformatter/theme/infiniteCarousel.js', 'default', 0x50726576696f75732070616765, '', 'none'),
(68, 'sites/all/modules/galleryformatter/theme/infiniteCarousel.js', 'default', 0x4e6578742070616765, '', 'none'),
(69, 'sites/all/modules/galleryformatter/theme/galleryformatter.js', 'default', 0x50726576696f757320696d616765, '', 'none'),
(70, 'sites/all/modules/galleryformatter/theme/galleryformatter.js', 'default', 0x4e65787420696d616765, '', 'none'),
(71, 'sites/all/modules/views_slideshow/contrib/views_slideshow_cycle/js/formoptions.js', 'default', 0x55706461746520416476616e636564204f7074696f6e, '', 'none'),
(72, 'sites/all/modules/views_slideshow/contrib/views_slideshow_cycle/js/formoptions.js', 'default', 0x4170706c696564204f7074696f6e73, '', 'none'),
(73, 'modules/user/user.permissions.js', 'default', 0x54686973207065726d697373696f6e20697320696e686572697465642066726f6d207468652061757468656e74696361746564207573657220726f6c652e, '', 'none'),
(74, 'modules/locale/locale.datepicker.js', 'default', 0x446f6e65, '', 'none'),
(75, 'modules/locale/locale.datepicker.js', 'default', 0x50726576, '', 'none'),
(76, 'modules/locale/locale.datepicker.js', 'default', 0x4e657874, '', 'none'),
(77, 'modules/locale/locale.datepicker.js', 'default', 0x546f646179, '', 'none'),
(78, 'modules/locale/locale.datepicker.js', 'default', 0x4a616e75617279, '', 'none'),
(79, 'modules/locale/locale.datepicker.js', 'default', 0x4665627275617279, '', 'none'),
(80, 'modules/locale/locale.datepicker.js', 'default', 0x4d61726368, '', 'none'),
(81, 'modules/locale/locale.datepicker.js', 'default', 0x417072696c, '', 'none'),
(82, 'modules/locale/locale.datepicker.js', 'default', 0x4d6179, '', 'none'),
(83, 'modules/locale/locale.datepicker.js', 'default', 0x4a756e65, '', 'none'),
(84, 'modules/locale/locale.datepicker.js', 'default', 0x4a756c79, '', 'none'),
(85, 'modules/locale/locale.datepicker.js', 'default', 0x417567757374, '', 'none'),
(86, 'modules/locale/locale.datepicker.js', 'default', 0x53657074656d626572, '', 'none'),
(87, 'modules/locale/locale.datepicker.js', 'default', 0x4f63746f626572, '', 'none'),
(88, 'modules/locale/locale.datepicker.js', 'default', 0x4e6f76656d626572, '', 'none'),
(89, 'modules/locale/locale.datepicker.js', 'default', 0x446563656d626572, '', 'none'),
(90, 'modules/locale/locale.datepicker.js', 'default', 0x4a616e, '', 'none'),
(91, 'modules/locale/locale.datepicker.js', 'default', 0x466562, '', 'none'),
(92, 'modules/locale/locale.datepicker.js', 'default', 0x4d6172, '', 'none'),
(93, 'modules/locale/locale.datepicker.js', 'default', 0x417072, '', 'none'),
(94, 'modules/locale/locale.datepicker.js', 'default', 0x4a756e, '', 'none'),
(95, 'modules/locale/locale.datepicker.js', 'default', 0x4a756c, '', 'none'),
(96, 'modules/locale/locale.datepicker.js', 'default', 0x417567, '', 'none'),
(97, 'modules/locale/locale.datepicker.js', 'default', 0x536570, '', 'none'),
(98, 'modules/locale/locale.datepicker.js', 'default', 0x4f6374, '', 'none'),
(99, 'modules/locale/locale.datepicker.js', 'default', 0x4e6f76, '', 'none'),
(100, 'modules/locale/locale.datepicker.js', 'default', 0x446563, '', 'none'),
(101, 'modules/locale/locale.datepicker.js', 'default', 0x53756e646179, '', 'none'),
(102, 'modules/locale/locale.datepicker.js', 'default', 0x4d6f6e646179, '', 'none'),
(103, 'modules/locale/locale.datepicker.js', 'default', 0x54756573646179, '', 'none'),
(104, 'modules/locale/locale.datepicker.js', 'default', 0x5765646e6573646179, '', 'none'),
(105, 'modules/locale/locale.datepicker.js', 'default', 0x5468757273646179, '', 'none'),
(106, 'modules/locale/locale.datepicker.js', 'default', 0x467269646179, '', 'none'),
(107, 'modules/locale/locale.datepicker.js', 'default', 0x5361747572646179, '', 'none'),
(108, 'modules/locale/locale.datepicker.js', 'default', 0x53756e, '', 'none'),
(109, 'modules/locale/locale.datepicker.js', 'default', 0x4d6f6e, '', 'none'),
(110, 'modules/locale/locale.datepicker.js', 'default', 0x547565, '', 'none'),
(111, 'modules/locale/locale.datepicker.js', 'default', 0x576564, '', 'none'),
(112, 'modules/locale/locale.datepicker.js', 'default', 0x546875, '', 'none'),
(113, 'modules/locale/locale.datepicker.js', 'default', 0x467269, '', 'none'),
(114, 'modules/locale/locale.datepicker.js', 'default', 0x536174, '', 'none'),
(115, 'modules/locale/locale.datepicker.js', 'default', 0x5375, '', 'none'),
(116, 'modules/locale/locale.datepicker.js', 'default', 0x4d6f, '', 'none'),
(117, 'modules/locale/locale.datepicker.js', 'default', 0x5475, '', 'none'),
(118, 'modules/locale/locale.datepicker.js', 'default', 0x5765, '', 'none'),
(119, 'modules/locale/locale.datepicker.js', 'default', 0x5468, '', 'none'),
(120, 'modules/locale/locale.datepicker.js', 'default', 0x4672, '', 'none'),
(121, 'modules/locale/locale.datepicker.js', 'default', 0x5361, '', 'none'),
(122, 'modules/locale/locale.datepicker.js', 'default', 0x6d6d2f64642f7979, '', 'none'),
(123, 'sites/all/modules/token/token.js', 'default', 0x4c6f6164696e6720746f6b656e2062726f777365722e2e2e, '', 'none'),
(124, 'sites/all/modules/token/token.js', 'default', 0x417661696c61626c6520746f6b656e73, '', 'none'),
(125, 'sites/all/modules/views/js/views-admin.js', 'default', 0x416464, '', 'none');

-- --------------------------------------------------------

--
-- Table structure for table `locales_target`
--

CREATE TABLE IF NOT EXISTS `locales_target` (
  `lid` int(11) NOT NULL DEFAULT '0' COMMENT 'Source string ID. References locales_source.lid.',
  `translation` blob NOT NULL COMMENT 'Translation string value in this language.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'Language code. References languages.language.',
  `plid` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent lid (lid of the previous string in the plural chain) in case of plural strings. References locales_source.lid.',
  `plural` int(11) NOT NULL DEFAULT '0' COMMENT 'Plural index number in case of plural strings.',
  PRIMARY KEY (`language`,`lid`,`plural`),
  KEY `lid` (`lid`),
  KEY `plid` (`plid`),
  KEY `plural` (`plural`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores translated versions of strings.';

-- --------------------------------------------------------

--
-- Table structure for table `menu_custom`
--

CREATE TABLE IF NOT EXISTS `menu_custom` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique key for menu. This is used as a block delta so length is 32.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Menu title; displayed at top of block.',
  `description` text COMMENT 'Menu description.',
  PRIMARY KEY (`menu_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds definitions for top-level custom menus (for example...';

--
-- Dumping data for table `menu_custom`
--

INSERT INTO `menu_custom` (`menu_name`, `title`, `description`) VALUES
('main-menu', 'Main menu', 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.'),
('management', 'Management', 'The <em>Management</em> menu contains links for administrative tasks.'),
('menu-top-menu', 'Top Menu', 'Donec dignissim tincidunt tellus, eu laoreet enim tincidunt in. Sed eget augue id arcu malesuada volutpat sit amet at tortor. Cras ac gravida leo? Donec quis dolor diam, quis tempus purus. Ut eu adipiscing nulla. Cras euismod, urna vel convallis commodo, augue enim eleifend augue, nec lobortis amet.\r\n'),
('navigation', 'Navigation', 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.'),
('user-menu', 'User menu', 'The <em>User</em> menu contains links related to the user''s account, as well as the ''Log out'' link.');

-- --------------------------------------------------------

--
-- Table structure for table `menu_links`
--

CREATE TABLE IF NOT EXISTS `menu_links` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ’navigation’) are part of the same menu.',
  `mlid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',
  `plid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The parent link ID (plid) is the mlid of the link above in the hierarchy, or zero if the link is at the top level in its menu.',
  `link_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The Drupal path or external path this link points to.',
  `router_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'For links corresponding to a Drupal path (external = 0), this connects the link to a menu_router.path for joins.',
  `link_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The text displayed for the link, which may be modified by a title callback stored in menu_router.',
  `options` blob COMMENT 'A serialized array of options to be passed to the url() or l() function, such as a query string or HTML attributes.',
  `module` varchar(255) NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',
  `hidden` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link should be rendered in menus. (1 = a disabled menu item that may be shown on admin screens, -1 = a menu callback, 0 = a normal, visible link)',
  `external` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).',
  `has_children` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any links have this link as a parent (1 = children exist, 0 = no children).',
  `expanded` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',
  `depth` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with plid == 0 will have depth == 1.',
  `customized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate that the user has manually created or edited the link (1 = customized, 0 = not customized).',
  `p1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the plid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',
  `p2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',
  `p3` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',
  `p4` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',
  `p5` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',
  `p6` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',
  `p7` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',
  `p8` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',
  `p9` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',
  `updated` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag that indicates that this link was generated during the update from Drupal 5.',
  PRIMARY KEY (`mlid`),
  KEY `path_menu` (`link_path`(128),`menu_name`),
  KEY `menu_plid_expand_child` (`menu_name`,`plid`,`expanded`,`has_children`),
  KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),
  KEY `router_path` (`router_path`(128))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the individual links within a menu.' AUTO_INCREMENT=1528 ;

--
-- Dumping data for table `menu_links`
--

INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 1, 0, 'admin', 'admin', 'Administration', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 9, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 2, 0, 'user', 'user', 'User account', 0x613a313a7b733a353a22616c746572223b623a313b7d, 'system', 0, 0, 0, 0, -10, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 3, 0, 'comment/%', 'comment/%', 'Comment permalink', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 4, 0, 'filter/tips', 'filter/tips', 'Compose tips', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 5, 0, 'node/%', 'node/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 6, 0, 'node/add', 'node/add', 'Add content', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 7, 1, 'admin/appearance', 'admin/appearance', 'Appearance', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a2253656c65637420616e6420636f6e66696775726520796f7572207468656d65732e223b7d7d, 'system', 0, 0, 0, 0, -6, 2, 0, 1, 7, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 8, 1, 'admin/config', 'admin/config', 'Configuration', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32303a2241646d696e69737465722073657474696e67732e223b7d7d, 'system', 0, 0, 1, 0, 0, 2, 0, 1, 8, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 9, 1, 'admin/content', 'admin/content', 'Content', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33323a2241646d696e697374657220636f6e74656e7420616e6420636f6d6d656e74732e223b7d7d, 'system', 0, 0, 1, 0, -10, 2, 0, 1, 9, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 10, 2, 'user/register', 'user/register', 'Create new account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 10, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 11, 1, 'admin/dashboard', 'admin/dashboard', 'Dashboard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a225669657720616e6420637573746f6d697a6520796f75722064617368626f6172642e223b7d7d, 'system', 0, 0, 0, 0, -15, 2, 0, 1, 11, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 12, 1, 'admin/index', 'admin/index', 'Index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -18, 2, 0, 1, 12, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 13, 2, 'user/login', 'user/login', 'Log in', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 13, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 14, 0, 'user/logout', 'user/logout', 'Log out', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 10, 1, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 15, 1, 'admin/modules', 'admin/modules', 'Modules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a22457874656e6420736974652066756e6374696f6e616c6974792e223b7d7d, 'system', 0, 0, 0, 0, -2, 2, 0, 1, 15, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 16, 0, 'user/%', 'user/%', 'My account', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 17, 1, 'admin/people', 'admin/people', 'People', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a224d616e6167652075736572206163636f756e74732c20726f6c65732c20616e64207065726d697373696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -4, 2, 0, 1, 17, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 18, 1, 'admin/reports', 'admin/reports', 'Reports', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a2256696577207265706f7274732c20757064617465732c20616e64206572726f72732e223b7d7d, 'system', 0, 0, 1, 0, 5, 2, 0, 1, 18, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 19, 2, 'user/password', 'user/password', 'Request new password', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 19, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 20, 1, 'admin/structure', 'admin/structure', 'Structure', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a2241646d696e697374657220626c6f636b732c20636f6e74656e742074797065732c206d656e75732c206574632e223b7d7d, 'system', 0, 0, 1, 0, -8, 2, 0, 1, 20, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 21, 1, 'admin/tasks', 'admin/tasks', 'Tasks', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -20, 2, 0, 1, 21, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 22, 0, 'comment/reply/%', 'comment/reply/%', 'Add new comment', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 23, 3, 'comment/%/approve', 'comment/%/approve', 'Approve', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 1, 2, 0, 3, 23, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 24, 3, 'comment/%/delete', 'comment/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 3, 24, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 25, 3, 'comment/%/edit', 'comment/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 3, 25, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 26, 3, 'comment/%/view', 'comment/%/view', 'View comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 3, 26, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 27, 17, 'admin/people/create', 'admin/people/create', 'Add user', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 17, 27, 0, 0, 0, 0, 0, 0, 0),
('management', 28, 20, 'admin/structure/block', 'admin/structure/block', 'Blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37393a22436f6e666967757265207768617420626c6f636b20636f6e74656e74206170706561727320696e20796f75722073697465277320736964656261727320616e64206f7468657220726567696f6e732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 20, 28, 0, 0, 0, 0, 0, 0, 0),
('navigation', 29, 16, 'user/%/cancel', 'user/%/cancel', 'Cancel account', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 2, 0, 16, 29, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 30, 9, 'admin/content/comment', 'admin/content/comment', 'Comments', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35393a224c69737420616e642065646974207369746520636f6d6d656e747320616e642074686520636f6d6d656e7420617070726f76616c2071756575652e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 9, 30, 0, 0, 0, 0, 0, 0, 0),
('management', 31, 11, 'admin/dashboard/configure', 'admin/dashboard/configure', 'Configure available dashboard blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a22436f6e66696775726520776869636820626c6f636b732063616e2062652073686f776e206f6e207468652064617368626f6172642e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 11, 31, 0, 0, 0, 0, 0, 0, 0),
('management', 32, 9, 'admin/content/node', 'admin/content/node', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 9, 32, 0, 0, 0, 0, 0, 0, 0),
('management', 33, 8, 'admin/config/content', 'admin/config/content', 'Content authoring', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a2253657474696e67732072656c6174656420746f20666f726d617474696e6720616e6420617574686f72696e6720636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, -15, 3, 0, 1, 8, 33, 0, 0, 0, 0, 0, 0, 0),
('management', 34, 20, 'admin/structure/types', 'admin/structure/types', 'Content types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a39323a224d616e61676520636f6e74656e742074797065732c20696e636c7564696e672064656661756c74207374617475732c2066726f6e7420706167652070726f6d6f74696f6e2c20636f6d6d656e742073657474696e67732c206574632e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 20, 34, 0, 0, 0, 0, 0, 0, 0),
('management', 35, 11, 'admin/dashboard/customize', 'admin/dashboard/customize', 'Customize dashboard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22437573746f6d697a6520796f75722064617368626f6172642e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 11, 35, 0, 0, 0, 0, 0, 0, 0),
('navigation', 36, 5, 'node/%/delete', 'node/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 2, 0, 5, 36, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 37, 8, 'admin/config/development', 'admin/config/development', 'Development', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31383a22446576656c6f706d656e7420746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 37, 0, 0, 0, 0, 0, 0, 0),
('navigation', 38, 16, 'user/%/edit', 'user/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 16, 38, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 39, 5, 'node/%/edit', 'node/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 5, 39, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 40, 18, 'admin/reports/fields', 'admin/reports/fields', 'Field list', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a224f76657276696577206f66206669656c6473206f6e20616c6c20656e746974792074797065732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 40, 0, 0, 0, 0, 0, 0, 0),
('management', 41, 17, 'admin/people/people', 'admin/people/people', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35303a2246696e6420616e64206d616e6167652070656f706c6520696e746572616374696e67207769746820796f757220736974652e223b7d7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 17, 41, 0, 0, 0, 0, 0, 0, 0),
('management', 42, 7, 'admin/appearance/list', 'admin/appearance/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a2253656c65637420616e6420636f6e66696775726520796f7572207468656d65223b7d7d, 'system', -1, 0, 0, 0, -1, 3, 0, 1, 7, 42, 0, 0, 0, 0, 0, 0, 0),
('management', 43, 15, 'admin/modules/list', 'admin/modules/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 15, 43, 0, 0, 0, 0, 0, 0, 0),
('management', 44, 8, 'admin/config/media', 'admin/config/media', 'Media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31323a224d6564696120746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 44, 0, 0, 0, 0, 0, 0, 0),
('management', 45, 20, 'admin/structure/menu', 'admin/structure/menu', 'Menus', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38363a22416464206e6577206d656e757320746f20796f757220736974652c2065646974206578697374696e67206d656e75732c20616e642072656e616d6520616e642072656f7267616e697a65206d656e75206c696e6b732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 20, 45, 0, 0, 0, 0, 0, 0, 0),
('management', 46, 8, 'admin/config/people', 'admin/config/people', 'People', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a22436f6e6669677572652075736572206163636f756e74732e223b7d7d, 'system', 0, 0, 1, 0, -20, 3, 0, 1, 8, 46, 0, 0, 0, 0, 0, 0, 0),
('management', 47, 17, 'admin/people/permissions', 'admin/people/permissions', 'Permissions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36343a2244657465726d696e652061636365737320746f2066656174757265732062792073656c656374696e67207065726d697373696f6e7320666f7220726f6c65732e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 17, 47, 0, 0, 0, 0, 0, 0, 0),
('management', 48, 18, 'admin/reports/dblog', 'admin/reports/dblog', 'Recent log messages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a2256696577206576656e74732074686174206861766520726563656e746c79206265656e206c6f676765642e223b7d7d, 'system', 0, 0, 0, 0, -1, 3, 0, 1, 18, 48, 0, 0, 0, 0, 0, 0, 0),
('management', 49, 8, 'admin/config/regional', 'admin/config/regional', 'Regional and language', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34383a22526567696f6e616c2073657474696e67732c206c6f63616c697a6174696f6e20616e64207472616e736c6174696f6e2e223b7d7d, 'system', 0, 0, 1, 0, -5, 3, 0, 1, 8, 49, 0, 0, 0, 0, 0, 0, 0),
('navigation', 50, 5, 'node/%/revisions', 'node/%/revisions', 'Revisions', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 2, 2, 0, 5, 50, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 51, 8, 'admin/config/search', 'admin/config/search', 'Search and metadata', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a224c6f63616c2073697465207365617263682c206d6574616461746120616e642053454f2e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 51, 0, 0, 0, 0, 0, 0, 0),
('management', 52, 7, 'admin/appearance/settings', 'admin/appearance/settings', 'Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a22436f6e6669677572652064656661756c7420616e64207468656d652073706563696669632073657474696e67732e223b7d7d, 'system', -1, 0, 0, 0, 20, 3, 0, 1, 7, 52, 0, 0, 0, 0, 0, 0, 0),
('management', 53, 18, 'admin/reports/status', 'admin/reports/status', 'Status report', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37343a22476574206120737461747573207265706f72742061626f757420796f757220736974652773206f7065726174696f6e20616e6420616e792064657465637465642070726f626c656d732e223b7d7d, 'system', 0, 0, 0, 0, -60, 3, 0, 1, 18, 53, 0, 0, 0, 0, 0, 0, 0),
('management', 54, 8, 'admin/config/system', 'admin/config/system', 'System', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2247656e6572616c2073797374656d2072656c6174656420636f6e66696775726174696f6e2e223b7d7d, 'system', 0, 0, 1, 0, -20, 3, 0, 1, 8, 54, 0, 0, 0, 0, 0, 0, 0),
('management', 55, 18, 'admin/reports/access-denied', 'admin/reports/access-denied', 'Top ''access denied'' errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33353a225669657720276163636573732064656e69656427206572726f7273202834303373292e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 55, 0, 0, 0, 0, 0, 0, 0),
('management', 56, 18, 'admin/reports/page-not-found', 'admin/reports/page-not-found', 'Top ''page not found'' errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a2256696577202770616765206e6f7420666f756e6427206572726f7273202834303473292e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 56, 0, 0, 0, 0, 0, 0, 0),
('management', 57, 15, 'admin/modules/uninstall', 'admin/modules/uninstall', 'Uninstall', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 3, 0, 1, 15, 57, 0, 0, 0, 0, 0, 0, 0),
('management', 58, 8, 'admin/config/user-interface', 'admin/config/user-interface', 'User interface', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a22546f6f6c73207468617420656e68616e636520746865207573657220696e746572666163652e223b7d7d, 'system', 0, 0, 1, 0, -15, 3, 0, 1, 8, 58, 0, 0, 0, 0, 0, 0, 0),
('navigation', 59, 5, 'node/%/view', 'node/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 5, 59, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 60, 16, 'user/%/view', 'user/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 16, 60, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 61, 8, 'admin/config/services', 'admin/config/services', 'Web services', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a22546f6f6c732072656c6174656420746f207765622073657276696365732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 8, 61, 0, 0, 0, 0, 0, 0, 0),
('management', 62, 8, 'admin/config/workflow', 'admin/config/workflow', 'Workflow', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22436f6e74656e7420776f726b666c6f772c20656469746f7269616c20776f726b666c6f7720746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, 5, 3, 0, 1, 8, 62, 0, 0, 0, 0, 0, 0, 0),
('management', 63, 46, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Account settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130393a22436f6e6669677572652064656661756c74206265686176696f72206f662075736572732c20696e636c7564696e6720726567697374726174696f6e20726571756972656d656e74732c20652d6d61696c732c206669656c64732c20616e6420757365722070696374757265732e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 46, 63, 0, 0, 0, 0, 0, 0),
('management', 64, 54, 'admin/config/system/actions', 'admin/config/system/actions', 'Actions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224d616e6167652074686520616374696f6e7320646566696e656420666f7220796f757220736974652e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 54, 64, 0, 0, 0, 0, 0, 0),
('management', 65, 28, 'admin/structure/block/add', 'admin/structure/block/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 65, 0, 0, 0, 0, 0, 0),
('management', 66, 34, 'admin/structure/types/add', 'admin/structure/types/add', 'Add content type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 34, 66, 0, 0, 0, 0, 0, 0),
('management', 67, 45, 'admin/structure/menu/add', 'admin/structure/menu/add', 'Add menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 45, 67, 0, 0, 0, 0, 0, 0),
('management', 68, 52, 'admin/appearance/settings/bartik', 'admin/appearance/settings/bartik', 'Bartik', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 68, 0, 0, 0, 0, 0, 0),
('management', 69, 51, 'admin/config/search/clean-urls', 'admin/config/search/clean-urls', 'Clean URLs', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22456e61626c65206f722064697361626c6520636c65616e2055524c7320666f7220796f757220736974652e223b7d7d, 'system', 0, 0, 0, 0, 5, 4, 0, 1, 8, 51, 69, 0, 0, 0, 0, 0, 0),
('management', 70, 54, 'admin/config/system/cron', 'admin/config/system/cron', 'Cron', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34303a224d616e616765206175746f6d617469632073697465206d61696e74656e616e6365207461736b732e223b7d7d, 'system', 0, 0, 0, 0, 20, 4, 0, 1, 8, 54, 70, 0, 0, 0, 0, 0, 0),
('management', 71, 49, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Date and time', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34343a22436f6e66696775726520646973706c617920666f726d61747320666f72206461746520616e642074696d652e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 49, 71, 0, 0, 0, 0, 0, 0),
('management', 72, 18, 'admin/reports/event/%', 'admin/reports/event/%', 'Details', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 72, 0, 0, 0, 0, 0, 0, 0),
('management', 73, 44, 'admin/config/media/file-system', 'admin/config/media/file-system', 'File system', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36383a2254656c6c2044727570616c20776865726520746f2073746f72652075706c6f616465642066696c657320616e6420686f772074686579206172652061636365737365642e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 44, 73, 0, 0, 0, 0, 0, 0),
('management', 74, 52, 'admin/appearance/settings/garland', 'admin/appearance/settings/garland', 'Garland', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 74, 0, 0, 0, 0, 0, 0),
('management', 75, 52, 'admin/appearance/settings/global', 'admin/appearance/settings/global', 'Global settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -1, 4, 0, 1, 7, 52, 75, 0, 0, 0, 0, 0, 0),
('management', 76, 52, 'admin/appearance/settings/hotel', 'admin/appearance/settings/hotel', 'Hotel', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 76, 0, 0, 0, 0, 0, 0),
('management', 77, 46, 'admin/config/people/ip-blocking', 'admin/config/people/ip-blocking', 'IP address blocking', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224d616e61676520626c6f636b6564204950206164647265737365732e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 8, 46, 77, 0, 0, 0, 0, 0, 0),
('management', 78, 44, 'admin/config/media/image-toolkit', 'admin/config/media/image-toolkit', 'Image toolkit', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37343a2243686f6f736520776869636820696d61676520746f6f6c6b697420746f2075736520696620796f75206861766520696e7374616c6c6564206f7074696f6e616c20746f6f6c6b6974732e223b7d7d, 'system', 0, 0, 0, 0, 20, 4, 0, 1, 8, 44, 78, 0, 0, 0, 0, 0, 0),
('management', 79, 34, 'admin/structure/types/list', 'admin/structure/types/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 20, 34, 79, 0, 0, 0, 0, 0, 0),
('management', 80, 43, 'admin/modules/list/confirm', 'admin/modules/list/confirm', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 15, 43, 80, 0, 0, 0, 0, 0, 0),
('management', 81, 45, 'admin/structure/menu/list', 'admin/structure/menu/list', 'List menus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 20, 45, 81, 0, 0, 0, 0, 0, 0),
('management', 82, 37, 'admin/config/development/logging', 'admin/config/development/logging', 'Logging and errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3135343a2253657474696e677320666f72206c6f6767696e6720616e6420616c65727473206d6f64756c65732e20566172696f7573206d6f64756c65732063616e20726f7574652044727570616c27732073797374656d206576656e747320746f20646966666572656e742064657374696e6174696f6e732c2073756368206173207379736c6f672c2064617461626173652c20656d61696c2c206574632e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 37, 82, 0, 0, 0, 0, 0, 0),
('management', 83, 37, 'admin/config/development/maintenance', 'admin/config/development/maintenance', 'Maintenance mode', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36323a2254616b65207468652073697465206f66666c696e6520666f72206d61696e74656e616e6365206f72206272696e67206974206261636b206f6e6c696e652e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 37, 83, 0, 0, 0, 0, 0, 0),
('management', 84, 37, 'admin/config/development/performance', 'admin/config/development/performance', 'Performance', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130313a22456e61626c65206f722064697361626c6520706167652063616368696e6720666f7220616e6f6e796d6f757320757365727320616e64207365742043535320616e64204a532062616e647769647468206f7074696d697a6174696f6e206f7074696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 37, 84, 0, 0, 0, 0, 0, 0),
('management', 85, 47, 'admin/people/permissions/list', 'admin/people/permissions/list', 'Permissions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36343a2244657465726d696e652061636365737320746f2066656174757265732062792073656c656374696e67207065726d697373696f6e7320666f7220726f6c65732e223b7d7d, 'system', -1, 0, 0, 0, -8, 4, 0, 1, 17, 47, 85, 0, 0, 0, 0, 0, 0),
('management', 86, 30, 'admin/content/comment/new', 'admin/content/comment/new', 'Published comments', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 9, 30, 86, 0, 0, 0, 0, 0, 0),
('management', 87, 61, 'admin/config/services/rss-publishing', 'admin/config/services/rss-publishing', 'RSS publishing', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3131343a22436f6e666967757265207468652073697465206465736372697074696f6e2c20746865206e756d626572206f66206974656d7320706572206665656420616e6420776865746865722066656564732073686f756c64206265207469746c65732f746561736572732f66756c6c2d746578742e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 61, 87, 0, 0, 0, 0, 0, 0),
('management', 88, 49, 'admin/config/regional/settings', 'admin/config/regional/settings', 'Regional settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35343a2253657474696e677320666f7220746865207369746527732064656661756c742074696d65207a6f6e6520616e6420636f756e7472792e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 49, 88, 0, 0, 0, 0, 0, 0),
('management', 89, 47, 'admin/people/permissions/roles', 'admin/people/permissions/roles', 'Roles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a224c6973742c20656469742c206f7220616464207573657220726f6c65732e223b7d7d, 'system', -1, 0, 1, 0, -5, 4, 0, 1, 17, 47, 89, 0, 0, 0, 0, 0, 0),
('management', 90, 45, 'admin/structure/menu/settings', 'admin/structure/menu/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 4, 0, 1, 20, 45, 90, 0, 0, 0, 0, 0, 0),
('management', 91, 52, 'admin/appearance/settings/seven', 'admin/appearance/settings/seven', 'Seven', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 91, 0, 0, 0, 0, 0, 0),
('management', 92, 54, 'admin/config/system/site-information', 'admin/config/system/site-information', 'Site information', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130343a224368616e67652073697465206e616d652c20652d6d61696c20616464726573732c20736c6f67616e2c2064656661756c742066726f6e7420706167652c20616e64206e756d626572206f6620706f7374732070657220706167652c206572726f722070616765732e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 54, 92, 0, 0, 0, 0, 0, 0),
('management', 93, 52, 'admin/appearance/settings/stark', 'admin/appearance/settings/stark', 'Stark', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 93, 0, 0, 0, 0, 0, 0),
('management', 94, 33, 'admin/config/content/formats', 'admin/config/content/formats', 'Text formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3132373a22436f6e66696775726520686f7720636f6e74656e7420696e7075742062792075736572732069732066696c74657265642c20696e636c7564696e6720616c6c6f7765642048544d4c20746167732e20416c736f20616c6c6f777320656e61626c696e67206f66206d6f64756c652d70726f76696465642066696c746572732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 33, 94, 0, 0, 0, 0, 0, 0),
('management', 95, 30, 'admin/content/comment/approval', 'admin/content/comment/approval', 'Unapproved comments', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 9, 30, 95, 0, 0, 0, 0, 0, 0),
('management', 96, 57, 'admin/modules/uninstall/confirm', 'admin/modules/uninstall/confirm', 'Uninstall', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 15, 57, 96, 0, 0, 0, 0, 0, 0),
('management', 97, 52, 'admin/appearance/settings/nucleus', 'admin/appearance/settings/nucleus', 'nucleus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 97, 0, 0, 0, 0, 0, 0),
('management', 98, 52, 'admin/appearance/settings/nucleus_starter', 'admin/appearance/settings/nucleus_starter', 'nucleus_starter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 52, 98, 0, 0, 0, 0, 0, 0),
('navigation', 99, 38, 'user/%/edit/account', 'user/%/edit/account', 'Account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 16, 38, 99, 0, 0, 0, 0, 0, 0, 0),
('management', 100, 94, 'admin/config/content/formats/%', 'admin/config/content/formats/%', '', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 33, 94, 100, 0, 0, 0, 0, 0),
('management', 101, 94, 'admin/config/content/formats/add', 'admin/config/content/formats/add', 'Add text format', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 33, 94, 101, 0, 0, 0, 0, 0),
('management', 102, 28, 'admin/structure/block/list/bartik', 'admin/structure/block/list/bartik', 'Bartik', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 102, 0, 0, 0, 0, 0, 0),
('management', 103, 64, 'admin/config/system/actions/configure', 'admin/config/system/actions/configure', 'Configure an advanced action', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 54, 64, 103, 0, 0, 0, 0, 0),
('management', 104, 45, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Customize menu', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 20, 45, 104, 0, 0, 0, 0, 0, 0),
('management', 105, 34, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Edit content type', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 20, 34, 105, 0, 0, 0, 0, 0, 0),
('management', 106, 71, 'admin/config/regional/date-time/formats', 'admin/config/regional/date-time/formats', 'Formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35313a22436f6e66696775726520646973706c617920666f726d617420737472696e677320666f72206461746520616e642074696d652e223b7d7d, 'system', -1, 0, 1, 0, -9, 5, 0, 1, 8, 49, 71, 106, 0, 0, 0, 0, 0),
('management', 107, 28, 'admin/structure/block/list/garland', 'admin/structure/block/list/garland', 'Garland', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 107, 0, 0, 0, 0, 0, 0),
('management', 108, 28, 'admin/structure/block/list/hotel', 'admin/structure/block/list/hotel', 'Hotel', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 20, 28, 108, 0, 0, 0, 0, 0, 0),
('management', 109, 94, 'admin/config/content/formats/list', 'admin/config/content/formats/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 33, 94, 109, 0, 0, 0, 0, 0),
('management', 110, 64, 'admin/config/system/actions/manage', 'admin/config/system/actions/manage', 'Manage actions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224d616e6167652074686520616374696f6e7320646566696e656420666f7220796f757220736974652e223b7d7d, 'system', -1, 0, 0, 0, -2, 5, 0, 1, 8, 54, 64, 110, 0, 0, 0, 0, 0),
('management', 111, 63, 'admin/config/people/accounts/settings', 'admin/config/people/accounts/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 46, 63, 111, 0, 0, 0, 0, 0),
('management', 112, 28, 'admin/structure/block/list/seven', 'admin/structure/block/list/seven', 'Seven', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 112, 0, 0, 0, 0, 0, 0),
('management', 113, 28, 'admin/structure/block/list/stark', 'admin/structure/block/list/stark', 'Stark', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 113, 0, 0, 0, 0, 0, 0),
('management', 114, 71, 'admin/config/regional/date-time/types', 'admin/config/regional/date-time/types', 'Types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34343a22436f6e66696775726520646973706c617920666f726d61747320666f72206461746520616e642074696d652e223b7d7d, 'system', -1, 0, 1, 0, -10, 5, 0, 1, 8, 49, 71, 114, 0, 0, 0, 0, 0),
('management', 115, 28, 'admin/structure/block/list/nucleus', 'admin/structure/block/list/nucleus', 'nucleus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 115, 0, 0, 0, 0, 0, 0),
('management', 116, 28, 'admin/structure/block/list/nucleus_starter', 'admin/structure/block/list/nucleus_starter', 'nucleus_starter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 28, 116, 0, 0, 0, 0, 0, 0),
('navigation', 117, 50, 'node/%/revisions/%/delete', 'node/%/revisions/%/delete', 'Delete earlier revision', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 50, 117, 0, 0, 0, 0, 0, 0, 0),
('navigation', 118, 50, 'node/%/revisions/%/revert', 'node/%/revisions/%/revert', 'Revert to earlier revision', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 50, 118, 0, 0, 0, 0, 0, 0, 0),
('navigation', 119, 50, 'node/%/revisions/%/view', 'node/%/revisions/%/view', 'Revisions', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 50, 119, 0, 0, 0, 0, 0, 0, 0),
('management', 120, 107, 'admin/structure/block/list/garland/add', 'admin/structure/block/list/garland/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 107, 120, 0, 0, 0, 0, 0),
('management', 122, 115, 'admin/structure/block/list/nucleus/add', 'admin/structure/block/list/nucleus/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 115, 122, 0, 0, 0, 0, 0),
('management', 123, 116, 'admin/structure/block/list/nucleus_starter/add', 'admin/structure/block/list/nucleus_starter/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 116, 123, 0, 0, 0, 0, 0),
('management', 124, 112, 'admin/structure/block/list/seven/add', 'admin/structure/block/list/seven/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 112, 124, 0, 0, 0, 0, 0),
('management', 125, 113, 'admin/structure/block/list/stark/add', 'admin/structure/block/list/stark/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 113, 125, 0, 0, 0, 0, 0),
('management', 126, 114, 'admin/config/regional/date-time/types/add', 'admin/config/regional/date-time/types/add', 'Add date type', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31383a22416464206e6577206461746520747970652e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 49, 71, 114, 126, 0, 0, 0, 0),
('management', 127, 106, 'admin/config/regional/date-time/formats/add', 'admin/config/regional/date-time/formats/add', 'Add format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22416c6c6f7720757365727320746f20616464206164646974696f6e616c206461746520666f726d6174732e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 49, 71, 106, 127, 0, 0, 0, 0),
('management', 128, 104, 'admin/structure/menu/manage/%/add', 'admin/structure/menu/manage/%/add', 'Add link', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 45, 104, 128, 0, 0, 0, 0, 0),
('management', 129, 28, 'admin/structure/block/manage/%/%', 'admin/structure/block/manage/%/%', 'Configure block', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 28, 129, 0, 0, 0, 0, 0, 0),
('navigation', 130, 29, 'user/%/cancel/confirm/%/%', 'user/%/cancel/confirm/%/%', 'Confirm account cancellation', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 16, 29, 130, 0, 0, 0, 0, 0, 0, 0),
('management', 131, 105, 'admin/structure/types/manage/%/delete', 'admin/structure/types/manage/%/delete', 'Delete', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 20, 34, 105, 131, 0, 0, 0, 0, 0),
('management', 132, 77, 'admin/config/people/ip-blocking/delete/%', 'admin/config/people/ip-blocking/delete/%', 'Delete IP address', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 46, 77, 132, 0, 0, 0, 0, 0),
('management', 133, 64, 'admin/config/system/actions/delete/%', 'admin/config/system/actions/delete/%', 'Delete action', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31373a2244656c65746520616e20616374696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 54, 64, 133, 0, 0, 0, 0, 0),
('management', 134, 104, 'admin/structure/menu/manage/%/delete', 'admin/structure/menu/manage/%/delete', 'Delete menu', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 20, 45, 104, 134, 0, 0, 0, 0, 0),
('management', 135, 45, 'admin/structure/menu/item/%/delete', 'admin/structure/menu/item/%/delete', 'Delete menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 135, 0, 0, 0, 0, 0, 0),
('management', 136, 89, 'admin/people/permissions/roles/delete/%', 'admin/people/permissions/roles/delete/%', 'Delete role', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 17, 47, 89, 136, 0, 0, 0, 0, 0),
('management', 137, 100, 'admin/config/content/formats/%/disable', 'admin/config/content/formats/%/disable', 'Disable text format', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 33, 94, 100, 137, 0, 0, 0, 0),
('management', 138, 105, 'admin/structure/types/manage/%/edit', 'admin/structure/types/manage/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 34, 105, 138, 0, 0, 0, 0, 0),
('management', 139, 104, 'admin/structure/menu/manage/%/edit', 'admin/structure/menu/manage/%/edit', 'Edit menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 45, 104, 139, 0, 0, 0, 0, 0),
('management', 140, 45, 'admin/structure/menu/item/%/edit', 'admin/structure/menu/item/%/edit', 'Edit menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 140, 0, 0, 0, 0, 0, 0),
('management', 141, 89, 'admin/people/permissions/roles/edit/%', 'admin/people/permissions/roles/edit/%', 'Edit role', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 17, 47, 89, 141, 0, 0, 0, 0, 0),
('management', 142, 104, 'admin/structure/menu/manage/%/list', 'admin/structure/menu/manage/%/list', 'List links', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 20, 45, 104, 142, 0, 0, 0, 0, 0),
('management', 143, 45, 'admin/structure/menu/item/%/reset', 'admin/structure/menu/item/%/reset', 'Reset menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 143, 0, 0, 0, 0, 0, 0),
('management', 144, 105, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%/comment/display', 'Comment display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 5, 0, 1, 20, 34, 105, 144, 0, 0, 0, 0, 0),
('management', 145, 105, 'admin/structure/types/manage/%/comment/fields', 'admin/structure/types/manage/%/comment/fields', 'Comment fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 3, 5, 0, 1, 20, 34, 105, 145, 0, 0, 0, 0, 0),
('management', 146, 129, 'admin/structure/block/manage/%/%/configure', 'admin/structure/block/manage/%/%/configure', 'Configure block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 129, 146, 0, 0, 0, 0, 0),
('management', 147, 129, 'admin/structure/block/manage/%/%/delete', 'admin/structure/block/manage/%/%/delete', 'Delete block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 129, 147, 0, 0, 0, 0, 0),
('management', 148, 106, 'admin/config/regional/date-time/formats/%/delete', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22416c6c6f7720757365727320746f2064656c657465206120636f6e66696775726564206461746520666f726d61742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 49, 71, 106, 148, 0, 0, 0, 0),
('management', 149, 114, 'admin/config/regional/date-time/types/%/delete', 'admin/config/regional/date-time/types/%/delete', 'Delete date type', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22416c6c6f7720757365727320746f2064656c657465206120636f6e66696775726564206461746520747970652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 49, 71, 114, 149, 0, 0, 0, 0),
('management', 150, 106, 'admin/config/regional/date-time/formats/%/edit', 'admin/config/regional/date-time/formats/%/edit', 'Edit date format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22416c6c6f7720757365727320746f2065646974206120636f6e66696775726564206461746520666f726d61742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 49, 71, 106, 150, 0, 0, 0, 0),
('management', 151, 45, 'admin/structure/menu/manage/main-menu', 'admin/structure/menu/manage/%', 'Main menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 151, 0, 0, 0, 0, 0, 0),
('management', 152, 45, 'admin/structure/menu/manage/management', 'admin/structure/menu/manage/%', 'Management', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 152, 0, 0, 0, 0, 0, 0),
('management', 153, 45, 'admin/structure/menu/manage/navigation', 'admin/structure/menu/manage/%', 'Navigation', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 153, 0, 0, 0, 0, 0, 0),
('management', 154, 45, 'admin/structure/menu/manage/user-menu', 'admin/structure/menu/manage/%', 'User menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 154, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 155, 0, 'search', 'search', 'Search', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 1, 0, 0, 0, 0, 1, 1, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 156, 155, 'search/node', 'search/node', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 155, 156, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 157, 155, 'search/user', 'search/user', 'Users', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 155, 157, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 158, 1, 'admin/help', 'admin/help', 'Help', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34383a225265666572656e636520666f722075736167652c20636f6e66696775726174696f6e2c20616e64206d6f64756c65732e223b7d7d, 'system', 0, 0, 0, 0, 9, 2, 0, 1, 158, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 159, 0, 'taxonomy/term/%', 'taxonomy/term/%', 'Taxonomy term', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 160, 156, 'search/node/%', 'search/node/%', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 155, 156, 160, 0, 0, 0, 0, 0, 0, 0),
('navigation', 161, 16, 'user/%/shortcuts', 'user/%/shortcuts', 'Shortcuts', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 16, 161, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 162, 20, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Taxonomy', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36373a224d616e6167652074616767696e672c2063617465676f72697a6174696f6e2c20616e6420636c617373696669636174696f6e206f6620796f757220636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 20, 162, 0, 0, 0, 0, 0, 0, 0),
('management', 163, 18, 'admin/reports/search', 'admin/reports/search', 'Top search phrases', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a2256696577206d6f737420706f70756c61722073656172636820706872617365732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 163, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 164, 157, 'search/user/%', 'search/user/%', 'Users', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 155, 157, 164, 0, 0, 0, 0, 0, 0, 0),
('management', 165, 158, 'admin/help/block', 'admin/help/block', 'block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 165, 0, 0, 0, 0, 0, 0, 0),
('management', 166, 158, 'admin/help/color', 'admin/help/color', 'color', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 166, 0, 0, 0, 0, 0, 0, 0),
('management', 167, 158, 'admin/help/comment', 'admin/help/comment', 'comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 167, 0, 0, 0, 0, 0, 0, 0),
('management', 168, 158, 'admin/help/contextual', 'admin/help/contextual', 'contextual', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 168, 0, 0, 0, 0, 0, 0, 0),
('management', 169, 158, 'admin/help/dashboard', 'admin/help/dashboard', 'dashboard', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 169, 0, 0, 0, 0, 0, 0, 0),
('management', 170, 158, 'admin/help/dblog', 'admin/help/dblog', 'dblog', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 170, 0, 0, 0, 0, 0, 0, 0),
('management', 171, 158, 'admin/help/field', 'admin/help/field', 'field', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 171, 0, 0, 0, 0, 0, 0, 0),
('management', 172, 158, 'admin/help/field_sql_storage', 'admin/help/field_sql_storage', 'field_sql_storage', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 172, 0, 0, 0, 0, 0, 0, 0),
('management', 173, 158, 'admin/help/field_ui', 'admin/help/field_ui', 'field_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 173, 0, 0, 0, 0, 0, 0, 0),
('management', 174, 158, 'admin/help/file', 'admin/help/file', 'file', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 174, 0, 0, 0, 0, 0, 0, 0),
('management', 175, 158, 'admin/help/filter', 'admin/help/filter', 'filter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 175, 0, 0, 0, 0, 0, 0, 0),
('management', 176, 158, 'admin/help/help', 'admin/help/help', 'help', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 176, 0, 0, 0, 0, 0, 0, 0),
('management', 177, 158, 'admin/help/image', 'admin/help/image', 'image', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 177, 0, 0, 0, 0, 0, 0, 0),
('management', 178, 158, 'admin/help/list', 'admin/help/list', 'list', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 178, 0, 0, 0, 0, 0, 0, 0),
('management', 179, 158, 'admin/help/menu', 'admin/help/menu', 'menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 179, 0, 0, 0, 0, 0, 0, 0),
('management', 180, 158, 'admin/help/node', 'admin/help/node', 'node', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 180, 0, 0, 0, 0, 0, 0, 0),
('management', 181, 158, 'admin/help/number', 'admin/help/number', 'number', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 181, 0, 0, 0, 0, 0, 0, 0),
('management', 182, 158, 'admin/help/options', 'admin/help/options', 'options', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 182, 0, 0, 0, 0, 0, 0, 0),
('management', 183, 158, 'admin/help/overlay', 'admin/help/overlay', 'overlay', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 183, 0, 0, 0, 0, 0, 0, 0),
('management', 184, 158, 'admin/help/path', 'admin/help/path', 'path', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 184, 0, 0, 0, 0, 0, 0, 0),
('management', 185, 158, 'admin/help/rdf', 'admin/help/rdf', 'rdf', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 185, 0, 0, 0, 0, 0, 0, 0),
('management', 186, 158, 'admin/help/search', 'admin/help/search', 'search', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 186, 0, 0, 0, 0, 0, 0, 0),
('management', 187, 158, 'admin/help/shortcut', 'admin/help/shortcut', 'shortcut', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 187, 0, 0, 0, 0, 0, 0, 0),
('management', 188, 158, 'admin/help/system', 'admin/help/system', 'system', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 188, 0, 0, 0, 0, 0, 0, 0),
('management', 189, 158, 'admin/help/taxonomy', 'admin/help/taxonomy', 'taxonomy', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 189, 0, 0, 0, 0, 0, 0, 0),
('management', 190, 158, 'admin/help/text', 'admin/help/text', 'text', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 190, 0, 0, 0, 0, 0, 0, 0),
('management', 191, 158, 'admin/help/user', 'admin/help/user', 'user', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 191, 0, 0, 0, 0, 0, 0, 0),
('navigation', 192, 159, 'taxonomy/term/%/edit', 'taxonomy/term/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 2, 0, 159, 192, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 193, 159, 'taxonomy/term/%/view', 'taxonomy/term/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 159, 193, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 194, 162, 'admin/structure/taxonomy/add', 'admin/structure/taxonomy/add', 'Add vocabulary', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 162, 194, 0, 0, 0, 0, 0, 0),
('management', 195, 44, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Image styles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37383a22436f6e666967757265207374796c657320746861742063616e206265207573656420666f7220726573697a696e67206f722061646a757374696e6720696d61676573206f6e20646973706c61792e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 44, 195, 0, 0, 0, 0, 0, 0),
('management', 196, 162, 'admin/structure/taxonomy/list', 'admin/structure/taxonomy/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 20, 162, 196, 0, 0, 0, 0, 0, 0),
('management', 197, 51, 'admin/config/search/settings', 'admin/config/search/settings', 'Search settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36373a22436f6e6669677572652072656c6576616e63652073657474696e677320666f722073656172636820616e64206f7468657220696e646578696e67206f7074696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 51, 197, 0, 0, 0, 0, 0, 0),
('management', 198, 58, 'admin/config/user-interface/shortcut', 'admin/config/user-interface/shortcut', 'Shortcuts', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32393a2241646420616e64206d6f646966792073686f727463757420736574732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 58, 198, 0, 0, 0, 0, 0, 0),
('management', 199, 51, 'admin/config/search/path', 'admin/config/search/path', 'URL aliases', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a224368616e676520796f7572207369746527732055524c20706174687320627920616c696173696e67207468656d2e223b7d7d, 'system', 0, 0, 1, 0, -5, 4, 0, 1, 8, 51, 199, 0, 0, 0, 0, 0, 0),
('management', 200, 162, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 162, 200, 0, 0, 0, 0, 0, 0),
('management', 201, 199, 'admin/config/search/path/add', 'admin/config/search/path/add', 'Add alias', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 51, 199, 201, 0, 0, 0, 0, 0),
('management', 202, 198, 'admin/config/user-interface/shortcut/add-set', 'admin/config/user-interface/shortcut/add-set', 'Add shortcut set', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 58, 198, 202, 0, 0, 0, 0, 0),
('management', 203, 195, 'admin/config/media/image-styles/add', 'admin/config/media/image-styles/add', 'Add style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a224164642061206e657720696d616765207374796c652e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 44, 195, 203, 0, 0, 0, 0, 0),
('management', 204, 200, 'admin/structure/taxonomy/%/add', 'admin/structure/taxonomy/%/add', 'Add term', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 162, 200, 204, 0, 0, 0, 0, 0),
('management', 205, 197, 'admin/config/search/settings/reindex', 'admin/config/search/settings/reindex', 'Clear index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 51, 197, 205, 0, 0, 0, 0, 0),
('management', 206, 200, 'admin/structure/taxonomy/%/edit', 'admin/structure/taxonomy/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 20, 162, 200, 206, 0, 0, 0, 0, 0),
('management', 207, 198, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Edit shortcuts', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 58, 198, 207, 0, 0, 0, 0, 0),
('management', 208, 200, 'admin/structure/taxonomy/%/list', 'admin/structure/taxonomy/%/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -20, 5, 0, 1, 20, 162, 200, 208, 0, 0, 0, 0, 0),
('management', 209, 199, 'admin/config/search/path/list', 'admin/config/search/path/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 51, 199, 209, 0, 0, 0, 0, 0);
INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 210, 195, 'admin/config/media/image-styles/list', 'admin/config/media/image-styles/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a224c697374207468652063757272656e7420696d616765207374796c6573206f6e2074686520736974652e223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 44, 195, 210, 0, 0, 0, 0, 0),
('management', 211, 207, 'admin/config/user-interface/shortcut/%/add-link', 'admin/config/user-interface/shortcut/%/add-link', 'Add shortcut', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 58, 198, 207, 211, 0, 0, 0, 0),
('management', 212, 199, 'admin/config/search/path/delete/%', 'admin/config/search/path/delete/%', 'Delete alias', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 51, 199, 212, 0, 0, 0, 0, 0),
('management', 213, 207, 'admin/config/user-interface/shortcut/%/delete', 'admin/config/user-interface/shortcut/%/delete', 'Delete shortcut set', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 58, 198, 207, 213, 0, 0, 0, 0),
('management', 214, 199, 'admin/config/search/path/edit/%', 'admin/config/search/path/edit/%', 'Edit alias', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 51, 199, 214, 0, 0, 0, 0, 0),
('management', 215, 207, 'admin/config/user-interface/shortcut/%/edit', 'admin/config/user-interface/shortcut/%/edit', 'Edit set name', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 6, 0, 1, 8, 58, 198, 207, 215, 0, 0, 0, 0),
('management', 216, 198, 'admin/config/user-interface/shortcut/link/%', 'admin/config/user-interface/shortcut/link/%', 'Edit shortcut', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 58, 198, 216, 0, 0, 0, 0, 0),
('management', 217, 195, 'admin/config/media/image-styles/edit/%', 'admin/config/media/image-styles/edit/%', 'Edit style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22436f6e66696775726520616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 44, 195, 217, 0, 0, 0, 0, 0),
('management', 218, 207, 'admin/config/user-interface/shortcut/%/links', 'admin/config/user-interface/shortcut/%/links', 'List links', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 58, 198, 207, 218, 0, 0, 0, 0),
('management', 219, 195, 'admin/config/media/image-styles/delete/%', 'admin/config/media/image-styles/delete/%', 'Delete style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2244656c65746520616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 44, 195, 219, 0, 0, 0, 0, 0),
('management', 220, 195, 'admin/config/media/image-styles/revert/%', 'admin/config/media/image-styles/revert/%', 'Revert style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2252657665727420616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 44, 195, 220, 0, 0, 0, 0, 0),
('management', 221, 216, 'admin/config/user-interface/shortcut/link/%/delete', 'admin/config/user-interface/shortcut/link/%/delete', 'Delete shortcut', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 58, 198, 216, 221, 0, 0, 0, 0),
('management', 222, 217, 'admin/config/media/image-styles/edit/%/add/%', 'admin/config/media/image-styles/edit/%/add/%', 'Add image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224164642061206e65772065666665637420746f2061207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 44, 195, 217, 222, 0, 0, 0, 0),
('management', 223, 217, 'admin/config/media/image-styles/edit/%/effects/%', 'admin/config/media/image-styles/edit/%/effects/%', 'Edit image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a224564697420616e206578697374696e67206566666563742077697468696e2061207374796c652e223b7d7d, 'system', 0, 0, 1, 0, 0, 6, 0, 1, 8, 44, 195, 217, 223, 0, 0, 0, 0),
('management', 224, 223, 'admin/config/media/image-styles/edit/%/effects/%/delete', 'admin/config/media/image-styles/edit/%/effects/%/delete', 'Delete image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a2244656c65746520616e206578697374696e67206566666563742066726f6d2061207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 44, 195, 217, 223, 224, 0, 0, 0),
('shortcut-set-1', 225, 0, 'node/add', 'node/add', 'Add content', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -50, 1, 0, 225, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 227, 0, '<front>', '', 'Home', 0x613a303a7b7d, 'menu', 0, 1, 0, 0, -50, 1, 1, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 228, 6, 'node/add/article', 'node/add/article', 'Article', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38393a22557365203c656d3e61727469636c65733c2f656d3e20666f722074696d652d73656e73697469766520636f6e74656e74206c696b65206e6577732c2070726573732072656c6561736573206f7220626c6f6720706f7374732e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 228, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 229, 6, 'node/add/page', 'node/add/page', 'Basic page', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37373a22557365203c656d3e62617369632070616765733c2f656d3e20666f7220796f75722073746174696320636f6e74656e742c207375636820617320616e202741626f75742075732720706167652e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 229, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 230, 158, 'admin/help/toolbar', 'admin/help/toolbar', 'toolbar', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 230, 0, 0, 0, 0, 0, 0, 0),
('management', 269, 18, 'admin/reports/updates', 'admin/reports/updates', 'Available updates', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38323a22476574206120737461747573207265706f72742061626f757420617661696c61626c65207570646174657320666f7220796f757220696e7374616c6c6564206d6f64756c657320616e64207468656d65732e223b7d7d, 'system', 0, 0, 0, 0, -50, 3, 0, 1, 18, 269, 0, 0, 0, 0, 0, 0, 0),
('management', 270, 15, 'admin/modules/install', 'admin/modules/install', 'Install new module', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 3, 0, 1, 15, 270, 0, 0, 0, 0, 0, 0, 0),
('management', 271, 7, 'admin/appearance/install', 'admin/appearance/install', 'Install new theme', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 3, 0, 1, 7, 271, 0, 0, 0, 0, 0, 0, 0),
('management', 272, 15, 'admin/modules/update', 'admin/modules/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 3, 0, 1, 15, 272, 0, 0, 0, 0, 0, 0, 0),
('management', 273, 7, 'admin/appearance/update', 'admin/appearance/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 3, 0, 1, 7, 273, 0, 0, 0, 0, 0, 0, 0),
('management', 274, 158, 'admin/help/update', 'admin/help/update', 'update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 274, 0, 0, 0, 0, 0, 0, 0),
('management', 275, 269, 'admin/reports/updates/install', 'admin/reports/updates/install', 'Install new module or theme', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 4, 0, 1, 18, 269, 275, 0, 0, 0, 0, 0, 0),
('management', 276, 269, 'admin/reports/updates/update', 'admin/reports/updates/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 4, 0, 1, 18, 269, 276, 0, 0, 0, 0, 0, 0),
('management', 277, 269, 'admin/reports/updates/list', 'admin/reports/updates/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 18, 269, 277, 0, 0, 0, 0, 0, 0),
('management', 278, 269, 'admin/reports/updates/settings', 'admin/reports/updates/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 50, 4, 0, 1, 18, 269, 278, 0, 0, 0, 0, 0, 0),
('main-menu', 317, 0, 'contact', 'contact', 'Contact', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 0, 0, -44, 1, 1, 317, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 318, 0, 'locationmap', 'locationmap', 'Location', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 0, 0, -46, 1, 1, 318, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 319, 0, 'poll', 'poll', 'Polls', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 0, 1, 0, 319, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 320, 0, 'cart', 'cart', 'Shopping cart', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 320, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 321, 0, 'sitemap', 'sitemap', 'Sitemap', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22446973706c617920612073697465206d61702077697468205253532066656564732e223b7d7d, 'system', 0, 0, 0, 0, -48, 1, 1, 321, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 322, 318, 'locationmap/edit', 'locationmap/edit', 'Edit', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32333a22436f6e666967757265204c6f636174696f6e204d61702e223b7d7d, 'system', -1, 0, 0, 0, 0, 2, 0, 318, 322, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 323, 320, 'cart/my', 'cart/my', 'Shopping cart (# items)', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 0, 2, 0, 320, 323, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 324, 318, 'locationmap/view', 'locationmap/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 318, 324, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 325, 1, 'admin/commerce', 'admin/commerce', 'Store', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2241646d696e697374657220796f75722073746f72652e223b7d7d, 'system', 0, 0, 1, 0, -7, 2, 0, 1, 325, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 326, 325, 'admin/commerce/config', 'admin/commerce/config', 'Configuration', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a22436f6e6669677572652073657474696e677320616e6420627573696e6573732072756c657320666f7220796f75722073746f72652e223b7d7d, 'system', 0, 0, 1, 0, 50, 3, 0, 1, 325, 326, 0, 0, 0, 0, 0, 0, 0),
('navigation', 327, 16, 'user/%/contact', 'user/%/contact', 'Contact', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 16, 327, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 328, 20, 'admin/structure/contact', 'admin/structure/contact', 'Contact form', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37313a2243726561746520612073797374656d20636f6e7461637420666f726d20616e64207365742075702063617465676f7269657320666f722074686520666f726d20746f207573652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 20, 328, 0, 0, 0, 0, 0, 0, 0),
('navigation', 331, 6, 'node/add/poll', 'node/add/poll', 'Poll', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3139313a2241203c656d3e706f6c6c3c2f656d3e2069732061207175657374696f6e2077697468206120736574206f6620706f737369626c6520726573706f6e7365732e2041203c656d3e706f6c6c3c2f656d3e2c206f6e636520637265617465642c206175746f6d61746963616c6c792070726f766964657320612073696d706c652072756e6e696e6720636f756e74206f6620746865206e756d626572206f6620766f74657320726563656976656420666f72206561636820726573706f6e73652e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 331, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 332, 18, 'admin/reports/hits', 'admin/reports/hits', 'Recent hits', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22566965772070616765732074686174206861766520726563656e746c79206265656e20766973697465642e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 332, 0, 0, 0, 0, 0, 0, 0),
('navigation', 333, 5, 'node/%/results', 'node/%/results', 'Results', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 2, 0, 5, 333, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 334, 18, 'admin/reports/pages', 'admin/reports/pages', 'Top pages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a225669657720706167657320746861742068617665206265656e20686974206672657175656e746c792e223b7d7d, 'system', 0, 0, 0, 0, 1, 3, 0, 1, 18, 334, 0, 0, 0, 0, 0, 0, 0),
('management', 335, 18, 'admin/reports/referrers', 'admin/reports/referrers', 'Top referrers', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31393a225669657720746f70207265666572726572732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 335, 0, 0, 0, 0, 0, 0, 0),
('management', 336, 18, 'admin/reports/visitors', 'admin/reports/visitors', 'Top visitors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22566965772076697369746f7273207468617420686974206d616e792070616765732e223b7d7d, 'system', 0, 0, 0, 0, 2, 3, 0, 1, 18, 336, 0, 0, 0, 0, 0, 0, 0),
('navigation', 337, 5, 'node/%/track', 'node/%/track', 'Track', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 5, 337, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 338, 5, 'node/%/translate', 'node/%/translate', 'Translate', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 5, 338, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 339, 20, 'admin/structure/trigger', 'admin/structure/trigger', 'Triggers', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22436f6e666967757265207768656e20746f206578656375746520616374696f6e732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 20, 339, 0, 0, 0, 0, 0, 0, 0),
('navigation', 340, 5, 'node/%/votes', 'node/%/votes', 'Votes', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 2, 0, 5, 340, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 341, 158, 'admin/help/commerce_checkout', 'admin/help/commerce_checkout', 'commerce_checkout', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 341, 0, 0, 0, 0, 0, 0, 0),
('management', 342, 158, 'admin/help/commerce_customer_ui', 'admin/help/commerce_customer_ui', 'commerce_customer_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 342, 0, 0, 0, 0, 0, 0, 0),
('management', 343, 158, 'admin/help/commerce_order_ui', 'admin/help/commerce_order_ui', 'commerce_order_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 343, 0, 0, 0, 0, 0, 0, 0),
('management', 344, 158, 'admin/help/commerce_payment_ui', 'admin/help/commerce_payment_ui', 'commerce_payment_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 344, 0, 0, 0, 0, 0, 0, 0),
('management', 345, 158, 'admin/help/commerce_product_pricing_ui', 'admin/help/commerce_product_pricing_ui', 'commerce_product_pricing_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 345, 0, 0, 0, 0, 0, 0, 0),
('management', 346, 158, 'admin/help/commerce_product_ui', 'admin/help/commerce_product_ui', 'commerce_product_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 346, 0, 0, 0, 0, 0, 0, 0),
('management', 347, 158, 'admin/help/contact', 'admin/help/contact', 'contact', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 347, 0, 0, 0, 0, 0, 0, 0),
('management', 348, 158, 'admin/help/jcarousel', 'admin/help/jcarousel', 'jcarousel', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 348, 0, 0, 0, 0, 0, 0, 0),
('management', 349, 158, 'admin/help/locale', 'admin/help/locale', 'locale', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 349, 0, 0, 0, 0, 0, 0, 0),
('management', 350, 158, 'admin/help/locationmap', 'admin/help/locationmap', 'locationmap', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 350, 0, 0, 0, 0, 0, 0, 0),
('management', 352, 158, 'admin/help/php', 'admin/help/php', 'php', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 352, 0, 0, 0, 0, 0, 0, 0),
('management', 353, 158, 'admin/help/poll', 'admin/help/poll', 'poll', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 353, 0, 0, 0, 0, 0, 0, 0),
('management', 354, 158, 'admin/help/rules', 'admin/help/rules', 'rules', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 354, 0, 0, 0, 0, 0, 0, 0),
('management', 355, 158, 'admin/help/statistics', 'admin/help/statistics', 'statistics', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 355, 0, 0, 0, 0, 0, 0, 0),
('management', 356, 158, 'admin/help/syslog', 'admin/help/syslog', 'syslog', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 356, 0, 0, 0, 0, 0, 0, 0),
('management', 357, 158, 'admin/help/translation', 'admin/help/translation', 'translation', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 357, 0, 0, 0, 0, 0, 0, 0),
('management', 358, 158, 'admin/help/trigger', 'admin/help/trigger', 'trigger', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 358, 0, 0, 0, 0, 0, 0, 0),
('management', 359, 325, 'admin/commerce/customer-profiles', 'admin/commerce/customer-profiles', 'Customer profiles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35363a224d616e61676520637573746f6d65722070726f66696c657320616e642070726f66696c6520747970657320696e207468652073746f72652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 325, 359, 0, 0, 0, 0, 0, 0, 0),
('management', 360, 325, 'admin/commerce/orders', 'admin/commerce/orders', 'Orders', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a224d616e616765206f726465727320696e207468652073746f72652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 325, 360, 0, 0, 0, 0, 0, 0, 0),
('management', 361, 325, 'admin/commerce/products', 'admin/commerce/products', 'Products', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a224d616e6167652070726f647563747320616e642070726f6475637420747970657320696e207468652073746f72652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 325, 361, 0, 0, 0, 0, 0, 0, 0),
('navigation', 362, 16, 'user/%/orders', 'user/%/orders', 'Orders', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 15, 2, 0, 16, 362, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 363, 359, 'admin/commerce/customer-profiles/%', 'admin/commerce/customer-profiles/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 359, 363, 0, 0, 0, 0, 0, 0),
('management', 364, 360, 'admin/commerce/orders/%', 'admin/commerce/orders/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 360, 364, 0, 0, 0, 0, 0, 0),
('navigation', 365, 362, 'user/%/orders/%', 'user/%/orders/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 16, 362, 365, 0, 0, 0, 0, 0, 0, 0),
('management', 366, 361, 'admin/commerce/products/%', 'admin/commerce/products/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 361, 366, 0, 0, 0, 0, 0, 0),
('management', 367, 359, 'admin/commerce/customer-profiles/add', 'admin/commerce/customer-profiles/add', 'Add a customer profile', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a224164642061206e657720637573746f6d65722070726f66696c652e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 325, 359, 367, 0, 0, 0, 0, 0, 0),
('management', 368, 361, 'admin/commerce/products/add', 'admin/commerce/products/add', 'Add a product', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a224164642061206e65772070726f6475637420666f722073616c652e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 325, 361, 368, 0, 0, 0, 0, 0, 0),
('management', 369, 328, 'admin/structure/contact/add', 'admin/structure/contact/add', 'Add category', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 4, 0, 1, 20, 328, 369, 0, 0, 0, 0, 0, 0),
('management', 370, 326, 'admin/commerce/config/checkout', 'admin/commerce/config/checkout', 'Checkout settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35373a22437573746f6d697a652074686520636865636b6f757420666f726d20616e6420636f6e66696775726520636865636b6f75742072756c65732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 326, 370, 0, 0, 0, 0, 0, 0),
('management', 371, 44, 'admin/config/media/colorbox', 'admin/config/media/colorbox', 'Colorbox', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a2241646a75737420436f6c6f72626f782073657474696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 44, 371, 0, 0, 0, 0, 0, 0),
('management', 372, 339, 'admin/structure/trigger/comment', 'admin/structure/trigger/comment', 'Comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 339, 372, 0, 0, 0, 0, 0, 0),
('management', 373, 360, 'admin/commerce/orders/add', 'admin/commerce/orders/add', 'Create an order', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31393a224372656174652061206e6577206f726465722e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 325, 360, 373, 0, 0, 0, 0, 0, 0),
('management', 374, 326, 'admin/commerce/config/currency', 'admin/commerce/config/currency', 'Currency settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35323a22436f6e666967757265207468652064656661756c742063757272656e637920616e6420646973706c61792073657474696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 326, 374, 0, 0, 0, 0, 0, 0),
('management', 376, 18, 'admin/reports/access/%', 'admin/reports/access/%', 'Details', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31363a225669657720616363657373206c6f672e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 376, 0, 0, 0, 0, 0, 0, 0),
('management', 377, 49, 'admin/config/regional/language', 'admin/config/regional/language', 'Languages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35353a22436f6e666967757265206c616e67756167657320666f7220636f6e74656e7420616e6420746865207573657220696e746572666163652e223b7d7d, 'system', 0, 0, 1, 0, -10, 4, 0, 1, 8, 49, 377, 0, 0, 0, 0, 0, 0),
('management', 378, 326, 'admin/commerce/config/line-items', 'admin/commerce/config/line-items', 'Line item types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a224d616e616765206c696e65206974656d20747970657320666f7220796f75722073746f72652e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 325, 326, 378, 0, 0, 0, 0, 0, 0),
('management', 379, 339, 'admin/structure/trigger/node', 'admin/structure/trigger/node', 'Node', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 339, 379, 0, 0, 0, 0, 0, 0),
('management', 380, 326, 'admin/commerce/config/order', 'admin/commerce/config/order', 'Order settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35353a22436f6e6669677572652067656e6572616c206f726465722073657474696e67732c206669656c64732c20616e6420646973706c6179732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 326, 380, 0, 0, 0, 0, 0, 0),
('management', 381, 326, 'admin/commerce/config/payment-methods', 'admin/commerce/config/payment-methods', 'Payment methods', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35363a22456e61626c6520616e6420636f6e666967757265207061796d656e74206d6574686f642072756c6520636f6e66696775726174696f6e732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 325, 326, 381, 0, 0, 0, 0, 0, 0),
('management', 382, 326, 'admin/commerce/config/product-pricing', 'admin/commerce/config/product-pricing', 'Product pricing rules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36333a22456e61626c6520616e6420636f6e6669677572652070726f647563742070726963696e672072756c657320616e64207072652d63616c63756c6174696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 325, 326, 382, 0, 0, 0, 0, 0, 0),
('management', 383, 361, 'admin/commerce/products/types', 'admin/commerce/products/types', 'Product types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a224d616e6167652070726f647563747320747970657320666f7220796f75722073746f72652e223b7d7d, 'system', -1, 0, 1, 0, 0, 4, 0, 1, 325, 361, 383, 0, 0, 0, 0, 0, 0),
('management', 384, 359, 'admin/commerce/customer-profiles/types', 'admin/commerce/customer-profiles/types', 'Profile types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a224d616e61676520637573746f6d65722070726f66696c6520747970657320666f7220796f75722073746f72652e223b7d7d, 'system', -1, 0, 1, 0, 0, 4, 0, 1, 325, 359, 384, 0, 0, 0, 0, 0, 0),
('management', 385, 62, 'admin/config/workflow/rules', 'admin/config/workflow/rules', 'Rules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a224d616e616765207265616374696f6e2072756c657320616e642072756c6520636f6d706f6e656e74732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 62, 385, 0, 0, 0, 0, 0, 0),
('management', 386, 51, 'admin/config/search/sitemap', 'admin/config/search/sitemap', 'Site map', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34393a22436f6e74726f6c20776861742073686f756c6420626520646973706c61796564206f6e207468652073697465206d61702e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 51, 386, 0, 0, 0, 0, 0, 0),
('management', 387, 54, 'admin/config/system/statistics', 'admin/config/system/statistics', 'Statistics', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36383a22436f6e74726f6c2064657461696c732061626f7574207768617420616e6420686f7720796f75722073697465206c6f67732061636365737320737461746973746963732e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 54, 387, 0, 0, 0, 0, 0, 0),
('management', 388, 339, 'admin/structure/trigger/system', 'admin/structure/trigger/system', 'System', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 339, 388, 0, 0, 0, 0, 0, 0),
('management', 389, 339, 'admin/structure/trigger/taxonomy', 'admin/structure/trigger/taxonomy', 'Taxonomy', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 339, 389, 0, 0, 0, 0, 0, 0),
('navigation', 390, 16, 'user/%/track/navigation', 'user/%/track/navigation', 'Track page visits', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 16, 390, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 391, 49, 'admin/config/regional/translate', 'admin/config/regional/translate', 'Translate interface', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35393a225472616e736c61746520746865206275696c7420696e20696e7465726661636520616e64206f7074696f6e616c6c79206f7468657220746578742e223b7d7d, 'system', 0, 0, 1, 0, -5, 4, 0, 1, 8, 49, 391, 0, 0, 0, 0, 0, 0),
('management', 392, 339, 'admin/structure/trigger/unassign', 'admin/structure/trigger/unassign', 'Unassign', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22556e61737369676e20616e20616374696f6e2066726f6d206120747269676765722e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 339, 392, 0, 0, 0, 0, 0, 0),
('management', 393, 339, 'admin/structure/trigger/user', 'admin/structure/trigger/user', 'User', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 339, 393, 0, 0, 0, 0, 0, 0),
('management', 394, 359, 'admin/commerce/customer-profiles/list', 'admin/commerce/customer-profiles/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 325, 359, 394, 0, 0, 0, 0, 0, 0),
('management', 395, 360, 'admin/commerce/orders/list', 'admin/commerce/orders/list', 'Orders', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 325, 360, 395, 0, 0, 0, 0, 0, 0),
('management', 396, 360, 'admin/commerce/orders/carts', 'admin/commerce/orders/carts', 'Shopping carts', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 325, 360, 396, 0, 0, 0, 0, 0, 0),
('management', 397, 361, 'admin/commerce/products/list', 'admin/commerce/products/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 325, 361, 397, 0, 0, 0, 0, 0, 0),
('management', 398, 381, 'admin/commerce/config/payment-methods/add', 'admin/commerce/config/payment-methods/add', 'Add a payment method rule', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a224164647320616e206164646974696f6e616c207061796d656e74206d6574686f642072756c6520636f6e66696775726174696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 326, 381, 398, 0, 0, 0, 0, 0),
('management', 399, 377, 'admin/config/regional/language/add', 'admin/config/regional/language/add', 'Add language', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 5, 0, 1, 8, 49, 377, 399, 0, 0, 0, 0, 0),
('management', 400, 383, 'admin/commerce/products/types/add', 'admin/commerce/products/types/add', 'Add product type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 325, 361, 383, 400, 0, 0, 0, 0, 0),
('management', 401, 384, 'admin/commerce/customer-profiles/types/billing', 'admin/commerce/customer-profiles/types/billing', 'Billing information', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 359, 384, 401, 0, 0, 0, 0, 0),
('management', 402, 370, 'admin/commerce/config/checkout/form', 'admin/commerce/config/checkout/form', 'Checkout form', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37303a224275696c6420796f757220636865636b6f7574207061676573207573696e67206d6f64756c6520646566696e656420636865636b6f757420666f726d20656c656d656e74732e223b7d7d, 'system', -1, 0, 1, 0, 0, 5, 0, 1, 325, 326, 370, 402, 0, 0, 0, 0, 0),
('management', 403, 370, 'admin/commerce/config/checkout/rules', 'admin/commerce/config/checkout/rules', 'Checkout rules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22456e61626c6520616e6420636f6e66696775726520636865636b6f757420636f6d706c6574696f6e2072756c65732e223b7d7d, 'system', -1, 0, 0, 0, 5, 5, 0, 1, 325, 326, 370, 403, 0, 0, 0, 0, 0),
('management', 404, 385, 'admin/config/workflow/rules/components', 'admin/config/workflow/rules/components', 'Components', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 62, 385, 404, 0, 0, 0, 0, 0),
('management', 405, 368, 'admin/commerce/products/add/product', 'admin/commerce/products/add/product', 'Create !name', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32313a22412062617369632070726f6475637420747970652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 361, 368, 405, 0, 0, 0, 0, 0),
('management', 406, 367, 'admin/commerce/customer-profiles/add/billing', 'admin/commerce/customer-profiles/add/billing', 'Create @name', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38303a225468652070726f66696c65207573656420746f20636f6c6c6563742062696c6c696e6720696e666f726d6174696f6e206f6e2074686520636865636b6f757420616e64206f7264657220666f726d732e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 359, 367, 406, 0, 0, 0, 0, 0),
('management', 407, 373, 'admin/commerce/orders/add/%', 'admin/commerce/orders/add/%', 'Create an order', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a224372656174652061206e6577206f7264657220666f72207468652073706563696669656420757365722e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 360, 373, 407, 0, 0, 0, 0, 0),
('management', 408, 364, 'admin/commerce/orders/%/delete', 'admin/commerce/orders/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 325, 360, 364, 408, 0, 0, 0, 0, 0),
('management', 409, 366, 'admin/commerce/products/%/delete', 'admin/commerce/products/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 325, 361, 366, 409, 0, 0, 0, 0, 0),
('management', 410, 363, 'admin/commerce/customer-profiles/%/delete', 'admin/commerce/customer-profiles/%/delete', 'Delete a customer profile', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 325, 359, 363, 410, 0, 0, 0, 0, 0),
('management', 411, 328, 'admin/structure/contact/delete/%', 'admin/structure/contact/delete/%', 'Delete contact', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 328, 411, 0, 0, 0, 0, 0, 0),
('management', 412, 377, 'admin/config/regional/language/configure', 'admin/config/regional/language/configure', 'Detection and selection', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 8, 49, 377, 412, 0, 0, 0, 0, 0),
('management', 413, 364, 'admin/commerce/orders/%/edit', 'admin/commerce/orders/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -5, 5, 0, 1, 325, 360, 364, 413, 0, 0, 0, 0, 0),
('management', 414, 363, 'admin/commerce/customer-profiles/%/edit', 'admin/commerce/customer-profiles/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 325, 359, 363, 414, 0, 0, 0, 0, 0),
('management', 415, 366, 'admin/commerce/products/%/edit', 'admin/commerce/products/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 325, 361, 366, 415, 0, 0, 0, 0, 0),
('management', 416, 328, 'admin/structure/contact/edit/%', 'admin/structure/contact/edit/%', 'Edit contact category', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 328, 416, 0, 0, 0, 0, 0, 0),
('management', 417, 391, 'admin/config/regional/translate/export', 'admin/config/regional/translate/export', 'Export', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 30, 5, 0, 1, 8, 49, 391, 417, 0, 0, 0, 0, 0),
('management', 418, 391, 'admin/config/regional/translate/import', 'admin/config/regional/translate/import', 'Import', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 8, 49, 391, 418, 0, 0, 0, 0, 0),
('management', 419, 382, 'admin/commerce/config/product-pricing/rules', 'admin/commerce/config/product-pricing/rules', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36323a2241646d696e6973746572207468652072756c6573207573656420666f722063616c63756c6174696e672070726f647563742073656c6c207072696365732e223b7d7d, 'system', -1, 0, 1, 0, 0, 5, 0, 1, 325, 326, 382, 419, 0, 0, 0, 0, 0),
('management', 420, 377, 'admin/config/regional/language/overview', 'admin/config/regional/language/overview', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 49, 377, 420, 0, 0, 0, 0, 0),
('management', 421, 71, 'admin/config/regional/date-time/locale', 'admin/config/regional/date-time/locale', 'Localize', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a22436f6e666967757265206461746520666f726d61747320666f722065616368206c6f63616c65223b7d7d, 'system', -1, 0, 1, 0, -8, 5, 0, 1, 8, 49, 71, 421, 0, 0, 0, 0, 0),
('management', 424, 391, 'admin/config/regional/translate/overview', 'admin/config/regional/translate/overview', 'Overview', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 49, 391, 424, 0, 0, 0, 0, 0),
('management', 425, 364, 'admin/commerce/orders/%/payment', 'admin/commerce/orders/%/payment', 'Payment', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 10, 5, 0, 1, 325, 360, 364, 425, 0, 0, 0, 0, 0),
('management', 426, 382, 'admin/commerce/config/product-pricing/pre-calculation', 'admin/commerce/config/product-pricing/pre-calculation', 'Pre-calculation', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22436f6e66696775726520746865207072696365207072652d63616c63756c6174696f6e2073657474696e67732e223b7d7d, 'system', -1, 0, 0, 0, 5, 5, 0, 1, 325, 326, 382, 426, 0, 0, 0, 0, 0),
('management', 427, 383, 'admin/commerce/products/types/product', 'admin/commerce/products/types/product', 'Product', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 361, 383, 427, 0, 0, 0, 0, 0),
('management', 428, 385, 'admin/config/workflow/rules/reaction', 'admin/config/workflow/rules/reaction', 'Rules', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -1, 5, 0, 1, 8, 62, 385, 428, 0, 0, 0, 0, 0),
('management', 429, 385, 'admin/config/workflow/rules/settings', 'admin/config/workflow/rules/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 62, 385, 429, 0, 0, 0, 0, 0),
('management', 430, 380, 'admin/commerce/config/order/settings', 'admin/commerce/config/order/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 325, 326, 380, 430, 0, 0, 0, 0, 0),
('management', 431, 391, 'admin/config/regional/translate/translate', 'admin/config/regional/translate/translate', 'Translate', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 8, 49, 391, 431, 0, 0, 0, 0, 0),
('management', 432, 364, 'admin/commerce/orders/%/view', 'admin/commerce/orders/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 325, 360, 364, 432, 0, 0, 0, 0, 0),
('management', 433, 425, 'admin/commerce/orders/%/payment/%', 'admin/commerce/orders/%/payment/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 360, 364, 425, 433, 0, 0, 0, 0),
('management', 434, 381, 'admin/commerce/config/payment-methods/manage/%', 'admin/commerce/config/payment-methods/manage/%', '', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 0, 5, 0, 1, 325, 326, 381, 434, 0, 0, 0, 0, 0),
('management', 435, 403, 'admin/commerce/config/checkout/rules/add', 'admin/commerce/config/checkout/rules/add', 'Add a checkout rule', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35383a224164647320616e206164646974696f6e616c20636865636b6f757420636f6d706c6574696f6e2072756c6520636f6e66696775726174696f6e2e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 325, 326, 370, 403, 435, 0, 0, 0, 0),
('management', 436, 419, 'admin/commerce/config/product-pricing/rules/add', 'admin/commerce/config/product-pricing/rules/add', 'Add a pricing rule', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36313a224164647320616e206164646974696f6e616c2073656c6c2070726963652063616c63756c6174696f6e2072756c6520636f6e66696775726174696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 382, 419, 436, 0, 0, 0, 0),
('management', 437, 404, 'admin/config/workflow/rules/components/add', 'admin/config/workflow/rules/components/add', 'Add new component', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 62, 385, 404, 437, 0, 0, 0, 0),
('management', 438, 428, 'admin/config/workflow/rules/reaction/add', 'admin/config/workflow/rules/reaction/add', 'Add new rule', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 62, 385, 428, 438, 0, 0, 0, 0),
('management', 440, 429, 'admin/config/workflow/rules/settings/advanced', 'admin/config/workflow/rules/settings/advanced', 'Advanced', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 62, 385, 429, 440, 0, 0, 0, 0),
('management', 441, 429, 'admin/config/workflow/rules/settings/basic', 'admin/config/workflow/rules/settings/basic', 'Basic', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 62, 385, 429, 441, 0, 0, 0, 0),
('management', 442, 377, 'admin/config/regional/language/delete/%', 'admin/config/regional/language/delete/%', 'Confirm', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 49, 377, 442, 0, 0, 0, 0, 0),
('management', 447, 427, 'admin/commerce/products/types/product/delete', 'admin/commerce/products/types/product/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 6, 0, 1, 325, 361, 383, 427, 447, 0, 0, 0, 0),
('management', 448, 391, 'admin/config/regional/translate/delete/%', 'admin/config/regional/translate/delete/%', 'Delete string', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 49, 391, 448, 0, 0, 0, 0, 0),
('management', 449, 427, 'admin/commerce/products/types/product/edit', 'admin/commerce/products/types/product/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 325, 361, 383, 427, 449, 0, 0, 0, 0),
('management', 450, 377, 'admin/config/regional/language/edit/%', 'admin/config/regional/language/edit/%', 'Edit language', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 49, 377, 450, 0, 0, 0, 0, 0),
('management', 451, 391, 'admin/config/regional/translate/edit/%', 'admin/config/regional/translate/edit/%', 'Edit string', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 49, 391, 451, 0, 0, 0, 0, 0),
('management', 452, 404, 'admin/config/workflow/rules/components/import', 'admin/config/workflow/rules/components/import', 'Import component', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 62, 385, 404, 452, 0, 0, 0, 0),
('management', 453, 428, 'admin/config/workflow/rules/reaction/import', 'admin/config/workflow/rules/reaction/import', 'Import rule', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 62, 385, 428, 453, 0, 0, 0, 0),
('management', 454, 401, 'admin/commerce/customer-profiles/types/billing/display', 'admin/commerce/customer-profiles/types/billing/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 325, 359, 384, 401, 454, 0, 0, 0, 0),
('management', 455, 427, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 325, 361, 383, 427, 455, 0, 0, 0, 0),
('management', 456, 401, 'admin/commerce/customer-profiles/types/billing/fields', 'admin/commerce/customer-profiles/types/billing/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 325, 359, 384, 401, 456, 0, 0, 0, 0),
('management', 457, 427, 'admin/commerce/products/types/product/fields', 'admin/commerce/products/types/product/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 325, 361, 383, 427, 457, 0, 0, 0, 0),
('management', 458, 412, 'admin/config/regional/language/configure/session', 'admin/config/regional/language/configure/session', 'Session language detection configuration', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 49, 377, 412, 458, 0, 0, 0, 0),
('management', 459, 412, 'admin/config/regional/language/configure/url', 'admin/config/regional/language/configure/url', 'URL language detection configuration', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 49, 377, 412, 459, 0, 0, 0, 0),
('management', 461, 402, 'admin/commerce/config/checkout/form/pane/%', 'admin/commerce/config/checkout/form/pane/%', '', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22436f6e666967757265207468652073657474696e677320666f72206120636865636b6f75742070616e652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 370, 402, 461, 0, 0, 0, 0),
('management', 462, 434, 'admin/commerce/config/payment-methods/manage/%/clone', 'admin/commerce/config/payment-methods/manage/%/clone', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 462, 0, 0, 0, 0),
('management', 463, 403, 'admin/commerce/config/checkout/rules/manage/%', 'admin/commerce/config/checkout/rules/manage/%', '', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 0, 6, 0, 1, 325, 326, 370, 403, 463, 0, 0, 0, 0),
('management', 464, 419, 'admin/commerce/config/product-pricing/rules/manage/%', 'admin/commerce/config/product-pricing/rules/manage/%', '', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 0, 6, 0, 1, 325, 326, 382, 419, 464, 0, 0, 0, 0),
('management', 465, 404, 'admin/config/workflow/rules/components/manage/%', 'admin/config/workflow/rules/components/manage/%', '', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 0, 6, 0, 1, 8, 62, 385, 404, 465, 0, 0, 0, 0),
('management', 466, 428, 'admin/config/workflow/rules/reaction/manage/%', 'admin/config/workflow/rules/reaction/manage/%', '', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 0, 6, 0, 1, 8, 62, 385, 428, 466, 0, 0, 0, 0),
('management', 467, 434, 'admin/commerce/config/payment-methods/manage/%/execute', 'admin/commerce/config/payment-methods/manage/%/execute', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 467, 0, 0, 0, 0),
('management', 468, 434, 'admin/commerce/config/payment-methods/manage/%/export', 'admin/commerce/config/payment-methods/manage/%/export', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 468, 0, 0, 0, 0),
('management', 474, 433, 'admin/commerce/orders/%/payment/%/delete', 'admin/commerce/orders/%/payment/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 325, 360, 364, 425, 433, 474, 0, 0, 0),
('management', 476, 434, 'admin/commerce/config/payment-methods/manage/%/%', 'admin/commerce/config/payment-methods/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 476, 0, 0, 0, 0),
('management', 477, 421, 'admin/config/regional/date-time/locale/%/edit', 'admin/config/regional/date-time/locale/%/edit', 'Localize date formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a22436f6e666967757265206461746520666f726d61747320666f722065616368206c6f63616c65223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 49, 71, 421, 477, 0, 0, 0, 0),
('management', 478, 421, 'admin/config/regional/date-time/locale/%/reset', 'admin/config/regional/date-time/locale/%/reset', 'Reset date formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a225265736574206c6f63616c697a6564206461746520666f726d61747320746f20676c6f62616c2064656661756c7473223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 49, 71, 421, 478, 0, 0, 0, 0),
('management', 479, 433, 'admin/commerce/orders/%/payment/%/view', 'admin/commerce/orders/%/payment/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 360, 364, 425, 433, 479, 0, 0, 0),
('management', 486, 463, 'admin/commerce/config/checkout/rules/manage/%/clone', 'admin/commerce/config/checkout/rules/manage/%/clone', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 486, 0, 0, 0),
('management', 487, 464, 'admin/commerce/config/product-pricing/rules/manage/%/clone', 'admin/commerce/config/product-pricing/rules/manage/%/clone', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 487, 0, 0, 0),
('management', 488, 465, 'admin/config/workflow/rules/components/manage/%/clone', 'admin/config/workflow/rules/components/manage/%/clone', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 488, 0, 0, 0),
('management', 489, 466, 'admin/config/workflow/rules/reaction/manage/%/clone', 'admin/config/workflow/rules/reaction/manage/%/clone', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 489, 0, 0, 0),
('management', 490, 463, 'admin/commerce/config/checkout/rules/manage/%/execute', 'admin/commerce/config/checkout/rules/manage/%/execute', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 490, 0, 0, 0),
('management', 491, 464, 'admin/commerce/config/product-pricing/rules/manage/%/execute', 'admin/commerce/config/product-pricing/rules/manage/%/execute', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 491, 0, 0, 0),
('management', 492, 465, 'admin/config/workflow/rules/components/manage/%/execute', 'admin/config/workflow/rules/components/manage/%/execute', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 492, 0, 0, 0),
('management', 493, 466, 'admin/config/workflow/rules/reaction/manage/%/execute', 'admin/config/workflow/rules/reaction/manage/%/execute', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 493, 0, 0, 0),
('management', 494, 463, 'admin/commerce/config/checkout/rules/manage/%/export', 'admin/commerce/config/checkout/rules/manage/%/export', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 494, 0, 0, 0),
('management', 495, 464, 'admin/commerce/config/product-pricing/rules/manage/%/export', 'admin/commerce/config/product-pricing/rules/manage/%/export', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 495, 0, 0, 0),
('management', 496, 465, 'admin/config/workflow/rules/components/manage/%/export', 'admin/config/workflow/rules/components/manage/%/export', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 496, 0, 0, 0),
('management', 497, 466, 'admin/config/workflow/rules/reaction/manage/%/export', 'admin/config/workflow/rules/reaction/manage/%/export', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 497, 0, 0, 0),
('management', 498, 463, 'admin/commerce/config/checkout/rules/manage/%/%', 'admin/commerce/config/checkout/rules/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 498, 0, 0, 0),
('management', 499, 464, 'admin/commerce/config/product-pricing/rules/manage/%/%', 'admin/commerce/config/product-pricing/rules/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 499, 0, 0, 0),
('management', 500, 465, 'admin/config/workflow/rules/components/manage/%/%', 'admin/config/workflow/rules/components/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 500, 0, 0, 0),
('management', 501, 466, 'admin/config/workflow/rules/reaction/manage/%/%', 'admin/config/workflow/rules/reaction/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 501, 0, 0, 0),
('management', 502, 434, 'admin/commerce/config/payment-methods/manage/%/delete/event', 'admin/commerce/config/payment-methods/manage/%/delete/event', 'Remove event', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2252656d6f766520616e206576656e742066726f6d2061207265616374696f6e2072756c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 502, 0, 0, 0, 0),
('management', 503, 434, 'admin/commerce/config/payment-methods/manage/%/add/event', 'admin/commerce/config/payment-methods/manage/%/add/event', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 503, 0, 0, 0, 0),
('management', 504, 434, 'admin/commerce/config/payment-methods/manage/%/delete/%', 'admin/commerce/config/payment-methods/manage/%/delete/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 504, 0, 0, 0, 0),
('management', 505, 434, 'admin/commerce/config/payment-methods/manage/%/edit/%', 'admin/commerce/config/payment-methods/manage/%/edit/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 505, 0, 0, 0, 0),
('management', 506, 434, 'admin/commerce/config/payment-methods/manage/%/add/%', 'admin/commerce/config/payment-methods/manage/%/add/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 381, 434, 506, 0, 0, 0, 0),
('management', 515, 463, 'admin/commerce/config/checkout/rules/manage/%/delete/event', 'admin/commerce/config/checkout/rules/manage/%/delete/event', 'Remove event', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2252656d6f766520616e206576656e742066726f6d2061207265616374696f6e2072756c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 515, 0, 0, 0);
INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 516, 464, 'admin/commerce/config/product-pricing/rules/manage/%/delete/event', 'admin/commerce/config/product-pricing/rules/manage/%/delete/event', 'Remove event', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2252656d6f766520616e206576656e742066726f6d2061207265616374696f6e2072756c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 516, 0, 0, 0),
('management', 517, 465, 'admin/config/workflow/rules/components/manage/%/delete/event', 'admin/config/workflow/rules/components/manage/%/delete/event', 'Remove event', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2252656d6f766520616e206576656e742066726f6d2061207265616374696f6e2072756c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 517, 0, 0, 0),
('management', 518, 466, 'admin/config/workflow/rules/reaction/manage/%/delete/event', 'admin/config/workflow/rules/reaction/manage/%/delete/event', 'Remove event', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2252656d6f766520616e206576656e742066726f6d2061207265616374696f6e2072756c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 518, 0, 0, 0),
('management', 519, 463, 'admin/commerce/config/checkout/rules/manage/%/add/event', 'admin/commerce/config/checkout/rules/manage/%/add/event', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 519, 0, 0, 0),
('management', 520, 464, 'admin/commerce/config/product-pricing/rules/manage/%/add/event', 'admin/commerce/config/product-pricing/rules/manage/%/add/event', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 520, 0, 0, 0),
('management', 521, 465, 'admin/config/workflow/rules/components/manage/%/add/event', 'admin/config/workflow/rules/components/manage/%/add/event', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 521, 0, 0, 0),
('management', 522, 466, 'admin/config/workflow/rules/reaction/manage/%/add/event', 'admin/config/workflow/rules/reaction/manage/%/add/event', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 522, 0, 0, 0),
('management', 523, 463, 'admin/commerce/config/checkout/rules/manage/%/delete/%', 'admin/commerce/config/checkout/rules/manage/%/delete/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 523, 0, 0, 0),
('management', 524, 464, 'admin/commerce/config/product-pricing/rules/manage/%/delete/%', 'admin/commerce/config/product-pricing/rules/manage/%/delete/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 524, 0, 0, 0),
('management', 525, 465, 'admin/config/workflow/rules/components/manage/%/delete/%', 'admin/config/workflow/rules/components/manage/%/delete/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 525, 0, 0, 0),
('management', 526, 466, 'admin/config/workflow/rules/reaction/manage/%/delete/%', 'admin/config/workflow/rules/reaction/manage/%/delete/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 526, 0, 0, 0),
('management', 527, 463, 'admin/commerce/config/checkout/rules/manage/%/edit/%', 'admin/commerce/config/checkout/rules/manage/%/edit/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 527, 0, 0, 0),
('management', 528, 464, 'admin/commerce/config/product-pricing/rules/manage/%/edit/%', 'admin/commerce/config/product-pricing/rules/manage/%/edit/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 528, 0, 0, 0),
('management', 529, 465, 'admin/config/workflow/rules/components/manage/%/edit/%', 'admin/config/workflow/rules/components/manage/%/edit/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 529, 0, 0, 0),
('management', 530, 466, 'admin/config/workflow/rules/reaction/manage/%/edit/%', 'admin/config/workflow/rules/reaction/manage/%/edit/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 530, 0, 0, 0),
('management', 531, 463, 'admin/commerce/config/checkout/rules/manage/%/add/%', 'admin/commerce/config/checkout/rules/manage/%/add/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 370, 403, 463, 531, 0, 0, 0),
('management', 532, 464, 'admin/commerce/config/product-pricing/rules/manage/%/add/%', 'admin/commerce/config/product-pricing/rules/manage/%/add/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 382, 419, 464, 532, 0, 0, 0),
('management', 533, 465, 'admin/config/workflow/rules/components/manage/%/add/%', 'admin/config/workflow/rules/components/manage/%/add/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 404, 465, 533, 0, 0, 0),
('management', 534, 466, 'admin/config/workflow/rules/reaction/manage/%/add/%', 'admin/config/workflow/rules/reaction/manage/%/add/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 62, 385, 428, 466, 534, 0, 0, 0),
('navigation', 535, 0, 'booking', 'booking', 'Create your booking', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 535, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 536, 0, 'bookings', 'bookings', 'Review your reservation', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 536, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 537, 0, 'tracker', 'tracker', 'Recent content', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 1, 1, 0, 537, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 538, 537, 'tracker/all', 'tracker/all', 'All recent content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 537, 538, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 539, 537, 'tracker/%', 'tracker/%', 'My recent content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 537, 539, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 540, 1, 'admin/rooms', 'admin/rooms', 'Rooms', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31373a2241646d696e697374657220526f6f6d732e223b7d7d, 'system', 0, 0, 1, 0, -7, 2, 0, 1, 540, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 541, 540, 'admin/rooms/units', 'admin/rooms/units', 'Bookable Units', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3234393a2243726561746520616e642061646d696e697374657220756e69747320746861742063616e20626520626f6f6b65642c207375636820617320726f6f6d7320666f72206120686f74656c2e20426f6f6b61626c6520756e697473206861766520617661696c6162696c69747920616e642070726963696e6720696e666f726d6174696f6e20617474616368656420746f207468656d2062792074686520526f6f6d73206d6f64756c6520616e642063616e2068617665206578747261206669656c64732061646465642076696120746865207374616e646172642044727570616c204669656c64204150492066756e6374696f6e616c6974792e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 540, 541, 0, 0, 0, 0, 0, 0, 0),
('management', 542, 540, 'admin/rooms/bookings', 'admin/rooms/bookings', 'Bookings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3135313a2241206c697374206f6620616c6c20626f6f6b696e67732e20426f6f6b696e67732063616e20626520637265617465642c20656469746564206f722064656c65746564206d616e75616c6c79206f722063616e206265206372656174656420666f6c6c6f77696e6720612070757263686173652066726f6d206120636c69656e74207573696e672044727570616c20436f6d6d657263652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 540, 542, 0, 0, 0, 0, 0, 0, 0),
('management', 543, 540, 'admin/rooms/config', 'admin/rooms/config', 'Configuration', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35393a22436f6e6669677572652073657474696e677320616e6420627573696e6573732072756c657320666f7220526f6f6d73206d616e6167656d656e742e223b7d7d, 'system', 0, 0, 1, 0, 10, 3, 0, 1, 540, 543, 0, 0, 0, 0, 0, 0, 0),
('management', 544, 8, 'admin/config/date', 'admin/config/date', 'Date API', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a2253657474696e677320666f72206d6f64756c65732074686520757365207468652044617465204150492e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 544, 0, 0, 0, 0, 0, 0, 0),
('navigation', 546, 16, 'user/%/track', 'user/%/track', 'Track', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 16, 546, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 547, 6, 'node/add/unit-description', 'node/add/unit-description', 'Unit Description', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a22426f6f6b61626c6520556e6974204465736372697074696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 547, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 548, 20, 'admin/structure/views', 'admin/structure/views', 'Views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33353a224d616e61676520637573746f6d697a6564206c69737473206f6620636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 20, 548, 0, 0, 0, 0, 0, 0, 0),
('management', 549, 158, 'admin/help/date', 'admin/help/date', 'date', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 549, 0, 0, 0, 0, 0, 0, 0),
('management', 550, 158, 'admin/help/pathauto', 'admin/help/pathauto', 'pathauto', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 550, 0, 0, 0, 0, 0, 0, 0),
('management', 551, 158, 'admin/help/superfish', 'admin/help/superfish', 'superfish', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 551, 0, 0, 0, 0, 0, 0, 0),
('management', 552, 158, 'admin/help/token', 'admin/help/token', 'token', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 552, 0, 0, 0, 0, 0, 0, 0),
('management', 553, 158, 'admin/help/tracker', 'admin/help/tracker', 'tracker', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 553, 0, 0, 0, 0, 0, 0, 0),
('management', 554, 158, 'admin/help/views_accordion', 'admin/help/views_accordion', 'views_accordion', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 554, 0, 0, 0, 0, 0, 0, 0),
('management', 555, 158, 'admin/help/views_slideshow', 'admin/help/views_slideshow', 'views_slideshow', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 555, 0, 0, 0, 0, 0, 0, 0),
('management', 556, 158, 'admin/help/views_slideshow_cycle', 'admin/help/views_slideshow_cycle', 'views_slideshow_cycle', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 556, 0, 0, 0, 0, 0, 0, 0),
('management', 557, 541, 'admin/rooms/units/add', 'admin/rooms/units/add', 'Add a Bookable Unit', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a224372656174652061206e657720626f6f6b61626c6520756e69742e223b7d7d, 'system', 0, 0, 1, 0, 20, 4, 0, 1, 540, 541, 557, 0, 0, 0, 0, 0, 0),
('management', 558, 542, 'admin/rooms/bookings/add', 'admin/rooms/bookings/add', 'Add a Booking', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31373a224164642061206e657720426f6f6b696e67223b7d7d, 'system', 0, 0, 1, 0, 20, 4, 0, 1, 540, 542, 558, 0, 0, 0, 0, 0, 0),
('management', 559, 541, 'admin/rooms/units/unit-types', 'admin/rooms/units/unit-types', 'Bookable Unit Types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38323a224d616e61676520756e69742074797065732c20696e636c7564696e6720616464696e6720616e642072656d6f76696e67206669656c647320616e642074686520646973706c6179206f66206669656c64732e223b7d7d, 'system', -1, 0, 1, 0, 3, 4, 0, 1, 540, 541, 559, 0, 0, 0, 0, 0, 0),
('management', 560, 543, 'admin/rooms/config/bookings', 'admin/rooms/config/bookings', 'Booking Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35313a22436f6e6669677572652073657474696e677320616e6420627573696e6573732072756c657320666f7220426f6f6b696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 540, 543, 560, 0, 0, 0, 0, 0, 0),
('management', 561, 542, 'admin/rooms/bookings/booking-types', 'admin/rooms/bookings/booking-types', 'Booking Types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38353a224d616e61676520626f6f6b696e672074797065732c20696e636c7564696e6720616464696e6720616e642072656d6f76696e67206669656c647320616e642074686520646973706c6179206f66206669656c64732e223b7d7d, 'system', -1, 0, 1, 0, 3, 4, 0, 1, 540, 542, 561, 0, 0, 0, 0, 0, 0),
('management', 562, 544, 'admin/config/date/date_popup', 'admin/config/date/date_popup', 'Date Popup', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22436f6e66696775726520746865204461746520506f7075702073657474696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 544, 562, 0, 0, 0, 0, 0, 0),
('management', 563, 548, 'admin/structure/views/import', 'admin/structure/views/import', 'Import', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 548, 563, 0, 0, 0, 0, 0, 0),
('management', 564, 548, 'admin/structure/views/list', 'admin/structure/views/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 20, 548, 564, 0, 0, 0, 0, 0, 0),
('management', 565, 548, 'admin/structure/views/settings', 'admin/structure/views/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 548, 565, 0, 0, 0, 0, 0, 0),
('management', 566, 58, 'admin/config/user-interface/superfish', 'admin/config/user-interface/superfish', 'Superfish', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22436f6e66696775726520537570657266697368204d656e7573223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 58, 566, 0, 0, 0, 0, 0, 0),
('management', 567, 548, 'admin/structure/views/add', 'admin/structure/views/add', 'Add new view', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 548, 567, 0, 0, 0, 0, 0, 0),
('management', 568, 548, 'admin/structure/views/add-template', 'admin/structure/views/add-template', 'Add view from template', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 20, 548, 568, 0, 0, 0, 0, 0, 0),
('management', 569, 541, 'admin/rooms/units/bulk_unit_management', 'admin/rooms/units/bulk_unit_management', 'Bulk availability management', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 4, 0, 1, 540, 541, 569, 0, 0, 0, 0, 0, 0),
('management', 570, 541, 'admin/rooms/units/bulk_pricing_management', 'admin/rooms/units/bulk_pricing_management', 'Bulk pricing management', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 4, 0, 1, 540, 541, 570, 0, 0, 0, 0, 0, 0),
('navigation', 572, 546, 'user/%/track/content', 'user/%/track/content', 'Track content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 16, 546, 572, 0, 0, 0, 0, 0, 0, 0),
('management', 573, 561, 'admin/rooms/bookings/booking-types/add', 'admin/rooms/bookings/booking-types/add', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 540, 542, 561, 573, 0, 0, 0, 0, 0),
('management', 574, 559, 'admin/rooms/units/unit-types/add', 'admin/rooms/units/unit-types/add', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 540, 541, 559, 574, 0, 0, 0, 0, 0),
('management', 575, 561, 'admin/rooms/bookings/booking-types/import', 'admin/rooms/bookings/booking-types/import', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 540, 542, 561, 575, 0, 0, 0, 0, 0),
('management', 576, 559, 'admin/rooms/units/unit-types/import', 'admin/rooms/units/unit-types/import', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 540, 541, 559, 576, 0, 0, 0, 0, 0),
('management', 577, 558, 'admin/rooms/bookings/add/standard_booking', 'admin/rooms/bookings/add/standard_booking', 'Add @booking_type', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 540, 542, 558, 577, 0, 0, 0, 0, 0),
('management', 578, 565, 'admin/structure/views/settings/advanced', 'admin/structure/views/settings/advanced', 'Advanced', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 20, 548, 565, 578, 0, 0, 0, 0, 0),
('management', 579, 565, 'admin/structure/views/settings/basic', 'admin/structure/views/settings/basic', 'Basic', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 565, 579, 0, 0, 0, 0, 0),
('management', 580, 199, 'admin/config/search/path/update_bulk', 'admin/config/search/path/update_bulk', 'Bulk update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 30, 5, 0, 1, 8, 51, 199, 580, 0, 0, 0, 0, 0),
('management', 581, 368, 'admin/commerce/products/add/rooms-product', 'admin/commerce/products/add/rooms-product', 'Create !name', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a2250726f647563747320746861742061726520626f6f6b61626c65207769746820526f6f6d732e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 361, 368, 581, 0, 0, 0, 0, 0),
('management', 582, 199, 'admin/config/search/path/delete_bulk', 'admin/config/search/path/delete_bulk', 'Delete aliases', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 40, 5, 0, 1, 8, 51, 199, 582, 0, 0, 0, 0, 0),
('management', 583, 561, 'admin/rooms/bookings/booking-types/list', 'admin/rooms/bookings/booking-types/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 540, 542, 561, 583, 0, 0, 0, 0, 0),
('management', 584, 559, 'admin/rooms/units/unit-types/list', 'admin/rooms/units/unit-types/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 540, 541, 559, 584, 0, 0, 0, 0, 0),
('management', 585, 199, 'admin/config/search/path/patterns', 'admin/config/search/path/patterns', 'Patterns', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 8, 51, 199, 585, 0, 0, 0, 0, 0),
('management', 586, 378, 'admin/commerce/config/line-items/product', 'admin/commerce/config/line-items/product', 'Product', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 326, 378, 586, 0, 0, 0, 0, 0),
('management', 587, 378, 'admin/commerce/config/line-items/rooms-booking', 'admin/commerce/config/line-items/rooms-booking', 'Rooms Booking', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 326, 378, 587, 0, 0, 0, 0, 0),
('management', 588, 383, 'admin/commerce/products/types/rooms-product', 'admin/commerce/products/types/rooms-product', 'Rooms product', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 325, 361, 383, 588, 0, 0, 0, 0, 0),
('management', 589, 199, 'admin/config/search/path/settings', 'admin/config/search/path/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 8, 51, 199, 589, 0, 0, 0, 0, 0),
('management', 590, 542, 'admin/rooms/bookings/booking/%', 'admin/rooms/bookings/booking/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 540, 542, 590, 0, 0, 0, 0, 0, 0),
('management', 591, 541, 'admin/rooms/units/unit/%', 'admin/rooms/units/unit/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 540, 541, 591, 0, 0, 0, 0, 0, 0),
('management', 592, 548, 'admin/structure/views/view/%', 'admin/structure/views/view/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 548, 592, 0, 0, 0, 0, 0, 0),
('management', 593, 592, 'admin/structure/views/view/%/break-lock', 'admin/structure/views/view/%/break-lock', 'Break lock', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 592, 593, 0, 0, 0, 0, 0),
('management', 594, 590, 'admin/rooms/bookings/booking/%/delete', 'admin/rooms/bookings/booking/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 540, 542, 590, 594, 0, 0, 0, 0, 0),
('management', 595, 591, 'admin/rooms/units/unit/%/delete', 'admin/rooms/units/unit/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 540, 541, 591, 595, 0, 0, 0, 0, 0),
('management', 596, 590, 'admin/rooms/bookings/booking/%/edit', 'admin/rooms/bookings/booking/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 540, 542, 590, 596, 0, 0, 0, 0, 0),
('management', 597, 591, 'admin/rooms/units/unit/%/edit', 'admin/rooms/units/unit/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 540, 541, 591, 597, 0, 0, 0, 0, 0),
('management', 598, 592, 'admin/structure/views/view/%/edit', 'admin/structure/views/view/%/edit', 'Edit view', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 20, 548, 592, 598, 0, 0, 0, 0, 0),
('management', 599, 591, 'admin/rooms/units/unit/%/availability', 'admin/rooms/units/unit/%/availability', 'Manage Availability', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 540, 541, 591, 599, 0, 0, 0, 0, 0),
('management', 600, 591, 'admin/rooms/units/unit/%/pricing', 'admin/rooms/units/unit/%/pricing', 'Manage Pricing', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 30, 5, 0, 1, 540, 541, 591, 600, 0, 0, 0, 0, 0),
('management', 601, 586, 'admin/commerce/config/line-items/product/display', 'admin/commerce/config/line-items/product/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 325, 326, 378, 586, 601, 0, 0, 0, 0),
('management', 602, 587, 'admin/commerce/config/line-items/rooms-booking/display', 'admin/commerce/config/line-items/rooms-booking/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 325, 326, 378, 587, 602, 0, 0, 0, 0),
('management', 603, 588, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 325, 361, 383, 588, 603, 0, 0, 0, 0),
('management', 604, 586, 'admin/commerce/config/line-items/product/fields', 'admin/commerce/config/line-items/product/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 325, 326, 378, 586, 604, 0, 0, 0, 0),
('management', 605, 587, 'admin/commerce/config/line-items/rooms-booking/fields', 'admin/commerce/config/line-items/rooms-booking/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 325, 326, 378, 587, 605, 0, 0, 0, 0),
('management', 606, 588, 'admin/commerce/products/types/rooms-product/fields', 'admin/commerce/products/types/rooms-product/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 325, 361, 383, 588, 606, 0, 0, 0, 0),
('management', 610, 592, 'admin/structure/views/view/%/clone', 'admin/structure/views/view/%/clone', 'Clone', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 592, 610, 0, 0, 0, 0, 0),
('management', 611, 592, 'admin/structure/views/view/%/delete', 'admin/structure/views/view/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 592, 611, 0, 0, 0, 0, 0),
('management', 612, 561, 'admin/rooms/bookings/booking-types/manage/%', 'admin/rooms/bookings/booking-types/manage/%', 'Edit', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 540, 542, 561, 612, 0, 0, 0, 0, 0),
('management', 613, 559, 'admin/rooms/units/unit-types/manage/%', 'admin/rooms/units/unit-types/manage/%', 'Edit', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 540, 541, 559, 613, 0, 0, 0, 0, 0),
('management', 614, 592, 'admin/structure/views/view/%/export', 'admin/structure/views/view/%/export', 'Export', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 592, 614, 0, 0, 0, 0, 0),
('management', 615, 592, 'admin/structure/views/view/%/revert', 'admin/structure/views/view/%/revert', 'Revert', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 592, 615, 0, 0, 0, 0, 0),
('management', 634, 592, 'admin/structure/views/view/%/preview/%', 'admin/structure/views/view/%/preview/%', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 548, 592, 634, 0, 0, 0, 0, 0),
('management', 635, 548, 'admin/structure/views/nojs/preview/%/%', 'admin/structure/views/nojs/preview/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 548, 635, 0, 0, 0, 0, 0, 0),
('management', 636, 548, 'admin/structure/views/ajax/preview/%/%', 'admin/structure/views/ajax/preview/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 20, 548, 636, 0, 0, 0, 0, 0, 0),
('management', 638, 612, 'admin/rooms/bookings/booking-types/manage/%/%', 'admin/rooms/bookings/booking-types/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 540, 542, 561, 612, 638, 0, 0, 0, 0),
('management', 639, 613, 'admin/rooms/units/unit-types/manage/%/%', 'admin/rooms/units/unit-types/manage/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 540, 541, 559, 613, 639, 0, 0, 0, 0),
('management', 641, 612, 'admin/rooms/bookings/booking-types/manage/%/clone', 'admin/rooms/bookings/booking-types/manage/%/clone', 'Clone', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 540, 542, 561, 612, 641, 0, 0, 0, 0),
('management', 642, 613, 'admin/rooms/units/unit-types/manage/%/clone', 'admin/rooms/units/unit-types/manage/%/clone', 'Clone', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 540, 541, 559, 613, 642, 0, 0, 0, 0),
('management', 643, 612, 'admin/rooms/bookings/booking-types/manage/%/edit', 'admin/rooms/bookings/booking-types/manage/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 540, 542, 561, 612, 643, 0, 0, 0, 0),
('management', 644, 613, 'admin/rooms/units/unit-types/manage/%/edit', 'admin/rooms/units/unit-types/manage/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 540, 541, 559, 613, 644, 0, 0, 0, 0),
('management', 665, 541, 'admin/rooms/units/list', 'admin/rooms/units/list', 'Bookable Units List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37353a2241206c697374206f662074686520756e6974732028726f6f6d732c206574632920746861742063616e20626520626f6f6b656420666f7220796f7572206163636f6d6d6f646174696f6e2e223b7d7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 540, 541, 665, 0, 0, 0, 0, 0, 0),
('management', 666, 542, 'admin/rooms/bookings/list', 'admin/rooms/bookings/list', 'Bookings List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31363a224c697374206f6620626f6f6b696e6773223b7d7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 540, 542, 666, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 774, 0, 'admin/structure/block', 'admin/structure/block', 'Blocks', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -49, 1, 0, 774, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 775, 0, 'admin/structure/views', 'admin/structure/views', 'Views', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -48, 1, 0, 775, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 776, 0, 'admin/rooms/units', 'admin/rooms/units', 'Bookable Units', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -47, 1, 0, 776, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 777, 557, 'admin/rooms/units/add/basic_suite', 'admin/rooms/units/add/basic_suite', 'Add @unit_type_label unit', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 540, 541, 557, 777, 0, 0, 0, 0, 0),
('management', 787, 102, 'admin/structure/block/list/bartik/add', 'admin/structure/block/list/bartik/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 20, 28, 102, 787, 0, 0, 0, 0, 0),
('management', 788, 557, 'admin/rooms/units/add/deluxe_suite', 'admin/rooms/units/add/deluxe_suite', 'Add @unit_type_label unit', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 540, 541, 557, 788, 0, 0, 0, 0, 0),
('management', 789, 557, 'admin/rooms/units/add/luxury_suite', 'admin/rooms/units/add/luxury_suite', 'Add @unit_type_label unit', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 540, 541, 557, 789, 0, 0, 0, 0, 0),
('management', 790, 557, 'admin/rooms/units/add/royal_suite', 'admin/rooms/units/add/royal_suite', 'Add @unit_type_label unit', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 540, 541, 557, 790, 0, 0, 0, 0, 0),
('shortcut-set-1', 791, 0, 'admin/structure/types', 'admin/structure/types', 'Content types', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -46, 1, 0, 791, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 792, 6, 'node/add/promotions', 'node/add/promotions', 'Promotions', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 792, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 793, 6, 'node/add/news-events', 'node/add/news-events', 'News & Events', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 793, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 794, 6, 'node/add/services-facilities', 'node/add/services-facilities', 'Services & Facilities', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 794, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 795, 6, 'node/add/photo-galleries', 'node/add/photo-galleries', 'Photo Galleries', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 795, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 911, 0, 'node/1', 'node/%', 'Support', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -47, 1, 1, 911, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 912, 45, 'admin/structure/menu/manage/menu-top-menu', 'admin/structure/menu/manage/%', 'Top Menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 20, 45, 912, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 913, 0, 'user/login', 'user/login', 'Login', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -50, 1, 1, 913, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-top-menu', 914, 0, 'user/logout', 'user/logout', 'Logout', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -49, 1, 1, 914, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 915, 0, 'news-events', 'news-events', 'News & Events', 0x613a303a7b7d, 'system', 0, 0, 0, 0, -48, 1, 1, 915, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 916, 0, 'photo-galleries', 'photo-galleries', 'Photo Galleries', 0x613a303a7b7d, 'system', 0, 0, 1, 0, -47, 1, 1, 916, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 917, 0, 'promotions', 'promotions', 'Promotions', 0x613a303a7b7d, 'system', 0, 0, 0, 0, -46, 1, 1, 917, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 918, 0, 'services-facilities', 'services-facilities', 'Services & Facilities', 0x613a303a7b7d, 'system', 0, 0, 0, 0, -45, 1, 1, 918, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 919, 0, 'accommodation', 'accommodation', 'Accommodation', 0x613a303a7b7d, 'system', 0, 0, 0, 0, -49, 1, 1, 919, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 920, 0, 'admin/structure/menu', 'admin/structure/menu', 'Menus', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -45, 1, 0, 920, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 921, 0, 'admin/appearance/settings/hotel', 'admin/appearance/settings/hotel', 'Hotel', 0x613a303a7b7d, 'menu', 1, 0, 0, 0, -44, 1, 0, 921, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 924, 0, 'admin/config/development/performance', 'admin/config/development/performance', 'Performance', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -43, 1, 0, 924, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 925, 916, 'node/19', 'node/%', 'Room', 0x613a313a7b733a31303a2261747472696275746573223b613a303a7b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 916, 925, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 926, 916, 'node/18', 'node/%', 'Restaurant', 0x613a313a7b733a31303a2261747472696275746573223b613a303a7b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 916, 926, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 927, 916, 'node/10', 'node/%', 'Wedding', 0x613a313a7b733a31303a2261747472696275746573223b613a303a7b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 916, 927, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 928, 916, 'node/9', 'node/%', 'Meeting', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 916, 928, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 1044, 18, 'admin/reports/views-plugins', 'admin/reports/views-plugins', 'Views plugins', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a224f76657276696577206f6620706c7567696e73207573656420696e20616c6c2076696577732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 1044, 0, 0, 0, 0, 0, 0, 0),
('management', 1045, 40, 'admin/reports/fields/list', 'admin/reports/fields/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 18, 40, 1045, 0, 0, 0, 0, 0, 0),
('management', 1046, 40, 'admin/reports/fields/views-fields', 'admin/reports/fields/views-fields', 'Used in views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a224f76657276696577206f66206669656c6473207573656420696e20616c6c2076696577732e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 18, 40, 1046, 0, 0, 0, 0, 0, 0),
('management', 1047, 433, 'admin/commerce/orders/%/payment/%/paypal-wpp-capture', 'admin/commerce/orders/%/payment/%/paypal-wpp-capture', 'Capture', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 7, 0, 1, 325, 360, 364, 425, 433, 1047, 0, 0, 0),
('management', 1163, 158, 'admin/help/commerce_line_item_ui', 'admin/help/commerce_line_item_ui', 'commerce_line_item_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 1163, 0, 0, 0, 0, 0, 0, 0),
('management', 1166, 158, 'admin/help/jquery_update', 'admin/help/jquery_update', 'jquery_update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 158, 1166, 0, 0, 0, 0, 0, 0, 0),
('management', 1167, 543, 'admin/rooms/config/children', 'admin/rooms/config/children', 'Children Discount Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a22436f6e6669677572652073657474696e677320666f72206368696c6472656e20646973636f756e74732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 540, 543, 1167, 0, 0, 0, 0, 0, 0),
('management', 1168, 33, 'admin/config/content/locationmap', 'admin/config/content/locationmap', 'Location Map', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32333a22436f6e666967757265204c6f636174696f6e204d61702e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 33, 1168, 0, 0, 0, 0, 0, 0),
('management', 1169, 37, 'admin/config/development/jquery_update', 'admin/config/development/jquery_update', 'jQuery update', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38333a22436f6e6669677572652073657474696e67732072656c6174656420746f20746865206a517565727920757067726164652c20746865206c696272617279207061746820616e6420636f6d7072657373696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 37, 1169, 0, 0, 0, 0, 0, 0),
('management', 1170, 364, 'admin/commerce/orders/%/revisions', 'admin/commerce/orders/%/revisions', 'Revisions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32393a2256696577207265766973696f6e73206f662074686973206f726465722e223b7d7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 325, 360, 364, 1170, 0, 0, 0, 0, 0),
('management', 1171, 366, 'admin/commerce/products/%/revisions', 'admin/commerce/products/%/revisions', 'Revisions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a2256696577207265766973696f6e73206f6620746869732070726f647563742e223b7d7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 325, 361, 366, 1171, 0, 0, 0, 0, 0),
('management', 1172, 413, 'admin/commerce/orders/%/edit/refresh', 'admin/commerce/orders/%/edit/refresh', 'Apply pricing rules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38393a224578656375746573207468652063617274206f726465722072656672657368207573656420746f206170706c7920616c6c2063757272656e742070726963696e672072756c6573206f6e207468652066726f6e7420656e642e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 325, 360, 364, 413, 1172, 0, 0, 0, 0),
('management', 1173, 413, 'admin/commerce/orders/%/edit/checkout', 'admin/commerce/orders/%/edit/checkout', 'Simulate checkout completion', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36303a224469726563746c7920696e766f6b65732074686520636865636b6f757420636f6d706c6574696f6e2072756c6573206f6e20746865206f726465722e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 325, 360, 364, 413, 1173, 0, 0, 0, 0),
('management', 1291, 543, 'admin/rooms/config/terminology', 'admin/rooms/config/terminology', 'Rooms Terminology', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a224368616e676520526f6f6d73205465726d696e6f6c6f6779223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 540, 543, 1291, 0, 0, 0, 0, 0, 0),
('management', 1292, 71, 'admin/config/regional/date-time/date-views', 'admin/config/regional/date-time/date-views', 'Date views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22436f6e6669677572652073657474696e677320666f7220646174652076696577732e223b7d7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 49, 71, 1292, 0, 0, 0, 0, 0),
('management', 1293, 591, 'admin/rooms/units/unit/%/view', 'admin/rooms/units/unit/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 540, 541, 591, 1293, 0, 0, 0, 0, 0),
('management', 1411, 380, 'admin/commerce/config/order/display', 'admin/commerce/config/order/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 325, 326, 380, 1411, 0, 0, 0, 0, 0),
('management', 1412, 200, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 20, 162, 200, 1412, 0, 0, 0, 0, 0),
('management', 1413, 63, 'admin/config/people/accounts/display', 'admin/config/people/accounts/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 46, 63, 1413, 0, 0, 0, 0, 0),
('management', 1414, 380, 'admin/commerce/config/order/fields', 'admin/commerce/config/order/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 325, 326, 380, 1414, 0, 0, 0, 0, 0),
('management', 1415, 200, 'admin/structure/taxonomy/%/fields', 'admin/structure/taxonomy/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 20, 162, 200, 1415, 0, 0, 0, 0, 0),
('management', 1416, 63, 'admin/config/people/accounts/fields', 'admin/config/people/accounts/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 8, 46, 63, 1416, 0, 0, 0, 0, 0),
('management', 1417, 1411, 'admin/commerce/config/order/display/administrator', 'admin/commerce/config/order/display/administrator', 'Administrator', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 325, 326, 380, 1411, 1417, 0, 0, 0, 0),
('management', 1418, 1411, 'admin/commerce/config/order/display/customer', 'admin/commerce/config/order/display/customer', 'Customer', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 325, 326, 380, 1411, 1418, 0, 0, 0, 0),
('management', 1419, 1411, 'admin/commerce/config/order/display/default', 'admin/commerce/config/order/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 325, 326, 380, 1411, 1419, 0, 0, 0, 0),
('management', 1420, 1412, 'admin/structure/taxonomy/%/display/default', 'admin/structure/taxonomy/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 20, 162, 200, 1412, 1420, 0, 0, 0, 0),
('management', 1421, 1413, 'admin/config/people/accounts/display/default', 'admin/config/people/accounts/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 46, 63, 1413, 1421, 0, 0, 0, 0),
('management', 1422, 105, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 20, 34, 105, 1422, 0, 0, 0, 0, 0),
('management', 1423, 105, 'admin/structure/types/manage/%/fields', 'admin/structure/types/manage/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 20, 34, 105, 1423, 0, 0, 0, 0, 0),
('management', 1424, 1412, 'admin/structure/taxonomy/%/display/full', 'admin/structure/taxonomy/%/display/full', 'Taxonomy term page', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 20, 162, 200, 1412, 1424, 0, 0, 0, 0),
('management', 1425, 1411, 'admin/commerce/config/order/display/token', 'admin/commerce/config/order/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 325, 326, 380, 1411, 1425, 0, 0, 0, 0),
('management', 1426, 1412, 'admin/structure/taxonomy/%/display/token', 'admin/structure/taxonomy/%/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 20, 162, 200, 1412, 1426, 0, 0, 0, 0),
('management', 1427, 1413, 'admin/config/people/accounts/display/token', 'admin/config/people/accounts/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 8, 46, 63, 1413, 1427, 0, 0, 0, 0),
('management', 1428, 1413, 'admin/config/people/accounts/display/full', 'admin/config/people/accounts/display/full', 'User account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 63, 1413, 1428, 0, 0, 0, 0),
('management', 1429, 1414, 'admin/commerce/config/order/fields/%', 'admin/commerce/config/order/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 325, 326, 380, 1414, 1429, 0, 0, 0, 0),
('management', 1430, 1415, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 20, 162, 200, 1415, 1430, 0, 0, 0, 0),
('management', 1431, 1416, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 46, 63, 1416, 1431, 0, 0, 0, 0),
('management', 1432, 455, 'admin/commerce/products/types/product/display/full', 'admin/commerce/products/types/product/display/full', 'Admin display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 361, 383, 427, 455, 1432, 0, 0, 0),
('management', 1433, 603, 'admin/commerce/products/types/rooms-product/display/full', 'admin/commerce/products/types/rooms-product/display/full', 'Admin display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 361, 383, 588, 603, 1433, 0, 0, 0),
('management', 1434, 454, 'admin/commerce/customer-profiles/types/billing/display/administrator', 'admin/commerce/customer-profiles/types/billing/display/administrator', 'Administrator', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 359, 384, 401, 454, 1434, 0, 0, 0),
('management', 1435, 455, 'admin/commerce/products/types/product/display/commerce_line_item_display', 'admin/commerce/products/types/product/display/commerce_line_item_display', 'Commerce Line item: Display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 7, 0, 1, 325, 361, 383, 427, 455, 1435, 0, 0, 0),
('management', 1436, 603, 'admin/commerce/products/types/rooms-product/display/commerce_line_item_display', 'admin/commerce/products/types/rooms-product/display/commerce_line_item_display', 'Commerce Line item: Display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 7, 0, 1, 325, 361, 383, 588, 603, 1436, 0, 0, 0),
('management', 1437, 455, 'admin/commerce/products/types/product/display/commerce_line_item_token', 'admin/commerce/products/types/product/display/commerce_line_item_token', 'Commerce Line item: Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 7, 0, 1, 325, 361, 383, 427, 455, 1437, 0, 0, 0),
('management', 1438, 603, 'admin/commerce/products/types/rooms-product/display/commerce_line_item_token', 'admin/commerce/products/types/rooms-product/display/commerce_line_item_token', 'Commerce Line item: Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 7, 0, 1, 325, 361, 383, 588, 603, 1438, 0, 0, 0),
('management', 1439, 454, 'admin/commerce/customer-profiles/types/billing/display/customer', 'admin/commerce/customer-profiles/types/billing/display/customer', 'Customer', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 325, 359, 384, 401, 454, 1439, 0, 0, 0),
('management', 1440, 454, 'admin/commerce/customer-profiles/types/billing/display/default', 'admin/commerce/customer-profiles/types/billing/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 325, 359, 384, 401, 454, 1440, 0, 0, 0),
('management', 1441, 601, 'admin/commerce/config/line-items/product/display/default', 'admin/commerce/config/line-items/product/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 325, 326, 378, 586, 601, 1441, 0, 0, 0),
('management', 1442, 602, 'admin/commerce/config/line-items/rooms-booking/display/default', 'admin/commerce/config/line-items/rooms-booking/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 325, 326, 378, 587, 602, 1442, 0, 0, 0),
('management', 1443, 455, 'admin/commerce/products/types/product/display/default', 'admin/commerce/products/types/product/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 325, 361, 383, 427, 455, 1443, 0, 0, 0),
('management', 1444, 603, 'admin/commerce/products/types/rooms-product/display/default', 'admin/commerce/products/types/rooms-product/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 325, 361, 383, 588, 603, 1444, 0, 0, 0),
('management', 1445, 1422, 'admin/structure/types/manage/%/display/default', 'admin/structure/types/manage/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 20, 34, 105, 1422, 1445, 0, 0, 0, 0),
('management', 1446, 601, 'admin/commerce/config/line-items/product/display/display', 'admin/commerce/config/line-items/product/display/display', 'Display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 326, 378, 586, 601, 1446, 0, 0, 0),
('management', 1447, 602, 'admin/commerce/config/line-items/rooms-booking/display/display', 'admin/commerce/config/line-items/rooms-booking/display/display', 'Display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 326, 378, 587, 602, 1447, 0, 0, 0),
('management', 1448, 1422, 'admin/structure/types/manage/%/display/full', 'admin/structure/types/manage/%/display/full', 'Full content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 20, 34, 105, 1422, 1448, 0, 0, 0, 0),
('management', 1449, 455, 'admin/commerce/products/types/product/display/line_item', 'admin/commerce/products/types/product/display/line_item', 'Line item', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 7, 0, 1, 325, 361, 383, 427, 455, 1449, 0, 0, 0),
('management', 1450, 603, 'admin/commerce/products/types/rooms-product/display/line_item', 'admin/commerce/products/types/rooms-product/display/line_item', 'Line item', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 7, 0, 1, 325, 361, 383, 588, 603, 1450, 0, 0, 0),
('management', 1451, 612, 'admin/rooms/bookings/booking-types/manage/%/display', 'admin/rooms/bookings/booking-types/manage/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 540, 542, 561, 612, 1451, 0, 0, 0, 0),
('management', 1452, 613, 'admin/rooms/units/unit-types/manage/%/display', 'admin/rooms/units/unit-types/manage/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 540, 541, 559, 613, 1452, 0, 0, 0, 0),
('management', 1453, 612, 'admin/rooms/bookings/booking-types/manage/%/fields', 'admin/rooms/bookings/booking-types/manage/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 540, 542, 561, 612, 1453, 0, 0, 0, 0),
('management', 1454, 613, 'admin/rooms/units/unit-types/manage/%/fields', 'admin/rooms/units/unit-types/manage/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 540, 541, 559, 613, 1454, 0, 0, 0, 0),
('management', 1455, 1422, 'admin/structure/types/manage/%/display/rss', 'admin/structure/types/manage/%/display/rss', 'RSS', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 20, 34, 105, 1422, 1455, 0, 0, 0, 0),
('management', 1456, 1422, 'admin/structure/types/manage/%/display/rooms_list', 'admin/structure/types/manage/%/display/rooms_list', 'Rooms Results View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 6, 0, 1, 20, 34, 105, 1422, 1456, 0, 0, 0, 0),
('management', 1457, 1422, 'admin/structure/types/manage/%/display/search_index', 'admin/structure/types/manage/%/display/search_index', 'Search index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 6, 0, 1, 20, 34, 105, 1422, 1457, 0, 0, 0, 0),
('management', 1458, 1422, 'admin/structure/types/manage/%/display/search_result', 'admin/structure/types/manage/%/display/search_result', 'Search result highlighting input', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 6, 0, 1, 20, 34, 105, 1422, 1458, 0, 0, 0, 0),
('management', 1459, 1422, 'admin/structure/types/manage/%/display/teaser', 'admin/structure/types/manage/%/display/teaser', 'Teaser', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 20, 34, 105, 1422, 1459, 0, 0, 0, 0),
('management', 1460, 454, 'admin/commerce/customer-profiles/types/billing/display/token', 'admin/commerce/customer-profiles/types/billing/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 7, 0, 1, 325, 359, 384, 401, 454, 1460, 0, 0, 0),
('management', 1461, 601, 'admin/commerce/config/line-items/product/display/token', 'admin/commerce/config/line-items/product/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 325, 326, 378, 586, 601, 1461, 0, 0, 0),
('management', 1462, 455, 'admin/commerce/products/types/product/display/token', 'admin/commerce/products/types/product/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 325, 361, 383, 427, 455, 1462, 0, 0, 0),
('management', 1463, 602, 'admin/commerce/config/line-items/rooms-booking/display/token', 'admin/commerce/config/line-items/rooms-booking/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 325, 326, 378, 587, 602, 1463, 0, 0, 0),
('management', 1464, 603, 'admin/commerce/products/types/rooms-product/display/token', 'admin/commerce/products/types/rooms-product/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 7, 0, 1, 325, 361, 383, 588, 603, 1464, 0, 0, 0),
('management', 1465, 1422, 'admin/structure/types/manage/%/display/token', 'admin/structure/types/manage/%/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 6, 6, 0, 1, 20, 34, 105, 1422, 1465, 0, 0, 0, 0),
('management', 1466, 606, 'admin/commerce/products/types/rooms-product/fields/%', 'admin/commerce/products/types/rooms-product/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 361, 383, 588, 606, 1466, 0, 0, 0),
('management', 1467, 456, 'admin/commerce/customer-profiles/types/billing/fields/%', 'admin/commerce/customer-profiles/types/billing/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 359, 384, 401, 456, 1467, 0, 0, 0),
('management', 1468, 604, 'admin/commerce/config/line-items/product/fields/%', 'admin/commerce/config/line-items/product/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 378, 586, 604, 1468, 0, 0, 0);
INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 1469, 605, 'admin/commerce/config/line-items/rooms-booking/fields/%', 'admin/commerce/config/line-items/rooms-booking/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 326, 378, 587, 605, 1469, 0, 0, 0),
('management', 1470, 1429, 'admin/commerce/config/order/fields/%/delete', 'admin/commerce/config/order/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 325, 326, 380, 1414, 1429, 1470, 0, 0, 0),
('management', 1471, 1429, 'admin/commerce/config/order/fields/%/edit', 'admin/commerce/config/order/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 326, 380, 1414, 1429, 1471, 0, 0, 0),
('management', 1472, 1429, 'admin/commerce/config/order/fields/%/field-settings', 'admin/commerce/config/order/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 326, 380, 1414, 1429, 1472, 0, 0, 0),
('management', 1473, 1429, 'admin/commerce/config/order/fields/%/widget-type', 'admin/commerce/config/order/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 325, 326, 380, 1414, 1429, 1473, 0, 0, 0),
('management', 1474, 457, 'admin/commerce/products/types/product/fields/%', 'admin/commerce/products/types/product/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 325, 361, 383, 427, 457, 1474, 0, 0, 0),
('management', 1475, 1423, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 20, 34, 105, 1423, 1475, 0, 0, 0, 0),
('management', 1476, 1430, 'admin/structure/taxonomy/%/fields/%/delete', 'admin/structure/taxonomy/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 20, 162, 200, 1415, 1430, 1476, 0, 0, 0),
('management', 1477, 1430, 'admin/structure/taxonomy/%/fields/%/edit', 'admin/structure/taxonomy/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 162, 200, 1415, 1430, 1477, 0, 0, 0),
('management', 1478, 1430, 'admin/structure/taxonomy/%/fields/%/field-settings', 'admin/structure/taxonomy/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 162, 200, 1415, 1430, 1478, 0, 0, 0),
('management', 1479, 1430, 'admin/structure/taxonomy/%/fields/%/widget-type', 'admin/structure/taxonomy/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 162, 200, 1415, 1430, 1479, 0, 0, 0),
('management', 1480, 1431, 'admin/config/people/accounts/fields/%/delete', 'admin/config/people/accounts/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 8, 46, 63, 1416, 1431, 1480, 0, 0, 0),
('management', 1481, 1431, 'admin/config/people/accounts/fields/%/edit', 'admin/config/people/accounts/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 46, 63, 1416, 1431, 1481, 0, 0, 0),
('management', 1482, 1431, 'admin/config/people/accounts/fields/%/field-settings', 'admin/config/people/accounts/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 46, 63, 1416, 1431, 1482, 0, 0, 0),
('management', 1483, 1431, 'admin/config/people/accounts/fields/%/widget-type', 'admin/config/people/accounts/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 46, 63, 1416, 1431, 1483, 0, 0, 0),
('management', 1484, 144, 'admin/structure/types/manage/%/comment/display/default', 'admin/structure/types/manage/%/comment/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 20, 34, 105, 144, 1484, 0, 0, 0, 0),
('management', 1485, 1451, 'admin/rooms/bookings/booking-types/manage/%/display/default', 'admin/rooms/bookings/booking-types/manage/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 540, 542, 561, 612, 1451, 1485, 0, 0, 0),
('management', 1486, 1452, 'admin/rooms/units/unit-types/manage/%/display/default', 'admin/rooms/units/unit-types/manage/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 540, 541, 559, 613, 1452, 1486, 0, 0, 0),
('management', 1487, 144, 'admin/structure/types/manage/%/comment/display/full', 'admin/structure/types/manage/%/comment/display/full', 'Full comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 20, 34, 105, 144, 1487, 0, 0, 0, 0),
('management', 1488, 144, 'admin/structure/types/manage/%/comment/display/token', 'admin/structure/types/manage/%/comment/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 20, 34, 105, 144, 1488, 0, 0, 0, 0),
('management', 1489, 145, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 20, 34, 105, 145, 1489, 0, 0, 0, 0),
('management', 1490, 1467, 'admin/commerce/customer-profiles/types/billing/fields/%/delete', 'admin/commerce/customer-profiles/types/billing/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 325, 359, 384, 401, 456, 1467, 1490, 0, 0),
('management', 1491, 1467, 'admin/commerce/customer-profiles/types/billing/fields/%/edit', 'admin/commerce/customer-profiles/types/billing/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 359, 384, 401, 456, 1467, 1491, 0, 0),
('management', 1492, 1467, 'admin/commerce/customer-profiles/types/billing/fields/%/field-settings', 'admin/commerce/customer-profiles/types/billing/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 359, 384, 401, 456, 1467, 1492, 0, 0),
('management', 1493, 1467, 'admin/commerce/customer-profiles/types/billing/fields/%/widget-type', 'admin/commerce/customer-profiles/types/billing/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 359, 384, 401, 456, 1467, 1493, 0, 0),
('management', 1494, 1468, 'admin/commerce/config/line-items/product/fields/%/delete', 'admin/commerce/config/line-items/product/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 325, 326, 378, 586, 604, 1468, 1494, 0, 0),
('management', 1495, 1468, 'admin/commerce/config/line-items/product/fields/%/edit', 'admin/commerce/config/line-items/product/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 326, 378, 586, 604, 1468, 1495, 0, 0),
('management', 1496, 1468, 'admin/commerce/config/line-items/product/fields/%/field-settings', 'admin/commerce/config/line-items/product/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 326, 378, 586, 604, 1468, 1496, 0, 0),
('management', 1497, 1468, 'admin/commerce/config/line-items/product/fields/%/widget-type', 'admin/commerce/config/line-items/product/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 326, 378, 586, 604, 1468, 1497, 0, 0),
('management', 1498, 1469, 'admin/commerce/config/line-items/rooms-booking/fields/%/delete', 'admin/commerce/config/line-items/rooms-booking/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 325, 326, 378, 587, 605, 1469, 1498, 0, 0),
('management', 1499, 1469, 'admin/commerce/config/line-items/rooms-booking/fields/%/edit', 'admin/commerce/config/line-items/rooms-booking/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 326, 378, 587, 605, 1469, 1499, 0, 0),
('management', 1500, 1469, 'admin/commerce/config/line-items/rooms-booking/fields/%/field-settings', 'admin/commerce/config/line-items/rooms-booking/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 326, 378, 587, 605, 1469, 1500, 0, 0),
('management', 1501, 1469, 'admin/commerce/config/line-items/rooms-booking/fields/%/widget-type', 'admin/commerce/config/line-items/rooms-booking/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 326, 378, 587, 605, 1469, 1501, 0, 0),
('management', 1502, 1474, 'admin/commerce/products/types/product/fields/%/delete', 'admin/commerce/products/types/product/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 325, 361, 383, 427, 457, 1474, 1502, 0, 0),
('management', 1503, 1474, 'admin/commerce/products/types/product/fields/%/edit', 'admin/commerce/products/types/product/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 361, 383, 427, 457, 1474, 1503, 0, 0),
('management', 1504, 1474, 'admin/commerce/products/types/product/fields/%/field-settings', 'admin/commerce/products/types/product/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 361, 383, 427, 457, 1474, 1504, 0, 0),
('management', 1505, 1474, 'admin/commerce/products/types/product/fields/%/widget-type', 'admin/commerce/products/types/product/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 361, 383, 427, 457, 1474, 1505, 0, 0),
('management', 1506, 1466, 'admin/commerce/products/types/rooms-product/fields/%/delete', 'admin/commerce/products/types/rooms-product/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 325, 361, 383, 588, 606, 1466, 1506, 0, 0),
('management', 1507, 1466, 'admin/commerce/products/types/rooms-product/fields/%/edit', 'admin/commerce/products/types/rooms-product/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 361, 383, 588, 606, 1466, 1507, 0, 0),
('management', 1508, 1466, 'admin/commerce/products/types/rooms-product/fields/%/field-settings', 'admin/commerce/products/types/rooms-product/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 361, 383, 588, 606, 1466, 1508, 0, 0),
('management', 1509, 1466, 'admin/commerce/products/types/rooms-product/fields/%/widget-type', 'admin/commerce/products/types/rooms-product/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 325, 361, 383, 588, 606, 1466, 1509, 0, 0),
('management', 1510, 1475, 'admin/structure/types/manage/%/fields/%/delete', 'admin/structure/types/manage/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 20, 34, 105, 1423, 1475, 1510, 0, 0, 0),
('management', 1511, 1475, 'admin/structure/types/manage/%/fields/%/edit', 'admin/structure/types/manage/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 34, 105, 1423, 1475, 1511, 0, 0, 0),
('management', 1512, 1475, 'admin/structure/types/manage/%/fields/%/field-settings', 'admin/structure/types/manage/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 34, 105, 1423, 1475, 1512, 0, 0, 0),
('management', 1513, 1475, 'admin/structure/types/manage/%/fields/%/widget-type', 'admin/structure/types/manage/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 34, 105, 1423, 1475, 1513, 0, 0, 0),
('management', 1514, 1453, 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'admin/rooms/bookings/booking-types/manage/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 540, 542, 561, 612, 1453, 1514, 0, 0, 0),
('management', 1515, 1454, 'admin/rooms/units/unit-types/manage/%/fields/%', 'admin/rooms/units/unit-types/manage/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 540, 541, 559, 613, 1454, 1515, 0, 0, 0),
('management', 1516, 1489, 'admin/structure/types/manage/%/comment/fields/%/delete', 'admin/structure/types/manage/%/comment/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 20, 34, 105, 145, 1489, 1516, 0, 0, 0),
('management', 1517, 1514, 'admin/rooms/bookings/booking-types/manage/%/fields/%/delete', 'admin/rooms/bookings/booking-types/manage/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 540, 542, 561, 612, 1453, 1514, 1517, 0, 0),
('management', 1518, 1515, 'admin/rooms/units/unit-types/manage/%/fields/%/delete', 'admin/rooms/units/unit-types/manage/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 540, 541, 559, 613, 1454, 1515, 1518, 0, 0),
('management', 1519, 1489, 'admin/structure/types/manage/%/comment/fields/%/edit', 'admin/structure/types/manage/%/comment/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 34, 105, 145, 1489, 1519, 0, 0, 0),
('management', 1520, 1489, 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 34, 105, 145, 1489, 1520, 0, 0, 0),
('management', 1521, 1489, 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 20, 34, 105, 145, 1489, 1521, 0, 0, 0),
('management', 1522, 1514, 'admin/rooms/bookings/booking-types/manage/%/fields/%/edit', 'admin/rooms/bookings/booking-types/manage/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 540, 542, 561, 612, 1453, 1514, 1522, 0, 0),
('management', 1523, 1514, 'admin/rooms/bookings/booking-types/manage/%/fields/%/field-settings', 'admin/rooms/bookings/booking-types/manage/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 540, 542, 561, 612, 1453, 1514, 1523, 0, 0),
('management', 1524, 1514, 'admin/rooms/bookings/booking-types/manage/%/fields/%/widget-type', 'admin/rooms/bookings/booking-types/manage/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 540, 542, 561, 612, 1453, 1514, 1524, 0, 0),
('management', 1525, 1515, 'admin/rooms/units/unit-types/manage/%/fields/%/edit', 'admin/rooms/units/unit-types/manage/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 540, 541, 559, 613, 1454, 1515, 1525, 0, 0),
('management', 1526, 1515, 'admin/rooms/units/unit-types/manage/%/fields/%/field-settings', 'admin/rooms/units/unit-types/manage/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 540, 541, 559, 613, 1454, 1515, 1526, 0, 0),
('management', 1527, 1515, 'admin/rooms/units/unit-types/manage/%/fields/%/widget-type', 'admin/rooms/units/unit-types/manage/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 540, 541, 559, 613, 1454, 1515, 1527, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `menu_router`
--

CREATE TABLE IF NOT EXISTS `menu_router` (
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: the Drupal path this entry describes',
  `load_functions` blob NOT NULL COMMENT 'A serialized array of function names (like node_load) to be called to load an object corresponding to a part of the current path.',
  `to_arg_functions` blob NOT NULL COMMENT 'A serialized array of function names (like user_uid_optional_to_arg) to be called to replace a part of the router path with another string.',
  `access_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback which determines the access to this router path. Defaults to user_access.',
  `access_arguments` blob COMMENT 'A serialized array of arguments for the access callback.',
  `page_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that renders the page.',
  `page_arguments` blob COMMENT 'A serialized array of arguments for the page callback.',
  `delivery_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that sends the result of the page_callback function to the browser.',
  `fit` int(11) NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',
  `number_parts` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',
  `context` int(11) NOT NULL DEFAULT '0' COMMENT 'Only for local tasks (tabs) - the context of a local task to control its placement.',
  `tab_parent` varchar(255) NOT NULL DEFAULT '' COMMENT 'Only for local tasks (tabs) - the router path of the parent page (which may also be a local task).',
  `tab_root` varchar(255) NOT NULL DEFAULT '' COMMENT 'Router path of the closest non-tab parent page. For pages that are not local tasks, this will be the same as the path.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title for the current page, or the title for the tab if this is a local task.',
  `title_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which will alter the title. Defaults to t()',
  `title_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the title callback. If empty, the title will be used as the sole argument for the title callback.',
  `theme_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which returns the name of the theme that will be used to render this page. If left empty, the default theme will be used.',
  `theme_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the theme callback.',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT 'Numeric representation of the type of the menu item, like MENU_LOCAL_TASK.',
  `description` text NOT NULL COMMENT 'A description of this item.',
  `position` varchar(255) NOT NULL DEFAULT '' COMMENT 'The position of the block (left or right) on the system administration page for this item.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of the element. Lighter weights are higher up, heavier weights go down.',
  `include_file` mediumtext COMMENT 'The file to include for this element, usually the page callback function lives in this file.',
  PRIMARY KEY (`path`),
  KEY `fit` (`fit`),
  KEY `tab_parent` (`tab_parent`(64),`weight`,`title`),
  KEY `tab_root_weight_title` (`tab_root`(64),`weight`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps paths to various callbacks (access, page and title)';

--
-- Dumping data for table `menu_router`
--

INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('accommodation', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a31343a2261636365737320636f6e74656e74223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31333a226163636f6d6d6f646174696f6e223b693a313b733a343a2270616765223b7d, '', 1, 1, 0, '', 'accommodation', 'Accommodation', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('admin', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'admin', 'Administration', 't', '', '', 'a:0:{}', 6, '', '', 9, 'modules/system/system.admin.inc'),
('admin/appearance', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_themes_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/appearance', 'Appearance', 't', '', '', 'a:0:{}', 6, 'Select and configure your themes.', 'left', -6, 'modules/system/system.admin.inc'),
('admin/appearance/default', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_default', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/default', 'Set default theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/disable', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_disable', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/disable', 'Disable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/enable', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_enable', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/enable', 'Enable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a353a227468656d65223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Install new theme', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/appearance/list', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_themes_page', 0x613a303a7b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'List', 't', '', '', 'a:0:{}', 140, 'Select and configure your theme', '', -1, 'modules/system/system.admin.inc'),
('admin/appearance/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Settings', 't', '', '', 'a:0:{}', 132, 'Configure default and theme specific settings.', '', 20, 'modules/system/system.admin.inc'),
('admin/appearance/settings/bartik', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a363a2262617274696b223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Bartik', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/garland', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a373a226761726c616e64223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Garland', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/global', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Global settings', 't', '', '', 'a:0:{}', 140, '', '', -1, 'modules/system/system.admin.inc'),
('admin/appearance/settings/hotel', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22686f74656c223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Hotel', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/nucleus', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a373a226e75636c657573223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'nucleus', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/appearance/settings/nucleus_starter', '', '', '_system_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31343a7b733a383a2266696c656e616d65223b733a36313a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6e75636c6575735f737461727465722e696e666f223b733a343a226e616d65223b733a31353a226e75636c6575735f73746172746572223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2230223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a32323a7b733a343a226e616d65223b733a31353a226e75636c6575735f73746172746572223b733a31313a226465736372697074696f6e223b733a33373a2253746172746572207468656d6520666f72206e75636c6575732062617365207468656d652e223b733a343a22636f7265223b733a333a22372e78223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a31303a2262617365207468656d65223b733a373a226e75636c657573223b733a31303a2273637265656e73686f74223b733a35353a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f73637265656e73686f742e706e67223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a31313a7b733a32313a226373732f68746d6c2d656c656d656e74732e637373223b733a36323a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f68746d6c2d656c656d656e74732e637373223b733a31333a226373732f666f726d732e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f666f726d732e637373223b733a31323a226373732f706167652e637373223b733a35333a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f706167652e637373223b733a31363a226373732f61727469636c65732e637373223b733a35373a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f61727469636c65732e637373223b733a31363a226373732f636f6d6d656e74732e637373223b733a35373a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f636f6d6d656e74732e637373223b733a31333a226373732f666f72756d2e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f666f72756d2e637373223b733a31343a226373732f6669656c64732e637373223b733a35353a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f6669656c64732e637373223b733a31343a226373732f626c6f636b732e637373223b733a35353a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f626c6f636b732e637373223b733a31393a226373732f70616e656c2d70616e65732e637373223b733a36303a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f70616e656c2d70616e65732e637373223b733a31383a226373732f6e617669676174696f6e2e637373223b733a35393a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f6e617669676174696f6e2e637373223b733a31333a226373732f666f6e74732e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f666f6e74732e637373223b7d733a353a227072696e74223b613a313a7b733a31333a226373732f7072696e742e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f7072696e742e637373223b7d7d733a373a22726567696f6e73223b613a32323a7b733a373a22636f6e74656e74223b733a31323a224d61696e20636f6e74656e74223b733a363a22686561646572223b733a363a22486561646572223b733a383a226d656e755f626172223b733a383a224d656e7520626172223b733a393a22736c69646573686f77223b733a393a22536c69646573686f77223b733a31313a22686967686c696768746564223b733a31313a22486967686c696768746564223b733a363a22666f6f746572223b733a363a22466f6f746572223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31333a22736964656261725f6669727374223b733a31333a2253696465626172206669727374223b733a31343a22736964656261725f7365636f6e64223b733a31343a2253696465626172207365636f6e64223b733a31333a2270616e656c5f66697273745f31223b733a32303a2250616e656c20666972737420636f6c756d6e2031223b733a31333a2270616e656c5f66697273745f32223b733a32303a2250616e656c20666972737420636f6c756d6e2032223b733a31333a2270616e656c5f66697273745f33223b733a32303a2250616e656c20666972737420636f6c756d6e2033223b733a31333a2270616e656c5f66697273745f34223b733a32303a2250616e656c20666972737420636f6c756d6e2034223b733a31343a2270616e656c5f7365636f6e645f31223b733a32313a2250616e656c207365636f6e6420636f6c756d6e2031223b733a31343a2270616e656c5f7365636f6e645f32223b733a32313a2250616e656c207365636f6e6420636f6c756d6e2032223b733a31343a2270616e656c5f7365636f6e645f33223b733a32313a2250616e656c207365636f6e6420636f6c756d6e2033223b733a31343a2270616e656c5f7365636f6e645f34223b733a32313a2250616e656c207365636f6e6420636f6c756d6e2034223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a343a226e616d65223b693a323b733a363a22736c6f67616e223b693a333b733a31373a226e6f64655f757365725f70696374757265223b693a343b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a353b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a363b733a373a2266617669636f6e223b693a373b733a31363a22676f5f746f5f746f705f627574746f6e223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a383a2273657474696e6773223b613a32343a7b733a31383a2262726561646372756d625f646973706c6179223b733a333a22796573223b733a32303a2262726561646372756d625f736570617261746f72223b733a383a222026233138373b20223b733a31353a2262726561646372756d625f686f6d65223b733a313a2231223b733a343a2267726964223b733a31333a22666c7569642d677269642d3234223b733a31323a226c61796f75745f7769647468223b733a353a223936307078223b733a31313a22706167655f6c61796f7574223b733a373a2264656661756c74223b733a31393a22736964656261725f66697273745f7769647468223b733a313a2236223b733a32303a22736964656261725f7365636f6e645f7769647468223b733a313a2236223b733a31393a2270616e656c5f66697273745f315f7769647468223b733a313a2236223b733a31393a2270616e656c5f66697273745f325f7769647468223b733a313a2236223b733a31393a2270616e656c5f66697273745f335f7769647468223b733a313a2236223b733a31393a2270616e656c5f66697273745f345f7769647468223b733a313a2236223b733a32303a2270616e656c5f7365636f6e645f315f7769647468223b733a313a2236223b733a32303a2270616e656c5f7365636f6e645f325f7769647468223b733a313a2236223b733a32303a2270616e656c5f7365636f6e645f335f7769647468223b733a313a2236223b733a32303a2270616e656c5f7365636f6e645f345f7769647468223b733a313a2236223b733a393a22626173655f666f6e74223b733a363a2262662d737373223b733a31343a22736974655f6e616d655f666f6e74223b733a363a22736e662d736c223b733a31363a22736974655f736c6f67616e5f666f6e74223b733a363a227373662d736c223b733a31353a22706167655f7469746c655f666f6e74223b733a363a227074662d736c223b733a31353a226e6f64655f7469746c655f666f6e74223b733a363a226e74662d736c223b733a31383a22636f6d6d656e745f7469746c655f666f6e74223b733a363a226374662d736c223b733a31363a22626c6f636b5f7469746c655f666f6e74223b733a363a226274662d736c223b733a393a22666f6e745f73697a65223b733a393a2266732d6d656469756d223b7d733a31333a2264656661756c745f666f6e7473223b613a383a7b733a333a22737373223b733a37363a2243616c696272692c2043616e646172612c2048656c766574696361204e6575652c20547265627563686574204d532c20417269616c2c2048656c7665746963612c2073616e732d7365726966223b733a333a2273736c223b733a34353a2256657264616e612c2047656e6576612c20417269616c2c2048656c7665746963612c2073616e732d7365726966223b733a313a2261223b733a32383a22417269616c2c2048656c7665746963612c2073616e732d7365726966223b733a323a227373223b733a34323a22476172616d6f6e642c2050657270657475612c2054696d6573204e657720526f6d616e2c207365726966223b733a323a22736c223b733a38373a2247656f726769612c204261736b657276696c6c652c2050616c6174696e6f2c2050616c6174696e6f204c696e6f747970652c20426f6f6b20416e74697175612c2054696d6573204e657720526f6d616e2c207365726966223b733a313a226d223b733a35393a225365676f652055492c204d79726961642050726f2c204d79726961642c20417269616c2c2048656c7665746963612c2073616e732d73657269663b223b733a313a226c223b733a37363a224c75636964612053616e7320556e69636f64652c204c75636964612053616e732c204c7563696461204772616e64652c2056657264616e612c2047656e6576612c2073616e732d7365726966223b733a323a226d73223b733a34393a22436f6e736f6c61732c204d6f6e61636f2c20436f7572696572204e65772c20436f75726965722c206d6f6e6f7370616365223b7d733a31363a227375706572666973685f7374796c6573223b613a313a7b733a373a2273746172746572223b733a32373a2253746172746572205374796c6520666f7220537570657266697368223b7d733a31363a22717569636b746162735f7374796c6573223b613a313a7b733a373a2273746172746572223b733a32373a2253746172746572207374796c6520666f7220517569636b74616273223b7d733a373a2276657273696f6e223b733a373a22372e782d312e34223b733a373a2270726f6a656374223b733a373a226e75636c657573223b733a393a22646174657374616d70223b733a31303a2231333735303732353638223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a353a226d74696d65223b693a313432343933373735333b733a31353a226f7665726c61795f726567696f6e73223b613a353a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b693a333b733a373a22636f6e74656e74223b693a343b733a343a2268656c70223b7d733a31343a22726567696f6e735f68696464656e223b613a323a7b693a303b733a383a22706167655f746f70223b693a313b733a31313a22706167655f626f74746f6d223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a383a22706167655f746f70223b7d7d733a31313a22626173655f7468656d6573223b613a313a7b733a373a226e75636c657573223b733a373a226e75636c657573223b7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a31313a7b733a32313a226373732f68746d6c2d656c656d656e74732e637373223b733a36323a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f68746d6c2d656c656d656e74732e637373223b733a31333a226373732f666f726d732e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f666f726d732e637373223b733a31323a226373732f706167652e637373223b733a35333a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f706167652e637373223b733a31363a226373732f61727469636c65732e637373223b733a35373a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f61727469636c65732e637373223b733a31363a226373732f636f6d6d656e74732e637373223b733a35373a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f636f6d6d656e74732e637373223b733a31333a226373732f666f72756d2e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f666f72756d2e637373223b733a31343a226373732f6669656c64732e637373223b733a35353a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f6669656c64732e637373223b733a31343a226373732f626c6f636b732e637373223b733a35353a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f626c6f636b732e637373223b733a31393a226373732f70616e656c2d70616e65732e637373223b733a36303a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f70616e656c2d70616e65732e637373223b733a31383a226373732f6e617669676174696f6e2e637373223b733a35393a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f6e617669676174696f6e2e637373223b733a31333a226373732f666f6e74732e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f666f6e74732e637373223b7d733a353a227072696e74223b613a313a7b733a31333a226373732f7072696e742e637373223b733a35343a2273697465732f616c6c2f7468656d65732f6e75636c6575732f6e75636c6575735f737461727465722f6373732f7072696e742e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a31303a22626173655f7468656d65223b733a373a226e75636c657573223b7d7d, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a31353a226e75636c6575735f73746172746572223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'nucleus_starter', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/seven', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22736576656e223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Seven', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/stark', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22737461726b223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Stark', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a353a227468656d65223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/commerce', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/commerce', 'Store', 't', '', '', 'a:0:{}', 6, 'Administer your store.', '', -7, 'modules/system/system.admin.inc'),
('admin/commerce/config', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/commerce/config', 'Configuration', 't', '', '', 'a:0:{}', 6, 'Configure settings and business rules for your store.', '', 50, 'modules/system/system.admin.inc'),
('admin/commerce/config/checkout', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636865636b6f7574223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a22636f6d6d657263655f636865636b6f75745f6275696c6465725f666f726d223b7d, '', 15, 4, 0, '', 'admin/commerce/config/checkout', 'Checkout settings', 't', '', '', 'a:0:{}', 6, 'Customize the checkout form and configure checkout rules.', '', 0, 'sites/all/modules/commerce/modules/checkout/includes/commerce_checkout.admin.inc'),
('admin/commerce/config/checkout/form', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636865636b6f7574223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a22636f6d6d657263655f636865636b6f75745f6275696c6465725f666f726d223b7d, '', 31, 5, 1, 'admin/commerce/config/checkout', 'admin/commerce/config/checkout', 'Checkout form', 't', '', '', 'a:0:{}', 140, 'Build your checkout pages using module defined checkout form elements.', '', 0, 'sites/all/modules/commerce/modules/checkout/includes/commerce_checkout.admin.inc'),
('admin/commerce/config/checkout/form/pane/%', 0x613a313a7b693a363b733a32373a22636f6d6d657263655f636865636b6f75745f70616e655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636865636b6f7574223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33363a22636f6d6d657263655f636865636b6f75745f70616e655f73657474696e67735f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/commerce/config/checkout/form/pane/%', '', 'commerce_checkout_pane_settings_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, 'Configure the settings for a checkout pane.', '', 0, 'sites/all/modules/commerce/modules/checkout/includes/commerce_checkout.admin.inc'),
('admin/commerce/config/checkout/rules', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636865636b6f7574223b7d, 'commerce_checkout_complete_rules', 0x613a303a7b7d, '', 31, 5, 1, 'admin/commerce/config/checkout', 'admin/commerce/config/checkout', 'Checkout rules', 't', '', '', 'a:0:{}', 132, 'Enable and configure checkout completion rules.', '', 5, 'sites/all/modules/commerce/modules/checkout/includes/commerce_checkout.admin.inc'),
('admin/commerce/config/checkout/rules/add', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636865636b6f7574223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a34303a22636f6d6d657263655f636865636b6f75745f6164645f636f6d706c6574655f72756c655f666f726d223b693a313b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 63, 6, 1, 'admin/commerce/config/checkout/rules', 'admin/commerce/config/checkout', 'Add a checkout rule', 't', '', '', 'a:0:{}', 388, 'Adds an additional checkout completion rule configuration.', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/commerce/config/checkout/rules/manage/%', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33313a2272756c65735f75695f666f726d5f656469745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 126, 7, 0, '', 'admin/commerce/config/checkout/rules/manage/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/%', 0x613a323a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b693a373b4e3b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33373a2272756c65735f75695f666f726d5f72756c65735f636f6e6669675f636f6e6669726d5f6f70223b693a313b693a363b693a323b693a373b693a333b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 252, 8, 0, '', 'admin/commerce/config/checkout/rules/manage/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/add/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a353a7b693a303b733a32303a2272756c65735f75695f6164645f656c656d656e74223b693a313b693a363b693a323b693a393b693a333b693a383b693a343b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 506, 9, 0, '', 'admin/commerce/config/checkout/rules/manage/%/add/%', '', 'rules_menu_add_element_title', 'a:1:{i:0;a:1:{i:0;i:9;}}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/add/event', 0x613a313a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32333a2272756c65735f75695f6164645f6576656e745f70616765223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 507, 9, 0, '', 'admin/commerce/config/checkout/rules/manage/%/add/event', '', 'rules_get_title', 'a:2:{i:0;s:32:"Adding event to !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/autocomplete', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'rules_ui_form_data_selection_auto_completion', 0x613a333a7b693a303b693a383b693a313b693a393b693a323b693a31303b7d, '', 253, 8, 0, '', 'admin/commerce/config/checkout/rules/manage/%/autocomplete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/clone', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33323a2272756c65735f75695f666f726d5f636c6f6e655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 253, 8, 0, '', 'admin/commerce/config/checkout/rules/manage/%/clone', '', 'rules_get_title', 'a:2:{i:0;s:24:"Cloning !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/delete/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32333a2272756c65735f75695f64656c6574655f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 506, 9, 0, '', 'admin/commerce/config/checkout/rules/manage/%/delete/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/delete/event', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f72656d6f76655f6576656e74223b693a313b693a363b693a323b693a393b693a333b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 507, 9, 0, '', 'admin/commerce/config/checkout/rules/manage/%/delete/event', 'Remove event', 't', '', '', 'a:0:{}', 6, 'Remove an event from a reaction rule.', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/edit/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f656469745f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 506, 9, 0, '', 'admin/commerce/config/checkout/rules/manage/%/edit/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/execute', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33343a2272756c65735f75695f666f726d5f657865637574655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 253, 8, 0, '', 'admin/commerce/config/checkout/rules/manage/%/execute', '', 'rules_get_title', 'a:2:{i:0;s:26:"Executing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/checkout/rules/manage/%/export', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33333a2272756c65735f75695f666f726d5f6578706f72745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6d6d657263652f636f6e6669672f636865636b6f75742f72756c6573223b7d, '', 253, 8, 0, '', 'admin/commerce/config/checkout/rules/manage/%/export', '', 'rules_get_title', 'a:2:{i:0;s:26:"Export of !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/currency', '', '', 'user_access', 0x613a313a7b693a303b733a31353a22636f6e6669677572652073746f7265223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33313a22636f6d6d657263655f63757272656e63795f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/commerce/config/currency', 'Currency settings', 't', '', '', 'a:0:{}', 6, 'Configure the default currency and display settings.', '', 0, 'sites/all/modules/commerce/includes/commerce_ui.admin.inc'),
('admin/commerce/config/line-items', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'commerce_line_item_ui_types_overview', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/commerce/config/line-items', 'Line item types', 't', '', '', 'a:0:{}', 6, 'Manage line item types for your store.', '', 0, 'sites/all/modules/commerce/modules/line_item/includes/commerce_line_item_ui.types.inc'),
('admin/commerce/config/line-items/product', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'commerce_line_item_ui_line_item_type_redirect', 0x613a313a7b693a303b733a373a2270726f64756374223b7d, '', 31, 5, 0, '', 'admin/commerce/config/line-items/product', 'Product', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('admin/commerce/config/line-items/product/display', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a373a2270726f64756374223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 3, 'admin/commerce/config/line-items/product', 'admin/commerce/config/line-items/product', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a373a2270726f64756374223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/commerce/config/line-items/product/display', 'admin/commerce/config/line-items/product', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/display/display', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a373a22646973706c6179223b693a333b733a31313a22757365725f616363657373223b693a343b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a373a2270726f64756374223b693a333b733a373a22646973706c6179223b7d, '', 127, 7, 1, 'admin/commerce/config/line-items/product/display', 'admin/commerce/config/line-items/product', 'Display', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a373a2270726f64756374223b693a333b733a353a22746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/config/line-items/product/display', 'admin/commerce/config/line-items/product', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a373a2270726f64756374223b7d, '', 63, 6, 3, 'admin/commerce/config/line-items/product', 'admin/commerce/config/line-items/product', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/commerce/config/line-items/product/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/product/fields/%', 'admin/commerce/config/line-items/product/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/product/fields/%', 'admin/commerce/config/line-items/product/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/product/fields/%', 'admin/commerce/config/line-items/product/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/product/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/product/fields/%', 'admin/commerce/config/line-items/product/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'commerce_line_item_ui_line_item_type_redirect', 0x613a313a7b693a303b733a31333a22726f6f6d732d626f6f6b696e67223b7d, '', 31, 5, 0, '', 'admin/commerce/config/line-items/rooms-booking', 'Rooms Booking', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('admin/commerce/config/line-items/rooms-booking/display', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a31333a22726f6f6d735f626f6f6b696e67223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 3, 'admin/commerce/config/line-items/rooms-booking', 'admin/commerce/config/line-items/rooms-booking', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a31333a22726f6f6d735f626f6f6b696e67223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/commerce/config/line-items/rooms-booking/display', 'admin/commerce/config/line-items/rooms-booking', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/display/display', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a373a22646973706c6179223b693a333b733a31313a22757365725f616363657373223b693a343b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a31333a22726f6f6d735f626f6f6b696e67223b693a333b733a373a22646973706c6179223b7d, '', 127, 7, 1, 'admin/commerce/config/line-items/rooms-booking/display', 'admin/commerce/config/line-items/rooms-booking', 'Display', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a31333a22726f6f6d735f626f6f6b696e67223b693a333b733a353a22746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/config/line-items/rooms-booking/display', 'admin/commerce/config/line-items/rooms-booking', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a323b733a31333a22726f6f6d735f626f6f6b696e67223b7d, '', 63, 6, 3, 'admin/commerce/config/line-items/rooms-booking', 'admin/commerce/config/line-items/rooms-booking', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/commerce/config/line-items/rooms-booking/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/rooms-booking/fields/%', 'admin/commerce/config/line-items/rooms-booking/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/rooms-booking/fields/%', 'admin/commerce/config/line-items/rooms-booking/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/line-items/rooms-booking/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/rooms-booking/fields/%', 'admin/commerce/config/line-items/rooms-booking/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/commerce/config/line-items/rooms-booking/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31383a22636f6d6d657263655f6c696e655f6974656d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572206c696e65206974656d207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/config/line-items/rooms-booking/fields/%', 'admin/commerce/config/line-items/rooms-booking/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order', '', '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a22636f6d6d657263655f6f726465725f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/commerce/config/order', 'Order settings', 't', '', '', 'a:0:{}', 6, 'Configure general order settings, fields, and displays.', '', 0, 'sites/all/modules/commerce/modules/order/includes/commerce_order_ui.orders.inc'),
('admin/commerce/config/order/display', '', '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31343a22636f6d6d657263655f6f72646572223b693a333b733a373a2264656661756c74223b7d, '', 31, 5, 1, 'admin/commerce/config/order', 'admin/commerce/config/order', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/display/administrator', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31333a2261646d696e6973747261746f72223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31343a22636f6d6d657263655f6f72646572223b693a333b733a31333a2261646d696e6973747261746f72223b7d, '', 63, 6, 1, 'admin/commerce/config/order/display', 'admin/commerce/config/order', 'Administrator', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/display/customer', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a383a22637573746f6d6572223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31343a22636f6d6d657263655f6f72646572223b693a333b733a383a22637573746f6d6572223b7d, '', 63, 6, 1, 'admin/commerce/config/order/display', 'admin/commerce/config/order', 'Customer', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31343a22636f6d6d657263655f6f72646572223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 1, 'admin/commerce/config/order/display', 'admin/commerce/config/order', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31343a22636f6d6d657263655f6f72646572223b693a333b733a353a22746f6b656e223b7d, '', 63, 6, 1, 'admin/commerce/config/order/display', 'admin/commerce/config/order', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a31343a22636f6d6d657263655f6f72646572223b7d, '', 31, 5, 1, 'admin/commerce/config/order', 'admin/commerce/config/order', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/fields/%', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/commerce/config/order/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/fields/%/delete', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/commerce/config/order/fields/%', 'admin/commerce/config/order/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/fields/%/edit', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/commerce/config/order/fields/%', 'admin/commerce/config/order/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/fields/%/field-settings', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/commerce/config/order/fields/%', 'admin/commerce/config/order/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/fields/%/widget-type', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31343a22636f6d6d657263655f6f72646572223b693a313b733a31343a22636f6d6d657263655f6f72646572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/commerce/config/order/fields/%', 'admin/commerce/config/order/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/config/order/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32343a22636f6e666967757265206f726465722073657474696e6773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a22636f6d6d657263655f6f726465725f73657474696e67735f666f726d223b7d, '', 31, 5, 1, 'admin/commerce/config/order', 'admin/commerce/config/order', 'Settings', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/commerce/modules/order/includes/commerce_order_ui.orders.inc'),
('admin/commerce/config/payment-methods', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572207061796d656e74206d6574686f6473223b7d, 'commerce_payment_ui_admin_page', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/commerce/config/payment-methods', 'Payment methods', 't', '', '', 'a:0:{}', 6, 'Enable and configure payment method rule configurations.', '', 0, 'sites/all/modules/commerce/modules/payment/includes/commerce_payment_ui.admin.inc'),
('admin/commerce/config/payment-methods/add', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e6973746572207061796d656e74206d6574686f6473223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a34313a22636f6d6d657263655f7061796d656e745f75695f6164645f7061796d656e745f72756c655f666f726d223b693a313b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 31, 5, 0, '', 'admin/commerce/config/payment-methods/add', 'Add a payment method rule', 't', '', '', 'a:0:{}', 6, 'Adds an additional payment method rule configuration.', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/commerce/config/payment-methods/manage/%', 0x613a313a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33313a2272756c65735f75695f666f726d5f656469745f72756c65735f636f6e666967223b693a313b693a353b693a323b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 62, 6, 0, '', 'admin/commerce/config/payment-methods/manage/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:5;}', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/%', 0x613a323a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b693a363b4e3b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33373a2272756c65735f75695f666f726d5f72756c65735f636f6e6669675f636f6e6669726d5f6f70223b693a313b693a353b693a323b693a363b693a333b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 124, 7, 0, '', 'admin/commerce/config/payment-methods/manage/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/add/%', 0x613a323a7b693a353b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a353b7d7d693a373b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a353a7b693a303b733a32303a2272756c65735f75695f6164645f656c656d656e74223b693a313b693a353b693a323b693a383b693a333b693a373b693a343b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 250, 8, 0, '', 'admin/commerce/config/payment-methods/manage/%/add/%', '', 'rules_menu_add_element_title', 'a:1:{i:0;a:1:{i:0;i:8;}}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/add/event', 0x613a313a7b693a353b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32333a2272756c65735f75695f6164645f6576656e745f70616765223b693a313b693a353b693a323b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 251, 8, 0, '', 'admin/commerce/config/payment-methods/manage/%/add/event', '', 'rules_get_title', 'a:2:{i:0;s:32:"Adding event to !plugin "!label"";i:1;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/autocomplete', 0x613a313a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'rules_ui_form_data_selection_auto_completion', 0x613a333a7b693a303b693a373b693a313b693a383b693a323b693a393b7d, '', 125, 7, 0, '', 'admin/commerce/config/payment-methods/manage/%/autocomplete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/clone', 0x613a313a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33323a2272756c65735f75695f666f726d5f636c6f6e655f72756c65735f636f6e666967223b693a313b693a353b693a323b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 125, 7, 0, '', 'admin/commerce/config/payment-methods/manage/%/clone', '', 'rules_get_title', 'a:2:{i:0;s:24:"Cloning !plugin "!label"";i:1;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/delete/%', 0x613a323a7b693a353b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a353b7d7d693a373b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32333a2272756c65735f75695f64656c6574655f656c656d656e74223b693a313b693a353b693a323b693a373b693a333b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 250, 8, 0, '', 'admin/commerce/config/payment-methods/manage/%/delete/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:7;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/delete/event', 0x613a313a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f72656d6f76655f6576656e74223b693a313b693a353b693a323b693a383b693a333b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 251, 8, 0, '', 'admin/commerce/config/payment-methods/manage/%/delete/event', 'Remove event', 't', '', '', 'a:0:{}', 6, 'Remove an event from a reaction rule.', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/edit/%', 0x613a323a7b693a353b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a353b7d7d693a373b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f656469745f656c656d656e74223b693a313b693a353b693a323b693a373b693a333b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 250, 8, 0, '', 'admin/commerce/config/payment-methods/manage/%/edit/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:7;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/execute', 0x613a313a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a353b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33343a2272756c65735f75695f666f726d5f657865637574655f72756c65735f636f6e666967223b693a313b693a353b693a323b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 125, 7, 0, '', 'admin/commerce/config/payment-methods/manage/%/execute', '', 'rules_get_title', 'a:2:{i:0;s:26:"Executing !plugin "!label"";i:1;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/payment-methods/manage/%/export', 0x613a313a7b693a353b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a353b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33333a2272756c65735f75695f666f726d5f6578706f72745f72756c65735f636f6e666967223b693a313b693a353b693a323b733a33373a2261646d696e2f636f6d6d657263652f636f6e6669672f7061796d656e742d6d6574686f6473223b7d, '', 125, 7, 0, '', 'admin/commerce/config/payment-methods/manage/%/export', '', 'rules_get_title', 'a:2:{i:0;s:26:"Export of !plugin "!label"";i:1;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e69737465722070726f647563742070726963696e67223b7d, 'commerce_product_pricing_ui_sell_price_rules', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/commerce/config/product-pricing', 'Product pricing rules', 't', '', '', 'a:0:{}', 6, 'Enable and configure product pricing rules and pre-calculation.', '', 0, 'sites/all/modules/commerce/modules/product_pricing/includes/commerce_product_pricing_ui.admin.inc'),
('admin/commerce/config/product-pricing/pre-calculation', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e69737465722070726f647563742070726963696e67223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a34363a22636f6d6d657263655f70726f647563745f7072655f63616c63756c6174696f6e5f73657474696e67735f666f726d223b7d, '', 31, 5, 1, 'admin/commerce/config/product-pricing', 'admin/commerce/config/product-pricing', 'Pre-calculation', 't', '', '', 'a:0:{}', 132, 'Configure the price pre-calculation settings.', '', 5, 'sites/all/modules/commerce/modules/product_pricing/includes/commerce_product_pricing_ui.admin.inc'),
('admin/commerce/config/product-pricing/rules', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e69737465722070726f647563742070726963696e67223b7d, 'commerce_product_pricing_ui_sell_price_rules', 0x613a303a7b7d, '', 31, 5, 1, 'admin/commerce/config/product-pricing', 'admin/commerce/config/product-pricing', 'List', 't', '', '', 'a:0:{}', 140, 'Administer the rules used for calculating product sell prices.', '', 0, 'sites/all/modules/commerce/modules/product_pricing/includes/commerce_product_pricing_ui.admin.inc'),
('admin/commerce/config/product-pricing/rules/add', '', '', 'user_access', 0x613a313a7b693a303b733a32363a2261646d696e69737465722070726f647563742070726963696e67223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a34393a22636f6d6d657263655f70726f647563745f70726963696e675f75695f6164645f70726963696e675f72756c655f666f726d223b693a313b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 63, 6, 0, '', 'admin/commerce/config/product-pricing/rules/add', 'Add a pricing rule', 't', '', '', 'a:0:{}', 6, 'Adds an additional sell price calculation rule configuration.', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/commerce/config/product-pricing/rules/manage/%', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33313a2272756c65735f75695f666f726d5f656469745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 126, 7, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/%', 0x613a323a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b693a373b4e3b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33373a2272756c65735f75695f666f726d5f72756c65735f636f6e6669675f636f6e6669726d5f6f70223b693a313b693a363b693a323b693a373b693a333b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 252, 8, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/add/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a353a7b693a303b733a32303a2272756c65735f75695f6164645f656c656d656e74223b693a313b693a363b693a323b693a393b693a333b693a383b693a343b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 506, 9, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/add/%', '', 'rules_menu_add_element_title', 'a:1:{i:0;a:1:{i:0;i:9;}}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/add/event', 0x613a313a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32333a2272756c65735f75695f6164645f6576656e745f70616765223b693a313b693a363b693a323b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 507, 9, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/add/event', '', 'rules_get_title', 'a:2:{i:0;s:32:"Adding event to !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/autocomplete', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'rules_ui_form_data_selection_auto_completion', 0x613a333a7b693a303b693a383b693a313b693a393b693a323b693a31303b7d, '', 253, 8, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/autocomplete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/clone', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33323a2272756c65735f75695f666f726d5f636c6f6e655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 253, 8, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/clone', '', 'rules_get_title', 'a:2:{i:0;s:24:"Cloning !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/delete/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32333a2272756c65735f75695f64656c6574655f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 506, 9, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/delete/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/delete/event', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f72656d6f76655f6576656e74223b693a313b693a363b693a323b693a393b693a333b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 507, 9, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/delete/event', 'Remove event', 't', '', '', 'a:0:{}', 6, 'Remove an event from a reaction rule.', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/edit/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f656469745f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 506, 9, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/edit/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/execute', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33343a2272756c65735f75695f666f726d5f657865637574655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 253, 8, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/execute', '', 'rules_get_title', 'a:2:{i:0;s:26:"Executing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/config/product-pricing/rules/manage/%/export', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33333a2272756c65735f75695f666f726d5f6578706f72745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a34333a2261646d696e2f636f6d6d657263652f636f6e6669672f70726f647563742d70726963696e672f72756c6573223b7d, '', 253, 8, 0, '', 'admin/commerce/config/product-pricing/rules/manage/%/export', '', 'rules_get_title', 'a:2:{i:0;s:26:"Export of !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/commerce/customer-profiles', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a34353a2261646d696e697374657220636f6d6d657263655f637573746f6d65725f70726f66696c6520656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a32363a22636f6d6d657263655f637573746f6d65725f70726f66696c6573223b693a313b733a363a22706167655f31223b7d, '', 7, 3, 0, '', 'admin/commerce/customer-profiles', 'Customer profiles', 't', '', '', 'a:0:{}', 6, 'Manage customer profiles and profile types in the store.', '', 0, ''),
('admin/commerce/customer-profiles/%', 0x613a313a7b693a333b733a33303a22636f6d6d657263655f637573746f6d65725f70726f66696c655f6c6f6164223b7d, '', 'commerce_customer_profile_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a333b7d, 'commerce_customer_ui_customer_profile_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 3, '', 'admin/commerce/customer-profiles/%', '', 'commerce_customer_ui_customer_profile_title', 'a:1:{i:0;i:3;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/commerce/modules/customer/includes/commerce_customer_ui.profiles.inc'),
('admin/commerce/customer-profiles/%/delete', 0x613a313a7b693a333b733a33303a22636f6d6d657263655f637573746f6d65725f70726f66696c655f6c6f6164223b7d, '', 'commerce_customer_profile_access', 0x613a323a7b693a303b733a363a2264656c657465223b693a313b693a333b7d, 'commerce_customer_ui_customer_profile_delete_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 2, 'admin/commerce/customer-profiles/%', 'admin/commerce/customer-profiles/%', 'Delete a customer profile', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/commerce/modules/customer/includes/commerce_customer_ui.profiles.inc'),
('admin/commerce/customer-profiles/%/edit', 0x613a313a7b693a333b733a33303a22636f6d6d657263655f637573746f6d65725f70726f66696c655f6c6f6164223b7d, '', 'commerce_customer_profile_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a333b7d, 'commerce_customer_ui_customer_profile_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 3, 'admin/commerce/customer-profiles/%', 'admin/commerce/customer-profiles/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/commerce/modules/customer/includes/commerce_customer_ui.profiles.inc'),
('admin/commerce/customer-profiles/add', '', '', 'commerce_customer_ui_customer_profile_add_any_access', 0x613a303a7b7d, 'commerce_customer_ui_customer_profile_add_page', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/commerce/customer-profiles/add', 'Add a customer profile', 't', '', '', 'a:0:{}', 6, 'Add a new customer profile.', '', 10, 'sites/all/modules/commerce/modules/customer/includes/commerce_customer_ui.profiles.inc'),
('admin/commerce/customer-profiles/add/billing', '', '', 'commerce_customer_profile_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b4f3a383a22737464436c617373223a383a7b733a343a2274797065223b733a373a2262696c6c696e67223b733a333a22756964223b693a303b733a31303a2270726f66696c655f6964223b4e3b733a31313a227265766973696f6e5f6964223b4e3b733a363a22737461747573223b693a313b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b733a363a2269735f6e6577223b623a313b7d7d, 'commerce_customer_ui_customer_profile_form_wrapper', 0x613a313a7b693a303b4f3a383a22737464436c617373223a383a7b733a343a2274797065223b733a373a2262696c6c696e67223b733a333a22756964223b693a303b733a31303a2270726f66696c655f6964223b4e3b733a31313a227265766973696f6e5f6964223b4e3b733a363a22737461747573223b693a313b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b733a363a2269735f6e6577223b623a313b7d7d, '', 31, 5, 0, '', 'admin/commerce/customer-profiles/add/billing', 'Create @name', 't', 'a:1:{s:5:"@name";s:19:"Billing information";}', '', 'a:0:{}', 6, 'The profile used to collect billing information on the checkout and order forms.', '', 0, 'sites/all/modules/commerce/modules/customer/includes/commerce_customer_ui.profiles.inc'),
('admin/commerce/customer-profiles/list', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a34353a2261646d696e697374657220636f6d6d657263655f637573746f6d65725f70726f66696c6520656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a32363a22636f6d6d657263655f637573746f6d65725f70726f66696c6573223b693a313b733a363a22706167655f31223b7d, '', 15, 4, 1, 'admin/commerce/customer-profiles', 'admin/commerce/customer-profiles', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('admin/commerce/customer-profiles/types', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'commerce_customer_ui_customer_profile_types_overview', 0x613a303a7b7d, '', 15, 4, 1, 'admin/commerce/customer-profiles', 'admin/commerce/customer-profiles', 'Profile types', 't', '', '', 'a:0:{}', 132, 'Manage customer profile types for your store.', '', 0, 'sites/all/modules/commerce/modules/customer/includes/commerce_customer_ui.profile_types.inc'),
('admin/commerce/customer-profiles/types/billing', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'commerce_customer_ui_profile_type_redirect', 0x613a313a7b693a303b733a373a2262696c6c696e67223b7d, '', 31, 5, 0, '', 'admin/commerce/customer-profiles/types/billing', 'Billing information', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('admin/commerce/customer-profiles/types/billing/display', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a323b733a373a2262696c6c696e67223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 3, 'admin/commerce/customer-profiles/types/billing', 'admin/commerce/customer-profiles/types/billing', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/display/administrator', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a31333a2261646d696e6973747261746f72223b693a333b733a31313a22757365725f616363657373223b693a343b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a323b733a373a2262696c6c696e67223b693a333b733a31333a2261646d696e6973747261746f72223b7d, '', 127, 7, 1, 'admin/commerce/customer-profiles/types/billing/display', 'admin/commerce/customer-profiles/types/billing', 'Administrator', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/display/customer', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a383a22637573746f6d6572223b693a333b733a31313a22757365725f616363657373223b693a343b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a323b733a373a2262696c6c696e67223b693a333b733a383a22637573746f6d6572223b7d, '', 127, 7, 1, 'admin/commerce/customer-profiles/types/billing/display', 'admin/commerce/customer-profiles/types/billing', 'Customer', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a323b733a373a2262696c6c696e67223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/commerce/customer-profiles/types/billing/display', 'admin/commerce/customer-profiles/types/billing', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a323b733a373a2262696c6c696e67223b693a333b733a353a22746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/customer-profiles/types/billing/display', 'admin/commerce/customer-profiles/types/billing', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/fields', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a323b733a373a2262696c6c696e67223b7d, '', 63, 6, 3, 'admin/commerce/customer-profiles/types/billing', 'admin/commerce/customer-profiles/types/billing', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/commerce/customer-profiles/types/billing/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/customer-profiles/types/billing/fields/%', 'admin/commerce/customer-profiles/types/billing/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/customer-profiles/types/billing/fields/%', 'admin/commerce/customer-profiles/types/billing/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/customer-profiles/types/billing/fields/%', 'admin/commerce/customer-profiles/types/billing/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/customer-profiles/types/billing/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32353a22636f6d6d657263655f637573746f6d65725f70726f66696c65223b693a313b733a373a2262696c6c696e67223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220637573746f6d65722070726f66696c65207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/customer-profiles/types/billing/fields/%', 'admin/commerce/customer-profiles/types/billing/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/orders', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33303a227669657720616e7920636f6d6d657263655f6f7264657220656e74697479223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31353a22636f6d6d657263655f6f7264657273223b693a313b733a31303a2261646d696e5f70616765223b7d, '', 7, 3, 0, '', 'admin/commerce/orders', 'Orders', 't', '', '', 'a:0:{}', 6, 'Manage orders in the store.', '', 0, ''),
('admin/commerce/orders/%', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_order_admin_order_view_access', 0x613a313a7b693a303b693a333b7d, 'commerce_order_ui_order_view', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 0, '', 'admin/commerce/orders/%', '', 'commerce_order_ui_order_title', 'a:1:{i:0;i:3;}', '', 'a:0:{}', 6, '', '', 0, ''),
('admin/commerce/orders/%/delete', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_order_access', 0x613a323a7b693a303b733a363a2264656c657465223b693a313b693a333b7d, 'commerce_order_ui_order_delete_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 2, 'admin/commerce/orders/%', 'admin/commerce/orders/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 20, 'sites/all/modules/commerce/modules/order/includes/commerce_order_ui.orders.inc'),
('admin/commerce/orders/%/edit', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_order_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a333b7d, 'commerce_order_ui_order_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 3, 'admin/commerce/orders/%', 'admin/commerce/orders/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', -5, 'sites/all/modules/commerce/modules/order/includes/commerce_order_ui.orders.inc'),
('admin/commerce/orders/%/edit/checkout', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_checkout_complete_form_access', 0x613a313a7b693a303b693a333b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33313a22636f6d6d657263655f636865636b6f75745f636f6d706c6574655f666f726d223b693a313b693a333b7d, '', 59, 6, 1, 'admin/commerce/orders/%/edit', 'admin/commerce/orders/%', 'Simulate checkout completion', 't', '', '', 'a:0:{}', 388, 'Directly invokes the checkout completion rules on the order.', '', 0, 'sites/all/modules/commerce/modules/checkout/includes/commerce_checkout.admin.inc'),
('admin/commerce/orders/%/edit/refresh', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_cart_order_refresh_form_access', 0x613a313a7b693a303b693a333b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33323a22636f6d6d657263655f636172745f6f726465725f726566726573685f666f726d223b693a313b693a333b7d, '', 59, 6, 1, 'admin/commerce/orders/%/edit', 'admin/commerce/orders/%', 'Apply pricing rules', 't', '', '', 'a:0:{}', 388, 'Executes the cart order refresh used to apply all current pricing rules on the front end.', '', 0, 'sites/all/modules/commerce/modules/cart/includes/commerce_cart.admin.inc'),
('admin/commerce/orders/%/payment', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_payment_transaction_order_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a333b7d, 'commerce_payment_ui_order_tab', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 3, 'admin/commerce/orders/%', 'admin/commerce/orders/%', 'Payment', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/commerce/modules/payment/includes/commerce_payment_ui.admin.inc'),
('admin/commerce/orders/%/payment/%', 0x613a323a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b693a353b733a33333a22636f6d6d657263655f7061796d656e745f7472616e73616374696f6e5f6c6f6164223b7d, '', 'commerce_payment_transaction_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a353b7d, 'commerce_payment_ui_payment_transaction_view', 0x613a333a7b693a303b693a333b693a313b693a353b693a323b733a31333a2261646d696e6973747261746f72223b7d, '', 58, 6, 0, '', 'admin/commerce/orders/%/payment/%', '', 'commerce_payment_ui_payment_transaction_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/commerce/modules/payment/includes/commerce_payment_ui.admin.inc'),
('admin/commerce/orders/%/payment/%/delete', 0x613a323a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b693a353b733a33333a22636f6d6d657263655f7061796d656e745f7472616e73616374696f6e5f6c6f6164223b7d, '', 'commerce_payment_transaction_access', 0x613a323a7b693a303b733a363a2264656c657465223b693a313b693a353b7d, 'commerce_payment_ui_payment_transaction_delete_form_wrapper', 0x613a323a7b693a303b693a333b693a313b693a353b7d, '', 117, 7, 2, 'admin/commerce/orders/%/payment/%', 'admin/commerce/orders/%/payment/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/commerce/modules/payment/includes/commerce_payment_ui.admin.inc'),
('admin/commerce/orders/%/payment/%/paypal-wpp-capture', 0x613a323a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b693a353b733a33333a22636f6d6d657263655f7061796d656e745f7472616e73616374696f6e5f6c6f6164223b7d, '', 'commerce_paypal_wpp_capture_access', 0x613a323a7b693a303b693a333b693a313b693a353b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33323a22636f6d6d657263655f70617970616c5f7770705f636170747572655f666f726d223b693a313b693a333b693a323b693a353b7d, '', 117, 7, 2, 'admin/commerce/orders/%/payment/%', 'admin/commerce/orders/%/payment/%', 'Capture', 't', '', '', 'a:0:{}', 140, '', '', 2, 'sites/all/modules/commerce_paypal/modules/wpp/includes/commerce_paypal_wpp.admin.inc'),
('admin/commerce/orders/%/payment/%/view', 0x613a323a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b693a353b733a33333a22636f6d6d657263655f7061796d656e745f7472616e73616374696f6e5f6c6f6164223b7d, '', 'commerce_payment_transaction_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a353b7d, 'commerce_payment_ui_payment_transaction_view', 0x613a333a7b693a303b693a333b693a313b693a353b693a323b733a31333a2261646d696e6973747261746f72223b7d, '', 117, 7, 3, 'admin/commerce/orders/%/payment/%', 'admin/commerce/orders/%/payment/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/commerce/modules/payment/includes/commerce_payment_ui.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/commerce/orders/%/revisions', 0x613a313a7b693a333b4e3b7d, '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33343a2261646d696e697374657220636f6d6d657263655f6f7264657220656e746974696573223b7d7d7d, 'views_page', 0x613a333a7b693a303b733a32343a22636f6d6d657263655f6f726465725f7265766973696f6e73223b693a313b733a32303a226f726465725f7265766973696f6e735f70616765223b693a323b693a333b7d, '', 29, 5, 1, 'admin/commerce/orders/%', 'admin/commerce/orders/%', 'Revisions', 't', '', '', 'a:0:{}', 132, 'View revisions of this order.', '', 20, ''),
('admin/commerce/orders/%/view', 0x613a313a7b693a333b733a31393a22636f6d6d657263655f6f726465725f6c6f6164223b7d, '', 'commerce_order_admin_order_view_access', 0x613a313a7b693a303b693a333b7d, 'commerce_order_ui_order_view', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 3, 'admin/commerce/orders/%', 'admin/commerce/orders/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('admin/commerce/orders/add', '', '', 'commerce_order_access', 0x613a313a7b693a303b733a363a22637265617465223b7d, 'commerce_order_ui_order_form_wrapper', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a333a22756964223b693a303b733a363a22737461747573223b733a373a2270656e64696e67223b733a343a2274797065223b733a31343a22636f6d6d657263655f6f72646572223b733a383a226f726465725f6964223b4e3b733a31323a226f726465725f6e756d626572223b4e3b733a31313a227265766973696f6e5f6964223b4e3b733a343a226d61696c223b733a303a22223b733a343a2264617461223b613a303a7b7d733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b733a383a22686f73746e616d65223b733a303a22223b733a363a2269735f6e6577223b623a313b7d7d, '', 15, 4, 0, '', 'admin/commerce/orders/add', 'Create an order', 't', '', '', 'a:0:{}', 6, 'Create a new order.', '', 10, 'sites/all/modules/commerce/modules/order/includes/commerce_order_ui.orders.inc'),
('admin/commerce/orders/add/%', 0x613a313a7b693a343b733a393a22757365725f6c6f6164223b7d, '', 'commerce_order_access', 0x613a313a7b693a303b733a363a22637265617465223b7d, 'commerce_order_ui_order_form_wrapper', 0x613a323a7b693a303b4f3a383a22737464436c617373223a31323a7b733a333a22756964223b693a303b733a363a22737461747573223b733a373a2270656e64696e67223b733a343a2274797065223b733a31343a22636f6d6d657263655f6f72646572223b733a383a226f726465725f6964223b4e3b733a31323a226f726465725f6e756d626572223b4e3b733a31313a227265766973696f6e5f6964223b4e3b733a343a226d61696c223b733a303a22223b733a343a2264617461223b613a303a7b7d733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b733a383a22686f73746e616d65223b733a303a22223b733a363a2269735f6e6577223b623a313b7d693a313b693a343b7d, '', 30, 5, 0, '', 'admin/commerce/orders/add/%', 'Create an order', 't', '', '', 'a:0:{}', 6, 'Create a new order for the specified user.', '', 0, 'sites/all/modules/commerce/modules/order/includes/commerce_order_ui.orders.inc'),
('admin/commerce/orders/carts', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33303a227669657720616e7920636f6d6d657263655f6f7264657220656e74697479223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31353a22636f6d6d657263655f6f7264657273223b693a313b733a31343a2273686f7070696e675f6361727473223b7d, '', 15, 4, 1, 'admin/commerce/orders', 'admin/commerce/orders', 'Shopping carts', 't', '', '', 'a:0:{}', 132, '', '', 0, ''),
('admin/commerce/orders/list', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33303a227669657720616e7920636f6d6d657263655f6f7264657220656e74697479223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31353a22636f6d6d657263655f6f7264657273223b693a313b733a31303a2261646d696e5f70616765223b7d, '', 15, 4, 1, 'admin/commerce/orders', 'admin/commerce/orders', 'Orders', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('admin/commerce/products', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33363a2261646d696e697374657220636f6d6d657263655f70726f6475637420656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31373a22636f6d6d657263655f70726f6475637473223b693a313b733a31303a2261646d696e5f70616765223b7d, '', 7, 3, 0, '', 'admin/commerce/products', 'Products', 't', '', '', 'a:0:{}', 6, 'Manage products and product types in the store.', '', 0, ''),
('admin/commerce/products/%', 0x613a313a7b693a333b733a32313a22636f6d6d657263655f70726f647563745f6c6f6164223b7d, '', 'commerce_product_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a333b7d, 'commerce_product_ui_product_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 3, '', 'admin/commerce/products/%', '', 'commerce_product_ui_product_title', 'a:1:{i:0;i:3;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.products.inc'),
('admin/commerce/products/%/delete', 0x613a313a7b693a333b733a32313a22636f6d6d657263655f70726f647563745f6c6f6164223b7d, '', 'commerce_product_access', 0x613a323a7b693a303b733a363a2264656c657465223b693a313b693a333b7d, 'commerce_product_ui_product_delete_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 2, 'admin/commerce/products/%', 'admin/commerce/products/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 20, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.products.inc'),
('admin/commerce/products/%/edit', 0x613a313a7b693a333b733a32313a22636f6d6d657263655f70726f647563745f6c6f6164223b7d, '', 'commerce_product_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a333b7d, 'commerce_product_ui_product_form_wrapper', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 3, 'admin/commerce/products/%', 'admin/commerce/products/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.products.inc'),
('admin/commerce/products/%/revisions', 0x613a313a7b693a333b4e3b7d, '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33363a2261646d696e697374657220636f6d6d657263655f70726f6475637420656e746974696573223b7d7d7d, 'views_page', 0x613a333a7b693a303b733a32363a22636f6d6d657263655f70726f647563745f7265766973696f6e73223b693a313b733a32323a2270726f647563745f7265766973696f6e735f70616765223b693a323b693a333b7d, '', 29, 5, 1, 'admin/commerce/products/%', 'admin/commerce/products/%', 'Revisions', 't', '', '', 'a:0:{}', 132, 'View revisions of this product.', '', 0, ''),
('admin/commerce/products/add', '', '', 'commerce_product_ui_product_add_any_access', 0x613a303a7b7d, 'commerce_product_ui_add_page', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/commerce/products/add', 'Add a product', 't', '', '', 'a:0:{}', 6, 'Add a new product for sale.', '', 10, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.products.inc'),
('admin/commerce/products/add/product', '', '', 'commerce_product_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b4f3a383a22737464436c617373223a31303a7b733a343a2274797065223b733a373a2270726f64756374223b733a31303a2270726f647563745f6964223b4e3b733a363a2269735f6e6577223b623a313b733a333a22736b75223b733a303a22223b733a31313a227265766973696f6e5f6964223b4e3b733a353a227469746c65223b733a303a22223b733a333a22756964223b733a303a22223b733a363a22737461747573223b693a313b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b7d7d, 'commerce_product_ui_product_form_wrapper', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31303a7b733a343a2274797065223b733a373a2270726f64756374223b733a31303a2270726f647563745f6964223b4e3b733a363a2269735f6e6577223b623a313b733a333a22736b75223b733a303a22223b733a31313a227265766973696f6e5f6964223b4e3b733a353a227469746c65223b733a303a22223b733a333a22756964223b733a303a22223b733a363a22737461747573223b693a313b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b7d7d, '', 31, 5, 0, '', 'admin/commerce/products/add/product', 'Create !name', 't', 'a:1:{s:5:"!name";s:7:"Product";}', '', 'a:0:{}', 6, 'A basic product type.', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.products.inc'),
('admin/commerce/products/add/rooms-product', '', '', 'commerce_product_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b4f3a383a22737464436c617373223a31303a7b733a343a2274797065223b733a31333a22726f6f6d735f70726f64756374223b733a31303a2270726f647563745f6964223b4e3b733a363a2269735f6e6577223b623a313b733a333a22736b75223b733a303a22223b733a31313a227265766973696f6e5f6964223b4e3b733a353a227469746c65223b733a303a22223b733a333a22756964223b733a303a22223b733a363a22737461747573223b693a313b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b7d7d, 'commerce_product_ui_product_form_wrapper', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31303a7b733a343a2274797065223b733a31333a22726f6f6d735f70726f64756374223b733a31303a2270726f647563745f6964223b4e3b733a363a2269735f6e6577223b623a313b733a333a22736b75223b733a303a22223b733a31313a227265766973696f6e5f6964223b4e3b733a353a227469746c65223b733a303a22223b733a333a22756964223b733a303a22223b733a363a22737461747573223b693a313b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b7d7d, '', 31, 5, 0, '', 'admin/commerce/products/add/rooms-product', 'Create !name', 't', 'a:1:{s:5:"!name";s:13:"Rooms product";}', '', 'a:0:{}', 6, 'Products that are bookable with Rooms.', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.products.inc'),
('admin/commerce/products/list', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33363a2261646d696e697374657220636f6d6d657263655f70726f6475637420656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31373a22636f6d6d657263655f70726f6475637473223b693a313b733a31303a2261646d696e5f70616765223b7d, '', 15, 4, 1, 'admin/commerce/products', 'admin/commerce/products', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('admin/commerce/products/types', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'commerce_product_ui_types_overview', 0x613a303a7b7d, '', 15, 4, 1, 'admin/commerce/products', 'admin/commerce/products', 'Product types', 't', '', '', 'a:0:{}', 132, 'Manage products types for your store.', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.types.inc'),
('admin/commerce/products/types/add', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'commerce_product_ui_product_type_form_wrapper', 0x613a313a7b693a303b613a353a7b733a343a2274797065223b733a303a22223b733a343a226e616d65223b733a303a22223b733a31313a226465736372697074696f6e223b733a303a22223b733a343a2268656c70223b733a303a22223b733a383a227265766973696f6e223b693a313b7d7d, '', 31, 5, 1, 'admin/commerce/products/types', 'admin/commerce/products', 'Add product type', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.types.inc'),
('admin/commerce/products/types/product', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'commerce_product_ui_product_type_form_wrapper', 0x613a313a7b693a303b733a373a2270726f64756374223b7d, '', 31, 5, 0, '', 'admin/commerce/products/types/product', 'Product', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.types.inc'),
('admin/commerce/products/types/product/delete', '', '', 'commerce_product_ui_product_type_update_access', 0x613a313a7b693a303b733a373a2270726f64756374223b7d, 'commerce_product_ui_product_type_delete_form_wrapper', 0x613a313a7b693a303b733a373a2270726f64756374223b7d, '', 63, 6, 2, 'admin/commerce/products/types/product', 'admin/commerce/products/types/product', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.types.inc'),
('admin/commerce/products/types/product/display', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 3, 'admin/commerce/products/types/product', 'admin/commerce/products/types/product', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/display/commerce_line_item_display', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a32363a22636f6d6d657263655f6c696e655f6974656d5f646973706c6179223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a32363a22636f6d6d657263655f6c696e655f6974656d5f646973706c6179223b7d, '', 127, 7, 1, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product', 'Commerce Line item: Display', 't', '', '', 'a:0:{}', 132, '', '', 3, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/display/commerce_line_item_token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a32343a22636f6d6d657263655f6c696e655f6974656d5f746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a32343a22636f6d6d657263655f6c696e655f6974656d5f746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product', 'Commerce Line item: Tokens', 't', '', '', 'a:0:{}', 132, '', '', 4, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/display/full', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a343a2266756c6c223b7d, '', 127, 7, 1, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product', 'Admin display', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/display/line_item', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a393a226c696e655f6974656d223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a393a226c696e655f6974656d223b7d, '', 127, 7, 1, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product', 'Line item', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b693a333b733a353a22746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/products/types/product/display', 'admin/commerce/products/types/product', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/edit', '', '', 'commerce_product_ui_product_type_update_access', 0x613a313a7b693a303b733a373a2270726f64756374223b7d, 'commerce_product_ui_product_type_form_wrapper', 0x613a313a7b693a303b733a373a2270726f64756374223b7d, '', 63, 6, 3, 'admin/commerce/products/types/product', 'admin/commerce/products/types/product', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.types.inc'),
('admin/commerce/products/types/product/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a373a2270726f64756374223b7d, '', 63, 6, 3, 'admin/commerce/products/types/product', 'admin/commerce/products/types/product', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/commerce/products/types/product/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/product/fields/%', 'admin/commerce/products/types/product/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/product/fields/%', 'admin/commerce/products/types/product/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/product/fields/%', 'admin/commerce/products/types/product/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/product/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a373a2270726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/product/fields/%', 'admin/commerce/products/types/product/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'commerce_product_ui_product_type_form_wrapper', 0x613a313a7b693a303b733a31333a22726f6f6d735f70726f64756374223b7d, '', 31, 5, 0, '', 'admin/commerce/products/types/rooms-product', 'Rooms product', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/commerce/modules/product/includes/commerce_product_ui.types.inc'),
('admin/commerce/products/types/rooms-product/display', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 3, 'admin/commerce/products/types/rooms-product', 'admin/commerce/products/types/rooms-product', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/display/commerce_line_item_display', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a32363a22636f6d6d657263655f6c696e655f6974656d5f646973706c6179223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a32363a22636f6d6d657263655f6c696e655f6974656d5f646973706c6179223b7d, '', 127, 7, 1, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product', 'Commerce Line item: Display', 't', '', '', 'a:0:{}', 132, '', '', 3, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/display/commerce_line_item_token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a32343a22636f6d6d657263655f6c696e655f6974656d5f746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a32343a22636f6d6d657263655f6c696e655f6974656d5f746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product', 'Commerce Line item: Tokens', 't', '', '', 'a:0:{}', 132, '', '', 4, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/display/full', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a343a2266756c6c223b7d, '', 127, 7, 1, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product', 'Admin display', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/display/line_item', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a393a226c696e655f6974656d223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a393a226c696e655f6974656d223b7d, '', 127, 7, 1, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product', 'Line item', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b693a333b733a353a22746f6b656e223b7d, '', 127, 7, 1, 'admin/commerce/products/types/rooms-product/display', 'admin/commerce/products/types/rooms-product', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31363a22636f6d6d657263655f70726f64756374223b693a323b733a31333a22726f6f6d735f70726f64756374223b7d, '', 63, 6, 3, 'admin/commerce/products/types/rooms-product', 'admin/commerce/products/types/rooms-product', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/commerce/products/types/rooms-product/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/rooms-product/fields/%', 'admin/commerce/products/types/rooms-product/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/rooms-product/fields/%', 'admin/commerce/products/types/rooms-product/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/rooms-product/fields/%', 'admin/commerce/products/types/rooms-product/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/commerce/products/types/rooms-product/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31363a22636f6d6d657263655f70726f64756374223b693a313b733a31333a22726f6f6d735f70726f64756374223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e69737465722070726f64756374207479706573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/commerce/products/types/rooms-product/fields/%', 'admin/commerce/products/types/rooms-product/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/compact', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_compact_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/compact', 'Compact mode', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_config_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/config', 'Configuration', 't', '', '', 'a:0:{}', 6, 'Administer settings.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/content', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/content', 'Content authoring', 't', '', '', 'a:0:{}', 6, 'Settings related to formatting and authoring content.', 'left', -15, 'modules/system/system.admin.inc'),
('admin/config/content/formats', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2266696c7465725f61646d696e5f6f76657276696577223b7d, '', 15, 4, 0, '', 'admin/config/content/formats', 'Text formats', 't', '', '', 'a:0:{}', 6, 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/%', 0x613a313a7b693a343b733a31383a2266696c7465725f666f726d61745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'filter_admin_format_page', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'admin/config/content/formats/%', '', 'filter_admin_format_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/%/disable', 0x613a313a7b693a343b733a31383a2266696c7465725f666f726d61745f6c6f6164223b7d, '', '_filter_disable_format_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2266696c7465725f61646d696e5f64697361626c65223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/config/content/formats/%/disable', 'Disable text format', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/add', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'filter_admin_format_page', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'Add text format', 't', '', '', 'a:0:{}', 388, '', '', 1, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/list', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2266696c7465725f61646d696e5f6f76657276696577223b7d, '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/locationmap', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206c6f636174696f6e6d6170223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a226c6f636174696f6e6d61705f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/content/locationmap', 'Location Map', 't', '', '', 'a:0:{}', 6, 'Configure Location Map.', '', 0, ''),
('admin/config/date', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/date', 'Date API', 't', '', '', 'a:0:{}', 6, 'Settings for modules the use the Date API.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/date/date_popup', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22646174655f706f7075705f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/date/date_popup', 'Date Popup', 't', '', '', 'a:0:{}', 6, 'Configure the Date Popup settings.', '', 0, ''),
('admin/config/development', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/development', 'Development', 't', '', '', 'a:0:{}', 6, 'Development tools.', 'right', -10, 'modules/system/system.admin.inc'),
('admin/config/development/jquery_update', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a226a71756572795f7570646174655f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/development/jquery_update', 'jQuery update', 't', '', '', 'a:0:{}', 6, 'Configure settings related to the jQuery upgrade, the library path and compression.', '', 0, ''),
('admin/config/development/logging', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32333a2273797374656d5f6c6f6767696e675f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/development/logging', 'Logging and errors', 't', '', '', 'a:0:{}', 6, 'Settings for logging and alerts modules. Various modules can route Drupal''s system events to different destinations, such as syslog, database, email, etc.', '', -15, 'modules/system/system.admin.inc'),
('admin/config/development/maintenance', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a2273797374656d5f736974655f6d61696e74656e616e63655f6d6f6465223b7d, '', 15, 4, 0, '', 'admin/config/development/maintenance', 'Maintenance mode', 't', '', '', 'a:0:{}', 6, 'Take the site offline for maintenance or bring it back online.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/development/performance', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a2273797374656d5f706572666f726d616e63655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/development/performance', 'Performance', 't', '', '', 'a:0:{}', 6, 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/media', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/media', 'Media', 't', '', '', 'a:0:{}', 6, 'Media tools.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/media/colorbox', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32333a22636f6c6f72626f785f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/colorbox', 'Colorbox', 't', '', '', 'a:0:{}', 6, 'Adjust Colorbox settings.', '', 0, 'sites/all/modules/colorbox/colorbox.admin.inc'),
('admin/config/media/file-system', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a2273797374656d5f66696c655f73797374656d5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/file-system', 'File system', 't', '', '', 'a:0:{}', 6, 'Tell Drupal where to store uploaded files and how they are accessed.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/media/image-styles', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'image_style_list', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/media/image-styles', 'Image styles', 't', '', '', 'a:0:{}', 6, 'Configure styles that can be used for resizing or adjusting images on display.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/add', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22696d6167655f7374796c655f6164645f666f726d223b7d, '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Add style', 't', '', '', 'a:0:{}', 388, 'Add a new image style.', '', 2, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/delete/%', 0x613a313a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b4e3b693a313b733a313a2231223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a22696d6167655f7374796c655f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/delete/%', 'Delete style', 't', '', '', 'a:0:{}', 6, 'Delete an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%', 0x613a313a7b693a353b733a31363a22696d6167655f7374796c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31363a22696d6167655f7374796c655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/edit/%', 'Edit style', 't', '', '', 'a:0:{}', 6, 'Configure an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/add/%', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a313a7b693a303b693a353b7d7d693a373b613a313a7b733a32383a22696d6167655f6566666563745f646566696e6974696f6e5f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31373a22696d6167655f6566666563745f666f726d223b693a313b693a353b693a323b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/add/%', 'Add image effect', 't', '', '', 'a:0:{}', 6, 'Add a new effect to a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/effects/%', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d693a373b613a313a7b733a31373a22696d6167655f6566666563745f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31373a22696d6167655f6566666563745f666f726d223b693a313b693a353b693a323b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/effects/%', 'Edit image effect', 't', '', '', 'a:0:{}', 6, 'Edit an existing effect within a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/effects/%/delete', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d693a373b613a313a7b733a31373a22696d6167655f6566666563745f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32343a22696d6167655f6566666563745f64656c6574655f666f726d223b693a313b693a353b693a323b693a373b7d, '', 501, 9, 0, '', 'admin/config/media/image-styles/edit/%/effects/%/delete', 'Delete image effect', 't', '', '', 'a:0:{}', 6, 'Delete an existing effect from a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/list', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'image_style_list', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'List', 't', '', '', 'a:0:{}', 140, 'List the current image styles on the site.', '', 1, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/revert/%', 0x613a313a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b4e3b693a313b733a313a2232223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a22696d6167655f7374796c655f7265766572745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/revert/%', 'Revert style', 't', '', '', 'a:0:{}', 6, 'Revert an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-toolkit', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a2273797374656d5f696d6167655f746f6f6c6b69745f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/image-toolkit', 'Image toolkit', 't', '', '', 'a:0:{}', 6, 'Choose which image toolkit to use if you have installed optional toolkits.', '', 20, 'modules/system/system.admin.inc'),
('admin/config/people', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/people', 'People', 't', '', '', 'a:0:{}', 6, 'Configure user accounts.', 'left', -20, 'modules/system/system.admin.inc'),
('admin/config/people/accounts', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22757365725f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/people/accounts', 'Account settings', 't', '', '', 'a:0:{}', 6, 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.', '', -10, 'modules/user/user.admin.inc'),
('admin/config/people/accounts/display', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a373a2264656661756c74223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/config/people/accounts/display/full', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a343a2266756c6c223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'User account', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a353a22746f6b656e223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/people/accounts/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/delete', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/edit', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/field-settings', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/widget-type', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22757365725f61646d696e5f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Settings', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/user/user.admin.inc'),
('admin/config/people/ip-blocking', '', '', 'user_access', 0x613a313a7b693a303b733a31383a22626c6f636b20495020616464726573736573223b7d, 'system_ip_blocking', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/people/ip-blocking', 'IP address blocking', 't', '', '', 'a:0:{}', 6, 'Manage blocked IP addresses.', '', 10, 'modules/system/system.admin.inc'),
('admin/config/people/ip-blocking/delete/%', 0x613a313a7b693a353b733a31353a22626c6f636b65645f69705f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a22626c6f636b20495020616464726573736573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a2273797374656d5f69705f626c6f636b696e675f64656c657465223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/people/ip-blocking/delete/%', 'Delete IP address', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/regional', 'Regional and language', 't', '', '', 'a:0:{}', 6, 'Regional settings, localization and translation.', 'left', -5, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f646174655f74696d655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/regional/date-time', 'Date and time', 't', '', '', 'a:0:{}', 6, 'Configure display formats for date and time.', '', -15, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/date-views', '', '', 'user_access', 0x613a313a7b693a303b733a33303a2261646d696e6973746572207369746520636f6e66696775726174696f6e20223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22646174655f76696577735f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Date views', 't', '', '', 'a:0:{}', 132, 'Configure settings for date views.', '', 0, ''),
('admin/config/regional/date-time/formats', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_date_time_formats', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Formats', 't', '', '', 'a:0:{}', 132, 'Configure display format strings for date and time.', '', -9, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a2273797374656d5f646174655f64656c6574655f666f726d61745f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date format.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/edit', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33343a2273797374656d5f636f6e6669677572655f646174655f666f726d6174735f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/edit', 'Edit date format', 't', '', '', 'a:0:{}', 6, 'Allow users to edit a configured date format.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/add', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33343a2273797374656d5f636f6e6669677572655f646174655f666f726d6174735f666f726d223b7d, '', 63, 6, 1, 'admin/config/regional/date-time/formats', 'admin/config/regional/date-time', 'Add format', 't', '', '', 'a:0:{}', 388, 'Allow users to add additional date formats.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/lookup', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_date_time_lookup', 0x613a303a7b7d, '', 63, 6, 0, '', 'admin/config/regional/date-time/formats/lookup', 'Date and time lookup', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/locale', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'locale_date_format_language_overview_page', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Localize', 't', '', '', 'a:0:{}', 132, 'Configure date formats for each locale', '', -8, 'modules/locale/locale.admin.inc'),
('admin/config/regional/date-time/locale/%/edit', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a226c6f63616c655f646174655f666f726d61745f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/locale/%/edit', 'Localize date formats', 't', '', '', 'a:0:{}', 6, 'Configure date formats for each locale', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/date-time/locale/%/reset', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32393a226c6f63616c655f646174655f666f726d61745f72657365745f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/locale/%/reset', 'Reset date formats', 't', '', '', 'a:0:{}', 6, 'Reset localized date formats to global defaults', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/date-time/types', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f646174655f74696d655f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Types', 't', '', '', 'a:0:{}', 140, 'Configure display formats for date and time.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33353a2273797374656d5f64656c6574655f646174655f666f726d61745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/types/%/delete', 'Delete date type', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date type.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types/add', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2273797374656d5f6164645f646174655f666f726d61745f747970655f666f726d223b7d, '', 63, 6, 1, 'admin/config/regional/date-time/types', 'admin/config/regional/date-time', 'Add date type', 't', '', '', 'a:0:{}', 388, 'Add new date type.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/language', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226c6f63616c655f6c616e6775616765735f6f766572766965775f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/regional/language', 'Languages', 't', '', '', 'a:0:{}', 6, 'Configure languages for content and the user interface.', '', -10, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/add', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'locale_languages_add_screen', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/language', 'admin/config/regional/language', 'Add language', 't', '', '', 'a:0:{}', 388, '', '', 5, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/configure', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33313a226c6f63616c655f6c616e6775616765735f636f6e6669677572655f666f726d223b7d, '', 31, 5, 1, 'admin/config/regional/language', 'admin/config/regional/language', 'Detection and selection', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/configure/session', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33383a226c6f63616c655f6c616e67756167655f70726f7669646572735f73657373696f6e5f666f726d223b7d, '', 63, 6, 0, '', 'admin/config/regional/language/configure/session', 'Session language detection configuration', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/configure/url', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33343a226c6f63616c655f6c616e67756167655f70726f7669646572735f75726c5f666f726d223b7d, '', 63, 6, 0, '', 'admin/config/regional/language/configure/url', 'URL language detection configuration', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/delete/%', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226c6f63616c655f6c616e6775616765735f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/regional/language/delete/%', 'Confirm', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/edit/%', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226c6f63616c655f6c616e6775616765735f656469745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/regional/language/edit/%', 'Edit language', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/language/overview', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e6973746572206c616e677561676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226c6f63616c655f6c616e6775616765735f6f766572766965775f666f726d223b7d, '', 31, 5, 1, 'admin/config/regional/language', 'admin/config/regional/language', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f726567696f6e616c5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/regional/settings', 'Regional settings', 't', '', '', 'a:0:{}', 6, 'Settings for the site''s default time zone and country.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/regional/translate', '', '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'locale_translate_overview_screen', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/regional/translate', 'Translate interface', 't', '', '', 'a:0:{}', 6, 'Translate the built in interface and optionally other text.', '', -5, 'modules/locale/locale.admin.inc'),
('admin/config/regional/translate/delete/%', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'locale_translate_delete_page', 0x613a313a7b693a303b693a353b7d, '', 62, 6, 0, '', 'admin/config/regional/translate/delete/%', 'Delete string', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/translate/edit/%', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226c6f63616c655f7472616e736c6174655f656469745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/regional/translate/edit/%', 'Edit string', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/translate/export', '', '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'locale_translate_export_screen', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/translate', 'admin/config/regional/translate', 'Export', 't', '', '', 'a:0:{}', 132, '', '', 30, 'modules/locale/locale.admin.inc'),
('admin/config/regional/translate/import', '', '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a226c6f63616c655f7472616e736c6174655f696d706f72745f666f726d223b7d, '', 31, 5, 1, 'admin/config/regional/translate', 'admin/config/regional/translate', 'Import', 't', '', '', 'a:0:{}', 132, '', '', 20, 'modules/locale/locale.admin.inc'),
('admin/config/regional/translate/overview', '', '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'locale_translate_overview_screen', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/translate', 'admin/config/regional/translate', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/locale/locale.admin.inc'),
('admin/config/regional/translate/translate', '', '', 'user_access', 0x613a313a7b693a303b733a31393a227472616e736c61746520696e74657266616365223b7d, 'locale_translate_seek_screen', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/translate', 'admin/config/regional/translate', 'Translate', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/locale/locale.admin.inc'),
('admin/config/search', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/search', 'Search and metadata', 't', '', '', 'a:0:{}', 6, 'Local site search, metadata and SEO.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/search/clean-urls', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f636c65616e5f75726c5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/search/clean-urls', 'Clean URLs', 't', '', '', 'a:0:{}', 6, 'Enable or disable clean URLs for your site.', '', 5, 'modules/system/system.admin.inc'),
('admin/config/search/clean-urls/check', '', '', '1', 0x613a303a7b7d, 'drupal_json_output', 0x613a313a7b693a303b613a313a7b733a363a22737461747573223b623a313b7d7d, '', 31, 5, 0, '', 'admin/config/search/clean-urls/check', 'Clean URL check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/search/path', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_overview', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/search/path', 'URL aliases', 't', '', '', 'a:0:{}', 6, 'Change your site''s URL paths by aliasing them.', '', -5, 'modules/path/path.admin.inc'),
('admin/config/search/path/add', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_edit', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Add alias', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/delete/%', 0x613a313a7b693a353b733a393a22706174685f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a22706174685f61646d696e5f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/search/path/delete/%', 'Delete alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/delete_bulk', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a22706174686175746f5f61646d696e5f64656c657465223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Delete aliases', 't', '', '', 'a:0:{}', 132, '', '', 40, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/path/edit/%', 0x613a313a7b693a353b733a393a22706174685f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_edit', 0x613a313a7b693a303b693a353b7d, '', 62, 6, 0, '', 'admin/config/search/path/edit/%', 'Edit alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/list', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_overview', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/path/path.admin.inc'),
('admin/config/search/path/patterns', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220706174686175746f223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22706174686175746f5f7061747465726e735f666f726d223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Patterns', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/path/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220706174686175746f223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22706174686175746f5f73657474696e67735f666f726d223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 20, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/path/update_bulk', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a22706174686175746f5f62756c6b5f7570646174655f666f726d223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Bulk update', 't', '', '', 'a:0:{}', 132, '', '', 30, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220736561726368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a227365617263685f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/search/settings', 'Search settings', 't', '', '', 'a:0:{}', 6, 'Configure relevance settings for search and other indexing options.', '', -10, 'modules/search/search.admin.inc'),
('admin/config/search/settings/reindex', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220736561726368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a227365617263685f7265696e6465785f636f6e6669726d223b7d, '', 31, 5, 0, '', 'admin/config/search/settings/reindex', 'Clear index', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/search/search.admin.inc'),
('admin/config/search/sitemap', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a22736974655f6d61705f61646d696e5f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/search/sitemap', 'Site map', 't', '', '', 'a:0:{}', 6, 'Control what should be displayed on the site map.', '', 0, 'sites/all/modules/site_map/site_map.admin.inc'),
('admin/config/services', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/services', 'Web services', 't', '', '', 'a:0:{}', 6, 'Tools related to web services.', 'right', 0, 'modules/system/system.admin.inc'),
('admin/config/services/rss-publishing', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f7273735f66656564735f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/services/rss-publishing', 'RSS publishing', 't', '', '', 'a:0:{}', 6, 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/system', 'System', 't', '', '', 'a:0:{}', 6, 'General system related configuration.', 'right', -20, 'modules/system/system.admin.inc'),
('admin/config/system/actions', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_manage', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/system/actions', 'Actions', 't', '', '', 'a:0:{}', 6, 'Manage the actions defined for your site.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f616374696f6e735f636f6e666967757265223b7d, '', 31, 5, 0, '', 'admin/config/system/actions/configure', 'Configure an advanced action', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/delete/%', 0x613a313a7b693a353b733a31323a22616374696f6e735f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a2273797374656d5f616374696f6e735f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/system/actions/delete/%', 'Delete action', 't', '', '', 'a:0:{}', 6, 'Delete an action.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/manage', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_manage', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/system/actions', 'admin/config/system/actions', 'Manage actions', 't', '', '', 'a:0:{}', 140, 'Manage the actions defined for your site.', '', -2, 'modules/system/system.admin.inc'),
('admin/config/system/actions/orphan', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_remove_orphans', 0x613a303a7b7d, '', 31, 5, 0, '', 'admin/config/system/actions/orphan', 'Remove orphans', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/cron', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2273797374656d5f63726f6e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/cron', 'Cron', 't', '', '', 'a:0:{}', 6, 'Manage automatic site maintenance tasks.', '', 20, 'modules/system/system.admin.inc'),
('admin/config/system/site-information', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2273797374656d5f736974655f696e666f726d6174696f6e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/site-information', 'Site information', 't', '', '', 'a:0:{}', 6, 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/system/statistics', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e69737465722073746174697374696373223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22737461746973746963735f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/system/statistics', 'Statistics', 't', '', '', 'a:0:{}', 6, 'Control details about what and how your site logs access statistics.', '', -15, 'modules/statistics/statistics.admin.inc'),
('admin/config/user-interface', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/user-interface', 'User interface', 't', '', '', 'a:0:{}', 6, 'Tools that enhance the user interface.', 'right', -15, 'modules/system/system.admin.inc'),
('admin/config/user-interface/shortcut', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e69737465722073686f727463757473223b7d, 'shortcut_set_admin', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/user-interface/shortcut', 'Shortcuts', 't', '', '', 'a:0:{}', 6, 'Add and modify shortcut sets.', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f637573746f6d697a65223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/config/user-interface/shortcut/%', 'Edit shortcuts', 'shortcut_set_title_callback', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/add-link', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31373a2273686f72746375745f6c696e6b5f616464223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Add shortcut', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/add-link-inline', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'shortcut_link_add_inline', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 0, '', 'admin/config/user-interface/shortcut/%/add-link-inline', 'Add shortcut', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/delete', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_delete_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a2273686f72746375745f7365745f64656c6574655f666f726d223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/config/user-interface/shortcut/%/delete', 'Delete shortcut set', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/edit', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f656469745f666f726d223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Edit set name', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/links', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f637573746f6d697a65223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'List links', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/add-set', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e69737465722073686f727463757473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273686f72746375745f7365745f6164645f666f726d223b7d, '', 31, 5, 1, 'admin/config/user-interface/shortcut', 'admin/config/user-interface/shortcut', 'Add shortcut set', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/link/%', 0x613a313a7b693a353b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'shortcut_link_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31383a2273686f72746375745f6c696e6b5f65646974223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/user-interface/shortcut/link/%', 'Edit shortcut', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/link/%/delete', 0x613a313a7b693a353b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'shortcut_link_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2273686f72746375745f6c696e6b5f64656c657465223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/user-interface/shortcut/link/%/delete', 'Delete shortcut', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/superfish', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e697374657220737570657266697368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a227375706572666973685f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/user-interface/superfish', 'Superfish', 't', '', '', 'a:0:{}', 6, 'Configure Superfish Menus', '', 0, 'sites/all/modules/superfish/superfish.admin.inc'),
('admin/config/workflow', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/workflow', 'Workflow', 't', '', '', 'a:0:{}', 6, 'Content workflow, editorial workflow tools.', 'right', 5, 'modules/system/system.admin.inc'),
('admin/config/workflow/rules', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32393a2272756c65735f61646d696e5f7265616374696f6e5f6f76657276696577223b693a313b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 15, 4, 0, '', 'admin/config/workflow/rules', 'Rules', 't', '', '', 'a:0:{}', 6, 'Manage reaction rules and rule components.', 'right', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/autocomplete_tags', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'rules_autocomplete_tags', 0x613a313a7b693a303b693a353b7d, '', 31, 5, 0, '', 'admin/config/workflow/rules/autocomplete_tags', 'Rules tags autocomplete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33313a2272756c65735f61646d696e5f636f6d706f6e656e74735f6f76657276696577223b693a313b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 31, 5, 1, 'admin/config/workflow/rules', 'admin/config/workflow/rules', 'Components', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/components/add', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a2272756c65735f61646d696e5f6164645f636f6d706f6e656e74223b693a313b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 63, 6, 1, 'admin/config/workflow/rules/components', 'admin/config/workflow/rules', 'Add new component', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/components/import', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2272756c65735f75695f696d706f72745f666f726d223b693a313b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 63, 6, 1, 'admin/config/workflow/rules/components', 'admin/config/workflow/rules', 'Import component', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33313a2272756c65735f75695f666f726d5f656469745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 126, 7, 0, '', 'admin/config/workflow/rules/components/manage/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/%', 0x613a323a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b693a373b4e3b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33373a2272756c65735f75695f666f726d5f72756c65735f636f6e6669675f636f6e6669726d5f6f70223b693a313b693a363b693a323b693a373b693a333b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 252, 8, 0, '', 'admin/config/workflow/rules/components/manage/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/add/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a353a7b693a303b733a32303a2272756c65735f75695f6164645f656c656d656e74223b693a313b693a363b693a323b693a393b693a333b693a383b693a343b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 506, 9, 0, '', 'admin/config/workflow/rules/components/manage/%/add/%', '', 'rules_menu_add_element_title', 'a:1:{i:0;a:1:{i:0;i:9;}}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/add/event', 0x613a313a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32333a2272756c65735f75695f6164645f6576656e745f70616765223b693a313b693a363b693a323b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 507, 9, 0, '', 'admin/config/workflow/rules/components/manage/%/add/event', '', 'rules_get_title', 'a:2:{i:0;s:32:"Adding event to !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/autocomplete', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'rules_ui_form_data_selection_auto_completion', 0x613a333a7b693a303b693a383b693a313b693a393b693a323b693a31303b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/components/manage/%/autocomplete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/clone', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33323a2272756c65735f75695f666f726d5f636c6f6e655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/components/manage/%/clone', '', 'rules_get_title', 'a:2:{i:0;s:24:"Cloning !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/delete/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32333a2272756c65735f75695f64656c6574655f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 506, 9, 0, '', 'admin/config/workflow/rules/components/manage/%/delete/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/delete/event', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f72656d6f76655f6576656e74223b693a313b693a363b693a323b693a393b693a333b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 507, 9, 0, '', 'admin/config/workflow/rules/components/manage/%/delete/event', 'Remove event', 't', '', '', 'a:0:{}', 6, 'Remove an event from a reaction rule.', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/edit/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f656469745f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 506, 9, 0, '', 'admin/config/workflow/rules/components/manage/%/edit/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/execute', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33343a2272756c65735f75695f666f726d5f657865637574655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/components/manage/%/execute', '', 'rules_get_title', 'a:2:{i:0;s:26:"Executing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/components/manage/%/export', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33333a2272756c65735f75695f666f726d5f6578706f72745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33383a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f636f6d706f6e656e7473223b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/components/manage/%/export', '', 'rules_get_title', 'a:2:{i:0;s:26:"Export of !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32393a2272756c65735f61646d696e5f7265616374696f6e5f6f76657276696577223b693a313b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 31, 5, 1, 'admin/config/workflow/rules', 'admin/config/workflow/rules', 'Rules', 't', '', '', 'a:0:{}', 140, '', '', -1, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/reaction/add', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32393a2272756c65735f61646d696e5f6164645f7265616374696f6e5f72756c65223b693a313b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 63, 6, 1, 'admin/config/workflow/rules/reaction', 'admin/config/workflow/rules', 'Add new rule', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/reaction/import', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2272756c65735f75695f696d706f72745f666f726d223b693a313b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 63, 6, 1, 'admin/config/workflow/rules/reaction', 'admin/config/workflow/rules', 'Import rule', 't', '', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33313a2272756c65735f75695f666f726d5f656469745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 126, 7, 0, '', 'admin/config/workflow/rules/reaction/manage/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 4, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/%', 0x613a323a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b693a373b4e3b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33373a2272756c65735f75695f666f726d5f72756c65735f636f6e6669675f636f6e6669726d5f6f70223b693a313b693a363b693a323b693a373b693a333b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 252, 8, 0, '', 'admin/config/workflow/rules/reaction/manage/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/config/workflow/rules/reaction/manage/%/add/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a353a7b693a303b733a32303a2272756c65735f75695f6164645f656c656d656e74223b693a313b693a363b693a323b693a393b693a333b693a383b693a343b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 506, 9, 0, '', 'admin/config/workflow/rules/reaction/manage/%/add/%', '', 'rules_menu_add_element_title', 'a:1:{i:0;a:1:{i:0;i:9;}}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/add/event', 0x613a313a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32333a2272756c65735f75695f6164645f6576656e745f70616765223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 507, 9, 0, '', 'admin/config/workflow/rules/reaction/manage/%/add/event', '', 'rules_get_title', 'a:2:{i:0;s:32:"Adding event to !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/autocomplete', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'rules_ui_form_data_selection_auto_completion', 0x613a333a7b693a303b693a383b693a313b693a393b693a323b693a31303b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/reaction/manage/%/autocomplete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/clone', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33323a2272756c65735f75695f666f726d5f636c6f6e655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/reaction/manage/%/clone', '', 'rules_get_title', 'a:2:{i:0;s:24:"Cloning !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/delete/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32333a2272756c65735f75695f64656c6574655f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 506, 9, 0, '', 'admin/config/workflow/rules/reaction/manage/%/delete/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/delete/event', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f72656d6f76655f6576656e74223b693a313b693a363b693a323b693a393b693a333b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 507, 9, 0, '', 'admin/config/workflow/rules/reaction/manage/%/delete/event', 'Remove event', 't', '', '', 'a:0:{}', 6, 'Remove an event from a reaction rule.', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/edit/%', 0x613a323a7b693a363b613a313a7b733a31373a2272756c65735f636f6e6669675f6c6f6164223b613a313a7b693a303b693a363b7d7d693a383b613a313a7b733a31383a2272756c65735f656c656d656e745f6c6f6164223b613a313a7b693a303b693a363b7d7d7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a343a7b693a303b733a32313a2272756c65735f75695f656469745f656c656d656e74223b693a313b693a363b693a323b693a383b693a333b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 506, 9, 0, '', 'admin/config/workflow/rules/reaction/manage/%/edit/%', '', 'rules_get_title', 'a:2:{i:0;s:24:"Editing !plugin "!label"";i:1;i:8;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/execute', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33343a2272756c65735f75695f666f726d5f657865637574655f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/reaction/manage/%/execute', '', 'rules_get_title', 'a:2:{i:0;s:26:"Executing !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/reaction/manage/%/export', 0x613a313a7b693a363b733a31373a2272756c65735f636f6e6669675f6c6f6164223b7d, '', 'rules_config_access', 0x613a323a7b693a303b733a343a2276696577223b693a313b693a363b7d, 'drupal_get_form', 0x613a333a7b693a303b733a33333a2272756c65735f75695f666f726d5f6578706f72745f72756c65735f636f6e666967223b693a313b693a363b693a323b733a33363a2261646d696e2f636f6e6669672f776f726b666c6f772f72756c65732f7265616374696f6e223b7d, '', 253, 8, 0, '', 'admin/config/workflow/rules/reaction/manage/%/export', '', 'rules_get_title', 'a:2:{i:0;s:26:"Export of !plugin "!label"";i:1;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rules/ui/ui.forms.inc'),
('admin/config/workflow/rules/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2272756c65735f61646d696e5f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/workflow/rules', 'admin/config/workflow/rules', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 1, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/settings/advanced', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a2272756c65735f61646d696e5f73657474696e67735f616476616e636564223b7d, '', 63, 6, 1, 'admin/config/workflow/rules/settings', 'admin/config/workflow/rules', 'Advanced', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/settings/basic', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2272756c65735f61646d696e5f73657474696e6773223b7d, '', 63, 6, 1, 'admin/config/workflow/rules/settings', 'admin/config/workflow/rules', 'Basic', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/rules/rules_admin/rules_admin.inc'),
('admin/config/workflow/rules/upgrade', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a2272756c65735f757067726164655f666f726d223b7d, '', 31, 5, 0, '', 'admin/config/workflow/rules/upgrade', 'Upgrade', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/includes/rules.upgrade.inc'),
('admin/config/workflow/rules/upgrade/clear', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e69737465722072756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2272756c65735f757067726164655f636f6e6669726d5f636c6561725f666f726d223b7d, '', 63, 6, 0, '', 'admin/config/workflow/rules/upgrade/clear', 'Clear', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/rules/includes/rules.upgrade.inc'),
('admin/content', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261636365737320636f6e74656e74206f76657276696577223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a226e6f64655f61646d696e5f636f6e74656e74223b7d, '', 3, 2, 0, '', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 6, 'Administer content and comments.', '', -10, 'modules/node/node.admin.inc'),
('admin/content/comment', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a303a7b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Comments', 't', '', '', 'a:0:{}', 134, 'List and edit site comments and the comment approval queue.', '', 0, 'modules/comment/comment.admin.inc'),
('admin/content/comment/approval', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a313a7b693a303b733a383a22617070726f76616c223b7d, '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Unapproved comments', 'comment_count_unpublished', '', '', 'a:0:{}', 132, '', '', 0, 'modules/comment/comment.admin.inc'),
('admin/content/comment/new', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a303a7b7d, '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Published comments', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/comment/comment.admin.inc'),
('admin/content/node', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261636365737320636f6e74656e74206f76657276696577223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a226e6f64655f61646d696e5f636f6e74656e74223b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/node/node.admin.inc'),
('admin/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a31363a226163636573732064617368626f617264223b7d, 'dashboard_admin', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/dashboard', 'Dashboard', 't', '', '', 'a:0:{}', 6, 'View and customize your dashboard.', '', -15, ''),
('admin/dashboard/block-content/%/%', 0x613a323a7b693a333b4e3b693a343b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_show_block_content', 0x613a323a7b693a303b693a333b693a313b693a343b7d, '', 28, 5, 0, '', 'admin/dashboard/block-content/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/dashboard/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_admin_blocks', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/configure', 'Configure available dashboard blocks', 't', '', '', 'a:0:{}', 4, 'Configure which blocks can be shown on the dashboard.', '', 0, ''),
('admin/dashboard/customize', '', '', 'user_access', 0x613a313a7b693a303b733a31363a226163636573732064617368626f617264223b7d, 'dashboard_admin', 0x613a313a7b693a303b623a313b7d, '', 7, 3, 0, '', 'admin/dashboard/customize', 'Customize dashboard', 't', '', '', 'a:0:{}', 4, 'Customize your dashboard.', '', 0, ''),
('admin/dashboard/drawer', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_show_disabled', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/drawer', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/dashboard/update', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_update', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/update', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/help', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_main', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/help', 'Help', 't', '', '', 'a:0:{}', 6, 'Reference for usage, configuration, and modules.', '', 9, 'modules/help/help.admin.inc'),
('admin/help/block', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/block', 'block', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/color', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/color', 'color', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/comment', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/comment', 'comment', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_checkout', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_checkout', 'commerce_checkout', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_customer_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_customer_ui', 'commerce_customer_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_line_item_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_line_item_ui', 'commerce_line_item_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_order_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_order_ui', 'commerce_order_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_payment_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_payment_ui', 'commerce_payment_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_product_pricing_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_product_pricing_ui', 'commerce_product_pricing_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/commerce_product_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/commerce_product_ui', 'commerce_product_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/contact', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/contact', 'contact', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/contextual', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/contextual', 'contextual', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/dashboard', 'dashboard', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/date', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/date', 'date', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/dblog', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/dblog', 'dblog', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field', 'field', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field_sql_storage', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field_sql_storage', 'field_sql_storage', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field_ui', 'field_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/file', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/file', 'file', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/filter', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/filter', 'filter', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/help', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/help', 'help', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/image', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/image', 'image', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/jcarousel', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/jcarousel', 'jcarousel', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/jquery_update', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/jquery_update', 'jquery_update', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/list', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/list', 'list', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/locale', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/locale', 'locale', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/locationmap', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/locationmap', 'locationmap', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/menu', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/menu', 'menu', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/node', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/node', 'node', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/number', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/number', 'number', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/options', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/options', 'options', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/overlay', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/overlay', 'overlay', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/path', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/path', 'path', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/pathauto', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/pathauto', 'pathauto', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/php', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/php', 'php', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/poll', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/poll', 'poll', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/rdf', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/rdf', 'rdf', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/rules', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/rules', 'rules', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/search', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/search', 'search', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/shortcut', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/shortcut', 'shortcut', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/statistics', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/statistics', 'statistics', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/superfish', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/superfish', 'superfish', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/syslog', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/syslog', 'syslog', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/system', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/system', 'system', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/taxonomy', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/taxonomy', 'taxonomy', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/text', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/text', 'text', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/token', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/token', 'token', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/toolbar', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/toolbar', 'toolbar', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/tracker', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/tracker', 'tracker', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/translation', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/translation', 'translation', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/trigger', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/trigger', 'trigger', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/update', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/update', 'update', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/user', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/user', 'user', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/views_accordion', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/views_accordion', 'views_accordion', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/views_slideshow', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/views_slideshow', 'views_slideshow', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/views_slideshow_cycle', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/views_slideshow_cycle', 'views_slideshow_cycle', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/index', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_index', 0x613a303a7b7d, '', 3, 2, 1, 'admin', 'admin', 'Index', 't', '', '', 'a:0:{}', 132, '', '', -18, 'modules/system/system.admin.inc'),
('admin/modules', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 3, 2, 0, '', 'admin/modules', 'Modules', 't', '', '', 'a:0:{}', 6, 'Extend site functionality.', '', -2, 'modules/system/system.admin.inc'),
('admin/modules/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a363a226d6f64756c65223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Install new module', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/modules/list', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/list/confirm', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 15, 4, 0, '', 'admin/modules/list/confirm', 'List', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/uninstall', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f6d6f64756c65735f756e696e7374616c6c223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Uninstall', 't', '', '', 'a:0:{}', 132, '', '', 20, 'modules/system/system.admin.inc'),
('admin/modules/uninstall/confirm', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f6d6f64756c65735f756e696e7374616c6c223b7d, '', 15, 4, 0, '', 'admin/modules/uninstall/confirm', 'Uninstall', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a363a226d6f64756c65223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/people', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a343a226c697374223b7d, '', 3, 2, 0, '', 'admin/people', 'People', 't', '', '', 'a:0:{}', 6, 'Manage user accounts, roles, and permissions.', 'left', -4, 'modules/user/user.admin.inc'),
('admin/people/create', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a363a22637265617465223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'Add user', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/user/user.admin.inc'),
('admin/people/people', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a343a226c697374223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'List', 't', '', '', 'a:0:{}', 140, 'Find and manage people interacting with your site.', '', -10, 'modules/user/user.admin.inc'),
('admin/people/permissions', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22757365725f61646d696e5f7065726d697373696f6e73223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'Permissions', 't', '', '', 'a:0:{}', 132, 'Determine access to features by selecting permissions for roles.', '', 0, 'modules/user/user.admin.inc'),
('admin/people/permissions/list', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22757365725f61646d696e5f7065726d697373696f6e73223b7d, '', 15, 4, 1, 'admin/people/permissions', 'admin/people', 'Permissions', 't', '', '', 'a:0:{}', 140, 'Determine access to features by selecting permissions for roles.', '', -8, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a22757365725f61646d696e5f726f6c6573223b7d, '', 15, 4, 1, 'admin/people/permissions', 'admin/people', 'Roles', 't', '', '', 'a:0:{}', 132, 'List, edit, or add user roles.', '', -5, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles/delete/%', 0x613a313a7b693a353b733a31343a22757365725f726f6c655f6c6f6164223b7d, '', 'user_role_edit_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a22757365725f61646d696e5f726f6c655f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/people/permissions/roles/delete/%', 'Delete role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles/edit/%', 0x613a313a7b693a353b733a31343a22757365725f726f6c655f6c6f6164223b7d, '', 'user_role_edit_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31353a22757365725f61646d696e5f726f6c65223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/people/permissions/roles/edit/%', 'Edit role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.admin.inc'),
('admin/reports', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/reports', 'Reports', 't', '', '', 'a:0:{}', 6, 'View reports, updates, and errors.', 'left', 5, 'modules/system/system.admin.inc'),
('admin/reports/access-denied', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_top', 0x613a313a7b693a303b733a31333a226163636573732064656e696564223b7d, '', 7, 3, 0, '', 'admin/reports/access-denied', 'Top ''access denied'' errors', 't', '', '', 'a:0:{}', 6, 'View ''access denied'' errors (403s).', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/access/%', 0x613a313a7b693a333b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_access_log', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 0, '', 'admin/reports/access/%', 'Details', 't', '', '', 'a:0:{}', 6, 'View access log.', '', 0, 'modules/statistics/statistics.admin.inc'),
('admin/reports/dblog', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_overview', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/dblog', 'Recent log messages', 't', '', '', 'a:0:{}', 6, 'View events that have recently been logged.', '', -1, 'modules/dblog/dblog.admin.inc'),
('admin/reports/event/%', 0x613a313a7b693a333b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_event', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 0, '', 'admin/reports/event/%', 'Details', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'field_ui_fields_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/fields', 'Field list', 't', '', '', 'a:0:{}', 6, 'Overview of fields on all entity types.', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/list', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'field_ui_fields_list', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/views-fields', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_field_list', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'Used in views', 't', '', '', 'a:0:{}', 132, 'Overview of fields used in all views.', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/reports/hits', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_recent_hits', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/hits', 'Recent hits', 't', '', '', 'a:0:{}', 6, 'View pages that have recently been visited.', '', 0, 'modules/statistics/statistics.admin.inc'),
('admin/reports/page-not-found', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_top', 0x613a313a7b693a303b733a31343a2270616765206e6f7420666f756e64223b7d, '', 7, 3, 0, '', 'admin/reports/page-not-found', 'Top ''page not found'' errors', 't', '', '', 'a:0:{}', 6, 'View ''page not found'' errors (404s).', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/pages', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_top_pages', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/pages', 'Top pages', 't', '', '', 'a:0:{}', 6, 'View pages that have been hit frequently.', '', 1, 'modules/statistics/statistics.admin.inc'),
('admin/reports/referrers', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_top_referrers', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/referrers', 'Top referrers', 't', '', '', 'a:0:{}', 6, 'View top referrers.', '', 0, 'modules/statistics/statistics.admin.inc'),
('admin/reports/search', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'dblog_top', 0x613a313a7b693a303b733a363a22736561726368223b7d, '', 7, 3, 0, '', 'admin/reports/search', 'Top search phrases', 't', '', '', 'a:0:{}', 6, 'View most popular search phrases.', '', 0, 'modules/dblog/dblog.admin.inc'),
('admin/reports/status', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_status', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/status', 'Status report', 't', '', '', 'a:0:{}', 6, 'Get a status report about your site''s operation and any detected problems.', '', -60, 'modules/system/system.admin.inc'),
('admin/reports/status/php', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_php', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/status/php', 'PHP', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/reports/status/rebuild', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226e6f64655f636f6e6669677572655f72656275696c645f636f6e6669726d223b7d, '', 15, 4, 0, '', 'admin/reports/status/rebuild', 'Rebuild permissions', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/node/node.admin.inc'),
('admin/reports/status/run-cron', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_run_cron', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/status/run-cron', 'Run cron', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/reports/updates', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_status', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/updates', 'Available updates', 't', '', '', 'a:0:{}', 6, 'Get a status report about available updates for your installed modules and themes.', '', -50, 'modules/update/update.report.inc'),
('admin/reports/updates/check', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_manual_status', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/updates/check', 'Manual update check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/update/update.fetch.inc'),
('admin/reports/updates/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a363a227265706f7274223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Install new module or theme', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/reports/updates/list', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_status', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/update/update.report.inc'),
('admin/reports/updates/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31353a227570646174655f73657474696e6773223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 50, 'modules/update/update.settings.inc'),
('admin/reports/updates/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a363a227265706f7274223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/reports/views-plugins', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_plugin_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/views-plugins', 'Views plugins', 't', '', '', 'a:0:{}', 6, 'Overview of plugins used in all views.', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/reports/visitors', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_top_visitors', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/visitors', 'Top visitors', 't', '', '', 'a:0:{}', 6, 'View visitors that hit many pages.', '', 2, 'modules/statistics/statistics.admin.inc'),
('admin/rooms', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/rooms', 'Rooms', 't', '', '', 'a:0:{}', 6, 'Administer Rooms.', '', -7, 'modules/system/system.admin.inc'),
('admin/rooms/add_customers', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220726f6f6d735f626f6f6b696e6720656e746974696573223b7d, 'rooms_booking_add_customer_profile', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/rooms/add_customers', 'Add customer profile', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/rooms/bookings', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33333a2261646d696e697374657220726f6f6d735f626f6f6b696e6720656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a383a22626f6f6b696e6773223b693a313b733a363a22706167655f31223b7d, '', 7, 3, 0, '', 'admin/rooms/bookings', 'Bookings', 't', '', '', 'a:0:{}', 6, 'A list of all bookings. Bookings can be created, edited or deleted manually or can be created following a purchase from a client using Drupal Commerce.', '', 0, ''),
('admin/rooms/bookings/add', '', '', '_rooms_booking_add_access', 0x613a303a7b7d, 'rooms_booking_add_page', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/rooms/bookings/add', 'Add a Booking', 't', '', '', 'a:0:{}', 6, 'Add a new Booking', '', 20, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking.admin.inc'),
('admin/rooms/bookings/add/standard_booking', '', '', 'rooms_booking_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b4f3a31323a22526f6f6d73426f6f6b696e67223a31333a7b733a31373a2273746172745f646174655f6f626a656374223b4e3b733a31353a22656e645f646174655f6f626a656374223b4e3b733a31333a22002a00656e7469747954797065223b733a31333a22726f6f6d735f626f6f6b696e67223b733a31353a22002a0064656661756c744c6162656c223b623a303b733a343a2274797065223b733a31363a227374616e646172645f626f6f6b696e67223b733a333a22756964223b693a303b733a31303a22626f6f6b696e675f6964223b733a303a22223b733a363a2269735f6e6577223b623a313b733a353a227469746c65223b733a303a22223b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b733a383a226f726465725f6964223b733a303a22223b733a343a2264617461223b613a303a7b7d7d7d, 'rooms_booking_create_form_wrapper', 0x613a313a7b693a303b733a31363a227374616e646172645f626f6f6b696e67223b7d, '', 31, 5, 0, '', 'admin/rooms/bookings/add/standard_booking', 'Add @booking_type', 't', 'a:1:{s:13:"@booking_type";s:16:"Standard Booking";}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking.admin.inc'),
('admin/rooms/bookings/booking-types', '', '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33323a22726f6f6d735f626f6f6b696e675f747970655f6f766572766965775f666f726d223b693a313b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b7d, '', 15, 4, 1, 'admin/rooms/bookings', 'admin/rooms/bookings', 'Booking Types', 't', '', '', 'a:0:{}', 132, 'Manage booking types, including adding and removing fields and the display of fields.', '', 3, 'sites/all/modules/entity/includes/entity.ui.inc'),
('admin/rooms/bookings/booking-types/add', '', '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'entity_ui_get_form', 0x613a333a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b693a313b4e3b693a323b733a333a22616464223b7d, '', 31, 5, 1, 'admin/rooms/bookings/booking-types', 'admin/rooms/bookings', '', 'entity_ui_get_action_title', 'a:2:{i:0;s:3:"add";i:1;s:18:"rooms_booking_type";}', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking_type.admin.inc'),
('admin/rooms/bookings/booking-types/import', '', '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33333a22726f6f6d735f626f6f6b696e675f747970655f6f7065726174696f6e5f666f726d223b693a313b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b693a323b4e3b693a333b733a363a22696d706f7274223b7d, '', 31, 5, 1, 'admin/rooms/bookings/booking-types', 'admin/rooms/bookings', '', 'entity_ui_get_action_title', 'a:2:{i:0;s:6:"import";i:1;s:18:"rooms_booking_type";}', '', 'a:0:{}', 388, '', '', 0, 'sites/all/modules/entity/includes/entity.ui.inc'),
('admin/rooms/bookings/booking-types/list', '', '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33323a22726f6f6d735f626f6f6b696e675f747970655f6f766572766965775f666f726d223b693a313b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b7d, '', 31, 5, 1, 'admin/rooms/bookings/booking-types', 'admin/rooms/bookings', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/entity/includes/entity.ui.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/rooms/bookings/booking-types/manage/%', 0x613a313a7b693a353b613a313a7b733a31383a22656e746974795f6f626a6563745f6c6f6164223b613a313a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'entity_ui_get_form', 0x613a323a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/rooms/bookings/booking-types/manage/%', 'Edit', 'entity_label', 'a:2:{i:0;s:18:"rooms_booking_type";i:1;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking_type.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/%', 0x613a323a7b693a353b613a313a7b733a31383a22656e746974795f6f626a6563745f6c6f6164223b613a313a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b7d7d693a363b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33333a22726f6f6d735f626f6f6b696e675f747970655f6f7065726174696f6e5f666f726d223b693a313b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b693a323b693a353b693a333b693a363b7d, '', 124, 7, 0, '', 'admin/rooms/bookings/booking-types/manage/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/entity/includes/entity.ui.inc'),
('admin/rooms/bookings/booking-types/manage/%/clone', 0x613a313a7b693a353b613a313a7b733a31383a22656e746974795f6f626a6563745f6c6f6164223b613a313a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'entity_ui_get_form', 0x613a333a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b693a313b693a353b693a323b733a353a22636c6f6e65223b7d, '', 125, 7, 0, '', 'admin/rooms/bookings/booking-types/manage/%/clone', 'Clone', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking_type.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/display', 0x613a313a7b693a353b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b693a353b693a333b733a373a2264656661756c74223b7d, '', 125, 7, 1, 'admin/rooms/bookings/booking-types/manage/%', 'admin/rooms/bookings/booking-types/manage/%', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/display/default', 0x613a313a7b693a353b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b7d, '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b693a353b693a333b733a373a2264656661756c74223b7d, '', 251, 8, 1, 'admin/rooms/bookings/booking-types/manage/%/display', 'admin/rooms/bookings/booking-types/manage/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/edit', 0x613a313a7b693a353b613a313a7b733a31383a22656e746974795f6f626a6563745f6c6f6164223b613a313a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'entity_ui_get_form', 0x613a323a7b693a303b733a31383a22726f6f6d735f626f6f6b696e675f74797065223b693a313b693a353b7d, '', 125, 7, 1, 'admin/rooms/bookings/booking-types/manage/%', 'admin/rooms/bookings/booking-types/manage/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking_type.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/fields', 0x613a313a7b693a353b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31333a22726f6f6d735f626f6f6b696e67223b693a323b693a353b7d, '', 125, 7, 1, 'admin/rooms/bookings/booking-types/manage/%', 'admin/rooms/bookings/booking-types/manage/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/fields/%', 0x613a323a7b693a353b613a313a7b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a373b7d, '', 250, 8, 0, '', 'admin/rooms/bookings/booking-types/manage/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:7;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/fields/%/delete', 0x613a323a7b693a353b613a313a7b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/fields/%/edit', 0x613a323a7b693a353b613a313a7b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/fields/%/field-settings', 0x613a323a7b693a353b613a313a7b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking-types/manage/%/fields/%/widget-type', 0x613a323a7b693a353b613a313a7b733a32333a22726f6f6d735f626f6f6b696e675f747970655f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d693a373b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31333a22726f6f6d735f626f6f6b696e67223b693a313b693a353b693a323b733a313a2235223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a33383a2261646d696e697374657220726f6f6d735f626f6f6b696e675f7479706520656e746974696573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a373b7d, '', 501, 9, 1, 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'admin/rooms/bookings/booking-types/manage/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/rooms/bookings/booking/%', 0x613a313a7b693a343b733a31383a22726f6f6d735f626f6f6b696e675f6c6f6164223b7d, '', 'rooms_booking_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a343b7d, 'rooms_booking_form_wrapper', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 3, '', 'admin/rooms/bookings/booking/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking.admin.inc'),
('admin/rooms/bookings/booking/%/delete', 0x613a313a7b693a343b733a31383a22726f6f6d735f626f6f6b696e675f6c6f6164223b7d, '', 'rooms_booking_access', 0x613a323a7b693a303b733a363a2264656c657465223b693a313b693a343b7d, 'rooms_booking_delete_form_wrapper', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 2, 'admin/rooms/bookings/booking/%', 'admin/rooms/bookings/booking/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking.admin.inc'),
('admin/rooms/bookings/booking/%/edit', 0x613a313a7b693a343b733a31383a22726f6f6d735f626f6f6b696e675f6c6f6164223b7d, '', 'rooms_booking_access', 0x613a323a7b693a303b733a363a22757064617465223b693a313b693a343b7d, 'rooms_booking_form_wrapper', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 3, 'admin/rooms/bookings/booking/%', 'admin/rooms/bookings/booking/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', -10, 'sites/all/modules/rooms/modules/rooms_booking/rooms_booking.admin.inc'),
('admin/rooms/bookings/customers', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220726f6f6d735f626f6f6b696e6720656e746974696573223b7d, 'rooms_booking_get_client_profiles', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/rooms/bookings/customers', 'Customers', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/rooms/bookings/list', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33333a2261646d696e697374657220726f6f6d735f626f6f6b696e6720656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a383a22626f6f6b696e6773223b693a313b733a363a22706167655f31223b7d, '', 15, 4, 1, 'admin/rooms/bookings', 'admin/rooms/bookings', 'Bookings List', 't', '', '', 'a:0:{}', 140, 'List of bookings', '', -10, ''),
('admin/rooms/bookings/room_types', '', '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220726f6f6d735f626f6f6b696e6720656e746974696573223b7d, 'rooms_booking_get_room_types', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/rooms/bookings/room_types', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/rooms/config', '', '', 'user_access', 0x613a313a7b693a303b733a32333a22636f6e66696775726520726f6f6d2073657474696e6773223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/rooms/config', 'Configuration', 't', '', '', 'a:0:{}', 6, 'Configure settings and business rules for Rooms management.', '', 10, 'modules/system/system.admin.inc'),
('admin/rooms/config/bookings', '', '', 'user_access', 0x613a313a7b693a303b733a32333a22636f6e66696775726520726f6f6d2073657474696e6773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22726f6f6d735f626f6f6b696e675f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/rooms/config/bookings', 'Booking Settings', 't', '', '', 'a:0:{}', 6, 'Configure settings and business rules for Bookings.', '', 0, ''),
('admin/rooms/config/children', '', '', 'user_access', 0x613a313a7b693a303b733a32333a22636f6e66696775726520726f6f6d2073657474696e6773223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33313a22726f6f6d735f626f6f6b696e675f6368696c6472656e5f646973636f756e74223b7d, '', 15, 4, 0, '', 'admin/rooms/config/children', 'Children Discount Settings', 't', '', '', 'a:0:{}', 6, 'Configure settings for children discounts.', '', 0, ''),
('admin/rooms/config/terminology', '', '', 'user_access', 0x613a313a7b693a303b733a32333a22636f6e66696775726520726f6f6d2073657474696e6773223b7d, 'rooms_ui_terminology_form', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/rooms/config/terminology', 'Rooms Terminology', 't', '', '', 'a:0:{}', 6, 'Change Rooms Terminology', '', 0, ''),
('admin/rooms/customer-profiles/%/edit', 0x613a313a7b693a333b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a33333a2261646d696e697374657220726f6f6d735f626f6f6b696e6720656e746974696573223b7d, 'rooms_booking_edit_customer_profile', 0x613a313a7b693a303b693a333b7d, '', 29, 5, 0, '', 'admin/rooms/customer-profiles/%/edit', 'Edit customer profile', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/rooms/unit-type/description-source', '', '', 'user_access', 0x613a313a7b693a303b733a32353a2261646d696e697374657220626f6f6b61626c6520756e697473223b7d, 'rooms_unit_type_description_source', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/rooms/unit-type/description-source', 'Unit type description source', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/rooms/units', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a33303a2261646d696e697374657220726f6f6d735f756e697420656e746974696573223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31343a22626f6f6b61626c655f756e697473223b693a313b733a363a22706167655f31223b7d, '', 7, 3, 0, '', 'admin/rooms/units', 'Bookable Units', 't', '', '', 'a:0:{}', 6, 'Create and administer units that can be booked, such as rooms for a hotel. Bookable units have availability and pricing information attached to them by the Rooms module and can have extra fields added via the standard Drupal Field API functionality.', '', -10, ''),
('admin/rooms/units/add', '', '', '_rooms_unit_add_access', 0x613a303a7b7d, 'rooms_unit_add_page', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/rooms/units/add', 'Add a Bookable Unit', 't', '', '', 'a:0:{}', 6, 'Create a new bookable unit.', '', 20, 'sites/all/modules/rooms/modules/rooms_unit/rooms_unit.admin.inc'),
('admin/rooms/units/add/basic_suite', '', '', 'rooms_unit_access', 0x613a323a7b693a303b733a363a22637265617465223b693a313b4f3a393a22526f6f6d73556e6974223a31353a7b733a31333a22002a00656e7469747954797065223b733a31303a22726f6f6d735f756e6974223b733a31353a22002a0064656661756c744c6162656c223b623a303b733a343a2274797065223b733a31313a2262617369635f7375697465223b733a333a22756964223b693a303b733a373a22756e69745f6964223b733a303a22223b733a363a2269735f6e6577223b623a313b733a353a227469746c65223b733a303a22223b733a373a2263726561746564223b733a303a22223b733a373a226368616e676564223b733a303a22223b733a31303a22626173655f7072696365223b733a323a223530223b733a31303a226d696e5f736c65657073223b733a313a2232223b733a31303a226d61785f736c65657073223b733a313a2232223b733a31323a226d696e5f6368696c6472656e223b693a303b733a31323a226d61785f6368696c6472656e223b693a303b733a343a2264617461223b613a313a7b733a31333a22636f745f737572636861726765223b693a303b7d7d7d, 'rooms_unit_create_form_wrapper', 0x613a313a7b693a303b733a31313a2262617369635f7375697465223b7d, '', 31, 5, 0, '', 'admin/rooms/units/add/basic_suite', 'Add @unit_type_label unit', 't', 'a:1:{s:16:"@unit_type_label";s:11:"Basic Suite";}', '', 'a:0:{}', 6, '', '', 0, 'sites/all/modules/rooms/modules/rooms_unit/rooms_unit.admin.inc'),
('admin/rooms/units/ad