<!doctype html>
<!--[if IE 8]>
<html {languageAttributes}  class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass} ie ie8">
<![endif]-->
<!--[if !(IE 7) | !(IE 8)]><!-->
<html {languageAttributes} class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass}">
<!--<![endif]-->
<head>
	<meta charset="{$wp->charset}">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="{$wp->pingbackUrl}">

	{if $options->theme->general->favicon != ""}
		<link href="{$options->theme->general->favicon}" rel="icon" type="image/x-icon" />
	{/if}

	{if isset($elements->unsortable['seo'])}
		{if $elements->unsortable[seo]->display}
			{if $elements->unsortable[seo]->option->keywords != ""}
				<meta name="keywords" content="{$elements->unsortable[seo]->option->keywords}">
			{/if}
			{if $elements->unsortable[seo]->option->description != ""}
				<meta name="description" content="{$elements->unsortable[seo]->option->description}">
			{/if}
			{if $elements->unsortable[seo]->option->title != ""}
				<title>{$elements->unsortable[seo]->option->title}</title>
			{else}
				<title>{title '|', true, right}</title>
			{/if}
		{else}
			<title>{title '|', true, right}</title>
		{/if}
	{else}
		<title>{title '|', true, right}</title>
	{/if}

	{googleAnalytics $options->theme->google->analyticsTrackingId, $options->theme->google->anonymizeIp}

	{wpHead}

	{!$options->theme->header->customJsCode}
</head>
<body {!$wp->bodyHtmlClass}>
	{* usefull for inline scripts like facebook social plugins scripts, etc... *}
	{doAction ait-html-body-begin}

	<div id="page" class="hfeed page-container">


			<header id="masthead" class="site-header">

    		<div class="top-header">
	       		<div class="grid-main">
	                <div class="top-header-right">
	                  {includePart parts/social-icons}
	                  {includePart parts/languages-switcher}
					  {includePart parts/woocommerce-cart}
	                </div>
	    			{includePart parts/breadcrumbs}
	          </div>
    		</div>

    				<div class="header-container {if $options->theme->header->enableHeaderIcons and $options->theme->header->headerIcons}iconmenu-on{else}iconmenu-off{/if}">
                		<div class="grid-main">

                			<div class="site-logo">
		              			{if $options->theme->header->logo}
		              			<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
		              			{else}
		              			<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
		              			{/if}
		              			<p class="site-description">{$wp->description}</p>

	              			</div>

							{if $options->theme->header->enableHeaderIcons and $options->theme->header->headerIcons}
							<div class="site-tools">

								<div class="iconmenu">
									<ul class="iconmenu-container">
										{foreach $options->theme->header->headerIcons as $icon}
											<li class="iconmenu-box cols-{$options->theme->header->headerIconsCols}">
												{if $icon->url}<a href="{$icon->url}">{/if}
												<div class="iconmenu-wrap">
													<span class="item-color" {if $icon->color}style="background-color: {!$icon->color};"{/if}></span>
													{if $icon->icon}
													<div class="i-thumb">
														<img src="{imageUrl $icon->icon, width => 300, height => 300, crop => 1}" class="i-thumb-img" alt="{$icon->title}" />
													</div>
													{/if}
													{if $icon->title}<h4 class="i-title">{!$icon->title}</h4>{/if}
												</div>
												{if $icon->url}</a>{/if}
											</li>
										{/foreach}
									</ul>
								</div>

							</div>
							{/if}

						</div>
    				</div>

    				<div class="menu-container">
    				<!--<div class="grid-main">   -->
    						<nav class="main-nav">

    						<!-- 	<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>    -->
    							<div class="main-nav-wrap">
    								<h3 class="menu-toggle">{__ 'Menu'}</h3>
    								{menu main}

    							</div>
    							<div class="site-search">
    								{searchForm}
    							</div>
    						</nav>
    						<!--</div>   -->
    				</div>
			</header>
      <!-- #masthead -->


		<div class="sticky-menu menu-container" >
			<div class="grid-main">
				<div class="site-logo">
					{if $options->theme->header->logo}
					<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
					{else}
					<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
					{/if}
				</div>
				<nav class="main-nav">
					<!-- wp menu here -->
				</nav>
			</div>
		</div>
