<?php


return array(

	'menus' => array(
		'main'   => __('Main menu', 'ait-admin'),
		'footer' => __('Footer menu', 'ait-admin'),
	),

	// Supported standard WordPress features
	'theme-support' => array(
		'woocommerce',
		'automatic-feed-links',
		'post-thumbnails',
	),

	// Supported custom ait-theme features
	'ait-theme-support' => array(
		'ait-languages-plugin',
		'megamenu',
		'cpts' => array(
			'ad-space',
			'faq',
			'job-offer',
			'member',
			'partner',
			'portfolio-item',
			'price-table',
			'product-item',
			'service-box',
			'testimonial',
			'toggle',
		),
		'elements' => array(
			'advertising-spaces',
			'columns',
			'contact-form',
			'easy-slider',
			'facebook',
			'faq',
			'google-map',
			'job-offers',
			'member',
			'members',
			'opening-hours',
			'page-title',
			'partners',
			'portfolio',
			'posts',
			'price-table',
			'products',
			'revolution-slider',
			'rule',
			'seo',
			'services',
			'sitemap',
			'testimonials',
			'text',
			'toggles',
			'twitter',
			'video',
			'widget-area',
		),
	),

	'plugins' => array(
		'ait-toolkit' => array(
			'required' => true,
			'name'     => 'AIT Elements Toolkit',
		),
		'ait-shortcodes' => array(
			'required' => true,
			'name'     => 'AIT Shortcodes',
		),
		'revslider' => array(
			'required' => true,
		),
	),


	'assets' => array(

		'fonts' => array(
			'opensans' => array(
				'regular', 'semibold', 'bold', 'italic',
			),
			'awesome',
		),

		'css' => array(
			'jquery-selectbox' => array(
				'file' => '/libs/jquery.selectbox.css',
			),
			'font-awesome'	=> array(
				'file'	=> '/libs/font-awesome.css',
			),
			'jquery-ui-css' => true,
			'jquery-mCustomScrollbar'=> array(
				'file' => '/libs/jquery.mCustomScrollbar.min.css',
			),
		),

		'js' => array(
			'jquery-selectbox' => array(
				'file' => '/libs/jquery.selectbox-0.2.js',
				'deps' => array('jquery')
			),
			'jquery-raty' => array(
				'file' => '/libs/jquery.raty-2.5.2.js',
				'deps' => array('jquery')
			),
			'jquery-waypoints' => array(
				'file' => '/libs/jquery-waypoints-2.0.3.js',
				'deps' => array('jquery')
			),
			'jquery-infieldlabels' => array(
				'file'	=> '/libs/jquery.infieldlabel-0.1.4.js',
				'deps'	=> array('jquery'),
			),
			'jquery-mCustomScrollbar' => array(
				'file'	=> '/libs/jquery.mCustomScrollbar.concat.min.js',
				'deps'	=> array('jquery'),
			),

			'ait-mobile-script' => array(
				'file' => '/mobile.js',
				'deps' => array('jquery')
			),
			'ait-menu-script' => array(
				'file' => '/menu.js',
				'deps' => array('jquery', 'ait-mobile-script')
			),
			'ait-portfolio-script' => array(
				'file' => '/portfolio-item.js',
				'deps' => array('jquery', 'ait-mobile-script', 'jquery-ui-accordion', 'jquery-bxslider')
			),
			'ait-custom-script' => array(
				'file' => '/custom.js',
				'deps' => array('jquery', 'ait-mobile-script')
			),

			'ait-woocommerce-script' => array(
				'file' => '/woocommerce.js',
				'deps' => array('jquery'),
				'enqueue-only-if' => function() { return !is_admin() and aitIsPluginActive("woocommerce"); },
			),

			'ait-script' => array(
				'file' => '/script.js',
				'deps' => array('jquery', 'ait-mobile-script', 'ait-menu-script', 'ait-portfolio-script', 'ait-custom-script')
			),
		),
	),

	'frontend-ajax' => array(
		'send-email',
	),

	'page-post-metaboxes' => array(

		'post-gallery-metabox' => array(
			'title' =>  __('Post Gallery', 'ait-admin'),
			'types' => array(
				'post',
			),
			'config' => 'post-gallery',
		),
	),
);
