<?php



// === Loads AIT WordPress Framework ================================
require_once get_template_directory() . '/ait-theme/@framework/load.php';


// === Mandatory WordPress Standard functionality ===================

if(!isset($content_width)) $content_width = 1200;


// === Custom filters, actions for framework overrides ==============
require_once aitPath('includes', '/ait-woocommerce-functions.php');




// === Run the theme ===============================================

AitTheme::run(aitPath('config', '/@theme-configuration.php'));

// === Custom settings ==============================================

if ( aitIsPluginActive( "woocommerce" ) ) {
	
	add_filter('loop_shop_columns', function() { return 3; });

	// Display 6 products per page
	add_filter('loop_shop_per_page', function($cols){ return 6; }, 20);

	// Add image sizes for woocommerce 3.3+
	add_theme_support( 'woocommerce', array(
	    'thumbnail_image_width'         => 500,
	    'gallery_thumbnail_image_width' => 180,
	    'single_image_width'            => 750,
	) );

	// Change number of related products on product page
	// Set your own value for 'posts_per_page'
	add_filter( 'woocommerce_output_related_products_args', 'ait_related_products_args' );
	function ait_related_products_args( $args ) {
		$args['posts_per_page'] = 3; // 3 related products
		$args['columns'] = 3; // arranged in 3 columns
		return $args;
	}
	
	// fixed: woocommerce prevented non-admin user to access easyadmin
	add_filter('woocommerce_prevent_admin_access', '__return_false');

	// Disable woocommerce default styles
	if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
		add_filter( 'woocommerce_enqueue_styles', '__return_false' );
	} else {
		define( 'WOOCOMMERCE_USE_CSS', false );
	}
}



// load entry-views plugin
require_once aitPath('includes', '/entry-views/entry-views.php');


// === Add Resources cpt in Languages Settings ============================
add_filter('pll_get_post_types', 'ait_pll_add_post_types');

function ait_pll_add_post_types($types) {
    if(function_exists('easyreservations_install')){ // only if easyReservations plugin is active
        return array_merge($types, array('easy-rooms' => 'easy-rooms'));
    }else{
        return $types;
    }
}

// WP 4.4 rest links
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );



