<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_Music_Post {

	public function get_name(){
		return 'gutenwp_music_post';
	}
	public function get_icon() {
		return 'wppb-font-video';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Music Post', 'gutenwp-core' );
	}
	
	public function get_settings() {
		$settings = array(
			'post_style' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Style', 'gutenwp-core'),
				'values' 	=> array(
						'style1'        => __( 'Style One', 'gutenwp-core' ),
                        'style2'        => __( 'Style Two', 'gutenwp-core' ),
                        'style3'        => __( 'Style Three', 'gutenwp-core' ),
					),
				'std' 		=> 'style1',
			),
			'post_cat' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Category', 'gutenwp-core'),
				'values' 	=> themeum_cat_list('category'),
				'std' 		=> 'All',
				'multiple' 	=> false, 
			),

			'post_number' => array(
				'type' 			=> 'text',
				'title' 		=> __('Post Number', 'gutenwp-core'),
				'placeholder' 	=> 'Number of Post',
				'std' 			=> '8'
			),
			'post_order_by' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Order', 'gutenwp-core'),
				'values' 	=> array(
						'ASC' 		=> 'ASC',
						'DESC' 		=> 'DESC',
					),
				'std' 		=> 'DESC',
			),
			'textlimit' => array(
	            'type'          => 'text',
				'title' 		=> __('Title Text Limit', 'gutenwp-core'),
	            'label_block'   => true,
				'std'	 		=> '45',
			),
			'content_limit' => array(
	            'type'          => 'text',
				'title' 		=> __('Content Text Limit', 'gutenwp-core'),
	            'label_block'   => true,
				'std'	 		=> '320',
			),


			/*========================================
			* 			 Custom Style  
			==========================================*/
			'title_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Title Color','gutenwp-core'),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} h3.music-title, h3.music-title a { color: {{data.title_color}}; }'
			),
			'title_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Title Typography','gutenwp-core'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '28px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '600',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} h3.music-title, h3.music-title a',
			),
			'title_margin' => array(
				'type' 			=> 'dimension',
				'title' 		=> 'Margin',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'selector' 		=> '{{SELECTOR}} h3.music-title, h3.music-title a { margin: {{data.title_margin}}; }',
			),
			# End

			# Category Text Style.
            'content_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Content Color','gutenwp-core'),
				'tab' 		=> 'style',
				'section' 	=> 'Content Style',
				'selector' 	=> '{{SELECTOR}} .music-video .music-content p { color: {{data.content_color}}; }',
			),
			'content_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','gutenwp-core'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '16px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '400',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'section' 	=> 'Content Style',
				'selector' 	=> '{{SELECTOR}} .music-video .music-content p',
			),
			# END 
		);

		return $settings;
	}


	public function render($data = null){

		$settings 		= $data['settings'];

		$post_style 		= $settings['post_style'];
		$post_number 		= $settings['post_number'];
		$post_cat 			= $settings['post_cat'];
		$post_order_by 		= $settings['post_order_by'];
		$textlimit 			= isset($settings['textlimit']) ? $settings['textlimit'] : array();
		$content_limits 	= isset($settings['content_limit']) ? $settings['content_limit'] : array();
		$page_numb 			= max( 1, get_query_var('paged') );

		# Query Build
		$args = array(
			'post_type' 		=> 'post',
			'post_status' 		=> 'publish',
			'posts_per_page' 	=> $post_number,
			'order' 			=> $post_order_by,
			'meta_query' 		=> array(
				'relation' 		=> 'OR',
				array(
					'key'     => 'themeum_video'
				),
				array(
					'key'     => 'themeum_audio_code'
				)
			),
		);

		$data = new \WP_Query( $args );
		$output = '';

		if ($post_style == 'style1') {
			$output .= '<div class="gutenwp-music-post addon-article leading-item">';

				if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post(); 

				$output .= '<div class="row blog-music-wrap music-video">';
					$output .= '<div class="col-md-5">';
						$audio = get_post_meta(get_the_ID(), 'themeum_audio_code', true);
						if ($audio) {
					        $output .= '<div class="article-image-wrap">';
					            $output .= rwmb_meta( 'themeum_audio_code' );
					        $output .= '</div>'; 
						}else {
							$output .= '<div class="article-image-wrap">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'"><i class="fa fa-play"></i></a>';
									$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-portfo', array('class' => 'img-responsive'));
								}
							$output .= '</div>';
						}
					$output .= '</div>'; # col-md-4 

					$output .= '<div class="col-md-7">';
						$output .= '<div class="music-details wp-style1">';
							$output .= '<h3 class="music-title">';
								$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
							$output .= '</h3>';

							$output .= '<div class="music-content">';
								$output .= get_avatar( get_the_author_meta( 'ID' ) , 35 );
		                		$output .= '<span class="author">'.__(' By ', 'gutenwp-core').' '.get_the_author_meta('display_name').'</span>';
		                		$output .= '<span>'. get_the_category_list(', ').'</span>';
	                			$output .= '<p>'.gutenwp_excerpt_max_charlength($content_limits).'</p>';
	                			$output .= '<a class="slider-btn" href="'.get_the_permalink().'">'.__('Read More', 'gutenwp').'</a>';
	                		$output .= '</div>';
	               
						$output .= '</div>';
					$output .= '</div>';
				$output .= '</div>';

				endwhile;
				wp_reset_query();
				endif; 
			$output .= '</div>';
		}elseif ($post_style == 'style2') {
			# Style 2
			$output .= '<div class="gutenwp-music-post addon-article leading-item items-masonary">';
			$output .= '<div class="row">';

				$count = 1;
				if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post(); 

					$the_date = get_the_date();

					if ($count == 1) {
						$output .= '<div class="addon-article intro-item-wrapper music-video col-md-3 masonary-item">';	

							$output .= '<div class="article-image-wrap single-img">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'"><i class="fa fa-play"></i></a>';
									$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
								}
							$output .= '</div>';

							$output .= '<div class="article-details">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 50, '...').'</a>';
								$output .= '</h3>';
								
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-read">'.__(' By ', 'gutenwp').'  '.get_the_author_meta('display_name').' /</li>';
					                $output .= '<li class="meta-category">'.date_i18n( get_option( 'date_format' ), strtotime($the_date)).'</li>';
					            $output .= '</ul>';
							$output .= '</div>'; #article-details

						$output .= '</div>';	

					}else if ($count == 2) {
						$output .= '<div class="addon-article intro-item-wrapper music-video col-md-6 masonary-item second">';
							
							$output .= '<div class="article-image-wrap">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'"><i class="fa fa-play"></i></a>';
									$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-portfo', array('class' => 'img-responsive'));
								}
							$output .= '</div>';

							$output .= '<div class="article-details">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 85, '...').'</a>';
								$output .= '</h3>';

								$output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-read">'.__(' By ', 'gutenwp').'  '.get_the_author_meta('display_name').' /</li>';
					                $output .= '<li class="meta-category">'.date_i18n( get_option( 'date_format' ), strtotime($the_date)).'</li>';
					            $output .= '</ul>';
							$output .= '</div>';
						$output .= '</div>';
					}else {
						$output .= '<div class="addon-article intro-item-wrapper music-video col-md-3 masonary-item">';
							$output .= '<div class="article-image-wrap single-img">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'"><i class="fa fa-play"></i></a>';
									$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
								}
							$output .= '</div>';

							$output .= '<div class="article-details">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 45, '...').'</a>';
								$output .= '</h3>';
								
								$output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-read">'.__(' By ', 'gutenwp').'  '.get_the_author_meta('display_name').' /</li>';
					                $output .= '<li class="meta-category">'.date_i18n( get_option( 'date_format' ), strtotime($the_date)).'</li>';
					            $output .= '</ul>';

							$output .= '</div>';
						$output .= '</div>';
					}
					$count++;

				endwhile;
				wp_reset_query();
				endif; 
				$output .= '</div>';
			$output .= '</div>';
			# Style 2 end
		}else {

			$output .= '<div class="row music-video music-style3">';	
				if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post(); 	
					$output .= '<div class="addon-article intro-item-wrapper col-md-4">';
						$output .= '<div class="article-image-wrap">';	
							$audio = get_post_meta(get_the_ID(), 'themeum_audio_code', true);
							if ($audio) {
						        $output .= '<div class="article-image-wrap">';
						            $output .= rwmb_meta( 'themeum_audio_code' );
						        $output .= '</div>'; 
							}else {
								$output .= '<div class="article-image-wrap">';
									if ( has_post_thumbnail()) {
										$output .= '<a class="item-image"  href="'.get_permalink().'"><i class="fa fa-play"></i></a>';
										$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
									}
								$output .= '</div>';
							}
						$output .= '</div>';

						$output .= '<div class="article-details">';
							$output .= '<h3 class="article-title">';
							$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 70, '...').'</a>';
							$output .= '</h3>';
				            $output .= '<ul class="gutenwp-post-category music-content">';
				                $output .= '<li class="author">'.get_avatar( get_the_author_meta( 'ID' ) , 35 ).'</li>';
				                $output .= '<li class="author">'.__(' By ', 'gutenwp-core').' '.get_the_author_meta('display_name').' .</li>';
				                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
				            $output .= '</ul>';
						$output .= '</div>';

					$output .= '</div>';
					
				endwhile;
				wp_reset_query();
				endif;  
			$output .= '</div>';	
		}
		return $output;
	}

}


