<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_Latest_Post {

	public function get_name(){
		return 'gutenwp_latest_post';
	}
	public function get_icon() {
		return 'wppb-font-trash';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Gutenwp Latest Post', 'gutenwp-core' );
	}
	
	public function get_settings() {
		$settings = array(
			'post_style' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Style', 'gutenwp-core'),
				'values' 	=> array(
						'style1'        => __( 'Style One', 'gutenwp-core' ),
                        'style2'        => __( 'Style Two', 'gutenwp-core' ),
                        'style3'        => __( 'Style Three', 'gutenwp-core' ),
                        'style4'        => __( 'Style Four', 'gutenwp-core' ),
                        'style5'        => __( 'Style Five', 'gutenwp-core' ),
					),
				'std' 		=> 'style1',
			),
			'post_column' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Column', 'gutenwp-core'),
				'values' 	=> array(
						'12' 		=> 'Column One',
						'6' 		=> 'Column Two',
						'4' 		=> 'Column Three',
						'3' 		=> 'Column Four',
					),
				'std' 		=> '3',
				'depends' => array( array( 'post_style', '=', ['style1', 'style3'] ) ),
			),

			'post_cat' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Category', 'gutenwp-core'),
				'values' 	=> themeum_cat_list('category'),
				'std' 		=> 'All',
				'multiple' 	=> false, 
			),
			'post_number' => array(
				'type' 			=> 'text',
				'title' 		=> __('Post Number', 'gutenwp-core'),
				'placeholder' 	=> 'Number of Post',
				'std' 			=> '4'
			),
			'post_order_by' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Order', 'gutenwp-core'),
				'values' 	=> array(
						'ASC' 		=> 'ASC',
						'DESC' 		=> 'DESC',
					),
				'std' 		=> 'DESC',
			),
			'textlimit' => array(
	            'type'          => 'text',
				'title' 		=> __('Title Text Limit', 'gutenwp-core'),
	            'label_block'   => true,
				'std'	 		=> '45',
			),
			'content_limit' => array(
	            'type'          => 'text',
				'title' 		=> __('Content Text Limit', 'gutenwp-core'),
	            'label_block'   => true,
				'std'	 		=> '150',
				'depends' => array( array( 'post_style', '=', ['style4'] ) ),
			),

			/*----------------------------------------
			* 			 Custom Style  
			------------------------------------------ */
			'title_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Title Color','gutenwp-core'),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .article-details h3 a, {{SELECTOR}} h3.music-title a, {{SELECTOR}} .single-article-details h3.article-title a { color: {{data.title_color}}; }'
			),
			'text_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','wp-pagebuilder'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '24px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '600',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .article-details h3 a, {{SELECTOR}} h3.music-title a, {{SELECTOR}} .music-video.style4 h3.music-title, {{SELECTOR}} .single-article-details h3.article-title a',
			),
			'title_padding' => array(
				'type' 			=> 'dimension',
				'title' 		=> 'Content Padding',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'selector' 		=> '{{SELECTOR}} .article-details h3 a, {{SELECTOR}} h3.music-title a, {{SELECTOR}} .single-article-details h3.article-title a { padding: {{data.title_padding}}; }',
			),
			'content_padding' => array(
				'type' 			=> 'dimension',
				'title' 		=> 'Content Padding',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'selector' 		=> '{{SELECTOR}} .music-video .music-details { padding: {{data.content_padding}}; }',
				'depends' => array( array( 'post_style', '=', ['style4'] ) ),
			),
			# End




		);

		return $settings;
	}


	public function render($data = null){

		$settings 			= $data['settings'];
		$post_style 		= $settings['post_style'];
		$post_number 		= $settings['post_number'];
		$post_cat 			= $settings['post_cat'];
		$post_order_by 		= $settings['post_order_by'];
		$post_column 		= $settings['post_column'];
		$textlimit 			= $settings['textlimit'];
		$content_limits 	= isset($settings['content_limit']) ? $settings['content_limit'] : array();
		$page_numb 			= max( 1, get_query_var('paged') );

		# Query Build
		if ( $post_cat == 'All' ) {
			$args = array(
				'post_type'   		=> 'post',
				'post_status' 		=> 'publish',
				'posts_per_page'   	=> $post_number,
				'order' 			=> $post_order_by,
			);
		}else {
			$args = array(
				'post_type'   		=> 'post',
				'post_status' 		=> 'publish',
				'posts_per_page'   	=> $post_number,
				'order' 			=> $post_order_by,
				'tax_query' => array(
	            	array(
		                'taxonomy' => 'category',
		                'field'    => 'slug',
		                'terms'    => esc_attr($post_cat),
	                ),
	            ),
			);
		}

		$data = new \WP_Query( $args );
		$output = '';
		
		if ($post_style == 'style1') {	
			$output .= '<div class="row">';	
				if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post(); 		
					$output .= '<div class="addon-article intro-item-wrapper col-md-'.$post_column.'">';
						$output .= '<div class="article-image-wrap">';	
							$output .= '<a href="'.get_permalink().'" class="img-wrapper">';
								$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
							$output .= '</a>';
						$output .= '</div>';

						$content = get_post_field( 'post_content', get_the_ID() );
					    $word_count = str_word_count( strip_tags( $content ) );
					    $wordceil = ceil ($word_count / 200);

						$output .= '<div class="article-details">';
							$output .= '<h3 class="article-title">';
								$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
							$output .= '</h3>';
							if( isset($settings['post_category']) == 'yes' ){ 
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read"> '. $wordceil .' '.__(' min read').'</li>';
					            $output .= '</ul>';
				            }
						$output .= '</div>';
					$output .= '</div>';
				endwhile;
				wp_reset_query();
				endif;  
			$output .= '</div>';	
		}elseif ( $post_style == 'style2' ) {
			$j = 0;
			$output .= '<div class="row">';
			if ( $data->have_posts() ) :
			while ( $data->have_posts() ) : $data->the_post(); 
				if ($j == 0) {
					$output .= '<div class="col-md-8">';
						$output .= '<div class="addon-article leading-item">';
							$output .= '<div class="article-image-wrap">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'">';
										$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-large', array('class' => 'img-responsive'));		
									$output .= '</a>';
								}
							$output .= '</div>';

							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);

							$output .= '<div class="article-details">';	
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
								$output .= '</h3>';
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read">'.$wordceil.' '.__(' min read').'</li>';
					            $output .= '</ul>';
							$output .= '</div>';
						$output .= '</div>';
					$output .= '</div>';
				} elseif($j == 1){ 
					$output .= '<div class="col-md-4">';
						$output .= '<div class="addon-article leading-item">';
							$output .= '<div class="article-image-wrap">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'">';
										$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-portfo', array('class' => 'img-responsive'));		
									$output .= '</a>';
								}
							$output .= '</div>';

							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);

							$output .= '<div class="article-details">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 45, '...').'</a>';
								$output .= '</h3>';
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read">'.$wordceil.' '.__(' min read').'</li>';
					            $output .= '</ul>';     
							$output .= '</div>';
						$output .= '</div>';
					$output .= '</div>';
				} else {
					$output .= '<div class="col-md-4">';
						$output .= '<div class="single-article-details row">';	
							$output .= '<div class="col-md-4">';
								$output .= '<div class="article-image-wrap">';
									if ( has_post_thumbnail()) {
										$output .= '<a class="item-image"  href="'.get_permalink().'">';
											$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-thumb', array('class' => 'img-responsive'));		
										$output .= '</a>';
									}
								$output .= '</div>';
							$output .= '</div>';

							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);
							$output .= '<div class="col-md-8">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 55, '...').'</a>';
								$output .= '</h3>';
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read">'.$wordceil.' '.__(' min read').'</li>';
					            $output .= '</ul>'; 
							$output .= '</div>';
						$output .= '</div>';
					$output .= '</div>';
				}

				$j++; 
				#<!-- End Post -->
			endwhile;
			wp_reset_query();
			endif;  
			$output .= '</div>';	
		}else if ($post_style == 'style3') {
			$output .= '<div class="row">';	
				$j = 0;

				if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post(); 	
					if($j%2 == 0) {
						$output .= '<div class="addon-article intro-item-wrapper col-md-'.$post_column.'">';
							$output .= '<div class="article-image-wrap">';	
								$output .= '<a href="'.get_permalink().'" class="img-wrapper">';
									$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
								$output .= '</a>';
							$output .= '</div>';

							# Title Word count
							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);

							$output .= '<div class="article-details">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
								$output .= '</h3>';
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read">'.$wordceil.' '.__('. min read').'</li>';
					            $output .= '</ul>';  
							$output .= '</div>';
						$output .= '</div>';
					}else {
						$output .= '<div class="addon-article intro-item-wrapper col-md-'.$post_column.'">';
							# Title Word count
							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);

							$output .= '<div class="article-details">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
								$output .= '</h3>';
								if( isset($settings['post_category']) == 'yes' ){ 
						            $output .= '<ul class="gutenwp-post-category">';
						                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
						                $output .= '<li class="meta-read">'.$wordceil.' '.__('min read').'</li>';
						            $output .= '</ul>';
					            }
							$output .= '</div>';

							$output .= '<div class="article-image-wrap">';	
								$output .= '<a href="'.get_permalink().'" class="img-wrapper">';
									$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
								$output .= '</a>';
							$output .= '</div>';

						$output .= '</div>';
					}
					$j++;				
				endwhile;
				wp_reset_query();
				endif;  
			$output .= '</div>';
		}else if ($post_style == 'style4') {
			if ( $data->have_posts() ) :
			while ( $data->have_posts() ) : $data->the_post(); 	

			$output .= '<div class="row blog-music-wrap music-video style4">';
				$output .= '<div class="col-md-6">';
					$output .= '<div class="article-image-wrap">';
					if ( has_post_thumbnail()) {
						$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-portfo', array('class' => 'img-responsive'));
					}
					$output .= '</div>';
				$output .= '</div>'; # col-md-6 

				$output .= '<div class="col-md-6">';
					$output .= '<div class="music-details">';
						$output .= '<h3 class="music-title">';
							$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
						$output .= '</h3>';
						$output .= '<div class="music-content">';
							$output .= get_avatar( get_the_author_meta( 'ID' ) , 35 );
	                		$output .= '<span class="author">'.__(' By ', 'gutenwp').' '.get_the_author_meta('display_name') .' .</span>';
	                		$output .= '<span>'. get_the_category_list(', ').'</span>';
                			$output .= '<p>'.gutenwp_excerpt_max_charlength($content_limits).'</p>';
                			$output .= '<a class="slider-btn" href="'.get_the_permalink().'">'.__('Read More', 'gutenwp').'</a>';
                		$output .= '</div>';
					$output .= '</div>';
				$output .= '</div>'; # col-md-6 
			$output .= '</div>';

			endwhile;
			wp_reset_query();
			endif;  
		}elseif ($post_style == 'style5') {
			$j = 0;
			$output .= '<div class="row">';
			if ( $data->have_posts() ) :
			while ( $data->have_posts() ) : $data->the_post(); 
				if ($j == 0) {
					$output .= '<div class="col-md-8">';
						$output .= '<div class="addon-article style6 leading-item">';
							$output .= '<div class="article-image-wrap">';
								if ( has_post_thumbnail()) {
									$output .= '<a class="item-image"  href="'.get_permalink().'">';
										$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-large', array('class' => 'img-responsive'));		
									$output .= '</a>';
								}
							$output .= '</div>';

							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);

							$output .= '<div class="article-details">';	
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, $textlimit, '...').'</a>';
								$output .= '</h3>';
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read">'.$wordceil.' '.__(' min read').'</li>';
					            $output .= '</ul>';   
							$output .= '</div>';
						$output .= '</div>';
					$output .= '</div>';
				} else{ 

					if ($j == 1):	
					$output .= '<div class="col-sm-4 section-content-second">';
					endif;		
						$output .= '<div class="single-article-details row">';	
							$output .= '<div class="col-md-4">';
								$output .= '<div class="article-image-wrap">';
									if ( has_post_thumbnail()) {
										$output .= '<a class="item-image"  href="'.get_permalink().'">';
											$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-thumb', array('class' => 'img-responsive'));		
										$output .= '</a>';
									}
								$output .= '</div>';
							$output .= '</div>';

							$content = get_post_field( 'post_content', get_the_ID() );
						    $word_count = str_word_count( strip_tags( $content ) );
						    $wordceil = ceil ($word_count / 200);

							$output .= '<div class="col-md-8">';
								$output .= '<h3 class="article-title">';
									$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 40, '...').'</a>';
								$output .= '</h3>';
					            $output .= '<ul class="gutenwp-post-category">';
					                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
					                $output .= '<li class="meta-read">'.$wordceil.' '.__(' min read').'</li>';
					            $output .= '</ul>';     
							$output .= '</div>';
						$output .= '</div>';	
					$cunt_nbr = $j+1; 
					if ($cunt_nbr == $post_number):
					$output .= '</div>';
					endif;	
				}

				$j++; 
				#<!-- End Post -->
			endwhile;
			wp_reset_query();
			endif;  
			$output .= '</div>';
		}
		return $output;
	}
}


