<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_Category_List {

	public function get_name(){
		return 'gutenwp_category_list';
	}
	public function get_icon() {
		return 'wppb-font-trash';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Post Category', 'gutenwp-core' );
	}
	
	public function get_settings() {
		$settings = array(
			'post_column' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Column', 'gutenwp-core'),
				'values' 	=> array(
						'12' 		=> 'Column One',
						'6' 		=> 'Column Two',
						'4' 		=> 'Column Three',
						'3' 		=> 'Column Four',
					),
				'std' 		=> '3',
			),
			'post_number' => array(
				'type' 			=> 'number',
				'title' 		=> __('Number of Category', 'gutenwp-core'),
				'placeholder' 	=> 'Number of Category',
				'std' 			=> '3'
			),
			'post_order' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Order', 'gutenwp-core'),
				'values' 	=> array(
						'ASC' 		=> 'ASC',
						'DESC' 		=> 'DESC',
					),
				'std' 		=> 'DESC',
			),

			/*---------------------------------------
			* 			 Custom Style  
			----------------------------------------- */
            'category_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Category Color','gutenwp-core'),
				'tab' 		=> 'style',
				'section' 	=> 'Category',
				'selector' 	=> '{{SELECTOR}} .category-image-wrap h2.category-name { color: {{data.category_color}}; }',
			),
			'category_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Category Typography','gutenwp-core'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '24px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '500',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'section' 	=> 'Category',
				'selector' 	=> '{{SELECTOR}} .category-image-wrap h2.category-name',
			),
			# END 

			# Content color. 
			'content_bg' => array(
				'type' 		=> 'color',
				'title' 	=> __('Date Color','gutenwp-core'),
				'tab' 		=> 'style',
				'section' 	=> 'Content',
				'selector' 	=> '{{SELECTOR}} .category-image-wrap .cat-wrap { background: {{data.content_bg}}; }',
			),
            'cotent_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Date Color','gutenwp-core'),
				'tab' 		=> 'style',
				'section' 	=> 'Content',
				'selector' 	=> '{{SELECTOR}} .cat-wrap span.cat-count { color: {{data.cotent_color}}; }',
			),
            'content_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Date Typography','wp-pagebuilder'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '16px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '400',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'section' 	=> 'Content',
				'selector' 	=> '{{SELECTOR}} .cat-wrap span.cat-count',
			),
			# End

		);

		return $settings;
	}


	public function render($data = null){

		$settings 		= $data['settings'];

		$post_number 		= $settings['post_number'];
		$post_order 		= $settings['post_order'];
		$post_column 		= $settings['post_column'];

			$args = array(
                'order' 	=> $post_order,
                'number' 	=> $post_number,
                'parent' 	=> 0,
            );

            $categories = get_categories($args);

			$output = '';
            $output .= '<div class="gutenwp-category">';
	            $output .= '<div class="row">';
	            foreach( $categories as $category ){

		            $post = ($category->category_count == '1') ? 'Post' : 'Posts';
					$image_id = get_term_meta ( $category->term_id, 'category-image-id', true );
					$featured_img_url = wp_get_attachment_image_url( $image_id, 'gutenwp-cat',true );

	                $output .= '<div class="col-md-'.$post_column.'">';
						$output .= '<div class="category-image-wrap" style="background-image: url('.$featured_img_url.'); padding: 356px 0 30px; margin-bottom:30px">';

							$output .= '<div class="cat-wrap">';
		                		$output .= '<a href="' . get_category_link( $category->term_id ) . '">';
		                			$output .= '<h2 class="category-name">' . $category->name . '</h2>';
		                		$output .= '</a>';
		                		$output .= '<span class="cat-count">'.$category->category_count.' '. $post.' </span>';
		                	$output .= '</div>';

		                $output .= '</div>';
	                $output .= '</div>';
	            }
	            $output .= '</div>';
            $output .= '</div>';
			wp_reset_query();  
				
		return $output;
	}

}


