<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_Featured_Post {

	public function get_name(){
		return 'gutenwp_featured_post';
	}
	public function get_icon() {
		return 'wppb-font-trash';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Gutenwp Featured Post', 'gutenwp-core' );
	}
	
	public function get_settings() {
		$settings = array(
			

			'post_column' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Column', 'gutenwp-core'),
				'values' 	=> array(
						'12' 		=> 'Column One',
						'6' 		=> 'Column Two',
						'4' 		=> 'Column Three',
						'3' 		=> 'Column Four',
					),
				'std' 		=> '3',
			),
			'post_number' => array(
				'type' 			=> 'text',
				'title' 		=> __('Post Number', 'gutenwp-core'),
				'placeholder' 	=> 'Number of Post',
				'std' 			=> '8'
			),

			'post_order_by' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Order', 'gutenwp-core'),
				'values' 	=> array(
						'ASC' 		=> 'ASC',
						'DESC' 		=> 'DESC',
					),
				'std' 		=> 'DESC',
			),

			/*========================================
			* 			 Custom Style  
			==========================================*/
			'title_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Title Color','gutenwp-core'),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .article-details h3 a { color: {{data.title_color}}; }'
			),
			'text_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','gutenwp-core'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '24px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '600',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .article-details h3 a',
			),
			'text_padding' => array(
				'type' 			=> 'dimension',
				'title' 		=> 'Title Padding',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'selector' 		=> '{{SELECTOR}} .article-details h3 a { padding: {{data.text_padding}}; }',
			),
			# End

		);

		return $settings;
	}


	public function render($data = null){

		$settings 		= $data['settings'];

		$post_number 		= $settings['post_number'];
		$post_order 		= $settings['post_order_by'];
		$post_column 		= $settings['post_column'];
		$page_numb 			= max( 1, get_query_var('paged') );


		# Query Build
		$query = new \WP_Query( 
            array( 
                'meta_key' 		 => 'post_views_count',
                'orderby' 		 => 'meta_value_num',
                'order' 		 => $post_order,
                'posts_per_page' => $post_number,
                'post_status' 	 => 'publish',
            ) 
        );

		global $post;
		$output = '';

		$output .= '<div class="row">';	
			$j = 1;

			if ( $query->have_posts() ) :
			while ( $query->have_posts() ) : $query->the_post(); 
	
				$output .= '<div class="addon-article intro-item-wrapper col-md-'.$post_column.'">';

					$output .= '<div class="article-image-wrap">';	
						$output .= '<a href="'.get_permalink().'" class="img-wrapper">';
							$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-medium', array('class' => 'img-responsive'));
						$output .= '</a>';
					$output .= '</div>';

					# blog Count Down
					$content = get_post_field( 'post_content', get_the_ID() );
				    $word_count = str_word_count( strip_tags( $content ) );
				    $wordceil = ceil ($word_count / 200);

					$output .= '<div class="article-details">';
						$output .= '<h3 class="article-title">';
							$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 45, '...').'</a>';
						$output .= '</h3>';
						if( isset($settings['post_category']) == 'yes' ){ 
				            $output .= '<ul class="gutenwp-post-category">';
				                $output .= '<li class="meta-category">'.get_the_category_list(', ').'</li>';
				                $output .= '<li class="meta-read">'.$wordceil.' '.__('  min read').'</li>';
				            $output .= '</ul>';
			            }
					$output .= '</div>';
				$output .= '</div>';
				
			endwhile;
			wp_reset_query();
			endif;  
		$output .= '</div>';	
		return $output;
	}
}


