<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_Post_Slider2 {

	public function get_name(){
		return 'themeum_post_slider2';
	}
	public function get_icon() {
		return 'wppb-font-trash';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Gutenwp Post Slider2', 'gutenwp-core' );
	}
	public function get_enqueue_script(){
	     return array( 'gutenwp-main', 'gutenwp-slick' ); 
	}
	
	public function get_settings() {
		$settings = array(

			'post_cat' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Category', 'gutenwp-core'),
				'values' 	=> themeum_cat_list('category'),
				'std' 		=> 'All',
				'multiple' 	=> false, 
			),

			'post_number' => array(
				'type' 			=> 'text',
				'title' 		=> __('Post Number', 'gutenwp-core'),
				'placeholder' 	=> 'Number of Post',
				'std' 			=> '8'
			),

			'post_order_by' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Order', 'gutenwp-core'),
				'values' 	=> array(
						'ASC' 		=> 'ASC',
						'DESC' 		=> 'DESC',
					),
				'std' 		=> 'DESC',
			),

		);

		return $settings;
	}


	public function render($data = null){

		$settings 		= $data['settings'];
		$post_cat 			= $settings['post_cat'];
		$post_number 		= $settings['post_number'];
		$post_order_by 		= $settings['post_order_by'];
		$gallery_thumb 		= $settings['gallery_thumb'];
		$page_numb 			= max( 1, get_query_var('paged') );

		# Query Build
		if ( $post_cat == 'All' ) {
			$args = array(
				'post_type'   		=>  'post',
	        	'post_status' 		=> 'publish',
				'posts_per_page'   	=> $post_number,
				'order' 			=> $post_order_by,
			);
		}else {
			$args = array(
				'post_type'   		=>  'post',
	        	'post_status' 		=> 'publish',
				'posts_per_page'   	=> $post_number,
				'order' 			=> $post_order_by,
				'tax_query' => array(
	            	array(
		                'taxonomy' => 'category',
		                'field'    => 'slug',
		                'terms'    => esc_attr($post_cat),
	                ),
	            ),
			);
		}

		$data = new \WP_Query( $args );

		$output = '';
			
		$output .= '<div class="home-lifestyle"background-size: cover; background-repeat: no-repeat;">';
		$output .= '<div class="container">';
		$output .= '<div class="themeum-post-slider2">';

			if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post();
					$output .= '<div class="lifestyle">';
						$output .= '<div class="row">';
							$output .= '<div class="col-md-4">';
								$output .= '<div class="article-image-wrap">';	
									$output .= '<a href="'.get_permalink().'" class="img-wrapper">';
										$output .= get_the_post_thumbnail(get_the_ID(), 'full', array('class' => 'img-responsive slider-bg'));
										$output .= get_the_post_thumbnail(get_the_ID(), 'gutenwp-portfo', array('class' => 'img-responsive'));
									$output .= '</a>';
								$output .= '</div>';
							$output .= '</div>'; # col-md-4

							$output .= '<div class="col-md-8">';
								$the_date = get_the_date();
								$output .= '<div class="article-details">';
									$output .= '<h3 class="article-title">';
										$output .= '<a href="'.get_permalink().'">'.mb_strimwidth(get_the_title(), 0, 80, '...').'</a>';
									$output .= '</h3>';
									
						            $output .= '<ul class="gutenwp-post-category">';
						                $output .= '<li class="meta-read">'.__(' By ', 'gutenwp').'  '.get_the_author_meta('display_name') .' /</li>';
						                $output .= '<li class="meta-category">'.date_i18n( get_option( 'date_format' ), strtotime($the_date)).'</li>';
						            $output .= '</ul>';
						            
								$output .= '</div>'; #article-details
							$output .= '</div>'; # col-md-8
						$output .= '</div>';
					$output .= '</div>';
				endwhile;
			endif;

		$output .= '</div>';
		$output .= '</div>';
		$output .= '</div>';

		wp_reset_query();
		return $output;
	}
}


