<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_Post_Slider {

	public function get_name(){
		return 'themeum_post_slider'; # addons name
	}
	public function get_title(){
		return __( 'Gutenwp Post Slider', 'gutenwp-core' );
	}
	public function get_icon() {
		return 'wppb-font-image';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	# Script ...
	public function get_enqueue_script(){
	    return array( 'gutenwp-main', 'gutenwp-slick' ); 
	}

	public function get_settings() {
		$settings = array(

			'post_cat' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Category', 'gutenwp-core'),
				'values' 	=> themeum_cat_list('category'),
				'std' 		=> 'All',
				'multiple' 	=> false, 
			),
			'post_number' => array(
				'type' 			=> 'text',
				'title' 		=> __('Number of Slider', 'gutenwp-core'),
				'placeholder' 	=> 'Number of Slider',
				'std' 			=> '4'
			),
			'post_order_by' => array(
				'type' 		=> 'select',
				'title' 	=> __('Select Order', 'gutenwp-core'),
				'values' 	=> array(
						'ASC' 		=> 'ASC',
						'DESC' 		=> 'DESC',
					),
				'std' 		=> 'DESC',
			),
			'textlimit' => array(
				'type' 			=> 'text',
				'title' 		=> __('Text Limit of Content', 'gutenwp-core'),
				'placeholder' 	=> '280',
				'std' 			=> '280'
			),
			# Text Align
			'text_align' => array(
				'type' => 'alignment',
				'title' => __('Alignment','wp-pagebuilder'),
				'responsive' => true,
				'selector' => '{{SELECTOR}} .article-details { text-align: {{data.text_align}}; }'
			),
			/*========================================
			* 			 Custom Style  
			==========================================*/
			'title_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Title Color','gutenwp-core'),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .section-content-second .article-title a, .thm-news-feed .addon-article .article-title a { color: {{data.title_color}}; }'
			),

			'text_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','wp-pagebuilder'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '14px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '400',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .thm-news-feed .addon-article .article-title a, .section-content-second .article-title a',
			),

            # Content Text.
            'content_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Content Color','gutenwp-core'),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .article-details p { color: {{data.content_color}}; }'
			),

			'content_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','wp-pagebuilder'),
				'std' 		=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md' => '14px', 'sm' => '', 'xs' => '' ),
					'lineHeight' 	=> array( 'md' => '', 'sm' => '', 'xs' => '' ),
					'fontWeight' 	=> '400',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md' => '', 'sm' => '', 'xs' =>'' ),
				),
				'tab' 		=> 'style',
				'selector' 	=> '{{SELECTOR}} .article-details p',
			),


		);

		return $settings;
	}


	public function render($data = null){

		$settings 		= $data['settings'];

		$post_number 		= $settings['post_number'];
		$post_cat 			= $settings['post_cat'];
		$post_order_by 		= $settings['post_order_by'];
		$textlimit 			= $settings['textlimit'];
		$page_numb 			= max( 1, get_query_var('paged') );




		# Query Build
		if ( $post_cat == 'All' ) {
			$args = array(
				'post_type'   		=> 'post',
				'post_status' 		=> 'publish',
				'posts_per_page'   	=> $post_number,
				'order' 			=> $post_order_by,
			);
		}else {
			$args = array(
				'post_type'   		=> 'post',
				'post_status' 		=> 'publish',
				'posts_per_page'   	=> $post_number,
				'order' 			=> $post_order_by,
				'tax_query' => array(
	            	array(
		                'taxonomy' => 'category',
		                'field'    => 'slug',
		                'terms'    => esc_attr($post_cat),
	                ),
	            ),
			);
		}

		$data = new \WP_Query( $args );
		$j = 0;

		$output = '';
		$output .= '<div class="slider-post-cont-wrap">';
		$output .= '<div class="gutenwp-post-slider">';
			if ( $data->have_posts() ) :
				while ( $data->have_posts() ) : $data->the_post(); 

				$image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' ); 

				if( $j == 0 ){
	            	$output .= '<div class="item active" style="padding:155px 0 155px 0; background-image: url('.esc_url($image_url[0]).'); background-repeat:no-repeat; background-size:cover;">';
	            }else{
	            	$output .= '<div class="item" style="padding:155px 0 155px 0; background-image: url('.esc_url($image_url[0]).');background-repeat:no-repeat;background-size:cover;">';
	            }

				$output .= '<div class="container guten-slider-cont">';
					$output .= '<div class="row">';
						$output .= '<div class="col-md-7">';


							$output .= '<div class="slider-content">';
								$output .= '<h2><a href="'.get_the_permalink().'">'.mb_strimwidth(get_the_title(), 0, 50, '...').'</a></h2>';
						        if ( $textlimit ) { 
						        	$output .= '<p>'.gutenwp_excerpt_max_charlength($textlimit).'</p>'; 
						        } 
						        $output .= '<a class="slider-btn" href="'.get_the_permalink().'">'.__('Read More', 'gutenwp').'</a>';

						        $output .= '
						        <i class="next_caro fa fa-arrow-left slick-arrow" style="display: block;"></i>
						        <i class="previous_caro fa fa-arrow-right slick-arrow" style="display: block;"></i> ';


					        $output .= '</div>';


				        $output .= '</div>';
			        $output .= '</div>';
		        $output .= '</div>';

		    	$output .= '</div>';
					
			endwhile; endif;
		$output .= '</div>';
		wp_reset_query();
		$output .= '</div>'; #<!-- row (inner) -->

		return $output;
	}

}


