<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Themeum_Title_Addon {

	public function get_name(){
		return 'gutenwp_title';
	}
	public function get_icon() {
		return 'wppb-font-heading';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Gutenwp Title ', 'gutenwp-core' );
	}
	
	# headline Settings Fields
	public function get_settings() {

		$settings = array(

			# General
			'title_txt' => array(
				'type' 	=> 'text',
				'title' => __('Title','gutenwp-core'),
				'std' 	=> 'This is Title',
			),
			'subtitle_content' => array( 
				'type' 	=> 'textarea',
				'title' => __('Sub Title Content','gutenwp-core'),
				'std' 	=> 'Enter Sub Title',
			),
			'align' 	=> array(
				'type'	 		=> 'alignment',
				'title' 		=> __('Alignment','gutenwp-core'),
				'responsive' 	=> true,
				'selector' 		=> '{{SELECTOR}} .gutenwp-title-content-wrapper { text-align: {{data.align}}; }'
			),

			# Style
			'title_color' 	=> array(
				'type' 		=> 'color',
				'title' 	=> __('Color','gutenwp-core'),
				'tab' 		=> 'style',
				'clip' 		=> true,
				'selector' 	=> '{{SELECTOR}} .themeum-title span{ color: {{data.title_color}}; }'
			),
			'border_off' 	=> array(
			    'type' 		=> 'switch',
			    'title' 	=> __('Enable Border', 'gutenwp-core'),
			    'std' 		=> 0
			),
			'title_border_color' 	=> array(
				'type' 				=> 'color',
				'title' 			=> __('Border Color','gutenwp-core'),
				'tab' 				=> 'style',
				'selector' 			=> '{{SELECTOR}} .themeum-title span:before { background-color: {{data.title_border_color}}; }'
			),
			'title_padding' 	=> array(
				'type' 			=> 'dimension',
				'title' 		=> 'Padding',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'selector' 		=> '{{SELECTOR}} .themeum-title { padding: {{data.title_padding}}; }',
			),
			'title_margin' => array(
				'type' 			=> 'dimension',
				'title' 		=> 'Margin',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'selector' 		=> '{{SELECTOR}} .themeum-title { margin: {{data.title_margin}}; }',
			),
			'title_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','gutenwp-core'),
				'std' 	=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md'=>'28px', 'sm'=>'', 'xs'=>'' ),
					'lineHeight' 	=> array( 'md'=>'', 'sm'=>'', 'xs'=>'' ),
					'fontWeight' 	=> '700',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md'=>'', 'sm'=>'', 'xs'=>'' ),
				),
				'selector' 	=> '{{SELECTOR}} .themeum-title',
				'tab' 		=> 'style',
			),
			# Sub Title.
			'subtitle_margin' => array(
				'type' 			=> 'dimension',
				'title' 		=> 'Margin',
				'unit' 			=> array( 'px','em','%' ),
				'responsive' 	=> true,
				'tab' 			=> 'style',
				'section' 		=> 'Sub Title',
				'selector' 		=> '{{SELECTOR}} .sub-title-content { margin: {{data.subtitle_margin}}; }',
			),
			'subtitle_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','gutenwp-core'),
				'std' 	=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md'=>'28px', 'sm'=>'', 'xs'=>'' ),
					'lineHeight' 	=> array( 'md'=>'', 'sm'=>'', 'xs'=>'' ),
					'fontWeight' 	=> '700',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md'=>'', 'sm'=>'', 'xs'=>'' ),
				),
				'section' 	=> 'Sub Title',
				'selector' 	=> '{{SELECTOR}} .sub-title-content',
				'tab' 		=> 'style',
			),
			'subtitle_color' => array(
				'type' 		=> 'color',
				'title' 	=> __('Subtitle Color','gutenwp-core'),
				'tab' 		=> 'style',
				'clip' 		=> true,
				'section' 	=> 'Sub Title',
				'selector' 	=> '{{SELECTOR}} .sub-title-content{ color: {{data.subtitle_color}}; }'
			),

		);

		return $settings;
	}

	# Title Render HTML
	public function render($data = null){
		$settings 		= $data['settings']; ?>

		<div class="gutenwp-title-content-wrapper">
			<h2 class="themeum-title"><span><?php echo $settings['title_txt']; ?></span></h2>
			<?php if( $settings['subtitle_content'] ){ ?>
				<p class="sub-title-content"><?php echo $settings['subtitle_content']; ?></p>
			<?php } ?>
		</div>
	<?php }


	# Title Template
	public function getTemplate(){
		$output = '
			<div class="gutenwp-title-content-wrapper">
				<h2 class="themeum-title"><span>{{{ data.title_txt }}}</span></h2>
				<p class="sub-title-content">{{{ data.subtitle_content }}}</p>
			</div>
		';
		return $output;
	}

}


