<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Gutenwp_Image{

	public function get_name(){
		return 'gutenwp_image';
	}
	public function get_icon() {
		return 'wppb-font-image';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Gutenwp Image ', 'gutenwp-core' );
	}

	# image Settings Fields
	public function get_settings() {

		$settings = array(
			'upload_image' 	=> array(
				'type' 		=> 'media',
				'title' 	=> __('Upload image','gutenwp-core'),
				'std'		=> '',
			),
			'title_text' 	=> array(
				'type' 	=> 'text',
				'title' => __('Title','gutenwp-core'),
				'std' 	=> 'Image Title',
			),
			'caption_text' 	=> array(
				'type' 		=> 'text',
				'title' 	=> 'Sub Title',
				'std' 		=> 'Sub Title',
			),
			'image_align' => array(
				'type' => 'alignment',
				'title' => __('Alignment','gutenwp-core'),
				'responsive' => true,
				'selector' => '{{SELECTOR}} .wppb-image-addon-content-wrap { text-align: {{data.image_align}}; }'
			),



		);

		return $settings;
	}


	# Image Render HTML
	public function render($data = null){
		$settings 		= $data['settings'];
		$upload_image 	= isset($settings['upload_image']) ? $settings['upload_image'] : array();
		$title_text 	= isset($settings['title_text']) ? $settings['title_text'] : '';
		$caption_text 	= isset($settings['caption_text']) ? $settings['caption_text'] : '';
		
		$img_url = '';
		$output = '';

		if(! empty($upload_image['url'])){
			$img_url = $upload_image['url'];
		}

		$output  .= '<div class="gutenwp-image-wrap">';
			$output  .= '<img class="wppb-image-addon-img" src="'.esc_url($img_url).'">';
			$output  .= '<div class="intro-gutenwp-text">';
				if($title_text){
					$output .= '<h2 class="image-title">'. esc_attr($title_text).'</h2>';
				}
				if($caption_text){
					$output .= '<h3 class="image-caption">'. esc_attr($caption_text).'</h3>';
				}
			$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

}