<?php

if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

class Gutenwp_PDF_Book_Addon {

	public function get_name(){
		return 'gutenwp_pdf_book';
	}
	public function get_icon() {
		return 'wppb-font-heading';
	}
	public function get_category_name(){
		return __( 'Gutenwp Widgets', 'gutenwp-core' );
	}
	public function get_title(){
		return __( 'Gutenwp PDF Book', 'gutenwp-core' );
	}
	
	# headline Settings Fields
	public function get_settings() {

		$settings = array(

			# General
			'upload_image' => array(
				'type' 		=> 'media',
				'title' 	=> __('Upload Cover Image','gutenwp-core'),
				'std'		=> array( 'url' => WPPB_DIR_URL.'assets/img/placeholder/wppb-medium.jpg' ),
			),
			'book_name' => array(
				'type' 	=> 'text',
				'title' => __('Book Title','gutenwp-core'),
				'std' 	=> 'Book Name',
			),
			'book_url' => array(
				'type' 	=> 'text',
				'title' => __('Midea Book Upload URL','gutenwp-core'),
				'std' 	=> 'Book URL',
			),
			'align' 	=> array(
				'type'	 		=> 'alignment',
				'title' 		=> __('Alignment','gutenwp-core'),
				'responsive' 	=> true,
				'selector' 		=> '{{SELECTOR}} .gutenwp-title-content-wrapper { text-align: {{data.align}}; }'
			),

			# Style
			'title_color' 	=> array(
				'type' 		=> 'color',
				'title' 	=> __('Color','gutenwp-core'),
				'tab' 		=> 'style',
				'clip' 		=> true,
				'selector' 	=> '{{SELECTOR}} .themeum-title span{ color: {{data.title_color}}; }'
			),
			'title_fontstyle' => array(
				'type' 		=> 'typography',
				'title' 	=> __('Typography','gutenwp-core'),
				'std' 	=> array(
					'fontFamily' 	=> '',
					'fontSize' 		=> array( 'md'=>'28px', 'sm'=>'', 'xs'=>'' ),
					'lineHeight' 	=> array( 'md'=>'', 'sm'=>'', 'xs'=>'' ),
					'fontWeight' 	=> '700',
					'textTransform' => '',
					'fontStyle' 	=> '',
					'letterSpacing' => array( 'md'=>'', 'sm'=>'', 'xs'=>'' ),
				),
				'selector' 	=> '{{SELECTOR}} .themeum-title',
				'tab' 		=> 'style',
			),

		);

		return $settings;
	}

	# Title Render HTML
	public function render($data = null){
		$settings 		= $data['settings']; 
		$book_name 		= $settings['book_name'];
		$book_url 		= $settings['book_url'];
		$upload_image 	= isset($settings['upload_image']) ? $settings['upload_image'] : array();

		if(! empty($upload_image['url'])){
			$img_url = $upload_image['url'];
		}

		$output  = '';
		$output  .= '<div class="gutenwp-book-wrapper">';
			$output  .= '<img class="gutenwp-book-img" src="'.esc_url($img_url).'">';
			$output  .= '<a href="'.$book_url.'" download><span class="book_name">'.$settings['book_name'] .' <i class="fa fa-dropbox" aria-hidden="true"></i></span></span></a>';
		$output  .= '</div>';
		return $output;
	}
	# render end
}


