<?php
/*
* Plugin Name: Gutenwp Core
* Plugin URI: http://www.themeum.com/item/gutenwp-core
* Author: Themeum
* Author URI: http://www.themeum.com
* License - GNU/GPL V2 or Later
* Description: gutenwp Core is a required plugin for this theme.
* Version: 1.0.0
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; # Exit if accessed directly
}

# language
add_action( 'init', 'themeum_core_language_load' );
function themeum_core_language_load(){
    $plugin_dir = basename(dirname(__FILE__))."/languages/";
    load_plugin_textdomain( 'gutenwp-core', false, $plugin_dir );
}

# Category List
if( !function_exists("themeum_cat_list") ){
    # List of Group
    function themeum_cat_list( $category ){
        global $wpdb;
        $sql = "SELECT * FROM `".$wpdb->prefix."term_taxonomy` INNER JOIN `".$wpdb->prefix."terms` ON `".$wpdb->prefix."term_taxonomy`.`term_taxonomy_id`=`".$wpdb->prefix."terms`.`term_id` AND `".$wpdb->prefix."term_taxonomy`.`taxonomy`='".$category."'";
        $results = $wpdb->get_results( $sql );

        $cat_list = array();
        $cat_list['All'] = 'All';
        if(is_array($results)){
            foreach ($results as $value) {
                $cat_list[$value->name] = $value->slug;
            }
        }
        return $cat_list;
    }
}
# End Cat.

# Metabox Include
include_once( 'post-type/meta_box.php' );
include_once( 'post-type/meta-box/meta-box.php' );

# widget
require_once('widgets/blog-posts.php');
require_once('widgets/image_widget.php');
require_once('widgets/themeum_about_widget.php');
require_once('widgets/themeum_social_share.php');
require_once('widgets/gutenberg_social_share2.php');

# Custom Customizer
include_once( 'customizer/libs/googlefonts.php' );
include_once( 'customizer/customizer.php' );

# WPPageBuilder
include_once( 'wp-pagebuilder/wp-pagebuilder.php' );

# Add CSS for Frontend
add_action( 'wp_enqueue_scripts', 'themeum_core_style' );
if(!function_exists('themeum_core_style')):
function themeum_core_style(){
    # CSS
    wp_enqueue_style('gutenwp-core',plugins_url('assets/css/gutenwp-core.css',__FILE__));

    # JS
    wp_enqueue_script('main',plugins_url('assets/js/main.js',__FILE__), array('jquery'));
}
endif;

function themeum_load_admin_assets() {
    wp_enqueue_script( 'themeum-admin', plugins_url('assets/js/admin.js', __FILE__), array('jquery') );
}
add_action( 'admin_enqueue_scripts', 'themeum_load_admin_assets' );

