<?php

/**
 * Themeum Customizer
 */


if (!class_exists('THMC_Framework')):

	class THMC_Framework
	{
		/**
		 * Instance of WP_Customize_Manager class
		 */
		public $wp_customize;


		private $fields_class = array();

		private $google_fonts = array();

		private $all_dependency = array();

		/**
		 * Constructor of 'THMC_Framework' class
		 *
		 * @wp_customize (WP_Customize_Manager) Instance of 'WP_Customize_Manager' class
		 */
		function __construct( $wp_customize )
		{
			$this->wp_customize = $wp_customize;

			$this->fields_class = array(
				'text'            => 'WP_Customize_Control',
				'checkbox'        => 'WP_Customize_Control',
				'textarea'        => 'WP_Customize_Control',
				'radio'           => 'WP_Customize_Control',
				'select'          => 'WP_Customize_Control',
				'email'           => 'WP_Customize_Control',
				'url'             => 'WP_Customize_Control',
				'number'          => 'WP_Customize_Control',
				'range'           => 'WP_Customize_Control',
				'hidden'          => 'WP_Customize_Control',
				'date'            => 'THMC_Date_Control',
				'color'           => 'WP_Customize_Color_Control',
				'upload'          => 'WP_Customize_Upload_Control',
				'image'           => 'WP_Customize_Image_Control',
				'radio_button'    => 'THMC_Radio_Button_Control',
				'checkbox_button' => 'THMC_Checkbox_Button_Control',
				'switch'          => 'THMC_Switch_Button_Control',
				'multi_select'    => 'THMC_Multi_Select_Control',
				'radio_image'     => 'THMC_Radio_Image_Control',
				'checkbox_image'  => 'THMC_Checkbox_Image_Control',
				'color_palette'   => 'THMC_Color_Palette_Control',
				'rgba'            => 'THMC_Rgba_Color_Picker_Control',
				'title'           => 'THMC_Switch_Title_Control',
			);

			$this->load_custom_controls();

			add_action( 'customize_controls_enqueue_scripts', array( $this, 'customizer_scripts' ), 100 );
		}

		public function customizer_scripts()
		{
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'thmc-select2', plugin_dir_url( __FILE__ ).'assets/select2/css/select2.min.css' );
			wp_enqueue_style( 'thmc-customizer', plugin_dir_url( __FILE__ ).'assets/css/customizer.css' );

			// Load all js
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_script( 'wp-color-picker' );
			wp_enqueue_script( 'thmc-select2', plugin_dir_url( __FILE__ ).'assets/select2/js/select2.min.js', array('jquery'), '1.0', true );
			wp_enqueue_script( 'thmc-rgba-colorpicker', plugin_dir_url( __FILE__ ).'assets/js/thmc-rgba-colorpicker.js', array('jquery', 'wp-color-picker'), '1.0', true );
			wp_enqueue_script( 'thmc-customizer', plugin_dir_url( __FILE__ ).'assets/js/customizer.js', array('jquery', 'jquery-ui-datepicker'), '1.0', true );
			wp_localize_script( 'thmc-customizer', 'thm_customizer', array(
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'import_success' => esc_html__('Success! Your theme data successfully imported. Page will be reloaded within 2 sec.', 'gutenwp-core'),
				'import_error' => esc_html__('Error! Your theme data importing failed.', 'gutenwp-core'),
				'file_error' => esc_html__('Error! Please upload a file.', 'gutenwp-core')
			) );
		}

		private function load_custom_controls()
		{
			include_once( 'controls/radio-button.php' );
			include_once( 'controls/radio-image.php' );
			include_once( 'controls/checkbox-button.php' );
			include_once( 'controls/checkbox-image.php' );
			include_once( 'controls/switch.php' );
			include_once( 'controls/date.php' );
			include_once( 'controls/multi-select.php' );
			include_once( 'controls/color-palette.php' );
			include_once( 'controls/rgba-colorpicker.php' );
			include_once( 'controls/title.php' );

			// Load Sanitize class
			include_once( 'libs/sanitize.php' );
		}

		public function add_option( $options )
		{
			if (isset($options['sections'])) {
				$this->panel_to_section($options);
			} elseif (isset($options['options'])){

			}



		}



		private function panel_to_section( $options )
		{
			$panel = $options;
			$panel_id = $options['id'];

			unset($panel['sections']);
			unset($panel['id']);

			// Register this panel
			$this->add_panel($panel, $panel_id);

			$sections = $options['sections'];

			if (!empty($sections)) {
				foreach ($sections as $section) {
					$fields = $section['fields'];
					$section_id = $section['id'];

					unset($section['fields']);
					unset($section['id']);

					$section['panel'] = $panel_id;

					$this->add_section($section, $section_id);

					if (!empty($fields)) {
						foreach ($fields as $field) {
							$field_id = $field['settings'];

							$this->add_field($field, $field_id, $section_id);
						}
					}
				}
			}
		}

		private function add_panel($panel, $panel_id){
			$this->wp_customize->add_panel( $panel_id, $panel );
		}

		private function add_section($section, $section_id)
		{
			$this->wp_customize->add_section( $section_id, $section );
		}

		private function add_field($field, $field_id, $section_id){


			$setting_args = array(
				'default'        => isset($field['default']) ? $field['default'] : '',
				'type'           => isset($field['setting_type']) ? $field['setting_type'] : 'theme_mod',
				'transport'     => isset($field['transport']) ? $field['transport'] : 'refresh',
				'capability'     => isset($field['capability']) ? $field['capability'] : 'edit_theme_options',
			);

			if (isset($field['type']) && $field['type'] == 'switch') {
				$setting_args['sanitize_callback'] = array('THMC_Sanitize', 'switch_sntz');
			} elseif (isset($field['type']) && ($field['type'] == 'checkbox_button' || $field['type'] == 'checkbox_image')) {
				$setting_args['sanitize_callback'] = array('THMC_Sanitize', 'multi_checkbox');
			} elseif (isset($field['type']) && $field['type'] == 'multi_select') {
				$setting_args['sanitize_callback'] = array('THMC_Sanitize', 'multi_select');
				$setting_args['sanitize_js_callback'] = array('THMC_Sanitize', 'multi_select_js');
			}

			$control_args = array(
				'label'       => isset($field['label']) ? $field['label'] : '',
				'section'     => $section_id,
				'settings'    => $field_id,
				'type'        => isset($field['type']) ? $field['type'] : 'text',
				'priority'    => isset($field['priority']) ? $field['priority'] : 10,
			);

			if (isset($field['choices'])) {
				$control_args['choices'] = $field['choices'];
			}

			// Register the settings
			$this->wp_customize->add_setting( $field_id, $setting_args );

			$control_class = isset($this->fields_class[$field['type']]) ? $this->fields_class[$field['type']] : 'WP_Customize_Control';

			// Add the controls
			$this->wp_customize->add_control( new $control_class( $this->wp_customize, $field_id, $control_args ) );

			if (isset($field['dependency'])) {

				$dependency = $field['dependency'];

				$this->add_dependency($field_id, $dependency);
			}
		}

		private function add_dependency( $id, $dependency )
		{
			$this->all_dependency[$id] = $dependency;
		}

		public function get_dependency()
		{
			return $this->all_dependency;
		}
	}

endif;

/**
*
*/
class THM_Customize
{
	public $google_fonts = array();

	public $all_dependency = array();

	function __construct( $options )
	{
		$this->options = $options;

		add_action('customize_register', array($this, 'customize_register'));
		add_action('wp_enqueue_scripts', array($this, 'get_google_fonts_data'));

		add_action('wp_ajax_thm_export_data', array($this, 'export_data_cb'));
		add_action('wp_ajax_thm_import_data', array($this, 'import_data_cb'));
	}

	public function customize_register( $wp_customize )
	{
		$framework = new THMC_Framework( $wp_customize );

		$framework->add_option( $this->options );

		$this->all_dependency = $framework->get_dependency();

		$this->import_export_ui( $wp_customize );

		add_action( 'customize_controls_enqueue_scripts', array( $this, 'dependency_json_register' ), 110 );
	}

	public function dependency_json_register()
	{
		wp_localize_script( 'thmc-customizer', 'thm_all_dependency', $this->all_dependency);
	}

	public function import_export_ui( $wp_customize )
	{
		include_once( 'controls/export.php' );
		include_once( 'controls/import.php' );

		$wp_customize->add_section( 'thm_import_export', array(
			'title'           => esc_html__( 'Import/Export', 'gutenwp-core' ),
			'description'     => esc_html__( 'Import Export Option Data', 'gutenwp-core' ),
			'priority'        => 1000,
		) );

		$wp_customize->add_setting( 'thm_export', array(
			'default'        => '',
			'transport'      => 'postMessage',
			'capability'     => 'edit_theme_options',
		) );

		$wp_customize->add_control( new THMC_Export_Control( $wp_customize, 'thm_export_ctrl', array(
			'label'       => 'Export Theme Data',
			'section'     => 'thm_import_export',
			'settings'    => 'thm_export',
			'type'        => 'export',
			'priority'    => 10,
		) ) );

		$wp_customize->add_setting( 'thm_import', array(
			'default'        => '',
			'transport'      => 'postMessage',
			'capability'     => 'edit_theme_options',
		) );

		$wp_customize->add_control( new THMC_Import_Control( $wp_customize, 'thm_import_ctrl', array(
			'label'       => 'Import Theme Data',
			'section'     => 'thm_import_export',
			'settings'    => 'thm_import',
			'type'        => 'export',
			'priority'    => 10,
		) ) );
	}

	public function export_data_cb()
	{
		$theme_slug = get_option( 'stylesheet' );
		$mods = get_option( "theme_mods_$theme_slug" );

		header( "Content-Description: File Transfer" );
		header( "Content-Disposition: attachment; filename=theme_data.json" );
		header( "Content-Type: application/octet-stream" );
		echo json_encode($mods);
		exit;
	}

	public function import_data_cb()
	{
		$theme_data = file_get_contents($_FILES['file']['tmp_name']);

		if (empty($theme_data)) {
			echo 0;
			exit();
		}

		$theme_data = json_decode($theme_data, true);

		if (empty($theme_data)) {
			echo 0;
			exit();
		}

		unset($theme_data['nav_menu_locations']);

		$theme_slug = get_option( 'stylesheet' );
		$mods = get_option( "theme_mods_$theme_slug" );

		if ($mods  === false) {
			$status = add_option( "theme_mods_$theme_slug", $theme_data );
			if ($status) {
				echo 1;
			} else {
				echo 0;
			}
		} else {
			$theme_data['nav_menu_locations'] = $mods['nav_menu_locations'];
			$status = update_option( "theme_mods_$theme_slug", $theme_data );

			if ($status) {
				echo 1;
			} else {
				echo 0;
			}
		}

		exit();
	}

	public function get_google_fonts_data()
	{
		if (isset($this->options['sections']) && !empty($this->options['sections'])) {
			foreach ($this->options['sections'] as $section) {
				if (isset($section['fields']) && !empty($section['fields'])) {
					foreach ($section['fields'] as $field) {
						if (isset($field['google_font']) && $field['google_font'] == true) {
							$this->google_fonts[$field['settings']] = array();

							if (isset($field['default']) && !empty($field['default'])) {
								$this->google_fonts[$field['settings']]["default"] = $field['default'];
							}

							if (isset($field['google_font_weight']) && !empty($field['google_font_weight'])) {
								$this->google_fonts[$field['settings']]["weight"] = $field['google_font_weight'];
							}

							if (isset($field['google_font_weight_default']) && !empty($field['google_font_weight_default'])) {
								$this->google_fonts[$field['settings']]["weight_default"] = $field['google_font_weight_default'];
							}
						}
					}
				}
			}
		}

		$all_fonts = array();

		if (!empty($this->google_fonts)) {
			foreach ($this->google_fonts as $font_id => $font_data) {
				$font_family_default = isset($font_data['default']) ? $font_data['default'] : '';
				$font_family = get_theme_mod( $font_id, $font_family_default );

				if (!isset($all_fonts[$font_family])) {
					$all_fonts[$font_family] = array();
				}

				if (isset($font_data['weight']) && !empty($font_data['weight'])) {
					$font_weight_default = isset($font_data['weight_default']) ? $font_data['weight_default'] : '';

					$font_weight = get_theme_mod( $font_data['weight'], $font_weight_default );


					$all_fonts[$font_family][] = $font_weight;
				}

			}
		}

		$font_url = "//fonts.googleapis.com/css?family=";

		if (!empty($all_fonts)) {

			$i = 0;

			foreach ($all_fonts as $font => $weights) {

				if ($i) {
					$font_url .= "|";
				}

				$font_url .= str_replace(" ", "+", $font);

				if (!empty($weights)) {
					$font_url .= ":";
					$font_url .= implode(",", $weights);
				}

				$i++;
			}

			wp_enqueue_style( "tm-google-font", $font_url );
		}
	}
}




/*
 *
 * Current Fields: text, checkbox, textarea, radio, select, email, url, number, hidden, color, upload, image, Range
 *
 * Required Fields: [Done] RGBA Color Picker, [Done] Palette Color, [Done] Button Set (Radio & Checkbox), [Done] Switch, [Done] Multi-Select, [Done] Image Select, [Done] Date Picker
 */

/**
 * Example Data
 *
 * These data will be removed later
 */



$panel_to_section = array(
	'id'           => 'gutenwp_panel_options',
	'title'        => esc_html( 'Gutenwp Options', 'gutenwp-core' ),
	'description'  => esc_html__( 'Gutenwp Theme Options', 'gutenwp-core' ),
	'priority'     => 10,
	'sections'     => array(

		array(
			'id'              => 'header_setting',
			'title'           => esc_html__( 'Header Settings', 'gutenwp-core' ),
			'description'     => esc_html__( 'Header Settings', 'gutenwp-core' ),
			'priority'        => 10,
			'fields'         => array(

				array(
					'settings' => 'header_style',
					'label'    => esc_html__( 'Select Header Style', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'regular_menu',
					'choices'  => array(
						'regular_menu' 		 => esc_html( 'Default Header', 'gutenwp-core' ),
						'header_classic' 	 => esc_html( 'Header with Classic menu', 'gutenwp-core' ),
						'offcanvas_menu' 	 => esc_html( 'Regular Menu with Offcanvas menu', 'gutenwp-core' ),
						'offcanvas_menu_off' => esc_html( 'Offcanvas menu', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'header_fixed',
					'label'    => esc_html__( 'Sticky Header', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),
				array(
					'settings' => 'header_color',
					'label'    => esc_html__( 'Header background Color', 'gutenwp-core' ),
					'type'     => 'rgba',
					'priority' => 10,
					'default'  => '#fff',
				),
				array(
					'settings' => 'sticky_header_color',
					'label'    => esc_html__( 'Sticky background Color', 'gutenwp-core' ),
					'type'     => 'rgba',
					'priority' => 10,
					'default'  => '#fff',
				),
				array(
					'settings' => 'header_padding_setting_content',
					'label'    => esc_html__( 'Header Padding Settings', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 20,
				),
				array(
					'settings' => 'header_padding_top',
					'label'    => esc_html__( 'Header Top Padding', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 120,
					'default'  => 20,
				),
				array(
					'settings' => 'header_padding_bottom',
					'label'    => esc_html__( 'Header Bottom Padding', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 65,
					'default'  => 20,
				),
			)//fields
		),//header_setting

		array(
			'id'              => 'logo_setting',
			'title'           => esc_html__( 'All Logo', 'gutenwp-core' ),
			'description'     => esc_html__( 'All Logo', 'gutenwp-core' ),
			'priority'        => 10,
			// 'active_callback' => 'is_front_page',
			'fields'         => array(

				array(
					'settings' 	=> 'favicon_logo',
					'label'    	=> esc_html__( 'Upload Favicon Logo', 'gutenwp-core' ),
					'type'     	=> 'upload',
					'priority' 	=> 10,
					'default' 	=> '',
				),

				array(
					'settings' => 'logo_style',
					'label'    => esc_html__( 'Select logo Style', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'logoimg',
					'choices'  => array(
						'logoimg' => esc_html( 'Logo image', 'gutenwp-core' ),
						'logotext' => esc_html( 'Logo text', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'logo',
					'label'    => esc_html__( 'Upload Logo', 'gutenwp-core' ),
					'type'     => 'upload',
					'priority' => 10,
					'default' => get_template_directory_uri().'/images/logo.png',
				),
				array(
					'settings' => 'logo_width',
					'label'    => esc_html__( 'Logo Width', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 128,
				),
				array(
					'settings' => 'logo_height',
					'label'    => esc_html__( 'Logo Height', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
				),
				array(
					'settings' => 'logo_text',
					'label'    => esc_html__( 'Use your Custom logo text', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => 'GutenWP',
				),
			)//fields
		),//logo_setting


		array(
			'id'              => 'sub_header_banner',
			'title'           => esc_html__( 'Sub Header Banner', 'eventco-core' ),
			'description'     => esc_html__( 'sub header banner', 'eventco-core' ),
			'priority'        => 10,
			// 'active_callback' => 'is_front_page',
			'fields'         => array(

				array(
					'settings' => 'enable_sub_header',
					'label'    => esc_html__( 'Enable Sub Header Banner', 'eventco-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),

				array(
					'settings' => 'sub_header_padding_top',
					'label'    => esc_html__( 'Sub-Header Padding Top', 'eventco-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 150,
				),
				array(
					'settings' => 'sub_header_padding_bottom',
					'label'    => esc_html__( 'Sub-Header Padding Bottom', 'eventco-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 150,
				),
				array(
					'settings' => 'sub_header_margin_bottom',
					'label'    => esc_html__( 'Sub-Header Margin Bottom', 'eventco-core' ),
					'type'     => 'number',
					'priority' => 100,
					'default'  => 0,
				),

				array(
					'settings' => 'sub_header_banner_img',
					'label'    => esc_html__( 'Sub-Header Background Image', 'eventco-core' ),
					'type'     => 'image',
					'priority' => 10,
					'default' => get_template_directory_uri().'/images/sub-header-banner.jpg',
				),

				array(
					'settings' => 'sub_header_bg_color',
					'label'    => esc_html__( 'Header Backgroumd Color', 'eventco-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#DC014D',
				),

				array(
					'settings' => 'sub_header_title',
					'label'    => esc_html__( 'Title Settings', 'eventco-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				array(
					'settings' => 'sub_header_title_size',
					'label'    => esc_html__( 'Header Title Font Size', 'eventco-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => '88',
				),
				array(
					'settings' => 'sub_header_title_color',
					'label'    => esc_html__( 'Header Title Color', 'eventco-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#fff',
				),
			)//fields
		),//sub_header_banner




		# Typography.
		array(
			'id'              => 'typo_setting',
			'title'           => esc_html__( 'Typography Settings', 'gutenwp-core' ),
			'description'     => esc_html__( 'Typography Settings', 'gutenwp-core' ),
			'priority'        => 10,
			'fields'         => array(

				array(
					'settings' => 'font_title_body',
					'label'    => esc_html__( 'Body Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				//body font
				array(
					'settings' => 'body_google_font',
					'label'    => esc_html__( 'Select Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'body_font_weight',
					'google_font_weight_default' => '300'
				),
				array(
					'settings' => 'body_font_size',
					'label'    => esc_html__( 'Body Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '16',
				),
				array(
					'settings' => 'body_font_height',
					'label'    => esc_html__( 'Body Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '24',
				),
				array(
					'settings' => 'body_font_weight',
					'label'    => esc_html__( 'Body Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'body_font_color',
					'label'    => esc_html__( 'Body Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#5e6571',
				),
				array(
					'settings' => 'font_title_menu',
					'label'    => esc_html__( 'Menu Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				//Menu font
				array(
					'settings' => 'menu_google_font',
					'label'    => esc_html__( 'Select Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'menu_font_weight',
					'google_font_weight_default' => '500'
				),
				array(
					'settings' => 'menu_font_size',
					'label'    => esc_html__( 'Menu Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '18',
				),
				array(
					'settings' => 'menu_font_height',
					'label'    => esc_html__( 'Menu Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '24',
				),
				array(
					'settings' => 'menu_font_weight',
					'label'    => esc_html__( 'Menu Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'menu_font_color',
					'label'    => esc_html__( 'Menu Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#676767',
				),

				array(
					'settings' => 'font_title_h1',
					'label'    => esc_html__( 'Heading 1 Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				//Heading 1
				array(
					'settings' => 'h1_google_font',
					'label'    => esc_html__( 'Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'menu_font_weight',
					'google_font_weight_default' => '400'
				),
				array(
					'settings' => 'h1_font_size',
					'label'    => esc_html__( 'Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '42',
				),
				array(
					'settings' => 'h1_font_height',
					'label'    => esc_html__( 'Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '48',
				),
				array(
					'settings' => 'h1_font_weight',
					'label'    => esc_html__( 'Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'h1_font_color',
					'label'    => esc_html__( 'Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#131d30',
				),

				array(
					'settings' => 'font_title_h2',
					'label'    => esc_html__( 'Heading 2 Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				//Heading 2
				array(
					'settings' => 'h2_google_font',
					'label'    => esc_html__( 'Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'menu_font_weight',
					'google_font_weight_default' => '400'
				),
				array(
					'settings' => 'h2_font_size',
					'label'    => esc_html__( 'Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '36',
				),
				array(
					'settings' => 'h2_font_height',
					'label'    => esc_html__( 'Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '36',
				),
				array(
					'settings' => 'h2_font_weight',
					'label'    => esc_html__( 'Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'h2_font_color',
					'label'    => esc_html__( 'Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#131d30',
				),

				array(
					'settings' => 'font_title_h3',
					'label'    => esc_html__( 'Heading 3 Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				//Heading 3
				array(
					'settings' => 'h3_google_font',
					'label'    => esc_html__( 'Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'menu_font_weight',
					'google_font_weight_default' => '700'
				),
				array(
					'settings' => 'h3_font_size',
					'label'    => esc_html__( 'Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '26',
				),
				array(
					'settings' => 'h3_font_height',
					'label'    => esc_html__( 'Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '28',
				),
				array(
					'settings' => 'h3_font_weight',
					'label'    => esc_html__( 'Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'h3_font_color',
					'label'    => esc_html__( 'Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#131d30',
				),

				array(
					'settings' => 'font_title_h4',
					'label'    => esc_html__( 'Heading 4 Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				//Heading 4
				array(
					'settings' => 'h4_google_font',
					'label'    => esc_html__( 'Heading4 Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'menu_font_weight',
					'google_font_weight_default' => '400'
				),
				array(
					'settings' => 'h4_font_size',
					'label'    => esc_html__( 'Heading4 Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '18',
				),
				array(
					'settings' => 'h4_font_height',
					'label'    => esc_html__( 'Heading4 Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '26',
				),
				array(
					'settings' => 'h4_font_weight',
					'label'    => esc_html__( 'Heading4 Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'h4_font_color',
					'label'    => esc_html__( 'Heading4 Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#131d30',
				),

				array(
					'settings' => 'font_title_h5',
					'label'    => esc_html__( 'Heading 5 Font Options', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),

				//Heading 5
				array(
					'settings' => 'h5_google_font',
					'label'    => esc_html__( 'Heading5 Google Font', 'gutenwp-core' ),
					'type'     => 'select',
					'default'  => 'Barlow',
					'choices'  => get_google_fonts(),
					'google_font' => true,
					'google_font_weight' => 'menu_font_weight',
					'google_font_weight_default' => '400'
				),
				array(
					'settings' => 'h5_font_size',
					'label'    => esc_html__( 'Heading5 Font Size', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '14',
				),
				array(
					'settings' => 'h5_font_height',
					'label'    => esc_html__( 'Heading5 Font Line Height', 'gutenwp-core' ),
					'type'     => 'number',
					'default'  => '24',
				),
				array(
					'settings' => 'h5_font_weight',
					'label'    => esc_html__( 'Heading5 Font Weight', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '400',
					'choices'  => array(
						'' => esc_html( 'Select', 'gutenwp-core' ),
						'100' => esc_html( '100', 'gutenwp-core' ),
						'200' => esc_html( '200', 'gutenwp-core' ),
						'300' => esc_html( '300', 'gutenwp-core' ),
						'400' => esc_html( '400', 'gutenwp-core' ),
						'500' => esc_html( '500', 'gutenwp-core' ),
						'600' => esc_html( '600', 'gutenwp-core' ),
						'700' => esc_html( '700', 'gutenwp-core' ),
						'800' => esc_html( '800', 'gutenwp-core' ),
						'900' => esc_html( '900', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'h5_font_color',
					'label'    => esc_html__( 'Heading5 Font Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#131d30',
				),

			)//fields
		),//typo_setting

		array(
			'id'              => 'layout_styling',
			'title'           => esc_html__( 'Layout & Styling', 'gutenwp-core' ),
			'description'     => esc_html__( 'Layout & Styling', 'gutenwp-core' ),
			'priority'        => 10,
			// 'active_callback' => 'is_front_page',
			'fields'         => array(
				array(
					'settings' => 'boxfull_en',
					'label'    => esc_html__( 'Select BoxWidth of FullWidth', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'fullwidth',
					'choices'  => array(
						'boxwidth' => esc_html__( 'BoxWidth', 'gutenwp-core' ),
						'fullwidth' => esc_html__( 'FullWidth', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'body_bg_color',
					'label'    => esc_html__( 'Body Background Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#f7f7f9',
				),
				array(
					'settings' => 'body_bg_img',
					'label'    => esc_html__( 'Body Background Image', 'gutenwp-core' ),
					'type'     => 'image',
					'priority' => 10,
				),
				array(
					'settings' => 'body_bg_attachment',
					'label'    => esc_html__( 'Body Background Attachment', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'fixed',
					'choices'  => array(
						'scroll' => esc_html__( 'Scroll', 'gutenwp-core' ),
						'fixed' => esc_html__( 'Fixed', 'gutenwp-core' ),
						'inherit' => esc_html__( 'Inherit', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'body_bg_repeat',
					'label'    => esc_html__( 'Body Background Repeat', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'no-repeat',
					'choices'  => array(
						'repeat' => esc_html__( 'Repeat', 'gutenwp-core' ),
						'repeat-x' => esc_html__( 'Repeat Horizontally', 'gutenwp-core' ),
						'repeat-y' => esc_html__( 'Repeat Vertically', 'gutenwp-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'body_bg_size',
					'label'    => esc_html__( 'Body Background Size', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'cover',
					'choices'  => array(
						'cover' => esc_html__( 'Cover', 'gutenwp-core' ),
						'contain' => esc_html__( 'Contain', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'body_bg_position',
					'label'    => esc_html__( 'Body Background Position', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'left top',
					'choices'  => array(
						'left top' 			=> esc_html__('left top', 'gutenwp-core'),
						'left center' 		=> esc_html__('left center', 'gutenwp-core'),
						'left bottom' 		=> esc_html__('left bottom', 'gutenwp-core'),
						'right top' 		=> esc_html__('right top', 'gutenwp-core'),
						'right center' 		=> esc_html__('right center', 'gutenwp-core'),
						'right bottom' 		=> esc_html__('right bottom', 'gutenwp-core'),
						'center top' 		=> esc_html__('center top', 'gutenwp-core'),
						'center center' 	=> esc_html__('center center', 'gutenwp-core'),
						'center bottom' 	=> esc_html__('center bottom', 'gutenwp-core'),
					)
				),

				array(
					'settings' => 'major_color',
					'label'    => esc_html__( 'Major Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#fc8a15',
				),
				array(
					'settings' => 'hover_color',
					'label'    => esc_html__( 'Hover Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#fc8a15',
				),

				# navbar color section start.
				array(
					'settings' => 'menu_color_title',
					'label'    => esc_html__( 'Menu Color Settings', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				array(
					'settings' => 'navbar_text_color',
					'label'    => esc_html__( 'Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#676767',
				),

				array(
					'settings' => 'navbar_hover_text_color',
					'label'    => esc_html__( 'Hover Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#fc8a15',
				),

				array(
					'settings' => 'navbar_active_text_color',
					'label'    => esc_html__( 'Active Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#fc8a15',
				),

				array(
					'settings' => 'sub_menu_color_title',
					'label'    => esc_html__( 'Sub-Menu Color Settings', 'gutenwp-core' ),
					'type'     => 'title',
					'priority' => 10,
				),
				array(
					'settings' => 'sub_menu_bg',
					'label'    => esc_html__( 'Background Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#ffffff',
				),
				array(
					'settings' => 'sub_menu_text_color',
					'label'    => esc_html__( 'Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#676767',
				),
				array(
					'settings' => 'sub_menu_text_color_hover',
					'label'    => esc_html__( 'Hover Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#fc8a15',
				),
				#End of the navbar color section


			)//fields
		),//Layout & Styling

		array(
			'id'              => 'social_media_settings',
			'title'           => esc_html__( 'Social Media', 'gutenwp-core' ),
			'description'     => esc_html__( 'Social Media', 'gutenwp-core' ),
			'priority'        => 10,
			// 'active_callback' => 'is_front_page',
			'fields'         => array(
				array(
					'settings' => 'wp_facebook',
					'label'    => esc_html__( 'Add Facebook URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '#',
				),
				array(
					'settings' => 'wp_twitter',
					'label'    => esc_html__( 'Add Twitter URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '#',
				),
				array(
					'settings' => 'wp_google_plus',
					'label'    => esc_html__( 'Add Goole Plus URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '#',
				),
				array(
					'settings' => 'wp_pinterest',
					'label'    => esc_html__( 'Add Pinterest URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '#',
				),
				array(
					'settings' => 'wp_youtube',
					'label'    => esc_html__( 'Add Youtube URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
				array(
					'settings' => 'wp_linkedin',
					'label'    => esc_html__( 'Add Linkedin URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
				array(
					'settings' => 'wp_linkedin_user',
					'label'    => esc_html__( 'Linkedin Username( For Share )', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),

				array(
					'settings' => 'wp_instagram',
					'label'    => esc_html__( 'Add Instagram URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '#',
				),
				array(
					'settings' => 'wp_dribbble',
					'label'    => esc_html__( 'Add Dribbble URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
				array(
					'settings' => 'wp_behance',
					'label'    => esc_html__( 'Add Behance URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
				array(
					'settings' => 'wp_flickr',
					'label'    => esc_html__( 'Add Flickr URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
				array(
					'settings' => 'wp_vk',
					'label'    => esc_html__( 'Add Vk URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
				array(
					'settings' => 'wp_skype',
					'label'    => esc_html__( 'Add Skype URL', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				),
			)//fields
		),//social_media

		array(
			'id'              => 'blog_setting',
			'title'           => esc_html__( 'Blog Setting', 'gutenwp-core' ),
			'description'     => esc_html__( 'Blog Setting', 'gutenwp-core' ),
			'priority'        => 10,
			'fields'         => array(
				array(
					'settings' => 'sidebar_style',
					'label'    => esc_html__( 'Select Sidebar Style', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'right_sidebar',
					'choices'  => array(
						'right_sidebar'  => esc_html( 'Right Sidebar', 'gutenwp-core' ),
						'left_sidebar' 	 => esc_html( 'Left Sidebar', 'gutenwp-core' ),
						'full_width' 	 => esc_html( 'Full Width', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'blog_date',
					'label'    => esc_html__( 'Enable Blog Date', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'blog_author',
					'label'    => esc_html__( 'Enable Blog author', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'blog_comments',
					'label'    => esc_html__( 'Enable Blog Comments', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				
				array(
					'settings' => 'blog_category',
					'label'    => esc_html__( 'Enable Blog Category', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),
				array(
					'settings' => 'blog_tag',
					'label'    => esc_html__( 'Enable Blog Tag', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),
				array(
					'settings' => 'blog_intro_en',
					'label'    => esc_html__( 'Enable post content', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'blog_post_text_limit',
					'label'    => esc_html__( 'Post character Limit', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '220',
				),

				array(
					'settings' => 'blog_grid_column',
					'label'    => esc_html__( 'Select Blog Column', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => '4',
					'choices'  => array(
						'12' 	=> esc_html( 'Column 1', 'gutenwp-core' ),
						'6' 	=> esc_html( 'Column 2', 'gutenwp-core' ),
						'4' 	=> esc_html( 'Column 3', 'gutenwp-core' ),
						'3' 	=> esc_html( 'Column 4', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'blog_continue_en',
					'label'    => esc_html__( 'Enable Blog Readmore', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),
				array(
					'settings' => 'blog_continue',
					'label'    => esc_html__( 'Continue Reading', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => 'Read More',
				),

				# Blog Single Page.
				array(
					'settings' => 'sub_header_height',
					'label'    => esc_html__( 'Sub-Header Height', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 635,
				),
			)//fields
		),//blog_setting


		array(
			'id'              => 'single_blog_setting',
			'title'           => esc_html__( 'Single Blog Setting', 'gutenwp-core' ),
			'description'     => esc_html__( 'Single Blog Setting', 'gutenwp-core' ),
			'priority'        => 10,
			'fields'         => array(

				array(
					'settings' => 'blog_single_style',
					'label'    => esc_html__( 'Select Blog Style', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'blogstyle1',
					'choices'  => array(
						'blogstyle1' 	=> esc_html( 'Blog Style1', 'gutenwp-core' ),
						'blogstyle2' 	=> esc_html( 'Blog Style2', 'gutenwp-core' ),
					)
				),

				array(
					'settings' => 'blog_single_author',
					'label'    => esc_html__( 'Single Blog Author Box', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true
				),
				array(
					'settings' => 'blog_single_comment',
					'label'    => esc_html__( 'Enable Single Blog Comment', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),
				array(
					'settings' => 'blog_single_date',
					'label'    => esc_html__( 'Enable Single Blog Date', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'blog_single_category',
					'label'    => esc_html__( 'Enable Single Blog Category', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),
				array(
					'settings' => 'blog_single_tag',
					'label'    => esc_html__( 'Enable Single Blog Tags', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => false,
				),

				# Related Post
				array(
					'settings' => 'related_post_style',
					'label'    => esc_html__( 'Select Related Post Style', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'style1',
					'choices'  => array(
						'style1' 	=> esc_html( 'Related Post Style1', 'gutenwp-core' ),
						'style2' 	=> esc_html( 'Related Post Style2', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'related_post',
					'label'    => esc_html__( 'Select Screen', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'style1',
					'choices'  => array(
						'style1' 	=> esc_html( 'Full Width', 'gutenwp-core' ),
						'style2' 	=> esc_html( 'Default', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'related_post_cat_limit',
					'label'    => esc_html__( 'Related Post Text Limit', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
					'default'  => '45',
				),

				# Instragram
				array(
					'settings' => 'shortcode_style',
					'label'    => esc_html__( 'Select Shortcode', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'style1',
					'choices'  => array(
						'style1' 	=> esc_html( 'Default', 'gutenwp-core' ),
						'style2' 	=> esc_html( 'MailChimp', 'gutenwp-core' ),
						'style3' 	=> esc_html( 'Instagram Full', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'instragram_title',
					'label'    => esc_html__( 'Shortcode Title', 'gutenwp-core' ),
					'type'     => 'text',
					'priority' => 10,
				),
				array(
					'settings' => 'instragram_post',
					'label'    => esc_html__( 'Add Shortcode', 'gutenwp-core' ),
					'type'     => 'textarea',
					'priority' => 10,
				),




			)//fields
		),//single_blog_setting

		# Footer Widgets
		array(
			'id'              => 'bottom_setting',
			'title'           => esc_html__( 'Footer Widgets Setting', 'gutenwp-core' ),
			'description'     => esc_html__( '', 'gutenwp-core' ),
			'priority'        => 10,
			'fields'         => array(
				array(
					'settings' => 'enable_bottom_section',
					'label'    => esc_html__( 'Enable Bottom Section', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'footer_style',
					'label'    => esc_html__( 'Select Footer Style', 'gutenwp-core' ),
					'type'     => 'select',
					'priority' => 10,
					'default'  => 'style1',
					'choices'  => array(
						'style1' 	=> esc_html( 'Footer Style One', 'gutenwp-core' ),
						'style2' 	=> esc_html( 'Footer Style two', 'gutenwp-core' ),
						'style3' 	=> esc_html( 'Footer Style three', 'gutenwp-core' ),
						'style4' 	=> esc_html( 'Footer Style Four', 'gutenwp-core' ),
					)
				),
				array(
					'settings' => 'enable_mailchimp',
					'label'    => esc_html__( 'Disable MailChimp', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'bottom_color',
					'label'    => esc_html__( 'Bottom background Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#f7f8fa',
				),
				array(
					'settings' => 'bottom_text_color',
					'label'    => esc_html__( 'Bottom Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#6E6E6E',
				),
				array(
					'settings' => 'bottom_padding_top',
					'label'    => esc_html__( 'Bottom Top Padding', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 100,
				),
				array(
					'settings' => 'bottom_padding_bottom',
					'label'    => esc_html__( 'Bottom Bottom Padding', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 124,
				),
			)//fields
		),//footer_setting

		array(
			'id'              => 'footer_setting',
			'title'           => esc_html__( 'Footer Setting', 'gutenwp-core' ),
			'description'     => esc_html__( 'Footer Setting', 'gutenwp-core' ),
			'priority'        => 10,
			'fields'         => array(
				array(
					'settings' => 'enable_footer_en',
					'label'    => esc_html__( 'Enable Footer', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'copyright_en',
					'label'    => esc_html__( 'Enable Copyright Text', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'socialshare_en',
					'label'    => esc_html__( 'Enable Social Share', 'gutenwp-core' ),
					'type'     => 'switch',
					'priority' => 10,
					'default'  => true,
				),
				array(
					'settings' => 'copyright_text_color',
					'label'    => esc_html__( 'Copyright Text Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#6E6E6E',
				),
				array(
					'settings' => 'copyright_bg_color',
					'label'    => esc_html__( 'Copyright Background Color', 'gutenwp-core' ),
					'type'     => 'color',
					'priority' => 10,
					'default'  => '#1c1c1c',
				),
				array(
					'settings' => 'copyright_padding_top',
					'label'    => esc_html__( 'Copyright Top Padding', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 25,
				),
				array(
					'settings' => 'copyright_padding_bottom',
					'label'    => esc_html__( 'Copyright Bottom Padding', 'gutenwp-core' ),
					'type'     => 'number',
					'priority' => 10,
					'default'  => 25,
				),
				array(
					'settings' => 'copyright_text',
					'label'    => esc_html__( 'Copyright Text', 'gutenwp-core' ),
					'type'     => 'textarea',
					'priority' => 10,
					'default'  => esc_html__( '© 2018 gutenwp. All Rights Reserved.', 'gutenwp-core' ),
				),
			)//fields
		),//footer_setting

	),
);//gutenwp_panel_options


$framework = new THM_Customize( $panel_to_section );
