<?php

class WP_SmartCatalog_Helper_Data extends Mage_Core_Helper_Abstract
{
    private $_productSuffix = null;

    private static $_regexMatchCache        = array();
    private static $_disabledByRegexpCache  = array();
	public $_store = null;
    
    public function isDisabled()
    {
        if (!Mage::getStoreConfig('smart_catalog/general/enabled')) return true;
        if ($this->isDisabledByUserAgentAgainstRegexps()) return true;
        return false;
    }

    public function getTemplateData(&$blockProductList)
    {
        // --- get Column Width ---
        $_columnWidth = $blockProductList->getColumnWidth() + 0;
        if (!$_columnWidth) $_columnWidth = Mage::getStoreConfig('smart_catalog/general/column_width') + 0;
        if (!$_columnWidth) $_columnWidth = 150;
        // --- get Image Width ---
        $_imgWidth = $blockProductList->getImageWidth();
        if (!$_imgWidth) $_imgWidth = Mage::getStoreConfig('smart_catalog/general/image_width');
        if ($_imgWidth == '-') {
            $_imgWidth = $_imgHeight = 0;
        } else {
            $_imgWidth += 0;
            // --- get Image Height ---
            $_imgHeight = $blockProductList->getImageHeight() + 0;
            if (!$_imgHeight) $_imgHeight = Mage::getStoreConfig('smart_catalog/general/image_height');
            if (!$_imgHeight) $_imgHeight = $_imgWidth;
        }

        $_productCollection = $blockProductList->getLoadedProductCollection();
        if (is_null($_productCollection)) $_productCollection = $blockProductList->getProductCollection();

        if (!is_null($_productCollection) && ($_productsCount = $blockProductList->getProductsCount())) {
            $_productCollection = $_productCollection->clear()
                ->setPageSize($_productsCount)
                ->load()
            ;
            Mage::getModel('review/review')->appendSummary($_productCollection);
        }

        return array($_imgWidth, $_imgHeight, $_columnWidth, $_productCollection);
    }

    public function getProductUrlWithValidation(&$_product)
    {
        $url = $_product->getProductUrl();
        if (strpos($url, '/s/') !== false) {
            if (is_null($this->_productSuffix)) {
                $productSuffix = Mage::helper('catalog/product')->getProductUrlSuffix();
                $productSuffix = $productSuffix ? $productSuffix : '/';
                $this->_productSuffix = $productSuffix;
            }
            return rtrim(Mage::getUrl($_product->getUrlKey()), '/') . $this->_productSuffix;
        }
        return $url;
    }

    public function isEnabledMoreProducts()
    {
        return Mage::getStoreConfig('smart_catalog/ajax_settings/loading_more_products') != WP_SmartCatalog_Model_System_Config_Source_Loadingmoreproducts::MORE_PRODUCTS_DISABLE;
    }

    public function displayShortDescription()
    {
        return Mage::getStoreConfig('smart_catalog/general/display_short_desc');
    }

    public function getStore()
    {
        if ($this->_store === null) {
            return Mage::app()->getStore();
        }
        return $this->_store;
    }

    public function isDisabledByUserAgentAgainstRegexps()
    {
        $regexpsConfigPath = 'smart_catalog/general/disabled_by_regexp';
        if (empty($_SERVER['HTTP_USER_AGENT'])) {
            return false;
        }
        if (!empty(self::$_disabledByRegexpCache[$regexpsConfigPath])) {
            return self::$_disabledByRegexpCache[$regexpsConfigPath];
        }
        $configValueSerialized = Mage::getStoreConfig($regexpsConfigPath, $this->getStore());
        if (!$configValueSerialized) {
            return false;
        }
        $regexps = @unserialize($configValueSerialized);
        if (empty($regexps)) {
            return false;
        }
        foreach ($regexps as $rule) {
            if (!empty(self::$_regexMatchCache[$rule['regexp']][$_SERVER['HTTP_USER_AGENT']])) {
                self::$_disabledByRegexpCache[$regexpsConfigPath] = true;
                return true;
            }
            $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);
            $regexp = '/(' . trim($rule['regexp'], '/') . ')/i';
            if (@preg_match($regexp, $_SERVER['HTTP_USER_AGENT'], $str)) {
                self::$_regexMatchCache[$rule['regexp']][$_SERVER['HTTP_USER_AGENT']] = true;
                self::$_disabledByRegexpCache[$regexpsConfigPath] = true;
                return true;
            }
        }
        return false;
    }

}

