-- MySQL dump 10.13  Distrib 5.6.35, for Linux (x86_64)
--
-- Host: localhost    Database: magento_929_grayscale
-- ------------------------------------------------------
-- Server version	5.6.35

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_assert`
--

DROP TABLE IF EXISTS `admin_assert`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_assert` (
  `assert_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Assert ID',
  `assert_type` varchar(20) NOT NULL DEFAULT '' COMMENT 'Assert Type',
  `assert_data` text COMMENT 'Assert Data',
  PRIMARY KEY (`assert_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin Assert Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_assert`
--

LOCK TABLES `admin_assert` WRITE;
/*!40000 ALTER TABLE `admin_assert` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_assert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_role`
--

DROP TABLE IF EXISTS `admin_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `role_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `IDX_ADMIN_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `IDX_ADMIN_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_role`
--

LOCK TABLES `admin_role` WRITE;
/*!40000 ALTER TABLE `admin_role` DISABLE KEYS */;
INSERT INTO `admin_role` VALUES (1,0,1,1,'G',0,'Administrators'),(7,1,2,0,'U',2,'Store'),(13,1,2,0,'U',1,'admin');
/*!40000 ALTER TABLE `admin_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_rule`
--

DROP TABLE IF EXISTS `admin_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `assert_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Assert ID',
  `role_type` varchar(1) DEFAULT NULL COMMENT 'Role Type',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `IDX_ADMIN_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `IDX_ADMIN_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `FK_ADMIN_RULE_ROLE_ID_ADMIN_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `admin_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_rule`
--

LOCK TABLES `admin_rule` WRITE;
/*!40000 ALTER TABLE `admin_rule` DISABLE KEYS */;
INSERT INTO `admin_rule` VALUES (1,1,'all',NULL,0,'G','allow');
/*!40000 ALTER TABLE `admin_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(100) DEFAULT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NULL DEFAULT NULL COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `UNQ_ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification id',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `IDX_ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `IDX_ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `IDX_ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2011-11-06 06:37:08','Enhanced Grid 1.3.2.1 was successfully installed! Remember to flush all cache, recompile and log-out and log back in.','Enhanced Grid 1.3.2.1 was successfully installed on your store. Remember to flush all cache, recompile and log-out and log back in. The new Enhanced Products Grid replaces the default Magento product management grid.You can configure Enhanced Grid in the Configuration section.','#',0,1),(2,3,'2011-10-28 15:45:11','Magento 1.6.x extensions updates','Here are more extensions updates compatible with Magento 1.6.x:\n Refer a Friend v.1.4.2 \n Customer Purchases v.1.2.3 \n Product Preview Pro v.1.0.1\n Delivery Date and Notice v.1.2','http://blog.aheadworks.com/2011/10/magento-1-6-x-extensions-updates/?utm_source=feed&utm_medium=zefeed&utm_campaign=mass_update_3',0,1),(3,3,'2011-10-27 14:59:48','Magento CE 1.6 extensions updates','Today we release a bulk of extensions updates compatible with Magento CE 1.6.\n \n Advanced Newsletter v.2.0.4\n Featured Products 3 v.3.2.1\n RMA v.1.1.2 \n Catalog Permissions v.1.1.1\n Subscriptions and Recurring Payments v.1.5.1 ','http://blog.aheadworks.com/2011/10/extensions-updates-compatibility-with-magento-ce-1-6/?utm_source=feed&utm_medium=zefeed&utm_campaign=mass_update_2',0,1),(4,3,'2011-10-18 15:34:09','Facebook Link v.2.0.2 by aheadWorks has been released!','We introduce Facebook Link v.2.0.2 with the \'Send\' button integrated. It’s the easiest way to drive traffic by letting users broadcast the things they like to groups and people who would be really interested.','http://ecommerce.aheadworks.com/magento-extensions/social-networking-integration/facebook-link.html?utm_source=feed&utm_medium=zefeed&utm_campaign=FBLink_2_0_2',0,1),(5,3,'2011-10-13 16:50:00','Magento CE 1.6.0.0 Extensions updates','Today we are happy to release a bulk of extensions updates compatible with Magento CE 1.6.0.0 version:\n Who Bought This Also Bought v.1.2.1\n Image Slider v.1.2 \n Review Rotator v.1.3.1\n AJAX Catalog v.1.0.1\n Market Segmentation Suite v.1.1.7','http://blog.aheadworks.com/2011/10/magento-ce-1-6-0-0-extensions-updates/?utm_source=feed&utm_medium=zefeed&utm_campaign=mass_update_1',0,1),(6,3,'2011-10-11 18:20:40','Advanced Reports v.2.2 and additional Units by aheadWorks have been released!','In the Advanced Reports v.2.2 released today, a bulk of new features has been implemented. For example, now you can customize each report!','http://blog.aheadworks.com/2011/10/create-a-complete-picture-of-your-business-situation/?utm_source=feed&utm_medium=zefeed&utm_campaign=AR_2_2',0,1),(7,3,'2011-10-06 18:06:53','Blog v.1.0.23 by aheadWorks has been released!','This update for Blog v.1.0.23 includes the features requested by our Forum members. ','http://ecommerce.aheadworks.com/free-stuff/blog.html?utm_source=feed&utm_medium=zefeed&utm_campaign=Blog_1_0_23',0,1),(8,3,'2011-10-05 20:27:25','Group Deals v.1.0 by aheadWorks has been released','Now you can gain from the service of collective purchases in your Magento store with the Group Deals extension. ','http://ecommerce.aheadworks.com/magento-extensions/group-deals.html?utm_source=feed&utm_medium=zefeed&utm_campaign=Group_Deals_1_0',0,1),(9,3,'2011-09-29 15:19:09','Help Desk Ultimate v.2.8.1 by aheadWorks has been released!','Today we are pleased to announce the release of Help Desk Ultimate v. 2.8.1 compatible with the new Magento CE 1.6.','http://blog.aheadworks.com/2011/09/our-premium-extension-is-updated-to-be-compatible-with-magento-ce-1-6/?utm_source=feed&utm_medium=zefeed&utm_campaign=HDU_2_8_1',0,1),(10,3,'2011-09-27 15:23:41','Automatic Related Products 2 by aheadWorks has been released','New Release - Automatic Related Products 2! Choose any product attribute while defining the rules for products selection and let this software populate the block automatically.','http://ecommerce.aheadworks.com/magento-extensions/automatic-related-products-2.html?utm_source=feed&utm_medium=zefeed&utm_campaign=ARP_2_2_0',0,1),(11,3,'2011-09-23 18:02:40','Points & Rewards v.1.2.1 by aheadWorks has been released!','Today we are pleased to announce the release of Points & Rewards v.1.2.1.Though this is a minor update, we recommend you to upgrade your Points & Rewards to the new 1.2.1 version as it contains core improvements.','http://ecommerce.aheadworks.com/magento-extensions/points-and-rewards.html?utm_source=feed&utm_medium=zefeed&utm_campaign=Points_1_2_1',0,1),(12,4,'2008-07-25 08:24:40','Magento 1.1 Production Version Now Available','We are thrilled to announce the availability of the production release of Magento 1.1. Read more about the release in the Magento Blog.','http://www.magentocommerce.com/blog/comments/magento-11-is-here-1/',0,1),(13,4,'2008-08-02 08:30:16','Updated iPhone Theme is now available','Updated iPhone theme for Magento 1.1 is now available on Magento Connect and for upgrade through your Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/updated-iphone-theme-for-magento-11-is-now-available/',0,1),(14,3,'2008-08-02 08:40:27','Magento version 1.1.2 is now available','Magento version 1.1.2 is now available for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-version-112-is-now-available/',0,1),(15,3,'2008-08-14 00:51:46','Magento version 1.1.3 is now available','Magento version 1.1.3 is now available','http://www.magentocommerce.com/blog/comments/magento-version-113-is-now-available/',0,1),(16,1,'2008-09-03 04:10:31','Magento Version 1.1.4 Security Update Now Available','Magento 1.1.4 Security Update Now Available. If you are using Magento version 1.1.x, we highly recommend upgrading to this version as soon as possible.','http://www.magentocommerce.com/blog/comments/magento-version-114-security-update/',0,1),(17,3,'2008-09-16 05:09:54','Magento version 1.1.5 Now Available','Magento version 1.1.5 Now Available.\n\nThis release includes many bug fixes, a new category manager and a new skin for the default Magento theme.','http://www.magentocommerce.com/blog/comments/magento-version-115-now-available/',0,1),(18,3,'2008-09-18 03:18:35','Magento version 1.1.6 Now Available','Magento version 1.1.6 Now Available.\n\nThis version includes bug fixes for Magento 1.1.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-116-now-available/',0,1),(19,4,'2008-11-08 06:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,0,1),(20,3,'2008-11-20 08:31:12','Magento version 1.1.7 Now Available','Magento version 1.1.7 Now Available.\n\nThis version includes over 350 issue resolutions for Magento 1.1.x that are listed in the release notes section, and new functionality that includes:\n\n-Google Website Optimizer integration\n-Google Base integration\n-Scheduled DB logs cleaning option','http://www.magentocommerce.com/blog/comments/magento-version-117-now-available/',0,1),(21,3,'2008-11-27 04:24:50','Magento Version 1.1.8 Now Available','Magento version 1.1.8 now available.\n\nThis version includes some issue resolutions for Magento 1.1.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-118-now-available/',0,1),(22,3,'2008-12-30 14:45:59','Magento version 1.2.0 is now available for download and upgrade','We are extremely happy to announce the availability of Magento version 1.2.0 for download and upgrade.\n\nThis version includes numerous issue resolutions for Magento version 1.1.x and some highly requested new features such as:\n\n    * Support for Downloadable/Digital Products. \n    * Added Layered Navigation to site search result page.\n    * Improved site search to utilize MySQL fulltext search\n    * Added support for fixed-taxes on product level.\n    * Upgraded Zend Framework to the latest stable version 1.7.2','http://www.magentocommerce.com/blog/comments/magento-version-120-is-now-available/',0,1),(23,2,'2008-12-31 04:59:22','Magento version 1.2.0.1 now available','Magento version 1.2.0.1 now available.This version includes some issue resolutions for Magento 1.2.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-1201-available/',0,1),(24,2,'2009-01-13 03:41:49','Magento version 1.2.0.2 now available','Magento version 1.2.0.2 is now available for download and upgrade. This version includes an issue resolutions for Magento version 1.2.0.x as listed in the release notes.','http://www.magentocommerce.com/blog/comments/magento-version-1202-now-available/',0,1),(25,3,'2009-01-24 07:25:56','Magento version 1.2.0.3 now available','Magento version 1.2.0.3 is now available for download and upgrade. This version includes issue resolutions for Magento version 1.2.0.x as listed in the release notes.','http://www.magentocommerce.com/blog/comments/magento-version-1203-now-available/',0,1),(26,3,'2009-02-03 04:57:00','Magento version 1.2.1 is now available for download and upgrade','We are happy to announce the availability of Magento version 1.2.1 for download and upgrade.\n\nThis version includes some issue resolutions for Magento version 1.2.x. A full list of items included in this release can be found on the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-121-now-available/',0,1),(27,3,'2009-02-24 07:45:47','Magento version 1.2.1.1 now available','Magento version 1.2.1.1 now available.This version includes some issue resolutions for Magento 1.2.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-1211-now-available/',0,1),(28,3,'2009-02-27 08:39:24','CSRF Attack Prevention','We have just posted a blog entry about a hypothetical CSRF attack on a Magento admin panel. Please read the post to find out if your Magento installation is at risk at http://www.magentocommerce.com/blog/comments/csrf-vulnerabilities-in-web-application-and-how-to-avoid-them-in-magento/','http://www.magentocommerce.com/blog/comments/csrf-vulnerabilities-in-web-application-and-how-to-avoid-them-in-magento/',0,1),(29,2,'2009-03-04 06:03:58','Magento version 1.2.1.2 now available','Magento version 1.2.1.2 is now available for download and upgrade.\nThis version includes some updates to improve admin security as described in the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-1212-now-available/',0,1),(30,3,'2009-03-31 09:22:40','Magento version 1.3.0 now available','Magento version 1.3.0 is now available for download and upgrade. This version includes numerous issue resolutions for Magento version 1.2.x and new features as described on the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-130-is-now-available/',0,1),(31,3,'2009-04-18 11:06:02','Magento version 1.3.1 now available','Magento version 1.3.1 is now available for download and upgrade. This version includes some issue resolutions for Magento version 1.3.x and new features such as Checkout By Amazon and Amazon Flexible Payment. To see a full list of updates please check the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-131-now-available/',0,1),(32,3,'2009-05-20 05:31:21','Magento version 1.3.1.1 now available','Magento version 1.3.1.1 is now available for download and upgrade. This version includes some issue resolutions for Magento version 1.3.x and a security update for Magento installations that run on multiple domains or sub-domains. If you are running Magento with multiple domains or sub-domains we highly recommend upgrading to this version.','http://www.magentocommerce.com/blog/comments/magento-version-1311-now-available/',0,1),(33,3,'2009-05-30 05:54:06','Magento version 1.3.2 now available','This version includes some improvements and issue resolutions for version 1.3.x that are listed on the release notes page. also included is a Beta version of the Compile module.','http://www.magentocommerce.com/blog/comments/magento-version-132-now-available/',0,1),(34,3,'2009-06-02 02:32:52','Magento version 1.3.2.1 now available','Magento version 1.3.2.1 now available for download and upgrade.\n\nThis release solves an issue for users running Magento with PHP 5.2.0, and changes to index.php to support the new Compiler Module.','http://www.magentocommerce.com/blog/comments/magento-version-1321-now-available/',0,1),(35,3,'2009-07-02 08:21:44','Magento version 1.3.2.2 now available','Magento version 1.3.2.2 is now available for download and upgrade.\n\nThis release includes issue resolution for Magento version 1.3.x. To see a full list of changes please visit the release notes page http://www.magentocommerce.com/download/release_notes.','http://www.magentocommerce.com/blog/comments/magento-version-1322-now-available/',0,1),(36,3,'2009-07-23 13:48:54','Magento version 1.3.2.3 now available','Magento version 1.3.2.3 is now available for download and upgrade.\n\nThis release includes issue resolution for Magento version 1.3.x. We recommend to upgrade to this version if PayPal payment modules are in use. To see a full list of changes please visit the release notes page http://www.magentocommerce.com/download/release_notes.','http://www.magentocommerce.com/blog/comments/magento-version-1323-now-available/',0,1),(37,4,'2009-08-29 01:26:28','PayPal is updating Payflow Pro and Website Payments Pro (Payflow Edition) UK.','If you are using Payflow Pro and/or Website Payments Pro (Payflow Edition) UK.  payment methods, you will need to update the URL‘s in your Magento Administrator Panel in order to process transactions after September 1, 2009. Full details are available here: http://www.magentocommerce.com/wiki/paypal_payflow_changes','http://www.magentocommerce.com/wiki/paypal_payflow_changes',0,1),(38,2,'2009-09-24 03:16:49','Magento Version 1.3.2.4 Security Update','Magento Version 1.3.2.4 is now available. This version includes a security updates for Magento 1.3.x that solves possible XSS vulnerability issue on customer registration page and is available through SVN, Download Page and through the Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/magento-version-1324-security-update/',0,1),(39,4,'2009-09-25 21:57:54','Magento Preview Version 1.4.0.0-alpha2 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-alpha2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-alpha2-now-available/',0,1),(40,4,'2009-10-07 07:55:40','Magento Preview Version 1.4.0.0-alpha3 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-alpha3 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-alpha3-now-available/',0,1),(41,4,'2009-12-09 06:30:36','Magento Preview Version 1.4.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-beta1-now-available/',0,1),(42,4,'2009-12-31 16:22:12','Magento Preview Version 1.4.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-rc1-now-available/',0,1),(43,4,'2010-02-13 10:39:53','Magento CE Version 1.4.0.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.0.0 Stable for upgrade and download.','http://bit.ly/c53rpK',0,1),(44,3,'2010-02-20 09:39:36','Magento CE Version 1.4.0.1 Stable is now available','Magento CE 1.4.0.1 Stable is now available for upgrade and download.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1401-stable-now-available/',0,1),(45,4,'2010-04-24 03:09:03','Magento Version CE 1.3.3.0 Stable - Now Available With Support for 3-D Secure','Based on community requests, we are excited to announce the release of Magento CE 1.3.3.0-Stable with support for 3-D Secure. This release is intended for Magento merchants using version 1.3.x, who want to add support for 3-D Secure.','http://www.magentocommerce.com/blog/comments/magento-version-ce-1330-stable-now-available-with-support-for-3-d-secure/',0,1),(46,4,'2010-06-01 00:20:21','Announcing the Launch of Magento Mobile','The Magento team is pleased to announce the launch of Magento mobile, a new product that will allow Magento merchants to easily create branded, native mobile storefront applications that are deeply integrated with Magento’s market-leading eCommerce platform. The product includes a new administrative manager, a native iPhone app that is fully customizable, and a service where Magento manages the submission and maintenance process for the iTunes App Store.\n\nLearn more by visiting the Magento mobile product page and sign-up to be the first to launch a native mobile commerce app, fully integrated with Magento.','http://www.magentocommerce.com/product/mobile',0,1),(47,4,'2010-06-11 03:08:08','Magento CE Version 1.4.1.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.1.0 Stable for upgrade and download. Some of the highlights of this release include: Enhanced PayPal integration (more info to follow), Change of Database structure of the Sales module to no longer use EAV, and much more.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1410-stable-now-available/',0,1),(48,4,'2010-07-27 04:37:34','Magento CE Version 1.4.1.1 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.1.1 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-now-available/',0,1),(49,4,'2010-07-28 12:12:12','Magento CE Version 1.4.2.0-beta1 Preview Release Now Available','This release gives a preview of the new Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-beta1-now-available/',0,1),(50,4,'2010-07-29 03:15:01','Magento CE Version 1.4.1.1 Patch Available','As some users experienced issues with upgrading to CE 1.4.1.1 through PEAR channels we provided a patch for it that is available on our blog http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-patch/','http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-patch/',0,1),(51,4,'2010-10-12 07:13:25','Magento Mobile is now live!','Magento Mobile is now live! Signup today to have your own native iPhone mobile-shopping app in iTunes for the holiday season! Learn more at http://www.magentomobile.com/','http://www.magentomobile.com/',0,1),(52,4,'2010-11-09 04:52:06','Magento CE Version 1.4.2.0-RC1 Preview Release Now Available','We are happy to announce the availability of Magento Preview Version 1.4.2.0-RC1 for download.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-rc1-now-available/',0,1),(53,4,'2010-12-03 03:33:00','Magento CE Version 1.4.2.0-RC2 Preview Release Now Available','We are happy to announce the availability of Magento Preview Version 1.4.2.0-RC2 for download.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-rc2-now-available/',0,1),(54,4,'2010-12-09 05:29:55','Magento CE Version 1.4.2.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.2.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1420-stable-now-available/',0,1),(55,4,'2010-12-18 06:23:55','Magento Preview Version CE 1.5.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-alpha1-now-available/',0,1),(56,4,'2010-12-30 06:51:08','Magento Preview Version CE 1.5.0.0-alpha2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-alpha2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-alpha2-now-available/',0,1),(57,4,'2011-01-14 07:35:36','Magento Preview Version CE 1.5.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-beta1-now-available/',0,1),(58,4,'2011-01-22 04:19:09','Magento Preview Version CE 1.5.0.0-beta2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-beta2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-beta2-now-available/',0,1),(59,4,'2011-01-25 05:10:33','Join us for Magento\'s Imagine eCommerce Conference!','Magento\'s Imagine eCommerce Conference is a must-attend event for anyone who uses the Magento platform or is part of the Magento ecosystem. The conference will bring together over 500 retailers, merchants, developers, partners, eCommerce experts, technologists and marketing pros for a fun and intensive conversation about the future of eCommerce.\n\nThe conference is in Los Angeles and kicks off early Monday evening February 7th through Wednesday, February 9th, 2011.\n\nRegister at http://www.magento.com/imagine. First 20 registrants use discount code IMAGINE3X76 for $300 off. *This discount is sponsored by PayPal and is only valid for new registrations.\n\nHope to see you there!\n\nMagento Team','http://www.magento.com/imagine',0,1),(60,4,'2011-01-28 04:27:57','Magento Preview Version CE 1.5.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-rc1-now-available/',0,1),(61,4,'2011-02-04 04:56:33','Magento Preview Version CE 1.5.0.0-rc2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-rc2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-rc2-now-available/',0,1),(62,4,'2011-02-09 02:43:23','Magento CE Version 1.5.0.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.5.0.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-community-professional-and-enterprise-editions-releases-now-availab/',0,1),(63,4,'2011-02-10 06:42:57','Magento CE 1.5.0.1 stable Now Available','We are excited to announce the availability of Magento CE Version 1.5.0.1 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-1501-stable-now-available/',0,1),(64,4,'2011-03-19 02:15:45','Magento CE 1.5.1.0-beta1 Now Available','We are happy to announce the availability of Magento Preview Version CE 1.5.1.0-beta1 for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1510-beta1-now-available/',0,1),(65,4,'2011-04-01 01:43:02','Magento CE 1.5.1.0-rc1 Now Available','We are happy to announce the availability of Magento Preview Version CE 1.5.1.0-rc1 for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1510-rc1-now-available/',0,1),(66,4,'2011-04-27 02:21:07','Magento CE 1.5.1.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.5.1.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1510-stable-now-available/',0,1),(67,4,'2011-05-27 02:33:23','Magento Preview Version CE 1.6.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-alpha1-now-available/',0,1),(68,4,'2011-06-16 01:12:08','Magento Preview Version CE 1.6.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-beta1for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-beta1-now-available/',0,1),(69,4,'2011-07-01 02:03:58','Magento Preview Version CE 1.6.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-rc1-now-available/',0,1),(70,4,'2011-07-12 02:07:39','Magento Preview Version CE 1.6.0.0-rc2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-rc2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-rc2-now-available/',0,1),(71,4,'2011-08-20 00:58:31','Magento CE 1.6.0.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.0.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1600-stable-now-available/',0,1),(72,4,'2011-09-17 08:31:26','Magento Preview Version CE 1.6.1.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.1.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1610-beta1-now-available/',0,1),(73,4,'2011-09-29 22:44:10','Magento Preview Version CE 1.6.1.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.1.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1610-rc1-now-available/',0,1),(74,4,'2011-10-20 00:50:05','Magento CE 1.6.1.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.1.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1610-stable-now-available/',0,1),(75,4,'2008-11-08 06:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,0,1),(76,3,'2011-11-09 15:37:57','Order Tags v.1.1 and Follow Up Email v.3.3.2 by aheadWorks have been released!','Today we launch new versions of Order Tags (1.1) and Follow Up Email (3.3.2).','http://blog.aheadworks.com/2011/11/how-to-pursue-your-customer-until-his-order-is-flagged/?utm_source=feed&utm_medium=zefeed&utm_campaign=FUE_3_3_2_Order_Tags_1_1',0,1),(77,3,'2012-01-16 09:22:17','Advanced Search 1.1 and On Sale 2.3 by aheadWorks have been released!','Make your promotions eye-catching and store search fast with On Sale 2.3 and Advanced Search 1.1','http://blog.aheadworks.com/2012/01/make-your-promotions-eye-catching-and-store-search-extremely-fast/?utm_source=feed&utm_medium=zefeed&utm_campaign=Sale_2_3_AdvS_1_1',0,1),(78,3,'2012-01-11 09:53:52','Catalog Permissions 1.2 and Automatic Related Products 2 2.1 by aheadWorks have been released!','Today we are excited to release new versions of Catalog Permissions and Automatic Related Products 2.','http://blog.aheadworks.com/2012/01/now-you-decide-what-products-your-customers-see/?utm_source=email&utm_medium=MailChimp&utm_campaign=ARP_2_1_CatPerm_1_2',0,1),(79,3,'2012-01-09 07:40:09','One Click Checkout v.1.0 by aheadWorks has been released!','Take the advantage of one click ordering with One Click Checkout.','http://ecommerce.aheadworks.com/magento-extensions/one-click-checkout.html?utm_source=feed&utm_medium=zefeed&utm_campaign=One_Click_Checkout_1_0',0,1),(80,3,'2012-01-06 08:40:04','Ajax Catalog 1.0.2 and Subscriptions and Recurring Payments 1.6 by aheadWorks have been released!','Get the most out of your Magento store with AJAX Catalog & Subscriptions and Recurring Payments extensions updates. ','http://blog.aheadworks.com/2012/01/get-the-most-out-of-your-magento-store-with-these-extensions-updates/?utm_source=feed&utm_medium=zefeed&utm_campaign=AJCAT_1_0_2_SARP_1_6',0,1),(81,3,'2012-01-03 09:57:24','Limited-time offer: One Click Checkout Pre-Order','Get our brand-new One Click Checkout extension 50% off the price! ','http://ecommerce.aheadworks.com/magento-extensions/one-click-checkout.html?utm_source=feed&utm_medium=zefeed&utm_campaign=Preorder_OneClick',0,1),(82,3,'2011-12-30 06:20:05','RMA v.1.2, Who Bought This Also Bought v.1.3 and Featured Products 3 v.3.2.2 by aheadWorks has been released','Encourage your webstie visitors to spend more and provide the highest standards of customer service','http://blog.aheadworks.com/2011/12/encourage-your-visitors-to-spend-more-and-provide-the-highest-standards-of-customer-service/?utm_source=feed&utm_medium=zefeed&utm_campaign=RMA_WBT_FP3',0,1),(83,3,'2011-12-28 12:00:27','Custom Stock Display v.1.0 by aheadWorks has been released!','Replace the native Magento stock status with image, text, or both text & image and show customers the available number of items in an attractive and eye-catching way.','http://ecommerce.aheadworks.com/magento-extensions/custom-stock-display.html?utm_source=feed&utm_medium=zefeed&utm_campaign=Custom_Stock_Display',0,1),(84,3,'2011-12-27 08:00:07','Holidays discounts','Holidays discounts at aheadWorks store! Hurry up to save up to $150!','http://ecommerce.aheadworks.com/?utm_source=feed&utm_medium=zefeed&utm_campaign=Holidays_Discounts',0,1),(85,3,'2011-12-26 09:33:00',' Sociable 1.1.1, Market Segmentation Suite 1.2, Advanced Menu 2.2 and Points and Rewards 1.2.2 by aheadWorks have been released!','Today we are excited to release four new updates for Sociable 1.1.1, Market Segmentation Suite 1.2, Advanced Menu 2.2 and Points and Rewards 1.2.2. ','http://blog.aheadworks.com/2011/12/bulk-updates-of-magento-extensions/?utm_source=feed&utm_medium=zefeed&utm_campaign=S_MMS_AdM_PAR',0,1),(86,3,'2011-12-22 10:00:47','Product Images Slider v.1.0 from aheadWorks has been released!','Forget about this dull native More Views gallery! It is very time to make the displaying of your items images attractive and up-to-date. The Product Images Slider Magento extension from aheadWorks replaces standard media gallery with its cute slider.','http://ecommerce.aheadworks.com/product-images-slider.html?utm_source=feed&utm_medium=zefeed&utm_campaign=Product_Images_Slider_1_0',0,1),(87,4,'2011-12-30 17:39:35','Magento Preview Version CE 1.7.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.7.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-alpha1-now-available/',0,1),(88,4,'2012-01-11 17:24:20','Magento CE 1.6.2.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.2.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1620-stable-now-available/',0,1),(89,3,'2012-01-24 08:26:26','Follow Up Email 3.3.4 by aheadWorks has been released!','Track your Follow-Ups in Google Analytics with Follow Up Email 3.3.4.','http://www.ecommerce.aheadworks.com/magento-extensions/follow-up-email.html?utm_source=feed&utm_medium=zefeed&utm_campaign=FUE_3_3_4',0,1),(90,3,'2012-01-19 08:03:55','Search Autocomplete and Suggest v.3.2 by aheadWorks has been released!','Search Autocomplete and Suggest v.3.2 is out. Now it\'s compatible with Advanced Search aheadWorks extension.','http://ecommerce.aheadworks.com/magento-extensions/search-autocomplete-and-suggest.html?utm_source=feed&utm_medium=zefeed&utm_campaign=SAAS_3_2',0,1),(91,4,'2012-01-20 16:15:35','Magento\'s Imagine eCommerce Conference 2012 – Registration Now Open!','Registration for the 2012 Imagine eCommerce Conference is officially OPEN! With an expected attendance of over 1000 Magento enthusiasts, this year’s exclusive event is taking place in Las Vegas, April 23rd – 25th at the luxurious M Resort. Join us for an unforgettable experience!','http://www.magentocommerce.com/blog/comments/registration-for-imagine-ecommerce-2012-is-live/',0,1),(92,3,'2012-03-06 09:10:58','Advanced Reviews 2.2.1 and Product Questions 1.4.4 by aheadWorks have been released!','Listen to your customers and show interest in their opinion with powerful extensions from aheadWorks.','http://blog.aheadworks.com/2012/03/listen-to-your-customers-show-interest-in-their-opinion/?utm_source=feed&utm_medium=zefeed&utm_campaign=AR_2_2_1_PQ_1_4_4',0,1),(93,3,'2012-03-01 09:05:24','Product Preview Pro 1.1 and Home Tabs Pro 1.2.1 by aheadWorks have been released!','Broaden standard Magento possibilities and enlarge your store usability with Product Preview Pro 1.1 and Home Tabs Pro 1.2.1','http://blog.aheadworks.com/2012/03/welcome-the-latest-versions-of-home-tabs-pro-and-product-preview-pro/?utm_source=feed&utm_medium=zefeed&utm_campaign=PPP_1_1_HT_1_2_1',0,1),(94,3,'2012-02-28 09:42:15','Countdown v.1.0 by aheadWorks has been released!','The Countdown Magento extension counts backward to indicate the time remaining for/before promotions, sales, discounts, registrations, or whatever else.','http://blog.aheadworks.com/2012/02/three-two-one-countdown/?utm_source=feed&utm_medium=zefeed&utm_campaign=Countdown_1_0',0,1),(95,3,'2012-02-23 09:00:13','AJAX Cart Pro v.2.4 by aheadWorks has been released!','Minor bugs have been fixed in the new version of the AJAX Cart Pro extension.','http://blog.aheadworks.com/2012/02/make-buying-process-comfortable-with-new-ajax-cart-pro-version/?utm_source=feed&utm_medium=zefeed&utm_campaign=ACP_2_4',0,1),(96,3,'2012-02-21 07:09:57','Points & Rewards v.1.3 by aheadWorks has been released!','Today we are pleased to announce the release of Points & Rewards v.1.3!','http://ecommerce.aheadworks.com/magento-extensions/points-and-rewards.html?utm_source=feed&utm_medium=zefeed&utm_campaign=PAR_1_3',0,1),(97,3,'2012-02-16 08:53:10','Help Desk Ultimate 2.9 by aheadWorks has been released!','Today we are pleased to announce the release of Help Desk Ultimate v.2.9 with new features!','http://ecommerce.aheadworks.com/magento-extensions/help-desk-ultimate.html?utm_source=feed&utm_medium=zefeed&utm_campaign=HDU_2_9',0,1),(98,3,'2012-02-14 05:01:33','Advanced Newsletter 2.1 by aheadWorks has been released!','Today we are excited to release Advanced Newsletter v.2.1 packed with new features for getting the most out of your email marketing strategy.','http://ecommerce.aheadworks.com/magento-extensions/advanced-newsletter.html?utm_source=feed&utm_medium=zefeed&utm_campaign=AN_2_1',0,1),(99,3,'2012-02-10 09:00:35','One Click Checkout 1.1 and iPhone Theme 1.4 by aheadWorks have been released!','How to Skip Multiple Checkout Steps and Optimize your Store for Mobile Devices with the help of One Click Checkout v.1.1 and iPhone Theme v.1.4.','http://blog.aheadworks.com/2012/02/how-to-skip-6-step-checkout-process-and-optimize-eshop-for-mobile-devices/?utm_source=feed&utm_medium=zefeed&utm_campaign=OCC_1_1_iPho_1_4',0,1),(100,3,'2012-02-08 05:30:29','Mobile Order Tracking v.1.0 by aheadWorks has been released!','Let your customers track the shipment & payment statuses all the way through the delivery process with ease using mobile devices or desktop computers. ','http://ecommerce.aheadworks.com/magento-extensions/mobile-order-tracking.html?utm_source=feed&utm_medium=zefeed&utm_campaign=MOT_1_0',0,1),(101,4,'2012-03-02 19:54:12','Magento Preview Version CE 1.7.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.7.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-beta1-now-available/',0,1),(102,3,'2012-04-27 04:00:35','Subscriptions and Recurring Payments v.1.7, Automatic Product Callouts v.1.2, and Product Updates Notifications v.1.2 by aheadWorks have been released!','Get New Opportunities with Our Extensions Updates!','http://blog.aheadworks.com/2012/04/get-new-opportunities-with-our-extensions-updates/?utm_source=feed&utm_medium=zefeed&utm_campaign=SARP_1_7_APC_1_2_PUN_1_2',0,1),(103,3,'2012-04-18 04:27:43','Custom Stock Display v.1.1 by aheadWorks has been released!','We released a new version of Magento module that will help avoid constant questions on the stock status.','http://blog.aheadworks.com/2012/04/keep-your-customers-informed/?utm_source=feed&utm_medium=zefeed&utm_campaign=CSD_1_1',0,1),(104,3,'2012-04-06 04:01:52','Advanced Search v.1.2 and Knowledge Base v.1.2 by aheadWorks have been released!','We released new versions of Magento modules that will help show careful attitude to your clients.','http://blog.aheadworks.com/2012/04/caring-attitude-is-the-key-to-long-term-client-relationship/?utm_source=feed&utm_medium=zefeed&utm_campaign=AS_1_2_KB_1_2',0,1),(105,3,'2012-03-30 04:19:57','Easy Categories v.1.1 and Image Slider v.1.3 by aheadWorks have been released!','We released new versions of Magento modules that will be helpful in making your website appealing for your clients.','http://blog.aheadworks.com/2012/03/images-are-the-best-way-of-grabbing-attention/?utm_source=feed&utm_medium=zefeed&utm_campaign=EC_1_1_IS_1_3',0,1),(106,3,'2012-03-23 03:00:20','Advanced Reports v.2.3 and Additional Units by aheadWorks have been released!','The new version of Advanced Reports is compatible with Magento CE 1.6.2.0. Don\'t forget to update additional units as well.','http://blog.aheadworks.com/2012/03/get-detailed-and-accurate-sales-information-easily/?utm_source=feed&utm_medium=zefeed&utm_campaign=AR_2_3_Units',0,1),(107,3,'2012-03-20 08:25:50','iPhone Theme v.1.4.1 by aheadWorks has been released','The new version detects iPad automatically that means the desktop version of your online store will be displayed. ','http://blog.aheadworks.com/2012/03/be-mobile-and-get-more-potential-traffic/?utm_source=feed&utm_medium=zefeed&utm_campaign=iPhone_Theme_1_4_1',0,1),(108,3,'2012-03-14 06:55:57','Z-Blocks 2.2.6, Market Segmentation Suite 1.2.1, Follow Up Email 3.4, and Advanced Newsletter 2.2 by aheadWorks have been released!','Today we release the Magento extensions that were modified for you to get the best results in your target marketing. With their help, your promotions and sales become easier and more cost-effective.','http://blog.aheadworks.com/2012/03/divide-and-conquer-with-the-newest-versions-of-our-magento-extensions/?utm_source=feed&utm_medium=zefeed&utm_campaign=FUE_34_MSS_121_ZB_226_AN_22',0,1),(109,4,'2012-04-23 10:02:40','Magento Community Preview Version CE 1.7.0.0-RC1 has been released!','Learn more about the exciting new features and updates in this release and how you can take it for a test drive. As this is a preview version, we need to stress that it\'s likely unstable and that we DON\'T recommend that you use it in any production environment just yet.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-rc1-now-available/',0,1),(110,4,'2012-04-24 13:49:13','Magento Community 1.7 and Magento Enterprise 1.12 now available!','Learn more about the exciting new features and updates in these releases.','http://www.magentocommerce.com/blog/comments/magento-enterprise-112-and-community-17-now-available/',0,1),(111,3,'2012-05-03 03:32:32','Featured Products 3 v.3.3 by aheadWorks has been released!','Promote products effectively with the updated version of the Featured Products 3 Magento extension.','http://blog.aheadworks.com/2012/05/promote-products-effectively/?utm_source=feed&utm_medium=zefeed&utm_campaign=FP3_3_3',0,1),(112,3,'2012-06-02 03:03:49','AJAX Cart Pro v.2.5 by aheadWorks has been released!','Provide convenience for your clients with the updated version of the AJAX Cart Pro Magento extension.','http://blog.aheadworks.com/2012/06/provide-convenience-for-your-clients/?utm_source=feed&utm_medium=zefeed&utm_campaign=ACP_2_5',0,1),(113,3,'2012-08-20 08:00:06','Back to School Sale','Get our TOP Magento extensions with up to 15% discount. Don\'t miss a chance - these 4 extensions are on sale till August 21!','http://ecommerce.aheadworks.com/?utm_source=feed&utm_medium=zefeed&utm_campaign=back2school_1',0,1),(114,3,'2012-08-03 03:56:33','Featured Products 3 v.3.4 by aheadWorks has been released!','The updated version of the Featured Products 3 Magento extension makes it even easier to promote products at your Magento store.','http://blog.aheadworks.com/2012/08/highlight-products-in-a-showy-way/?utm_source=feef&utm_medium=zefeed&utm_campaign=FP3_3_4',0,1),(115,3,'2012-08-02 03:37:58','Random Price v.1.0 by aheadWorks has been released!','The Random Price extension lets draw your customers in an interesting game as well as bring excitement to your site.','http://blog.aheadworks.com/2012/08/start-out-a-streak-of-good-luck/?utm_source=feed&utm_medium=zefeed&utm_campaign=RP_1_0',0,1),(116,3,'2012-06-08 03:56:20','Subscriptions and Recurring Payments v.1.8 by aheadWorks has been released!','The new version of the Subscriptions and Recurring Payments extension with considerable improvements gives new opportunities.','http://blog.aheadworks.com/2012/06/new-payment-methods-support-in-subscriptions-and-recurring-payments/?utm_source=feed&utm_medium=zefeed&utm_campaign=SARP_1_8',0,1),(117,4,'2012-06-20 14:54:07','Magento Community Edition 1.7.0.1 now available! ','We have just released an updated version of Magento Community Edition, version 1.7.0.1. This update delivers new, minor functionality and fixes for some potential security vulnerabilities.','http://www.magentocommerce.com/blog/comments/magento-community-edition-1701-released/',0,1),(118,4,'2012-07-05 15:21:43','Important Security Update - Zend Platform Vulnerability','We have recently learned of a serious vulnerability in the Zend platform on which Magento is built. Learn more and access a patch that addresses this issue. ','http://www.magentocommerce.com/blog/comments/important-security-update-zend-platform-vulnerability/',0,1),(119,4,'2012-08-24 18:37:47','Increase Your Sales With PayPal','Magento merchants using PayPal Express Checkout can help increase their sales on average 18%. It is one simple thing you can do right now to help boost your sales. Learn more.','http://www.magentocommerce.com/add-paypal?utm_source=CEModule&utm_medium=copy&utm_content=18&utm_campaign=choosepaypal',0,1),(120,3,'2012-12-12 01:00:00','Follow Up Email v.3.5 by aheadWorks has been released!','Follow Up Email 3.5 Knocks on Your Door! Support of Up-sells, Cross-sells and Related Products Is Provided','http://blog.aheadworks.com/2012/12/follow-up-email-3-5-knocks-on-your-door-support-of-up-sells-cross-sells-and-related-products-is-provided?utm_source=feed&utm_medium=zefeed&utm_campaign=FUE_3_5',0,1),(121,3,'2012-12-07 00:00:00','Advanced Newsletter v.2.3 by aheadWorks has been released!','Advanced Newsletter 2.3: Letting Customers Unsubscribe from the Unwanted Content and More','http://blog.aheadworks.com/2012/12/advanced-newsletter-2-3-letting-customers-unsubscribe-from-the-unwanted-content-and-more?utm_source=feed&utm_medium=zefeed&utm_campaign=AN_2_3',0,1),(122,3,'2012-11-28 00:00:00','RMA v.1.4 by aheadWorks has been released!','Control the Refund Process and Make It Less Painful with RMA 1.4 version','http://blog.aheadworks.com/2012/11/control-the-refund-process-and-make-it-less-painful-with-rma-1-4-version/?utm_source=feed&utm_medium=zefeed&utm_campaign=RMA_1_4',0,1),(123,3,'2012-11-15 03:09:00','Product Updates Notifications v.2.0 by aheadWorks has been released!','Now every store visitor can subscribe to your stock changes from category or product page and this Magento extension will send all the notifications automatically.','http://blog.aheadworks.com/2012/11/make-product-updates-notifications-sent-automatically/?utm_source=feed&utm_medium=zefeed&utm_campaign=PUN_2_0',0,1),(124,3,'2012-11-07 06:06:27','AJAX Cart Pro v.3.0 by aheadWorks has been released!','The completely refactored AJAX Cart Pro 3.0 has been released as promised. This bestseller and must-have extension has 7 new features implemented!','http://blog.aheadworks.com/2012/11/welcome-ajax-cart-pro-v-3-0-with-7-new-features/?utm_source=feed&utm_medium=zefeed&utm_campaign=ACP_3_0',0,1),(125,3,'2012-10-30 00:00:00','Advanced Search v.1.3 has been released!','Improve Your Store Search with Our Updated Magento Extension!','http://blog.aheadworks.com/2012/10/improve-your-store-search-with-our-updated-magento-extension/#more-18496?utm_source=feed&utm_medium=zefeed&utm_campaign=AS_1_3',0,1),(126,3,'2012-10-23 01:00:00','Facebook Link v.2.1.4 has been released!','\"Like\" a Product and Get a Reward with the Updated Facebook Link Extension!','http://blog.aheadworks.com/2012/10/reward-your-visitors-for-like-in-facebook/?utm_source=feed&utm_medium=zefeed&utm_campaign=FB_2_1_4',0,1),(127,3,'2012-10-09 02:00:00','Automatic Related Products 2 v.2.3 has been released!','Cross-selling gains renewed momentum with the updated Automatic Related Products 2 extension!','http://ecommerce.aheadworks.com/magento-extensions/automatic-related-products-2.html?___SID=U&utm_source=feed&utm_medium=zefeed&utm_campaign=ARP2_2_3',0,1),(128,3,'2012-09-27 02:00:00','Video Testimonials v.1.4 has been released!','The new version of the Video Testimonials extension allows you to add video on any CMS page!','http://ecommerce.aheadworks.com/magento-extensions/video-testimonials.html?utm_source=feed&utm_medium=zefeed&utm_campaign=VT_1_4',0,1),(129,3,'2012-09-21 04:30:42','Free “Magento Performance Optimization” User Guide','Learn how to optimize Magento performance without code modifications in our free PDF guide.','http://blog.aheadworks.com/2012/09/free-magento-performance-optimization-user-guide/?utm_source=feed&utm_medium=zefeed&utm_campaign=OMP_PDF_Guide',0,1),(130,4,'2012-11-19 14:27:42','Wrap up more holiday sales with financing','Give your customers up to 6 months financing. You get paid right away with Bill Me Later, a PayPal service. It’s a great way to extend financing in time for the holidays. Learn More.','http://www.magentocommerce.com/paypal/billmelater?utm_source=CEMessaging&utm_medium=copy&utm_content=sixmonths&utm_campaign=BML',0,1),(131,4,'2013-01-15 16:02:07','Imagine 2013 Registration is Now Open!','Join 1500 merchants, partners, developers and enthusiasts from 35+ countries around the world for Magento’s premier global conference! Collaborate, learn, network and get inspired by the future of eCommerce. Tickets will sell out fast! April 8th – 10th in Las Vegas.','https://registration.imagineecommerce.com/',0,1),(132,4,'2013-02-12 11:53:42','Get More eCommerce Power with Magento Enterprise','Limited time offer: Get a free, customized evaluation of your Community Edition site from a Magento Solution Partner. This evaluation gives you a clear look at the numerous benefits you can achieve by upgrading to Enterprise Edition. ','http://www.magentocommerce.com/community-to-enterprise?utm_source=CEMM&utm_medium=copy&utm_campaign=CE2EE',0,1),(133,3,'2013-02-22 09:15:07','Free Mobile administration extension for Magento has just been released by aheadWorks','OnPulse.info provides you with an access to sales statistics, the latest orders, and the clients list through any iOS or Android powered device.','http://onpulse.info/?utm_source=feed&utm_medium=zefeed&utm_campaign=onpulse',0,1),(134,3,'2013-02-26 06:48:23','Custom Stock Display from aheadWorks with 30% discount','Save up to $40 when you buy the Custom Stock Display extension from aheadWorks. 10 new features for flexible display of product quantity!','http://ecommerce.aheadworks.com/custom-stock-display.html/?utm_source=feed&utm_medium=zefeed#reviews-list',0,1),(135,3,'2013-03-16 02:59:59','St. Patrick\'s Weekend Sale from aheadWorks!','Save 15% on any Magento extension from aheadWorks. Use coupon: GOLUCKY thru March 16th -17th\n ','http://ecommerce.aheadworks.com?utm_source=feed&utm_medium=zefeed&utm_campaign=StPatricks2013',0,1),(136,3,'2013-03-21 13:00:00','Limited-time offer: Shop By Brand Pre-Order','Get our new Shop By Brand Magento extension 25% off the price! ','http://ecommerce.aheadworks.com/shop-by-brand.html?utm_source=feed&utm_medium=zefeed&utm_campaign=sbb_preorder',0,1),(137,3,'2013-03-29 11:00:00','Refer a Friend v.2.0 by aheadWorks has been released!','Increase Your Customers Base with Refer a Friend v. 2.0','http://blog.aheadworks.com/2013/03/increase-your-customers-base-with-refer-a-friend-v-2-0?utm_source=feed&utm_medium=zefeed&utm_campaign=easter_sbb_raf',0,1),(138,3,'2013-03-28 11:00:00','Welcome Shop By Brand 1.0 by aheadWorks!','Use the Shop By Brand Magento extension by aheadWorks to create brands and connect with items seamlessly. ','http://ecommerce.aheadworks.com/shop-by-brand.html?utm_source=feed&utm_medium=zefeed&utm_campaign=sbb_release',0,1),(139,3,'2013-04-11 11:00:00','Limited-time offer: Store Locator Pre-Order','Pre-order the Store Locator Extension 25% off and Help Customers Find Your Shops on the Map','http://blog.aheadworks.com/2013/04/pre-order-the-store-locator-and-help-customers-find-your-shops-on-the-map?utm_source=feed&utm_medium=zefeed&utm_campaign=sl',0,1),(140,3,'2013-04-10 00:00:00','Ajax Cart Pro v.3.1 by aheadWorks has been released!','Ajax Cart Pro Magento extension has been upgraded to v.3.1','http://blog.aheadworks.com/2013/04/ajax-cart-pro-v-3-1-is-out?utm_source=feed&utm_medium=zefeed&utm_campaign=acp_3_1',0,1),(141,3,'2013-04-05 13:00:00','Limited-time offer: Customer Attributes Pre-Order','Get our new Customer Attributes Magento extension 25% off the price! ','http://ecommerce.aheadworks.com/customer-attributes.html?utm_source=feed&utm_medium=zefeed&utm_campaign=catt_aM',0,1),(142,3,'2013-04-22 11:00:00','Limited-time offer: Activity Stream Pre-Order','Working on call-to-purchase message? Pre-order the Activity Stream Extension and Your Customers Will Do the Job','http://blog.aheadworks.com/2013/04/working-on-call-to-purchase-message-pre-order-the-activity-stream-extension-and-your-customers-will-do-the-job?utm_source=feed&utm_medium=zefeed&utm_campaign=activity',0,1),(143,3,'2013-04-17 11:00:00','Welcome Store Locator 1.0 by aheadWorks!','To the Rescue of Your Physical Offline Stores: Use Store Locator to Highlight Them','http://blog.aheadworks.com/2013/04/to-the-rescue-of-your-physical-offline-shops-use-store-locator-to-highlight-them?utm_source=feed&utm_medium=zefeed&utm_campaign=sl_sp10',0,1),(144,3,'2013-04-16 11:00:00','Welcome Shipping Price1.0 by aheadWorks!','Free Shipping Price Extension for Convenience of Your Customers','http://blog.aheadworks.com/2013/04/free-shipping-price-extension-for-convenience-of-your-customers?utm_source=feed&utm_medium=zefeed&utm_campaign=shipprice',0,1),(145,3,'2013-04-12 11:00:00','Welcome Customer Attributes 1.0 by aheadWorks!','Collect information, segment customers, and market smarter with the Customer Attributes extension.','http://ecommerce.aheadworks.com/customer-attributes.html?utm_source=feed&utm_medium=zefeed&utm_campaign=catt10',0,1),(146,3,'2013-06-11 11:00:00','Welcome eCommerce Gamification Suite 1.0 by aheadWorks!','eCommerce Gamification Suite Involves Your Customers into Exciting Game','http://blog.aheadworks.com/2013/06/magento-ecommerce-gamification-suite-involves-your-customers-into-exciting-game?utm_source=feed&utm_medium=zefeed&utm_campaign=gamification10',0,1),(147,3,'2013-06-05 12:00:00','Catalog Permissions v.1.3 by aheadWorks has been released!','Get More Control Over the Catalog Permissions Magento Extension','http://blog.aheadworks.com/2013/06/ get-more-control-over-the-catalog-permissions-magento-extension?utm_source=feed&utm_medium=zefeed&utm_campaign=catper13',0,1),(148,3,'2013-06-04 12:00:00','Limited-time offer: eCommerce Gamification Suite Pre-Order','Turn Shopping into Game in Your Store! The eCommerce Gamification Suite Extension Is Available for Pre-order','http://blog.aheadworks.com/2013/01/turn-shopping-into-game-in-your-store-the-ecommerce-gamification-suite-extension-is-available-for-pre-order?utm_source=feed&utm_medium=zefeed&utm_campaign=gamification',0,1),(149,3,'2013-05-30 11:00:00','Welcome Better Thank You Page 1.0 by aheadWorks!','New Better Thank You Page module: empower the order success page to boost sales','http://ecommerce.aheadworks.com/better-thank-you-page.html?utm_source=feed&utm_medium=zefeed&utm_campaign=betterthankyou',0,1),(150,3,'2013-05-28 11:00:00','Limited-time offer: Better Thank You Page Pre-Order','Pre-order the Better Thank You Page Magento Extension and Increase Customer Conversion Rate','http://blog.aheadworks.com/2013/05/pre-order-the-better-thank-you-page-magento-extension-and-increase-customer-conversion-rate?utm_source=feed&utm_medium=zefeed&utm_campaign=thankyou',0,1),(151,3,'2013-05-27 11:00:00','Welcome Auction Pro 1.0 by aheadWorks!','Organize auction at your website with the help of the Auction Pro extension for Magento','http://ecommerce.aheadworks.com/auction-pro.html?utm_source=feed&utm_medium=zefeed&utm_campaign=auction',0,1),(152,3,'2013-05-26 01:00:00','Last Weekend of Spring Sale from aheadWorks!','Take 15% off everything this weekend at our Spring Sale!','http://ecommerce.aheadworks.com/?utm_source=feed&utm_medium=zefeed&utm_campaign=springsale',0,1),(153,3,'2013-05-23 11:00:00','Limited-time offer: Auction Pro Pre-Order','Put the ‘Spotlight’ on your Products – Pre-order the Auction Pro Magento Extension!','http://blog.aheadworks.com/2013/05/put-the-spotlight-on-your-products-pre-order-the-auction-pro-magento-extension?utm_source=feed&utm_medium=zefeed&utm_campaign=auction',0,1),(154,3,'2013-05-22 11:00:00','Welcome One Step Checkout 1.0 by aheadWorks!','Increase Your Sales Conversions with the One Step Checkout Magento Extension','http://ecommerce.aheadworks.com/one-step-checkout.html?utm_source=feed&utm_medium=zefeed&utm_campaign=osc1_0',0,1),(155,3,'2013-05-10 06:00:00','Mother\'s Day Sale - all Magento extensions 15% off','Happy Mother\'s Day! Get 15% off on any Magento extensions and themes in honour of the holiday.','http://ecommerce.aheadworks.com/?utm_source=feed&utm_medium=zefeed&utm_campaign=Mother_Sale',0,1),(156,3,'2013-07-19 11:00:00','Welcome Order Attributes Pro1.0 by aheadWorks!','Add custom order attributes on any checkout step and collect required information from your clients for quick order processing','http://ecommerce.aheadworks.com/order-attributes.html?utm_source=feed&utm_medium=zefeed&utm_campaign=oatt10',0,1),(157,3,'2013-07-19 00:56:56','New extension - Extra Downloads','Add attachments to product pages in your store and let visitors download all additional information about your products.','http://ecommerce.aheadworks.com/magento-extensions/extra-downloads.html',0,1),(158,3,'2013-07-10 11:00:00','Limited-time offer: Order Attributes Pre-Order','Get Order Attributes 30% off to fasten order processing','http://ecommerce.aheadworks.com/order-attributes.html?utm_source=feed&utm_medium=zefeed&utm_campaign=oatpre',0,1),(159,3,'2013-07-04 12:00:00','Welcome Add Free Product to Cart 1.0 by aheadWorks!','The Add Free Product to Cart Magento extension caters customers with pleasant gifts\n ','http://blog.aheadworks.com/2013/07/the-add-free-product-to-cart-magento-extension-caters-customers-with-pleasant-gifts/?utm_source=feed&utm_medium=zefeed&utm_campaign=addfree',0,1),(160,3,'2013-07-02 11:00:00','Welcome Call for Price 1.0 by aheadWorks!','Tell Customers the Product Price Personally with the Call for Price Magento Extension','http://blog.aheadworks.com/2013/07/tell-customers-the-product-price-personally-with-the-call-for-price-magento-extension/?utm_source=feed&utm_medium=zefeed&utm_campaign=call_for_price',0,1),(161,3,'2013-06-26 11:00:00','Limited-time offer: Add Free Product to Cart Pre-Order','50% discount on new Add Free Product to Cart module - populate customer\'s cart with a gift after rule conditions meet.','http://ecommerce.aheadworks.com/add-free-product-to-cart.html?utm_source=feed&utm_medium=zefeed&',0,1),(162,3,'2013-06-25 12:00:00','Limited-time offer: Call for Price Pre-Order','Get 50% off – Pre-order the Call for Price Magento Extension','http://blog.aheadworks.com/2013/06/keep-in-touch-with-customers-pre-order-the-call-for-price-magento-extension?utm_source=feed&utm_medium=zefeed&utm_campaign=callforprice',0,1),(163,3,'2013-12-26 08:00:00','Subscription Module v.2.0. Free Upgrade!','SARP 1.X owners can upgrade the module to the newest 2.0 version absolutely for FREE! The offer is time-limited.','http://ecommerce.aheadworks.com/magento-extensions/subscriptions-and-recurring-payments.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=SARP2_free_upgrade',0,1),(164,3,'2013-12-23 02:00:00','24-Hour Pre-Christmas Sale! ','We’re cutting prices on all aheadWorks extensions and themes by 15% for 24-hour Pre-Christmas sale.','http://ecommerce.aheadworks.com?utm_source=awfeed&utm_medium=zefeed&utm_campaign=xmas_sale',0,1),(165,3,'2013-12-19 04:00:00','Subscriptions and Recurring Payments v.2.0 by aheadWorks has been released!','New generation of subscription extension. Uses PayPal and Authorize.Net logic with its trial periods and initial fees.','http://ecommerce.aheadworks.com/magento-extensions/subscriptions-and-recurring-payments.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=sarp_alp',0,1),(166,3,'2013-12-16 08:00:00','AJAX Login Pro v.1.1.1 by aheadWorks has been released!','Improve registration and login process with the updated AJAX Login Pro v.1.1.1. Now customers can log in via Twitter or Amazon, subscribe to any segment of your store during the registration.','http://ecommerce.aheadworks.com/magento-extensions/ajax-login-pro.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=ajaxlogin111',0,1),(167,3,'2013-12-11 02:00:00','Countdown from aheadWorks with a 25% discount','Indicate start/end time of Holiday Sales with the Countdown module 25% off!','http://ecommerce.aheadworks.com/magento-extensions/countdown.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=countdown25off',0,1),(168,3,'2013-12-05 11:00:00','Welcome Gift Card/Certificate 1.0 by aheadWorks!','Let customers get the best gift for any occasion. Start selling gift certificates with any values for your store!','http://ecommerce.aheadworks.com/magento-extensions/gift-card-certificate.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=gift_card',0,1),(169,3,'2013-12-04 11:00:00','Hot Offer: Market Segmentation Suite 30% OFF','Get 30% off Market Segmentation Suite when bought together with one of seven integrated modules.','http://ecommerce.aheadworks.com/magento-extensions/market-segmentation-suite.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=mss_30off',0,1),(170,3,'2013-11-28 06:00:00','Holidays Sale - all Magento extensions 15% off','Enjoy aheadWorks deals for Black Friday and Cyber Monday. Get any Magento extensions or themes with a 15% discount. The offer is valid throught December 2.','http://ecommerce.aheadworks.com?utm_source=awfeed&utm_medium=zefeed&utm_campaign=black_cyber',0,1),(171,3,'2013-11-20 11:00:00','Welcome Layered Navigation 1.0 by aheadWorks!','Optimizes the navigation and lets visitors find the desired product faster. ','http://ecommerce.aheadworks.com/magento-extensions/layered-navigation.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=layered_navigation',0,1),(172,3,'2013-11-14 11:00:00','Market Segmentation Suite v.2.0.1 by aheadWorks has been released!','Market Segmentation Suite has absolutely new logic of operation. Implemented results tracking and re-indexing make the module10x times faster!\n ','http://ecommerce.aheadworks.com/magento-extensions/market-segmentation-suite.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=mss2',0,1),(173,2,'2013-09-27 10:28:13','Magento Community Edition 1.8.0.0 - now available for download!','Get tax, security, performance, and many other improvements. \n\nLearn more at http://www.magentocommerce.com/blog/comments/magento-community-edition-one-eight-now-available/ ','http://www.magentocommerce.com/blog/comments/magento-community-edition-one-eight-now-available/',0,1),(174,4,'2013-12-11 09:35:06','Magento Community Edition 1.8.1.0 is here!','This new version offers significant tax calculation, product quality, and security enhancements. Be sure to carefully review the upgrade instructions before starting. More information is available at http://www.magentocommerce.com/blog/comments/magento-community-edition-1810-is-here/','http://www.magentocommerce.com/blog/comments/magento-community-edition-1810-is-here/',0,1),(175,4,'2013-12-12 17:24:39','Important Magento Community Edition Patch','A security patch is available for Magento Community Edition 1.4.0.0 through 1.7.0.2; the issue has been fixed in Magento Community Edition 1.8.0.0 and later. It resolves a vulnerability discovered through our quarterly penetration testing process and has not been reported by merchants. We encourage all merchants to apply the patch in their next regularly scheduled maintenance cycle. The patch is available at http://www.magentocommerce.com/download in the Magento Community Edition Patches section.','http://www.magentocommerce.com/download',0,1),(176,3,'2014-01-14 04:00:00','AJAX Cart Pro v.3.2 by aheadWorks has been released!','Set up unique confirmation block content per each product! With the updated AJAX Cart Pro module, you can create rules and define pop-up window behavior per different items.','http://ecommerce.aheadworks.com/magento-extensions/ajax-cart-pro.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=acp3_2',0,1),(177,3,'2014-01-16 03:00:00','Advanced Search v.1.4 has been released! ','Make search results even more trustworthy! Since version 1.4, Advanced Search corrects all misspellings and allows customers to find products by part of the word.','http://ecommerce.aheadworks.com/magento-extensions/advanced-search.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=as1_4',0,1),(178,4,'2014-01-21 12:34:48','PHP 5.4 Patch Now Available','Magento is advancing its platform and making development more efficient by adding support for PHP 5.4. Patches are available for download at www.magentocommerce.com/download and you can learn more about this update in our blog post at http://www.magentocommerce.com/blog/comments/magento-now-supports-php-54 .','http://www.magentocommerce.com/blog/comments/magento-now-supports-php-54',0,1),(179,3,'2014-02-28 11:00:00','Featured Products 3 v.3.6 by aheadWorks has been released!','Showcase top items of your store in a customizable featured products block! Background color, border, and border-radius can be configured in the backend.','http://ecommerce.aheadworks.com/magento-extensions/featured-products-3.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=fp36',0,1),(180,3,'2014-02-26 11:00:00','Advanced Newsletter v.2.4 by aheadWorks has been released! ','Add more security to your emails. Since version 2.4, SSL protocol in SMTP configuration is supported.','http://ecommerce.aheadworks.com/magento-extensions/advanced-newsletter.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=an_2_4',0,1),(181,3,'2014-02-24 11:00:00','RMA v.1.5 by aheadWorks has been released!','Manage customers’ requests for products return or exchange without any efforts. Since version 1.5, you can explain RMA policy to clients while a new request is being created.','http://ecommerce.aheadworks.com/magento-extensions/rma.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=rma_1_5',0,1),(182,3,'2014-02-14 08:00:00','Valentines’ Day Sale – 15% off Magento extensions','Happy Valentine’s Day! Enjoy a 15% discount on all Magento extensions or themes by aheadWorks! The offer is valid only on the 14th of February!','http://ecommerce.aheadworks.com/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=valentine',0,1),(183,3,'2014-02-03 11:00:00','Search Autocomplete and Suggest v.3.4 by aheadWorks has been released!','Make your store search instant with relevant results. Now with suggested keywords and ‘All Results’ button.','http://ecommerce.aheadworks.com/magento-extensions/search-autocomplete-and-suggest.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=sas_3_4',0,1),(184,4,'2014-02-20 11:51:46','Discover Card Validation Patch Available','A patch that resolves an issue with validating Discover credit cards is now available for download at http://www.magentocommerce.com/download. More information on the patch is available in the Magento Knowledge Base at http://www.magentocommerce.com/knowledge-base/entry/discover-card-validation','http://www.magentocommerce.com/knowledge-base/entry/discover-card-validation ',0,1),(185,4,'2014-03-04 09:12:26','Learn How to Quickly Increase Sales on Your Site','Adding the PayPal Express Checkout button to your checkout page can help increase sales 18% on average. It’s fast and easy and you can do it right now to boost sales. Express Checkout is already seamlessly integrated into Community Edition.','http://magento.com/paypal/CE_Express_Checkout_NA?utm_source=messagemodule&utm_medium=message&utm_campaign=Ceexpresscheckout',0,1),(186,3,'2014-03-05 10:00:00','Layered Navigation v.1.1 by aheadWorks has been released!','Improve Magento search with easy-to-use navigation filters. Since version 1.1, decimal/integer attributes are supported, help notices & column layout can be set up, and much more…','http://ecommerce.aheadworks.com/magento-extensions/layered-navigation.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=ln11',0,1),(187,3,'2014-04-18 00:30:00','Easter Sale – 15% off Magento extensions and themes','Save on great solutions to improve your online store! Catch a 15% discount on all aheadWorks products. The sale runs through April 20.','http://ecommerce.aheadworks.com/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=easter2014',0,1),(188,3,'2014-04-09 10:00:00','Product Questions v.2.0 by aheadWorks has been released!','The new ‘Ask Customers’ functionality is implemented - invite buyers to answer questions via direct emails.','http://ecommerce.aheadworks.com/magento-extensions/product-questions.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=pq2',0,1),(189,3,'2014-03-26 11:00:00','Shop By Brand v.1.3 by aheadWorks has been released!','Assign products to brands without any efforts! Since version 1.3, you can use layered navigation on the brand page, insert \"More from same brand\" block on product page, and much more.','http://ecommerce.aheadworks.com/magento-extensions/shop-by-brand.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=sbb13',0,1),(190,3,'2014-03-18 11:00:00','Price Match v.2.1 by aheadWorks has been released!','Let customers create a price match request when other vendors offer lower product price. Since version 2.1, visitors’ requests can be approved automatically.','http://ecommerce.aheadworks.com/magento-extensions/price-match.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=pmatch_2_1',0,1),(191,3,'2014-03-17 01:00:00','St. Patrick’s Day Sale – 10% OFF all Magento extensions','Save some green on St. Patrick’s Day! We offer you a 10% discount on all Magento extensions and themes by aheadWorks. The sale is valid only on the 17th of March.','http://ecommerce.aheadworks.com/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=patrick2014',0,1),(192,3,'2014-03-12 11:00:00','Countdown v.1.1 by aheadWorks has been released!','Get full control over promotional countdown blocks: show them on a recurring basis, prioritize, display inside product list on the category page, and much more.','http://ecommerce.aheadworks.com/magento-extensions/countdown.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=countdown11',0,1),(193,4,'2014-05-13 09:46:11','Magento Community Edition 1.9 is now available!','It accelerates your entry into the mobile commerce space by slashing the time and cost of getting a mobile device-friendly responsive site.  And a new Bill Me Later payment option helps boost your sales. Visit http://magento.com/blog/magento-news/magento-enables-responsive-sites-half-time to learn more.','http://magento.com/blog/magento-news/magento-enables-responsive-sites-half-time',0,1),(194,3,'2014-06-03 10:00:00','Event Tickets v.1.1 by aheadWorks has been released!','Implement powerful and easy-to-use event & ticket management system on your website with the updated Event Tickets tool! Now you can send printable tickets, scan QR codes, redeem tickets using smartphones, and much more.','http://ecommerce.aheadworks.com/magento-extensions/event-tickets.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=et11',0,1),(195,3,'2014-06-12 09:00:00','Help Desk Ultimate v.3.0 by aheadWorks has been released!','Fully redesigned with absolutely new business logic! View help desk statistics, let customers escalate a ticket, assign a request to a specific agent and much more.','http://ecommerce.aheadworks.com/magento-extensions/help-desk-ultimate.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=hdu3',0,1),(196,3,'2014-12-01 02:00:00','Cyber Monday Deal: Get a Year of Free Support with any Extension','Keep your online store up-to-date with any aheadWorks extension and get a free technical support the whole year round! The offer ends on December 3.','http://ecommerce.aheadworks.com/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=cyber_monday_2014',0,1),(197,3,'2014-11-26 08:00:00','Black Friday Sale – 20% OFF all Magento extensions and themes!',' Enhance your store with new functionality at a reduced price! Valid till November 30.','http://ecommerce.aheadworks.com/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=black_friday_2014',0,1),(198,3,'2014-11-24 09:00:00','Order Tags v.1.4 has been released!','Speed up order processing in your store! Since version 1.4, you can assign tags to orders of specific stores, change order row style and more.','http://ecommerce.aheadworks.com/magento-extensions/order-tags.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=order_tags14',0,1),(199,3,'2014-11-19 11:00:00','Welcome Store Credit and Refund 1.0 by aheadWorks!','Implement store credit functionality and inspire customers to make new purchases in your Magento store!','http://ecommerce.aheadworks.com/magento-extensions/store-credit-and-refund.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=scr_launch',0,1),(200,3,'2014-11-12 11:00:00','Limited-time offer: Store Credit and Refund Pre-Order',' With the help of the Store Credit and Refund tool, you can create virtual wallets on your website and let customers accumulate funds for their cancelled orders. The module can be purchased with a 30% discount now! ','http://ecommerce.aheadworks.com/magento-extensions/store-credit-and-refund.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=scr_pre_order',0,1),(201,3,'2014-11-06 11:00:00','Limited-time offer: Get Search Autocomplete and Suggest for Free!','Improve your search functionality twofold! Order Advanced Search and get Search Autocomplete & Suggest at no cost. The offer is limited.','http://ecommerce.aheadworks.com/exclusive-deal/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=as_saas',0,1),(202,3,'2014-10-28 09:00:00','Halloween Sale - 15% off Magento extensions and themes','In honor of the spookiest day of the year, we slash prices on all Magento extensions and themes in our store! The offer ends on October 31. Hurry up!','http://ecommerce.aheadworks.com/?utm_source=MailChimp&utm_medium=email&utm_campaign=halloween2014',0,1),(203,3,'2014-10-02 06:00:00','Limited-time offer: Get eCommerce Gamification Suite for free!','Build successful loyalty program with powerful marketing tools: order Points & Rewards or Refer a Friend and get the eCommerce Gamification Suite extension absolutely for free!','http://ecommerce.aheadworks.com/magento-extensions/ecommerce-gamification-suite.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=gamifpromo',0,1),(204,3,'2014-09-16 10:00:00','Help Desk Ultimate v.3.1 by aheadWorks has been released!','Use the updated Help Desk Ultimate extension to streamline your communications into a single channel! The tool is enhanced with 15 new features!','http://ecommerce.aheadworks.com/magento-extensions/help-desk-ultimate.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=hdu31',0,1),(205,3,'2014-08-06 08:00:00','Better Thank You Page v.1.1 by aheadWorks has been released!','Turn the order success page into a powerful marketing tool! The just implemented rules system allows you to create flexible conditions and populate the thank you page with unique content automatically after a rule triggering.','http://ecommerce.aheadworks.com/magento-extensions/better-thank-you-page.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=btyp11',0,1),(206,4,'2014-10-07 21:55:06','It’s still not too late: Boost your 2014 Holiday sales today.','See results in as little as one week with eBay Enterprise Display and 2 business days with eBay Enterprise Affiliate. DID YOU KNOW: Get access to over 128 million highly qualified shoppers on eBay.com with eBay Enterprise Display. And the average retail client using product retargeting sees a $10 to $1 ROI on retargeting spend during Q4. With the eBay Enterprise Affiliate Network, get access to over 200,000 active network publishers across 30+ verticals, and only pay when a customer makes a purchase (Affiliate Network is only available in the U.S. & Canada).  GET STARTED TODAY by visiting www.ebayenterprise.com/turbochargesales','http://www.ebayenterprise.com/turbochargesales',0,1),(207,4,'2014-11-12 13:03:26','Important: PayPal Users Must Discontinue Using SSL 3.0 By December 3, 2014','To address a vulnerability with the SSL 3.0 security protocol, PayPal and other payment gateways will be disabling SSL 3.0 support. Merchants must upgrade to Transport Layer Service (TLS) by December 3, 2014 to avoid PayPal payment operation failures. Learn more about what you need to do at https://devblog.paypal.com/poodle-ssl-3-0-vulnerability/','https://devblog.paypal.com/poodle-ssl-3-0-vulnerability/',0,1),(208,4,'2014-11-24 17:25:21','Magento Community Edition 1.9.1 is available!','Magento Community Edition 1.9.1 empowers merchants to deliver compelling shopping experiences by offering enhanced responsive design capabilities, new swatches to display product variations, and improved performance through support for MySQL 5.6 and PHP 5.5. It also includes support for Google Universal Analytics and over 70 product improvements. Find out more at http://magento.com/blog/magento-news/magento-community-edition-191-now-available-download','http://magento.com/blog/magento-news/magento-community-edition-191-now-available-download',0,1),(209,3,'2015-09-10 09:00:00','Magento 2 Extensions by aheadWorks in Beta Now!','Have a look at the first batch of Magento 2 extensions by aheadWorks and share your thoughts and expectations. Your feedback is highly appreciated!','https://ecommerce.aheadworks.com/magento-2-extensions/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=M2ExtBeta',0,1),(210,3,'2015-08-28 07:10:00','Security issue has been fixed in Blog 1.3.14','To avoid any security problems, please upgrade the Blog extension to version 1.3.14. Please log in and then go to the product page to obtain the latest version. In case of any questions, feel free to contact our support team.','http://ecommerce.aheadworks.com/free-stuff/blog.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Blog1_3_14CE',0,1),(211,3,'2015-08-28 07:00:00','Security issue has been fixed in Blog 1.3.14','To avoid any security problems, please upgrade the Blog extension to version 1.3.14 (My Account->Products->Blog). The module is available for FREE DOWNLOAD regardless the status of support period.','http://ecommerce.aheadworks.com/magento-extensions/blog-enterprise-edition.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Blog1_3_14EE',0,1),(212,3,'2015-08-25 08:00:00','Coupon Code Generator is out!','Generate coupon codes in one click and send them to customers automatically!','http://ecommerce.aheadworks.com/magento-extensions/coupon-code-generator.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=CouponCodeLaunch',0,1),(213,3,'2015-07-22 07:00:00','Order Tags v.1.5.0 has been released!','Now you can assign tags to orders automatically using Shipping Methods as a rule conditions. ','http://ecommerce.aheadworks.com/magento-extensions/order-tags.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Order_Tags_1_5',0,1),(214,3,'2015-07-14 09:20:00','Update Gift Card/Certificate after Magento Security patch (SUPEE-6285) installation','In order to avoid any ACL problems, please update Gift Card/Certificate to the latest version 1.0.11! In case of any questions, feel free to contact our support team.','http://ecommerce.aheadworks.com/magento-extensions/gift-card-certificate.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Sec_Patch',0,1),(215,3,'2015-07-14 09:10:00','Update Advanced Reports after Magento Security patch (SUPEE-6285) installation','In order to avoid any ACL problems, please update Advanced Reports to the latest version 2.6.3! In case of any questions, feel free to contact our support team.','http://ecommerce.aheadworks.com/magento-extensions/advanced-reports.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Sec_Patch',0,1),(216,3,'2015-07-14 09:00:00','Update Advanced Reviews after Magento Security patch (SUPEE-6285) installation','In order to avoid any ACL problems, please update Advanced Reviews to the latest version 2.3.8! In case of any questions, feel free to contact our support team.','http://ecommerce.aheadworks.com/magento-extensions/advanced-reviews.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Sec_Patch',0,1),(217,3,'2015-07-08 08:00:00','Free International Shipping Solution for Magento is out!','Access international market in a convenient and cost-efficient way with brand new Magento International Shipping. Install now and get a 10% discount for your next purchase at aheadWorks!','http://ecommerce.aheadworks.com/magento-extensions/international-shipping.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Int_Ship',0,1),(218,3,'2015-05-27 08:00:08','Advanced Reports v.2.6.0 by aheadWorks has been released!','We have made significant progress with it\'s look and feel, included a number of long-awaited features, and added several most requested new reports. Moreover, now you can get all 10 additional reports at 60% discount as an Extended Pack.','http://ecommerce.aheadworks.com/magento-extensions/advanced-reports.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=AR_2_6_0',0,1),(219,4,'2015-01-22 11:47:08','Join Us at Imagine Commerce 2015 - April 20-22 at the Wynn Las Vegas','Join Magento, eBay Enterprise, and over 2,000 merchants, developers, and eCommerce experts at the premier Commerce event of the year. With three days of cutting-edge keynote presentations, special technical programs, dynamic breakout sessions, and incredible networking opportunities, Imagine Commerce 2015 will educate, enrich, and inspire you to take your business to new heights. Register now at http://imagine2015.magento.com/.','http://imagine2015.magento.com/',0,1),(220,1,'2015-04-16 10:17:07','Critical Reminder: Download and install Magento security patches.  Download now.','Download and implement 2 important security patches (SUPEE-5344 and SUPEE-1533) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  If you have not done so already, download and install 2 previously-released patches that prevent an attacker from remotely executing code on Magento software.  These issues affect all versions of Magento Community Edition.  A press release from Check Point Software Technologies in the coming days will make one of these issues widely known, possibly alerting hackers who may try to exploit it.  Ensure the patches are in place as a preventative measure before the issue is publicized.','https://www.magentocommerce.com/products/downloads/magento/ ',0,1),(221,1,'2015-04-19 16:37:00','Second Reminder: Download and install Magento critical security patches now.','If you have not done so already, download and install 2 previously-released security patches (SUPEE-5344 and SUPEE-1533) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  These security issues affect all versions of Magento Community Edition and enable an attacker to remotely execute code on Magento software. A press release from Check Point Software Technologies tomorrow  will make one of these issues widely known, possibly alerting hackers who may try to exploit it.  Ensure the patches are in place as a preventative measure before the issue is publicized.','https://www.magentocommerce.com/products/downloads/magento/',0,1),(222,1,'2015-04-23 13:43:31','Urgent: Immediately install Magento critical security patches','It is critical for you to download and install 2 previously-released security patches (SUPEE-5344 and SUPEE-1533) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  Please do this immediately, as Check Point Software Technologies has published a technical description of how they discovered the issue, which we feel might serve as a tutorial for implementing an attack against your website. ','https://www.magentocommerce.com/products/downloads/magento/',0,1),(223,1,'2015-05-14 18:34:01','Important: New Magento Security Patch - Install it Now','It is important for you to download and install a new security patch (SUPEE-5994) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  Please apply this critical update immediately to help protect your site from exposure to multiple security vulnerabilities impacting all versions of the Magento Community Edition software. Please note that this patch should be installed in addition to the recent Shoplift patch (SUPEE-5344).','https://www.magentocommerce.com/products/downloads/magento/',0,1),(224,4,'2015-07-07 10:28:25','Now available:  Enhanced site quality and security with Community Edition 1.9.2','Magento Community Edition 1.9.2 is now available for download and features over 105 product improvements, nearly 170 automated functional tests to help internal development teams improve implementation quality and time to market, and several security enhancements. Read our blog announcement for more information (http://magento.com/blog/magento-news/magento-community-edition-192-now-available), or go to the Community Edition download page to get the software today (https://www.magentocommerce.com/products/downloads/magento/).','https://www.magentocommerce.com/products/downloads/magento/',0,1),(225,1,'2015-07-07 11:08:05','July 7, 2015: New Magento Security Patch (SUPEE-6285) – Install Immediately','Today we are providing a new security patch (SUPEE-6285) that addresses critical security vulnerabilities. The patch is available for Community Edition 1.4.1 to 1.9.1.1 and is part of the core code of our latest release, Community Edition 1.9.2, available for download today.  PLEASE NOTE:  You must first implement SUPEE-5994 to ensure SUPEE-6285 works properly. Download Community Edition 1.9.2 or the patch from the Community Edition download page: https://www.magentocommerce.com/products/downloads/magento/  ','https://www.magentocommerce.com/products/downloads/magento/',0,1),(226,1,'2015-08-04 11:28:26','August 4, 2015: New Magento Security Patch (SUPEE-6482) – Install Immediately','Today we are providing a new security patch (SUPEE-6482) that addresses 4 security issues; two issues related to APIs and two cross-site scripting risks. The patch is available for Community Edition 1.4 and later releases and is part of the core code of Community Edition 1.9.2.1, which is available for download today. Before implementing this new security patch, you must first implement all previous security patches. Download Community Edition 1.9.2.1 or the patch from the Community Edition download page at https://www.magentocommerce.com/products/downloads/magento/  ','https://www.magentocommerce.com/products/downloads/magento/  ',0,1),(227,2,'2015-08-05 14:12:55','August 5, 2015:  Security Patch (SUPEE-6482) Release Note CORRECTION','When we announced a new security patch (SUPEE-6482) for Community Edition yesterday we incorrectly said that it addresses 4 issues. It actually addresses 2 security issues: Autoloaded File Inclusion in Magento SOAP API and a SSRF Vulnerability in WSDL File. The patch and Community Edition 1.9.2.1 are complete, fully-tested, and ready to deploy. We strongly encourage you to deploy the patch or upgrade to the latest version of Community Edition if you haven’t done so already. You can find the patch at https://www.magentocommerce.com/products/downloads/magento/. ','https://www.magentocommerce.com/products/downloads/magento/',0,1),(228,3,'2015-09-16 09:00:00','Subscriptions and Recurring Payments v.2.2.0 has been released!','Send updates on your subscription products just in time! Since version 2.2.0, the module supports automatic email notifications.','https://ecommerce.aheadworks.com/magento-extensions/subscriptions-and-recurring-payments.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=SARP2_2',0,1),(229,4,'2015-10-01 11:32:53','Episode VI: Return of Imagine Commerce | 2016 Registration is Open!','The force is strong with this one. Join the Magento rebellion at Imagine Commerce 2016. Enlist Now at http://imagine.magento.com.','http://imagine.magento.com',0,1),(230,3,'2015-11-19 06:46:47','Gift Card / Certificate 1.1.0 is out!','New version of our Gift Card/Certificate is out. It offers customers to specify the delivery date and introduces a few additions to backend control.','https://ecommerce.aheadworks.com/magento-extensions/gift-card-certificate.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=GCM1_1.1',0,1),(231,3,'2015-11-12 08:15:00','Gift Card for Magento 2 is out!','Craft the gift card that will match your specific business model and customer mindset! Explore the tool and let us know what you think! Your feedback is highly appreciated.','https://ecommerce.aheadworks.com/magento-2-extensions/gift-card/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=GiftCard_M2',0,1),(232,3,'2015-11-10 02:00:00','iPhone Theme 3.0 is Out!','This version includes refactored script and new CSS styles for easier customization. Moreover, 7 new features provide iPad-tailored design, quantity selection field, review posting option and much more.','https://ecommerce.aheadworks.com/magento-themes-and-templates/iphone-theme.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=iphone3',0,1),(233,3,'2015-11-05 06:05:00','Free access to Auction Pro v.1.0.4 with SUPEE-6788 compatibility issue fixed','Get Auction Pro v.1.0.4 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/auction-pro.html?utm_source=awfeed&utm_medium=zefeed&utm_term=auction&utm_campaign=Patch6788',0,1),(234,3,'2015-11-05 06:00:00','Free access to Extra Downloads v.1.0.3 with SUPEE-6788 compatibility issue fixed','Get Extra Downloads v.1.0.3 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/extra-downloads.html?utm_source=awfeed&utm_medium=zefeed&utm_term=extradownloads&utm_campaign=Patch6788',0,1),(235,3,'2015-11-04 03:10:00','Free access to Checkout Promo v.1.2.5 with SUPEE-6788 compatibility issue fixed','Get Checkout Promo v.1.2.5 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/checkout-promo.html?utm_source=awfeed&utm_medium=zefeed&utm_term=checkoutpromo&utm_campaign=Patch6788',0,1),(236,3,'2015-11-04 03:00:00','Free access to Group Deals v.1.0.7 with SUPEE-6788 compatibility issue fixed','Get Group Deals v.1.0.7 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/group-deals.html?utm_source=awfeed&utm_medium=zefeed&utm_term=groupdeals&utm_campaign=Patch6788',0,1),(237,3,'2015-11-04 02:55:00','Free access to Sales by Manufacturer v.1.0.10 with SUPEE-6788 compatibility issue fixed','Get Sales by Manufacturer v.1.0.10 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/magento-analytics/sales-by-manufacturer.html?utm_source=awfeed&utm_medium=zefeed&utm_term=salesbymanufacturer&utm_campaign=Patch6788',0,1),(238,3,'2015-11-04 02:45:00','Free access to Sales Statistics v.1.0.11 with SUPEE-6788 compatibility issue fixed','Get Sales Statistics v.1.0.11 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/magento-analytics/sales-statistics.html?utm_source=awfeed&utm_medium=zefeed&utm_term=salesstatistics&utm_campaign=Patch6788',0,1),(239,3,'2015-11-04 02:40:00','Free access to Sales by ZIP Code v.1.0.9 with SUPEE-6788 compatibility issue fixed','Get Sales by ZIP Code v.1.0.9 for free in your account area to ensure the proper work of the tool after Magento Security patch (SUPEE-6788) installation. Please note that it will not reactivate your support period.','https://ecommerce.aheadworks.com/magento-extensions/magento-analytics/sales-by-zip-code.html?utm_source=awfeed&utm_medium=zefeed&utm_term=salesbyzipcode&utm_campaign=Patch6788',0,1),(240,1,'2015-10-20 18:28:05','New Malware Issue. Make Sure You Have Implemented All Security Patches','We have received reports that some Magento sites are being targeted by Guruincsite malware (Neutrino exploit kit). We have NOT identified a new attack vector at this time. Nearly all the impacted sites checked so far were vulnerable to a previously identified and patched issue; sites not vulnerable to that issue show other unpatched issues. Visit the Magento Security Center at http://magento.com/security/news/important-security-update for more information on how to address this issue and make sure that you have implemented all recent security patches.\n','http://magento.com/security/news/important-security-update',0,1),(241,1,'2015-10-27 15:48:23','October 27, 2015: New Magento Security Patch (SUPEE-6788) – Install Immediately','Today, we are releasing a new patch (SUPEE-6788) and Community Edition 1.9.2.2 to address 10+ security issues, including remote code execution and information leak vulnerabilities. This patch is unrelated to the Guruincsite malware issue. Be sure to test the patch in a development environment first, as it can affect extensions and customizations. Download the patch from the Community Edition Download page and learn more at http://magento.com/security/patches/supee-6788  ','http://magento.com/security/patches/supee-6788  ',0,1),(242,1,'2015-11-17 18:25:00','New JavaScript Malware Issue. Make sure your site is secure.','Magento Commerce has received reports of a JavaScript malware exploit that forwards credit card information from checkout pages to an external site. No new attack vector has been identified. It appears most impacted sites have not implemented the February 2015 Shoplift patch, or the patch was implemented after the site was already compromised. Information on how to identify and remove the malicious code is available on the Magento Security Center at http://magento.com/security/news/new-javascript-malware-issue','http://magento.com/security/news/new-javascript-malware-issue ',0,1),(243,4,'2015-11-18 15:40:40','Magento 2.0 Is Available!','Magento 2.0, our next generation open source digital commerce platform is here!  Magento 2.0 offers enhanced performance and scalability, new features to deliver better shopping experiences and conversion rates, and business agility and productivity improvements.  Learn more http://magento.com/blog/magento-news/new-era-commerce-innovation.\n\n','http://magento.com/blog/magento-news/new-era-commerce-innovation',0,1),(244,3,'2016-01-18 07:46:30','Fixed link for a Package Deal!','A lot of you were interested in our new package deal for M1, but, unfortunately, the link we have supplied was broken. Please follow the link in this message to learn more about the deal.','https://ecommerce.aheadworks.com/magento-extensions/package-deal-for-m1.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=PackDealM1V2',0,1),(245,3,'2016-01-13 03:22:08','Package deal for Magento 1!','We are launching a limited time offer that allows you to pick any 5 aheadWorks extensions from our catalogue for a one time payment of $499. The offer stands until the end of January. Follow the link for more details.','https://ecommerce.aheadworks.com/magento-extensions/package-deal-for-m1.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=PackDealM1',0,1),(246,3,'2015-12-09 08:59:51','Advanced Reports 2.7 is out!','We have rolled out the new version of Advanced Reports. Apart from countless bug fixes we have added a new report that splits all sales by orders, giving you another perspective on the performance of your store.','https://ecommerce.aheadworks.com/magento-extensions/advanced-reports.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=AR2.7',0,1),(247,3,'2016-03-14 03:43:19','Gift Card 2.0 is out!','The long awaited, new edition Gift Card is a less complex, yet a very flexible, customer-oriented extension, meant for adding a gift card product to your catalogue.','https://ecommerce.aheadworks.com/magento-extensions/gift-card-certificate.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=GC20',0,1),(248,3,'2016-02-29 01:27:03','Leap Day Sale!','Today only - 29% OFF for all our products!','https://ecommerce.aheadworks.com/magento-extensions.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=LD16',0,1),(249,3,'2017-02-14 06:34:11','New product line for Magento 2: Small Business Kit ','Straightforward extensions at best possible prices! Get Abandoned Cart Email at $79 only!','https://ecommerce.aheadworks.com/magento-2-extensions/abandoned-cart?utm_source=awfeed&utm_medium=zefeed&utm_campaign=SBKit',0,1),(250,3,'2017-02-07 01:41:15','Happy Valentine\'s Day - 25% off!','Valentine’s Day is coming! Prepare your store and get Aheadworks extensions at lovely prices - 25% off! Coupon: VALENTINE2017','https://ecommerce.aheadworks.com/magento-extensions.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=Valentine2017',0,1),(251,3,'2017-02-01 02:12:55','Update of Advanced Reports for Magento 2','We\'ve added Sales by Product Attributes report and a lot of new features! Use coupon M1M2 to get this product at half price!','https://ecommerce.aheadworks.com/magento-2-extensions/advanced-reports?utm_source=awfeed&utm_medium=zefeed&utm_campaign=AdvReports2_1v',0,1),(252,3,'2017-01-30 05:33:25','Subscription and Recurring Payments for Magento 2','Subscription and Recurring Payments for Magento 2 have been released! Use coupon M1M2 to get it at half price!','https://ecommerce.aheadworks.com/magento-2-extensions/subscriptions-and-recurring-payments?utm_source=awfeed&utm_medium=zefeed&utm_campaign=SARPm2',0,1),(253,3,'2016-12-22 06:35:36','X-mas prices at Aheadworks - 35% off','With this final sale we bid farewell to 2016. Have a merry Chistmas and a happy New Year! Coupon: XMAS16','https://ecommerce.aheadworks.com/magento-extensions.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=XMAS16',0,1),(254,3,'2016-12-20 07:28:55','X-mas prices at Aheadworks','And another chance to snatch a couple of our extensions at a discount! This entire week Aheadworks products are 20% off. Coupon: JOLLY16','https://ecommerce.aheadworks.com/magento-extensions.html?utm_source=awfeed&utm_medium=zefeed&utm_campaign=XMAS16',0,1),(255,3,'2016-12-15 07:32:18','Reward Points for Magento 2','Reward Points for Magetno 2 have been released! Use coupon M1M2 to get it at half price!','https://ecommerce.aheadworks.com/magento-2-extensions/points-and-rewards?utm_source=awfeed&utm_medium=zefeed&utm_campaign=RP16',0,1),(256,3,'2016-12-15 05:30:44','Update of Layered Navigation for Magento 2','We\'ve added a price glider and price input fields to the navigation panel! Use coupon M1M2 to get this product at half price!','https://ecommerce.aheadworks.com/magento-2-extensions/layered-navigation?utm_source=awfeed&utm_medium=zefeed&utm_campaign=LN16',0,1),(257,3,'2016-12-08 08:11:04','Aheadworks: Free Lifetime Updates!','Starting now all Aheadworks extensions come with free lifetime updates. The most recent versions of your extensions are available for download regardless of support period status.','https://ecommerce.aheadworks.com/awlicensing/index/links/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=licence081216',0,1),(258,3,'2016-11-28 04:38:26','Cyber Monday discount!','For those who have missed all the Black Friday action - no need to worry. Use the code CM16 to get 20% off on any Aheadworks extensions. Today and tomorrow only!','https://ecommerce.aheadworks.com/?utm_source=awfeed&utm_medium=zefeed&utm_campaign=CM16',0,1);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api2_acl_attribute`
--

DROP TABLE IF EXISTS `api2_acl_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api2_acl_attribute` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `user_type` varchar(20) NOT NULL COMMENT 'Type of user',
  `resource_id` varchar(255) NOT NULL COMMENT 'Resource ID',
  `operation` varchar(20) NOT NULL COMMENT 'Operation',
  `allowed_attributes` text COMMENT 'Allowed attributes',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `UNQ_API2_ACL_ATTRIBUTE_USER_TYPE_RESOURCE_ID_OPERATION` (`user_type`,`resource_id`,`operation`),
  KEY `IDX_API2_ACL_ATTRIBUTE_USER_TYPE` (`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api2 Filter ACL Attributes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api2_acl_attribute`
--

LOCK TABLES `api2_acl_attribute` WRITE;
/*!40000 ALTER TABLE `api2_acl_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `api2_acl_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api2_acl_role`
--

DROP TABLE IF EXISTS `api2_acl_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api2_acl_role` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `role_name` varchar(255) NOT NULL COMMENT 'Name of role',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_API2_ACL_ROLE_CREATED_AT` (`created_at`),
  KEY `IDX_API2_ACL_ROLE_UPDATED_AT` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Api2 Global ACL Roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api2_acl_role`
--

LOCK TABLES `api2_acl_role` WRITE;
/*!40000 ALTER TABLE `api2_acl_role` DISABLE KEYS */;
INSERT INTO `api2_acl_role` VALUES (1,'2012-05-17 00:43:28',NULL,'Guest'),(2,'2012-05-17 00:43:28',NULL,'Customer');
/*!40000 ALTER TABLE `api2_acl_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api2_acl_rule`
--

DROP TABLE IF EXISTS `api2_acl_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api2_acl_rule` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `role_id` int(10) unsigned NOT NULL COMMENT 'Role ID',
  `resource_id` varchar(255) NOT NULL COMMENT 'Resource ID',
  `privilege` varchar(20) DEFAULT NULL COMMENT 'ACL Privilege',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `UNQ_API2_ACL_RULE_ROLE_ID_RESOURCE_ID_PRIVILEGE` (`role_id`,`resource_id`,`privilege`),
  CONSTRAINT `FK_API2_ACL_RULE_ROLE_ID_API2_ACL_ROLE_ENTITY_ID` FOREIGN KEY (`role_id`) REFERENCES `api2_acl_role` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api2 Global ACL Rules';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api2_acl_rule`
--

LOCK TABLES `api2_acl_rule` WRITE;
/*!40000 ALTER TABLE `api2_acl_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `api2_acl_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api2_acl_user`
--

DROP TABLE IF EXISTS `api2_acl_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api2_acl_user` (
  `admin_id` int(10) unsigned NOT NULL COMMENT 'Admin ID',
  `role_id` int(10) unsigned NOT NULL COMMENT 'Role ID',
  UNIQUE KEY `UNQ_API2_ACL_USER_ADMIN_ID` (`admin_id`),
  KEY `FK_API2_ACL_USER_ROLE_ID_API2_ACL_ROLE_ENTITY_ID` (`role_id`),
  CONSTRAINT `FK_API2_ACL_USER_ADMIN_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_API2_ACL_USER_ROLE_ID_API2_ACL_ROLE_ENTITY_ID` FOREIGN KEY (`role_id`) REFERENCES `api2_acl_role` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api2 Global ACL Users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api2_acl_user`
--

LOCK TABLES `api2_acl_user` WRITE;
/*!40000 ALTER TABLE `api2_acl_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `api2_acl_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_assert`
--

DROP TABLE IF EXISTS `api_assert`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_assert` (
  `assert_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Assert id',
  `assert_type` varchar(20) DEFAULT NULL COMMENT 'Assert type',
  `assert_data` text COMMENT 'Assert additional data',
  PRIMARY KEY (`assert_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api ACL Asserts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_assert`
--

LOCK TABLES `api_assert` WRITE;
/*!40000 ALTER TABLE `api_assert` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_assert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_role`
--

DROP TABLE IF EXISTS `api_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role id',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent role id',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role level in tree',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort order to display on admin area',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User id',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role name',
  PRIMARY KEY (`role_id`),
  KEY `IDX_API_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `IDX_API_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api ACL Roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_role`
--

LOCK TABLES `api_role` WRITE;
/*!40000 ALTER TABLE `api_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_rule`
--

DROP TABLE IF EXISTS `api_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Api rule Id',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Api role Id',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Module code',
  `api_privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `assert_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Assert id',
  `role_type` varchar(1) DEFAULT NULL COMMENT 'Role type',
  `api_permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `IDX_API_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `IDX_API_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `FK_API_RULE_ROLE_ID_API_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `api_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api ACL Rules';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_rule`
--

LOCK TABLES `api_rule` WRITE;
/*!40000 ALTER TABLE `api_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_session`
--

DROP TABLE IF EXISTS `api_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_session` (
  `user_id` int(10) unsigned NOT NULL COMMENT 'User id',
  `logdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Login date',
  `sessid` varchar(40) DEFAULT NULL COMMENT 'Sessioin id',
  KEY `IDX_API_SESSION_USER_ID` (`user_id`),
  KEY `IDX_API_SESSION_SESSID` (`sessid`),
  CONSTRAINT `FK_API_SESSION_USER_ID_API_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `api_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api Sessions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_session`
--

LOCK TABLES `api_session` WRITE;
/*!40000 ALTER TABLE `api_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_user`
--

DROP TABLE IF EXISTS `api_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User id',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'First name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'Last name',
  `email` varchar(128) DEFAULT NULL COMMENT 'Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'Nickname',
  `api_key` varchar(100) DEFAULT NULL COMMENT 'Api key',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User record create date',
  `modified` timestamp NULL DEFAULT NULL COMMENT 'User record modify date',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Quantity of log ins',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Refresh ACL flag',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Account status',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api Users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_user`
--

LOCK TABLES `api_user` WRITE;
/*!40000 ALTER TABLE `api_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog`
--

DROP TABLE IF EXISTS `aw_blog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog` (
  `post_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `post_content` text NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '0',
  `created_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `user` varchar(255) NOT NULL DEFAULT '',
  `update_user` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text NOT NULL,
  `meta_description` text NOT NULL,
  `comments` tinyint(11) NOT NULL,
  `tags` text NOT NULL,
  `short_content` text NOT NULL,
  PRIMARY KEY (`post_id`),
  UNIQUE KEY `identifier` (`identifier`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog`
--

LOCK TABLES `aw_blog` WRITE;
/*!40000 ALTER TABLE `aw_blog` DISABLE KEYS */;
INSERT INTO `aw_blog` VALUES (3,'Free installation on a special Magento hosting','<h3>Deeper integration with Magenting hosting</h3>\r\n<p>Get the theme with extensions rapidly installed on magenting hosting absolutely for free ( just check proper option while checkout).</p>\r\n<p>All you have to do is to follow simple steps and obtain magenting.com hosting account (starting from $20/mo).</p>\r\n<h2>Magenting</h2>\r\n<p><a title=\"Magento hosting\" href=\"http://magenting.com\">Magenting.com</a>, a new faster, highly optimized, improved <strong>Magento hosting solution</strong>, is making it easy to create, promote, and manage online stores. Magento comes with everything you need to get your online store up and running!</p>\r\n<ul class=\"bullet\">\r\n<li><strong> Professional Magento hosting account</strong></li>\r\n<li><strong> Automatic Magento eCommerce installation</strong></li>\r\n<li><strong> Free our Magento template installation</strong></li>\r\n</ul>\r\n<p>It\'s never been easier to start selling online!</p>',1,'2010-11-11 00:00:00','2013-02-07 03:11:30','hosting','Store Magento','Store Magento','','',0,'','Deeper integration with Magenting hosting');
/*!40000 ALTER TABLE `aw_blog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_cat`
--

DROP TABLE IF EXISTS `aw_blog_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_cat` (
  `cat_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `sort_order` tinyint(6) NOT NULL,
  `meta_keywords` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_cat`
--

LOCK TABLES `aw_blog_cat` WRITE;
/*!40000 ALTER TABLE `aw_blog_cat` DISABLE KEYS */;
INSERT INTO `aw_blog_cat` VALUES (1,'News','news',0,'','');
/*!40000 ALTER TABLE `aw_blog_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_cat_store`
--

DROP TABLE IF EXISTS `aw_blog_cat_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_cat_store` (
  `cat_id` smallint(6) unsigned DEFAULT NULL,
  `store_id` smallint(6) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_cat_store`
--

LOCK TABLES `aw_blog_cat_store` WRITE;
/*!40000 ALTER TABLE `aw_blog_cat_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `aw_blog_cat_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_comment`
--

DROP TABLE IF EXISTS `aw_blog_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_comment` (
  `comment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` smallint(11) NOT NULL DEFAULT '0',
  `comment` text NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '0',
  `created_time` datetime DEFAULT NULL,
  `user` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_comment`
--

LOCK TABLES `aw_blog_comment` WRITE;
/*!40000 ALTER TABLE `aw_blog_comment` DISABLE KEYS */;
/*!40000 ALTER TABLE `aw_blog_comment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_post_cat`
--

DROP TABLE IF EXISTS `aw_blog_post_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_post_cat` (
  `cat_id` smallint(6) unsigned DEFAULT NULL,
  `post_id` smallint(6) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_post_cat`
--

LOCK TABLES `aw_blog_post_cat` WRITE;
/*!40000 ALTER TABLE `aw_blog_post_cat` DISABLE KEYS */;
INSERT INTO `aw_blog_post_cat` VALUES (1,3);
/*!40000 ALTER TABLE `aw_blog_post_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_store`
--

DROP TABLE IF EXISTS `aw_blog_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_store` (
  `post_id` smallint(6) unsigned DEFAULT NULL,
  `store_id` smallint(6) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_store`
--

LOCK TABLES `aw_blog_store` WRITE;
/*!40000 ALTER TABLE `aw_blog_store` DISABLE KEYS */;
INSERT INTO `aw_blog_store` VALUES (3,1),(3,5),(3,3);
/*!40000 ALTER TABLE `aw_blog_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_tags`
--

DROP TABLE IF EXISTS `aw_blog_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL,
  `tag_count` int(11) NOT NULL DEFAULT '0',
  `store_id` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`,`tag_count`,`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_tags`
--

LOCK TABLES `aw_blog_tags` WRITE;
/*!40000 ALTER TABLE `aw_blog_tags` DISABLE KEYS */;
INSERT INTO `aw_blog_tags` VALUES (1,'',2,0);
/*!40000 ALTER TABLE `aw_blog_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(32) NOT NULL COMMENT 'Value',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captcha_log`
--

LOCK TABLES `captcha_log` WRITE;
/*!40000 ALTER TABLE `captcha_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_categs_index_idx`
--

DROP TABLE IF EXISTS `catalog_category_anc_categs_index_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_categs_index_idx` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Path',
  KEY `IDX_CATALOG_CATEGORY_ANC_CATEGS_INDEX_IDX_CATEGORY_ID` (`category_id`),
  KEY `IDX_CATALOG_CATEGORY_ANC_CATEGS_INDEX_IDX_PATH_CATEGORY_ID` (`path`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Anchor Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_categs_index_idx`
--

LOCK TABLES `catalog_category_anc_categs_index_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_categs_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_anc_categs_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_categs_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Path',
  KEY `IDX_CATALOG_CATEGORY_ANC_CATEGS_INDEX_TMP_CATEGORY_ID` (`category_id`),
  KEY `IDX_CATALOG_CATEGORY_ANC_CATEGS_INDEX_TMP_PATH_CATEGORY_ID` (`path`,`category_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Category Anchor Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_categs_index_tmp`
--

LOCK TABLES `catalog_category_anc_categs_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_products_index_idx`
--

DROP TABLE IF EXISTS `catalog_category_anc_products_index_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_products_index_idx` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  KEY `IDX_CAT_CTGR_ANC_PRDS_IDX_IDX_CTGR_ID_PRD_ID_POSITION` (`category_id`,`product_id`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Anchor Product Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_products_index_idx`
--

LOCK TABLES `catalog_category_anc_products_index_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_products_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_anc_products_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_products_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  KEY `IDX_CAT_CTGR_ANC_PRDS_IDX_TMP_CTGR_ID_PRD_ID_POSITION` (`category_id`,`product_id`,`position`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Category Anchor Product Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_products_index_tmp`
--

LOCK TABLES `catalog_category_anc_products_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attriute Set ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Time',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int(11) NOT NULL COMMENT 'Position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int(11) NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_PATH_ENTITY_ID` (`path`,`entity_id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES (1,3,0,0,'2011-10-29 22:59:09','2011-10-29 22:59:09','1',0,0,24),(2,3,3,1,'2011-10-29 22:59:09','2011-10-29 22:59:09','1/2',1,1,21),(3,3,3,2,'2011-11-06 06:49:56','2014-01-09 01:44:08','1/2/3',2,2,0),(28,3,3,2,'2011-11-12 08:38:15','2014-01-21 00:02:13','1/2/28',6,2,17),(50,3,3,2,'2011-11-13 03:12:38','2014-01-21 00:04:18','1/2/50',5,2,0),(51,3,3,2,'2011-11-13 03:40:16','2013-02-19 02:03:59','1/2/51',8,2,0),(53,3,3,28,'2011-11-14 04:27:28','2014-01-09 01:09:12','1/2/28/53',4,3,6),(61,3,3,53,'2012-05-04 22:41:38','2013-02-06 01:42:47','1/2/28/53/61',1,4,0),(62,3,3,53,'2012-05-04 22:42:59','2013-02-04 22:31:34','1/2/28/53/62',6,4,0),(63,3,3,53,'2012-05-04 22:46:13','2013-02-04 22:31:05','1/2/28/53/63',7,4,0),(64,3,3,53,'2012-05-04 22:46:51','2013-02-04 22:30:44','1/2/28/53/64',8,4,0),(65,3,3,53,'2012-05-04 22:47:26','2013-02-04 22:31:25','1/2/28/53/65',9,4,0),(67,3,3,1,'2012-05-04 22:59:00','2012-05-04 22:59:00','1/67',2,1,1),(68,3,3,67,'2012-05-04 22:59:14','2013-06-17 23:13:34','1/67/68',1,2,0),(69,3,3,28,'2012-05-04 23:22:16','2012-05-07 12:19:48','1/2/28/69',8,3,0),(87,3,3,53,'2013-02-06 22:09:24','2013-02-06 22:29:49','1/2/28/53/87',2,4,0),(94,3,3,28,'2013-06-17 07:11:50','2014-01-20 23:35:15','1/2/28/94',3,3,4),(95,3,3,28,'2013-06-17 07:12:14','2014-01-21 00:02:41','1/2/28/95',1,3,2),(99,3,3,94,'2013-06-17 07:16:36','2014-01-20 23:00:14','1/2/28/94/99',5,4,0),(101,3,3,94,'2013-06-17 07:17:16','2014-01-20 23:35:29','1/2/28/94/101',8,4,0),(102,3,3,95,'2014-01-08 02:37:36','2014-06-08 22:50:21','1/2/28/95/102',1,4,0),(103,3,3,95,'2014-01-08 02:38:02','2014-01-20 22:58:33','1/2/28/95/103',2,4,0),(104,3,3,94,'2014-01-10 03:50:53','2014-01-20 23:00:20','1/2/28/94/104',6,4,0),(106,3,3,94,'2014-01-20 23:16:54','2014-01-20 23:17:55','1/2/28/94/106',1,4,0),(107,3,3,28,'2014-08-01 23:25:45','2014-03-07 00:28:01','1/2/28/107',9,3,0);
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_CTGR_ENTT_DTIME_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1283 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_datetime` VALUES (1,3,53,0,3,NULL),(2,3,54,0,3,NULL),(121,3,53,0,28,NULL),(122,3,54,0,28,NULL),(445,3,53,0,50,NULL),(446,3,54,0,50,NULL),(483,3,53,0,51,NULL),(484,3,54,0,51,NULL),(519,3,53,0,53,NULL),(520,3,54,0,53,NULL),(763,3,53,0,61,NULL),(764,3,54,0,61,NULL),(767,3,53,0,62,NULL),(768,3,54,0,62,NULL),(771,3,53,0,63,NULL),(772,3,54,0,63,NULL),(773,3,53,0,64,NULL),(774,3,54,0,64,NULL),(775,3,53,0,65,NULL),(776,3,54,0,65,NULL),(791,3,53,0,67,NULL),(792,3,54,0,67,NULL),(793,3,53,0,68,NULL),(794,3,54,0,68,NULL),(799,3,53,0,69,NULL),(800,3,54,0,69,NULL),(1071,3,53,0,87,NULL),(1072,3,54,0,87,NULL),(1173,3,53,0,94,NULL),(1174,3,54,0,94,NULL),(1175,3,53,0,95,NULL),(1176,3,54,0,95,NULL),(1193,3,53,0,99,NULL),(1194,3,54,0,99,NULL),(1197,3,53,0,101,NULL),(1198,3,54,0,101,NULL),(1217,3,53,0,102,NULL),(1218,3,54,0,102,NULL),(1219,3,53,0,103,NULL),(1220,3,54,0,103,NULL),(1221,3,53,0,104,NULL),(1222,3,54,0,104,NULL),(1279,3,53,0,106,NULL),(1280,3,54,0,106,NULL),(1281,3,53,0,107,NULL),(1282,3,54,0,107,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_CTGR_ENTT_DEC_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_decimal`
--

LOCK TABLES `catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_decimal` VALUES (1,3,64,0,3,NULL),(25,3,64,0,28,NULL),(44,3,64,0,50,NULL),(45,3,64,0,51,NULL),(47,3,64,0,53,NULL),(54,3,64,0,61,NULL),(55,3,64,0,62,NULL),(56,3,64,0,63,NULL),(57,3,64,0,64,NULL),(58,3,64,0,65,NULL),(60,3,64,0,67,NULL),(61,3,64,0,68,NULL),(62,3,64,0,69,NULL),(141,3,64,0,87,NULL),(148,3,64,0,94,NULL),(149,3,64,0,95,NULL),(153,3,64,0,99,NULL),(155,3,64,0,101,NULL),(156,3,64,0,102,NULL),(157,3,64,0,103,NULL),(158,3,64,0,104,NULL),(160,3,64,0,106,NULL),(161,3,64,0,107,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_CTGR_ENTT_INT_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_INT_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1272 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES (1,3,61,0,1,1),(2,3,61,1,1,1),(3,3,36,0,2,1),(4,3,61,0,2,1),(5,3,36,1,2,1),(6,3,61,1,2,1),(7,3,36,0,3,0),(8,3,61,0,3,1),(9,3,44,0,3,NULL),(10,3,45,0,3,0),(11,3,62,0,3,0),(12,3,63,0,3,0),(215,3,36,0,28,1),(216,3,61,0,28,1),(217,3,44,0,28,NULL),(218,3,45,0,28,1),(219,3,62,0,28,0),(220,3,63,0,28,0),(507,3,36,0,50,1),(508,3,61,0,50,1),(509,3,44,0,50,NULL),(510,3,45,0,50,1),(511,3,62,0,50,0),(512,3,63,0,50,0),(532,3,36,0,51,0),(533,3,61,0,51,1),(534,3,44,0,51,NULL),(535,3,45,0,51,0),(536,3,62,0,51,0),(537,3,63,0,51,0),(562,3,36,0,53,1),(563,3,61,0,53,1),(564,3,44,0,53,NULL),(565,3,45,0,53,0),(566,3,62,0,53,0),(567,3,63,0,53,0),(722,3,36,0,61,1),(723,3,61,0,61,1),(724,3,44,0,61,34),(725,3,45,0,61,0),(726,3,62,0,61,0),(727,3,63,0,61,0),(730,3,36,0,62,1),(731,3,61,0,62,1),(732,3,44,0,62,NULL),(733,3,45,0,62,0),(734,3,62,0,62,0),(735,3,63,0,62,0),(738,3,36,0,63,1),(739,3,61,0,63,1),(740,3,44,0,63,NULL),(741,3,45,0,63,0),(742,3,62,0,63,0),(743,3,63,0,63,0),(745,3,36,0,64,1),(746,3,61,0,64,1),(747,3,44,0,64,NULL),(748,3,45,0,64,0),(749,3,62,0,64,0),(750,3,63,0,64,0),(752,3,36,0,65,1),(753,3,61,0,65,1),(754,3,44,0,65,NULL),(755,3,45,0,65,0),(756,3,62,0,65,0),(757,3,63,0,65,0),(767,3,36,0,67,1),(768,3,61,0,67,1),(769,3,44,0,67,NULL),(770,3,45,0,67,0),(771,3,62,0,67,0),(772,3,63,0,67,0),(774,3,36,0,68,0),(775,3,61,0,68,1),(776,3,44,0,68,NULL),(777,3,45,0,68,0),(778,3,62,0,68,0),(779,3,63,0,68,0),(783,3,36,0,69,1),(784,3,61,0,69,1),(785,3,44,0,69,NULL),(786,3,45,0,69,0),(787,3,62,0,69,0),(788,3,63,0,69,0),(939,3,36,5,50,0),(940,3,36,5,28,0),(1026,3,36,0,87,1),(1027,3,61,0,87,1),(1028,3,44,0,87,35),(1029,3,45,0,87,0),(1030,3,62,0,87,0),(1031,3,63,0,87,0),(1140,3,36,0,94,1),(1141,3,61,0,94,1),(1142,3,44,0,94,NULL),(1143,3,45,0,94,0),(1144,3,62,0,94,0),(1145,3,63,0,94,0),(1146,3,36,0,95,1),(1147,3,61,0,95,1),(1148,3,44,0,95,NULL),(1149,3,45,0,95,0),(1150,3,62,0,95,0),(1151,3,63,0,95,0),(1177,3,36,0,99,1),(1178,3,61,0,99,1),(1179,3,44,0,99,NULL),(1180,3,45,0,99,0),(1181,3,62,0,99,0),(1182,3,63,0,99,0),(1189,3,36,0,101,1),(1190,3,61,0,101,1),(1191,3,44,0,101,NULL),(1192,3,45,0,101,0),(1193,3,62,0,101,0),(1194,3,63,0,101,0),(1208,3,36,0,102,1),(1209,3,61,0,102,1),(1210,3,44,0,102,NULL),(1211,3,45,0,102,0),(1212,3,62,0,102,0),(1213,3,63,0,102,0),(1214,3,36,0,103,1),(1215,3,61,0,103,1),(1216,3,44,0,103,NULL),(1217,3,45,0,103,0),(1218,3,62,0,103,0),(1219,3,63,0,103,0),(1220,3,36,0,104,1),(1221,3,61,0,104,1),(1222,3,44,0,104,NULL),(1223,3,45,0,104,0),(1224,3,62,0,104,0),(1225,3,63,0,104,0),(1260,3,36,0,106,1),(1261,3,61,0,106,1),(1262,3,44,0,106,NULL),(1263,3,45,0,106,0),(1264,3,62,0,106,0),(1265,3,63,0,106,0),(1266,3,36,0,107,1),(1267,3,61,0,107,1),(1268,3,44,0,107,37),(1269,3,45,0,107,0),(1270,3,62,0,107,0),(1271,3,63,0,107,0);
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_CTGR_ENTT_TEXT_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2516 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_text` VALUES (1,3,59,0,1,NULL),(2,3,59,1,1,NULL),(3,3,59,0,2,NULL),(4,3,59,1,2,NULL),(5,3,38,0,3,NULL),(6,3,41,0,3,NULL),(7,3,42,0,3,NULL),(8,3,56,0,3,NULL),(9,3,59,0,3,NULL),(274,3,38,0,28,'<h2>Extensions</h2>\r\n<p>This Magento template comes with a bonus</p>\r\n<ul class=\"bullet\">\r\n  <li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/smart-catalog.html\">Smart Catalog Light</a> </strong> <br>\r\n    Smart Catalog is the first responsive configurable catalog with a toolbar for Magento.</li>\r\n<li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/smart-product-image.html\">Smart Product Image</a></strong><br>\r\n    This extension calculates product image size depending on the screen resolution and special Magento settings.</li>\r\n  <li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/custom-magento-menu.html\">Custom Magento Menu</a></strong><br>\r\n    Informative top menu for Magento. Displays all subcategories at once. </li>\r\n  <li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/back-to-top-button.html\">Back to Top button</a></strong><br>\r\n    The \'back to top\' button is a very popular tool now. Page is scrolled to top of the page with animation when you push the button.</li>\r\n    <li><strong style=\"font-size: 14px; \">LightBox2 by MageSpecialist</strong><br>\r\n   LightBox2 is a fully customizable and ready-to-use extension to take control of your products\' images.</li>\r\n <li><strong style=\"font-size: 14px; \">EasyTabs</strong><br>\r\n    We have applied unique Grayscale Full-width  style for EasyTabs Magento extensions.</li>\r\n   <li><strong style=\"font-size: 14px; \">AW blog</strong><br>\r\n    We have applied unique Grayscale Full-width style for AW blog Magento extensions.</li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Static pages and blocks</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/static-pages/highlighted-categories.html\">Highlighted categories</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/most-popular-block.html\">Most Popular block</a></li>\r\n  <li><a href=\"/blog\">AW Blog</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/1-column-page.html\">Full width</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with right bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with left bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/3-columns-page.html\">3 columns</a></li>\r\n</ul>\r\n\r\n'),(275,3,41,0,28,'free, full-width, Magento, template, eCommerce, theme, Magento template, extension'),(276,3,42,0,28,'The perfect Magento theme is best for home décor, home textiles, crafts, accessories, flowers, eco products, green products, health products, visual arts and gift shops. '),(277,3,56,0,28,NULL),(278,3,59,0,28,NULL),(787,3,38,0,50,NULL),(788,3,41,0,50,'free, full-width, Magento, template, eCommerce, theme, Magento template, extension'),(789,3,42,0,50,'New free responsive Magento template.  '),(790,3,56,0,50,'<reference name=\"content\"> <reference name=\"category.products\"> <reference name=\"product_list\"> \r\n<action method=\"setColumnWidth\"> <count>185</count> </action> \r\n<action method=\"setImageWidth\"> <size>170</size> </action> \r\n<action method=\"setImageHeight\"> <size>170</size> </action> \r\n</reference> </reference> </reference> '),(791,3,59,0,50,NULL),(831,3,38,0,51,NULL),(832,3,41,0,51,NULL),(833,3,42,0,51,NULL),(834,3,56,0,51,NULL),(835,3,59,0,51,NULL),(921,3,38,0,53,'<ul class=\"bullet\" style=\"font-size: 18px;\">\r\n <li><a href=\"./static-pages/highlighted-categories.html\"><strong>Highlighted categories</strong></a></li>\r\n<li><a href=\"./static-pages/most-popular-block.html\"><strong>Most popular block</strong></a></li>\r\n   <li><a href=\"./static-pages/1-column-page.html\"><strong>Full width</strong></a></li>\r\n  <li><a href=\"./static-pages/2-columns-with-right-bar.html\"><strong>2 columns with right bar</strong></a></li>\r\n  <li><a href=\"./static-pages/2-columns-with-left-bar.html\"><strong>2 columns with left bar</strong></a></li>\r\n  <li><a href=\"./static-pages/3-columns-page.html\"><strong>3 columns</strong></a></li>\r\n  <li><a href=\"./blog\"><strong>AW Blog</strong></a></li>\r\n</ul>'),(922,3,41,0,53,NULL),(923,3,42,0,53,NULL),(924,3,56,0,53,NULL),(925,3,59,0,53,NULL),(1479,3,38,0,61,NULL),(1480,3,41,0,61,NULL),(1481,3,42,0,61,NULL),(1482,3,56,0,61,NULL),(1483,3,59,0,61,NULL),(1488,3,38,0,62,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>'),(1489,3,41,0,62,NULL),(1490,3,42,0,62,NULL),(1491,3,56,0,62,NULL),(1492,3,59,0,62,NULL),(1497,3,38,0,63,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>'),(1498,3,41,0,63,NULL),(1499,3,42,0,63,NULL),(1500,3,56,0,63,NULL),(1501,3,59,0,63,NULL),(1502,3,38,0,64,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>'),(1503,3,41,0,64,NULL),(1504,3,42,0,64,NULL),(1505,3,56,0,64,NULL),(1506,3,59,0,64,NULL),(1507,3,38,0,65,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>'),(1508,3,41,0,65,NULL),(1509,3,42,0,65,NULL),(1510,3,56,0,65,NULL),(1511,3,59,0,65,NULL),(1543,3,38,0,67,NULL),(1544,3,41,0,67,NULL),(1545,3,42,0,67,NULL),(1546,3,56,0,67,NULL),(1547,3,59,0,67,NULL),(1548,3,38,0,68,NULL),(1549,3,41,0,68,NULL),(1550,3,42,0,68,NULL),(1551,3,56,0,68,NULL),(1552,3,59,0,68,NULL),(1561,3,38,0,69,'<h2>Deeper integration with Magenting hosting</h2><p>Get the theme with extensions rapidly installed on magenting hosting absolutely for free ( just check proper option while checkout).</p><p>All you have to do is to follow simple steps and obtain magenting.com hosting account (starting from $20/mo).</p><h2>Magenting</h2><p><a title=\"Magento hosting\" href=\"http://magenting.com\">Magenting.com</a>, a new faster, highly optimized, improved <strong>Magento hosting solution</strong>, is making it easy to create, promote, and manage online stores. Magento comes with everything you need to get your online store up and running!</p>\r\n<ul class=\"bullet\">\r\n<li><strong> Professional Magento hosting account</strong></li>\r\n<li><strong> Automatic Magento eCommerce installation</strong></li>\r\n<li><strong> Free our Magento template installation</strong></li>\r\n</ul>\r\n<p>It\'s never been easier to start selling online!</p>'),(1562,3,41,0,69,NULL),(1563,3,42,0,69,NULL),(1564,3,56,0,69,NULL),(1565,3,59,0,69,NULL),(2050,3,38,0,87,NULL),(2051,3,41,0,87,NULL),(2052,3,42,0,87,NULL),(2053,3,56,0,87,NULL),(2054,3,59,0,87,NULL),(2281,3,38,0,94,'<p>This Magento template comes with a bonus</p>\r\n<ul class=\"bullet\">\r\n  <li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/smart-catalog.html\">Smart Catalog Light</a> </strong><br>\r\n    Smart Catalog is the first responsive configurable catalog with a toolbar for Magento.</li>\r\n<li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/smart-product-image.html\">Smart Product Image</a></strong><br>\r\n    This extension calculates product image size depending on the screen resolution and special Magento settings.</li>\r\n  <li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/custom-magento-menu.html\">Custom Magento Menu</a></strong><br>\r\n    Informative top menu for Magento. Displays all subcategories at once. </li>\r\n<li><strong style=\"font-size: 14px;\"><a href=\"/magento-template-features/bonus-extensions/back-to-top-button.html\">Back to Top button</a></strong><br>\r\nPage is scrolled to top of the page when you push the button. </li>\r\n    <li><strong style=\"font-size: 14px; \">LightBox2 by MageSpecialist</strong><br>\r\n   LightBox2 is a fully customizable and ready-to-use extension to take control of your products\' images.</li>\r\n <li><strong style=\"font-size: 14px; \">EasyTabs</strong><br>\r\n    We have applied unique Grayscale 2014 style for EasyTabs Magento extensions.</li>\r\n   <li><strong style=\"font-size: 14px; \">AW blog</strong><br>\r\n    We have applied unique Grayscale 2014 style for AW blog Magento extensions.</li>\r\n </ul>'),(2282,3,41,0,94,NULL),(2283,3,42,0,94,NULL),(2284,3,56,0,94,NULL),(2285,3,59,0,94,NULL),(2286,3,38,0,95,'<ul class=\"bullet\">\r\n<li><strong>Responsive layout</strong><br>The layout of the catalog allows a varying number of products to be displayed per page depending on the size of the user\'s screen.</li>\r\n<li><strong>Configurable image size / column width</strong><br></li>\r\n<li><strong>Display Short Description</strong>: Yes / No</li>\r\n<li><strong>Configurable displaying of selected category</strong> For example:<br><a href=\"/magento-template-features/smart-catalog/clothing-format.html\">Clothing format example</a> - column width: 230; image width: 170; image height: 270.<br><a href=\"/magento-template-features/smart-catalog/small-images.html\">Small images format example</a> - column width: 120; image width: 110; image height: 110.\r\n</li>\r\n</ul>\r\n'),(2287,3,41,0,95,NULL),(2288,3,42,0,95,NULL),(2289,3,56,0,95,NULL),(2290,3,59,0,95,NULL),(2326,3,38,0,99,'<ul class=\"bullet\">\r\n<li>Display all subcategories at once.</li>\r\n<li>Customize number of columns in the drop down.</li>\r\n<li>Apply a static block at the bottom of each drop down. You can set the width of the each static block.</li>\r\n<li>Display empty categories: Yes/No.</li>\r\n<li>Feature \"Split categories left to right into columns\"</li>\r\n<li>Right-to-Left format support.</li>\r\n<li>Top offset is now defined automatically.</li>\r\n<li>Touchscreen support</li>\r\n</ul>\r\n'),(2327,3,41,0,99,NULL),(2328,3,42,0,99,NULL),(2329,3,56,0,99,NULL),(2330,3,59,0,99,NULL),(2336,3,38,0,101,'<ul class=\"bullet\">\r\n    <li><strong  style=\"font-size: 14px; \">LightBox2 by MageSpecialist</strong><br />\r\n   LightBox2 is a fully customizable and ready-to-use extension to take control of your products\' images.</li>\r\n<li><strong  style=\"font-size: 14px; \">EasyTabs</strong><br />\r\n    We have applied unique Grayscale 2014 style for EasyTabs Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">AW blog</strong><br />\r\n    We have applied unique Grayscale 2014 style for AW blog Magento extensions.</li>\r\n</ul>'),(2337,3,41,0,101,NULL),(2338,3,42,0,101,NULL),(2339,3,56,0,101,NULL),(2340,3,59,0,101,NULL),(2374,3,38,0,102,NULL),(2375,3,41,0,102,'Configurable catalog, free, full-width, Magento, template, eCommerce, theme, Magento template, extension'),(2376,3,42,0,102,NULL),(2377,3,56,0,102,'<reference name=\"content\"> <reference name=\"category.products\"> <reference name=\"product_list\"> \r\n<action method=\"setColumnWidth\"> <count>230</count> </action> \r\n<action method=\"setImageWidth\"> <size>170</size> </action> \r\n<action method=\"setImageHeight\"> <size>270</size> </action> \r\n</reference> </reference> </reference> '),(2378,3,59,0,102,NULL),(2379,3,38,0,103,NULL),(2380,3,41,0,103,NULL),(2381,3,42,0,103,NULL),(2382,3,56,0,103,'<reference name=\"content\"> <reference name=\"category.products\"> <reference name=\"product_list\"> \r\n<action method=\"setColumnWidth\"> <count>120</count> </action> \r\n<action method=\"setImageWidth\"> <size>110</size> </action> \r\n<action method=\"setImageHeight\"> <size>110</size> </action> \r\n</reference> </reference> </reference> '),(2383,3,59,0,103,NULL),(2384,3,38,0,104,'The \'back to top\' button is a very popular tool now. Page is scrolled to top of the page when you push the button. '),(2385,3,41,0,104,NULL),(2386,3,42,0,104,NULL),(2387,3,56,0,104,NULL),(2388,3,59,0,104,NULL),(2506,3,38,0,106,'This extension calculates product image size depending on the screen resolution and special Magento settings.'),(2507,3,41,0,106,NULL),(2508,3,42,0,106,NULL),(2509,3,56,0,106,NULL),(2510,3,59,0,106,NULL),(2511,3,38,0,107,NULL),(2512,3,41,0,107,NULL),(2513,3,42,0,107,NULL),(2514,3,56,0,107,'<reference name=\"header\">\r\n    <block type=\"cms/block\" name=\"home_page_header_block\">\r\n        <action method=\"setBlockId\">\r\n            <block_id>home_page_header_block</block_id>\r\n        </action>\r\n    </block>\r\n</reference>\r\n<reference name=\"head\">\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/jquery-1.5.2.min.js</name>\r\n    </action>\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/noconflict.js</name>\r\n    </action>\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/cycle-fade-effect.js</name>\r\n    </action>\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/jquery.standardSlider.js</name>\r\n    </action>\r\n    <action method=\"addCss\">\r\n        <stylesheet>css/slider.css</stylesheet>\r\n    </action>\r\n</reference>'),(2515,3,59,0,107,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_CTGR_ENTT_VCHR_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2512 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES (1,3,35,0,1,'Root Catalog'),(2,3,35,1,1,'Root Catalog'),(3,3,37,1,1,'root-catalog'),(4,3,35,0,2,'Default Category'),(5,3,35,1,2,'Default Category'),(6,3,43,1,2,'PRODUCTS'),(7,3,37,1,2,'default-category'),(8,3,35,0,3,'Popular Products'),(9,3,37,0,3,'popular-products'),(10,3,40,0,3,NULL),(11,3,43,0,3,'PRODUCTS'),(12,3,52,0,3,NULL),(13,3,55,0,3,NULL),(14,3,51,1,3,'popular-products.html'),(15,3,51,0,3,'popular-products.html'),(327,3,35,0,28,'Template features'),(328,3,37,0,28,'magento-template-features'),(329,3,40,0,28,'Grayscale Free full-width Magento Template - Magento eCommerce - Magento Template Features'),(330,3,43,0,28,'PAGE'),(331,3,52,0,28,NULL),(332,3,55,0,28,'three_columns'),(333,3,51,1,28,'magento-template-features.html'),(334,3,51,0,28,'magento-template-features.html'),(871,3,35,0,50,'Category'),(872,3,37,0,50,'grayscale-magento-template'),(873,3,40,0,50,'Grayscale Free full-width Magento Template - Magento eCommerce - Magento Template Features'),(874,3,43,0,50,'PRODUCTS'),(875,3,52,0,50,NULL),(876,3,55,0,50,NULL),(877,3,51,1,50,'grayscale-magento-template.html'),(878,3,51,0,50,'grayscale-magento-template.html'),(914,3,39,0,50,NULL),(918,3,35,0,51,'Home Tabs 01'),(919,3,37,0,51,'home-tabs'),(920,3,40,0,51,NULL),(921,3,43,0,51,'PRODUCTS'),(922,3,52,0,51,NULL),(923,3,55,0,51,NULL),(924,3,51,1,51,'home-tabs.html'),(925,3,51,0,51,'home-tabs.html'),(983,3,35,0,53,'Static pages and blocks'),(984,3,37,0,53,'static-pages'),(985,3,40,0,53,NULL),(986,3,43,0,53,'PAGE'),(987,3,52,0,53,NULL),(988,3,55,0,53,NULL),(989,3,51,1,53,'magento-template-features/static-pages.html'),(990,3,51,0,53,'magento-template-features/static-pages.html'),(1352,3,35,0,61,'Highlighted categories'),(1353,3,37,0,61,'highlighted-categories'),(1354,3,40,0,61,NULL),(1355,3,43,0,61,'PAGE'),(1356,3,52,0,61,NULL),(1357,3,55,0,61,NULL),(1358,3,51,1,61,'magento-template-features/static-pages/highlighted-categories.html'),(1359,3,51,0,61,'magento-template-features/static-pages/highlighted-categories.html'),(1364,3,35,0,62,'Full-width page'),(1365,3,37,0,62,'1-column-page'),(1366,3,40,0,62,NULL),(1367,3,43,0,62,'PAGE'),(1368,3,52,0,62,NULL),(1369,3,55,0,62,'one_column'),(1370,3,51,1,62,'magento-template-features/static-pages/1-column-page.html'),(1371,3,51,0,62,'magento-template-features/static-pages/1-column-page.html'),(1375,3,35,0,63,'2 columns with left bar'),(1376,3,37,0,63,'2-columns-with-left-bar'),(1377,3,40,0,63,NULL),(1378,3,43,0,63,'PAGE'),(1379,3,52,0,63,NULL),(1380,3,55,0,63,'two_columns_left'),(1381,3,51,1,63,'magento-template-features/static-pages/2-columns-with-left-bar.html'),(1382,3,51,0,63,'magento-template-features/static-pages/2-columns-with-left-bar.html'),(1383,3,35,0,64,'2 columns with right bar'),(1384,3,37,0,64,'2-columns-with-right-bar'),(1385,3,40,0,64,NULL),(1386,3,43,0,64,'PAGE'),(1387,3,52,0,64,NULL),(1388,3,55,0,64,'two_columns_right'),(1389,3,51,1,64,'magento-template-features/static-pages/2-columns-with-right-bar.html'),(1390,3,51,0,64,'magento-template-features/static-pages/2-columns-with-right-bar.html'),(1391,3,35,0,65,'3 columns page'),(1392,3,37,0,65,'3-columns-page'),(1393,3,40,0,65,NULL),(1394,3,43,0,65,'PAGE'),(1395,3,52,0,65,NULL),(1396,3,55,0,65,'three_columns'),(1397,3,51,1,65,'magento-template-features/static-pages/3-columns-page.html'),(1398,3,51,0,65,'magento-template-features/static-pages/3-columns-page.html'),(1431,3,35,0,67,'Empty root catalog'),(1432,3,37,0,67,'empty-root-catalog'),(1433,3,40,0,67,NULL),(1434,3,43,0,67,'PRODUCTS'),(1435,3,52,0,67,NULL),(1436,3,55,0,67,NULL),(1437,3,35,0,68,'Empty'),(1438,3,37,0,68,'empty'),(1439,3,40,0,68,NULL),(1440,3,43,0,68,'PRODUCTS'),(1441,3,52,0,68,NULL),(1442,3,55,0,68,NULL),(1444,3,51,0,68,'empty.html'),(1451,3,35,0,69,'Free installation on a special Magento hosting'),(1452,3,37,0,69,'get-installed-store-on-our-magento-hosting'),(1453,3,40,0,69,NULL),(1454,3,43,0,69,'PAGE'),(1455,3,52,0,69,NULL),(1456,3,55,0,69,NULL),(1457,3,51,1,69,'magento-template-features/get-installed-store-on-our-magento-hosting.html'),(1458,3,51,0,69,'magento-template-features/get-installed-store-on-our-magento-hosting.html'),(1846,3,51,5,50,'grayscale-magento-template.html'),(1847,3,51,5,28,'magento-template-features.html'),(2027,3,35,0,87,'Most Popular block'),(2028,3,37,0,87,'most-popular-block'),(2029,3,40,0,87,NULL),(2030,3,43,0,87,'PAGE'),(2031,3,52,0,87,NULL),(2032,3,55,0,87,'one_column'),(2033,3,51,1,87,'magento-template-features/static-pages/most-popular-block.html'),(2034,3,51,0,87,'magento-template-features/static-pages/most-popular-block.html'),(2285,3,35,0,94,'Bonus Extensions'),(2286,3,37,0,94,'bonus-extensions'),(2287,3,40,0,94,NULL),(2288,3,43,0,94,'PAGE'),(2289,3,52,0,94,NULL),(2290,3,55,0,94,'three_columns'),(2291,3,51,1,94,'magento-template-features/bonus-extensions.html'),(2292,3,51,0,94,'magento-template-features/bonus-extensions.html'),(2293,3,35,0,95,'Smart Catalog Light'),(2294,3,37,0,95,'smart-catalog'),(2295,3,40,0,95,'Smart Catalog, Grayscale Free full-width Magento Template - Magento eCommerce - Magento Template Features'),(2296,3,43,0,95,'PAGE'),(2297,3,52,0,95,NULL),(2298,3,55,0,95,'three_columns'),(2299,3,51,1,95,'magento-template-features/smart-catalog.html'),(2300,3,51,0,95,'magento-template-features/smart-catalog.html'),(2342,3,35,0,99,'Custom Magento Menu'),(2343,3,37,0,99,'custom-magento-menu'),(2344,3,40,0,99,NULL),(2345,3,43,0,99,'PAGE'),(2346,3,52,0,99,NULL),(2347,3,55,0,99,'three_columns'),(2348,3,51,1,99,'magento-template-features/bonus-extensions/custom-magento-menu.html'),(2349,3,51,0,99,'magento-template-features/bonus-extensions/custom-magento-menu.html'),(2358,3,35,0,101,'Third-party free extensions'),(2359,3,37,0,101,'third-party-extensions'),(2360,3,40,0,101,NULL),(2361,3,43,0,101,'PAGE'),(2362,3,52,0,101,NULL),(2363,3,55,0,101,'three_columns'),(2364,3,51,1,101,'magento-template-features/bonus-extensions/third-party-extensions.html'),(2365,3,51,0,101,'magento-template-features/bonus-extensions/third-party-extensions.html'),(2394,3,35,0,102,' Clothing format'),(2395,3,37,0,102,'clothing-format'),(2396,3,40,0,102,'Free Magento Themes and Templates'),(2397,3,43,0,102,'PRODUCTS'),(2398,3,52,0,102,NULL),(2399,3,55,0,102,'three_columns'),(2400,3,51,1,102,'magento-template-features/smart-catalog/clothing-format.html'),(2401,3,51,0,102,'magento-template-features/smart-catalog/clothing-format.html'),(2402,3,35,0,103,'Small images'),(2403,3,37,0,103,'small-images'),(2404,3,40,0,103,NULL),(2405,3,43,0,103,'PRODUCTS'),(2406,3,52,0,103,NULL),(2407,3,55,0,103,'three_columns'),(2408,3,51,1,103,'magento-template-features/smart-catalog/small-images.html'),(2409,3,51,0,103,'magento-template-features/smart-catalog/small-images.html'),(2410,3,35,0,104,'Back to Top Button'),(2411,3,37,0,104,'back-to-top-button'),(2412,3,40,0,104,NULL),(2413,3,43,0,104,'PAGE'),(2414,3,52,0,104,NULL),(2415,3,55,0,104,'three_columns'),(2416,3,51,1,104,'magento-template-features/bonus-extensions/back-to-top-button.html'),(2417,3,51,0,104,'magento-template-features/bonus-extensions/back-to-top-button.html'),(2496,3,35,0,106,'Smart Product Image'),(2497,3,37,0,106,'smart-product-image'),(2498,3,40,0,106,NULL),(2499,3,43,0,106,'PAGE'),(2500,3,52,0,106,NULL),(2501,3,55,0,106,'three_columns'),(2502,3,51,1,106,'magento-template-features/bonus-extensions/smart-product-image.html'),(2503,3,51,0,106,'magento-template-features/bonus-extensions/smart-product-image.html'),(2504,3,35,0,107,'Fixed-width example'),(2505,3,37,0,107,'fixed-width-example'),(2506,3,40,0,107,NULL),(2507,3,43,0,107,'PAGE'),(2508,3,52,0,107,NULL),(2509,3,55,0,107,'three_columns'),(2510,3,51,1,107,'magento-template-features/fixed-width-example.html'),(2511,3,51,0,107,'magento-template-features/fixed-width-example.html');
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_1`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_1` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'entity_id',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'parent_id',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'created_at',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'updated_at',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'path',
  `position` int(11) NOT NULL COMMENT 'position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'level',
  `children_count` int(11) NOT NULL COMMENT 'children_count',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `all_children` text COMMENT 'All Children',
  `available_sort_by` text COMMENT 'Available Product Listing Sort By',
  `children` text COMMENT 'Children',
  `custom_apply_to_products` int(11) DEFAULT NULL COMMENT 'Apply To Products',
  `custom_design` varchar(255) DEFAULT NULL COMMENT 'Custom Design',
  `custom_design_from` datetime DEFAULT NULL COMMENT 'Active From',
  `custom_design_to` datetime DEFAULT NULL COMMENT 'Active To',
  `custom_layout_update` text COMMENT 'Custom Layout Update',
  `custom_use_parent_settings` int(11) DEFAULT NULL COMMENT 'Use Parent Category Settings',
  `default_sort_by` varchar(255) DEFAULT NULL COMMENT 'Default Product Listing Sort By',
  `description` text COMMENT 'Description',
  `display_mode` varchar(255) DEFAULT NULL COMMENT 'Display Mode',
  `filter_price_range` decimal(12,4) DEFAULT NULL COMMENT 'Layered Navigation Price Step',
  `image` varchar(255) DEFAULT NULL COMMENT 'Image',
  `include_in_menu` int(11) DEFAULT NULL COMMENT 'Include in Navigation Menu',
  `is_active` int(11) DEFAULT NULL COMMENT 'Is Active',
  `is_anchor` int(11) DEFAULT NULL COMMENT 'Is Anchor',
  `landing_page` int(11) DEFAULT NULL COMMENT 'CMS Block',
  `meta_description` text COMMENT 'Meta Description',
  `meta_keywords` text COMMENT 'Meta Keywords',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `page_layout` varchar(255) DEFAULT NULL COMMENT 'Page Layout',
  `path_in_store` text COMMENT 'Path In Store',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Image',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'URL Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_1_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_1_PATH` (`path`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_1_LEVEL` (`level`),
  CONSTRAINT `FK_CATALOG_CATEGORY_FLAT_STORE_1_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_FLAT_STORE_1_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Flat (Store 1)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_1`
--

LOCK TABLES `catalog_category_flat_store_1` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_1` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_1` VALUES (1,0,'2011-10-29 22:59:09','2011-10-29 22:59:09','1',0,0,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'Root Catalog',NULL,NULL,NULL,NULL,NULL),(2,1,'2011-10-29 22:59:09','2011-10-29 22:59:09','1/2',1,1,77,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'Default Category',NULL,NULL,NULL,NULL,NULL),(3,2,'2011-11-06 06:49:56','2013-02-18 05:31:04','1/2/3',2,2,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PRODUCTS',NULL,NULL,1,0,0,NULL,NULL,NULL,NULL,'Popular Products',NULL,NULL,NULL,'popular-products','popular-products.html'),(28,2,'2011-11-12 08:38:15','2013-04-04 00:16:26','1/2/28',6,2,30,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>Extensions</h2>\r\n<p>This Magento template comes with a bonus</p>\r\n<ul class=\"bullet\">\r\n  <li><strong  style=\"font-size: 14px; \">One Page Magento Checkout</strong> (worth $169)<br />\r\n    A fast, lightweight and easy to setup Magento One Page Checkout Extension.</li>\r\n  <li><strong  style=\"font-size: 14px;\">Shipping Price Calculator</strong> (worth $30).<br />\r\n    With this useful Magento Extension you can now provide rates live on your store for different shipping methods with their associated costs.</li>\r\n<li><strong  style=\"font-size: 14px; \">Stylish Stores/Languages Switcher</strong> (worth $30)<br />\r\n    This is a simple and stylish stores and languages switch. The languages switch can be in the form of flags or text tabs.</li>\r\n <li><strong  style=\"font-size: 14px;\">Custom Magento Menu</strong><br />\r\n    Informative top menu for Magento. Displays all subcategories at once.</li>\r\n    <li><strong  style=\"font-size: 14px;\">EM Quickshop</strong><br />\r\n    Magento extension allow to quickly view product details on the same page. We have applied unique LightShop Green style for EM Quickshop.</li>\r\n  <li><strong  style=\"font-size: 14px; \">EasyTabs</strong><br />\r\n    We have applied unique LightShop Green style for EasyTabs Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">Quick Feedback</strong><br />\r\n    We have applied unique LightShop Green style for Quick Feedback Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">AW blog</strong><br />\r\n    We have applied unique LightShop Green style for AW blog Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">ShareThis</strong><br />\r\n    offers the most innovative sharing platform for today\'s social audience.</li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Home Page Variants</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/home-page-variants/home-page-v2.html\">Home page v2</a></li>\r\n  <li><a href=\"/magento-template-features/home-page-variants/home-page-v3.html\">Home page v3</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Slider Manager</h2>\r\n<h3>Without touching any code you can create multiple sliders that can be included anywhere using the Magento backend.</h3>\r\n<p>Slider Manager is a perfect feature to demonstrate advertising and promotional story building of an image with a title and link for each slide or any HTML content. The user adds images to the slider by uploading them as attachments.</p>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n<li><a href=\"/magento-template-features/slider-manager/amanda-slider.html\">Amanda Slider</a></li>\r\n  <li><a href=\"/magento-template-features/slider-manager/samanta-slider.html\">Samanta Slider</a></li>\r\n  <li><a href=\"/magento-template-features/slider-manager/trisha-slider.html\">Trisha Slider</a></li>\r\n  <li><a href=\"/magento-template-features/slider-manager/krista-slider.html\">Krista Slider</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Test Category</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/test-category/category-big-images.html\">Category with Big Images</a></li>\r\n  <li><a href=\"/magento-template-features/test-category/category-long-title-medium.html\">Category with Medium Images</a></li>\r\n  <li><a href=\"/magento-template-features/test-category/category-small-images.html\">Category with Small Images</a></li>\r\n  <li><a href=\"/magento-template-features/test-category/clothing-format.html\">Clothing Format</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Static pages and blocks</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/static-pages/highlighted-categories.html\">Highlighted categories</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/most-popular-block.html\">Most Popular block</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/testimonials.html\">Testimonials</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-and-events.html\">News</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-details.html\">News Details</a></li>\r\n  <li><a href=\"/blog\">AW Blog</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/1-column-page.html\">Full width</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with right bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with left bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/3-columns-page.html\">3 columns</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Backgrounds and Buttons</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/backgrounds.html\">Backgrounds and Buttons</a></li>\r\n</ul>\r\n','PAGE',NULL,NULL,1,1,1,NULL,'The perfect Magento theme is best for home décor, home textiles, crafts, accessories, flowers, eco products, green products, health products, visual arts and gift shops. ','Magento, template, eCommerce, theme, Magento template, extension, crafts, home décor, home textiles, accessories, flowers, eco products, green products, health products, visual arts, gift ','LightShop GreenMagento Template - Magento eCommerce - Magento Template Features','Template features',NULL,NULL,NULL,'magento-template-features','magento-template-features.html'),(50,2,'2011-11-13 03:12:38','2013-02-17 03:08:03','1/2/50',5,2,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<div class=\"three_images clearfix\">\r\n<div class=\"b01\"><a class=\"title\" href=\"/magento-template-features/static-pages/highlighted-categories.html\" title=\"Home Textile Magento Template\"><img src=\"{{media url=\"template/kids_magento_template01.jpg\"}}\" alt=\"Home Textile Magento Template\" /></a> \r\n</div>\r\n<div class=\"b02\"><a class=\"title\" href=\"/magento-template-features/static-pages/highlighted-categories.html\"><img src=\"{{media url=\"template/kids_magento_template02.jpg\"}}\" alt=\"Kids Magento Template\" /></a> \r\n</div>\r\n<div class=\"b03\"><a class=\"title\" href=\"/magento-template-features/static-pages/highlighted-categories.html\"><img src=\"{{media url=\"template/kids_magento_template03.jpg\"}}\" alt=\"Kids Magento Template\" /></a> \r\n</div>\r\n</div>\r\n<p>Kids Magento Template. Kids Magento theme. Magento Template for Baby Products, Apparel & Accessories, Baby & Toddler Toys, Baby Stationery, Diapering, Gifts, Nursery, Pregnancy & Maternity.</p>','PRODUCTS',NULL,NULL,1,1,0,NULL,'LightShop Green Magento Template. Kids Magento Template. Kids Magento theme. Magento Template for Baby Products, Apparel & Accessories, Baby & Toddler Toys, Baby Stationery, Diapering, Gifts, Nursery, Pregnancy & Maternity.','Magento, template, eCommerce, theme, Magento template, extension, crafts, home décor, home textiles, accessories, flowers, eco products, green products, health products, visual arts, gift ','LightShop Green Magento Template. Kids Magento Template.','Kids',NULL,NULL,NULL,'kids-magento-template','kids-magento-template.html'),(51,2,'2011-11-13 03:40:16','2013-02-19 02:03:59','1/2/51',8,2,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PRODUCTS',NULL,NULL,1,0,0,NULL,NULL,NULL,NULL,'Home Tabs 01',NULL,NULL,NULL,'home-tabs','home-tabs.html'),(53,28,'2011-11-14 04:27:28','2013-04-03 23:00:47','1/2/28/53',4,3,9,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<ul class=\"bullet\" style=\"font-size: 18px;\">\r\n  <li><a href=\"/magento-template-features/static-pages/highlighted-categories.html\">Highlighted categories</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/most-popular-block.html\">Most Popular block</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/testimonials.html\">Testimonials</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-and-events.html\">News</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-details.html\">News Details</a></li>\r\n  <li><a href=\"/blog\">AW Blog</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/1-column-page.html\">Full width</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with right bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with left bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/3-columns-page.html\">3 columns</a></li>\r\n</ul>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'Static pages and blocks',NULL,NULL,NULL,'static-pages','magento-template-features/static-pages.html'),(61,53,'2012-05-04 22:41:38','2013-02-06 01:42:47','1/2/28/53/61',1,4,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PAGE',NULL,NULL,1,1,0,34,NULL,NULL,NULL,'Highlighted categories',NULL,NULL,NULL,'highlighted-categories','magento-template-features/static-pages/highlighted-categories.html'),(62,53,'2012-05-04 22:42:59','2013-02-04 22:31:34','1/2/28/53/62',6,4,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'Full-width page','one_column',NULL,NULL,'1-column-page','magento-template-features/static-pages/1-column-page.html'),(63,53,'2012-05-04 22:46:13','2013-02-04 22:31:05','1/2/28/53/63',7,4,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'2 columns with left bar','two_columns_left',NULL,NULL,'2-columns-with-left-bar','magento-template-features/static-pages/2-columns-with-left-bar.html'),(64,53,'2012-05-04 22:46:51','2013-02-04 22:30:44','1/2/28/53/64',8,4,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'2 columns with right bar','two_columns_right',NULL,NULL,'2-columns-with-right-bar','magento-template-features/static-pages/2-columns-with-right-bar.html'),(65,53,'2012-05-04 22:47:26','2013-02-04 22:31:25','1/2/28/53/65',9,4,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'3 columns page','three_columns',NULL,NULL,'3-columns-page','magento-template-features/static-pages/3-columns-page.html'),(69,28,'2012-05-04 23:22:16','2012-05-07 12:19:48','1/2/28/69',6,3,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>Deeper integration with Magenting hosting</h2><p>Get the theme with extensions rapidly installed on magenting hosting absolutely for free ( just check proper option while checkout).</p><p>All you have to do is to follow simple steps and obtain magenting.com hosting account (starting from $20/mo).</p><h2>Magenting</h2><p><a title=\"Magento hosting\" href=\"http://magenting.com\">Magenting.com</a>, a new faster, highly optimized, improved <strong>Magento hosting solution</strong>, is making it easy to create, promote, and manage online stores. Magento comes with everything you need to get your online store up and running!</p>\r\n<ul class=\"bullet\">\r\n<li><strong> Professional Magento hosting account</strong></li>\r\n<li><strong> Automatic Magento eCommerce installation</strong></li>\r\n<li><strong> Free our Magento template installation</strong></li>\r\n</ul>\r\n<p>It\'s never been easier to start selling online!</p>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'Free installation on a special Magento hosting',NULL,NULL,NULL,'get-installed-store-on-our-magento-hosting','magento-template-features/get-installed-store-on-our-magento-hosting.html'),(87,53,'2013-02-06 22:09:24','2013-02-06 22:29:49','1/2/28/53/87',2,4,0,1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PAGE',NULL,NULL,1,1,0,35,NULL,NULL,NULL,'Most Popular block','one_column',NULL,NULL,'most-popular-block','magento-template-features/static-pages/most-popular-block.html');
/*!40000 ALTER TABLE `catalog_category_flat_store_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_2`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_2` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'entity_id',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'parent_id',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'created_at',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'updated_at',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'path',
  `position` int(11) NOT NULL COMMENT 'position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'level',
  `children_count` int(11) NOT NULL COMMENT 'children_count',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `all_children` text COMMENT 'All Children',
  `available_sort_by` text COMMENT 'Available Product Listing Sort By',
  `children` text COMMENT 'Children',
  `custom_apply_to_products` int(11) DEFAULT NULL COMMENT 'Apply To Products',
  `custom_design` varchar(255) DEFAULT NULL COMMENT 'Custom Design',
  `custom_design_from` datetime DEFAULT NULL COMMENT 'Active From',
  `custom_design_to` datetime DEFAULT NULL COMMENT 'Active To',
  `custom_layout_update` text COMMENT 'Custom Layout Update',
  `custom_use_parent_settings` int(11) DEFAULT NULL COMMENT 'Use Parent Category Settings',
  `default_sort_by` varchar(255) DEFAULT NULL COMMENT 'Default Product Listing Sort By',
  `description` text COMMENT 'Description',
  `display_mode` varchar(255) DEFAULT NULL COMMENT 'Display Mode',
  `filter_price_range` int(11) DEFAULT NULL COMMENT 'Layered Navigation Price Step',
  `image` varchar(255) DEFAULT NULL COMMENT 'Image',
  `include_in_menu` int(11) DEFAULT NULL COMMENT 'Include in Navigation Menu',
  `is_active` int(11) DEFAULT NULL COMMENT 'Is Active',
  `is_anchor` int(11) DEFAULT NULL COMMENT 'Is Anchor',
  `landing_page` int(11) DEFAULT NULL COMMENT 'CMS Block',
  `meta_description` text COMMENT 'Meta Description',
  `meta_keywords` text COMMENT 'Meta Keywords',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `page_layout` varchar(255) DEFAULT NULL COMMENT 'Page Layout',
  `path_in_store` text COMMENT 'Path In Store',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Image',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'URL Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_2_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_2_PATH` (`path`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_2_LEVEL` (`level`),
  CONSTRAINT `FK_CATALOG_CATEGORY_FLAT_STORE_2_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_FLAT_STORE_2_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Flat (Store 2)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_2`
--

LOCK TABLES `catalog_category_flat_store_2` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_flat_store_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_3`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_3` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'entity_id',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'parent_id',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'created_at',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'updated_at',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'path',
  `position` int(11) NOT NULL COMMENT 'position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'level',
  `children_count` int(11) NOT NULL COMMENT 'children_count',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `all_children` text COMMENT 'All Children',
  `available_sort_by` text COMMENT 'Available Product Listing Sort By',
  `children` text COMMENT 'Children',
  `custom_apply_to_products` int(11) DEFAULT NULL COMMENT 'Apply To Products',
  `custom_design` varchar(255) DEFAULT NULL COMMENT 'Custom Design',
  `custom_design_from` datetime DEFAULT NULL COMMENT 'Active From',
  `custom_design_to` datetime DEFAULT NULL COMMENT 'Active To',
  `custom_layout_update` text COMMENT 'Custom Layout Update',
  `custom_use_parent_settings` int(11) DEFAULT NULL COMMENT 'Use Parent Category Settings',
  `default_sort_by` varchar(255) DEFAULT NULL COMMENT 'Default Product Listing Sort By',
  `description` text COMMENT 'Description',
  `display_mode` varchar(255) DEFAULT NULL COMMENT 'Display Mode',
  `filter_price_range` decimal(12,4) DEFAULT NULL COMMENT 'Layered Navigation Price Step',
  `image` varchar(255) DEFAULT NULL COMMENT 'Image',
  `include_in_menu` int(11) DEFAULT NULL COMMENT 'Include in Navigation Menu',
  `is_active` int(11) DEFAULT NULL COMMENT 'Is Active',
  `is_anchor` int(11) DEFAULT NULL COMMENT 'Is Anchor',
  `landing_page` int(11) DEFAULT NULL COMMENT 'CMS Block',
  `meta_description` text COMMENT 'Meta Description',
  `meta_keywords` text COMMENT 'Meta Keywords',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `page_layout` varchar(255) DEFAULT NULL COMMENT 'Page Layout',
  `path_in_store` text COMMENT 'Path In Store',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Image',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'URL Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_3_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_3_PATH` (`path`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_3_LEVEL` (`level`),
  CONSTRAINT `FK_CATALOG_CATEGORY_FLAT_STORE_3_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_FLAT_STORE_3_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Flat (Store 3)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_3`
--

LOCK TABLES `catalog_category_flat_store_3` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_3` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_flat_store_3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_5`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_5` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'entity_id',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'parent_id',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'created_at',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'updated_at',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'path',
  `position` int(11) NOT NULL COMMENT 'position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'level',
  `children_count` int(11) NOT NULL COMMENT 'children_count',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `all_children` text COMMENT 'All Children',
  `available_sort_by` text COMMENT 'Available Product Listing Sort By',
  `children` text COMMENT 'Children',
  `custom_apply_to_products` int(11) DEFAULT NULL COMMENT 'Apply To Products',
  `custom_design` varchar(255) DEFAULT NULL COMMENT 'Custom Design',
  `custom_design_from` datetime DEFAULT NULL COMMENT 'Active From',
  `custom_design_to` datetime DEFAULT NULL COMMENT 'Active To',
  `custom_layout_update` text COMMENT 'Custom Layout Update',
  `custom_use_parent_settings` int(11) DEFAULT NULL COMMENT 'Use Parent Category Settings',
  `default_sort_by` varchar(255) DEFAULT NULL COMMENT 'Default Product Listing Sort By',
  `description` text COMMENT 'Description',
  `display_mode` varchar(255) DEFAULT NULL COMMENT 'Display Mode',
  `filter_price_range` decimal(12,4) DEFAULT NULL COMMENT 'Layered Navigation Price Step',
  `image` varchar(255) DEFAULT NULL COMMENT 'Image',
  `include_in_menu` int(11) DEFAULT NULL COMMENT 'Include in Navigation Menu',
  `is_active` int(11) DEFAULT NULL COMMENT 'Is Active',
  `is_anchor` int(11) DEFAULT NULL COMMENT 'Is Anchor',
  `landing_page` int(11) DEFAULT NULL COMMENT 'CMS Block',
  `meta_description` text COMMENT 'Meta Description',
  `meta_keywords` text COMMENT 'Meta Keywords',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `page_layout` varchar(255) DEFAULT NULL COMMENT 'Page Layout',
  `path_in_store` text COMMENT 'Path In Store',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Image',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'URL Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_5_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_5_PATH` (`path`),
  KEY `IDX_CATALOG_CATEGORY_FLAT_STORE_5_LEVEL` (`level`),
  CONSTRAINT `FK_CATALOG_CATEGORY_FLAT_STORE_5_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_FLAT_STORE_5_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Flat (Store 5)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_5`
--

LOCK TABLES `catalog_category_flat_store_5` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_5` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_5` VALUES (1,0,'2011-10-29 22:59:09','2011-10-29 22:59:09','1',0,0,80,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'Root Catalog',NULL,NULL,NULL,NULL,NULL),(2,1,'2011-10-29 22:59:09','2011-10-29 22:59:09','1/2',1,1,77,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'Default Category',NULL,NULL,NULL,NULL,NULL),(3,2,'2011-11-06 06:49:56','2013-02-18 05:31:04','1/2/3',2,2,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PRODUCTS',NULL,NULL,1,0,0,NULL,NULL,NULL,NULL,'Popular Products',NULL,NULL,NULL,'popular-products','popular-products.html'),(28,2,'2011-11-12 08:38:15','2013-04-04 00:16:26','1/2/28',6,2,30,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>Extensions</h2>\r\n<p>This Magento template comes with a bonus</p>\r\n<ul class=\"bullet\">\r\n  <li><strong  style=\"font-size: 14px; \">One Page Magento Checkout</strong> (worth $169)<br />\r\n    A fast, lightweight and easy to setup Magento One Page Checkout Extension.</li>\r\n  <li><strong  style=\"font-size: 14px;\">Shipping Price Calculator</strong> (worth $30).<br />\r\n    With this useful Magento Extension you can now provide rates live on your store for different shipping methods with their associated costs.</li>\r\n<li><strong  style=\"font-size: 14px; \">Stylish Stores/Languages Switcher</strong> (worth $30)<br />\r\n    This is a simple and stylish stores and languages switch. The languages switch can be in the form of flags or text tabs.</li>\r\n <li><strong  style=\"font-size: 14px;\">Custom Magento Menu</strong><br />\r\n    Informative top menu for Magento. Displays all subcategories at once.</li>\r\n    <li><strong  style=\"font-size: 14px;\">EM Quickshop</strong><br />\r\n    Magento extension allow to quickly view product details on the same page. We have applied unique LightShop Green style for EM Quickshop.</li>\r\n  <li><strong  style=\"font-size: 14px; \">EasyTabs</strong><br />\r\n    We have applied unique LightShop Green style for EasyTabs Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">Quick Feedback</strong><br />\r\n    We have applied unique LightShop Green style for Quick Feedback Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">AW blog</strong><br />\r\n    We have applied unique LightShop Green style for AW blog Magento extensions.</li>\r\n  <li><strong  style=\"font-size: 14px; \">ShareThis</strong><br />\r\n    offers the most innovative sharing platform for today\'s social audience.</li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Home Page Variants</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/home-page-variants/home-page-v2.html\">Home page v2</a></li>\r\n  <li><a href=\"/magento-template-features/home-page-variants/home-page-v3.html\">Home page v3</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Slider Manager</h2>\r\n<h3>Without touching any code you can create multiple sliders that can be included anywhere using the Magento backend.</h3>\r\n<p>Slider Manager is a perfect feature to demonstrate advertising and promotional story building of an image with a title and link for each slide or any HTML content. The user adds images to the slider by uploading them as attachments.</p>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n<li><a href=\"/magento-template-features/slider-manager/amanda-slider.html\">Amanda Slider</a></li>\r\n  <li><a href=\"/magento-template-features/slider-manager/samanta-slider.html\">Samanta Slider</a></li>\r\n  <li><a href=\"/magento-template-features/slider-manager/trisha-slider.html\">Trisha Slider</a></li>\r\n  <li><a href=\"/magento-template-features/slider-manager/krista-slider.html\">Krista Slider</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Test Category</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/test-category/category-big-images.html\">Category with Big Images</a></li>\r\n  <li><a href=\"/magento-template-features/test-category/category-long-title-medium.html\">Category with Medium Images</a></li>\r\n  <li><a href=\"/magento-template-features/test-category/category-small-images.html\">Category with Small Images</a></li>\r\n  <li><a href=\"/magento-template-features/test-category/clothing-format.html\">Clothing Format</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Static pages and blocks</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/static-pages/highlighted-categories.html\">Highlighted categories</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/most-popular-block.html\">Most Popular block</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/testimonials.html\">Testimonials</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-and-events.html\">News</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-details.html\">News Details</a></li>\r\n  <li><a href=\"/blog\">AW Blog</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/1-column-page.html\">Full width</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with right bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with left bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/3-columns-page.html\">3 columns</a></li>\r\n</ul>\r\n<hr style=\"margin-top: 30px; margin-bottom: 30px;\"/>\r\n<h2>Backgrounds and Buttons</h2>\r\n<ul class=\"bullet\" style=\"font-size: 14px;\">\r\n  <li><a href=\"/magento-template-features/backgrounds.html\">Backgrounds and Buttons</a></li>\r\n</ul>\r\n','PAGE',NULL,NULL,1,0,1,NULL,'The perfect Magento theme is best for home décor, home textiles, crafts, accessories, flowers, eco products, green products, health products, visual arts and gift shops. ','Magento, template, eCommerce, theme, Magento template, extension, crafts, home décor, home textiles, accessories, flowers, eco products, green products, health products, visual arts, gift ','LightShop GreenMagento Template - Magento eCommerce - Magento Template Features','Template features',NULL,NULL,NULL,'magento-template-features','magento-template-features.html'),(50,2,'2011-11-13 03:12:38','2013-02-17 03:08:03','1/2/50',5,2,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<div class=\"three_images clearfix\">\r\n<div class=\"b01\"><a class=\"title\" href=\"/magento-template-features/static-pages/highlighted-categories.html\" title=\"Home Textile Magento Template\"><img src=\"{{media url=\"template/kids_magento_template01.jpg\"}}\" alt=\"Home Textile Magento Template\" /></a> \r\n</div>\r\n<div class=\"b02\"><a class=\"title\" href=\"/magento-template-features/static-pages/highlighted-categories.html\"><img src=\"{{media url=\"template/kids_magento_template02.jpg\"}}\" alt=\"Kids Magento Template\" /></a> \r\n</div>\r\n<div class=\"b03\"><a class=\"title\" href=\"/magento-template-features/static-pages/highlighted-categories.html\"><img src=\"{{media url=\"template/kids_magento_template03.jpg\"}}\" alt=\"Kids Magento Template\" /></a> \r\n</div>\r\n</div>\r\n<p>Kids Magento Template. Kids Magento theme. Magento Template for Baby Products, Apparel & Accessories, Baby & Toddler Toys, Baby Stationery, Diapering, Gifts, Nursery, Pregnancy & Maternity.</p>','PRODUCTS',NULL,NULL,1,0,0,NULL,'LightShop Green Magento Template. Kids Magento Template. Kids Magento theme. Magento Template for Baby Products, Apparel & Accessories, Baby & Toddler Toys, Baby Stationery, Diapering, Gifts, Nursery, Pregnancy & Maternity.','Magento, template, eCommerce, theme, Magento template, extension, crafts, home décor, home textiles, accessories, flowers, eco products, green products, health products, visual arts, gift ','LightShop Green Magento Template. Kids Magento Template.','Kids',NULL,NULL,NULL,'kids-magento-template','kids-magento-template.html'),(51,2,'2011-11-13 03:40:16','2013-02-19 02:03:59','1/2/51',8,2,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PRODUCTS',NULL,NULL,1,0,0,NULL,NULL,NULL,NULL,'Home Tabs 01',NULL,NULL,NULL,'home-tabs','home-tabs.html'),(53,28,'2011-11-14 04:27:28','2013-04-03 23:00:47','1/2/28/53',4,3,9,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<ul class=\"bullet\" style=\"font-size: 18px;\">\r\n  <li><a href=\"/magento-template-features/static-pages/highlighted-categories.html\">Highlighted categories</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/most-popular-block.html\">Most Popular block</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/testimonials.html\">Testimonials</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-and-events.html\">News</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/news-details.html\">News Details</a></li>\r\n  <li><a href=\"/blog\">AW Blog</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/1-column-page.html\">Full width</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with right bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/2-columns-with-left-bar.html\">2 columns with left bar</a></li>\r\n  <li><a href=\"/magento-template-features/static-pages/3-columns-page.html\">3 columns</a></li>\r\n</ul>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'Static pages and blocks',NULL,NULL,NULL,'static-pages','magento-template-features/static-pages.html'),(61,53,'2012-05-04 22:41:38','2013-02-06 01:42:47','1/2/28/53/61',1,4,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PAGE',NULL,NULL,1,1,0,34,NULL,NULL,NULL,'Highlighted categories',NULL,NULL,NULL,'highlighted-categories','magento-template-features/static-pages/highlighted-categories.html'),(62,53,'2012-05-04 22:42:59','2013-02-04 22:31:34','1/2/28/53/62',6,4,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'Full-width page','one_column',NULL,NULL,'1-column-page','magento-template-features/static-pages/1-column-page.html'),(63,53,'2012-05-04 22:46:13','2013-02-04 22:31:05','1/2/28/53/63',7,4,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'2 columns with left bar','two_columns_left',NULL,NULL,'2-columns-with-left-bar','magento-template-features/static-pages/2-columns-with-left-bar.html'),(64,53,'2012-05-04 22:46:51','2013-02-04 22:30:44','1/2/28/53/64',8,4,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'2 columns with right bar','two_columns_right',NULL,NULL,'2-columns-with-right-bar','magento-template-features/static-pages/2-columns-with-right-bar.html'),(65,53,'2012-05-04 22:47:26','2013-02-04 22:31:25','1/2/28/53/65',9,4,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>H2 title goes here</h2>\r\n<p><img class=\"pic-right\" title=\"class=pic-right\" src=\"{{media url=\"/template/magento_theme.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h3>H3 title goes here</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<h4>H4 title goes here</h4>\r\n<ul class=\"bullet\">\r\n<li>Ul class \"bullet\" </li>\r\n<li>Consectetur adipisicing elit</li>\r\n<li>Ipsum dolor</li>\r\n</ul>\r\n<p><img class=\"pic-left\" title=\"class=pic-left\" src=\"{{media url=\"template/magento_template.jpg\"}}\" alt=\"Web-Experiment.info Premium Magento Template\" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>\r\n<hr />\r\n<h4>Definition list DL</h4>\r\n<dl> <dt>Lorem ipsum dolor</dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> <dt>Consectetur adipisicing elit </dt> <dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd> </dl>\r\n<hr />\r\n<h4>Ordered lists OL</h4>\r\n<ol>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>\r\n<h5>OL start=\"50\"</h5>\r\n<ol start=\"50\">\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n  <li>Lorem ipsum dolor</li>\r\n</ol>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'3 columns page','three_columns',NULL,NULL,'3-columns-page','magento-template-features/static-pages/3-columns-page.html'),(69,28,'2012-05-04 23:22:16','2012-05-07 12:19:48','1/2/28/69',6,3,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,'<h2>Deeper integration with Magenting hosting</h2><p>Get the theme with extensions rapidly installed on magenting hosting absolutely for free ( just check proper option while checkout).</p><p>All you have to do is to follow simple steps and obtain magenting.com hosting account (starting from $20/mo).</p><h2>Magenting</h2><p><a title=\"Magento hosting\" href=\"http://magenting.com\">Magenting.com</a>, a new faster, highly optimized, improved <strong>Magento hosting solution</strong>, is making it easy to create, promote, and manage online stores. Magento comes with everything you need to get your online store up and running!</p>\r\n<ul class=\"bullet\">\r\n<li><strong> Professional Magento hosting account</strong></li>\r\n<li><strong> Automatic Magento eCommerce installation</strong></li>\r\n<li><strong> Free our Magento template installation</strong></li>\r\n</ul>\r\n<p>It\'s never been easier to start selling online!</p>','PAGE',NULL,NULL,1,1,0,NULL,NULL,NULL,NULL,'Free installation on a special Magento hosting',NULL,NULL,NULL,'get-installed-store-on-our-magento-hosting','magento-template-features/get-installed-store-on-our-magento-hosting.html'),(87,53,'2013-02-06 22:09:24','2013-02-06 22:29:49','1/2/28/53/87',2,4,0,5,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL,'PAGE',NULL,NULL,1,1,0,35,NULL,NULL,NULL,'Most Popular block','one_column',NULL,NULL,'most-popular-block','magento-template-features/static-pages/most-popular-block.html');
/*!40000 ALTER TABLE `catalog_category_flat_store_5` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`category_id`,`product_id`),
  KEY `IDX_CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES (3,292,0),(3,294,0),(3,295,0),(3,296,0),(50,226,5),(50,227,150),(50,231,6),(50,232,250),(50,236,280),(50,238,130),(50,239,40),(50,241,240),(50,242,60),(50,243,20),(50,244,3),(50,245,220),(50,246,180),(50,247,100),(50,248,160),(50,249,3),(50,250,6),(50,251,90),(50,252,140),(50,253,190),(50,255,70),(50,292,1),(50,293,1),(50,294,1),(50,295,1),(50,296,1),(50,297,1),(50,298,1),(51,226,0),(51,239,0),(51,243,0),(51,244,0),(51,245,0),(51,247,0),(51,248,0),(102,287,0),(102,288,0),(102,289,0),(102,290,0),(102,291,0),(103,248,0),(103,251,0),(103,292,0),(103,293,0),(103,294,0),(103,295,0),(103,296,0),(103,297,0),(103,298,0);
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `15D3C269665C74C2219037D534F4B0DC` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`),
  CONSTRAINT `FK_CATALOG_CATEGORY_PRODUCT_INDEX_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_PRD_IDX_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CTGR_PRD_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index` VALUES (2,226,0,0,1,4),(2,227,0,0,1,4),(2,231,0,0,1,4),(2,232,0,0,1,4),(2,236,0,0,1,4),(2,238,0,0,1,4),(2,239,0,0,1,4),(2,241,0,0,1,4),(2,242,0,0,1,4),(2,243,0,0,1,4),(2,244,0,0,1,4),(2,245,0,0,1,4),(2,246,0,0,1,4),(2,247,0,0,1,4),(2,248,0,0,1,4),(2,249,0,0,1,4),(2,250,0,0,1,4),(2,251,0,0,1,4),(2,252,0,0,1,4),(2,253,0,0,1,4),(2,255,0,0,1,4),(2,292,0,0,1,4),(2,293,0,0,1,4),(2,294,0,0,1,4),(2,295,0,0,1,4),(2,296,0,0,1,4),(2,297,0,0,1,4),(2,298,0,0,1,4),(2,1,0,1,1,4),(2,287,0,1,1,4),(2,288,0,1,1,4),(2,289,0,1,1,4),(2,290,0,1,1,4),(2,291,0,1,1,4),(3,292,0,1,1,4),(3,294,0,1,1,4),(3,295,0,1,1,4),(3,296,0,1,1,4),(28,287,100000,0,1,4),(28,288,100000,0,1,4),(28,289,100000,0,1,4),(28,290,100000,0,1,4),(28,291,100000,0,1,4),(28,248,150000,0,1,4),(28,251,150000,0,1,4),(28,292,150000,0,1,4),(28,293,150000,0,1,4),(28,294,150000,0,1,4),(28,295,150000,0,1,4),(28,296,150000,0,1,4),(28,297,150000,0,1,4),(28,298,150000,0,1,4),(50,292,1,1,1,4),(50,293,1,1,1,4),(50,294,1,1,1,4),(50,295,1,1,1,4),(50,296,1,1,1,4),(50,297,1,1,1,4),(50,298,1,1,1,4),(50,244,3,1,1,4),(50,249,3,1,1,4),(50,226,5,1,1,4),(50,231,6,1,1,4),(50,250,6,1,1,4),(50,243,20,1,1,4),(50,239,40,1,1,4),(50,242,60,1,1,4),(50,255,70,1,1,4),(50,251,90,1,1,4),(50,247,100,1,1,4),(50,238,130,1,1,4),(50,252,140,1,1,4),(50,227,150,1,1,4),(50,248,160,1,1,4),(50,246,180,1,1,4),(50,253,190,1,1,4),(50,245,220,1,1,4),(50,241,240,1,1,4),(50,232,250,1,1,4),(50,236,280,1,1,4),(51,226,0,1,1,4),(51,239,0,1,1,4),(51,243,0,1,1,4),(51,244,0,1,1,4),(51,245,0,1,1,4),(51,247,0,1,1,4),(51,248,0,1,1,4),(102,287,0,1,1,4),(102,288,0,1,1,4),(102,289,0,1,1,4),(102,290,0,1,1,4),(102,291,0,1,1,4),(103,248,0,1,1,4),(103,251,0,1,1,4),(103,292,0,1,1,4),(103,293,0,1,1,4),(103,294,0,1,1,4),(103,295,0,1,1,4),(103,296,0,1,1,4),(103,297,0,1,1,4),(103,298,0,1,1,4),(2,226,0,0,5,4),(2,227,0,0,5,4),(2,231,0,0,5,4),(2,232,0,0,5,4),(2,236,0,0,5,4),(2,238,0,0,5,4),(2,239,0,0,5,4),(2,241,0,0,5,4),(2,242,0,0,5,4),(2,243,0,0,5,4),(2,244,0,0,5,4),(2,245,0,0,5,4),(2,246,0,0,5,4),(2,247,0,0,5,4),(2,248,0,0,5,4),(2,249,0,0,5,4),(2,250,0,0,5,4),(2,251,0,0,5,4),(2,252,0,0,5,4),(2,253,0,0,5,4),(2,255,0,0,5,4),(2,292,0,0,5,4),(2,293,0,0,5,4),(2,294,0,0,5,4),(2,295,0,0,5,4),(2,296,0,0,5,4),(2,297,0,0,5,4),(2,298,0,0,5,4),(2,1,0,1,5,4),(2,287,0,1,5,4),(2,288,0,1,5,4),(2,289,0,1,5,4),(2,290,0,1,5,4),(2,291,0,1,5,4),(3,292,0,1,5,4),(3,294,0,1,5,4),(3,295,0,1,5,4),(3,296,0,1,5,4),(28,287,100000,0,5,4),(28,288,100000,0,5,4),(28,289,100000,0,5,4),(28,290,100000,0,5,4),(28,291,100000,0,5,4),(28,248,150000,0,5,4),(28,251,150000,0,5,4),(28,292,150000,0,5,4),(28,293,150000,0,5,4),(28,294,150000,0,5,4),(28,295,150000,0,5,4),(28,296,150000,0,5,4),(28,297,150000,0,5,4),(28,298,150000,0,5,4),(50,292,1,1,5,4),(50,293,1,1,5,4),(50,294,1,1,5,4),(50,295,1,1,5,4),(50,296,1,1,5,4),(50,297,1,1,5,4),(50,298,1,1,5,4),(50,244,3,1,5,4),(50,249,3,1,5,4),(50,226,5,1,5,4),(50,231,6,1,5,4),(50,250,6,1,5,4),(50,243,20,1,5,4),(50,239,40,1,5,4),(50,242,60,1,5,4),(50,255,70,1,5,4),(50,251,90,1,5,4),(50,247,100,1,5,4),(50,238,130,1,5,4),(50,252,140,1,5,4),(50,227,150,1,5,4),(50,248,160,1,5,4),(50,246,180,1,5,4),(50,253,190,1,5,4),(50,245,220,1,5,4),(50,241,240,1,5,4),(50,232,250,1,5,4),(50,236,280,1,5,4),(51,226,0,1,5,4),(51,239,0,1,5,4),(51,243,0,1,5,4),(51,244,0,1,5,4),(51,245,0,1,5,4),(51,247,0,1,5,4),(51,248,0,1,5,4),(102,287,0,1,5,4),(102,288,0,1,5,4),(102,289,0,1,5,4),(102,290,0,1,5,4),(102,291,0,1,5,4),(103,248,0,1,5,4),(103,251,0,1,5,4),(103,292,0,1,5,4),(103,293,0,1,5,4),(103,294,0,1,5,4),(103,295,0,1,5,4),(103,296,0,1,5,4),(103,297,0,1,5,4),(103,298,0,1,5,4);
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_enbl_idx`
--

DROP TABLE IF EXISTS `catalog_category_product_index_enbl_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_enbl_idx` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `visibility` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility',
  KEY `IDX_CAT_CTGR_PRD_IDX_ENBL_IDX_PRD_ID_VISIBILITY` (`product_id`,`visibility`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Enabled Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_enbl_idx`
--

LOCK TABLES `catalog_category_product_index_enbl_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_enbl_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_enbl_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_enbl_tmp` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `visibility` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility',
  KEY `IDX_CAT_CTGR_PRD_IDX_ENBL_TMP_PRD_ID_VISIBILITY` (`product_id`,`visibility`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Enabled Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_enbl_tmp`
--

LOCK TABLES `catalog_category_product_index_enbl_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_idx`
--

DROP TABLE IF EXISTS `catalog_category_product_index_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_idx` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  KEY `IDX_CAT_CTGR_PRD_IDX_IDX_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_idx`
--

LOCK TABLES `catalog_category_product_index_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  KEY `IDX_CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_tmp`
--

LOCK TABLES `catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Store ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `IDX_CATALOG_COMPARE_ITEM_CUSTOMER_ID` (`customer_id`),
  KEY `IDX_CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `IDX_CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `IDX_CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `IDX_CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_COMPARE_ITEM_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_COMPARE_ITEM_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_CMP_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_item`
--

LOCK TABLES `catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `catalog_compare_item` DISABLE KEYS */;
INSERT INTO `catalog_compare_item` VALUES (3,0,2,244,1),(4,54,1,296,1),(5,54,1,241,1),(6,53,NULL,295,1),(7,53,NULL,243,1);
/*!40000 ALTER TABLE `catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `is_configurable` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Configurable',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  PRIMARY KEY (`attribute_id`),
  KEY `IDX_CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `IDX_CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `FK_CATALOG_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (35,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(36,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(37,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(38,NULL,0,1,0,0,0,0,1,0,0,0,0,1,NULL,0,0,1,0),(39,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(40,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(41,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(42,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(43,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(44,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(45,NULL,1,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(46,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(47,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(48,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(49,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(50,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(51,NULL,0,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(54,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(55,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(56,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(59,'adminhtml/catalog_category_helper_sortby_available',0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(60,'adminhtml/catalog_category_helper_sortby_default',0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(64,'adminhtml/catalog_category_helper_pricestep',0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(65,NULL,0,1,1,0,0,0,0,0,0,1,1,1,NULL,1,0,0,0),(66,NULL,0,1,1,0,1,0,1,0,0,0,0,1,NULL,1,0,1,0),(67,NULL,0,1,1,0,1,0,1,0,0,1,0,1,NULL,1,0,1,0),(68,NULL,1,1,1,0,1,0,0,0,0,0,0,1,NULL,1,0,0,0),(69,NULL,2,1,1,1,0,0,0,0,0,1,1,1,'simple,configurable,virtual,bundle,downloadable',1,0,0,0),(70,NULL,2,1,0,0,0,0,0,0,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,0,0,0),(71,NULL,2,1,0,0,0,0,0,0,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,0,0,0),(72,NULL,2,1,0,0,0,0,0,0,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,0,0,0),(73,NULL,2,1,0,0,0,0,0,0,0,0,0,1,'virtual,downloadable',0,0,0,0),(74,NULL,1,1,0,0,0,0,0,0,0,0,0,1,'simple,bundle',0,0,0,0),(75,NULL,1,1,1,1,1,0,0,0,0,0,0,1,'simple',1,0,0,0),(76,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(77,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(78,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(79,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(80,NULL,0,1,0,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(81,NULL,0,1,0,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(82,NULL,1,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(83,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(84,NULL,2,1,0,0,0,0,0,0,0,0,0,1,'simple,configurable,virtual,bundle,downloadable',0,0,0,0),(85,NULL,1,1,1,1,1,0,0,0,0,0,0,1,'simple',1,0,0,0),(86,NULL,2,1,0,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(87,NULL,2,1,0,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(88,NULL,1,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(89,NULL,2,1,1,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(90,NULL,0,1,0,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(91,NULL,0,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(92,NULL,0,0,0,0,0,0,0,0,0,0,0,1,'simple,configurable,virtual,bundle,downloadable',0,0,0,0),(93,NULL,1,1,0,0,0,0,0,0,0,0,0,0,'simple,virtual',0,0,0,0),(94,NULL,1,1,0,0,0,0,0,0,0,0,0,0,'simple,virtual',0,0,0,0),(95,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(96,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(97,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(98,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(101,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(103,NULL,1,0,0,0,0,0,0,0,0,1,0,1,NULL,0,0,0,0),(104,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(105,NULL,0,0,0,0,0,0,0,0,0,1,0,0,NULL,0,0,0,0),(106,NULL,0,0,0,0,0,0,0,0,0,1,0,0,NULL,0,0,0,0),(107,NULL,0,0,0,0,0,0,0,0,0,1,0,0,NULL,0,0,0,0),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(109,NULL,1,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(110,NULL,2,1,0,0,0,0,0,0,0,0,0,0,'simple,configurable,bundle,grouped',0,0,0,0),(111,'adminhtml/catalog_product_helper_form_msrp_enabled',2,1,0,0,0,0,0,0,0,1,0,1,'simple,bundle,configurable,virtual,downloadable',0,0,0,0),(112,'adminhtml/catalog_product_helper_form_msrp_price',2,1,0,0,0,0,0,0,0,1,0,1,'simple,bundle,configurable,virtual,downloadable',0,0,0,0),(113,NULL,2,1,0,0,0,0,0,0,0,1,0,1,'simple,bundle,configurable,virtual,downloadable',0,0,0,0),(114,NULL,1,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0),(115,NULL,2,1,1,0,0,0,0,0,0,1,0,1,'simple,configurable,virtual,downloadable,bundle',1,0,0,0),(116,'giftmessage/adminhtml_product_helper_form_config',1,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0),(117,NULL,1,0,0,0,0,0,0,0,0,1,0,0,'bundle',0,0,0,0),(118,NULL,1,0,0,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0),(119,NULL,1,0,0,0,0,0,0,0,0,1,0,0,'bundle',0,0,0,0),(120,NULL,1,1,0,0,0,0,0,0,0,1,0,0,'bundle',0,0,0,0),(121,NULL,1,0,0,0,0,0,0,0,0,1,0,0,'bundle',0,0,0,0),(122,NULL,1,0,0,0,0,0,0,0,0,1,0,0,'downloadable',0,0,0,0),(123,NULL,0,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0),(124,NULL,0,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0),(125,NULL,1,0,0,0,0,0,0,0,0,1,0,0,'downloadable',0,0,0,0),(126,NULL,0,1,0,0,0,0,0,0,0,0,0,1,NULL,0,0,0,0),(150,NULL,2,1,0,0,0,0,0,0,0,0,0,1,'simple,configurable,virtual,bundle,downloadable',0,0,0,0);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Id',
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent Id',
  `required` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `IDX_CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `FK_CAT_PRD_BNDL_OPT_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option`
--

LOCK TABLES `catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option` DISABLE KEYS */;
INSERT INTO `catalog_product_bundle_option` VALUES (5,296,1,4,'multi'),(6,296,1,3,'checkbox'),(7,296,1,2,'radio'),(8,296,1,1,'select');
/*!40000 ALTER TABLE `catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value Id',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option Id',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store Id',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_BUNDLE_OPTION_VALUE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  CONSTRAINT `FK_CAT_PRD_BNDL_OPT_VAL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option_value`
--

LOCK TABLES `catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` DISABLE KEYS */;
INSERT INTO `catalog_product_bundle_option_value` VALUES (21,8,0,'Option 1'),(22,7,0,'Option 2'),(23,6,0,'Option 3'),(24,5,0,'Option 4');
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `min_price` decimal(12,4) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `IDX_CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `FK_CAT_PRD_BNDL_PRICE_IDX_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_BNDL_PRICE_IDX_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_price_index`
--

LOCK TABLES `catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection Id',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option Id',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product Id',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `IDX_CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `IDX_CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CAT_PRD_BNDL_SELECTION_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_BNDL_SELECTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection`
--

LOCK TABLES `catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` DISABLE KEYS */;
INSERT INTO `catalog_product_bundle_selection` VALUES (9,5,296,292,0,0,0,0.0000,1.0000,1),(10,5,296,293,0,0,0,0.0000,1.0000,1),(11,6,296,292,0,0,0,0.0000,1.0000,1),(12,6,296,293,0,0,0,0.0000,1.0000,1),(13,7,296,292,0,0,0,0.0000,1.0000,1),(14,7,296,293,0,0,0,0.0000,1.0000,1),(15,8,296,292,0,0,0,0.0000,1.0000,1),(16,8,296,293,0,0,0,0.0000,1.0000,1);
/*!40000 ALTER TABLE `catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL COMMENT 'Selection Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  PRIMARY KEY (`selection_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_DCF37523AA05D770A70AA4ED7C2616E4` FOREIGN KEY (`selection_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection_price`
--

LOCK TABLES `catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `stock_status` smallint(6) DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_stock_index`
--

LOCK TABLES `catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_enabled_index`
--

DROP TABLE IF EXISTS `catalog_product_enabled_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_enabled_index` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility',
  PRIMARY KEY (`product_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENABLED_INDEX_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENABLED_INDEX_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENABLED_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Visibility Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_enabled_index`
--

LOCK TABLES `catalog_product_enabled_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_enabled_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_enabled_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Time',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_ENTITY_TYPE_ID` (`entity_type_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_SKU` (`sku`),
  CONSTRAINT `FK_CAT_PRD_ENTT_ATTR_SET_ID_EAV_ATTR_SET_ATTR_SET_ID` FOREIGN KEY (`attribute_set_id`) REFERENCES `eav_attribute_set` (`attribute_set_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=299 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES (1,4,4,'simple','test_product',1,1,'2011-11-06 07:20:09','2014-01-10 02:23:51'),(226,4,4,'simple','B0017YJ130',0,0,'2011-11-13 03:14:16','2014-01-10 02:22:35'),(227,4,4,'simple','B001GSKCAI',0,0,'2011-11-13 03:14:21','2014-01-10 02:20:44'),(231,4,4,'simple','B003JNEKAG',0,0,'2011-11-13 03:14:38','2014-01-10 02:19:55'),(232,4,4,'simple','B002RL8386',0,0,'2011-11-13 03:14:44','2014-01-10 02:19:19'),(236,4,4,'simple','B003ZV4CVE',0,0,'2011-11-13 03:15:11','2014-01-10 02:18:35'),(238,4,4,'simple','B001TZLAZE',0,0,'2011-11-13 03:15:21','2014-01-10 02:17:54'),(239,4,4,'simple','B000IHJF60',0,0,'2011-11-13 03:15:25','2014-01-10 02:16:23'),(241,4,4,'simple','B002AQIA6S',0,0,'2011-11-13 03:15:32','2014-01-10 02:17:01'),(242,4,4,'simple','B004835N8E',0,0,'2011-11-13 03:15:37','2014-01-10 02:15:08'),(243,4,4,'simple','B001HX4IXE',0,0,'2011-11-13 03:15:43','2014-01-10 02:14:16'),(244,4,4,'simple','B0039UTUWM',0,0,'2011-11-13 03:15:50','2014-01-10 02:12:53'),(245,4,4,'simple','B001RIY7CQ',0,0,'2011-11-13 03:15:58','2014-01-10 02:12:17'),(246,4,4,'simple','B004A154PG',0,0,'2011-11-13 03:16:02','2014-01-10 02:11:44'),(247,4,4,'simple','B004VT7Y7I',0,0,'2011-11-13 03:16:05','2014-01-10 02:11:06'),(248,4,4,'simple','B004VT7X8I',0,0,'2011-11-13 03:16:09','2014-01-10 02:09:42'),(249,4,4,'simple','B004VT7XVA',0,0,'2011-11-13 03:16:16','2014-01-13 22:15:01'),(250,4,4,'simple','B004A154PQ',0,0,'2011-11-13 03:16:22','2014-01-10 02:08:11'),(251,4,4,'simple','B000WYJ33E',0,0,'2011-11-13 03:16:30','2014-01-10 02:07:35'),(252,4,4,'simple','B00545CDQ0',0,0,'2011-11-13 03:16:38','2014-01-10 02:06:59'),(253,4,4,'simple','B002EDG14U',0,0,'2011-11-13 03:16:41','2014-01-10 02:06:15'),(255,4,4,'simple','B004A154P6',0,0,'2011-11-13 03:16:56','2014-01-10 02:05:41'),(287,4,4,'simple','B006XFJXF4',0,0,'2012-05-08 02:01:42','2012-05-08 02:01:46'),(288,4,4,'simple','B003VSOKQI',0,0,'2012-05-08 02:01:48','2012-05-08 02:01:53'),(289,4,4,'simple','B0040WRM5K',0,0,'2012-05-08 02:01:55','2012-05-08 02:01:58'),(290,4,4,'simple','B005PPMSOG',0,0,'2012-05-08 02:02:00','2014-01-20 22:56:43'),(291,4,4,'simple','B005FGF38S',0,0,'2012-05-08 02:02:05','2012-05-08 02:02:07'),(292,4,4,'simple','simple_product_example',0,0,'2013-02-13 12:04:34','2014-01-10 04:02:54'),(293,4,4,'virtual','virtual_product_example',0,0,'2013-02-13 12:04:37','2014-01-10 04:00:49'),(294,4,4,'configurable','configurable_example',1,1,'2013-02-13 12:04:40','2014-01-15 23:31:38'),(295,4,4,'grouped','grouped_product_example',0,0,'2013-02-13 12:04:42','2014-01-10 02:56:43'),(296,4,4,'bundle','bundle_product_example',1,1,'2013-02-13 12:04:44','2014-01-10 02:57:20'),(297,4,4,'downloadable','downloadable_product_example',1,1,'2013-02-13 12:04:46','2014-01-14 00:00:02'),(298,4,4,'simple','product_with_options_example',1,1,'2013-02-13 12:04:48','2014-01-10 03:47:31');
/*!40000 ALTER TABLE `catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2417 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_datetime`
--

LOCK TABLES `catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_datetime` VALUES (1,4,86,0,1,NULL),(2,4,87,0,1,NULL),(3,4,71,0,1,NULL),(4,4,72,0,1,NULL),(5,4,97,0,1,NULL),(6,4,98,0,1,NULL),(683,4,71,0,226,NULL),(686,4,71,0,227,NULL),(698,4,71,0,231,NULL),(701,4,71,0,232,NULL),(713,4,71,0,236,NULL),(719,4,71,0,238,NULL),(722,4,71,0,239,NULL),(728,4,71,0,241,NULL),(731,4,71,0,242,'2012-05-07 00:00:00'),(734,4,71,0,243,NULL),(737,4,71,0,244,NULL),(740,4,71,0,245,NULL),(743,4,71,0,246,NULL),(746,4,71,0,247,'2012-05-07 00:00:00'),(749,4,71,0,248,NULL),(752,4,71,0,249,NULL),(755,4,71,0,250,NULL),(758,4,71,0,251,NULL),(761,4,71,0,252,NULL),(764,4,71,0,253,'2012-05-07 00:00:00'),(770,4,71,0,255,NULL),(1844,4,86,0,255,NULL),(1845,4,87,0,255,NULL),(1846,4,72,0,255,NULL),(1847,4,97,0,255,NULL),(1848,4,98,0,255,NULL),(1856,4,86,0,253,NULL),(1857,4,87,0,253,NULL),(1858,4,72,0,253,NULL),(1859,4,97,0,253,NULL),(1860,4,98,0,253,NULL),(1862,4,86,0,251,NULL),(1863,4,87,0,251,NULL),(1864,4,72,0,251,NULL),(1865,4,97,0,251,NULL),(1866,4,98,0,251,NULL),(1868,4,86,0,250,NULL),(1869,4,87,0,250,NULL),(1870,4,72,0,250,NULL),(1871,4,97,0,250,NULL),(1872,4,98,0,250,NULL),(1874,4,86,0,249,NULL),(1875,4,87,0,249,NULL),(1876,4,72,0,249,NULL),(1877,4,97,0,249,NULL),(1878,4,98,0,249,NULL),(1880,4,86,0,248,NULL),(1881,4,87,0,248,NULL),(1882,4,72,0,248,NULL),(1883,4,97,0,248,NULL),(1884,4,98,0,248,NULL),(1886,4,86,0,247,NULL),(1887,4,87,0,247,NULL),(1888,4,72,0,247,NULL),(1889,4,97,0,247,NULL),(1890,4,98,0,247,NULL),(1892,4,86,0,246,NULL),(1893,4,87,0,246,NULL),(1894,4,72,0,246,NULL),(1895,4,97,0,246,NULL),(1896,4,98,0,246,NULL),(1898,4,86,0,245,NULL),(1899,4,87,0,245,NULL),(1900,4,72,0,245,NULL),(1901,4,97,0,245,NULL),(1902,4,98,0,245,NULL),(1904,4,86,0,244,NULL),(1905,4,87,0,244,NULL),(1906,4,72,0,244,NULL),(1907,4,97,0,244,NULL),(1908,4,98,0,244,NULL),(1910,4,86,0,243,NULL),(1911,4,87,0,243,NULL),(1912,4,72,0,243,NULL),(1913,4,97,0,243,NULL),(1914,4,98,0,243,NULL),(1916,4,86,0,242,NULL),(1917,4,87,0,242,NULL),(1918,4,72,0,242,NULL),(1919,4,97,0,242,NULL),(1920,4,98,0,242,NULL),(1922,4,86,0,241,NULL),(1923,4,87,0,241,NULL),(1924,4,72,0,241,NULL),(1925,4,97,0,241,NULL),(1926,4,98,0,241,NULL),(2058,4,71,0,287,NULL),(2061,4,71,0,288,NULL),(2064,4,71,0,289,NULL),(2067,4,71,0,290,'2014-01-20 00:00:00'),(2070,4,71,0,291,NULL),(2117,4,71,0,292,'2013-02-10 00:00:00'),(2118,4,72,0,292,NULL),(2119,4,86,0,292,'2014-01-09 00:00:00'),(2120,4,87,0,292,NULL),(2121,4,97,0,292,NULL),(2122,4,98,0,292,NULL),(2123,4,71,0,293,'2013-02-10 00:00:00'),(2124,4,72,0,293,NULL),(2125,4,86,0,293,'2014-01-09 00:00:00'),(2126,4,87,0,293,NULL),(2127,4,97,0,293,NULL),(2128,4,98,0,293,NULL),(2129,4,71,0,294,NULL),(2130,4,72,0,294,NULL),(2131,4,86,0,294,'2014-01-09 00:00:00'),(2132,4,87,0,294,NULL),(2133,4,97,0,294,NULL),(2134,4,98,0,294,NULL),(2135,4,86,0,295,'2014-01-09 00:00:00'),(2136,4,87,0,295,NULL),(2137,4,97,0,295,NULL),(2138,4,98,0,295,NULL),(2139,4,71,0,296,NULL),(2140,4,72,0,296,NULL),(2141,4,86,0,296,'2014-01-09 00:00:00'),(2142,4,87,0,296,NULL),(2143,4,97,0,296,NULL),(2144,4,98,0,296,NULL),(2145,4,71,0,297,'2013-02-10 00:00:00'),(2146,4,72,0,297,NULL),(2147,4,86,0,297,NULL),(2148,4,87,0,297,NULL),(2149,4,97,0,297,NULL),(2150,4,98,0,297,NULL),(2151,4,71,0,298,'2013-01-05 00:00:00'),(2152,4,72,0,298,NULL),(2153,4,86,0,298,'2014-01-09 00:00:00'),(2154,4,87,0,298,NULL),(2155,4,97,0,298,NULL),(2156,4,98,0,298,NULL),(2157,4,86,0,226,NULL),(2158,4,87,0,226,NULL),(2159,4,72,0,226,NULL),(2160,4,97,0,226,NULL),(2161,4,98,0,226,NULL),(2179,4,86,0,252,NULL),(2180,4,87,0,252,NULL),(2181,4,72,0,252,NULL),(2182,4,97,0,252,NULL),(2183,4,98,0,252,NULL),(2243,4,86,0,239,NULL),(2244,4,87,0,239,NULL),(2245,4,72,0,239,NULL),(2246,4,97,0,239,NULL),(2247,4,98,0,239,NULL),(2255,4,86,0,238,NULL),(2256,4,87,0,238,NULL),(2257,4,72,0,238,NULL),(2258,4,97,0,238,NULL),(2259,4,98,0,238,NULL),(2261,4,86,0,236,NULL),(2262,4,87,0,236,NULL),(2263,4,72,0,236,NULL),(2264,4,97,0,236,NULL),(2265,4,98,0,236,NULL),(2267,4,86,0,232,NULL),(2268,4,87,0,232,NULL),(2269,4,72,0,232,NULL),(2270,4,97,0,232,NULL),(2271,4,98,0,232,NULL),(2273,4,86,0,231,NULL),(2274,4,87,0,231,NULL),(2275,4,72,0,231,NULL),(2276,4,97,0,231,NULL),(2277,4,98,0,231,NULL),(2279,4,86,0,227,NULL),(2280,4,87,0,227,NULL),(2281,4,72,0,227,NULL),(2282,4,97,0,227,NULL),(2283,4,98,0,227,NULL),(2412,4,86,0,290,'2014-01-20 00:00:00'),(2413,4,87,0,290,NULL),(2414,4,72,0,290,NULL),(2415,4,97,0,290,'2014-01-20 00:00:00'),(2416,4,98,0,290,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1669 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_decimal`
--

LOCK TABLES `catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_decimal` VALUES (1,4,74,0,1,1.0000),(2,4,69,0,1,156.0000),(3,4,70,0,1,NULL),(4,4,113,0,1,120.0000),(676,4,69,0,226,104.9900),(677,4,74,0,226,1.0000),(679,4,69,0,227,58.7500),(680,4,74,0,227,1.0000),(691,4,69,0,231,56.4900),(692,4,74,0,231,1.0000),(694,4,69,0,232,58.9800),(695,4,74,0,232,1.0000),(706,4,69,0,236,38.4000),(707,4,74,0,236,1.0000),(712,4,69,0,238,55.0000),(713,4,74,0,238,1.0000),(715,4,69,0,239,26.9900),(716,4,74,0,239,1.0000),(721,4,69,0,241,88.2000),(722,4,74,0,241,1.0000),(724,4,69,0,242,34.9900),(725,4,74,0,242,1.0000),(727,4,69,0,243,32.6000),(728,4,74,0,243,1.0000),(730,4,69,0,244,22.3500),(731,4,74,0,244,1.0000),(733,4,69,0,245,66.9900),(734,4,74,0,245,1.0000),(736,4,69,0,246,164.9900),(737,4,74,0,246,1.0000),(739,4,69,0,247,34.6500),(740,4,74,0,247,1.0000),(742,4,69,0,248,76.4900),(743,4,74,0,248,1.0000),(745,4,69,0,249,35.9500),(746,4,74,0,249,1.0000),(748,4,69,0,250,83.4800),(749,4,74,0,250,1.0000),(751,4,69,0,251,168.0000),(752,4,74,0,251,1.0000),(754,4,69,0,252,48.0000),(755,4,74,0,252,1.0000),(757,4,69,0,253,35.9900),(758,4,74,0,253,1.0000),(763,4,69,0,255,53.9800),(764,4,74,0,255,1.0000),(1347,4,70,0,255,NULL),(1348,4,113,0,255,NULL),(1353,4,70,0,253,28.0000),(1354,4,113,0,253,NULL),(1356,4,70,0,251,NULL),(1357,4,113,0,251,NULL),(1359,4,70,0,250,NULL),(1360,4,113,0,250,NULL),(1362,4,70,0,249,NULL),(1363,4,113,0,249,NULL),(1365,4,70,0,248,NULL),(1366,4,113,0,248,NULL),(1368,4,70,0,247,28.0000),(1369,4,113,0,247,NULL),(1371,4,70,0,246,NULL),(1372,4,113,0,246,NULL),(1374,4,70,0,245,NULL),(1375,4,113,0,245,NULL),(1377,4,70,0,244,NULL),(1378,4,113,0,244,NULL),(1380,4,70,0,243,NULL),(1381,4,113,0,243,NULL),(1383,4,70,0,242,28.0000),(1384,4,113,0,242,NULL),(1386,4,70,0,241,NULL),(1387,4,113,0,241,NULL),(1464,4,69,0,287,28.0000),(1465,4,74,0,287,1.0000),(1467,4,69,0,288,28.0000),(1468,4,74,0,288,1.0000),(1470,4,69,0,289,28.0000),(1471,4,74,0,289,1.0000),(1473,4,69,0,290,28.0000),(1474,4,74,0,290,1.0000),(1476,4,69,0,291,28.0000),(1477,4,74,0,291,1.0000),(1484,4,70,0,291,26.0000),(1485,4,70,0,290,26.0000),(1486,4,70,0,288,26.0000),(1487,4,70,0,289,26.0000),(1488,4,70,0,287,26.0000),(1511,4,69,0,292,373.9900),(1512,4,70,0,292,NULL),(1513,4,74,0,292,1.0000),(1514,4,113,0,292,NULL),(1515,4,69,0,293,99.0000),(1516,4,70,0,293,75.0000),(1517,4,113,0,293,NULL),(1518,4,73,0,293,NULL),(1519,4,69,0,294,3.0000),(1520,4,70,0,294,NULL),(1521,4,113,0,294,NULL),(1522,4,69,0,296,NULL),(1523,4,70,0,296,NULL),(1524,4,74,0,296,1.0000),(1525,4,69,0,297,495.9900),(1526,4,70,0,297,NULL),(1527,4,113,0,297,NULL),(1528,4,73,0,297,47.0000),(1529,4,69,0,298,299.9900),(1530,4,70,0,298,NULL),(1531,4,74,0,298,1.0000),(1532,4,113,0,298,NULL),(1533,4,70,0,226,NULL),(1534,4,113,0,226,NULL),(1544,4,70,0,252,NULL),(1545,4,113,0,252,NULL),(1577,4,70,0,239,NULL),(1578,4,113,0,239,NULL),(1583,4,70,0,238,NULL),(1584,4,113,0,238,NULL),(1586,4,70,0,236,NULL),(1587,4,113,0,236,NULL),(1589,4,70,0,232,NULL),(1590,4,113,0,232,NULL),(1592,4,70,0,231,NULL),(1593,4,113,0,231,NULL),(1595,4,70,0,227,NULL),(1596,4,113,0,227,NULL),(1668,4,113,0,290,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) NOT NULL DEFAULT '' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_ENTT_GLR_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_gallery`
--

LOCK TABLES `catalog_product_entity_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_group_price`
--

DROP TABLE IF EXISTS `catalog_product_entity_group_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_group_price` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `all_groups` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Applicable To All Customer Groups',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `is_percent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Percent',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CC12C83765B562314470A24F2BDD0F36` (`entity_id`,`all_groups`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_GROUP_PRICE_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_GROUP_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_GROUP_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CAT_PRD_ENTT_GROUP_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_GROUP_PRICE_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_DF909D22C11B60B1E5E3EE64AB220ECE` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Group Price Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_group_price`
--

LOCK TABLES `catalog_product_entity_group_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_group_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_group_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_INT_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_INT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3446 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_int`
--

LOCK TABLES `catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_int` VALUES (1,4,89,0,1,1),(2,4,95,0,1,4),(3,4,114,0,1,1),(4,4,115,0,1,4),(5,4,93,0,1,0),(2468,4,115,0,226,0),(2469,4,95,0,226,4),(2470,4,89,0,226,1),(2472,4,114,0,226,1),(2479,4,115,0,227,0),(2480,4,95,0,227,4),(2481,4,89,0,227,1),(2483,4,114,0,227,1),(2523,4,115,0,231,0),(2524,4,95,0,231,4),(2525,4,89,0,231,1),(2527,4,114,0,231,1),(2534,4,115,0,232,0),(2535,4,95,0,232,4),(2536,4,89,0,232,1),(2538,4,114,0,232,1),(2578,4,115,0,236,0),(2579,4,95,0,236,4),(2580,4,89,0,236,1),(2582,4,114,0,236,1),(2600,4,115,0,238,0),(2601,4,95,0,238,4),(2602,4,89,0,238,1),(2604,4,114,0,238,1),(2611,4,115,0,239,0),(2612,4,95,0,239,4),(2613,4,89,0,239,1),(2615,4,114,0,239,1),(2633,4,115,0,241,0),(2634,4,95,0,241,4),(2635,4,89,0,241,1),(2637,4,114,0,241,1),(2644,4,115,0,242,0),(2645,4,95,0,242,4),(2646,4,89,0,242,1),(2648,4,114,0,242,1),(2655,4,115,0,243,0),(2656,4,95,0,243,4),(2657,4,89,0,243,1),(2659,4,114,0,243,1),(2666,4,115,0,244,0),(2667,4,95,0,244,4),(2668,4,89,0,244,1),(2670,4,114,0,244,1),(2677,4,115,0,245,0),(2678,4,95,0,245,4),(2679,4,89,0,245,1),(2681,4,114,0,245,1),(2688,4,115,0,246,0),(2689,4,95,0,246,4),(2690,4,89,0,246,1),(2692,4,114,0,246,1),(2699,4,115,0,247,0),(2700,4,95,0,247,4),(2701,4,89,0,247,1),(2703,4,114,0,247,1),(2710,4,115,0,248,0),(2711,4,95,0,248,4),(2712,4,89,0,248,1),(2714,4,114,0,248,1),(2721,4,115,0,249,0),(2722,4,95,0,249,4),(2723,4,89,0,249,1),(2725,4,114,0,249,1),(2732,4,115,0,250,0),(2733,4,95,0,250,4),(2734,4,89,0,250,1),(2736,4,114,0,250,1),(2743,4,115,0,251,0),(2744,4,95,0,251,4),(2745,4,89,0,251,1),(2747,4,114,0,251,1),(2754,4,115,0,252,0),(2755,4,95,0,252,4),(2756,4,89,0,252,1),(2758,4,114,0,252,1),(2765,4,115,0,253,0),(2766,4,95,0,253,4),(2767,4,89,0,253,1),(2769,4,114,0,253,1),(2787,4,115,0,255,0),(2788,4,95,0,255,4),(2789,4,89,0,255,1),(2791,4,114,0,255,1),(3230,4,93,0,255,0),(3232,4,93,0,253,0),(3233,4,93,0,251,0),(3234,4,93,0,250,0),(3235,4,93,0,249,0),(3236,4,93,0,248,0),(3237,4,93,0,247,0),(3238,4,93,0,246,0),(3239,4,93,0,245,0),(3240,4,93,0,244,0),(3241,4,93,0,243,0),(3242,4,93,0,242,0),(3243,4,93,0,241,0),(3297,4,115,0,287,0),(3298,4,95,0,287,4),(3299,4,89,0,287,1),(3301,4,114,0,287,1),(3308,4,115,0,288,0),(3309,4,95,0,288,4),(3310,4,89,0,288,1),(3312,4,114,0,288,1),(3319,4,115,0,289,0),(3320,4,95,0,289,4),(3321,4,89,0,289,1),(3323,4,114,0,289,1),(3330,4,115,0,290,0),(3331,4,95,0,290,4),(3332,4,89,0,290,1),(3334,4,114,0,290,1),(3341,4,115,0,291,0),(3342,4,95,0,291,4),(3343,4,89,0,291,1),(3345,4,114,0,291,1),(3353,4,89,0,292,1),(3354,4,93,0,292,0),(3355,4,95,0,292,4),(3356,4,114,0,292,1),(3357,4,115,0,292,0),(3358,4,89,0,293,1),(3359,4,93,0,293,0),(3360,4,95,0,293,4),(3361,4,114,0,293,1),(3362,4,115,0,293,0),(3363,4,89,0,294,1),(3364,4,95,0,294,4),(3365,4,114,0,294,1),(3366,4,115,0,294,0),(3367,4,89,0,295,1),(3368,4,95,0,295,4),(3369,4,114,0,295,1),(3370,4,89,0,296,1),(3371,4,95,0,296,4),(3372,4,114,0,296,1),(3373,4,117,0,296,0),(3374,4,118,0,296,1),(3375,4,119,0,296,1),(3376,4,120,0,296,0),(3377,4,121,0,296,0),(3378,4,89,0,297,1),(3379,4,95,0,297,4),(3380,4,114,0,297,1),(3381,4,115,0,297,0),(3382,4,122,0,297,1),(3383,4,89,0,298,1),(3384,4,93,0,298,0),(3385,4,95,0,298,4),(3386,4,114,0,298,1),(3387,4,115,0,298,0),(3388,4,85,0,292,5),(3389,4,85,0,294,NULL),(3390,4,125,0,297,1),(3391,4,85,0,298,4),(3400,4,85,0,244,NULL),(3401,4,85,0,243,NULL),(3403,4,85,0,226,NULL),(3404,4,93,0,226,0),(3405,4,85,0,255,NULL),(3407,4,85,0,253,NULL),(3408,4,85,0,252,NULL),(3409,4,93,0,252,0),(3410,4,85,0,251,NULL),(3411,4,85,0,250,NULL),(3412,4,85,0,249,NULL),(3413,4,85,0,248,NULL),(3414,4,85,0,247,NULL),(3415,4,85,0,246,NULL),(3416,4,85,0,245,NULL),(3419,4,85,0,242,NULL),(3420,4,85,0,239,NULL),(3421,4,93,0,239,0),(3422,4,85,0,241,NULL),(3423,4,85,0,238,NULL),(3424,4,93,0,238,0),(3425,4,85,0,236,NULL),(3426,4,93,0,236,0),(3427,4,85,0,232,NULL),(3428,4,93,0,232,0),(3429,4,85,0,231,NULL),(3430,4,93,0,231,0),(3431,4,85,0,227,NULL),(3432,4,93,0,227,0),(3435,4,85,0,1,NULL),(3444,4,85,0,290,NULL),(3445,4,93,0,290,0);
/*!40000 ALTER TABLE `catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ENTITY_ID` (`entity_id`),
  CONSTRAINT `FK_CAT_PRD_ENTT_MDA_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_MDA_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=699 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery`
--

LOCK TABLES `catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery` VALUES (620,82,287,'/3/1/3113241uzg_2BLmC1L.jpg'),(621,82,288,'/5/5/5512951-nlqe_2BMpL.jpg'),(622,82,288,'/7/0/7063341j6_2BJCLkiL.jpg'),(623,82,288,'/4/3/4358751DhrrNsYkL.jpg'),(624,82,288,'/1/9/1921241bKM-p3qsL.jpg'),(625,82,288,'/4/3/4395541VGHP7cYXL.jpg'),(626,82,289,'/2/8/28391413qWC2vpOL.jpg'),(627,82,289,'/1/2/12287315UYxejU8L.jpg'),(629,82,291,'/1/4/1432551QvKKpVYLL.jpg'),(645,82,298,'/1/9/1985141fbme3c8xl.jpg'),(646,82,298,'/1/0/1088841ijfwhewyl.jpg'),(647,82,298,'/7/5/754344125vs8zawl.jpg'),(648,82,298,'/5/7/5703531g5enognzl.jpg'),(649,82,298,'/9/0/9017431vzmkzl6bl.jpg'),(650,82,297,'/f/i/file_5_89.jpg'),(651,82,297,'/2/3/2338351ysn7gguql.jpg'),(652,82,297,'/5/6/5614031lpi6nezjl.jpg'),(653,82,296,'/1/3/13000319a3qg39gl.jpg'),(654,82,296,'/6/2/6276251gv8imkzgl.jpg'),(655,82,296,'/8/0/8004441l6a-vkzzl.jpg'),(656,82,296,'/2/5/2586541l3jj4xyol.jpg'),(657,82,295,'/4/4/445834197g6ucvdl.jpg'),(658,82,295,'/f/i/file_5_87.jpg'),(659,82,295,'/1/5/1575321xxitti6ql.jpg'),(660,82,294,'/3/5/3518951orrwb2szl.jpg'),(661,82,294,'/4/5/4596251m0ds1xeol.jpg'),(662,82,294,'/7/4/7469851kyrkuipal.jpg'),(663,82,293,'/3/9/3996831m4cedq1fl.jpg'),(664,82,293,'/9/2/9278831pv1utff6l.jpg'),(665,82,293,'/8/3/8308341syzd4qthl.jpg'),(666,82,292,'/f/i/file_5_96.jpg'),(667,82,292,'/4/5/4518141yqdds1w2l.jpg'),(668,82,292,'/4/0/4067951jerw0yenl.jpg'),(669,82,292,'/2/8/2855141wgkqlfzjl.jpg'),(670,82,292,'/9/3/93933416jgeajqrl.jpg'),(671,82,255,'/1/8/1842441ugnfbh7kl.jpg'),(672,82,253,'/3/5/3593841ukdyrthxl.jpg'),(673,82,252,'/3/8/3817831wc2kkavsl.jpg'),(674,82,251,'/4/8/4858351hm4qmcr3l.jpg'),(675,82,250,'/6/2/6276251gv8imkzgl_1.jpg'),(676,82,249,'/8/5/8581731c6dlwyxel.jpg'),(677,82,248,'/5/7/57513319fxpdryjl.jpg'),(678,82,247,'/6/4/64397412hiqswx4l.jpg'),(679,82,246,'/2/1/219855146skdaqnl.jpg'),(680,82,245,'/1/8/1842441ugnfbh7kl_1.jpg'),(681,82,244,'/3/5/3593841ukdyrthxl_1.jpg'),(682,82,243,'/3/8/3817831wc2kkavsl_1.jpg'),(683,82,242,'/4/8/4858351hm4qmcr3l_1.jpg'),(684,82,239,'/6/2/6276251gv8imkzgl_2.jpg'),(685,82,241,'/9/3/9352651swse52brl.jpg'),(686,82,241,'/8/5/8581731c6dlwyxel_1.jpg'),(687,82,241,'/4/8/4858351hm4qmcr3l_2.jpg'),(688,82,238,'/3/5/3593841ukdyrthxl_2.jpg'),(689,82,238,'/9/3/9352651swse52brl_1.jpg'),(690,82,238,'/1/8/1842441ugnfbh7kl_2.jpg'),(691,82,236,'/9/8/9834551egofdo9hl.jpg'),(692,82,232,'/5/7/57513319fxpdryjl_1.jpg'),(693,82,231,'/2/1/219855146skdaqnl_1.jpg'),(694,82,227,'/6/2/6276251gv8imkzgl_3.jpg'),(695,82,226,'/5/7/5700651cbl3tp1ql.jpg'),(696,82,1,'/3/2/3291241ce7yabthl.jpg'),(697,82,1,'/f/i/file_5_88.jpg'),(698,82,290,'/7/8/7813141r6v6ecpfl_1.jpg');
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  PRIMARY KEY (`value_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_MDA_GLR_VAL_VAL_ID_CAT_PRD_ENTT_MDA_GLR_VAL_ID` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value`
--

LOCK TABLES `catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value` VALUES (620,0,NULL,1,0),(621,0,NULL,1,0),(622,0,NULL,2,0),(623,0,NULL,3,0),(624,0,NULL,4,0),(625,0,NULL,5,0),(626,0,NULL,1,0),(627,0,NULL,2,0),(629,0,NULL,1,0),(645,0,NULL,4,0),(646,0,NULL,5,0),(647,0,NULL,6,1),(648,0,NULL,7,0),(649,0,NULL,8,0),(650,0,NULL,2,0),(651,0,NULL,3,1),(652,0,NULL,4,0),(653,0,NULL,2,0),(654,0,NULL,3,1),(655,0,NULL,4,0),(656,0,NULL,5,0),(657,0,NULL,5,0),(658,0,NULL,6,1),(659,0,NULL,7,0),(660,0,NULL,4,0),(661,0,NULL,5,1),(662,0,NULL,6,0),(663,0,NULL,2,0),(664,0,NULL,3,0),(665,0,NULL,4,1),(666,0,NULL,2,1),(667,0,NULL,3,0),(668,0,NULL,4,0),(669,0,NULL,5,0),(670,0,NULL,6,0),(671,0,NULL,1,1),(672,0,NULL,6,1),(673,0,NULL,2,1),(674,0,NULL,7,1),(675,0,NULL,7,1),(676,0,NULL,4,1),(677,0,NULL,5,1),(678,0,NULL,3,1),(679,0,NULL,2,1),(680,0,NULL,3,1),(681,0,NULL,5,1),(682,0,NULL,7,1),(683,0,NULL,6,1),(684,0,NULL,2,1),(685,0,NULL,4,1),(686,0,NULL,5,0),(687,0,NULL,6,0),(688,0,NULL,3,0),(689,0,NULL,4,1),(690,0,NULL,5,0),(691,0,NULL,4,1),(692,0,NULL,5,1),(693,0,NULL,3,1),(694,0,NULL,3,1),(695,0,NULL,4,1),(696,0,NULL,10,0),(697,0,NULL,11,0),(698,0,NULL,2,1);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_TEXT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6707 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_text`
--

LOCK TABLES `catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_text` VALUES (1,4,66,0,1,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(2,4,67,0,1,'Lorem ipsum Collection\r\n \r\n'),(3,4,77,0,1,NULL),(4,4,99,0,1,NULL),(3313,4,67,0,226,'All Stars Collection'),(3314,4,66,0,226,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3328,4,67,0,227,'Orange'),(3329,4,66,0,227,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3388,4,67,0,231,'Gray Collection'),(3389,4,66,0,231,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3403,4,67,0,232,'Black'),(3404,4,66,0,232,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3468,4,67,0,236,'White'),(3469,4,66,0,236,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3498,4,67,0,238,'Soft collection'),(3499,4,66,0,238,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3513,4,67,0,239,'Best Collection'),(3514,4,66,0,239,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3543,4,67,0,241,'Best Collection'),(3544,4,66,0,241,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3558,4,67,0,242,'Collection'),(3559,4,66,0,242,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3573,4,67,0,243,'Orange Collection'),(3574,4,66,0,243,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3588,4,67,0,244,'White Collection'),(3589,4,66,0,244,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3603,4,67,0,245,'White'),(3604,4,66,0,245,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3618,4,67,0,246,'Zebra Collection'),(3619,4,66,0,246,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3633,4,67,0,247,'Collection'),(3634,4,66,0,247,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3648,4,67,0,248,'Flower Pink'),(3649,4,66,0,248,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3663,4,67,0,249,'Crown'),(3664,4,66,0,249,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3678,4,67,0,250,'Safari Collection '),(3679,4,66,0,250,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3693,4,67,0,251,'Orange'),(3694,4,66,0,251,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3708,4,67,0,252,'Collection'),(3709,4,66,0,252,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3723,4,67,0,253,'Extra Fun'),(3724,4,66,0,253,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(3753,4,67,0,255,'Safari Collection '),(3754,4,66,0,255,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>'),(6187,4,77,0,255,NULL),(6188,4,99,0,255,NULL),(6193,4,77,0,253,NULL),(6194,4,99,0,253,NULL),(6196,4,77,0,251,NULL),(6197,4,99,0,251,NULL),(6199,4,77,0,250,NULL),(6200,4,99,0,250,NULL),(6202,4,77,0,249,NULL),(6203,4,99,0,249,NULL),(6205,4,77,0,248,NULL),(6206,4,99,0,248,NULL),(6208,4,77,0,247,NULL),(6209,4,99,0,247,NULL),(6211,4,77,0,246,NULL),(6212,4,99,0,246,NULL),(6214,4,77,0,245,NULL),(6215,4,99,0,245,NULL),(6217,4,77,0,244,NULL),(6218,4,99,0,244,NULL),(6220,4,77,0,243,NULL),(6221,4,99,0,243,NULL),(6223,4,77,0,242,NULL),(6224,4,99,0,242,NULL),(6226,4,77,0,241,NULL),(6227,4,99,0,241,NULL),(6440,4,67,0,287,'Feel like you are in a tropical island!'),(6441,4,66,0,287,'<div>Cup A, B & C for a hot décolleté! Bandeau Style! Halter neck tie fastening! Available in size 2 - 12! Colour yellow, white or black (83% Polyamid, 17% Elasthan)</div><p></p>'),(6456,4,67,0,288,'Feel like you are in a tropical island!'),(6457,4,66,0,288,'<div>Feel like you are in a tropical island when you wear this monokini style printed bikini. Be ready to look hot when you wear this exotic two piece to all your fun times in the sun. The fabric of this bikini is super soft on your skin and has great luxurious quality. The top features a deep V neckline with halter and back ties. The cups feature removable soft padding for a comfortable fit and superior coverage. The cut out sides and low waist bottom with circle side rings, makes this a must have sexy swimsuit. The back reveals an open sexy bareback with a moderate coverage bikini bottom. This tropical style will make you the exotic princess everywhere you go!</div><p></p>'),(6472,4,67,0,289,'Feel like you are in a tropical island!'),(6473,4,66,0,289,'<div>Halter top slingshot monokini.</div><p></p>'),(6489,4,67,0,290,'Feel like you are in a tropical island!'),(6490,4,66,0,290,'<div>Bandeau Style! Halter neck tie fastening! Fully lined! Available in size 2 - 8 (XXS - M)! Colour: Multicolour (80% Polyamid, 20% Elasthan)</div><p></p>'),(6505,4,67,0,291,'Feel like you are in a tropical island!'),(6506,4,66,0,291,'<div>Strapless sequin corset with underwire cups, side zipper closure, lace-up back and matching thong.  Ruffle panty not included.</div><p></p>'),(6544,4,66,0,292,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(6545,4,67,0,292,'Simple Product Example'),(6546,4,77,0,292,NULL),(6547,4,99,0,292,NULL),(6548,4,66,0,293,'<h2>Virtual Products are those that do not have a physical or digital counterpart.</h2><p>They do not ship, nor do they have a download link. </p><p>This product type might be used for services like:</p><ul class=\"bullet\"><li>House Cleaning</li><li>1-Year Newsletter Subscription</li></ul><p>Note: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.</p>'),(6549,4,67,0,293,'Virtual Product Example'),(6550,4,77,0,293,NULL),(6551,4,99,0,293,NULL),(6552,4,66,0,294,'<h2>Configurable Product : This product enables your customers to select the variant that they want by choosing options.</h2>\r\n<p>For example, you can sell T-shirts in two colors and three sizes. You would create six simple products as individual products (each with its own SKUs) and then add these six to a configurable product where customers can choose the size and color, and then add it to their cart. Very similar functionality is possible by using Custom Options for Simple products. The difference between a configurable product and a product including custom options is that inventory is not checked or updated for individual options during the purchase of the custom options.</p>\r\n'),(6553,4,67,0,294,'Configurable Product Example'),(6554,4,77,0,294,NULL),(6555,4,99,0,294,NULL),(6556,4,66,0,295,'<h2>Grouped products allow you to create a new product using one or more existing products in your store</h2>\r\n'),(6557,4,67,0,295,'Grouped Products Example'),(6558,4,77,0,295,NULL),(6559,4,99,0,295,NULL),(6560,4,66,0,296,'<h2>This product type is also known as a “kit” in other eCommerce software. </h2>\r\n<p>This product type is ideal for circumstances where the user have to select a number of configurable options, but at least one option. </p>\r\n'),(6561,4,67,0,296,'Bundle Products Example'),(6562,4,77,0,296,NULL),(6563,4,99,0,296,NULL),(6564,4,66,0,297,'<h2>Downloadable products are similar to virtual products, except that they include the ability to add one or more digital files for download.</h2>'),(6565,4,67,0,297,'Downloadable Product Example'),(6566,4,77,0,297,NULL),(6567,4,99,0,297,NULL),(6568,4,66,0,298,'<h2>H2 title goes here</h2><p><img class=\"pic-right\" title=\"class=pic-right\" src=\"/media//template/magento_theme.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h3>H3 title goes here</h3><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><h4>H4 title goes here</h4><ul class=\"bullet\"><li>Ul class \"bullet\" </li><li>Consectetur adipisicing elit</li><li>Ipsum dolor</li></ul><p><img class=\"pic-left\" title=\"class=pic-left\" src=\"/media/template/magento_template.jpg\" alt=\"Web-Experiment.info Premium Magento Template\"></p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p><hr><h4>Definition list DL</h4><dl><dt>Lorem ipsum dolor</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd><dt>Consectetur adipisicing elit</dt><dd>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</dd></dl><hr><h4>Ordered lists OL</h4><ol><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li><li>Lorem ipsum dolor</li></ol>\r\n'),(6569,4,67,0,298,'Product with Options Example'),(6570,4,77,0,298,NULL),(6571,4,99,0,298,NULL),(6572,4,77,0,226,NULL),(6573,4,99,0,226,NULL),(6582,4,77,0,252,NULL),(6583,4,99,0,252,NULL),(6622,4,77,0,239,NULL),(6623,4,99,0,239,NULL),(6630,4,77,0,238,NULL),(6631,4,99,0,238,NULL),(6634,4,77,0,236,NULL),(6635,4,99,0,236,NULL),(6638,4,77,0,232,NULL),(6639,4,99,0,232,NULL),(6642,4,77,0,231,NULL),(6643,4,99,0,231,NULL),(6646,4,77,0,227,NULL),(6647,4,99,0,227,NULL),(6705,4,77,0,290,NULL),(6706,4,99,0,290,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_entity_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_tier_price` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `all_groups` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Applicable To All Customer Groups',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'QTY',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `E8AB433B9ACB00343ABB312AD2FAB087` (`entity_id`,`all_groups`,`customer_group_id`,`qty`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_TIER_PRICE_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_TIER_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_6E08D719F0501DD1D8E6D4EFF2511C85` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_TIER_PRICE_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Tier Price Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_tier_price`
--

LOCK TABLES `catalog_product_entity_tier_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_tier_price` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_tier_price` VALUES (1,1,1,0,2.0000,140.0000,0),(2,1,1,0,3.0000,100.0000,0),(3,292,1,0,3.0000,300.0000,0);
/*!40000 ALTER TABLE `catalog_product_entity_tier_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_product_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_ENTT_VCHR_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_ENTT_VCHR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6276 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_varchar`
--

LOCK TABLES `catalog_product_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_varchar` VALUES (1,4,65,0,1,'Product'),(2,4,90,0,1,'test-product'),(3,4,110,0,1,NULL),(4,4,111,0,1,'2'),(5,4,112,0,1,'4'),(6,4,76,0,1,NULL),(7,4,78,0,1,NULL),(8,4,79,0,1,'/f/i/file_5_88.jpg'),(9,4,80,0,1,'/f/i/file_5_88.jpg'),(10,4,81,0,1,'/f/i/file_5_88.jpg'),(11,4,96,0,1,NULL),(12,4,100,0,1,NULL),(13,4,102,0,1,'container1'),(14,4,116,0,1,NULL),(15,4,91,1,1,'test-product.html'),(16,4,91,0,1,'test-product.html'),(146,4,105,0,1,NULL),(147,4,106,0,1,NULL),(148,4,107,0,1,NULL),(2514,4,65,0,226,'Product'),(2515,4,102,0,226,'container2'),(2516,4,90,0,226,'gund-all-stars-sports-glove-chair'),(2517,4,91,1,226,'gund-all-stars-sports-glove-chair.html'),(2518,4,91,0,226,'gund-all-stars-sports-glove-chair.html'),(2519,4,81,0,226,'/5/7/5700651cbl3tp1ql.jpg'),(2520,4,80,0,226,'/5/7/5700651cbl3tp1ql.jpg'),(2521,4,79,0,226,'/5/7/5700651cbl3tp1ql.jpg'),(2522,4,105,0,226,NULL),(2523,4,106,0,226,NULL),(2524,4,107,0,226,NULL),(2525,4,65,0,227,'Product'),(2526,4,102,0,227,'container2'),(2527,4,90,0,227,'disney-princess-pretty-pink-toddler-bed'),(2528,4,91,1,227,'disney-princess-pretty-pink-toddler-bed.html'),(2529,4,91,0,227,'disney-princess-pretty-pink-toddler-bed.html'),(2530,4,81,0,227,'/6/2/6276251gv8imkzgl_3.jpg'),(2531,4,80,0,227,'/6/2/6276251gv8imkzgl_3.jpg'),(2532,4,79,0,227,'/6/2/6276251gv8imkzgl_3.jpg'),(2533,4,105,0,227,NULL),(2534,4,106,0,227,NULL),(2535,4,107,0,227,NULL),(2569,4,65,0,231,'Product'),(2570,4,102,0,231,'container2'),(2571,4,90,0,231,'nickelodeon-sponge-bob-toddler-bed'),(2572,4,91,1,231,'nickelodeon-sponge-bob-toddler-bed.html'),(2573,4,91,0,231,'nickelodeon-sponge-bob-toddler-bed.html'),(2574,4,81,0,231,'/2/1/219855146skdaqnl_1.jpg'),(2575,4,80,0,231,'/2/1/219855146skdaqnl_1.jpg'),(2576,4,79,0,231,'/2/1/219855146skdaqnl_1.jpg'),(2577,4,105,0,231,NULL),(2578,4,106,0,231,NULL),(2579,4,107,0,231,NULL),(2580,4,65,0,232,'Product'),(2581,4,102,0,232,'container2'),(2582,4,90,0,232,'4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails'),(2583,4,91,1,232,'4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html'),(2584,4,91,0,232,'4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html'),(2585,4,81,0,232,'/5/7/57513319fxpdryjl_1.jpg'),(2586,4,80,0,232,'/5/7/57513319fxpdryjl_1.jpg'),(2587,4,79,0,232,'/5/7/57513319fxpdryjl_1.jpg'),(2588,4,105,0,232,NULL),(2589,4,106,0,232,NULL),(2590,4,107,0,232,NULL),(2624,4,65,0,236,'Product'),(2625,4,102,0,236,'container2'),(2626,4,90,0,236,'nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer'),(2627,4,91,1,236,'nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html'),(2628,4,91,0,236,'nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html'),(2629,4,81,0,236,'/9/8/9834551egofdo9hl.jpg'),(2630,4,80,0,236,'/9/8/9834551egofdo9hl.jpg'),(2631,4,79,0,236,'/9/8/9834551egofdo9hl.jpg'),(2632,4,105,0,236,NULL),(2633,4,106,0,236,NULL),(2634,4,107,0,236,NULL),(2646,4,65,0,238,'Prduct'),(2647,4,102,0,238,'container2'),(2648,4,90,0,238,'tot-tutors-kids-table-and-4-chair-set-plastic'),(2649,4,91,1,238,'tot-tutors-kids-table-and-4-chair-set-plastic.html'),(2650,4,91,0,238,'tot-tutors-kids-table-and-4-chair-set-plastic.html'),(2651,4,81,0,238,'/9/3/9352651swse52brl_1.jpg'),(2652,4,80,0,238,'/9/3/9352651swse52brl_1.jpg'),(2653,4,79,0,238,'/9/3/9352651swse52brl_1.jpg'),(2654,4,105,0,238,NULL),(2655,4,106,0,238,NULL),(2656,4,107,0,238,NULL),(2657,4,65,0,239,'Product'),(2658,4,102,0,239,'container2'),(2659,4,90,0,239,'tot-tutors-book-rack-primary-colors'),(2660,4,91,1,239,'tot-tutors-book-rack-primary-colors.html'),(2661,4,91,0,239,'tot-tutors-book-rack-primary-colors.html'),(2662,4,81,0,239,'/6/2/6276251gv8imkzgl_2.jpg'),(2663,4,80,0,239,'/6/2/6276251gv8imkzgl_2.jpg'),(2664,4,79,0,239,'/6/2/6276251gv8imkzgl_2.jpg'),(2665,4,105,0,239,NULL),(2666,4,106,0,239,NULL),(2667,4,107,0,239,NULL),(2679,4,65,0,241,'Product'),(2680,4,102,0,241,'container2'),(2681,4,90,0,241,'p-kolino-little-sofa-sleeper-green'),(2682,4,91,1,241,'p-kolino-little-sofa-sleeper-green.html'),(2683,4,91,0,241,'p-kolino-little-sofa-sleeper-green.html'),(2684,4,81,0,241,'/9/3/9352651swse52brl.jpg'),(2685,4,80,0,241,'/9/3/9352651swse52brl.jpg'),(2686,4,79,0,241,'/9/3/9352651swse52brl.jpg'),(2687,4,105,0,241,NULL),(2688,4,106,0,241,NULL),(2689,4,107,0,241,NULL),(2690,4,65,0,242,'Product'),(2691,4,102,0,242,'container2'),(2692,4,90,0,242,'p-kolino-silly-soft-seating-lila'),(2693,4,91,1,242,'p-kolino-silly-soft-seating-lila.html'),(2694,4,91,0,242,'p-kolino-silly-soft-seating-lila.html'),(2695,4,81,0,242,'/4/8/4858351hm4qmcr3l_1.jpg'),(2696,4,80,0,242,'/4/8/4858351hm4qmcr3l_1.jpg'),(2697,4,79,0,242,'/4/8/4858351hm4qmcr3l_1.jpg'),(2698,4,105,0,242,NULL),(2699,4,106,0,242,NULL),(2700,4,107,0,242,NULL),(2701,4,65,0,243,'Product'),(2702,4,102,0,243,'container2'),(2703,4,90,0,243,'p-kolino-book-buggee-in-orange'),(2704,4,91,1,243,'p-kolino-book-buggee-in-orange.html'),(2705,4,91,0,243,'p-kolino-book-buggee-in-orange.html'),(2706,4,81,0,243,'/3/8/3817831wc2kkavsl_1.jpg'),(2707,4,80,0,243,'/3/8/3817831wc2kkavsl_1.jpg'),(2708,4,79,0,243,'/3/8/3817831wc2kkavsl_1.jpg'),(2709,4,105,0,243,NULL),(2710,4,106,0,243,NULL),(2711,4,107,0,243,NULL),(2712,4,65,0,244,'Product'),(2713,4,102,0,244,'container2'),(2714,4,90,0,244,'p-kolino-nesting-birds'),(2715,4,91,1,244,'p-kolino-nesting-birds.html'),(2716,4,91,0,244,'p-kolino-nesting-birds.html'),(2717,4,81,0,244,'/3/5/3593841ukdyrthxl_1.jpg'),(2718,4,80,0,244,'/3/5/3593841ukdyrthxl_1.jpg'),(2719,4,79,0,244,'/3/5/3593841ukdyrthxl_1.jpg'),(2720,4,105,0,244,NULL),(2721,4,106,0,244,NULL),(2722,4,107,0,244,NULL),(2723,4,65,0,245,'Product'),(2724,4,102,0,245,'container2'),(2725,4,90,0,245,'p-kolino-children-desk-white'),(2726,4,91,1,245,'p-kolino-children-desk-white.html'),(2727,4,91,0,245,'p-kolino-children-desk-white.html'),(2728,4,81,0,245,'/1/8/1842441ugnfbh7kl_1.jpg'),(2729,4,80,0,245,'/1/8/1842441ugnfbh7kl_1.jpg'),(2730,4,79,0,245,'/1/8/1842441ugnfbh7kl_1.jpg'),(2731,4,105,0,245,NULL),(2732,4,106,0,245,NULL),(2733,4,107,0,245,NULL),(2734,4,65,0,246,'Product'),(2735,4,102,0,246,'container2'),(2736,4,90,0,246,'p-kolino-tree-trable-with-zebra-and-giraffe-chairs'),(2737,4,91,1,246,'p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html'),(2738,4,91,0,246,'p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html'),(2739,4,81,0,246,'/2/1/219855146skdaqnl.jpg'),(2740,4,80,0,246,'/2/1/219855146skdaqnl.jpg'),(2741,4,79,0,246,'/2/1/219855146skdaqnl.jpg'),(2742,4,105,0,246,NULL),(2743,4,106,0,246,NULL),(2744,4,107,0,246,NULL),(2745,4,65,0,247,'Product'),(2746,4,102,0,247,'container2'),(2747,4,90,0,247,'p-kolino-book-buggee-fire-truck'),(2748,4,91,1,247,'p-kolino-book-buggee-fire-truck.html'),(2749,4,91,0,247,'p-kolino-book-buggee-fire-truck.html'),(2750,4,81,0,247,'/6/4/64397412hiqswx4l.jpg'),(2751,4,80,0,247,'/6/4/64397412hiqswx4l.jpg'),(2752,4,79,0,247,'/6/4/64397412hiqswx4l.jpg'),(2753,4,105,0,247,NULL),(2754,4,106,0,247,NULL),(2755,4,107,0,247,NULL),(2756,4,65,0,248,'Product'),(2757,4,102,0,248,'container2'),(2758,4,90,0,248,'p-kolino-new-little-reader-chair-flower-pink'),(2759,4,91,1,248,'p-kolino-new-little-reader-chair-flower-pink.html'),(2760,4,91,0,248,'p-kolino-new-little-reader-chair-flower-pink.html'),(2761,4,81,0,248,'/5/7/57513319fxpdryjl.jpg'),(2762,4,80,0,248,'/5/7/57513319fxpdryjl.jpg'),(2763,4,79,0,248,'/5/7/57513319fxpdryjl.jpg'),(2764,4,105,0,248,NULL),(2765,4,106,0,248,NULL),(2766,4,107,0,248,NULL),(2767,4,65,0,249,'Best product for the home with very loooooooooooong title'),(2768,4,102,0,249,'container2'),(2769,4,90,0,249,'p-kolino-book-buggee-crown'),(2770,4,91,1,249,'p-kolino-book-buggee-crown.html'),(2771,4,91,0,249,'p-kolino-book-buggee-crown.html'),(2772,4,81,0,249,'/8/5/8581731c6dlwyxel.jpg'),(2773,4,80,0,249,'/8/5/8581731c6dlwyxel.jpg'),(2774,4,79,0,249,'/8/5/8581731c6dlwyxel.jpg'),(2775,4,105,0,249,NULL),(2776,4,106,0,249,NULL),(2777,4,107,0,249,NULL),(2778,4,65,0,250,'Prodict'),(2779,4,102,0,250,'container2'),(2780,4,90,0,250,'p-kolino-safari-duck-and-ostrich-chairs'),(2781,4,91,1,250,'p-kolino-safari-duck-and-ostrich-chairs.html'),(2782,4,91,0,250,'p-kolino-safari-duck-and-ostrich-chairs.html'),(2783,4,81,0,250,'/6/2/6276251gv8imkzgl_1.jpg'),(2784,4,80,0,250,'/6/2/6276251gv8imkzgl_1.jpg'),(2785,4,79,0,250,'/6/2/6276251gv8imkzgl_1.jpg'),(2786,4,105,0,250,NULL),(2787,4,106,0,250,NULL),(2788,4,107,0,250,NULL),(2789,4,65,0,251,'Product'),(2790,4,102,0,251,'container2'),(2791,4,90,0,251,'p-kolino-klick-children-s-desk-orange'),(2792,4,91,1,251,'p-kolino-klick-children-s-desk-orange.html'),(2793,4,91,0,251,'p-kolino-klick-children-s-desk-orange.html'),(2794,4,81,0,251,'/4/8/4858351hm4qmcr3l.jpg'),(2795,4,80,0,251,'/4/8/4858351hm4qmcr3l.jpg'),(2796,4,79,0,251,'/4/8/4858351hm4qmcr3l.jpg'),(2797,4,105,0,251,NULL),(2798,4,106,0,251,NULL),(2799,4,107,0,251,NULL),(2800,4,65,0,252,'Product'),(2801,4,102,0,252,'container2'),(2802,4,90,0,252,'safari-collection-tree-table-w-animal-chairs'),(2803,4,91,1,252,'safari-collection-tree-table-w-animal-chairs.html'),(2804,4,91,0,252,'safari-collection-tree-table-w-animal-chairs.html'),(2805,4,81,0,252,'/3/8/3817831wc2kkavsl.jpg'),(2806,4,80,0,252,'/3/8/3817831wc2kkavsl.jpg'),(2807,4,79,0,252,'/3/8/3817831wc2kkavsl.jpg'),(2808,4,105,0,252,NULL),(2809,4,106,0,252,NULL),(2810,4,107,0,252,NULL),(2811,4,65,0,253,'Product'),(2812,4,102,0,253,'container2'),(2813,4,90,0,253,'p-kolino-little-one-s-chair'),(2814,4,91,1,253,'p-kolino-little-one-s-chair.html'),(2815,4,91,0,253,'p-kolino-little-one-s-chair.html'),(2816,4,81,0,253,'/3/5/3593841ukdyrthxl.jpg'),(2817,4,80,0,253,'/3/5/3593841ukdyrthxl.jpg'),(2818,4,79,0,253,'/3/5/3593841ukdyrthxl.jpg'),(2819,4,105,0,253,NULL),(2820,4,106,0,253,NULL),(2821,4,107,0,253,NULL),(2833,4,65,0,255,'Product'),(2834,4,102,0,255,'container2'),(2835,4,90,0,255,'p-kolino-zebra-rocking-chair'),(2836,4,91,1,255,'p-kolino-zebra-rocking-chair.html'),(2837,4,91,0,255,'p-kolino-zebra-rocking-chair.html'),(2838,4,81,0,255,'/1/8/1842441ugnfbh7kl.jpg'),(2839,4,80,0,255,'/1/8/1842441ugnfbh7kl.jpg'),(2840,4,79,0,255,'/1/8/1842441ugnfbh7kl.jpg'),(2841,4,105,0,255,NULL),(2842,4,106,0,255,NULL),(2843,4,107,0,255,NULL),(4672,4,110,0,255,NULL),(4673,4,111,0,255,'2'),(4674,4,112,0,255,'4'),(4675,4,76,0,255,NULL),(4676,4,78,0,255,NULL),(4677,4,96,0,255,NULL),(4678,4,100,0,255,NULL),(4679,4,116,0,255,NULL),(4690,4,110,0,253,NULL),(4691,4,111,0,253,'2'),(4692,4,112,0,253,'4'),(4693,4,76,0,253,NULL),(4694,4,78,0,253,NULL),(4695,4,96,0,253,NULL),(4696,4,100,0,253,NULL),(4697,4,116,0,253,NULL),(4699,4,110,0,251,NULL),(4700,4,111,0,251,'2'),(4701,4,112,0,251,'4'),(4702,4,76,0,251,NULL),(4703,4,78,0,251,NULL),(4704,4,96,0,251,NULL),(4705,4,100,0,251,NULL),(4706,4,116,0,251,NULL),(4708,4,110,0,250,NULL),(4709,4,111,0,250,'2'),(4710,4,112,0,250,'4'),(4711,4,76,0,250,NULL),(4712,4,78,0,250,NULL),(4713,4,96,0,250,NULL),(4714,4,100,0,250,NULL),(4715,4,116,0,250,NULL),(4717,4,110,0,249,NULL),(4718,4,111,0,249,'2'),(4719,4,112,0,249,'4'),(4720,4,76,0,249,NULL),(4721,4,78,0,249,NULL),(4722,4,96,0,249,NULL),(4723,4,100,0,249,NULL),(4724,4,116,0,249,NULL),(4726,4,110,0,248,NULL),(4727,4,111,0,248,'2'),(4728,4,112,0,248,'4'),(4729,4,76,0,248,NULL),(4730,4,78,0,248,NULL),(4731,4,96,0,248,NULL),(4732,4,100,0,248,NULL),(4733,4,116,0,248,NULL),(4735,4,110,0,247,NULL),(4736,4,111,0,247,'2'),(4737,4,112,0,247,'4'),(4738,4,76,0,247,NULL),(4739,4,78,0,247,NULL),(4740,4,96,0,247,NULL),(4741,4,100,0,247,NULL),(4742,4,116,0,247,NULL),(4744,4,110,0,246,NULL),(4745,4,111,0,246,'2'),(4746,4,112,0,246,'4'),(4747,4,76,0,246,NULL),(4748,4,78,0,246,NULL),(4749,4,96,0,246,NULL),(4750,4,100,0,246,NULL),(4751,4,116,0,246,NULL),(4753,4,110,0,245,NULL),(4754,4,111,0,245,'2'),(4755,4,112,0,245,'4'),(4756,4,76,0,245,NULL),(4757,4,78,0,245,NULL),(4758,4,96,0,245,NULL),(4759,4,100,0,245,NULL),(4760,4,116,0,245,NULL),(4762,4,110,0,244,NULL),(4763,4,111,0,244,'2'),(4764,4,112,0,244,'4'),(4765,4,76,0,244,NULL),(4766,4,78,0,244,NULL),(4767,4,96,0,244,NULL),(4768,4,100,0,244,NULL),(4769,4,116,0,244,NULL),(4771,4,110,0,243,NULL),(4772,4,111,0,243,'2'),(4773,4,112,0,243,'4'),(4774,4,76,0,243,NULL),(4775,4,78,0,243,NULL),(4776,4,96,0,243,NULL),(4777,4,100,0,243,NULL),(4778,4,116,0,243,NULL),(4780,4,110,0,242,NULL),(4781,4,111,0,242,'2'),(4782,4,112,0,242,'4'),(4783,4,76,0,242,NULL),(4784,4,78,0,242,NULL),(4785,4,96,0,242,NULL),(4786,4,100,0,242,NULL),(4787,4,116,0,242,NULL),(4789,4,110,0,241,NULL),(4790,4,111,0,241,'2'),(4791,4,112,0,241,'4'),(4792,4,76,0,241,NULL),(4793,4,78,0,241,NULL),(4794,4,96,0,241,NULL),(4795,4,100,0,241,NULL),(4796,4,116,0,241,NULL),(5419,4,65,0,287,'Hot! Bikini white, yellow or black'),(5420,4,102,0,287,'container2'),(5421,4,90,0,287,'hot-bikini-white-yellow-or-black'),(5422,4,91,1,287,'hot-bikini-white-yellow-or-black.html'),(5423,4,91,0,287,'hot-bikini-white-yellow-or-black.html'),(5424,4,81,0,287,'/3/1/3113241uzg_2BLmC1L.jpg'),(5425,4,80,0,287,'/3/1/3113241uzg_2BLmC1L.jpg'),(5426,4,79,0,287,'/3/1/3113241uzg_2BLmC1L.jpg'),(5427,4,105,0,287,NULL),(5428,4,106,0,287,NULL),(5429,4,107,0,287,NULL),(5430,4,65,0,288,'Designer Monokini Halter String Ties Womens Sexy Bikini'),(5431,4,102,0,288,'container2'),(5432,4,90,0,288,'designer-monokini-halter-string-ties-womens-sexy-bikini'),(5433,4,91,1,288,'designer-monokini-halter-string-ties-womens-sexy-bikini.html'),(5434,4,91,0,288,'designer-monokini-halter-string-ties-womens-sexy-bikini.html'),(5435,4,81,0,288,'/5/5/5512951-nlqe_2BMpL.jpg'),(5436,4,80,0,288,'/5/5/5512951-nlqe_2BMpL.jpg'),(5437,4,79,0,288,'/5/5/5512951-nlqe_2BMpL.jpg'),(5438,4,105,0,288,NULL),(5439,4,106,0,288,NULL),(5440,4,107,0,288,NULL),(5441,4,65,0,289,'Metallic Slingshot Monokini (As Shown;One Size)'),(5442,4,102,0,289,'container2'),(5443,4,90,0,289,'metallic-slingshot-monokini-as-shown-one-size'),(5444,4,91,1,289,'metallic-slingshot-monokini-as-shown-one-size.html'),(5445,4,91,0,289,'metallic-slingshot-monokini-as-shown-one-size.html'),(5446,4,81,0,289,'/2/8/28391413qWC2vpOL.jpg'),(5447,4,80,0,289,'/2/8/28391413qWC2vpOL.jpg'),(5448,4,79,0,289,'/2/8/28391413qWC2vpOL.jpg'),(5449,4,105,0,289,NULL),(5450,4,106,0,289,NULL),(5451,4,107,0,289,NULL),(5452,4,65,0,290,'Hot! Bikini Leopard'),(5453,4,102,0,290,'container2'),(5454,4,90,0,290,'hot-bikini-leopard'),(5455,4,91,1,290,'hot-bikini-leopard.html'),(5456,4,91,0,290,'hot-bikini-leopard.html'),(5457,4,81,0,290,'/7/8/7813141r6v6ecpfl_1.jpg'),(5458,4,80,0,290,'/7/8/7813141r6v6ecpfl_1.jpg'),(5459,4,79,0,290,'/7/8/7813141r6v6ecpfl_1.jpg'),(5460,4,105,0,290,NULL),(5461,4,106,0,290,NULL),(5462,4,107,0,290,NULL),(5463,4,65,0,291,'Daisy Corsets Sequin Underwire Corset'),(5464,4,102,0,291,'container2'),(5465,4,90,0,291,'daisy-corsets-sequin-underwire-corset'),(5466,4,91,1,291,'daisy-corsets-sequin-underwire-corset.html'),(5467,4,91,0,291,'daisy-corsets-sequin-underwire-corset.html'),(5468,4,81,0,291,'/1/4/1432551QvKKpVYLL.jpg'),(5469,4,80,0,291,'/1/4/1432551QvKKpVYLL.jpg'),(5470,4,79,0,291,'/1/4/1432551QvKKpVYLL.jpg'),(5471,4,105,0,291,NULL),(5472,4,106,0,291,NULL),(5473,4,107,0,291,NULL),(5560,4,65,0,292,'Simple Product'),(5561,4,76,0,292,NULL),(5562,4,78,0,292,NULL),(5563,4,79,0,292,'/f/i/file_5_96.jpg'),(5564,4,80,0,292,'/f/i/file_5_96.jpg'),(5565,4,81,0,292,'/f/i/file_5_96.jpg'),(5566,4,90,0,292,'simple-product-example'),(5567,4,91,0,292,'simple-product-example.html'),(5568,4,100,0,292,NULL),(5569,4,102,0,292,'container1'),(5570,4,105,0,292,NULL),(5571,4,106,0,292,NULL),(5572,4,107,0,292,NULL),(5573,4,110,0,292,'HU'),(5574,4,111,0,292,'2'),(5575,4,112,0,292,'4'),(5576,4,116,0,292,'0'),(5577,4,88,0,292,NULL),(5578,4,65,0,293,'Virtual Product'),(5579,4,76,0,293,NULL),(5580,4,78,0,293,NULL),(5581,4,79,0,293,'/8/3/8308341syzd4qthl.jpg'),(5582,4,80,0,293,'/8/3/8308341syzd4qthl.jpg'),(5583,4,81,0,293,'/8/3/8308341syzd4qthl.jpg'),(5584,4,90,0,293,'virtual-product-example'),(5585,4,91,0,293,'virtual-product-example.html'),(5586,4,100,0,293,NULL),(5587,4,102,0,293,'container2'),(5588,4,105,0,293,NULL),(5589,4,106,0,293,NULL),(5590,4,107,0,293,NULL),(5591,4,111,0,293,'2'),(5592,4,112,0,293,'4'),(5593,4,116,0,293,'0'),(5594,4,88,0,293,NULL),(5595,4,65,0,294,'Configurable Product'),(5596,4,76,0,294,NULL),(5597,4,78,0,294,NULL),(5598,4,79,0,294,'/4/5/4596251m0ds1xeol.jpg'),(5599,4,80,0,294,'/4/5/4596251m0ds1xeol.jpg'),(5600,4,81,0,294,'/4/5/4596251m0ds1xeol.jpg'),(5601,4,90,0,294,'configurable-example'),(5602,4,91,0,294,'configurable-example.html'),(5603,4,100,0,294,'two_columns_right'),(5604,4,102,0,294,'container2'),(5605,4,105,0,294,NULL),(5606,4,106,0,294,NULL),(5607,4,107,0,294,NULL),(5608,4,110,0,294,'AU'),(5609,4,111,0,294,'2'),(5610,4,112,0,294,'4'),(5611,4,116,0,294,'0'),(5612,4,88,0,294,NULL),(5613,4,65,0,295,'Grouped Products'),(5614,4,76,0,295,NULL),(5615,4,78,0,295,NULL),(5616,4,79,0,295,'/f/i/file_5_87.jpg'),(5617,4,80,0,295,'/f/i/file_5_87.jpg'),(5618,4,81,0,295,'/f/i/file_5_87.jpg'),(5619,4,90,0,295,'grouped-product-example'),(5620,4,91,0,295,'grouped-product-example.html'),(5621,4,100,0,295,NULL),(5622,4,102,0,295,'container1'),(5623,4,105,0,295,NULL),(5624,4,106,0,295,NULL),(5625,4,107,0,295,NULL),(5626,4,110,0,295,'AR'),(5627,4,116,0,295,'0'),(5628,4,88,0,295,NULL),(5629,4,65,0,296,'Bundled Products'),(5630,4,76,0,296,NULL),(5631,4,78,0,296,NULL),(5632,4,79,0,296,'/6/2/6276251gv8imkzgl.jpg'),(5633,4,80,0,296,'/6/2/6276251gv8imkzgl.jpg'),(5634,4,81,0,296,'/6/2/6276251gv8imkzgl.jpg'),(5635,4,90,0,296,'bundle-product-example'),(5636,4,91,0,296,'bundle-product-example.html'),(5637,4,100,0,296,NULL),(5638,4,102,0,296,'container2'),(5639,4,105,0,296,NULL),(5640,4,106,0,296,NULL),(5641,4,107,0,296,NULL),(5642,4,110,0,296,'BG'),(5643,4,111,0,296,'0'),(5644,4,116,0,296,'0'),(5645,4,88,0,296,NULL),(5646,4,65,0,297,'Downloadable Product'),(5647,4,76,0,297,NULL),(5648,4,78,0,297,NULL),(5649,4,79,0,297,'/2/3/2338351ysn7gguql.jpg'),(5650,4,80,0,297,'/2/3/2338351ysn7gguql.jpg'),(5651,4,81,0,297,'/2/3/2338351ysn7gguql.jpg'),(5652,4,90,0,297,'downloadable-product-example'),(5653,4,91,0,297,'downloadable-product-example.html'),(5654,4,100,0,297,NULL),(5655,4,102,0,297,'container2'),(5656,4,105,0,297,NULL),(5657,4,106,0,297,NULL),(5658,4,107,0,297,NULL),(5659,4,111,0,297,'2'),(5660,4,112,0,297,'4'),(5661,4,116,0,297,'0'),(5662,4,123,0,297,'Samples'),(5663,4,124,0,297,'Links'),(5664,4,88,0,297,NULL),(5665,4,65,0,298,'Product with Options'),(5666,4,76,0,298,NULL),(5667,4,78,0,298,NULL),(5668,4,79,0,298,'/7/5/754344125vs8zawl.jpg'),(5669,4,80,0,298,'/7/5/754344125vs8zawl.jpg'),(5670,4,81,0,298,'/7/5/754344125vs8zawl.jpg'),(5671,4,90,0,298,'product-with-options-example'),(5672,4,91,0,298,'product-with-options-example.html'),(5673,4,100,0,298,'two_columns_right'),(5674,4,102,0,298,'container2'),(5675,4,105,0,298,NULL),(5676,4,106,0,298,NULL),(5677,4,107,0,298,NULL),(5678,4,110,0,298,'HU'),(5679,4,111,0,298,'2'),(5680,4,112,0,298,'4'),(5681,4,116,0,298,'0'),(5682,4,88,0,298,NULL),(5683,4,96,0,292,NULL),(5690,4,96,0,293,NULL),(5697,4,96,0,294,NULL),(5704,4,96,0,295,NULL),(5711,4,96,0,296,NULL),(5729,4,96,0,297,NULL),(5736,4,96,0,298,NULL),(5748,4,91,1,292,'simple-product-example.html'),(5758,4,91,1,294,'configurable-example.html'),(5764,4,91,1,295,'grouped-product-example.html'),(5765,4,110,0,226,NULL),(5766,4,111,0,226,'2'),(5767,4,112,0,226,'4'),(5768,4,76,0,226,NULL),(5769,4,78,0,226,NULL),(5770,4,96,0,226,NULL),(5771,4,100,0,226,NULL),(5772,4,116,0,226,NULL),(5808,4,110,0,252,NULL),(5809,4,111,0,252,'2'),(5810,4,112,0,252,'4'),(5811,4,76,0,252,NULL),(5812,4,78,0,252,NULL),(5813,4,96,0,252,NULL),(5814,4,100,0,252,NULL),(5815,4,116,0,252,NULL),(5953,4,110,0,239,NULL),(5954,4,111,0,239,'2'),(5955,4,112,0,239,'4'),(5956,4,76,0,239,NULL),(5957,4,78,0,239,NULL),(5958,4,96,0,239,NULL),(5959,4,100,0,239,NULL),(5960,4,116,0,239,NULL),(5981,4,110,0,238,NULL),(5982,4,111,0,238,'2'),(5983,4,112,0,238,'4'),(5984,4,76,0,238,NULL),(5985,4,78,0,238,NULL),(5986,4,96,0,238,NULL),(5987,4,100,0,238,NULL),(5988,4,116,0,238,NULL),(5996,4,110,0,236,NULL),(5997,4,111,0,236,'2'),(5998,4,112,0,236,'4'),(5999,4,76,0,236,NULL),(6000,4,78,0,236,NULL),(6001,4,96,0,236,NULL),(6002,4,100,0,236,NULL),(6003,4,116,0,236,NULL),(6011,4,110,0,232,NULL),(6012,4,111,0,232,'2'),(6013,4,112,0,232,'4'),(6014,4,76,0,232,NULL),(6015,4,78,0,232,NULL),(6016,4,96,0,232,NULL),(6017,4,100,0,232,NULL),(6018,4,116,0,232,NULL),(6026,4,110,0,231,NULL),(6027,4,111,0,231,'2'),(6028,4,112,0,231,'4'),(6029,4,76,0,231,NULL),(6030,4,78,0,231,NULL),(6031,4,96,0,231,NULL),(6032,4,100,0,231,NULL),(6033,4,116,0,231,NULL),(6041,4,110,0,227,NULL),(6042,4,111,0,227,'2'),(6043,4,112,0,227,'4'),(6044,4,76,0,227,NULL),(6045,4,78,0,227,NULL),(6046,4,96,0,227,NULL),(6047,4,100,0,227,NULL),(6048,4,116,0,227,NULL),(6268,4,110,0,290,NULL),(6269,4,111,0,290,'2'),(6270,4,112,0,290,'4'),(6271,4,76,0,290,NULL),(6272,4,78,0,290,NULL),(6273,4,96,0,290,NULL),(6274,4,100,0,290,NULL),(6275,4,116,0,290,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_1`
--

DROP TABLE IF EXISTS `catalog_product_flat_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_1` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set Id',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type Id',
  `cost` decimal(12,4) DEFAULT NULL COMMENT 'Cost',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `enable_googlecheckout` smallint(6) DEFAULT NULL COMMENT 'Enable Googlecheckout',
  `gift_message_available` smallint(6) DEFAULT NULL COMMENT 'Gift Message Available',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `image_label` varchar(255) DEFAULT NULL COMMENT 'Image Label',
  `is_recurring` smallint(6) DEFAULT NULL COMMENT 'Is Recurring',
  `links_exist` int(11) DEFAULT NULL COMMENT 'Links Exist',
  `links_purchased_separately` int(11) DEFAULT NULL COMMENT 'Links Purchased Separately',
  `links_title` varchar(255) DEFAULT NULL COMMENT 'Links Title',
  `msrp` decimal(12,4) DEFAULT NULL COMMENT 'Msrp',
  `msrp_display_actual_price_type` varchar(255) DEFAULT NULL COMMENT 'Msrp Display Actual Price Type',
  `msrp_enabled` smallint(6) DEFAULT NULL COMMENT 'Msrp Enabled',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `news_from_date` datetime DEFAULT NULL COMMENT 'News From Date',
  `news_to_date` datetime DEFAULT NULL COMMENT 'News To Date',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `price_type` int(11) DEFAULT NULL COMMENT 'Price Type',
  `price_view` int(11) DEFAULT NULL COMMENT 'Price View',
  `recurring_profile` text COMMENT 'Recurring Profile',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `shipment_type` int(11) DEFAULT NULL COMMENT 'Shipment Type',
  `short_description` text COMMENT 'Short Description',
  `sku` varchar(64) DEFAULT NULL COMMENT 'Sku',
  `sku_type` int(11) DEFAULT NULL COMMENT 'Sku Type',
  `small_image` varchar(255) DEFAULT NULL COMMENT 'Small Image',
  `small_image_label` varchar(255) DEFAULT NULL COMMENT 'Small Image Label',
  `special_from_date` datetime DEFAULT NULL COMMENT 'Special From Date',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `special_to_date` datetime DEFAULT NULL COMMENT 'Special To Date',
  `tax_class_id` int(10) unsigned DEFAULT NULL COMMENT 'Tax Class Id',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail',
  `thumbnail_label` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Label',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'Url Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  `visibility` smallint(5) unsigned DEFAULT NULL COMMENT 'Visibility',
  `weight` decimal(12,4) DEFAULT NULL COMMENT 'Weight',
  `weight_type` int(11) DEFAULT NULL COMMENT 'Weight Type',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_1_TYPE_ID` (`type_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_1_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_1_NAME` (`name`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_1_PRICE` (`price`),
  CONSTRAINT `FK_CAT_PRD_FLAT_1_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Flat (Store 1)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_1`
--

LOCK TABLES `catalog_product_flat_1` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_1` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_1` VALUES (1,4,'simple',NULL,'2011-11-06 07:20:09',1,NULL,1,NULL,0,NULL,NULL,NULL,120.0000,'4',2,'Product',NULL,NULL,156.0000,NULL,NULL,NULL,1,NULL,'Lorem ipsum Collection\r\n \r\n','test_product',NULL,'/f/i/file_5_88.jpg',NULL,NULL,NULL,NULL,4,'/f/i/file_5_88.jpg',NULL,'2014-01-10 02:23:51','test-product','test-product.html',4,1.0000,NULL),(226,4,'simple',NULL,'2011-11-13 03:14:16',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,104.9900,NULL,NULL,NULL,0,NULL,'All Stars Collection','B0017YJ130',NULL,'/5/7/5700651cbl3tp1ql.jpg',NULL,NULL,NULL,NULL,0,'/5/7/5700651cbl3tp1ql.jpg',NULL,'2014-01-10 02:22:35','gund-all-stars-sports-glove-chair','gund-all-stars-sports-glove-chair.html',4,1.0000,NULL),(227,4,'simple',NULL,'2011-11-13 03:14:21',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,58.7500,NULL,NULL,NULL,0,NULL,'Orange','B001GSKCAI',NULL,'/6/2/6276251gv8imkzgl_3.jpg',NULL,NULL,NULL,NULL,0,'/6/2/6276251gv8imkzgl_3.jpg',NULL,'2014-01-10 02:20:44','disney-princess-pretty-pink-toddler-bed','disney-princess-pretty-pink-toddler-bed.html',4,1.0000,NULL),(231,4,'simple',NULL,'2011-11-13 03:14:38',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,56.4900,NULL,NULL,NULL,0,NULL,'Gray Collection','B003JNEKAG',NULL,'/2/1/219855146skdaqnl_1.jpg',NULL,NULL,NULL,NULL,0,'/2/1/219855146skdaqnl_1.jpg',NULL,'2014-01-10 02:19:55','nickelodeon-sponge-bob-toddler-bed','nickelodeon-sponge-bob-toddler-bed.html',4,1.0000,NULL),(232,4,'simple',NULL,'2011-11-13 03:14:44',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,58.9800,NULL,NULL,NULL,0,NULL,'Black','B002RL8386',NULL,'/5/7/57513319fxpdryjl_1.jpg',NULL,NULL,NULL,NULL,0,'/5/7/57513319fxpdryjl_1.jpg',NULL,'2014-01-10 02:19:19','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html',4,1.0000,NULL),(236,4,'simple',NULL,'2011-11-13 03:15:11',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,38.4000,NULL,NULL,NULL,0,NULL,'White','B003ZV4CVE',NULL,'/9/8/9834551egofdo9hl.jpg',NULL,NULL,NULL,NULL,0,'/9/8/9834551egofdo9hl.jpg',NULL,'2014-01-10 02:18:35','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html',4,1.0000,NULL),(238,4,'simple',NULL,'2011-11-13 03:15:21',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Prduct',NULL,NULL,55.0000,NULL,NULL,NULL,0,NULL,'Soft collection','B001TZLAZE',NULL,'/9/3/9352651swse52brl_1.jpg',NULL,NULL,NULL,NULL,0,'/9/3/9352651swse52brl_1.jpg',NULL,'2014-01-10 02:17:54','tot-tutors-kids-table-and-4-chair-set-plastic','tot-tutors-kids-table-and-4-chair-set-plastic.html',4,1.0000,NULL),(239,4,'simple',NULL,'2011-11-13 03:15:25',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,26.9900,NULL,NULL,NULL,0,NULL,'Best Collection','B000IHJF60',NULL,'/6/2/6276251gv8imkzgl_2.jpg',NULL,NULL,NULL,NULL,0,'/6/2/6276251gv8imkzgl_2.jpg',NULL,'2014-01-10 02:16:23','tot-tutors-book-rack-primary-colors','tot-tutors-book-rack-primary-colors.html',4,1.0000,NULL),(241,4,'simple',NULL,'2011-11-13 03:15:32',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,88.2000,NULL,NULL,NULL,0,NULL,'Best Collection','B002AQIA6S',NULL,'/9/3/9352651swse52brl.jpg',NULL,NULL,NULL,NULL,0,'/9/3/9352651swse52brl.jpg',NULL,'2014-01-10 02:17:01','p-kolino-little-sofa-sleeper-green','p-kolino-little-sofa-sleeper-green.html',4,1.0000,NULL),(242,4,'simple',NULL,'2011-11-13 03:15:37',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,34.9900,NULL,NULL,NULL,0,NULL,'Collection','B004835N8E',NULL,'/4/8/4858351hm4qmcr3l_1.jpg',NULL,'2012-05-07 00:00:00',28.0000,NULL,0,'/4/8/4858351hm4qmcr3l_1.jpg',NULL,'2014-01-10 02:15:08','p-kolino-silly-soft-seating-lila','p-kolino-silly-soft-seating-lila.html',4,1.0000,NULL),(243,4,'simple',NULL,'2011-11-13 03:15:43',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,32.6000,NULL,NULL,NULL,0,NULL,'Orange Collection','B001HX4IXE',NULL,'/3/8/3817831wc2kkavsl_1.jpg',NULL,NULL,NULL,NULL,0,'/3/8/3817831wc2kkavsl_1.jpg',NULL,'2014-01-10 02:14:16','p-kolino-book-buggee-in-orange','p-kolino-book-buggee-in-orange.html',4,1.0000,NULL),(244,4,'simple',NULL,'2011-11-13 03:15:50',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,22.3500,NULL,NULL,NULL,0,NULL,'White Collection','B0039UTUWM',NULL,'/3/5/3593841ukdyrthxl_1.jpg',NULL,NULL,NULL,NULL,0,'/3/5/3593841ukdyrthxl_1.jpg',NULL,'2014-01-10 02:12:53','p-kolino-nesting-birds','p-kolino-nesting-birds.html',4,1.0000,NULL),(245,4,'simple',NULL,'2011-11-13 03:15:58',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,66.9900,NULL,NULL,NULL,0,NULL,'White','B001RIY7CQ',NULL,'/1/8/1842441ugnfbh7kl_1.jpg',NULL,NULL,NULL,NULL,0,'/1/8/1842441ugnfbh7kl_1.jpg',NULL,'2014-01-10 02:12:17','p-kolino-children-desk-white','p-kolino-children-desk-white.html',4,1.0000,NULL),(246,4,'simple',NULL,'2011-11-13 03:16:02',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,164.9900,NULL,NULL,NULL,0,NULL,'Zebra Collection','B004A154PG',NULL,'/2/1/219855146skdaqnl.jpg',NULL,NULL,NULL,NULL,0,'/2/1/219855146skdaqnl.jpg',NULL,'2014-01-10 02:11:44','p-kolino-tree-trable-with-zebra-and-giraffe-chairs','p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html',4,1.0000,NULL),(247,4,'simple',NULL,'2011-11-13 03:16:05',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,34.6500,NULL,NULL,NULL,0,NULL,'Collection','B004VT7Y7I',NULL,'/6/4/64397412hiqswx4l.jpg',NULL,'2012-05-07 00:00:00',28.0000,NULL,0,'/6/4/64397412hiqswx4l.jpg',NULL,'2014-01-10 02:11:06','p-kolino-book-buggee-fire-truck','p-kolino-book-buggee-fire-truck.html',4,1.0000,NULL),(248,4,'simple',NULL,'2011-11-13 03:16:09',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,76.4900,NULL,NULL,NULL,0,NULL,'Flower Pink','B004VT7X8I',NULL,'/5/7/57513319fxpdryjl.jpg',NULL,NULL,NULL,NULL,0,'/5/7/57513319fxpdryjl.jpg',NULL,'2014-01-10 02:09:42','p-kolino-new-little-reader-chair-flower-pink','p-kolino-new-little-reader-chair-flower-pink.html',4,1.0000,NULL),(249,4,'simple',NULL,'2011-11-13 03:16:16',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Best product for the home with very loooooooooooong title',NULL,NULL,35.9500,NULL,NULL,NULL,0,NULL,'Crown','B004VT7XVA',NULL,'/8/5/8581731c6dlwyxel.jpg',NULL,NULL,NULL,NULL,0,'/8/5/8581731c6dlwyxel.jpg',NULL,'2014-01-13 22:15:01','p-kolino-book-buggee-crown','p-kolino-book-buggee-crown.html',4,1.0000,NULL),(250,4,'simple',NULL,'2011-11-13 03:16:22',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Prodict',NULL,NULL,83.4800,NULL,NULL,NULL,0,NULL,'Safari Collection ','B004A154PQ',NULL,'/6/2/6276251gv8imkzgl_1.jpg',NULL,NULL,NULL,NULL,0,'/6/2/6276251gv8imkzgl_1.jpg',NULL,'2014-01-10 02:08:11','p-kolino-safari-duck-and-ostrich-chairs','p-kolino-safari-duck-and-ostrich-chairs.html',4,1.0000,NULL),(251,4,'simple',NULL,'2011-11-13 03:16:30',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,168.0000,NULL,NULL,NULL,0,NULL,'Orange','B000WYJ33E',NULL,'/4/8/4858351hm4qmcr3l.jpg',NULL,NULL,NULL,NULL,0,'/4/8/4858351hm4qmcr3l.jpg',NULL,'2014-01-10 02:07:35','p-kolino-klick-children-s-desk-orange','p-kolino-klick-children-s-desk-orange.html',4,1.0000,NULL),(252,4,'simple',NULL,'2011-11-13 03:16:38',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,48.0000,NULL,NULL,NULL,0,NULL,'Collection','B00545CDQ0',NULL,'/3/8/3817831wc2kkavsl.jpg',NULL,NULL,NULL,NULL,0,'/3/8/3817831wc2kkavsl.jpg',NULL,'2014-01-10 02:06:59','safari-collection-tree-table-w-animal-chairs','safari-collection-tree-table-w-animal-chairs.html',4,1.0000,NULL),(253,4,'simple',NULL,'2011-11-13 03:16:41',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,35.9900,NULL,NULL,NULL,0,NULL,'Extra Fun','B002EDG14U',NULL,'/3/5/3593841ukdyrthxl.jpg',NULL,'2012-05-07 00:00:00',28.0000,NULL,0,'/3/5/3593841ukdyrthxl.jpg',NULL,'2014-01-10 02:06:15','p-kolino-little-one-s-chair','p-kolino-little-one-s-chair.html',4,1.0000,NULL),(255,4,'simple',NULL,'2011-11-13 03:16:56',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,53.9800,NULL,NULL,NULL,0,NULL,'Safari Collection ','B004A154P6',NULL,'/1/8/1842441ugnfbh7kl.jpg',NULL,NULL,NULL,NULL,0,'/1/8/1842441ugnfbh7kl.jpg',NULL,'2014-01-10 02:05:41','p-kolino-zebra-rocking-chair','p-kolino-zebra-rocking-chair.html',4,1.0000,NULL),(287,4,'simple',NULL,'2012-05-08 02:01:42',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hot! Bikini white, yellow or black',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B006XFJXF4',NULL,'/3/1/3113241uzg_2BLmC1L.jpg',NULL,NULL,26.0000,NULL,0,'/3/1/3113241uzg_2BLmC1L.jpg',NULL,'2012-05-08 02:01:46','hot-bikini-white-yellow-or-black','hot-bikini-white-yellow-or-black.html',4,1.0000,NULL),(288,4,'simple',NULL,'2012-05-08 02:01:48',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Designer Monokini Halter String Ties Womens Sexy Bikini',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B003VSOKQI',NULL,'/5/5/5512951-nlqe_2BMpL.jpg',NULL,NULL,26.0000,NULL,0,'/5/5/5512951-nlqe_2BMpL.jpg',NULL,'2012-05-08 02:01:53','designer-monokini-halter-string-ties-womens-sexy-bikini','designer-monokini-halter-string-ties-womens-sexy-bikini.html',4,1.0000,NULL),(289,4,'simple',NULL,'2012-05-08 02:01:55',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Metallic Slingshot Monokini (As Shown;One Size)',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B0040WRM5K',NULL,'/2/8/28391413qWC2vpOL.jpg',NULL,NULL,26.0000,NULL,0,'/2/8/28391413qWC2vpOL.jpg',NULL,'2012-05-08 02:01:58','metallic-slingshot-monokini-as-shown-one-size','metallic-slingshot-monokini-as-shown-one-size.html',4,1.0000,NULL),(290,4,'simple',NULL,'2012-05-08 02:02:00',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hot! Bikini Leopard',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B005PPMSOG',NULL,'/7/8/7813141R6v6eCPfL.jpg',NULL,NULL,26.0000,NULL,0,'/7/8/7813141R6v6eCPfL.jpg',NULL,'2012-05-08 02:02:02','hot-bikini-leopard','hot-bikini-leopard.html',4,1.0000,NULL),(291,4,'simple',NULL,'2012-05-08 02:02:05',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy Corsets Sequin Underwire Corset',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B005FGF38S',NULL,'/1/4/1432551QvKKpVYLL.jpg',NULL,NULL,26.0000,NULL,0,'/1/4/1432551QvKKpVYLL.jpg',NULL,'2012-05-08 02:02:07','daisy-corsets-sequin-underwire-corset','daisy-corsets-sequin-underwire-corset.html',4,1.0000,NULL),(292,4,'simple',NULL,'2013-02-13 12:04:34',1,0,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Simple Product','2014-01-09 00:00:00',NULL,373.9900,NULL,NULL,NULL,0,NULL,'Simple Product Example','simple_product_example',NULL,'/f/i/file_5_96.jpg',NULL,'2013-02-10 00:00:00',NULL,NULL,0,'/f/i/file_5_96.jpg',NULL,'2014-01-10 04:02:54','simple-product-example','simple-product-example.html',4,1.0000,NULL),(293,4,'virtual',NULL,'2013-02-13 12:04:37',1,0,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Virtual Product','2014-01-09 00:00:00',NULL,99.0000,NULL,NULL,NULL,0,NULL,'Virtual Product Example','virtual_product_example',NULL,'/8/3/8308341syzd4qthl.jpg',NULL,'2013-02-10 00:00:00',75.0000,NULL,0,'/8/3/8308341syzd4qthl.jpg',NULL,'2014-01-10 04:00:49','virtual-product-example','virtual-product-example.html',4,NULL,NULL),(294,4,'configurable',NULL,'2013-02-13 12:04:40',1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,'4',2,'Configurable Product','2014-01-09 00:00:00',NULL,3.0000,NULL,NULL,NULL,1,NULL,'Configurable Product Example','configurable_example',NULL,'/4/5/4596251m0ds1xeol.jpg',NULL,NULL,NULL,NULL,0,'/4/5/4596251m0ds1xeol.jpg',NULL,'2014-01-15 23:31:38','configurable-example','configurable-example.html',4,NULL,NULL),(295,4,'grouped',NULL,'2013-02-13 12:04:42',1,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Grouped Products','2014-01-09 00:00:00',NULL,NULL,NULL,NULL,NULL,0,NULL,'Grouped Products Example','grouped_product_example',NULL,'/f/i/file_5_87.jpg',NULL,NULL,NULL,NULL,NULL,'/f/i/file_5_87.jpg',NULL,'2014-01-10 02:56:43','grouped-product-example','grouped-product-example.html',4,NULL,NULL),(296,4,'bundle',NULL,'2013-02-13 12:04:44',1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Bundled Products','2014-01-09 00:00:00',NULL,NULL,0,0,NULL,1,0,'Bundle Products Example','bundle_product_example',1,'/6/2/6276251gv8imkzgl.jpg',NULL,NULL,NULL,NULL,NULL,'/6/2/6276251gv8imkzgl.jpg',NULL,'2014-01-10 02:57:20','bundle-product-example','bundle-product-example.html',4,1.0000,1),(297,4,'downloadable',47.0000,'2013-02-13 12:04:46',1,0,1,NULL,NULL,1,1,'Links',NULL,'4',2,'Downloadable Product',NULL,NULL,495.9900,NULL,NULL,NULL,1,NULL,'Downloadable Product Example','downloadable_product_example',NULL,'/2/3/2338351ysn7gguql.jpg',NULL,'2013-02-10 00:00:00',NULL,NULL,0,'/2/3/2338351ysn7gguql.jpg',NULL,'2014-01-14 00:00:02','downloadable-product-example','downloadable-product-example.html',4,NULL,NULL),(298,4,'simple',NULL,'2013-02-13 12:04:48',1,0,1,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product with Options','2014-01-09 00:00:00',NULL,299.9900,NULL,NULL,NULL,1,NULL,'Product with Options Example','product_with_options_example',NULL,'/7/5/754344125vs8zawl.jpg',NULL,'2013-01-05 00:00:00',NULL,NULL,0,'/7/5/754344125vs8zawl.jpg',NULL,'2014-01-10 03:47:31','product-with-options-example','product-with-options-example.html',4,1.0000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_3`
--

DROP TABLE IF EXISTS `catalog_product_flat_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_3` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set Id',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `short_description` text COMMENT 'Short Description',
  `sku` varchar(64) DEFAULT NULL COMMENT 'Sku',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `special_from_date` datetime DEFAULT NULL COMMENT 'Special From Date',
  `special_to_date` datetime DEFAULT NULL COMMENT 'Special To Date',
  `cost` decimal(12,4) DEFAULT NULL COMMENT 'Cost',
  `weight` decimal(12,4) DEFAULT NULL COMMENT 'Weight',
  `small_image` varchar(255) DEFAULT NULL COMMENT 'Small Image',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail',
  `news_from_date` datetime DEFAULT NULL COMMENT 'News From Date',
  `news_to_date` datetime DEFAULT NULL COMMENT 'News To Date',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'Url Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  `is_recurring` smallint(6) DEFAULT NULL COMMENT 'Is Recurring',
  `recurring_profile` text COMMENT 'Recurring Profile',
  `visibility` smallint(5) unsigned DEFAULT NULL COMMENT 'Visibility',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `image_label` varchar(255) DEFAULT NULL COMMENT 'Image Label',
  `small_image_label` varchar(255) DEFAULT NULL COMMENT 'Small Image Label',
  `thumbnail_label` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Label',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `msrp_enabled` smallint(6) DEFAULT NULL COMMENT 'Msrp Enabled',
  `msrp_display_actual_price_type` varchar(255) DEFAULT NULL COMMENT 'Msrp Display Actual Price Type',
  `msrp` decimal(12,4) DEFAULT NULL COMMENT 'Msrp',
  `enable_googlecheckout` smallint(6) DEFAULT NULL COMMENT 'Enable Googlecheckout',
  `tax_class_id` int(10) unsigned DEFAULT NULL COMMENT 'Tax Class Id',
  `gift_message_available` smallint(6) DEFAULT NULL COMMENT 'Gift Message Available',
  `price_type` int(11) DEFAULT NULL COMMENT 'Price Type',
  `sku_type` int(11) DEFAULT NULL COMMENT 'Sku Type',
  `weight_type` int(11) DEFAULT NULL COMMENT 'Weight Type',
  `price_view` int(11) DEFAULT NULL COMMENT 'Price View',
  `shipment_type` int(11) DEFAULT NULL COMMENT 'Shipment Type',
  `links_purchased_separately` int(11) DEFAULT NULL COMMENT 'Links Purchased Separately',
  `links_title` varchar(255) DEFAULT NULL COMMENT 'Links Title',
  `links_exist` int(11) DEFAULT NULL COMMENT 'Links Exist',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_3_TYPE_ID` (`type_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_3_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_3_NAME` (`name`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_3_PRICE` (`price`),
  CONSTRAINT `FK_CAT_PRD_FLAT_3_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Flat (Store 3)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_3`
--

LOCK TABLES `catalog_product_flat_3` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_3` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_3` VALUES (1,4,'simple','Test product','Lorem ipsum dolor sit amet\r\n \r\n','test_product',156.0000,NULL,NULL,NULL,NULL,1.0000,'/t/e/test_3.jpg','/t/e/test_3.jpg',NULL,NULL,'test-product','test-product.html',0,NULL,4,1,1,NULL,NULL,NULL,'2011-11-06 07:20:09','2012-05-08 12:14:31',2,'4',120.0000,1,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(226,4,'simple','Gund All Stars Sports Glove Chair','<a href=\"http://www.amazon.com/Gund-Stars-Sports-Glove-Chair/dp/B0017YJ130%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB0017YJ130\">Amazon Product Detail Page</a>','B0017YJ130',104.9900,NULL,NULL,NULL,NULL,1.0000,'/7/8/7852141aNV5HMQEL.jpg','/7/8/7852141aNV5HMQEL.jpg',NULL,NULL,'gund-all-stars-sports-glove-chair','gund-all-stars-sports-glove-chair.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:14:16','2012-05-07 10:44:30',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(227,4,'simple','Disney Princess Pretty Pink Toddler Bed','<a href=\"http://www.amazon.com/Disney-Princess-Pretty-Pink-Toddler/dp/B001GSKCAI%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB001GSKCAI\">Amazon Product Detail Page</a>','B001GSKCAI',58.7500,NULL,NULL,NULL,NULL,1.0000,'/5/4/5421741-JulxOYvL.jpg','/5/4/5421741-JulxOYvL.jpg',NULL,NULL,'disney-princess-pretty-pink-toddler-bed','disney-princess-pretty-pink-toddler-bed.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:14:21','2012-05-07 10:44:32',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(231,4,'simple','NICKELODEON SPONGE BOB TODDLER BED','<a href=\"http://www.amazon.com/NICKELODEON-SPONGE-BOB-TODDLER-BED/dp/B003JNEKAG%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB003JNEKAG\">Amazon Product Detail Page</a>','B003JNEKAG',56.4900,NULL,NULL,NULL,NULL,1.0000,'/3/7/3767141DRL97wcgL.jpg','/3/7/3767141DRL97wcgL.jpg',NULL,NULL,'nickelodeon-sponge-bob-toddler-bed','nickelodeon-sponge-bob-toddler-bed.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:14:38','2012-05-07 10:44:34',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(232,4,'simple','4Gr8 Kidz Racing Series Toddler Bed with Safe Sleep Rails','<a href=\"http://www.amazon.com/4Gr8-Kidz-Racing-Toddler-Sleep/dp/B002RL8386%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB002RL8386\">Amazon Product Detail Page</a>','B002RL8386',58.9800,NULL,NULL,NULL,NULL,1.0000,'/9/4/9494941hE3Ws_2Ba6L.jpg','/9/4/9494941hE3Ws_2Ba6L.jpg',NULL,NULL,'4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:14:44','2012-05-07 10:44:36',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(236,4,'simple','Nickelodeon\'s Dora the Explorer Multi-Bin Toy Organizer','<a href=\"http://www.amazon.com/Nickelodeons-Dora-Explorer-Multi-Bin-Organizer/dp/B003ZV4CVE%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB003ZV4CVE\">Amazon Product Detail Page</a>','B003ZV4CVE',38.4000,NULL,NULL,NULL,NULL,1.0000,'/8/7/8793451K4rsL_2ByQL.jpg','/8/7/8793451K4rsL_2ByQL.jpg',NULL,NULL,'nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:11','2012-05-07 10:44:38',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(238,4,'simple','Tot Tutors Kids\' Table and 4-Chair Set, Plastic','<a href=\"http://www.amazon.com/Tot-Tutors-Table-4-Chair-Plastic/dp/B001TZLAZE%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB001TZLAZE\">Amazon Product Detail Page</a>','B001TZLAZE',55.0000,NULL,NULL,NULL,NULL,1.0000,'/9/4/94506412UShi0tdL.jpg','/9/4/94506412UShi0tdL.jpg',NULL,NULL,'tot-tutors-kids-table-and-4-chair-set-plastic','tot-tutors-kids-table-and-4-chair-set-plastic.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:21','2012-05-07 10:44:40',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(239,4,'simple','Tot Tutors Book Rack, Primary Colors','<a href=\"http://www.amazon.com/Tot-Tutors-Book-Primary-Colors/dp/B000IHJF60%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB000IHJF60\">Amazon Product Detail Page</a>','B000IHJF60',26.9900,NULL,NULL,NULL,NULL,1.0000,'/5/6/5653251OoGUKtGhL.jpg','/5/6/5653251OoGUKtGhL.jpg',NULL,NULL,'tot-tutors-book-rack-primary-colors','tot-tutors-book-rack-primary-colors.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:25','2012-05-07 10:44:41',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(241,4,'simple','P\'Kolino Little Sofa','Sleeper, Green','B002AQIA6S',88.2000,NULL,NULL,NULL,NULL,1.0000,'/6/8/6851831WBmazyvNL.jpg','/6/8/6851831WBmazyvNL.jpg',NULL,NULL,'p-kolino-little-sofa-sleeper-green','p-kolino-little-sofa-sleeper-green.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:32','2012-05-07 10:44:43',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(242,4,'simple','P\'kolino Silly Soft Seating ','Lila','B004835N8E',34.9900,28.0000,'2012-05-07 00:00:00',NULL,NULL,1.0000,'/2/6/2678951tFS4dXddL.jpg','/2/6/2678951tFS4dXddL.jpg',NULL,NULL,'p-kolino-silly-soft-seating-lila','p-kolino-silly-soft-seating-lila.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:37','2012-05-07 10:44:45',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(243,4,'simple','P\'kolino Book Buggee','Orange','B001HX4IXE',32.6000,NULL,NULL,NULL,NULL,1.0000,'/2/0/2094741vZYZ7kzRL.jpg','/2/0/2094741vZYZ7kzRL.jpg',NULL,NULL,'p-kolino-book-buggee-in-orange','p-kolino-book-buggee-in-orange.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:43','2013-02-22 21:55:40',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(244,4,'simple','P\'kolino Nesting Birds','Natural wood','B0039UTUWM',22.3500,NULL,NULL,NULL,NULL,1.0000,'/7/7/7718151ZPc0bO4zL.jpg','/7/7/7718151ZPc0bO4zL.jpg',NULL,NULL,'p-kolino-nesting-birds','p-kolino-nesting-birds.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:50','2013-04-04 20:26:50',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(245,4,'simple','P\'kolino Children Desk','White','B001RIY7CQ',66.9900,NULL,NULL,NULL,NULL,1.0000,'/8/3/8345421s3XSZtfSL.jpg','/8/3/8345421s3XSZtfSL.jpg',NULL,NULL,'p-kolino-children-desk-white','p-kolino-children-desk-white.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:15:58','2012-05-07 10:44:51',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(246,4,'simple','P\'kolino Tree Trable ','with Zebra and Giraffe Chairs','B004A154PG',164.9900,NULL,NULL,NULL,NULL,1.0000,'/3/2/3229641xVI-10esL.jpg','/3/2/3229641xVI-10esL.jpg',NULL,NULL,'p-kolino-tree-trable-with-zebra-and-giraffe-chairs','p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:02','2012-05-07 10:44:53',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(247,4,'simple','P\'kolino Book Buggee ','Fire Truck','B004VT7Y7I',34.6500,28.0000,'2012-05-07 00:00:00',NULL,NULL,1.0000,'/3/5/3581551eFqe6efmL.jpg','/3/5/3581551eFqe6efmL.jpg',NULL,NULL,'p-kolino-book-buggee-fire-truck','p-kolino-book-buggee-fire-truck.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:05','2012-05-07 10:44:54',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(248,4,'simple','P\'kolino New Little Reader Chair','Flower Pink','B004VT7X8I',76.4900,NULL,NULL,NULL,NULL,1.0000,'/5/1/5187141-37T74zhL.jpg','/5/1/5187141-37T74zhL.jpg',NULL,NULL,'p-kolino-new-little-reader-chair-flower-pink','p-kolino-new-little-reader-chair-flower-pink.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:09','2012-05-07 10:44:56',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(249,4,'simple','P\'kolino Book Buggee','Crown','B004VT7XVA',35.9500,NULL,NULL,NULL,NULL,1.0000,'/1/2/1248541nko-hU08L.jpg','/1/2/1248541nko-hU08L.jpg',NULL,NULL,'p-kolino-book-buggee-crown','p-kolino-book-buggee-crown.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:16','2012-05-07 10:44:58',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(250,4,'simple','P\'kolino Duck and Ostrich Chairs',' Safari Collection ','B004A154PQ',83.4800,NULL,NULL,NULL,NULL,1.0000,'/5/7/5762541_2BOoIou2DL.jpg','/5/7/5762541_2BOoIou2DL.jpg',NULL,NULL,'p-kolino-safari-duck-and-ostrich-chairs','p-kolino-safari-duck-and-ostrich-chairs.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:22','2012-05-07 10:45:00',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(251,4,'simple','P\'Kolino Klick Children\'s Desk','Orange','B000WYJ33E',168.0000,NULL,NULL,NULL,NULL,1.0000,'/7/9/7918641xi65Dr6YL.jpg','/7/9/7918641xi65Dr6YL.jpg',NULL,NULL,'p-kolino-klick-children-s-desk-orange','p-kolino-klick-children-s-desk-orange.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:30','2012-05-07 10:45:02',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(252,4,'simple','Safari Collection Tree Table w/Animal Chairs','<a href=\"http://www.amazon.com/Safari-Collection-Table-Animal-Chairs/dp/B00545CDQ0%3FSubscriptionId%3DAKIAINMNN6OQDP4TPU2Q%26tag%3Dhttpwebandpco-20%26linkCode%3Dsp1%26camp%3D2025%26creative%3D165953%26creativeASIN%3DB00545CDQ0\">Amazon Product Detail Page</a>','B00545CDQ0',48.0000,NULL,NULL,NULL,NULL,1.0000,'/9/7/9701141xVI-10esL.jpg','/9/7/9701141xVI-10esL.jpg',NULL,NULL,'safari-collection-tree-table-w-animal-chairs','safari-collection-tree-table-w-animal-chairs.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:38','2012-05-07 10:45:04',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(253,4,'simple','P\'kolino Little One\'s Chair','Extra Fun','B002EDG14U',35.9900,28.0000,'2012-05-07 00:00:00',NULL,NULL,1.0000,'/7/8/7818341Gfe25GNIL.jpg','/7/8/7818341Gfe25GNIL.jpg',NULL,NULL,'p-kolino-little-one-s-chair','p-kolino-little-one-s-chair.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:41','2012-05-07 10:45:06',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(255,4,'simple','P\'kolino Zebra Rocking Chair','Safari Collection ','B004A154P6',53.9800,NULL,NULL,NULL,NULL,1.0000,'/4/8/4810331QtJvw2JPL.jpg','/4/8/4810331QtJvw2JPL.jpg',NULL,NULL,'p-kolino-zebra-rocking-chair','p-kolino-zebra-rocking-chair.html',0,NULL,4,0,0,NULL,NULL,NULL,'2011-11-13 03:16:56','2012-05-07 10:45:09',2,'4',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(287,4,'simple','Hot! Bikini white, yellow or black','Feel like you are in a tropical island!','B006XFJXF4',28.0000,26.0000,NULL,NULL,NULL,1.0000,'/3/1/3113241uzg_2BLmC1L.jpg','/3/1/3113241uzg_2BLmC1L.jpg',NULL,NULL,'hot-bikini-white-yellow-or-black','hot-bikini-white-yellow-or-black.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2012-05-08 02:01:42','2012-05-08 02:01:46',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(288,4,'simple','Designer Monokini Halter String Ties Womens Sexy Bikini','Feel like you are in a tropical island!','B003VSOKQI',28.0000,26.0000,NULL,NULL,NULL,1.0000,'/5/5/5512951-nlqe_2BMpL.jpg','/5/5/5512951-nlqe_2BMpL.jpg',NULL,NULL,'designer-monokini-halter-string-ties-womens-sexy-bikini','designer-monokini-halter-string-ties-womens-sexy-bikini.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2012-05-08 02:01:48','2012-05-08 02:01:53',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(289,4,'simple','Metallic Slingshot Monokini (As Shown;One Size)','Feel like you are in a tropical island!','B0040WRM5K',28.0000,26.0000,NULL,NULL,NULL,1.0000,'/2/8/28391413qWC2vpOL.jpg','/2/8/28391413qWC2vpOL.jpg',NULL,NULL,'metallic-slingshot-monokini-as-shown-one-size','metallic-slingshot-monokini-as-shown-one-size.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2012-05-08 02:01:55','2012-05-08 02:01:58',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(290,4,'simple','Hot! Bikini Leopard','Feel like you are in a tropical island!','B005PPMSOG',28.0000,26.0000,NULL,NULL,NULL,1.0000,'/7/8/7813141R6v6eCPfL.jpg','/7/8/7813141R6v6eCPfL.jpg',NULL,NULL,'hot-bikini-leopard','hot-bikini-leopard.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2012-05-08 02:02:00','2012-05-08 02:02:02',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(291,4,'simple','Daisy Corsets Sequin Underwire Corset','Feel like you are in a tropical island!','B005FGF38S',28.0000,26.0000,NULL,NULL,NULL,1.0000,'/1/4/1432551QvKKpVYLL.jpg','/1/4/1432551QvKKpVYLL.jpg',NULL,NULL,'daisy-corsets-sequin-underwire-corset','daisy-corsets-sequin-underwire-corset.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2012-05-08 02:02:05','2012-05-08 02:02:07',NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(292,4,'simple','P\'kolino Giraffe Rocking Chair [Simple]','Simple Product Example','simple_product_example',73.9900,NULL,'2013-02-10 00:00:00',NULL,NULL,1.0000,'/9/1/9192541ngxuslxxl_1.jpg','/9/1/9192541ngxuslxxl_1.jpg',NULL,NULL,'simple-product-example','simple-product-example.html',0,NULL,4,0,0,NULL,NULL,NULL,'2013-02-13 12:04:34','2013-02-22 21:57:35',2,'4',NULL,1,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(293,4,'virtual','Furniture Assembly Service [Virtual]','Virtual Product Example','virtual_product_example',99.0000,75.0000,'2013-02-10 00:00:00',NULL,NULL,NULL,'/4/1/41mt7cusmnl.jpg','/4/1/41mt7cusmnl.jpg',NULL,NULL,'virtual-product-example','virtual-product-example.html',0,NULL,4,0,0,NULL,NULL,NULL,'2013-02-13 12:04:37','2013-02-22 21:56:10',2,'4',NULL,1,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(294,4,'configurable','Chair  [Configurable]','Configurable Product Example','configurable_example',3.0000,NULL,NULL,NULL,NULL,NULL,'/4/8/4810331qtjvw2jpl_1.jpg','/4/8/4810331qtjvw2jpl_1.jpg',NULL,NULL,'configurable-example','configurable-example.html',NULL,NULL,4,1,1,NULL,NULL,NULL,'2013-02-13 12:04:40','2013-02-20 03:33:37',2,'4',NULL,1,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(295,4,'grouped','P\'colino Collection  [Grouped]','Grouped Product Example','grouped_product_example',NULL,NULL,NULL,NULL,NULL,NULL,'/4/1/41eldp2m6dl123.jpg','/4/1/41eldp2m6dl123.jpg',NULL,NULL,'grouped-product-example','grouped-product-example.html',NULL,NULL,4,0,0,NULL,NULL,NULL,'2013-02-13 12:04:42','2013-02-20 03:54:30',NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(296,4,'bundle','Furniture Kit [Bundled]','Bundle Product Example','bundle_product_example',NULL,NULL,NULL,NULL,NULL,1.0000,'/1/2/12345.jpg','/1/2/12345.jpg',NULL,NULL,'bundle-product-example','bundle-product-example.html',NULL,NULL,4,1,1,NULL,NULL,NULL,'2013-02-13 12:04:44','2013-02-20 06:49:57',0,NULL,NULL,1,NULL,0,0,1,1,0,0,NULL,NULL,NULL),(297,4,'downloadable','Home Designer Pro 2014  [Download]','Downloadable Product Example','downloadable_product_example',495.9900,NULL,'2013-02-10 00:00:00',NULL,47.0000,NULL,'/1/2/123.jpg','/1/2/123.jpg',NULL,NULL,'downloadable-product-example','downloadable-product-example.html',NULL,NULL,4,1,1,NULL,NULL,NULL,'2013-02-13 12:04:46','2013-02-20 06:52:02',2,'4',NULL,1,0,0,NULL,NULL,NULL,NULL,NULL,1,'Links',1),(298,4,'simple','P\'kolino Toddler Bed & Chair [with Options]','Product with Options Example','product_with_options_example',299.9900,NULL,'2013-01-05 00:00:00',NULL,NULL,1.0000,'/5/0/5098441qsqhlawrl_1.jpg','/5/0/5098441qsqhlawrl_1.jpg',NULL,NULL,'product-with-options-example','product-with-options-example.html',0,NULL,4,1,1,NULL,NULL,NULL,'2013-02-13 12:04:48','2013-02-22 21:57:09',2,'4',NULL,1,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_5`
--

DROP TABLE IF EXISTS `catalog_product_flat_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_5` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set Id',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type Id',
  `cost` decimal(12,4) DEFAULT NULL COMMENT 'Cost',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `enable_googlecheckout` smallint(6) DEFAULT NULL COMMENT 'Enable Googlecheckout',
  `gift_message_available` smallint(6) DEFAULT NULL COMMENT 'Gift Message Available',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `image_label` varchar(255) DEFAULT NULL COMMENT 'Image Label',
  `is_recurring` smallint(6) DEFAULT NULL COMMENT 'Is Recurring',
  `links_exist` int(11) DEFAULT NULL COMMENT 'Links Exist',
  `links_purchased_separately` int(11) DEFAULT NULL COMMENT 'Links Purchased Separately',
  `links_title` varchar(255) DEFAULT NULL COMMENT 'Links Title',
  `msrp` decimal(12,4) DEFAULT NULL COMMENT 'Msrp',
  `msrp_display_actual_price_type` varchar(255) DEFAULT NULL COMMENT 'Msrp Display Actual Price Type',
  `msrp_enabled` smallint(6) DEFAULT NULL COMMENT 'Msrp Enabled',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `news_from_date` datetime DEFAULT NULL COMMENT 'News From Date',
  `news_to_date` datetime DEFAULT NULL COMMENT 'News To Date',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `price_type` int(11) DEFAULT NULL COMMENT 'Price Type',
  `price_view` int(11) DEFAULT NULL COMMENT 'Price View',
  `recurring_profile` text COMMENT 'Recurring Profile',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `shipment_type` int(11) DEFAULT NULL COMMENT 'Shipment Type',
  `short_description` text COMMENT 'Short Description',
  `sku` varchar(64) DEFAULT NULL COMMENT 'Sku',
  `sku_type` int(11) DEFAULT NULL COMMENT 'Sku Type',
  `small_image` varchar(255) DEFAULT NULL COMMENT 'Small Image',
  `small_image_label` varchar(255) DEFAULT NULL COMMENT 'Small Image Label',
  `special_from_date` datetime DEFAULT NULL COMMENT 'Special From Date',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `special_to_date` datetime DEFAULT NULL COMMENT 'Special To Date',
  `tax_class_id` int(10) unsigned DEFAULT NULL COMMENT 'Tax Class Id',
  `thumbnail` varchar(255) DEFAULT NULL COMMENT 'Thumbnail',
  `thumbnail_label` varchar(255) DEFAULT NULL COMMENT 'Thumbnail Label',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `url_key` varchar(255) DEFAULT NULL COMMENT 'Url Key',
  `url_path` varchar(255) DEFAULT NULL COMMENT 'Url Path',
  `visibility` smallint(5) unsigned DEFAULT NULL COMMENT 'Visibility',
  `weight` decimal(12,4) DEFAULT NULL COMMENT 'Weight',
  `weight_type` int(11) DEFAULT NULL COMMENT 'Weight Type',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_5_TYPE_ID` (`type_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_5_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_5_NAME` (`name`),
  KEY `IDX_CATALOG_PRODUCT_FLAT_5_PRICE` (`price`),
  CONSTRAINT `FK_CAT_PRD_FLAT_5_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Flat (Store 5)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_5`
--

LOCK TABLES `catalog_product_flat_5` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_5` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_5` VALUES (1,4,'simple',NULL,'2011-11-06 07:20:09',1,NULL,1,NULL,0,NULL,NULL,NULL,120.0000,'4',2,'Product',NULL,NULL,156.0000,NULL,NULL,NULL,1,NULL,'Lorem ipsum Collection\r\n \r\n','test_product',NULL,'/f/i/file_5_88.jpg',NULL,NULL,NULL,NULL,4,'/f/i/file_5_88.jpg',NULL,'2014-01-10 02:23:51','test-product','test-product.html',4,1.0000,NULL),(226,4,'simple',NULL,'2011-11-13 03:14:16',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,104.9900,NULL,NULL,NULL,0,NULL,'All Stars Collection','B0017YJ130',NULL,'/5/7/5700651cbl3tp1ql.jpg',NULL,NULL,NULL,NULL,0,'/5/7/5700651cbl3tp1ql.jpg',NULL,'2014-01-10 02:22:35','gund-all-stars-sports-glove-chair','gund-all-stars-sports-glove-chair.html',4,1.0000,NULL),(227,4,'simple',NULL,'2011-11-13 03:14:21',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,58.7500,NULL,NULL,NULL,0,NULL,'Orange','B001GSKCAI',NULL,'/6/2/6276251gv8imkzgl_3.jpg',NULL,NULL,NULL,NULL,0,'/6/2/6276251gv8imkzgl_3.jpg',NULL,'2014-01-10 02:20:44','disney-princess-pretty-pink-toddler-bed','disney-princess-pretty-pink-toddler-bed.html',4,1.0000,NULL),(231,4,'simple',NULL,'2011-11-13 03:14:38',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,56.4900,NULL,NULL,NULL,0,NULL,'Gray Collection','B003JNEKAG',NULL,'/2/1/219855146skdaqnl_1.jpg',NULL,NULL,NULL,NULL,0,'/2/1/219855146skdaqnl_1.jpg',NULL,'2014-01-10 02:19:55','nickelodeon-sponge-bob-toddler-bed','nickelodeon-sponge-bob-toddler-bed.html',4,1.0000,NULL),(232,4,'simple',NULL,'2011-11-13 03:14:44',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,58.9800,NULL,NULL,NULL,0,NULL,'Black','B002RL8386',NULL,'/5/7/57513319fxpdryjl_1.jpg',NULL,NULL,NULL,NULL,0,'/5/7/57513319fxpdryjl_1.jpg',NULL,'2014-01-10 02:19:19','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html',4,1.0000,NULL),(236,4,'simple',NULL,'2011-11-13 03:15:11',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,38.4000,NULL,NULL,NULL,0,NULL,'White','B003ZV4CVE',NULL,'/9/8/9834551egofdo9hl.jpg',NULL,NULL,NULL,NULL,0,'/9/8/9834551egofdo9hl.jpg',NULL,'2014-01-10 02:18:35','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html',4,1.0000,NULL),(238,4,'simple',NULL,'2011-11-13 03:15:21',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Prduct',NULL,NULL,55.0000,NULL,NULL,NULL,0,NULL,'Soft collection','B001TZLAZE',NULL,'/9/3/9352651swse52brl_1.jpg',NULL,NULL,NULL,NULL,0,'/9/3/9352651swse52brl_1.jpg',NULL,'2014-01-10 02:17:54','tot-tutors-kids-table-and-4-chair-set-plastic','tot-tutors-kids-table-and-4-chair-set-plastic.html',4,1.0000,NULL),(239,4,'simple',NULL,'2011-11-13 03:15:25',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,26.9900,NULL,NULL,NULL,0,NULL,'Best Collection','B000IHJF60',NULL,'/6/2/6276251gv8imkzgl_2.jpg',NULL,NULL,NULL,NULL,0,'/6/2/6276251gv8imkzgl_2.jpg',NULL,'2014-01-10 02:16:23','tot-tutors-book-rack-primary-colors','tot-tutors-book-rack-primary-colors.html',4,1.0000,NULL),(241,4,'simple',NULL,'2011-11-13 03:15:32',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,88.2000,NULL,NULL,NULL,0,NULL,'Best Collection','B002AQIA6S',NULL,'/9/3/9352651swse52brl.jpg',NULL,NULL,NULL,NULL,0,'/9/3/9352651swse52brl.jpg',NULL,'2014-01-10 02:17:01','p-kolino-little-sofa-sleeper-green','p-kolino-little-sofa-sleeper-green.html',4,1.0000,NULL),(242,4,'simple',NULL,'2011-11-13 03:15:37',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,34.9900,NULL,NULL,NULL,0,NULL,'Collection','B004835N8E',NULL,'/4/8/4858351hm4qmcr3l_1.jpg',NULL,'2012-05-07 00:00:00',28.0000,NULL,0,'/4/8/4858351hm4qmcr3l_1.jpg',NULL,'2014-01-10 02:15:08','p-kolino-silly-soft-seating-lila','p-kolino-silly-soft-seating-lila.html',4,1.0000,NULL),(243,4,'simple',NULL,'2011-11-13 03:15:43',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,32.6000,NULL,NULL,NULL,0,NULL,'Orange Collection','B001HX4IXE',NULL,'/3/8/3817831wc2kkavsl_1.jpg',NULL,NULL,NULL,NULL,0,'/3/8/3817831wc2kkavsl_1.jpg',NULL,'2014-01-10 02:14:16','p-kolino-book-buggee-in-orange','p-kolino-book-buggee-in-orange.html',4,1.0000,NULL),(244,4,'simple',NULL,'2011-11-13 03:15:50',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,22.3500,NULL,NULL,NULL,0,NULL,'White Collection','B0039UTUWM',NULL,'/3/5/3593841ukdyrthxl_1.jpg',NULL,NULL,NULL,NULL,0,'/3/5/3593841ukdyrthxl_1.jpg',NULL,'2014-01-10 02:12:53','p-kolino-nesting-birds','p-kolino-nesting-birds.html',4,1.0000,NULL),(245,4,'simple',NULL,'2011-11-13 03:15:58',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,66.9900,NULL,NULL,NULL,0,NULL,'White','B001RIY7CQ',NULL,'/1/8/1842441ugnfbh7kl_1.jpg',NULL,NULL,NULL,NULL,0,'/1/8/1842441ugnfbh7kl_1.jpg',NULL,'2014-01-10 02:12:17','p-kolino-children-desk-white','p-kolino-children-desk-white.html',4,1.0000,NULL),(246,4,'simple',NULL,'2011-11-13 03:16:02',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,164.9900,NULL,NULL,NULL,0,NULL,'Zebra Collection','B004A154PG',NULL,'/2/1/219855146skdaqnl.jpg',NULL,NULL,NULL,NULL,0,'/2/1/219855146skdaqnl.jpg',NULL,'2014-01-10 02:11:44','p-kolino-tree-trable-with-zebra-and-giraffe-chairs','p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html',4,1.0000,NULL),(247,4,'simple',NULL,'2011-11-13 03:16:05',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,34.6500,NULL,NULL,NULL,0,NULL,'Collection','B004VT7Y7I',NULL,'/6/4/64397412hiqswx4l.jpg',NULL,'2012-05-07 00:00:00',28.0000,NULL,0,'/6/4/64397412hiqswx4l.jpg',NULL,'2014-01-10 02:11:06','p-kolino-book-buggee-fire-truck','p-kolino-book-buggee-fire-truck.html',4,1.0000,NULL),(248,4,'simple',NULL,'2011-11-13 03:16:09',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,76.4900,NULL,NULL,NULL,0,NULL,'Flower Pink','B004VT7X8I',NULL,'/5/7/57513319fxpdryjl.jpg',NULL,NULL,NULL,NULL,0,'/5/7/57513319fxpdryjl.jpg',NULL,'2014-01-10 02:09:42','p-kolino-new-little-reader-chair-flower-pink','p-kolino-new-little-reader-chair-flower-pink.html',4,1.0000,NULL),(249,4,'simple',NULL,'2011-11-13 03:16:16',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Best product for the home with very loooooooooooong title',NULL,NULL,35.9500,NULL,NULL,NULL,0,NULL,'Crown','B004VT7XVA',NULL,'/8/5/8581731c6dlwyxel.jpg',NULL,NULL,NULL,NULL,0,'/8/5/8581731c6dlwyxel.jpg',NULL,'2014-01-13 22:15:01','p-kolino-book-buggee-crown','p-kolino-book-buggee-crown.html',4,1.0000,NULL),(250,4,'simple',NULL,'2011-11-13 03:16:22',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Prodict',NULL,NULL,83.4800,NULL,NULL,NULL,0,NULL,'Safari Collection ','B004A154PQ',NULL,'/6/2/6276251gv8imkzgl_1.jpg',NULL,NULL,NULL,NULL,0,'/6/2/6276251gv8imkzgl_1.jpg',NULL,'2014-01-10 02:08:11','p-kolino-safari-duck-and-ostrich-chairs','p-kolino-safari-duck-and-ostrich-chairs.html',4,1.0000,NULL),(251,4,'simple',NULL,'2011-11-13 03:16:30',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,168.0000,NULL,NULL,NULL,0,NULL,'Orange','B000WYJ33E',NULL,'/4/8/4858351hm4qmcr3l.jpg',NULL,NULL,NULL,NULL,0,'/4/8/4858351hm4qmcr3l.jpg',NULL,'2014-01-10 02:07:35','p-kolino-klick-children-s-desk-orange','p-kolino-klick-children-s-desk-orange.html',4,1.0000,NULL),(252,4,'simple',NULL,'2011-11-13 03:16:38',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,48.0000,NULL,NULL,NULL,0,NULL,'Collection','B00545CDQ0',NULL,'/3/8/3817831wc2kkavsl.jpg',NULL,NULL,NULL,NULL,0,'/3/8/3817831wc2kkavsl.jpg',NULL,'2014-01-10 02:06:59','safari-collection-tree-table-w-animal-chairs','safari-collection-tree-table-w-animal-chairs.html',4,1.0000,NULL),(253,4,'simple',NULL,'2011-11-13 03:16:41',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,35.9900,NULL,NULL,NULL,0,NULL,'Extra Fun','B002EDG14U',NULL,'/3/5/3593841ukdyrthxl.jpg',NULL,'2012-05-07 00:00:00',28.0000,NULL,0,'/3/5/3593841ukdyrthxl.jpg',NULL,'2014-01-10 02:06:15','p-kolino-little-one-s-chair','p-kolino-little-one-s-chair.html',4,1.0000,NULL),(255,4,'simple',NULL,'2011-11-13 03:16:56',1,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product',NULL,NULL,53.9800,NULL,NULL,NULL,0,NULL,'Safari Collection ','B004A154P6',NULL,'/1/8/1842441ugnfbh7kl.jpg',NULL,NULL,NULL,NULL,0,'/1/8/1842441ugnfbh7kl.jpg',NULL,'2014-01-10 02:05:41','p-kolino-zebra-rocking-chair','p-kolino-zebra-rocking-chair.html',4,1.0000,NULL),(287,4,'simple',NULL,'2012-05-08 02:01:42',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hot! Bikini white, yellow or black',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B006XFJXF4',NULL,'/3/1/3113241uzg_2BLmC1L.jpg',NULL,NULL,26.0000,NULL,0,'/3/1/3113241uzg_2BLmC1L.jpg',NULL,'2012-05-08 02:01:46','hot-bikini-white-yellow-or-black','hot-bikini-white-yellow-or-black.html',4,1.0000,NULL),(288,4,'simple',NULL,'2012-05-08 02:01:48',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Designer Monokini Halter String Ties Womens Sexy Bikini',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B003VSOKQI',NULL,'/5/5/5512951-nlqe_2BMpL.jpg',NULL,NULL,26.0000,NULL,0,'/5/5/5512951-nlqe_2BMpL.jpg',NULL,'2012-05-08 02:01:53','designer-monokini-halter-string-ties-womens-sexy-bikini','designer-monokini-halter-string-ties-womens-sexy-bikini.html',4,1.0000,NULL),(289,4,'simple',NULL,'2012-05-08 02:01:55',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Metallic Slingshot Monokini (As Shown;One Size)',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B0040WRM5K',NULL,'/2/8/28391413qWC2vpOL.jpg',NULL,NULL,26.0000,NULL,0,'/2/8/28391413qWC2vpOL.jpg',NULL,'2012-05-08 02:01:58','metallic-slingshot-monokini-as-shown-one-size','metallic-slingshot-monokini-as-shown-one-size.html',4,1.0000,NULL),(290,4,'simple',NULL,'2012-05-08 02:02:00',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hot! Bikini Leopard',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B005PPMSOG',NULL,'/7/8/7813141R6v6eCPfL.jpg',NULL,NULL,26.0000,NULL,0,'/7/8/7813141R6v6eCPfL.jpg',NULL,'2012-05-08 02:02:02','hot-bikini-leopard','hot-bikini-leopard.html',4,1.0000,NULL),(291,4,'simple',NULL,'2012-05-08 02:02:05',1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy Corsets Sequin Underwire Corset',NULL,NULL,28.0000,NULL,NULL,NULL,0,NULL,'Feel like you are in a tropical island!','B005FGF38S',NULL,'/1/4/1432551QvKKpVYLL.jpg',NULL,NULL,26.0000,NULL,0,'/1/4/1432551QvKKpVYLL.jpg',NULL,'2012-05-08 02:02:07','daisy-corsets-sequin-underwire-corset','daisy-corsets-sequin-underwire-corset.html',4,1.0000,NULL),(292,4,'simple',NULL,'2013-02-13 12:04:34',1,0,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Simple Product','2014-01-09 00:00:00',NULL,373.9900,NULL,NULL,NULL,0,NULL,'Simple Product Example','simple_product_example',NULL,'/f/i/file_5_96.jpg',NULL,'2013-02-10 00:00:00',NULL,NULL,0,'/f/i/file_5_96.jpg',NULL,'2014-01-10 04:02:54','simple-product-example','simple-product-example.html',4,1.0000,NULL),(293,4,'virtual',NULL,'2013-02-13 12:04:37',1,0,0,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Virtual Product','2014-01-09 00:00:00',NULL,99.0000,NULL,NULL,NULL,0,NULL,'Virtual Product Example','virtual_product_example',NULL,'/8/3/8308341syzd4qthl.jpg',NULL,'2013-02-10 00:00:00',75.0000,NULL,0,'/8/3/8308341syzd4qthl.jpg',NULL,'2014-01-10 04:00:49','virtual-product-example','virtual-product-example.html',4,NULL,NULL),(294,4,'configurable',NULL,'2013-02-13 12:04:40',1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,'4',2,'Configurable Product','2014-01-09 00:00:00',NULL,3.0000,NULL,NULL,NULL,1,NULL,'Configurable Product Example','configurable_example',NULL,'/4/5/4596251m0ds1xeol.jpg',NULL,NULL,NULL,NULL,0,'/4/5/4596251m0ds1xeol.jpg',NULL,'2014-01-15 23:31:38','configurable-example','configurable-example.html',4,NULL,NULL),(295,4,'grouped',NULL,'2013-02-13 12:04:42',1,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Grouped Products','2014-01-09 00:00:00',NULL,NULL,NULL,NULL,NULL,0,NULL,'Grouped Products Example','grouped_product_example',NULL,'/f/i/file_5_87.jpg',NULL,NULL,NULL,NULL,NULL,'/f/i/file_5_87.jpg',NULL,'2014-01-10 02:56:43','grouped-product-example','grouped-product-example.html',4,NULL,NULL),(296,4,'bundle',NULL,'2013-02-13 12:04:44',1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Bundled Products','2014-01-09 00:00:00',NULL,NULL,0,0,NULL,1,0,'Bundle Products Example','bundle_product_example',1,'/6/2/6276251gv8imkzgl.jpg',NULL,NULL,NULL,NULL,NULL,'/6/2/6276251gv8imkzgl.jpg',NULL,'2014-01-10 02:57:20','bundle-product-example','bundle-product-example.html',4,1.0000,1),(297,4,'downloadable',47.0000,'2013-02-13 12:04:46',1,0,1,NULL,NULL,1,1,'Links',NULL,'4',2,'Downloadable Product',NULL,NULL,495.9900,NULL,NULL,NULL,1,NULL,'Downloadable Product Example','downloadable_product_example',NULL,'/2/3/2338351ysn7gguql.jpg',NULL,'2013-02-10 00:00:00',NULL,NULL,0,'/2/3/2338351ysn7gguql.jpg',NULL,'2014-01-14 00:00:02','downloadable-product-example','downloadable-product-example.html',4,NULL,NULL),(298,4,'simple',NULL,'2013-02-13 12:04:48',1,0,1,NULL,0,NULL,NULL,NULL,NULL,'4',2,'Product with Options','2014-01-09 00:00:00',NULL,299.9900,NULL,NULL,NULL,1,NULL,'Product with Options Example','product_with_options_example',NULL,'/7/5/754344125vs8zawl.jpg',NULL,'2013-01-05 00:00:00',NULL,NULL,0,'/7/5/754344125vs8zawl.jpg',NULL,'2014-01-10 03:47:31','product-with-options-example','product-with-options-example.html',4,1.0000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_5` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav`
--

DROP TABLE IF EXISTS `catalog_product_index_eav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` int(10) unsigned NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_VALUE` (`value`),
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_EAV_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_EAV_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav`
--

LOCK TABLES `catalog_product_index_eav` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav` VALUES (292,85,1,5),(292,85,5,5),(294,85,1,5),(294,85,5,5),(295,85,1,5),(295,85,5,5),(296,85,1,5),(296,85,5,5),(298,85,1,4),(298,85,5,4),(1,115,1,4),(1,115,5,4),(226,115,1,0),(226,115,5,0),(227,115,1,0),(227,115,5,0),(231,115,1,0),(231,115,5,0),(232,115,1,0),(232,115,5,0),(236,115,1,0),(236,115,5,0),(238,115,1,0),(238,115,5,0),(239,115,1,0),(239,115,5,0),(241,115,1,0),(241,115,5,0),(242,115,1,0),(242,115,5,0),(243,115,1,0),(243,115,5,0),(244,115,1,0),(244,115,5,0),(245,115,1,0),(245,115,5,0),(246,115,1,0),(246,115,5,0),(247,115,1,0),(247,115,5,0),(248,115,1,0),(248,115,5,0),(249,115,1,0),(249,115,5,0),(250,115,1,0),(250,115,5,0),(251,115,1,0),(251,115,5,0),(252,115,1,0),(252,115,5,0),(253,115,1,0),(253,115,5,0),(255,115,1,0),(255,115,5,0),(287,115,1,0),(287,115,5,0),(288,115,1,0),(288,115,5,0),(289,115,1,0),(289,115,5,0),(290,115,1,0),(290,115,5,0),(291,115,1,0),(291,115,5,0),(292,115,1,0),(292,115,5,0),(293,115,1,0),(293,115,5,0),(294,115,1,0),(294,115,5,0),(295,115,1,0),(295,115,5,0),(296,115,1,0),(296,115,5,0),(297,115,1,0),(297,115,5,0),(298,115,1,0),(298,115,5,0);
/*!40000 ALTER TABLE `catalog_product_index_eav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_decimal` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE` (`value`),
  CONSTRAINT `FK_CAT_PRD_IDX_EAV_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_EAV_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_EAV_DEC_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Decimal Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal`
--

LOCK TABLES `catalog_product_index_eav_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_decimal_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Decimal Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_idx`
--

LOCK TABLES `catalog_product_index_eav_decimal_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_decimal_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_VALUE` (`value`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Decimal Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_tmp`
--

LOCK TABLES `catalog_product_index_eav_decimal_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` int(10) unsigned NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_idx`
--

LOCK TABLES `catalog_product_index_eav_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav_idx` VALUES (292,85,1,5),(292,85,3,5),(292,85,5,5),(294,85,1,5),(294,85,3,5),(294,85,5,5),(295,85,1,5),(295,85,3,5),(295,85,5,5),(296,85,1,5),(296,85,3,5),(296,85,5,5),(298,85,1,4),(298,85,3,4),(298,85,5,4),(1,115,1,4),(1,115,3,4),(1,115,5,4),(2,115,1,0),(2,115,3,0),(2,115,5,0),(8,115,1,0),(8,115,3,0),(8,115,5,0),(10,115,1,0),(10,115,3,0),(10,115,5,0),(11,115,1,0),(11,115,3,0),(11,115,5,0),(12,115,1,0),(12,115,3,0),(12,115,5,0),(13,115,1,0),(13,115,3,0),(13,115,5,0),(14,115,1,0),(14,115,3,0),(14,115,5,0),(15,115,1,0),(15,115,3,0),(15,115,5,0),(16,115,1,0),(16,115,3,0),(16,115,5,0),(17,115,1,0),(17,115,3,0),(17,115,5,0),(18,115,1,0),(18,115,3,0),(18,115,5,0),(19,115,1,0),(19,115,3,0),(19,115,5,0),(20,115,1,0),(20,115,3,0),(20,115,5,0),(21,115,1,0),(21,115,3,0),(21,115,5,0),(22,115,1,0),(22,115,3,0),(22,115,5,0),(23,115,1,0),(23,115,3,0),(23,115,5,0),(24,115,1,0),(24,115,3,0),(24,115,5,0),(25,115,1,0),(25,115,3,0),(25,115,5,0),(26,115,1,0),(26,115,3,0),(26,115,5,0),(27,115,1,0),(27,115,3,0),(27,115,5,0),(28,115,1,0),(28,115,3,0),(28,115,5,0),(29,115,1,0),(29,115,3,0),(29,115,5,0),(30,115,1,0),(30,115,3,0),(30,115,5,0),(32,115,1,0),(32,115,3,0),(32,115,5,0),(33,115,1,0),(33,115,3,0),(33,115,5,0),(34,115,1,0),(34,115,3,0),(34,115,5,0),(37,115,1,0),(37,115,3,0),(37,115,5,0),(38,115,1,0),(38,115,3,0),(38,115,5,0),(39,115,1,0),(39,115,3,0),(39,115,5,0),(40,115,1,0),(40,115,3,0),(40,115,5,0),(41,115,1,0),(41,115,3,0),(41,115,5,0),(42,115,1,0),(42,115,3,0),(42,115,5,0),(43,115,1,0),(43,115,3,0),(43,115,5,0),(45,115,1,0),(45,115,3,0),(45,115,5,0),(46,115,1,0),(46,115,3,0),(46,115,5,0),(47,115,1,0),(47,115,3,0),(47,115,5,0),(48,115,1,0),(48,115,3,0),(48,115,5,0),(49,115,1,0),(49,115,3,0),(49,115,5,0),(50,115,1,0),(50,115,3,0),(50,115,5,0),(51,115,1,0),(51,115,3,0),(51,115,5,0),(52,115,1,0),(52,115,3,0),(52,115,5,0),(53,115,1,0),(53,115,3,0),(53,115,5,0),(54,115,1,0),(54,115,3,0),(54,115,5,0),(55,115,1,0),(55,115,3,0),(55,115,5,0),(56,115,1,0),(56,115,3,0),(56,115,5,0),(57,115,1,0),(57,115,3,0),(57,115,5,0),(58,115,1,0),(58,115,3,0),(58,115,5,0),(59,115,1,0),(59,115,3,0),(59,115,5,0),(60,115,1,0),(60,115,3,0),(60,115,5,0),(61,115,1,0),(61,115,3,0),(61,115,5,0),(62,115,1,0),(62,115,3,0),(62,115,5,0),(63,115,1,0),(63,115,3,0),(63,115,5,0),(64,115,1,0),(64,115,3,0),(64,115,5,0),(65,115,1,0),(65,115,3,0),(65,115,5,0),(66,115,1,0),(66,115,3,0),(66,115,5,0),(67,115,1,0),(67,115,3,0),(67,115,5,0),(68,115,1,0),(68,115,3,0),(68,115,5,0),(69,115,1,0),(69,115,3,0),(69,115,5,0),(70,115,1,0),(70,115,3,0),(70,115,5,0),(71,115,1,0),(71,115,3,0),(71,115,5,0),(72,115,1,0),(72,115,3,0),(72,115,5,0),(73,115,1,0),(73,115,3,0),(73,115,5,0),(74,115,1,0),(74,115,3,0),(74,115,5,0),(75,115,1,0),(75,115,3,0),(75,115,5,0),(76,115,1,0),(76,115,3,0),(76,115,5,0),(77,115,1,0),(77,115,3,0),(77,115,5,0),(78,115,1,0),(78,115,3,0),(78,115,5,0),(79,115,1,0),(79,115,3,0),(79,115,5,0),(80,115,1,0),(80,115,3,0),(80,115,5,0),(81,115,1,0),(81,115,3,0),(81,115,5,0),(82,115,1,0),(82,115,3,0),(82,115,5,0),(83,115,1,0),(83,115,3,0),(83,115,5,0),(84,115,1,0),(84,115,3,0),(84,115,5,0),(85,115,1,0),(85,115,3,0),(85,115,5,0),(86,115,1,0),(86,115,3,0),(86,115,5,0),(87,115,1,0),(87,115,3,0),(87,115,5,0),(88,115,1,0),(88,115,3,0),(88,115,5,0),(89,115,1,0),(89,115,3,0),(89,115,5,0),(90,115,1,0),(90,115,3,0),(90,115,5,0),(91,115,1,0),(91,115,3,0),(91,115,5,0),(92,115,1,0),(92,115,3,0),(92,115,5,0),(93,115,1,0),(93,115,3,0),(93,115,5,0),(94,115,1,0),(94,115,3,0),(94,115,5,0),(95,115,1,0),(95,115,3,0),(95,115,5,0),(96,115,1,0),(96,115,3,0),(96,115,5,0),(97,115,1,0),(97,115,3,0),(97,115,5,0),(98,115,1,0),(98,115,3,0),(98,115,5,0),(99,115,1,0),(99,115,3,0),(99,115,5,0),(100,115,1,0),(100,115,3,0),(100,115,5,0),(101,115,1,0),(101,115,3,0),(101,115,5,0),(102,115,1,0),(102,115,3,0),(102,115,5,0),(103,115,1,0),(103,115,3,0),(103,115,5,0),(104,115,1,0),(104,115,3,0),(104,115,5,0),(105,115,1,0),(105,115,3,0),(105,115,5,0),(106,115,1,0),(106,115,3,0),(106,115,5,0),(108,115,1,0),(108,115,3,0),(108,115,5,0),(109,115,1,0),(109,115,3,0),(109,115,5,0),(110,115,1,0),(110,115,3,0),(110,115,5,0),(111,115,1,0),(111,115,3,0),(111,115,5,0),(112,115,1,0),(112,115,3,0),(112,115,5,0),(113,115,1,0),(113,115,3,0),(113,115,5,0),(114,115,1,0),(114,115,3,0),(114,115,5,0),(115,115,1,0),(115,115,3,0),(115,115,5,0),(116,115,1,0),(116,115,3,0),(116,115,5,0),(117,115,1,0),(117,115,3,0),(117,115,5,0),(120,115,1,0),(120,115,3,0),(120,115,5,0),(121,115,1,0),(121,115,3,0),(121,115,5,0),(122,115,1,0),(122,115,3,0),(122,115,5,0),(123,115,1,0),(123,115,3,0),(123,115,5,0),(124,115,1,0),(124,115,3,0),(124,115,5,0),(125,115,1,0),(125,115,3,0),(125,115,5,0),(126,115,1,0),(126,115,3,0),(126,115,5,0),(127,115,1,0),(127,115,3,0),(127,115,5,0),(128,115,1,0),(128,115,3,0),(128,115,5,0),(129,115,1,0),(129,115,3,0),(129,115,5,0),(130,115,1,0),(130,115,3,0),(130,115,5,0),(131,115,1,0),(131,115,3,0),(131,115,5,0),(132,115,1,0),(132,115,3,0),(132,115,5,0),(133,115,1,0),(133,115,3,0),(133,115,5,0),(134,115,1,0),(134,115,3,0),(134,115,5,0),(135,115,1,0),(135,115,3,0),(135,115,5,0),(136,115,1,0),(136,115,3,0),(136,115,5,0),(137,115,1,0),(137,115,3,0),(137,115,5,0),(138,115,1,0),(138,115,3,0),(138,115,5,0),(139,115,1,0),(139,115,3,0),(139,115,5,0),(140,115,1,0),(140,115,3,0),(140,115,5,0),(141,115,1,0),(141,115,3,0),(141,115,5,0),(142,115,1,0),(142,115,3,0),(142,115,5,0),(143,115,1,0),(143,115,3,0),(143,115,5,0),(144,115,1,0),(144,115,3,0),(144,115,5,0),(145,115,1,0),(145,115,3,0),(145,115,5,0),(146,115,1,0),(146,115,3,0),(146,115,5,0),(147,115,1,0),(147,115,3,0),(147,115,5,0),(148,115,1,0),(148,115,3,0),(148,115,5,0),(149,115,1,0),(149,115,3,0),(149,115,5,0),(150,115,1,0),(150,115,3,0),(150,115,5,0),(151,115,1,0),(151,115,3,0),(151,115,5,0),(152,115,1,0),(152,115,3,0),(152,115,5,0),(153,115,1,0),(153,115,3,0),(153,115,5,0),(154,115,1,0),(154,115,3,0),(154,115,5,0),(155,115,1,0),(155,115,3,0),(155,115,5,0),(156,115,1,0),(156,115,3,0),(156,115,5,0),(157,115,1,0),(157,115,3,0),(157,115,5,0),(158,115,1,0),(158,115,3,0),(158,115,5,0),(159,115,1,0),(159,115,3,0),(159,115,5,0),(160,115,1,0),(160,115,3,0),(160,115,5,0),(161,115,1,0),(161,115,3,0),(161,115,5,0),(162,115,1,0),(162,115,3,0),(162,115,5,0),(163,115,1,0),(163,115,3,0),(163,115,5,0),(164,115,1,0),(164,115,3,0),(164,115,5,0),(165,115,1,0),(165,115,3,0),(165,115,5,0),(166,115,1,0),(166,115,3,0),(166,115,5,0),(173,115,1,0),(173,115,3,0),(173,115,5,0),(177,115,1,0),(177,115,3,0),(177,115,5,0),(178,115,1,0),(178,115,3,0),(178,115,5,0),(179,115,1,0),(179,115,3,0),(179,115,5,0),(180,115,1,0),(180,115,3,0),(180,115,5,0),(181,115,1,0),(181,115,3,0),(181,115,5,0),(182,115,1,0),(182,115,3,0),(182,115,5,0),(183,115,1,0),(183,115,3,0),(183,115,5,0),(184,115,1,0),(184,115,3,0),(184,115,5,0),(185,115,1,0),(185,115,3,0),(185,115,5,0),(186,115,1,0),(186,115,3,0),(186,115,5,0),(187,115,1,0),(187,115,3,0),(187,115,5,0),(188,115,1,0),(188,115,3,0),(188,115,5,0),(189,115,1,0),(189,115,3,0),(189,115,5,0),(190,115,1,0),(190,115,3,0),(190,115,5,0),(191,115,1,0),(191,115,3,0),(191,115,5,0),(192,115,1,0),(192,115,3,0),(192,115,5,0),(193,115,1,0),(193,115,3,0),(193,115,5,0),(194,115,1,0),(194,115,3,0),(194,115,5,0),(195,115,1,0),(195,115,3,0),(195,115,5,0),(196,115,1,0),(196,115,3,0),(196,115,5,0),(197,115,1,0),(197,115,3,0),(197,115,5,0),(198,115,1,0),(198,115,3,0),(198,115,5,0),(199,115,1,0),(199,115,3,0),(199,115,5,0),(200,115,1,0),(200,115,3,0),(200,115,5,0),(201,115,1,0),(201,115,3,0),(201,115,5,0),(202,115,1,0),(202,115,3,0),(202,115,5,0),(203,115,1,0),(203,115,3,0),(203,115,5,0),(204,115,1,0),(204,115,3,0),(204,115,5,0),(205,115,1,0),(205,115,3,0),(205,115,5,0),(206,115,1,0),(206,115,3,0),(206,115,5,0),(207,115,1,0),(207,115,3,0),(207,115,5,0),(208,115,1,0),(208,115,3,0),(208,115,5,0),(209,115,1,0),(209,115,3,0),(209,115,5,0),(210,115,1,0),(210,115,3,0),(210,115,5,0),(211,115,1,0),(211,115,3,0),(211,115,5,0),(212,115,1,0),(212,115,3,0),(212,115,5,0),(213,115,1,0),(213,115,3,0),(213,115,5,0),(214,115,1,0),(214,115,3,0),(214,115,5,0),(215,115,1,0),(215,115,3,0),(215,115,5,0),(216,115,1,0),(216,115,3,0),(216,115,5,0),(217,115,1,0),(217,115,3,0),(217,115,5,0),(218,115,1,0),(218,115,3,0),(218,115,5,0),(219,115,1,0),(219,115,3,0),(219,115,5,0),(220,115,1,0),(220,115,3,0),(220,115,5,0),(221,115,1,0),(221,115,3,0),(221,115,5,0),(222,115,1,0),(222,115,3,0),(222,115,5,0),(223,115,1,0),(223,115,3,0),(223,115,5,0),(224,115,1,0),(224,115,3,0),(224,115,5,0),(226,115,1,0),(226,115,3,0),(226,115,5,0),(227,115,1,0),(227,115,3,0),(227,115,5,0),(231,115,1,0),(231,115,3,0),(231,115,5,0),(232,115,1,0),(232,115,3,0),(232,115,5,0),(236,115,1,0),(236,115,3,0),(236,115,5,0),(238,115,1,0),(238,115,3,0),(238,115,5,0),(239,115,1,0),(239,115,3,0),(239,115,5,0),(241,115,1,0),(241,115,3,0),(241,115,5,0),(242,115,1,0),(242,115,3,0),(242,115,5,0),(243,115,1,0),(243,115,3,0),(243,115,5,0),(244,115,1,0),(244,115,3,0),(244,115,5,0),(245,115,1,0),(245,115,3,0),(245,115,5,0),(246,115,1,0),(246,115,3,0),(246,115,5,0),(247,115,1,0),(247,115,3,0),(247,115,5,0),(248,115,1,0),(248,115,3,0),(248,115,5,0),(249,115,1,0),(249,115,3,0),(249,115,5,0),(250,115,1,0),(250,115,3,0),(250,115,5,0),(251,115,1,0),(251,115,3,0),(251,115,5,0),(252,115,1,0),(252,115,3,0),(252,115,5,0),(253,115,1,0),(253,115,3,0),(253,115,5,0),(255,115,1,0),(255,115,3,0),(255,115,5,0),(256,115,1,0),(256,115,3,0),(256,115,5,0),(258,115,1,0),(258,115,3,0),(258,115,5,0),(259,115,1,0),(259,115,3,0),(259,115,5,0),(260,115,1,0),(260,115,3,0),(260,115,5,0),(261,115,1,0),(261,115,3,0),(261,115,5,0),(262,115,1,0),(262,115,3,0),(262,115,5,0),(263,115,1,0),(263,115,3,0),(263,115,5,0),(264,115,1,0),(264,115,3,0),(264,115,5,0),(265,115,1,0),(265,115,3,0),(265,115,5,0),(266,115,1,0),(266,115,3,0),(266,115,5,0),(267,115,1,0),(267,115,3,0),(267,115,5,0),(268,115,1,0),(268,115,3,0),(268,115,5,0),(269,115,1,0),(269,115,3,0),(269,115,5,0),(270,115,1,0),(270,115,3,0),(270,115,5,0),(271,115,1,0),(271,115,3,0),(271,115,5,0),(272,115,1,0),(272,115,3,0),(272,115,5,0),(273,115,1,0),(273,115,3,0),(273,115,5,0),(274,115,1,0),(274,115,3,0),(274,115,5,0),(275,115,1,0),(275,115,3,0),(275,115,5,0),(276,115,1,0),(276,115,3,0),(276,115,5,0),(277,115,1,0),(277,115,3,0),(277,115,5,0),(278,115,1,0),(278,115,3,0),(278,115,5,0),(279,115,1,0),(279,115,3,0),(279,115,5,0),(280,115,1,0),(280,115,3,0),(280,115,5,0),(281,115,1,0),(281,115,3,0),(281,115,5,0),(282,115,1,0),(282,115,3,0),(282,115,5,0),(283,115,1,0),(283,115,3,0),(283,115,5,0),(284,115,1,0),(284,115,3,0),(284,115,5,0),(285,115,1,0),(285,115,3,0),(285,115,5,0),(286,115,1,0),(286,115,3,0),(286,115,5,0),(287,115,1,0),(287,115,3,0),(287,115,5,0),(288,115,1,0),(288,115,3,0),(288,115,5,0),(289,115,1,0),(289,115,3,0),(289,115,5,0),(290,115,1,0),(290,115,3,0),(290,115,5,0),(291,115,1,0),(291,115,3,0),(291,115,5,0),(292,115,1,0),(292,115,3,0),(292,115,5,0),(293,115,1,0),(293,115,3,0),(293,115,5,0),(294,115,1,0),(294,115,3,0),(294,115,5,0),(295,115,1,0),(295,115,3,0),(295,115,5,0),(296,115,1,0),(296,115,3,0),(296,115,5,0),(297,115,1,0),(297,115,3,0),(297,115,5,0),(298,115,1,0),(298,115,3,0),(298,115,5,0);
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `value` int(10) unsigned NOT NULL COMMENT 'Value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_ENTITY_ID` (`entity_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_STORE_ID` (`store_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_VALUE` (`value`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product EAV Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_tmp`
--

LOCK TABLES `catalog_product_index_eav_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_group_price`
--

DROP TABLE IF EXISTS `catalog_product_index_group_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_group_price` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_GROUP_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_GROUP_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_195DF97C81B0BDD6A2EEC50F870E16D1` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_GROUP_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_GROUP_PRICE_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Group Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_group_price`
--

LOCK TABLES `catalog_product_index_group_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_group_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_group_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price`
--

DROP TABLE IF EXISTS `catalog_product_index_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(12,4) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_WEBSITE_ID` (`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE` (`min_price`),
  KEY `IDX_CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE` (`website_id`,`customer_group_id`,`min_price`),
  CONSTRAINT `FK_CAT_PRD_IDX_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_PRICE_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price`
--

LOCK TABLES `catalog_product_index_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price` VALUES (1,0,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(1,1,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(1,2,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(1,3,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(226,0,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(226,1,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(226,2,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(226,3,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(227,0,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(227,1,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(227,2,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(227,3,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(231,0,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(231,1,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(231,2,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(231,3,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(232,0,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(232,1,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(232,2,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(232,3,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(236,0,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(236,1,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(236,2,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(236,3,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(238,0,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(238,1,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(238,2,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(238,3,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(239,0,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(239,1,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(239,2,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(239,3,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(241,0,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(241,1,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(241,2,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(241,3,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(242,0,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(242,1,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(242,2,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(242,3,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(243,0,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(243,1,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(243,2,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(243,3,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(244,0,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(244,1,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(244,2,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(244,3,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(245,0,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(245,1,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(245,2,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(245,3,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(246,0,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(246,1,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(246,2,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(246,3,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(247,0,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(247,1,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(247,2,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(247,3,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(248,0,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(248,1,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(248,2,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(248,3,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(249,0,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(249,1,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(249,2,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(249,3,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(250,0,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(250,1,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(250,2,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(250,3,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(251,0,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(251,1,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(251,2,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(251,3,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(252,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(252,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(252,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(252,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(253,0,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(253,1,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(253,2,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(253,3,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(255,0,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(255,1,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(255,2,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(255,3,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(287,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(287,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(287,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(287,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(292,0,1,0,373.9900,373.9900,373.9900,373.9900,300.0000,NULL),(292,1,1,0,373.9900,373.9900,373.9900,373.9900,300.0000,NULL),(292,2,1,0,373.9900,373.9900,373.9900,373.9900,300.0000,NULL),(292,3,1,0,373.9900,373.9900,373.9900,373.9900,300.0000,NULL),(293,0,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(293,1,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(293,2,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(293,3,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(294,0,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(294,1,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(294,2,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(294,3,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(295,0,1,0,NULL,NULL,35.9500,373.9900,NULL,NULL),(295,1,1,0,NULL,NULL,35.9500,373.9900,NULL,NULL),(295,2,1,0,NULL,NULL,35.9500,373.9900,NULL,NULL),(295,3,1,0,NULL,NULL,35.9500,373.9900,NULL,NULL),(296,0,1,0,0.0000,0.0000,300.0000,1645.9600,NULL,NULL),(296,1,1,0,0.0000,0.0000,300.0000,1645.9600,NULL,NULL),(296,2,1,0,0.0000,0.0000,300.0000,1645.9600,NULL,NULL),(296,3,1,0,0.0000,0.0000,300.0000,1645.9600,NULL,NULL),(297,0,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(297,1,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(297,2,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(297,3,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(298,0,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL),(298,1,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL),(298,2,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL),(298,3,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class Id',
  `price_type` smallint(5) unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(12,4) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  `base_group_price` decimal(12,4) DEFAULT NULL COMMENT 'Base Group Price',
  `group_price_percent` decimal(12,4) DEFAULT NULL COMMENT 'Group Price Percent',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_bundle_idx` VALUES (296,0,1,0,0,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL),(296,1,1,0,0,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL),(296,2,1,0,0,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL),(296,3,1,0,0,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  `alt_group_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Group Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Opt Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_bundle_opt_idx` VALUES (296,0,1,5,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,0,1,6,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,0,1,7,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,0,1,8,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,1,1,5,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,1,1,6,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,1,1,7,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,1,1,8,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,2,1,5,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,2,1,6,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,2,1,7,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,2,1,8,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,3,1,5,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,3,1,6,73.9900,0.0000,148.9900,NULL,0.0000,NULL,0.0000),(296,3,1,7,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000),(296,3,1,8,73.9900,0.0000,75.0000,NULL,0.0000,NULL,0.0000);
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  `alt_group_price` decimal(12,4) DEFAULT NULL COMMENT 'Alt Group Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Opt Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `selection_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Id',
  `group_type` smallint(5) unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint(5) unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Sel Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_bundle_sel_idx` VALUES (296,0,1,5,9,1,1,73.9900,NULL,NULL),(296,0,1,5,10,1,1,75.0000,NULL,NULL),(296,0,1,6,11,1,1,73.9900,NULL,NULL),(296,0,1,6,12,1,1,75.0000,NULL,NULL),(296,0,1,7,13,0,1,73.9900,NULL,NULL),(296,0,1,7,14,0,1,75.0000,NULL,NULL),(296,0,1,8,15,0,1,73.9900,NULL,NULL),(296,0,1,8,16,0,1,75.0000,NULL,NULL),(296,1,1,5,9,1,1,73.9900,NULL,NULL),(296,1,1,5,10,1,1,75.0000,NULL,NULL),(296,1,1,6,11,1,1,73.9900,NULL,NULL),(296,1,1,6,12,1,1,75.0000,NULL,NULL),(296,1,1,7,13,0,1,73.9900,NULL,NULL),(296,1,1,7,14,0,1,75.0000,NULL,NULL),(296,1,1,8,15,0,1,73.9900,NULL,NULL),(296,1,1,8,16,0,1,75.0000,NULL,NULL),(296,2,1,5,9,1,1,73.9900,NULL,NULL),(296,2,1,5,10,1,1,75.0000,NULL,NULL),(296,2,1,6,11,1,1,73.9900,NULL,NULL),(296,2,1,6,12,1,1,75.0000,NULL,NULL),(296,2,1,7,13,0,1,73.9900,NULL,NULL),(296,2,1,7,14,0,1,75.0000,NULL,NULL),(296,2,1,8,15,0,1,73.9900,NULL,NULL),(296,2,1,8,16,0,1,75.0000,NULL,NULL),(296,3,1,5,9,1,1,73.9900,NULL,NULL),(296,3,1,5,10,1,1,75.0000,NULL,NULL),(296,3,1,6,11,1,1,73.9900,NULL,NULL),(296,3,1,6,12,1,1,75.0000,NULL,NULL),(296,3,1,7,13,0,1,73.9900,NULL,NULL),(296,3,1,7,14,0,1,75.0000,NULL,NULL),(296,3,1,8,15,0,1,73.9900,NULL,NULL),(296,3,1,8,16,0,1,75.0000,NULL,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `selection_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Id',
  `group_type` smallint(5) unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint(5) unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Sel Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class Id',
  `price_type` smallint(5) unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(12,4) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(12,4) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  `base_group_price` decimal(12,4) DEFAULT NULL COMMENT 'Base Group Price',
  `group_price_percent` decimal(12,4) DEFAULT NULL COMMENT 'Group Price Percent',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Index Price Bundle Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_idx` (
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int(10) unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Aggregate Index ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_agr_idx`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_agr_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_tmp` (
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int(10) unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Aggregate Temp T';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_agr_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_idx`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Config Option Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_downlod_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_downlod_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Minimum price',
  `max_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Indexer Table for price of downloadable products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_downlod_idx`
--

LOCK TABLES `catalog_product_index_price_downlod_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_downlod_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_downlod_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Minimum price',
  `max_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Temporary Indexer Table for price of downloadable products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_downlod_tmp`
--

LOCK TABLES `catalog_product_index_price_downlod_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_final_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_final_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  `base_group_price` decimal(12,4) DEFAULT NULL COMMENT 'Base Group Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Final Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_final_idx`
--

LOCK TABLES `catalog_product_index_price_final_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_final_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_final_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_final_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_final_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(12,4) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(12,4) DEFAULT NULL COMMENT 'Base Tier',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  `base_group_price` decimal(12,4) DEFAULT NULL COMMENT 'Base Group Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Final Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_final_tmp`
--

LOCK TABLES `catalog_product_index_price_final_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_final_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_final_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(12,4) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_IDX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_IDX_WEBSITE_ID` (`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_IDX_MIN_PRICE` (`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_idx`
--

LOCK TABLES `catalog_product_index_price_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_idx` VALUES (1,0,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(1,1,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(1,2,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(1,3,1,4,156.0000,156.0000,171.6000,179.4000,110.0000,NULL),(2,0,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(2,1,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(2,2,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(2,3,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(8,0,1,0,4.1900,4.1900,4.1900,4.1900,NULL,NULL),(8,1,1,0,4.1900,4.1900,4.1900,4.1900,NULL,NULL),(8,2,1,0,4.1900,4.1900,4.1900,4.1900,NULL,NULL),(8,3,1,0,4.1900,4.1900,4.1900,4.1900,NULL,NULL),(10,0,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(10,1,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(10,2,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(10,3,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(11,0,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(11,1,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(11,2,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(11,3,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(12,0,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(12,1,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(12,2,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(12,3,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(13,0,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(13,1,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(13,2,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(13,3,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(14,0,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(14,1,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(14,2,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(14,3,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(15,0,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(15,1,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(15,2,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(15,3,1,0,159.9900,159.9900,159.9900,159.9900,NULL,NULL),(16,0,1,0,259.9900,259.9900,259.9900,259.9900,NULL,NULL),(16,1,1,0,259.9900,259.9900,259.9900,259.9900,NULL,NULL),(16,2,1,0,259.9900,259.9900,259.9900,259.9900,NULL,NULL),(16,3,1,0,259.9900,259.9900,259.9900,259.9900,NULL,NULL),(17,0,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(17,1,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(17,2,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(17,3,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(18,0,1,0,129.9900,129.9900,129.9900,129.9900,NULL,NULL),(18,1,1,0,129.9900,129.9900,129.9900,129.9900,NULL,NULL),(18,2,1,0,129.9900,129.9900,129.9900,129.9900,NULL,NULL),(18,3,1,0,129.9900,129.9900,129.9900,129.9900,NULL,NULL),(19,0,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(19,1,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(19,2,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(19,3,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(20,0,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(20,1,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(20,2,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(20,3,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(21,0,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(21,1,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(21,2,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(21,3,1,0,99.9900,99.9900,99.9900,99.9900,NULL,NULL),(22,0,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(22,1,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(22,2,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(22,3,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(23,0,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(23,1,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(23,2,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(23,3,1,0,149.9900,149.9900,149.9900,149.9900,NULL,NULL),(24,0,1,0,279.9900,279.9900,279.9900,279.9900,NULL,NULL),(24,1,1,0,279.9900,279.9900,279.9900,279.9900,NULL,NULL),(24,2,1,0,279.9900,279.9900,279.9900,279.9900,NULL,NULL),(24,3,1,0,279.9900,279.9900,279.9900,279.9900,NULL,NULL),(25,0,1,0,109.9900,109.9900,109.9900,109.9900,NULL,NULL),(25,1,1,0,109.9900,109.9900,109.9900,109.9900,NULL,NULL),(25,2,1,0,109.9900,109.9900,109.9900,109.9900,NULL,NULL),(25,3,1,0,109.9900,109.9900,109.9900,109.9900,NULL,NULL),(26,0,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(26,1,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(26,2,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(26,3,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(27,0,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(27,1,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(27,2,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(27,3,1,0,369.9900,369.9900,369.9900,369.9900,NULL,NULL),(28,0,1,0,399.9900,399.9900,399.9900,399.9900,NULL,NULL),(28,1,1,0,399.9900,399.9900,399.9900,399.9900,NULL,NULL),(28,2,1,0,399.9900,399.9900,399.9900,399.9900,NULL,NULL),(28,3,1,0,399.9900,399.9900,399.9900,399.9900,NULL,NULL),(29,0,1,0,349.9900,349.9900,349.9900,349.9900,NULL,NULL),(29,1,1,0,349.9900,349.9900,349.9900,349.9900,NULL,NULL),(29,2,1,0,349.9900,349.9900,349.9900,349.9900,NULL,NULL),(29,3,1,0,349.9900,349.9900,349.9900,349.9900,NULL,NULL),(30,0,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(30,1,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(30,2,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(30,3,1,0,299.9900,299.9900,299.9900,299.9900,NULL,NULL),(32,0,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(32,1,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(32,2,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(32,3,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(33,0,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(33,1,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(33,2,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(33,3,1,0,17.9900,12.0000,12.0000,12.0000,NULL,NULL),(34,0,1,0,20.9800,20.9800,20.9800,20.9800,NULL,NULL),(34,1,1,0,20.9800,20.9800,20.9800,20.9800,NULL,NULL),(34,2,1,0,20.9800,20.9800,20.9800,20.9800,NULL,NULL),(34,3,1,0,20.9800,20.9800,20.9800,20.9800,NULL,NULL),(37,0,1,0,169.9900,169.9900,169.9900,169.9900,NULL,NULL),(37,1,1,0,169.9900,169.9900,169.9900,169.9900,NULL,NULL),(37,2,1,0,169.9900,169.9900,169.9900,169.9900,NULL,NULL),(37,3,1,0,169.9900,169.9900,169.9900,169.9900,NULL,NULL),(38,0,1,0,88.1400,88.1400,88.1400,88.1400,NULL,NULL),(38,1,1,0,88.1400,88.1400,88.1400,88.1400,NULL,NULL),(38,2,1,0,88.1400,88.1400,88.1400,88.1400,NULL,NULL),(38,3,1,0,88.1400,88.1400,88.1400,88.1400,NULL,NULL),(39,0,1,0,90.3900,90.3900,90.3900,90.3900,NULL,NULL),(39,1,1,0,90.3900,90.3900,90.3900,90.3900,NULL,NULL),(39,2,1,0,90.3900,90.3900,90.3900,90.3900,NULL,NULL),(39,3,1,0,90.3900,90.3900,90.3900,90.3900,NULL,NULL),(40,0,1,0,91.9500,91.9500,91.9500,91.9500,NULL,NULL),(40,1,1,0,91.9500,91.9500,91.9500,91.9500,NULL,NULL),(40,2,1,0,91.9500,91.9500,91.9500,91.9500,NULL,NULL),(40,3,1,0,91.9500,91.9500,91.9500,91.9500,NULL,NULL),(41,0,1,0,333.3300,333.3300,333.3300,333.3300,NULL,NULL),(41,1,1,0,333.3300,333.3300,333.3300,333.3300,NULL,NULL),(41,2,1,0,333.3300,333.3300,333.3300,333.3300,NULL,NULL),(41,3,1,0,333.3300,333.3300,333.3300,333.3300,NULL,NULL),(42,0,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(42,1,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(42,2,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(42,3,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(43,0,1,0,79.9900,79.9900,79.9900,79.9900,NULL,NULL),(43,1,1,0,79.9900,79.9900,79.9900,79.9900,NULL,NULL),(43,2,1,0,79.9900,79.9900,79.9900,79.9900,NULL,NULL),(43,3,1,0,79.9900,79.9900,79.9900,79.9900,NULL,NULL),(45,0,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(45,1,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(45,2,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(45,3,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(46,0,1,0,22.1900,22.1900,22.1900,22.1900,NULL,NULL),(46,1,1,0,22.1900,22.1900,22.1900,22.1900,NULL,NULL),(46,2,1,0,22.1900,22.1900,22.1900,22.1900,NULL,NULL),(46,3,1,0,22.1900,22.1900,22.1900,22.1900,NULL,NULL),(47,0,1,0,16.8900,12.0000,12.0000,12.0000,NULL,NULL),(47,1,1,0,16.8900,12.0000,12.0000,12.0000,NULL,NULL),(47,2,1,0,16.8900,12.0000,12.0000,12.0000,NULL,NULL),(47,3,1,0,16.8900,12.0000,12.0000,12.0000,NULL,NULL),(48,0,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(48,1,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(48,2,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(48,3,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(49,0,1,0,9.5900,9.5900,9.5900,9.5900,NULL,NULL),(49,1,1,0,9.5900,9.5900,9.5900,9.5900,NULL,NULL),(49,2,1,0,9.5900,9.5900,9.5900,9.5900,NULL,NULL),(49,3,1,0,9.5900,9.5900,9.5900,9.5900,NULL,NULL),(50,0,1,0,25.6900,25.6900,25.6900,25.6900,NULL,NULL),(50,1,1,0,25.6900,25.6900,25.6900,25.6900,NULL,NULL),(50,2,1,0,25.6900,25.6900,25.6900,25.6900,NULL,NULL),(50,3,1,0,25.6900,25.6900,25.6900,25.6900,NULL,NULL),(51,0,1,0,14.1300,14.1300,14.1300,14.1300,NULL,NULL),(51,1,1,0,14.1300,14.1300,14.1300,14.1300,NULL,NULL),(51,2,1,0,14.1300,14.1300,14.1300,14.1300,NULL,NULL),(51,3,1,0,14.1300,14.1300,14.1300,14.1300,NULL,NULL),(52,0,1,0,16.4100,12.0000,12.0000,12.0000,NULL,NULL),(52,1,1,0,16.4100,12.0000,12.0000,12.0000,NULL,NULL),(52,2,1,0,16.4100,12.0000,12.0000,12.0000,NULL,NULL),(52,3,1,0,16.4100,12.0000,12.0000,12.0000,NULL,NULL),(53,0,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(53,1,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(53,2,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(53,3,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(54,0,1,0,11.8900,11.8900,11.8900,11.8900,NULL,NULL),(54,1,1,0,11.8900,11.8900,11.8900,11.8900,NULL,NULL),(54,2,1,0,11.8900,11.8900,11.8900,11.8900,NULL,NULL),(54,3,1,0,11.8900,11.8900,11.8900,11.8900,NULL,NULL),(55,0,1,0,14.9500,14.9500,14.9500,14.9500,NULL,NULL),(55,1,1,0,14.9500,14.9500,14.9500,14.9500,NULL,NULL),(55,2,1,0,14.9500,14.9500,14.9500,14.9500,NULL,NULL),(55,3,1,0,14.9500,14.9500,14.9500,14.9500,NULL,NULL),(56,0,1,0,39.9500,39.9500,39.9500,39.9500,NULL,NULL),(56,1,1,0,39.9500,39.9500,39.9500,39.9500,NULL,NULL),(56,2,1,0,39.9500,39.9500,39.9500,39.9500,NULL,NULL),(56,3,1,0,39.9500,39.9500,39.9500,39.9500,NULL,NULL),(57,0,1,0,175.0000,175.0000,175.0000,175.0000,NULL,NULL),(57,1,1,0,175.0000,175.0000,175.0000,175.0000,NULL,NULL),(57,2,1,0,175.0000,175.0000,175.0000,175.0000,NULL,NULL),(57,3,1,0,175.0000,175.0000,175.0000,175.0000,NULL,NULL),(58,0,1,0,54.9900,54.9900,54.9900,54.9900,NULL,NULL),(58,1,1,0,54.9900,54.9900,54.9900,54.9900,NULL,NULL),(58,2,1,0,54.9900,54.9900,54.9900,54.9900,NULL,NULL),(58,3,1,0,54.9900,54.9900,54.9900,54.9900,NULL,NULL),(59,0,1,0,489.5000,489.5000,489.5000,489.5000,NULL,NULL),(59,1,1,0,489.5000,489.5000,489.5000,489.5000,NULL,NULL),(59,2,1,0,489.5000,489.5000,489.5000,489.5000,NULL,NULL),(59,3,1,0,489.5000,489.5000,489.5000,489.5000,NULL,NULL),(60,0,1,0,643.6900,643.6900,643.6900,643.6900,NULL,NULL),(60,1,1,0,643.6900,643.6900,643.6900,643.6900,NULL,NULL),(60,2,1,0,643.6900,643.6900,643.6900,643.6900,NULL,NULL),(60,3,1,0,643.6900,643.6900,643.6900,643.6900,NULL,NULL),(61,0,1,0,488.9000,488.9000,488.9000,488.9000,NULL,NULL),(61,1,1,0,488.9000,488.9000,488.9000,488.9000,NULL,NULL),(61,2,1,0,488.9000,488.9000,488.9000,488.9000,NULL,NULL),(61,3,1,0,488.9000,488.9000,488.9000,488.9000,NULL,NULL),(62,0,1,0,445.0000,445.0000,445.0000,445.0000,NULL,NULL),(62,1,1,0,445.0000,445.0000,445.0000,445.0000,NULL,NULL),(62,2,1,0,445.0000,445.0000,445.0000,445.0000,NULL,NULL),(62,3,1,0,445.0000,445.0000,445.0000,445.0000,NULL,NULL),(63,0,1,0,575.1700,575.1700,575.1700,575.1700,NULL,NULL),(63,1,1,0,575.1700,575.1700,575.1700,575.1700,NULL,NULL),(63,2,1,0,575.1700,575.1700,575.1700,575.1700,NULL,NULL),(63,3,1,0,575.1700,575.1700,575.1700,575.1700,NULL,NULL),(64,0,1,0,74.9900,74.9900,74.9900,74.9900,NULL,NULL),(64,1,1,0,74.9900,74.9900,74.9900,74.9900,NULL,NULL),(64,2,1,0,74.9900,74.9900,74.9900,74.9900,NULL,NULL),(64,3,1,0,74.9900,74.9900,74.9900,74.9900,NULL,NULL),(65,0,1,0,549.0000,549.0000,549.0000,549.0000,NULL,NULL),(65,1,1,0,549.0000,549.0000,549.0000,549.0000,NULL,NULL),(65,2,1,0,549.0000,549.0000,549.0000,549.0000,NULL,NULL),(65,3,1,0,549.0000,549.0000,549.0000,549.0000,NULL,NULL),(66,0,1,0,624.0000,624.0000,624.0000,624.0000,NULL,NULL),(66,1,1,0,624.0000,624.0000,624.0000,624.0000,NULL,NULL),(66,2,1,0,624.0000,624.0000,624.0000,624.0000,NULL,NULL),(66,3,1,0,624.0000,624.0000,624.0000,624.0000,NULL,NULL),(67,0,1,0,469.3700,469.3700,469.3700,469.3700,NULL,NULL),(67,1,1,0,469.3700,469.3700,469.3700,469.3700,NULL,NULL),(67,2,1,0,469.3700,469.3700,469.3700,469.3700,NULL,NULL),(67,3,1,0,469.3700,469.3700,469.3700,469.3700,NULL,NULL),(68,0,1,0,498.9900,498.9900,498.9900,498.9900,NULL,NULL),(68,1,1,0,498.9900,498.9900,498.9900,498.9900,NULL,NULL),(68,2,1,0,498.9900,498.9900,498.9900,498.9900,NULL,NULL),(68,3,1,0,498.9900,498.9900,498.9900,498.9900,NULL,NULL),(69,0,1,0,436.5800,436.5800,436.5800,436.5800,NULL,NULL),(69,1,1,0,436.5800,436.5800,436.5800,436.5800,NULL,NULL),(69,2,1,0,436.5800,436.5800,436.5800,436.5800,NULL,NULL),(69,3,1,0,436.5800,436.5800,436.5800,436.5800,NULL,NULL),(70,0,1,0,329.9900,329.9900,329.9900,329.9900,NULL,NULL),(70,1,1,0,329.9900,329.9900,329.9900,329.9900,NULL,NULL),(70,2,1,0,329.9900,329.9900,329.9900,329.9900,NULL,NULL),(70,3,1,0,329.9900,329.9900,329.9900,329.9900,NULL,NULL),(71,0,1,0,849.0000,849.0000,849.0000,849.0000,NULL,NULL),(71,1,1,0,849.0000,849.0000,849.0000,849.0000,NULL,NULL),(71,2,1,0,849.0000,849.0000,849.0000,849.0000,NULL,NULL),(71,3,1,0,849.0000,849.0000,849.0000,849.0000,NULL,NULL),(72,0,1,0,44.5000,44.5000,44.5000,44.5000,NULL,NULL),(72,1,1,0,44.5000,44.5000,44.5000,44.5000,NULL,NULL),(72,2,1,0,44.5000,44.5000,44.5000,44.5000,NULL,NULL),(72,3,1,0,44.5000,44.5000,44.5000,44.5000,NULL,NULL),(73,0,1,0,394.1600,394.1600,394.1600,394.1600,NULL,NULL),(73,1,1,0,394.1600,394.1600,394.1600,394.1600,NULL,NULL),(73,2,1,0,394.1600,394.1600,394.1600,394.1600,NULL,NULL),(73,3,1,0,394.1600,394.1600,394.1600,394.1600,NULL,NULL),(74,0,1,0,189.0000,189.0000,189.0000,189.0000,NULL,NULL),(74,1,1,0,189.0000,189.0000,189.0000,189.0000,NULL,NULL),(74,2,1,0,189.0000,189.0000,189.0000,189.0000,NULL,NULL),(74,3,1,0,189.0000,189.0000,189.0000,189.0000,NULL,NULL),(75,0,1,0,224.0000,224.0000,224.0000,224.0000,NULL,NULL),(75,1,1,0,224.0000,224.0000,224.0000,224.0000,NULL,NULL),(75,2,1,0,224.0000,224.0000,224.0000,224.0000,NULL,NULL),(75,3,1,0,224.0000,224.0000,224.0000,224.0000,NULL,NULL),(76,0,1,0,299.0000,299.0000,299.0000,299.0000,NULL,NULL),(76,1,1,0,299.0000,299.0000,299.0000,299.0000,NULL,NULL),(76,2,1,0,299.0000,299.0000,299.0000,299.0000,NULL,NULL),(76,3,1,0,299.0000,299.0000,299.0000,299.0000,NULL,NULL),(77,0,1,0,219.4100,219.4100,219.4100,219.4100,NULL,NULL),(77,1,1,0,219.4100,219.4100,219.4100,219.4100,NULL,NULL),(77,2,1,0,219.4100,219.4100,219.4100,219.4100,NULL,NULL),(77,3,1,0,219.4100,219.4100,219.4100,219.4100,NULL,NULL),(78,0,1,0,518.9900,518.9900,518.9900,518.9900,NULL,NULL),(78,1,1,0,518.9900,518.9900,518.9900,518.9900,NULL,NULL),(78,2,1,0,518.9900,518.9900,518.9900,518.9900,NULL,NULL),(78,3,1,0,518.9900,518.9900,518.9900,518.9900,NULL,NULL),(79,0,1,0,1199.0000,1199.0000,1199.0000,1199.0000,NULL,NULL),(79,1,1,0,1199.0000,1199.0000,1199.0000,1199.0000,NULL,NULL),(79,2,1,0,1199.0000,1199.0000,1199.0000,1199.0000,NULL,NULL),(79,3,1,0,1199.0000,1199.0000,1199.0000,1199.0000,NULL,NULL),(80,0,1,0,169.0000,169.0000,169.0000,169.0000,NULL,NULL),(80,1,1,0,169.0000,169.0000,169.0000,169.0000,NULL,NULL),(80,2,1,0,169.0000,169.0000,169.0000,169.0000,NULL,NULL),(80,3,1,0,169.0000,169.0000,169.0000,169.0000,NULL,NULL),(81,0,1,0,279.0000,279.0000,279.0000,279.0000,NULL,NULL),(81,1,1,0,279.0000,279.0000,279.0000,279.0000,NULL,NULL),(81,2,1,0,279.0000,279.0000,279.0000,279.0000,NULL,NULL),(81,3,1,0,279.0000,279.0000,279.0000,279.0000,NULL,NULL),(82,0,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(82,1,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(82,2,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(82,3,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(83,0,1,0,319.0000,319.0000,319.0000,319.0000,NULL,NULL),(83,1,1,0,319.0000,319.0000,319.0000,319.0000,NULL,NULL),(83,2,1,0,319.0000,319.0000,319.0000,319.0000,NULL,NULL),(83,3,1,0,319.0000,319.0000,319.0000,319.0000,NULL,NULL),(84,0,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(84,1,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(84,2,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(84,3,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(85,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(85,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(85,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(85,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(86,0,1,0,699.0000,699.0000,699.0000,699.0000,NULL,NULL),(86,1,1,0,699.0000,699.0000,699.0000,699.0000,NULL,NULL),(86,2,1,0,699.0000,699.0000,699.0000,699.0000,NULL,NULL),(86,3,1,0,699.0000,699.0000,699.0000,699.0000,NULL,NULL),(87,0,1,0,369.0000,369.0000,369.0000,369.0000,NULL,NULL),(87,1,1,0,369.0000,369.0000,369.0000,369.0000,NULL,NULL),(87,2,1,0,369.0000,369.0000,369.0000,369.0000,NULL,NULL),(87,3,1,0,369.0000,369.0000,369.0000,369.0000,NULL,NULL),(88,0,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(88,1,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(88,2,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(88,3,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(89,0,1,0,249.0000,249.0000,249.0000,249.0000,NULL,NULL),(89,1,1,0,249.0000,249.0000,249.0000,249.0000,NULL,NULL),(89,2,1,0,249.0000,249.0000,249.0000,249.0000,NULL,NULL),(89,3,1,0,249.0000,249.0000,249.0000,249.0000,NULL,NULL),(90,0,1,0,799.0000,799.0000,799.0000,799.0000,NULL,NULL),(90,1,1,0,799.0000,799.0000,799.0000,799.0000,NULL,NULL),(90,2,1,0,799.0000,799.0000,799.0000,799.0000,NULL,NULL),(90,3,1,0,799.0000,799.0000,799.0000,799.0000,NULL,NULL),(91,0,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(91,1,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(91,2,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(91,3,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(92,0,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(92,1,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(92,2,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(92,3,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(93,0,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(93,1,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(93,2,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(93,3,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(94,0,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(94,1,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(94,2,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(94,3,1,0,1679.0000,1679.0000,1679.0000,1679.0000,NULL,NULL),(95,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(95,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(95,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(95,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(96,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(96,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(96,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(96,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(97,0,1,0,26.8300,26.8300,26.8300,26.8300,NULL,NULL),(97,1,1,0,26.8300,26.8300,26.8300,26.8300,NULL,NULL),(97,2,1,0,26.8300,26.8300,26.8300,26.8300,NULL,NULL),(97,3,1,0,26.8300,26.8300,26.8300,26.8300,NULL,NULL),(98,0,1,0,21.0000,21.0000,21.0000,21.0000,NULL,NULL),(98,1,1,0,21.0000,21.0000,21.0000,21.0000,NULL,NULL),(98,2,1,0,21.0000,21.0000,21.0000,21.0000,NULL,NULL),(98,3,1,0,21.0000,21.0000,21.0000,21.0000,NULL,NULL),(99,0,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(99,1,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(99,2,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(99,3,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(100,0,1,0,47.2000,47.2000,47.2000,47.2000,NULL,NULL),(100,1,1,0,47.2000,47.2000,47.2000,47.2000,NULL,NULL),(100,2,1,0,47.2000,47.2000,47.2000,47.2000,NULL,NULL),(100,3,1,0,47.2000,47.2000,47.2000,47.2000,NULL,NULL),(101,0,1,0,3.9900,3.9900,3.9900,3.9900,NULL,NULL),(101,1,1,0,3.9900,3.9900,3.9900,3.9900,NULL,NULL),(101,2,1,0,3.9900,3.9900,3.9900,3.9900,NULL,NULL),(101,3,1,0,3.9900,3.9900,3.9900,3.9900,NULL,NULL),(102,0,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(102,1,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(102,2,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(102,3,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(103,0,1,0,219.0000,219.0000,219.0000,219.0000,NULL,NULL),(103,1,1,0,219.0000,219.0000,219.0000,219.0000,NULL,NULL),(103,2,1,0,219.0000,219.0000,219.0000,219.0000,NULL,NULL),(103,3,1,0,219.0000,219.0000,219.0000,219.0000,NULL,NULL),(104,0,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(104,1,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(104,2,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(104,3,1,0,79.0000,79.0000,79.0000,79.0000,NULL,NULL),(105,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(105,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(105,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(105,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(106,0,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(106,1,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(106,2,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(106,3,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(108,0,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(108,1,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(108,2,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(108,3,1,0,599.0000,599.0000,599.0000,599.0000,NULL,NULL),(109,0,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(109,1,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(109,2,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(109,3,1,0,113.0000,113.0000,113.0000,113.0000,NULL,NULL),(110,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(110,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(110,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(110,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(111,0,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(111,1,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(111,2,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(111,3,1,0,24.9900,24.9900,24.9900,24.9900,NULL,NULL),(112,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(112,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(112,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(112,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(113,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(113,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(113,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(113,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(114,0,1,0,103.2500,103.2500,103.2500,103.2500,NULL,NULL),(114,1,1,0,103.2500,103.2500,103.2500,103.2500,NULL,NULL),(114,2,1,0,103.2500,103.2500,103.2500,103.2500,NULL,NULL),(114,3,1,0,103.2500,103.2500,103.2500,103.2500,NULL,NULL),(115,0,1,0,9.9900,9.9900,9.9900,9.9900,NULL,NULL),(115,1,1,0,9.9900,9.9900,9.9900,9.9900,NULL,NULL),(115,2,1,0,9.9900,9.9900,9.9900,9.9900,NULL,NULL),(115,3,1,0,9.9900,9.9900,9.9900,9.9900,NULL,NULL),(116,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(116,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(116,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(116,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(117,0,1,0,84.9900,84.9900,84.9900,84.9900,NULL,NULL),(117,1,1,0,84.9900,84.9900,84.9900,84.9900,NULL,NULL),(117,2,1,0,84.9900,84.9900,84.9900,84.9900,NULL,NULL),(117,3,1,0,84.9900,84.9900,84.9900,84.9900,NULL,NULL),(120,0,1,0,55.9900,55.9900,55.9900,55.9900,NULL,NULL),(120,1,1,0,55.9900,55.9900,55.9900,55.9900,NULL,NULL),(120,2,1,0,55.9900,55.9900,55.9900,55.9900,NULL,NULL),(120,3,1,0,55.9900,55.9900,55.9900,55.9900,NULL,NULL),(121,0,1,0,80.0100,80.0100,80.0100,80.0100,NULL,NULL),(121,1,1,0,80.0100,80.0100,80.0100,80.0100,NULL,NULL),(121,2,1,0,80.0100,80.0100,80.0100,80.0100,NULL,NULL),(121,3,1,0,80.0100,80.0100,80.0100,80.0100,NULL,NULL),(122,0,1,0,49.0000,49.0000,49.0000,49.0000,NULL,NULL),(122,1,1,0,49.0000,49.0000,49.0000,49.0000,NULL,NULL),(122,2,1,0,49.0000,49.0000,49.0000,49.0000,NULL,NULL),(122,3,1,0,49.0000,49.0000,49.0000,49.0000,NULL,NULL),(123,0,1,0,160.0000,160.0000,160.0000,160.0000,NULL,NULL),(123,1,1,0,160.0000,160.0000,160.0000,160.0000,NULL,NULL),(123,2,1,0,160.0000,160.0000,160.0000,160.0000,NULL,NULL),(123,3,1,0,160.0000,160.0000,160.0000,160.0000,NULL,NULL),(124,0,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(124,1,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(124,2,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(124,3,1,0,88.9900,88.9900,88.9900,88.9900,NULL,NULL),(125,0,1,0,69.0000,69.0000,69.0000,69.0000,NULL,NULL),(125,1,1,0,69.0000,69.0000,69.0000,69.0000,NULL,NULL),(125,2,1,0,69.0000,69.0000,69.0000,69.0000,NULL,NULL),(125,3,1,0,69.0000,69.0000,69.0000,69.0000,NULL,NULL),(126,0,1,0,28.9900,28.9900,28.9900,28.9900,NULL,NULL),(126,1,1,0,28.9900,28.9900,28.9900,28.9900,NULL,NULL),(126,2,1,0,28.9900,28.9900,28.9900,28.9900,NULL,NULL),(126,3,1,0,28.9900,28.9900,28.9900,28.9900,NULL,NULL),(127,0,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(127,1,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(127,2,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(127,3,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(128,0,1,0,18.4700,12.0000,12.0000,12.0000,NULL,NULL),(128,1,1,0,18.4700,12.0000,12.0000,12.0000,NULL,NULL),(128,2,1,0,18.4700,12.0000,12.0000,12.0000,NULL,NULL),(128,3,1,0,18.4700,12.0000,12.0000,12.0000,NULL,NULL),(129,0,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(129,1,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(129,2,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(129,3,1,0,23.1700,23.1700,23.1700,23.1700,NULL,NULL),(130,0,1,0,19.1600,19.1600,19.1600,19.1600,NULL,NULL),(130,1,1,0,19.1600,19.1600,19.1600,19.1600,NULL,NULL),(130,2,1,0,19.1600,19.1600,19.1600,19.1600,NULL,NULL),(130,3,1,0,19.1600,19.1600,19.1600,19.1600,NULL,NULL),(131,0,1,0,18.1000,12.0000,12.0000,12.0000,NULL,NULL),(131,1,1,0,18.1000,12.0000,12.0000,12.0000,NULL,NULL),(131,2,1,0,18.1000,12.0000,12.0000,12.0000,NULL,NULL),(131,3,1,0,18.1000,12.0000,12.0000,12.0000,NULL,NULL),(132,0,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(132,1,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(132,2,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(132,3,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(133,0,1,0,17.9000,12.0000,12.0000,12.0000,NULL,NULL),(133,1,1,0,17.9000,12.0000,12.0000,12.0000,NULL,NULL),(133,2,1,0,17.9000,12.0000,12.0000,12.0000,NULL,NULL),(133,3,1,0,17.9000,12.0000,12.0000,12.0000,NULL,NULL),(134,0,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(134,1,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(134,2,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(134,3,1,0,17.2400,12.0000,12.0000,12.0000,NULL,NULL),(135,0,1,0,6.9900,6.9900,6.9900,6.9900,NULL,NULL),(135,1,1,0,6.9900,6.9900,6.9900,6.9900,NULL,NULL),(135,2,1,0,6.9900,6.9900,6.9900,6.9900,NULL,NULL),(135,3,1,0,6.9900,6.9900,6.9900,6.9900,NULL,NULL),(136,0,1,0,8.9900,8.9900,8.9900,8.9900,NULL,NULL),(136,1,1,0,8.9900,8.9900,8.9900,8.9900,NULL,NULL),(136,2,1,0,8.9900,8.9900,8.9900,8.9900,NULL,NULL),(136,3,1,0,8.9900,8.9900,8.9900,8.9900,NULL,NULL),(137,0,1,0,4.9900,4.9900,4.9900,4.9900,NULL,NULL),(137,1,1,0,4.9900,4.9900,4.9900,4.9900,NULL,NULL),(137,2,1,0,4.9900,4.9900,4.9900,4.9900,NULL,NULL),(137,3,1,0,4.9900,4.9900,4.9900,4.9900,NULL,NULL),(138,0,1,0,4.2500,4.2500,4.2500,4.2500,NULL,NULL),(138,1,1,0,4.2500,4.2500,4.2500,4.2500,NULL,NULL),(138,2,1,0,4.2500,4.2500,4.2500,4.2500,NULL,NULL),(138,3,1,0,4.2500,4.2500,4.2500,4.2500,NULL,NULL),(139,0,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(139,1,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(139,2,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(139,3,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(140,0,1,0,2.4900,2.4900,2.4900,2.4900,NULL,NULL),(140,1,1,0,2.4900,2.4900,2.4900,2.4900,NULL,NULL),(140,2,1,0,2.4900,2.4900,2.4900,2.4900,NULL,NULL),(140,3,1,0,2.4900,2.4900,2.4900,2.4900,NULL,NULL),(141,0,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(141,1,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(141,2,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(141,3,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(142,0,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(142,1,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(142,2,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(142,3,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(143,0,1,0,1.6500,1.6500,1.6500,1.6500,NULL,NULL),(143,1,1,0,1.6500,1.6500,1.6500,1.6500,NULL,NULL),(143,2,1,0,1.6500,1.6500,1.6500,1.6500,NULL,NULL),(143,3,1,0,1.6500,1.6500,1.6500,1.6500,NULL,NULL),(144,0,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(144,1,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(144,2,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(144,3,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(145,0,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(145,1,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(145,2,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(145,3,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(146,0,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(146,1,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(146,2,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(146,3,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(147,0,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(147,1,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(147,2,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(147,3,1,0,1.5900,1.5900,1.5900,1.5900,NULL,NULL),(148,0,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(148,1,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(148,2,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(148,3,1,0,1.3500,1.3500,1.3500,1.3500,NULL,NULL),(149,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(149,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(149,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(149,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(150,0,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(150,1,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(150,2,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(150,3,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(151,0,1,0,6.7500,6.7500,6.7500,6.7500,NULL,NULL),(151,1,1,0,6.7500,6.7500,6.7500,6.7500,NULL,NULL),(151,2,1,0,6.7500,6.7500,6.7500,6.7500,NULL,NULL),(151,3,1,0,6.7500,6.7500,6.7500,6.7500,NULL,NULL),(152,0,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(152,1,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(152,2,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(152,3,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(153,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(153,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(153,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(153,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(154,0,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(154,1,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(154,2,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(154,3,1,0,6.9800,6.9800,6.9800,6.9800,NULL,NULL),(155,0,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(155,1,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(155,2,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(155,3,1,0,2.7700,2.7700,2.7700,2.7700,NULL,NULL),(156,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(156,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(156,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(156,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(157,0,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(157,1,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(157,2,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(157,3,1,0,2.7900,2.7900,2.7900,2.7900,NULL,NULL),(158,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(158,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(158,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(158,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(159,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(159,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(159,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(159,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(160,0,1,0,3.7800,3.7800,3.7800,3.7800,NULL,NULL),(160,1,1,0,3.7800,3.7800,3.7800,3.7800,NULL,NULL),(160,2,1,0,3.7800,3.7800,3.7800,3.7800,NULL,NULL),(160,3,1,0,3.7800,3.7800,3.7800,3.7800,NULL,NULL),(161,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(161,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(161,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(161,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(162,0,1,0,3.9800,3.9800,3.9800,3.9800,NULL,NULL),(162,1,1,0,3.9800,3.9800,3.9800,3.9800,NULL,NULL),(162,2,1,0,3.9800,3.9800,3.9800,3.9800,NULL,NULL),(162,3,1,0,3.9800,3.9800,3.9800,3.9800,NULL,NULL),(163,0,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(163,1,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(163,2,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(163,3,1,0,3.2800,3.2800,3.2800,3.2800,NULL,NULL),(164,0,1,0,6.4800,6.4800,6.4800,6.4800,NULL,NULL),(164,1,1,0,6.4800,6.4800,6.4800,6.4800,NULL,NULL),(164,2,1,0,6.4800,6.4800,6.4800,6.4800,NULL,NULL),(164,3,1,0,6.4800,6.4800,6.4800,6.4800,NULL,NULL),(165,0,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(165,1,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(165,2,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(165,3,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(166,0,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(166,1,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(166,2,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(166,3,1,0,5.2800,5.2800,5.2800,5.2800,NULL,NULL),(173,0,1,0,6.4500,6.4500,6.4500,6.4500,NULL,NULL),(173,1,1,0,6.4500,6.4500,6.4500,6.4500,NULL,NULL),(173,2,1,0,6.4500,6.4500,6.4500,6.4500,NULL,NULL),(173,3,1,0,6.4500,6.4500,6.4500,6.4500,NULL,NULL),(177,0,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(177,1,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(177,2,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(177,3,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(178,0,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(178,1,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(178,2,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(178,3,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(179,0,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(179,1,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(179,2,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(179,3,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(180,0,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(180,1,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(180,2,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(180,3,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(181,0,1,0,22.9500,22.9500,22.9500,22.9500,NULL,NULL),(181,1,1,0,22.9500,22.9500,22.9500,22.9500,NULL,NULL),(181,2,1,0,22.9500,22.9500,22.9500,22.9500,NULL,NULL),(181,3,1,0,22.9500,22.9500,22.9500,22.9500,NULL,NULL),(182,0,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(182,1,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(182,2,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(182,3,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(183,0,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(183,1,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(183,2,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(183,3,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(184,0,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(184,1,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(184,2,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(184,3,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(185,0,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(185,1,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(185,2,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(185,3,1,0,11.9500,11.9500,11.9500,11.9500,NULL,NULL),(186,0,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(186,1,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(186,2,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(186,3,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(187,0,1,0,6.4000,6.4000,6.4000,6.4000,NULL,NULL),(187,1,1,0,6.4000,6.4000,6.4000,6.4000,NULL,NULL),(187,2,1,0,6.4000,6.4000,6.4000,6.4000,NULL,NULL),(187,3,1,0,6.4000,6.4000,6.4000,6.4000,NULL,NULL),(188,0,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(188,1,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(188,2,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(188,3,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(189,0,1,0,12.9500,12.9500,12.9500,12.9500,NULL,NULL),(189,1,1,0,12.9500,12.9500,12.9500,12.9500,NULL,NULL),(189,2,1,0,12.9500,12.9500,12.9500,12.9500,NULL,NULL),(189,3,1,0,12.9500,12.9500,12.9500,12.9500,NULL,NULL),(190,0,1,0,11.5500,11.5500,11.5500,11.5500,NULL,NULL),(190,1,1,0,11.5500,11.5500,11.5500,11.5500,NULL,NULL),(190,2,1,0,11.5500,11.5500,11.5500,11.5500,NULL,NULL),(190,3,1,0,11.5500,11.5500,11.5500,11.5500,NULL,NULL),(191,0,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(191,1,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(191,2,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(191,3,1,0,7.9500,7.9500,7.9500,7.9500,NULL,NULL),(192,0,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(192,1,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(192,2,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(192,3,1,0,6.3500,6.3500,6.3500,6.3500,NULL,NULL),(193,0,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(193,1,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(193,2,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(193,3,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(194,0,1,0,21.9500,21.9500,21.9500,21.9500,NULL,NULL),(194,1,1,0,21.9500,21.9500,21.9500,21.9500,NULL,NULL),(194,2,1,0,21.9500,21.9500,21.9500,21.9500,NULL,NULL),(194,3,1,0,21.9500,21.9500,21.9500,21.9500,NULL,NULL),(195,0,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(195,1,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(195,2,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(195,3,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(196,0,1,0,5.9500,5.9500,5.9500,5.9500,NULL,NULL),(196,1,1,0,5.9500,5.9500,5.9500,5.9500,NULL,NULL),(196,2,1,0,5.9500,5.9500,5.9500,5.9500,NULL,NULL),(196,3,1,0,5.9500,5.9500,5.9500,5.9500,NULL,NULL),(197,0,1,0,25.9500,25.9500,25.9500,25.9500,NULL,NULL),(197,1,1,0,25.9500,25.9500,25.9500,25.9500,NULL,NULL),(197,2,1,0,25.9500,25.9500,25.9500,25.9500,NULL,NULL),(197,3,1,0,25.9500,25.9500,25.9500,25.9500,NULL,NULL),(198,0,1,0,26.9500,26.9500,26.9500,26.9500,NULL,NULL),(198,1,1,0,26.9500,26.9500,26.9500,26.9500,NULL,NULL),(198,2,1,0,26.9500,26.9500,26.9500,26.9500,NULL,NULL),(198,3,1,0,26.9500,26.9500,26.9500,26.9500,NULL,NULL),(199,0,1,0,24.9500,24.9500,24.9500,24.9500,NULL,NULL),(199,1,1,0,24.9500,24.9500,24.9500,24.9500,NULL,NULL),(199,2,1,0,24.9500,24.9500,24.9500,24.9500,NULL,NULL),(199,3,1,0,24.9500,24.9500,24.9500,24.9500,NULL,NULL),(200,0,1,0,10.9500,10.9500,10.9500,10.9500,NULL,NULL),(200,1,1,0,10.9500,10.9500,10.9500,10.9500,NULL,NULL),(200,2,1,0,10.9500,10.9500,10.9500,10.9500,NULL,NULL),(200,3,1,0,10.9500,10.9500,10.9500,10.9500,NULL,NULL),(201,0,1,0,8.4500,8.4500,8.4500,8.4500,NULL,NULL),(201,1,1,0,8.4500,8.4500,8.4500,8.4500,NULL,NULL),(201,2,1,0,8.4500,8.4500,8.4500,8.4500,NULL,NULL),(201,3,1,0,8.4500,8.4500,8.4500,8.4500,NULL,NULL),(202,0,1,0,19.9500,19.9500,19.9500,19.9500,NULL,NULL),(202,1,1,0,19.9500,19.9500,19.9500,19.9500,NULL,NULL),(202,2,1,0,19.9500,19.9500,19.9500,19.9500,NULL,NULL),(202,3,1,0,19.9500,19.9500,19.9500,19.9500,NULL,NULL),(203,0,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(203,1,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(203,2,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(203,3,1,0,9.9500,9.9500,9.9500,9.9500,NULL,NULL),(204,0,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(204,1,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(204,2,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(204,3,1,0,6.2500,6.2500,6.2500,6.2500,NULL,NULL),(205,0,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(205,1,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(205,2,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(205,3,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(206,0,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(206,1,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(206,2,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(206,3,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(207,0,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(207,1,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(207,2,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(207,3,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(208,0,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(208,1,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(208,2,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(208,3,1,0,59.9900,59.9900,59.9900,59.9900,NULL,NULL),(209,0,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(209,1,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(209,2,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(209,3,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(210,0,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(210,1,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(210,2,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(210,3,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(211,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(211,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(211,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(211,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(212,0,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(212,1,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(212,2,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(212,3,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(213,0,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(213,1,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(213,2,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(213,3,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(214,0,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(214,1,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(214,2,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(214,3,1,0,39.9900,39.9900,39.9900,39.9900,NULL,NULL),(215,0,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(215,1,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(215,2,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(215,3,1,0,119.9900,119.9900,119.9900,119.9900,NULL,NULL),(216,0,1,0,88.8900,88.8900,88.8900,88.8900,NULL,NULL),(216,1,1,0,88.8900,88.8900,88.8900,88.8900,NULL,NULL),(216,2,1,0,88.8900,88.8900,88.8900,88.8900,NULL,NULL),(216,3,1,0,88.8900,88.8900,88.8900,88.8900,NULL,NULL),(217,0,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(217,1,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(217,2,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(217,3,1,0,78.9900,78.9900,78.9900,78.9900,NULL,NULL),(218,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(218,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(218,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(218,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(219,0,1,0,155.0000,155.0000,155.0000,155.0000,NULL,NULL),(219,1,1,0,155.0000,155.0000,155.0000,155.0000,NULL,NULL),(219,2,1,0,155.0000,155.0000,155.0000,155.0000,NULL,NULL),(219,3,1,0,155.0000,155.0000,155.0000,155.0000,NULL,NULL),(220,0,1,0,145.9900,145.9900,145.9900,145.9900,NULL,NULL),(220,1,1,0,145.9900,145.9900,145.9900,145.9900,NULL,NULL),(220,2,1,0,145.9900,145.9900,145.9900,145.9900,NULL,NULL),(220,3,1,0,145.9900,145.9900,145.9900,145.9900,NULL,NULL),(221,0,1,0,22.9900,22.9900,22.9900,22.9900,NULL,NULL),(221,1,1,0,22.9900,22.9900,22.9900,22.9900,NULL,NULL),(221,2,1,0,22.9900,22.9900,22.9900,22.9900,NULL,NULL),(221,3,1,0,22.9900,22.9900,22.9900,22.9900,NULL,NULL),(222,0,1,0,45.9900,45.9900,45.9900,45.9900,NULL,NULL),(222,1,1,0,45.9900,45.9900,45.9900,45.9900,NULL,NULL),(222,2,1,0,45.9900,45.9900,45.9900,45.9900,NULL,NULL),(222,3,1,0,45.9900,45.9900,45.9900,45.9900,NULL,NULL),(223,0,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(223,1,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(223,2,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(223,3,1,0,49.9900,49.9900,49.9900,49.9900,NULL,NULL),(224,0,1,0,86.6000,86.6000,86.6000,86.6000,NULL,NULL),(224,1,1,0,86.6000,86.6000,86.6000,86.6000,NULL,NULL),(224,2,1,0,86.6000,86.6000,86.6000,86.6000,NULL,NULL),(224,3,1,0,86.6000,86.6000,86.6000,86.6000,NULL,NULL),(226,0,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(226,1,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(226,2,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(226,3,1,0,104.9900,104.9900,104.9900,104.9900,NULL,NULL),(227,0,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(227,1,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(227,2,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(227,3,1,0,58.7500,58.7500,58.7500,58.7500,NULL,NULL),(231,0,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(231,1,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(231,2,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(231,3,1,0,56.4900,56.4900,56.4900,56.4900,NULL,NULL),(232,0,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(232,1,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(232,2,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(232,3,1,0,58.9800,58.9800,58.9800,58.9800,NULL,NULL),(236,0,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(236,1,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(236,2,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(236,3,1,0,38.4000,38.4000,38.4000,38.4000,NULL,NULL),(238,0,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(238,1,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(238,2,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(238,3,1,0,55.0000,55.0000,55.0000,55.0000,NULL,NULL),(239,0,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(239,1,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(239,2,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(239,3,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(241,0,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(241,1,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(241,2,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(241,3,1,0,88.2000,88.2000,88.2000,88.2000,NULL,NULL),(242,0,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(242,1,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(242,2,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(242,3,1,0,34.9900,28.0000,28.0000,28.0000,NULL,NULL),(243,0,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(243,1,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(243,2,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(243,3,1,0,32.6000,32.6000,32.6000,32.6000,NULL,NULL),(244,0,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(244,1,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(244,2,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(244,3,1,0,22.3500,22.3500,22.3500,22.3500,NULL,NULL),(245,0,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(245,1,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(245,2,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(245,3,1,0,66.9900,66.9900,66.9900,66.9900,NULL,NULL),(246,0,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(246,1,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(246,2,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(246,3,1,0,164.9900,164.9900,164.9900,164.9900,NULL,NULL),(247,0,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(247,1,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(247,2,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(247,3,1,0,34.6500,28.0000,28.0000,28.0000,NULL,NULL),(248,0,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(248,1,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(248,2,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(248,3,1,0,76.4900,76.4900,76.4900,76.4900,NULL,NULL),(249,0,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(249,1,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(249,2,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(249,3,1,0,35.9500,35.9500,35.9500,35.9500,NULL,NULL),(250,0,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(250,1,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(250,2,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(250,3,1,0,83.4800,83.4800,83.4800,83.4800,NULL,NULL),(251,0,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(251,1,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(251,2,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(251,3,1,0,168.0000,168.0000,168.0000,168.0000,NULL,NULL),(252,0,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(252,1,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(252,2,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(252,3,1,0,48.0000,48.0000,48.0000,48.0000,NULL,NULL),(253,0,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(253,1,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(253,2,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(253,3,1,0,35.9900,28.0000,28.0000,28.0000,NULL,NULL),(255,0,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(255,1,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(255,2,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(255,3,1,0,53.9800,53.9800,53.9800,53.9800,NULL,NULL),(258,0,1,0,76.4800,76.4800,76.4800,76.4800,NULL,NULL),(258,1,1,0,76.4800,76.4800,76.4800,76.4800,NULL,NULL),(258,2,1,0,76.4800,76.4800,76.4800,76.4800,NULL,NULL),(258,3,1,0,76.4800,76.4800,76.4800,76.4800,NULL,NULL),(259,0,1,0,93.6900,55.0000,55.0000,55.0000,NULL,NULL),(259,1,1,0,93.6900,55.0000,55.0000,55.0000,NULL,NULL),(259,2,1,0,93.6900,55.0000,55.0000,55.0000,NULL,NULL),(259,3,1,0,93.6900,55.0000,55.0000,55.0000,NULL,NULL),(260,0,1,0,274.9900,274.9900,274.9900,274.9900,NULL,NULL),(260,1,1,0,274.9900,274.9900,274.9900,274.9900,NULL,NULL),(260,2,1,0,274.9900,274.9900,274.9900,274.9900,NULL,NULL),(260,3,1,0,274.9900,274.9900,274.9900,274.9900,NULL,NULL),(261,0,1,0,248.0000,248.0000,248.0000,248.0000,NULL,NULL),(261,1,1,0,248.0000,248.0000,248.0000,248.0000,NULL,NULL),(261,2,1,0,248.0000,248.0000,248.0000,248.0000,NULL,NULL),(261,3,1,0,248.0000,248.0000,248.0000,248.0000,NULL,NULL),(262,0,1,0,96.9900,96.9900,96.9900,96.9900,NULL,NULL),(262,1,1,0,96.9900,96.9900,96.9900,96.9900,NULL,NULL),(262,2,1,0,96.9900,96.9900,96.9900,96.9900,NULL,NULL),(262,3,1,0,96.9900,96.9900,96.9900,96.9900,NULL,NULL),(263,0,1,0,20.2900,20.2900,20.2900,20.2900,NULL,NULL),(263,1,1,0,20.2900,20.2900,20.2900,20.2900,NULL,NULL),(263,2,1,0,20.2900,20.2900,20.2900,20.2900,NULL,NULL),(263,3,1,0,20.2900,20.2900,20.2900,20.2900,NULL,NULL),(264,0,1,0,109.0000,109.0000,109.0000,109.0000,NULL,NULL),(264,1,1,0,109.0000,109.0000,109.0000,109.0000,NULL,NULL),(264,2,1,0,109.0000,109.0000,109.0000,109.0000,NULL,NULL),(264,3,1,0,109.0000,109.0000,109.0000,109.0000,NULL,NULL),(265,0,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(265,1,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(265,2,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(265,3,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(266,0,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(266,1,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(266,2,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(266,3,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(267,0,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(267,1,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(267,2,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(267,3,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(268,0,1,0,229.9900,229.9900,229.9900,229.9900,NULL,NULL),(268,1,1,0,229.9900,229.9900,229.9900,229.9900,NULL,NULL),(268,2,1,0,229.9900,229.9900,229.9900,229.9900,NULL,NULL),(268,3,1,0,229.9900,229.9900,229.9900,229.9900,NULL,NULL),(269,0,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(269,1,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(269,2,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(269,3,1,0,179.9900,179.9900,179.9900,179.9900,NULL,NULL),(270,0,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(270,1,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(270,2,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(270,3,1,0,189.9900,189.9900,189.9900,189.9900,NULL,NULL),(271,0,1,0,39.9700,39.9700,39.9700,39.9700,NULL,NULL),(271,1,1,0,39.9700,39.9700,39.9700,39.9700,NULL,NULL),(271,2,1,0,39.9700,39.9700,39.9700,39.9700,NULL,NULL),(271,3,1,0,39.9700,39.9700,39.9700,39.9700,NULL,NULL),(272,0,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(272,1,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(272,2,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(272,3,1,0,26.9900,26.9900,26.9900,26.9900,NULL,NULL),(273,0,1,0,29.9700,29.9700,29.9700,29.9700,NULL,NULL),(273,1,1,0,29.9700,29.9700,29.9700,29.9700,NULL,NULL),(273,2,1,0,29.9700,29.9700,29.9700,29.9700,NULL,NULL),(273,3,1,0,29.9700,29.9700,29.9700,29.9700,NULL,NULL),(274,0,1,0,50.9900,50.9900,50.9900,50.9900,NULL,NULL),(274,1,1,0,50.9900,50.9900,50.9900,50.9900,NULL,NULL),(274,2,1,0,50.9900,50.9900,50.9900,50.9900,NULL,NULL),(274,3,1,0,50.9900,50.9900,50.9900,50.9900,NULL,NULL),(275,0,1,0,13.4100,13.4100,13.4100,13.4100,NULL,NULL),(275,1,1,0,13.4100,13.4100,13.4100,13.4100,NULL,NULL),(275,2,1,0,13.4100,13.4100,13.4100,13.4100,NULL,NULL),(275,3,1,0,13.4100,13.4100,13.4100,13.4100,NULL,NULL),(276,0,1,0,12.0000,12.0000,12.0000,12.0000,NULL,NULL),(276,1,1,0,12.0000,12.0000,12.0000,12.0000,NULL,NULL),(276,2,1,0,12.0000,12.0000,12.0000,12.0000,NULL,NULL),(276,3,1,0,12.0000,12.0000,12.0000,12.0000,NULL,NULL),(277,0,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(277,1,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(277,2,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(277,3,1,0,19.9900,19.9900,19.9900,19.9900,NULL,NULL),(278,0,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(278,1,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(278,2,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(278,3,1,0,21.9900,21.9900,21.9900,21.9900,NULL,NULL),(279,0,1,0,14.2700,14.2700,14.2700,14.2700,NULL,NULL),(279,1,1,0,14.2700,14.2700,14.2700,14.2700,NULL,NULL),(279,2,1,0,14.2700,14.2700,14.2700,14.2700,NULL,NULL),(279,3,1,0,14.2700,14.2700,14.2700,14.2700,NULL,NULL),(280,0,1,0,18.9900,12.0000,12.0000,12.0000,NULL,NULL),(280,1,1,0,18.9900,12.0000,12.0000,12.0000,NULL,NULL),(280,2,1,0,18.9900,12.0000,12.0000,12.0000,NULL,NULL),(280,3,1,0,18.9900,12.0000,12.0000,12.0000,NULL,NULL),(281,0,1,0,18.2500,12.0000,12.0000,12.0000,NULL,NULL),(281,1,1,0,18.2500,12.0000,12.0000,12.0000,NULL,NULL),(281,2,1,0,18.2500,12.0000,12.0000,12.0000,NULL,NULL),(281,3,1,0,18.2500,12.0000,12.0000,12.0000,NULL,NULL),(282,0,1,0,73.3900,73.3900,73.3900,73.3900,NULL,NULL),(282,1,1,0,73.3900,73.3900,73.3900,73.3900,NULL,NULL),(282,2,1,0,73.3900,73.3900,73.3900,73.3900,NULL,NULL),(282,3,1,0,73.3900,73.3900,73.3900,73.3900,NULL,NULL),(283,0,1,0,54.9900,38.0000,38.0000,38.0000,NULL,NULL),(283,1,1,0,54.9900,38.0000,38.0000,38.0000,NULL,NULL),(283,2,1,0,54.9900,38.0000,38.0000,38.0000,NULL,NULL),(283,3,1,0,54.9900,38.0000,38.0000,38.0000,NULL,NULL),(284,0,1,0,43.0000,43.0000,43.0000,43.0000,NULL,NULL),(284,1,1,0,43.0000,43.0000,43.0000,43.0000,NULL,NULL),(284,2,1,0,43.0000,43.0000,43.0000,43.0000,NULL,NULL),(284,3,1,0,43.0000,43.0000,43.0000,43.0000,NULL,NULL),(285,0,1,0,49.5600,49.5600,49.5600,49.5600,NULL,NULL),(285,1,1,0,49.5600,49.5600,49.5600,49.5600,NULL,NULL),(285,2,1,0,49.5600,49.5600,49.5600,49.5600,NULL,NULL),(285,3,1,0,49.5600,49.5600,49.5600,49.5600,NULL,NULL),(286,0,1,0,34.3500,28.0000,28.0000,28.0000,NULL,NULL),(286,1,1,0,34.3500,28.0000,28.0000,28.0000,NULL,NULL),(286,2,1,0,34.3500,28.0000,28.0000,28.0000,NULL,NULL),(286,3,1,0,34.3500,28.0000,28.0000,28.0000,NULL,NULL),(287,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(287,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(287,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(287,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(288,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(289,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(290,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,0,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,1,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,2,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(291,3,1,0,28.0000,26.0000,26.0000,26.0000,NULL,NULL),(292,0,1,0,73.9900,73.9900,73.9900,73.9900,10.0000,NULL),(292,1,1,0,73.9900,73.9900,73.9900,73.9900,10.0000,NULL),(292,2,1,0,73.9900,73.9900,73.9900,73.9900,10.0000,NULL),(292,3,1,0,73.9900,73.9900,73.9900,73.9900,10.0000,NULL),(293,0,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(293,1,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(293,2,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(293,3,1,0,99.0000,75.0000,75.0000,75.0000,NULL,NULL),(294,0,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(294,1,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(294,2,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(294,3,1,0,3.0000,3.0000,3.0000,3.0000,NULL,NULL),(295,0,1,0,NULL,NULL,35.9500,76.4900,NULL,NULL),(295,1,1,0,NULL,NULL,35.9500,76.4900,NULL,NULL),(295,2,1,0,NULL,NULL,35.9500,76.4900,NULL,NULL),(295,3,1,0,NULL,NULL,35.9500,76.4900,NULL,NULL),(296,0,1,0,0.0000,0.0000,295.9600,447.9800,NULL,NULL),(296,1,1,0,0.0000,0.0000,295.9600,447.9800,NULL,NULL),(296,2,1,0,0.0000,0.0000,295.9600,447.9800,NULL,NULL),(296,3,1,0,0.0000,0.0000,295.9600,447.9800,NULL,NULL),(297,0,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(297,1,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(297,2,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(297,3,1,0,495.9900,495.9900,520.9900,520.9900,NULL,NULL),(298,0,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL),(298,1,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL),(298,2,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL),(298,3,1,0,299.9900,299.9900,299.9900,325.9900,NULL,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_agr_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Aggregate Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_agr_idx`
--

LOCK TABLES `catalog_product_index_price_opt_agr_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_agr_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Aggregate Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_agr_tmp`
--

LOCK TABLES `catalog_product_index_price_opt_agr_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_idx`
--

LOCK TABLES `catalog_product_index_price_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Option Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_tmp` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint(5) unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(12,4) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(12,4) DEFAULT NULL COMMENT 'Tier Price',
  `group_price` decimal(12,4) DEFAULT NULL COMMENT 'Group price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_TMP_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_TMP_WEBSITE_ID` (`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_PRICE_TMP_MIN_PRICE` (`min_price`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Product Price Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_tmp`
--

LOCK TABLES `catalog_product_index_price_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_index_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_tier_price` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(12,4) DEFAULT NULL COMMENT 'Min Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CAT_PRD_IDX_TIER_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_IDX_TIER_PRICE_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Tier Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_tier_price`
--

LOCK TABLES `catalog_product_index_tier_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_tier_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_tier_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_website`
--

DROP TABLE IF EXISTS `catalog_product_index_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_website` (
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `website_date` date DEFAULT NULL COMMENT 'Website Date',
  `rate` float DEFAULT '1' COMMENT 'Rate',
  PRIMARY KEY (`website_id`),
  KEY `IDX_CATALOG_PRODUCT_INDEX_WEBSITE_WEBSITE_DATE` (`website_date`),
  CONSTRAINT `FK_CAT_PRD_IDX_WS_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Website Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_website`
--

LOCK TABLES `catalog_product_index_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_website` DISABLE KEYS */;
INSERT INTO `catalog_product_index_website` VALUES (1,'2014-03-01',1);
/*!40000 ALTER TABLE `catalog_product_index_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link`
--

DROP TABLE IF EXISTS `catalog_product_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `linked_product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Linked Product ID',
  `link_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `UNQ_CAT_PRD_LNK_LNK_TYPE_ID_PRD_ID_LNKED_PRD_ID` (`link_type_id`,`product_id`,`linked_product_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_PRODUCT_ID` (`product_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_LINKED_PRODUCT_ID` (`linked_product_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_LINK_TYPE_ID` (`link_type_id`),
  CONSTRAINT `FK_CAT_PRD_LNK_LNKED_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`linked_product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_LNK_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_LNK_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1650 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Product Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link`
--

LOCK TABLES `catalog_product_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_link` DISABLE KEYS */;
INSERT INTO `catalog_product_link` VALUES (1277,226,227,1),(1278,226,231,1),(1287,227,231,1),(1288,227,232,1),(1297,231,232,1),(1298,231,236,1),(1307,232,236,1),(1308,232,238,1),(1317,236,238,1),(1318,236,239,1),(1327,238,239,1),(1328,238,241,1),(1337,239,241,1),(1338,239,242,1),(1347,241,242,1),(1348,241,243,1),(1357,242,243,1),(1358,242,244,1),(1367,243,244,1),(1368,243,245,1),(1377,244,245,1),(1378,244,246,1),(1387,245,246,1),(1388,245,247,1),(1397,246,247,1),(1398,246,248,1),(1407,247,248,1),(1408,247,249,1),(1417,248,249,1),(1418,248,250,1),(1427,249,250,1),(1428,249,251,1),(1437,250,251,1),(1438,250,252,1),(1447,251,252,1),(1448,251,253,1),(1457,252,253,1),(1468,253,255,1),(1644,293,245,1),(1645,293,246,1),(1646,293,247,1),(1647,294,242,1),(1648,294,243,1),(1649,294,244,1),(1626,294,293,1),(1631,295,292,1),(1618,296,292,1),(1619,296,293,1),(1592,297,298,1),(1579,298,248,1),(1640,295,248,3),(1641,295,249,3),(1577,295,292,3),(1279,226,232,4),(1280,226,236,4),(1281,226,238,4),(1282,226,239,4),(1289,227,236,4),(1290,227,238,4),(1291,227,239,4),(1292,227,241,4),(1299,231,238,4),(1300,231,239,4),(1301,231,241,4),(1302,231,242,4),(1309,232,239,4),(1310,232,241,4),(1311,232,242,4),(1312,232,243,4),(1319,236,241,4),(1320,236,242,4),(1321,236,243,4),(1322,236,244,4),(1329,238,242,4),(1330,238,243,4),(1331,238,244,4),(1332,238,245,4),(1339,239,243,4),(1340,239,244,4),(1341,239,245,4),(1342,239,246,4),(1349,241,244,4),(1350,241,245,4),(1351,241,246,4),(1352,241,247,4),(1359,242,245,4),(1360,242,246,4),(1361,242,247,4),(1362,242,248,4),(1369,243,246,4),(1370,243,247,4),(1371,243,248,4),(1372,243,249,4),(1379,244,247,4),(1380,244,248,4),(1381,244,249,4),(1382,244,250,4),(1389,245,248,4),(1390,245,249,4),(1391,245,250,4),(1392,245,251,4),(1399,246,249,4),(1400,246,250,4),(1401,246,251,4),(1402,246,252,4),(1409,247,250,4),(1410,247,251,4),(1411,247,252,4),(1412,247,253,4),(1419,248,251,4),(1420,248,252,4),(1421,248,253,4),(1429,249,252,4),(1430,249,253,4),(1432,249,255,4),(1439,250,253,4),(1441,250,255,4),(1450,251,255,4),(1459,252,255,4),(1604,292,251,4),(1605,292,252,4),(1606,292,253,4),(1607,292,255,4),(1612,293,295,4),(1613,293,296,4),(1614,293,297,4),(1615,293,298,4),(1628,294,293,4),(1629,294,296,4),(1632,295,294,4),(1633,295,296,4),(1634,295,297,4),(1635,295,298,4),(1620,296,292,4),(1621,296,293,4),(1622,296,298,4),(1593,297,241,4),(1594,297,242,4),(1595,297,243,4),(1596,297,253,4),(1597,297,255,4),(1600,297,298,4),(1584,298,255,4),(1283,226,232,5),(1284,226,236,5),(1285,226,238,5),(1286,226,239,5),(1293,227,236,5),(1294,227,238,5),(1295,227,239,5),(1296,227,241,5),(1303,231,238,5),(1304,231,239,5),(1305,231,241,5),(1306,231,242,5),(1313,232,239,5),(1314,232,241,5),(1315,232,242,5),(1316,232,243,5),(1323,236,241,5),(1324,236,242,5),(1325,236,243,5),(1326,236,244,5),(1333,238,242,5),(1334,238,243,5),(1335,238,244,5),(1336,238,245,5),(1343,239,243,5),(1344,239,244,5),(1345,239,245,5),(1346,239,246,5),(1353,241,244,5),(1354,241,245,5),(1355,241,246,5),(1356,241,247,5),(1363,242,245,5),(1364,242,246,5),(1365,242,247,5),(1366,242,248,5),(1373,243,246,5),(1374,243,247,5),(1375,243,248,5),(1376,243,249,5),(1383,244,247,5),(1384,244,248,5),(1385,244,249,5),(1386,244,250,5),(1393,245,248,5),(1394,245,249,5),(1395,245,250,5),(1396,245,251,5),(1403,246,249,5),(1404,246,250,5),(1405,246,251,5),(1406,246,252,5),(1413,247,250,5),(1414,247,251,5),(1415,247,252,5),(1416,247,253,5),(1423,248,251,5),(1424,248,252,5),(1425,248,253,5),(1433,249,252,5),(1434,249,253,5),(1436,249,255,5),(1443,250,253,5),(1445,250,255,5),(1454,251,255,5),(1463,252,255,5),(1608,292,297,5),(1609,292,298,5),(1616,293,296,5),(1617,293,297,5),(1630,294,296,5),(1636,295,296,5),(1637,295,297,5),(1638,295,298,5),(1623,296,292,5),(1624,296,293,5),(1625,296,298,5),(1601,297,298,5),(1587,298,255,5);
/*!40000 ALTER TABLE `catalog_product_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute` (
  `product_link_attribute_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Link Attribute ID',
  `link_type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  `product_link_attribute_code` varchar(32) NOT NULL DEFAULT '' COMMENT 'Product Link Attribute Code',
  `data_type` varchar(32) NOT NULL DEFAULT '' COMMENT 'Data Type',
  PRIMARY KEY (`product_link_attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_LINK_TYPE_ID` (`link_type_id`),
  CONSTRAINT `FK_CAT_PRD_LNK_ATTR_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute`
--

LOCK TABLES `catalog_product_link_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute` VALUES (1,1,'position','int'),(2,3,'position','int'),(3,3,'qty','decimal'),(4,4,'position','int'),(5,5,'position','int');
/*!40000 ALTER TABLE `catalog_product_link_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_decimal`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute_decimal` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int(10) unsigned NOT NULL COMMENT 'Link ID',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `IDX_CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID` (`product_link_attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_DECIMAL_LINK_ID` (`link_id`),
  CONSTRAINT `FK_AB2EFA9A14F7BCF1D5400056203D14B6` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_LNK_ATTR_DEC_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Decimal Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_decimal`
--

LOCK TABLES `catalog_product_link_attribute_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute_decimal` VALUES (1,3,1577,0.0000),(4,3,1640,0.0000),(5,3,1641,0.0000);
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_int`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute_int` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int(10) unsigned NOT NULL COMMENT 'Link ID',
  `value` int(11) NOT NULL DEFAULT '0' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_LNK_ATTR_INT_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_PRODUCT_LINK_ATTRIBUTE_ID` (`product_link_attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_LINK_ID` (`link_id`),
  CONSTRAINT `FK_CAT_PRD_LNK_ATTR_INT_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_D6D878F8BA2A4282F8DDED7E6E3DE35C` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1689 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Integer Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_int`
--

LOCK TABLES `catalog_product_link_attribute_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute_int` VALUES (1297,1,1277,1),(1298,1,1278,2),(1299,4,1279,1),(1300,4,1280,2),(1301,4,1281,3),(1302,4,1282,4),(1303,5,1283,1),(1304,5,1284,2),(1305,5,1285,3),(1306,5,1286,4),(1307,1,1287,1),(1308,1,1288,2),(1309,4,1289,1),(1310,4,1290,2),(1311,4,1291,3),(1312,4,1292,4),(1313,5,1293,1),(1314,5,1294,2),(1315,5,1295,3),(1316,5,1296,4),(1317,1,1297,1),(1318,1,1298,2),(1319,4,1299,1),(1320,4,1300,2),(1321,4,1301,3),(1322,4,1302,4),(1323,5,1303,1),(1324,5,1304,2),(1325,5,1305,3),(1326,5,1306,4),(1327,1,1307,1),(1328,1,1308,2),(1329,4,1309,1),(1330,4,1310,2),(1331,4,1311,3),(1332,4,1312,4),(1333,5,1313,1),(1334,5,1314,2),(1335,5,1315,3),(1336,5,1316,4),(1337,1,1317,1),(1338,1,1318,2),(1339,4,1319,1),(1340,4,1320,2),(1341,4,1321,3),(1342,4,1322,4),(1343,5,1323,1),(1344,5,1324,2),(1345,5,1325,3),(1346,5,1326,4),(1347,1,1327,1),(1348,1,1328,2),(1349,4,1329,1),(1350,4,1330,2),(1351,4,1331,3),(1352,4,1332,4),(1353,5,1333,1),(1354,5,1334,2),(1355,5,1335,3),(1356,5,1336,4),(1357,1,1337,1),(1358,1,1338,2),(1359,4,1339,1),(1360,4,1340,2),(1361,4,1341,3),(1362,4,1342,4),(1363,5,1343,1),(1364,5,1344,2),(1365,5,1345,3),(1366,5,1346,4),(1367,1,1347,1),(1368,1,1348,2),(1369,4,1349,1),(1370,4,1350,2),(1371,4,1351,3),(1372,4,1352,4),(1373,5,1353,1),(1374,5,1354,2),(1375,5,1355,3),(1376,5,1356,4),(1377,1,1357,1),(1378,1,1358,2),(1379,4,1359,1),(1380,4,1360,2),(1381,4,1361,3),(1382,4,1362,4),(1383,5,1363,1),(1384,5,1364,2),(1385,5,1365,3),(1386,5,1366,4),(1387,1,1367,1),(1388,1,1368,2),(1389,4,1369,1),(1390,4,1370,2),(1391,4,1371,3),(1392,4,1372,4),(1393,5,1373,1),(1394,5,1374,2),(1395,5,1375,3),(1396,5,1376,4),(1397,1,1377,1),(1398,1,1378,2),(1399,4,1379,1),(1400,4,1380,2),(1401,4,1381,3),(1402,4,1382,4),(1403,5,1383,1),(1404,5,1384,2),(1405,5,1385,3),(1406,5,1386,4),(1407,1,1387,1),(1408,1,1388,2),(1409,4,1389,1),(1410,4,1390,2),(1411,4,1391,3),(1412,4,1392,4),(1413,5,1393,1),(1414,5,1394,2),(1415,5,1395,3),(1416,5,1396,4),(1417,1,1397,1),(1418,1,1398,2),(1419,4,1399,1),(1420,4,1400,2),(1421,4,1401,3),(1422,4,1402,4),(1423,5,1403,1),(1424,5,1404,2),(1425,5,1405,3),(1426,5,1406,4),(1427,1,1407,1),(1428,1,1408,2),(1429,4,1409,1),(1430,4,1410,2),(1431,4,1411,3),(1432,4,1412,4),(1433,5,1413,1),(1434,5,1414,2),(1435,5,1415,3),(1436,5,1416,4),(1437,1,1417,1),(1438,1,1418,2),(1439,4,1419,1),(1440,4,1420,2),(1441,4,1421,3),(1443,5,1423,1),(1444,5,1424,2),(1445,5,1425,3),(1447,1,1427,1),(1448,1,1428,2),(1449,4,1429,1),(1450,4,1430,2),(1452,4,1432,4),(1453,5,1433,1),(1454,5,1434,2),(1456,5,1436,4),(1457,1,1437,1),(1458,1,1438,2),(1459,4,1439,1),(1461,4,1441,3),(1463,5,1443,1),(1465,5,1445,3),(1467,1,1447,1),(1468,1,1448,2),(1470,4,1450,2),(1474,5,1454,2),(1477,1,1457,1),(1479,4,1459,1),(1483,5,1463,1),(1488,1,1468,2),(1597,2,1577,1),(1599,1,1579,0),(1604,4,1584,0),(1610,5,1587,0),(1615,1,1592,0),(1616,4,1593,0),(1617,4,1594,0),(1618,4,1595,0),(1619,4,1596,0),(1620,4,1597,0),(1623,4,1600,0),(1624,5,1601,0),(1627,4,1604,0),(1628,4,1605,0),(1629,4,1606,0),(1630,4,1607,0),(1631,5,1608,0),(1632,5,1609,0),(1635,4,1612,0),(1636,4,1613,0),(1637,4,1614,0),(1638,4,1615,0),(1639,5,1616,0),(1640,5,1617,0),(1641,1,1618,0),(1642,1,1619,0),(1643,4,1620,0),(1644,4,1621,0),(1645,4,1622,0),(1646,5,1623,0),(1647,5,1624,0),(1648,5,1625,0),(1649,1,1626,0),(1651,4,1628,0),(1652,4,1629,0),(1653,5,1630,0),(1654,1,1631,0),(1655,4,1632,0),(1656,4,1633,0),(1657,4,1634,0),(1658,4,1635,0),(1659,5,1636,0),(1660,5,1637,0),(1661,5,1638,0),(1663,2,1640,3),(1664,2,1641,2),(1678,1,1644,0),(1679,1,1645,0),(1680,1,1646,0),(1686,1,1647,0),(1687,1,1648,0),(1688,1,1649,0);
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_varchar`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute_varchar` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Link Attribute ID',
  `link_id` int(10) unsigned NOT NULL COMMENT 'Link ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `IDX_CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID` (`product_link_attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_VARCHAR_LINK_ID` (`link_id`),
  CONSTRAINT `FK_CAT_PRD_LNK_ATTR_VCHR_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_DEE9C4DA61CFCC01DFCF50F0D79CEA51` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Varchar Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_varchar`
--

LOCK TABLES `catalog_product_link_attribute_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_varchar` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_type`
--

DROP TABLE IF EXISTS `catalog_product_link_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_type` (
  `link_type_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link Type ID',
  `code` varchar(32) NOT NULL DEFAULT '' COMMENT 'Code',
  PRIMARY KEY (`link_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Link Type Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_type`
--

LOCK TABLES `catalog_product_link_type` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_type` DISABLE KEYS */;
INSERT INTO `catalog_product_link_type` VALUES (1,'relation'),(3,'super'),(4,'up_sell'),(5,'cross_sell');
/*!40000 ALTER TABLE `catalog_product_link_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option`
--

DROP TABLE IF EXISTS `catalog_product_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `type` varchar(50) NOT NULL DEFAULT '' COMMENT 'Type',
  `is_require` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Is Required',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `max_characters` int(10) unsigned DEFAULT NULL COMMENT 'Max Characters',
  `file_extension` varchar(50) DEFAULT NULL COMMENT 'File Extension',
  `image_size_x` smallint(5) unsigned DEFAULT NULL COMMENT 'Image Size X',
  `image_size_y` smallint(5) unsigned DEFAULT NULL COMMENT 'Image Size Y',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CAT_PRD_OPT_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option`
--

LOCK TABLES `catalog_product_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_option` DISABLE KEYS */;
INSERT INTO `catalog_product_option` VALUES (3,1,'radio',1,NULL,NULL,NULL,NULL,NULL,4),(4,1,'drop_down',1,NULL,NULL,NULL,NULL,NULL,3),(5,298,'date_time',0,NULL,NULL,NULL,NULL,NULL,9),(6,298,'time',0,NULL,NULL,NULL,NULL,NULL,8),(7,298,'date',0,NULL,NULL,NULL,NULL,NULL,7),(8,298,'area',0,NULL,0,NULL,NULL,NULL,6),(9,298,'field',0,NULL,0,NULL,NULL,NULL,5),(10,298,'multiple',0,NULL,NULL,NULL,NULL,NULL,4),(11,298,'checkbox',0,NULL,NULL,NULL,NULL,NULL,3),(12,298,'drop_down',1,NULL,NULL,NULL,NULL,NULL,2),(13,298,'radio',1,NULL,NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `catalog_product_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_price`
--

DROP TABLE IF EXISTS `catalog_product_option_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_price` (
  `option_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Price ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_price_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID` (`option_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_PRICE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_OPT_PRICE_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_price`
--

LOCK TABLES `catalog_product_option_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_price` DISABLE KEYS */;
INSERT INTO `catalog_product_option_price` VALUES (1,5,0,0.0000,'fixed'),(2,6,0,0.0000,'fixed'),(3,7,0,0.0000,'fixed'),(4,8,0,0.0000,'fixed'),(5,9,0,0.0000,'fixed');
/*!40000 ALTER TABLE `catalog_product_option_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_title`
--

DROP TABLE IF EXISTS `catalog_product_option_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_title` (
  `option_title_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Title ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Title',
  PRIMARY KEY (`option_title_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID` (`option_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TITLE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_OPT_TTL_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_title`
--

LOCK TABLES `catalog_product_option_title` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_title` DISABLE KEYS */;
INSERT INTO `catalog_product_option_title` VALUES (3,3,0,'Color'),(4,4,0,'Size'),(5,5,0,'Date & Time'),(6,6,0,'Time'),(7,7,0,'Date'),(8,8,0,'Text Area'),(9,9,0,'Text Field'),(10,10,0,'Multiple Select'),(11,11,0,'Chekboxes'),(12,12,0,'Size'),(13,13,0,'Color');
/*!40000 ALTER TABLE `catalog_product_option_title` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_price`
--

DROP TABLE IF EXISTS `catalog_product_option_type_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_type_price` (
  `option_type_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Price ID',
  `option_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_type_price_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID` (`option_type_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_B523E3378E8602F376CC415825576B7F` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_OPT_TYPE_PRICE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Type Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_price`
--

LOCK TABLES `catalog_product_option_type_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_price` DISABLE KEYS */;
INSERT INTO `catalog_product_option_type_price` VALUES (4,4,0,10.0000,'percent'),(5,5,0,15.0000,'percent'),(6,6,0,0.0000,'fixed'),(7,7,0,0.0000,'fixed'),(8,8,0,0.0000,'fixed'),(9,9,0,0.0000,'fixed'),(10,10,0,0.0000,'fixed'),(11,11,0,10.0000,'fixed'),(12,12,0,1.0000,'fixed'),(13,13,0,0.0000,'fixed'),(14,14,0,0.0000,'fixed'),(15,15,0,0.0000,'fixed'),(16,16,0,0.0000,'fixed'),(17,17,0,10.0000,'fixed'),(18,18,0,15.0000,'fixed');
/*!40000 ALTER TABLE `catalog_product_option_type_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_title`
--

DROP TABLE IF EXISTS `catalog_product_option_type_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_type_title` (
  `option_type_title_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Title ID',
  `option_type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Title',
  PRIMARY KEY (`option_type_title_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID` (`option_type_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_C085B9CF2C2A302E8043FDEA1937D6A2` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_OPT_TYPE_TTL_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Type Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_title`
--

LOCK TABLES `catalog_product_option_type_title` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_title` DISABLE KEYS */;
INSERT INTO `catalog_product_option_type_title` VALUES (4,4,0,'Red'),(5,5,0,'Blue'),(6,6,0,'M (USA)'),(7,7,0,'L (USA)'),(8,8,0,'Option 1'),(9,9,0,'Option 2'),(10,10,0,'Option 3'),(11,11,0,'Option 1'),(12,12,0,'Option 2'),(13,13,0,'L'),(14,14,0,'M'),(15,15,0,'XXL'),(16,16,0,'Blue'),(17,17,0,'Pink'),(18,18,0,'Red');
/*!40000 ALTER TABLE `catalog_product_option_type_title` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_value`
--

DROP TABLE IF EXISTS `catalog_product_option_type_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_type_value` (
  `option_type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_type_id`),
  KEY `IDX_CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION_ID` (`option_id`),
  CONSTRAINT `FK_CAT_PRD_OPT_TYPE_VAL_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Option Type Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_value`
--

LOCK TABLES `catalog_product_option_type_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_value` DISABLE KEYS */;
INSERT INTO `catalog_product_option_type_value` VALUES (4,3,NULL,0),(5,3,NULL,0),(6,4,NULL,0),(7,4,NULL,0),(8,10,NULL,0),(9,10,NULL,0),(10,10,NULL,0),(11,11,NULL,0),(12,11,NULL,0),(13,12,NULL,0),(14,12,NULL,0),(15,12,NULL,0),(16,13,NULL,0),(17,13,NULL,0),(18,13,NULL,0);
/*!40000 ALTER TABLE `catalog_product_option_type_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_relation`
--

DROP TABLE IF EXISTS `catalog_product_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_relation` (
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int(10) unsigned NOT NULL COMMENT 'Child ID',
  PRIMARY KEY (`parent_id`,`child_id`),
  KEY `IDX_CATALOG_PRODUCT_RELATION_CHILD_ID` (`child_id`),
  CONSTRAINT `FK_CAT_PRD_RELATION_CHILD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`child_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_RELATION_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_relation`
--

LOCK TABLES `catalog_product_relation` WRITE;
/*!40000 ALTER TABLE `catalog_product_relation` DISABLE KEYS */;
INSERT INTO `catalog_product_relation` VALUES (295,248),(295,249),(294,292),(295,292),(296,292),(296,293);
/*!40000 ALTER TABLE `catalog_product_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_attribute` (
  `product_super_attribute_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Super Attribute ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`product_super_attribute_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID_ATTRIBUTE_ID` (`product_id`,`attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CAT_PRD_SPR_ATTR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute`
--

LOCK TABLES `catalog_product_super_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute` DISABLE KEYS */;
INSERT INTO `catalog_product_super_attribute` VALUES (1,294,85,0);
/*!40000 ALTER TABLE `catalog_product_super_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute_label`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_attribute_label` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_super_attribute_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Super Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `use_default` smallint(5) unsigned DEFAULT '0' COMMENT 'Use Default Value',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID_STORE_ID` (`product_super_attribute_id`,`store_id`),
  KEY `IDX_CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID` (`product_super_attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID` (`store_id`),
  CONSTRAINT `FK_309442281DF7784210ED82B2CC51E5D5` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_SPR_ATTR_LBL_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Attribute Label Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute_label`
--

LOCK TABLES `catalog_product_super_attribute_label` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` DISABLE KEYS */;
INSERT INTO `catalog_product_super_attribute_label` VALUES (1,1,0,0,'Color');
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute_pricing`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_pricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_attribute_pricing` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_super_attribute_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Super Attribute ID',
  `value_index` varchar(255) NOT NULL DEFAULT '' COMMENT 'Value Index',
  `is_percent` smallint(5) unsigned DEFAULT '0' COMMENT 'Is Percent',
  `pricing_value` decimal(12,4) DEFAULT NULL COMMENT 'Pricing Value',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CAT_PRD_SPR_ATTR_PRICING_PRD_SPR_ATTR_ID_VAL_IDX_WS_ID` (`product_super_attribute_id`,`value_index`,`website_id`),
  KEY `IDX_CAT_PRD_SPR_ATTR_PRICING_PRD_SPR_ATTR_ID` (`product_super_attribute_id`),
  KEY `IDX_CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRICING_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CAT_PRD_SPR_ATTR_PRICING_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CDE8813117106CFAA3AD209358F66332` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Attribute Pricing Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute_pricing`
--

LOCK TABLES `catalog_product_super_attribute_pricing` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute_pricing` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_attribute_pricing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_link`
--

DROP TABLE IF EXISTS `catalog_product_super_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_link` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID_PARENT_ID` (`product_id`,`parent_id`),
  KEY `IDX_CATALOG_PRODUCT_SUPER_LINK_PARENT_ID` (`parent_id`),
  KEY `IDX_CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CAT_PRD_SPR_LNK_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_SPR_LNK_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Super Link Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_link`
--

LOCK TABLES `catalog_product_super_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_link` DISABLE KEYS */;
INSERT INTO `catalog_product_super_link` VALUES (1,292,294);
/*!40000 ALTER TABLE `catalog_product_super_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_website`
--

DROP TABLE IF EXISTS `catalog_product_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_website` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`product_id`,`website_id`),
  KEY `IDX_CATALOG_PRODUCT_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CAT_PRD_WS_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Website Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_website`
--

LOCK TABLES `catalog_product_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_website` DISABLE KEYS */;
INSERT INTO `catalog_product_website` VALUES (1,1),(226,1),(227,1),(231,1),(232,1),(236,1),(238,1),(239,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(255,1),(287,1),(288,1),(289,1),(290,1),(291,1),(292,1),(293,1),(294,1),(295,1),(296,1),(297,1),(298,1);
/*!40000 ALTER TABLE `catalog_product_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock`
--

DROP TABLE IF EXISTS `cataloginventory_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock` (
  `stock_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Stock Id',
  `stock_name` varchar(255) DEFAULT NULL COMMENT 'Stock Name',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock`
--

LOCK TABLES `cataloginventory_stock` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock` VALUES (1,'Default');
/*!40000 ALTER TABLE `cataloginventory_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_item`
--

DROP TABLE IF EXISTS `cataloginventory_stock_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_item` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `stock_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `min_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Min Qty',
  `use_config_min_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Qty',
  `is_qty_decimal` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Qty Decimal',
  `backorders` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Backorders',
  `use_config_backorders` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Backorders',
  `min_sale_qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'Min Sale Qty',
  `use_config_min_sale_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Sale Qty',
  `max_sale_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Max Sale Qty',
  `use_config_max_sale_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Max Sale Qty',
  `is_in_stock` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is In Stock',
  `low_stock_date` timestamp NULL DEFAULT NULL COMMENT 'Low Stock Date',
  `notify_stock_qty` decimal(12,4) DEFAULT NULL COMMENT 'Notify Stock Qty',
  `use_config_notify_stock_qty` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Notify Stock Qty',
  `manage_stock` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Manage Stock',
  `use_config_manage_stock` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Manage Stock',
  `stock_status_changed_auto` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Stock Status Changed Automatically',
  `use_config_qty_increments` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Qty Increments',
  `qty_increments` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Increments',
  `use_config_enable_qty_inc` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Enable Qty Increments',
  `enable_qty_increments` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Enable Qty Increments',
  `is_decimal_divided` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Divided into Multiple Boxes for Shipping',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `UNQ_CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID_STOCK_ID` (`product_id`,`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID` (`product_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_ITEM_STOCK_ID` (`stock_id`),
  CONSTRAINT `FK_CATINV_STOCK_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATINV_STOCK_ITEM_STOCK_ID_CATINV_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `cataloginventory_stock` (`stock_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=299 DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_item`
--

LOCK TABLES `cataloginventory_stock_item` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_item` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_item` VALUES (1,1,1,110.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(226,226,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(227,227,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(231,231,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(232,232,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(236,236,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(238,238,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(239,239,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(241,241,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(242,242,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(243,243,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(244,244,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(245,245,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(246,246,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(247,247,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(248,248,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(249,249,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(250,250,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(251,251,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(252,252,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,1,1,0,1,0.0000,1,0,0),(253,253,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(255,255,1,99999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,0,0,1,0.0000,1,0,0),(287,287,1,999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(288,288,1,999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(289,289,1,999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(290,290,1,998.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(291,291,1,999.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(292,292,1,984.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0,0),(293,293,1,995.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0,0),(294,294,1,0.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(295,295,1,0.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(296,296,1,0.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,NULL,1,0,1,0,1,0.0000,1,0,0),(297,297,1,986.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0,0),(298,298,1,1105.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0,0);
/*!40000 ALTER TABLE `cataloginventory_stock_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_status` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint(5) unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_STATUS_STOCK_ID` (`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CATINV_STOCK_STS_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATINV_STOCK_STS_STOCK_ID_CATINV_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `cataloginventory_stock` (`stock_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATINV_STOCK_STS_WS_ID_CORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status`
--

LOCK TABLES `cataloginventory_stock_status` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status` VALUES (1,1,1,110.0000,1),(226,1,1,99999.0000,1),(227,1,1,99999.0000,1),(231,1,1,99999.0000,1),(232,1,1,99999.0000,1),(236,1,1,99999.0000,1),(238,1,1,99999.0000,1),(239,1,1,99999.0000,1),(241,1,1,99999.0000,1),(242,1,1,99999.0000,1),(243,1,1,99999.0000,1),(244,1,1,99999.0000,1),(245,1,1,99999.0000,1),(246,1,1,99999.0000,1),(247,1,1,99999.0000,1),(248,1,1,99999.0000,1),(249,1,1,99999.0000,1),(250,1,1,99999.0000,1),(251,1,1,99999.0000,1),(252,1,1,99999.0000,1),(253,1,1,99999.0000,1),(255,1,1,99999.0000,1),(287,1,1,999.0000,1),(288,1,1,999.0000,1),(289,1,1,999.0000,1),(290,1,1,998.0000,1),(291,1,1,999.0000,1),(292,1,1,984.0000,1),(293,1,1,995.0000,1),(294,1,1,0.0000,1),(295,1,1,0.0000,1),(296,1,1,0.0000,1),(297,1,1,986.0000,1),(298,1,1,1105.0000,1);
/*!40000 ALTER TABLE `cataloginventory_stock_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_idx`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_status_idx` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint(5) unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_STATUS_IDX_STOCK_ID` (`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_STATUS_IDX_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Status Indexer Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_idx`
--

LOCK TABLES `cataloginventory_stock_status_idx` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status_idx` VALUES (1,1,1,110.0000,1),(2,1,1,99999.0000,1),(8,1,1,99999.0000,1),(10,1,1,99999.0000,1),(11,1,1,99999.0000,1),(12,1,1,99999.0000,1),(13,1,1,99999.0000,1),(14,1,1,99999.0000,1),(15,1,1,99999.0000,1),(16,1,1,99999.0000,1),(17,1,1,99999.0000,1),(18,1,1,99999.0000,1),(19,1,1,99999.0000,1),(20,1,1,99999.0000,1),(21,1,1,99999.0000,1),(22,1,1,99999.0000,1),(23,1,1,99999.0000,1),(24,1,1,99999.0000,1),(25,1,1,99999.0000,1),(26,1,1,99999.0000,1),(27,1,1,99999.0000,1),(28,1,1,99999.0000,1),(29,1,1,99999.0000,1),(30,1,1,99999.0000,1),(32,1,1,99999.0000,1),(33,1,1,99999.0000,1),(34,1,1,99999.0000,1),(37,1,1,99999.0000,1),(38,1,1,99999.0000,1),(39,1,1,99999.0000,1),(40,1,1,99999.0000,1),(41,1,1,99999.0000,1),(42,1,1,99999.0000,1),(43,1,1,99999.0000,1),(45,1,1,99999.0000,1),(46,1,1,99999.0000,1),(47,1,1,99999.0000,1),(48,1,1,25.0000,1),(49,1,1,7.0000,1),(50,1,1,199.0000,1),(51,1,1,100.0000,1),(52,1,1,350.0000,1),(53,1,1,87.0000,1),(54,1,1,100.0000,1),(55,1,1,1.0000,1),(56,1,1,2.0000,1),(57,1,1,99999.0000,1),(58,1,1,99999.0000,1),(59,1,1,99999.0000,1),(60,1,1,99999.0000,1),(61,1,1,99999.0000,1),(62,1,1,99999.0000,1),(63,1,1,99999.0000,1),(64,1,1,99999.0000,1),(65,1,1,99999.0000,1),(66,1,1,99999.0000,1),(67,1,1,99999.0000,1),(68,1,1,99999.0000,1),(69,1,1,99999.0000,1),(70,1,1,99999.0000,1),(71,1,1,99999.0000,1),(72,1,1,99999.0000,1),(73,1,1,99999.0000,1),(74,1,1,99999.0000,1),(75,1,1,99999.0000,1),(76,1,1,99999.0000,1),(77,1,1,99999.0000,1),(78,1,1,99999.0000,1),(79,1,1,99999.0000,1),(80,1,1,99999.0000,1),(81,1,1,99999.0000,1),(82,1,1,99999.0000,1),(83,1,1,99999.0000,1),(84,1,1,99999.0000,1),(85,1,1,99999.0000,1),(86,1,1,99999.0000,1),(87,1,1,99999.0000,1),(88,1,1,99999.0000,1),(89,1,1,99999.0000,1),(90,1,1,99999.0000,1),(91,1,1,99999.0000,1),(92,1,1,99999.0000,1),(93,1,1,99999.0000,1),(94,1,1,99999.0000,1),(95,1,1,99999.0000,1),(96,1,1,99999.0000,1),(97,1,1,99999.0000,1),(98,1,1,99999.0000,1),(99,1,1,99999.0000,1),(100,1,1,99999.0000,1),(101,1,1,99999.0000,1),(102,1,1,99999.0000,1),(103,1,1,99999.0000,1),(104,1,1,99999.0000,1),(105,1,1,99999.0000,1),(106,1,1,99999.0000,1),(108,1,1,99999.0000,1),(109,1,1,99999.0000,1),(110,1,1,99999.0000,1),(111,1,1,99999.0000,1),(112,1,1,99999.0000,1),(113,1,1,99999.0000,1),(114,1,1,99999.0000,1),(115,1,1,99999.0000,1),(116,1,1,99999.0000,1),(117,1,1,99999.0000,1),(120,1,1,99999.0000,1),(121,1,1,99999.0000,1),(122,1,1,99999.0000,1),(123,1,1,99999.0000,1),(124,1,1,99999.0000,1),(125,1,1,99999.0000,1),(126,1,1,99999.0000,1),(127,1,1,99999.0000,1),(128,1,1,99999.0000,1),(129,1,1,99999.0000,1),(130,1,1,99999.0000,1),(131,1,1,99999.0000,1),(132,1,1,99999.0000,1),(133,1,1,99999.0000,1),(134,1,1,99999.0000,1),(135,1,1,99999.0000,1),(136,1,1,99999.0000,1),(137,1,1,99999.0000,1),(138,1,1,99999.0000,1),(139,1,1,99999.0000,1),(140,1,1,99999.0000,1),(141,1,1,99999.0000,1),(142,1,1,99999.0000,1),(143,1,1,99999.0000,1),(144,1,1,99999.0000,1),(145,1,1,99999.0000,1),(146,1,1,99999.0000,1),(147,1,1,99999.0000,1),(148,1,1,99999.0000,1),(149,1,1,99999.0000,1),(150,1,1,99999.0000,1),(151,1,1,99999.0000,1),(152,1,1,99999.0000,1),(153,1,1,99999.0000,1),(154,1,1,99999.0000,1),(155,1,1,99999.0000,1),(156,1,1,99999.0000,1),(157,1,1,99999.0000,1),(158,1,1,99999.0000,1),(159,1,1,99999.0000,1),(160,1,1,99999.0000,1),(161,1,1,99999.0000,1),(162,1,1,99999.0000,1),(163,1,1,99999.0000,1),(164,1,1,99999.0000,1),(165,1,1,99999.0000,1),(166,1,1,99999.0000,1),(173,1,1,99999.0000,1),(177,1,1,99999.0000,1),(178,1,1,99999.0000,1),(179,1,1,99999.0000,1),(180,1,1,99999.0000,1),(181,1,1,99999.0000,1),(182,1,1,99999.0000,1),(183,1,1,99999.0000,1),(184,1,1,99999.0000,1),(185,1,1,99999.0000,1),(186,1,1,99999.0000,1),(187,1,1,99999.0000,1),(188,1,1,99999.0000,1),(189,1,1,99999.0000,1),(190,1,1,99999.0000,1),(191,1,1,99999.0000,1),(192,1,1,99999.0000,1),(193,1,1,99999.0000,1),(194,1,1,99999.0000,1),(195,1,1,99999.0000,1),(196,1,1,99999.0000,1),(197,1,1,99999.0000,1),(198,1,1,99999.0000,1),(199,1,1,99999.0000,1),(200,1,1,99999.0000,1),(201,1,1,99999.0000,1),(202,1,1,99999.0000,1),(203,1,1,99999.0000,1),(204,1,1,99999.0000,1),(205,1,1,99999.0000,1),(206,1,1,99999.0000,1),(207,1,1,99999.0000,1),(208,1,1,99999.0000,1),(209,1,1,99999.0000,1),(210,1,1,99999.0000,1),(211,1,1,99999.0000,1),(212,1,1,99999.0000,1),(213,1,1,99999.0000,1),(214,1,1,99999.0000,1),(215,1,1,99999.0000,1),(216,1,1,99999.0000,1),(217,1,1,99999.0000,1),(218,1,1,99999.0000,1),(219,1,1,99999.0000,1),(220,1,1,99999.0000,1),(221,1,1,99999.0000,1),(222,1,1,99999.0000,1),(223,1,1,99999.0000,1),(224,1,1,99999.0000,1),(226,1,1,99999.0000,1),(227,1,1,99999.0000,1),(231,1,1,99999.0000,1),(232,1,1,99999.0000,1),(236,1,1,99999.0000,1),(238,1,1,99999.0000,1),(239,1,1,99999.0000,1),(241,1,1,99999.0000,1),(242,1,1,99999.0000,1),(243,1,1,99999.0000,1),(244,1,1,99999.0000,1),(245,1,1,99999.0000,1),(246,1,1,99999.0000,1),(247,1,1,99999.0000,1),(248,1,1,99999.0000,1),(249,1,1,99999.0000,1),(250,1,1,99999.0000,1),(251,1,1,99999.0000,1),(252,1,1,99999.0000,1),(253,1,1,99999.0000,1),(255,1,1,99999.0000,1),(258,1,1,99999.0000,1),(259,1,1,99999.0000,1),(260,1,1,99999.0000,1),(261,1,1,99999.0000,1),(262,1,1,99999.0000,1),(263,1,1,99999.0000,1),(264,1,1,99999.0000,1),(265,1,1,99999.0000,1),(266,1,1,99999.0000,1),(267,1,1,99999.0000,1),(268,1,1,99999.0000,1),(269,1,1,99999.0000,1),(270,1,1,99999.0000,1),(271,1,1,99999.0000,1),(272,1,1,99999.0000,1),(273,1,1,99999.0000,1),(274,1,1,99999.0000,1),(275,1,1,99999.0000,1),(276,1,1,99999.0000,1),(277,1,1,99999.0000,1),(278,1,1,99999.0000,1),(279,1,1,99999.0000,1),(280,1,1,99999.0000,1),(281,1,1,99999.0000,1),(282,1,1,99999.0000,1),(283,1,1,9999.0000,1),(284,1,1,99999.0000,1),(285,1,1,99999.0000,1),(286,1,1,99999.0000,1),(287,1,1,999.0000,1),(288,1,1,999.0000,1),(289,1,1,999.0000,1),(290,1,1,999.0000,1),(291,1,1,999.0000,1),(292,1,1,990.0000,1),(293,1,1,998.0000,1),(294,1,1,0.0000,1),(295,1,1,0.0000,1),(296,1,1,0.0000,1),(297,1,1,988.0000,1),(298,1,1,1105.0000,1);
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_tmp`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_status_tmp` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint(5) unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_STATUS_TMP_STOCK_ID` (`stock_id`),
  KEY `IDX_CATALOGINVENTORY_STOCK_STATUS_TMP_WEBSITE_ID` (`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Cataloginventory Stock Status Indexer Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_tmp`
--

LOCK TABLES `cataloginventory_stock_status_tmp` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `cataloginventory_stock_status_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule`
--

DROP TABLE IF EXISTS `catalogrule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `from_date` date DEFAULT NULL COMMENT 'From Date',
  `to_date` date DEFAULT NULL COMMENT 'To Date',
  `is_active` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `conditions_serialized` mediumtext COMMENT 'Conditions Serialized',
  `actions_serialized` mediumtext COMMENT 'Actions Serialized',
  `stop_rules_processing` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Stop Rules Processing',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `sub_is_enable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Rule Enable For Subitems',
  `sub_simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action For Subitems',
  `sub_discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount For Subitems',
  PRIMARY KEY (`rule_id`),
  KEY `IDX_CATALOGRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE` (`is_active`,`sort_order`,`to_date`,`from_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule`
--

LOCK TABLES `catalogrule` WRITE;
/*!40000 ALTER TABLE `catalogrule` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_affected_product`
--

DROP TABLE IF EXISTS `catalogrule_affected_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_affected_product` (
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Affected Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_affected_product`
--

LOCK TABLES `catalogrule_affected_product` WRITE;
/*!40000 ALTER TABLE `catalogrule_affected_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_affected_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_customer_group`
--

DROP TABLE IF EXISTS `catalogrule_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_customer_group` (
  `rule_id` int(10) unsigned NOT NULL COMMENT 'Rule Id',
  `customer_group_id` smallint(5) unsigned NOT NULL COMMENT 'Customer Group Id',
  PRIMARY KEY (`rule_id`,`customer_group_id`),
  KEY `IDX_CATALOGRULE_CUSTOMER_GROUP_RULE_ID` (`rule_id`),
  KEY `IDX_CATALOGRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `FK_CATALOGRULE_CUSTOMER_GROUP_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATRULE_CSTR_GROUP_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Rules To Customer Groups Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_customer_group`
--

LOCK TABLES `catalogrule_customer_group` WRITE;
/*!40000 ALTER TABLE `catalogrule_customer_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_customer_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_group_website`
--

DROP TABLE IF EXISTS `catalogrule_group_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_group_website` (
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Rule Id',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group Id',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Website Id',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CATALOGRULE_GROUP_WEBSITE_RULE_ID` (`rule_id`),
  KEY `IDX_CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CATALOGRULE_GROUP_WEBSITE_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATRULE_GROUP_WS_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Group Website';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_group_website`
--

LOCK TABLES `catalogrule_group_website` WRITE;
/*!40000 ALTER TABLE `catalogrule_group_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_group_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product`
--

DROP TABLE IF EXISTS `catalogrule_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_product` (
  `rule_product_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product Id',
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Rule Id',
  `from_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'From Time',
  `to_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'To time',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `action_operator` varchar(10) DEFAULT 'to_fixed' COMMENT 'Action Operator',
  `action_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Action Amount',
  `action_stop` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Action Stop',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `sub_simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action For Subitems',
  `sub_discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount For Subitems',
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `EAA51B56FF092A0DCB795D1CEF812B7B` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `IDX_CATALOGRULE_PRODUCT_RULE_ID` (`rule_id`),
  KEY `IDX_CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOGRULE_PRODUCT_WEBSITE_ID` (`website_id`),
  KEY `IDX_CATALOGRULE_PRODUCT_FROM_TIME` (`from_time`),
  KEY `IDX_CATALOGRULE_PRODUCT_TO_TIME` (`to_time`),
  KEY `IDX_CATALOGRULE_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CATALOGRULE_PRODUCT_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_PRODUCT_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATRULE_PRD_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATRULE_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product`
--

LOCK TABLES `catalogrule_product` WRITE;
/*!40000 ALTER TABLE `catalogrule_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product_price`
--

DROP TABLE IF EXISTS `catalogrule_product_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_product_price` (
  `rule_product_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product PriceId',
  `rule_date` date NOT NULL COMMENT 'Rule Date',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `rule_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Rule Price',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `latest_start_date` date DEFAULT NULL COMMENT 'Latest StartDate',
  `earliest_end_date` date DEFAULT NULL COMMENT 'Earliest EndDate',
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `UNQ_CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `IDX_CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `IDX_CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `IDX_CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATRULE_PRD_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATRULE_PRD_PRICE_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CatalogRule Product Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product_price`
--

LOCK TABLES `catalogrule_product_price` WRITE;
/*!40000 ALTER TABLE `catalogrule_product_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_website`
--

DROP TABLE IF EXISTS `catalogrule_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_website` (
  `rule_id` int(10) unsigned NOT NULL COMMENT 'Rule Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  PRIMARY KEY (`rule_id`,`website_id`),
  KEY `IDX_CATALOGRULE_WEBSITE_RULE_ID` (`rule_id`),
  KEY `IDX_CATALOGRULE_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_CATALOGRULE_WEBSITE_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Rules To Websites Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_website`
--

LOCK TABLES `catalogrule_website` WRITE;
/*!40000 ALTER TABLE `catalogrule_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogsearch_fulltext` (
  `fulltext_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `data_index` longtext COMMENT 'Data index',
  PRIMARY KEY (`fulltext_id`),
  UNIQUE KEY `UNQ_CATALOGSEARCH_FULLTEXT_PRODUCT_ID_STORE_ID` (`product_id`,`store_id`),
  FULLTEXT KEY `FTI_CATALOGSEARCH_FULLTEXT_DATA_INDEX` (`data_index`)
) ENGINE=MyISAM AUTO_INCREMENT=20919 DEFAULT CHARSET=utf8 COMMENT='Catalog search result table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_fulltext`
--

LOCK TABLES `catalogsearch_fulltext` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext` VALUES (20744,298,3,'product_with_options_example|Enabled|None|Gray|P\'kolino Toddler Bed & Chair [with Options]|P\'kolino Toddler Bed & Chair now part of the New Café con Leche Collection! Premium, café wood finish with milky white highlights gives these playful P\'kolino favorites a double shot of modern sophistication. This playfully functional bed smartly folds into a cozy chair to extend the use; change it back again for sleepovers. Made from the same quality wood to match the P\'kolino line, this durable bed is a great addition to any home. Perfectly sized for little ones, it fits any standard sized criAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|Product with Options Example|299.99|1'),(11505,255,2,'B004A154P6|None|Enabled|P\'kolino Zebra Rocking Chair|The P\'kolino Safari Collection Zebra Rocking Chair show how colorful, animal silhouettes make for a playful yet sophisticated design. Ideal for little ones ages 3 to 6 years. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.|Amazon Product Detail Page|53.98|1'),(20742,296,3,'bundle_product_example|Enabled|Enabled|Enabled|Furniture Kit [Bundled]|P\'kolino Giraffe Rocking Chair [Simple]|Furniture Assembly Service [Virtual]|This product type is also known as a “kit” in other eCommerce software. This product type is ideal for circumstances where the user have to select a number of configurable options, but at least one option.|The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Tested for stability. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|Virtual Products are those that do not have a physical or digital counterpart.They do not ship, nor do they have a download link. This product type might be used for services like:House Cleaning1-Year Newsletter SubscriptionNote: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.|Bundle Product Example|Simple Product Example|Virtual Product Example|0|73.99|99|None|None|White|Option 1|Option 2|Option 3|Option 4|1'),(11503,253,2,'B002EDG14U|None|Enabled|P\'kolino Little One\'s Chair|An Extra Chair for Extra Fun! Need additional space at the table? P\'kolino is happy to offer extra chairs for your Little One\'s Table and Chair set. Great alone or accessorize your Little One\'s Table and Chairs set with another chair or two! Clean, modern lines, bold color accents and playful \"popsicle-stick\" feet make this chair a perfect addition to any growing home. Designed for children age 2 to 6. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer that m|Amazon Product Detail Page|35.99|1'),(20207,289,1,'B0040WRM5K|None|Enabled|Metallic Slingshot Monokini (As Shown;One Size)|Feel like you are in a tropical island!|Halter top slingshot monokini.|28|1'),(11502,252,2,'B00545CDQ0|None|Enabled|Safari Collection Tree Table w/Animal Chairs|Safari Collection Tree Table w/ Zebra and Giraffe Chairs is part of the new P\'kolino Safari Collection and shows how colorful animal silhouettes make for a playful yet sophisticated design. This collection is ideal for children 3-6 years old. Suitable for playrooms and bedrooms. Create a play space where creativity can run wild! Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. Two chairs are included with the product, but you can always the Duck and Ostrich|Amazon Product Detail Page|0|0'),(11499,249,2,'B004VT7XVA|None|Enabled|P\'kolino Book Buggee - Crown|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 years|Amazon Product Detail Page|35.95|1'),(11500,250,2,'B004A154PQ|None|Enabled|P\'kolino Safari Duck and Ostrich Chairs|The P\'kolino Safari Collection Duck and Ostrich Chair Set show how colorful, animal silhouettes make for a playful yet sophisticated design. A great addition to any playroom or bedroom and are the perfect companions to the Tree Table with Giraffe and Zebra Chairs(sold separately)! The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Create a play space where creati|Amazon Product Detail Page|83.48|1'),(11501,251,2,'B000WYJ33E|None|Enabled|P\'Kolino Klick Children\'s Desk, Orange|P\'kolino KlickThis playfully smart desk and chair set is a \"perfect fit\"! The P\'kolino Klick is the perfect desk for children ages 3-7. With an ample working space for paper, books, and puzzles, it is ideal for project based learning or the budding artist in your little one. The padded seat is an optimal 12 inches high with enough storage under the seat for the most prolific Picasso. For additional storage, add a Play Kit.|Amazon Product Detail Page|168|1'),(11495,245,2,'B001RIY7CQ|None|Enabled|P\'kolino Children Desk, White|P\'kolino Children\'s DeskA Stylistically-Compact, Playful Work Space! Specially designed for little ones with big ideas, the P\'kolino Children\'s Desk is a child favorite. With it\'s ample working space for paper, books, and puzzles, it is ideal for project based learning or the budding artist.This all-in-one design with ergonomically positioned built-in seat means little ones do not need to struggle with finding or positioning their chair. The seat is an optimal 12 inches high with a smart storage|Amazon Product Detail Page|66.99|1'),(11496,246,2,'B004A154PG|None|Enabled|P\'kolino Tree Trable with Zebra and Giraffe Chairs|Description: A balance of playfulness and sophisticated design! The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Create a play space where creativity can run wild! Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. Two chairs are included with the product, but you can always add more. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA Specifications: Materials: Fiber Board with Wood Veneer **Tip: Age: 3 to 6 years old Dimensions: Chair: 23 in. (58.4 cm) H x 11 in (28 cm) W x 11 in (28 cm) L.Seat Height: 11 in (28 cm). Table: 20.5 in. (52 cm) H x 28 in. (71.2 cm) W x 28 in. (71.2 cm) L.Weight: 40 lbs (19 kg)|Amazon Product Detail Page|164.99|1'),(11497,247,2,'B004VT7Y7I|None|Enabled|P\'kolino Book Buggee - Fire Truck|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 years|Amazon Product Detail Page|34.65|1'),(11498,248,2,'B004VT7X8I|None|Enabled|P\'kolino New Little Reader Chair - Flower Pink|This NEW Little Reader Chair - Flowers has all the loved features of the Original Little Reader! Plush stain resistant faux-suede, premium quality high density foam, stable wide-base, feathery light weight, tote handle and pockets for books (and all sorts of stuff). But the New Little Reader has even more to love with playful embroidered themes, wider contoured seat and ergonomic arms for added comfort. This feathery light chair, with its two pockets for \"stuff\" and a handle to take it all where|Amazon Product Detail Page|76.49|1'),(11494,244,2,'B0039UTUWM|None|Enabled|P\'kolino Nesting Birds|These silly birds nest inside each other teaching the fundamentals of size and shape while engaging reasoning skills(larger birds do not fit in smaller birds), which improve problem-solving abilities. Strengthen fine motor skills by separating the birds and putting them back together. These functional features combined with the beautiful colors and natural wood creates a truly one-of-a-kind, playfully smart nesting toy!|Amazon Product Detail Page|22.35|1'),(11491,241,2,'B002AQIA6S|None|Enabled|P\'Kolino Little Sofa -Sleeper, Green|P\'kolino Little Reader SofaComfy foam, supple fabric, book pockets and easy to fold out sleeper, creates the perfect combination for a little quiet-time. A wide base and strong angular lines makes this sofa attractive and supremely sturdy. This durable sofa is made with the highest quality materials, constructed with premium high density foam and upholstered in cozy, stain resistant fabrics. The Little Reader Sofa Sleeper is also the perfect companion to the Little Reader chair.|Amazon Product Detail Page|88.2|1'),(11492,242,2,'B004835N8E|None|Enabled|P\'kolino Silly Soft Seating Lila|This fun loving combination of stuffed toy and modular toddler seating has many features designed to support your toddler\'s developmental needs, making these engaging and multi-talented silly seats a playfully smart addition to any growing home.This modular Silly Soft Seating is compromised of three soft, sturdy, lightweight pieces that can be configured in a myriad of ways; from seats of varying height to tiny tables. These many variations and the capacity for children to do the configuring, ar|Amazon Product Detail Page|34.99|1'),(11493,243,2,'B001HX4IXE|None|Enabled|P\'kolino Book Buggee in Orange|Make books a part of everyday play! The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books. In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"|Amazon Product Detail Page|32.6|1'),(20743,297,3,'downloadable_product_example|Enabled|None|Home Designer Pro 2014 [Download]|Downloadable products are similar to virtual products, except that they include the ability to add one or more digital files for download. Amazon Product Details Page|Downloadable Product Example|495.99|Photos - Full version|Sample|1'),(20481,1,3,'test_product|Enabled|Shipping|Test product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Definition list dt Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. Consectetur adipisicing elit Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.|Lorem ipsum dolor sit amet|156|1'),(11489,238,2,'B001TZLAZE|None|Enabled|Tot Tutors Kids\' Table and 4-Chair Set, Plastic|The vibrant and striking colors of this plastic table and 4 chair set will liven up your child’s bedroom, playroom or back patio. Ideal for lunch for four, art projects or story time. Your children will love sharing their special space with all their friends.|Amazon Product Detail Page|55|1'),(11490,239,2,'B000IHJF60|None|Enabled|Tot Tutors Book Rack, Primary Colors|The sturdy wood bookrack with colorful nylon fabric pockets hold books cover forward for easy recognition by young children encouraging them to “read” and return their books for a neat and organized room.|Amazon Product Detail Page|26.99|1'),(20902,295,1,'grouped_product_example|Enabled|Enabled|Enabled|Enabled|Grouped Products|Product|Best product for the home with very loooooooooooong title|Simple Product|Grouped products allow you to create a new product using one or more existing products in your store|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Grouped Products Example|Flower Pink|Crown|Simple Product Example|None|None|None|76.49|35.95|373.99|White|1'),(20873,292,1,'simple_product_example|Enabled|None|White|Simple Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Simple Product Example|373.99|1'),(20913,294,1,'configurable_example|Enabled|Enabled|None|None|Configurable Product|Simple Product|Configurable Product : This product enables your customers to select the variant that they want by choosing options. For example, you can sell T-shirts in two colors and three sizes. You would create six simple products as individual products (each with its own SKUs) and then add these six to a configurable product where customers can choose the size and color, and then add it to their cart. Very similar functionality is possible by using Custom Options for Simple products. The difference between a configurable product and a product including custom options is that inventory is not checked or updated for individual options during the purchase of the custom options.|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Configurable Product Example|Simple Product Example|3|373.99|White|1'),(11487,232,2,'B002RL8386|None|Enabled|4Gr8 Kidz Racing Series Toddler Bed with Safe Sleep Rails||Amazon Product Detail Page|58.98|1'),(11488,236,2,'B003ZV4CVE|None|Enabled|Nickelodeon\'s Dora the Explorer Multi-Bin Toy Organizer|TB84504DO_999 This charming and functional Nickelodeon Dora the Explorer Toy Organizer makes tidying up fun. Each tier of the organizer serves its own function. The toy box is perfect for storing larger items while the storage bins are great for storing small accessories. It features an adorable Nickelodeon Dora the Explorer inspired design theme that complements other Nickelodeon Dora the Explorer items (sold separately online). Features: -Dora the explorer multi-bin toy organizer. -10th Anniversary design for Dora the Explorer. -Bins feature your child\'s favorite Nickelodeon Dora the Explorer characters. -Bottom tier is a toy box for convenient storage. -5 fabric storage bins. -In compliance with all ASTM safety standards and requirements. -High quality licensed item. -Perfect for storing larger items while the storage bins are great for storing small accessories. -Assembly required. About Dora the Explorer Airing in 2000 as one of the first cross-cultural animated children s programs, Dora the Explorer became a phenomenal hit, entertaining children and introducing young Americans to Hispanic culture. Formally aired on the CBS television network, and now a prominent series on Nickelodeon and sister channel, Noggin, the extremely successful franchise has created a recognizable household name. In the series, Dora is an adventurous, bilingual, Latina heroine who lives inside a computer. Determined, positive, helpful and caring, Dora is always ready for adventure. Children learn by watching Dora journey through her world, gathering objects and clues to ultimately help a person in need or perform a good deed with her faithful Backpack, Map and her best friend Boots. Not only is Dora the Explorer entertaining, but the interactive aspects allow children to develop problem solving skills, reasoning, and communication skills when the curious little explorer asks her audience at home questions to help her along her way. In 2005, Dora s equally curious cousin, Diego, claime|Amazon Product Detail Page|38.4|1'),(11486,231,2,'B003JNEKAG|None|Enabled|NICKELODEON SPONGE BOB TODDLER BED|A special 10th anniversary design makes this SpongeBob Squarepants toddler bed a must-have for your little SpongeBob fan. Kids will love the decals featuring favorite SpongeBob Squarepants characters. The bed is built low to the ground for easy child access and comes with side rails for safe and secure sleeping. A decal of SpongeBob Squarepants appears on the headboard and footboard. The bed also uses a standard crib mattress, sold separately. Nickelodeon - SpongeBob Squarepants Toddler Bed, 10th Anniversary Edition: Bright cheerful colors SpongeBob Squarepants toddler bed has a sturdy steel frame Low height and safety sleep rails (removable) make the bed safe SpongeBob Squarepants toddler bed is recommended for ages 18 months to 5 years Weight limit: up to 50 lbs. JPMA approved SpongeBob Squarepants toddler bed uses a standard crib mattress, sold separately|Amazon Product Detail Page|56.49|1'),(11484,226,2,'B0017YJ130|None|Enabled|Gund All Stars Sports Glove Chair|Gund All Stars Glove ChairYour little baseball fan will love lounging in this \'sports fans only\' chair. Cushiony and comfortable this All Stars Sports Glove Chair shaped as a baseball glove is sure to hit a \'grand slam\' with children of all ages. Crafted of light brown suede and black trim this authentic looking baseball glove holds your young one in it\'s palm and the fingers serve as the back.|Amazon Product Detail Page|104.99|1'),(20876,296,1,'bundle_product_example|Enabled|Enabled|Enabled|Bundled Products|Simple Product|Virtual Product|This product type is also known as a “kit” in other eCommerce software. This product type is ideal for circumstances where the user have to select a number of configurable options, but at least one option.|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Virtual Products are those that do not have a physical or digital counterpart.They do not ship, nor do they have a download link. This product type might be used for services like:House Cleaning1-Year Newsletter SubscriptionNote: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.|Bundle Products Example|Simple Product Example|Virtual Product Example|0|373.99|99|None|None|White|Option 1|Option 2|Option 3|Option 4|1'),(11485,227,2,'B001GSKCAI|None|Enabled|Disney Princess Pretty Pink Toddler Bed|There\'s something about a Delta-conceived, Delta-designed, Delta-made children\'s product that so many parents, from all ends of the earth, just seem to naturally gravitate to. That is becuase Delta Children\'s Products are experts in creating groundbreaking products that meet the growing needs of children. From infancy all the way through young teen hood. Every smart, safe, high-quality Delta product is designed to deliver timeless beauty, myriad uses, and outstanding value for years to come. The Disney Princess Toddler Bed in pretty pink is perfect for transitioning your little princess from crib to big girl bed. Features a high quality plastic and metal frame making it lightweight yet sturdy for strength and durability that will last. The bed is built low to the ground for easy child access and comes with side rails for safe and secure sleeping. A whimsical princess design theme featuring your child\'s favorite Princess characters on the headboard and footboard make it a must have. The bed uses a standard crib mattress (sold separately). Recommended for use up to 50 lbs. Meets all JPMA safety requirements. Some assembly required. Features: Disney Princess Pretty Pink Toddler Bed High quality plastic and metal frame Lightweight yet sturdy Sits low to the ground for easy entry and exit 2 side rails Uses a standard crib mattress (sold separately) Recommended for use up to 50 lbs Meets all JPMA safety requirements Some assembly required Specifications: Dimensions: 29\' H x 31\' W x 54\' D Weight: 21 lbs|Amazon Product Detail Page|58.75|1'),(20205,287,1,'B006XFJXF4|None|Enabled|Hot! Bikini white, yellow or black|Feel like you are in a tropical island!|Cup A, B & C for a hot décolleté! Bandeau Style! Halter neck tie fastening! Available in size 2 - 12! Colour yellow, white or black (83% Polyamid, 17% Elasthan)|28|1'),(20206,288,1,'B003VSOKQI|None|Enabled|Designer Monokini Halter String Ties Womens Sexy Bikini|Feel like you are in a tropical island!|Feel like you are in a tropical island when you wear this monokini style printed bikini. Be ready to look hot when you wear this exotic two piece to all your fun times in the sun. The fabric of this bikini is super soft on your skin and has great luxurious quality. The top features a deep V neckline with halter and back ties. The cups feature removable soft padding for a comfortable fit and superior coverage. The cut out sides and low waist bottom with circle side rings, makes this a must have sexy swimsuit. The back reveals an open sexy bareback with a moderate coverage bikini bottom. This tropical style will make you the exotic princess everywhere you go!|28|1'),(20209,291,1,'B005FGF38S|None|Enabled|Daisy Corsets Sequin Underwire Corset|Feel like you are in a tropical island!|Strapless sequin corset with underwire cups, side zipper closure, lace-up back and matching thong. Ruffle panty not included.|28|1'),(20914,294,5,'configurable_example|Enabled|Enabled|None|None|Configurable Product|Simple Product|Configurable Product : This product enables your customers to select the variant that they want by choosing options. For example, you can sell T-shirts in two colors and three sizes. You would create six simple products as individual products (each with its own SKUs) and then add these six to a configurable product where customers can choose the size and color, and then add it to their cart. Very similar functionality is possible by using Custom Options for Simple products. The difference between a configurable product and a product including custom options is that inventory is not checked or updated for individual options during the purchase of the custom options.|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Configurable Product Example|Simple Product Example|3|373.99|White|1'),(20915,290,1,'B005PPMSOG|None|Hot! Bikini Leopard|Bandeau Style! Halter neck tie fastening! Fully lined! Available in size 2 - 8 (XXS - M)! Colour: Multicolour (80% Polyamid, 20% Elasthan)|Feel like you are in a tropical island!|28|1'),(20741,295,3,'grouped_product_example|Enabled|Enabled|Enabled|Enabled|P\'colino Collection [Grouped]|P\'kolino New Little Reader Chair|P\'kolino Book Buggee|P\'kolino Giraffe Rocking Chair [Simple]|Grouped products allow you to create a new product using one or more existing products in your store|This NEW Little Reader Chair - Flowers has all the loved features of the Original Little Reader! Plush stain resistant faux-suede, premium quality high density foam, stable wide-base, feathery light weight, tote handle and pockets for books (and all sorts of stuff). But the New Little Reader has even more to love with playful embroidered themes, wider contoured seat and ergonomic arms for added comfort. This feathery light chair, with its two pockets for \"stuff\" and a handle to take it all whereAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 yearsAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Tested for stability. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|Grouped Product Example|Flower Pink|Crown|Simple Product Example|None|None|None|76.49|35.95|73.99|White|1'),(20739,293,3,'virtual_product_example|Enabled|None|Furniture Assembly Service [Virtual]|Virtual Products are those that do not have a physical or digital counterpart.They do not ship, nor do they have a download link. This product type might be used for services like:House Cleaning1-Year Newsletter SubscriptionNote: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.|Virtual Product Example|99|1'),(20740,294,3,'configurable_example|Enabled|Enabled|None|None|Chair [Configurable]|P\'kolino Giraffe Rocking Chair [Simple]|Configurable Product : This product enables your customers to select the variant that they want by choosing options. For example, you can sell T-shirts in two colors and three sizes. You would create six simple products as individual products (each with its own SKUs) and then add these six to a configurable product where customers can choose the size and color, and then add it to their cart. Very similar functionality is possible by using Custom Options for Simple products. The difference between a configurable product and a product including custom options is that inventory is not checked or updated for individual options during the purchase of the custom options. Amazon Product Detail Page|The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Tested for stability. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|Configurable Product Example|Simple Product Example|3|73.99|White|1'),(20735,289,3,'B0040WRM5K|None|Enabled|Metallic Slingshot Monokini (As Shown;One Size)|Feel like you are in a tropical island!|Halter top slingshot monokini.|28|1'),(20736,290,3,'B005PPMSOG|None|Enabled|Hot! Bikini Leopard|Feel like you are in a tropical island!|Bandeau Style! Halter neck tie fastening! Fully lined! Available in size 2 - 8 (XXS - M)! Colour: Multicolour (80% Polyamid, 20% Elasthan)|28|1'),(20737,291,3,'B005FGF38S|None|Enabled|Daisy Corsets Sequin Underwire Corset|Feel like you are in a tropical island!|Strapless sequin corset with underwire cups, side zipper closure, lace-up back and matching thong. Ruffle panty not included.|28|1'),(20738,292,3,'simple_product_example|Enabled|None|White|P\'kolino Giraffe Rocking Chair [Simple]|The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Tested for stability. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|Simple Product Example|73.99|1'),(20733,287,3,'B006XFJXF4|None|Enabled|Hot! Bikini white, yellow or black|Feel like you are in a tropical island!|Cup A, B & C for a hot décolleté! Bandeau Style! Halter neck tie fastening! Available in size 2 - 12! Colour yellow, white or black (83% Polyamid, 17% Elasthan)|28|1'),(20734,288,3,'B003VSOKQI|None|Enabled|Designer Monokini Halter String Ties Womens Sexy Bikini|Feel like you are in a tropical island!|Feel like you are in a tropical island when you wear this monokini style printed bikini. Be ready to look hot when you wear this exotic two piece to all your fun times in the sun. The fabric of this bikini is super soft on your skin and has great luxurious quality. The top features a deep V neckline with halter and back ties. The cups feature removable soft padding for a comfortable fit and superior coverage. The cut out sides and low waist bottom with circle side rings, makes this a must have sexy swimsuit. The back reveals an open sexy bareback with a moderate coverage bikini bottom. This tropical style will make you the exotic princess everywhere you go!|28|1'),(20795,255,1,'B004A154P6|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Safari Collection|53.98|1'),(20797,253,1,'B002EDG14U|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Extra Fun|35.99|1'),(20799,252,1,'B00545CDQ0|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Collection|48|1'),(20803,250,1,'B004A154PQ|Enabled|None|Prodict|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Safari Collection|83.48|1'),(20801,251,1,'B000WYJ33E|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Orange|168|1'),(20809,248,1,'B004VT7X8I|None|Enabled|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Flower Pink|76.49|1'),(20811,248,5,'B004VT7X8I|None|Enabled|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Flower Pink|76.49|1'),(20868,298,5,'product_with_options_example|Gray|Enabled|None|Product with Options|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Product with Options Example|299.99|1'),(20877,292,5,'simple_product_example|Enabled|None|White|Simple Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Simple Product Example|373.99|1'),(20869,293,1,'virtual_product_example|Enabled|None|Virtual Product|Virtual Products are those that do not have a physical or digital counterpart.They do not ship, nor do they have a download link. This product type might be used for services like:House Cleaning1-Year Newsletter SubscriptionNote: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.|Virtual Product Example|99|1'),(20871,293,5,'virtual_product_example|Enabled|None|Virtual Product|Virtual Products are those that do not have a physical or digital counterpart.They do not ship, nor do they have a download link. This product type might be used for services like:House Cleaning1-Year Newsletter SubscriptionNote: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.|Virtual Product Example|99|1'),(20469,287,5,'B006XFJXF4|None|Enabled|Hot! Bikini white, yellow or black|Feel like you are in a tropical island!|Cup A, B & C for a hot décolleté! Bandeau Style! Halter neck tie fastening! Available in size 2 - 12! Colour yellow, white or black (83% Polyamid, 17% Elasthan)|28|1'),(20470,288,5,'B003VSOKQI|None|Enabled|Designer Monokini Halter String Ties Womens Sexy Bikini|Feel like you are in a tropical island!|Feel like you are in a tropical island when you wear this monokini style printed bikini. Be ready to look hot when you wear this exotic two piece to all your fun times in the sun. The fabric of this bikini is super soft on your skin and has great luxurious quality. The top features a deep V neckline with halter and back ties. The cups feature removable soft padding for a comfortable fit and superior coverage. The cut out sides and low waist bottom with circle side rings, makes this a must have sexy swimsuit. The back reveals an open sexy bareback with a moderate coverage bikini bottom. This tropical style will make you the exotic princess everywhere you go!|28|1'),(20903,249,5,'B004VT7XVA|None|Enabled|Best product for the home with very loooooooooooong title|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Crown|35.95|1'),(20813,247,1,'B004VT7Y7I|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Collection|34.65|1'),(20703,255,3,'B004A154P6|None|Enabled|P\'kolino Zebra Rocking Chair|Safari Collection|The P\'kolino Safari Collection Zebra Rocking Chair show how colorful, animal silhouettes make for a playful yet sophisticated design. Ideal for little ones ages 3 to 6 years. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|53.98|1'),(20815,246,1,'B004A154PG|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Zebra Collection|164.99|1'),(20819,244,1,'B0039UTUWM|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|White Collection|22.35|1'),(20817,245,1,'B001RIY7CQ|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|White|66.99|1'),(20823,242,1,'B004835N8E|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Collection|34.99|1'),(20821,243,1,'B001HX4IXE|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Orange Collection|32.6|1'),(20700,251,3,'B000WYJ33E|None|Enabled|P\'Kolino Klick Children\'s Desk|Orange|P\'kolino KlickThis playfully smart desk and chair set is a \"perfect fit\"! The P\'kolino Klick is the perfect desk for children ages 3-7. With an ample working space for paper, books, and puzzles, it is ideal for project based learning or the budding artist in your little one. The padded seat is an optimal 12 inches high with enough storage under the seat for the most prolific Picasso. For additional storage, add a Play Kit.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|168|1'),(20702,253,3,'B002EDG14U|None|Enabled|P\'kolino Little One\'s Chair|Extra Fun|An Extra Chair for Extra Fun! Need additional space at the table? P\'kolino is happy to offer extra chairs for your Little One\'s Table and Chair set. Great alone or accessorize your Little One\'s Table and Chairs set with another chair or two! Clean, modern lines, bold color accents and playful \"popsicle-stick\" feet make this chair a perfect addition to any growing home. Designed for children age 2 to 6. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer that mAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|35.99|1'),(20701,252,3,'B00545CDQ0|None|Enabled|Safari Collection Tree Table w/Animal Chairs|Amazon Product Detail Page|Safari Collection Tree Table w/ Zebra and Giraffe Chairs is part of the new P\'kolino Safari Collection and shows how colorful animal silhouettes make for a playful yet sophisticated design. This collection is ideal for children 3-6 years old. Suitable for playrooms and bedrooms. Create a play space where creativity can run wild! Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. Two chairs are included with the product, but you can always the Duck and Ostrich|48|1'),(20825,239,1,'B000IHJF60|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Best Collection|26.99|1'),(20827,241,1,'B002AQIA6S|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Best Collection|88.2|1'),(20829,238,1,'B001TZLAZE|Enabled|None|Prduct|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Soft collection|55|1'),(20833,232,1,'B002RL8386|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Black|58.98|1'),(20831,236,1,'B003ZV4CVE|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|White|38.4|1'),(20837,227,1,'B001GSKCAI|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Orange|58.75|1'),(20835,231,1,'B003JNEKAG|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Gray Collection|56.49|1'),(20699,250,3,'B004A154PQ|None|Enabled|P\'kolino Duck and Ostrich Chairs|Safari Collection|The P\'kolino Safari Collection Duck and Ostrich Chair Set show how colorful, animal silhouettes make for a playful yet sophisticated design. A great addition to any playroom or bedroom and are the perfect companions to the Tree Table with Giraffe and Zebra Chairs(sold separately)! The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Create a play space where creatiAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|83.48|1'),(20841,226,1,'B0017YJ130|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|All Stars Collection|104.99|1'),(20842,226,5,'B0017YJ130|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|All Stars Collection|104.99|1'),(20697,248,3,'B004VT7X8I|None|Enabled|P\'kolino New Little Reader Chair|Flower Pink|This NEW Little Reader Chair - Flowers has all the loved features of the Original Little Reader! Plush stain resistant faux-suede, premium quality high density foam, stable wide-base, feathery light weight, tote handle and pockets for books (and all sorts of stuff). But the New Little Reader has even more to love with playful embroidered themes, wider contoured seat and ergonomic arms for added comfort. This feathery light chair, with its two pockets for \"stuff\" and a handle to take it all whereAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|76.49|1'),(20698,249,3,'B004VT7XVA|None|Enabled|P\'kolino Book Buggee|Crown|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 yearsAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|35.95|1'),(20696,247,3,'B004VT7Y7I|None|Enabled|P\'kolino Book Buggee|Fire Truck|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 yearsAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|34.65|1'),(20694,245,3,'B001RIY7CQ|None|Enabled|P\'kolino Children Desk|White|P\'kolino Children\'s DeskA Stylistically-Compact, Playful Work Space! Specially designed for little ones with big ideas, the P\'kolino Children\'s Desk is a child favorite. With it\'s ample working space for paper, books, and puzzles, it is ideal for project based learning or the budding artist.This all-in-one design with ergonomically positioned built-in seat means little ones do not need to struggle with finding or positioning their chair. The seat is an optimal 12 inches high with a smart storageAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|66.99|1'),(20695,246,3,'B004A154PG|None|Enabled|P\'kolino Tree Trable|with Zebra and Giraffe Chairs|Description: A balance of playfulness and sophisticated design! The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Create a play space where creativity can run wild! Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. Two chairs are included with the product, but you can always add more. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA Specifications: Materials: Fiber Board with Wood Veneer **Tip: Age: 3 to 6 years old Dimensions: Chair: 23 in. (58.4 cm) H x 11 in (28 cm) W x 11 in (28 cm) L.Seat Height: 11 in (28 cm). Table: 20.5 in. (52 cm) H x 28 in. (71.2 cm) W x 28 in. (71.2 cm) L.Weight: 40 lbs (19 kg)Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|164.99|1'),(20692,243,3,'B001HX4IXE|None|Enabled|P\'kolino Book Buggee|Orange|Make books a part of everyday play! The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books. In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|32.6|1'),(20693,244,3,'B0039UTUWM|None|Enabled|P\'kolino Nesting Birds|Natural wood|These silly birds nest inside each other teaching the fundamentals of size and shape while engaging reasoning skills (larger birds do not fit in smaller birds), which improve problem-solving abilities. Strengthen fine motor skills by separating the birds and putting them back together. These functional features combined with the beautiful colors and natural wood creates a truly one-of-a-kind, playfully smart nesting toy!Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|22.35|1'),(20691,242,3,'B004835N8E|None|Enabled|P\'kolino Silly Soft Seating|Lila|This fun loving combination of stuffed toy and modular toddler seating has many features designed to support your toddler\'s developmental needs, making these engaging and multi-talented silly seats a playfully smart addition to any growing home.This modular Silly Soft Seating is compromised of three soft, sturdy, lightweight pieces that can be configured in a myriad of ways; from seats of varying height to tiny tables. These many variations and the capacity for children to do the configuring, arAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|34.99|1'),(20688,238,3,'B001TZLAZE|None|Enabled|Tot Tutors Kids\' Table and 4-Chair Set, Plastic|Amazon Product Detail Page|The vibrant and striking colors of this plastic table and 4 chair set will liven up your child’s bedroom, playroom or back patio. Ideal for lunch for four, art projects or story time. Your children will love sharing their special space with all their friends.|55|1'),(20689,239,3,'B000IHJF60|None|Enabled|Tot Tutors Book Rack, Primary Colors|Amazon Product Detail Page|The sturdy wood bookrack with colorful nylon fabric pockets hold books cover forward for easy recognition by young children encouraging them to “read” and return their books for a neat and organized room.|26.99|1'),(20690,241,3,'B002AQIA6S|None|Enabled|P\'Kolino Little Sofa|Sleeper, Green|P\'kolino Little Reader SofaComfy foam, supple fabric, book pockets and easy to fold out sleeper, creates the perfect combination for a little quiet-time. A wide base and strong angular lines makes this sofa attractive and supremely sturdy. This durable sofa is made with the highest quality materials, constructed with premium high density foam and upholstered in cozy, stain resistant fabrics. The Little Reader Sofa Sleeper is also the perfect companion to the Little Reader chair.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|88.2|1'),(20686,232,3,'B002RL8386|None|Enabled|4Gr8 Kidz Racing Series Toddler Bed with Safe Sleep Rails|Amazon Product Detail Page||58.98|1'),(20687,236,3,'B003ZV4CVE|None|Enabled|Nickelodeon\'s Dora the Explorer Multi-Bin Toy Organizer|Amazon Product Detail Page|TB84504DO_999 This charming and functional Nickelodeon Dora the Explorer Toy Organizer makes tidying up fun. Each tier of the organizer serves its own function. The toy box is perfect for storing larger items while the storage bins are great for storing small accessories. It features an adorable Nickelodeon Dora the Explorer inspired design theme that complements other Nickelodeon Dora the Explorer items (sold separately online). Features: -Dora the explorer multi-bin toy organizer. -10th Anniversary design for Dora the Explorer. -Bins feature your child\'s favorite Nickelodeon Dora the Explorer characters. -Bottom tier is a toy box for convenient storage. -5 fabric storage bins. -In compliance with all ASTM safety standards and requirements. -High quality licensed item. -Perfect for storing larger items while the storage bins are great for storing small accessories. -Assembly required. About Dora the Explorer Airing in 2000 as one of the first cross-cultural animated children s programs, Dora the Explorer became a phenomenal hit, entertaining children and introducing young Americans to Hispanic culture. Formally aired on the CBS television network, and now a prominent series on Nickelodeon and sister channel, Noggin, the extremely successful franchise has created a recognizable household name. In the series, Dora is an adventurous, bilingual, Latina heroine who lives inside a computer. Determined, positive, helpful and caring, Dora is always ready for adventure. Children learn by watching Dora journey through her world, gathering objects and clues to ultimately help a person in need or perform a good deed with her faithful Backpack, Map and her best friend Boots. Not only is Dora the Explorer entertaining, but the interactive aspects allow children to develop problem solving skills, reasoning, and communication skills when the curious little explorer asks her audience at home questions to help her along her way. In 2005, Dora s equally curious cousin, Diego, claime|38.4|1'),(20685,231,3,'B003JNEKAG|None|Enabled|NICKELODEON SPONGE BOB TODDLER BED|Amazon Product Detail Page|A special 10th anniversary design makes this SpongeBob Squarepants toddler bed a must-have for your little SpongeBob fan. Kids will love the decals featuring favorite SpongeBob Squarepants characters. The bed is built low to the ground for easy child access and comes with side rails for safe and secure sleeping. A decal of SpongeBob Squarepants appears on the headboard and footboard. The bed also uses a standard crib mattress, sold separately. Nickelodeon - SpongeBob Squarepants Toddler Bed, 10th Anniversary Edition: Bright cheerful colors SpongeBob Squarepants toddler bed has a sturdy steel frame Low height and safety sleep rails (removable) make the bed safe SpongeBob Squarepants toddler bed is recommended for ages 18 months to 5 years Weight limit: up to 50 lbs. JPMA approved SpongeBob Squarepants toddler bed uses a standard crib mattress, sold separately|56.49|1'),(20683,226,3,'B0017YJ130|None|Enabled|Gund All Stars Sports Glove Chair|Amazon Product Detail Page|Gund All Stars Glove ChairYour little baseball fan will love lounging in this \'sports fans only\' chair. Cushiony and comfortable this All Stars Sports Glove Chair shaped as a baseball glove is sure to hit a \'grand slam\' with children of all ages. Crafted of light brown suede and black trim this authentic looking baseball glove holds your young one in it\'s palm and the fingers serve as the back.|104.99|1'),(20684,227,3,'B001GSKCAI|None|Enabled|Disney Princess Pretty Pink Toddler Bed|Amazon Product Detail Page|There\'s something about a Delta-conceived, Delta-designed, Delta-made children\'s product that so many parents, from all ends of the earth, just seem to naturally gravitate to. That is becuase Delta Children\'s Products are experts in creating groundbreaking products that meet the growing needs of children. From infancy all the way through young teen hood. Every smart, safe, high-quality Delta product is designed to deliver timeless beauty, myriad uses, and outstanding value for years to come. The Disney Princess Toddler Bed in pretty pink is perfect for transitioning your little princess from crib to big girl bed. Features a high quality plastic and metal frame making it lightweight yet sturdy for strength and durability that will last. The bed is built low to the ground for easy child access and comes with side rails for safe and secure sleeping. A whimsical princess design theme featuring your child\'s favorite Princess characters on the headboard and footboard make it a must have. The bed uses a standard crib mattress (sold separately). Recommended for use up to 50 lbs. Meets all JPMA safety requirements. Some assembly required. Features: Disney Princess Pretty Pink Toddler Bed High quality plastic and metal frame Lightweight yet sturdy Sits low to the ground for easy entry and exit 2 side rails Uses a standard crib mattress (sold separately) Recommended for use up to 50 lbs Meets all JPMA safety requirements Some assembly required Specifications: Dimensions: 29\' H x 31\' W x 54\' D Weight: 21 lbs|58.75|1'),(11282,1,2,'test_product|Enabled|Shipping|Test product|Description goes here|We\'ve combined the peaceful and informative|156|1'),(14558,255,4,'B004A154P6|None|Enabled|P\'kolino Zebra Rocking Chair|Safari Collection|The P\'kolino Safari Collection Zebra Rocking Chair show how colorful, animal silhouettes make for a playful yet sophisticated design. Ideal for little ones ages 3 to 6 years. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|53.98|1'),(20911,297,1,'downloadable_product_example|Enabled|None|Downloadable Product|Downloadable products are similar to virtual products, except that they include the ability to add one or more digital files for download.|Downloadable Product Example|495.99|Photos - Full version|Sample|1'),(14556,253,4,'B002EDG14U|None|Enabled|P\'kolino Little One\'s Chair|Extra Fun|An Extra Chair for Extra Fun! Need additional space at the table? P\'kolino is happy to offer extra chairs for your Little One\'s Table and Chair set. Great alone or accessorize your Little One\'s Table and Chairs set with another chair or two! Clean, modern lines, bold color accents and playful \"popsicle-stick\" feet make this chair a perfect addition to any growing home. Designed for children age 2 to 6. Made of the same quality wood to match the P\'kolino line and coated with a wood veneer that mAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|35.99|1'),(14555,252,4,'B00545CDQ0|None|Enabled|Safari Collection Tree Table w/Animal Chairs|Amazon Product Detail Page|Safari Collection Tree Table w/ Zebra and Giraffe Chairs is part of the new P\'kolino Safari Collection and shows how colorful animal silhouettes make for a playful yet sophisticated design. This collection is ideal for children 3-6 years old. Suitable for playrooms and bedrooms. Create a play space where creativity can run wild! Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. Two chairs are included with the product, but you can always the Duck and Ostrich|48|1'),(14554,251,4,'B000WYJ33E|None|Enabled|P\'Kolino Klick Children\'s Desk|Orange|P\'kolino KlickThis playfully smart desk and chair set is a \"perfect fit\"! The P\'kolino Klick is the perfect desk for children ages 3-7. With an ample working space for paper, books, and puzzles, it is ideal for project based learning or the budding artist in your little one. The padded seat is an optimal 12 inches high with enough storage under the seat for the most prolific Picasso. For additional storage, add a Play Kit.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|168|1'),(14553,250,4,'B004A154PQ|None|Enabled|P\'kolino Duck and Ostrich Chairs|Safari Collection|The P\'kolino Safari Collection Duck and Ostrich Chair Set show how colorful, animal silhouettes make for a playful yet sophisticated design. A great addition to any playroom or bedroom and are the perfect companions to the Tree Table with Giraffe and Zebra Chairs(sold separately)! The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Create a play space where creatiAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|83.48|1'),(14552,249,4,'B004VT7XVA|None|Enabled|P\'kolino Book Buggee|Crown|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 yearsAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|35.95|1'),(14551,248,4,'B004VT7X8I|None|Enabled|P\'kolino New Little Reader Chair|Flower Pink|This NEW Little Reader Chair - Flowers has all the loved features of the Original Little Reader! Plush stain resistant faux-suede, premium quality high density foam, stable wide-base, feathery light weight, tote handle and pockets for books (and all sorts of stuff). But the New Little Reader has even more to love with playful embroidered themes, wider contoured seat and ergonomic arms for added comfort. This feathery light chair, with its two pockets for \"stuff\" and a handle to take it all whereAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|76.49|1'),(14550,247,4,'B004VT7Y7I|None|Enabled|P\'kolino Book Buggee|Fire Truck|The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books.In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"V\" shaped book holders are wider at the top for easy loading and unloading and narrow at the bottom to hold the book in place. With four book holders and plenty of \"head\" room for other treasures, see how much you can fit into your Book Buggee! Product Dimensions: 13.5\" X 7.5\" X 7.5\" Recommended Ages: 3 years - 6 yearsAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|34.65|1'),(14549,246,4,'B004A154PG|None|Enabled|P\'kolino Tree Trable|with Zebra and Giraffe Chairs|Description: A balance of playfulness and sophisticated design! The P\'kolino Safari Collection is ideal for little ones ages 3 to 6 years. Colorful, animal silhouettes make for a playful yet sophisticated design. Suitable for playrooms and bedrooms. Create a play space where creativity can run wild! Made of the same quality wood to match the P\'kolino line and coated with a wood veneer. Two chairs are included with the product, but you can always add more. P\'kolino products meet or exceed US, EU, and Canadian safety standards. Product Made in China - Designed in USA Specifications: Materials: Fiber Board with Wood Veneer **Tip: Age: 3 to 6 years old Dimensions: Chair: 23 in. (58.4 cm) H x 11 in (28 cm) W x 11 in (28 cm) L.Seat Height: 11 in (28 cm). Table: 20.5 in. (52 cm) H x 28 in. (71.2 cm) W x 28 in. (71.2 cm) L.Weight: 40 lbs (19 kg)Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|164.99|1'),(14548,245,4,'B001RIY7CQ|None|Enabled|P\'kolino Children Desk|White|P\'kolino Children\'s DeskA Stylistically-Compact, Playful Work Space! Specially designed for little ones with big ideas, the P\'kolino Children\'s Desk is a child favorite. With it\'s ample working space for paper, books, and puzzles, it is ideal for project based learning or the budding artist.This all-in-one design with ergonomically positioned built-in seat means little ones do not need to struggle with finding or positioning their chair. The seat is an optimal 12 inches high with a smart storageAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|66.99|1'),(14547,244,4,'B0039UTUWM|None|Enabled|P\'kolino Nesting Birds|Natural wood|These silly birds nest inside each other teaching the fundamentals of size and shape while engaging reasoning skills (larger birds do not fit in smaller birds), which improve problem-solving abilities. Strengthen fine motor skills by separating the birds and putting them back together. These functional features combined with the beautiful colors and natural wood creates a truly one-of-a-kind, playfully smart nesting toy!Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|22.35|1'),(14546,243,4,'B001HX4IXE|None|Enabled|P\'kolino Book Buggee|Orange|Make books a part of everyday play! The P\'kolino Book Buggee is a fantastically fun way to make books a part of your child\'s everyday play. This fun-loving friend helps introduce and develop a playful bond with books through the self-directed acts of selecting, loading and pulling books and other treasures. This incorporation of books into play helps nurture a child\'s love for books. In addition to the P\'kolino Book Buggee being super cute, it is also ergonomically designed for easy use. The \"Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|32.6|1'),(14545,242,4,'B004835N8E|None|Enabled|P\'kolino Silly Soft Seating|Lila|This fun loving combination of stuffed toy and modular toddler seating has many features designed to support your toddler\'s developmental needs, making these engaging and multi-talented silly seats a playfully smart addition to any growing home.This modular Silly Soft Seating is compromised of three soft, sturdy, lightweight pieces that can be configured in a myriad of ways; from seats of varying height to tiny tables. These many variations and the capacity for children to do the configuring, arAmazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|34.99|1'),(14543,239,4,'B000IHJF60|None|Enabled|Tot Tutors Book Rack, Primary Colors|Amazon Product Detail Page|The sturdy wood bookrack with colorful nylon fabric pockets hold books cover forward for easy recognition by young children encouraging them to “read” and return their books for a neat and organized room.|26.99|1'),(14544,241,4,'B002AQIA6S|None|Enabled|P\'Kolino Little Sofa|Sleeper, Green|P\'kolino Little Reader SofaComfy foam, supple fabric, book pockets and easy to fold out sleeper, creates the perfect combination for a little quiet-time. A wide base and strong angular lines makes this sofa attractive and supremely sturdy. This durable sofa is made with the highest quality materials, constructed with premium high density foam and upholstered in cozy, stain resistant fabrics. The Little Reader Sofa Sleeper is also the perfect companion to the Little Reader chair.Amazon Product Detail Page About P\'kolinoP\'kolino (pee-ko-lee-no) was founded to improve play at home by two dads with a passion for creating great products. With the help of friends, family and a global network of designers, P’kolino has created play products that are beloved worldwide for their playful style and smart functionality.This innovative line of toys, play furnishings, art supplies, décor and more offer children of all ages playfully smart solutions to improving play at home. With many more new products and expansion into new markets we are looking forward to a day when everyone will know what it means to have a playfully smart P’kolino home. P\'kolino was founded in 2004 and is currently located in Fort Lauderdale, Florida.|88.2|1'),(14542,238,4,'B001TZLAZE|None|Enabled|Tot Tutors Kids\' Table and 4-Chair Set, Plastic|Amazon Product Detail Page|The vibrant and striking colors of this plastic table and 4 chair set will liven up your child’s bedroom, playroom or back patio. Ideal for lunch for four, art projects or story time. Your children will love sharing their special space with all their friends.|55|1'),(14539,231,4,'B003JNEKAG|None|Enabled|NICKELODEON SPONGE BOB TODDLER BED|Amazon Product Detail Page|A special 10th anniversary design makes this SpongeBob Squarepants toddler bed a must-have for your little SpongeBob fan. Kids will love the decals featuring favorite SpongeBob Squarepants characters. The bed is built low to the ground for easy child access and comes with side rails for safe and secure sleeping. A decal of SpongeBob Squarepants appears on the headboard and footboard. The bed also uses a standard crib mattress, sold separately. Nickelodeon - SpongeBob Squarepants Toddler Bed, 10th Anniversary Edition: Bright cheerful colors SpongeBob Squarepants toddler bed has a sturdy steel frame Low height and safety sleep rails (removable) make the bed safe SpongeBob Squarepants toddler bed is recommended for ages 18 months to 5 years Weight limit: up to 50 lbs. JPMA approved SpongeBob Squarepants toddler bed uses a standard crib mattress, sold separately|56.49|1'),(14540,232,4,'B002RL8386|None|Enabled|4Gr8 Kidz Racing Series Toddler Bed with Safe Sleep Rails|Amazon Product Detail Page||58.98|1'),(14541,236,4,'B003ZV4CVE|None|Enabled|Nickelodeon\'s Dora the Explorer Multi-Bin Toy Organizer|Amazon Product Detail Page|TB84504DO_999 This charming and functional Nickelodeon Dora the Explorer Toy Organizer makes tidying up fun. Each tier of the organizer serves its own function. The toy box is perfect for storing larger items while the storage bins are great for storing small accessories. It features an adorable Nickelodeon Dora the Explorer inspired design theme that complements other Nickelodeon Dora the Explorer items (sold separately online). Features: -Dora the explorer multi-bin toy organizer. -10th Anniversary design for Dora the Explorer. -Bins feature your child\'s favorite Nickelodeon Dora the Explorer characters. -Bottom tier is a toy box for convenient storage. -5 fabric storage bins. -In compliance with all ASTM safety standards and requirements. -High quality licensed item. -Perfect for storing larger items while the storage bins are great for storing small accessories. -Assembly required. About Dora the Explorer Airing in 2000 as one of the first cross-cultural animated children s programs, Dora the Explorer became a phenomenal hit, entertaining children and introducing young Americans to Hispanic culture. Formally aired on the CBS television network, and now a prominent series on Nickelodeon and sister channel, Noggin, the extremely successful franchise has created a recognizable household name. In the series, Dora is an adventurous, bilingual, Latina heroine who lives inside a computer. Determined, positive, helpful and caring, Dora is always ready for adventure. Children learn by watching Dora journey through her world, gathering objects and clues to ultimately help a person in need or perform a good deed with her faithful Backpack, Map and her best friend Boots. Not only is Dora the Explorer entertaining, but the interactive aspects allow children to develop problem solving skills, reasoning, and communication skills when the curious little explorer asks her audience at home questions to help her along her way. In 2005, Dora s equally curious cousin, Diego, claime|38.4|1'),(14537,226,4,'B0017YJ130|None|Enabled|Gund All Stars Sports Glove Chair|Amazon Product Detail Page|Gund All Stars Glove ChairYour little baseball fan will love lounging in this \'sports fans only\' chair. Cushiony and comfortable this All Stars Sports Glove Chair shaped as a baseball glove is sure to hit a \'grand slam\' with children of all ages. Crafted of light brown suede and black trim this authentic looking baseball glove holds your young one in it\'s palm and the fingers serve as the back.|104.99|1'),(14538,227,4,'B001GSKCAI|None|Enabled|Disney Princess Pretty Pink Toddler Bed|Amazon Product Detail Page|There\'s something about a Delta-conceived, Delta-designed, Delta-made children\'s product that so many parents, from all ends of the earth, just seem to naturally gravitate to. That is becuase Delta Children\'s Products are experts in creating groundbreaking products that meet the growing needs of children. From infancy all the way through young teen hood. Every smart, safe, high-quality Delta product is designed to deliver timeless beauty, myriad uses, and outstanding value for years to come. The Disney Princess Toddler Bed in pretty pink is perfect for transitioning your little princess from crib to big girl bed. Features a high quality plastic and metal frame making it lightweight yet sturdy for strength and durability that will last. The bed is built low to the ground for easy child access and comes with side rails for safe and secure sleeping. A whimsical princess design theme featuring your child\'s favorite Princess characters on the headboard and footboard make it a must have. The bed uses a standard crib mattress (sold separately). Recommended for use up to 50 lbs. Meets all JPMA safety requirements. Some assembly required. Features: Disney Princess Pretty Pink Toddler Bed High quality plastic and metal frame Lightweight yet sturdy Sits low to the ground for easy entry and exit 2 side rails Uses a standard crib mattress (sold separately) Recommended for use up to 50 lbs Meets all JPMA safety requirements Some assembly required Specifications: Dimensions: 29\' H x 31\' W x 54\' D Weight: 21 lbs|58.75|1'),(14335,1,4,'test_product|Enabled|Shipping|Test product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Definition list dt Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. Consectetur adipisicing elit Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.|Lorem ipsum dolor sit amet|156|1'),(20912,297,5,'downloadable_product_example|Enabled|None|Downloadable Product|Downloadable products are similar to virtual products, except that they include the ability to add one or more digital files for download.|Downloadable Product Example|495.99|Photos - Full version|Sample|1'),(20846,1,5,'test_product|Enabled|Shipping|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Lorem ipsum Collection|156|1'),(20867,298,1,'product_with_options_example|Gray|Enabled|None|Product with Options|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Product with Options Example|299.99|1'),(20471,289,5,'B0040WRM5K|None|Enabled|Metallic Slingshot Monokini (As Shown;One Size)|Feel like you are in a tropical island!|Halter top slingshot monokini.|28|1'),(20904,295,5,'grouped_product_example|Enabled|Enabled|Enabled|Enabled|Grouped Products|Product|Best product for the home with very loooooooooooong title|Simple Product|Grouped products allow you to create a new product using one or more existing products in your store|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Grouped Products Example|Flower Pink|Crown|Simple Product Example|None|None|None|76.49|35.95|373.99|White|1'),(20901,249,1,'B004VT7XVA|None|Enabled|Best product for the home with very loooooooooooong title|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Crown|35.95|1'),(20880,296,5,'bundle_product_example|Enabled|Enabled|Enabled|Bundled Products|Simple Product|Virtual Product|This product type is also known as a “kit” in other eCommerce software. This product type is ideal for circumstances where the user have to select a number of configurable options, but at least one option.|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Virtual Products are those that do not have a physical or digital counterpart.They do not ship, nor do they have a download link. This product type might be used for services like:House Cleaning1-Year Newsletter SubscriptionNote: If using Virtual Products for “subscriptions”, it is important to note that there is no built-in way to manage auto-renewing subscriptions. All purchases made in Magento, regardless of Product Type, are one-time purchases.|Bundle Products Example|Simple Product Example|Virtual Product Example|0|373.99|99|None|None|White|Option 1|Option 2|Option 3|Option 4|1'),(20473,291,5,'B005FGF38S|None|Enabled|Daisy Corsets Sequin Underwire Corset|Feel like you are in a tropical island!|Strapless sequin corset with underwire cups, side zipper closure, lace-up back and matching thong. Ruffle panty not included.|28|1'),(20916,290,5,'B005PPMSOG|None|Hot! Bikini Leopard|Bandeau Style! Halter neck tie fastening! Fully lined! Available in size 2 - 8 (XXS - M)! Colour: Multicolour (80% Polyamid, 20% Elasthan)|Feel like you are in a tropical island!|28|1'),(20796,255,5,'B004A154P6|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Safari Collection|53.98|1'),(20800,252,5,'B00545CDQ0|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Collection|48|1'),(20798,253,5,'B002EDG14U|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Extra Fun|35.99|1'),(20802,251,5,'B000WYJ33E|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Orange|168|1'),(20804,250,5,'B004A154PQ|Enabled|None|Prodict|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Safari Collection|83.48|1'),(20814,247,5,'B004VT7Y7I|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Collection|34.65|1'),(20816,246,5,'B004A154PG|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Zebra Collection|164.99|1'),(20818,245,5,'B001RIY7CQ|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|White|66.99|1'),(20820,244,5,'B0039UTUWM|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|White Collection|22.35|1'),(20824,242,5,'B004835N8E|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Collection|34.99|1'),(20822,243,5,'B001HX4IXE|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Orange Collection|32.6|1'),(20830,238,5,'B001TZLAZE|Enabled|None|Prduct|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Soft collection|55|1'),(20826,239,5,'B000IHJF60|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Best Collection|26.99|1'),(20828,241,5,'B002AQIA6S|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Best Collection|88.2|1'),(20836,231,5,'B003JNEKAG|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Gray Collection|56.49|1'),(20834,232,5,'B002RL8386|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Black|58.98|1'),(20832,236,5,'B003ZV4CVE|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|White|38.4|1'),(20838,227,5,'B001GSKCAI|Enabled|None|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Orange|58.75|1'),(14589,287,4,'B006XFJXF4|None|Enabled|Hot! Bikini white, yellow or black|Feel like you are in a tropical island!|Cup A, B & C for a hot décolleté! Bandeau Style! Halter neck tie fastening! Available in size 2 - 12! Colour yellow, white or black (83% Polyamid, 17% Elasthan)|28|1'),(14590,288,4,'B003VSOKQI|None|Enabled|Designer Monokini Halter String Ties Womens Sexy Bikini|Feel like you are in a tropical island!|Feel like you are in a tropical island when you wear this monokini style printed bikini. Be ready to look hot when you wear this exotic two piece to all your fun times in the sun. The fabric of this bikini is super soft on your skin and has great luxurious quality. The top features a deep V neckline with halter and back ties. The cups feature removable soft padding for a comfortable fit and superior coverage. The cut out sides and low waist bottom with circle side rings, makes this a must have sexy swimsuit. The back reveals an open sexy bareback with a moderate coverage bikini bottom. This tropical style will make you the exotic princess everywhere you go!|28|1'),(14591,289,4,'B0040WRM5K|None|Enabled|Metallic Slingshot Monokini (As Shown;One Size)|Feel like you are in a tropical island!|Halter top slingshot monokini.|28|1'),(14592,290,4,'B005PPMSOG|None|Enabled|Hot! Bikini Leopard|Feel like you are in a tropical island!|Bandeau Style! Halter neck tie fastening! Fully lined! Available in size 2 - 8 (XXS - M)! Colour: Multicolour (80% Polyamid, 20% Elasthan)|28|1'),(14593,291,4,'B005FGF38S|None|Enabled|Daisy Corsets Sequin Underwire Corset|Feel like you are in a tropical island!|Strapless sequin corset with underwire cups, side zipper closure, lace-up back and matching thong. Ruffle panty not included.|28|1'),(20845,1,1,'test_product|Enabled|Shipping|Product|H2 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH3 title goes hereLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumH4 title goes hereUl class \"bullet\" Consectetur adipisicing elitIpsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborumDefinition list DLLorem ipsum dolorLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Consectetur adipisicing elitLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Ordered lists OLLorem ipsum dolorLorem ipsum dolorLorem ipsum dolor|Lorem ipsum Collection|156|1');
/*!40000 ALTER TABLE `catalogsearch_fulltext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_query`
--

DROP TABLE IF EXISTS `catalogsearch_query`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogsearch_query` (
  `query_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Query ID',
  `query_text` varchar(255) DEFAULT NULL COMMENT 'Query text',
  `num_results` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Num results',
  `popularity` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Popularity',
  `redirect` varchar(255) DEFAULT NULL COMMENT 'Redirect',
  `synonym_for` varchar(255) DEFAULT NULL COMMENT 'Synonym for',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `display_in_terms` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Display in terms',
  `is_active` smallint(6) DEFAULT '1' COMMENT 'Active status',
  `is_processed` smallint(6) DEFAULT '0' COMMENT 'Processed status',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated at',
  PRIMARY KEY (`query_id`),
  KEY `IDX_CATALOGSEARCH_QUERY_QUERY_TEXT_STORE_ID_POPULARITY` (`query_text`,`store_id`,`popularity`),
  KEY `IDX_CATALOGSEARCH_QUERY_STORE_ID` (`store_id`),
  KEY `IDX_CATALOGSEARCH_QUERY_SYNONYM_FOR` (`synonym_for`),
  CONSTRAINT `FK_CATALOGSEARCH_QUERY_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COMMENT='Catalog search query table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_query`
--

LOCK TABLES `catalogsearch_query` WRITE;
/*!40000 ALTER TABLE `catalogsearch_query` DISABLE KEYS */;
INSERT INTO `catalogsearch_query` VALUES (1,'comp',8,2,NULL,NULL,1,1,1,0,'2011-11-16 11:46:35'),(2,'v',0,1,NULL,NULL,1,1,1,0,'2011-11-12 01:08:39'),(3,'home',55,44,NULL,NULL,1,1,1,0,'2014-01-08 05:50:43'),(4,'P\'kolino',19,5,NULL,NULL,1,1,1,0,'2013-02-13 14:57:43'),(5,'Hok',0,1,NULL,NULL,1,1,1,0,'2012-02-06 06:47:02'),(6,'h',30,2,NULL,NULL,1,1,1,0,'2012-02-06 06:47:02'),(7,'hom',4,2,NULL,NULL,1,1,1,0,'2012-02-06 06:47:02'),(8,'Ashton Sutton',6,3,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(9,'roxy',19,11,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(10,'lush',37,2,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(11,'birdscapes',2,5,NULL,NULL,1,1,1,0,'2012-05-08 09:01:45'),(12,'Eero Aarnio',5,7,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(13,'JoJo',7,1,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(14,'JoJo Designs',47,3,NULL,NULL,1,1,1,0,'2012-05-08 09:01:45'),(15,'Strathwood',23,2,NULL,NULL,1,1,1,0,'2013-02-23 01:39:28'),(16,'aero aarnio',5,1,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(17,'momeni',27,3,NULL,NULL,1,1,1,0,'2012-05-06 21:06:43'),(18,'red to',31,4,NULL,NULL,1,1,1,0,'2014-03-01 10:57:18'),(19,'ссс',0,1,NULL,NULL,1,1,1,1,'2015-10-01 03:53:09');
/*!40000 ALTER TABLE `catalogsearch_query` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_result`
--

DROP TABLE IF EXISTS `catalogsearch_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogsearch_result` (
  `query_id` int(10) unsigned NOT NULL COMMENT 'Query ID',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `relevance` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Relevance',
  PRIMARY KEY (`query_id`,`product_id`),
  KEY `IDX_CATALOGSEARCH_RESULT_QUERY_ID` (`query_id`),
  KEY `IDX_CATALOGSEARCH_RESULT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_CATALOGSEARCH_RESULT_QUERY_ID_CATALOGSEARCH_QUERY_QUERY_ID` FOREIGN KEY (`query_id`) REFERENCES `catalogsearch_query` (`query_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATSRCH_RESULT_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog search result table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_result`
--

LOCK TABLES `catalogsearch_result` WRITE;
/*!40000 ALTER TABLE `catalogsearch_result` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogsearch_result` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkout_agreement`
--

DROP TABLE IF EXISTS `checkout_agreement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_agreement` (
  `agreement_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Agreement Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `content` text COMMENT 'Content',
  `content_height` varchar(25) DEFAULT NULL COMMENT 'Content Height',
  `checkbox_text` text COMMENT 'Checkbox Text',
  `is_active` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `is_html` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Is Html',
  PRIMARY KEY (`agreement_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Checkout Agreement';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkout_agreement`
--

LOCK TABLES `checkout_agreement` WRITE;
/*!40000 ALTER TABLE `checkout_agreement` DISABLE KEYS */;
INSERT INTO `checkout_agreement` VALUES (1,'Terms and Conditions','test',NULL,'Terms and Conditions',1,0);
/*!40000 ALTER TABLE `checkout_agreement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkout_agreement_store`
--

DROP TABLE IF EXISTS `checkout_agreement_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_agreement_store` (
  `agreement_id` int(10) unsigned NOT NULL COMMENT 'Agreement Id',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store Id',
  PRIMARY KEY (`agreement_id`,`store_id`),
  KEY `FK_CHECKOUT_AGREEMENT_STORE_STORE_ID_CORE_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CHECKOUT_AGREEMENT_STORE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CHKT_AGRT_STORE_AGRT_ID_CHKT_AGRT_AGRT_ID` FOREIGN KEY (`agreement_id`) REFERENCES `checkout_agreement` (`agreement_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Checkout Agreement Store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkout_agreement_store`
--

LOCK TABLES `checkout_agreement_store` WRITE;
/*!40000 ALTER TABLE `checkout_agreement_store` DISABLE KEYS */;
INSERT INTO `checkout_agreement_store` VALUES (1,0);
/*!40000 ALTER TABLE `checkout_agreement_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_block`
--

DROP TABLE IF EXISTS `cms_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_block` (
  `block_id` smallint(6) NOT NULL AUTO_INCREMENT COMMENT 'Block ID',
  `title` varchar(255) NOT NULL COMMENT 'Block Title',
  `identifier` varchar(255) NOT NULL COMMENT 'Block String Identifier',
  `content` mediumtext COMMENT 'Block Content',
  `creation_time` timestamp NULL DEFAULT NULL COMMENT 'Block Creation Time',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'Block Modification Time',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Is Block Active',
  PRIMARY KEY (`block_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COMMENT='CMS Block Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_block`
--

LOCK TABLES `cms_block` WRITE;
/*!40000 ALTER TABLE `cms_block` DISABLE KEYS */;
INSERT INTO `cms_block` VALUES (5,'Footer Links','footer_links','<div class=\"footer_block\">\r\n  <div class=\"links_block clearfix\">\r\n    <div >\r\n      <h4 class=\"title\">Company Information</h4>\r\n      <ul>\r\n        <li><a href=\"/about-us\">About Us</a></li>\r\n        <li><a href=\"/contacts\">Contact Us</a></li>\r\n        <li><a href=\"/customer-service\">Privacy Policy</a></li>\r\n      </ul>\r\n    </div>\r\n    <div>\r\n      <h4 class=\"title\">Customer Service</h4>\r\n      <ul>\r\n        <li><a href=\"/customer-service\">Ordering Information</a></li>\r\n        <li><a href=\"/customer-service\">Delivery &amp; Rates</a></li>\r\n        <li><a href=\"/sales/guest/form/\">Cancellations &amp; Returns</a></li>\r\n      </ul>\r\n    </div>\r\n    <div class=\"last\">\r\n      <h4 class=\"title\">Useful Tips and Information</h4>\r\n      <ul>\r\n        <li><a href=\"/testimonials\">Customer Testimonials</a></li>\r\n        <li><a href=\"/blog\">Our Blog</a></li>\r\n        <li><a href=\"/catalog/seo_sitemap/category/\">Site Map</a></li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n  <div class=\"seotext\">\r\n  <p>Download our best free Magento themes at Web-Experiment.info</p>\r\n </div>\r\n','2010-11-30 21:55:30','2014-01-16 22:20:48',1),(10,'Slider Manager - slides example','slider_manager','<h3>Slider Manager is a perfect feature to demonstrate advertising and promotional story building of an image with a title and link for each slide or any HTML content.</h3>\r\n<p>Without touching any code you can create multiple sliders that can be included anywhere using the Magento backend. The user adds images to the slider by uploading them as attachments.</p>\r\n<p><a style=\"font-size: 14px; font-weight: bold; text-decoration: underline;\" href=\"/magento-template-features/slider-manager/page-without-slider-manager.html\">Magento template without the Slider Manager</a></p>\r\n<h2 class=\"h2_big\"><a href=\"/magento-template-features/slider-manager/samanta-slider.html\">Samanta Slider</a></h2>\r\n{{widget type=\"advancedslider/widget_slider\" unique_id_prefix=\"1371433208\" slider=\"22\"}}\r\n<h2 class=\"h2_big\"><a href=\"/magento-template-features/slider-manager/amanda-slider.html\">Amanda Slider</a></h2>\r\n{{widget type=\"advancedslider/widget_slider\" unique_id_prefix=\"1371433160\" slider=\"23\"}}\r\n<h2 class=\"h2_big\"><a href=\"/magento-template-features/slider-manager/trisha-slider.html\">Trisha Slider</a></h2>\r\n{{widget type=\"advancedslider/widget_slider\" unique_id_prefix=\"1371433384\" slider=\"18\"}}\r\n<h2 class=\"h2_big\"><a href=\"/magento-template-features/slider-manager/krista-slider.html\">Krista Slider</a></h2>\r\n{{widget type=\"advancedslider/widget_slider\" unique_id_prefix=\"1371433530\" slider=\"15\"}}\r\n<h2 class=\"h2_big\"><a href=\"/magento-template-features/slider-manager/standard-slider.html\">Standard Slider</a></h2>\r\n{{widget type=\"advancedslider/widget_slider\" unique_id_prefix=\"1371433586\" slider=\"25\"}}\r\n','2011-11-09 14:05:45','2013-06-17 07:46:32',1),(17,'right_info_block','right_info_block','<div class=\"sidebar_banner\"><img src=\"{{media url=\"template/grayscale_full_width_free_magento_theme.jpg\"}}\" alt=\"Grayscale Full-width Free Magento Template\" /></div>','2011-11-11 06:24:58','2014-06-06 02:54:51',1),(19,'Custom Menu Block Example','wp_custom_menu_28','<div class=\"items\">\r\n  <div class=\"single_menu_product\">{{block type=\"catalog/product_new\" product_id=\"296\" template=\"catalog/product/view/single_top.phtml\" cache_key=\"296\"}}</div>\r\n  <div class=\"single_menu_product\">{{block type=\"catalog/product_new\" product_id=\"295\" template=\"catalog/product/view/single_top_btn.phtml\" cache_key=\"295\"}}</div>\r\n</div>\r\n<div class=\"menu_image\">\r\n  <p><a href=\"/magento-template-features/bonus-extensions/custom-magento-menu.html\"><img src=\"{{media url=\"template/magento_template_custom_menu.jpg\"}}\" alt=\"\" /></a></p>\r\n</div>\r\n','2011-11-12 09:21:38','2014-01-19 21:27:29',1),(27,'left_info_block','left_info_block','<div>{{block type=\"catalog/product_popular\" template=\"catalog/product/popular.phtml\" category_id=\"3\"}}</div>\r\n<div class=\"block block-service\">\r\n  <div class=\"block-title\"><strong><span>Customer Service</span></strong></div>\r\n  <div class=\"block-content\">\r\n    <dl>\r\n      <dd>8AM-10PM ET, Mon - Fri <br />\r\n        10AM-6PM ET, Sat</dd>\r\n      <dt>Sales Assistance:</dt>\r\n      <dd>8AM-11PM ET, Mon - Fri <br />\r\n        9AM-11PM ET, Sat - Sun</dd>\r\n      <dt>Call: <strong>000.000.2014</strong> </dt>\r\n    </dl>\r\n  </div>\r\n</div>\r\n\r\n','2012-05-04 23:04:56','2014-01-14 02:38:14',1),(28,'home_page_header_block','home_page_header_block','<div class=\"images\">\r\n  <div id=\"slider-wrap\" class=\"slider-wrap\" style=\"width: 100%;\">\r\n    <div id=\"slider_pager\" class=\"stripNav\"></div>\r\n    <div id=\"slider-content\" class=\"slider-wrap\">\r\n<a rel=\"nofollow\" href=\"http://web-experiment.info/free-magento-templates\" title=\"Free Magento templates\"><img src=\"{{media url=\"template/free_responsive_magento_template_grayscale_full_width.jpg\"}}\" alt=\"Free responsive Magento template Grayscale full-width\" /></a>\r\n<a rel=\"nofollow\" href=\"http://web-experiment.info\"  title=\"Web-Experiment.info - Premium Magento templates\"><img src=\"{{media url=\"template/web_experiment_premium_magento_templates.jpg\"}}\" alt=\"Web-Experiment.info - Premium Magento templates\" /></a>\r\n    </div>\r\n  </div>\r\n  <script type=\"text/javascript\">\r\n    jQuery(document).ready(function() {\r\n        jQuery(\'#slider-content\').wpInitStandardSlider({baseWidth: 1900, baseHeight: 529});\r\n    });\r\n  </script>\r\n</div>','2012-05-04 23:08:25','2015-10-05 02:12:42',1),(34,'Highlight Categories','category_hightlight','<h2>Category layout with product name and price</h2>\r\n{{block type=\"catalog/product_promo\" template=\"webandpeople/smartcatalog/list-short.phtml\" category_id=\"50\" image_width=\"110\" image_height=\"110\" column_width=\"155\" products_count=\"6\" sort_by=\"entity_id\"}}\r\n<h2>Category layout with product name, price, rating and add-to-cart button</h2>\r\n{{block type=\"catalog/product_promo\" template=\"webandpeople/smartcatalog/list-rate.phtml\" category_id=\"50\" image_width=\"120\" image_height=\"120\" column_width=\"187\" products_count=\"5\" }}\r\n<h2>Category layout with product name, price, rating, add-to-cart button, add-to-wishlist, add-to-compare</h2>\r\n{{block type=\"catalog/product_promo\" template=\"webandpeople/smartcatalog/list-home.phtml\" category_id=\"3\" image_width=\"170\" image_height=\"170\" column_width=\"230\" products_count=\"4\" sort_by=\"entity_id\"}}\r\n','2013-02-04 23:20:09','2014-01-09 01:48:23',1),(35,'Most Popular Static Block','most-popular','<div class=\"col-left sidebar clearfix\"  style=\"float: none; margin-left: auto;margin-right: auto;\">{{block type=\"catalog/product_popular\" template=\"catalog/product/popular.phtml\" category_id=\"3\"}}</div>\r\n','2013-02-06 22:10:33','2014-01-06 01:52:15',1),(36,'Cookie restriction notice','cookie_restriction_notice_block','<p>This website requires cookies to provide all of its features. For more information on what data is contained in the cookies, please see our <a href=\"{{store direct_url=\"privacy-policy-cookie-restriction-mode\"}}\">Privacy Policy page</a>. To accept cookies from this site, please click the Allow button below.</p>','2014-01-20 11:23:10','2014-01-20 11:23:10',1),(37,'Home page v2','home_page_v2','<div class=\"best_sellers\">New Arrivals</div>\r\n<div>{{block type=\"catalog/product_new\" template=\"webandpeople/smartcatalog/list-new.phtml\" image_width=\"170\" image_height=\"170\" column_width=\"190\" products_count=\"6\"}}</div>\r\n<div class=\"best_sellers\">Best Sellers in <a href=\"/grayscale-magento-template.html\">Category &raquo;</a></div>\r\n<div>{{block type=\"catalog/product_promo\" template=\"webandpeople/smartcatalog/list-home.phtml\" category_id=\"50\" image_width=\"110\" image_height=\"110\" column_width=\"144\" products_count=\"8\" }}</div>','2014-03-07 00:26:32','2014-06-05 13:39:29',1);
/*!40000 ALTER TABLE `cms_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_block_store`
--

DROP TABLE IF EXISTS `cms_block_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_block_store` (
  `block_id` smallint(6) NOT NULL COMMENT 'Block ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`block_id`,`store_id`),
  KEY `IDX_CMS_BLOCK_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CMS_BLOCK_STORE_BLOCK_ID_CMS_BLOCK_BLOCK_ID` FOREIGN KEY (`block_id`) REFERENCES `cms_block` (`block_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CMS_BLOCK_STORE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CMS Block To Store Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_block_store`
--

LOCK TABLES `cms_block_store` WRITE;
/*!40000 ALTER TABLE `cms_block_store` DISABLE KEYS */;
INSERT INTO `cms_block_store` VALUES (5,0),(10,0),(17,0),(19,0),(27,0),(28,0),(34,0),(35,0),(36,0),(37,0);
/*!40000 ALTER TABLE `cms_block_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_page`
--

DROP TABLE IF EXISTS `cms_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_page` (
  `page_id` smallint(6) NOT NULL AUTO_INCREMENT COMMENT 'Page ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `root_template` varchar(255) DEFAULT NULL COMMENT 'Page Template',
  `meta_keywords` text COMMENT 'Page Meta Keywords',
  `meta_description` text COMMENT 'Page Meta Description',
  `identifier` varchar(100) NOT NULL DEFAULT '' COMMENT 'Page String Identifier',
  `content_heading` varchar(255) DEFAULT NULL COMMENT 'Page Content Heading',
  `content` mediumtext COMMENT 'Page Content',
  `creation_time` timestamp NULL DEFAULT NULL COMMENT 'Page Creation Time',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'Page Modification Time',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Is Page Active',
  `sort_order` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Page Sort Order',
  `layout_update_xml` text COMMENT 'Page Layout Update Content',
  `custom_theme` varchar(100) DEFAULT NULL COMMENT 'Page Custom Theme',
  `custom_root_template` varchar(255) DEFAULT NULL COMMENT 'Page Custom Template',
  `custom_layout_update_xml` text COMMENT 'Page Custom Layout Update Content',
  `custom_theme_from` date DEFAULT NULL COMMENT 'Page Custom Theme Active From Date',
  `custom_theme_to` date DEFAULT NULL COMMENT 'Page Custom Theme Active To Date',
  PRIMARY KEY (`page_id`),
  KEY `IDX_CMS_PAGE_IDENTIFIER` (`identifier`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='CMS Page Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_page`
--

LOCK TABLES `cms_page` WRITE;
/*!40000 ALTER TABLE `cms_page` DISABLE KEYS */;
INSERT INTO `cms_page` VALUES (1,'404 Not Found 1','two_columns_right','Page keywords','Page description','no-route',NULL,'<div class=\"page-title\"><h1>Whoops, our bad...</h1></div>\r\n<dl>\r\n<dt>The page you requested was not found, and we have a fine guess why.</dt>\r\n<dd>\r\n<ul class=\"disc\">\r\n<li>If you typed the URL directly, please make sure the spelling is correct.</li>\r\n<li>If you clicked on a link to get here, the link is outdated.</li>\r\n</ul></dd>\r\n</dl>\r\n<dl>\r\n<dt>What can you do?</dt>\r\n<dd>Have no fear, help is near! There are many ways you can get back on track with Magento Store.</dd>\r\n<dd>\r\n<ul class=\"disc\">\r\n<li><a href=\"#\" onclick=\"history.go(-1); return false;\">Go back</a> to the previous page.</li>\r\n<li>Use the search bar at the top of the page to search for your products.</li>\r\n<li>Follow these links to get you back on track!<br /><a href=\"{{store url=\"\"}}\">Store Home</a> <span class=\"separator\">|</span> <a href=\"{{store url=\"customer/account\"}}\">My Account</a></li></ul></dd></dl>\r\n','2011-10-29 22:59:08','2011-10-29 22:59:08',1,0,NULL,NULL,NULL,NULL,NULL,NULL),(2,'Grayscale Full-width Free Magento Template','three_columns','Magento, template, eCommerce, theme, Magento template, extension, crafts, home décor, home textiles, accessories, flowers, eco products, green products, health products, visual arts, gift ','The perfect Magento theme is best for home décor, home textiles, crafts, accessories, flowers, eco products, green products, health products, visual arts and gift shops. ','home',NULL,'<div class=\"best_sellers\">New Arrivals</div>\r\n<div>{{block type=\"catalog/product_new\" template=\"webandpeople/smartcatalog/list-new.phtml\" image_width=\"170\" image_height=\"170\" column_width=\"190\" products_count=\"6\"}}</div>\r\n<div class=\"best_sellers\">Best Sellers in <a href=\"/grayscale-magento-template.html\">Category &raquo;</a></div>\r\n<div>{{block type=\"catalog/product_promo\" template=\"webandpeople/smartcatalog/list-home.phtml\" category_id=\"50\" image_width=\"110\" image_height=\"110\" column_width=\"144\" products_count=\"8\" }}</div>\r\n\r\n\r\n','2011-10-29 22:59:08','2014-01-22 08:14:08',1,0,'<reference name=\"header\">\r\n    <block type=\"cms/block\" name=\"home_page_header_block\">\r\n        <action method=\"setBlockId\">\r\n            <block_id>home_page_header_block</block_id>\r\n        </action>\r\n    </block>\r\n</reference>\r\n<reference name=\"head\">\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/jquery-1.5.2.min.js</name>\r\n    </action>\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/noconflict.js</name>\r\n    </action>\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/cycle-fade-effect.js</name>\r\n    </action>\r\n    <action method=\"addItem\">\r\n        <type>skin_js</type>\r\n        <name>js/jquery.standardSlider.js</name>\r\n    </action>\r\n    <action method=\"addCss\">\r\n        <stylesheet>css/slider.css</stylesheet>\r\n    </action>\r\n</reference>',NULL,NULL,NULL,NULL,NULL),(3,'About  Us','two_columns_left',NULL,NULL,'about-us',NULL,'<div class=\"page-title\">\r\n  <h1>About Magento Store</h1>\r\n</div>\r\n<div class=\"col3-set\">\r\n  <div class=\"col-1\">\r\n    <p style=\"text-align: center;\"><a href=\"http://www.webandpeople.com/\"><img title=\"WebAndPeople\" src=\"{{media url=\"/template/web_experiment_magento_templates.jpg\"}}\" alt=\"Web-Experiment.info\" /></a></p>\r\n  </div>\r\n  <div class=\"col-2\" >\r\n    <h2>Premium Magento Templates</h2>\r\n    <p>Each Magento Template is a fresh, beautifully complex and customizable template with many applications in business. It can be used for any kind of store that needs a fresh and modern look with improved user interface..</p>\r\n    <p>A massive pack of backend CMS options was created to give you substantial control over the content and look of your store. Our idea  was to create a fresh templates &mdash;useful, great looking and easy to modify &mdash;whether you are a Magento novice or an advanced user.</p>\r\n    <p>There are also some great freebies being offered, like a Grayscale, Bluescale and Glam Free Magento Theme as well. Since coming on the scene one year ago in July 2009, the Web-Experiment.info has been growing at a striking rate. We are constantly striving to improve Web-Experiment, and we hope that all of our customers enjoy all that our Magento store templates have to offer</p>\r\n  </div>\r\n  <div class=\"col-3\">\r\n    <h2>About WebAndPeople Network</h2>\r\n    <p><strong>Web-Experiment.info</strong> offers a wide choice of nice-looking and easily editable free and premium tempaltes for the extremely popular Magento eCommerce platform.</p>\r\n    <p><strong>Magenting.com</strong> a new and improved hosting solution, is allowing you to easily create, promote, and manage your online store with Magento.</p>\r\n    <p><strong>WebAndPeople.com</strong> is a team of professional Web developers and designers who are some of the best in the industry. </p>\r\n    <p style=\"line-height: 1.2em;\"><strong style=\"font: italic 2em Georgia, serif;\">WebAndPeople</strong><br />\r\n      <small>...a solid company! :)</small></p>\r\n  </div>\r\n</div>\r\n','2007-08-31 00:01:18','2014-01-13 23:06:47',1,0,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Customer Service','three_columns',NULL,NULL,'customer-service',NULL,'<div class=\"page-title\">\r\n<h1>Customer Service</h1>\r\n</div>\r\n<ul class=\"disc\">\r\n<li><a href=\"#answer1\">Shipping &amp; Delivery</a></li>\r\n<li><a href=\"#answer2\">Privacy &amp; Security</a></li>\r\n<li><a href=\"#answer3\">Returns &amp; Replacements</a></li>\r\n<li><a href=\"#answer4\">Ordering</a></li>\r\n<li><a href=\"#answer5\">Payment, Pricing &amp; Promotions</a></li>\r\n<li><a href=\"#answer6\">Viewing Orders</a></li>\r\n<li><a href=\"#answer7\">Updating Account Information</a></li>\r\n</ul>\r\n<dl>\r\n<dt id=\"answer1\">Shipping &amp; Delivery</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer2\">Privacy &amp; Security</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer3\">Returns &amp; Replacements</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer4\">Ordering</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer5\">Payment, Pricing &amp; Promotions</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer6\">Viewing Orders</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer7\">Updating Account Information</dt>\r\n<dd>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n</dl>','2011-10-29 22:59:08','2011-10-29 22:59:08',1,0,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Enable Cookies','one_column',NULL,NULL,'enable-cookies',NULL,'<div class=\"std\">\r\n    <ul class=\"messages\">\r\n        <li class=\"notice-msg\">\r\n            <ul>\r\n                <li>Please enable cookies in your web browser to continue.</li>\r\n            </ul>\r\n        </li>\r\n    </ul>\r\n    <div class=\"page-title\">\r\n        <h1><a name=\"top\"></a>What are Cookies?</h1>\r\n    </div>\r\n    <p>Cookies are short pieces of data that are sent to your computer when you visit a website. On later visits, this data is then returned to that website. Cookies allow us to recognize you automatically whenever you visit our site so that we can personalize your experience and provide you with better service. We also use cookies (and similar browser data, such as Flash cookies) for fraud prevention and other purposes. If your web browser is set to refuse cookies from our website, you will not be able to complete a purchase or take advantage of certain features of our website, such as storing items in your Shopping Cart or receiving personalized recommendations. As a result, we strongly encourage you to configure your web browser to accept cookies from our website.</p>\r\n    <h2 class=\"subtitle\">Enabling Cookies</h2>\r\n    <ul class=\"disc\">\r\n        <li><a href=\"#ie7\">Internet Explorer 7.x</a></li>\r\n        <li><a href=\"#ie6\">Internet Explorer 6.x</a></li>\r\n        <li><a href=\"#firefox\">Mozilla/Firefox</a></li>\r\n        <li><a href=\"#opera\">Opera 7.x</a></li>\r\n    </ul>\r\n    <h3><a name=\"ie7\"></a>Internet Explorer 7.x</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Start Internet Explorer</p>\r\n        </li>\r\n        <li>\r\n            <p>Under the <strong>Tools</strong> menu, click <strong>Internet Options</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-1.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click the <strong>Privacy</strong> tab</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-2.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click the <strong>Advanced</strong> button</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-3.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Put a check mark in the box for <strong>Override Automatic Cookie Handling</strong>, put another check mark in the <strong>Always accept session cookies </strong>box</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-4.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click <strong>OK</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-5.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click <strong>OK</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-6.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Restart Internet Explore</p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n    <h3><a name=\"ie6\"></a>Internet Explorer 6.x</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Select <strong>Internet Options</strong> from the Tools menu</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie6-1.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Privacy</strong> tab</p>\r\n        </li>\r\n        <li>\r\n            <p>Click the <strong>Default</strong> button (or manually slide the bar down to <strong>Medium</strong>) under <strong>Settings</strong>. Click <strong>OK</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie6-2.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n    <h3><a name=\"firefox\"></a>Mozilla/Firefox</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Click on the <strong>Tools</strong>-menu in Mozilla</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Options...</strong> item in the menu - a new window open</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Privacy</strong> selection in the left part of the window. (See image below)</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/firefox.png\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Expand the <strong>Cookies</strong> section</p>\r\n        </li>\r\n        <li>\r\n            <p>Check the <strong>Enable cookies</strong> and <strong>Accept cookies normally</strong> checkboxes</p>\r\n        </li>\r\n        <li>\r\n            <p>Save changes by clicking <strong>Ok</strong>.</p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n    <h3><a name=\"opera\"></a>Opera 7.x</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Click on the <strong>Tools</strong> menu in Opera</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Preferences...</strong> item in the menu - a new window open</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Privacy</strong> selection near the bottom left of the window. (See image below)</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/opera.png\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>The <strong>Enable cookies</strong> checkbox must be checked, and <strong>Accept all cookies</strong> should be selected in the &quot;<strong>Normal cookies</strong>&quot; drop-down</p>\r\n        </li>\r\n        <li>\r\n            <p>Save changes by clicking <strong>Ok</strong></p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n</div>\r\n','2011-10-29 22:59:08','2011-10-29 22:59:08',1,0,NULL,NULL,NULL,NULL,NULL,NULL),(26,'Privacy Policy','one_column',NULL,NULL,'privacy-policy-cookie-restriction-mode','Privacy Policy','<p style=\"color: #ff0000; font-weight: bold; font-size: 13px\">\n    Please replace this text with you Privacy Policy.\n    Please add any additional cookies your website uses below (e.g., Google Analytics)\n</p>\n<p>\n    This privacy policy sets out how {{config path=\"general/store_information/name\"}} uses and protects any information\n    that you give {{config path=\"general/store_information/name\"}} when you use this website.\n    {{config path=\"general/store_information/name\"}} is committed to ensuring that your privacy is protected.\n    Should we ask you to provide certain information by which you can be identified when using this website,\n    then you can be assured that it will only be used in accordance with this privacy statement.\n    {{config path=\"general/store_information/name\"}} may change this policy from time to time by updating this page.\n    You should check this page from time to time to ensure that you are happy with any changes.\n</p>\n<h2>What we collect</h2>\n<p>We may collect the following information:</p>\n<ul>\n    <li>name</li>\n    <li>contact information including email address</li>\n    <li>demographic information such as postcode, preferences and interests</li>\n    <li>other information relevant to customer surveys and/or offers</li>\n</ul>\n<p>\n    For the exhaustive list of cookies we collect see the <a href=\"#list\">List of cookies we collect</a> section.\n</p>\n<h2>What we do with the information we gather</h2>\n<p>\n    We require this information to understand your needs and provide you with a better service,\n    and in particular for the following reasons:\n</p>\n<ul>\n    <li>Internal record keeping.</li>\n    <li>We may use the information to improve our products and services.</li>\n    <li>\n        We may periodically send promotional emails about new products, special offers or other information which we\n        think you may find interesting using the email address which you have provided.\n    </li>\n    <li>\n        From time to time, we may also use your information to contact you for market research purposes.\n        We may contact you by email, phone, fax or mail. We may use the information to customise the website\n        according to your interests.\n    </li>\n</ul>\n<h2>Security</h2>\n<p>\n    We are committed to ensuring that your information is secure. In order to prevent unauthorised access or disclosure,\n    we have put in place suitable physical, electronic and managerial procedures to safeguard and secure\n    the information we collect online.\n</p>\n<h2>How we use cookies</h2>\n<p>\n    A cookie is a small file which asks permission to be placed on your computer\'s hard drive.\n    Once you agree, the file is added and the cookie helps analyse web traffic or lets you know when you visit\n    a particular site. Cookies allow web applications to respond to you as an individual. The web application\n    can tailor its operations to your needs, likes and dislikes by gathering and remembering information about\n    your preferences.\n</p>\n<p>\n    We use traffic log cookies to identify which pages are being used. This helps us analyse data about web page traffic\n    and improve our website in order to tailor it to customer needs. We only use this information for statistical\n    analysis purposes and then the data is removed from the system.\n</p>\n<p>\n    Overall, cookies help us provide you with a better website, by enabling us to monitor which pages you find useful\n    and which you do not. A cookie in no way gives us access to your computer or any information about you,\n    other than the data you choose to share with us. You can choose to accept or decline cookies.\n    Most web browsers automatically accept cookies, but you can usually modify your browser setting\n    to decline cookies if you prefer. This may prevent you from taking full advantage of the website.\n</p>\n<h2>Links to other websites</h2>\n<p>\n    Our website may contain links to other websites of interest. However, once you have used these links\n    to leave our site, you should note that we do not have any control over that other website.\n    Therefore, we cannot be responsible for the protection and privacy of any information which you provide whilst\n    visiting such sites and such sites are not governed by this privacy statement.\n    You should exercise caution and look at the privacy statement applicable to the website in question.\n</p>\n<h2>Controlling your personal information</h2>\n<p>You may choose to restrict the collection or use of your personal information in the following ways:</p>\n<ul>\n    <li>\n        whenever you are asked to fill in a form on the website, look for the box that you can click to indicate\n        that you do not want the information to be used by anybody for direct marketing purposes\n    </li>\n    <li>\n        if you have previously agreed to us using your personal information for direct marketing purposes,\n        you may change your mind at any time by writing to or emailing us at\n        {{config path=\"trans_email/ident_general/email\"}}\n    </li>\n</ul>\n<p>\n    We will not sell, distribute or lease your personal information to third parties unless we have your permission\n    or are required by law to do so. We may use your personal information to send you promotional information\n    about third parties which we think you may find interesting if you tell us that you wish this to happen.\n</p>\n<p>\n    You may request details of personal information which we hold about you under the Data Protection Act 1998.\n    A small fee will be payable. If you would like a copy of the information held on you please write to\n    {{config path=\"general/store_information/address\"}}.\n</p>\n<p>\n    If you believe that any information we are holding on you is incorrect or incomplete,\n    please write to or email us as soon as possible, at the above address.\n    We will promptly correct any information found to be incorrect.\n</p>\n<h2><a name=\"list\"></a>List of cookies we collect</h2>\n<p>The table below lists the cookies we collect and what information they store.</p>\n<table class=\"data-table\">\n    <thead>\n        <tr>\n            <th>COOKIE name</th>\n            <th>COOKIE Description</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <th>CART</th>\n            <td>The association with your shopping cart.</td>\n        </tr>\n        <tr>\n            <th>CATEGORY_INFO</th>\n            <td>Stores the category info on the page, that allows to display pages more quickly.</td>\n        </tr>\n        <tr>\n            <th>COMPARE</th>\n            <td>The items that you have in the Compare Products list.</td>\n        </tr>\n        <tr>\n            <th>CURRENCY</th>\n            <td>Your preferred currency</td>\n        </tr>\n        <tr>\n            <th>CUSTOMER</th>\n            <td>An encrypted version of your customer id with the store.</td>\n        </tr>\n        <tr>\n            <th>CUSTOMER_AUTH</th>\n            <td>An indicator if you are currently logged into the store.</td>\n        </tr>\n        <tr>\n            <th>CUSTOMER_INFO</th>\n            <td>An encrypted version of the customer group you belong to.</td>\n        </tr>\n        <tr>\n            <th>CUSTOMER_SEGMENT_IDS</th>\n            <td>Stores the Customer Segment ID</td>\n        </tr>\n        <tr>\n            <th>EXTERNAL_NO_CACHE</th>\n            <td>A flag, which indicates whether caching is disabled or not.</td>\n        </tr>\n        <tr>\n            <th>FRONTEND</th>\n            <td>You sesssion ID on the server.</td>\n        </tr>\n        <tr>\n            <th>GUEST-VIEW</th>\n            <td>Allows guests to edit their orders.</td>\n        </tr>\n        <tr>\n            <th>LAST_CATEGORY</th>\n            <td>The last category you visited.</td>\n        </tr>\n        <tr>\n            <th>LAST_PRODUCT</th>\n            <td>The most recent product you have viewed.</td>\n        </tr>\n        <tr>\n            <th>NEWMESSAGE</th>\n            <td>Indicates whether a new message has been received.</td>\n        </tr>\n        <tr>\n            <th>NO_CACHE</th>\n            <td>Indicates whether it is allowed to use cache.</td>\n        </tr>\n        <tr>\n            <th>PERSISTENT_SHOPPING_CART</th>\n            <td>A link to information about your cart and viewing history if you have asked the site.</td>\n        </tr>\n        <tr>\n            <th>POLL</th>\n            <td>The ID of any polls you have recently voted in.</td>\n        </tr>\n        <tr>\n            <th>POLLN</th>\n            <td>Information on what polls you have voted on.</td>\n        </tr>\n        <tr>\n            <th>RECENTLYCOMPARED</th>\n            <td>The items that you have recently compared.            </td>\n        </tr>\n        <tr>\n            <th>STF</th>\n            <td>Information on products you have emailed to friends.</td>\n        </tr>\n        <tr>\n            <th>STORE</th>\n            <td>The store view or language you have selected.</td>\n        </tr>\n        <tr>\n            <th>USER_ALLOWED_SAVE_COOKIE</th>\n            <td>Indicates whether a customer allowed to use cookies.</td>\n        </tr>\n        <tr>\n            <th>VIEWED_PRODUCT_IDS</th>\n            <td>The products that you have recently viewed.</td>\n        </tr>\n        <tr>\n            <th>WISHLIST</th>\n            <td>An encrypted list of products added to your Wishlist.</td>\n        </tr>\n        <tr>\n            <th>WISHLIST_CNT</th>\n            <td>The number of items in your Wishlist.</td>\n        </tr>\n    </tbody>\n</table>','2012-05-16 18:43:29','2012-05-16 18:43:29',1,0,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cms_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_page_store`
--

DROP TABLE IF EXISTS `cms_page_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_page_store` (
  `page_id` smallint(6) NOT NULL COMMENT 'Page ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`page_id`,`store_id`),
  KEY `IDX_CMS_PAGE_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CMS_PAGE_STORE_PAGE_ID_CMS_PAGE_PAGE_ID` FOREIGN KEY (`page_id`) REFERENCES `cms_page` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CMS_PAGE_STORE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CMS Page To Store Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_page_store`
--

LOCK TABLES `cms_page_store` WRITE;
/*!40000 ALTER TABLE `cms_page_store` DISABLE KEYS */;
INSERT INTO `cms_page_store` VALUES (1,0),(2,0),(3,0),(4,0),(5,0),(26,0);
/*!40000 ALTER TABLE `cms_page_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_cache`
--

DROP TABLE IF EXISTS `core_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int(11) DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int(11) DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int(11) DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `IDX_CORE_CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_cache`
--

LOCK TABLES `core_cache` WRITE;
/*!40000 ALTER TABLE `core_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_cache_option`
--

DROP TABLE IF EXISTS `core_cache_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_cache_option` (
  `code` varchar(32) NOT NULL COMMENT 'Code',
  `value` smallint(6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache Options';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_cache_option`
--

LOCK TABLES `core_cache_option` WRITE;
/*!40000 ALTER TABLE `core_cache_option` DISABLE KEYS */;
INSERT INTO `core_cache_option` VALUES ('block_html',0),('collections',0),('config',0),('config_api',0),('config_api2',0),('eav',0),('layout',0),('translate',0);
/*!40000 ALTER TABLE `core_cache_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_cache_tag`
--

DROP TABLE IF EXISTS `core_cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `IDX_CORE_CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_cache_tag`
--

LOCK TABLES `core_cache_tag` WRITE;
/*!40000 ALTER TABLE `core_cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_config_data`
--

DROP TABLE IF EXISTS `core_config_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_config_data` (
  `config_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Config Id',
  `scope` varchar(8) NOT NULL DEFAULT 'default' COMMENT 'Config Scope',
  `scope_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Config Scope Id',
  `path` varchar(255) NOT NULL DEFAULT 'general' COMMENT 'Config Path',
  `value` text COMMENT 'Config Value',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `UNQ_CORE_CONFIG_DATA_SCOPE_SCOPE_ID_PATH` (`scope`,`scope_id`,`path`)
) ENGINE=InnoDB AUTO_INCREMENT=879 DEFAULT CHARSET=utf8 COMMENT='Config Data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_config_data`
--

LOCK TABLES `core_config_data` WRITE;
/*!40000 ALTER TABLE `core_config_data` DISABLE KEYS */;
INSERT INTO `core_config_data` VALUES (1,'default',0,'web/seo/use_rewrites','1'),(2,'default',0,'admin/dashboard/enable_charts','0'),(6,'default',0,'general/locale/timezone','America/Los_Angeles'),(10,'default',0,'catalog/category/root_id','2'),(13,'default',0,'design/head/default_title',NULL),(14,'default',0,'design/head/title_prefix',NULL),(15,'default',0,'design/head/title_suffix',NULL),(16,'default',0,'design/head/default_description',NULL),(17,'default',0,'design/head/default_keywords',NULL),(18,'default',0,'design/header/welcome','Welcome to  Grayscale Full-width Free Magento Template'),(19,'default',0,'design/footer/copyright','&copy; Grayscale Full-width Free Magento Template. '),(20,'default',0,'design/footer/absolute_footer',NULL),(21,'default',0,'web/url/use_store','0'),(22,'default',0,'web/url/redirect_to_base','0'),(23,'default',0,'advanced/modules_disable_output/Mage_Newsletter','0'),(24,'default',0,'advanced/modules_disable_output/Mage_Poll','0'),(25,'default',0,'catalog/seo/product_use_categories','0'),(26,'default',0,'catalog/seo/category_canonical_tag','1'),(27,'default',0,'catalog/seo/product_canonical_tag','1'),(28,'default',0,'cataloginventory/options/show_out_of_stock','1'),(56,'default',0,'system/adminnotification/use_https','0'),(57,'default',0,'system/adminnotification/frequency','24'),(58,'default',0,'general/locale/code','en_US'),(59,'default',0,'currency/options/base','USD'),(60,'default',0,'currency/options/default','USD'),(61,'default',0,'currency/options/allow','EUR,USD'),(64,'default',0,'awall/install/run','1320558318'),(65,'default',0,'design/package/name','default'),(66,'default',0,'design/package/ua_regexp','a:0:{}'),(67,'default',0,'design/theme/locale','grayscale'),(68,'default',0,'design/theme/template','grayscale'),(69,'default',0,'design/theme/template_ua_regexp','a:0:{}'),(70,'default',0,'design/theme/skin','grayscale'),(71,'default',0,'design/theme/skin_ua_regexp','a:0:{}'),(72,'default',0,'design/theme/layout','grayscale'),(73,'default',0,'design/theme/layout_ua_regexp','a:0:{}'),(74,'default',0,'design/theme/default',NULL),(75,'default',0,'design/theme/default_ua_regexp','a:0:{}'),(76,'default',0,'design/head/default_robots','INDEX,FOLLOW'),(77,'default',0,'design/head/includes','<script type=\"text/javascript\">\r\n    var switchTo5x=true; \r\n    var __st_loadLate=true;\r\n</script>\r\n<script type=\"text/javascript\" src=\"http://w.sharethis.com/button/buttons.js\"></script>\r\n<script type=\"text/javascript\">\r\n    stLight.options({publisher:\'611af2c6-efd2-4147-ae93-87f40641bdd9\'});\r\n</script>\r\n\r\n<script type=\"text/javascript\">\r\n    var _gaq = _gaq || [];\r\n    _gaq.push([\'_setAccount\', \'UA-6063824-5\']);\r\n    _gaq.push([\'_trackPageview\']);    \r\n    (function() {\r\n        var ga = document.createElement(\'script\'); \r\n        ga.type = \'text/javascript\';\r\n        ga.async = true;\r\n        ga.src = (\'https:\' == document.location.protocol ? \'https://ssl\' : \'http://www\') + \'.google-analytics.com/ga.js\';\r\n        var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(ga, s);\r\n    })();\r\n</script>'),(78,'default',0,'design/head/demonotice','0'),(79,'default',0,'design/header/logo_src','images/logo.gif'),(80,'default',0,'design/header/logo_alt','Grayscale Full-width Free Magento Template'),(81,'default',0,'design/watermark/image_size',NULL),(82,'default',0,'design/watermark/image_imageOpacity',NULL),(83,'default',0,'design/watermark/image_position','stretch'),(84,'default',0,'design/watermark/small_image_size',NULL),(85,'default',0,'design/watermark/small_image_imageOpacity',NULL),(86,'default',0,'design/watermark/small_image_position','stretch'),(87,'default',0,'design/watermark/thumbnail_size',NULL),(88,'default',0,'design/watermark/thumbnail_imageOpacity',NULL),(89,'default',0,'design/watermark/thumbnail_position','stretch'),(90,'default',0,'design/pagination/pagination_frame','5'),(91,'default',0,'design/pagination/pagination_frame_skip',NULL),(92,'default',0,'design/pagination/anchor_text_for_previous',NULL),(93,'default',0,'design/pagination/anchor_text_for_next',NULL),(118,'default',0,'onepage_checkout/general/guest_checkout','1'),(119,'default',0,'onepage_checkout/origin_shipping_settings/country_id','US'),(120,'default',0,'onepage_checkout/origin_shipping_settings/region_id','12'),(121,'default',0,'onepage_checkout/origin_shipping_settings/postcode','90034'),(122,'default',0,'onepage_checkout/gift_options/allow_order','1'),(123,'default',0,'onepage_checkout/gift_options/allow_items','1'),(124,'default',0,'advanced/modules_disable_output/AW_All','0'),(125,'default',0,'advanced/modules_disable_output/AW_Blog','0'),(126,'default',0,'advanced/modules_disable_output/EM_Quickshop','0'),(127,'default',0,'advanced/modules_disable_output/HM_DeveloperToolbar','0'),(128,'default',0,'advanced/modules_disable_output/HM_QuickContact','0'),(129,'default',0,'advanced/modules_disable_output/Mage_Admin','0'),(130,'default',0,'advanced/modules_disable_output/Mage_AdminNotification','0'),(131,'default',0,'advanced/modules_disable_output/Mage_Api','0'),(132,'default',0,'advanced/modules_disable_output/Mage_Authorizenet','0'),(133,'default',0,'advanced/modules_disable_output/Mage_Backup','0'),(134,'default',0,'advanced/modules_disable_output/Mage_Bundle','0'),(135,'default',0,'advanced/modules_disable_output/Mage_Catalog','0'),(136,'default',0,'advanced/modules_disable_output/Mage_CatalogIndex','0'),(137,'default',0,'advanced/modules_disable_output/Mage_CatalogInventory','0'),(138,'default',0,'advanced/modules_disable_output/Mage_CatalogRule','0'),(139,'default',0,'advanced/modules_disable_output/Mage_CatalogSearch','0'),(140,'default',0,'advanced/modules_disable_output/Mage_Centinel','0'),(141,'default',0,'advanced/modules_disable_output/Mage_Checkout','0'),(142,'default',0,'advanced/modules_disable_output/Mage_Cms','0'),(143,'default',0,'advanced/modules_disable_output/Mage_Compiler','0'),(144,'default',0,'advanced/modules_disable_output/Mage_Connect','0'),(145,'default',0,'advanced/modules_disable_output/Mage_Contacts','0'),(146,'default',0,'advanced/modules_disable_output/Mage_Core','0'),(147,'default',0,'advanced/modules_disable_output/Mage_Cron','0'),(148,'default',0,'advanced/modules_disable_output/Mage_Customer','0'),(149,'default',0,'advanced/modules_disable_output/Mage_Dataflow','0'),(150,'default',0,'advanced/modules_disable_output/Mage_Directory','0'),(151,'default',0,'advanced/modules_disable_output/Mage_Downloadable','0'),(152,'default',0,'advanced/modules_disable_output/Mage_Eav','0'),(153,'default',0,'advanced/modules_disable_output/Mage_GiftMessage','0'),(154,'default',0,'advanced/modules_disable_output/Mage_GoogleAnalytics','0'),(155,'default',0,'advanced/modules_disable_output/Mage_GoogleCheckout','0'),(156,'default',0,'advanced/modules_disable_output/Mage_ImportExport','0'),(157,'default',0,'advanced/modules_disable_output/Mage_Index','0'),(158,'default',0,'advanced/modules_disable_output/Mage_Install','0'),(159,'default',0,'advanced/modules_disable_output/Mage_Log','0'),(160,'default',0,'advanced/modules_disable_output/Mage_Media','0'),(161,'default',0,'advanced/modules_disable_output/Mage_Page','0'),(162,'default',0,'advanced/modules_disable_output/Mage_PageCache','0'),(163,'default',0,'advanced/modules_disable_output/Mage_Paygate','0'),(164,'default',0,'advanced/modules_disable_output/Mage_Payment','0'),(165,'default',0,'advanced/modules_disable_output/Mage_Paypal','0'),(166,'default',0,'advanced/modules_disable_output/Mage_PaypalUk','0'),(167,'default',0,'advanced/modules_disable_output/Mage_Persistent','0'),(168,'default',0,'advanced/modules_disable_output/Mage_ProductAlert','0'),(169,'default',0,'advanced/modules_disable_output/Mage_Rating','0'),(170,'default',0,'advanced/modules_disable_output/Mage_Reports','0'),(171,'default',0,'advanced/modules_disable_output/Mage_Review','0'),(172,'default',0,'advanced/modules_disable_output/Mage_Rss','0'),(173,'default',0,'advanced/modules_disable_output/Mage_Rule','0'),(174,'default',0,'advanced/modules_disable_output/Mage_Sales','0'),(175,'default',0,'advanced/modules_disable_output/Mage_SalesRule','0'),(176,'default',0,'advanced/modules_disable_output/Mage_Sendfriend','0'),(177,'default',0,'advanced/modules_disable_output/Mage_Shipping','0'),(178,'default',0,'advanced/modules_disable_output/Mage_Sitemap','0'),(179,'default',0,'advanced/modules_disable_output/Mage_Tag','0'),(180,'default',0,'advanced/modules_disable_output/Mage_Tax','0'),(181,'default',0,'advanced/modules_disable_output/Mage_Usa','0'),(182,'default',0,'advanced/modules_disable_output/Mage_Weee','0'),(183,'default',0,'advanced/modules_disable_output/Mage_Widget','0'),(184,'default',0,'advanced/modules_disable_output/Mage_Wishlist','0'),(185,'default',0,'advanced/modules_disable_output/Mage_XmlConnect','0'),(186,'default',0,'advanced/modules_disable_output/Phoenix_Moneybookers','0'),(187,'default',0,'advanced/modules_disable_output/Rissip_UIOptimization','0'),(188,'default',0,'advanced/modules_disable_output/TBT_Enhancedgrid','0'),(189,'default',0,'advanced/modules_disable_output/TM_EasyLightbox','0'),(190,'default',0,'advanced/modules_disable_output/TM_EasyTabs','0'),(191,'default',0,'advanced/modules_disable_output/WP_AdminNotificationsDisable','0'),(192,'default',0,'advanced/modules_disable_output/WP_AdvancedSlider','0'),(193,'default',0,'advanced/modules_disable_output/WP_AjaxShippingPriceCalculator','0'),(194,'default',0,'advanced/modules_disable_output/WP_Amazonimportproducts','0'),(195,'default',0,'advanced/modules_disable_output/WP_CustomMenu','0'),(196,'default',0,'advanced/modules_disable_output/WP_OnePageCheckout','0'),(197,'default',0,'advanced/modules_disable_output/WP_ThemeLightshopGreen','0'),(240,'default',0,'admin/emails/forgot_email_template','admin_emails_forgot_email_template'),(241,'default',0,'admin/emails/forgot_email_identity','general'),(242,'default',0,'admin/emails/password_reset_link_expiration_period','3'),(243,'default',0,'admin/startup/page','dashboard'),(244,'default',0,'admin/url/use_custom','0'),(245,'default',0,'admin/url/use_custom_path','0'),(246,'default',0,'admin/security/use_form_key','1'),(247,'default',0,'admin/security/use_case_sensitive_login','0'),(248,'default',0,'admin/security/session_cookie_lifetime','172800'),(249,'default',0,'easy_tabs/general/enabled','1'),(250,'default',0,'easy_tabs/general/descriptiontabbed','1'),(251,'default',0,'easy_tabs/general/additionaltabbed','1'),(252,'default',0,'easy_tabs/general/upsellproductstabbed','1'),(253,'default',0,'easy_tabs/general/relatedtabbed','0'),(254,'default',0,'easy_tabs/general/tagstabbed','1'),(255,'default',0,'easy_tabs/general/reviewtabbed','1'),(256,'default',0,'easy_tabs/custom/customtab','0'),(257,'default',0,'easy_tabs/custom/customtabid',NULL),(258,'default',0,'easy_tabs/custom/customtabname',NULL),(259,'default',0,'easy_tabs/custom/customtab1','0'),(260,'default',0,'easy_tabs/custom/customtabid1',NULL),(261,'default',0,'easy_tabs/custom/customtabname1',NULL),(262,'default',0,'easy_tabs/custom/customtab2','0'),(263,'default',0,'easy_tabs/custom/customtabid2',NULL),(264,'default',0,'easy_tabs/custom/customtabname2',NULL),(265,'default',0,'easy_tabs/custom/customtab3','0'),(266,'default',0,'easy_tabs/custom/customtabid3',NULL),(267,'default',0,'easy_tabs/custom/customtabname3',NULL),(268,'default',0,'easy_tabs/custom/customtab4','0'),(269,'default',0,'easy_tabs/custom/customtabid4',NULL),(270,'default',0,'easy_tabs/custom/customtabname4',NULL),(271,'default',0,'easy_tabs/customcms/tabcms','0'),(272,'default',0,'easy_tabs/customcms/tabidcms',NULL),(273,'default',0,'easy_tabs/customcms/tabnamecms',NULL),(274,'default',0,'easy_tabs/customcms/tabcms1','0'),(275,'default',0,'easy_tabs/customcms/tabidcms1',NULL),(276,'default',0,'easy_tabs/customcms/tabnamecms1',NULL),(277,'default',0,'easy_tabs/customcms/tabcms2','0'),(278,'default',0,'easy_tabs/customcms/tabidcms2',NULL),(279,'default',0,'easy_tabs/customcms/tabnamecms2',NULL),(280,'default',0,'easy_tabs/customcms/tabcms3','0'),(281,'default',0,'easy_tabs/customcms/tabidcms3',NULL),(282,'default',0,'easy_tabs/customcms/tabnamecms3',NULL),(283,'default',0,'easy_tabs/customcms/tabcms4','0'),(284,'default',0,'easy_tabs/customcms/tabidcms4',NULL),(285,'default',0,'easy_tabs/customcms/tabnamecms4',NULL),(286,'default',0,'quickshop/general/size_type','0'),(287,'default',0,'quickshop/general/frame_width','70'),(288,'default',0,'quickshop/general/frame_height','70'),(289,'default',0,'wp_ajaxshippingpricecalculator/general/enabled','0'),(290,'default',0,'wp_ajaxshippingpricecalculator/general/popup_link','1'),(291,'default',0,'wp_ajaxshippingpricecalculator/general/block_position','short_description'),(292,'default',0,'wp_ajaxshippingpricecalculator/general/use_country','1'),(293,'default',0,'wp_ajaxshippingpricecalculator/general/use_region','1'),(294,'default',0,'wp_ajaxshippingpricecalculator/general/use_city','1'),(295,'default',0,'wp_ajaxshippingpricecalculator/general/use_postcode','1'),(296,'default',0,'wp_ajaxshippingpricecalculator/general/use_coupon_code','1'),(297,'default',0,'wp_ajaxshippingpricecalculator/general/use_cart','1'),(298,'default',0,'wp_ajaxshippingpricecalculator/general/use_cart_default','1'),(299,'default',0,'onepage_checkout/general/enabled','0'),(300,'default',0,'onepage_checkout/general/ie6_ignore','1'),(301,'default',0,'onepage_checkout/general/enable_agreements','1'),(302,'default',0,'onepage_checkout/general/update_total_after_payment','0'),(303,'default',0,'onepage_checkout/origin_shipping_settings/city',NULL),(304,'default',0,'checkout/options/guest_checkout','1'),(305,'default',0,'checkout/options/enable_agreements','1'),(306,'default',0,'shipping/origin/country_id','US'),(307,'default',0,'shipping/origin/region_id','12'),(308,'default',0,'shipping/origin/postcode','90034'),(309,'default',0,'sales/gift_options/allow_order','1'),(310,'default',0,'sales/gift_options/allow_items','1'),(311,'default',0,'sales/gift_messages/allow_order','0'),(312,'default',0,'sales/gift_messages/allow_items','0'),(314,'default',0,'custom_menu/general/enabled','1'),(315,'default',0,'custom_menu/general/max_level','4'),(316,'default',0,'custom_menu/general/show_home_link','1'),(317,'default',0,'custom_menu/general/non_breaking_space','0'),(318,'default',0,'custom_menu/general/ie6_ignore','1'),(319,'default',0,'custom_menu/columns/count','4'),(320,'default',0,'custom_menu/columns/integrate','0'),(321,'default',0,'custom_menu/popup/width','0'),(322,'default',0,'custom_menu/popup/top_offset','0'),(323,'default',0,'custom_menu/popup/right_offset_min','0'),(324,'default',0,'catalog/frontend/list_mode','grid-list'),(325,'default',0,'catalog/frontend/grid_per_page_values','15,30'),(326,'default',0,'catalog/frontend/grid_per_page','15'),(327,'default',0,'catalog/frontend/list_per_page_values','5,10,15,20,25'),(328,'default',0,'catalog/frontend/list_per_page','10'),(329,'default',0,'catalog/frontend/list_allow_all','0'),(330,'default',0,'catalog/frontend/default_sort_by','position'),(331,'default',0,'catalog/frontend/flat_catalog_category','0'),(332,'default',0,'catalog/frontend/flat_catalog_product','0'),(333,'default',0,'catalog/frontend/parse_url_directives','1'),(334,'default',0,'catalog/sitemap/tree_mode','0'),(335,'default',0,'catalog/sitemap/lines_perpage','30'),(336,'default',0,'catalog/review/allow_guest','1'),(337,'default',0,'catalog/productalert/allow_price','0'),(338,'default',0,'catalog/productalert/email_price_template','catalog_productalert_email_price_template'),(339,'default',0,'catalog/productalert/allow_stock','0'),(340,'default',0,'catalog/productalert/email_stock_template','catalog_productalert_email_stock_template'),(341,'default',0,'catalog/productalert/email_identity','general'),(342,'default',0,'catalog/productalert_cron/frequency','D'),(343,'default',0,'crontab/jobs/catalog_product_alert/schedule/cron_expr','0 0 * * *'),(344,'default',0,'crontab/jobs/catalog_product_alert/run/model','productalert/observer::process'),(345,'default',0,'catalog/productalert_cron/time','00,00,00'),(346,'default',0,'catalog/productalert_cron/error_email',NULL),(347,'default',0,'catalog/productalert_cron/error_email_identity','general'),(348,'default',0,'catalog/productalert_cron/error_email_template','catalog_productalert_cron_error_email_template'),(349,'default',0,'catalog/recently_products/scope','website'),(350,'default',0,'catalog/recently_products/viewed_count','5'),(351,'default',0,'catalog/recently_products/compared_count','5'),(352,'default',0,'catalog/price/scope','0'),(353,'default',0,'catalog/layered_navigation/price_range_calculation','auto'),(354,'default',0,'catalog/navigation/max_depth','0'),(355,'default',0,'catalog/seo/site_map','1'),(356,'default',0,'catalog/seo/search_terms','1'),(357,'default',0,'catalog/seo/product_url_suffix','.html'),(358,'default',0,'catalog/seo/category_url_suffix','.html'),(359,'default',0,'catalog/seo/save_rewrites_history','1'),(360,'default',0,'catalog/seo/title_separator','-'),(361,'default',0,'catalog/search/min_query_length','1'),(362,'default',0,'catalog/search/max_query_length','128'),(363,'default',0,'catalog/search/max_query_words','10'),(364,'default',0,'catalog/search/search_type','1'),(365,'default',0,'catalog/search/use_layered_navigation_count','2000'),(366,'default',0,'catalog/downloadable/order_item_status','9'),(367,'default',0,'catalog/downloadable/downloads_number','0'),(368,'default',0,'catalog/downloadable/shareable','0'),(369,'default',0,'catalog/downloadable/samples_title','Samples'),(370,'default',0,'catalog/downloadable/links_title','Links'),(371,'default',0,'catalog/downloadable/links_target_new_window','1'),(372,'default',0,'catalog/downloadable/content_disposition','inline'),(373,'default',0,'catalog/downloadable/disable_guest_checkout','1'),(374,'default',0,'catalog/custom_options/use_calendar','0'),(375,'default',0,'catalog/custom_options/date_fields_order','m,d,y'),(376,'default',0,'catalog/custom_options/time_format','12h'),(377,'default',0,'catalog/custom_options/year_range',','),(382,'default',0,'blog/blog/enabled','1'),(383,'default',0,'blog/blog/title','Blog'),(384,'default',0,'blog/blog/route',NULL),(385,'default',0,'blog/blog/layout','page/3columns.phtml'),(386,'default',0,'blog/blog/dateformat','short'),(387,'default',0,'blog/blog/blogcrumbs','1'),(388,'default',0,'blog/blog/readmore',NULL),(389,'default',0,'blog/blog/useshortcontent','1'),(390,'default',0,'blog/blog/parse_cms','0'),(391,'default',0,'blog/blog/perpage',NULL),(392,'default',0,'blog/blog/categories_urls','1'),(393,'default',0,'blog/blog/bookmarkslist','0'),(394,'default',0,'blog/blog/bookmarkspost','0'),(395,'default',0,'blog/menu/left','0'),(396,'default',0,'blog/menu/right','1'),(397,'default',0,'blog/menu/footer','1'),(398,'default',0,'blog/menu/top','0'),(399,'default',0,'blog/menu/recent','3'),(400,'default',0,'blog/menu/category','1'),(401,'default',0,'blog/menu/tagcloud_size','10'),(402,'default',0,'blog/comments/enabled','0'),(403,'default',0,'blog/comments/login','0'),(404,'default',0,'blog/comments/approval','0'),(405,'default',0,'blog/comments/loginauto','0'),(406,'default',0,'blog/comments/recipient_email',NULL),(407,'default',0,'blog/comments/sender_email_identity','general'),(408,'default',0,'blog/comments/email_template','blog_comments_email_template'),(409,'default',0,'blog/recaptcha/enabled','0'),(410,'default',0,'blog/recaptcha/publickey',NULL),(411,'default',0,'blog/recaptcha/privatekey',NULL),(412,'default',0,'blog/rss/enable','0'),(413,'default',0,'blog/rss/image',NULL),(414,'default',0,'blog/rss/posts',NULL),(416,'default',0,'cms/wysiwyg/enabled','hidden'),(417,'default',0,'cms/wysiwyg/use_static_urls_in_catalog','0'),(418,'default',0,'general/region/display_all','1'),(419,'default',0,'general/region/state_required','AT,CA,CH,DE,EE,ES,FI,FR,LT,LV,RO,US'),(420,'default',0,'easy_lightbox/general/enabled','0'),(421,'default',0,'easy_lightbox/general/defaulzoom','0'),(422,'default',0,'easy_lightbox/general/mainImageSize','317_317'),(423,'default',0,'easy_lightbox/general/popupImageSize','500_500'),(424,'default',0,'easy_lightbox/general/additionalImageSize','60_60'),(425,'default',0,'easy_lightbox/general/productName','0'),(426,'default',0,'easy_lightbox/general/animate','1'),(427,'default',0,'easy_lightbox/general/overlayOpacity','0.8'),(428,'default',0,'easy_lightbox/general/resizeSpeed','7'),(429,'default',0,'easy_lightbox/general/borderSize','10'),(430,'default',0,'easy_lightbox/general/labelImage','Image'),(431,'default',0,'easy_lightbox/general/labelOf','of'),(432,'default',0,'onepage_checkout/general/enable_discount','1'),(433,'default',0,'onepage_checkout/general/enable_different_shipping','1'),(434,'default',0,'onepage_checkout/general/clear_different_shipping','0'),(435,'default',0,'onepage_checkout/origin_shipping_settings/street_line1',NULL),(436,'default',0,'onepage_checkout/origin_shipping_settings/telephone',NULL),(437,'default',0,'onepage_checkout/fields_settings/country','1'),(438,'default',0,'onepage_checkout/fields_settings/region','1'),(439,'default',0,'onepage_checkout/fields_settings/postcode','1'),(440,'default',0,'onepage_checkout/fields_settings/city','1'),(441,'default',0,'onepage_checkout/fields_settings/street_line1','1'),(442,'default',0,'onepage_checkout/fields_settings/telephone','1'),(443,'default',0,'onepage_checkout/fields_settings/fax','opt'),(444,'default',0,'onepage_checkout/fields_settings/company','opt'),(445,'default',0,'shipping/origin/city',NULL),(446,'default',0,'shipping/origin/street_line1',NULL),(447,'default',0,'hide_backend_notifications/general/enabled','1'),(448,'default',0,'hide_backend_notifications/general/only_popup','1'),(449,'default',0,'advanced/modules_disable_output/Mage_Api2','0'),(450,'default',0,'advanced/modules_disable_output/Mage_Captcha','0'),(451,'default',0,'advanced/modules_disable_output/Mage_CurrencySymbol','0'),(452,'default',0,'advanced/modules_disable_output/Mage_Oauth','0'),(453,'default',0,'advanced/modules_disable_output/WP_HideBackendNotifications','0'),(454,'default',0,'advanced/modules_disable_output/WP_Quickshopaddtocomparefix','0'),(455,'default',0,'design/email/logo_alt',NULL),(492,'default',0,'dev/restrict/allow_ips',NULL),(493,'default',0,'dev/debug/profiler','0'),(494,'default',0,'dev/template/allow_symlink','0'),(495,'default',0,'dev/translate_inline/active','0'),(496,'default',0,'dev/translate_inline/active_admin','0'),(497,'default',0,'dev/log/active','1'),(498,'default',0,'dev/log/file','system.log'),(499,'default',0,'dev/log/exception_file','exception.log'),(500,'default',0,'dev/js/merge_files','0'),(501,'default',0,'dev/css/merge_css_files','0'),(502,'default',0,'custom_menu/general/display_empty_categories','1'),(503,'default',0,'custom_menu/popup/delay_displaying','150'),(504,'default',0,'custom_menu/popup/delay_hiding','100'),(505,'default',0,'custom_menu/columns/divided_horizontally','1'),(506,'default',0,'wp_stylish_store_switcher/general/enabled','0'),(507,'default',0,'wp_stylish_store_switcher/general/use_flags','1'),(508,'default',0,'wp_stylish_store_switcher/general/show_label','0'),(509,'default',0,'custom_menu/general/rtl','0'),(512,'stores',5,'general/locale/code','de_DE'),(513,'stores',5,'custom_menu/general/rtl','1'),(514,'stores',1,'custom_menu/general/rtl','0'),(527,'default',0,'advanced/modules_disable_output/WP_BackToTopButton','0'),(528,'default',0,'advanced/modules_disable_output/WP_StylishStoreSwitcher','0'),(538,'default',0,'onepage_checkout/general/create_account_checked','0'),(539,'default',0,'onepage_checkout/general/shipping_disabled','0'),(540,'default',0,'onepage_checkout/fields_settings/comments','1'),(541,'default',0,'onepage_checkout/newsletter_subscription/enabled','1'),(542,'default',0,'onepage_checkout/newsletter_subscription/checked','0'),(543,'default',0,'onepage_checkout/newsletter_subscription/visibility','all'),(544,'default',0,'currency/webservicex/timeout','100'),(545,'default',0,'currency/import/enabled','0'),(546,'default',0,'currency/import/service','webservicex'),(547,'default',0,'crontab/jobs/currency_rates_update/schedule/cron_expr','0 0 * * *'),(548,'default',0,'currency/import/time','00,00,00'),(549,'default',0,'currency/import/frequency','D'),(550,'default',0,'currency/import/error_email',NULL),(551,'default',0,'currency/import/error_email_identity','general'),(552,'default',0,'currency/import/error_email_template','currency_import_error_email_template'),(553,'default',0,'catalog/layered_navigation/display_product_count','1'),(554,'default',0,'catalog/vertnav/hide_vertnav','1'),(555,'default',0,'catalog/vertnav/hide_top','0'),(556,'default',0,'catalog/vertnav/display_product_count','0'),(557,'default',0,'catalog/vertnav/show_cat_on_toplevel','0'),(558,'default',0,'catalog/vertnav/expand_all','0'),(559,'default',0,'catalog/vertnav/expand_all_max_depth','0'),(560,'default',0,'catalog/vertnav/vertnav_root','root'),(561,'default',0,'catalog/vertnav/fallback_to_root','1'),(568,'default',0,'quickcontact/email/dock_link','0'),(569,'default',0,'advanced/modules_disable_output/IG_LightBox2','0'),(570,'default',0,'advanced/modules_disable_output/RicoNeitzel_VertNav','0'),(571,'default',0,'advanced/modules_disable_output/TPSS_Captcha','0'),(572,'default',0,'advanced/modules_disable_output/WP_AboutWebandpeople','0'),(573,'default',0,'advanced/modules_disable_output/WP_AdvancedSliderAddonExportImport','0'),(574,'default',0,'advanced/modules_disable_output/WP_SmartCatalog','0'),(614,'default',0,'web/unsecure/base_url','http://server.webandpeople.com:929/'),(615,'default',0,'web/secure/base_url','http://server.webandpeople.com:929/'),(621,'default',0,'backtotopbutton/general/enabled','1'),(622,'default',0,'backtotopbutton/general/disabled_by_regexp','a:0:{}'),(623,'default',0,'backtotopbutton/general/include_jquery','1'),(624,'default',0,'backtotopbutton/general/include_waypoints','1'),(625,'default',0,'custom_menu/general/ajax_load_content','0'),(626,'default',0,'custom_menu/general/move_code_to_bottom','0'),(627,'default',0,'custom_menu/general/mobile_menu','1'),(628,'default',0,'smart_product_image/general/enabled','1'),(629,'default',0,'smart_product_image/general/image_sizes','a:5:{s:18:\"_1389676571922_922\";a:1:{s:11:\"image_width\";s:3:\"200\";}s:18:\"_1389676617392_392\";a:1:{s:11:\"image_width\";s:3:\"300\";}s:18:\"_1389676634755_755\";a:1:{s:11:\"image_width\";s:3:\"400\";}s:18:\"_1389676637516_516\";a:1:{s:11:\"image_width\";s:3:\"480\";}s:17:\"_1389676644053_53\";a:1:{s:11:\"image_width\";s:3:\"600\";}}'),(630,'default',0,'onepage_checkout/general/disabled_by_regexp','a:0:{}'),(631,'default',0,'onepage_checkout/layout/type','3columns'),(632,'default',0,'onepage_checkout/layout/enable_discount','1'),(633,'default',0,'onepage_checkout/layout/shipping_disabled','0'),(634,'default',0,'onepage_checkout/layout/enable_different_shipping','1'),(635,'default',0,'onepage_checkout/layout/clear_different_shipping','0'),(636,'default',0,'onepage_checkout/polls/enabled','1'),(637,'default',0,'onepage_checkout/polls/visibility','all'),(638,'default',0,'onepage_checkout/polls/items','a:1:{s:18:\"_1401992973269_269\";a:2:{s:4:\"poll\";s:1:\"1\";s:9:\"poll_type\";s:5:\"radio\";}}'),(639,'default',0,'onepage_checkout/polls/intro',NULL),(640,'default',0,'checkout/options/customer_must_be_logged','1'),(641,'default',0,'smart_catalog/general/enabled','1'),(642,'default',0,'smart_catalog/general/image_width','135'),(643,'default',0,'smart_catalog/general/image_height','135'),(644,'default',0,'smart_catalog/general/column_width','150'),(645,'default',0,'smart_catalog/general/display_short_desc','1'),(646,'default',0,'smart_catalog/include_jquery_files/include_jquery','1'),(647,'default',0,'smart_catalog/include_jquery_files/include_debouncedresize','1'),(648,'default',0,'demo_menu/general/enabled','0'),(649,'default',0,'demo_menu/general/demo_personal_html','<li><a class=\"buy_th\" title=\"Buy this Magento Theme\" href=\"https://www.plimus.com/jsp/buynow.jsp?contractId=2929798\">Buy this theme</a></li>\r\n<li class=\"bar_bt\"> </li>'),(650,'default',0,'custom_menu/general/position','top'),(651,'default',0,'custom_menu/general/sibebar_draw_max_level','1'),(652,'default',0,'custom_menu/general/topmenu_static_block',NULL),(653,'default',0,'custom_menu/popup/sb_width','300'),(654,'default',0,'custom_menu/popup/sb_height','0'),(655,'default',0,'custom_menu/popup/sb_bottom_offset','0'),(656,'default',0,'paypal/general/merchant_country','US'),(657,'default',0,'payment/payflow_advanced/partner','PayPal'),(658,'default',0,'payment/payflow_advanced/vendor','PayPal'),(659,'default',0,'payment/payflow_advanced/user','PayPal'),(660,'default',0,'payment/payflow_advanced/pwd',NULL),(661,'default',0,'payment/payflow_advanced/sandbox_flag','0'),(662,'default',0,'payment/payflow_advanced/use_proxy','0'),(663,'default',0,'paypal/general/business_account','y.gerassimenko@gmail.com'),(664,'default',0,'paypal/wpp/api_authentication','0'),(665,'default',0,'paypal/wpp/api_username','cVaKAZdXNec='),(666,'default',0,'paypal/wpp/api_password','cVaKAZdXNec='),(667,'default',0,'paypal/wpp/api_signature','cVaKAZdXNec='),(668,'default',0,'paypal/wpp/sandbox_flag','0'),(669,'default',0,'paypal/wpp/use_proxy','0'),(670,'default',0,'payment/payflow_advanced/active','0'),(671,'default',0,'payment/payflow_advanced/title','Credit Card'),(672,'default',0,'payment/payflow_advanced/sort_order',NULL),(673,'default',0,'payment/payflow_advanced/payment_action','Authorization'),(674,'default',0,'payment/payflow_advanced/allowspecific','0'),(675,'default',0,'payment/payflow_advanced/debug','0'),(676,'default',0,'payment/payflow_advanced/verify_peer','1'),(677,'default',0,'payment/payflow_advanced/csc_editable','1'),(678,'default',0,'payment/payflow_advanced/csc_required','1'),(679,'default',0,'payment/payflow_advanced/email_confirmation','0'),(680,'default',0,'payment/payflow_advanced/url_method','GET'),(681,'default',0,'payment/paypal_billing_agreement/active','1'),(682,'default',0,'payment/paypal_billing_agreement/title','PayPal Billing Agreement'),(683,'default',0,'payment/paypal_billing_agreement/sort_order',NULL),(684,'default',0,'payment/paypal_billing_agreement/payment_action','Authorization'),(685,'default',0,'payment/paypal_billing_agreement/allowspecific','0'),(686,'default',0,'payment/paypal_billing_agreement/debug','0'),(687,'default',0,'payment/paypal_billing_agreement/verify_peer','1'),(688,'default',0,'payment/paypal_billing_agreement/line_items_enabled','0'),(689,'default',0,'payment/paypal_billing_agreement/allow_billing_agreement_wizard','1'),(690,'default',0,'paypal/fetch_reports/ftp_login',NULL),(691,'default',0,'paypal/fetch_reports/ftp_password',NULL),(692,'default',0,'paypal/fetch_reports/ftp_sandbox','0'),(693,'default',0,'paypal/fetch_reports/ftp_ip',NULL),(694,'default',0,'paypal/fetch_reports/ftp_path',NULL),(695,'default',0,'paypal/fetch_reports/active','0'),(696,'default',0,'paypal/fetch_reports/schedule','1'),(697,'default',0,'paypal/fetch_reports/time','00,00,00'),(698,'default',0,'paypal/style/logo','nowAccepting_150x60'),(699,'default',0,'paypal/style/page_style',NULL),(700,'default',0,'paypal/style/paypal_hdrimg',NULL),(701,'default',0,'paypal/style/paypal_hdrbackcolor',NULL),(702,'default',0,'paypal/style/paypal_hdrbordercolor',NULL),(703,'default',0,'paypal/style/paypal_payflowcolor',NULL),(704,'default',0,'payment/paypal_express/title','PayPal Express Checkout'),(705,'default',0,'payment/paypal_express/sort_order',NULL),(706,'default',0,'payment/paypal_express/payment_action','Authorization'),(707,'default',0,'payment/paypal_express/visible_on_cart','1'),(708,'default',0,'payment/paypal_express/visible_on_product','1'),(709,'default',0,'payment/paypal_express/allowspecific','0'),(710,'default',0,'payment/paypal_express/debug','0'),(711,'default',0,'payment/paypal_express/verify_peer','1'),(712,'default',0,'payment/paypal_express/line_items_enabled','1'),(713,'default',0,'payment/paypal_express/transfer_shipping_options','0'),(714,'default',0,'paypal/wpp/button_flavor','dynamic'),(715,'default',0,'payment/paypal_express/solution_type','Mark'),(716,'default',0,'payment/paypal_express/require_billing_address','0'),(717,'default',0,'payment/paypal_express/allow_ba_signup','never'),(718,'default',0,'payment/paypal_direct/active','0'),(719,'default',0,'payment/paypal_direct/title','PayPal Payments Pro'),(720,'default',0,'payment/paypal_direct/sort_order',NULL),(721,'default',0,'payment/paypal_direct/payment_action','Authorization'),(722,'default',0,'payment/paypal_direct/cctypes','VI,MC'),(723,'default',0,'payment/paypal_direct/allowspecific','0'),(724,'default',0,'payment/paypal_direct/debug','0'),(725,'default',0,'payment/paypal_direct/verify_peer','1'),(726,'default',0,'payment/paypal_direct/line_items_enabled','0'),(727,'default',0,'payment/paypal_direct/useccv','1'),(728,'default',0,'payment/paypal_direct/centinel','0'),(729,'default',0,'payment/paypal_standard/active','0'),(730,'default',0,'payment/paypal_standard/title','PayPal Website Payments Standard'),(731,'default',0,'payment/paypal_standard/sort_order',NULL),(732,'default',0,'payment/paypal_standard/payment_action','Sale'),(733,'default',0,'payment/paypal_standard/allowspecific','0'),(734,'default',0,'payment/paypal_standard/sandbox_flag','0'),(735,'default',0,'payment/paypal_standard/line_items_enabled','1'),(736,'default',0,'payment/paypal_standard/debug','0'),(737,'default',0,'payment/paypal_standard/verify_peer','1'),(738,'default',0,'payment/verisign/partner',NULL),(739,'default',0,'payment/verisign/user',NULL),(740,'default',0,'payment/verisign/vendor',NULL),(741,'default',0,'payment/verisign/pwd',NULL),(742,'default',0,'payment/verisign/sandbox_flag','0'),(743,'default',0,'payment/verisign/use_proxy','0'),(744,'default',0,'payment/verisign/active','0'),(745,'default',0,'payment/verisign/title','Payflow Pro'),(746,'default',0,'payment/verisign/sort_order',NULL),(747,'default',0,'payment/verisign/payment_action','Authorization'),(748,'default',0,'payment/verisign/cctypes','AE,VI'),(749,'default',0,'payment/verisign/allowspecific','0'),(750,'default',0,'payment/verisign/debug','0'),(751,'default',0,'payment/verisign/verify_peer','1'),(752,'default',0,'payment/verisign/useccv','1'),(753,'default',0,'payment/verisign/centinel','0'),(754,'default',0,'payment/paypaluk_express/active','0'),(755,'default',0,'payment/paypaluk_express/title','PayPal Express Checkout Payflow Edition'),(756,'default',0,'payment/paypaluk_express/sort_order',NULL),(757,'default',0,'payment/paypaluk_express/payment_action','Authorization'),(758,'default',0,'payment/paypaluk_express/visible_on_cart','1'),(759,'default',0,'payment/paypaluk_express/visible_on_product','1'),(760,'default',0,'payment/paypaluk_express/allowspecific','0'),(761,'default',0,'payment/paypaluk_express/debug','0'),(762,'default',0,'payment/paypaluk_express/verify_peer','1'),(763,'default',0,'payment/paypaluk_express/line_items_enabled','1'),(764,'default',0,'payment/payflow_link/partner',NULL),(765,'default',0,'payment/payflow_link/vendor',NULL),(766,'default',0,'payment/payflow_link/user',NULL),(767,'default',0,'payment/payflow_link/pwd',NULL),(768,'default',0,'payment/payflow_link/sandbox_flag','0'),(769,'default',0,'payment/payflow_link/use_proxy','0'),(770,'default',0,'payment/payflow_link/active','0'),(771,'default',0,'payment/paypal_express/active','1'),(772,'default',0,'payment/payflow_link/title','Credit Card'),(773,'default',0,'payment/payflow_link/sort_order',NULL),(774,'default',0,'payment/payflow_link/payment_action','Authorization'),(775,'default',0,'payment/payflow_link/allowspecific','0'),(776,'default',0,'payment/payflow_link/debug','0'),(777,'default',0,'payment/payflow_link/verify_peer','1'),(778,'default',0,'payment/payflow_link/csc_editable','1'),(779,'default',0,'payment/payflow_link/csc_required','1'),(780,'default',0,'payment/payflow_link/email_confirmation','0'),(781,'default',0,'payment/payflow_link/url_method','GET'),(782,'default',0,'payment/ccsave/active','1'),(783,'default',0,'payment/ccsave/title','Credit Card (saved)'),(784,'default',0,'payment/ccsave/order_status','pending'),(785,'default',0,'payment/ccsave/cctypes','AE,VI,MC,DI'),(786,'default',0,'payment/ccsave/useccv','0'),(787,'default',0,'payment/ccsave/centinel','0'),(788,'default',0,'payment/ccsave/allowspecific','0'),(789,'default',0,'payment/ccsave/min_order_total',NULL),(790,'default',0,'payment/ccsave/max_order_total',NULL),(791,'default',0,'payment/ccsave/sort_order',NULL),(792,'default',0,'payment/checkmo/active','1'),(793,'default',0,'payment/checkmo/title','Check / Money order'),(794,'default',0,'payment/checkmo/order_status','pending'),(795,'default',0,'payment/checkmo/allowspecific','0'),(796,'default',0,'payment/checkmo/payable_to',NULL),(797,'default',0,'payment/checkmo/mailing_address',NULL),(798,'default',0,'payment/checkmo/min_order_total',NULL),(799,'default',0,'payment/checkmo/max_order_total',NULL),(800,'default',0,'payment/checkmo/sort_order',NULL),(801,'default',0,'payment/free/title','No Payment Information Required'),(802,'default',0,'payment/free/active','1'),(803,'default',0,'payment/free/order_status','pending'),(804,'default',0,'payment/free/allowspecific','0'),(805,'default',0,'payment/free/sort_order','1'),(806,'default',0,'payment/banktransfer/active','0'),(807,'default',0,'payment/banktransfer/title','Bank Transfer Payment'),(808,'default',0,'payment/banktransfer/order_status','pending'),(809,'default',0,'payment/banktransfer/allowspecific','0'),(810,'default',0,'payment/banktransfer/instructions',NULL),(811,'default',0,'payment/banktransfer/min_order_total',NULL),(812,'default',0,'payment/banktransfer/max_order_total',NULL),(813,'default',0,'payment/banktransfer/sort_order',NULL),(814,'default',0,'payment/cashondelivery/active','0'),(815,'default',0,'payment/cashondelivery/title','Cash On Delivery'),(816,'default',0,'payment/cashondelivery/order_status','pending'),(817,'default',0,'payment/cashondelivery/allowspecific','0'),(818,'default',0,'payment/cashondelivery/instructions',NULL),(819,'default',0,'payment/cashondelivery/min_order_total',NULL),(820,'default',0,'payment/cashondelivery/max_order_total',NULL),(821,'default',0,'payment/cashondelivery/sort_order',NULL),(822,'default',0,'payment/purchaseorder/active','0'),(823,'default',0,'payment/purchaseorder/title','Purchase Order'),(824,'default',0,'payment/purchaseorder/order_status','pending'),(825,'default',0,'payment/purchaseorder/allowspecific','0'),(826,'default',0,'payment/purchaseorder/min_order_total',NULL),(827,'default',0,'payment/purchaseorder/max_order_total',NULL),(828,'default',0,'payment/purchaseorder/sort_order',NULL),(829,'default',0,'payment/authorizenet_directpost/active','0'),(830,'default',0,'payment/authorizenet_directpost/payment_action','authorize'),(831,'default',0,'payment/authorizenet_directpost/title','Credit Card Direct Post (Authorize.net)'),(832,'default',0,'payment/authorizenet_directpost/login',NULL),(833,'default',0,'payment/authorizenet_directpost/trans_key',NULL),(834,'default',0,'payment/authorizenet_directpost/trans_md5',NULL),(835,'default',0,'payment/authorizenet_directpost/order_status','processing'),(836,'default',0,'payment/authorizenet_directpost/test','1'),(837,'default',0,'payment/authorizenet_directpost/cgi_url','https://secure.authorize.net/gateway/transact.dll'),(838,'default',0,'payment/authorizenet_directpost/currency','USD'),(839,'default',0,'payment/authorizenet_directpost/debug','0'),(840,'default',0,'payment/authorizenet_directpost/email_customer','0'),(841,'default',0,'payment/authorizenet_directpost/merchant_email',NULL),(842,'default',0,'payment/authorizenet_directpost/cctypes','AE,VI,MC,DI'),(843,'default',0,'payment/authorizenet_directpost/useccv','0'),(844,'default',0,'payment/authorizenet_directpost/allowspecific','0'),(845,'default',0,'payment/authorizenet_directpost/min_order_total',NULL),(846,'default',0,'payment/authorizenet_directpost/max_order_total',NULL),(847,'default',0,'payment/authorizenet_directpost/sort_order',NULL),(848,'default',0,'payment/authorizenet/active','0'),(849,'default',0,'payment/authorizenet/title','Credit Card (Authorize.net)'),(850,'default',0,'payment/authorizenet/login',NULL),(851,'default',0,'payment/authorizenet/payment_action','authorize'),(852,'default',0,'payment/authorizenet/trans_key',NULL),(853,'default',0,'payment/authorizenet/order_status','processing'),(854,'default',0,'payment/authorizenet/test','1'),(855,'default',0,'payment/authorizenet/cgi_url','https://secure.authorize.net/gateway/transact.dll'),(856,'default',0,'payment/authorizenet/currency','USD'),(857,'default',0,'payment/authorizenet/debug','0'),(858,'default',0,'payment/authorizenet/email_customer','0'),(859,'default',0,'payment/authorizenet/merchant_email',NULL),(860,'default',0,'payment/authorizenet/cctypes','AE,VI,MC,DI'),(861,'default',0,'payment/authorizenet/useccv','0'),(862,'default',0,'payment/authorizenet/allowspecific','0'),(863,'default',0,'payment/authorizenet/min_order_total',NULL),(864,'default',0,'payment/authorizenet/max_order_total',NULL),(865,'default',0,'payment/authorizenet/sort_order',NULL),(866,'default',0,'payment/authorizenet/allow_partial_authorization','0'),(867,'default',0,'payment/authorizenet/centinel','0'),(868,'default',0,'demo_menu/general/buynow_url',NULL),(869,'default',0,'demo_menu/general/download_url',NULL),(870,'default',0,'demo_menu/include_jquery_files/include_jquery','0'),(871,'default',0,'demo_menu/include_jquery_files/include_cookie','1'),(872,'default',0,'payment/paypal_express/skip_order_review_step','0'),(873,'default',0,'design/header/logo_src_small','images/logo.gif'),(874,'default',0,'design/email/logo_width',NULL),(875,'default',0,'design/email/logo_height',NULL),(876,'default',0,'design/email/header','design_email_header'),(877,'default',0,'design/email/footer','design_email_footer'),(878,'default',0,'design/email/css_non_inline','email-non-inline.css');
/*!40000 ALTER TABLE `core_config_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_email_queue`
--

DROP TABLE IF EXISTS `core_email_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_email_queue` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Message Id',
  `entity_id` int(10) unsigned DEFAULT NULL COMMENT 'Entity ID',
  `entity_type` varchar(128) DEFAULT NULL COMMENT 'Entity Type',
  `event_type` varchar(128) DEFAULT NULL COMMENT 'Event Type',
  `message_body_hash` varchar(64) NOT NULL COMMENT 'Message Body Hash',
  `message_body` mediumtext NOT NULL COMMENT 'Message Body',
  `message_parameters` text NOT NULL COMMENT 'Message Parameters',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Time',
  `processed_at` timestamp NULL DEFAULT NULL COMMENT 'Finish Time',
  PRIMARY KEY (`message_id`),
  KEY `0ADECE62FD629241C147389ADF20706E` (`entity_id`,`entity_type`,`event_type`,`message_body_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Email Queue';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_email_queue`
--

LOCK TABLES `core_email_queue` WRITE;
/*!40000 ALTER TABLE `core_email_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_email_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_email_queue_recipients`
--

DROP TABLE IF EXISTS `core_email_queue_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_email_queue_recipients` (
  `recipient_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Recipient Id',
  `message_id` int(10) unsigned NOT NULL COMMENT 'Message ID',
  `recipient_email` varchar(128) NOT NULL COMMENT 'Recipient Email',
  `recipient_name` varchar(255) NOT NULL COMMENT 'Recipient Name',
  `email_type` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Email Type',
  PRIMARY KEY (`recipient_id`),
  UNIQUE KEY `19BDB9C5FE4BD685FCF992A71E976CD0` (`message_id`,`recipient_email`,`email_type`),
  KEY `IDX_CORE_EMAIL_QUEUE_RECIPIENTS_RECIPIENT_EMAIL` (`recipient_email`),
  KEY `IDX_CORE_EMAIL_QUEUE_RECIPIENTS_EMAIL_TYPE` (`email_type`),
  CONSTRAINT `FK_6F4948F3ABF97DE12127EF14B140802A` FOREIGN KEY (`message_id`) REFERENCES `core_email_queue` (`message_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Email Queue';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_email_queue_recipients`
--

LOCK TABLES `core_email_queue_recipients` WRITE;
/*!40000 ALTER TABLE `core_email_queue_recipients` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_email_queue_recipients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_email_template`
--

DROP TABLE IF EXISTS `core_email_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_email_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Template Id',
  `template_code` varchar(150) NOT NULL COMMENT 'Template Name',
  `template_text` text NOT NULL COMMENT 'Template Content',
  `template_styles` text COMMENT 'Templste Styles',
  `template_type` int(10) unsigned DEFAULT NULL COMMENT 'Template Type',
  `template_subject` varchar(200) NOT NULL COMMENT 'Template Subject',
  `template_sender_name` varchar(200) DEFAULT NULL COMMENT 'Template Sender Name',
  `template_sender_email` varchar(200) DEFAULT NULL COMMENT 'Template Sender Email',
  `added_at` timestamp NULL DEFAULT NULL COMMENT 'Date of Template Creation',
  `modified_at` timestamp NULL DEFAULT NULL COMMENT 'Date of Template Modification',
  `orig_template_code` varchar(200) DEFAULT NULL COMMENT 'Original Template Code',
  `orig_template_variables` text COMMENT 'Original Template Variables',
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `UNQ_CORE_EMAIL_TEMPLATE_TEMPLATE_CODE` (`template_code`),
  KEY `IDX_CORE_EMAIL_TEMPLATE_ADDED_AT` (`added_at`),
  KEY `IDX_CORE_EMAIL_TEMPLATE_MODIFIED_AT` (`modified_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Email Templates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_email_template`
--

LOCK TABLES `core_email_template` WRITE;
/*!40000 ALTER TABLE `core_email_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_email_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_flag`
--

DROP TABLE IF EXISTS `core_flag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_flag` (
  `flag_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Flag Id',
  `flag_code` varchar(255) NOT NULL COMMENT 'Flag Code',
  `state` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag State',
  `flag_data` text COMMENT 'Flag Data',
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of Last Flag Update',
  PRIMARY KEY (`flag_id`),
  KEY `IDX_CORE_FLAG_LAST_UPDATE` (`last_update`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='Flag';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_flag`
--

LOCK TABLES `core_flag` WRITE;
/*!40000 ALTER TABLE `core_flag` DISABLE KEYS */;
INSERT INTO `core_flag` VALUES (1,'catalog_product_flat',0,'a:1:{s:8:\"is_built\";b:1;}','2013-06-06 00:39:00'),(2,'report_order_aggregated',0,NULL,'2011-11-17 01:01:55'),(3,'report_shipping_aggregated',0,NULL,'2011-11-17 01:01:55'),(4,'report_invoiced_aggregated',0,NULL,'2011-11-17 01:01:55'),(5,'report_refunded_aggregated',0,NULL,'2011-11-17 01:01:56'),(6,'report_bestsellers_aggregated',0,NULL,'2011-11-17 01:01:56'),(7,'report_coupons_aggregated',0,NULL,'2011-11-17 01:01:56'),(8,'report_tax_aggregated',0,NULL,'2011-11-17 01:01:57'),(9,'admin_notification_survey',0,'a:1:{s:13:\"survey_viewed\";b:1;}','2014-01-05 06:22:01'),(10,'catalog_rules_dirty',0,NULL,'2013-02-13 12:04:50');
/*!40000 ALTER TABLE `core_flag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_layout_link`
--

DROP TABLE IF EXISTS `core_layout_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_layout_link` (
  `layout_link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link Id',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `area` varchar(64) DEFAULT NULL COMMENT 'Area',
  `package` varchar(64) DEFAULT NULL COMMENT 'Package',
  `theme` varchar(64) DEFAULT NULL COMMENT 'Theme',
  `layout_update_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Layout Update Id',
  PRIMARY KEY (`layout_link_id`),
  UNIQUE KEY `UNQ_CORE_LAYOUT_LINK_STORE_ID_PACKAGE_THEME_LAYOUT_UPDATE_ID` (`store_id`,`package`,`theme`,`layout_update_id`),
  KEY `IDX_CORE_LAYOUT_LINK_LAYOUT_UPDATE_ID` (`layout_update_id`),
  CONSTRAINT `FK_CORE_LAYOUT_LINK_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_LYT_LNK_LYT_UPDATE_ID_CORE_LYT_UPDATE_LYT_UPDATE_ID` FOREIGN KEY (`layout_update_id`) REFERENCES `core_layout_update` (`layout_update_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Layout Link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_layout_link`
--

LOCK TABLES `core_layout_link` WRITE;
/*!40000 ALTER TABLE `core_layout_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_layout_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_layout_update`
--

DROP TABLE IF EXISTS `core_layout_update`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_layout_update` (
  `layout_update_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Layout Update Id',
  `handle` varchar(255) DEFAULT NULL COMMENT 'Handle',
  `xml` text COMMENT 'Xml',
  `sort_order` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`layout_update_id`),
  KEY `IDX_CORE_LAYOUT_UPDATE_HANDLE` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Layout Updates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_layout_update`
--

LOCK TABLES `core_layout_update` WRITE;
/*!40000 ALTER TABLE `core_layout_update` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_layout_update` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_resource`
--

DROP TABLE IF EXISTS `core_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_resource` (
  `code` varchar(50) NOT NULL COMMENT 'Resource Code',
  `version` varchar(50) DEFAULT NULL COMMENT 'Resource Version',
  `data_version` varchar(50) DEFAULT NULL COMMENT 'Data Version',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Resources';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_resource`
--

LOCK TABLES `core_resource` WRITE;
/*!40000 ALTER TABLE `core_resource` DISABLE KEYS */;
INSERT INTO `core_resource` VALUES ('adminnotification_setup','1.6.0.0','1.6.0.0'),('admin_setup','1.6.1.2','1.6.1.2'),('api2_setup','1.0.0.0','1.0.0.0'),('api_setup','1.6.0.1','1.6.0.1'),('awall_setup','2.1.2','2.1.2'),('backup_setup','1.6.0.0','1.6.0.0'),('blog_setup','1.3.18','1.3.18'),('bundle_setup','1.6.0.0.1','1.6.0.0.1'),('captcha_setup','1.7.0.0.0','1.7.0.0.0'),('catalogindex_setup','1.6.0.0','1.6.0.0'),('cataloginventory_setup','1.6.0.0.2','1.6.0.0.2'),('catalogrule_setup','1.6.0.3','1.6.0.3'),('catalogsearch_setup','1.8.2.0','1.8.2.0'),('catalog_setup','1.6.0.0.19.1.5','1.6.0.0.19.1.5'),('checkout_setup','1.6.0.0','1.6.0.0'),('cms_setup','1.6.0.0.2','1.6.0.0.2'),('compiler_setup','1.6.0.0','1.6.0.0'),('contacts_setup','1.6.0.0','1.6.0.0'),('core_setup','1.6.0.6','1.6.0.6'),('cron_setup','1.6.0.0','1.6.0.0'),('customer_setup','1.6.2.0.5','1.6.2.0.5'),('dataflow_setup','1.6.0.0','1.6.0.0'),('directory_setup','1.6.0.3','1.6.0.3'),('downloadable_setup','1.6.0.0.2','1.6.0.0.2'),('easylightbox_setup','1.0.0','1.0.0'),('easytabs_setup','1.1.0','1.1.0'),('eav_setup','1.6.0.1','1.6.0.1'),('enhancedgrid_setup','1.3.4.4','1.3.4.4'),('giftmessage_setup','1.6.0.0','1.6.0.0'),('googleanalytics_setup','1.6.0.0','1.6.0.0'),('googlecheckout_setup','1.6.0.1','1.6.0.1'),('importexport_setup','1.6.0.2','1.6.0.2'),('index_setup','1.6.0.0','1.6.0.0'),('log_setup','1.6.1.1','1.6.1.1'),('moneybookers_setup','1.6.0.0','1.6.0.0'),('newsletter_setup','1.6.0.2','1.6.0.2'),('oauth_setup','1.0.0.0','1.0.0.0'),('onepagecheckout_setup','3.2.0','3.2.0'),('paygate_setup','1.6.0.0','1.6.0.0'),('payment_setup','1.6.0.0','1.6.0.0'),('paypaluk_setup','1.6.0.0','1.6.0.0'),('paypal_setup','1.6.0.6','1.6.0.6'),('persistent_setup','1.0.0.0','1.0.0.0'),('poll_setup','1.6.0.1','1.6.0.1'),('productalert_setup','1.6.0.0','1.6.0.0'),('quickcontact_setup','0.8.0','0.8.0'),('quickshop_setup','0.1.0','0.1.0'),('rating_setup','1.6.0.1','1.6.0.1'),('reports_setup','1.6.0.0.1','1.6.0.0.1'),('review_setup','1.6.0.0','1.6.0.0'),('rss_setup','1.6.0.0','1.6.0.0'),('salesrule_setup','1.6.0.3','1.6.0.3'),('sales_setup','1.6.0.10','1.6.0.10'),('sendfriend_setup','1.6.0.1','1.6.0.1'),('shipping_setup','1.6.0.0','1.6.0.0'),('sitemap_setup','1.6.0.0','1.6.0.0'),('tag_setup','1.6.0.0','1.6.0.0'),('tax_setup','1.6.0.4','1.6.0.4'),('usa_setup','1.6.0.3','1.6.0.3'),('weee_setup','1.6.0.0','1.6.0.0'),('widget_setup','1.6.0.0','1.6.0.0'),('wishlist_setup','1.6.0.0','1.6.0.0'),('xmlconnect_setup','1.6.0.0.1','1.6.0.0.1');
/*!40000 ALTER TABLE `core_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_session`
--

DROP TABLE IF EXISTS `core_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_session` (
  `session_id` varchar(255) NOT NULL COMMENT 'Session Id',
  `session_expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Date of Session Expiration',
  `session_data` mediumblob NOT NULL COMMENT 'Session Data',
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Database Sessions Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_session`
--

LOCK TABLES `core_session` WRITE;
/*!40000 ALTER TABLE `core_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_store`
--

DROP TABLE IF EXISTS `core_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_store` (
  `store_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Store Id',
  `code` varchar(32) DEFAULT NULL COMMENT 'Code',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Website Id',
  `group_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Group Id',
  `name` varchar(255) NOT NULL COMMENT 'Store Name',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Sort Order',
  `is_active` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Activity',
  PRIMARY KEY (`store_id`),
  UNIQUE KEY `UNQ_CORE_STORE_CODE` (`code`),
  KEY `IDX_CORE_STORE_WEBSITE_ID` (`website_id`),
  KEY `IDX_CORE_STORE_IS_ACTIVE_SORT_ORDER` (`is_active`,`sort_order`),
  KEY `IDX_CORE_STORE_GROUP_ID` (`group_id`),
  CONSTRAINT `FK_CORE_STORE_GROUP_ID_CORE_STORE_GROUP_GROUP_ID` FOREIGN KEY (`group_id`) REFERENCES `core_store_group` (`group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_STORE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Stores';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_store`
--

LOCK TABLES `core_store` WRITE;
/*!40000 ALTER TABLE `core_store` DISABLE KEYS */;
INSERT INTO `core_store` VALUES (0,'admin',0,0,'Admin',0,1),(1,'default',1,1,'English',0,1),(5,'de',1,1,'German',0,1);
/*!40000 ALTER TABLE `core_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_store_group`
--

DROP TABLE IF EXISTS `core_store_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_store_group` (
  `group_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Group Id',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Website Id',
  `name` varchar(255) NOT NULL COMMENT 'Store Group Name',
  `root_category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Root Category Id',
  `default_store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Default Store Id',
  PRIMARY KEY (`group_id`),
  KEY `IDX_CORE_STORE_GROUP_WEBSITE_ID` (`website_id`),
  KEY `IDX_CORE_STORE_GROUP_DEFAULT_STORE_ID` (`default_store_id`),
  CONSTRAINT `FK_CORE_STORE_GROUP_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Store Groups';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_store_group`
--

LOCK TABLES `core_store_group` WRITE;
/*!40000 ALTER TABLE `core_store_group` DISABLE KEYS */;
INSERT INTO `core_store_group` VALUES (0,0,'Default',0,0),(1,1,'All included',2,1);
/*!40000 ALTER TABLE `core_store_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_translate`
--

DROP TABLE IF EXISTS `core_translate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_translate` (
  `key_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Key Id of Translation',
  `string` varchar(255) NOT NULL DEFAULT 'Translate String' COMMENT 'Translation String',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `translate` varchar(255) DEFAULT NULL COMMENT 'Translate',
  `locale` varchar(20) NOT NULL DEFAULT 'en_US' COMMENT 'Locale',
  `crc_string` bigint(20) NOT NULL DEFAULT '1591228201' COMMENT 'Translation String CRC32 Hash',
  PRIMARY KEY (`key_id`),
  UNIQUE KEY `UNQ_CORE_TRANSLATE_STORE_ID_LOCALE_CRC_STRING_STRING` (`store_id`,`locale`,`crc_string`,`string`),
  KEY `IDX_CORE_TRANSLATE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_CORE_TRANSLATE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Translations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_translate`
--

LOCK TABLES `core_translate` WRITE;
/*!40000 ALTER TABLE `core_translate` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_translate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_url_rewrite`
--

DROP TABLE IF EXISTS `core_url_rewrite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_url_rewrite` (
  `url_rewrite_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rewrite Id',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `id_path` varchar(255) DEFAULT NULL COMMENT 'Id Path',
  `request_path` varchar(255) DEFAULT NULL COMMENT 'Request Path',
  `target_path` varchar(255) DEFAULT NULL COMMENT 'Target Path',
  `is_system` smallint(5) unsigned DEFAULT '1' COMMENT 'Defines is Rewrite System',
  `options` varchar(255) DEFAULT NULL COMMENT 'Options',
  `description` varchar(255) DEFAULT NULL COMMENT 'Deascription',
  `category_id` int(10) unsigned DEFAULT NULL COMMENT 'Category Id',
  `product_id` int(10) unsigned DEFAULT NULL COMMENT 'Product Id',
  PRIMARY KEY (`url_rewrite_id`),
  UNIQUE KEY `UNQ_CORE_URL_REWRITE_REQUEST_PATH_STORE_ID` (`request_path`,`store_id`),
  UNIQUE KEY `UNQ_CORE_URL_REWRITE_ID_PATH_IS_SYSTEM_STORE_ID` (`id_path`,`is_system`,`store_id`),
  KEY `IDX_CORE_URL_REWRITE_TARGET_PATH_STORE_ID` (`target_path`,`store_id`),
  KEY `IDX_CORE_URL_REWRITE_ID_PATH` (`id_path`),
  KEY `IDX_CORE_URL_REWRITE_STORE_ID` (`store_id`),
  KEY `FK_CORE_URL_REWRITE_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` (`category_id`),
  KEY `FK_CORE_URL_REWRITE_PRODUCT_ID_CATALOG_CATEGORY_ENTITY_ENTITY_ID` (`product_id`),
  CONSTRAINT `FK_CORE_URL_REWRITE_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_URL_REWRITE_PRODUCT_ID_CATALOG_CATEGORY_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_URL_REWRITE_STORE_ID_CORE_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=114980 DEFAULT CHARSET=utf8 COMMENT='Url Rewrites';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_url_rewrite`
--

LOCK TABLES `core_url_rewrite` WRITE;
/*!40000 ALTER TABLE `core_url_rewrite` DISABLE KEYS */;
INSERT INTO `core_url_rewrite` VALUES (8,1,'product/1','test-product.html','catalog/product/view/id/1',1,NULL,NULL,NULL,1),(3889,1,'product/226','gund-all-stars-sports-glove-chair.html','catalog/product/view/id/226',1,NULL,NULL,NULL,226),(3895,1,'product/227','disney-princess-pretty-pink-toddler-bed.html','catalog/product/view/id/227',1,NULL,NULL,NULL,227),(3919,1,'product/231','nickelodeon-sponge-bob-toddler-bed.html','catalog/product/view/id/231',1,NULL,NULL,NULL,231),(3925,1,'product/232','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html','catalog/product/view/id/232',1,NULL,NULL,NULL,232),(3949,1,'product/236','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html','catalog/product/view/id/236',1,NULL,NULL,NULL,236),(3961,1,'product/238','tot-tutors-kids-table-and-4-chair-set-plastic.html','catalog/product/view/id/238',1,NULL,NULL,NULL,238),(3967,1,'product/239','tot-tutors-book-rack-primary-colors.html','catalog/product/view/id/239',1,NULL,NULL,NULL,239),(3979,1,'product/241','p-kolino-little-sofa-sleeper-green.html','catalog/product/view/id/241',1,NULL,NULL,NULL,241),(3985,1,'product/242','p-kolino-silly-soft-seating-lila.html','catalog/product/view/id/242',1,NULL,NULL,NULL,242),(3991,1,'product/243','p-kolino-book-buggee-in-orange.html','catalog/product/view/id/243',1,NULL,NULL,NULL,243),(3997,1,'product/244','p-kolino-nesting-birds.html','catalog/product/view/id/244',1,NULL,NULL,NULL,244),(4003,1,'product/245','p-kolino-children-desk-white.html','catalog/product/view/id/245',1,NULL,NULL,NULL,245),(4009,1,'product/246','p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html','catalog/product/view/id/246',1,NULL,NULL,NULL,246),(4015,1,'product/247','p-kolino-book-buggee-fire-truck.html','catalog/product/view/id/247',1,NULL,NULL,NULL,247),(4021,1,'product/248','p-kolino-new-little-reader-chair-flower-pink.html','catalog/product/view/id/248',1,NULL,NULL,NULL,248),(4027,1,'product/249','p-kolino-book-buggee-crown.html','catalog/product/view/id/249',1,NULL,NULL,NULL,249),(4033,1,'product/250','p-kolino-safari-duck-and-ostrich-chairs.html','catalog/product/view/id/250',1,NULL,NULL,NULL,250),(4039,1,'product/251','p-kolino-klick-children-s-desk-orange.html','catalog/product/view/id/251',1,NULL,NULL,NULL,251),(4045,1,'product/252','safari-collection-tree-table-w-animal-chairs.html','catalog/product/view/id/252',1,NULL,NULL,NULL,252),(4051,1,'product/253','p-kolino-little-one-s-chair.html','catalog/product/view/id/253',1,NULL,NULL,NULL,253),(4063,1,'product/255','p-kolino-zebra-rocking-chair.html','catalog/product/view/id/255',1,NULL,NULL,NULL,255),(4783,1,'product/287','hot-bikini-white-yellow-or-black.html','catalog/product/view/id/287',1,NULL,NULL,NULL,287),(4786,1,'product/288','designer-monokini-halter-string-ties-womens-sexy-bikini.html','catalog/product/view/id/288',1,NULL,NULL,NULL,288),(4789,1,'product/289','metallic-slingshot-monokini-as-shown-one-size.html','catalog/product/view/id/289',1,NULL,NULL,NULL,289),(4792,1,'product/290','hot-bikini-leopard.html','catalog/product/view/id/290',1,NULL,NULL,NULL,290),(4795,1,'product/291','daisy-corsets-sequin-underwire-corset.html','catalog/product/view/id/291',1,NULL,NULL,NULL,291),(33587,1,'category/50','grayscale-magento-template.html','catalog/category/view/id/50',1,NULL,NULL,50,NULL),(33589,1,'product/226/50','grayscale-magento-template/gund-all-stars-sports-glove-chair.html','catalog/product/view/id/226/category/50',1,NULL,NULL,50,226),(33591,1,'product/227/50','grayscale-magento-template/disney-princess-pretty-pink-toddler-bed.html','catalog/product/view/id/227/category/50',1,NULL,NULL,50,227),(33593,1,'product/231/50','grayscale-magento-template/nickelodeon-sponge-bob-toddler-bed.html','catalog/product/view/id/231/category/50',1,NULL,NULL,50,231),(33595,1,'product/232/50','grayscale-magento-template/4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html','catalog/product/view/id/232/category/50',1,NULL,NULL,50,232),(33597,1,'product/236/50','grayscale-magento-template/nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html','catalog/product/view/id/236/category/50',1,NULL,NULL,50,236),(33599,1,'product/238/50','grayscale-magento-template/tot-tutors-kids-table-and-4-chair-set-plastic.html','catalog/product/view/id/238/category/50',1,NULL,NULL,50,238),(33601,1,'product/239/50','grayscale-magento-template/tot-tutors-book-rack-primary-colors.html','catalog/product/view/id/239/category/50',1,NULL,NULL,50,239),(33603,1,'product/241/50','grayscale-magento-template/p-kolino-little-sofa-sleeper-green.html','catalog/product/view/id/241/category/50',1,NULL,NULL,50,241),(33605,1,'product/242/50','grayscale-magento-template/p-kolino-silly-soft-seating-lila.html','catalog/product/view/id/242/category/50',1,NULL,NULL,50,242),(33607,1,'product/243/50','grayscale-magento-template/p-kolino-book-buggee-in-orange.html','catalog/product/view/id/243/category/50',1,NULL,NULL,50,243),(33609,1,'product/244/50','grayscale-magento-template/p-kolino-nesting-birds.html','catalog/product/view/id/244/category/50',1,NULL,NULL,50,244),(33611,1,'product/245/50','grayscale-magento-template/p-kolino-children-desk-white.html','catalog/product/view/id/245/category/50',1,NULL,NULL,50,245),(33613,1,'product/246/50','grayscale-magento-template/p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html','catalog/product/view/id/246/category/50',1,NULL,NULL,50,246),(33615,1,'product/247/50','grayscale-magento-template/p-kolino-book-buggee-fire-truck.html','catalog/product/view/id/247/category/50',1,NULL,NULL,50,247),(33617,1,'product/248/50','grayscale-magento-template/p-kolino-new-little-reader-chair-flower-pink.html','catalog/product/view/id/248/category/50',1,NULL,NULL,50,248),(33619,1,'product/249/50','grayscale-magento-template/p-kolino-book-buggee-crown.html','catalog/product/view/id/249/category/50',1,NULL,NULL,50,249),(33621,1,'product/250/50','grayscale-magento-template/p-kolino-safari-duck-and-ostrich-chairs.html','catalog/product/view/id/250/category/50',1,NULL,NULL,50,250),(33623,1,'product/251/50','grayscale-magento-template/p-kolino-klick-children-s-desk-orange.html','catalog/product/view/id/251/category/50',1,NULL,NULL,50,251),(33625,1,'product/252/50','grayscale-magento-template/safari-collection-tree-table-w-animal-chairs.html','catalog/product/view/id/252/category/50',1,NULL,NULL,50,252),(33627,1,'product/253/50','grayscale-magento-template/p-kolino-little-one-s-chair.html','catalog/product/view/id/253/category/50',1,NULL,NULL,50,253),(33631,1,'product/255/50','grayscale-magento-template/p-kolino-zebra-rocking-chair.html','catalog/product/view/id/255/category/50',1,NULL,NULL,50,255),(33648,5,'category/50','grayscale-magento-template.html','catalog/category/view/id/50',1,NULL,NULL,50,NULL),(33649,5,'product/226','gund-all-stars-sports-glove-chair.html','catalog/product/view/id/226',1,NULL,NULL,NULL,226),(33650,5,'product/226/50','grayscale-magento-template/gund-all-stars-sports-glove-chair.html','catalog/product/view/id/226/category/50',1,NULL,NULL,50,226),(33651,5,'product/227','disney-princess-pretty-pink-toddler-bed.html','catalog/product/view/id/227',1,NULL,NULL,NULL,227),(33652,5,'product/227/50','grayscale-magento-template/disney-princess-pretty-pink-toddler-bed.html','catalog/product/view/id/227/category/50',1,NULL,NULL,50,227),(33653,5,'product/231','nickelodeon-sponge-bob-toddler-bed.html','catalog/product/view/id/231',1,NULL,NULL,NULL,231),(33654,5,'product/231/50','grayscale-magento-template/nickelodeon-sponge-bob-toddler-bed.html','catalog/product/view/id/231/category/50',1,NULL,NULL,50,231),(33655,5,'product/232','4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html','catalog/product/view/id/232',1,NULL,NULL,NULL,232),(33656,5,'product/232/50','grayscale-magento-template/4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html','catalog/product/view/id/232/category/50',1,NULL,NULL,50,232),(33657,5,'product/236','nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html','catalog/product/view/id/236',1,NULL,NULL,NULL,236),(33658,5,'product/236/50','grayscale-magento-template/nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html','catalog/product/view/id/236/category/50',1,NULL,NULL,50,236),(33659,5,'product/238','tot-tutors-kids-table-and-4-chair-set-plastic.html','catalog/product/view/id/238',1,NULL,NULL,NULL,238),(33660,5,'product/238/50','grayscale-magento-template/tot-tutors-kids-table-and-4-chair-set-plastic.html','catalog/product/view/id/238/category/50',1,NULL,NULL,50,238),(33661,5,'product/239','tot-tutors-book-rack-primary-colors.html','catalog/product/view/id/239',1,NULL,NULL,NULL,239),(33662,5,'product/239/50','grayscale-magento-template/tot-tutors-book-rack-primary-colors.html','catalog/product/view/id/239/category/50',1,NULL,NULL,50,239),(33663,5,'product/241','p-kolino-little-sofa-sleeper-green.html','catalog/product/view/id/241',1,NULL,NULL,NULL,241),(33664,5,'product/241/50','grayscale-magento-template/p-kolino-little-sofa-sleeper-green.html','catalog/product/view/id/241/category/50',1,NULL,NULL,50,241),(33665,5,'product/242','p-kolino-silly-soft-seating-lila.html','catalog/product/view/id/242',1,NULL,NULL,NULL,242),(33666,5,'product/242/50','grayscale-magento-template/p-kolino-silly-soft-seating-lila.html','catalog/product/view/id/242/category/50',1,NULL,NULL,50,242),(33667,5,'product/243','p-kolino-book-buggee-in-orange.html','catalog/product/view/id/243',1,NULL,NULL,NULL,243),(33668,5,'product/243/50','grayscale-magento-template/p-kolino-book-buggee-in-orange.html','catalog/product/view/id/243/category/50',1,NULL,NULL,50,243),(33669,5,'product/244','p-kolino-nesting-birds.html','catalog/product/view/id/244',1,NULL,NULL,NULL,244),(33670,5,'product/244/50','grayscale-magento-template/p-kolino-nesting-birds.html','catalog/product/view/id/244/category/50',1,NULL,NULL,50,244),(33671,5,'product/245','p-kolino-children-desk-white.html','catalog/product/view/id/245',1,NULL,NULL,NULL,245),(33672,5,'product/245/50','grayscale-magento-template/p-kolino-children-desk-white.html','catalog/product/view/id/245/category/50',1,NULL,NULL,50,245),(33673,5,'product/246','p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html','catalog/product/view/id/246',1,NULL,NULL,NULL,246),(33674,5,'product/246/50','grayscale-magento-template/p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html','catalog/product/view/id/246/category/50',1,NULL,NULL,50,246),(33675,5,'product/247','p-kolino-book-buggee-fire-truck.html','catalog/product/view/id/247',1,NULL,NULL,NULL,247),(33676,5,'product/247/50','grayscale-magento-template/p-kolino-book-buggee-fire-truck.html','catalog/product/view/id/247/category/50',1,NULL,NULL,50,247),(33677,5,'product/248','p-kolino-new-little-reader-chair-flower-pink.html','catalog/product/view/id/248',1,NULL,NULL,NULL,248),(33678,5,'product/248/50','grayscale-magento-template/p-kolino-new-little-reader-chair-flower-pink.html','catalog/product/view/id/248/category/50',1,NULL,NULL,50,248),(33679,5,'product/249','p-kolino-book-buggee-crown.html','catalog/product/view/id/249',1,NULL,NULL,NULL,249),(33680,5,'product/249/50','grayscale-magento-template/p-kolino-book-buggee-crown.html','catalog/product/view/id/249/category/50',1,NULL,NULL,50,249),(33681,5,'product/250','p-kolino-safari-duck-and-ostrich-chairs.html','catalog/product/view/id/250',1,NULL,NULL,NULL,250),(33682,5,'product/250/50','grayscale-magento-template/p-kolino-safari-duck-and-ostrich-chairs.html','catalog/product/view/id/250/category/50',1,NULL,NULL,50,250),(33683,5,'product/251','p-kolino-klick-children-s-desk-orange.html','catalog/product/view/id/251',1,NULL,NULL,NULL,251),(33684,5,'product/251/50','grayscale-magento-template/p-kolino-klick-children-s-desk-orange.html','catalog/product/view/id/251/category/50',1,NULL,NULL,50,251),(33685,5,'product/252','safari-collection-tree-table-w-animal-chairs.html','catalog/product/view/id/252',1,NULL,NULL,NULL,252),(33686,5,'product/252/50','grayscale-magento-template/safari-collection-tree-table-w-animal-chairs.html','catalog/product/view/id/252/category/50',1,NULL,NULL,50,252),(33687,5,'product/253','p-kolino-little-one-s-chair.html','catalog/product/view/id/253',1,NULL,NULL,NULL,253),(33688,5,'product/253/50','grayscale-magento-template/p-kolino-little-one-s-chair.html','catalog/product/view/id/253/category/50',1,NULL,NULL,50,253),(33691,5,'product/255','p-kolino-zebra-rocking-chair.html','catalog/product/view/id/255',1,NULL,NULL,NULL,255),(33692,5,'product/255/50','grayscale-magento-template/p-kolino-zebra-rocking-chair.html','catalog/product/view/id/255/category/50',1,NULL,NULL,50,255),(33709,1,'category/28','magento-template-features.html','catalog/category/view/id/28',1,NULL,NULL,28,NULL),(33862,1,'category/53','magento-template-features/static-pages.html','catalog/category/view/id/53',1,NULL,NULL,53,NULL),(33866,1,'category/61','magento-template-features/static-pages/highlighted-categories.html','catalog/category/view/id/61',1,NULL,NULL,61,NULL),(33867,1,'category/62','magento-template-features/static-pages/1-column-page.html','catalog/category/view/id/62',1,NULL,NULL,62,NULL),(33868,1,'category/63','magento-template-features/static-pages/2-columns-with-left-bar.html','catalog/category/view/id/63',1,NULL,NULL,63,NULL),(33869,1,'category/64','magento-template-features/static-pages/2-columns-with-right-bar.html','catalog/category/view/id/64',1,NULL,NULL,64,NULL),(33870,1,'category/65','magento-template-features/static-pages/3-columns-page.html','catalog/category/view/id/65',1,NULL,NULL,65,NULL),(33873,1,'category/69','magento-template-features/get-installed-store-on-our-magento-hosting.html','catalog/category/view/id/69',1,NULL,NULL,69,NULL),(33874,5,'category/28','magento-template-features.html','catalog/category/view/id/28',1,NULL,NULL,28,NULL),(33883,5,'product/1','test-product.html','catalog/product/view/id/1',1,NULL,NULL,NULL,1),(33980,5,'product/287','hot-bikini-white-yellow-or-black.html','catalog/product/view/id/287',1,NULL,NULL,NULL,287),(33982,5,'product/288','designer-monokini-halter-string-ties-womens-sexy-bikini.html','catalog/product/view/id/288',1,NULL,NULL,NULL,288),(33984,5,'product/289','metallic-slingshot-monokini-as-shown-one-size.html','catalog/product/view/id/289',1,NULL,NULL,NULL,289),(33986,5,'product/290','hot-bikini-leopard.html','catalog/product/view/id/290',1,NULL,NULL,NULL,290),(33988,5,'product/291','daisy-corsets-sequin-underwire-corset.html','catalog/product/view/id/291',1,NULL,NULL,NULL,291),(34027,5,'category/53','magento-template-features/static-pages.html','catalog/category/view/id/53',1,NULL,NULL,53,NULL),(34031,5,'category/61','magento-template-features/static-pages/highlighted-categories.html','catalog/category/view/id/61',1,NULL,NULL,61,NULL),(34032,5,'category/62','magento-template-features/static-pages/1-column-page.html','catalog/category/view/id/62',1,NULL,NULL,62,NULL),(34033,5,'category/63','magento-template-features/static-pages/2-columns-with-left-bar.html','catalog/category/view/id/63',1,NULL,NULL,63,NULL),(34034,5,'category/64','magento-template-features/static-pages/2-columns-with-right-bar.html','catalog/category/view/id/64',1,NULL,NULL,64,NULL),(34035,5,'category/65','magento-template-features/static-pages/3-columns-page.html','catalog/category/view/id/65',1,NULL,NULL,65,NULL),(34038,5,'category/69','magento-template-features/get-installed-store-on-our-magento-hosting.html','catalog/category/view/id/69',1,NULL,NULL,69,NULL),(37548,1,'category/87','magento-template-features/static-pages/most-popular-block.html','catalog/category/view/id/87',1,NULL,NULL,87,NULL),(37549,5,'category/87','magento-template-features/static-pages/most-popular-block.html','catalog/category/view/id/87',1,NULL,NULL,87,NULL),(39151,1,'category/3','popular-products.html','catalog/category/view/id/3',1,NULL,NULL,3,NULL),(39157,1,'category/51','home-tabs.html','catalog/category/view/id/51',1,NULL,NULL,51,NULL),(40097,1,'product/226/51','home-tabs/gund-all-stars-sports-glove-chair.html','catalog/product/view/id/226/category/51',1,NULL,NULL,51,226),(40110,1,'product/239/51','home-tabs/tot-tutors-book-rack-primary-colors.html','catalog/product/view/id/239/category/51',1,NULL,NULL,51,239),(40117,1,'product/243/51','home-tabs/p-kolino-book-buggee-in-orange.html','catalog/product/view/id/243/category/51',1,NULL,NULL,51,243),(40119,1,'product/244/3','popular-products/p-kolino-nesting-birds.html','catalog/product/view/id/244/category/3',1,NULL,NULL,3,244),(40123,1,'product/244/51','home-tabs/p-kolino-nesting-birds.html','catalog/product/view/id/244/category/51',1,NULL,NULL,51,244),(40128,1,'product/245/51','home-tabs/p-kolino-children-desk-white.html','catalog/product/view/id/245/category/51',1,NULL,NULL,51,245),(40137,1,'product/247/51','home-tabs/p-kolino-book-buggee-fire-truck.html','catalog/product/view/id/247/category/51',1,NULL,NULL,51,247),(40142,1,'product/248/51','home-tabs/p-kolino-new-little-reader-chair-flower-pink.html','catalog/product/view/id/248/category/51',1,NULL,NULL,51,248),(40352,5,'category/3','popular-products.html','catalog/category/view/id/3',1,NULL,NULL,3,NULL),(40358,5,'category/51','home-tabs.html','catalog/category/view/id/51',1,NULL,NULL,51,NULL),(41298,5,'product/226/51','home-tabs/gund-all-stars-sports-glove-chair.html','catalog/product/view/id/226/category/51',1,NULL,NULL,51,226),(41311,5,'product/239/51','home-tabs/tot-tutors-book-rack-primary-colors.html','catalog/product/view/id/239/category/51',1,NULL,NULL,51,239),(41318,5,'product/243/51','home-tabs/p-kolino-book-buggee-in-orange.html','catalog/product/view/id/243/category/51',1,NULL,NULL,51,243),(41320,5,'product/244/3','popular-products/p-kolino-nesting-birds.html','catalog/product/view/id/244/category/3',1,NULL,NULL,3,244),(41324,5,'product/244/51','home-tabs/p-kolino-nesting-birds.html','catalog/product/view/id/244/category/51',1,NULL,NULL,51,244),(41329,5,'product/245/51','home-tabs/p-kolino-children-desk-white.html','catalog/product/view/id/245/category/51',1,NULL,NULL,51,245),(41338,5,'product/247/51','home-tabs/p-kolino-book-buggee-fire-truck.html','catalog/product/view/id/247/category/51',1,NULL,NULL,51,247),(41343,5,'product/248/51','home-tabs/p-kolino-new-little-reader-chair-flower-pink.html','catalog/product/view/id/248/category/51',1,NULL,NULL,51,248),(42681,1,'product/292','simple-product-example.html','catalog/product/view/id/292',1,NULL,NULL,NULL,292),(42685,1,'product/293','virtual-product-example.html','catalog/product/view/id/293',1,NULL,NULL,NULL,293),(42688,1,'product/294','configurable-example.html','catalog/product/view/id/294',1,NULL,NULL,NULL,294),(42691,1,'product/295','grouped-product-example.html','catalog/product/view/id/295',1,NULL,NULL,NULL,295),(42694,1,'product/296','bundle-product-example.html','catalog/product/view/id/296',1,NULL,NULL,NULL,296),(42697,1,'product/297','downloadable-product-example.html','catalog/product/view/id/297',1,NULL,NULL,NULL,297),(42700,1,'product/298','product-with-options-example.html','catalog/product/view/id/298',1,NULL,NULL,NULL,298),(43904,5,'product/292','simple-product-example.html','catalog/product/view/id/292',1,NULL,NULL,NULL,292),(43908,5,'product/293','virtual-product-example.html','catalog/product/view/id/293',1,NULL,NULL,NULL,293),(43911,5,'product/294','configurable-example.html','catalog/product/view/id/294',1,NULL,NULL,NULL,294),(43914,5,'product/295','grouped-product-example.html','catalog/product/view/id/295',1,NULL,NULL,NULL,295),(43917,5,'product/296','bundle-product-example.html','catalog/product/view/id/296',1,NULL,NULL,NULL,296),(43920,5,'product/297','downloadable-product-example.html','catalog/product/view/id/297',1,NULL,NULL,NULL,297),(43923,5,'product/298','product-with-options-example.html','catalog/product/view/id/298',1,NULL,NULL,NULL,298),(44242,1,'59534900_1360780937','test-product-2.html','simple-product-example.html',0,'RP',NULL,NULL,292),(44250,5,'64001100_1360780937','test-product-2.html','simple-product-example.html',0,'RP',NULL,NULL,292),(44258,1,'24156200_1360780982','test-product-4.html','configurable-example.html',0,'RP',NULL,NULL,294),(44264,5,'27725000_1360780982','test-product-4.html','configurable-example.html',0,'RP',NULL,NULL,294),(44272,1,'69176500_1360780998','test-product-5.html','grouped-product-example.html',0,'RP',NULL,NULL,295),(44278,5,'72471100_1360780998','test-product-5.html','grouped-product-example.html',0,'RP',NULL,NULL,295),(46995,1,'product/298/50','grayscale-magento-template/product-with-options-example.html','catalog/product/view/id/298/category/50',1,NULL,NULL,50,298),(46998,5,'product/298/50','grayscale-magento-template/product-with-options-example.html','catalog/product/view/id/298/category/50',1,NULL,NULL,50,298),(47002,1,'product/297/50','grayscale-magento-template/downloadable-product-example.html','catalog/product/view/id/297/category/50',1,NULL,NULL,50,297),(47005,5,'product/297/50','grayscale-magento-template/downloadable-product-example.html','catalog/product/view/id/297/category/50',1,NULL,NULL,50,297),(47009,1,'product/292/50','grayscale-magento-template/simple-product-example.html','catalog/product/view/id/292/category/50',1,NULL,NULL,50,292),(47012,5,'product/292/50','grayscale-magento-template/simple-product-example.html','catalog/product/view/id/292/category/50',1,NULL,NULL,50,292),(47016,1,'product/293/50','grayscale-magento-template/virtual-product-example.html','catalog/product/view/id/293/category/50',1,NULL,NULL,50,293),(47019,5,'product/293/50','grayscale-magento-template/virtual-product-example.html','catalog/product/view/id/293/category/50',1,NULL,NULL,50,293),(47023,1,'product/296/50','grayscale-magento-template/bundle-product-example.html','catalog/product/view/id/296/category/50',1,NULL,NULL,50,296),(47026,5,'product/296/50','grayscale-magento-template/bundle-product-example.html','catalog/product/view/id/296/category/50',1,NULL,NULL,50,296),(47030,1,'product/294/50','grayscale-magento-template/configurable-example.html','catalog/product/view/id/294/category/50',1,NULL,NULL,50,294),(47033,5,'product/294/50','grayscale-magento-template/configurable-example.html','catalog/product/view/id/294/category/50',1,NULL,NULL,50,294),(47037,1,'product/295/50','grayscale-magento-template/grouped-product-example.html','catalog/product/view/id/295/category/50',1,NULL,NULL,50,295),(47040,5,'product/295/50','grayscale-magento-template/grouped-product-example.html','catalog/product/view/id/295/category/50',1,NULL,NULL,50,295),(114152,1,'category/94','magento-template-features/bonus-extensions.html','catalog/category/view/id/94',1,NULL,NULL,94,NULL),(114153,5,'category/94','magento-template-features/bonus-extensions.html','catalog/category/view/id/94',1,NULL,NULL,94,NULL),(114264,1,'category/95','magento-template-features/smart-catalog.html','catalog/category/view/id/95',1,NULL,NULL,95,NULL),(114265,5,'category/95','magento-template-features/smart-catalog.html','catalog/category/view/id/95',1,NULL,NULL,95,NULL),(114271,1,'18349500_1371474938','magento-template-features/bonus-extensions/smart-catalog-you-save-95.html','magento-template-features/smart-catalog.html',0,'RP',NULL,95,NULL),(114273,5,'19723500_1371474938','magento-template-features/bonus-extensions/smart-catalog-you-save-95.html','magento-template-features/smart-catalog.html',0,'RP',NULL,95,NULL),(114276,1,'category/99','magento-template-features/bonus-extensions/custom-magento-menu.html','catalog/category/view/id/99',1,NULL,NULL,99,NULL),(114277,5,'category/99','magento-template-features/bonus-extensions/custom-magento-menu.html','catalog/category/view/id/99',1,NULL,NULL,99,NULL),(114280,1,'category/101','magento-template-features/bonus-extensions/third-party-extensions.html','catalog/category/view/id/101',1,NULL,NULL,101,NULL),(114281,5,'category/101','magento-template-features/bonus-extensions/third-party-extensions.html','catalog/category/view/id/101',1,NULL,NULL,101,NULL),(114283,1,'92070800_1389159637','kids-magento-template.html','grayscale-magento-template.html',0,'RP',NULL,50,NULL),(114286,1,'95565600_1389159637','kids-magento-template/gund-all-stars-sports-glove-chair.html','grayscale-magento-template/gund-all-stars-sports-glove-chair.html',0,'RP',NULL,50,226),(114289,1,'96000400_1389159637','kids-magento-template/disney-princess-pretty-pink-toddler-bed.html','grayscale-magento-template/disney-princess-pretty-pink-toddler-bed.html',0,'RP',NULL,50,227),(114292,1,'96483400_1389159637','kids-magento-template/nickelodeon-sponge-bob-toddler-bed.html','grayscale-magento-template/nickelodeon-sponge-bob-toddler-bed.html',0,'RP',NULL,50,231),(114295,1,'96941300_1389159637','kids-magento-template/4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html','grayscale-magento-template/4gr8-kidz-racing-series-toddler-bed-with-safe-sleep-rails.html',0,'RP',NULL,50,232),(114298,1,'97385200_1389159637','kids-magento-template/nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html','grayscale-magento-template/nickelodeon-s-dora-the-explorer-multi-bin-toy-organizer.html',0,'RP',NULL,50,236),(114301,1,'97891000_1389159637','kids-magento-template/tot-tutors-kids-table-and-4-chair-set-plastic.html','grayscale-magento-template/tot-tutors-kids-table-and-4-chair-set-plastic.html',0,'RP',NULL,50,238),(114304,1,'98330300_1389159637','kids-magento-template/tot-tutors-book-rack-primary-colors.html','grayscale-magento-template/tot-tutors-book-rack-primary-colors.html',0,'RP',NULL,50,239),(114307,1,'98764100_1389159637','kids-magento-template/p-kolino-little-sofa-sleeper-green.html','grayscale-magento-template/p-kolino-little-sofa-sleeper-green.html',0,'RP',NULL,50,241),(114310,1,'99211700_1389159637','kids-magento-template/p-kolino-silly-soft-seating-lila.html','grayscale-magento-template/p-kolino-silly-soft-seating-lila.html',0,'RP',NULL,50,242),(114313,1,'99642000_1389159637','kids-magento-template/p-kolino-book-buggee-in-orange.html','grayscale-magento-template/p-kolino-book-buggee-in-orange.html',0,'RP',NULL,50,243),(114316,1,'00069100_1389159638','kids-magento-template/p-kolino-nesting-birds.html','grayscale-magento-template/p-kolino-nesting-birds.html',0,'RP',NULL,50,244),(114319,1,'00498700_1389159638','kids-magento-template/p-kolino-children-desk-white.html','grayscale-magento-template/p-kolino-children-desk-white.html',0,'RP',NULL,50,245),(114322,1,'00933900_1389159638','kids-magento-template/p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html','grayscale-magento-template/p-kolino-tree-trable-with-zebra-and-giraffe-chairs.html',0,'RP',NULL,50,246),(114325,1,'01364300_1389159638','kids-magento-template/p-kolino-book-buggee-fire-truck.html','grayscale-magento-template/p-kolino-book-buggee-fire-truck.html',0,'RP',NULL,50,247),(114328,1,'01796800_1389159638','kids-magento-template/p-kolino-new-little-reader-chair-flower-pink.html','grayscale-magento-template/p-kolino-new-little-reader-chair-flower-pink.html',0,'RP',NULL,50,248),(114331,1,'02226000_1389159638','kids-magento-template/p-kolino-book-buggee-crown.html','grayscale-magento-template/p-kolino-book-buggee-crown.html',0,'RP',NULL,50,249),(114334,1,'02657600_1389159638','kids-magento-template/p-kolino-safari-duck-and-ostrich-chairs.html','grayscale-magento-template/p-kolino-safari-duck-and-ostrich-chairs.html',0,'RP',NULL,50,250),(114337,1,'03088400_1389159638','kids-magento-template/p-kolino-klick-children-s-desk-orange.html','grayscale-magento-template/p-kolino-klick-children-s-desk-orange.html',0,'RP',NULL,50,251),(114340,1,'03519200_1389159638','kids-magento-template/safari-collection-tree-table-w-animal-chairs.html','grayscale-magento-template/safari-collection-tree-table-w-animal-chairs.html',0,'RP',NULL,50,252),(114343,1,'03949600_1389159638','kids-magento-template/p-kolino-little-one-s-chair.html','grayscale-magento-template/p-kolino-little-one-s-chair.html',0,'RP',NULL,50,253),(114346,1,'04378200_1389159638','kids-magento-template/p-kolino-zebra-rocking-chair.html','grayscale-magento-template/p-kolino-zebra-rocking-chair.html',0,'RP',NULL,50,255),(114373,1,'08607200_1389159638','kids-magento-template/simple-product-example.html','grayscale-magento-template/simple-product-example.html',0,'RP',NULL,50,292),(1