<?php
/**
 * Venustheme
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Venustheme EULA that is bundled with
 * this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.venustheme.com/LICENSE-1.0.html
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the extension
 * to newer versions in the future. If you wish to customize the extension
 * for your needs please refer to http://www.venustheme.com/ for more information
 *
 * @category   Ves
 * @package    Ves_Blog
 * @copyright  Copyright (c) 2014 Venustheme (http://www.venustheme.com/)
 * @license    http://www.venustheme.com/LICENSE-1.0.html
 */

/**
 * Ves Blog Extension
 *
 * @category   Ves
 * @package    Ves_Blog
 * @author     Venustheme Dev Team <venustheme@gmail.com>
 */
class Ves_Blog_Model_Mysql4_Post extends Mage_Core_Model_Mysql4_Abstract {
    /**
     * Initialize resource model
     */
    protected function _construct() {
      $this->_init('ves_blog/post', 'post_id');
    }

    /**
     * Load images
     */
   // public function loadImage(Mage_Core_Model_Abstract $object) {
   //     return $this->__loadImage($object);
   // }

         /**
     * Assign page to store views
     *
     * @param Mage_Core_Model_Abstract $object
     */
         protected function _afterSave(Mage_Core_Model_Abstract $object)
         {
           
            if(Mage::helper("ves_blog")->isAdmin()) {
                $stores = $object->getData('stores');
                $condition = $this->_getWriteAdapter()->quoteInto('post_id = ?', $object->getId());
            // process faq item to store relation
                $this->_getWriteAdapter()->delete($this->getTable('ves_blog/post_store'), $condition);

                if($stores){
                  foreach ((array) $object->getData('stores') as $store) {
                    $storeArray = array ();
                    $storeArray['post_id'] = $object->getId();
                    $storeArray['store_id'] = $store;
                    $this->_getWriteAdapter()->insert(
                      $this->getTable('ves_blog/post_store'), $storeArray
                      );
                  }
                }else{
                  $stores = $object->getStoreId();
                  if($stores) {
                    foreach ((array) $stores as $store) {
                      $storeArray = array ();
                      $storeArray['post_id'] = $object->getId();
                      $storeArray['store_id'] = $store;
                      $this->_getWriteAdapter()->insert(
                        $this->getTable('ves_blog/post_store'), $storeArray
                        );
                    }
                  }

                }
                //Rewrite blog url
                $resroute = Mage::getStoreConfig('ves_blog/general_setting/route');
                $extension = Mage::getStoreConfig('ves_blog/general_setting/extension');
                $extension = $extension?".".$extension:"";
                $stores = $object->getData('stores');

                if($stores && isset($stores[0]) && $stores[0]) {

                    foreach($stores as $store_id) {
                      Mage::getModel('core/url_rewrite')
                        ->loadByIdPath('venusblog/post/'.$object->getId()."/store_id/".$store_id)
                        ->setIdPath('venusblog/post/'.$object->getId()."/store_id/".$store_id)
                        ->setRequestPath( $resroute.'/'.$object->getIdentifier().$extension)
                        ->setTargetPath('venusblog/post/view/id/'.$object->getId())
                        ->setStoreId($store_id)
                        ->save();
                    }
                } else {
                    Mage::getModel('core/url_rewrite')
                    ->loadByIdPath('venusblog/post/'.$object->getId())
                    ->setIdPath('venusblog/post/'.$object->getId())
                    ->setRequestPath( $resroute.'/'.$object->getIdentifier().$extension)
                    ->setTargetPath('venusblog/post/view/id/'.$object->getId())
                    ->save();
                }
            }
            return parent::_afterSave($object);
        }

  /**
   * Do store and category processing after loading
   *
   * @param Mage_Core_Model_Abstract $object Current faq item
   */
  protected function _afterLoad(Mage_Core_Model_Abstract $object)
  {
    // process faq item to store relation
    $select = $this->_getReadAdapter()->select()->from(
      $this->getTable('ves_blog/post_store')
      )->where('post_id = ?', $object->getId());

    if ($data = $this->_getReadAdapter()->fetchAll($select)) {
      $storesArray = array ();
      foreach ($data as $row) {
        $storesArray[] = $row['store_id'];
      }
      $object->setData('store_id', $storesArray);
      $object->setData('stores', $storesArray);

    }
    
    return parent::_afterLoad($object);
  }

  public function lookupStoreIds($post_id = 0){
    $select = $this->_getReadAdapter()->select()->from(
      $this->getTable('ves_blog/post_store')
      )->where('post_id = ?', (int)$post_id);

    $storesArray = array ();

    if ($data = $this->_getReadAdapter()->fetchAll($select)) {

      foreach ($data as $row) {
        $storesArray[] = $row['store_id'];
      }
    }
    return $storesArray;
  }

    /**
     * Call-back function
     */
    protected function _beforeSave(Mage_Core_Model_Abstract $object) {
        // Cleanup stats on blog delete
      $adapter = $this->_getReadAdapter();
      $identifier = $object->getData('identifier');
      $identifier = trim($identifier);
      $identifier = strtolower($identifier);
      $identifier = str_replace(' ','-', $identifier);
      $object->setData('identifier', $identifier);
      return parent::_beforeSave($object);
    }

    /**
     * Retrieve select object for load object data
     *
     * @param string $field
     * @param mixed $value
     * @return Zend_Db_Select
     */
    protected function _getLoadSelect($field, $value, $object) {
      $select = parent::_getLoadSelect($field, $value, $object);

      return $select;
    }


    /**
     * Call-back function
     */
    protected function _beforeDelete(Mage_Core_Model_Abstract $object) {
        // Cleanup stats on blog delete
      $adapter = $this->_getReadAdapter();
        // 1. Delete blog/store
        //$adapter->delete($this->getTable('ves_blog/post_store'), 'post_id='.$object->getId());
        // 2. Delete blog/post_cat

      return parent::_beforeDelete($object);
    }


  }
