/* --------------------------------------------- 
* Filename:     custom.js
* Version:      1.0.0 (2016-03-05)
* Website:      http://www.zymphonies.com
* Description:  Global Script
* Author:       Zymphonies Team
                info@zymphonies.com
-----------------------------------------------*/

function clients_owl(){
	jQuery('.field--name-field-clients-logo').owlCarousel({
		items: 2,
		margin:10,
		dots: true,
		autoPlay: 3000,
		navigation : true,
		responsive : {
			500:{ items: 2, dots: true, navigation : true },
			700:{ items: 3, dots: true, navigation : true },
			900:{ items: 4, dots: true, navigation : true }
		}
	});
}

function service_owl(){
	jQuery('.field--name-field-service').owlCarousel({
		items: 1,
		margin:10,
		dots: true,
		autoPlay: 3000,
		navigation : true,
		responsive : {
			500:{ items: 1, dots: true, navigation : true },
			700:{ items: 2, dots: true, navigation : true },
			900:{ items: 3, dots: true, navigation : true }
		}
	});
}

wow = new WOW({
	boxClass: 'wow',
	animateClass: 'animated',
	offset: 0,
	mobile: false,
	live: true
});


function theme_menu(){

	//Main menu
	jQuery('#main-menu').smartmenus();
	
	//Mobile menu toggle
	jQuery('.navbar-toggle').click(function(){
		jQuery('.region-primary-menu').slideToggle();
	});

	//Mobile dropdown menu
	if ( jQuery(window).width() < 767) {
		jQuery(".region-primary-menu li a:not(.has-submenu)").click(function () {
			jQuery('.region-primary-menu').hide();
	    });
	}

}

function theme_home(){
	
	//flexslider
	jQuery('.flexslider').flexslider({
    	animation: "slide"	
    });

	// primary-menu 
	jQuery('.region-primary-menu a').click(function() {
      if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
          var target = jQuery(this.hash);
          target = target.length ? target : jQuery('[name=' + this.hash.slice(1) + ']');
          if (target.length) {
              jQuery('html,body').animate({
                  scrollTop: target.offset().top
              }, 1000);
              return false;
          }
      	}
  	});

}

jQuery(document).ready(function($){
	wow.init();
	clients_owl();
	service_owl();
	theme_menu();
	theme_home();	
});