<?php
/**
	This File handles Customizer Options
	* @version:1.0
*/

//include_once( 'admin/kirki/kirki.php' );


// Early exit if Kirki is not installed
if ( ! class_exists( 'Kirki' ) ) {
	return;
}
 
/**
 * Configuration sample for the Kirki Customizer.
 */
function navthemes_configuration() {

	$args = array(
		'logo_image'   => 'http://navthemes.com/branding/inthemes/logo.png',
		'url_path' => get_stylesheet_directory_uri() . '/admin/kirki/'
   );

	return $args;

}

add_filter( 'kirki/config', 'navthemes_configuration' );


/*=================================
	Priorities-

* NavThemes Branding  - 10 
* Maintenance Service- 11
* Sample Content      - 12
* General settings    - 20-49
* Front page          - 50-136
* Contact Section     - 137-140
* Google Map 		  - 142-147

================================= */


/*=================================
	Panels Priorities-

* NavThemes Branding  - 1 
* Sample Content      - 2
* General Settings    - 3
* Front Page          - 4
* Contact Section 	  - 5
* Google Map 		  - 6
================================= */


/*=================================
	Config	
  ================================= */

Kirki::add_config( 'cowork-lite', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
 	
) );

	/*------------------------------------------
     NavThemes Branding
     ------------------------------------------*/

     $theme = wp_get_theme();
	 $theme_version = $theme->get( 'Version' );
	 $theme_name = $theme->get( 'Name' );
 
  Kirki::add_section( 'NavThemes_Support', array(
			'title'          => __( 'NavThemes Support', 'navthemes' ),
			'description'    => sprintf( 'You are using Free version of %s Theme, Check out Paid version, which comes with many exciting features in the package.', __($theme->Name, 'navthemes','cowork-lite') ),
			'priority'       => 1,
	) );
			
		Kirki::add_field( 'navthemes', array(
		'type'        => 'custom',
		'settings'     => 'navthemes_support',
		'section'     => 'NavThemes_Support',
		'default'     => sprintf( '<div id="navthemes_branding"><h1>Get Premium Version of %s for Just $59</h1>
			<div class="navthemes-links">
			<ul>
				<li><a target="_blank" href="%s">Check out All Features of Paid version</a></li>
				<li><a target="_blank" href="%s1">View Demo</a></li>
			</ul> 
		</div>
		</div>', __($theme->Name, 'navthemes','cowork-lite'), 'https://www.navthemes.com/wp-themes/cowork-pro-wordpress-theme/' , 'http://demo.navthemes.com/?demo=cowork-pro&c=OZcdK2Gt' ),
		'priority'    => 10,
	) );    

/*------------------------------------------
    Maintenance Service
    ------------------------------------------*/

Kirki::add_section( 'NavThemes_Maintenance_Service', array(
            'title'          => __( 'Maintenance Service', 'navthemes' ),
            'description'    => sprintf( '<h1> Managing WordPress Site is a hassle ? Let us handle that.

</h1>', __($theme->Name, 'navthemes','cowork-lite') ),
            'priority'       => 2,
    ) );
            

        Kirki::add_field( 'navthemes', array(
        'type'        => 'custom',
        'settings'     => 'navThemes_maintenance_service',
        'section'     => 'NavThemes_Maintenance_Service',
        'default'     => sprintf( '<div id="navthemes_maintenance">
        <div class="themeisle-upsell"> 
        <h1>**Key Features**</h1>
            <h3>FREE Lightning Fast Hosting <span class="color_span" ><br>This is a Google Ranking factor. </span></h3>
            <h3>FREE SSL Certificate   <span class="color_span"> <br>This is a Google Ranking factor. </span></h3> 
            <h3>24/7 Uptime monitoring</h3>
            <h3>Access All NavThemes Premium WordPress Themes and Plugins</h3>
            <h3>Free Migration Service to our hosting</h3>
            <h3>Free CDN Service</h3>
            <h3>Unlimited Website Edits</h3>
            <h3>Hack/Malware Removal</h3>
            <h3>Weekly Website Report</h3>
            <div class="navthemes-links">
            <ul>
            <li>

            <a target="_blank" href="http://navthemes.com/wordpress-management-service/?utm_source=cowork-lite&utm_medium=lite-wordpress-theme&utm_campaign=customizer&utm_term=maintenance-service" class="button button-primary button_70">Starting at just $39/Month</a>
          </li>

                
            </ul>
            </div>
        </div>
        </div>', __($theme->Name, 'navthemes','cowork-lite'), 'https://www.navthemes.com/free-wordpress-theme/ cowork-lite-wordpress-theme/'),
        'priority'    => 11,
    ) );


	/*=================================
		Sample Content	
	 ================================= */
	
	Kirki::add_section( 'required_settings', array(
		'title'          => __( 'Sample Content', 'cowork-lite' ), 
		'priority'       => 3,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'cowork-lite', array(
				'section'  => 'required_settings',
				'type'     => 'custom',
				'priority' => 10,
				'default'  =>sprintf('<div><h3>Once you have installed and activated all recommended plugins, to setup your theme look like demo Follow these steps.
					<ol>
						<li>Download <a target="_blank" href="%s">this</a> file</li>
						<li>Import this file in customizer, Check <a target="_blank" href="%s">instructions</a> here.</li>
						<li>Once imported, publish it.</li>
					</ol>
					</h3>
		</div>
		<div id="navthemes_maintenance">
		 <a target="_blank" href="https://docs.navthemes.com/docs/cowork-lite/" class="button button-primary button_70">Documentation</a>
		 </div>', 'https://docs.navthemes.com/download/2407/', 'https://docs.navthemes.com/docs/cowork-lite/sample-content/'),
		'priority'    => 12,
	) );   
	



/*--------------------------------------------------------------------------
  --------------------------------------------------------------------------
			General Settings
--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
			
	Kirki::add_panel( 'general_settings', array(
		'priority'    => 4,
		'title'       => __( 'General Setting', 'cowork-lite' ),
		'description' => __( 'Manage General Setting from here', 'cowork-lite' ),
	) );
	
	/*=================================
		General Section	
  	================================= */
		
	Kirki::add_section( 'general_settings', array(
		'title'          => __( 'Header Image', 'cowork-lite' ),
		'description'    => __( 'From Here You Can Manage Header Background Image' , 'cowork-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 20,
		'capability'     => 'edit_theme_options', 
	) );
  
	Kirki::add_field( 'cowork-lite', array(
			'settings' => 'inner_page_bg_image',
			'label'    => __( 'Inner Pages Title Background image', 'cowork-lite' ),
			'section'  => 'general_settings',
			'type'     => 'image',
			'priority' => 21,
			'default'  => get_template_directory_uri() . '/assets/images/slider_bg.jpg',
		 
		) );
			

	 /*=========================================================
	 						Logo Setting 
	 ==========================================================*/						
      Kirki::add_section( 'logo_settings', array(
			'title'          => __( 'Logo Setting', 'cowork-lite' ),
			'description'    => __( 'From Here You Can Manage Manage Setting' , 'cowork-lite' ),
			'panel'          => 'general_settings', 
			'priority'       => 23,
			'capability'     => 'edit_theme_options', 
		) );
	
		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'logo',
				'label'    => __( 'Logo', 'cowork-lite' ),
				'section'  => 'logo_settings',
				'type'     => 'image',
				'priority' => 24,
				'default'  => '',
			 
			) );

 
			/*----------------------------------
						Menu Settings
			*----------------------------------*/
			
		Kirki::add_section( 'menu_settings1', array(
			'title'          => __( 'Menu Settings', 'cowork-lite' ),
			'description'    => __( 'From Here You Can Manage Menu Settings' , 'cowork-lite' ),
			'panel'          => 'general_settings', 
			'priority'       => 25,
			'capability'     => 'edit_theme_options', 
		) );
		
		Kirki::add_field( 'cowork-lite', array(
			'settings' => 'nav_menu_name',
			'label'    => __( 'Choose a Menu', 'cowork-lite' ),
			'section'  => 'menu_settings1',
			'type'     => 'select',
			'priority' => 26,
			'choices'  => cowork_lite_nav_menus(),
		) );
 	
		Kirki::add_field( 'cowork-lite', array(
		'settings' => 'nav_menu_position_pro_message',
		'label'    => '',
		'section'  => 'menu_settings1',
		'type'     => 'custom',
		'priority' => 27,
		'default'     => '',
	) );
			
		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'nav_menu_position',
				'label'    => __( 'Choose Menu Position', 'cowork-lite' ),
				'section'  => 'menu_settings1',
				'type'     => 'select',
				'priority' => 28,
				'default'  => 'after',
				'choices'     => array(
					'after'   => esc_attr__( 'After', 'cowork-lite' ),
					'before' => esc_attr__( 'Before', 'cowork-lite' ), 
				),
	 		) );		


	/*=================================
		Navigation social Section	
  	================================= */

	Kirki::add_section( 'nav_social_settings', array(
		'title'          => __( 'Navigation Social Settings', 'cowork-lite' ),
		'description'    => __( 'From Here You Can Manage Navigation Social Settings' , 'cowork-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 29,
		'capability'     => 'edit_theme_options', 
	) );
		
		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'navfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'cowork-lite' ),
                'section'  => 'nav_social_settings',
                'type'     => 'toggle',
                'priority' => 30,
                'default'  => 1,          
            ) );

		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'nav_social_facebook',
				'label'    => __( 'Facebook', 'cowork-lite' ),
				'section'  => 'nav_social_settings',
				'type'     => 'url',
				'priority' => 31,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'navtwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'cowork-lite' ),
                'section'  => 'nav_social_settings',
                'type'     => 'toggle',
                'priority' => 32,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'nav_social_twitter',
				'label'    => __( 'Twiiter', 'cowork-lite' ),
				'section'  => 'nav_social_settings',
				'type'     => 'url',
				'priority' => 34,
				'default'  => '#',
			) );


		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'navinstagramonoff',
                'label'    => __( 'Instagram Active/Inactive', 'cowork-lite' ),
                'section'  => 'nav_social_settings',
                'type'     => 'toggle',
                'priority' => 35,
                'default'  => 1,          
            ) );
	
		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'nav_social_instagram',
				'label'    => __( 'Instagram', 'cowork-lite' ),
				'section'  => 'nav_social_settings',
				'type'     => 'url',
				'priority' => 36,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'navlinkedinonoff',
                'label'    => __( 'Linkedin Active/Inactive', 'cowork-lite' ),
                'section'  => 'nav_social_settings',
                'type'     => 'toggle',
                'priority' => 37,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'nav_social_linkedin',
				'label'    => __( 'Linkedin', 'cowork-lite' ),
				'section'  => 'nav_social_settings',
				'type'     => 'url',
				'priority' => 38,
				'default'  => '#',
			) );


			/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Footer Text Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'footer_text', array(
		'title'          => __( 'Footer Copyright Text Setting', 'cowork-lite' ),
		'description'    => __( 'From here you can manage text of footer', 'cowork-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 41,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'footer_theme_text',
				'label'    => __( 'Field', 'cowork-lite' ),
				'section'  => 'footer_text',
				'type'     => 'textarea',
				'priority' => 42,
				'default'  => '',
			) );	

    /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page  Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_panel( 'home_page', array(
    'priority'    => 4,
    'title'       => __( 'Front Page ', 'cowork-lite' ),
    'description' => __( 'Manage home page from here', 'cowork-lite' ),
	) );


	 /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Header Section
	  --------------------------------------------------------------------------
	  --------------------------------------------------------------------------*/

	Kirki::add_section( 'home_banner', array(
		'title'          => __( 'Header Content Setting', 'cowork-lite' ),
		'description'    => __( 'From here you can manage background image, Title and Text of banner', 'cowork-lite' ),
		'panel'          => 'home_page', 
		'priority'       => 1,
		'capability'     => 'edit_theme_options',
	) );


	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_welcome_title',
				'label'    => __( 'Heading ', 'cowork-lite' ),
				'section'  => 'home_banner',
				'type'     => 'text',
				'priority' => 31,
				'default'  => 'Co-Work Custom Office',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_welcome_title_text',
				'label'    => __( 'Content', 'cowork-lite' ),
				'section'  => 'home_banner',
				'type'     => 'textarea',
				'priority' => 32,
				'default'  => 'Located in Jaipur Center, This Custom Designed Office by Skootr,<br> 
                was Developed Exclusively for Mattsenkumar.<br>
                Call us +91-955 510 0999',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_welcome_title_button',
				'label'    => __( 'Button', 'cowork-lite' ),
				'section'  => 'home_banner',
				'type'     => 'text',
				'priority' => 33,
				'default'  => 'Contact',
			) );

	Kirki::add_field( 'cowork-lite', array(
			'settings' => 'home_welcome_title_buttonlink',
			'label'    => __( 'Link', 'cowork-lite' ),
			'section'  => 'home_banner',
			'type'     => 'text',
			'priority' => 34,

			'default'  => '#',
		) );	



    /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page about Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'home_about', array(
		'title'          => __( 'About Setting', 'cowork-lite' ),
		'description'    => __( 'From here you can manage about image, Title and Text of banner', 'cowork-lite' ),
		'panel'          => 'home_page', 
		'priority'       => 2,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_about_title',
				'label'    => __( 'Heading', 'cowork-lite' ),
				'section'  => 'home_about',
				'type'     => 'text',
				'priority' => 44,
				'default'  => 'What is Cowork?',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_about_title_text',
				'label'    => __( 'Content', 'cowork-lite' ),
				'section'  => 'home_about',
				'type'     => 'textarea',
				'priority' => 45,
				'default'  => '',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_about_title_button',
				'label'    => __( 'Button', 'cowork-lite' ),
				'section'  => 'home_about',
				'type'     => 'text',
				'priority' => 46,
				'default'  => 'Read More',
			) );

	Kirki::add_field( 'cowork-lite', array(
			'settings' => 'home_about_title_buttonlink',
			'label'    => __( 'Link', 'cowork-lite' ),
			'section'  => 'home_about',
			'type'     => 'textarea',
			'priority' => 47,
			'default'  => '#',
		) );

	
	Kirki::add_field( 'cowork-lite', array(
				'type'        => 'repeater',
				'label'       => esc_attr__( 'Repeater Control', 'cowork-lite' ),
				'section'     => 'home_about',
				'settings' => 'homepage_about_cowork',
				'priority'    => 48,
				
				'row_label' => array(
					'type' => 'text',
					'value' => esc_attr__('Partner', 'cowork-lite' ),
				),
				'choices'     => array(
							'save_as' => 'array',
							),

				'button_label' => esc_attr__('"Add new"', 'cowork-lite' ),

				
				'fields' => array(
					'cowork_image'  => array(
							'type' => 'image',
							'settings'    => 'partner_image_setting_array',
							'label'       => esc_attr__( 'Partner Image', 'cowork-lite' ),
							'section'     => 'home_about',
							'priority'    => 49,
							'default'  => '',
							
						),
				
					)
				) );





/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Pricing Plans Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'home_Pricing_Plans', array(
		'title'          => __( 'Pricing Plans Setting', 'cowork-lite' ),
		'description'    => __( 'From here you can manage About Pricing Plans image, Title and Text of banner', 'cowork-lite' ),
		'panel'          => 'home_page', 
		'priority'       => 3,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_heading',
				'label'    => __( 'heading', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'text',
				'priority' => 50,
				'default'  => 'About Community',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_heading_text',
				'label'    => __( 'Content', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'textarea',
				'priority' => 51,
				'default'  => '',
			) );

	Kirki::add_field( 'cowork-lite', array(
                'settings' => 'home_Pricing_head1_icon',
                'label'    => __( 'Box 1 Icon', 'cowork-lite' ),
                'section'  => 'home_Pricing_Plans',
                'type'     => 'fontawesome',
                'priority' => 52,
                'default'  => 'fa fa-object-group',
             
            ) );
	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_head1',
				'label'    => __( 'Box 1 pricing heading', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'text',
				'priority' => 53,
				'default'  => 'Open Space',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_head1_rupee',
				'label'    => __( 'Box 1 pricing ', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'text',
				'priority' => 54,
				'default'  => '$30',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_head1_year',
				'label'    => __( 'Box 1 pricing year', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'text',
				'priority' => 55,
				'default'  => '/months',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_head1_text',
				'label'    => __( 'Box 1 pricing text', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'textarea',
				'priority' => 56,
				'default'  => 'Lorem Ipsum is simply dummy text <br> of the printing',
			) );

	Kirki::add_field( 'cowork-lite', array(
				'settings' => 'home_Pricing_head1_button',
				'label'    => __( 'Box 1 button text', 'cowork-lite' ),
				'section'  => 'home_Pricing_Plans',
				'type'     => 'text',
				'priority' => 57,
				'default'  => 'book now',
			) );

				Kirki::add_field( 'cowork-lite', array(
					'settings' => 'home_Pricing_head1_buttonlink',
					'label'    => __( 'Box 1 button Link', 'cowork-lite' ),
					'section'  => 'home_Pricing_Plans',
					'type'     => 'textarea',
					'priority' => 58,
					'default'  => '#',
				) );

				Kirki::add_field( 'cowork-lite', array(
			                'settings' => 'home_Pricing_head2_icon',
			                'label'    => __( 'Box 2 Icon', 'cowork-lite' ),
			                'section'  => 'home_Pricing_Plans',
			                'type'     => 'fontawesome',
			                'priority' => 59,
			                'default'  => 'fa fa-outdent',
			             
			            ) );
				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head2',
							'label'    => __( 'Box 2 pricing heading', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 60,
							'default'  => 'Dedicated Desk',
						) );

				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head2_rupee',
							'label'    => __( 'Box 2 pricing', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 61,
							'default'  => '$54',
							) );

				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head2_year',
							'label'    => __( 'Box 2 pricing year', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 62,
							'default'  => '/months',
						) );

				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head2_text',
							'label'    => __( 'Box 2 pricing text', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'textarea',
							'priority' => 63,
							'default'  => 'Lorem Ipsum is simply dummy text <br> of the printing',
						) );
				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head2_button',
							'label'    => __( 'Box 2 button text', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 64,
							'default'  => 'book now',
						) );

				Kirki::add_field( 'cowork-lite', array(
					'settings' => 'home_Pricing_head2_buttonlink',
					'label'    => __( 'Box 2 button Link', 'cowork-lite' ),
					'section'  => 'home_Pricing_Plans',
					'type'     => 'textarea',
					'priority' => 65,
					'default'  => '#',
				) );

				Kirki::add_field( 'cowork-lite', array(
			                'settings' => 'home_Pricing_head3_icon',
			                'label'    => __( 'Box 3 Icon', 'cowork-lite' ),
			                'section'  => 'home_Pricing_Plans',
			                'type'     => 'fontawesome',
			                'priority' => 67,
			                'default'  => 'fa fa-building',
			             
			            ) );
				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head3',
							'label'    => __( 'Box 3 pricing heading', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 68,
							'default'  => 'Private Office  ',
						) );

				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head3_rupee',
							'label'    => __( 'Box 3 pricing', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 69,
							'default'  => '$99',
						) );

				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head3_year',
							'label'    => __( 'Box 3 pricing year', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 70,
							'default'  => '/months',
						) );

				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head3_text',
							'label'    => __( 'Box 3 pricing text', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'textarea',
							'priority' => 71,
							'default'  => 'Lorem Ipsum is simply dummy text <br> of the printing',
						) );
				Kirki::add_field( 'cowork-lite', array(
							'settings' => 'home_Pricing_head3_button',
							'label'    => __( 'Box 3 button text', 'cowork-lite' ),
							'section'  => 'home_Pricing_Plans',
							'type'     => 'text',
							'priority' => 72,
							'default'  => 'book now',
						) );

				Kirki::add_field( 'cowork-lite', array(
						'settings' => 'home_Pricing_head3_buttonlink',
						'label'    => __( 'Box 3 button Link', 'cowork-lite' ),
						'section'  => 'home_Pricing_Plans',
						'type'     => 'textarea',
						'priority' => 73,
						'default'  => '#',
				) );

        /*--------------------------------------------------------------------------
	     --------------------------------------------------------------------------
				Home Page Testimonials Section
	    --------------------------------------------------------------------------
	    --------------------------------------------------------------------------*/

	        Kirki::add_section( 'home_Testimonials', array(
						'title'          => __( 'Testimonials Setting', 'cowork-lite' ),
						'description'    => __( 'From here you can manage Testimonials image, Title and Text of banner', 'cowork-lite' ),
						'panel'          => 'home_page', 
						'priority'       => 7,
						'capability'     => 'edit_theme_options',
					) );

         	Kirki::add_field( 'cowork-lite', array(
						'settings' => 'home_Testimonials_heading',
						'label'    => __( 'Heading', 'cowork-lite' ),
						'section'  => 'home_Testimonials',
						'type'     => 'text',
						'priority' => 127,
						'default'  => 'TESTIMONIALS',
					) );



			/*--------------------------------------------------------------------------
			  --------------------------------------------------------------------------
						Home Page Contact Section
			--------------------------------------------------------------------------
			--------------------------------------------------------------------------*/

			Kirki::add_section( 'home_contact', array(
						'title'          => __( 'Contact Section', 'cowork-lite' ),
						'priority'       => 5,
						'capability'     => 'edit_theme_options',
					) );

			Kirki::add_field( 'cowork-lite', array(
						'settings' => 'home_contact_heading',
						'label'    => __( 'Heading', 'cowork-lite' ),
						'section'  => 'home_contact',
						'type'     => 'text',
						'priority' => 137,
						'default'  => 'Contact',
					) );

			Kirki::add_field( 'cowork-lite', array(
						'settings' => 'home_contact_head_text',
						'label'    => __( 'Content', 'cowork-lite' ),
						'section'  => 'home_contact',
						'type'     => 'textarea',
						'priority' => 138,
						'default'  => '',
					) );


			Kirki::add_field( 'cowork-lite', array(
				'settings' => 'contact7_code',
				'label'    => __( 'Contact 7 Code', 'cowork-lite' ),
				'section'  => 'home_contact',
				'type'     => 'text',
				'priority' => 139,
				'default'  => '',
				
			) );

			Kirki::add_field( 'cowork-lite', array(
						'settings' => 'home_contact_head_button',
						'label'    => __( 'Button', 'cowork-lite' ),
						'section'  => 'home_contact',
						'type'     => 'text',
						'priority' => 140,
						'default'  => 'SEND REQUEST',
					) );


			/*------------------------------------------
				Google Map Section	
		  	------------------------------------------*/
	
			Kirki::add_section( 'homepage_googlemap', array(
					'title'          => __( 'Google Map Setting', 'cowork-lite' ),
					'priority'       => 6,
					'capability'     => 'edit_theme_options',
					'theme_supports' => '', // Rarely needed.
				) );
			 	
			/*------------------------------------------
				Add Fields to Google Map Section
			------------------------------------------*/
	 	
			// Switch
			Kirki::add_field( 'cowork-lite', array(
				'type'        => 'switch',
				'settings'    => 'google_map_active',
				'label'       => __( 'Google Map Active', 'cowork-lite' ),
				'description' => __( 'You Can On/Off Google Map from here', 'cowork-lite' ),
				'section'     => 'homepage_googlemap',
				'default'     => '1',
				'priority'    => 142,
			) );

		// Help
		Kirki::add_field( 'cowork-lite', array(
			'type'        => 'custom',
			'settings'    => 'latlong_help',
			'default'     => '<strong>You Can find your Latitude and Long from here <a target="_blank" href="http://www.latlong.net/">http://www.latlong.net/</a> <br/> <br/> You need to get an Google map Api key in order to use map. You can get one from <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" > here </a> <strong>',
			'section'     => 'homepage_googlemap',
			'priority'    => 143,
		) );
		
		// Lat
			Kirki::add_field( 'cowork-lite', array(
				'type'        => 'text',
				'settings'    => 'map_key',
				'description'    => __( 'You need to get an Google map Api key in order to use map.', 'cowork-lite' ),
				'label'       => __( 'Your Google Map Key', 'cowork-lite' ),
				'section'     => 'homepage_googlemap',
				'priority'    => 144,
				'default' 	  => ''
			) );
					
		// Lat
		Kirki::add_field( 'cowork-lite', array(
			'type'        => 'text',
			'settings'    => 'map_lat',
			'label'       => __( 'Your Latitude', 'cowork-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 145,
			'default' 	  => 27.175015
		) );
		
		// Long
		Kirki::add_field( 'cowork-lite', array(
			'type'        => 'text',
			'settings'    => 'map_long',
			'label'       => __( 'Your Longitude', 'cowork-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 146,
			'default' 	  => 78.042155
		) );
						

		// Long
		Kirki::add_field( 'cowork-lite', array(
			'type'        => 'number',
			'settings'    => 'map_zoom',
			'label'       => __( 'Map Zoom', 'cowork-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 147,
			'default' 	  => 12,
			'choices'     => array(
				'min'  => 0,
				'max'  => 30,
				'step' => 1,
			),
		) );



  	Kirki::add_section( 'social_settings', array(
		'title'          => __( 'Footer Social Setting', 'cowork-lite' ),
		'description'    => __( 'From Here You Can Manage Some Social Setting' , 'cowork-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 43,
		'capability'     => 'edit_theme_options', 
	) );

		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'footerfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'cowork-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 44,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'social_facebook',
				'label'    => __( 'Facebook', 'cowork-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 45,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'footertwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'cowork-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 46,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'social_twitter',
				'label'    => __( 'Twiiter', 'cowork-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 47,
				'default'  => '#',
			) );


		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'footerskypeonoff',
                'label'    => __( 'Skype Active/Inactive', 'cowork-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 48,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'social_skype',
				'label'    => __( 'Skype', 'cowork-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 49,
				'default'  => '#',
			) );

		Kirki::add_field( 'cowork-lite', array(
                'settings' => 'footergoogleonoff',
                'label'    => __( 'Google Active/Inactive', 'cowork-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 50,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'cowork-lite', array(
				'settings' => 'social_google',
				'label'    => __( 'Google', 'cowork-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 51,
				'default'  => '#',
			) );



add_action( 'customize_register', 'navthemes_move_widget_area' );
function navthemes_move_widget_area () {
  global $wp_customize;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section2 = (object) $wp_customize->get_section( 'sidebar-widgets-testimonials_widgets' );
  // general_settings - Panel ID 
  $footer_widgets_section2->panel = 'home_page';
  $footer_widgets_section2->priority = 8;

 
     // sidebar-2 is your sidebar ID
  $footer_widgets_section8 = (object) $wp_customize->get_section( 'sidebar-widgets-team_widget_' );
  // general_settings - Panel ID 
  $footer_widgets_section8->panel = 'home_page';
   $footer_widgets_section8->priority = 4;


// sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-about_widgets' );
  // general_settings - Panel ID 
  $footer_widgets_section6->panel = 'home_page';
}

	
// add if other functions available
if(file_exists('add-on.php')) include('add-on.php');
		
