<?php
/**
 * Template Name:gallerywithsidebar 
 * This file handles the view of the pages if page template is not found.
 */

get_header();
?>

     <section id="home" class="s-home s-blog target-section bg_slider_img" data-aos="fade-up"  data-aos-duration="500">
         <div class="shadow-overlay"></div>
         <div class="home-content">
            <div class="row home-content__main">
               <h1>
                  <?php
                    the_title();
                  ?>
               </h1>
               <p>
                  <?php
                    bloginfo('description');
                  ?>
               </p>
               
            </div>
     
         </div>
      </section>
      <!-- end s-home -->
      
        <section class="blog-area ptb-140 bg-1">
          <div class="container">
              <div class="row">
                 <div class="col-md-8 col-sm-8 col-xs-12 col">
                          <?php while ( have_posts() ) : the_post(); ?>   
                              <?php the_content(); ?>
                          <?php
                            wp_link_pages( array(
                              'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'cowork-lite' ) . '</span>',
                              'after'       => '</div>',
                              'link_before' => '<span>',
                              'link_after'  => '</span>',
                              'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'cowork-lite' ) . ' </span>%',
                              'separator'   => '<span class="screen-reader-text">, </span>',
                            ) );
                          ?>

                         <?php 
                          // If comments are open or we have at least one comment, load up the comment template.
                          if ( comments_open() || get_comments_number() ) :
                            comments_template();
                          endif;
                       
                        endwhile;
                    ?>
                    
              </div>
               <?php get_sidebar(); ?>
            </div>
          </div>
    </section>
  <!-- #End blog Us Area  -->
       
  <div class="clearboth"></div>

<?php get_footer(); ?>



                

  
  