<?php
/**
 * This file is responsible for the rendering of the header of the theme.
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
  <head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>
    <?php
    if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
    wp_head();
    ?>
</head>
   <body <?php body_class(); ?>>
      <!-- header
         ================================================== -->

     <header class="s-header">
         <div class="header-logo">
            <a class="" href="<?php echo home_url(); ?>">
            <?php if(is_home() || is_front_page()) { ?>
            <?php if(get_theme_mod('logo', get_template_directory_uri() . '/assets/images/logo.png')) echo '<img class="logo" src="'. get_theme_mod('logo' , get_template_directory_uri() . '/assets/images/logo.png') .'">'; else  
               bloginfo('name', 'thewest'); ?>
                      <?php }
                         else {
                       ?>
                    <p class="site-title"><?php if(get_theme_mod('logo' , get_template_directory_uri() . '/assets/images/logo.png')) echo '<img class="logo" src="'. get_theme_mod('logo', get_template_directory_uri() . '/assets/images/logo.png') .'">'; else  
              bloginfo('name', 'thewest'); ?></p>
                <?php } ?> 
            </a>
         </div>
         <!-- end header-logo -->
         <nav class="header-nav">
            <a href="#0" class="header-nav__close" title="close"><span>Close</span></a>
            <div class="header-nav__content">
              <?php
                  $layout = maybe_unserialize( get_theme_mod( 'onepage_modules', array('about' , 'benefits' , 'community' ,'pricing' , 'event', 'team','modern_office','testimonials','blog','contact') ) );  
                
                $menu_args = array(
                              'menu' => get_theme_mod('nav_menu_name'),
                              'container' => false,
                              'items_wrap'=> '%3$s',
                              'fallback_cb'    => '__return_false',
                             );

                  $modules = array( 
          
                        'about' =>array(
                          'show' => get_theme_mod('showin_menu_welcome', 1), 
                          'text' => get_theme_mod('welcome_menu_title', 'About'),
                          'link' => '#about'
                        ), 
                        
         
         
                        'pricing' =>array(
                          'show' => get_theme_mod('showin_menu_portfolio', 1), 
                          'text' => get_theme_mod('portfolio_menu_title', 'Pricing'),
                          'link' => '#pricing'
                        ), 
        
                        'team' =>array(
                          'show' => get_theme_mod('showin_menu_team', 1), 
                          'text' => get_theme_mod('team_menu_title', 'Team'),
                          'link' => '#team'
                        ),
             
                        'testimonials' =>array(
                          'show' => get_theme_mod('showin_menu_team', 1), 
                          'text' => get_theme_mod('team_menu_title', 'Testimonials'),
                          'link' => '#testimonials'
                        ),
            
                        'contact' =>array(
                          'show' => get_theme_mod('showin_menu_team', 1), 
                          'text' => get_theme_mod('team_menu_title', 'Contact'),
                          'link' => '#contact'
                        ),
                  );
                ?>
               <ul itemscope itemtype="https://schema.org/SiteNavigationElement" class="header-nav__list">
                <?php  if(get_option('show_on_front')=='posts'): 
 
                          //check menu is empty or not
                          if ( get_theme_mod('nav_menu_name') )
                            {
                               wp_nav_menu( $menu_args );

                            }

                            else{
                             if (current_user_can('update_core')) : echo ( sprintf('<h5 class="menuwarning">Menu Doesn\'t exists, please set a <a href="%s"> menu. </a></h5>', site_url().'/wp-admin/nav-menus.php') ); endif;
                          }

                        
                      else: 
                      // lets show one page menus     

                  if (get_theme_mod('nav_menu_position') == 'before') {
                    if (get_theme_mod('nav_menu_name') != 'none') {
                        
                        wp_nav_menu( $menu_args );
                   
                    
                    }
                  }

                  if ( ! empty( $layout ) ) : 
                ?>
                <?php
                  foreach ($layout as $checked_value) {
                  if( array_key_exists ($checked_value,$modules) ){
                  if ($modules[$checked_value]['show']) {
                ?>
                     <li>
                        <a itemprop="url" class="smoothscroll" href="<?php echo (!is_front_page() ? get_site_url().'/' : '') . $modules[$checked_value]['link']; ?>">
                      <span itemprop="name"><?php echo $modules[$checked_value]['text']; ?></span>
                </a>
              </li>
                <?php
                      }
                    }
                  } 
                ?>
                <?php 
                    endif; // if not empty sorter
                  endif; // if one page switch

                  if (get_theme_mod('nav_menu_position') == 'after') {
                    if (get_theme_mod('nav_menu_name') != 'none') {
                            wp_nav_menu( $menu_args );
                    }
                  }
                ?>
                     </li>

               </ul>
               
            </div>
            <ul class="list-inline">
              <?php if ( true == get_theme_mod( 'navfacebookonoff', true ) ) : ?>
                           <li class="list-inline-item bg_n">
                              <a href="<?php _e(get_theme_mod('nav_social_facebook', __('#' , 'cowork-lite'))); ?>" target="_blank"><i  class="fa fa-facebook"></i></a>
                           </li>
                          <?php endif; ?>

                          <?php if ( true == get_theme_mod( 'navtwitteronoff', true ) ) : ?>
                           <li class="list-inline-item bg_n">
                              <a href="<?php _e(get_theme_mod('nav_social_twitter', __('#' , 'cowork-lite'))); ?>" class="social-icon text-xs-center" target="_blank"><i  class="fa fa-twitter"></i></a>
                           </li>
                           <?php endif; ?>

                           <?php if ( true == get_theme_mod( 'navinstagramonoff', true ) ) : ?>
                           <li class="list-inline-item bg_n">
                              <a href="<?php _e(get_theme_mod('nav_social_instagram', __('#' , 'cowork-lite'))); ?>" class="social-icon text-xs-center" target="_blank"><i  class="fa fa-skype"></i></a>
                           </li>
                           <?php endif; ?>

                           <?php if ( true == get_theme_mod( 'navlinkedinonoff', true ) ) : ?>
                           <li class="list-inline-item bg_n">
                              <a href="<?php _e(get_theme_mod('nav_social_linkedin', __('#' , 'cowork-lite'))); ?>" class="social-icon text-xs-center"><i class="fa fa-google"></i></a>
                           </li>
                           <?php endif; ?>
               </ul>
            <!-- end header-nav__content -->
         </nav>
         <!-- end header-nav -->
         <a class="header-menu-toggle" href="#0">
         <span class="header-menu-icon"></span>
         </a>
      </header>
