<?php
 /*--------------------------------------------------------------------------------
  _   _                   _______   _                                     
 | \ | |                 |__   __| | |                                    
 |  \| |   __ _  __   __    | |    | |__     ___   _ __ ___     ___   ___ 
 |     |  / _  | \ \ / /    | |    | '_ \   / _ \ | '_ ` _ \   / _ \ / __|
 | |\  | | (_| |  \ V /     | |    | | | | |  __/ | | | | | | |  __/ \__ \
 |_| \_|  \__,_|   \_/      |_|    |_| |_|  \___| |_| |_| |_|  \___| |___/
                                                                          
----------------------------------------------------------------------------------*/ 
?>


<?php
/**
 * The main theme functions file loads styles/scripts, allows some theme functionality and provides some helper functions.
 * @version:1.0
 */
/**
 * This theme only works in WordPress 4.2 or later.
 */


if ( version_compare( $GLOBALS['wp_version'], '4.2', '<' ) ) {
    require get_template_directory() . '/inc/back-compat.php';
}

/*----------------------------------------------------------------
    Content Width
 -----------------------------------------------------------------*/

if ( ! isset( $content_width ) ) $content_width = 1140;


/*----------------------------------------------------------------
    Path Function.
 -----------------------------------------------------------------*/

 function getAssetsPath($path) {
     return get_template_directory_uri().$path;
 }

 function image($name) {
     return getAssetsPath('assets/images/'.$name);
 }


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 *
 * Create your own cowork_lite_setup function to override in a child theme.
 *
 * @version cowork 1.0
 */

function cowork_lite_setup(){

    /*------------------------------
         * Register Navigation 
    --------------------------------*/
    //Navigation Menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'cowork-lite')
    ));

    /*---------------------------------------------------
         Theme Supports.
     ----------------------------------------------------*/

    //Add featured image support
    add_theme_support('post-thumbnails');

    //This feature enables plugins and themes to manage the document title tag.
    add_theme_support('title-tag');
    //This feature adds RSS feed links to HTML <head>.
    add_theme_support( 'automatic-feed-links' );
 
    add_theme_support('post-thumbnails');
    
    set_post_thumbnail_size( 700, 500, true ); 
    add_image_size( 'small-thumb', 200, 200);
    add_image_size( 'video-logo', 90, 90, true );
    add_image_size( 'medium-photo', 500, 500, true );
    add_image_size( 'single-photo', 140, 70, true );

    // Load Text Domain
    load_theme_textdomain('cowork-lite');
 }

add_action( 'after_setup_theme', 'cowork_lite_setup' );



/*----------------------------------------------------------------
    Nav menu selection
 -----------------------------------------------------------------*/
    function cowork_lite_nav_menus(){
         $nav_menus = array('none' => __('None', 'cowork-lite'));
         $wp_nav_menu_list = get_terms('nav_menu', array('hide_empty' => true));

        foreach($wp_nav_menu_list as $menuItem) {
            $nav_menus[$menuItem->slug] = $menuItem->name;
        }
        return $nav_menus;
     }



/**
 * Enqueue scripts and styles.
 *
 */
function cowork_lite_scripts() {
	global $wp_styles;
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

    // Loads main stylesheet
    wp_enqueue_style( 'cowork-style', get_stylesheet_uri () );

    // load bootstrap css
    wp_enqueue_style('cowork-bootstrap.css', getAssetsPath('/assets/css/bootstrap.min.css'));

    // bootstrap JS
    wp_enqueue_script( 'cowork-bootstrap-min',  getAssetsPath('/assets/js/bootstrap.min.js'), array( 'jquery' ) );

    // Loads base css.
    wp_enqueue_style( 'cowork-base-style', getAssetsPath('/assets/css/base.css') );
    

    // Loads vendor css.
    wp_enqueue_style( 'cowork-vendor-style', getAssetsPath('/assets/css/vendor.css') );
    

    //Load Font CSS
    wp_enqueue_style('cowork-font-awesome-min', getAssetsPath('/fonts/font-awesome/css/font-awesome.min.css'));


    // modernizr JS
    wp_enqueue_script( 'cowork-modernizr',  getAssetsPath('/assets/js/modernizr.js'));
    
    // vendors JS
    wp_enqueue_script( 'cowork-wow-min',  getAssetsPath('/assets/js/pace.min.js'));

    // google font
    wp_enqueue_style('google-PTSans-font', 'https://fonts.googleapis.com/css?family=PT+Sans:400,400i,700,700i' );

    // plugins JS
    wp_enqueue_script( 'cowork-plugins',  getAssetsPath('/assets/js/plugins.js'), '','', true);


	// lightbox JS
	wp_enqueue_script( 'cowork-lightbox',  getAssetsPath('/assets/js/popup/lightbox.min.js'), '','', true);
    
       // slider JS
    wp_enqueue_script( 'cowork-slider',  getAssetsPath('/assets/js/slider.js'), '','', true);
   
	// main JS
	wp_enqueue_script( 'cowork-main',  getAssetsPath('/assets/js/main.js'), '','', true);

 
       /*----------------------------
           Google Map
        -----------------------------*/
    if (get_theme_mod('google_map_active', 1) ) {
            
            $map_key = get_theme_mod("map_key");
            wp_enqueue_script( 'cowork-google-js',  'https://maps.googleapis.com/maps/api/js?key='.$map_key.'&v=3.exp');

        }   
	}
	
	add_action( 'wp_enqueue_scripts', 'cowork_lite_scripts' );


 /*----------------------------
   Excerpt Word Length
    -----------------------------*/

 if(!function_exists( 'cowork_lite_custom_excerpt_length' )) {

    //Customize excerpt word count
    function cowork_lite_custom_excerpt_length() {
        return 25; //25 words
    }
    
    add_filter('excerpt_length', 'cowork_lite_custom_excerpt_length');
}

/*----------------------------
   Add our Widget Locations
    -----------------------------*/

    function cowork_lite_widgets() {
        register_sidebar( array(
            'name' => __( 'Sidebar', 'cowork-lite' ),
            'id' => 'sidebar-1',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'cowork-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widgettitle">',
            'after_title'   => '</h3>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 1', 'cowork-lite' ),
            'id' => 'sidebar-2',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'cowork-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widgettitle">',
            'after_title'   => '</h3>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer 2', 'cowork-lite' ),
            'id' => 'sidebar-3',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'cowork-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widgettitle">',
            'after_title'   => '</h3>',
            ) );
        register_sidebar( array(
            'name' => __( 'Home Page Testimonials', 'cowork-lite' ),
            'id' => 'testimonials_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'cowork-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );


        register_sidebar( array(
            'name' => __( 'Team Widget', 'cowork-lite' ),
            'id' => 'team_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'cowork-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
       

        }

add_action('widgets_init', 'cowork_lite_widgets');


/*
    Nav Functions   
*/

    
/*----------------------------
    Including NavThemes Functions File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/navthemes-functions.php')) :
    include_once(dirname( __FILE__ ) . '/navthemes-functions.php');
 endif;   

    
/*----------------------------
    Including NavThemes Functions File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/theme-options.php')) :
    include_once(dirname( __FILE__ ) . '/theme-options.php');
 endif;   



    /*----------------------------
    Adds customizer css
    -----------------------------*/
if(!function_exists('navthemes_customizer_css')) {

    function navthemes_customizer_css() {
     // Loads our main stylesheet.
        wp_enqueue_style( 'customizer-css', get_template_directory_uri().'/customizer.css' );
    }
    
    add_action( 'customize_controls_print_styles', 'navthemes_customizer_css');

}

