<?php
/**
 * This file is responsible for the display of front page.
 * @version:1.0
 */
get_header(); 

?>

      <section id="home" class="s-home target-section bg_slider_img" data-aos="fade-up"  data-aos-duration="500" style="background: url(<?php echo esc_attr(get_theme_mod('inner_page_bg_image',  get_template_directory_uri() . '/assets/images/slider_bg.jpg')); ?>)">
         <div class="shadow-overlay"></div>
         <div class="home-content">
            <div class="row home-content__main">
               <h1>
                <?php echo(get_theme_mod('home_welcome_title', __('Co-Work Custom Office, Finland','cowork-lite'))); ?>
               </h1>
               <p>
                  <?php echo(get_theme_mod('home_welcome_title_text', __('Located in Jaipur Center, This Custom Designed Office by Skootr,<br> 
                was Developed Exclusively for Mattsenkumar.<br>

                Call us +91-955 510 0999','cowork-lite'))); ?>
                 
               </p>
               
               <div class="btn">
                  <a href="<?php echo(get_theme_mod('home_welcome_title_buttonlink', __('#','cowork-lite'))); ?>" class="btn--primary smoothscroll"  ><?php echo(get_theme_mod('home_welcome_title_button', __('Contact','cowork-lite'))); ?></a>
               </div>
            </div>
            <!-- end home-content__main -->
         </div>
          <!-- end home-content -->
         <a href="#about" class="home-scroll smoothscroll">
         <span class="home-scroll__icon"></span>
         </a> <!-- end home-scroll -->
     
      </section>
      <!-- end s-home -->

    
      <?php

// Early exit if Kirki is not installed
         if ( ! class_exists( 'Kirki' ) ) {
            printf( __( '<h5 class="kirki-nf">
              Please install recommended theme <a href="%s">plugins</a> to begin customizations. For instructions, click <a href="%s">here</a>.</h5>', 'cowork-lite' ), 
                esc_url( admin_url( 'plugins.php' ) ), 'https://docs.navthemes.com/docs/cowork-lite/'
            );

             get_footer();
           return;
         }

        
         $layout = maybe_unserialize( get_theme_mod( 'homepage_modules', 
                        array( 
                            'about', 
                            'pricing', 
                            'team',
                            'testimonials' , 
                            'contact'
                          ) ) ); 

         if (!empty($layout)) {
             foreach ($layout as $module => $val) {
                 get_template_part('templates/modules/module', $val);
             }
         }
         ?>

 <script type="text/javascript">
    
    $ = jQuery;

 </script>

<?php
get_footer();
?>
