(function ($, Drupal) {
  Drupal.behaviors.mtWaypointsFixedHeader = {
    attach: function (context, settings) {
      $(context).find(".header-container .header").once('mtWaypointsFixedHeaderInit').each(function(index, item) {
        var sticky = new Waypoint.Sticky ({
          element: $('.header-container .header')[0],
          stuckClass: 'js-fixed',
          handler: function(direction) {
            if (Waypoint.viewportWidth() > 752) {
              $('body', context).toggleClass('onscroll');
            } else {
              $('body', context).removeClass('onscroll');
            }
            var topValue = $('body').css('padding-top');
            $(".header.js-fixed").css("top", topValue);
          },
          offset: function() {
            var offsetValue = parseInt($('body').css('padding-top')) - 1;
            return offsetValue;
          }
        });
      });
    }
  };
})(jQuery, Drupal);
