<?php


$strings = array();

$strings['theme'] = array(
	'general' => array(
		'layoutType' => __("Display full-width or fixed-width layout of website", 'ait-admin'),
		'websiteWidth' => __("Width of the website layout", 'ait-admin'),
		'leftSidebarWidth' => __("Width of left sidebar", 'ait-admin'),
		'rightSidebarWidth' => __("Width of right sidebar", 'ait-admin'),
		'sidebarGap' => '',
		'progressivePageLoading' => __("Enable or disable progressive loading of page", 'ait-admin'),
		'favicon' => __("Select image used as Favicon", 'ait-admin'),
		'mainbg' => __("Look of section background. Color, opacity and background image.", 'ait-admin'),
		'themeColor' => __("Main theme color", 'ait-admin'),
		'pageBgColor' => __("Color and opacity of page background", 'ait-admin'),
		'titColor' => __("Color of titles text", 'ait-admin'),
		'txtColor' => __("Color of main text", 'ait-admin'),
		'lnkColor' => __("Color of links", 'ait-admin'),
		'hvrColor' => __("Color of links with mouse cursor over", 'ait-admin'),
		'decColor' => __("Decorative color of elements on website", 'ait-admin'),
		'linesColor' => __("Color of lines", 'ait-admin'),
		'lightObj' => __("Color and opacity to make objects lighter", 'ait-admin'),
		'darkObj' => __("Color and opacity to make objects darker", 'ait-admin'),
	),
	'header' => array(
		'headerType' => __("Select type of website header", 'ait-admin'),
		'logo' => __("Logo image for website header", 'ait-admin'),
		'headbg' => __("Look of section background. Color, opacity and background image.", 'ait-admin'),
		'stickyMenu' => __("Enable or disable sticky menu on website", 'ait-admin'),
		'menubg' => __("Background color and opacity of main menu", 'ait-admin'),
		'menuColor' => __("Color of menu items text", 'ait-admin'),
		'menuColorAct' => __("Color of active menu item text", 'ait-admin'),
		'customJsCode' => __("Place for your custom Javascript codes", 'ait-admin'),
	),
	'footer' => array(
		'footerbg' => __("Look of section background. Color, opacity and background image.", 'ait-admin'),
		'titFwColor' => __("Color of widget titles", 'ait-admin'),
		'txtFwColor' => __("Color of plain text", 'ait-admin'),
		'lnkFwColor' => __("Color of links", 'ait-admin'),
		'decFwColor' => __("Decorative color of some elements and links with mouse cursor over", 'ait-admin'),
		'FtText' => __("Percentage width of area", 'ait-admin'),
		'FtMenu' => __("Percentage width of area", 'ait-admin'),
		'bgColor' => __("Background color and opacity of footer bar", 'ait-admin'),
		'txtColor' => __("Color of plain text", 'ait-admin'),
		'lnkColor' => __("Color of links", 'ait-admin'),
		'hvrColor' => __("Color of links with mouse cursor over", 'ait-admin'),
		'text' => __("Text displayed in footer bar text area", 'ait-admin'),
		'customJsCode' => __("Place for your custom Javascript codes", 'ait-admin'),
	),
	'typography' => array(
		'mainFont' => '',
	),
	'breadcrumbs' => array(
		'separator' => __("Separator used between links in breadcrumbs", 'ait-admin'),
		'before' => __("Text displayed before breadcrumbs", 'ait-admin'),
		'showHome' => __("Text for home link in breadcrumbs", 'ait-admin'),
		'network' => __("Display current website title in breadcrumbs. Have not any effect on standard Wordpress installation, only on Wordpress Multisite installation.", 'ait-admin'),
	),
	'@widgetAreasAndSidebars' => array(
		'@sidebar' => array(
			'items' => array(
				'name' => __("Name of widget area displayed in Widgets options", 'ait-admin'),
			),
			'help' => '',
		),
		'footer' => array(
			'items' => array(
				'name' => __("Name of widget area displayed in Widgets options", 'ait-admin'),
				'width' => __("Percentage width of area", 'ait-admin'),
			),
			'help' => '',
		),
	),
	'google' => array(
		'analyticsTrackingId' => __("Google Analytics Tracking ID in form UA-XXXXX-YY", 'ait-admin'),
	),
	'social' => array(
		'enableSocialIcons' => __("Display social icons on website", 'ait-admin'),
		'socbg' => __("Background color and opacity of icons", 'ait-admin'),
		'socIconsNewWindow' => __("Open links in new window or tab", 'ait-admin'),
		'socIcons' => array(
			'items' => array(
				'title' => __("Social icon title", 'ait-admin'),
				'icon' => __("Social icon image", 'ait-admin'),
				'iconDark' => __("Social icon image", 'ait-admin'),
				'url' => __("Social icon link, use valid URL format with http://", 'ait-admin'),
			),
			'help' => __("Add new Social Icon by click on \"+ Add New Item\" link, or remove existing Social Icon by clicking on red cross. Click on \"Remove All Items\" link to remove all existing Social Icons.", 'ait-admin'),
		),
	),
);



$strings['layout'] = array(
	'custom' => array(
		'pageHtmlClass' => __("Write your custom class for own page identification", 'ait-admin'),
	),
	'@sidebars' => array(
		'right' => __("Select sidebar displayed on the right side of page", 'ait-admin'),
		'left' => __("Select sidebar displayed on the left side of page", 'ait-admin'),
	),
	'general' => array(
		'enableWidgetAreas' => __("Display footer widgets area", 'ait-admin'),
		'showBreadcrumbs' => __("Display breadcrumbs", 'ait-admin'),
	),
);



$strings['elements'] = array(
	'page-title' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'title' => '',
		'description' => __("Description text displayed with page title", 'ait-admin'),
	),
	'revolution-slider' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'alias' => __("Select slider displayed on page", 'ait-admin'),
		'alternative' => __("Image displayed in responsive layout instead of slider", 'ait-admin'),
		'responsive' => __("Breakpoint when alternative image is displayed", 'ait-admin'),
	),
	'content' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'content' => '',
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
	),
	'comments' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'discussion' => __("Allow users to comment this page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
	),
	'portfolio' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'count' => __("Number of visible items", 'ait-admin'),
		'columns' => __("Number of items in one row", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'showFilter' => __("Display Portfolio filter", 'ait-admin'),
		'subcategoryItems' => __("Display items from subcategories when filtering", 'ait-admin'),
		'display' => __("Select how to show the content of Portfolio item", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'imageDescription' => __("Display Portfolio item description", 'ait-admin'),
		'imageHeight' => __("Height of Portfolio images. For automatic height enter auto or 0.", 'ait-admin'),
		'imageOffset' => __("Offset of Portfolio images", 'ait-admin'),
	),
	'testimonials' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'addInfo' => __("Enable or disable post information", 'ait-admin'),
		'boxColumns' => __("Number of items in one row", 'ait-admin'),
		'boxAlign' => __("Select alignment of title and description", 'ait-admin'),
		'boxEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'boxEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'boxEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'boxRows' => __("Number of rows in carousel", 'ait-admin'),
		'listColumns' => __("Number of items in one row", 'ait-admin'),
		'listEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'listEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'listEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'listRows' => __("Number of rows in carousel", 'ait-admin'),
	),
	'text' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'text' => '',
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
	),
	'columns' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'columns' => '',
	),
	'partners' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'logoSpace' => __("Offset of partner's logo", 'ait-admin'),
	),
	'facebook' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'type' => __("Select type of Facebook box", 'ait-admin'),
		'href' => __("URL of Facebook page displayed in box, use valid URL format with http://", 'ait-admin'),
		'width' => __("Width of Facebook box", 'ait-admin'),
		'height' => __("Height of Facebook box", 'ait-admin'),
		'smallHeader' => __("Use the small header instead", 'ait-admin'),
		'adaptContainerWidth' => __("Try to fit inside the container width", 'ait-admin'),
		'hideCover' => __("Hide cover photo in the header", 'ait-admin'),
		'showFacepile' => __("Show profile photos when friends like this", 'ait-admin'),
		'showPosts' => __("Show posts from the Page's timeline.", 'ait-admin'),
		'hideCta' => __("Hide the custom call to action button (if available)", 'ait-admin'),
		'posts' => __("Count of visible posts in Facebook box", 'ait-admin'),
		'borderColor' => __("Color of Border", 'ait-admin'),
		'borderWidth' => __("Width of border when Border Color is defined", 'ait-admin'),
	),
	'faq' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'count' => __("Number of visible items", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'showCategoryData' => __("Display category information on page", 'ait-admin'),
	),
	'google-map' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'type' => __("Select type of Google Map", 'ait-admin'),
		'contentSize' => __("Select size of Google Map", 'ait-admin'),
		'height' => __("Height of Google Map", 'ait-admin'),
		'markers' => array(
			'items' => array(
				'title' => __("Title displayed in infowindow", 'ait-admin'),
				'url' => __("URL of link displayed in infowindow, use valid URL format with http://", 'ait-admin'),
				'description' => __("Description displayed in infowindow", 'ait-admin'),
				'icon' => __("Marker image URL", 'ait-admin'),
				'address' => __("Address for marker position", 'ait-admin'),
			),
			'help' => __("Add new Marker by click on \"+ Add New Item\" link, or remove existing Marker by clicking on red cross. Click on \"Remove All Items\" link to remove all existing Markers.", 'ait-admin'),
		),
		'address' => __("Address of default position shown on Google Map", 'ait-admin'),
		'zoom' => __("Zoom level of Google Map", 'ait-admin'),
		'borderColor' => __("Border color of Google Map", 'ait-admin'),
		'mapHue' => __("Hue color of Google Map", 'ait-admin'),
		'mapSaturation' => __("Saturation level of Google Map", 'ait-admin'),
		'mapBrightness' => __("Brightness level of Google Map", 'ait-admin'),
		'objSaturation' => __("Saturation level of Google Map objects", 'ait-admin'),
		'objBrightness' => __("Brightness level of Google Map objects", 'ait-admin'),
		'landscapeColor' => __("Hue color of Google Map landscape", 'ait-admin'),
		'administrativeColor' => __("Hue color of Google Map administrative areas", 'ait-admin'),
		'roadsColor' => __("Hue color of Google Map roads", 'ait-admin'),
		'waterColor' => __("Hue color of Google Map water", 'ait-admin'),
		'poiColor' => __("Hue color of Google Map Points Of Interest", 'ait-admin'),
		'mousewheelZoom' => '',
	),
	'member' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'member' => __("Select member displayed on page", 'ait-admin'),
		'imageHeight' => __("Select format for image of member", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'hideRows' => __("Collapsible hidden exceeded rows", 'ait-admin'),
		'linksInNewWindow' => '',
	),
	'price-table' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'standard' => __("Decoration color of standard items", 'ait-admin'),
		'featured' => __("Decoration color of featured items", 'ait-admin'),
	),
	'twitter' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'username' => __("Twitter username (account)", 'ait-admin'),
		'posts' => __("Count of displayed posts", 'ait-admin'),
		'consumerKey' => __("Twitter API Consumer key", 'ait-admin'),
		'consumerSecret' => __("Twitter API Consumer secret", 'ait-admin'),
		'accessToken' => __("Twitter API Access token", 'ait-admin'),
		'accessTokenSecret' => __("Twitter API Access token secret", 'ait-admin'),
		'dateFormat' => __("Format of posts dates", 'ait-admin'),
		'escapeSpecialChars' => __("Escaping special characters used in posts", 'ait-admin'),
		'linksClickable' => __("Possibility click on posts links", 'ait-admin'),
		'displayDate' => __("Display posts dates", 'ait-admin'),
	),
	'video' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'type' => __("Select video source", 'ait-admin'),
		'link' => __("URL of video displayed on page, use valid URL format with http:// and use long URL in case of YouTube video", 'ait-admin'),
		'width' => __("Width of player", 'ait-admin'),
		'height' => __("Height of player", 'ait-admin'),
		'borderColor' => __("Color of border around video", 'ait-admin'),
	),
	'toggles' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'type' => __("Select type of toggles", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
	),
	'soundcloud' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'url' => __("URL of song used in player, use valid URL format with http://", 'ait-admin'),
		'size' => __("Select size of player", 'ait-admin'),
		'showArtwork' => __("Display artwork in player", 'ait-admin'),
		'autoplay' => __("Use autoplay on page load", 'ait-admin'),
		'color' => __("Decorative color of player", 'ait-admin'),
	),
	'mixcloud' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'url' => __("URL of song used in player, use valid URL format with http://", 'ait-admin'),
		'height' => __("Height of player", 'ait-admin'),
		'showArtwork' => __("Display artwork in player", 'ait-admin'),
		'color' => __("Decorative color of player", 'ait-admin'),
		'borderColor' => __("Color of border around player", 'ait-admin'),
	),
	'counters' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'chartType' => __("Select type of counter", 'ait-admin'),
		'counterDimension' => __("Dimension of counters", 'ait-admin'),
		'counterThickness' => __("Thickness of counters", 'ait-admin'),
		'counters' => array(
			'items' => array(
				'current' => __("Value displayed by counter (number from 0 to 100 for type Gauge and Line)", 'ait-admin'),
				'title' => __("Text displayed as label of counter", 'ait-admin'),
				'description' => __("Text displayed as description with counter", 'ait-admin'),
			),
			'help' => __("Add new Counter by click on \"+ Add New Item\" link, or remove existing Counter by clicking on red cross. Click on \"Remove All Items\" link to remove all existing Counters.", 'ait-admin'),
		),
		'counterBottomColor' => __("Main color of counters", 'ait-admin'),
		'counterBaseColor' => __("Color displaying current value", 'ait-admin'),
	),
	'countdown' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'countdownSize' => __("Diameter of countdown circles", 'ait-admin'),
		'lineWidth' => __("Width of countdown circles", 'ait-admin'),
		'startDate' => __("Starting date for countdown", 'ait-admin'),
		'endDate' => __("Ending date for countdown", 'ait-admin'),
		'finishedText' => __("Text displayed after end date", 'ait-admin'),
		'countdownRound' => __("Main color of countdown circles", 'ait-admin'),
		'countdownColor' => __("Color displaying current value", 'ait-admin'),
	),
	'rule' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'type' => __("Select type of rule", 'ait-admin'),
		'size' => __("Select size of rule", 'ait-admin'),
		'showTop' => __("Display button on rule to slide up", 'ait-admin'),
		'ruleColor' => __("Color of rule", 'ait-admin'),
		'elmTopPad' => __("Space above rule", 'ait-admin'),
		'elmBotPad' => __("Space below rule", 'ait-admin'),
	),
	'events' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'addInfo' => __("Enable or disable post information", 'ait-admin'),
		'boxColumns' => __("Number of items in one row", 'ait-admin'),
		'boxAlign' => __("Select alignment of title and description", 'ait-admin'),
		'boxEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'boxEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'boxEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'boxRows' => __("Number of rows in carousel", 'ait-admin'),
		'boxImageHeight' => __("Select format for images in carousel", 'ait-admin'),
		'listColumns' => __("Number of items in one row", 'ait-admin'),
		'listEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'listEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'listEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'listRows' => __("Number of rows in carousel", 'ait-admin'),
		'listImageHeight' => __("Select format for images in carousel", 'ait-admin'),
	),
	'job-offers' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'addInfo' => __("Enable or disable post information", 'ait-admin'),
		'boxColumns' => __("Number of items in one row", 'ait-admin'),
		'boxAlign' => __("Select alignment of title and description", 'ait-admin'),
		'boxEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'boxEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'boxEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'boxRows' => __("Number of rows in carousel", 'ait-admin'),
		'listColumns' => __("Number of items in one row", 'ait-admin'),
		'listEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'listEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'listEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'listRows' => __("Number of rows in carousel", 'ait-admin'),
	),
	'opening-hours' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'monday' => '',
		'tuesday' => '',
		'wednesday' => '',
		'thursday' => '',
		'friday' => '',
		'saturday' => '',
		'sunday' => '',
		'showFreeDay' => __("Display or hide empty days in table", 'ait-admin'),
		'note' => __("Text visible as note below table", 'ait-admin'),
	),
	'contact-form' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'address' => __("Email address of recipient", 'ait-admin'),
		'sender' => __("Email address of sender. Some hostings accept only something@yourdomain.com. Contact your provider for more information.", 'ait-admin'),
		'subject' => __("Subject of received email", 'ait-admin'),
		'content' => __("Content of received email. Use Name attribute to get value of input, example: {name}", 'ait-admin'),
		'msgsuccess' => __("Message displayed when form is sent successfully", 'ait-admin'),
		'msgerror' => __("Message displayed when form sending failed", 'ait-admin'),
		'msgwarning' => __("Message displayed when validation is not successful", 'ait-admin'),
		'captchaInclude' => __("Use Captcha feature", 'ait-admin'),
		'captchaLabel' => __("Label for Captcha input", 'ait-admin'),
		'captchaText' => __("Text displayed beside Captcha input", 'ait-admin'),
		'resetButtonDisplay' => __("Display reset button in form", 'ait-admin'),
		'escapeFormInputs' => __("Turn on/off characters escaping of form inputs", 'ait-admin'),
		'inputs' => array(
			'items' => array(
				'label' => __("Text displayed as label for input. To hide label leave this input empty.", 'ait-admin'),
				'name' => __("Name of input, used for email content", 'ait-admin'),
				'type' => __("Select type of input", 'ait-admin'),
				'value' => __("Text displayed in input for text input types. For types with more values use semi-colon delimiter. Example: select value 1;select value 2;select value 3", 'ait-admin'),
				'placeholder' => __("Text displayed as placeholder while input is empty", 'ait-admin'),
				'size' => __("Select size of input", 'ait-admin'),
				'required' => __("Select if the field is required", 'ait-admin'),
			),
			'help' => '',
		),
		'labelWidth' => __("Custom width of form labels", 'ait-admin'),
	),
	'sitemap' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'type' => __("Select type of items", 'ait-admin'),
		'number' => __("Count of items listed on page. Enter 0 for all items.", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'pagesOrderby' => __("Select order of items listed on page", 'ait-admin'),
		'depth' => __("Depth of listed items", 'ait-admin'),
		'postsOrderby' => __("Select order of items listed on page", 'ait-admin'),
		'comments-count' => __("Display or hide count of comments", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'author' => __("ID number of author, or multiple IDs delimited by comma", 'ait-admin'),
	),
	'advertising-spaces' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'linkTarget' => __("Open links in new window or tab", 'ait-admin'),
		'animationTime' => __("Time visibility of advertisement in seconds", 'ait-admin'),
		'borderColor' => __("Color of border around advertisement", 'ait-admin'),
		'textBgColor' => __("Background color of advertisement", 'ait-admin'),
	),
	'seo' => array(
		'@display' => __("Include SEO meta data into header", 'ait-admin'),
		'title' => __("Write title for page", 'ait-admin'),
		'keywords' => __("Write keywords for page", 'ait-admin'),
		'description' => __("Write description for page", 'ait-admin'),
	),
	'posts' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'addInfo' => __("Enable or disable post information", 'ait-admin'),
		'boxColumns' => __("Number of items in one row", 'ait-admin'),
		'boxAlign' => __("Select alignment of title and description", 'ait-admin'),
		'boxEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'boxEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'boxEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'boxRows' => __("Number of rows in carousel", 'ait-admin'),
		'boxImageHeight' => __("Select format for images in carousel", 'ait-admin'),
		'listColumns' => __("Number of items in one row", 'ait-admin'),
		'listEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'listEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'listEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'listRows' => __("Number of rows in carousel", 'ait-admin'),
		'listImageHeight' => __("Select format for images in carousel", 'ait-admin'),
	),
	'members' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'linksInNewWindow' => '',
		'boxColumns' => __("Number of items in one row", 'ait-admin'),
		'boxAlign' => __("Select alignment of title and description", 'ait-admin'),
		'boxEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'boxEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'boxEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'boxRows' => __("Number of rows in carousel", 'ait-admin'),
		'boxImageHeight' => __("Select format for images in carousel", 'ait-admin'),
		'listColumns' => __("Number of items in one row", 'ait-admin'),
		'listEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'listEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'listEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'listRows' => __("Number of rows in carousel", 'ait-admin'),
		'listImageHeight' => __("Select format for images in carousel", 'ait-admin'),
	),
	'services' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
		'layout' => __("Select layout type of displayed items", 'ait-admin'),
		'textRows' => __("Number of rows for description text", 'ait-admin'),
		'addInfo' => __("Enable or disable post information", 'ait-admin'),
		'boxColumns' => __("Number of items in one row", 'ait-admin'),
		'boxAlign' => __("Select alignment of title and description", 'ait-admin'),
		'boxEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'boxEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'boxEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'boxRows' => __("Number of rows in carousel", 'ait-admin'),
		'boxImageHeight' => __("Select format for images in carousel", 'ait-admin'),
		'listColumns' => __("Number of items in one row", 'ait-admin'),
		'listEnableCarousel' => __("Enable or disable carousel feature", 'ait-admin'),
		'listEnableAutoplay' => __("Enable or disable carousel autoplay feature", 'ait-admin'),
		'listEnableFading' => __("Enable or disable carousel fading feature", 'ait-admin'),
		'listRows' => __("Number of rows in carousel", 'ait-admin'),
		'listImageHeight' => __("Select format for images in carousel", 'ait-admin'),
	),
	'easy-slider' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'sliderMode' => __("Select type of slider animation", 'ait-admin'),
		'sliderAutoplay' => __("Enable or disable the autoplay feature", 'ait-admin'),
		'contentSize' => __("Select size of slider", 'ait-admin'),
		'imageFormat' => __("Select format of images", 'ait-admin'),
		'pagerType' => __("Select type of slider navigation", 'ait-admin'),
		'descriptionAnimation' => __("Select type of animation for description", 'ait-admin'),
		'linkTarget' => __("Open links in new window or tab", 'ait-admin'),
		'slides' => array(
			'items' => array(
				'link' => __("URL of link for image in slide, use valid URL format with http://", 'ait-admin'),
				'image' => __("URL of image displayed in slide, use valid URL format with http://", 'ait-admin'),
				'title' => __("Title displayed in description box", 'ait-admin'),
				'description' => __("Text displayed in description box", 'ait-admin'),
				'button' => __("Text for button displayed in description box", 'ait-admin'),
				'descriptionAlign' => __("Select text alignment in description box", 'ait-admin'),
				'descriptionPosition' => __("Select position of description box", 'ait-admin'),
				'descWidth' => __("Width of description box", 'ait-admin'),
			),
			'help' => '',
		),
		'borderColor' => __("Color of border around slider", 'ait-admin'),
		'sliderAutoplayPause' => __("The amount of time (in sec) between each auto transition", 'ait-admin'),
		'pagerPosition' => __("Select position of slider navigation", 'ait-admin'),
		'thumbBorderColor' => __("Color of border around the thumbnails", 'ait-admin'),
		'descWidthAll' => __("Width of description box for all slides", 'ait-admin'),
		'descVoffset' => __("Top and bottom offset of description boxes", 'ait-admin'),
		'descHoffset' => __("Right and left offset of description boxes", 'ait-admin'),
		'descBackground' => __("Background of description boxes", 'ait-admin'),
		'descTitleColor' => __("Color of title in description boxes", 'ait-admin'),
		'descTitleSize' => __("Font size of title in description boxes", 'ait-admin'),
		'descTextColor' => __("Color of text in description boxes", 'ait-admin'),
		'descButtonColor' => __("Color of button in description boxes", 'ait-admin'),
		'descButtonTextColor' => __("Color of text on button in description boxes", 'ait-admin'),
		'descButtonOpacity' => __("Opacity of button in description boxes", 'ait-admin'),
	),
	'products' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'category' => __("Select category displayed on page", 'ait-admin'),
		'orderby' => __("Select order of items listed on page", 'ait-admin'),
		'order' => __("Select order of items listed on page", 'ait-admin'),
		'count' => __("Number of items listed on page", 'ait-admin'),
	),
	'image' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'image' => __("Image to display", 'ait-admin'),
		'width' => __("Width of image", 'ait-admin'),
		'imgLayout' => __("Layout of the image displayed on the page", 'ait-admin'),
		'border' => __("Display or hide borders", 'ait-admin'),
		'altTitle' => __("Title of the image displayed as ALT text", 'ait-admin'),
		'captionTitle' => __("Display Title of the image in caption", 'ait-admin'),
		'caption' => __("Image description displayed as caption", 'ait-admin'),
		'linkTo' => __("Where to link the image?", 'ait-admin'),
		'link' => __("URL of link on the image, use valid URL format with http://", 'ait-admin'),
		'linkTarget' => __("Target of the link", 'ait-admin'),
		'useLabel' => __("Set custom label on the image", 'ait-admin'),
		'labelSize' => __("Size of the label", 'ait-admin'),
		'labelIcon' => __("Class for FontAwesome icon", 'ait-admin'),
		'labelTitle' => __("Title of label", 'ait-admin'),
		'labelDesc' => __("Description of label", 'ait-admin'),
		'labelPos' => __("Zero point for X and Y coordinates of label position", 'ait-admin'),
		'labelPosX' => __("+ / - coordinate on X axis", 'ait-admin'),
		'labelPosY' => __("+ / - coordinate on Y axis", 'ait-admin'),
		'labelUrl' => __("URL of link on the label, use valid URL format with http://", 'ait-admin'),
		'labelTarget' => __("Target of the link", 'ait-admin'),
		'borderColor' => __("Color of border around image", 'ait-admin'),
		'leftOffset' => __("Left offset around the image", 'ait-admin'),
		'rightOffset' => __("Right offset around the image", 'ait-admin'),
		'captionPos' => __("Position of the image caption", 'ait-admin'),
		'captionSize' => __("Width of the Caption", 'ait-admin'),
		'captionTop' => __("Top margin of caption placed outside", 'ait-admin'),
		'captionBox' => __("Backgroud Color of caption", 'ait-admin'),
		'captionTxt' => __("Color of texts in caption", 'ait-admin'),
		'labelBck' => __("Backgroud Color of label", 'ait-admin'),
		'labelTxt' => __("Color of texts in label", 'ait-admin'),
	),
	'lists' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'layout' => __("Select layout style", 'ait-admin'),
		'line' => __("Show or hide lines between items", 'ait-admin'),
		'style' => __("Select icon style", 'ait-admin'),
		'iconColor' => __("Custom color of icon bullets", 'ait-admin'),
		'typo' => __("Select typography style", 'ait-admin'),
		'lists' => array(
			'items' => array(
			),
			'help' => __("Add new List item by click on \"+ Add New Item\" link, or remove existing List item by clicking on red cross. Click on \"Remove All Items\" link to remove all existing List items.", 'ait-admin'),
		),
	),
	'promotion' => array(
		'@display' => __("Display or hide this element on page", 'ait-admin'),
		'customClass' => __("Write your custom class for own element identification", 'ait-admin'),
		'title' => __("Title text displayed with element", 'ait-admin'),
		'description' => __("Description text displayed with element", 'ait-admin'),
		'headAlign' => __("Select alignment of title and description", 'ait-admin'),
		'@bg' => __("Look of element background. Color, opacity and background image.", 'ait-admin'),
		'margin-top' => __("Space above element", 'ait-admin'),
		'padding-top' => __("Top space inside element", 'ait-admin'),
		'padding-bottom' => __("Bottom space inside element", 'ait-admin'),
		'margin-bottom' => __("Space below element", 'ait-admin'),
		'text' => '',
		'textContainerWidth' => '',
		'textContainerPosition' => '',
		'image' => '',
	),
);



return $strings;
